package cmd

import (
	"github.com/gsamokovarov/jump/cli"
)

func Example_shellCmd_Bash() {
	_ = shellCmd(cli.Args{"bash"}, nil)

	// Output:
	// # Put the line below in ~/.bashrc or ~/bash_profile:
	// #
	// #   eval "$(jump shell bash)"
	// #
	// # The following lines are autogenerated:
	//
	// __jump_prompt_command() {
	//   local status=$?
	//   jump chdir && return $status
	// }
	//
	// __jump_hint() {
	//   local term="${COMP_LINE/#j /}"
	//   echo \'$(jump hint "$term")\'
	// }
	//
	// j() {
	//   local dir="$(jump cd "$@")"
	//   test -d "$dir"  && cd "$dir"
	// }
	//
	// [[ "$PROMPT_COMMAND" =~ __jump_prompt_command ]] || {
	//   PROMPT_COMMAND="__jump_prompt_command;$PROMPT_COMMAND"
	// }
	//
	// complete -o dirnames -C '__jump_hint' j
}

func Example_shellCmd_Zsh() {
	_ = shellCmd(cli.Args{"zsh"}, nil)

	// Output:
	// # Put the line below in ~/.zshrc:
	// #
	// #   eval "$(jump shell zsh)"
	// #
	// # The following lines are autogenerated:
	//
	// __jump_chpwd() {
	//   jump chdir
	// }
	//
	// jump_completion() {
	//   reply="'$(jump hint "$@")'"
	// }
	//
	// j() {
	//   local dir="$(jump cd $@)"
	//   test -d "$dir" && cd "$dir"
	// }
	//
	// typeset -gaU chpwd_functions
	// chpwd_functions+=__jump_chpwd
	//
	// compctl -U -K jump_completion j
}

func Example_shellCmd_Fish() {
	_ = shellCmd(cli.Args{"fish"}, nil)

	// Output:
	// # Put the line below in ~/.config/fish/config.fish:
	// #
	// #   jump shell fish | source
	// #
	// # The following lines are autogenerated:
	//
	// function __jump_add --on-variable PWD
	//   status --is-command-substitution; and return
	//   jump chdir
	// end
	//
	// function __jump_hint
	//   set -l term (string replace -r '^j ' '' -- (commandline -cp))
	//   jump hint "$term"
	// end
	//
	// function j
	//   set -l dir (jump cd "$argv")
	//   test -d "$dir"; and cd "$dir"
	// end
	//
	// complete --command j --exclusive --arguments '(__jump_hint)'
}

func Example_shellCmd_Bind() {
	_ = shellCmd(cli.Args{"bash", "--bind=z"}, nil)

	// Output:
	// # Put the line below in ~/.bashrc or ~/bash_profile:
	// #
	// #   eval "$(jump shell bash)"
	// #
	// # The following lines are autogenerated:
	//
	// __jump_prompt_command() {
	//   local status=$?
	//   jump chdir && return $status
	// }
	//
	// __jump_hint() {
	//   local term="${COMP_LINE/#z /}"
	//   echo \'$(jump hint "$term")\'
	// }
	//
	// z() {
	//   local dir="$(jump cd "$@")"
	//   test -d "$dir"  && cd "$dir"
	// }
	//
	// [[ "$PROMPT_COMMAND" =~ __jump_prompt_command ]] || {
	//   PROMPT_COMMAND="__jump_prompt_command;$PROMPT_COMMAND"
	// }
	//
	// complete -o dirnames -C '__jump_hint' z
}
