{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='ephemeralContainer', url='', help='"An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.\\n\\nTo add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted."'),
  '#lifecycle':: d.obj(help='"Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted."'),
  lifecycle: {
    '#postStart':: d.obj(help='"LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified."'),
    postStart: {
      '#exec':: d.obj(help='"ExecAction describes a \\"run in container\\" action."'),
      exec: {
        '#withCommand':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"", args=[d.arg(name='command', type=d.T.array)]),
        withCommand(command): { lifecycle+: { postStart+: { exec+: { command: if std.isArray(v=command) then command else [command] } } } },
        '#withCommandMixin':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='command', type=d.T.array)]),
        withCommandMixin(command): { lifecycle+: { postStart+: { exec+: { command+: if std.isArray(v=command) then command else [command] } } } },
      },
      '#httpGet':: d.obj(help='"HTTPGetAction describes an action based on HTTP Get requests."'),
      httpGet: {
        '#withHost':: d.fn(help='"Host name to connect to, defaults to the pod IP. You probably want to set \\"Host\\" in httpHeaders instead."', args=[d.arg(name='host', type=d.T.string)]),
        withHost(host): { lifecycle+: { postStart+: { httpGet+: { host: host } } } },
        '#withHttpHeaders':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."', args=[d.arg(name='httpHeaders', type=d.T.array)]),
        withHttpHeaders(httpHeaders): { lifecycle+: { postStart+: { httpGet+: { httpHeaders: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } } },
        '#withHttpHeadersMixin':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='httpHeaders', type=d.T.array)]),
        withHttpHeadersMixin(httpHeaders): { lifecycle+: { postStart+: { httpGet+: { httpHeaders+: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } } },
        '#withPath':: d.fn(help='"Path to access on the HTTP server."', args=[d.arg(name='path', type=d.T.string)]),
        withPath(path): { lifecycle+: { postStart+: { httpGet+: { path: path } } } },
        '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
        withPort(port): { lifecycle+: { postStart+: { httpGet+: { port: port } } } },
        '#withScheme':: d.fn(help='"Scheme to use for connecting to the host. Defaults to HTTP."', args=[d.arg(name='scheme', type=d.T.string)]),
        withScheme(scheme): { lifecycle+: { postStart+: { httpGet+: { scheme: scheme } } } },
      },
      '#sleep':: d.obj(help='"SleepAction describes a \\"sleep\\" action."'),
      sleep: {
        '#withSeconds':: d.fn(help='"Seconds is the number of seconds to sleep."', args=[d.arg(name='seconds', type=d.T.integer)]),
        withSeconds(seconds): { lifecycle+: { postStart+: { sleep+: { seconds: seconds } } } },
      },
      '#tcpSocket':: d.obj(help='"TCPSocketAction describes an action based on opening a socket"'),
      tcpSocket: {
        '#withHost':: d.fn(help='"Optional: Host name to connect to, defaults to the pod IP."', args=[d.arg(name='host', type=d.T.string)]),
        withHost(host): { lifecycle+: { postStart+: { tcpSocket+: { host: host } } } },
        '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
        withPort(port): { lifecycle+: { postStart+: { tcpSocket+: { port: port } } } },
      },
    },
    '#preStop':: d.obj(help='"LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified."'),
    preStop: {
      '#exec':: d.obj(help='"ExecAction describes a \\"run in container\\" action."'),
      exec: {
        '#withCommand':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"", args=[d.arg(name='command', type=d.T.array)]),
        withCommand(command): { lifecycle+: { preStop+: { exec+: { command: if std.isArray(v=command) then command else [command] } } } },
        '#withCommandMixin':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='command', type=d.T.array)]),
        withCommandMixin(command): { lifecycle+: { preStop+: { exec+: { command+: if std.isArray(v=command) then command else [command] } } } },
      },
      '#httpGet':: d.obj(help='"HTTPGetAction describes an action based on HTTP Get requests."'),
      httpGet: {
        '#withHost':: d.fn(help='"Host name to connect to, defaults to the pod IP. You probably want to set \\"Host\\" in httpHeaders instead."', args=[d.arg(name='host', type=d.T.string)]),
        withHost(host): { lifecycle+: { preStop+: { httpGet+: { host: host } } } },
        '#withHttpHeaders':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."', args=[d.arg(name='httpHeaders', type=d.T.array)]),
        withHttpHeaders(httpHeaders): { lifecycle+: { preStop+: { httpGet+: { httpHeaders: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } } },
        '#withHttpHeadersMixin':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='httpHeaders', type=d.T.array)]),
        withHttpHeadersMixin(httpHeaders): { lifecycle+: { preStop+: { httpGet+: { httpHeaders+: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } } },
        '#withPath':: d.fn(help='"Path to access on the HTTP server."', args=[d.arg(name='path', type=d.T.string)]),
        withPath(path): { lifecycle+: { preStop+: { httpGet+: { path: path } } } },
        '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
        withPort(port): { lifecycle+: { preStop+: { httpGet+: { port: port } } } },
        '#withScheme':: d.fn(help='"Scheme to use for connecting to the host. Defaults to HTTP."', args=[d.arg(name='scheme', type=d.T.string)]),
        withScheme(scheme): { lifecycle+: { preStop+: { httpGet+: { scheme: scheme } } } },
      },
      '#sleep':: d.obj(help='"SleepAction describes a \\"sleep\\" action."'),
      sleep: {
        '#withSeconds':: d.fn(help='"Seconds is the number of seconds to sleep."', args=[d.arg(name='seconds', type=d.T.integer)]),
        withSeconds(seconds): { lifecycle+: { preStop+: { sleep+: { seconds: seconds } } } },
      },
      '#tcpSocket':: d.obj(help='"TCPSocketAction describes an action based on opening a socket"'),
      tcpSocket: {
        '#withHost':: d.fn(help='"Optional: Host name to connect to, defaults to the pod IP."', args=[d.arg(name='host', type=d.T.string)]),
        withHost(host): { lifecycle+: { preStop+: { tcpSocket+: { host: host } } } },
        '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
        withPort(port): { lifecycle+: { preStop+: { tcpSocket+: { port: port } } } },
      },
    },
  },
  '#livenessProbe':: d.obj(help='"Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic."'),
  livenessProbe: {
    '#exec':: d.obj(help='"ExecAction describes a \\"run in container\\" action."'),
    exec: {
      '#withCommand':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"", args=[d.arg(name='command', type=d.T.array)]),
      withCommand(command): { livenessProbe+: { exec+: { command: if std.isArray(v=command) then command else [command] } } },
      '#withCommandMixin':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='command', type=d.T.array)]),
      withCommandMixin(command): { livenessProbe+: { exec+: { command+: if std.isArray(v=command) then command else [command] } } },
    },
    '#grpc':: d.obj(help=''),
    grpc: {
      '#withPort':: d.fn(help='"Port number of the gRPC service. Number must be in the range 1 to 65535."', args=[d.arg(name='port', type=d.T.integer)]),
      withPort(port): { livenessProbe+: { grpc+: { port: port } } },
      '#withService':: d.fn(help='"Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).\\n\\nIf this is not specified, the default behavior is defined by gRPC."', args=[d.arg(name='service', type=d.T.string)]),
      withService(service): { livenessProbe+: { grpc+: { service: service } } },
    },
    '#httpGet':: d.obj(help='"HTTPGetAction describes an action based on HTTP Get requests."'),
    httpGet: {
      '#withHost':: d.fn(help='"Host name to connect to, defaults to the pod IP. You probably want to set \\"Host\\" in httpHeaders instead."', args=[d.arg(name='host', type=d.T.string)]),
      withHost(host): { livenessProbe+: { httpGet+: { host: host } } },
      '#withHttpHeaders':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."', args=[d.arg(name='httpHeaders', type=d.T.array)]),
      withHttpHeaders(httpHeaders): { livenessProbe+: { httpGet+: { httpHeaders: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } },
      '#withHttpHeadersMixin':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='httpHeaders', type=d.T.array)]),
      withHttpHeadersMixin(httpHeaders): { livenessProbe+: { httpGet+: { httpHeaders+: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } },
      '#withPath':: d.fn(help='"Path to access on the HTTP server."', args=[d.arg(name='path', type=d.T.string)]),
      withPath(path): { livenessProbe+: { httpGet+: { path: path } } },
      '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
      withPort(port): { livenessProbe+: { httpGet+: { port: port } } },
      '#withScheme':: d.fn(help='"Scheme to use for connecting to the host. Defaults to HTTP."', args=[d.arg(name='scheme', type=d.T.string)]),
      withScheme(scheme): { livenessProbe+: { httpGet+: { scheme: scheme } } },
    },
    '#tcpSocket':: d.obj(help='"TCPSocketAction describes an action based on opening a socket"'),
    tcpSocket: {
      '#withHost':: d.fn(help='"Optional: Host name to connect to, defaults to the pod IP."', args=[d.arg(name='host', type=d.T.string)]),
      withHost(host): { livenessProbe+: { tcpSocket+: { host: host } } },
      '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
      withPort(port): { livenessProbe+: { tcpSocket+: { port: port } } },
    },
    '#withFailureThreshold':: d.fn(help='"Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1."', args=[d.arg(name='failureThreshold', type=d.T.integer)]),
    withFailureThreshold(failureThreshold): { livenessProbe+: { failureThreshold: failureThreshold } },
    '#withInitialDelaySeconds':: d.fn(help='"Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"', args=[d.arg(name='initialDelaySeconds', type=d.T.integer)]),
    withInitialDelaySeconds(initialDelaySeconds): { livenessProbe+: { initialDelaySeconds: initialDelaySeconds } },
    '#withPeriodSeconds':: d.fn(help='"How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1."', args=[d.arg(name='periodSeconds', type=d.T.integer)]),
    withPeriodSeconds(periodSeconds): { livenessProbe+: { periodSeconds: periodSeconds } },
    '#withSuccessThreshold':: d.fn(help='"Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1."', args=[d.arg(name='successThreshold', type=d.T.integer)]),
    withSuccessThreshold(successThreshold): { livenessProbe+: { successThreshold: successThreshold } },
    '#withTerminationGracePeriodSeconds':: d.fn(help="\"Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.\"", args=[d.arg(name='terminationGracePeriodSeconds', type=d.T.integer)]),
    withTerminationGracePeriodSeconds(terminationGracePeriodSeconds): { livenessProbe+: { terminationGracePeriodSeconds: terminationGracePeriodSeconds } },
    '#withTimeoutSeconds':: d.fn(help='"Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"', args=[d.arg(name='timeoutSeconds', type=d.T.integer)]),
    withTimeoutSeconds(timeoutSeconds): { livenessProbe+: { timeoutSeconds: timeoutSeconds } },
  },
  '#readinessProbe':: d.obj(help='"Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic."'),
  readinessProbe: {
    '#exec':: d.obj(help='"ExecAction describes a \\"run in container\\" action."'),
    exec: {
      '#withCommand':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"", args=[d.arg(name='command', type=d.T.array)]),
      withCommand(command): { readinessProbe+: { exec+: { command: if std.isArray(v=command) then command else [command] } } },
      '#withCommandMixin':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='command', type=d.T.array)]),
      withCommandMixin(command): { readinessProbe+: { exec+: { command+: if std.isArray(v=command) then command else [command] } } },
    },
    '#grpc':: d.obj(help=''),
    grpc: {
      '#withPort':: d.fn(help='"Port number of the gRPC service. Number must be in the range 1 to 65535."', args=[d.arg(name='port', type=d.T.integer)]),
      withPort(port): { readinessProbe+: { grpc+: { port: port } } },
      '#withService':: d.fn(help='"Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).\\n\\nIf this is not specified, the default behavior is defined by gRPC."', args=[d.arg(name='service', type=d.T.string)]),
      withService(service): { readinessProbe+: { grpc+: { service: service } } },
    },
    '#httpGet':: d.obj(help='"HTTPGetAction describes an action based on HTTP Get requests."'),
    httpGet: {
      '#withHost':: d.fn(help='"Host name to connect to, defaults to the pod IP. You probably want to set \\"Host\\" in httpHeaders instead."', args=[d.arg(name='host', type=d.T.string)]),
      withHost(host): { readinessProbe+: { httpGet+: { host: host } } },
      '#withHttpHeaders':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."', args=[d.arg(name='httpHeaders', type=d.T.array)]),
      withHttpHeaders(httpHeaders): { readinessProbe+: { httpGet+: { httpHeaders: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } },
      '#withHttpHeadersMixin':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='httpHeaders', type=d.T.array)]),
      withHttpHeadersMixin(httpHeaders): { readinessProbe+: { httpGet+: { httpHeaders+: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } },
      '#withPath':: d.fn(help='"Path to access on the HTTP server."', args=[d.arg(name='path', type=d.T.string)]),
      withPath(path): { readinessProbe+: { httpGet+: { path: path } } },
      '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
      withPort(port): { readinessProbe+: { httpGet+: { port: port } } },
      '#withScheme':: d.fn(help='"Scheme to use for connecting to the host. Defaults to HTTP."', args=[d.arg(name='scheme', type=d.T.string)]),
      withScheme(scheme): { readinessProbe+: { httpGet+: { scheme: scheme } } },
    },
    '#tcpSocket':: d.obj(help='"TCPSocketAction describes an action based on opening a socket"'),
    tcpSocket: {
      '#withHost':: d.fn(help='"Optional: Host name to connect to, defaults to the pod IP."', args=[d.arg(name='host', type=d.T.string)]),
      withHost(host): { readinessProbe+: { tcpSocket+: { host: host } } },
      '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
      withPort(port): { readinessProbe+: { tcpSocket+: { port: port } } },
    },
    '#withFailureThreshold':: d.fn(help='"Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1."', args=[d.arg(name='failureThreshold', type=d.T.integer)]),
    withFailureThreshold(failureThreshold): { readinessProbe+: { failureThreshold: failureThreshold } },
    '#withInitialDelaySeconds':: d.fn(help='"Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"', args=[d.arg(name='initialDelaySeconds', type=d.T.integer)]),
    withInitialDelaySeconds(initialDelaySeconds): { readinessProbe+: { initialDelaySeconds: initialDelaySeconds } },
    '#withPeriodSeconds':: d.fn(help='"How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1."', args=[d.arg(name='periodSeconds', type=d.T.integer)]),
    withPeriodSeconds(periodSeconds): { readinessProbe+: { periodSeconds: periodSeconds } },
    '#withSuccessThreshold':: d.fn(help='"Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1."', args=[d.arg(name='successThreshold', type=d.T.integer)]),
    withSuccessThreshold(successThreshold): { readinessProbe+: { successThreshold: successThreshold } },
    '#withTerminationGracePeriodSeconds':: d.fn(help="\"Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.\"", args=[d.arg(name='terminationGracePeriodSeconds', type=d.T.integer)]),
    withTerminationGracePeriodSeconds(terminationGracePeriodSeconds): { readinessProbe+: { terminationGracePeriodSeconds: terminationGracePeriodSeconds } },
    '#withTimeoutSeconds':: d.fn(help='"Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"', args=[d.arg(name='timeoutSeconds', type=d.T.integer)]),
    withTimeoutSeconds(timeoutSeconds): { readinessProbe+: { timeoutSeconds: timeoutSeconds } },
  },
  '#resources':: d.obj(help='"ResourceRequirements describes the compute resource requirements."'),
  resources: {
    '#withClaims':: d.fn(help='"Claims lists the names of resources, defined in spec.resourceClaims, that are used by this container.\\n\\nThis is an alpha field and requires enabling the DynamicResourceAllocation feature gate.\\n\\nThis field is immutable. It can only be set for containers."', args=[d.arg(name='claims', type=d.T.array)]),
    withClaims(claims): { resources+: { claims: if std.isArray(v=claims) then claims else [claims] } },
    '#withClaimsMixin':: d.fn(help='"Claims lists the names of resources, defined in spec.resourceClaims, that are used by this container.\\n\\nThis is an alpha field and requires enabling the DynamicResourceAllocation feature gate.\\n\\nThis field is immutable. It can only be set for containers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='claims', type=d.T.array)]),
    withClaimsMixin(claims): { resources+: { claims+: if std.isArray(v=claims) then claims else [claims] } },
    '#withLimits':: d.fn(help='"Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"', args=[d.arg(name='limits', type=d.T.object)]),
    withLimits(limits): { resources+: { limits: limits } },
    '#withLimitsMixin':: d.fn(help='"Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='limits', type=d.T.object)]),
    withLimitsMixin(limits): { resources+: { limits+: limits } },
    '#withRequests':: d.fn(help='"Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"', args=[d.arg(name='requests', type=d.T.object)]),
    withRequests(requests): { resources+: { requests: requests } },
    '#withRequestsMixin':: d.fn(help='"Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='requests', type=d.T.object)]),
    withRequestsMixin(requests): { resources+: { requests+: requests } },
  },
  '#securityContext':: d.obj(help='"SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence."'),
  securityContext: {
    '#appArmorProfile':: d.obj(help="\"AppArmorProfile defines a pod or container's AppArmor settings.\""),
    appArmorProfile: {
      '#withLocalhostProfile':: d.fn(help='"localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is \\"Localhost\\"."', args=[d.arg(name='localhostProfile', type=d.T.string)]),
      withLocalhostProfile(localhostProfile): { securityContext+: { appArmorProfile+: { localhostProfile: localhostProfile } } },
      '#withType':: d.fn(help="\"type indicates which kind of AppArmor profile will be applied. Valid options are:\\n  Localhost - a profile pre-loaded on the node.\\n  RuntimeDefault - the container runtime's default profile.\\n  Unconfined - no AppArmor enforcement.\"", args=[d.arg(name='type', type=d.T.string)]),
      withType(type): { securityContext+: { appArmorProfile+: { type: type } } },
    },
    '#capabilities':: d.obj(help='"Adds and removes POSIX capabilities from running containers."'),
    capabilities: {
      '#withAdd':: d.fn(help='"Added capabilities"', args=[d.arg(name='add', type=d.T.array)]),
      withAdd(add): { securityContext+: { capabilities+: { add: if std.isArray(v=add) then add else [add] } } },
      '#withAddMixin':: d.fn(help='"Added capabilities"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='add', type=d.T.array)]),
      withAddMixin(add): { securityContext+: { capabilities+: { add+: if std.isArray(v=add) then add else [add] } } },
      '#withDrop':: d.fn(help='"Removed capabilities"', args=[d.arg(name='drop', type=d.T.array)]),
      withDrop(drop): { securityContext+: { capabilities+: { drop: if std.isArray(v=drop) then drop else [drop] } } },
      '#withDropMixin':: d.fn(help='"Removed capabilities"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='drop', type=d.T.array)]),
      withDropMixin(drop): { securityContext+: { capabilities+: { drop+: if std.isArray(v=drop) then drop else [drop] } } },
    },
    '#seLinuxOptions':: d.obj(help='"SELinuxOptions are the labels to be applied to the container"'),
    seLinuxOptions: {
      '#withLevel':: d.fn(help='"Level is SELinux level label that applies to the container."', args=[d.arg(name='level', type=d.T.string)]),
      withLevel(level): { securityContext+: { seLinuxOptions+: { level: level } } },
      '#withRole':: d.fn(help='"Role is a SELinux role label that applies to the container."', args=[d.arg(name='role', type=d.T.string)]),
      withRole(role): { securityContext+: { seLinuxOptions+: { role: role } } },
      '#withType':: d.fn(help='"Type is a SELinux type label that applies to the container."', args=[d.arg(name='type', type=d.T.string)]),
      withType(type): { securityContext+: { seLinuxOptions+: { type: type } } },
      '#withUser':: d.fn(help='"User is a SELinux user label that applies to the container."', args=[d.arg(name='user', type=d.T.string)]),
      withUser(user): { securityContext+: { seLinuxOptions+: { user: user } } },
    },
    '#seccompProfile':: d.obj(help="\"SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set.\""),
    seccompProfile: {
      '#withLocalhostProfile':: d.fn(help="\"localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must be set if type is \\\"Localhost\\\". Must NOT be set for any other type.\"", args=[d.arg(name='localhostProfile', type=d.T.string)]),
      withLocalhostProfile(localhostProfile): { securityContext+: { seccompProfile+: { localhostProfile: localhostProfile } } },
      '#withType':: d.fn(help='"type indicates which kind of seccomp profile will be applied. Valid options are:\\n\\nLocalhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied."', args=[d.arg(name='type', type=d.T.string)]),
      withType(type): { securityContext+: { seccompProfile+: { type: type } } },
    },
    '#windowsOptions':: d.obj(help='"WindowsSecurityContextOptions contain Windows-specific options and credentials."'),
    windowsOptions: {
      '#withGmsaCredentialSpec':: d.fn(help='"GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field."', args=[d.arg(name='gmsaCredentialSpec', type=d.T.string)]),
      withGmsaCredentialSpec(gmsaCredentialSpec): { securityContext+: { windowsOptions+: { gmsaCredentialSpec: gmsaCredentialSpec } } },
      '#withGmsaCredentialSpecName':: d.fn(help='"GMSACredentialSpecName is the name of the GMSA credential spec to use."', args=[d.arg(name='gmsaCredentialSpecName', type=d.T.string)]),
      withGmsaCredentialSpecName(gmsaCredentialSpecName): { securityContext+: { windowsOptions+: { gmsaCredentialSpecName: gmsaCredentialSpecName } } },
      '#withHostProcess':: d.fn(help="\"HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.\"", args=[d.arg(name='hostProcess', type=d.T.boolean)]),
      withHostProcess(hostProcess): { securityContext+: { windowsOptions+: { hostProcess: hostProcess } } },
      '#withRunAsUserName':: d.fn(help='"The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence."', args=[d.arg(name='runAsUserName', type=d.T.string)]),
      withRunAsUserName(runAsUserName): { securityContext+: { windowsOptions+: { runAsUserName: runAsUserName } } },
    },
    '#withAllowPrivilegeEscalation':: d.fn(help='"AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='allowPrivilegeEscalation', type=d.T.boolean)]),
    withAllowPrivilegeEscalation(allowPrivilegeEscalation): { securityContext+: { allowPrivilegeEscalation: allowPrivilegeEscalation } },
    '#withPrivileged':: d.fn(help='"Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='privileged', type=d.T.boolean)]),
    withPrivileged(privileged): { securityContext+: { privileged: privileged } },
    '#withProcMount':: d.fn(help='"procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='procMount', type=d.T.string)]),
    withProcMount(procMount): { securityContext+: { procMount: procMount } },
    '#withReadOnlyRootFilesystem':: d.fn(help='"Whether this container has a read-only root filesystem. Default is false. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='readOnlyRootFilesystem', type=d.T.boolean)]),
    withReadOnlyRootFilesystem(readOnlyRootFilesystem): { securityContext+: { readOnlyRootFilesystem: readOnlyRootFilesystem } },
    '#withRunAsGroup':: d.fn(help='"The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='runAsGroup', type=d.T.integer)]),
    withRunAsGroup(runAsGroup): { securityContext+: { runAsGroup: runAsGroup } },
    '#withRunAsNonRoot':: d.fn(help='"Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence."', args=[d.arg(name='runAsNonRoot', type=d.T.boolean)]),
    withRunAsNonRoot(runAsNonRoot): { securityContext+: { runAsNonRoot: runAsNonRoot } },
    '#withRunAsUser':: d.fn(help='"The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='runAsUser', type=d.T.integer)]),
    withRunAsUser(runAsUser): { securityContext+: { runAsUser: runAsUser } },
  },
  '#startupProbe':: d.obj(help='"Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic."'),
  startupProbe: {
    '#exec':: d.obj(help='"ExecAction describes a \\"run in container\\" action."'),
    exec: {
      '#withCommand':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"", args=[d.arg(name='command', type=d.T.array)]),
      withCommand(command): { startupProbe+: { exec+: { command: if std.isArray(v=command) then command else [command] } } },
      '#withCommandMixin':: d.fn(help="\"Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='command', type=d.T.array)]),
      withCommandMixin(command): { startupProbe+: { exec+: { command+: if std.isArray(v=command) then command else [command] } } },
    },
    '#grpc':: d.obj(help=''),
    grpc: {
      '#withPort':: d.fn(help='"Port number of the gRPC service. Number must be in the range 1 to 65535."', args=[d.arg(name='port', type=d.T.integer)]),
      withPort(port): { startupProbe+: { grpc+: { port: port } } },
      '#withService':: d.fn(help='"Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).\\n\\nIf this is not specified, the default behavior is defined by gRPC."', args=[d.arg(name='service', type=d.T.string)]),
      withService(service): { startupProbe+: { grpc+: { service: service } } },
    },
    '#httpGet':: d.obj(help='"HTTPGetAction describes an action based on HTTP Get requests."'),
    httpGet: {
      '#withHost':: d.fn(help='"Host name to connect to, defaults to the pod IP. You probably want to set \\"Host\\" in httpHeaders instead."', args=[d.arg(name='host', type=d.T.string)]),
      withHost(host): { startupProbe+: { httpGet+: { host: host } } },
      '#withHttpHeaders':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."', args=[d.arg(name='httpHeaders', type=d.T.array)]),
      withHttpHeaders(httpHeaders): { startupProbe+: { httpGet+: { httpHeaders: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } },
      '#withHttpHeadersMixin':: d.fn(help='"Custom headers to set in the request. HTTP allows repeated headers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='httpHeaders', type=d.T.array)]),
      withHttpHeadersMixin(httpHeaders): { startupProbe+: { httpGet+: { httpHeaders+: if std.isArray(v=httpHeaders) then httpHeaders else [httpHeaders] } } },
      '#withPath':: d.fn(help='"Path to access on the HTTP server."', args=[d.arg(name='path', type=d.T.string)]),
      withPath(path): { startupProbe+: { httpGet+: { path: path } } },
      '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
      withPort(port): { startupProbe+: { httpGet+: { port: port } } },
      '#withScheme':: d.fn(help='"Scheme to use for connecting to the host. Defaults to HTTP."', args=[d.arg(name='scheme', type=d.T.string)]),
      withScheme(scheme): { startupProbe+: { httpGet+: { scheme: scheme } } },
    },
    '#tcpSocket':: d.obj(help='"TCPSocketAction describes an action based on opening a socket"'),
    tcpSocket: {
      '#withHost':: d.fn(help='"Optional: Host name to connect to, defaults to the pod IP."', args=[d.arg(name='host', type=d.T.string)]),
      withHost(host): { startupProbe+: { tcpSocket+: { host: host } } },
      '#withPort':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='port', type=d.T.string)]),
      withPort(port): { startupProbe+: { tcpSocket+: { port: port } } },
    },
    '#withFailureThreshold':: d.fn(help='"Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1."', args=[d.arg(name='failureThreshold', type=d.T.integer)]),
    withFailureThreshold(failureThreshold): { startupProbe+: { failureThreshold: failureThreshold } },
    '#withInitialDelaySeconds':: d.fn(help='"Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"', args=[d.arg(name='initialDelaySeconds', type=d.T.integer)]),
    withInitialDelaySeconds(initialDelaySeconds): { startupProbe+: { initialDelaySeconds: initialDelaySeconds } },
    '#withPeriodSeconds':: d.fn(help='"How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1."', args=[d.arg(name='periodSeconds', type=d.T.integer)]),
    withPeriodSeconds(periodSeconds): { startupProbe+: { periodSeconds: periodSeconds } },
    '#withSuccessThreshold':: d.fn(help='"Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1."', args=[d.arg(name='successThreshold', type=d.T.integer)]),
    withSuccessThreshold(successThreshold): { startupProbe+: { successThreshold: successThreshold } },
    '#withTerminationGracePeriodSeconds':: d.fn(help="\"Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.\"", args=[d.arg(name='terminationGracePeriodSeconds', type=d.T.integer)]),
    withTerminationGracePeriodSeconds(terminationGracePeriodSeconds): { startupProbe+: { terminationGracePeriodSeconds: terminationGracePeriodSeconds } },
    '#withTimeoutSeconds':: d.fn(help='"Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"', args=[d.arg(name='timeoutSeconds', type=d.T.integer)]),
    withTimeoutSeconds(timeoutSeconds): { startupProbe+: { timeoutSeconds: timeoutSeconds } },
  },
  '#withArgs':: d.fn(help="\"Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \\\"$$(VAR_NAME)\\\" will produce the string literal \\\"$(VAR_NAME)\\\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell\"", args=[d.arg(name='args', type=d.T.array)]),
  withArgs(args): { args: if std.isArray(v=args) then args else [args] },
  '#withArgsMixin':: d.fn(help="\"Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \\\"$$(VAR_NAME)\\\" will produce the string literal \\\"$(VAR_NAME)\\\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='args', type=d.T.array)]),
  withArgsMixin(args): { args+: if std.isArray(v=args) then args else [args] },
  '#withCommand':: d.fn(help="\"Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \\\"$$(VAR_NAME)\\\" will produce the string literal \\\"$(VAR_NAME)\\\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell\"", args=[d.arg(name='command', type=d.T.array)]),
  withCommand(command): { command: if std.isArray(v=command) then command else [command] },
  '#withCommandMixin':: d.fn(help="\"Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \\\"$$(VAR_NAME)\\\" will produce the string literal \\\"$(VAR_NAME)\\\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='command', type=d.T.array)]),
  withCommandMixin(command): { command+: if std.isArray(v=command) then command else [command] },
  '#withEnv':: d.fn(help='"List of environment variables to set in the container. Cannot be updated."', args=[d.arg(name='env', type=d.T.array)]),
  withEnv(env): { env: if std.isArray(v=env) then env else [env] },
  '#withEnvFrom':: d.fn(help='"List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated."', args=[d.arg(name='envFrom', type=d.T.array)]),
  withEnvFrom(envFrom): { envFrom: if std.isArray(v=envFrom) then envFrom else [envFrom] },
  '#withEnvFromMixin':: d.fn(help='"List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='envFrom', type=d.T.array)]),
  withEnvFromMixin(envFrom): { envFrom+: if std.isArray(v=envFrom) then envFrom else [envFrom] },
  '#withEnvMixin':: d.fn(help='"List of environment variables to set in the container. Cannot be updated."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='env', type=d.T.array)]),
  withEnvMixin(env): { env+: if std.isArray(v=env) then env else [env] },
  '#withImage':: d.fn(help='"Container image name. More info: https://kubernetes.io/docs/concepts/containers/images"', args=[d.arg(name='image', type=d.T.string)]),
  withImage(image): { image: image },
  '#withImagePullPolicy':: d.fn(help='"Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images"', args=[d.arg(name='imagePullPolicy', type=d.T.string)]),
  withImagePullPolicy(imagePullPolicy): { imagePullPolicy: imagePullPolicy },
  '#withName':: d.fn(help='"Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers."', args=[d.arg(name='name', type=d.T.string)]),
  withName(name): { name: name },
  '#withPorts':: d.fn(help='"Ports are not allowed for ephemeral containers."', args=[d.arg(name='ports', type=d.T.array)]),
  withPorts(ports): { ports: if std.isArray(v=ports) then ports else [ports] },
  '#withPortsMixin':: d.fn(help='"Ports are not allowed for ephemeral containers."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ports', type=d.T.array)]),
  withPortsMixin(ports): { ports+: if std.isArray(v=ports) then ports else [ports] },
  '#withResizePolicy':: d.fn(help='"Resources resize policy for the container."', args=[d.arg(name='resizePolicy', type=d.T.array)]),
  withResizePolicy(resizePolicy): { resizePolicy: if std.isArray(v=resizePolicy) then resizePolicy else [resizePolicy] },
  '#withResizePolicyMixin':: d.fn(help='"Resources resize policy for the container."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='resizePolicy', type=d.T.array)]),
  withResizePolicyMixin(resizePolicy): { resizePolicy+: if std.isArray(v=resizePolicy) then resizePolicy else [resizePolicy] },
  '#withRestartPolicy':: d.fn(help='"Restart policy for the container to manage the restart behavior of each container within a pod. This may only be set for init containers. You cannot set this field on ephemeral containers."', args=[d.arg(name='restartPolicy', type=d.T.string)]),
  withRestartPolicy(restartPolicy): { restartPolicy: restartPolicy },
  '#withStdin':: d.fn(help='"Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false."', args=[d.arg(name='stdin', type=d.T.boolean)]),
  withStdin(stdin): { stdin: stdin },
  '#withStdinOnce':: d.fn(help='"Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false"', args=[d.arg(name='stdinOnce', type=d.T.boolean)]),
  withStdinOnce(stdinOnce): { stdinOnce: stdinOnce },
  '#withTargetContainerName':: d.fn(help='"If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.\\n\\nThe container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined."', args=[d.arg(name='targetContainerName', type=d.T.string)]),
  withTargetContainerName(targetContainerName): { targetContainerName: targetContainerName },
  '#withTerminationMessagePath':: d.fn(help="\"Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.\"", args=[d.arg(name='terminationMessagePath', type=d.T.string)]),
  withTerminationMessagePath(terminationMessagePath): { terminationMessagePath: terminationMessagePath },
  '#withTerminationMessagePolicy':: d.fn(help='"Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated."', args=[d.arg(name='terminationMessagePolicy', type=d.T.string)]),
  withTerminationMessagePolicy(terminationMessagePolicy): { terminationMessagePolicy: terminationMessagePolicy },
  '#withTty':: d.fn(help="\"Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.\"", args=[d.arg(name='tty', type=d.T.boolean)]),
  withTty(tty): { tty: tty },
  '#withVolumeDevices':: d.fn(help='"volumeDevices is the list of block devices to be used by the container."', args=[d.arg(name='volumeDevices', type=d.T.array)]),
  withVolumeDevices(volumeDevices): { volumeDevices: if std.isArray(v=volumeDevices) then volumeDevices else [volumeDevices] },
  '#withVolumeDevicesMixin':: d.fn(help='"volumeDevices is the list of block devices to be used by the container."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='volumeDevices', type=d.T.array)]),
  withVolumeDevicesMixin(volumeDevices): { volumeDevices+: if std.isArray(v=volumeDevices) then volumeDevices else [volumeDevices] },
  '#withVolumeMounts':: d.fn(help="\"Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.\"", args=[d.arg(name='volumeMounts', type=d.T.array)]),
  withVolumeMounts(volumeMounts): { volumeMounts: if std.isArray(v=volumeMounts) then volumeMounts else [volumeMounts] },
  '#withVolumeMountsMixin':: d.fn(help="\"Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='volumeMounts', type=d.T.array)]),
  withVolumeMountsMixin(volumeMounts): { volumeMounts+: if std.isArray(v=volumeMounts) then volumeMounts else [volumeMounts] },
  '#withWorkingDir':: d.fn(help="\"Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.\"", args=[d.arg(name='workingDir', type=d.T.string)]),
  withWorkingDir(workingDir): { workingDir: workingDir },
  '#mixin': 'ignore',
  mixin: self,
}
