{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='cronJobSpec', url='', help='"CronJobSpec describes how the job execution will look like and when it will actually run."'),
  '#jobTemplate':: d.obj(help='"JobTemplateSpec describes the data a Job should have when created from a template"'),
  jobTemplate: {
    '#metadata':: d.obj(help='"ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create."'),
    metadata: {
      '#withAnnotations':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"', args=[d.arg(name='annotations', type=d.T.object)]),
      withAnnotations(annotations): { jobTemplate+: { metadata+: { annotations: annotations } } },
      '#withAnnotationsMixin':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='annotations', type=d.T.object)]),
      withAnnotationsMixin(annotations): { jobTemplate+: { metadata+: { annotations+: annotations } } },
      '#withCreationTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='creationTimestamp', type=d.T.string)]),
      withCreationTimestamp(creationTimestamp): { jobTemplate+: { metadata+: { creationTimestamp: creationTimestamp } } },
      '#withDeletionGracePeriodSeconds':: d.fn(help='"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only."', args=[d.arg(name='deletionGracePeriodSeconds', type=d.T.integer)]),
      withDeletionGracePeriodSeconds(deletionGracePeriodSeconds): { jobTemplate+: { metadata+: { deletionGracePeriodSeconds: deletionGracePeriodSeconds } } },
      '#withDeletionTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='deletionTimestamp', type=d.T.string)]),
      withDeletionTimestamp(deletionTimestamp): { jobTemplate+: { metadata+: { deletionTimestamp: deletionTimestamp } } },
      '#withFinalizers':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."', args=[d.arg(name='finalizers', type=d.T.array)]),
      withFinalizers(finalizers): { jobTemplate+: { metadata+: { finalizers: if std.isArray(v=finalizers) then finalizers else [finalizers] } } },
      '#withFinalizersMixin':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='finalizers', type=d.T.array)]),
      withFinalizersMixin(finalizers): { jobTemplate+: { metadata+: { finalizers+: if std.isArray(v=finalizers) then finalizers else [finalizers] } } },
      '#withGenerateName':: d.fn(help='"GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\\n\\nIf this field is specified and the generated name exists, the server will return a 409.\\n\\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency"', args=[d.arg(name='generateName', type=d.T.string)]),
      withGenerateName(generateName): { jobTemplate+: { metadata+: { generateName: generateName } } },
      '#withGeneration':: d.fn(help='"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only."', args=[d.arg(name='generation', type=d.T.integer)]),
      withGeneration(generation): { jobTemplate+: { metadata+: { generation: generation } } },
      '#withLabels':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"', args=[d.arg(name='labels', type=d.T.object)]),
      withLabels(labels): { jobTemplate+: { metadata+: { labels: labels } } },
      '#withLabelsMixin':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='labels', type=d.T.object)]),
      withLabelsMixin(labels): { jobTemplate+: { metadata+: { labels+: labels } } },
      '#withManagedFields':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"", args=[d.arg(name='managedFields', type=d.T.array)]),
      withManagedFields(managedFields): { jobTemplate+: { metadata+: { managedFields: if std.isArray(v=managedFields) then managedFields else [managedFields] } } },
      '#withManagedFieldsMixin':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='managedFields', type=d.T.array)]),
      withManagedFieldsMixin(managedFields): { jobTemplate+: { metadata+: { managedFields+: if std.isArray(v=managedFields) then managedFields else [managedFields] } } },
      '#withName':: d.fn(help='"Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { jobTemplate+: { metadata+: { name: name } } },
      '#withNamespace':: d.fn(help='"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \\"default\\" namespace, but \\"default\\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\\n\\nMust be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces"', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { jobTemplate+: { metadata+: { namespace: namespace } } },
      '#withOwnerReferences':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."', args=[d.arg(name='ownerReferences', type=d.T.array)]),
      withOwnerReferences(ownerReferences): { jobTemplate+: { metadata+: { ownerReferences: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } },
      '#withOwnerReferencesMixin':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ownerReferences', type=d.T.array)]),
      withOwnerReferencesMixin(ownerReferences): { jobTemplate+: { metadata+: { ownerReferences+: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } },
      '#withResourceVersion':: d.fn(help='"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\\n\\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
      withResourceVersion(resourceVersion): { jobTemplate+: { metadata+: { resourceVersion: resourceVersion } } },
      '#withSelfLink':: d.fn(help='"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system."', args=[d.arg(name='selfLink', type=d.T.string)]),
      withSelfLink(selfLink): { jobTemplate+: { metadata+: { selfLink: selfLink } } },
      '#withUid':: d.fn(help='"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\\n\\nPopulated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids"', args=[d.arg(name='uid', type=d.T.string)]),
      withUid(uid): { jobTemplate+: { metadata+: { uid: uid } } },
    },
    '#spec':: d.obj(help='"JobSpec describes how the job execution will look like."'),
    spec: {
      '#podFailurePolicy':: d.obj(help='"PodFailurePolicy describes how failed pods influence the backoffLimit."'),
      podFailurePolicy: {
        '#withRules':: d.fn(help='"A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed."', args=[d.arg(name='rules', type=d.T.array)]),
        withRules(rules): { jobTemplate+: { spec+: { podFailurePolicy+: { rules: if std.isArray(v=rules) then rules else [rules] } } } },
        '#withRulesMixin':: d.fn(help='"A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='rules', type=d.T.array)]),
        withRulesMixin(rules): { jobTemplate+: { spec+: { podFailurePolicy+: { rules+: if std.isArray(v=rules) then rules else [rules] } } } },
      },
      '#selector':: d.obj(help='"A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects."'),
      selector: {
        '#withMatchExpressions':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."', args=[d.arg(name='matchExpressions', type=d.T.array)]),
        withMatchExpressions(matchExpressions): { jobTemplate+: { spec+: { selector+: { matchExpressions: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } } },
        '#withMatchExpressionsMixin':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchExpressions', type=d.T.array)]),
        withMatchExpressionsMixin(matchExpressions): { jobTemplate+: { spec+: { selector+: { matchExpressions+: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } } },
        '#withMatchLabels':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."', args=[d.arg(name='matchLabels', type=d.T.object)]),
        withMatchLabels(matchLabels): { jobTemplate+: { spec+: { selector+: { matchLabels: matchLabels } } } },
        '#withMatchLabelsMixin':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchLabels', type=d.T.object)]),
        withMatchLabelsMixin(matchLabels): { jobTemplate+: { spec+: { selector+: { matchLabels+: matchLabels } } } },
      },
      '#successPolicy':: d.obj(help='"SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes."'),
      successPolicy: {
        '#withRules':: d.fn(help='"rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the \\"SucceededCriteriaMet\\" condition is added, and the lingering pods are removed. The terminal state for such a Job has the \\"Complete\\" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed."', args=[d.arg(name='rules', type=d.T.array)]),
        withRules(rules): { jobTemplate+: { spec+: { successPolicy+: { rules: if std.isArray(v=rules) then rules else [rules] } } } },
        '#withRulesMixin':: d.fn(help='"rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the \\"SucceededCriteriaMet\\" condition is added, and the lingering pods are removed. The terminal state for such a Job has the \\"Complete\\" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='rules', type=d.T.array)]),
        withRulesMixin(rules): { jobTemplate+: { spec+: { successPolicy+: { rules+: if std.isArray(v=rules) then rules else [rules] } } } },
      },
      '#template':: d.obj(help='"PodTemplateSpec describes the data a pod should have when created from a template"'),
      template: {
        '#metadata':: d.obj(help='"ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create."'),
        metadata: {
          '#withAnnotations':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"', args=[d.arg(name='annotations', type=d.T.object)]),
          withAnnotations(annotations): { jobTemplate+: { spec+: { template+: { metadata+: { annotations: annotations } } } } },
          '#withAnnotationsMixin':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='annotations', type=d.T.object)]),
          withAnnotationsMixin(annotations): { jobTemplate+: { spec+: { template+: { metadata+: { annotations+: annotations } } } } },
          '#withCreationTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='creationTimestamp', type=d.T.string)]),
          withCreationTimestamp(creationTimestamp): { jobTemplate+: { spec+: { template+: { metadata+: { creationTimestamp: creationTimestamp } } } } },
          '#withDeletionGracePeriodSeconds':: d.fn(help='"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only."', args=[d.arg(name='deletionGracePeriodSeconds', type=d.T.integer)]),
          withDeletionGracePeriodSeconds(deletionGracePeriodSeconds): { jobTemplate+: { spec+: { template+: { metadata+: { deletionGracePeriodSeconds: deletionGracePeriodSeconds } } } } },
          '#withDeletionTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='deletionTimestamp', type=d.T.string)]),
          withDeletionTimestamp(deletionTimestamp): { jobTemplate+: { spec+: { template+: { metadata+: { deletionTimestamp: deletionTimestamp } } } } },
          '#withFinalizers':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."', args=[d.arg(name='finalizers', type=d.T.array)]),
          withFinalizers(finalizers): { jobTemplate+: { spec+: { template+: { metadata+: { finalizers: if std.isArray(v=finalizers) then finalizers else [finalizers] } } } } },
          '#withFinalizersMixin':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='finalizers', type=d.T.array)]),
          withFinalizersMixin(finalizers): { jobTemplate+: { spec+: { template+: { metadata+: { finalizers+: if std.isArray(v=finalizers) then finalizers else [finalizers] } } } } },
          '#withGenerateName':: d.fn(help='"GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\\n\\nIf this field is specified and the generated name exists, the server will return a 409.\\n\\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency"', args=[d.arg(name='generateName', type=d.T.string)]),
          withGenerateName(generateName): { jobTemplate+: { spec+: { template+: { metadata+: { generateName: generateName } } } } },
          '#withGeneration':: d.fn(help='"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only."', args=[d.arg(name='generation', type=d.T.integer)]),
          withGeneration(generation): { jobTemplate+: { spec+: { template+: { metadata+: { generation: generation } } } } },
          '#withLabels':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"', args=[d.arg(name='labels', type=d.T.object)]),
          withLabels(labels): { jobTemplate+: { spec+: { template+: { metadata+: { labels: labels } } } } },
          '#withLabelsMixin':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='labels', type=d.T.object)]),
          withLabelsMixin(labels): { jobTemplate+: { spec+: { template+: { metadata+: { labels+: labels } } } } },
          '#withManagedFields':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"", args=[d.arg(name='managedFields', type=d.T.array)]),
          withManagedFields(managedFields): { jobTemplate+: { spec+: { template+: { metadata+: { managedFields: if std.isArray(v=managedFields) then managedFields else [managedFields] } } } } },
          '#withManagedFieldsMixin':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='managedFields', type=d.T.array)]),
          withManagedFieldsMixin(managedFields): { jobTemplate+: { spec+: { template+: { metadata+: { managedFields+: if std.isArray(v=managedFields) then managedFields else [managedFields] } } } } },
          '#withName':: d.fn(help='"Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names"', args=[d.arg(name='name', type=d.T.string)]),
          withName(name): { jobTemplate+: { spec+: { template+: { metadata+: { name: name } } } } },
          '#withNamespace':: d.fn(help='"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \\"default\\" namespace, but \\"default\\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\\n\\nMust be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces"', args=[d.arg(name='namespace', type=d.T.string)]),
          withNamespace(namespace): { jobTemplate+: { spec+: { template+: { metadata+: { namespace: namespace } } } } },
          '#withOwnerReferences':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."', args=[d.arg(name='ownerReferences', type=d.T.array)]),
          withOwnerReferences(ownerReferences): { jobTemplate+: { spec+: { template+: { metadata+: { ownerReferences: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } } } },
          '#withOwnerReferencesMixin':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ownerReferences', type=d.T.array)]),
          withOwnerReferencesMixin(ownerReferences): { jobTemplate+: { spec+: { template+: { metadata+: { ownerReferences+: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } } } },
          '#withResourceVersion':: d.fn(help='"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\\n\\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
          withResourceVersion(resourceVersion): { jobTemplate+: { spec+: { template+: { metadata+: { resourceVersion: resourceVersion } } } } },
          '#withSelfLink':: d.fn(help='"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system."', args=[d.arg(name='selfLink', type=d.T.string)]),
          withSelfLink(selfLink): { jobTemplate+: { spec+: { template+: { metadata+: { selfLink: selfLink } } } } },
          '#withUid':: d.fn(help='"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\\n\\nPopulated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids"', args=[d.arg(name='uid', type=d.T.string)]),
          withUid(uid): { jobTemplate+: { spec+: { template+: { metadata+: { uid: uid } } } } },
        },
        '#spec':: d.obj(help='"PodSpec is a description of a pod."'),
        spec: {
          '#affinity':: d.obj(help='"Affinity is a group of affinity scheduling rules."'),
          affinity: {
            '#nodeAffinity':: d.obj(help='"Node affinity is a group of node affinity scheduling rules."'),
            nodeAffinity: {
              '#requiredDuringSchedulingIgnoredDuringExecution':: d.obj(help='"A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms."'),
              requiredDuringSchedulingIgnoredDuringExecution: {
                '#withNodeSelectorTerms':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
                withNodeSelectorTerms(nodeSelectorTerms): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: { nodeSelectorTerms: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } } } } } } },
                '#withNodeSelectorTermsMixin':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
                withNodeSelectorTermsMixin(nodeSelectorTerms): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: { nodeSelectorTerms+: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } } } } } } },
              },
              '#withPreferredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred."', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withPreferredDuringSchedulingIgnoredDuringExecution(preferredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { preferredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withPreferredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withPreferredDuringSchedulingIgnoredDuringExecutionMixin(preferredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { preferredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } } },
            },
            '#podAffinity':: d.obj(help='"Pod affinity is a group of inter pod affinity scheduling rules."'),
            podAffinity: {
              '#withPreferredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withPreferredDuringSchedulingIgnoredDuringExecution(preferredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAffinity+: { preferredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withPreferredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withPreferredDuringSchedulingIgnoredDuringExecutionMixin(preferredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAffinity+: { preferredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withRequiredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withRequiredDuringSchedulingIgnoredDuringExecution(requiredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAffinity+: { requiredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withRequiredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withRequiredDuringSchedulingIgnoredDuringExecutionMixin(requiredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } } },
            },
            '#podAntiAffinity':: d.obj(help='"Pod anti affinity is a group of inter pod anti affinity scheduling rules."'),
            podAntiAffinity: {
              '#withPreferredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withPreferredDuringSchedulingIgnoredDuringExecution(preferredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { preferredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withPreferredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withPreferredDuringSchedulingIgnoredDuringExecutionMixin(preferredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { preferredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withRequiredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withRequiredDuringSchedulingIgnoredDuringExecution(requiredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { requiredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } } },
              '#withRequiredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
              withRequiredDuringSchedulingIgnoredDuringExecutionMixin(requiredDuringSchedulingIgnoredDuringExecution): { jobTemplate+: { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } } },
            },
          },
          '#dnsConfig':: d.obj(help='"PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy."'),
          dnsConfig: {
            '#withNameservers':: d.fn(help='"A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed."', args=[d.arg(name='nameservers', type=d.T.array)]),
            withNameservers(nameservers): { jobTemplate+: { spec+: { template+: { spec+: { dnsConfig+: { nameservers: if std.isArray(v=nameservers) then nameservers else [nameservers] } } } } } },
            '#withNameserversMixin':: d.fn(help='"A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='nameservers', type=d.T.array)]),
            withNameserversMixin(nameservers): { jobTemplate+: { spec+: { template+: { spec+: { dnsConfig+: { nameservers+: if std.isArray(v=nameservers) then nameservers else [nameservers] } } } } } },
            '#withOptions':: d.fn(help='"A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy."', args=[d.arg(name='options', type=d.T.array)]),
            withOptions(options): { jobTemplate+: { spec+: { template+: { spec+: { dnsConfig+: { options: if std.isArray(v=options) then options else [options] } } } } } },
            '#withOptionsMixin':: d.fn(help='"A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='options', type=d.T.array)]),
            withOptionsMixin(options): { jobTemplate+: { spec+: { template+: { spec+: { dnsConfig+: { options+: if std.isArray(v=options) then options else [options] } } } } } },
            '#withSearches':: d.fn(help='"A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed."', args=[d.arg(name='searches', type=d.T.array)]),
            withSearches(searches): { jobTemplate+: { spec+: { template+: { spec+: { dnsConfig+: { searches: if std.isArray(v=searches) then searches else [searches] } } } } } },
            '#withSearchesMixin':: d.fn(help='"A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='searches', type=d.T.array)]),
            withSearchesMixin(searches): { jobTemplate+: { spec+: { template+: { spec+: { dnsConfig+: { searches+: if std.isArray(v=searches) then searches else [searches] } } } } } },
          },
          '#os':: d.obj(help='"PodOS defines the OS parameters of a pod."'),
          os: {
            '#withName':: d.fn(help='"Name is the name of the operating system. The currently supported values are linux and windows. Additional value may be defined in future and can be one of: https://github.com/opencontainers/runtime-spec/blob/master/config.md#platform-specific-configuration Clients should expect to handle additional values and treat unrecognized values in this field as os: null"', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { jobTemplate+: { spec+: { template+: { spec+: { os+: { name: name } } } } } },
          },
          '#securityContext':: d.obj(help='"PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext."'),
          securityContext: {
            '#appArmorProfile':: d.obj(help="\"AppArmorProfile defines a pod or container's AppArmor settings.\""),
            appArmorProfile: {
              '#withLocalhostProfile':: d.fn(help='"localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is \\"Localhost\\"."', args=[d.arg(name='localhostProfile', type=d.T.string)]),
              withLocalhostProfile(localhostProfile): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { appArmorProfile+: { localhostProfile: localhostProfile } } } } } } },
              '#withType':: d.fn(help="\"type indicates which kind of AppArmor profile will be applied. Valid options are:\\n  Localhost - a profile pre-loaded on the node.\\n  RuntimeDefault - the container runtime's default profile.\\n  Unconfined - no AppArmor enforcement.\"", args=[d.arg(name='type', type=d.T.string)]),
              withType(type): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { appArmorProfile+: { type: type } } } } } } },
            },
            '#seLinuxOptions':: d.obj(help='"SELinuxOptions are the labels to be applied to the container"'),
            seLinuxOptions: {
              '#withLevel':: d.fn(help='"Level is SELinux level label that applies to the container."', args=[d.arg(name='level', type=d.T.string)]),
              withLevel(level): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { level: level } } } } } } },
              '#withRole':: d.fn(help='"Role is a SELinux role label that applies to the container."', args=[d.arg(name='role', type=d.T.string)]),
              withRole(role): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { role: role } } } } } } },
              '#withType':: d.fn(help='"Type is a SELinux type label that applies to the container."', args=[d.arg(name='type', type=d.T.string)]),
              withType(type): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { type: type } } } } } } },
              '#withUser':: d.fn(help='"User is a SELinux user label that applies to the container."', args=[d.arg(name='user', type=d.T.string)]),
              withUser(user): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { user: user } } } } } } },
            },
            '#seccompProfile':: d.obj(help="\"SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set.\""),
            seccompProfile: {
              '#withLocalhostProfile':: d.fn(help="\"localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must be set if type is \\\"Localhost\\\". Must NOT be set for any other type.\"", args=[d.arg(name='localhostProfile', type=d.T.string)]),
              withLocalhostProfile(localhostProfile): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { seccompProfile+: { localhostProfile: localhostProfile } } } } } } },
              '#withType':: d.fn(help='"type indicates which kind of seccomp profile will be applied. Valid options are:\\n\\nLocalhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied."', args=[d.arg(name='type', type=d.T.string)]),
              withType(type): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { seccompProfile+: { type: type } } } } } } },
            },
            '#windowsOptions':: d.obj(help='"WindowsSecurityContextOptions contain Windows-specific options and credentials."'),
            windowsOptions: {
              '#withGmsaCredentialSpec':: d.fn(help='"GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field."', args=[d.arg(name='gmsaCredentialSpec', type=d.T.string)]),
              withGmsaCredentialSpec(gmsaCredentialSpec): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { gmsaCredentialSpec: gmsaCredentialSpec } } } } } } },
              '#withGmsaCredentialSpecName':: d.fn(help='"GMSACredentialSpecName is the name of the GMSA credential spec to use."', args=[d.arg(name='gmsaCredentialSpecName', type=d.T.string)]),
              withGmsaCredentialSpecName(gmsaCredentialSpecName): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { gmsaCredentialSpecName: gmsaCredentialSpecName } } } } } } },
              '#withHostProcess':: d.fn(help="\"HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.\"", args=[d.arg(name='hostProcess', type=d.T.boolean)]),
              withHostProcess(hostProcess): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { hostProcess: hostProcess } } } } } } },
              '#withRunAsUserName':: d.fn(help='"The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence."', args=[d.arg(name='runAsUserName', type=d.T.string)]),
              withRunAsUserName(runAsUserName): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { runAsUserName: runAsUserName } } } } } } },
            },
            '#withFsGroup':: d.fn(help="\"A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\\n\\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\\n\\nIf unset, the Kubelet will not modify the ownership and permissions of any volume. Note that this field cannot be set when spec.os.name is windows.\"", args=[d.arg(name='fsGroup', type=d.T.integer)]),
            withFsGroup(fsGroup): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { fsGroup: fsGroup } } } } } },
            '#withFsGroupChangePolicy':: d.fn(help='"fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are \\"OnRootMismatch\\" and \\"Always\\". If not specified, \\"Always\\" is used. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='fsGroupChangePolicy', type=d.T.string)]),
            withFsGroupChangePolicy(fsGroupChangePolicy): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { fsGroupChangePolicy: fsGroupChangePolicy } } } } } },
            '#withRunAsGroup':: d.fn(help='"The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='runAsGroup', type=d.T.integer)]),
            withRunAsGroup(runAsGroup): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { runAsGroup: runAsGroup } } } } } },
            '#withRunAsNonRoot':: d.fn(help='"Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence."', args=[d.arg(name='runAsNonRoot', type=d.T.boolean)]),
            withRunAsNonRoot(runAsNonRoot): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { runAsNonRoot: runAsNonRoot } } } } } },
            '#withRunAsUser':: d.fn(help='"The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='runAsUser', type=d.T.integer)]),
            withRunAsUser(runAsUser): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { runAsUser: runAsUser } } } } } },
            '#withSupplementalGroups':: d.fn(help="\"A list of groups applied to the first process run in each container, in addition to the container's primary GID, the fsGroup (if specified), and group memberships defined in the container image for the uid of the container process. If unspecified, no additional groups are added to any container. Note that group memberships defined in the container image for the uid of the container process are still effective, even if they are not included in this list. Note that this field cannot be set when spec.os.name is windows.\"", args=[d.arg(name='supplementalGroups', type=d.T.array)]),
            withSupplementalGroups(supplementalGroups): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { supplementalGroups: if std.isArray(v=supplementalGroups) then supplementalGroups else [supplementalGroups] } } } } } },
            '#withSupplementalGroupsMixin':: d.fn(help="\"A list of groups applied to the first process run in each container, in addition to the container's primary GID, the fsGroup (if specified), and group memberships defined in the container image for the uid of the container process. If unspecified, no additional groups are added to any container. Note that group memberships defined in the container image for the uid of the container process are still effective, even if they are not included in this list. Note that this field cannot be set when spec.os.name is windows.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='supplementalGroups', type=d.T.array)]),
            withSupplementalGroupsMixin(supplementalGroups): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { supplementalGroups+: if std.isArray(v=supplementalGroups) then supplementalGroups else [supplementalGroups] } } } } } },
            '#withSysctls':: d.fn(help='"Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='sysctls', type=d.T.array)]),
            withSysctls(sysctls): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { sysctls: if std.isArray(v=sysctls) then sysctls else [sysctls] } } } } } },
            '#withSysctlsMixin':: d.fn(help='"Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='sysctls', type=d.T.array)]),
            withSysctlsMixin(sysctls): { jobTemplate+: { spec+: { template+: { spec+: { securityContext+: { sysctls+: if std.isArray(v=sysctls) then sysctls else [sysctls] } } } } } },
          },
          '#withActiveDeadlineSeconds':: d.fn(help='"Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer."', args=[d.arg(name='activeDeadlineSeconds', type=d.T.integer)]),
          withActiveDeadlineSeconds(activeDeadlineSeconds): { jobTemplate+: { spec+: { template+: { spec+: { activeDeadlineSeconds: activeDeadlineSeconds } } } } },
          '#withAutomountServiceAccountToken':: d.fn(help='"AutomountServiceAccountToken indicates whether a service account token should be automatically mounted."', args=[d.arg(name='automountServiceAccountToken', type=d.T.boolean)]),
          withAutomountServiceAccountToken(automountServiceAccountToken): { jobTemplate+: { spec+: { template+: { spec+: { automountServiceAccountToken: automountServiceAccountToken } } } } },
          '#withContainers':: d.fn(help='"List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated."', args=[d.arg(name='containers', type=d.T.array)]),
          withContainers(containers): { jobTemplate+: { spec+: { template+: { spec+: { containers: if std.isArray(v=containers) then containers else [containers] } } } } },
          '#withContainersMixin':: d.fn(help='"List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='containers', type=d.T.array)]),
          withContainersMixin(containers): { jobTemplate+: { spec+: { template+: { spec+: { containers+: if std.isArray(v=containers) then containers else [containers] } } } } },
          '#withDnsPolicy':: d.fn(help="\"Set DNS policy for the pod. Defaults to \\\"ClusterFirst\\\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.\"", args=[d.arg(name='dnsPolicy', type=d.T.string)]),
          withDnsPolicy(dnsPolicy): { jobTemplate+: { spec+: { template+: { spec+: { dnsPolicy: dnsPolicy } } } } },
          '#withEnableServiceLinks':: d.fn(help="\"EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.\"", args=[d.arg(name='enableServiceLinks', type=d.T.boolean)]),
          withEnableServiceLinks(enableServiceLinks): { jobTemplate+: { spec+: { template+: { spec+: { enableServiceLinks: enableServiceLinks } } } } },
          '#withEphemeralContainers':: d.fn(help="\"List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource.\"", args=[d.arg(name='ephemeralContainers', type=d.T.array)]),
          withEphemeralContainers(ephemeralContainers): { jobTemplate+: { spec+: { template+: { spec+: { ephemeralContainers: if std.isArray(v=ephemeralContainers) then ephemeralContainers else [ephemeralContainers] } } } } },
          '#withEphemeralContainersMixin':: d.fn(help="\"List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='ephemeralContainers', type=d.T.array)]),
          withEphemeralContainersMixin(ephemeralContainers): { jobTemplate+: { spec+: { template+: { spec+: { ephemeralContainers+: if std.isArray(v=ephemeralContainers) then ephemeralContainers else [ephemeralContainers] } } } } },
          '#withHostAliases':: d.fn(help="\"HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.\"", args=[d.arg(name='hostAliases', type=d.T.array)]),
          withHostAliases(hostAliases): { jobTemplate+: { spec+: { template+: { spec+: { hostAliases: if std.isArray(v=hostAliases) then hostAliases else [hostAliases] } } } } },
          '#withHostAliasesMixin':: d.fn(help="\"HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='hostAliases', type=d.T.array)]),
          withHostAliasesMixin(hostAliases): { jobTemplate+: { spec+: { template+: { spec+: { hostAliases+: if std.isArray(v=hostAliases) then hostAliases else [hostAliases] } } } } },
          '#withHostIPC':: d.fn(help="\"Use the host's ipc namespace. Optional: Default to false.\"", args=[d.arg(name='hostIPC', type=d.T.boolean)]),
          withHostIPC(hostIPC): { jobTemplate+: { spec+: { template+: { spec+: { hostIPC: hostIPC } } } } },
          '#withHostNetwork':: d.fn(help="\"Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.\"", args=[d.arg(name='hostNetwork', type=d.T.boolean)]),
          withHostNetwork(hostNetwork): { jobTemplate+: { spec+: { template+: { spec+: { hostNetwork: hostNetwork } } } } },
          '#withHostPID':: d.fn(help="\"Use the host's pid namespace. Optional: Default to false.\"", args=[d.arg(name='hostPID', type=d.T.boolean)]),
          withHostPID(hostPID): { jobTemplate+: { spec+: { template+: { spec+: { hostPID: hostPID } } } } },
          '#withHostUsers':: d.fn(help="\"Use the host's user namespace. Optional: Default to true. If set to true or not present, the pod will be run in the host user namespace, useful for when the pod needs a feature only available to the host user namespace, such as loading a kernel module with CAP_SYS_MODULE. When set to false, a new userns is created for the pod. Setting false is useful for mitigating container breakout vulnerabilities even allowing users to run their containers as root without actually having root privileges on the host. This field is alpha-level and is only honored by servers that enable the UserNamespacesSupport feature.\"", args=[d.arg(name='hostUsers', type=d.T.boolean)]),
          withHostUsers(hostUsers): { jobTemplate+: { spec+: { template+: { spec+: { hostUsers: hostUsers } } } } },
          '#withHostname':: d.fn(help="\"Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.\"", args=[d.arg(name='hostname', type=d.T.string)]),
          withHostname(hostname): { jobTemplate+: { spec+: { template+: { spec+: { hostname: hostname } } } } },
          '#withImagePullSecrets':: d.fn(help='"ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod"', args=[d.arg(name='imagePullSecrets', type=d.T.array)]),
          withImagePullSecrets(imagePullSecrets): { jobTemplate+: { spec+: { template+: { spec+: { imagePullSecrets: if std.isArray(v=imagePullSecrets) then imagePullSecrets else [imagePullSecrets] } } } } },
          '#withImagePullSecretsMixin':: d.fn(help='"ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='imagePullSecrets', type=d.T.array)]),
          withImagePullSecretsMixin(imagePullSecrets): { jobTemplate+: { spec+: { template+: { spec+: { imagePullSecrets+: if std.isArray(v=imagePullSecrets) then imagePullSecrets else [imagePullSecrets] } } } } },
          '#withInitContainers':: d.fn(help='"List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/"', args=[d.arg(name='initContainers', type=d.T.array)]),
          withInitContainers(initContainers): { jobTemplate+: { spec+: { template+: { spec+: { initContainers: if std.isArray(v=initContainers) then initContainers else [initContainers] } } } } },
          '#withInitContainersMixin':: d.fn(help='"List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='initContainers', type=d.T.array)]),
          withInitContainersMixin(initContainers): { jobTemplate+: { spec+: { template+: { spec+: { initContainers+: if std.isArray(v=initContainers) then initContainers else [initContainers] } } } } },
          '#withNodeName':: d.fn(help='"NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements."', args=[d.arg(name='nodeName', type=d.T.string)]),
          withNodeName(nodeName): { jobTemplate+: { spec+: { template+: { spec+: { nodeName: nodeName } } } } },
          '#withNodeSelector':: d.fn(help="\"NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\"", args=[d.arg(name='nodeSelector', type=d.T.object)]),
          withNodeSelector(nodeSelector): { jobTemplate+: { spec+: { template+: { spec+: { nodeSelector: nodeSelector } } } } },
          '#withNodeSelectorMixin':: d.fn(help="\"NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='nodeSelector', type=d.T.object)]),
          withNodeSelectorMixin(nodeSelector): { jobTemplate+: { spec+: { template+: { spec+: { nodeSelector+: nodeSelector } } } } },
          '#withOverhead':: d.fn(help='"Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md"', args=[d.arg(name='overhead', type=d.T.object)]),
          withOverhead(overhead): { jobTemplate+: { spec+: { template+: { spec+: { overhead: overhead } } } } },
          '#withOverheadMixin':: d.fn(help='"Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='overhead', type=d.T.object)]),
          withOverheadMixin(overhead): { jobTemplate+: { spec+: { template+: { spec+: { overhead+: overhead } } } } },
          '#withPreemptionPolicy':: d.fn(help='"PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset."', args=[d.arg(name='preemptionPolicy', type=d.T.string)]),
          withPreemptionPolicy(preemptionPolicy): { jobTemplate+: { spec+: { template+: { spec+: { preemptionPolicy: preemptionPolicy } } } } },
          '#withPriority':: d.fn(help='"The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority."', args=[d.arg(name='priority', type=d.T.integer)]),
          withPriority(priority): { jobTemplate+: { spec+: { template+: { spec+: { priority: priority } } } } },
          '#withPriorityClassName':: d.fn(help="\"If specified, indicates the pod's priority. \\\"system-node-critical\\\" and \\\"system-cluster-critical\\\" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.\"", args=[d.arg(name='priorityClassName', type=d.T.string)]),
          withPriorityClassName(priorityClassName): { jobTemplate+: { spec+: { template+: { spec+: { priorityClassName: priorityClassName } } } } },
          '#withReadinessGates':: d.fn(help='"If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \\"True\\" More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates"', args=[d.arg(name='readinessGates', type=d.T.array)]),
          withReadinessGates(readinessGates): { jobTemplate+: { spec+: { template+: { spec+: { readinessGates: if std.isArray(v=readinessGates) then readinessGates else [readinessGates] } } } } },
          '#withReadinessGatesMixin':: d.fn(help='"If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \\"True\\" More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='readinessGates', type=d.T.array)]),
          withReadinessGatesMixin(readinessGates): { jobTemplate+: { spec+: { template+: { spec+: { readinessGates+: if std.isArray(v=readinessGates) then readinessGates else [readinessGates] } } } } },
          '#withResourceClaims':: d.fn(help='"ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.\\n\\nThis is an alpha field and requires enabling the DynamicResourceAllocation feature gate.\\n\\nThis field is immutable."', args=[d.arg(name='resourceClaims', type=d.T.array)]),
          withResourceClaims(resourceClaims): { jobTemplate+: { spec+: { template+: { spec+: { resourceClaims: if std.isArray(v=resourceClaims) then resourceClaims else [resourceClaims] } } } } },
          '#withResourceClaimsMixin':: d.fn(help='"ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.\\n\\nThis is an alpha field and requires enabling the DynamicResourceAllocation feature gate.\\n\\nThis field is immutable."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='resourceClaims', type=d.T.array)]),
          withResourceClaimsMixin(resourceClaims): { jobTemplate+: { spec+: { template+: { spec+: { resourceClaims+: if std.isArray(v=resourceClaims) then resourceClaims else [resourceClaims] } } } } },
          '#withRestartPolicy':: d.fn(help='"Restart policy for all containers within the pod. One of Always, OnFailure, Never. In some contexts, only a subset of those values may be permitted. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy"', args=[d.arg(name='restartPolicy', type=d.T.string)]),
          withRestartPolicy(restartPolicy): { jobTemplate+: { spec+: { template+: { spec+: { restartPolicy: restartPolicy } } } } },
          '#withRuntimeClassName':: d.fn(help='"RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the \\"legacy\\" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class"', args=[d.arg(name='runtimeClassName', type=d.T.string)]),
          withRuntimeClassName(runtimeClassName): { jobTemplate+: { spec+: { template+: { spec+: { runtimeClassName: runtimeClassName } } } } },
          '#withSchedulerName':: d.fn(help='"If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler."', args=[d.arg(name='schedulerName', type=d.T.string)]),
          withSchedulerName(schedulerName): { jobTemplate+: { spec+: { template+: { spec+: { schedulerName: schedulerName } } } } },
          '#withSchedulingGates':: d.fn(help='"SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.\\n\\nSchedulingGates can only be set at pod creation time, and be removed only afterwards."', args=[d.arg(name='schedulingGates', type=d.T.array)]),
          withSchedulingGates(schedulingGates): { jobTemplate+: { spec+: { template+: { spec+: { schedulingGates: if std.isArray(v=schedulingGates) then schedulingGates else [schedulingGates] } } } } },
          '#withSchedulingGatesMixin':: d.fn(help='"SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.\\n\\nSchedulingGates can only be set at pod creation time, and be removed only afterwards."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='schedulingGates', type=d.T.array)]),
          withSchedulingGatesMixin(schedulingGates): { jobTemplate+: { spec+: { template+: { spec+: { schedulingGates+: if std.isArray(v=schedulingGates) then schedulingGates else [schedulingGates] } } } } },
          '#withServiceAccount':: d.fn(help='"DeprecatedServiceAccount is a deprecated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead."', args=[d.arg(name='serviceAccount', type=d.T.string)]),
          withServiceAccount(serviceAccount): { jobTemplate+: { spec+: { template+: { spec+: { serviceAccount: serviceAccount } } } } },
          '#withServiceAccountName':: d.fn(help='"ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/"', args=[d.arg(name='serviceAccountName', type=d.T.string)]),
          withServiceAccountName(serviceAccountName): { jobTemplate+: { spec+: { template+: { spec+: { serviceAccountName: serviceAccountName } } } } },
          '#withSetHostnameAsFQDN':: d.fn(help="\"If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\\\SYSTEM\\\\CurrentControlSet\\\\Services\\\\Tcpip\\\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.\"", args=[d.arg(name='setHostnameAsFQDN', type=d.T.boolean)]),
          withSetHostnameAsFQDN(setHostnameAsFQDN): { jobTemplate+: { spec+: { template+: { spec+: { setHostnameAsFQDN: setHostnameAsFQDN } } } } },
          '#withShareProcessNamespace':: d.fn(help='"Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false."', args=[d.arg(name='shareProcessNamespace', type=d.T.boolean)]),
          withShareProcessNamespace(shareProcessNamespace): { jobTemplate+: { spec+: { template+: { spec+: { shareProcessNamespace: shareProcessNamespace } } } } },
          '#withSubdomain':: d.fn(help='"If specified, the fully qualified Pod hostname will be \\"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\\". If not specified, the pod will not have a domainname at all."', args=[d.arg(name='subdomain', type=d.T.string)]),
          withSubdomain(subdomain): { jobTemplate+: { spec+: { template+: { spec+: { subdomain: subdomain } } } } },
          '#withTerminationGracePeriodSeconds':: d.fn(help='"Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds."', args=[d.arg(name='terminationGracePeriodSeconds', type=d.T.integer)]),
          withTerminationGracePeriodSeconds(terminationGracePeriodSeconds): { jobTemplate+: { spec+: { template+: { spec+: { terminationGracePeriodSeconds: terminationGracePeriodSeconds } } } } },
          '#withTolerations':: d.fn(help="\"If specified, the pod's tolerations.\"", args=[d.arg(name='tolerations', type=d.T.array)]),
          withTolerations(tolerations): { jobTemplate+: { spec+: { template+: { spec+: { tolerations: if std.isArray(v=tolerations) then tolerations else [tolerations] } } } } },
          '#withTolerationsMixin':: d.fn(help="\"If specified, the pod's tolerations.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='tolerations', type=d.T.array)]),
          withTolerationsMixin(tolerations): { jobTemplate+: { spec+: { template+: { spec+: { tolerations+: if std.isArray(v=tolerations) then tolerations else [tolerations] } } } } },
          '#withTopologySpreadConstraints':: d.fn(help='"TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed."', args=[d.arg(name='topologySpreadConstraints', type=d.T.array)]),
          withTopologySpreadConstraints(topologySpreadConstraints): { jobTemplate+: { spec+: { template+: { spec+: { topologySpreadConstraints: if std.isArray(v=topologySpreadConstraints) then topologySpreadConstraints else [topologySpreadConstraints] } } } } },
          '#withTopologySpreadConstraintsMixin':: d.fn(help='"TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='topologySpreadConstraints', type=d.T.array)]),
          withTopologySpreadConstraintsMixin(topologySpreadConstraints): { jobTemplate+: { spec+: { template+: { spec+: { topologySpreadConstraints+: if std.isArray(v=topologySpreadConstraints) then topologySpreadConstraints else [topologySpreadConstraints] } } } } },
          '#withVolumes':: d.fn(help='"List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes"', args=[d.arg(name='volumes', type=d.T.array)]),
          withVolumes(volumes): { jobTemplate+: { spec+: { template+: { spec+: { volumes: if std.isArray(v=volumes) then volumes else [volumes] } } } } },
          '#withVolumesMixin':: d.fn(help='"List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='volumes', type=d.T.array)]),
          withVolumesMixin(volumes): { jobTemplate+: { spec+: { template+: { spec+: { volumes+: if std.isArray(v=volumes) then volumes else [volumes] } } } } },
        },
      },
      '#withActiveDeadlineSeconds':: d.fn(help='"Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again."', args=[d.arg(name='activeDeadlineSeconds', type=d.T.integer)]),
      withActiveDeadlineSeconds(activeDeadlineSeconds): { jobTemplate+: { spec+: { activeDeadlineSeconds: activeDeadlineSeconds } } },
      '#withBackoffLimit':: d.fn(help='"Specifies the number of retries before marking this job failed. Defaults to 6"', args=[d.arg(name='backoffLimit', type=d.T.integer)]),
      withBackoffLimit(backoffLimit): { jobTemplate+: { spec+: { backoffLimit: backoffLimit } } },
      '#withBackoffLimitPerIndex':: d.fn(help="\"Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).\"", args=[d.arg(name='backoffLimitPerIndex', type=d.T.integer)]),
      withBackoffLimitPerIndex(backoffLimitPerIndex): { jobTemplate+: { spec+: { backoffLimitPerIndex: backoffLimitPerIndex } } },
      '#withCompletionMode':: d.fn(help="\"completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.\\n\\n`NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.\\n\\n`Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.\\n\\nMore completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.\"", args=[d.arg(name='completionMode', type=d.T.string)]),
      withCompletionMode(completionMode): { jobTemplate+: { spec+: { completionMode: completionMode } } },
      '#withCompletions':: d.fn(help='"Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/"', args=[d.arg(name='completions', type=d.T.integer)]),
      withCompletions(completions): { jobTemplate+: { spec+: { completions: completions } } },
      '#withManagedBy':: d.fn(help="\"ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first \\\"/\\\" must be a valid subdomain as defined by RFC 1123. All characters trailing the first \\\"/\\\" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 64 characters.\\n\\nThis field is alpha-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (disabled by default).\"", args=[d.arg(name='managedBy', type=d.T.string)]),
      withManagedBy(managedBy): { jobTemplate+: { spec+: { managedBy: managedBy } } },
      '#withManualSelector':: d.fn(help='"manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector"', args=[d.arg(name='manualSelector', type=d.T.boolean)]),
      withManualSelector(manualSelector): { jobTemplate+: { spec+: { manualSelector: manualSelector } } },
      '#withMaxFailedIndexes':: d.fn(help='"Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default)."', args=[d.arg(name='maxFailedIndexes', type=d.T.integer)]),
      withMaxFailedIndexes(maxFailedIndexes): { jobTemplate+: { spec+: { maxFailedIndexes: maxFailedIndexes } } },
      '#withParallelism':: d.fn(help='"Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/"', args=[d.arg(name='parallelism', type=d.T.integer)]),
      withParallelism(parallelism): { jobTemplate+: { spec+: { parallelism: parallelism } } },
      '#withPodReplacementPolicy':: d.fn(help='"podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods\\n  when they are terminating (has a metadata.deletionTimestamp) or failed.\\n- Failed means to wait until a previously created Pod is fully terminated (has phase\\n  Failed or Succeeded) before creating a replacement Pod.\\n\\nWhen using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default."', args=[d.arg(name='podReplacementPolicy', type=d.T.string)]),
      withPodReplacementPolicy(podReplacementPolicy): { jobTemplate+: { spec+: { podReplacementPolicy: podReplacementPolicy } } },
      '#withSuspend':: d.fn(help='"suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false."', args=[d.arg(name='suspend', type=d.T.boolean)]),
      withSuspend(suspend): { jobTemplate+: { spec+: { suspend: suspend } } },
      '#withTtlSecondsAfterFinished':: d.fn(help="\"ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.\"", args=[d.arg(name='ttlSecondsAfterFinished', type=d.T.integer)]),
      withTtlSecondsAfterFinished(ttlSecondsAfterFinished): { jobTemplate+: { spec+: { ttlSecondsAfterFinished: ttlSecondsAfterFinished } } },
    },
  },
  '#withConcurrencyPolicy':: d.fn(help="\"Specifies how to treat concurrent executions of a Job. Valid values are:\\n\\n- \\\"Allow\\\" (default): allows CronJobs to run concurrently; - \\\"Forbid\\\": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - \\\"Replace\\\": cancels currently running job and replaces it with a new one\"", args=[d.arg(name='concurrencyPolicy', type=d.T.string)]),
  withConcurrencyPolicy(concurrencyPolicy): { concurrencyPolicy: concurrencyPolicy },
  '#withFailedJobsHistoryLimit':: d.fn(help='"The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1."', args=[d.arg(name='failedJobsHistoryLimit', type=d.T.integer)]),
  withFailedJobsHistoryLimit(failedJobsHistoryLimit): { failedJobsHistoryLimit: failedJobsHistoryLimit },
  '#withSchedule':: d.fn(help='"The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron."', args=[d.arg(name='schedule', type=d.T.string)]),
  withSchedule(schedule): { schedule: schedule },
  '#withStartingDeadlineSeconds':: d.fn(help='"Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones."', args=[d.arg(name='startingDeadlineSeconds', type=d.T.integer)]),
  withStartingDeadlineSeconds(startingDeadlineSeconds): { startingDeadlineSeconds: startingDeadlineSeconds },
  '#withSuccessfulJobsHistoryLimit':: d.fn(help='"The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3."', args=[d.arg(name='successfulJobsHistoryLimit', type=d.T.integer)]),
  withSuccessfulJobsHistoryLimit(successfulJobsHistoryLimit): { successfulJobsHistoryLimit: successfulJobsHistoryLimit },
  '#withSuspend':: d.fn(help='"This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false."', args=[d.arg(name='suspend', type=d.T.boolean)]),
  withSuspend(suspend): { suspend: suspend },
  '#withTimeZone':: d.fn(help='"The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones"', args=[d.arg(name='timeZone', type=d.T.string)]),
  withTimeZone(timeZone): { timeZone: timeZone },
  '#mixin': 'ignore',
  mixin: self,
}
