# v0.6.x changelogs

## v0.6.0

[v0.6.0](https://github.com/hofstadter-io/hof/compare/v0.5.17...v0.6.0)

- general cleanup, bugfixing, refactoring
- rework `hof gen` schemas
- remove some disjunctions in schema to improve performance
- better error messages
- enable subgenerators

## v0.6.1

[v0.6.0...v0.6.1](https://github.com/hofstadter-io/hof/compare/v0.6.0...v0.6.1)

### hof datamodel

hof datamodel is a tool to manage your models.
Define, validate, checkpoint, diff, and migrate.

See the following to learn more:

- `hof datamodel -h`
- [getting-started/data-modeling](https://docs.hofstadter.io/getting-started/data-modeling/)
- [reference/hof-datamodel](https://docs.hofstadter.io/reference/hof-datamodel/)

### Other

- data files from generators
- various bugfixes
- cleanup and legacy code removal

## v0.6.2

[v0.6.1...v0.6.2](https://github.com/hofstadter-io/hof/compare/v0.6.1...v0.6.2)

### hof flow

hof flow is a custom cue/flow runtime with more task types.

See the following to learn more:

- `hof flow -h`
- [getting-started/data-flow](https://docs.hofstadter.io/getting-started/data-flow/)
- [reference/hof-flow](https://docs.hofstadter.io/reference/hof-flow/)

### Other

- CUE v0.4.3
- Go v1.18
- other dep updates
- various bugfixes


## v0.6.3

[v0.6.2...v0.6.3](https://github.com/hofstadter-io/hof/compare/v0.6.2...v0.6.3)

### hof gen adhoc mode

Adds flags to `hof gen` to support adhoc code gen,
so you do not need to setup a generator to use.

- `--template`/`-T` flag to specify templates, input data, schemas, and output files
- `--partial`/`-P` flag to support adhoc partial templates
- `--watch`/`-w` flag to suport watching globs and regenerating (also works for generators)
- `--as-module` flag turns your other flags into a reusable and sharable generator module
- `--init` flag bootstraps a new modular generator in the current directory

The `-T` flag has a flexible format so you can
supply multiple templates and control the data.
It lets you specify the mapping from template
to input & schema, to output filepath.

```
hof gen data.cue -T template.txt
hof gen data.yaml schema.cue -T template.txt > output.txt
```

See the following to learn more

- `hof gen -h`
- [hof demos](https://github.com/hofstadter-io/demos)
- [code-generation/file-rendering](https://docs.hofstadter.io/code-generation/file-rendering/)
- [code-generation/type-rendering](https://docs.hofstadter.io/code-generation/type-rendering/)
- [reference/hof-gen/adhoc-file-gen](https://docs.hofstadter.io/reference/hof-gen/adhoc-file-gen/)

### Other

- added `dict` to template helpers to create maps, useful for passing more than one arg to a partial template
- added `pascal` template helper for string casing
- load data with CUE code, more inline with `cue`
- (bug) remove some shell completetion hacks
- more tests, bugfixes, and dep updates
- some small changes to the datamodel schema, namely attribute change to prep for enhancemnts

## v0.6.4

[v0.6.3...v0.6.4](https://github.com/hofstadter-io/hof/compare/v0.6.3...v0.6.4)

Bugfix and cleanup

- The `and` template helper was custom, wrong, and needed to be removed. This is the primary reason for the release.
- Removed many template helpers which overrode or duplicated Go's, or did not make sense or seemed unusual.
- Add newline when writing generator outputs, ending on a curly brace seemed odd.
- Update almost all deps, remove some others, need Go 1.17 to go out of fasion before rest can be... generics and breaking changes in deps...

