package cmd

import (
	"github.com/helmfile/helmfile/pkg/app"
	"github.com/helmfile/helmfile/pkg/config"
	"github.com/urfave/cli"
)

func addTemplateSubcommand(cliApp *cli.App) {
	cliApp.Commands = append(cliApp.Commands, cli.Command{
		Name:  "template",
		Usage: "template releases from state file against env (helm template)",
		Flags: []cli.Flag{
			cli.StringFlag{
				Name:  "args",
				Value: "",
				Usage: "pass args to helm template",
			},
			cli.StringSliceFlag{
				Name:  "set",
				Usage: "additional values to be merged into the command",
			},
			cli.StringSliceFlag{
				Name:  "values",
				Usage: "additional value files to be merged into the command",
			},
			cli.StringFlag{
				Name:  "output-dir",
				Usage: "output directory to pass to helm template (helm template --output-dir)",
			},
			cli.StringFlag{
				Name:  "output-dir-template",
				Usage: "go text template for generating the output directory. Default: {{ .OutputDir }}/{{ .State.BaseName }}-{{ .State.AbsPathSHA1 }}-{{ .Release.Name}}",
			},
			cli.IntFlag{
				Name:  "concurrency",
				Value: 0,
				Usage: "maximum number of concurrent downloads of release charts",
			},
			cli.BoolFlag{
				Name:  "validate",
				Usage: "validate your manifests against the Kubernetes cluster you are currently pointing at. Note that this requiers access to a Kubernetes cluster to obtain information necessary for validating, like the list of available API versions",
			},
			cli.BoolFlag{
				Name:  "include-crds",
				Usage: "include CRDs in the templated output",
			},
			cli.BoolFlag{
				Name:  "skip-tests",
				Usage: "skip tests from templated output",
			},
			cli.BoolFlag{
				Name:  "skip-needs",
				Usage: `do not automatically include releases from the target release's "needs" when --selector/-l flag is provided. Does nothing when when --selector/-l flag is not provided. Defaults to true when --include-needs or --include-transitive-needs is not provided`,
			},
			cli.BoolFlag{
				Name:  "include-needs",
				Usage: `automatically include releases from the target release's "needs" when --selector/-l flag is provided. Does nothing when when --selector/-l flag is not provided`,
			},
			cli.BoolFlag{
				Name:  "include-transitive-needs",
				Usage: `like --include-needs, but also includes transitive needs (needs of needs). Does nothing when when --selector/-l flag is not provided. Overrides exclusions of other selectors and conditions.`,
			},
			cli.BoolFlag{
				Name:  "skip-deps",
				Usage: `skip running "helm repo update" and "helm dependency build"`,
			},
			cli.BoolFlag{
				Name:  "skip-cleanup",
				Usage: "Stop cleaning up temporary values generated by helmfile and helm-secrets. Useful for debugging. Don't use in production for security",
			},
		},
		Action: Action(func(a *app.App, c config.ConfigImpl) error {
			return a.Template(c)
		}),
	})
}
