---
layout: "docs"
page_title: "MongoDB - Secrets Engines"
sidebar_title: "MongoDB <sup>DEPRECATED</sup>"
sidebar_current: "docs-secrets-mongodb"
description: |-
  The mongodb secrets engine for Vault generates database credentials to access MongoDB.
---

# MongoDB Secrets Engine

~> **Deprecation Note:** This secrets engine is deprecated in favor of the
combined databases secrets engine added in v0.7.1. See the documentation for
the new implementation of this secrets engine at
[MongoDB database plugin](/docs/secrets/databases/mongodb.html).

The `mongodb` secrets engine for Vault generates MongoDB database credentials
dynamically based on configured roles. This means that services that need
to access a MongoDB database no longer need to hard-code credentials: they
can request them from Vault and use Vault's leasing mechanism to more easily
roll them.

Additionally, it introduces a new ability: with every service accessing
the database with unique credentials, it makes auditing much easier when
questionable data access is discovered: you can track it down to the specific
instance of a service based on the MongoDB username.

Vault makes use of its own internal revocation system to ensure that users
become invalid within a reasonable time of the lease expiring.

This page will show a quick start for this secrets engine. For detailed documentation
on every path, use `vault path-help` after mounting the secrets engine.

## Quick Start

The first step to using the mongodb secrets engine is to mount it. Unlike the
`kv` secrets engine, the `mongodb` secrets engine is not mounted by default.

```
$ vault secrets enable mongodb
Success! Enabled the mongodb secrets engine at: mongodb/
```

Next, we must tell Vault how to connect to MongoDB. This is done by providing
a standard connection string (URI):

```
$ vault write mongodb/config/connection uri="mongodb://admin:Password!@mongodb.acme.com:27017/admin?ssl=true"
Key	Value
---	-----

The following warnings were returned from the Vault server:
* Read access to this endpoint should be controlled via ACLs as it will return the connection URI as it is, including passwords, if any.
```

In this case, we've configured Vault with the username `admin` and password
`Password!`, connecting to an instance at `mongodb.acme.com` on port `27017`
with TLS. The user must have privileges to manage users and their roles in the
databases Vault will manage users in. The built-in role `userAdminAnyDatabase`
is the simplest way to grant the necessary permissions if we want Vault to
manage all users in all databases.

Optionally, we can configure the lease settings for the credentials generated
by Vault. This is done by writing to the `config/lease` key:

```
$ vault write mongodb/config/lease ttl=1h max_ttl=24h
Success! Data written to: mongodb/config/lease
```

This restricts each user to being valid or leased for 1 hour at a time, with
a maximum total use period of 24 hours. This forces an application to renew
its credentials at least hourly and to recycle them once per day.

The next step is to configure a role. A role is a logical name that maps
to a policy used to generate MongoDB credentials for that role.

Note that MongoDB also uses roles. The roles you define in Vault are distinct
from the built-in and user-defined roles in MongoDB. In fact, when defining
a Vault role you may specify the MongoDB roles that should be assigned to
users created for that Vault role.

For example, let's create a "readonly" role:

```
$ vault write mongodb/roles/readonly db=foo roles='[ "readWrite", { "role": "read", "db": "bar" } ]'
Success! Data written to: mongodb/roles/readonly
```

By writing to the `roles/readonly` path we are defining the `readonly` role.
Each time Vault is asked for credentials for this role, it will create a
user in the specified MongoDB database with the MongoDB roles provided. The
username and password of each user created will be dynamically generated by
Vault. Just like when creating a user directly using `db.createUser`, the
`roles` JSON array can specify both built-in roles and user-defined roles
for both the database the user is created in and for other databases. Please
consult the MongoDB documentation for more details on Role-Based Access
Control in MongoDB. In this example, Vault will create a user in the `foo`
database with the `readWrite` built-in role on that database and the `read`
built-in role on the `bar` database.

To generate a new set of credentials for a given role, we simply read from
the credentials path for that role:

```
$ vault read mongodb/creds/readonly
Key                Value
---                -----
lease_id           mongodb/creds/readonly/91685212-3040-7dde-48b1-df997c5dc8e7
lease_duration     3600
lease_renewable    true
db                 foo
password           c3faa86d-0f93-9649-de91-c431765e62dd
username           vault-token-48729def-b0ca-2b17-d7b9-3ca7cb86f0ae
```

By reading from the `creds/readonly` path, Vault has generated a new set of
credentials using the `readonly` role configuration. Here we see the
dynamically generated username and password, along with a one hour lease.

Using ACLs, it is possible to restrict using the `mongodb` secrets engine such that
trusted operators can manage the role definitions, and both users and
applications are restricted in the credentials they are allowed to read.

## API

The MongoDB secrets engine has a full HTTP API. Please see the
[MongoDB secrets engine API](/api/secret/mongodb/index.html) for more
details.
