package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachPolicyFromGroup invokes the ram.DetachPolicyFromGroup API synchronously
// api document: https://help.aliyun.com/api/ram/detachpolicyfromgroup.html
func (client *Client) DetachPolicyFromGroup(request *DetachPolicyFromGroupRequest) (response *DetachPolicyFromGroupResponse, err error) {
	response = CreateDetachPolicyFromGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DetachPolicyFromGroupWithChan invokes the ram.DetachPolicyFromGroup API asynchronously
// api document: https://help.aliyun.com/api/ram/detachpolicyfromgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetachPolicyFromGroupWithChan(request *DetachPolicyFromGroupRequest) (<-chan *DetachPolicyFromGroupResponse, <-chan error) {
	responseChan := make(chan *DetachPolicyFromGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachPolicyFromGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachPolicyFromGroupWithCallback invokes the ram.DetachPolicyFromGroup API asynchronously
// api document: https://help.aliyun.com/api/ram/detachpolicyfromgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetachPolicyFromGroupWithCallback(request *DetachPolicyFromGroupRequest, callback func(response *DetachPolicyFromGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachPolicyFromGroupResponse
		var err error
		defer close(result)
		response, err = client.DetachPolicyFromGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachPolicyFromGroupRequest is the request struct for api DetachPolicyFromGroup
type DetachPolicyFromGroupRequest struct {
	*requests.RpcRequest
	PolicyType string `position:"Query" name:"PolicyType"`
	PolicyName string `position:"Query" name:"PolicyName"`
	GroupName  string `position:"Query" name:"GroupName"`
}

// DetachPolicyFromGroupResponse is the response struct for api DetachPolicyFromGroup
type DetachPolicyFromGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachPolicyFromGroupRequest creates a request to invoke DetachPolicyFromGroup API
func CreateDetachPolicyFromGroupRequest() (request *DetachPolicyFromGroupRequest) {
	request = &DetachPolicyFromGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "DetachPolicyFromGroup", "", "")
	return
}

// CreateDetachPolicyFromGroupResponse creates a response to parse from DetachPolicyFromGroup response
func CreateDetachPolicyFromGroupResponse() (response *DetachPolicyFromGroupResponse) {
	response = &DetachPolicyFromGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
