package stdin

import (
	"bufio"
	"errors"
	"io"
	"os"
	"strings"
)

// Read reads input from an stdin pipe.
func Read() (string, error) {
	stat, err := os.Stdin.Stat()
	if err != nil {
		return "", errors.New("failed to get stdin stat")
	}

	if stat.Mode()&os.ModeNamedPipe == 0 && stat.Size() == 0 {
		return "", nil
	}

	reader := bufio.NewReader(os.Stdin)
	var b strings.Builder

	for {
		r, _, err := reader.ReadRune()
		if err != nil && err == io.EOF {
			break
		}
		_, err = b.WriteRune(r)
		if err != nil {
			return "", err
		}
	}

	return b.String(), nil
}
