package vulnerability

import "strings"

const (
	UnknownSeverity Severity = iota
	NegligibleSeverity
	LowSeverity
	MediumSeverity
	HighSeverity
	CriticalSeverity
)

var matcherTypeStr = []string{
	"UnknownSeverity",
	"negligible",
	"low",
	"medium",
	"high",
	"critical",
}

var AllSeverities = []Severity{
	NegligibleSeverity,
	LowSeverity,
	MediumSeverity,
	HighSeverity,
	CriticalSeverity,
}

type Severity int

func (f Severity) String() string {
	if int(f) >= len(matcherTypeStr) || f < 0 {
		return matcherTypeStr[0]
	}

	return matcherTypeStr[f]
}

func ParseSeverity(severity string) Severity {
	switch strings.ToLower(severity) {
	case NegligibleSeverity.String():
		return NegligibleSeverity
	case LowSeverity.String():
		return LowSeverity
	case MediumSeverity.String():
		return MediumSeverity
	case HighSeverity.String():
		return HighSeverity
	case CriticalSeverity.String():
		return CriticalSeverity
	default:
		return UnknownSeverity
	}
}
