package vulnerability

import (
	"fmt"

	grypeDB "github.com/anchore/grype-db/pkg/db/v3"
)

type MetadataStoreAdapter struct {
	store grypeDB.VulnerabilityMetadataStoreReader
}

func NewMetadataStoreProvider(store grypeDB.VulnerabilityMetadataStoreReader) *MetadataStoreAdapter {
	return &MetadataStoreAdapter{
		store: store,
	}
}

func (pr *MetadataStoreAdapter) GetMetadata(id, namespace string) (*Metadata, error) {
	metadata, err := pr.store.GetVulnerabilityMetadata(id, namespace)
	if err != nil {
		return nil, fmt.Errorf("metadata provider failed to fetch id='%s' recordsource='%s': %w", id, namespace, err)
	}

	return NewMetadata(metadata)
}
