---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
description: Learn about feature toggles, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L19 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to enable or disable features in Grafana. You can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation]({{< relref "../_index.md#feature_toggles" >}}). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

## Feature toggles

Some features are enabled by default. You can disable these feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                              | Description                                                                                                                                                                                                                  | Enabled by default |
| ------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`                      | Disable envelope encryption (emergency only)                                                                                                                                                                                 |                    |
| `publicDashboards`                               | Enables public access to dashboards                                                                                                                                                                                          | Yes                |
| `featureHighlights`                              | Highlight Grafana Enterprise features                                                                                                                                                                                        |                    |
| `exploreContentOutline`                          | Content outline sidebar                                                                                                                                                                                                      | Yes                |
| `dataConnectionsConsole`                         | Enables a new top-level page called Connections. This page is an experiment that provides a better experience when you install and configure data sources and other plugins.                                                 | Yes                |
| `cloudWatchCrossAccountQuerying`                 | Enables cross-account querying in CloudWatch datasources                                                                                                                                                                     | Yes                |
| `redshiftAsyncQueryDataSupport`                  | Enable async query data support for Redshift                                                                                                                                                                                 | Yes                |
| `athenaAsyncQueryDataSupport`                    | Enable async query data support for Athena                                                                                                                                                                                   | Yes                |
| `cloudwatchNewRegionsHandler`                    | Refactor of /regions endpoint, no user-facing changes                                                                                                                                                                        | Yes                |
| `nestedFolderPicker`                             | Enables the new folder picker to work with nested folders. Requires the nestedFolders feature toggle                                                                                                                         | Yes                |
| `accessTokenExpirationCheck`                     | Enable OAuth access_token expiration check and token refresh using the refresh_token                                                                                                                                         |                    |
| `emptyDashboardPage`                             | Enable the redesigned user interface of a dashboard page that includes no panels                                                                                                                                             | Yes                |
| `disablePrometheusExemplarSampling`              | Disable Prometheus exemplar sampling                                                                                                                                                                                         |                    |
| `logsContextDatasourceUi`                        | Allow datasource to provide custom UI for context view                                                                                                                                                                       | Yes                |
| `gcomOnlyExternalOrgRoleSync`                    | Prohibits a user from changing organization roles synced with Grafana Cloud auth provider                                                                                                                                    |                    |
| `prometheusMetricEncyclopedia`                   | Adds the metrics explorer component to the Prometheus query builder as an option in metric select                                                                                                                            | Yes                |
| `prometheusDataplane`                            | Changes responses to from Prometheus to be compliant with the dataplane specification. In particular, when this feature toggle is active, the numeric `Field.Name` is set from 'Value' to the value of the `__name__` label. | Yes                |
| `lokiMetricDataplane`                            | Changes metric responses from Loki to be compliant with the dataplane specification.                                                                                                                                         | Yes                |
| `dataplaneFrontendFallback`                      | Support dataplane contract field name change for transformations and field name matchers where the name is different                                                                                                         | Yes                |
| `alertingNotificationsPoliciesMatchingInstances` | Enables the preview of matching instances for notification policies                                                                                                                                                          | Yes                |
| `useCachingService`                              | When active, the new query and resource caching implementation using a wire service inject replaces the previous middleware implementation.                                                                                  |                    |
| `enableElasticsearchBackendQuerying`             | Enable the processing of queries and responses in the Elasticsearch data source through backend                                                                                                                              | Yes                |
| `advancedDataSourcePicker`                       | Enable a new data source picker with contextual information, recently used order and advanced mode                                                                                                                           | Yes                |
| `cloudWatchLogsMonacoEditor`                     | Enables the Monaco editor for CloudWatch Logs queries                                                                                                                                                                        | Yes                |
| `recordedQueriesMulti`                           | Enables writing multiple items from a single query within Recorded Queries                                                                                                                                                   | Yes                |
| `transformationsRedesign`                        | Enables the transformations redesign                                                                                                                                                                                         | Yes                |
| `toggleLabelsInLogsUI`                           | Enable toggleable filters in log details view                                                                                                                                                                                | Yes                |
| `azureMonitorDataplane`                          | Adds dataplane compliant frame metadata in the Azure Monitor datasource                                                                                                                                                      | Yes                |
| `prometheusConfigOverhaulAuth`                   | Update the Prometheus configuration page with the new auth component                                                                                                                                                         | Yes                |
| `newBrowseDashboards`                            | New browse/manage dashboards UI                                                                                                                                                                                              | Yes                |
| `alertingInsights`                               | Show the new alerting insights landing page                                                                                                                                                                                  | Yes                |
| `cloudWatchWildCardDimensionValues`              | Fetches dimension values from CloudWatch to correctly label wildcard dimensions                                                                                                                                              | Yes                |

## Preview feature toggles

| Feature toggle name              | Description                                                                                                                                                                                  |
| -------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `trimDefaults`                   | Use cue schema to remove values that will be applied automatically                                                                                                                           |
| `panelTitleSearch`               | Search for dashboards using panel title                                                                                                                                                      |
| `migrationLocking`               | Lock database during migrations                                                                                                                                                              |
| `correlations`                   | Correlations page                                                                                                                                                                            |
| `newDBLibrary`                   | Use jmoiron/sqlx rather than xorm for a few backend services                                                                                                                                 |
| `autoMigrateOldPanels`           | Migrate old angular panels to supported versions (graph, table-old, worldmap, etc)                                                                                                           |
| `disableAngular`                 | Dynamic flag to disable angular at runtime. The preferred method is to set `angular_support_enabled` to `false` in the [security] settings, which allows you to change the state at runtime. |
| `grpcServer`                     | Run the GRPC server                                                                                                                                                                          |
| `accessControlOnCall`            | Access control primitives for OnCall                                                                                                                                                         |
| `nestedFolders`                  | Enable folder nesting                                                                                                                                                                        |
| `alertingNoNormalState`          | Stop maintaining state of alerts that are not firing                                                                                                                                         |
| `influxdbBackendMigration`       | Query InfluxDB InfluxQL without the proxy                                                                                                                                                    |
| `renderAuthJWT`                  | Uses JWT-based auth for rendering instead of relying on remote cache                                                                                                                         |
| `refactorVariablesTimeRange`     | Refactor time range variables flow to reduce number of API calls made when query variables are chained                                                                                       |
| `faroDatasourceSelector`         | Enable the data source selector within the Frontend Apps section of the Frontend Observability                                                                                               |
| `enableDatagridEditing`          | Enables the edit functionality in the datagrid panel                                                                                                                                         |
| `dataSourcePageHeader`           | Apply new pageHeader UI in data source edit page                                                                                                                                             |
| `sqlDatasourceDatabaseSelection` | Enables previous SQL data source dataset dropdown behavior                                                                                                                                   |
| `awsAsyncQueryCaching`           | Enable caching for async queries for Redshift and Athena. Requires that the `useCachingService` feature toggle is enabled and the datasource has caching and async query support enabled     |
| `splitScopes`                    | Support faster dashboard and folder search by splitting permission scopes into parts                                                                                                         |
| `reportingRetries`               | Enables rendering retries for the reporting feature                                                                                                                                          |

## Experimental feature toggles

These features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Experimental features might be changed or removed without prior notice.

| Feature toggle name                         | Description                                                                                                                                                                                                                                                                       |
| ------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `live-service-web-worker`                   | This will use a webworker thread to processes events rather than the main thread                                                                                                                                                                                                  |
| `queryOverLive`                             | Use Grafana Live WebSocket to execute backend queries                                                                                                                                                                                                                             |
| `lokiExperimentalStreaming`                 | Support new streaming approach for loki (prototype, needs special loki build)                                                                                                                                                                                                     |
| `storage`                                   | Configurable storage for dashboards, datasources, and resources                                                                                                                                                                                                                   |
| `datasourceQueryMultiStatus`                | Introduce HTTP 207 Multi Status for api/ds/query                                                                                                                                                                                                                                  |
| `traceToMetrics`                            | Enable trace to metrics links                                                                                                                                                                                                                                                     |
| `canvasPanelNesting`                        | Allow elements nesting                                                                                                                                                                                                                                                            |
| `scenes`                                    | Experimental framework to build interactive dashboards                                                                                                                                                                                                                            |
| `disableSecretsCompatibility`               | Disable duplicated secret storage in legacy tables                                                                                                                                                                                                                                |
| `logRequestsInstrumentedAsUnknown`          | Logs the path for requests that are instrumented as unknown                                                                                                                                                                                                                       |
| `dockedMegaMenu`                            | Enable support for a persistent (docked) navigation menu                                                                                                                                                                                                                          |
| `showDashboardValidationWarnings`           | Show warnings when dashboards do not validate against the schema                                                                                                                                                                                                                  |
| `mysqlAnsiQuotes`                           | Use double quotes to escape keyword in a MySQL query                                                                                                                                                                                                                              |
| `alertingBacktesting`                       | Rule backtesting API for alerting                                                                                                                                                                                                                                                 |
| `editPanelCSVDragAndDrop`                   | Enables drag and drop for CSV and Excel files                                                                                                                                                                                                                                     |
| `lokiQuerySplitting`                        | Split large interval queries into subqueries with smaller time intervals                                                                                                                                                                                                          |
| `lokiQuerySplittingConfig`                  | Give users the option to configure split durations for Loki queries                                                                                                                                                                                                               |
| `individualCookiePreferences`               | Support overriding cookie preferences per user                                                                                                                                                                                                                                    |
| `clientTokenRotation`                       | Replaces the current in-request token rotation so that the client initiates the rotation                                                                                                                                                                                          |
| `lokiLogsDataplane`                         | Changes logs responses from Loki to be compliant with the dataplane specification.                                                                                                                                                                                                |
| `disableSSEDataplane`                       | Disables dataplane specific processing in server side expressions.                                                                                                                                                                                                                |
| `alertStateHistoryLokiSecondary`            | Enable Grafana to write alert state history to an external Loki instance in addition to Grafana annotations.                                                                                                                                                                      |
| `alertStateHistoryLokiPrimary`              | Enable a remote Loki instance as the primary source for state history reads.                                                                                                                                                                                                      |
| `alertStateHistoryLokiOnly`                 | Disable Grafana alerts from emitting annotations when a remote Loki instance is available.                                                                                                                                                                                        |
| `unifiedRequestLog`                         | Writes error logs to the request logger                                                                                                                                                                                                                                           |
| `extraThemes`                               | Enables extra themes                                                                                                                                                                                                                                                              |
| `lokiPredefinedOperations`                  | Adds predefined query operations to Loki query editor                                                                                                                                                                                                                             |
| `pluginsFrontendSandbox`                    | Enables the plugins frontend sandbox                                                                                                                                                                                                                                              |
| `dashboardEmbed`                            | Allow embedding dashboard for external use in Code editors                                                                                                                                                                                                                        |
| `frontendSandboxMonitorOnly`                | Enables monitor only in the plugin frontend sandbox (if enabled)                                                                                                                                                                                                                  |
| `lokiFormatQuery`                           | Enables the ability to format Loki queries                                                                                                                                                                                                                                        |
| `exploreScrollableLogsContainer`            | Improves the scrolling behavior of logs in Explore                                                                                                                                                                                                                                |
| `pluginsDynamicAngularDetectionPatterns`    | Enables fetching Angular detection patterns for plugins from GCOM and fallback to hardcoded ones                                                                                                                                                                                  |
| `vizAndWidgetSplit`                         | Split panels between visualizations and widgets                                                                                                                                                                                                                                   |
| `prometheusIncrementalQueryInstrumentation` | Adds RudderStack events to incremental queries                                                                                                                                                                                                                                    |
| `logsExploreTableVisualisation`             | A table visualisation for logs in Explore                                                                                                                                                                                                                                         |
| `awsDatasourcesTempCredentials`             | Support temporary security credentials in AWS plugins for Grafana Cloud customers                                                                                                                                                                                                 |
| `mlExpressions`                             | Enable support for Machine Learning in server-side expressions                                                                                                                                                                                                                    |
| `traceQLStreaming`                          | Enables response streaming of TraceQL queries of the Tempo data source                                                                                                                                                                                                            |
| `metricsSummary`                            | Enables metrics summary queries in the Tempo data source                                                                                                                                                                                                                          |
| `grafanaAPIServer`                          | Enable Kubernetes API Server for Grafana resources                                                                                                                                                                                                                                |
| `grafanaAPIServerWithExperimentalAPIs`      | Register experimental APIs with the k8s API server                                                                                                                                                                                                                                |
| `featureToggleAdminPage`                    | Enable admin page for managing feature toggles from the Grafana front-end                                                                                                                                                                                                         |
| `permissionsFilterRemoveSubquery`           | Alternative permission filter implementation that does not use subqueries for fetching the dashboard folder                                                                                                                                                                       |
| `influxdbSqlSupport`                        | Enable InfluxDB SQL query language support with new querying UI                                                                                                                                                                                                                   |
| `angularDeprecationUI`                      | Display new Angular deprecation-related UI features                                                                                                                                                                                                                               |
| `dashgpt`                                   | Enable AI powered features in dashboards                                                                                                                                                                                                                                          |
| `sseGroupByDatasource`                      | Send query to the same datasource in a single request when using server side expressions                                                                                                                                                                                          |
| `requestInstrumentationStatusSource`        | Include a status source label for request metrics and logs                                                                                                                                                                                                                        |
| `libraryPanelRBAC`                          | Enables RBAC support for library panels                                                                                                                                                                                                                                           |
| `wargamesTesting`                           | Placeholder feature flag for internal testing                                                                                                                                                                                                                                     |
| `externalCorePlugins`                       | Allow core plugins to be loaded as external                                                                                                                                                                                                                                       |
| `pluginsAPIMetrics`                         | Sends metrics of public grafana packages usage by plugins                                                                                                                                                                                                                         |
| `httpSLOLevels`                             | Adds SLO level to http request metrics                                                                                                                                                                                                                                            |
| `panelMonitoring`                           | Enables panel monitoring through logs and measurements                                                                                                                                                                                                                            |
| `enableNativeHTTPHistogram`                 | Enables native HTTP Histograms                                                                                                                                                                                                                                                    |
| `formatString`                              | Enable format string transformer                                                                                                                                                                                                                                                  |
| `transformationsVariableSupport`            | Allows using variables in transformations                                                                                                                                                                                                                                         |
| `kubernetesPlaylists`                       | Use the kubernetes API in the frontend for playlists                                                                                                                                                                                                                              |
| `navAdminSubsections`                       | Splits the administration section of the nav tree into subsections                                                                                                                                                                                                                |
| `recoveryThreshold`                         | Enables feature recovery threshold (aka hysteresis) for threshold server-side expression                                                                                                                                                                                          |
| `awsDatasourcesNewFormStyling`              | Applies new form styling for configuration and query editors in AWS plugins                                                                                                                                                                                                       |
| `cachingOptimizeSerializationMemoryUsage`   | If enabled, the caching backend gradually serializes query responses for the cache, comparing against the configured `[caching]max_value_mb` value as it goes. This can can help prevent Grafana from running out of memory while attempting to cache very large query responses. |
| `pluginsInstrumentationStatusSource`        | Include a status source label for plugin request metrics and logs                                                                                                                                                                                                                 |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode]({{< relref "../_index.md#app_mode" >}}) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name       | Description                                                                                  |
| ------------------------- | -------------------------------------------------------------------------------------------- |
| `entityStore`             | SQL-based entity store (requires storage flag also)                                          |
| `externalServiceAuth`     | Starts an OAuth2 authentication provider for external services                               |
| `idForwarding`            | Generate signed id token for identity that can be forwarded to plugins and external services |
| `externalServiceAccounts` | Automatic service account and token setup for plugins                                        |
| `panelTitleSearchInV1`    | Enable searching for dashboards using panel title in search v1                               |
