---
keywords:
  - grafana
  - schema
labels:
  products:
    - cloud
    - enterprise
    - oss
title: Dashboard kind
---
> Both documentation generation and kinds schemas are in active development and subject to change without prior notice.

## Dashboard

#### Maturity: [experimental](../../../maturity/#experimental)
#### Version: 0.0

A Grafana dashboard.

| Property   | Type                | Required | Default | Description                                                                                                                                                                                                                                                                    |
|------------|---------------------|----------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `metadata` | [object](#metadata) | **Yes**  |         | metadata contains embedded CommonMetadata and can be extended with custom string fields<br/>TODO: use CommonMetadata instead of redefining here; currently needs to be defined here<br/>without external reference as using the CommonMetadata reference breaks thema codegen. |
| `spec`     | [object](#spec)     | **Yes**  |         |                                                                                                                                                                                                                                                                                |
| `status`   | [object](#status)   | **Yes**  |         |                                                                                                                                                                                                                                                                                |

### Metadata

metadata contains embedded CommonMetadata and can be extended with custom string fields
TODO: use CommonMetadata instead of redefining here; currently needs to be defined here
without external reference as using the CommonMetadata reference breaks thema codegen.

It extends [_kubeObjectMetadata](#_kubeobjectmetadata).

| Property            | Type                   | Required | Default | Description                                                                                                                             |
|---------------------|------------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------|
| `createdBy`         | string                 | **Yes**  |         |                                                                                                                                         |
| `creationTimestamp` | string                 | **Yes**  |         | *(Inherited from [_kubeObjectMetadata](#_kubeobjectmetadata))*                                                                          |
| `extraFields`       | [object](#extrafields) | **Yes**  |         | extraFields is reserved for any fields that are pulled from the API server metadata but do not have concrete fields in the CUE metadata |
| `finalizers`        | string[]               | **Yes**  |         | *(Inherited from [_kubeObjectMetadata](#_kubeobjectmetadata))*                                                                          |
| `labels`            | map[string]string      | **Yes**  |         | *(Inherited from [_kubeObjectMetadata](#_kubeobjectmetadata))*                                                                          |
| `resourceVersion`   | string                 | **Yes**  |         | *(Inherited from [_kubeObjectMetadata](#_kubeobjectmetadata))*                                                                          |
| `uid`               | string                 | **Yes**  |         | *(Inherited from [_kubeObjectMetadata](#_kubeobjectmetadata))*                                                                          |
| `updateTimestamp`   | string                 | **Yes**  |         |                                                                                                                                         |
| `updatedBy`         | string                 | **Yes**  |         |                                                                                                                                         |
| `deletionTimestamp` | string                 | No       |         | *(Inherited from [_kubeObjectMetadata](#_kubeobjectmetadata))*                                                                          |

### _kubeObjectMetadata

_kubeObjectMetadata is metadata found in a kubernetes object's metadata field.
It is not exhaustive and only includes fields which may be relevant to a kind's implementation,
As it is also intended to be generic enough to function with any API Server.

| Property            | Type              | Required | Default | Description |
|---------------------|-------------------|----------|---------|-------------|
| `creationTimestamp` | string            | **Yes**  |         |             |
| `finalizers`        | string[]          | **Yes**  |         |             |
| `labels`            | map[string]string | **Yes**  |         |             |
| `resourceVersion`   | string            | **Yes**  |         |             |
| `uid`               | string            | **Yes**  |         |             |
| `deletionTimestamp` | string            | No       |         |             |

### ExtraFields

extraFields is reserved for any fields that are pulled from the API server metadata but do not have concrete fields in the CUE metadata

| Property | Type | Required | Default | Description |
|----------|------|----------|---------|-------------|

### Spec

| Property               | Type                                        | Required | Default   | Description                                                                                                                                                                                                                                                                                                                                                                                                    |
|------------------------|---------------------------------------------|----------|-----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `schemaVersion`        | uint16                                      | **Yes**  | `36`      | Version of the JSON schema, incremented each time a Grafana update brings<br/>changes to said schema.                                                                                                                                                                                                                                                                                                          |
| `annotations`          | [AnnotationContainer](#annotationcontainer) | No       |           | Contains the list of annotations that are associated with the dashboard.<br/>Annotations are used to overlay event markers and overlay event tags on graphs.<br/>Grafana comes with a native annotation store and the ability to add annotation events directly from the graph panel or via the HTTP API.<br/>See https://grafana.com/docs/grafana/latest/dashboards/build-dashboards/annotate-visualizations/ |
| `description`          | string                                      | No       |           | Description of dashboard.                                                                                                                                                                                                                                                                                                                                                                                      |
| `editable`             | boolean                                     | No       | `true`    | Whether a dashboard is editable or not.                                                                                                                                                                                                                                                                                                                                                                        |
| `fiscalYearStartMonth` | integer                                     | No       | `0`       | The month that the fiscal year starts on.  0 = January, 11 = December<br/>Constraint: `>=0 & <12`.                                                                                                                                                                                                                                                                                                             |
| `gnetId`               | string                                      | No       |           | ID of a dashboard imported from the https://grafana.com/grafana/dashboards/ portal                                                                                                                                                                                                                                                                                                                             |
| `graphTooltip`         | integer                                     | No       | `0`       | 0 for no shared crosshair or tooltip (default).<br/>1 for shared crosshair.<br/>2 for shared crosshair AND shared tooltip.<br/>Possible values are: `0`, `1`, `2`.                                                                                                                                                                                                                                             |
| `id`                   | integer or null                             | No       |           | Unique numeric identifier for the dashboard.<br/>`id` is internal to a specific Grafana instance. `uid` should be used to identify a dashboard across Grafana instances.                                                                                                                                                                                                                                       |
| `links`                | [DashboardLink](#dashboardlink)[]           | No       |           | Links with references to other dashboards or external websites.                                                                                                                                                                                                                                                                                                                                                |
| `liveNow`              | boolean                                     | No       |           | When set to true, the dashboard will redraw panels at an interval matching the pixel width.<br/>This will keep data "moving left" regardless of the query refresh rate. This setting helps<br/>avoid dashboards presenting stale live data                                                                                                                                                                     |
| `panels`               | [object](#panels)[]                         | No       |           | List of dashboard panels                                                                                                                                                                                                                                                                                                                                                                                       |
| `refresh`              |                                             | No       |           | Refresh rate of dashboard. Represented via interval string, e.g. "5s", "1m", "1h", "1d".                                                                                                                                                                                                                                                                                                                       |
| `revision`             | integer                                     | No       |           | This property should only be used in dashboards defined by plugins.  It is a quick check<br/>to see if the version has changed since the last time.                                                                                                                                                                                                                                                            |
| `snapshot`             | [Snapshot](#snapshot)                       | No       |           | A dashboard snapshot shares an interactive dashboard publicly.<br/>It is a read-only version of a dashboard, and is not editable.<br/>It is possible to create a snapshot of a snapshot.<br/>Grafana strips away all sensitive information from the dashboard.<br/>Sensitive information stripped: queries (metric, template,annotation) and panel links.                                                      |
| `tags`                 | string[]                                    | No       |           | Tags associated with dashboard.                                                                                                                                                                                                                                                                                                                                                                                |
| `templating`           | [object](#templating)                       | No       |           | Configured template variables                                                                                                                                                                                                                                                                                                                                                                                  |
| `time`                 | [object](#time)                             | No       |           | Time range for dashboard.<br/>Accepted values are relative time strings like {from: 'now-6h', to: 'now'} or absolute time strings like {from: '2020-07-10T08:00:00.000Z', to: '2020-07-10T14:00:00.000Z'}.                                                                                                                                                                                                     |
| `timepicker`           | [object](#timepicker)                       | No       |           | Configuration of the time picker shown at the top of a dashboard.                                                                                                                                                                                                                                                                                                                                              |
| `timezone`             | string                                      | No       | `browser` | Timezone of dashboard. Accepted values are IANA TZDB zone ID or "browser" or "utc".                                                                                                                                                                                                                                                                                                                            |
| `title`                | string                                      | No       |           | Title of dashboard.                                                                                                                                                                                                                                                                                                                                                                                            |
| `uid`                  | string                                      | No       |           | Unique dashboard identifier that can be generated by anyone. string (8-40)                                                                                                                                                                                                                                                                                                                                     |
| `version`              | uint32                                      | No       |           | Version of the dashboard, incremented each time the dashboard is updated.                                                                                                                                                                                                                                                                                                                                      |
| `weekStart`            | string                                      | No       |           | Day when the week starts. Expressed by the name of the day in lowercase, e.g. "monday".                                                                                                                                                                                                                                                                                                                        |

### AnnotationContainer

Contains the list of annotations that are associated with the dashboard.
Annotations are used to overlay event markers and overlay event tags on graphs.
Grafana comes with a native annotation store and the ability to add annotation events directly from the graph panel or via the HTTP API.
See https://grafana.com/docs/grafana/latest/dashboards/build-dashboards/annotate-visualizations/

| Property | Type                                  | Required | Default | Description         |
|----------|---------------------------------------|----------|---------|---------------------|
| `list`   | [AnnotationQuery](#annotationquery)[] | No       |         | List of annotations |

### AnnotationQuery

TODO docs
FROM: AnnotationQuery in grafana-data/src/types/annotations.ts

| Property     | Type                                            | Required | Default | Description                                                                                                                                                                  |
|--------------|-------------------------------------------------|----------|---------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `datasource` | [DataSourceRef](#datasourceref)                 | **Yes**  |         | Ref to a DataSource instance                                                                                                                                                 |
| `enable`     | boolean                                         | **Yes**  | `true`  | When enabled the annotation query is issued with every dashboard refresh                                                                                                     |
| `iconColor`  | string                                          | **Yes**  |         | Color to use for the annotation event markers                                                                                                                                |
| `name`       | string                                          | **Yes**  |         | Name of annotation.                                                                                                                                                          |
| `builtIn`    | number                                          | No       | `0`     | Set to 1 for the standard annotation query all dashboards have by default.                                                                                                   |
| `filter`     | [AnnotationPanelFilter](#annotationpanelfilter) | No       |         |                                                                                                                                                                              |
| `hide`       | boolean                                         | No       | `false` | Annotation queries can be toggled on or off at the top of the dashboard.<br/>When hide is true, the toggle is not shown in the dashboard.                                    |
| `target`     | [AnnotationTarget](#annotationtarget)           | No       |         | TODO: this should be a regular DataQuery that depends on the selected dashboard<br/>these match the properties of the "grafana" datasouce that is default in most dashboards |
| `type`       | string                                          | No       |         | TODO -- this should not exist here, it is based on the --grafana-- datasource                                                                                                |

### AnnotationPanelFilter

| Property  | Type      | Required | Default | Description                                         |
|-----------|-----------|----------|---------|-----------------------------------------------------|
| `ids`     | integer[] | **Yes**  |         | Panel IDs that should be included or excluded       |
| `exclude` | boolean   | No       | `false` | Should the specified panels be included or excluded |

### AnnotationTarget

TODO: this should be a regular DataQuery that depends on the selected dashboard
these match the properties of the "grafana" datasouce that is default in most dashboards

| Property   | Type     | Required | Default | Description                                                                                                       |
|------------|----------|----------|---------|-------------------------------------------------------------------------------------------------------------------|
| `limit`    | integer  | **Yes**  |         | Only required/valid for the grafana datasource...<br/>but code+tests is already depending on it so hard to change |
| `matchAny` | boolean  | **Yes**  |         | Only required/valid for the grafana datasource...<br/>but code+tests is already depending on it so hard to change |
| `tags`     | string[] | **Yes**  |         | Only required/valid for the grafana datasource...<br/>but code+tests is already depending on it so hard to change |
| `type`     | string   | **Yes**  |         | Only required/valid for the grafana datasource...<br/>but code+tests is already depending on it so hard to change |

### DataSourceRef

Ref to a DataSource instance

| Property | Type   | Required | Default | Description                  |
|----------|--------|----------|---------|------------------------------|
| `type`   | string | No       |         | The plugin type-id           |
| `uid`    | string | No       |         | Specific datasource instance |

### DashboardLink

Links with references to other dashboards or external resources

| Property      | Type     | Required | Default | Description                                                                                                                                                                    |
|---------------|----------|----------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `asDropdown`  | boolean  | **Yes**  | `false` | If true, all dashboards links will be displayed in a dropdown. If false, all dashboards links will be displayed side by side. Only valid if the type is dashboards             |
| `icon`        | string   | **Yes**  |         | Icon name to be displayed with the link                                                                                                                                        |
| `includeVars` | boolean  | **Yes**  | `false` | If true, includes current template variables values in the link as query params                                                                                                |
| `keepTime`    | boolean  | **Yes**  | `false` | If true, includes current time range in the link as query params                                                                                                               |
| `tags`        | string[] | **Yes**  |         | List of tags to limit the linked dashboards. If empty, all dashboards will be displayed. Only valid if the type is dashboards                                                  |
| `targetBlank` | boolean  | **Yes**  | `false` | If true, the link will be opened in a new tab                                                                                                                                  |
| `title`       | string   | **Yes**  |         | Title to display with the link                                                                                                                                                 |
| `tooltip`     | string   | **Yes**  |         | Tooltip to display when the user hovers their mouse over it                                                                                                                    |
| `type`        | string   | **Yes**  |         | Dashboard Link type. Accepted values are dashboards (to refer to another dashboard) and link (to refer to an external resource)<br/>Possible values are: `link`, `dashboards`. |
| `url`         | string   | **Yes**  |         | Link URL. Only required/valid if the type is link                                                                                                                              |

### Snapshot

A dashboard snapshot shares an interactive dashboard publicly.
It is a read-only version of a dashboard, and is not editable.
It is possible to create a snapshot of a snapshot.
Grafana strips away all sensitive information from the dashboard.
Sensitive information stripped: queries (metric, template,annotation) and panel links.

| Property      | Type    | Required | Default | Description                                                                    |
|---------------|---------|----------|---------|--------------------------------------------------------------------------------|
| `created`     | string  | **Yes**  |         | Time when the snapshot was created                                             |
| `expires`     | string  | **Yes**  |         | Time when the snapshot expires, default is never to expire                     |
| `externalUrl` | string  | **Yes**  |         | external url, if snapshot was shared in external grafana instance              |
| `external`    | boolean | **Yes**  |         | Is the snapshot saved in an external grafana instance                          |
| `id`          | uint32  | **Yes**  |         | Unique identifier of the snapshot                                              |
| `key`         | string  | **Yes**  |         | Optional, defined the unique key of the snapshot, required if external is true |
| `name`        | string  | **Yes**  |         | Optional, name of the snapshot                                                 |
| `orgId`       | uint32  | **Yes**  |         | org id of the snapshot                                                         |
| `updated`     | string  | **Yes**  |         | last time when the snapshot was updated                                        |
| `userId`      | uint32  | **Yes**  |         | user id of the snapshot creator                                                |
| `url`         | string  | No       |         | url of the snapshot, if snapshot was shared internally                         |

### Panels

| Property | Type                                                                                                        | Required | Default | Description |
|----------|-------------------------------------------------------------------------------------------------------------|----------|---------|-------------|
| `object` | Possible types are: [](#), [RowPanel](#rowpanel), [GraphPanel](#graphpanel), [HeatmapPanel](#heatmappanel). |          |         |

### DataTransformerConfig

Transformations allow to manipulate data returned by a query before the system applies a visualization.
Using transformations you can: rename fields, join time series data, perform mathematical operations across queries,
use the output of one transformation as the input to another transformation, etc.

| Property   | Type                            | Required | Default | Description                                                                                                                                                                                                                                                                         |
|------------|---------------------------------|----------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `id`       | string                          | **Yes**  |         | Unique identifier of transformer                                                                                                                                                                                                                                                    |
| `options`  |                                 | **Yes**  |         | Options to be passed to the transformer<br/>Valid options depend on the transformer id                                                                                                                                                                                              |
| `disabled` | boolean                         | No       |         | Disabled transformations are skipped                                                                                                                                                                                                                                                |
| `filter`   | [MatcherConfig](#matcherconfig) | No       |         | Matcher is a predicate configuration. Based on the config a set of field(s) or values is filtered in order to apply override / transformation.<br/>It comes with in id ( to resolve implementation from registry) and a configuration that’s specific to a particular matcher type. |

### MatcherConfig

Matcher is a predicate configuration. Based on the config a set of field(s) or values is filtered in order to apply override / transformation.
It comes with in id ( to resolve implementation from registry) and a configuration that’s specific to a particular matcher type.

| Property  | Type   | Required | Default | Description                                                                    |
|-----------|--------|----------|---------|--------------------------------------------------------------------------------|
| `id`      | string | **Yes**  | ``      | The matcher id. This is used to find the matcher implementation from registry. |
| `options` |        | No       |         | The matcher options. This is specific to the matcher implementation.           |

### FieldConfigSource

The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.
Each column within this structure is called a field. A field can represent a single time series or table column.
Field options allow you to change how the data is displayed in your visualizations.

| Property    | Type                        | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                       |
|-------------|-----------------------------|----------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `defaults`  | [FieldConfig](#fieldconfig) | **Yes**  |         | The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.<br/>Each column within this structure is called a field. A field can represent a single time series or table column.<br/>Field options allow you to change how the data is displayed in your visualizations. |
| `overrides` | [object](#overrides)[]      | **Yes**  |         | Overrides are the options applied to specific fields overriding the defaults.                                                                                                                                                                                                                                                                                     |

### FieldConfig

The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.
Each column within this structure is called a field. A field can represent a single time series or table column.
Field options allow you to change how the data is displayed in your visualizations.

| Property            | Type                                  | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|---------------------|---------------------------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `color`             | [FieldColor](#fieldcolor)             | No       |         | Map a field to a color.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `custom`            | [object](#custom)                     | No       |         | custom is specified by the FieldConfig field<br/>in panel plugin schemas.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `decimals`          | number                                | No       |         | Specify the number of decimals Grafana includes in the rendered value.<br/>If you leave this field blank, Grafana automatically truncates the number of decimals based on the value.<br/>For example 1.1234 will display as 1.12 and 100.456 will display as 100.<br/>To display all decimals, set the unit to `String`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `description`       | string                                | No       |         | Human readable field metadata                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `displayNameFromDS` | string                                | No       |         | This can be used by data sources that return and explicit naming structure for values and labels<br/>When this property is configured, this value is used rather than the default naming strategy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `displayName`       | string                                | No       |         | The display value for this field.  This supports template variables blank is auto                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `filterable`        | boolean                               | No       |         | True if data source field supports ad-hoc filters                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `links`             |                                       | No       |         | The behavior when clicking on a result                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `mappings`          | [ValueMapping](#valuemapping)[]       | No       |         | Convert input values into a display string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `max`               | number                                | No       |         | The maximum value used in percentage threshold calculations. Leave blank for auto calculation based on all series and fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `min`               | number                                | No       |         | The minimum value used in percentage threshold calculations. Leave blank for auto calculation based on all series and fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `noValue`           | string                                | No       |         | Alternative to empty string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `path`              | string                                | No       |         | An explicit path to the field in the datasource.  When the frame meta includes a path,<br/>This will default to `${frame.meta.path}/${field.name}<br/><br/>When defined, this value can be used as an identifier within the datasource scope, and<br/>may be used to update the results                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `thresholds`        | [ThresholdsConfig](#thresholdsconfig) | No       |         | Thresholds configuration for the panel                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `unit`              | string                                | No       |         | Unit a field should use. The unit you select is applied to all fields except time.<br/>You can use the units ID availables in Grafana or a custom unit.<br/>Available units in Grafana: https://github.com/grafana/grafana/blob/main/packages/grafana-data/src/valueFormats/categories.ts<br/>As custom unit, you can use the following formats:<br/>`suffix:<suffix>` for custom unit that should go after value.<br/>`prefix:<prefix>` for custom unit that should go before value.<br/>`time:<format>` For custom date time formats type for example `time:YYYY-MM-DD`.<br/>`si:<base scale><unit characters>` for custom SI units. For example: `si: mF`. This one is a bit more advanced as you can specify both a unit and the source data scale. So if your source data is represented as milli (thousands of) something prefix the unit with that SI scale character.<br/>`count:<unit>` for a custom count unit.<br/>`currency:<unit>` for custom a currency unit. |
| `writeable`         | boolean                               | No       |         | True if data source can write a value to the path. Auth/authz are supported separately                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |

### FieldColor

Map a field to a color.

| Property     | Type   | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|--------------|--------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `mode`       | string | **Yes**  |         | Color mode for a field. You can specify a single color, or select a continuous (gradient) color schemes, based on a value.<br/>Continuous color interpolates a color using the percentage of a value relative to min and max.<br/>Accepted values are:<br/>`thresholds`: From thresholds. Informs Grafana to take the color from the matching threshold<br/>`palette-classic`: Classic palette. Grafana will assign color by looking up a color in a palette by series index. Useful for Graphs and pie charts and other categorical data visualizations<br/>`palette-classic-by-name`: Classic palette (by name). Grafana will assign color by looking up a color in a palette by series name. Useful for Graphs and pie charts and other categorical data visualizations<br/>`continuous-GrYlRd`: ontinuous Green-Yellow-Red palette mode<br/>`continuous-RdYlGr`: Continuous Red-Yellow-Green palette mode<br/>`continuous-BlYlRd`: Continuous Blue-Yellow-Red palette mode<br/>`continuous-YlRd`: Continuous Yellow-Red palette mode<br/>`continuous-BlPu`: Continuous Blue-Purple palette mode<br/>`continuous-YlBl`: Continuous Yellow-Blue palette mode<br/>`continuous-blues`: Continuous Blue palette mode<br/>`continuous-reds`: Continuous Red palette mode<br/>`continuous-greens`: Continuous Green palette mode<br/>`continuous-purples`: Continuous Purple palette mode<br/>`shades`: Shades of a single color. Specify a single color, useful in an override rule.<br/>`fixed`: Fixed color mode. Specify a single color, useful in an override rule.<br/>Possible values are: `thresholds`, `palette-classic`, `palette-classic-by-name`, `continuous-GrYlRd`, `continuous-RdYlGr`, `continuous-BlYlRd`, `continuous-YlRd`, `continuous-BlPu`, `continuous-YlBl`, `continuous-blues`, `continuous-reds`, `continuous-greens`, `continuous-purples`, `fixed`, `shades`. |
| `fixedColor` | string | No       |         | The fixed color value for fixed or shades color modes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `seriesBy`   | string | No       |         | Defines how to assign a series color from "by value" color schemes. For example for an aggregated data points like a timeseries, the color can be assigned by the min, max or last value.<br/>Possible values are: `min`, `max`, `last`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |

### ThresholdsConfig

Thresholds configuration for the panel

| Property | Type                      | Required | Default | Description                                                                                                                                                                           |
|----------|---------------------------|----------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `mode`   | string                    | **Yes**  |         | Thresholds can either be `absolute` (specific number) or `percentage` (relative to min or max, it will be values between 0 and 1).<br/>Possible values are: `absolute`, `percentage`. |
| `steps`  | [Threshold](#threshold)[] | **Yes**  |         | Must be sorted by 'value', first value is always -Infinity                                                                                                                            |

### Threshold

User-defined value for a metric that triggers visual changes in a panel when this value is met or exceeded
They are used to conditionally style and color visualizations based on query results , and can be applied to most visualizations.

| Property | Type           | Required | Default | Description                                                                                                                                                                                                    |
|----------|----------------|----------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `color`  | string         | **Yes**  |         | Color represents the color of the visual change that will occur in the dashboard when the threshold value is met or exceeded.                                                                                  |
| `value`  | number or null | **Yes**  |         | Value represents a specified metric for the threshold, which triggers a visual change in the dashboard when this value is met or exceeded.<br/>Nulls currently appear here when serializing -Infinity to JSON. |

### ValueMapping

Allow to transform the visual representation of specific data values in a visualization, irrespective of their original units

| Property | Type                                                                                                                          | Required | Default | Description |
|----------|-------------------------------------------------------------------------------------------------------------------------------|----------|---------|-------------|
| `object` | Possible types are: [ValueMap](#valuemap), [RangeMap](#rangemap), [RegexMap](#regexmap), [SpecialValueMap](#specialvaluemap). |          |         |

### RangeMap

Maps numerical ranges to a display text and color.
For example, if a value is within a certain range, you can configure a range value mapping to display Low or High rather than the number.

| Property  | Type               | Required | Default | Description                                                                       |
|-----------|--------------------|----------|---------|-----------------------------------------------------------------------------------|
| `options` | [object](#options) | **Yes**  |         | Range to match against and the result to apply when the value is within the range |
| `type`    | string             | **Yes**  |         |                                                                                   |

### Options

Range to match against and the result to apply when the value is within the range

| Property | Type                                      | Required | Default | Description                                                           |
|----------|-------------------------------------------|----------|---------|-----------------------------------------------------------------------|
| `from`   | number or null                            | **Yes**  |         | Min value of the range. It can be null which means -Infinity          |
| `result` | [ValueMappingResult](#valuemappingresult) | **Yes**  |         | Result used as replacement with text and color when the value matches |
| `to`     | number or null                            | **Yes**  |         | Max value of the range. It can be null which means +Infinity          |

### ValueMappingResult

Result used as replacement with text and color when the value matches

| Property | Type    | Required | Default | Description                                                           |
|----------|---------|----------|---------|-----------------------------------------------------------------------|
| `color`  | string  | No       |         | Text to use when the value matches                                    |
| `icon`   | string  | No       |         | Icon to display when the value matches. Only specific visualizations. |
| `index`  | integer | No       |         | Position in the mapping array. Only used internally.                  |
| `text`   | string  | No       |         | Text to display when the value matches                                |

### RegexMap

Maps regular expressions to replacement text and a color.
For example, if a value is www.example.com, you can configure a regex value mapping so that Grafana displays www and truncates the domain.

| Property  | Type               | Required | Default | Description                                                                                  |
|-----------|--------------------|----------|---------|----------------------------------------------------------------------------------------------|
| `options` | [object](#options) | **Yes**  |         | Regular expression to match against and the result to apply when the value matches the regex |
| `type`    | string             | **Yes**  |         |                                                                                              |

### Options

Regular expression to match against and the result to apply when the value matches the regex

| Property  | Type                                      | Required | Default | Description                                                           |
|-----------|-------------------------------------------|----------|---------|-----------------------------------------------------------------------|
| `pattern` | string                                    | **Yes**  |         | Regular expression to match against                                   |
| `result`  | [ValueMappingResult](#valuemappingresult) | **Yes**  |         | Result used as replacement with text and color when the value matches |

### SpecialValueMap

Maps special values like Null, NaN (not a number), and boolean values like true and false to a display text and color.
See SpecialValueMatch to see the list of special values.
For example, you can configure a special value mapping so that null values appear as N/A.

| Property  | Type               | Required | Default | Description |
|-----------|--------------------|----------|---------|-------------|
| `options` | [object](#options) | **Yes**  |         |             |
| `type`    | string             | **Yes**  |         |             |

### Options

| Property | Type                                      | Required | Default | Description                                                                                                                          |
|----------|-------------------------------------------|----------|---------|--------------------------------------------------------------------------------------------------------------------------------------|
| `match`  | string                                    | **Yes**  |         | Special value types supported by the `SpecialValueMap`<br/>Possible values are: `true`, `false`, `null`, `nan`, `null+nan`, `empty`. |
| `result` | [ValueMappingResult](#valuemappingresult) | **Yes**  |         | Result used as replacement with text and color when the value matches                                                                |

### ValueMap

Maps text values to a color or different display text and color.
For example, you can configure a value mapping so that all instances of the value 10 appear as Perfection! rather than the number.

| Property  | Type                                                 | Required | Default | Description                                                                                                   |
|-----------|------------------------------------------------------|----------|---------|---------------------------------------------------------------------------------------------------------------|
| `options` | map[string][ValueMappingResult](#valuemappingresult) | **Yes**  |         | Map with <value_to_match>: ValueMappingResult. For example: { "10": { text: "Perfection!", color: "green" } } |
| `type`    | string                                               | **Yes**  |         |                                                                                                               |

### Custom

custom is specified by the FieldConfig field
in panel plugin schemas.

| Property | Type | Required | Default | Description |
|----------|------|----------|---------|-------------|

### Overrides

| Property     | Type                                        | Required | Default | Description                                                                                                                                                                                                                                                                         |
|--------------|---------------------------------------------|----------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `matcher`    | [MatcherConfig](#matcherconfig)             | **Yes**  |         | Matcher is a predicate configuration. Based on the config a set of field(s) or values is filtered in order to apply override / transformation.<br/>It comes with in id ( to resolve implementation from registry) and a configuration that’s specific to a particular matcher type. |
| `properties` | [DynamicConfigValue](#dynamicconfigvalue)[] | **Yes**  |         |                                                                                                                                                                                                                                                                                     |

### DynamicConfigValue

| Property | Type   | Required | Default | Description |
|----------|--------|----------|---------|-------------|
| `id`     | string | **Yes**  | ``      |             |
| `value`  |        | No       |         |             |

### GraphPanel

Support for legacy graph panel.
@deprecated this a deprecated panel type

| Property | Type              | Required | Default | Description                                        |
|----------|-------------------|----------|---------|----------------------------------------------------|
| `type`   | string            | **Yes**  |         | Possible values are: `graph`.                      |
| `legend` | [object](#legend) | No       |         | @deprecated this is part of deprecated graph panel |

### Legend

@deprecated this is part of deprecated graph panel

| Property   | Type    | Required | Default | Description |
|------------|---------|----------|---------|-------------|
| `show`     | boolean | **Yes**  | `true`  |             |
| `sortDesc` | boolean | No       |         |             |
| `sort`     | string  | No       |         |             |

### GridPos

Position and dimensions of a panel in the grid

| Property | Type    | Required | Default | Description                                                                                                       |
|----------|---------|----------|---------|-------------------------------------------------------------------------------------------------------------------|
| `h`      | uint32  | **Yes**  | `9`     | Panel height. The height is the number of rows from the top edge of the panel.                                    |
| `w`      | integer | **Yes**  | `12`    | Panel width. The width is the number of columns from the left edge of the panel.<br/>Constraint: `>0 & <=24`.     |
| `x`      | integer | **Yes**  | `0`     | Panel x. The x coordinate is the number of columns from the left edge of the grid<br/>Constraint: `>=0 & <24`.    |
| `y`      | uint32  | **Yes**  | `0`     | Panel y. The y coordinate is the number of rows from the top edge of the grid                                     |
| `static` | boolean | No       |         | Whether the panel is fixed within the grid. If true, the panel will not be affected by other panels' interactions |

### HeatmapPanel

Support for legacy heatmap panel.
@deprecated this a deprecated panel type

| Property | Type   | Required | Default | Description                     |
|----------|--------|----------|---------|---------------------------------|
| `type`   | string | **Yes**  |         | Possible values are: `heatmap`. |

### LibraryPanelRef

A library panel is a reusable panel that you can use in any dashboard.
When you make a change to a library panel, that change propagates to all instances of where the panel is used.
Library panels streamline reuse of panels across multiple dashboards.

| Property | Type   | Required | Default | Description        |
|----------|--------|----------|---------|--------------------|
| `name`   | string | **Yes**  |         | Library panel name |
| `uid`    | string | **Yes**  |         | Library panel uid  |

### RowPanel

Row panel

| Property     | Type                            | Required | Default | Description                                                                                                                             |
|--------------|---------------------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------|
| `collapsed`  | boolean                         | **Yes**  | `false` | Whether this row should be collapsed or not.                                                                                            |
| `id`         | uint32                          | **Yes**  |         | Unique identifier of the panel. Generated by Grafana when creating a new panel. It must be unique within a dashboard, but not globally. |
| `panels`     | [panels](#panels)[]             | **Yes**  |         | List of panels in the row                                                                                                               |
| `type`       | string                          | **Yes**  |         | The panel type<br/>Possible values are: `row`.                                                                                          |
| `datasource` | [DataSourceRef](#datasourceref) | No       |         | Ref to a DataSource instance                                                                                                            |
| `gridPos`    | [GridPos](#gridpos)             | No       |         | Position and dimensions of a panel in the grid                                                                                          |
| `repeat`     | string                          | No       |         | Name of template variable to repeat for.                                                                                                |
| `title`      | string                          | No       |         | Row title                                                                                                                               |

### Panels

| Property | Type                                                                                           | Required | Default | Description |
|----------|------------------------------------------------------------------------------------------------|----------|---------|-------------|
| `object` | Possible types are: [Panel](#panel), [GraphPanel](#graphpanel), [HeatmapPanel](#heatmappanel). |          |         |

### Panel

Dashboard panels are the basic visualization building blocks.

| Property           | Type                                              | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
|--------------------|---------------------------------------------------|----------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `type`             | string                                            | **Yes**  |         | The panel plugin type id. This is used to find the plugin to display the panel.<br/>Constraint: `length >=1`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `datasource`       | [DataSourceRef](#datasourceref)                   | No       |         | Ref to a DataSource instance                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `description`      | string                                            | No       |         | Panel description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `fieldConfig`      | [FieldConfigSource](#fieldconfigsource)           | No       |         | The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.<br/>Each column within this structure is called a field. A field can represent a single time series or table column.<br/>Field options allow you to change how the data is displayed in your visualizations.                                                                                                                                                                                                                                                                                                                                 |
| `gridPos`          | [GridPos](#gridpos)                               | No       |         | Position and dimensions of a panel in the grid                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `hideTimeOverride` | boolean                                           | No       |         | Controls if the timeFrom or timeShift overrides are shown in the panel header                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `id`               | uint32                                            | No       |         | Unique identifier of the panel. Generated by Grafana when creating a new panel. It must be unique within a dashboard, but not globally.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `interval`         | string                                            | No       |         | The min time interval setting defines a lower limit for the $__interval and $__interval_ms variables.<br/>This value must be formatted as a number followed by a valid time<br/>identifier like: "40s", "3d", etc.<br/>See: https://grafana.com/docs/grafana/latest/panels-visualizations/query-transform-data/#query-options                                                                                                                                                                                                                                                                                                                                                                     |
| `libraryPanel`     | [LibraryPanelRef](#librarypanelref)               | No       |         | A library panel is a reusable panel that you can use in any dashboard.<br/>When you make a change to a library panel, that change propagates to all instances of where the panel is used.<br/>Library panels streamline reuse of panels across multiple dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `links`            | [DashboardLink](#dashboardlink)[]                 | No       |         | Panel links.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `maxDataPoints`    | number                                            | No       |         | The maximum number of data points that the panel queries are retrieving.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `maxPerRow`        | number                                            | No       |         | Option for repeated panels that controls max items per row<br/>Only relevant for horizontally repeated panels                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `options`          | [object](#options)                                | No       |         | It depends on the panel plugin. They are specified by the Options field in panel plugin schemas.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `pluginVersion`    | string                                            | No       |         | The version of the plugin that is used for this panel. This is used to find the plugin to display the panel and to migrate old panel configs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `repeatDirection`  | string                                            | No       | `h`     | Direction to repeat in if 'repeat' is set.<br/>`h` for horizontal, `v` for vertical.<br/>Possible values are: `h`, `v`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `repeat`           | string                                            | No       |         | Name of template variable to repeat for.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `tags`             | string[]                                          | No       |         | Tags for the panel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `targets`          | [Target](#target)[]                               | No       |         | Depends on the panel plugin. See the plugin documentation for details.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `timeFrom`         | string                                            | No       |         | Overrides the relative time range for individual panels,<br/>which causes them to be different than what is selected in<br/>the dashboard time picker in the top-right corner of the dashboard. You can use this to show metrics from different<br/>time periods or days on the same dashboard.<br/>The value is formatted as time operation like: `now-5m` (Last 5 minutes), `now/d` (the day so far),<br/>`now-5d/d`(Last 5 days), `now/w` (This week so far), `now-2y/y` (Last 2 years).<br/>Note: Panel time overrides have no effect when the dashboard’s time range is absolute.<br/>See: https://grafana.com/docs/grafana/latest/panels-visualizations/query-transform-data/#query-options |
| `timeShift`        | string                                            | No       |         | Overrides the time range for individual panels by shifting its start and end relative to the time picker.<br/>For example, you can shift the time range for the panel to be two hours earlier than the dashboard time picker setting `2h`.<br/>Note: Panel time overrides have no effect when the dashboard’s time range is absolute.<br/>See: https://grafana.com/docs/grafana/latest/panels-visualizations/query-transform-data/#query-options                                                                                                                                                                                                                                                  |
| `title`            | string                                            | No       |         | Panel title.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `transformations`  | [DataTransformerConfig](#datatransformerconfig)[] | No       |         | List of transformations that are applied to the panel data before rendering.<br/>When there are multiple transformations, Grafana applies them in the order they are listed.<br/>Each transformation creates a result set that then passes on to the next transformation in the processing pipeline.                                                                                                                                                                                                                                                                                                                                                                                              |
| `transparent`      | boolean                                           | No       | `false` | Whether to display the panel without a background.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |

### FieldConfigSource

The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.
Each column within this structure is called a field. A field can represent a single time series or table column.
Field options allow you to change how the data is displayed in your visualizations.

| Property    | Type                        | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                       |
|-------------|-----------------------------|----------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `defaults`  | [FieldConfig](#fieldconfig) | **Yes**  |         | The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.<br/>Each column within this structure is called a field. A field can represent a single time series or table column.<br/>Field options allow you to change how the data is displayed in your visualizations. |
| `overrides` | [overrides](#overrides)[]   | **Yes**  |         | Overrides are the options applied to specific fields overriding the defaults.                                                                                                                                                                                                                                                                                     |

### FieldConfig

The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.
Each column within this structure is called a field. A field can represent a single time series or table column.
Field options allow you to change how the data is displayed in your visualizations.

| Property            | Type                                  | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|---------------------|---------------------------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `color`             | [FieldColor](#fieldcolor)             | No       |         | Map a field to a color.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `custom`            | [custom](#custom)                     | No       |         | custom is specified by the FieldConfig field<br/>in panel plugin schemas.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `decimals`          | number                                | No       |         | Specify the number of decimals Grafana includes in the rendered value.<br/>If you leave this field blank, Grafana automatically truncates the number of decimals based on the value.<br/>For example 1.1234 will display as 1.12 and 100.456 will display as 100.<br/>To display all decimals, set the unit to `String`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `description`       | string                                | No       |         | Human readable field metadata                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `displayNameFromDS` | string                                | No       |         | This can be used by data sources that return and explicit naming structure for values and labels<br/>When this property is configured, this value is used rather than the default naming strategy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `displayName`       | string                                | No       |         | The display value for this field.  This supports template variables blank is auto                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `filterable`        | boolean                               | No       |         | True if data source field supports ad-hoc filters                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `links`             |                                       | No       |         | The behavior when clicking on a result                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `mappings`          | [ValueMapping](#valuemapping)[]       | No       |         | Convert input values into a display string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `max`               | number                                | No       |         | The maximum value used in percentage threshold calculations. Leave blank for auto calculation based on all series and fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `min`               | number                                | No       |         | The minimum value used in percentage threshold calculations. Leave blank for auto calculation based on all series and fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `noValue`           | string                                | No       |         | Alternative to empty string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `path`              | string                                | No       |         | An explicit path to the field in the datasource.  When the frame meta includes a path,<br/>This will default to `${frame.meta.path}/${field.name}<br/><br/>When defined, this value can be used as an identifier within the datasource scope, and<br/>may be used to update the results                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `thresholds`        | [ThresholdsConfig](#thresholdsconfig) | No       |         | Thresholds configuration for the panel                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `unit`              | string                                | No       |         | Unit a field should use. The unit you select is applied to all fields except time.<br/>You can use the units ID availables in Grafana or a custom unit.<br/>Available units in Grafana: https://github.com/grafana/grafana/blob/main/packages/grafana-data/src/valueFormats/categories.ts<br/>As custom unit, you can use the following formats:<br/>`suffix:<suffix>` for custom unit that should go after value.<br/>`prefix:<prefix>` for custom unit that should go before value.<br/>`time:<format>` For custom date time formats type for example `time:YYYY-MM-DD`.<br/>`si:<base scale><unit characters>` for custom SI units. For example: `si: mF`. This one is a bit more advanced as you can specify both a unit and the source data scale. So if your source data is represented as milli (thousands of) something prefix the unit with that SI scale character.<br/>`count:<unit>` for a custom count unit.<br/>`currency:<unit>` for custom a currency unit. |
| `writeable`         | boolean                               | No       |         | True if data source can write a value to the path. Auth/authz are supported separately                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |

### RangeMap

Maps numerical ranges to a display text and color.
For example, if a value is within a certain range, you can configure a range value mapping to display Low or High rather than the number.

| Property  | Type                | Required | Default | Description                                                                       |
|-----------|---------------------|----------|---------|-----------------------------------------------------------------------------------|
| `options` | [options](#options) | **Yes**  |         | Range to match against and the result to apply when the value is within the range |
| `type`    | string              | **Yes**  |         |                                                                                   |

### RegexMap

Maps regular expressions to replacement text and a color.
For example, if a value is www.example.com, you can configure a regex value mapping so that Grafana displays www and truncates the domain.

| Property  | Type                | Required | Default | Description                                                                                  |
|-----------|---------------------|----------|---------|----------------------------------------------------------------------------------------------|
| `options` | [options](#options) | **Yes**  |         | Regular expression to match against and the result to apply when the value matches the regex |
| `type`    | string              | **Yes**  |         |                                                                                              |

### SpecialValueMap

Maps special values like Null, NaN (not a number), and boolean values like true and false to a display text and color.
See SpecialValueMatch to see the list of special values.
For example, you can configure a special value mapping so that null values appear as N/A.

| Property  | Type                | Required | Default | Description |
|-----------|---------------------|----------|---------|-------------|
| `options` | [options](#options) | **Yes**  |         |             |
| `type`    | string              | **Yes**  |         |             |

### Target

Schema for panel targets is specified by datasource
plugins. We use a placeholder definition, which the Go
schema loader either left open/as-is with the Base
variant of the Dashboard and Panel families, or filled
with types derived from plugins in the Instance variant.
When working directly from CUE, importers can extend this
type directly to achieve the same effect.

| Property | Type | Required | Default | Description |
|----------|------|----------|---------|-------------|

### Options

It depends on the panel plugin. They are specified by the Options field in panel plugin schemas.

| Property | Type | Required | Default | Description |
|----------|------|----------|---------|-------------|

### GraphPanel

Support for legacy graph panel.
@deprecated this a deprecated panel type

| Property | Type              | Required | Default | Description                                        |
|----------|-------------------|----------|---------|----------------------------------------------------|
| `type`   | string            | **Yes**  |         | Possible values are: `graph`.                      |
| `legend` | [legend](#legend) | No       |         | @deprecated this is part of deprecated graph panel |

### Panel

Dashboard panels are the basic visualization building blocks.

| Property           | Type                                              | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
|--------------------|---------------------------------------------------|----------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `type`             | string                                            | **Yes**  |         | The panel plugin type id. This is used to find the plugin to display the panel.<br/>Constraint: `length >=1`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `datasource`       | [DataSourceRef](#datasourceref)                   | No       |         | Ref to a DataSource instance                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `description`      | string                                            | No       |         | Panel description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `fieldConfig`      | [FieldConfigSource](#fieldconfigsource)           | No       |         | The data model used in Grafana, namely the data frame, is a columnar-oriented table structure that unifies both time series and table query results.<br/>Each column within this structure is called a field. A field can represent a single time series or table column.<br/>Field options allow you to change how the data is displayed in your visualizations.                                                                                                                                                                                                                                                                                                                                 |
| `gridPos`          | [GridPos](#gridpos)                               | No       |         | Position and dimensions of a panel in the grid                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `hideTimeOverride` | boolean                                           | No       |         | Controls if the timeFrom or timeShift overrides are shown in the panel header                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `id`               | uint32                                            | No       |         | Unique identifier of the panel. Generated by Grafana when creating a new panel. It must be unique within a dashboard, but not globally.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `interval`         | string                                            | No       |         | The min time interval setting defines a lower limit for the $__interval and $__interval_ms variables.<br/>This value must be formatted as a number followed by a valid time<br/>identifier like: "40s", "3d", etc.<br/>See: https://grafana.com/docs/grafana/latest/panels-visualizations/query-transform-data/#query-options                                                                                                                                                                                                                                                                                                                                                                     |
| `libraryPanel`     | [LibraryPanelRef](#librarypanelref)               | No       |         | A library panel is a reusable panel that you can use in any dashboard.<br/>When you make a change to a library panel, that change propagates to all instances of where the panel is used.<br/>Library panels streamline reuse of panels across multiple dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `links`            | [DashboardLink](#dashboardlink)[]                 | No       |         | Panel links.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `maxDataPoints`    | number                                            | No       |         | The maximum number of data points that the panel queries are retrieving.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `maxPerRow`        | number                                            | No       |         | Option for repeated panels that controls max items per row<br/>Only relevant for horizontally repeated panels                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `options`          | [options](#options)                               | No       |         | It depends on the panel plugin. They are specified by the Options field in panel plugin schemas.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `pluginVersion`    | string                                            | No       |         | The version of the plugin that is used for this panel. This is used to find the plugin to display the panel and to migrate old panel configs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `repeatDirection`  | string                                            | No       | `h`     | Direction to repeat in if 'repeat' is set.<br/>`h` for horizontal, `v` for vertical.<br/>Possible values are: `h`, `v`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `repeat`           | string                                            | No       |         | Name of template variable to repeat for.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `tags`             | string[]                                          | No       |         | Tags for the panel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `targets`          | [Target](#target)[]                               | No       |         | Depends on the panel plugin. See the plugin documentation for details.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `timeFrom`         | string                                            | No       |         | Overrides the relative time range for individual panels,<br/>which causes them to be different than what is selected in<br/>the dashboard time picker in the top-right corner of the dashboard. You can use this to show metrics from different<br/>time periods or days on the same dashboard.<br/>The value is formatted as time operation like: `now-5m` (Last 5 minutes), `now/d` (the day so far),<br/>`now-5d/d`(Last 5 days), `now/w` (This week so far), `now-2y/y` (Last 2 years).<br/>Note: Panel time overrides have no effect when the dashboard’s time range is absolute.<br/>See: https://grafana.com/docs/grafana/latest/panels-visualizations/query-transform-data/#query-options |
| `timeShift`        | string                                            | No       |         | Overrides the time range for individual panels by shifting its start and end relative to the time picker.<br/>For example, you can shift the time range for the panel to be two hours earlier than the dashboard time picker setting `2h`.<br/>Note: Panel time overrides have no effect when the dashboard’s time range is absolute.<br/>See: https://grafana.com/docs/grafana/latest/panels-visualizations/query-transform-data/#query-options                                                                                                                                                                                                                                                  |
| `title`            | string                                            | No       |         | Panel title.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `transformations`  | [DataTransformerConfig](#datatransformerconfig)[] | No       |         | List of transformations that are applied to the panel data before rendering.<br/>When there are multiple transformations, Grafana applies them in the order they are listed.<br/>Each transformation creates a result set that then passes on to the next transformation in the processing pipeline.                                                                                                                                                                                                                                                                                                                                                                                              |
| `transparent`      | boolean                                           | No       | `false` | Whether to display the panel without a background.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |

### Templating

Configured template variables

| Property | Type                              | Required | Default | Description                                                                                  |
|----------|-----------------------------------|----------|---------|----------------------------------------------------------------------------------------------|
| `list`   | [VariableModel](#variablemodel)[] | No       |         | List of configured template variables with their saved values along with some other metadata |

### VariableModel

A variable is a placeholder for a value. You can use variables in metric queries and in panel titles.

| Property      | Type                                | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|---------------|-------------------------------------|----------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `name`        | string                              | **Yes**  |         | Name of variable                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `type`        | string                              | **Yes**  |         | Dashboard variable type<br/>`query`: Query-generated list of values such as metric names, server names, sensor IDs, data centers, and so on.<br/>`adhoc`: Key/value filters that are automatically added to all metric queries for a data source (Prometheus, Loki, InfluxDB, and Elasticsearch only).<br/>`constant`: 	Define a hidden constant.<br/>`datasource`: Quickly change the data source for an entire dashboard.<br/>`interval`: Interval variables represent time spans.<br/>`textbox`: Display a free text input field with an optional default value.<br/>`custom`: Define the variable options manually using a comma-separated list.<br/>`system`: Variables defined by Grafana. See: https://grafana.com/docs/grafana/latest/dashboards/variables/add-template-variables/#global-variables<br/>Possible values are: `query`, `adhoc`, `constant`, `datasource`, `interval`, `textbox`, `custom`, `system`. |
| `current`     | [VariableOption](#variableoption)   | No       |         | Option to be selected in a variable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `datasource`  | [DataSourceRef](#datasourceref)     | No       |         | Ref to a DataSource instance                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `description` | string                              | No       |         | Description of variable. It can be defined but `null`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `hide`        | integer                             | No       |         | Determine if the variable shows on dashboard<br/>Accepted values are 0 (show label and value), 1 (show value only), 2 (show nothing).<br/>Possible values are: `0`, `1`, `2`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `label`       | string                              | No       |         | Optional display name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `multi`       | boolean                             | No       | `false` | Whether multiple values can be selected or not from variable value list                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `options`     | [VariableOption](#variableoption)[] | No       |         | Options that can be selected for a variable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `query`       |                                     | No       |         | Query used to fetch values for a variable                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `refresh`     | integer                             | No       |         | Options to config when to refresh a variable<br/>`0`: Never refresh the variable<br/>`1`: Queries the data source every time the dashboard loads.<br/>`2`: Queries the data source when the dashboard time range changes.<br/>Possible values are: `0`, `1`, `2`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `skipUrlSync` | boolean                             | No       | `false` | Whether the variable value should be managed by URL query params or not                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `sort`        | integer                             | No       |         | Sort variable options<br/>Accepted values are:<br/>`0`: No sorting<br/>`1`: Alphabetical ASC<br/>`2`: Alphabetical DESC<br/>`3`: Numerical ASC<br/>`4`: Numerical DESC<br/>`5`: Alphabetical Case Insensitive ASC<br/>`6`: Alphabetical Case Insensitive DESC<br/>Possible values are: `0`, `1`, `2`, `3`, `4`, `5`, `6`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |

### VariableOption

Option to be selected in a variable.

| Property   | Type    | Required | Default | Description                           |
|------------|---------|----------|---------|---------------------------------------|
| `text`     |         | **Yes**  |         | Text to be displayed for the option   |
| `value`    |         | **Yes**  |         | Value of the option                   |
| `selected` | boolean | No       |         | Whether the option is selected or not |

### Time

Time range for dashboard.
Accepted values are relative time strings like {from: 'now-6h', to: 'now'} or absolute time strings like {from: '2020-07-10T08:00:00.000Z', to: '2020-07-10T14:00:00.000Z'}.

| Property | Type   | Required | Default  | Description |
|----------|--------|----------|----------|-------------|
| `from`   | string | **Yes**  | `now-6h` |             |
| `to`     | string | **Yes**  | `now`    |             |

### Timepicker

Configuration of the time picker shown at the top of a dashboard.

| Property            | Type     | Required | Default                               | Description                                                                                       |
|---------------------|----------|----------|---------------------------------------|---------------------------------------------------------------------------------------------------|
| `collapse`          | boolean  | **Yes**  | `false`                               | Whether timepicker is collapsed or not. Has no effect on provisioned dashboard.                   |
| `hidden`            | boolean  | **Yes**  | `false`                               | Whether timepicker is visible or not.                                                             |
| `refresh_intervals` | string[] | **Yes**  | `[5s 10s 30s 1m 5m 15m 30m 1h 2h 1d]` | Interval options available in the refresh picker dropdown.                                        |
| `time_options`      | string[] | **Yes**  | `[5m 15m 1h 6h 12h 24h 2d 7d 30d]`    | Selectable options available in the time picker dropdown. Has no effect on provisioned dashboard. |

### Status

| Property           | Type                                                       | Required | Default | Description                                                                                                                                                                |
|--------------------|------------------------------------------------------------|----------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `additionalFields` | [object](#additionalfields)                                | No       |         | additionalFields is reserved for future use                                                                                                                                |
| `operatorStates`   | map[string][status.#OperatorState](#status.#operatorstate) | No       |         | operatorStates is a map of operator ID to operator state evaluations.<br/>Any operator which consumes this kind SHOULD add its state evaluation information to this field. |

### AdditionalFields

additionalFields is reserved for future use

| Property | Type | Required | Default | Description |
|----------|------|----------|---------|-------------|

### Status.#OperatorState

| Property           | Type               | Required | Default | Description                                                                                                                                                                      |
|--------------------|--------------------|----------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `lastEvaluation`   | string             | **Yes**  |         | lastEvaluation is the ResourceVersion last evaluated                                                                                                                             |
| `state`            | string             | **Yes**  |         | state describes the state of the lastEvaluation.<br/>It is limited to three possible states for machine evaluation.<br/>Possible values are: `success`, `in_progress`, `failed`. |
| `descriptiveState` | string             | No       |         | descriptiveState is an optional more descriptive state field which has no requirements on format                                                                                 |
| `details`          | [object](#details) | No       |         | details contains any extra information that is operator-specific                                                                                                                 |

### Details

details contains any extra information that is operator-specific

| Property | Type | Required | Default | Description |
|----------|------|----------|---------|-------------|


