/*Package api contains base API implementation of unified alerting
 *
 *Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 *
 *Do not manually edit these files, please find ngalert/api/swagger-codegen/ for commands on how to generate them.
 */
package api

import (
	"net/http"

	"github.com/grafana/grafana/pkg/api/response"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/middleware"
	contextmodel "github.com/grafana/grafana/pkg/services/contexthandler/model"
	apimodels "github.com/grafana/grafana/pkg/services/ngalert/api/tooling/definitions"
	"github.com/grafana/grafana/pkg/services/ngalert/metrics"
	"github.com/grafana/grafana/pkg/web"
)

type TestingApi interface {
	BacktestConfig(*contextmodel.ReqContext) response.Response
	RouteEvalQueries(*contextmodel.ReqContext) response.Response
	RouteTestRuleConfig(*contextmodel.ReqContext) response.Response
	RouteTestRuleGrafanaConfig(*contextmodel.ReqContext) response.Response
}

func (f *TestingApiHandler) BacktestConfig(ctx *contextmodel.ReqContext) response.Response {
	// Parse Request Body
	conf := apimodels.BacktestConfig{}
	if err := web.Bind(ctx.Req, &conf); err != nil {
		return response.Error(http.StatusBadRequest, "bad request data", err)
	}
	return f.handleBacktestConfig(ctx, conf)
}
func (f *TestingApiHandler) RouteEvalQueries(ctx *contextmodel.ReqContext) response.Response {
	// Parse Request Body
	conf := apimodels.EvalQueriesPayload{}
	if err := web.Bind(ctx.Req, &conf); err != nil {
		return response.Error(http.StatusBadRequest, "bad request data", err)
	}
	return f.handleRouteEvalQueries(ctx, conf)
}
func (f *TestingApiHandler) RouteTestRuleConfig(ctx *contextmodel.ReqContext) response.Response {
	// Parse Path Parameters
	datasourceUIDParam := web.Params(ctx.Req)[":DatasourceUID"]
	// Parse Request Body
	conf := apimodels.TestRulePayload{}
	if err := web.Bind(ctx.Req, &conf); err != nil {
		return response.Error(http.StatusBadRequest, "bad request data", err)
	}
	return f.handleRouteTestRuleConfig(ctx, conf, datasourceUIDParam)
}
func (f *TestingApiHandler) RouteTestRuleGrafanaConfig(ctx *contextmodel.ReqContext) response.Response {
	// Parse Request Body
	conf := apimodels.PostableExtendedRuleNodeExtended{}
	if err := web.Bind(ctx.Req, &conf); err != nil {
		return response.Error(http.StatusBadRequest, "bad request data", err)
	}
	return f.handleRouteTestRuleGrafanaConfig(ctx, conf)
}

func (api *API) RegisterTestingApiEndpoints(srv TestingApi, m *metrics.API) {
	api.RouteRegister.Group("", func(group routing.RouteRegister) {
		group.Post(
			toMacaronPath("/api/v1/rule/backtest"),
			api.authorize(http.MethodPost, "/api/v1/rule/backtest"),
			metrics.Instrument(
				http.MethodPost,
				"/api/v1/rule/backtest",
				api.Hooks.Wrap(srv.BacktestConfig),
				m,
			),
		)
		group.Post(
			toMacaronPath("/api/v1/eval"),
			api.authorize(http.MethodPost, "/api/v1/eval"),
			metrics.Instrument(
				http.MethodPost,
				"/api/v1/eval",
				api.Hooks.Wrap(srv.RouteEvalQueries),
				m,
			),
		)
		group.Post(
			toMacaronPath("/api/v1/rule/test/{DatasourceUID}"),
			api.authorize(http.MethodPost, "/api/v1/rule/test/{DatasourceUID}"),
			metrics.Instrument(
				http.MethodPost,
				"/api/v1/rule/test/{DatasourceUID}",
				api.Hooks.Wrap(srv.RouteTestRuleConfig),
				m,
			),
		)
		group.Post(
			toMacaronPath("/api/v1/rule/test/grafana"),
			api.authorize(http.MethodPost, "/api/v1/rule/test/grafana"),
			metrics.Instrument(
				http.MethodPost,
				"/api/v1/rule/test/grafana",
				api.Hooks.Wrap(srv.RouteTestRuleGrafanaConfig),
				m,
			),
		)
	}, middleware.ReqSignedIn)
}
