import { NavIndex } from '@grafana/data';

export const navIndex: NavIndex = {
  dashboards: {
    id: 'dashboards',
    text: 'Dashboards',
    subTitle: 'Manage dashboards and folders',
    icon: 'apps',
    url: '/dashboards',
    sortWeight: -1800,
    children: [
      {
        id: 'manage-dashboards',
        text: 'Browse',
        icon: 'sitemap',
        url: '/dashboards',
      },
      {
        id: 'playlists',
        text: 'Playlists',
        icon: 'presentation-play',
        url: '/playlists',
      },
      {
        id: 'snapshots',
        text: 'Snapshots',
        icon: 'camera',
        url: '/dashboard/snapshots',
      },
      {
        id: 'library-panels',
        text: 'Library panels',
        icon: 'library-panel',
        url: '/library-panels',
      },
      {
        id: 'new-dashboard',
        text: 'New dashboard',
        icon: 'plus',
        url: '/dashboard/new',
        hideFromTabs: true,
      },
      {
        id: 'new-folder',
        text: 'New folder',
        subTitle: 'Create a new folder to organize your dashboards',
        icon: 'plus',
        url: '/dashboards/folder/new',
        hideFromTabs: true,
      },
      {
        id: 'import',
        text: 'Import',
        subTitle: 'Import dashboard from file or Grafana.com',
        icon: 'plus',
        url: '/dashboard/import',
        hideFromTabs: true,
      },
    ],
  },
  'manage-dashboards': {
    id: 'manage-dashboards',
    text: 'Browse',
    icon: 'sitemap',
    url: '/dashboards',
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  playlists: {
    id: 'playlists',
    text: 'Playlists',
    icon: 'presentation-play',
    url: '/playlists',
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  snapshots: {
    id: 'snapshots',
    text: 'Snapshots',
    icon: 'camera',
    url: '/dashboard/snapshots',
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  'library-panels': {
    id: 'library-panels',
    text: 'Library panels',
    icon: 'library-panel',
    url: '/library-panels',
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  'new-dashboard': {
    id: 'new-dashboard',
    text: 'New dashboard',
    icon: 'plus',
    url: '/dashboard/new',
    hideFromTabs: true,
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  'new-folder': {
    id: 'new-folder',
    text: 'New folder',
    subTitle: 'Create a new folder to organize your dashboards',
    icon: 'plus',
    url: '/dashboards/folder/new',
    hideFromTabs: true,
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  import: {
    id: 'import',
    text: 'Import',
    subTitle: 'Import dashboard from file or Grafana.com',
    icon: 'plus',
    url: '/dashboard/import',
    hideFromTabs: true,
    parentItem: {
      id: 'dashboards',
      text: 'Dashboards',
      subTitle: 'Manage dashboards and folders',
      icon: 'apps',
      url: '/dashboards',
      sortWeight: -1800,
      children: [
        {
          id: 'manage-dashboards',
          text: 'Browse',
          icon: 'sitemap',
          url: '/dashboards',
        },
        {
          id: 'playlists',
          text: 'Playlists',
          icon: 'presentation-play',
          url: '/playlists',
        },
        {
          id: 'snapshots',
          text: 'Snapshots',
          icon: 'camera',
          url: '/dashboard/snapshots',
        },
        {
          id: 'library-panels',
          text: 'Library panels',
          icon: 'library-panel',
          url: '/library-panels',
        },
        {
          id: 'new-dashboard',
          text: 'New dashboard',
          icon: 'plus',
          url: '/dashboard/new',
          hideFromTabs: true,
        },
        {
          id: 'new-folder',
          text: 'New folder',
          subTitle: 'Create a new folder to organize your dashboards',
          icon: 'plus',
          url: '/dashboards/folder/new',
          hideFromTabs: true,
        },
        {
          id: 'import',
          text: 'Import',
          subTitle: 'Import dashboard from file or Grafana.com',
          icon: 'plus',
          url: '/dashboard/import',
          hideFromTabs: true,
        },
      ],
    },
  },
  'not-found': {
    text: 'Page not found',
    subTitle: '404 Error',
    icon: 'exclamation-triangle',
  },
  explore: {
    id: 'explore',
    text: 'Explore',
    subTitle: 'Explore your data',
    icon: 'compass',
    url: '/explore',
    sortWeight: -1700,
  },
  alerting: {
    id: 'alerting',
    text: 'Alerting',
    subTitle: 'Alert rules and notifications',
    icon: 'bell',
    url: '/alerting/list',
    sortWeight: -1600,
    children: [
      {
        id: 'alert-list',
        text: 'Alert rules',
        icon: 'list-ul',
        url: '/alerting/list',
      },
      {
        id: 'receivers',
        text: 'Contact points',
        icon: 'comment-alt-share',
        url: '/alerting/notifications',
      },
      {
        id: 'am-routes',
        text: 'Notification policies',
        icon: 'sitemap',
        url: '/alerting/routes',
      },
      {
        id: 'silences',
        text: 'Silences',
        icon: 'bell-slash',
        url: '/alerting/silences',
      },
      {
        id: 'groups',
        text: 'Alert groups',
        icon: 'layer-group',
        url: '/alerting/groups',
      },
      {
        id: 'alerting-admin',
        text: 'Admin',
        icon: 'cog',
        url: '/alerting/admin',
      },
      {
        id: 'alert',
        text: 'Create alert rule',
        subTitle: 'Create an alert rule',
        icon: 'plus',
        url: '/alerting/new',
        hideFromTabs: true,
      },
    ],
  },
  'alert-list': {
    id: 'alert-list',
    text: 'Alert rules',
    icon: 'list-ul',
    url: '/alerting/list',
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  receivers: {
    id: 'receivers',
    text: 'Contact points',
    icon: 'comment-alt-share',
    url: '/alerting/notifications',
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  'am-routes': {
    id: 'am-routes',
    text: 'Notification policies',
    icon: 'sitemap',
    url: '/alerting/routes',
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  silences: {
    id: 'silences',
    text: 'Silences',
    icon: 'bell-slash',
    url: '/alerting/silences',
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  groups: {
    id: 'groups',
    text: 'Alert groups',
    icon: 'layer-group',
    url: '/alerting/groups',
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  'alerting-admin': {
    id: 'alerting-admin',
    text: 'Admin',
    icon: 'cog',
    url: '/alerting/admin',
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  alert: {
    id: 'alert',
    text: 'Create alert rule',
    subTitle: 'Create an alert rule',
    icon: 'plus',
    url: '/alerting/new',
    hideFromTabs: true,
    parentItem: {
      id: 'alerting',
      text: 'Alerting',
      subTitle: 'Alert rules and notifications',
      icon: 'bell',
      url: '/alerting/list',
      sortWeight: -1600,
      children: [
        {
          id: 'alert-list',
          text: 'Alert rules',
          icon: 'list-ul',
          url: '/alerting/list',
        },
        {
          id: 'receivers',
          text: 'Contact points',
          icon: 'comment-alt-share',
          url: '/alerting/notifications',
        },
        {
          id: 'am-routes',
          text: 'Notification policies',
          icon: 'sitemap',
          url: '/alerting/routes',
        },
        {
          id: 'silences',
          text: 'Silences',
          icon: 'bell-slash',
          url: '/alerting/silences',
        },
        {
          id: 'groups',
          text: 'Alert groups',
          icon: 'layer-group',
          url: '/alerting/groups',
        },
        {
          id: 'alerting-admin',
          text: 'Admin',
          icon: 'cog',
          url: '/alerting/admin',
        },
        {
          id: 'alert',
          text: 'Create alert rule',
          subTitle: 'Create an alert rule',
          icon: 'plus',
          url: '/alerting/new',
          hideFromTabs: true,
        },
      ],
    },
  },
  connections: {
    id: 'connections',
    text: 'Connections',
    icon: 'link',
    url: '/connections',
    sortWeight: -1500,
    children: [
      {
        id: 'connections-datasources',
        text: 'Data sources',
        description: 'Add and configure data sources',
        icon: 'database',
        url: '/connections/datasources',
      },
      {
        id: 'connections-plugins',
        text: 'Plugins',
        description: 'Manage plugins',
        icon: 'plug',
        url: '/connections/plugins',
      },
      {
        id: 'connections-cloud-integrations',
        text: 'Cloud integrations',
        description: 'Manage your cloud integrations',
        icon: 'bolt',
        url: '/connections/cloud-integrations',
      },
      {
        id: 'connections-recorded-queries',
        text: 'Recorded queries',
        description: 'Manage your recorded queries',
        icon: 'record-audio',
        url: '/connections/recorded-queries',
      },
    ],
  },
  'connections-datasources': {
    id: 'connections-datasources',
    text: 'Data sources',
    description: 'Add and configure data sources',
    icon: 'database',
    url: '/connections/datasources',
    parentItem: {
      id: 'connections',
      text: 'Connections',
      icon: 'link',
      url: '/connections',
      sortWeight: -1500,
      children: [
        {
          id: 'connections-datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/connections/datasources',
        },
        {
          id: 'connections-plugins',
          text: 'Plugins',
          description: 'Manage plugins',
          icon: 'plug',
          url: '/connections/plugins',
        },
        {
          id: 'connections-cloud-integrations',
          text: 'Cloud integrations',
          description: 'Manage your cloud integrations',
          icon: 'bolt',
          url: '/connections/cloud-integrations',
        },
        {
          id: 'connections-recorded-queries',
          text: 'Recorded queries',
          description: 'Manage your recorded queries',
          icon: 'record-audio',
          url: '/connections/recorded-queries',
        },
      ],
    },
  },
  'connections-plugins': {
    id: 'connections-plugins',
    text: 'Plugins',
    description: 'Manage plugins',
    icon: 'plug',
    url: '/connections/plugins',
    parentItem: {
      id: 'connections',
      text: 'Connections',
      icon: 'link',
      url: '/connections',
      sortWeight: -1500,
      children: [
        {
          id: 'connections-datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/connections/datasources',
        },
        {
          id: 'connections-plugins',
          text: 'Plugins',
          description: 'Manage plugins',
          icon: 'plug',
          url: '/connections/plugins',
        },
        {
          id: 'connections-cloud-integrations',
          text: 'Cloud integrations',
          description: 'Manage your cloud integrations',
          icon: 'bolt',
          url: '/connections/cloud-integrations',
        },
        {
          id: 'connections-recorded-queries',
          text: 'Recorded queries',
          description: 'Manage your recorded queries',
          icon: 'record-audio',
          url: '/connections/recorded-queries',
        },
      ],
    },
  },
  'connections-cloud-integrations': {
    id: 'connections-cloud-integrations',
    text: 'Cloud integrations',
    description: 'Manage your cloud integrations',
    icon: 'bolt',
    url: '/connections/cloud-integrations',
    parentItem: {
      id: 'connections',
      text: 'Connections',
      icon: 'link',
      url: '/connections',
      sortWeight: -1500,
      children: [
        {
          id: 'connections-datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/connections/datasources',
        },
        {
          id: 'connections-plugins',
          text: 'Plugins',
          description: 'Manage plugins',
          icon: 'plug',
          url: '/connections/plugins',
        },
        {
          id: 'connections-cloud-integrations',
          text: 'Cloud integrations',
          description: 'Manage your cloud integrations',
          icon: 'bolt',
          url: '/connections/cloud-integrations',
        },
        {
          id: 'connections-recorded-queries',
          text: 'Recorded queries',
          description: 'Manage your recorded queries',
          icon: 'record-audio',
          url: '/connections/recorded-queries',
        },
      ],
    },
  },
  'connections-recorded-queries': {
    id: 'connections-recorded-queries',
    text: 'Recorded queries',
    description: 'Manage your recorded queries',
    icon: 'record-audio',
    url: '/connections/recorded-queries',
    parentItem: {
      id: 'connections',
      text: 'Connections',
      icon: 'link',
      url: '/connections',
      sortWeight: -1500,
      children: [
        {
          id: 'connections-datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/connections/datasources',
        },
        {
          id: 'connections-plugins',
          text: 'Plugins',
          description: 'Manage plugins',
          icon: 'plug',
          url: '/connections/plugins',
        },
        {
          id: 'connections-cloud-integrations',
          text: 'Cloud integrations',
          description: 'Manage your cloud integrations',
          icon: 'bolt',
          url: '/connections/cloud-integrations',
        },
        {
          id: 'connections-recorded-queries',
          text: 'Recorded queries',
          description: 'Manage your recorded queries',
          icon: 'record-audio',
          url: '/connections/recorded-queries',
        },
      ],
    },
  },
  'plugin-page-basic-app': {
    id: 'plugin-page-basic-app',
    text: 'Basic App',
    img: 'public/plugins/basic-app/img/logo.svg',
    url: '/a/basic-app/one',
    sortWeight: -1400,
    children: [
      {
        text: 'Page One',
        url: '/a/basic-app/one',
      },
      {
        text: 'Page Two',
        url: '/a/basic-app/two',
      },
      {
        text: 'Page Three',
        url: '/a/basic-app/three',
      },
      {
        text: 'Page Four',
        url: '/a/basic-app/four',
      },
      {
        text: 'Configuration',
        icon: 'cog',
        url: '/plugins/basic-app',
      },
    ],
  },
  undefined: {
    text: 'Config',
    url: '/plugins/grafana-synthetic-monitoring-app',
    parentItem: {
      id: 'plugin-page-grafana-synthetic-monitoring-app',
      text: 'Synthetic Monitoring',
      img: 'public/plugins/grafana-synthetic-monitoring-app/img/logo.svg',
      url: '/a/grafana-synthetic-monitoring-app/home',
      sortWeight: -1400,
      children: [
        {
          text: 'Home',
          url: '/a/grafana-synthetic-monitoring-app/home',
        },
        {
          text: 'Summary',
          url: '/a/grafana-synthetic-monitoring-app/redirect?dashboard=summary',
        },
        {
          text: 'Checks',
          url: '/a/grafana-synthetic-monitoring-app/checks',
        },
        {
          text: 'Probes',
          url: '/a/grafana-synthetic-monitoring-app/probes',
        },
        {
          text: 'Alerts',
          url: '/a/grafana-synthetic-monitoring-app/alerts',
        },
        {
          text: 'Config',
          url: '/plugins/grafana-synthetic-monitoring-app',
        },
      ],
    },
  },
  'plugin-page-cloudflare-app': {
    id: 'plugin-page-cloudflare-app',
    text: 'Cloudflare Grafana App',
    img: 'public/plugins/cloudflare-app/img/cf_icon.png',
    sortWeight: -1400,
    children: [
      {
        text: 'Zones',
        url: '/d/KAVdMAw9k',
      },
      {
        text: 'DNS Firewall',
        url: '/d/QrKttDVqu',
      },
    ],
  },
  'plugin-page-grafana-easystart-app': {
    id: 'plugin-page-grafana-easystart-app',
    text: 'Integrations and Connections',
    img: 'public/plugins/grafana-easystart-app/img/logo.svg',
    url: '/a/grafana-easystart-app',
    sortWeight: -1400,
  },
  'plugin-page-redis-explorer-app': {
    id: 'plugin-page-redis-explorer-app',
    text: 'Redis Explorer',
    img: 'public/plugins/redis-explorer-app/img/logo.svg',
    url: '/a/redis-explorer-app/',
    sortWeight: -1400,
    children: [
      {
        text: 'Home',
        icon: 'home-alt',
        url: '/a/redis-explorer-app/',
      },
      {
        text: 'Enterprise Clusters',
        icon: 'apps',
        url: '/d/1dKhTjtGk',
      },
      {
        text: 'Cluster Overview',
        icon: 'monitor',
        url: '/d/viroIzSGz',
      },
      {
        text: 'Cluster Nodes',
        icon: 'sitemap',
        url: '/d/hqze6rtGz',
      },
      {
        text: 'Cluster Databases',
        icon: 'database',
        url: '/d/k_A8MjtMk',
      },
      {
        text: 'Cluster Alerts',
        icon: 'info-circle',
        url: '/d/xESAiFcnk',
      },
    ],
  },
  'plugin-page-grafana-synthetic-monitoring-app': {
    id: 'plugin-page-grafana-synthetic-monitoring-app',
    text: 'Synthetic Monitoring',
    img: 'public/plugins/grafana-synthetic-monitoring-app/img/logo.svg',
    url: '/a/grafana-synthetic-monitoring-app/home',
    sortWeight: -1400,
    children: [
      {
        text: 'Home',
        url: '/a/grafana-synthetic-monitoring-app/home',
      },
      {
        text: 'Summary',
        url: '/a/grafana-synthetic-monitoring-app/redirect?dashboard=summary',
      },
      {
        text: 'Checks',
        url: '/a/grafana-synthetic-monitoring-app/checks',
      },
      {
        text: 'Probes',
        url: '/a/grafana-synthetic-monitoring-app/probes',
      },
      {
        text: 'Alerts',
        url: '/a/grafana-synthetic-monitoring-app/alerts',
      },
      {
        text: 'Config',
        url: '/plugins/grafana-synthetic-monitoring-app',
      },
    ],
  },
  'plugin-page-grafana-k6-app': {
    id: 'plugin-page-grafana-k6-app',
    text: 'k6 Cloud App',
    img: 'public/plugins/grafana-k6-app/img/logo.svg',
    url: '/a/grafana-k6-app',
    sortWeight: -1400,
  },
  cfg: {
    id: 'cfg',
    text: 'Configuration',
    subTitle: 'Organization: Main Org.',
    icon: 'cog',
    url: '/datasources',
    sortWeight: -1300,
    children: [
      {
        id: 'datasources',
        text: 'Data sources',
        description: 'Add and configure data sources',
        icon: 'database',
        url: '/datasources',
      },
      {
        id: 'users',
        text: 'Users',
        description: 'Manage org members',
        icon: 'user',
        url: '/org/users',
      },
      {
        id: 'teams',
        text: 'Teams',
        description: 'Manage org groups',
        icon: 'users-alt',
        url: '/org/teams',
      },
      {
        id: 'plugins',
        text: 'Plugins',
        description: 'View and configure plugins',
        icon: 'plug',
        url: '/plugins',
      },
      {
        id: 'org-settings',
        text: 'Preferences',
        description: 'Organization preferences',
        icon: 'sliders-v-alt',
        url: '/org',
      },
      {
        id: 'apikeys',
        text: 'API keys',
        description: 'Create & manage API keys',
        icon: 'key-skeleton-alt',
        url: '/org/apikeys',
      },
      {
        id: 'serviceaccounts',
        text: 'Service accounts',
        description: 'Manage service accounts',
        icon: 'gf-service-account',
        url: '/org/serviceaccounts',
      },
    ],
  },
  datasources: {
    id: 'datasources',
    text: 'Data sources',
    description: 'Add and configure data sources',
    icon: 'database',
    url: '/datasources',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  users: {
    id: 'users',
    text: 'Users',
    description: 'Manage org members',
    icon: 'user',
    url: '/org/users',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  teams: {
    id: 'teams',
    text: 'Teams',
    description: 'Manage org groups',
    icon: 'users-alt',
    url: '/org/teams',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  plugins: {
    id: 'plugins',
    text: 'Plugins',
    description: 'View and configure plugins',
    icon: 'plug',
    url: '/plugins',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  'org-settings': {
    id: 'org-settings',
    text: 'Preferences',
    description: 'Organization preferences',
    icon: 'sliders-v-alt',
    url: '/org',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  apikeys: {
    id: 'apikeys',
    text: 'API keys',
    description: 'Create & manage API keys',
    icon: 'key-skeleton-alt',
    url: '/org/apikeys',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  serviceaccounts: {
    id: 'serviceaccounts',
    text: 'Service accounts',
    description: 'Manage service accounts',
    icon: 'gf-service-account',
    url: '/org/serviceaccounts',
    parentItem: {
      id: 'cfg',
      text: 'Configuration',
      subTitle: 'Organization: Main Org.',
      icon: 'cog',
      url: '/datasources',
      sortWeight: -1300,
      children: [
        {
          id: 'datasources',
          text: 'Data sources',
          description: 'Add and configure data sources',
          icon: 'database',
          url: '/datasources',
        },
        {
          id: 'users',
          text: 'Users',
          description: 'Manage org members',
          icon: 'user',
          url: '/org/users',
        },
        {
          id: 'teams',
          text: 'Teams',
          description: 'Manage org groups',
          icon: 'users-alt',
          url: '/org/teams',
        },
        {
          id: 'plugins',
          text: 'Plugins',
          description: 'View and configure plugins',
          icon: 'plug',
          url: '/plugins',
        },
        {
          id: 'org-settings',
          text: 'Preferences',
          description: 'Organization preferences',
          icon: 'sliders-v-alt',
          url: '/org',
        },
        {
          id: 'apikeys',
          text: 'API keys',
          description: 'Create & manage API keys',
          icon: 'key-skeleton-alt',
          url: '/org/apikeys',
        },
        {
          id: 'serviceaccounts',
          text: 'Service accounts',
          description: 'Manage service accounts',
          icon: 'gf-service-account',
          url: '/org/serviceaccounts',
        },
      ],
    },
  },
  admin: {
    id: 'admin',
    text: 'Server Admin',
    subTitle: 'Manage all users and orgs',
    icon: 'shield',
    url: '/admin/users',
    sortWeight: -1200,
    hideFromTabs: true,
    children: [
      {
        id: 'global-users',
        text: 'Users',
        icon: 'user',
        url: '/admin/users',
      },
      {
        id: 'global-orgs',
        text: 'Orgs',
        icon: 'building',
        url: '/admin/orgs',
      },
      {
        id: 'server-settings',
        text: 'Settings',
        icon: 'sliders-v-alt',
        url: '/admin/settings',
      },
      {
        id: 'admin-plugins',
        text: 'Plugins',
        icon: 'plug',
        url: '/admin/plugins',
      },
      {
        id: 'upgrading',
        text: 'Stats and license',
        icon: 'unlock',
        url: '/admin/upgrading',
      },
    ],
  },
  'global-users': {
    id: 'global-users',
    text: 'Users',
    icon: 'user',
    url: '/admin/users',
    parentItem: {
      id: 'admin',
      text: 'Server Admin',
      subTitle: 'Manage all users and orgs',
      icon: 'shield',
      url: '/admin/users',
      sortWeight: -1200,
      hideFromTabs: true,
      children: [
        {
          id: 'global-users',
          text: 'Users',
          icon: 'user',
          url: '/admin/users',
        },
        {
          id: 'global-orgs',
          text: 'Orgs',
          icon: 'building',
          url: '/admin/orgs',
        },
        {
          id: 'server-settings',
          text: 'Settings',
          icon: 'sliders-v-alt',
          url: '/admin/settings',
        },
        {
          id: 'admin-plugins',
          text: 'Plugins',
          icon: 'plug',
          url: '/admin/plugins',
        },
        {
          id: 'upgrading',
          text: 'Stats and license',
          icon: 'unlock',
          url: '/admin/upgrading',
        },
      ],
    },
  },
  'global-orgs': {
    id: 'global-orgs',
    text: 'Orgs',
    icon: 'building',
    url: '/admin/orgs',
    parentItem: {
      id: 'admin',
      text: 'Server Admin',
      subTitle: 'Manage all users and orgs',
      icon: 'shield',
      url: '/admin/users',
      sortWeight: -1200,
      hideFromTabs: true,
      children: [
        {
          id: 'global-users',
          text: 'Users',
          icon: 'user',
          url: '/admin/users',
        },
        {
          id: 'global-orgs',
          text: 'Orgs',
          icon: 'building',
          url: '/admin/orgs',
        },
        {
          id: 'server-settings',
          text: 'Settings',
          icon: 'sliders-v-alt',
          url: '/admin/settings',
        },
        {
          id: 'admin-plugins',
          text: 'Plugins',
          icon: 'plug',
          url: '/admin/plugins',
        },
        {
          id: 'upgrading',
          text: 'Stats and license',
          icon: 'unlock',
          url: '/admin/upgrading',
        },
      ],
    },
  },
  'server-settings': {
    id: 'server-settings',
    text: 'Settings',
    icon: 'sliders-v-alt',
    url: '/admin/settings',
    parentItem: {
      id: 'admin',
      text: 'Server Admin',
      subTitle: 'Manage all users and orgs',
      icon: 'shield',
      url: '/admin/users',
      sortWeight: -1200,
      hideFromTabs: true,
      children: [
        {
          id: 'global-users',
          text: 'Users',
          icon: 'user',
          url: '/admin/users',
        },
        {
          id: 'global-orgs',
          text: 'Orgs',
          icon: 'building',
          url: '/admin/orgs',
        },
        {
          id: 'server-settings',
          text: 'Settings',
          icon: 'sliders-v-alt',
          url: '/admin/settings',
        },
        {
          id: 'admin-plugins',
          text: 'Plugins',
          icon: 'plug',
          url: '/admin/plugins',
        },
        {
          id: 'upgrading',
          text: 'Stats and license',
          icon: 'unlock',
          url: '/admin/upgrading',
        },
      ],
    },
  },
  'admin-plugins': {
    id: 'admin-plugins',
    text: 'Plugins',
    icon: 'plug',
    url: '/admin/plugins',
    parentItem: {
      id: 'admin',
      text: 'Server Admin',
      subTitle: 'Manage all users and orgs',
      icon: 'shield',
      url: '/admin/users',
      sortWeight: -1200,
      hideFromTabs: true,
      children: [
        {
          id: 'global-users',
          text: 'Users',
          icon: 'user',
          url: '/admin/users',
        },
        {
          id: 'global-orgs',
          text: 'Orgs',
          icon: 'building',
          url: '/admin/orgs',
        },
        {
          id: 'server-settings',
          text: 'Settings',
          icon: 'sliders-v-alt',
          url: '/admin/settings',
        },
        {
          id: 'admin-plugins',
          text: 'Plugins',
          icon: 'plug',
          url: '/admin/plugins',
        },
        {
          id: 'upgrading',
          text: 'Stats and license',
          icon: 'unlock',
          url: '/admin/upgrading',
        },
      ],
    },
  },
  upgrading: {
    id: 'upgrading',
    text: 'Stats and license',
    icon: 'unlock',
    url: '/admin/upgrading',
    parentItem: {
      id: 'admin',
      text: 'Server Admin',
      subTitle: 'Manage all users and orgs',
      icon: 'shield',
      url: '/admin/users',
      sortWeight: -1200,
      hideFromTabs: true,
      children: [
        {
          id: 'global-users',
          text: 'Users',
          icon: 'user',
          url: '/admin/users',
        },
        {
          id: 'global-orgs',
          text: 'Orgs',
          icon: 'building',
          url: '/admin/orgs',
        },
        {
          id: 'server-settings',
          text: 'Settings',
          icon: 'sliders-v-alt',
          url: '/admin/settings',
        },
        {
          id: 'admin-plugins',
          text: 'Plugins',
          icon: 'plug',
          url: '/admin/plugins',
        },
        {
          id: 'upgrading',
          text: 'Stats and license',
          icon: 'unlock',
          url: '/admin/upgrading',
        },
      ],
    },
  },
  profile: {
    id: 'profile',
    text: 'admin',
    img: '/avatar/46d229b033af06a191ff2267bca9ae56',
    url: '/profile',
    sortWeight: -1100,
    children: [
      {
        id: 'profile-settings',
        text: 'Preferences',
        icon: 'sliders-v-alt',
        url: '/profile',
      },
      {
        id: 'notifications',
        text: 'Notification history',
        icon: 'bell',
        url: '/notifications',
      },
      {
        id: 'change-password',
        text: 'Change password',
        icon: 'lock',
        url: '/profile/password',
      },
      {
        id: 'sign-out',
        text: 'Sign out',
        icon: 'arrow-from-right',
        url: '/logout',
        target: '_self',
        hideFromTabs: true,
      },
    ],
  },
  'profile-settings': {
    id: 'profile-settings',
    text: 'Preferences',
    icon: 'sliders-v-alt',
    url: '/profile',
    parentItem: {
      id: 'profile',
      text: 'admin',
      img: '/avatar/46d229b033af06a191ff2267bca9ae56',
      url: '/profile',
      sortWeight: -1100,
      children: [
        {
          id: 'profile-settings',
          text: 'Preferences',
          icon: 'sliders-v-alt',
          url: '/profile',
        },
        {
          id: 'notifications',
          text: 'Notification history',
          icon: 'bell',
          url: '/notifications',
        },
        {
          id: 'change-password',
          text: 'Change password',
          icon: 'lock',
          url: '/profile/password',
        },
        {
          id: 'sign-out',
          text: 'Sign out',
          icon: 'arrow-from-right',
          url: '/logout',
          target: '_self',
          hideFromTabs: true,
        },
      ],
    },
  },
  notifications: {
    id: 'notifications',
    text: 'Notification history',
    icon: 'bell',
    url: '/notifications',
    parentItem: {
      id: 'profile',
      text: 'admin',
      img: '/avatar/46d229b033af06a191ff2267bca9ae56',
      url: '/profile',
      sortWeight: -1100,
      children: [
        {
          id: 'profile-settings',
          text: 'Preferences',
          icon: 'sliders-v-alt',
          url: '/profile',
        },
        {
          id: 'notifications',
          text: 'Notification history',
          icon: 'bell',
          url: '/notifications',
        },
        {
          id: 'change-password',
          text: 'Change password',
          icon: 'lock',
          url: '/profile/password',
        },
        {
          id: 'sign-out',
          text: 'Sign out',
          icon: 'arrow-from-right',
          url: '/logout',
          target: '_self',
          hideFromTabs: true,
        },
      ],
    },
  },
  'change-password': {
    id: 'change-password',
    text: 'Change password',
    icon: 'lock',
    url: '/profile/password',
    parentItem: {
      id: 'profile',
      text: 'admin',
      img: '/avatar/46d229b033af06a191ff2267bca9ae56',
      url: '/profile',
      sortWeight: -1100,
      children: [
        {
          id: 'profile-settings',
          text: 'Preferences',
          icon: 'sliders-v-alt',
          url: '/profile',
        },
        {
          id: 'notifications',
          text: 'Notification history',
          icon: 'bell',
          url: '/notifications',
        },
        {
          id: 'change-password',
          text: 'Change password',
          icon: 'lock',
          url: '/profile/password',
        },
        {
          id: 'sign-out',
          text: 'Sign out',
          icon: 'arrow-from-right',
          url: '/logout',
          target: '_self',
          hideFromTabs: true,
        },
      ],
    },
  },
  'sign-out': {
    id: 'sign-out',
    text: 'Sign out',
    icon: 'arrow-from-right',
    url: '/logout',
    target: '_self',
    hideFromTabs: true,
    parentItem: {
      id: 'profile',
      text: 'admin',
      img: '/avatar/46d229b033af06a191ff2267bca9ae56',
      url: '/profile',
      sortWeight: -1100,
      children: [
        {
          id: 'profile-settings',
          text: 'Preferences',
          icon: 'sliders-v-alt',
          url: '/profile',
        },
        {
          id: 'notifications',
          text: 'Notification history',
          icon: 'bell',
          url: '/notifications',
        },
        {
          id: 'change-password',
          text: 'Change password',
          icon: 'lock',
          url: '/profile/password',
        },
        {
          id: 'sign-out',
          text: 'Sign out',
          icon: 'arrow-from-right',
          url: '/logout',
          target: '_self',
          hideFromTabs: true,
        },
      ],
    },
  },
  help: {
    id: 'help',
    text: 'Help',
    subTitle: 'Grafana v9.0.0-pre (cd35366222)',
    icon: 'question-circle',
    url: '#',
    sortWeight: -1000,
  },
};
