---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
description: Learn about toggles for experimental and beta features, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L19 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to turn experimental or beta features on and off in Grafana. Although we do not recommend using these features in production, you can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation]({{< relref "../_index.md#feature_toggles" >}}). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

## Stable feature toggles

Some stable features are enabled by default. You can disable a stable feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                 | Description                                                                                                                                                                                         | Enabled by default |
| ----------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`         | Disable envelope encryption (emergency only)                                                                                                                                                        |                    |
| `featureHighlights`                 | Highlight Grafana Enterprise features                                                                                                                                                               |                    |
| `exploreMixedDatasource`            | Enable mixed datasource in Explore                                                                                                                                                                  | Yes                |
| `cloudWatchDynamicLabels`           | Use dynamic labels instead of alias patterns in CloudWatch datasource                                                                                                                               | Yes                |
| `dataConnectionsConsole`            | Enables a new top-level page called Connections. This page is an experiment that provides a better experience when you install and configure data sources and other plugins.                        | Yes                |
| `internationalization`              | Enables internationalization                                                                                                                                                                        | Yes                |
| `topnav`                            | Enables new top navigation and page layouts                                                                                                                                                         | Yes                |
| `cloudWatchCrossAccountQuerying`    | Enables cross-account querying in CloudWatch datasources                                                                                                                                            | Yes                |
| `newPanelChromeUI`                  | Show updated look and feel of grafana-ui PanelChrome: panel header, icons, and menu                                                                                                                 | Yes                |
| `accessTokenExpirationCheck`        | Enable OAuth access_token expiration check and token refresh using the refresh_token                                                                                                                |                    |
| `emptyDashboardPage`                | Enable the redesigned user interface of a dashboard page that includes no panels                                                                                                                    | Yes                |
| `disablePrometheusExemplarSampling` | Disable Prometheus exemplar sampling                                                                                                                                                                |                    |
| `logsSampleInExplore`               | Enables access to the logs sample feature in Explore                                                                                                                                                | Yes                |
| `logsContextDatasourceUi`           | Allow datasource to provide custom UI for context view                                                                                                                                              | Yes                |
| `prometheusDataplane`               | Changes responses to from Prometheus to be compliant with the dataplane specification. In particular it sets the numeric Field.Name from 'Value' to the value of the `__name__` label when present. | Yes                |
| `lokiMetricDataplane`               | Changes metric responses from Loki to be compliant with the dataplane specification.                                                                                                                | Yes                |
| `dataplaneFrontendFallback`         | Support dataplane contract field name change for transformations and field name matchers where the name is different                                                                                | Yes                |
| `useCachingService`                 | When turned on, the new query and resource caching implementation using a wire service inject will be used in place of the previous middleware implementation                                       |                    |
| `authenticationConfigUI`            | Enables authentication configuration UI                                                                                                                                                             | Yes                |
| `advancedDataSourcePicker`          | Enable a new data source picker with contextual information, recently used order and advanced mode                                                                                                  | Yes                |

## Beta feature toggles

| Feature toggle name                  | Description                                                                                                                                                                                  |
| ------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `trimDefaults`                       | Use cue schema to remove values that will be applied automatically                                                                                                                           |
| `panelTitleSearch`                   | Search for dashboards using panel title                                                                                                                                                      |
| `prometheusAzureOverrideAudience`    | Experimental. Allow override default AAD audience for Azure Prometheus endpoint                                                                                                              |
| `publicDashboards`                   | Enables public access to dashboards                                                                                                                                                          |
| `publicDashboardsEmailSharing`       | Enables public dashboard sharing to be restricted to only allowed emails                                                                                                                     |
| `migrationLocking`                   | Lock database during migrations                                                                                                                                                              |
| `correlations`                       | Correlations page                                                                                                                                                                            |
| `newDBLibrary`                       | Use jmoiron/sqlx rather than xorm for a few backend services                                                                                                                                 |
| `validateDashboardsOnSave`           | Validate dashboard JSON POSTed to api/dashboards/db                                                                                                                                          |
| `autoMigrateOldPanels`               | Migrate old angular panels to supported versions (graph, table-old, worldmap, etc)                                                                                                           |
| `disableAngular`                     | Dynamic flag to disable angular at runtime. The preferred method is to set `angular_support_enabled` to `false` in the [security] settings, which allows you to change the state at runtime. |
| `grpcServer`                         | Run the GRPC server                                                                                                                                                                          |
| `accessControlOnCall`                | Access control primitives for OnCall                                                                                                                                                         |
| `nestedFolders`                      | Enable folder nesting                                                                                                                                                                        |
| `alertingNoNormalState`              | Stop maintaining state of alerts that are not firing                                                                                                                                         |
| `renderAuthJWT`                      | Uses JWT-based auth for rendering instead of relying on remote cache                                                                                                                         |
| `refactorVariablesTimeRange`         | Refactor time range variables flow to reduce number of API calls made when query variables are chained                                                                                       |
| `enableElasticsearchBackendQuerying` | Enable the processing of queries and responses in the Elasticsearch data source through backend                                                                                              |
| `enableDatagridEditing`              | Enables the edit functionality in the datagrid panel                                                                                                                                         |

## Alpha feature toggles

These features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Alpha features might be changed or removed without prior notice.

| Feature toggle name                | Description                                                                                                  |
| ---------------------------------- | ------------------------------------------------------------------------------------------------------------ |
| `live-service-web-worker`          | This will use a webworker thread to processes events rather than the main thread                             |
| `queryOverLive`                    | Use Grafana Live WebSocket to execute backend queries                                                        |
| `lokiLive`                         | Support WebSocket streaming for loki (early prototype)                                                       |
| `storage`                          | Configurable storage for dashboards, datasources, and resources                                              |
| `newTraceViewHeader`               | Shows the new trace view header                                                                              |
| `datasourceQueryMultiStatus`       | Introduce HTTP 207 Multi Status for api/ds/query                                                             |
| `traceToMetrics`                   | Enable trace to metrics links                                                                                |
| `prometheusWideSeries`             | Enable wide series responses in the Prometheus datasource                                                    |
| `canvasPanelNesting`               | Allow elements nesting                                                                                       |
| `scenes`                           | Experimental framework to build interactive dashboards                                                       |
| `disableSecretsCompatibility`      | Disable duplicated secret storage in legacy tables                                                           |
| `logRequestsInstrumentedAsUnknown` | Logs the path for requests that are instrumented as unknown                                                  |
| `redshiftAsyncQueryDataSupport`    | Enable async query data support for Redshift                                                                 |
| `athenaAsyncQueryDataSupport`      | Enable async query data support for Athena                                                                   |
| `showDashboardValidationWarnings`  | Show warnings when dashboards do not validate against the schema                                             |
| `mysqlAnsiQuotes`                  | Use double quotes to escape keyword in a MySQL query                                                         |
| `showTraceId`                      | Show trace ids for requests                                                                                  |
| `authnService`                     | Use new auth service to perform authentication                                                               |
| `alertingBacktesting`              | Rule backtesting API for alerting                                                                            |
| `editPanelCSVDragAndDrop`          | Enables drag and drop for CSV and Excel files                                                                |
| `lokiQuerySplitting`               | Split large interval queries into subqueries with smaller time intervals                                     |
| `lokiQuerySplittingConfig`         | Give users the option to configure split durations for Loki queries                                          |
| `individualCookiePreferences`      | Support overriding cookie preferences per user                                                               |
| `onlyExternalOrgRoleSync`          | Prohibits a user from changing organization roles synced with external auth providers                        |
| `traceqlSearch`                    | Enables the 'TraceQL Search' tab for the Tempo datasource which provides a UI to generate TraceQL queries    |
| `prometheusMetricEncyclopedia`     | Replaces the Prometheus query builder metric select option with a paginated and filterable component         |
| `timeSeriesTable`                  | Enable time series table transformer & sparkline cell type                                                   |
| `prometheusResourceBrowserCache`   | Displays browser caching options in Prometheus data source configuration                                     |
| `influxdbBackendMigration`         | Query InfluxDB InfluxQL without the proxy                                                                    |
| `clientTokenRotation`              | Replaces the current in-request token rotation so that the client initiates the rotation                     |
| `disableSSEDataplane`              | Disables dataplane specific processing in server side expressions.                                           |
| `alertStateHistoryLokiSecondary`   | Enable Grafana to write alert state history to an external Loki instance in addition to Grafana annotations. |
| `alertStateHistoryLokiPrimary`     | Enable a remote Loki instance as the primary source for state history reads.                                 |
| `alertStateHistoryLokiOnly`        | Disable Grafana alerts from emitting annotations when a remote Loki instance is available.                   |
| `unifiedRequestLog`                | Writes error logs to the request logger                                                                      |
| `pyroscopeFlameGraph`              | Changes flame graph to pyroscope one                                                                         |
| `pluginsAPIManifestKey`            | Use grafana.com API to retrieve the public manifest key                                                      |
| `opensearchDetectVersion`          | Enable version detection in OpenSearch                                                                       |
| `alertingLokiRangeToInstant`       | Rewrites eligible loki range queries to instant queries                                                      |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode]({{< relref "../_index.md#app_mode" >}}) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name   | Description                                                    |
| --------------------- | -------------------------------------------------------------- |
| `entityStore`         | SQL-based entity store (requires storage flag also)            |
| `externalServiceAuth` | Starts an OAuth2 authentication provider for external services |
