---
title: Homebrew
series: customization
hideFromIndex: true
weight: 90
---

After releasing to GitHub, GoReleaser can generate and publish a _homebrew-tap_
recipe into a repository that you have access to.

The `brew` section specifies how the formula should be created.
You can check the
[Homebrew documentation](https://github.com/Homebrew/brew/blob/master/docs/How-to-Create-and-Maintain-a-Tap.md)
and the
[formula cookbook](https://github.com/Homebrew/brew/blob/master/docs/Formula-Cookbook.md)
for more details.

```yml
# .goreleaser.yml
brew:
  # Name template of the recipe
  # Default to project name
  name: myproject

  # Repository to push the tap to.
  github:
    owner: user
    name: homebrew-tap

  # Template for the url.
  # Default is "https://github.com/<repo_owner>/<repo_name>/releases/download/{{ .Tag }}/{{ .ArtifactName }}"
  url_template: "http://github.mycompany.com/foo/bar/releases/{{ .Tag }}/{{ .ArtifactName }}"

  # Allows you to set a custom download strategy.
  # Default is empty.
  download_strategy: GitHubPrivateRepositoryReleaseDownloadStrategy

  # Allows you to add a custom require_relative at the top of the formula template
  # Default is empty
  custom_require: custom_download_strategy

  # Git author used to commit to the repository.
  # Defaults are shown.
  commit_author:
    name: goreleaserbot
    email: goreleaser@carlosbecker.com

  # Folder inside the repository to put the formula.
  # Default is the root folder.
  folder: Formula

  # Caveats for the user of your binary.
  # Default is empty.
  caveats: "How to use this binary"

  # Your app's homepage.
  # Default is empty.
  homepage: "https://example.com/"

  # Your app's description.
  # Default is empty.
  description: "Software to create fast and easy drum rolls."

  # Setting this will prevent goreleaser to actually try to commit the updated
  # formula - instead, the formula file will be stored on the dist folder only,
  # leaving the responsibility of publishing it to the user.
  # If set to auto, the release will not be uploaded to the homebrew tap
  # in case there is an indicator for prerelease in the tag e.g. v1.0.0-rc1
  # Default is false.
  skip_upload: true

  # Custom block for brew.
  # Can be used to specify alternate downloads for devel or head releases.
  # Default is empty.
  custom_block: |
    head "https://github.com/some/package.git"
    ...

  # Packages your package depends on.
  dependencies:
    - git
    - zsh

  # Packages that conflict with your package.
  conflicts:
    - svn
    - bash

  # Specify for packages that run as a service.
  # Default is empty.
  plist: |
    <?xml version="1.0" encoding="UTF-8"?>
    ...

  # So you can `brew test` your formula.
  # Default is empty.
  test: |
    system "#{bin}/program --version"
    ...

  # Custom install script for brew.
  # Default is 'bin.install "program"'.
  install: |
    bin.install "program"
    ...
```

> Learn more about the [name template engine](/templates).

By defining the `brew` section, GoReleaser will take care of publishing the
Homebrew tap.
Assuming that the current tag is `v1.2.3`, the above configuration will generate a
`program.rb` formula in the `Formula` folder of `user/homebrew-tap` repository:

```rb
class Program < Formula
  desc "How to use this binary"
  homepage "https://github.com/user/repo"
  url "https://github.com/user/repo/releases/download/v1.2.3/program_v1.2.3_macOs_64bit.zip"
  version "v1.2.3"
  sha256 "9ee30fc358fae8d248a2d7538957089885da321dca3f09e3296fe2058e7fff74"

  depends_on "git"
  depends_on "zsh"

  def install
    bin.install "program"
  end
end
```

**Important**: Note that GoReleaser does not yet generate a valid
homebrew-core formula. The generated formulas are meant to be published as
[homebrew taps](https://docs.brew.sh/Taps.html), and in their current
form will not be accepted in any of the official homebrew repositories.
