# Install

There are two GoReleaser distributions: OSS and [Pro](/pro/).

You can install the pre-compiled binary (in several ways), use Docker or compile
from source (when on OSS).

Below you can find the steps for each of them.

## Install the pre-compiled binary

### homebrew tap

=== "OSS"

    ```bash
    brew install goreleaser/tap/goreleaser
    ```

=== "Pro"

    ```bash
    brew install goreleaser/tap/goreleaser-pro
    ```

### homebrew

=== "OSS"

    ```bash
    brew install goreleaser
    ```

!!! info

    The [formula in homebrew-core](https://github.com/Homebrew/homebrew-core/blob/master/Formula/g/goreleaser.rb) might be slightly outdated.
    Use our homebrew tap to always get the latest updates.

### snapcraft

=== "OSS"

    ```bash
    sudo snap install --classic goreleaser
    ```

### scoop

=== "OSS"

    ```bash
    scoop bucket add goreleaser https://github.com/goreleaser/scoop-bucket.git
    scoop install goreleaser
    ```

=== "Pro"

    ```bash
    scoop bucket add goreleaser https://github.com/goreleaser/scoop-bucket.git
    scoop install goreleaser-pro
    ```

### apt

=== "OSS"

    ```bash
    echo 'deb [trusted=yes] https://repo.goreleaser.com/apt/ /' | sudo tee /etc/apt/sources.list.d/goreleaser.list
    sudo apt update
    sudo apt install goreleaser
    ```

=== "Pro"

    ```bash
    echo 'deb [trusted=yes] https://repo.goreleaser.com/apt/ /' | sudo tee /etc/apt/sources.list.d/goreleaser.list
    sudo apt update
    sudo apt install goreleaser-pro
    ```

### yum

=== "OSS"

    ```bash
    echo '[goreleaser]
    name=GoReleaser
    baseurl=https://repo.goreleaser.com/yum/
    enabled=1
    gpgcheck=0' | sudo tee /etc/yum.repos.d/goreleaser.repo
    sudo yum install goreleaser
    ```

=== "Pro"

    ```bash
    echo '[goreleaser]
    name=GoReleaser
    baseurl=https://repo.goreleaser.com/yum/
    enabled=1
    gpgcheck=0' | sudo tee /etc/yum.repos.d/goreleaser.repo
    sudo yum install goreleaser-pro
    ```

### aur

=== "OSS"

    ```bash
    yay -S goreleaser-bin
    ```

=== "Pro"

    ```bash
    yay -S goreleaser-pro-bin
    ```

### nix

#### nixpkgs

=== "OSS"

    ```bash
    nix-env -iA goreleaser
    ```

!!! info

    The [package in nixpkgs](https://github.com/NixOS/nixpkgs/blob/master/pkgs/tools/misc/goreleaser/default.nix)
    might be slightly outdated, as it is not updated automatically.
    Use our NUR to always get the latest updates.

#### nur

First, you'll need to add our [NUR][nur] to your nix configuration.
You can follow the guides
[here](https://github.com/nix-community/NUR#installation).

Once you do that, you can install the packages.

[nur]: https://github.com/goreleaser/nur

=== "OSS"

    ```nix
    { pkgs, lib, ... }: {
      home.packages = with pkgs; [
        nur.repos.goreleaser.goreleaser
      ];
    }
    ```

=== "Pro"

    ```nix
    { pkgs, lib, ... }: {
      home.packages = with pkgs; [
        nur.repos.goreleaser.goreleaser-pro
      ];
    }
    ```

### deb, rpm and apk packages

=== "OSS"

    Download the `.deb`, `.rpm` or `.apk` packages from the [OSS releases page][releases] and install them with the appropriate tools.

=== "Pro"

    Download the `.deb`, `.rpm` or `.apk` packages from the [Pro releases page][pro-releases] and install them with the appropriate tools.

### go install

=== "OSS"

    ```bash
    go install github.com/goreleaser/goreleaser@latest
    ```

    Requires Go 1.21.

### bash script

=== "OSS"

    ```bash
    curl -sfL https://goreleaser.com/static/run | bash
    ```

=== "Pro"

    ```bash
    curl -sfL https://goreleaser.com/static/run | DISTRIBUTION=pro bash
    ```

=== "Additional Options"

    You can also set the `VERSION` and `DISTRIBUTION` variables to specify
    a version instead of using latest and `pro` or `oss` distributions,
    respectively.

    You can also pass flags and args to GoReleaser:

    ```bash
    curl -sfL https://goreleaser.com/static/run |
      VERSION=__VERSION__ DISTRIBUTION=oss bash -s -- check

    curl -sfL https://goreleaser.com/static/run |
      VERSION=__VERSION__ DISTRIBUTION=pro bash -s -- check
    ```

!!! tip

    This script does not install anything, it just downloads, verifies and
    runs GoReleaser.
    Its purpose is to be used within scripts and CIs.

### manually

=== "OSS"

    Download the pre-compiled binaries from the [OSS releases page][releases] and copy them to the desired location.

=== "Pro"

    Download the pre-compiled binaries from the [Pro releases page][pro-releases] and copy them to the desired location.

### nightly

Nightly build are pre-releases of the current code into the main branch.
Use it for testing out new features only.

#### manually

=== "OSS"

    Download the pre-compiled binaries from the [nightly release][nightly-releases] and copy them to the desired location.

=== "Pro"

    Download the pre-compiled binaries from the [nightly release][nightly-pro-releases] and copy them to the desired location.

### bash script

=== "OSS"

    ```bash
    curl -sfL https://goreleaser.com/static/run |
      VERSION=nightly DISTRIBUTION=oss bash -s -- release --clean
    ```

=== "Pro"

    ```bash
    curl -sfL https://goreleaser.com/static/run |
      VERSION=nightly DISTRIBUTION=pro bash -s -- release --clean
    ```

#### docker

Docker images are also available, look for tags with a `-nightly` suffix for
the last nightly of a specific release, or the `:nightly` tag,
which is always the latest nightly build available.

=== "OSS"

    Registries:

    - [`goreleaser/goreleaser`](https://hub.docker.com/r/goreleaser/goreleaser)
    - [`ghcr.io/goreleaser/goreleaser`](https://github.com/goreleaser/goreleaser/pkgs/container/goreleaser)

=== "Pro"

    Registries:

    - [`goreleaser/goreleaser-pro`](https://hub.docker.com/r/goreleaser/goreleaser-pro)
    - [`ghcr.io/goreleaser/goreleaser-pro`](https://github.com/goreleaser/goreleaser/pkgs/container/goreleaser-pro)

## Verifying the artifacts

### binaries

All artifacts are checksummed, and the checksum file is signed with [cosign][].

=== "OSS"

    1. Download the files you want, and the `checksums.txt`, `checksum.txt.pem` and `checksums.txt.sig` files from the [releases][releases] page:
      ```bash
      wget 'https://github.com/goreleaser/goreleaser/releases/download/__VERSION__/checksums.txt'
      ```
    1. Verify the signature:
      ```bash
      cosign verify-blob \
        --certificate-identity 'https://github.com/goreleaser/goreleaser/.github/workflows/release.yml@refs/tags/__VERSION__' \
        --certificate-oidc-issuer 'https://token.actions.githubusercontent.com' \
        --cert 'https://github.com/goreleaser/goreleaser/releases/download/__VERSION__/checksums.txt.pem' \
        --signature 'https://github.com/goreleaser/goreleaser/releases/download/__VERSION__/checksums.txt.sig' \
        ./checksums.txt
      ```
    1. If the signature is valid, you can then verify the SHA256 sums match with the downloaded binary:
      ```bash
      sha256sum --ignore-missing -c checksums.txt
      ```

=== "Pro"

    1. Download the files you want, and the `checksums.txt`, `checksum.txt.pem` and `checksums.txt.sig` files from the [releases][pro-releases] page:
      ```bash
      wget 'https://github.com/goreleaser/goreleaser-pro/releases/download/__VERSION__-pro/checksums.txt'
      ```
    1. Verify the signature:
      ```bash
      cosign verify-blob \
        --certificate-identity 'https://github.com/goreleaser/goreleaser-pro-internal/.github/workflows/release-pro.yml@refs/tags/__VERSION__-pro' \
        --certificate-oidc-issuer 'https://token.actions.githubusercontent.com' \
        --cert 'https://github.com/goreleaser/goreleaser-pro/releases/download/__VERSION__-pro/checksums.txt.pem' \
        --signature 'https://github.com/goreleaser/goreleaser-pro/releases/download/__VERSION__-pro/checksums.txt.sig' \
        ./checksums.txt
      ```
    1. If the signature is valid, you can then verify the SHA256 sums match with the downloaded binary:
      ```bash
      sha256sum --ignore-missing -c checksums.txt
      ```

### docker images

Our Docker images are signed with [cosign][].

Verify the signatures:

=== "OSS"

    ```bash
    cosign verify \
      --certificate-identity 'https://github.com/goreleaser/goreleaser/.github/workflows/release.yml@refs/tags/__VERSION__' \
        --certificate-oidc-issuer 'https://token.actions.githubusercontent.com' \
      goreleaser/goreleaser
    ```

=== "Pro"

    ```bash
    cosign verify \
      --certificate-identity 'https://github.com/goreleaser/goreleaser-pro-internal/.github/workflows/release-pro.yml@refs/tags/__VERSION__-pro' \
      --certificate-oidc-issuer 'https://token.actions.githubusercontent.com' \
      goreleaser/goreleaser-pro
    ```

!!! info

    The `.pem` and `.sig` files are the image `name:tag`, replacing `/` and `:` with `-`.

## Running with Docker

You can also use it within a Docker container.
To do that, you'll need to execute something more-or-less like the examples below.

=== "OSS"

    Registries:

    - [`goreleaser/goreleaser`](https://hub.docker.com/r/goreleaser/goreleaser)
    - [`ghcr.io/goreleaser/goreleaser`](https://github.com/goreleaser/goreleaser/pkgs/container/goreleaser)

    Example usage:

    ```bash
    docker run --rm --privileged \
      -v $PWD:/go/src/github.com/user/repo \
      -v /var/run/docker.sock:/var/run/docker.sock \
      -w /go/src/github.com/user/repo \
      -e GITHUB_TOKEN \
      -e DOCKER_USERNAME \
      -e DOCKER_PASSWORD \
      -e DOCKER_REGISTRY \
      goreleaser/goreleaser release
    ```

=== "Pro"

    Registries:

    - [`goreleaser/goreleaser-pro`](https://hub.docker.com/r/goreleaser/goreleaser-pro)
    - [`ghcr.io/goreleaser/goreleaser-pro`](https://github.com/goreleaser/goreleaser/pkgs/container/goreleaser-pro)

    Example usage:

    ```bash
    docker run --rm --privileged \
      -v $PWD:/go/src/github.com/user/repo \
      -v /var/run/docker.sock:/var/run/docker.sock \
      -w /go/src/github.com/user/repo \
      -e GITHUB_TOKEN \
      -e DOCKER_USERNAME \
      -e DOCKER_PASSWORD \
      -e DOCKER_REGISTRY \
      -e GORELEASER_KEY \
      goreleaser/goreleaser-pro release
    ```

!!! info

    Now, the provided docker image does not support
    the generation of Snapcraft packages.

Note that the image will almost always have the last stable Go version.

The `DOCKER_REGISTRY` environment variable can be left empty when you are
releasing to the public docker registry.

If you need more things, you are encouraged to keep your own image. You can
always use GoReleaser's [own Dockerfile][dockerfile] as an example though
and iterate from that.

[dockerfile]: https://github.com/goreleaser/goreleaser/blob/main/Dockerfile
[releases]: https://github.com/goreleaser/goreleaser/releases
[pro-releases]: https://github.com/goreleaser/goreleaser-pro/releases
[nightly-pro-releases]: https://github.com/goreleaser/goreleaser-pro/releases/nightly
[nightly-releases]: https://github.com/goreleaser/goreleaser/releases/nightly
[cosign]: https://github.com/sigstore/cosign

## Packaging status

[![Packaging status](https://repology.org/badge/vertical-allrepos/goreleaser.svg)](https://repology.org/project/goreleaser/versions)

## Compiling from source

Here you have two options:

If you want to contribute to the project, please follow the
steps on our [contributing guide](/contributing).

If you just want to build from source for whatever reason, follow these steps:

**clone:**

```bash
git clone https://github.com/goreleaser/goreleaser
cd goreleaser
```

**get the dependencies:**

```bash
go mod tidy
```

**build:**

```bash
go build -o goreleaser .
```

**verify it works:**

```bash
./goreleaser --version
```
