# Winget

> Since: v1.19

After releasing to GitHub, GitLab, or Gitea, GoReleaser can generate and publish
a _winget manifest_ and commit to a git repository, and PR it to `winget-pkgs`
if instructed to.

The `winget` section specifies how the **manifests** should be created:

```yaml
# .goreleaser.yaml
winget:
  - # Name of the recipe
    #
    # Default: ProjectName
    # Templates: allowed
    name: myproject

    # Publisher name.
    #
    # Templates: allowed
    # Required.
    publisher: Foo Inc

    # Your app's description.
    #
    # Templates: allowed
    # Required.
    short_description: "Software to create fast and easy drum rolls."

    # License name.
    #
    # Templates: allowed
    # Required.
    license: "mit"

    # Publisher URL.
    #
    # Templates: allowed
    publisher_url: https://goreleaser.com

    # Publisher support URL.
    #
    # Templates: allowed
    publisher_support_url: "https://github.com/user/repo/issues/new"

    # Package identifier.
    #
    # Default: Publisher.ProjectName
    # Templates: allowed
    package_identifier: myproject.myproject

    # IDs of the archives to use.
    # Empty means all IDs.
    ids:
      - foo
      - bar

    # Which format to use.
    #
    # Valid options are:
    # - '':        archives or binaries
    # - 'msi':     msi installers (requires the MSI pipe configured, Pro only)
    # - 'archive': archives (only if format is zip),
    # - 'binary':  binaries
    #
    # Default: ''
    # Since: v1.24 (pro)
    use: msi

    # GOAMD64 to specify which amd64 version to use if there are multiple
    # versions from the build section.
    #
    # Default: v1
    goamd64: v1

    # Product code to be used.
    #
    # Usually needed when `use: msi`.
    #
    # Since: v1.24 (pro)
    product_code: AAAA-BBB-CCC-DDD-EEEFFF

    # URL which is determined by the given Token (github, gitlab or gitea).
    #
    # Default depends on the client.
    # Templates: allowed
    url_template: "https://github.mycompany.com/foo/bar/releases/download/{{ .Tag }}/{{ .ArtifactName }}"

    # Git author used to commit to the repository.
    commit_author:
      name: goreleaserbot
      email: bot@goreleaser.com

    # The project name and current git tag are used in the format string.
    #
    # Templates: allowed
    commit_msg_template: "{{ .PackageIdentifier }}: {{ .Tag }}"

    # Path for the file inside the repository.
    #
    # Default: manifests/<lowercased first char of publisher>/<publisher>/<version>
    path: manifests/g/goreleaser/1.19

    # Your app's homepage.
    homepage: "https://example.com/"

    # Your app's long description.
    #
    # Templates: allowed
    description: "Software to create fast and easy drum rolls."

    # License URL.
    #
    # Templates: allowed
    license_url: "https://goreleaser.com/license"

    # Copyright.
    #
    # Templates: allowed
    copyright: "Becker Software LTDA"

    # Copyright URL.
    #
    # Templates: allowed
    copyright_url: "https://goreleaser.com/copyright"

    # Setting this will prevent goreleaser to actually try to commit the updated
    # package - instead, it will be stored on the dist folder only,
    # leaving the responsibility of publishing it to the user.
    #
    # If set to auto, the release will not be uploaded to the repository
    # in case there is an indicator for prerelease in the tag e.g. v1.0.0-rc1
    #
    # Templates: allowed
    skip_upload: true

    # Release notes.
    #
    # If you want to use the release notes generated by GoReleaser, use
    # `{{.Changelog}}` as the value.
    #
    # Templates: allowed
    release_notes: "{{.Changelog}}"

    # Release notes URL.
    #
    # Templates: allowed
    release_notes_url: "https://foo.bar/changelog/{{.Version}}"

    # Tags.
    tags:
      - golang
      - cli

    # Package dependencies.
    #
    # Since: v1.21
    # Templates: allowed
    dependencies:
      - package_identifier: Foo.Bar
        minimum_version: 1.2.3


{% include-markdown "../includes/repository.md" comments=false %}
```

!!! tip

    Learn more about the [name template engine](/customization/templates/).

{% include-markdown "../includes/prs.md" comments=false %}
