package tests

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestBaseConfig(t *testing.T) { //nolint:paralleltest
	ts := newTester(t)
	defer ts.teardown()

	out, err := ts.run("config")
	assert.NoError(t, err)

	wanted := `autoclip: false
autoimport: true
cliptimeout: 45
exportkeys: false
keychain: false
nopager: false
notifications: true
parsing: true
`
	wanted += "path: " + ts.storeDir("root") + "\n"
	wanted += "safecontent: false"

	assert.Equal(t, wanted, out)

	invertables := []string{
		"autoimport",
		"safecontent",
		"parsing",
	}

	for _, invert := range invertables { //nolint:paralleltest
		t.Run("invert "+invert, func(t *testing.T) {
			out, err = ts.run("config " + invert + " false")
			assert.NoError(t, err)
			assert.Equal(t, "false", out)

			out, err = ts.run("config " + invert)
			assert.NoError(t, err)
			assert.Equal(t, "false", out)
		})
	}

	t.Run("cliptimeout", func(t *testing.T) {
		out, err = ts.run("config cliptimeout 120")
		assert.NoError(t, err)
		assert.Equal(t, "120", out)

		out, err = ts.run("config cliptimeout")
		assert.NoError(t, err)
		assert.Equal(t, "120", out)
	})
}

func TestMountConfig(t *testing.T) { //nolint:paralleltest
	ts := newTester(t)
	defer ts.teardown()

	// we add a mount:
	_, err := ts.run("init --store mnt/m1 --path " + ts.storeDir("m1") + " --storage=fs " + keyID)
	require.NoError(t, err)

	_, err = ts.run("config")
	assert.NoError(t, err)

	wanted := `autoclip: false
autoimport: true
cliptimeout: 45
exportkeys: false
keychain: false
nopager: false
notifications: true
parsing: true
path: `
	wanted += ts.storeDir("root") + "\n"
	wanted += `safecontent: false
mount "mnt/m1" => "`
	wanted += ts.storeDir("m1") + "\"\n"

	out, err := ts.run("config")
	assert.NoError(t, err)
	assert.Equal(t, strings.TrimSpace(wanted), out)
}
