// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package visionai

import (
	"bytes"
	"context"
	"errors"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	visionaipb "cloud.google.com/go/visionai/apiv1/visionaipb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newWarehouseClientHook clientHook

// WarehouseCallOptions contains the retry settings for each method of WarehouseClient.
type WarehouseCallOptions struct {
	CreateAsset          []gax.CallOption
	UpdateAsset          []gax.CallOption
	GetAsset             []gax.CallOption
	ListAssets           []gax.CallOption
	DeleteAsset          []gax.CallOption
	UploadAsset          []gax.CallOption
	GenerateRetrievalUrl []gax.CallOption
	AnalyzeAsset         []gax.CallOption
	IndexAsset           []gax.CallOption
	RemoveIndexAsset     []gax.CallOption
	ViewIndexedAssets    []gax.CallOption
	CreateIndex          []gax.CallOption
	UpdateIndex          []gax.CallOption
	GetIndex             []gax.CallOption
	ListIndexes          []gax.CallOption
	DeleteIndex          []gax.CallOption
	CreateCorpus         []gax.CallOption
	GetCorpus            []gax.CallOption
	UpdateCorpus         []gax.CallOption
	ListCorpora          []gax.CallOption
	DeleteCorpus         []gax.CallOption
	AnalyzeCorpus        []gax.CallOption
	CreateDataSchema     []gax.CallOption
	UpdateDataSchema     []gax.CallOption
	GetDataSchema        []gax.CallOption
	DeleteDataSchema     []gax.CallOption
	ListDataSchemas      []gax.CallOption
	CreateAnnotation     []gax.CallOption
	GetAnnotation        []gax.CallOption
	ListAnnotations      []gax.CallOption
	UpdateAnnotation     []gax.CallOption
	DeleteAnnotation     []gax.CallOption
	IngestAsset          []gax.CallOption
	ClipAsset            []gax.CallOption
	GenerateHlsUri       []gax.CallOption
	ImportAssets         []gax.CallOption
	CreateSearchConfig   []gax.CallOption
	UpdateSearchConfig   []gax.CallOption
	GetSearchConfig      []gax.CallOption
	DeleteSearchConfig   []gax.CallOption
	ListSearchConfigs    []gax.CallOption
	CreateSearchHypernym []gax.CallOption
	UpdateSearchHypernym []gax.CallOption
	GetSearchHypernym    []gax.CallOption
	DeleteSearchHypernym []gax.CallOption
	ListSearchHypernyms  []gax.CallOption
	SearchAssets         []gax.CallOption
	SearchIndexEndpoint  []gax.CallOption
	CreateIndexEndpoint  []gax.CallOption
	GetIndexEndpoint     []gax.CallOption
	ListIndexEndpoints   []gax.CallOption
	UpdateIndexEndpoint  []gax.CallOption
	DeleteIndexEndpoint  []gax.CallOption
	DeployIndex          []gax.CallOption
	UndeployIndex        []gax.CallOption
	CreateCollection     []gax.CallOption
	DeleteCollection     []gax.CallOption
	GetCollection        []gax.CallOption
	UpdateCollection     []gax.CallOption
	ListCollections      []gax.CallOption
	AddCollectionItem    []gax.CallOption
	RemoveCollectionItem []gax.CallOption
	ViewCollectionItems  []gax.CallOption
	CancelOperation      []gax.CallOption
	DeleteOperation      []gax.CallOption
	GetOperation         []gax.CallOption
	ListOperations       []gax.CallOption
}

func defaultWarehouseGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("visionai.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("visionai.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("visionai.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://visionai.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultWarehouseCallOptions() *WarehouseCallOptions {
	return &WarehouseCallOptions{
		CreateAsset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				})
			}),
		},
		UpdateAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UploadAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GenerateRetrievalUrl: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		AnalyzeAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		IndexAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RemoveIndexAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ViewIndexedAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListIndexes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateCorpus: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				})
			}),
		},
		GetCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListCorpora: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		AnalyzeCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateDataSchema: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				})
			}),
		},
		UpdateDataSchema: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetDataSchema: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteDataSchema: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListDataSchemas: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateAnnotation: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				})
			}),
		},
		GetAnnotation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAnnotations: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateAnnotation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAnnotation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		IngestAsset: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				})
			}),
		},
		ClipAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GenerateHlsUri: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ImportAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListSearchConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListSearchHypernyms: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListIndexEndpoints: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeployIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UndeployIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListCollections: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		AddCollectionItem: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RemoveCollectionItem: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ViewCollectionItems: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

func defaultWarehouseRESTCallOptions() *WarehouseCallOptions {
	return &WarehouseCallOptions{
		CreateAsset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UploadAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GenerateRetrievalUrl: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		AnalyzeAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		IndexAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		RemoveIndexAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ViewIndexedAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListIndexes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateCorpus: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListCorpora: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		AnalyzeCorpus: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateDataSchema: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateDataSchema: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetDataSchema: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteDataSchema: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListDataSchemas: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateAnnotation: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetAnnotation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListAnnotations: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateAnnotation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteAnnotation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		IngestAsset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        120000 * time.Millisecond,
					Multiplier: 2.50,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ClipAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GenerateHlsUri: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ImportAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteSearchConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListSearchConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteSearchHypernym: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListSearchHypernyms: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		SearchAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		SearchIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListIndexEndpoints: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteIndexEndpoint: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeployIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UndeployIndex: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateCollection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListCollections: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		AddCollectionItem: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		RemoveCollectionItem: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ViewCollectionItems: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalWarehouseClient is an interface that defines the methods available from Vision AI API.
type internalWarehouseClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateAsset(context.Context, *visionaipb.CreateAssetRequest, ...gax.CallOption) (*visionaipb.Asset, error)
	UpdateAsset(context.Context, *visionaipb.UpdateAssetRequest, ...gax.CallOption) (*visionaipb.Asset, error)
	GetAsset(context.Context, *visionaipb.GetAssetRequest, ...gax.CallOption) (*visionaipb.Asset, error)
	ListAssets(context.Context, *visionaipb.ListAssetsRequest, ...gax.CallOption) *AssetIterator
	DeleteAsset(context.Context, *visionaipb.DeleteAssetRequest, ...gax.CallOption) (*DeleteAssetOperation, error)
	DeleteAssetOperation(name string) *DeleteAssetOperation
	UploadAsset(context.Context, *visionaipb.UploadAssetRequest, ...gax.CallOption) (*UploadAssetOperation, error)
	UploadAssetOperation(name string) *UploadAssetOperation
	GenerateRetrievalUrl(context.Context, *visionaipb.GenerateRetrievalUrlRequest, ...gax.CallOption) (*visionaipb.GenerateRetrievalUrlResponse, error)
	AnalyzeAsset(context.Context, *visionaipb.AnalyzeAssetRequest, ...gax.CallOption) (*AnalyzeAssetOperation, error)
	AnalyzeAssetOperation(name string) *AnalyzeAssetOperation
	IndexAsset(context.Context, *visionaipb.IndexAssetRequest, ...gax.CallOption) (*IndexAssetOperation, error)
	IndexAssetOperation(name string) *IndexAssetOperation
	RemoveIndexAsset(context.Context, *visionaipb.RemoveIndexAssetRequest, ...gax.CallOption) (*RemoveIndexAssetOperation, error)
	RemoveIndexAssetOperation(name string) *RemoveIndexAssetOperation
	ViewIndexedAssets(context.Context, *visionaipb.ViewIndexedAssetsRequest, ...gax.CallOption) *IndexedAssetIterator
	CreateIndex(context.Context, *visionaipb.CreateIndexRequest, ...gax.CallOption) (*CreateIndexOperation, error)
	CreateIndexOperation(name string) *CreateIndexOperation
	UpdateIndex(context.Context, *visionaipb.UpdateIndexRequest, ...gax.CallOption) (*UpdateIndexOperation, error)
	UpdateIndexOperation(name string) *UpdateIndexOperation
	GetIndex(context.Context, *visionaipb.GetIndexRequest, ...gax.CallOption) (*visionaipb.Index, error)
	ListIndexes(context.Context, *visionaipb.ListIndexesRequest, ...gax.CallOption) *IndexIterator
	DeleteIndex(context.Context, *visionaipb.DeleteIndexRequest, ...gax.CallOption) (*DeleteIndexOperation, error)
	DeleteIndexOperation(name string) *DeleteIndexOperation
	CreateCorpus(context.Context, *visionaipb.CreateCorpusRequest, ...gax.CallOption) (*CreateCorpusOperation, error)
	CreateCorpusOperation(name string) *CreateCorpusOperation
	GetCorpus(context.Context, *visionaipb.GetCorpusRequest, ...gax.CallOption) (*visionaipb.Corpus, error)
	UpdateCorpus(context.Context, *visionaipb.UpdateCorpusRequest, ...gax.CallOption) (*visionaipb.Corpus, error)
	ListCorpora(context.Context, *visionaipb.ListCorporaRequest, ...gax.CallOption) *CorpusIterator
	DeleteCorpus(context.Context, *visionaipb.DeleteCorpusRequest, ...gax.CallOption) error
	AnalyzeCorpus(context.Context, *visionaipb.AnalyzeCorpusRequest, ...gax.CallOption) (*AnalyzeCorpusOperation, error)
	AnalyzeCorpusOperation(name string) *AnalyzeCorpusOperation
	CreateDataSchema(context.Context, *visionaipb.CreateDataSchemaRequest, ...gax.CallOption) (*visionaipb.DataSchema, error)
	UpdateDataSchema(context.Context, *visionaipb.UpdateDataSchemaRequest, ...gax.CallOption) (*visionaipb.DataSchema, error)
	GetDataSchema(context.Context, *visionaipb.GetDataSchemaRequest, ...gax.CallOption) (*visionaipb.DataSchema, error)
	DeleteDataSchema(context.Context, *visionaipb.DeleteDataSchemaRequest, ...gax.CallOption) error
	ListDataSchemas(context.Context, *visionaipb.ListDataSchemasRequest, ...gax.CallOption) *DataSchemaIterator
	CreateAnnotation(context.Context, *visionaipb.CreateAnnotationRequest, ...gax.CallOption) (*visionaipb.Annotation, error)
	GetAnnotation(context.Context, *visionaipb.GetAnnotationRequest, ...gax.CallOption) (*visionaipb.Annotation, error)
	ListAnnotations(context.Context, *visionaipb.ListAnnotationsRequest, ...gax.CallOption) *AnnotationIterator
	UpdateAnnotation(context.Context, *visionaipb.UpdateAnnotationRequest, ...gax.CallOption) (*visionaipb.Annotation, error)
	DeleteAnnotation(context.Context, *visionaipb.DeleteAnnotationRequest, ...gax.CallOption) error
	IngestAsset(context.Context, ...gax.CallOption) (visionaipb.Warehouse_IngestAssetClient, error)
	ClipAsset(context.Context, *visionaipb.ClipAssetRequest, ...gax.CallOption) (*visionaipb.ClipAssetResponse, error)
	GenerateHlsUri(context.Context, *visionaipb.GenerateHlsUriRequest, ...gax.CallOption) (*visionaipb.GenerateHlsUriResponse, error)
	ImportAssets(context.Context, *visionaipb.ImportAssetsRequest, ...gax.CallOption) (*ImportAssetsOperation, error)
	ImportAssetsOperation(name string) *ImportAssetsOperation
	CreateSearchConfig(context.Context, *visionaipb.CreateSearchConfigRequest, ...gax.CallOption) (*visionaipb.SearchConfig, error)
	UpdateSearchConfig(context.Context, *visionaipb.UpdateSearchConfigRequest, ...gax.CallOption) (*visionaipb.SearchConfig, error)
	GetSearchConfig(context.Context, *visionaipb.GetSearchConfigRequest, ...gax.CallOption) (*visionaipb.SearchConfig, error)
	DeleteSearchConfig(context.Context, *visionaipb.DeleteSearchConfigRequest, ...gax.CallOption) error
	ListSearchConfigs(context.Context, *visionaipb.ListSearchConfigsRequest, ...gax.CallOption) *SearchConfigIterator
	CreateSearchHypernym(context.Context, *visionaipb.CreateSearchHypernymRequest, ...gax.CallOption) (*visionaipb.SearchHypernym, error)
	UpdateSearchHypernym(context.Context, *visionaipb.UpdateSearchHypernymRequest, ...gax.CallOption) (*visionaipb.SearchHypernym, error)
	GetSearchHypernym(context.Context, *visionaipb.GetSearchHypernymRequest, ...gax.CallOption) (*visionaipb.SearchHypernym, error)
	DeleteSearchHypernym(context.Context, *visionaipb.DeleteSearchHypernymRequest, ...gax.CallOption) error
	ListSearchHypernyms(context.Context, *visionaipb.ListSearchHypernymsRequest, ...gax.CallOption) *SearchHypernymIterator
	SearchAssets(context.Context, *visionaipb.SearchAssetsRequest, ...gax.CallOption) *SearchResultItemIterator
	SearchIndexEndpoint(context.Context, *visionaipb.SearchIndexEndpointRequest, ...gax.CallOption) *SearchResultItemIterator
	CreateIndexEndpoint(context.Context, *visionaipb.CreateIndexEndpointRequest, ...gax.CallOption) (*CreateIndexEndpointOperation, error)
	CreateIndexEndpointOperation(name string) *CreateIndexEndpointOperation
	GetIndexEndpoint(context.Context, *visionaipb.GetIndexEndpointRequest, ...gax.CallOption) (*visionaipb.IndexEndpoint, error)
	ListIndexEndpoints(context.Context, *visionaipb.ListIndexEndpointsRequest, ...gax.CallOption) *IndexEndpointIterator
	UpdateIndexEndpoint(context.Context, *visionaipb.UpdateIndexEndpointRequest, ...gax.CallOption) (*UpdateIndexEndpointOperation, error)
	UpdateIndexEndpointOperation(name string) *UpdateIndexEndpointOperation
	DeleteIndexEndpoint(context.Context, *visionaipb.DeleteIndexEndpointRequest, ...gax.CallOption) (*DeleteIndexEndpointOperation, error)
	DeleteIndexEndpointOperation(name string) *DeleteIndexEndpointOperation
	DeployIndex(context.Context, *visionaipb.DeployIndexRequest, ...gax.CallOption) (*DeployIndexOperation, error)
	DeployIndexOperation(name string) *DeployIndexOperation
	UndeployIndex(context.Context, *visionaipb.UndeployIndexRequest, ...gax.CallOption) (*UndeployIndexOperation, error)
	UndeployIndexOperation(name string) *UndeployIndexOperation
	CreateCollection(context.Context, *visionaipb.CreateCollectionRequest, ...gax.CallOption) (*CreateCollectionOperation, error)
	CreateCollectionOperation(name string) *CreateCollectionOperation
	DeleteCollection(context.Context, *visionaipb.DeleteCollectionRequest, ...gax.CallOption) (*DeleteCollectionOperation, error)
	DeleteCollectionOperation(name string) *DeleteCollectionOperation
	GetCollection(context.Context, *visionaipb.GetCollectionRequest, ...gax.CallOption) (*visionaipb.Collection, error)
	UpdateCollection(context.Context, *visionaipb.UpdateCollectionRequest, ...gax.CallOption) (*visionaipb.Collection, error)
	ListCollections(context.Context, *visionaipb.ListCollectionsRequest, ...gax.CallOption) *CollectionIterator
	AddCollectionItem(context.Context, *visionaipb.AddCollectionItemRequest, ...gax.CallOption) (*visionaipb.AddCollectionItemResponse, error)
	RemoveCollectionItem(context.Context, *visionaipb.RemoveCollectionItemRequest, ...gax.CallOption) (*visionaipb.RemoveCollectionItemResponse, error)
	ViewCollectionItems(context.Context, *visionaipb.ViewCollectionItemsRequest, ...gax.CallOption) *CollectionItemIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// WarehouseClient is a client for interacting with Vision AI API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service that manages media content + metadata for streaming.
type WarehouseClient struct {
	// The internal transport-dependent client.
	internalClient internalWarehouseClient

	// The call options for this service.
	CallOptions *WarehouseCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *WarehouseClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *WarehouseClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *WarehouseClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateAsset creates an asset inside corpus.
func (c *WarehouseClient) CreateAsset(ctx context.Context, req *visionaipb.CreateAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	return c.internalClient.CreateAsset(ctx, req, opts...)
}

// UpdateAsset updates an asset inside corpus.
func (c *WarehouseClient) UpdateAsset(ctx context.Context, req *visionaipb.UpdateAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	return c.internalClient.UpdateAsset(ctx, req, opts...)
}

// GetAsset reads an asset inside corpus.
func (c *WarehouseClient) GetAsset(ctx context.Context, req *visionaipb.GetAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	return c.internalClient.GetAsset(ctx, req, opts...)
}

// ListAssets lists an list of assets inside corpus.
func (c *WarehouseClient) ListAssets(ctx context.Context, req *visionaipb.ListAssetsRequest, opts ...gax.CallOption) *AssetIterator {
	return c.internalClient.ListAssets(ctx, req, opts...)
}

// DeleteAsset deletes asset inside corpus.
func (c *WarehouseClient) DeleteAsset(ctx context.Context, req *visionaipb.DeleteAssetRequest, opts ...gax.CallOption) (*DeleteAssetOperation, error) {
	return c.internalClient.DeleteAsset(ctx, req, opts...)
}

// DeleteAssetOperation returns a new DeleteAssetOperation from a given name.
// The name must be that of a previously created DeleteAssetOperation, possibly from a different process.
func (c *WarehouseClient) DeleteAssetOperation(name string) *DeleteAssetOperation {
	return c.internalClient.DeleteAssetOperation(name)
}

// UploadAsset upload asset by specifing the asset Cloud Storage uri.
// For video warehouse, it requires users who call this API have read access
// to the cloud storage file. Once it is uploaded, it can be retrieved by
// GenerateRetrievalUrl API which by default, only can retrieve cloud storage
// files from the same project of the warehouse. To allow retrieval cloud
// storage files that are in a separate project, it requires to find the
// vision ai service account (Go to IAM, check checkbox to show “Include
// Google-provided role grants”, search for “Cloud Vision AI Service Agent”)
// and grant the read access of the cloud storage files to that service
// account.
func (c *WarehouseClient) UploadAsset(ctx context.Context, req *visionaipb.UploadAssetRequest, opts ...gax.CallOption) (*UploadAssetOperation, error) {
	return c.internalClient.UploadAsset(ctx, req, opts...)
}

// UploadAssetOperation returns a new UploadAssetOperation from a given name.
// The name must be that of a previously created UploadAssetOperation, possibly from a different process.
func (c *WarehouseClient) UploadAssetOperation(name string) *UploadAssetOperation {
	return c.internalClient.UploadAssetOperation(name)
}

// GenerateRetrievalUrl generates a signed url for downloading the asset.
// For video warehouse, please see comment of UploadAsset about how to allow
// retrieval of cloud storage files in a different project.
func (c *WarehouseClient) GenerateRetrievalUrl(ctx context.Context, req *visionaipb.GenerateRetrievalUrlRequest, opts ...gax.CallOption) (*visionaipb.GenerateRetrievalUrlResponse, error) {
	return c.internalClient.GenerateRetrievalUrl(ctx, req, opts...)
}

// AnalyzeAsset analyze asset to power search capability.
func (c *WarehouseClient) AnalyzeAsset(ctx context.Context, req *visionaipb.AnalyzeAssetRequest, opts ...gax.CallOption) (*AnalyzeAssetOperation, error) {
	return c.internalClient.AnalyzeAsset(ctx, req, opts...)
}

// AnalyzeAssetOperation returns a new AnalyzeAssetOperation from a given name.
// The name must be that of a previously created AnalyzeAssetOperation, possibly from a different process.
func (c *WarehouseClient) AnalyzeAssetOperation(name string) *AnalyzeAssetOperation {
	return c.internalClient.AnalyzeAssetOperation(name)
}

// IndexAsset index one asset for search.
// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
func (c *WarehouseClient) IndexAsset(ctx context.Context, req *visionaipb.IndexAssetRequest, opts ...gax.CallOption) (*IndexAssetOperation, error) {
	return c.internalClient.IndexAsset(ctx, req, opts...)
}

// IndexAssetOperation returns a new IndexAssetOperation from a given name.
// The name must be that of a previously created IndexAssetOperation, possibly from a different process.
func (c *WarehouseClient) IndexAssetOperation(name string) *IndexAssetOperation {
	return c.internalClient.IndexAssetOperation(name)
}

// RemoveIndexAsset remove one asset’s index data for search.
// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
func (c *WarehouseClient) RemoveIndexAsset(ctx context.Context, req *visionaipb.RemoveIndexAssetRequest, opts ...gax.CallOption) (*RemoveIndexAssetOperation, error) {
	return c.internalClient.RemoveIndexAsset(ctx, req, opts...)
}

// RemoveIndexAssetOperation returns a new RemoveIndexAssetOperation from a given name.
// The name must be that of a previously created RemoveIndexAssetOperation, possibly from a different process.
func (c *WarehouseClient) RemoveIndexAssetOperation(name string) *RemoveIndexAssetOperation {
	return c.internalClient.RemoveIndexAssetOperation(name)
}

// ViewIndexedAssets lists assets inside an index.
func (c *WarehouseClient) ViewIndexedAssets(ctx context.Context, req *visionaipb.ViewIndexedAssetsRequest, opts ...gax.CallOption) *IndexedAssetIterator {
	return c.internalClient.ViewIndexedAssets(ctx, req, opts...)
}

// CreateIndex creates an Index under the corpus.
func (c *WarehouseClient) CreateIndex(ctx context.Context, req *visionaipb.CreateIndexRequest, opts ...gax.CallOption) (*CreateIndexOperation, error) {
	return c.internalClient.CreateIndex(ctx, req, opts...)
}

// CreateIndexOperation returns a new CreateIndexOperation from a given name.
// The name must be that of a previously created CreateIndexOperation, possibly from a different process.
func (c *WarehouseClient) CreateIndexOperation(name string) *CreateIndexOperation {
	return c.internalClient.CreateIndexOperation(name)
}

// UpdateIndex updates an Index under the corpus.
// Users can perform a metadata-only update or trigger a full index rebuild
// with different update_mask values.
func (c *WarehouseClient) UpdateIndex(ctx context.Context, req *visionaipb.UpdateIndexRequest, opts ...gax.CallOption) (*UpdateIndexOperation, error) {
	return c.internalClient.UpdateIndex(ctx, req, opts...)
}

// UpdateIndexOperation returns a new UpdateIndexOperation from a given name.
// The name must be that of a previously created UpdateIndexOperation, possibly from a different process.
func (c *WarehouseClient) UpdateIndexOperation(name string) *UpdateIndexOperation {
	return c.internalClient.UpdateIndexOperation(name)
}

// GetIndex gets the details of a single Index under a Corpus.
func (c *WarehouseClient) GetIndex(ctx context.Context, req *visionaipb.GetIndexRequest, opts ...gax.CallOption) (*visionaipb.Index, error) {
	return c.internalClient.GetIndex(ctx, req, opts...)
}

// ListIndexes list all Indexes in a given Corpus.
func (c *WarehouseClient) ListIndexes(ctx context.Context, req *visionaipb.ListIndexesRequest, opts ...gax.CallOption) *IndexIterator {
	return c.internalClient.ListIndexes(ctx, req, opts...)
}

// DeleteIndex delete a single Index. In order to delete an index, the caller must
// make sure that it is not deployed to any index endpoint.
func (c *WarehouseClient) DeleteIndex(ctx context.Context, req *visionaipb.DeleteIndexRequest, opts ...gax.CallOption) (*DeleteIndexOperation, error) {
	return c.internalClient.DeleteIndex(ctx, req, opts...)
}

// DeleteIndexOperation returns a new DeleteIndexOperation from a given name.
// The name must be that of a previously created DeleteIndexOperation, possibly from a different process.
func (c *WarehouseClient) DeleteIndexOperation(name string) *DeleteIndexOperation {
	return c.internalClient.DeleteIndexOperation(name)
}

// CreateCorpus creates a corpus inside a project.
func (c *WarehouseClient) CreateCorpus(ctx context.Context, req *visionaipb.CreateCorpusRequest, opts ...gax.CallOption) (*CreateCorpusOperation, error) {
	return c.internalClient.CreateCorpus(ctx, req, opts...)
}

// CreateCorpusOperation returns a new CreateCorpusOperation from a given name.
// The name must be that of a previously created CreateCorpusOperation, possibly from a different process.
func (c *WarehouseClient) CreateCorpusOperation(name string) *CreateCorpusOperation {
	return c.internalClient.CreateCorpusOperation(name)
}

// GetCorpus gets corpus details inside a project.
func (c *WarehouseClient) GetCorpus(ctx context.Context, req *visionaipb.GetCorpusRequest, opts ...gax.CallOption) (*visionaipb.Corpus, error) {
	return c.internalClient.GetCorpus(ctx, req, opts...)
}

// UpdateCorpus updates a corpus in a project.
func (c *WarehouseClient) UpdateCorpus(ctx context.Context, req *visionaipb.UpdateCorpusRequest, opts ...gax.CallOption) (*visionaipb.Corpus, error) {
	return c.internalClient.UpdateCorpus(ctx, req, opts...)
}

// ListCorpora lists all corpora in a project.
func (c *WarehouseClient) ListCorpora(ctx context.Context, req *visionaipb.ListCorporaRequest, opts ...gax.CallOption) *CorpusIterator {
	return c.internalClient.ListCorpora(ctx, req, opts...)
}

// DeleteCorpus deletes a corpus only if its empty.
// Returns empty response.
func (c *WarehouseClient) DeleteCorpus(ctx context.Context, req *visionaipb.DeleteCorpusRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteCorpus(ctx, req, opts...)
}

// AnalyzeCorpus analyzes a corpus.
func (c *WarehouseClient) AnalyzeCorpus(ctx context.Context, req *visionaipb.AnalyzeCorpusRequest, opts ...gax.CallOption) (*AnalyzeCorpusOperation, error) {
	return c.internalClient.AnalyzeCorpus(ctx, req, opts...)
}

// AnalyzeCorpusOperation returns a new AnalyzeCorpusOperation from a given name.
// The name must be that of a previously created AnalyzeCorpusOperation, possibly from a different process.
func (c *WarehouseClient) AnalyzeCorpusOperation(name string) *AnalyzeCorpusOperation {
	return c.internalClient.AnalyzeCorpusOperation(name)
}

// CreateDataSchema creates data schema inside corpus.
func (c *WarehouseClient) CreateDataSchema(ctx context.Context, req *visionaipb.CreateDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	return c.internalClient.CreateDataSchema(ctx, req, opts...)
}

// UpdateDataSchema updates data schema inside corpus.
func (c *WarehouseClient) UpdateDataSchema(ctx context.Context, req *visionaipb.UpdateDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	return c.internalClient.UpdateDataSchema(ctx, req, opts...)
}

// GetDataSchema gets data schema inside corpus.
func (c *WarehouseClient) GetDataSchema(ctx context.Context, req *visionaipb.GetDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	return c.internalClient.GetDataSchema(ctx, req, opts...)
}

// DeleteDataSchema deletes data schema inside corpus.
func (c *WarehouseClient) DeleteDataSchema(ctx context.Context, req *visionaipb.DeleteDataSchemaRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteDataSchema(ctx, req, opts...)
}

// ListDataSchemas lists a list of data schemas inside corpus.
func (c *WarehouseClient) ListDataSchemas(ctx context.Context, req *visionaipb.ListDataSchemasRequest, opts ...gax.CallOption) *DataSchemaIterator {
	return c.internalClient.ListDataSchemas(ctx, req, opts...)
}

// CreateAnnotation creates annotation inside asset.
func (c *WarehouseClient) CreateAnnotation(ctx context.Context, req *visionaipb.CreateAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	return c.internalClient.CreateAnnotation(ctx, req, opts...)
}

// GetAnnotation reads annotation inside asset.
func (c *WarehouseClient) GetAnnotation(ctx context.Context, req *visionaipb.GetAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	return c.internalClient.GetAnnotation(ctx, req, opts...)
}

// ListAnnotations lists a list of annotations inside asset.
func (c *WarehouseClient) ListAnnotations(ctx context.Context, req *visionaipb.ListAnnotationsRequest, opts ...gax.CallOption) *AnnotationIterator {
	return c.internalClient.ListAnnotations(ctx, req, opts...)
}

// UpdateAnnotation updates annotation inside asset.
func (c *WarehouseClient) UpdateAnnotation(ctx context.Context, req *visionaipb.UpdateAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	return c.internalClient.UpdateAnnotation(ctx, req, opts...)
}

// DeleteAnnotation deletes annotation inside asset.
func (c *WarehouseClient) DeleteAnnotation(ctx context.Context, req *visionaipb.DeleteAnnotationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteAnnotation(ctx, req, opts...)
}

// IngestAsset ingests data for the asset. It is not allowed to ingest a data chunk which
// is already expired according to TTL.
// This method is only available via the gRPC API (not HTTP since
// bi-directional streaming is not supported via HTTP).
//
// This method is not supported for the REST transport.
func (c *WarehouseClient) IngestAsset(ctx context.Context, opts ...gax.CallOption) (visionaipb.Warehouse_IngestAssetClient, error) {
	return c.internalClient.IngestAsset(ctx, opts...)
}

// ClipAsset supported by STREAM_VIDEO corpus type.
// Generates clips for downloading. The api takes in a time range, and
// generates a clip of the first content available after start_time and
// before end_time, which may overflow beyond these bounds.
// Returned clips are truncated if the total size of the clips are larger
// than 100MB.
func (c *WarehouseClient) ClipAsset(ctx context.Context, req *visionaipb.ClipAssetRequest, opts ...gax.CallOption) (*visionaipb.ClipAssetResponse, error) {
	return c.internalClient.ClipAsset(ctx, req, opts...)
}

// GenerateHlsUri generates a uri for an HLS manifest. The api takes in a collection of time
// ranges, and generates a URI for an HLS manifest that covers all the
// requested time ranges.
func (c *WarehouseClient) GenerateHlsUri(ctx context.Context, req *visionaipb.GenerateHlsUriRequest, opts ...gax.CallOption) (*visionaipb.GenerateHlsUriResponse, error) {
	return c.internalClient.GenerateHlsUri(ctx, req, opts...)
}

// ImportAssets imports assets (images plus annotations) from a meta file on cloud storage.
// Each row in the meta file is corresponding to an image (specified by a
// cloud storage uri) and its annotations.
func (c *WarehouseClient) ImportAssets(ctx context.Context, req *visionaipb.ImportAssetsRequest, opts ...gax.CallOption) (*ImportAssetsOperation, error) {
	return c.internalClient.ImportAssets(ctx, req, opts...)
}

// ImportAssetsOperation returns a new ImportAssetsOperation from a given name.
// The name must be that of a previously created ImportAssetsOperation, possibly from a different process.
func (c *WarehouseClient) ImportAssetsOperation(name string) *ImportAssetsOperation {
	return c.internalClient.ImportAssetsOperation(name)
}

// CreateSearchConfig creates a search configuration inside a corpus.
//
// Please follow the rules below to create a valid CreateSearchConfigRequest.
// — General Rules —
//
// Request.search_config_id must not be associated with an existing
// SearchConfig.
//
// Request must contain at least one non-empty search_criteria_property or
// facet_property.
//
// mapped_fields must not be empty, and must map to existing UGA keys.
//
// All mapped_fields must be of the same type.
//
// All mapped_fields must share the same granularity.
//
// All mapped_fields must share the same semantic SearchConfig match
// options.
// For property-specific rules, please reference the comments for
// FacetProperty and SearchCriteriaProperty.
func (c *WarehouseClient) CreateSearchConfig(ctx context.Context, req *visionaipb.CreateSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	return c.internalClient.CreateSearchConfig(ctx, req, opts...)
}

// UpdateSearchConfig updates a search configuration inside a corpus.
//
// Please follow the rules below to create a valid UpdateSearchConfigRequest.
// — General Rules —
//
// Request.search_configuration.name must already exist.
//
// Request must contain at least one non-empty search_criteria_property or
// facet_property.
//
// mapped_fields must not be empty, and must map to existing UGA keys.
//
// All mapped_fields must be of the same type.
//
// All mapped_fields must share the same granularity.
//
// All mapped_fields must share the same semantic SearchConfig match
// options.
// For property-specific rules, please reference the comments for
// FacetProperty and SearchCriteriaProperty.
func (c *WarehouseClient) UpdateSearchConfig(ctx context.Context, req *visionaipb.UpdateSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	return c.internalClient.UpdateSearchConfig(ctx, req, opts...)
}

// GetSearchConfig gets a search configuration inside a corpus.
func (c *WarehouseClient) GetSearchConfig(ctx context.Context, req *visionaipb.GetSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	return c.internalClient.GetSearchConfig(ctx, req, opts...)
}

// DeleteSearchConfig deletes a search configuration inside a corpus.
//
// For a DeleteSearchConfigRequest to be valid,
// Request.search_configuration.name must already exist.
func (c *WarehouseClient) DeleteSearchConfig(ctx context.Context, req *visionaipb.DeleteSearchConfigRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSearchConfig(ctx, req, opts...)
}

// ListSearchConfigs lists all search configurations inside a corpus.
func (c *WarehouseClient) ListSearchConfigs(ctx context.Context, req *visionaipb.ListSearchConfigsRequest, opts ...gax.CallOption) *SearchConfigIterator {
	return c.internalClient.ListSearchConfigs(ctx, req, opts...)
}

// CreateSearchHypernym creates a SearchHypernym inside a corpus.
func (c *WarehouseClient) CreateSearchHypernym(ctx context.Context, req *visionaipb.CreateSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	return c.internalClient.CreateSearchHypernym(ctx, req, opts...)
}

// UpdateSearchHypernym updates a SearchHypernym inside a corpus.
func (c *WarehouseClient) UpdateSearchHypernym(ctx context.Context, req *visionaipb.UpdateSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	return c.internalClient.UpdateSearchHypernym(ctx, req, opts...)
}

// GetSearchHypernym gets a SearchHypernym inside a corpus.
func (c *WarehouseClient) GetSearchHypernym(ctx context.Context, req *visionaipb.GetSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	return c.internalClient.GetSearchHypernym(ctx, req, opts...)
}

// DeleteSearchHypernym deletes a SearchHypernym inside a corpus.
func (c *WarehouseClient) DeleteSearchHypernym(ctx context.Context, req *visionaipb.DeleteSearchHypernymRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSearchHypernym(ctx, req, opts...)
}

// ListSearchHypernyms lists SearchHypernyms inside a corpus.
func (c *WarehouseClient) ListSearchHypernyms(ctx context.Context, req *visionaipb.ListSearchHypernymsRequest, opts ...gax.CallOption) *SearchHypernymIterator {
	return c.internalClient.ListSearchHypernyms(ctx, req, opts...)
}

// SearchAssets search media asset.
func (c *WarehouseClient) SearchAssets(ctx context.Context, req *visionaipb.SearchAssetsRequest, opts ...gax.CallOption) *SearchResultItemIterator {
	return c.internalClient.SearchAssets(ctx, req, opts...)
}

// SearchIndexEndpoint search a deployed index endpoint (IMAGE corpus type only).
func (c *WarehouseClient) SearchIndexEndpoint(ctx context.Context, req *visionaipb.SearchIndexEndpointRequest, opts ...gax.CallOption) *SearchResultItemIterator {
	return c.internalClient.SearchIndexEndpoint(ctx, req, opts...)
}

// CreateIndexEndpoint creates an IndexEndpoint.
func (c *WarehouseClient) CreateIndexEndpoint(ctx context.Context, req *visionaipb.CreateIndexEndpointRequest, opts ...gax.CallOption) (*CreateIndexEndpointOperation, error) {
	return c.internalClient.CreateIndexEndpoint(ctx, req, opts...)
}

// CreateIndexEndpointOperation returns a new CreateIndexEndpointOperation from a given name.
// The name must be that of a previously created CreateIndexEndpointOperation, possibly from a different process.
func (c *WarehouseClient) CreateIndexEndpointOperation(name string) *CreateIndexEndpointOperation {
	return c.internalClient.CreateIndexEndpointOperation(name)
}

// GetIndexEndpoint gets an IndexEndpoint.
func (c *WarehouseClient) GetIndexEndpoint(ctx context.Context, req *visionaipb.GetIndexEndpointRequest, opts ...gax.CallOption) (*visionaipb.IndexEndpoint, error) {
	return c.internalClient.GetIndexEndpoint(ctx, req, opts...)
}

// ListIndexEndpoints lists all IndexEndpoints in a project.
func (c *WarehouseClient) ListIndexEndpoints(ctx context.Context, req *visionaipb.ListIndexEndpointsRequest, opts ...gax.CallOption) *IndexEndpointIterator {
	return c.internalClient.ListIndexEndpoints(ctx, req, opts...)
}

// UpdateIndexEndpoint updates an IndexEndpoint.
func (c *WarehouseClient) UpdateIndexEndpoint(ctx context.Context, req *visionaipb.UpdateIndexEndpointRequest, opts ...gax.CallOption) (*UpdateIndexEndpointOperation, error) {
	return c.internalClient.UpdateIndexEndpoint(ctx, req, opts...)
}

// UpdateIndexEndpointOperation returns a new UpdateIndexEndpointOperation from a given name.
// The name must be that of a previously created UpdateIndexEndpointOperation, possibly from a different process.
func (c *WarehouseClient) UpdateIndexEndpointOperation(name string) *UpdateIndexEndpointOperation {
	return c.internalClient.UpdateIndexEndpointOperation(name)
}

// DeleteIndexEndpoint deletes an IndexEndpoint.
func (c *WarehouseClient) DeleteIndexEndpoint(ctx context.Context, req *visionaipb.DeleteIndexEndpointRequest, opts ...gax.CallOption) (*DeleteIndexEndpointOperation, error) {
	return c.internalClient.DeleteIndexEndpoint(ctx, req, opts...)
}

// DeleteIndexEndpointOperation returns a new DeleteIndexEndpointOperation from a given name.
// The name must be that of a previously created DeleteIndexEndpointOperation, possibly from a different process.
func (c *WarehouseClient) DeleteIndexEndpointOperation(name string) *DeleteIndexEndpointOperation {
	return c.internalClient.DeleteIndexEndpointOperation(name)
}

// DeployIndex deploys an Index to IndexEndpoint.
func (c *WarehouseClient) DeployIndex(ctx context.Context, req *visionaipb.DeployIndexRequest, opts ...gax.CallOption) (*DeployIndexOperation, error) {
	return c.internalClient.DeployIndex(ctx, req, opts...)
}

// DeployIndexOperation returns a new DeployIndexOperation from a given name.
// The name must be that of a previously created DeployIndexOperation, possibly from a different process.
func (c *WarehouseClient) DeployIndexOperation(name string) *DeployIndexOperation {
	return c.internalClient.DeployIndexOperation(name)
}

// UndeployIndex undeploys an Index from IndexEndpoint.
func (c *WarehouseClient) UndeployIndex(ctx context.Context, req *visionaipb.UndeployIndexRequest, opts ...gax.CallOption) (*UndeployIndexOperation, error) {
	return c.internalClient.UndeployIndex(ctx, req, opts...)
}

// UndeployIndexOperation returns a new UndeployIndexOperation from a given name.
// The name must be that of a previously created UndeployIndexOperation, possibly from a different process.
func (c *WarehouseClient) UndeployIndexOperation(name string) *UndeployIndexOperation {
	return c.internalClient.UndeployIndexOperation(name)
}

// CreateCollection creates a collection.
func (c *WarehouseClient) CreateCollection(ctx context.Context, req *visionaipb.CreateCollectionRequest, opts ...gax.CallOption) (*CreateCollectionOperation, error) {
	return c.internalClient.CreateCollection(ctx, req, opts...)
}

// CreateCollectionOperation returns a new CreateCollectionOperation from a given name.
// The name must be that of a previously created CreateCollectionOperation, possibly from a different process.
func (c *WarehouseClient) CreateCollectionOperation(name string) *CreateCollectionOperation {
	return c.internalClient.CreateCollectionOperation(name)
}

// DeleteCollection deletes a collection.
func (c *WarehouseClient) DeleteCollection(ctx context.Context, req *visionaipb.DeleteCollectionRequest, opts ...gax.CallOption) (*DeleteCollectionOperation, error) {
	return c.internalClient.DeleteCollection(ctx, req, opts...)
}

// DeleteCollectionOperation returns a new DeleteCollectionOperation from a given name.
// The name must be that of a previously created DeleteCollectionOperation, possibly from a different process.
func (c *WarehouseClient) DeleteCollectionOperation(name string) *DeleteCollectionOperation {
	return c.internalClient.DeleteCollectionOperation(name)
}

// GetCollection gets a collection.
func (c *WarehouseClient) GetCollection(ctx context.Context, req *visionaipb.GetCollectionRequest, opts ...gax.CallOption) (*visionaipb.Collection, error) {
	return c.internalClient.GetCollection(ctx, req, opts...)
}

// UpdateCollection updates a collection.
func (c *WarehouseClient) UpdateCollection(ctx context.Context, req *visionaipb.UpdateCollectionRequest, opts ...gax.CallOption) (*visionaipb.Collection, error) {
	return c.internalClient.UpdateCollection(ctx, req, opts...)
}

// ListCollections lists collections inside a corpus.
func (c *WarehouseClient) ListCollections(ctx context.Context, req *visionaipb.ListCollectionsRequest, opts ...gax.CallOption) *CollectionIterator {
	return c.internalClient.ListCollections(ctx, req, opts...)
}

// AddCollectionItem adds an item into a Collection.
func (c *WarehouseClient) AddCollectionItem(ctx context.Context, req *visionaipb.AddCollectionItemRequest, opts ...gax.CallOption) (*visionaipb.AddCollectionItemResponse, error) {
	return c.internalClient.AddCollectionItem(ctx, req, opts...)
}

// RemoveCollectionItem removes an item from a collection.
func (c *WarehouseClient) RemoveCollectionItem(ctx context.Context, req *visionaipb.RemoveCollectionItemRequest, opts ...gax.CallOption) (*visionaipb.RemoveCollectionItemResponse, error) {
	return c.internalClient.RemoveCollectionItem(ctx, req, opts...)
}

// ViewCollectionItems view items inside a collection.
func (c *WarehouseClient) ViewCollectionItems(ctx context.Context, req *visionaipb.ViewCollectionItemsRequest, opts ...gax.CallOption) *CollectionItemIterator {
	return c.internalClient.ViewCollectionItems(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *WarehouseClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *WarehouseClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *WarehouseClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *WarehouseClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// warehouseGRPCClient is a client for interacting with Vision AI API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type warehouseGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing WarehouseClient
	CallOptions **WarehouseCallOptions

	// The gRPC API client.
	warehouseClient visionaipb.WarehouseClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewWarehouseClient creates a new warehouse client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service that manages media content + metadata for streaming.
func NewWarehouseClient(ctx context.Context, opts ...option.ClientOption) (*WarehouseClient, error) {
	clientOpts := defaultWarehouseGRPCClientOptions()
	if newWarehouseClientHook != nil {
		hookOpts, err := newWarehouseClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := WarehouseClient{CallOptions: defaultWarehouseCallOptions()}

	c := &warehouseGRPCClient{
		connPool:         connPool,
		warehouseClient:  visionaipb.NewWarehouseClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *warehouseGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *warehouseGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *warehouseGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type warehouseRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing WarehouseClient
	CallOptions **WarehouseCallOptions

	logger *slog.Logger
}

// NewWarehouseRESTClient creates a new warehouse rest client.
//
// Service that manages media content + metadata for streaming.
func NewWarehouseRESTClient(ctx context.Context, opts ...option.ClientOption) (*WarehouseClient, error) {
	clientOpts := append(defaultWarehouseRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultWarehouseRESTCallOptions()
	c := &warehouseRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &WarehouseClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultWarehouseRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://visionai.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://visionai.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://visionai.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://visionai.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *warehouseRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *warehouseRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *warehouseRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *warehouseGRPCClient) CreateAsset(ctx context.Context, req *visionaipb.CreateAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAsset[0:len((*c.CallOptions).CreateAsset):len((*c.CallOptions).CreateAsset)], opts...)
	var resp *visionaipb.Asset
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateAsset, req, settings.GRPC, c.logger, "CreateAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) UpdateAsset(ctx context.Context, req *visionaipb.UpdateAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "asset.name", url.QueryEscape(req.GetAsset().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAsset[0:len((*c.CallOptions).UpdateAsset):len((*c.CallOptions).UpdateAsset)], opts...)
	var resp *visionaipb.Asset
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateAsset, req, settings.GRPC, c.logger, "UpdateAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) GetAsset(ctx context.Context, req *visionaipb.GetAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAsset[0:len((*c.CallOptions).GetAsset):len((*c.CallOptions).GetAsset)], opts...)
	var resp *visionaipb.Asset
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetAsset, req, settings.GRPC, c.logger, "GetAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListAssets(ctx context.Context, req *visionaipb.ListAssetsRequest, opts ...gax.CallOption) *AssetIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAssets[0:len((*c.CallOptions).ListAssets):len((*c.CallOptions).ListAssets)], opts...)
	it := &AssetIterator{}
	req = proto.Clone(req).(*visionaipb.ListAssetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Asset, string, error) {
		resp := &visionaipb.ListAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListAssets, req, settings.GRPC, c.logger, "ListAssets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAssets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) DeleteAsset(ctx context.Context, req *visionaipb.DeleteAssetRequest, opts ...gax.CallOption) (*DeleteAssetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAsset[0:len((*c.CallOptions).DeleteAsset):len((*c.CallOptions).DeleteAsset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.DeleteAsset, req, settings.GRPC, c.logger, "DeleteAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) UploadAsset(ctx context.Context, req *visionaipb.UploadAssetRequest, opts ...gax.CallOption) (*UploadAssetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UploadAsset[0:len((*c.CallOptions).UploadAsset):len((*c.CallOptions).UploadAsset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UploadAsset, req, settings.GRPC, c.logger, "UploadAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UploadAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) GenerateRetrievalUrl(ctx context.Context, req *visionaipb.GenerateRetrievalUrlRequest, opts ...gax.CallOption) (*visionaipb.GenerateRetrievalUrlResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateRetrievalUrl[0:len((*c.CallOptions).GenerateRetrievalUrl):len((*c.CallOptions).GenerateRetrievalUrl)], opts...)
	var resp *visionaipb.GenerateRetrievalUrlResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GenerateRetrievalUrl, req, settings.GRPC, c.logger, "GenerateRetrievalUrl")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) AnalyzeAsset(ctx context.Context, req *visionaipb.AnalyzeAssetRequest, opts ...gax.CallOption) (*AnalyzeAssetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AnalyzeAsset[0:len((*c.CallOptions).AnalyzeAsset):len((*c.CallOptions).AnalyzeAsset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.AnalyzeAsset, req, settings.GRPC, c.logger, "AnalyzeAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AnalyzeAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) IndexAsset(ctx context.Context, req *visionaipb.IndexAssetRequest, opts ...gax.CallOption) (*IndexAssetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).IndexAsset[0:len((*c.CallOptions).IndexAsset):len((*c.CallOptions).IndexAsset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.IndexAsset, req, settings.GRPC, c.logger, "IndexAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &IndexAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) RemoveIndexAsset(ctx context.Context, req *visionaipb.RemoveIndexAssetRequest, opts ...gax.CallOption) (*RemoveIndexAssetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RemoveIndexAsset[0:len((*c.CallOptions).RemoveIndexAsset):len((*c.CallOptions).RemoveIndexAsset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.RemoveIndexAsset, req, settings.GRPC, c.logger, "RemoveIndexAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RemoveIndexAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) ViewIndexedAssets(ctx context.Context, req *visionaipb.ViewIndexedAssetsRequest, opts ...gax.CallOption) *IndexedAssetIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index", url.QueryEscape(req.GetIndex()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ViewIndexedAssets[0:len((*c.CallOptions).ViewIndexedAssets):len((*c.CallOptions).ViewIndexedAssets)], opts...)
	it := &IndexedAssetIterator{}
	req = proto.Clone(req).(*visionaipb.ViewIndexedAssetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.IndexedAsset, string, error) {
		resp := &visionaipb.ViewIndexedAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ViewIndexedAssets, req, settings.GRPC, c.logger, "ViewIndexedAssets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetIndexedAssets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) CreateIndex(ctx context.Context, req *visionaipb.CreateIndexRequest, opts ...gax.CallOption) (*CreateIndexOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateIndex[0:len((*c.CallOptions).CreateIndex):len((*c.CallOptions).CreateIndex)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateIndex, req, settings.GRPC, c.logger, "CreateIndex")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) UpdateIndex(ctx context.Context, req *visionaipb.UpdateIndexRequest, opts ...gax.CallOption) (*UpdateIndexOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index.name", url.QueryEscape(req.GetIndex().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateIndex[0:len((*c.CallOptions).UpdateIndex):len((*c.CallOptions).UpdateIndex)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateIndex, req, settings.GRPC, c.logger, "UpdateIndex")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) GetIndex(ctx context.Context, req *visionaipb.GetIndexRequest, opts ...gax.CallOption) (*visionaipb.Index, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIndex[0:len((*c.CallOptions).GetIndex):len((*c.CallOptions).GetIndex)], opts...)
	var resp *visionaipb.Index
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetIndex, req, settings.GRPC, c.logger, "GetIndex")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListIndexes(ctx context.Context, req *visionaipb.ListIndexesRequest, opts ...gax.CallOption) *IndexIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListIndexes[0:len((*c.CallOptions).ListIndexes):len((*c.CallOptions).ListIndexes)], opts...)
	it := &IndexIterator{}
	req = proto.Clone(req).(*visionaipb.ListIndexesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Index, string, error) {
		resp := &visionaipb.ListIndexesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListIndexes, req, settings.GRPC, c.logger, "ListIndexes")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetIndexes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) DeleteIndex(ctx context.Context, req *visionaipb.DeleteIndexRequest, opts ...gax.CallOption) (*DeleteIndexOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteIndex[0:len((*c.CallOptions).DeleteIndex):len((*c.CallOptions).DeleteIndex)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.DeleteIndex, req, settings.GRPC, c.logger, "DeleteIndex")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) CreateCorpus(ctx context.Context, req *visionaipb.CreateCorpusRequest, opts ...gax.CallOption) (*CreateCorpusOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateCorpus[0:len((*c.CallOptions).CreateCorpus):len((*c.CallOptions).CreateCorpus)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateCorpus, req, settings.GRPC, c.logger, "CreateCorpus")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateCorpusOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) GetCorpus(ctx context.Context, req *visionaipb.GetCorpusRequest, opts ...gax.CallOption) (*visionaipb.Corpus, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetCorpus[0:len((*c.CallOptions).GetCorpus):len((*c.CallOptions).GetCorpus)], opts...)
	var resp *visionaipb.Corpus
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetCorpus, req, settings.GRPC, c.logger, "GetCorpus")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) UpdateCorpus(ctx context.Context, req *visionaipb.UpdateCorpusRequest, opts ...gax.CallOption) (*visionaipb.Corpus, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "corpus.name", url.QueryEscape(req.GetCorpus().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCorpus[0:len((*c.CallOptions).UpdateCorpus):len((*c.CallOptions).UpdateCorpus)], opts...)
	var resp *visionaipb.Corpus
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateCorpus, req, settings.GRPC, c.logger, "UpdateCorpus")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListCorpora(ctx context.Context, req *visionaipb.ListCorporaRequest, opts ...gax.CallOption) *CorpusIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListCorpora[0:len((*c.CallOptions).ListCorpora):len((*c.CallOptions).ListCorpora)], opts...)
	it := &CorpusIterator{}
	req = proto.Clone(req).(*visionaipb.ListCorporaRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Corpus, string, error) {
		resp := &visionaipb.ListCorporaResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListCorpora, req, settings.GRPC, c.logger, "ListCorpora")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCorpora(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) DeleteCorpus(ctx context.Context, req *visionaipb.DeleteCorpusRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteCorpus[0:len((*c.CallOptions).DeleteCorpus):len((*c.CallOptions).DeleteCorpus)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.warehouseClient.DeleteCorpus, req, settings.GRPC, c.logger, "DeleteCorpus")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) AnalyzeCorpus(ctx context.Context, req *visionaipb.AnalyzeCorpusRequest, opts ...gax.CallOption) (*AnalyzeCorpusOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AnalyzeCorpus[0:len((*c.CallOptions).AnalyzeCorpus):len((*c.CallOptions).AnalyzeCorpus)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.AnalyzeCorpus, req, settings.GRPC, c.logger, "AnalyzeCorpus")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AnalyzeCorpusOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) CreateDataSchema(ctx context.Context, req *visionaipb.CreateDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDataSchema[0:len((*c.CallOptions).CreateDataSchema):len((*c.CallOptions).CreateDataSchema)], opts...)
	var resp *visionaipb.DataSchema
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateDataSchema, req, settings.GRPC, c.logger, "CreateDataSchema")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) UpdateDataSchema(ctx context.Context, req *visionaipb.UpdateDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "data_schema.name", url.QueryEscape(req.GetDataSchema().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDataSchema[0:len((*c.CallOptions).UpdateDataSchema):len((*c.CallOptions).UpdateDataSchema)], opts...)
	var resp *visionaipb.DataSchema
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateDataSchema, req, settings.GRPC, c.logger, "UpdateDataSchema")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) GetDataSchema(ctx context.Context, req *visionaipb.GetDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDataSchema[0:len((*c.CallOptions).GetDataSchema):len((*c.CallOptions).GetDataSchema)], opts...)
	var resp *visionaipb.DataSchema
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetDataSchema, req, settings.GRPC, c.logger, "GetDataSchema")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) DeleteDataSchema(ctx context.Context, req *visionaipb.DeleteDataSchemaRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDataSchema[0:len((*c.CallOptions).DeleteDataSchema):len((*c.CallOptions).DeleteDataSchema)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.warehouseClient.DeleteDataSchema, req, settings.GRPC, c.logger, "DeleteDataSchema")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) ListDataSchemas(ctx context.Context, req *visionaipb.ListDataSchemasRequest, opts ...gax.CallOption) *DataSchemaIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDataSchemas[0:len((*c.CallOptions).ListDataSchemas):len((*c.CallOptions).ListDataSchemas)], opts...)
	it := &DataSchemaIterator{}
	req = proto.Clone(req).(*visionaipb.ListDataSchemasRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.DataSchema, string, error) {
		resp := &visionaipb.ListDataSchemasResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListDataSchemas, req, settings.GRPC, c.logger, "ListDataSchemas")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDataSchemas(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) CreateAnnotation(ctx context.Context, req *visionaipb.CreateAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAnnotation[0:len((*c.CallOptions).CreateAnnotation):len((*c.CallOptions).CreateAnnotation)], opts...)
	var resp *visionaipb.Annotation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateAnnotation, req, settings.GRPC, c.logger, "CreateAnnotation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) GetAnnotation(ctx context.Context, req *visionaipb.GetAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAnnotation[0:len((*c.CallOptions).GetAnnotation):len((*c.CallOptions).GetAnnotation)], opts...)
	var resp *visionaipb.Annotation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetAnnotation, req, settings.GRPC, c.logger, "GetAnnotation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListAnnotations(ctx context.Context, req *visionaipb.ListAnnotationsRequest, opts ...gax.CallOption) *AnnotationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAnnotations[0:len((*c.CallOptions).ListAnnotations):len((*c.CallOptions).ListAnnotations)], opts...)
	it := &AnnotationIterator{}
	req = proto.Clone(req).(*visionaipb.ListAnnotationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Annotation, string, error) {
		resp := &visionaipb.ListAnnotationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListAnnotations, req, settings.GRPC, c.logger, "ListAnnotations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAnnotations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) UpdateAnnotation(ctx context.Context, req *visionaipb.UpdateAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "annotation.name", url.QueryEscape(req.GetAnnotation().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAnnotation[0:len((*c.CallOptions).UpdateAnnotation):len((*c.CallOptions).UpdateAnnotation)], opts...)
	var resp *visionaipb.Annotation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateAnnotation, req, settings.GRPC, c.logger, "UpdateAnnotation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) DeleteAnnotation(ctx context.Context, req *visionaipb.DeleteAnnotationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAnnotation[0:len((*c.CallOptions).DeleteAnnotation):len((*c.CallOptions).DeleteAnnotation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.warehouseClient.DeleteAnnotation, req, settings.GRPC, c.logger, "DeleteAnnotation")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) IngestAsset(ctx context.Context, opts ...gax.CallOption) (visionaipb.Warehouse_IngestAssetClient, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	var resp visionaipb.Warehouse_IngestAssetClient
	opts = append((*c.CallOptions).IngestAsset[0:len((*c.CallOptions).IngestAsset):len((*c.CallOptions).IngestAsset)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		c.logger.DebugContext(ctx, "api streaming client request", "serviceName", serviceName, "rpcName", "IngestAsset")
		resp, err = c.warehouseClient.IngestAsset(ctx, settings.GRPC...)
		c.logger.DebugContext(ctx, "api streaming client response", "serviceName", serviceName, "rpcName", "IngestAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ClipAsset(ctx context.Context, req *visionaipb.ClipAssetRequest, opts ...gax.CallOption) (*visionaipb.ClipAssetResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ClipAsset[0:len((*c.CallOptions).ClipAsset):len((*c.CallOptions).ClipAsset)], opts...)
	var resp *visionaipb.ClipAssetResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.ClipAsset, req, settings.GRPC, c.logger, "ClipAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) GenerateHlsUri(ctx context.Context, req *visionaipb.GenerateHlsUriRequest, opts ...gax.CallOption) (*visionaipb.GenerateHlsUriResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateHlsUri[0:len((*c.CallOptions).GenerateHlsUri):len((*c.CallOptions).GenerateHlsUri)], opts...)
	var resp *visionaipb.GenerateHlsUriResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GenerateHlsUri, req, settings.GRPC, c.logger, "GenerateHlsUri")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ImportAssets(ctx context.Context, req *visionaipb.ImportAssetsRequest, opts ...gax.CallOption) (*ImportAssetsOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ImportAssets[0:len((*c.CallOptions).ImportAssets):len((*c.CallOptions).ImportAssets)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.ImportAssets, req, settings.GRPC, c.logger, "ImportAssets")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ImportAssetsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) CreateSearchConfig(ctx context.Context, req *visionaipb.CreateSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSearchConfig[0:len((*c.CallOptions).CreateSearchConfig):len((*c.CallOptions).CreateSearchConfig)], opts...)
	var resp *visionaipb.SearchConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateSearchConfig, req, settings.GRPC, c.logger, "CreateSearchConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) UpdateSearchConfig(ctx context.Context, req *visionaipb.UpdateSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "search_config.name", url.QueryEscape(req.GetSearchConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSearchConfig[0:len((*c.CallOptions).UpdateSearchConfig):len((*c.CallOptions).UpdateSearchConfig)], opts...)
	var resp *visionaipb.SearchConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateSearchConfig, req, settings.GRPC, c.logger, "UpdateSearchConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) GetSearchConfig(ctx context.Context, req *visionaipb.GetSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSearchConfig[0:len((*c.CallOptions).GetSearchConfig):len((*c.CallOptions).GetSearchConfig)], opts...)
	var resp *visionaipb.SearchConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetSearchConfig, req, settings.GRPC, c.logger, "GetSearchConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) DeleteSearchConfig(ctx context.Context, req *visionaipb.DeleteSearchConfigRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSearchConfig[0:len((*c.CallOptions).DeleteSearchConfig):len((*c.CallOptions).DeleteSearchConfig)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.warehouseClient.DeleteSearchConfig, req, settings.GRPC, c.logger, "DeleteSearchConfig")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) ListSearchConfigs(ctx context.Context, req *visionaipb.ListSearchConfigsRequest, opts ...gax.CallOption) *SearchConfigIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSearchConfigs[0:len((*c.CallOptions).ListSearchConfigs):len((*c.CallOptions).ListSearchConfigs)], opts...)
	it := &SearchConfigIterator{}
	req = proto.Clone(req).(*visionaipb.ListSearchConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchConfig, string, error) {
		resp := &visionaipb.ListSearchConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListSearchConfigs, req, settings.GRPC, c.logger, "ListSearchConfigs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSearchConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) CreateSearchHypernym(ctx context.Context, req *visionaipb.CreateSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSearchHypernym[0:len((*c.CallOptions).CreateSearchHypernym):len((*c.CallOptions).CreateSearchHypernym)], opts...)
	var resp *visionaipb.SearchHypernym
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateSearchHypernym, req, settings.GRPC, c.logger, "CreateSearchHypernym")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) UpdateSearchHypernym(ctx context.Context, req *visionaipb.UpdateSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "search_hypernym.name", url.QueryEscape(req.GetSearchHypernym().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSearchHypernym[0:len((*c.CallOptions).UpdateSearchHypernym):len((*c.CallOptions).UpdateSearchHypernym)], opts...)
	var resp *visionaipb.SearchHypernym
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateSearchHypernym, req, settings.GRPC, c.logger, "UpdateSearchHypernym")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) GetSearchHypernym(ctx context.Context, req *visionaipb.GetSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSearchHypernym[0:len((*c.CallOptions).GetSearchHypernym):len((*c.CallOptions).GetSearchHypernym)], opts...)
	var resp *visionaipb.SearchHypernym
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetSearchHypernym, req, settings.GRPC, c.logger, "GetSearchHypernym")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) DeleteSearchHypernym(ctx context.Context, req *visionaipb.DeleteSearchHypernymRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSearchHypernym[0:len((*c.CallOptions).DeleteSearchHypernym):len((*c.CallOptions).DeleteSearchHypernym)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.warehouseClient.DeleteSearchHypernym, req, settings.GRPC, c.logger, "DeleteSearchHypernym")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) ListSearchHypernyms(ctx context.Context, req *visionaipb.ListSearchHypernymsRequest, opts ...gax.CallOption) *SearchHypernymIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSearchHypernyms[0:len((*c.CallOptions).ListSearchHypernyms):len((*c.CallOptions).ListSearchHypernyms)], opts...)
	it := &SearchHypernymIterator{}
	req = proto.Clone(req).(*visionaipb.ListSearchHypernymsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchHypernym, string, error) {
		resp := &visionaipb.ListSearchHypernymsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListSearchHypernyms, req, settings.GRPC, c.logger, "ListSearchHypernyms")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSearchHypernyms(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) SearchAssets(ctx context.Context, req *visionaipb.SearchAssetsRequest, opts ...gax.CallOption) *SearchResultItemIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "corpus", url.QueryEscape(req.GetCorpus()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchAssets[0:len((*c.CallOptions).SearchAssets):len((*c.CallOptions).SearchAssets)], opts...)
	it := &SearchResultItemIterator{}
	req = proto.Clone(req).(*visionaipb.SearchAssetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchResultItem, string, error) {
		resp := &visionaipb.SearchAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.SearchAssets, req, settings.GRPC, c.logger, "SearchAssets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSearchResultItems(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) SearchIndexEndpoint(ctx context.Context, req *visionaipb.SearchIndexEndpointRequest, opts ...gax.CallOption) *SearchResultItemIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint", url.QueryEscape(req.GetIndexEndpoint()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchIndexEndpoint[0:len((*c.CallOptions).SearchIndexEndpoint):len((*c.CallOptions).SearchIndexEndpoint)], opts...)
	it := &SearchResultItemIterator{}
	req = proto.Clone(req).(*visionaipb.SearchIndexEndpointRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchResultItem, string, error) {
		resp := &visionaipb.SearchIndexEndpointResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.SearchIndexEndpoint, req, settings.GRPC, c.logger, "SearchIndexEndpoint")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSearchResultItems(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) CreateIndexEndpoint(ctx context.Context, req *visionaipb.CreateIndexEndpointRequest, opts ...gax.CallOption) (*CreateIndexEndpointOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateIndexEndpoint[0:len((*c.CallOptions).CreateIndexEndpoint):len((*c.CallOptions).CreateIndexEndpoint)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateIndexEndpoint, req, settings.GRPC, c.logger, "CreateIndexEndpoint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateIndexEndpointOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) GetIndexEndpoint(ctx context.Context, req *visionaipb.GetIndexEndpointRequest, opts ...gax.CallOption) (*visionaipb.IndexEndpoint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIndexEndpoint[0:len((*c.CallOptions).GetIndexEndpoint):len((*c.CallOptions).GetIndexEndpoint)], opts...)
	var resp *visionaipb.IndexEndpoint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetIndexEndpoint, req, settings.GRPC, c.logger, "GetIndexEndpoint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListIndexEndpoints(ctx context.Context, req *visionaipb.ListIndexEndpointsRequest, opts ...gax.CallOption) *IndexEndpointIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListIndexEndpoints[0:len((*c.CallOptions).ListIndexEndpoints):len((*c.CallOptions).ListIndexEndpoints)], opts...)
	it := &IndexEndpointIterator{}
	req = proto.Clone(req).(*visionaipb.ListIndexEndpointsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.IndexEndpoint, string, error) {
		resp := &visionaipb.ListIndexEndpointsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListIndexEndpoints, req, settings.GRPC, c.logger, "ListIndexEndpoints")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetIndexEndpoints(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) UpdateIndexEndpoint(ctx context.Context, req *visionaipb.UpdateIndexEndpointRequest, opts ...gax.CallOption) (*UpdateIndexEndpointOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint.name", url.QueryEscape(req.GetIndexEndpoint().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateIndexEndpoint[0:len((*c.CallOptions).UpdateIndexEndpoint):len((*c.CallOptions).UpdateIndexEndpoint)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateIndexEndpoint, req, settings.GRPC, c.logger, "UpdateIndexEndpoint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateIndexEndpointOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) DeleteIndexEndpoint(ctx context.Context, req *visionaipb.DeleteIndexEndpointRequest, opts ...gax.CallOption) (*DeleteIndexEndpointOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteIndexEndpoint[0:len((*c.CallOptions).DeleteIndexEndpoint):len((*c.CallOptions).DeleteIndexEndpoint)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.DeleteIndexEndpoint, req, settings.GRPC, c.logger, "DeleteIndexEndpoint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteIndexEndpointOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) DeployIndex(ctx context.Context, req *visionaipb.DeployIndexRequest, opts ...gax.CallOption) (*DeployIndexOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint", url.QueryEscape(req.GetIndexEndpoint()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeployIndex[0:len((*c.CallOptions).DeployIndex):len((*c.CallOptions).DeployIndex)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.DeployIndex, req, settings.GRPC, c.logger, "DeployIndex")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeployIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) UndeployIndex(ctx context.Context, req *visionaipb.UndeployIndexRequest, opts ...gax.CallOption) (*UndeployIndexOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint", url.QueryEscape(req.GetIndexEndpoint()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UndeployIndex[0:len((*c.CallOptions).UndeployIndex):len((*c.CallOptions).UndeployIndex)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UndeployIndex, req, settings.GRPC, c.logger, "UndeployIndex")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UndeployIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) CreateCollection(ctx context.Context, req *visionaipb.CreateCollectionRequest, opts ...gax.CallOption) (*CreateCollectionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateCollection[0:len((*c.CallOptions).CreateCollection):len((*c.CallOptions).CreateCollection)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.CreateCollection, req, settings.GRPC, c.logger, "CreateCollection")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateCollectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) DeleteCollection(ctx context.Context, req *visionaipb.DeleteCollectionRequest, opts ...gax.CallOption) (*DeleteCollectionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteCollection[0:len((*c.CallOptions).DeleteCollection):len((*c.CallOptions).DeleteCollection)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.DeleteCollection, req, settings.GRPC, c.logger, "DeleteCollection")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteCollectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *warehouseGRPCClient) GetCollection(ctx context.Context, req *visionaipb.GetCollectionRequest, opts ...gax.CallOption) (*visionaipb.Collection, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetCollection[0:len((*c.CallOptions).GetCollection):len((*c.CallOptions).GetCollection)], opts...)
	var resp *visionaipb.Collection
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.GetCollection, req, settings.GRPC, c.logger, "GetCollection")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) UpdateCollection(ctx context.Context, req *visionaipb.UpdateCollectionRequest, opts ...gax.CallOption) (*visionaipb.Collection, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "collection.name", url.QueryEscape(req.GetCollection().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCollection[0:len((*c.CallOptions).UpdateCollection):len((*c.CallOptions).UpdateCollection)], opts...)
	var resp *visionaipb.Collection
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.UpdateCollection, req, settings.GRPC, c.logger, "UpdateCollection")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListCollections(ctx context.Context, req *visionaipb.ListCollectionsRequest, opts ...gax.CallOption) *CollectionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListCollections[0:len((*c.CallOptions).ListCollections):len((*c.CallOptions).ListCollections)], opts...)
	it := &CollectionIterator{}
	req = proto.Clone(req).(*visionaipb.ListCollectionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Collection, string, error) {
		resp := &visionaipb.ListCollectionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ListCollections, req, settings.GRPC, c.logger, "ListCollections")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCollections(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) AddCollectionItem(ctx context.Context, req *visionaipb.AddCollectionItemRequest, opts ...gax.CallOption) (*visionaipb.AddCollectionItemResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "item.collection", url.QueryEscape(req.GetItem().GetCollection()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AddCollectionItem[0:len((*c.CallOptions).AddCollectionItem):len((*c.CallOptions).AddCollectionItem)], opts...)
	var resp *visionaipb.AddCollectionItemResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.AddCollectionItem, req, settings.GRPC, c.logger, "AddCollectionItem")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) RemoveCollectionItem(ctx context.Context, req *visionaipb.RemoveCollectionItemRequest, opts ...gax.CallOption) (*visionaipb.RemoveCollectionItemResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "item.collection", url.QueryEscape(req.GetItem().GetCollection()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RemoveCollectionItem[0:len((*c.CallOptions).RemoveCollectionItem):len((*c.CallOptions).RemoveCollectionItem)], opts...)
	var resp *visionaipb.RemoveCollectionItemResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.warehouseClient.RemoveCollectionItem, req, settings.GRPC, c.logger, "RemoveCollectionItem")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ViewCollectionItems(ctx context.Context, req *visionaipb.ViewCollectionItemsRequest, opts ...gax.CallOption) *CollectionItemIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "collection", url.QueryEscape(req.GetCollection()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ViewCollectionItems[0:len((*c.CallOptions).ViewCollectionItems):len((*c.CallOptions).ViewCollectionItems)], opts...)
	it := &CollectionItemIterator{}
	req = proto.Clone(req).(*visionaipb.ViewCollectionItemsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.CollectionItem, string, error) {
		resp := &visionaipb.ViewCollectionItemsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.warehouseClient.ViewCollectionItems, req, settings.GRPC, c.logger, "ViewCollectionItems")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetItems(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *warehouseGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *warehouseGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *warehouseGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAsset creates an asset inside corpus.
func (c *warehouseRESTClient) CreateAsset(ctx context.Context, req *visionaipb.CreateAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAsset()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/assets", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req != nil && req.AssetId != nil {
		params.Add("assetId", fmt.Sprintf("%v", req.GetAssetId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateAsset[0:len((*c.CallOptions).CreateAsset):len((*c.CallOptions).CreateAsset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Asset{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateAsset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateAsset updates an asset inside corpus.
func (c *warehouseRESTClient) UpdateAsset(ctx context.Context, req *visionaipb.UpdateAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAsset()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetAsset().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "asset.name", url.QueryEscape(req.GetAsset().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAsset[0:len((*c.CallOptions).UpdateAsset):len((*c.CallOptions).UpdateAsset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Asset{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateAsset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetAsset reads an asset inside corpus.
func (c *warehouseRESTClient) GetAsset(ctx context.Context, req *visionaipb.GetAssetRequest, opts ...gax.CallOption) (*visionaipb.Asset, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAsset[0:len((*c.CallOptions).GetAsset):len((*c.CallOptions).GetAsset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Asset{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAsset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListAssets lists an list of assets inside corpus.
func (c *warehouseRESTClient) ListAssets(ctx context.Context, req *visionaipb.ListAssetsRequest, opts ...gax.CallOption) *AssetIterator {
	it := &AssetIterator{}
	req = proto.Clone(req).(*visionaipb.ListAssetsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Asset, string, error) {
		resp := &visionaipb.ListAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/assets", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAssets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAssets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteAsset deletes asset inside corpus.
func (c *warehouseRESTClient) DeleteAsset(ctx context.Context, req *visionaipb.DeleteAssetRequest, opts ...gax.CallOption) (*DeleteAssetOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteAsset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UploadAsset upload asset by specifing the asset Cloud Storage uri.
// For video warehouse, it requires users who call this API have read access
// to the cloud storage file. Once it is uploaded, it can be retrieved by
// GenerateRetrievalUrl API which by default, only can retrieve cloud storage
// files from the same project of the warehouse. To allow retrieval cloud
// storage files that are in a separate project, it requires to find the
// vision ai service account (Go to IAM, check checkbox to show “Include
// Google-provided role grants”, search for “Cloud Vision AI Service Agent”)
// and grant the read access of the cloud storage files to that service
// account.
func (c *warehouseRESTClient) UploadAsset(ctx context.Context, req *visionaipb.UploadAssetRequest, opts ...gax.CallOption) (*UploadAssetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:upload", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UploadAsset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UploadAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GenerateRetrievalUrl generates a signed url for downloading the asset.
// For video warehouse, please see comment of UploadAsset about how to allow
// retrieval of cloud storage files in a different project.
func (c *warehouseRESTClient) GenerateRetrievalUrl(ctx context.Context, req *visionaipb.GenerateRetrievalUrlRequest, opts ...gax.CallOption) (*visionaipb.GenerateRetrievalUrlResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:generateRetrievalUrl", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GenerateRetrievalUrl[0:len((*c.CallOptions).GenerateRetrievalUrl):len((*c.CallOptions).GenerateRetrievalUrl)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.GenerateRetrievalUrlResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "GenerateRetrievalUrl")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// AnalyzeAsset analyze asset to power search capability.
func (c *warehouseRESTClient) AnalyzeAsset(ctx context.Context, req *visionaipb.AnalyzeAssetRequest, opts ...gax.CallOption) (*AnalyzeAssetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:analyze", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AnalyzeAsset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &AnalyzeAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// IndexAsset index one asset for search.
// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
func (c *warehouseRESTClient) IndexAsset(ctx context.Context, req *visionaipb.IndexAssetRequest, opts ...gax.CallOption) (*IndexAssetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:index", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "IndexAsset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &IndexAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RemoveIndexAsset remove one asset’s index data for search.
// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
func (c *warehouseRESTClient) RemoveIndexAsset(ctx context.Context, req *visionaipb.RemoveIndexAssetRequest, opts ...gax.CallOption) (*RemoveIndexAssetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:removeIndex", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RemoveIndexAsset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RemoveIndexAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ViewIndexedAssets lists assets inside an index.
func (c *warehouseRESTClient) ViewIndexedAssets(ctx context.Context, req *visionaipb.ViewIndexedAssetsRequest, opts ...gax.CallOption) *IndexedAssetIterator {
	it := &IndexedAssetIterator{}
	req = proto.Clone(req).(*visionaipb.ViewIndexedAssetsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.IndexedAsset, string, error) {
		resp := &visionaipb.ViewIndexedAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:viewAssets", req.GetIndex())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ViewIndexedAssets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetIndexedAssets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateIndex creates an Index under the corpus.
func (c *warehouseRESTClient) CreateIndex(ctx context.Context, req *visionaipb.CreateIndexRequest, opts ...gax.CallOption) (*CreateIndexOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetIndex()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/indexes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetIndexId() != "" {
		params.Add("indexId", fmt.Sprintf("%v", req.GetIndexId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateIndex")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateIndex updates an Index under the corpus.
// Users can perform a metadata-only update or trigger a full index rebuild
// with different update_mask values.
func (c *warehouseRESTClient) UpdateIndex(ctx context.Context, req *visionaipb.UpdateIndexRequest, opts ...gax.CallOption) (*UpdateIndexOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetIndex()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetIndex().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index.name", url.QueryEscape(req.GetIndex().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateIndex")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetIndex gets the details of a single Index under a Corpus.
func (c *warehouseRESTClient) GetIndex(ctx context.Context, req *visionaipb.GetIndexRequest, opts ...gax.CallOption) (*visionaipb.Index, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetIndex[0:len((*c.CallOptions).GetIndex):len((*c.CallOptions).GetIndex)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Index{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetIndex")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListIndexes list all Indexes in a given Corpus.
func (c *warehouseRESTClient) ListIndexes(ctx context.Context, req *visionaipb.ListIndexesRequest, opts ...gax.CallOption) *IndexIterator {
	it := &IndexIterator{}
	req = proto.Clone(req).(*visionaipb.ListIndexesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Index, string, error) {
		resp := &visionaipb.ListIndexesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/indexes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListIndexes")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetIndexes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteIndex delete a single Index. In order to delete an index, the caller must
// make sure that it is not deployed to any index endpoint.
func (c *warehouseRESTClient) DeleteIndex(ctx context.Context, req *visionaipb.DeleteIndexRequest, opts ...gax.CallOption) (*DeleteIndexOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteIndex")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateCorpus creates a corpus inside a project.
func (c *warehouseRESTClient) CreateCorpus(ctx context.Context, req *visionaipb.CreateCorpusRequest, opts ...gax.CallOption) (*CreateCorpusOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCorpus()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/corpora", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCorpus")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateCorpusOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetCorpus gets corpus details inside a project.
func (c *warehouseRESTClient) GetCorpus(ctx context.Context, req *visionaipb.GetCorpusRequest, opts ...gax.CallOption) (*visionaipb.Corpus, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCorpus[0:len((*c.CallOptions).GetCorpus):len((*c.CallOptions).GetCorpus)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Corpus{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCorpus")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateCorpus updates a corpus in a project.
func (c *warehouseRESTClient) UpdateCorpus(ctx context.Context, req *visionaipb.UpdateCorpusRequest, opts ...gax.CallOption) (*visionaipb.Corpus, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCorpus()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetCorpus().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "corpus.name", url.QueryEscape(req.GetCorpus().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCorpus[0:len((*c.CallOptions).UpdateCorpus):len((*c.CallOptions).UpdateCorpus)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Corpus{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateCorpus")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListCorpora lists all corpora in a project.
func (c *warehouseRESTClient) ListCorpora(ctx context.Context, req *visionaipb.ListCorporaRequest, opts ...gax.CallOption) *CorpusIterator {
	it := &CorpusIterator{}
	req = proto.Clone(req).(*visionaipb.ListCorporaRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Corpus, string, error) {
		resp := &visionaipb.ListCorporaResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/corpora", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCorpora")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCorpora(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteCorpus deletes a corpus only if its empty.
// Returns empty response.
func (c *warehouseRESTClient) DeleteCorpus(ctx context.Context, req *visionaipb.DeleteCorpusRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteCorpus")
		return err
	}, opts...)
}

// AnalyzeCorpus analyzes a corpus.
func (c *warehouseRESTClient) AnalyzeCorpus(ctx context.Context, req *visionaipb.AnalyzeCorpusRequest, opts ...gax.CallOption) (*AnalyzeCorpusOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:analyze", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AnalyzeCorpus")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &AnalyzeCorpusOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateDataSchema creates data schema inside corpus.
func (c *warehouseRESTClient) CreateDataSchema(ctx context.Context, req *visionaipb.CreateDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDataSchema()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/dataSchemas", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateDataSchema[0:len((*c.CallOptions).CreateDataSchema):len((*c.CallOptions).CreateDataSchema)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.DataSchema{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateDataSchema")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateDataSchema updates data schema inside corpus.
func (c *warehouseRESTClient) UpdateDataSchema(ctx context.Context, req *visionaipb.UpdateDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDataSchema()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetDataSchema().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "data_schema.name", url.QueryEscape(req.GetDataSchema().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDataSchema[0:len((*c.CallOptions).UpdateDataSchema):len((*c.CallOptions).UpdateDataSchema)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.DataSchema{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateDataSchema")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetDataSchema gets data schema inside corpus.
func (c *warehouseRESTClient) GetDataSchema(ctx context.Context, req *visionaipb.GetDataSchemaRequest, opts ...gax.CallOption) (*visionaipb.DataSchema, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDataSchema[0:len((*c.CallOptions).GetDataSchema):len((*c.CallOptions).GetDataSchema)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.DataSchema{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetDataSchema")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteDataSchema deletes data schema inside corpus.
func (c *warehouseRESTClient) DeleteDataSchema(ctx context.Context, req *visionaipb.DeleteDataSchemaRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteDataSchema")
		return err
	}, opts...)
}

// ListDataSchemas lists a list of data schemas inside corpus.
func (c *warehouseRESTClient) ListDataSchemas(ctx context.Context, req *visionaipb.ListDataSchemasRequest, opts ...gax.CallOption) *DataSchemaIterator {
	it := &DataSchemaIterator{}
	req = proto.Clone(req).(*visionaipb.ListDataSchemasRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.DataSchema, string, error) {
		resp := &visionaipb.ListDataSchemasResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/dataSchemas", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDataSchemas")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDataSchemas(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAnnotation creates annotation inside asset.
func (c *warehouseRESTClient) CreateAnnotation(ctx context.Context, req *visionaipb.CreateAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAnnotation()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/annotations", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req != nil && req.AnnotationId != nil {
		params.Add("annotationId", fmt.Sprintf("%v", req.GetAnnotationId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateAnnotation[0:len((*c.CallOptions).CreateAnnotation):len((*c.CallOptions).CreateAnnotation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Annotation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateAnnotation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetAnnotation reads annotation inside asset.
func (c *warehouseRESTClient) GetAnnotation(ctx context.Context, req *visionaipb.GetAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAnnotation[0:len((*c.CallOptions).GetAnnotation):len((*c.CallOptions).GetAnnotation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Annotation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAnnotation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListAnnotations lists a list of annotations inside asset.
func (c *warehouseRESTClient) ListAnnotations(ctx context.Context, req *visionaipb.ListAnnotationsRequest, opts ...gax.CallOption) *AnnotationIterator {
	it := &AnnotationIterator{}
	req = proto.Clone(req).(*visionaipb.ListAnnotationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Annotation, string, error) {
		resp := &visionaipb.ListAnnotationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/annotations", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAnnotations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAnnotations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateAnnotation updates annotation inside asset.
func (c *warehouseRESTClient) UpdateAnnotation(ctx context.Context, req *visionaipb.UpdateAnnotationRequest, opts ...gax.CallOption) (*visionaipb.Annotation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAnnotation()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetAnnotation().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "annotation.name", url.QueryEscape(req.GetAnnotation().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAnnotation[0:len((*c.CallOptions).UpdateAnnotation):len((*c.CallOptions).UpdateAnnotation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Annotation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateAnnotation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteAnnotation deletes annotation inside asset.
func (c *warehouseRESTClient) DeleteAnnotation(ctx context.Context, req *visionaipb.DeleteAnnotationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteAnnotation")
		return err
	}, opts...)
}

// IngestAsset ingests data for the asset. It is not allowed to ingest a data chunk which
// is already expired according to TTL.
// This method is only available via the gRPC API (not HTTP since
// bi-directional streaming is not supported via HTTP).
//
// This method is not supported for the REST transport.
func (c *warehouseRESTClient) IngestAsset(ctx context.Context, opts ...gax.CallOption) (visionaipb.Warehouse_IngestAssetClient, error) {
	return nil, errors.New("IngestAsset not yet supported for REST clients")
}

// ClipAsset supported by STREAM_VIDEO corpus type.
// Generates clips for downloading. The api takes in a time range, and
// generates a clip of the first content available after start_time and
// before end_time, which may overflow beyond these bounds.
// Returned clips are truncated if the total size of the clips are larger
// than 100MB.
func (c *warehouseRESTClient) ClipAsset(ctx context.Context, req *visionaipb.ClipAssetRequest, opts ...gax.CallOption) (*visionaipb.ClipAssetResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:clip", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ClipAsset[0:len((*c.CallOptions).ClipAsset):len((*c.CallOptions).ClipAsset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.ClipAssetResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ClipAsset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GenerateHlsUri generates a uri for an HLS manifest. The api takes in a collection of time
// ranges, and generates a URI for an HLS manifest that covers all the
// requested time ranges.
func (c *warehouseRESTClient) GenerateHlsUri(ctx context.Context, req *visionaipb.GenerateHlsUriRequest, opts ...gax.CallOption) (*visionaipb.GenerateHlsUriResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:generateHlsUri", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GenerateHlsUri[0:len((*c.CallOptions).GenerateHlsUri):len((*c.CallOptions).GenerateHlsUri)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.GenerateHlsUriResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "GenerateHlsUri")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ImportAssets imports assets (images plus annotations) from a meta file on cloud storage.
// Each row in the meta file is corresponding to an image (specified by a
// cloud storage uri) and its annotations.
func (c *warehouseRESTClient) ImportAssets(ctx context.Context, req *visionaipb.ImportAssetsRequest, opts ...gax.CallOption) (*ImportAssetsOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/assets:import", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ImportAssets")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ImportAssetsOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateSearchConfig creates a search configuration inside a corpus.
//
// Please follow the rules below to create a valid CreateSearchConfigRequest.
// — General Rules —
//
// Request.search_config_id must not be associated with an existing
// SearchConfig.
//
// Request must contain at least one non-empty search_criteria_property or
// facet_property.
//
// mapped_fields must not be empty, and must map to existing UGA keys.
//
// All mapped_fields must be of the same type.
//
// All mapped_fields must share the same granularity.
//
// All mapped_fields must share the same semantic SearchConfig match
// options.
// For property-specific rules, please reference the comments for
// FacetProperty and SearchCriteriaProperty.
func (c *warehouseRESTClient) CreateSearchConfig(ctx context.Context, req *visionaipb.CreateSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSearchConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/searchConfigs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("searchConfigId", fmt.Sprintf("%v", req.GetSearchConfigId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateSearchConfig[0:len((*c.CallOptions).CreateSearchConfig):len((*c.CallOptions).CreateSearchConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.SearchConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateSearchConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateSearchConfig updates a search configuration inside a corpus.
//
// Please follow the rules below to create a valid UpdateSearchConfigRequest.
// — General Rules —
//
// Request.search_configuration.name must already exist.
//
// Request must contain at least one non-empty search_criteria_property or
// facet_property.
//
// mapped_fields must not be empty, and must map to existing UGA keys.
//
// All mapped_fields must be of the same type.
//
// All mapped_fields must share the same granularity.
//
// All mapped_fields must share the same semantic SearchConfig match
// options.
// For property-specific rules, please reference the comments for
// FacetProperty and SearchCriteriaProperty.
func (c *warehouseRESTClient) UpdateSearchConfig(ctx context.Context, req *visionaipb.UpdateSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSearchConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSearchConfig().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "search_config.name", url.QueryEscape(req.GetSearchConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSearchConfig[0:len((*c.CallOptions).UpdateSearchConfig):len((*c.CallOptions).UpdateSearchConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.SearchConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateSearchConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetSearchConfig gets a search configuration inside a corpus.
func (c *warehouseRESTClient) GetSearchConfig(ctx context.Context, req *visionaipb.GetSearchConfigRequest, opts ...gax.CallOption) (*visionaipb.SearchConfig, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSearchConfig[0:len((*c.CallOptions).GetSearchConfig):len((*c.CallOptions).GetSearchConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.SearchConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSearchConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteSearchConfig deletes a search configuration inside a corpus.
//
// For a DeleteSearchConfigRequest to be valid,
// Request.search_configuration.name must already exist.
func (c *warehouseRESTClient) DeleteSearchConfig(ctx context.Context, req *visionaipb.DeleteSearchConfigRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteSearchConfig")
		return err
	}, opts...)
}

// ListSearchConfigs lists all search configurations inside a corpus.
func (c *warehouseRESTClient) ListSearchConfigs(ctx context.Context, req *visionaipb.ListSearchConfigsRequest, opts ...gax.CallOption) *SearchConfigIterator {
	it := &SearchConfigIterator{}
	req = proto.Clone(req).(*visionaipb.ListSearchConfigsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchConfig, string, error) {
		resp := &visionaipb.ListSearchConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/searchConfigs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListSearchConfigs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSearchConfigs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateSearchHypernym creates a SearchHypernym inside a corpus.
func (c *warehouseRESTClient) CreateSearchHypernym(ctx context.Context, req *visionaipb.CreateSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSearchHypernym()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/searchHypernyms", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req != nil && req.SearchHypernymId != nil {
		params.Add("searchHypernymId", fmt.Sprintf("%v", req.GetSearchHypernymId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateSearchHypernym[0:len((*c.CallOptions).CreateSearchHypernym):len((*c.CallOptions).CreateSearchHypernym)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.SearchHypernym{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateSearchHypernym")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateSearchHypernym updates a SearchHypernym inside a corpus.
func (c *warehouseRESTClient) UpdateSearchHypernym(ctx context.Context, req *visionaipb.UpdateSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSearchHypernym()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSearchHypernym().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "search_hypernym.name", url.QueryEscape(req.GetSearchHypernym().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSearchHypernym[0:len((*c.CallOptions).UpdateSearchHypernym):len((*c.CallOptions).UpdateSearchHypernym)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.SearchHypernym{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateSearchHypernym")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetSearchHypernym gets a SearchHypernym inside a corpus.
func (c *warehouseRESTClient) GetSearchHypernym(ctx context.Context, req *visionaipb.GetSearchHypernymRequest, opts ...gax.CallOption) (*visionaipb.SearchHypernym, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSearchHypernym[0:len((*c.CallOptions).GetSearchHypernym):len((*c.CallOptions).GetSearchHypernym)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.SearchHypernym{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSearchHypernym")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteSearchHypernym deletes a SearchHypernym inside a corpus.
func (c *warehouseRESTClient) DeleteSearchHypernym(ctx context.Context, req *visionaipb.DeleteSearchHypernymRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteSearchHypernym")
		return err
	}, opts...)
}

// ListSearchHypernyms lists SearchHypernyms inside a corpus.
func (c *warehouseRESTClient) ListSearchHypernyms(ctx context.Context, req *visionaipb.ListSearchHypernymsRequest, opts ...gax.CallOption) *SearchHypernymIterator {
	it := &SearchHypernymIterator{}
	req = proto.Clone(req).(*visionaipb.ListSearchHypernymsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchHypernym, string, error) {
		resp := &visionaipb.ListSearchHypernymsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/searchHypernyms", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListSearchHypernyms")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSearchHypernyms(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchAssets search media asset.
func (c *warehouseRESTClient) SearchAssets(ctx context.Context, req *visionaipb.SearchAssetsRequest, opts ...gax.CallOption) *SearchResultItemIterator {
	it := &SearchResultItemIterator{}
	req = proto.Clone(req).(*visionaipb.SearchAssetsRequest)
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchResultItem, string, error) {
		resp := &visionaipb.SearchAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		jsonReq, err := m.Marshal(req)
		if err != nil {
			return nil, "", err
		}

		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:searchAssets", req.GetCorpus())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SearchAssets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSearchResultItems(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchIndexEndpoint search a deployed index endpoint (IMAGE corpus type only).
func (c *warehouseRESTClient) SearchIndexEndpoint(ctx context.Context, req *visionaipb.SearchIndexEndpointRequest, opts ...gax.CallOption) *SearchResultItemIterator {
	it := &SearchResultItemIterator{}
	req = proto.Clone(req).(*visionaipb.SearchIndexEndpointRequest)
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.SearchResultItem, string, error) {
		resp := &visionaipb.SearchIndexEndpointResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		jsonReq, err := m.Marshal(req)
		if err != nil {
			return nil, "", err
		}

		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:searchIndexEndpoint", req.GetIndexEndpoint())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SearchIndexEndpoint")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSearchResultItems(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateIndexEndpoint creates an IndexEndpoint.
func (c *warehouseRESTClient) CreateIndexEndpoint(ctx context.Context, req *visionaipb.CreateIndexEndpointRequest, opts ...gax.CallOption) (*CreateIndexEndpointOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetIndexEndpoint()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/indexEndpoints", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetIndexEndpointId() != "" {
		params.Add("indexEndpointId", fmt.Sprintf("%v", req.GetIndexEndpointId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateIndexEndpoint")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateIndexEndpointOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetIndexEndpoint gets an IndexEndpoint.
func (c *warehouseRESTClient) GetIndexEndpoint(ctx context.Context, req *visionaipb.GetIndexEndpointRequest, opts ...gax.CallOption) (*visionaipb.IndexEndpoint, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetIndexEndpoint[0:len((*c.CallOptions).GetIndexEndpoint):len((*c.CallOptions).GetIndexEndpoint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.IndexEndpoint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetIndexEndpoint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListIndexEndpoints lists all IndexEndpoints in a project.
func (c *warehouseRESTClient) ListIndexEndpoints(ctx context.Context, req *visionaipb.ListIndexEndpointsRequest, opts ...gax.CallOption) *IndexEndpointIterator {
	it := &IndexEndpointIterator{}
	req = proto.Clone(req).(*visionaipb.ListIndexEndpointsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.IndexEndpoint, string, error) {
		resp := &visionaipb.ListIndexEndpointsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/indexEndpoints", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListIndexEndpoints")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetIndexEndpoints(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateIndexEndpoint updates an IndexEndpoint.
func (c *warehouseRESTClient) UpdateIndexEndpoint(ctx context.Context, req *visionaipb.UpdateIndexEndpointRequest, opts ...gax.CallOption) (*UpdateIndexEndpointOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetIndexEndpoint()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetIndexEndpoint().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint.name", url.QueryEscape(req.GetIndexEndpoint().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateIndexEndpoint")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateIndexEndpointOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteIndexEndpoint deletes an IndexEndpoint.
func (c *warehouseRESTClient) DeleteIndexEndpoint(ctx context.Context, req *visionaipb.DeleteIndexEndpointRequest, opts ...gax.CallOption) (*DeleteIndexEndpointOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteIndexEndpoint")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteIndexEndpointOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeployIndex deploys an Index to IndexEndpoint.
func (c *warehouseRESTClient) DeployIndex(ctx context.Context, req *visionaipb.DeployIndexRequest, opts ...gax.CallOption) (*DeployIndexOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:deployIndex", req.GetIndexEndpoint())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint", url.QueryEscape(req.GetIndexEndpoint()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "DeployIndex")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeployIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UndeployIndex undeploys an Index from IndexEndpoint.
func (c *warehouseRESTClient) UndeployIndex(ctx context.Context, req *visionaipb.UndeployIndexRequest, opts ...gax.CallOption) (*UndeployIndexOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:undeployIndex", req.GetIndexEndpoint())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "index_endpoint", url.QueryEscape(req.GetIndexEndpoint()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UndeployIndex")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UndeployIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateCollection creates a collection.
func (c *warehouseRESTClient) CreateCollection(ctx context.Context, req *visionaipb.CreateCollectionRequest, opts ...gax.CallOption) (*CreateCollectionOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCollection()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/collections", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req != nil && req.CollectionId != nil {
		params.Add("collectionId", fmt.Sprintf("%v", req.GetCollectionId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCollection")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateCollectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteCollection deletes a collection.
func (c *warehouseRESTClient) DeleteCollection(ctx context.Context, req *visionaipb.DeleteCollectionRequest, opts ...gax.CallOption) (*DeleteCollectionOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteCollection")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteCollectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetCollection gets a collection.
func (c *warehouseRESTClient) GetCollection(ctx context.Context, req *visionaipb.GetCollectionRequest, opts ...gax.CallOption) (*visionaipb.Collection, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCollection[0:len((*c.CallOptions).GetCollection):len((*c.CallOptions).GetCollection)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Collection{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCollection")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateCollection updates a collection.
func (c *warehouseRESTClient) UpdateCollection(ctx context.Context, req *visionaipb.UpdateCollectionRequest, opts ...gax.CallOption) (*visionaipb.Collection, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCollection()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetCollection().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "collection.name", url.QueryEscape(req.GetCollection().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCollection[0:len((*c.CallOptions).UpdateCollection):len((*c.CallOptions).UpdateCollection)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.Collection{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateCollection")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListCollections lists collections inside a corpus.
func (c *warehouseRESTClient) ListCollections(ctx context.Context, req *visionaipb.ListCollectionsRequest, opts ...gax.CallOption) *CollectionIterator {
	it := &CollectionIterator{}
	req = proto.Clone(req).(*visionaipb.ListCollectionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.Collection, string, error) {
		resp := &visionaipb.ListCollectionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/collections", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCollections")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCollections(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// AddCollectionItem adds an item into a Collection.
func (c *warehouseRESTClient) AddCollectionItem(ctx context.Context, req *visionaipb.AddCollectionItemRequest, opts ...gax.CallOption) (*visionaipb.AddCollectionItemResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:addCollectionItem", req.GetItem().GetCollection())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "item.collection", url.QueryEscape(req.GetItem().GetCollection()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).AddCollectionItem[0:len((*c.CallOptions).AddCollectionItem):len((*c.CallOptions).AddCollectionItem)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.AddCollectionItemResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AddCollectionItem")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RemoveCollectionItem removes an item from a collection.
func (c *warehouseRESTClient) RemoveCollectionItem(ctx context.Context, req *visionaipb.RemoveCollectionItemRequest, opts ...gax.CallOption) (*visionaipb.RemoveCollectionItemResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:removeCollectionItem", req.GetItem().GetCollection())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "item.collection", url.QueryEscape(req.GetItem().GetCollection()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RemoveCollectionItem[0:len((*c.CallOptions).RemoveCollectionItem):len((*c.CallOptions).RemoveCollectionItem)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &visionaipb.RemoveCollectionItemResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RemoveCollectionItem")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ViewCollectionItems view items inside a collection.
func (c *warehouseRESTClient) ViewCollectionItems(ctx context.Context, req *visionaipb.ViewCollectionItemsRequest, opts ...gax.CallOption) *CollectionItemIterator {
	it := &CollectionItemIterator{}
	req = proto.Clone(req).(*visionaipb.ViewCollectionItemsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*visionaipb.CollectionItem, string, error) {
		resp := &visionaipb.ViewCollectionItemsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:viewCollectionItems", req.GetCollection())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ViewCollectionItems")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetItems(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *warehouseRESTClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *warehouseRESTClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *warehouseRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *warehouseRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// AnalyzeAssetOperation returns a new AnalyzeAssetOperation from a given name.
// The name must be that of a previously created AnalyzeAssetOperation, possibly from a different process.
func (c *warehouseGRPCClient) AnalyzeAssetOperation(name string) *AnalyzeAssetOperation {
	return &AnalyzeAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AnalyzeAssetOperation returns a new AnalyzeAssetOperation from a given name.
// The name must be that of a previously created AnalyzeAssetOperation, possibly from a different process.
func (c *warehouseRESTClient) AnalyzeAssetOperation(name string) *AnalyzeAssetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &AnalyzeAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// AnalyzeCorpusOperation returns a new AnalyzeCorpusOperation from a given name.
// The name must be that of a previously created AnalyzeCorpusOperation, possibly from a different process.
func (c *warehouseGRPCClient) AnalyzeCorpusOperation(name string) *AnalyzeCorpusOperation {
	return &AnalyzeCorpusOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AnalyzeCorpusOperation returns a new AnalyzeCorpusOperation from a given name.
// The name must be that of a previously created AnalyzeCorpusOperation, possibly from a different process.
func (c *warehouseRESTClient) AnalyzeCorpusOperation(name string) *AnalyzeCorpusOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &AnalyzeCorpusOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateCollectionOperation returns a new CreateCollectionOperation from a given name.
// The name must be that of a previously created CreateCollectionOperation, possibly from a different process.
func (c *warehouseGRPCClient) CreateCollectionOperation(name string) *CreateCollectionOperation {
	return &CreateCollectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateCollectionOperation returns a new CreateCollectionOperation from a given name.
// The name must be that of a previously created CreateCollectionOperation, possibly from a different process.
func (c *warehouseRESTClient) CreateCollectionOperation(name string) *CreateCollectionOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateCollectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateCorpusOperation returns a new CreateCorpusOperation from a given name.
// The name must be that of a previously created CreateCorpusOperation, possibly from a different process.
func (c *warehouseGRPCClient) CreateCorpusOperation(name string) *CreateCorpusOperation {
	return &CreateCorpusOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateCorpusOperation returns a new CreateCorpusOperation from a given name.
// The name must be that of a previously created CreateCorpusOperation, possibly from a different process.
func (c *warehouseRESTClient) CreateCorpusOperation(name string) *CreateCorpusOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateCorpusOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateIndexOperation returns a new CreateIndexOperation from a given name.
// The name must be that of a previously created CreateIndexOperation, possibly from a different process.
func (c *warehouseGRPCClient) CreateIndexOperation(name string) *CreateIndexOperation {
	return &CreateIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateIndexOperation returns a new CreateIndexOperation from a given name.
// The name must be that of a previously created CreateIndexOperation, possibly from a different process.
func (c *warehouseRESTClient) CreateIndexOperation(name string) *CreateIndexOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateIndexEndpointOperation returns a new CreateIndexEndpointOperation from a given name.
// The name must be that of a previously created CreateIndexEndpointOperation, possibly from a different process.
func (c *warehouseGRPCClient) CreateIndexEndpointOperation(name string) *CreateIndexEndpointOperation {
	return &CreateIndexEndpointOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateIndexEndpointOperation returns a new CreateIndexEndpointOperation from a given name.
// The name must be that of a previously created CreateIndexEndpointOperation, possibly from a different process.
func (c *warehouseRESTClient) CreateIndexEndpointOperation(name string) *CreateIndexEndpointOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateIndexEndpointOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteAssetOperation returns a new DeleteAssetOperation from a given name.
// The name must be that of a previously created DeleteAssetOperation, possibly from a different process.
func (c *warehouseGRPCClient) DeleteAssetOperation(name string) *DeleteAssetOperation {
	return &DeleteAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAssetOperation returns a new DeleteAssetOperation from a given name.
// The name must be that of a previously created DeleteAssetOperation, possibly from a different process.
func (c *warehouseRESTClient) DeleteAssetOperation(name string) *DeleteAssetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteCollectionOperation returns a new DeleteCollectionOperation from a given name.
// The name must be that of a previously created DeleteCollectionOperation, possibly from a different process.
func (c *warehouseGRPCClient) DeleteCollectionOperation(name string) *DeleteCollectionOperation {
	return &DeleteCollectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteCollectionOperation returns a new DeleteCollectionOperation from a given name.
// The name must be that of a previously created DeleteCollectionOperation, possibly from a different process.
func (c *warehouseRESTClient) DeleteCollectionOperation(name string) *DeleteCollectionOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteCollectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteIndexOperation returns a new DeleteIndexOperation from a given name.
// The name must be that of a previously created DeleteIndexOperation, possibly from a different process.
func (c *warehouseGRPCClient) DeleteIndexOperation(name string) *DeleteIndexOperation {
	return &DeleteIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteIndexOperation returns a new DeleteIndexOperation from a given name.
// The name must be that of a previously created DeleteIndexOperation, possibly from a different process.
func (c *warehouseRESTClient) DeleteIndexOperation(name string) *DeleteIndexOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteIndexEndpointOperation returns a new DeleteIndexEndpointOperation from a given name.
// The name must be that of a previously created DeleteIndexEndpointOperation, possibly from a different process.
func (c *warehouseGRPCClient) DeleteIndexEndpointOperation(name string) *DeleteIndexEndpointOperation {
	return &DeleteIndexEndpointOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteIndexEndpointOperation returns a new DeleteIndexEndpointOperation from a given name.
// The name must be that of a previously created DeleteIndexEndpointOperation, possibly from a different process.
func (c *warehouseRESTClient) DeleteIndexEndpointOperation(name string) *DeleteIndexEndpointOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteIndexEndpointOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeployIndexOperation returns a new DeployIndexOperation from a given name.
// The name must be that of a previously created DeployIndexOperation, possibly from a different process.
func (c *warehouseGRPCClient) DeployIndexOperation(name string) *DeployIndexOperation {
	return &DeployIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeployIndexOperation returns a new DeployIndexOperation from a given name.
// The name must be that of a previously created DeployIndexOperation, possibly from a different process.
func (c *warehouseRESTClient) DeployIndexOperation(name string) *DeployIndexOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeployIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ImportAssetsOperation returns a new ImportAssetsOperation from a given name.
// The name must be that of a previously created ImportAssetsOperation, possibly from a different process.
func (c *warehouseGRPCClient) ImportAssetsOperation(name string) *ImportAssetsOperation {
	return &ImportAssetsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ImportAssetsOperation returns a new ImportAssetsOperation from a given name.
// The name must be that of a previously created ImportAssetsOperation, possibly from a different process.
func (c *warehouseRESTClient) ImportAssetsOperation(name string) *ImportAssetsOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ImportAssetsOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// IndexAssetOperation returns a new IndexAssetOperation from a given name.
// The name must be that of a previously created IndexAssetOperation, possibly from a different process.
func (c *warehouseGRPCClient) IndexAssetOperation(name string) *IndexAssetOperation {
	return &IndexAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// IndexAssetOperation returns a new IndexAssetOperation from a given name.
// The name must be that of a previously created IndexAssetOperation, possibly from a different process.
func (c *warehouseRESTClient) IndexAssetOperation(name string) *IndexAssetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &IndexAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RemoveIndexAssetOperation returns a new RemoveIndexAssetOperation from a given name.
// The name must be that of a previously created RemoveIndexAssetOperation, possibly from a different process.
func (c *warehouseGRPCClient) RemoveIndexAssetOperation(name string) *RemoveIndexAssetOperation {
	return &RemoveIndexAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RemoveIndexAssetOperation returns a new RemoveIndexAssetOperation from a given name.
// The name must be that of a previously created RemoveIndexAssetOperation, possibly from a different process.
func (c *warehouseRESTClient) RemoveIndexAssetOperation(name string) *RemoveIndexAssetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RemoveIndexAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UndeployIndexOperation returns a new UndeployIndexOperation from a given name.
// The name must be that of a previously created UndeployIndexOperation, possibly from a different process.
func (c *warehouseGRPCClient) UndeployIndexOperation(name string) *UndeployIndexOperation {
	return &UndeployIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UndeployIndexOperation returns a new UndeployIndexOperation from a given name.
// The name must be that of a previously created UndeployIndexOperation, possibly from a different process.
func (c *warehouseRESTClient) UndeployIndexOperation(name string) *UndeployIndexOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UndeployIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateIndexOperation returns a new UpdateIndexOperation from a given name.
// The name must be that of a previously created UpdateIndexOperation, possibly from a different process.
func (c *warehouseGRPCClient) UpdateIndexOperation(name string) *UpdateIndexOperation {
	return &UpdateIndexOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateIndexOperation returns a new UpdateIndexOperation from a given name.
// The name must be that of a previously created UpdateIndexOperation, possibly from a different process.
func (c *warehouseRESTClient) UpdateIndexOperation(name string) *UpdateIndexOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateIndexOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateIndexEndpointOperation returns a new UpdateIndexEndpointOperation from a given name.
// The name must be that of a previously created UpdateIndexEndpointOperation, possibly from a different process.
func (c *warehouseGRPCClient) UpdateIndexEndpointOperation(name string) *UpdateIndexEndpointOperation {
	return &UpdateIndexEndpointOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateIndexEndpointOperation returns a new UpdateIndexEndpointOperation from a given name.
// The name must be that of a previously created UpdateIndexEndpointOperation, possibly from a different process.
func (c *warehouseRESTClient) UpdateIndexEndpointOperation(name string) *UpdateIndexEndpointOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateIndexEndpointOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UploadAssetOperation returns a new UploadAssetOperation from a given name.
// The name must be that of a previously created UploadAssetOperation, possibly from a different process.
func (c *warehouseGRPCClient) UploadAssetOperation(name string) *UploadAssetOperation {
	return &UploadAssetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UploadAssetOperation returns a new UploadAssetOperation from a given name.
// The name must be that of a previously created UploadAssetOperation, possibly from a different process.
func (c *warehouseRESTClient) UploadAssetOperation(name string) *UploadAssetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UploadAssetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
