// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/datasources/v1beta/fileuploads.proto

package datasourcespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The processing state of the data source.
type FileUpload_ProcessingState int32

const (
	// Processing state unspecified.
	FileUpload_PROCESSING_STATE_UNSPECIFIED FileUpload_ProcessingState = 0
	// The data source could not be processed or all the items had errors.
	FileUpload_FAILED FileUpload_ProcessingState = 1
	// The data source is being processed.
	FileUpload_IN_PROGRESS FileUpload_ProcessingState = 2
	// The data source was processed successfully, though some items might have
	// had errors.
	FileUpload_SUCCEEDED FileUpload_ProcessingState = 3
)

// Enum value maps for FileUpload_ProcessingState.
var (
	FileUpload_ProcessingState_name = map[int32]string{
		0: "PROCESSING_STATE_UNSPECIFIED",
		1: "FAILED",
		2: "IN_PROGRESS",
		3: "SUCCEEDED",
	}
	FileUpload_ProcessingState_value = map[string]int32{
		"PROCESSING_STATE_UNSPECIFIED": 0,
		"FAILED":                       1,
		"IN_PROGRESS":                  2,
		"SUCCEEDED":                    3,
	}
)

func (x FileUpload_ProcessingState) Enum() *FileUpload_ProcessingState {
	p := new(FileUpload_ProcessingState)
	*p = x
	return p
}

func (x FileUpload_ProcessingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileUpload_ProcessingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_enumTypes[0].Descriptor()
}

func (FileUpload_ProcessingState) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_enumTypes[0]
}

func (x FileUpload_ProcessingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileUpload_ProcessingState.Descriptor instead.
func (FileUpload_ProcessingState) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescGZIP(), []int{0, 0}
}

// The severity of the issue.
type FileUpload_Issue_Severity int32

const (
	// Severity unspecified.
	FileUpload_Issue_SEVERITY_UNSPECIFIED FileUpload_Issue_Severity = 0
	// The issue is the warning.
	FileUpload_Issue_WARNING FileUpload_Issue_Severity = 1
	// The issue is an error.
	FileUpload_Issue_ERROR FileUpload_Issue_Severity = 2
)

// Enum value maps for FileUpload_Issue_Severity.
var (
	FileUpload_Issue_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "WARNING",
		2: "ERROR",
	}
	FileUpload_Issue_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"WARNING":              1,
		"ERROR":                2,
	}
)

func (x FileUpload_Issue_Severity) Enum() *FileUpload_Issue_Severity {
	p := new(FileUpload_Issue_Severity)
	*p = x
	return p
}

func (x FileUpload_Issue_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileUpload_Issue_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_enumTypes[1].Descriptor()
}

func (FileUpload_Issue_Severity) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_enumTypes[1]
}

func (x FileUpload_Issue_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileUpload_Issue_Severity.Descriptor instead.
func (FileUpload_Issue_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The file upload of a specific data source, that is, the result of the
// retrieval of the data source at a certain timestamp computed asynchronously
// when the data source processing is finished. Only applicable to file data
// sources.
type FileUpload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the data source file upload.
	// Format:
	// `{datasource.name=accounts/{account}/dataSources/{datasource}/fileUploads/{fileupload}}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The data source id.
	DataSourceId int64 `protobuf:"varint,2,opt,name=data_source_id,json=dataSourceId,proto3" json:"data_source_id,omitempty"`
	// Output only. The processing state of the data source.
	ProcessingState FileUpload_ProcessingState `protobuf:"varint,3,opt,name=processing_state,json=processingState,proto3,enum=google.shopping.merchant.datasources.v1beta.FileUpload_ProcessingState" json:"processing_state,omitempty"`
	// Output only. The list of issues occurring in the data source.
	Issues []*FileUpload_Issue `protobuf:"bytes,4,rep,name=issues,proto3" json:"issues,omitempty"`
	// Output only. The number of items in the data source that were processed.
	ItemsTotal int64 `protobuf:"varint,5,opt,name=items_total,json=itemsTotal,proto3" json:"items_total,omitempty"`
	// Output only. The number of items in the data source that were created.
	ItemsCreated int64 `protobuf:"varint,6,opt,name=items_created,json=itemsCreated,proto3" json:"items_created,omitempty"`
	// Output only. The number of items in the data source that were updated.
	ItemsUpdated int64 `protobuf:"varint,7,opt,name=items_updated,json=itemsUpdated,proto3" json:"items_updated,omitempty"`
	// Output only. The date at which the file of the data source was uploaded.
	UploadTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=upload_time,json=uploadTime,proto3" json:"upload_time,omitempty"`
}

func (x *FileUpload) Reset() {
	*x = FileUpload{}
	mi := &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileUpload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileUpload) ProtoMessage() {}

func (x *FileUpload) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileUpload.ProtoReflect.Descriptor instead.
func (*FileUpload) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescGZIP(), []int{0}
}

func (x *FileUpload) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileUpload) GetDataSourceId() int64 {
	if x != nil {
		return x.DataSourceId
	}
	return 0
}

func (x *FileUpload) GetProcessingState() FileUpload_ProcessingState {
	if x != nil {
		return x.ProcessingState
	}
	return FileUpload_PROCESSING_STATE_UNSPECIFIED
}

func (x *FileUpload) GetIssues() []*FileUpload_Issue {
	if x != nil {
		return x.Issues
	}
	return nil
}

func (x *FileUpload) GetItemsTotal() int64 {
	if x != nil {
		return x.ItemsTotal
	}
	return 0
}

func (x *FileUpload) GetItemsCreated() int64 {
	if x != nil {
		return x.ItemsCreated
	}
	return 0
}

func (x *FileUpload) GetItemsUpdated() int64 {
	if x != nil {
		return x.ItemsUpdated
	}
	return 0
}

func (x *FileUpload) GetUploadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UploadTime
	}
	return nil
}

// Request message for the GetFileUploadRequest method.
type GetFileUploadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the data source file upload to retrieve.
	// Format:
	// `accounts/{account}/dataSources/{datasource}/fileUploads/latest`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFileUploadRequest) Reset() {
	*x = GetFileUploadRequest{}
	mi := &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFileUploadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileUploadRequest) ProtoMessage() {}

func (x *GetFileUploadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFileUploadRequest.ProtoReflect.Descriptor instead.
func (*GetFileUploadRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescGZIP(), []int{1}
}

func (x *GetFileUploadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An error occurring in the data source, like "invalid price".
type FileUpload_Issue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The title of the issue, for example, "Item too big".
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. The error description, for example, "Your data source
	// contains items which have too many attributes, or are too big. These
	// items will be dropped".
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The code of the error, for example,
	// "validation/invalid_value". Returns
	// "?" if the code is unknown.
	Code string `protobuf:"bytes,3,opt,name=code,proto3" json:"code,omitempty"`
	// Output only. The number of occurrences of the error in the file upload.
	Count int64 `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
	// Output only. The severity of the issue.
	Severity FileUpload_Issue_Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=google.shopping.merchant.datasources.v1beta.FileUpload_Issue_Severity" json:"severity,omitempty"`
	// Output only. Link to the documentation explaining the issue in more
	// details, if available.
	DocumentationUri string `protobuf:"bytes,6,opt,name=documentation_uri,json=documentationUri,proto3" json:"documentation_uri,omitempty"`
}

func (x *FileUpload_Issue) Reset() {
	*x = FileUpload_Issue{}
	mi := &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileUpload_Issue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileUpload_Issue) ProtoMessage() {}

func (x *FileUpload_Issue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileUpload_Issue.ProtoReflect.Descriptor instead.
func (*FileUpload_Issue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FileUpload_Issue) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *FileUpload_Issue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FileUpload_Issue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *FileUpload_Issue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *FileUpload_Issue) GetSeverity() FileUpload_Issue_Severity {
	if x != nil {
		return x.Severity
	}
	return FileUpload_Issue_SEVERITY_UNSPECIFIED
}

func (x *FileUpload_Issue) GetDocumentationUri() string {
	if x != nil {
		return x.DocumentationUri
	}
	return ""
}

var File_google_shopping_merchant_datasources_v1beta_fileuploads_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x66, 0x69,
	0x6c, 0x65, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xa8, 0x08, 0x0a, 0x0a, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x77, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x65,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5a, 0x0a, 0x06,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x28,
	0x0a, 0x0d, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0xd6, 0x02, 0x0a, 0x05, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x30, 0x0a,
	0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x22,
	0x3c, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53,
	0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0x5f, 0x0a,
	0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x20, 0x0a, 0x1c, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x8a,
	0x01, 0xea, 0x41, 0x86, 0x01, 0x0a, 0x25, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x44, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6c, 0x65, 0x75, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x7d, 0x2a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x32,
	0x0a, 0x66, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x59, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xbd, 0x02, 0x0a, 0x12, 0x46, 0x69, 0x6c, 0x65, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdd, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x50, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x47, 0xca,
	0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xac, 0x02, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x10, 0x46, 0x69, 0x6c, 0x65,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x56,
	0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x5c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0xea, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescData = file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDesc
)

func file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescData)
	})
	return file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDescData
}

var file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_goTypes = []any{
	(FileUpload_ProcessingState)(0), // 0: google.shopping.merchant.datasources.v1beta.FileUpload.ProcessingState
	(FileUpload_Issue_Severity)(0),  // 1: google.shopping.merchant.datasources.v1beta.FileUpload.Issue.Severity
	(*FileUpload)(nil),              // 2: google.shopping.merchant.datasources.v1beta.FileUpload
	(*GetFileUploadRequest)(nil),    // 3: google.shopping.merchant.datasources.v1beta.GetFileUploadRequest
	(*FileUpload_Issue)(nil),        // 4: google.shopping.merchant.datasources.v1beta.FileUpload.Issue
	(*timestamppb.Timestamp)(nil),   // 5: google.protobuf.Timestamp
}
var file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_depIdxs = []int32{
	0, // 0: google.shopping.merchant.datasources.v1beta.FileUpload.processing_state:type_name -> google.shopping.merchant.datasources.v1beta.FileUpload.ProcessingState
	4, // 1: google.shopping.merchant.datasources.v1beta.FileUpload.issues:type_name -> google.shopping.merchant.datasources.v1beta.FileUpload.Issue
	5, // 2: google.shopping.merchant.datasources.v1beta.FileUpload.upload_time:type_name -> google.protobuf.Timestamp
	1, // 3: google.shopping.merchant.datasources.v1beta.FileUpload.Issue.severity:type_name -> google.shopping.merchant.datasources.v1beta.FileUpload.Issue.Severity
	3, // 4: google.shopping.merchant.datasources.v1beta.FileUploadsService.GetFileUpload:input_type -> google.shopping.merchant.datasources.v1beta.GetFileUploadRequest
	2, // 5: google.shopping.merchant.datasources.v1beta.FileUploadsService.GetFileUpload:output_type -> google.shopping.merchant.datasources.v1beta.FileUpload
	5, // [5:6] is the sub-list for method output_type
	4, // [4:5] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_init() }
func file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_init() {
	if File_google_shopping_merchant_datasources_v1beta_fileuploads_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_datasources_v1beta_fileuploads_proto = out.File
	file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_rawDesc = nil
	file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_goTypes = nil
	file_google_shopping_merchant_datasources_v1beta_fileuploads_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FileUploadsServiceClient is the client API for FileUploadsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FileUploadsServiceClient interface {
	// Gets the latest data source file upload. Only the `latest` alias is
	// accepted for a file upload.
	GetFileUpload(ctx context.Context, in *GetFileUploadRequest, opts ...grpc.CallOption) (*FileUpload, error)
}

type fileUploadsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFileUploadsServiceClient(cc grpc.ClientConnInterface) FileUploadsServiceClient {
	return &fileUploadsServiceClient{cc}
}

func (c *fileUploadsServiceClient) GetFileUpload(ctx context.Context, in *GetFileUploadRequest, opts ...grpc.CallOption) (*FileUpload, error) {
	out := new(FileUpload)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.datasources.v1beta.FileUploadsService/GetFileUpload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FileUploadsServiceServer is the server API for FileUploadsService service.
type FileUploadsServiceServer interface {
	// Gets the latest data source file upload. Only the `latest` alias is
	// accepted for a file upload.
	GetFileUpload(context.Context, *GetFileUploadRequest) (*FileUpload, error)
}

// UnimplementedFileUploadsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFileUploadsServiceServer struct {
}

func (*UnimplementedFileUploadsServiceServer) GetFileUpload(context.Context, *GetFileUploadRequest) (*FileUpload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFileUpload not implemented")
}

func RegisterFileUploadsServiceServer(s *grpc.Server, srv FileUploadsServiceServer) {
	s.RegisterService(&_FileUploadsService_serviceDesc, srv)
}

func _FileUploadsService_GetFileUpload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileUploadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FileUploadsServiceServer).GetFileUpload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.datasources.v1beta.FileUploadsService/GetFileUpload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FileUploadsServiceServer).GetFileUpload(ctx, req.(*GetFileUploadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FileUploadsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.datasources.v1beta.FileUploadsService",
	HandlerType: (*FileUploadsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFileUpload",
			Handler:    _FileUploadsService_GetFileUpload_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/datasources/v1beta/fileuploads.proto",
}
