// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/cloud_armor.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Fields related to Google Cloud Armor findings.
type CloudArmor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the [Google Cloud Armor security
	// policy](https://cloud.google.com/armor/docs/security-policy-overview)
	// relevant to the finding.
	SecurityPolicy *SecurityPolicy `protobuf:"bytes,1,opt,name=security_policy,json=securityPolicy,proto3" json:"security_policy,omitempty"`
	// Information about incoming requests evaluated by [Google Cloud Armor
	// security
	// policies](https://cloud.google.com/armor/docs/security-policy-overview).
	Requests *Requests `protobuf:"bytes,2,opt,name=requests,proto3" json:"requests,omitempty"`
	// Information about potential Layer 7 DDoS attacks identified by [Google
	// Cloud Armor Adaptive
	// Protection](https://cloud.google.com/armor/docs/adaptive-protection-overview).
	AdaptiveProtection *AdaptiveProtection `protobuf:"bytes,3,opt,name=adaptive_protection,json=adaptiveProtection,proto3" json:"adaptive_protection,omitempty"`
	// Information about DDoS attack volume and classification.
	Attack *Attack `protobuf:"bytes,4,opt,name=attack,proto3" json:"attack,omitempty"`
	// Distinguish between volumetric & protocol DDoS attack and
	// application layer attacks. For example, "L3_4" for Layer 3 and Layer 4 DDoS
	// attacks, or "L_7" for Layer 7 DDoS attacks.
	ThreatVector string `protobuf:"bytes,5,opt,name=threat_vector,json=threatVector,proto3" json:"threat_vector,omitempty"`
	// Duration of attack from the start until the current moment (updated every 5
	// minutes).
	Duration *durationpb.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *CloudArmor) Reset() {
	*x = CloudArmor{}
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudArmor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudArmor) ProtoMessage() {}

func (x *CloudArmor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudArmor.ProtoReflect.Descriptor instead.
func (*CloudArmor) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescGZIP(), []int{0}
}

func (x *CloudArmor) GetSecurityPolicy() *SecurityPolicy {
	if x != nil {
		return x.SecurityPolicy
	}
	return nil
}

func (x *CloudArmor) GetRequests() *Requests {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *CloudArmor) GetAdaptiveProtection() *AdaptiveProtection {
	if x != nil {
		return x.AdaptiveProtection
	}
	return nil
}

func (x *CloudArmor) GetAttack() *Attack {
	if x != nil {
		return x.Attack
	}
	return nil
}

func (x *CloudArmor) GetThreatVector() string {
	if x != nil {
		return x.ThreatVector
	}
	return ""
}

func (x *CloudArmor) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Information about the [Google Cloud Armor security
// policy](https://cloud.google.com/armor/docs/security-policy-overview)
// relevant to the finding.
type SecurityPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Google Cloud Armor security policy, for example,
	// "my-security-policy".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of Google Cloud Armor security policy for example, 'backend
	// security policy', 'edge security policy', 'network edge security policy',
	// or 'always-on DDoS protection'.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Whether or not the associated rule or policy is in preview mode.
	Preview bool `protobuf:"varint,3,opt,name=preview,proto3" json:"preview,omitempty"`
}

func (x *SecurityPolicy) Reset() {
	*x = SecurityPolicy{}
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityPolicy) ProtoMessage() {}

func (x *SecurityPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityPolicy.ProtoReflect.Descriptor instead.
func (*SecurityPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescGZIP(), []int{1}
}

func (x *SecurityPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecurityPolicy) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SecurityPolicy) GetPreview() bool {
	if x != nil {
		return x.Preview
	}
	return false
}

// Information about the requests relevant to the finding.
type Requests struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For 'Increasing deny ratio', the ratio is the denied traffic divided by the
	// allowed traffic. For 'Allowed traffic spike', the ratio is the allowed
	// traffic in the short term divided by allowed traffic in the long term.
	Ratio float64 `protobuf:"fixed64,1,opt,name=ratio,proto3" json:"ratio,omitempty"`
	// Allowed RPS (requests per second) in the short term.
	ShortTermAllowed int32 `protobuf:"varint,2,opt,name=short_term_allowed,json=shortTermAllowed,proto3" json:"short_term_allowed,omitempty"`
	// Allowed RPS (requests per second) over the long term.
	LongTermAllowed int32 `protobuf:"varint,3,opt,name=long_term_allowed,json=longTermAllowed,proto3" json:"long_term_allowed,omitempty"`
	// Denied RPS (requests per second) over the long term.
	LongTermDenied int32 `protobuf:"varint,4,opt,name=long_term_denied,json=longTermDenied,proto3" json:"long_term_denied,omitempty"`
}

func (x *Requests) Reset() {
	*x = Requests{}
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Requests) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Requests) ProtoMessage() {}

func (x *Requests) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Requests.ProtoReflect.Descriptor instead.
func (*Requests) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescGZIP(), []int{2}
}

func (x *Requests) GetRatio() float64 {
	if x != nil {
		return x.Ratio
	}
	return 0
}

func (x *Requests) GetShortTermAllowed() int32 {
	if x != nil {
		return x.ShortTermAllowed
	}
	return 0
}

func (x *Requests) GetLongTermAllowed() int32 {
	if x != nil {
		return x.LongTermAllowed
	}
	return 0
}

func (x *Requests) GetLongTermDenied() int32 {
	if x != nil {
		return x.LongTermDenied
	}
	return 0
}

// Information about [Google Cloud Armor Adaptive
// Protection](https://cloud.google.com/armor/docs/cloud-armor-overview#google-cloud-armor-adaptive-protection).
type AdaptiveProtection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A score of 0 means that there is low confidence that the detected event is
	// an actual attack. A score of 1 means that there is high confidence that the
	// detected event is an attack. See the [Adaptive Protection
	// documentation](https://cloud.google.com/armor/docs/adaptive-protection-overview#configure-alert-tuning)
	// for further explanation.
	Confidence float64 `protobuf:"fixed64,1,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *AdaptiveProtection) Reset() {
	*x = AdaptiveProtection{}
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdaptiveProtection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveProtection) ProtoMessage() {}

func (x *AdaptiveProtection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveProtection.ProtoReflect.Descriptor instead.
func (*AdaptiveProtection) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescGZIP(), []int{3}
}

func (x *AdaptiveProtection) GetConfidence() float64 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Information about DDoS attack volume and classification.
type Attack struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total PPS (packets per second) volume of attack.
	VolumePpsLong int64 `protobuf:"varint,4,opt,name=volume_pps_long,json=volumePpsLong,proto3" json:"volume_pps_long,omitempty"`
	// Total BPS (bytes per second) volume of attack.
	VolumeBpsLong int64 `protobuf:"varint,5,opt,name=volume_bps_long,json=volumeBpsLong,proto3" json:"volume_bps_long,omitempty"`
	// Type of attack, for example, 'SYN-flood', 'NTP-udp', or 'CHARGEN-udp'.
	Classification string `protobuf:"bytes,3,opt,name=classification,proto3" json:"classification,omitempty"`
	// Total PPS (packets per second) volume of attack. Deprecated - refer to
	// volume_pps_long instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/securitycenter/v2/cloud_armor.proto.
	VolumePps int32 `protobuf:"varint,1,opt,name=volume_pps,json=volumePps,proto3" json:"volume_pps,omitempty"`
	// Total BPS (bytes per second) volume of attack. Deprecated - refer to
	// volume_bps_long instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/securitycenter/v2/cloud_armor.proto.
	VolumeBps int32 `protobuf:"varint,2,opt,name=volume_bps,json=volumeBps,proto3" json:"volume_bps,omitempty"`
}

func (x *Attack) Reset() {
	*x = Attack{}
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Attack) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attack) ProtoMessage() {}

func (x *Attack) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attack.ProtoReflect.Descriptor instead.
func (*Attack) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescGZIP(), []int{4}
}

func (x *Attack) GetVolumePpsLong() int64 {
	if x != nil {
		return x.VolumePpsLong
	}
	return 0
}

func (x *Attack) GetVolumeBpsLong() int64 {
	if x != nil {
		return x.VolumeBpsLong
	}
	return 0
}

func (x *Attack) GetClassification() string {
	if x != nil {
		return x.Classification
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/securitycenter/v2/cloud_armor.proto.
func (x *Attack) GetVolumePps() int32 {
	if x != nil {
		return x.VolumePps
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/securitycenter/v2/cloud_armor.proto.
func (x *Attack) GetVolumeBps() int32 {
	if x != nil {
		return x.VolumeBps
	}
	return 0
}

var File_google_cloud_securitycenter_v2_cloud_armor_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xac, 0x03, 0x0a, 0x0a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x72, 0x6d, 0x6f,
	0x72, 0x12, 0x57, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x44, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x12, 0x63, 0x0a, 0x13, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x12, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x52, 0x06, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f,
	0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x52, 0x0a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x70, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0xa4, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x68, 0x6f, 0x72,
	0x74, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x41,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74,
	0x65, 0x72, 0x6d, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x72, 0x6d, 0x41, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f,
	0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6c, 0x6f,
	0x6e, 0x67, 0x54, 0x65, 0x72, 0x6d, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x22, 0x34, 0x0a, 0x12,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x06, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x12, 0x26, 0x0a,
	0x0f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x70, 0x70, 0x73, 0x5f, 0x6c, 0x6f, 0x6e, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x70,
	0x73, 0x4c, 0x6f, 0x6e, 0x67, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f,
	0x62, 0x70, 0x73, 0x5f, 0x6c, 0x6f, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x70, 0x73, 0x4c, 0x6f, 0x6e, 0x67, 0x12, 0x26, 0x0a,
	0x0e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0a, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f,
	0x70, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x70, 0x73, 0x12, 0x21, 0x0a, 0x0a, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x09, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x70, 0x73, 0x42, 0xe9, 0x01, 0x0a, 0x22,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x42, 0x0f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x72, 0x6d, 0x6f, 0x72, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x56, 0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x5c, 0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescData = file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_securitycenter_v2_cloud_armor_proto_goTypes = []any{
	(*CloudArmor)(nil),          // 0: google.cloud.securitycenter.v2.CloudArmor
	(*SecurityPolicy)(nil),      // 1: google.cloud.securitycenter.v2.SecurityPolicy
	(*Requests)(nil),            // 2: google.cloud.securitycenter.v2.Requests
	(*AdaptiveProtection)(nil),  // 3: google.cloud.securitycenter.v2.AdaptiveProtection
	(*Attack)(nil),              // 4: google.cloud.securitycenter.v2.Attack
	(*durationpb.Duration)(nil), // 5: google.protobuf.Duration
}
var file_google_cloud_securitycenter_v2_cloud_armor_proto_depIdxs = []int32{
	1, // 0: google.cloud.securitycenter.v2.CloudArmor.security_policy:type_name -> google.cloud.securitycenter.v2.SecurityPolicy
	2, // 1: google.cloud.securitycenter.v2.CloudArmor.requests:type_name -> google.cloud.securitycenter.v2.Requests
	3, // 2: google.cloud.securitycenter.v2.CloudArmor.adaptive_protection:type_name -> google.cloud.securitycenter.v2.AdaptiveProtection
	4, // 3: google.cloud.securitycenter.v2.CloudArmor.attack:type_name -> google.cloud.securitycenter.v2.Attack
	5, // 4: google.cloud.securitycenter.v2.CloudArmor.duration:type_name -> google.protobuf.Duration
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_cloud_armor_proto_init() }
func file_google_cloud_securitycenter_v2_cloud_armor_proto_init() {
	if File_google_cloud_securitycenter_v2_cloud_armor_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_cloud_armor_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_cloud_armor_proto_depIdxs,
		MessageInfos:      file_google_cloud_securitycenter_v2_cloud_armor_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_cloud_armor_proto = out.File
	file_google_cloud_securitycenter_v2_cloud_armor_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_cloud_armor_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_cloud_armor_proto_depIdxs = nil
}
