// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/db_server.proto

package oracledatabasepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The various lifecycle states of the database server.
type DbServerProperties_State int32

const (
	// Default unspecified value.
	DbServerProperties_STATE_UNSPECIFIED DbServerProperties_State = 0
	// Indicates that the resource is in creating state.
	DbServerProperties_CREATING DbServerProperties_State = 1
	// Indicates that the resource is in available state.
	DbServerProperties_AVAILABLE DbServerProperties_State = 2
	// Indicates that the resource is in unavailable state.
	DbServerProperties_UNAVAILABLE DbServerProperties_State = 3
	// Indicates that the resource is in deleting state.
	DbServerProperties_DELETING DbServerProperties_State = 4
	// Indicates that the resource is in deleted state.
	DbServerProperties_DELETED DbServerProperties_State = 5
)

// Enum value maps for DbServerProperties_State.
var (
	DbServerProperties_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "AVAILABLE",
		3: "UNAVAILABLE",
		4: "DELETING",
		5: "DELETED",
	}
	DbServerProperties_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"AVAILABLE":         2,
		"UNAVAILABLE":       3,
		"DELETING":          4,
		"DELETED":           5,
	}
)

func (x DbServerProperties_State) Enum() *DbServerProperties_State {
	p := new(DbServerProperties_State)
	*p = x
	return p
}

func (x DbServerProperties_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DbServerProperties_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_db_server_proto_enumTypes[0].Descriptor()
}

func (DbServerProperties_State) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_db_server_proto_enumTypes[0]
}

func (x DbServerProperties_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DbServerProperties_State.Descriptor instead.
func (DbServerProperties_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_db_server_proto_rawDescGZIP(), []int{1, 0}
}

// Details of the database server resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbServer/
type DbServer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the database server resource with the format:
	// projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}/dbServers/{db_server}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly name for this resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Various properties of the database server.
	Properties *DbServerProperties `protobuf:"bytes,3,opt,name=properties,proto3" json:"properties,omitempty"`
}

func (x *DbServer) Reset() {
	*x = DbServer{}
	mi := &file_google_cloud_oracledatabase_v1_db_server_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DbServer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DbServer) ProtoMessage() {}

func (x *DbServer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_db_server_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DbServer.ProtoReflect.Descriptor instead.
func (*DbServer) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_db_server_proto_rawDescGZIP(), []int{0}
}

func (x *DbServer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DbServer) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DbServer) GetProperties() *DbServerProperties {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Various properties and settings associated with Exadata database server.
type DbServerProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. OCID of database server.
	Ocid string `protobuf:"bytes,1,opt,name=ocid,proto3" json:"ocid,omitempty"`
	// Optional. OCPU count per database.
	OcpuCount int32 `protobuf:"varint,2,opt,name=ocpu_count,json=ocpuCount,proto3" json:"ocpu_count,omitempty"`
	// Optional. Maximum OCPU count per database.
	MaxOcpuCount int32 `protobuf:"varint,3,opt,name=max_ocpu_count,json=maxOcpuCount,proto3" json:"max_ocpu_count,omitempty"`
	// Optional. Memory allocated in GBs.
	MemorySizeGb int32 `protobuf:"varint,4,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. Maximum memory allocated in GBs.
	MaxMemorySizeGb int32 `protobuf:"varint,5,opt,name=max_memory_size_gb,json=maxMemorySizeGb,proto3" json:"max_memory_size_gb,omitempty"`
	// Optional. Local storage per VM.
	DbNodeStorageSizeGb int32 `protobuf:"varint,6,opt,name=db_node_storage_size_gb,json=dbNodeStorageSizeGb,proto3" json:"db_node_storage_size_gb,omitempty"`
	// Optional. Maximum local storage per VM.
	MaxDbNodeStorageSizeGb int32 `protobuf:"varint,7,opt,name=max_db_node_storage_size_gb,json=maxDbNodeStorageSizeGb,proto3" json:"max_db_node_storage_size_gb,omitempty"`
	// Optional. Vm count per database.
	VmCount int32 `protobuf:"varint,8,opt,name=vm_count,json=vmCount,proto3" json:"vm_count,omitempty"`
	// Output only. State of the database server.
	State DbServerProperties_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.oracledatabase.v1.DbServerProperties_State" json:"state,omitempty"`
	// Output only. OCID of database nodes associated with the database server.
	DbNodeIds []string `protobuf:"bytes,10,rep,name=db_node_ids,json=dbNodeIds,proto3" json:"db_node_ids,omitempty"`
}

func (x *DbServerProperties) Reset() {
	*x = DbServerProperties{}
	mi := &file_google_cloud_oracledatabase_v1_db_server_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DbServerProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DbServerProperties) ProtoMessage() {}

func (x *DbServerProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_db_server_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DbServerProperties.ProtoReflect.Descriptor instead.
func (*DbServerProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_db_server_proto_rawDescGZIP(), []int{1}
}

func (x *DbServerProperties) GetOcid() string {
	if x != nil {
		return x.Ocid
	}
	return ""
}

func (x *DbServerProperties) GetOcpuCount() int32 {
	if x != nil {
		return x.OcpuCount
	}
	return 0
}

func (x *DbServerProperties) GetMaxOcpuCount() int32 {
	if x != nil {
		return x.MaxOcpuCount
	}
	return 0
}

func (x *DbServerProperties) GetMemorySizeGb() int32 {
	if x != nil {
		return x.MemorySizeGb
	}
	return 0
}

func (x *DbServerProperties) GetMaxMemorySizeGb() int32 {
	if x != nil {
		return x.MaxMemorySizeGb
	}
	return 0
}

func (x *DbServerProperties) GetDbNodeStorageSizeGb() int32 {
	if x != nil {
		return x.DbNodeStorageSizeGb
	}
	return 0
}

func (x *DbServerProperties) GetMaxDbNodeStorageSizeGb() int32 {
	if x != nil {
		return x.MaxDbNodeStorageSizeGb
	}
	return 0
}

func (x *DbServerProperties) GetVmCount() int32 {
	if x != nil {
		return x.VmCount
	}
	return 0
}

func (x *DbServerProperties) GetState() DbServerProperties_State {
	if x != nil {
		return x.State
	}
	return DbServerProperties_STATE_UNSPECIFIED
}

func (x *DbServerProperties) GetDbNodeIds() []string {
	if x != nil {
		return x.DbNodeIds
	}
	return nil
}

var File_google_cloud_oracledatabase_v1_db_server_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_db_server_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x64, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe2, 0x02, 0x0a,
	0x08, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x3a, 0xbb, 0x01, 0xea, 0x41, 0xb7, 0x01, 0x0a, 0x26, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x12, 0x78, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65,
	0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x7d, 0x2f, 0x64, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x64, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x7d, 0x2a, 0x09, 0x64, 0x62,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x32, 0x08, 0x64, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x22, 0xd9, 0x04, 0x0a, 0x12, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6f, 0x63, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6f, 0x63, 0x69,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6f, 0x63, 0x70, 0x75,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x63, 0x70,
	0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x67, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x30, 0x0a, 0x12, 0x6d,
	0x61, 0x78, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67,
	0x62, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x61,
	0x78, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x39, 0x0a,
	0x17, 0x64, 0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x13, 0x64, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x40, 0x0a, 0x1b, 0x6d, 0x61, 0x78, 0x5f,
	0x64, 0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x16, 0x6d, 0x61, 0x78, 0x44, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x6d,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x76, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x62, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x23, 0x0a, 0x0b, 0x64, 0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x62, 0x4e, 0x6f, 0x64,
	0x65, 0x49, 0x64, 0x73, 0x22, 0x67, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04,
	0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x05, 0x42, 0xe7, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62,
	0x3b, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70,
	0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_db_server_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_db_server_proto_rawDescData = file_google_cloud_oracledatabase_v1_db_server_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_db_server_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_db_server_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_db_server_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_db_server_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_db_server_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_db_server_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_oracledatabase_v1_db_server_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_oracledatabase_v1_db_server_proto_goTypes = []any{
	(DbServerProperties_State)(0), // 0: google.cloud.oracledatabase.v1.DbServerProperties.State
	(*DbServer)(nil),              // 1: google.cloud.oracledatabase.v1.DbServer
	(*DbServerProperties)(nil),    // 2: google.cloud.oracledatabase.v1.DbServerProperties
}
var file_google_cloud_oracledatabase_v1_db_server_proto_depIdxs = []int32{
	2, // 0: google.cloud.oracledatabase.v1.DbServer.properties:type_name -> google.cloud.oracledatabase.v1.DbServerProperties
	0, // 1: google.cloud.oracledatabase.v1.DbServerProperties.state:type_name -> google.cloud.oracledatabase.v1.DbServerProperties.State
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_db_server_proto_init() }
func file_google_cloud_oracledatabase_v1_db_server_proto_init() {
	if File_google_cloud_oracledatabase_v1_db_server_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_db_server_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_db_server_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_db_server_proto_depIdxs,
		EnumInfos:         file_google_cloud_oracledatabase_v1_db_server_proto_enumTypes,
		MessageInfos:      file_google_cloud_oracledatabase_v1_db_server_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_db_server_proto = out.File
	file_google_cloud_oracledatabase_v1_db_server_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_db_server_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_db_server_proto_depIdxs = nil
}
