// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/managedkafka/v1/managed_kafka_connect.proto

package managedkafkapb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for GetConnectCluster.
type GetConnectClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Kafka Connect cluster whose configuration to
	// return. Structured like
	// `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectClusterRequest) Reset() {
	*x = GetConnectClusterRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConnectClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectClusterRequest) ProtoMessage() {}

func (x *GetConnectClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectClusterRequest.ProtoReflect.Descriptor instead.
func (*GetConnectClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{0}
}

func (x *GetConnectClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for CreateConnectCluster.
type CreateConnectClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/location in which to create the Kafka Connect
	// cluster. Structured like
	// `projects/{project}/locations/{location}/`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the Connect cluster, which will become the
	// final component of the cluster's name. The ID must be 1-63 characters long,
	// and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply
	// with RFC 1035.
	//
	// This value is structured like: `my-cluster-id`.
	ConnectClusterId string `protobuf:"bytes,2,opt,name=connect_cluster_id,json=connectClusterId,proto3" json:"connect_cluster_id,omitempty"`
	// Required. Configuration of the Kafka Connect cluster to create. Its `name`
	// field is ignored.
	ConnectCluster *ConnectCluster `protobuf:"bytes,3,opt,name=connect_cluster,json=connectCluster,proto3" json:"connect_cluster,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID to avoid duplication of requests. If a request times out or
	// fails, retrying with the same ID allows the server to recognize the
	// previous attempt. For at least 60 minutes, the server ignores duplicate
	// requests bearing the same ID.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID
	// within 60 minutes of the last request, the server checks if an original
	// operation with the same request ID was received. If so, the server ignores
	// the second request.
	//
	// The request ID must be a valid UUID. A zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateConnectClusterRequest) Reset() {
	*x = CreateConnectClusterRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConnectClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectClusterRequest) ProtoMessage() {}

func (x *CreateConnectClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{1}
}

func (x *CreateConnectClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectClusterRequest) GetConnectClusterId() string {
	if x != nil {
		return x.ConnectClusterId
	}
	return ""
}

func (x *CreateConnectClusterRequest) GetConnectCluster() *ConnectCluster {
	if x != nil {
		return x.ConnectCluster
	}
	return nil
}

func (x *CreateConnectClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for UpdateConnectCluster.
type UpdateConnectClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// cluster resource by the update. The fields specified in the update_mask are
	// relative to the resource, not the full request. A field will be overwritten
	// if it is in the mask. The mask is required and a value of * will update all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The Kafka Connect cluster to update. Its `name` field must be
	// populated.
	ConnectCluster *ConnectCluster `protobuf:"bytes,2,opt,name=connect_cluster,json=connectCluster,proto3" json:"connect_cluster,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID to avoid duplication of requests. If a request times out or
	// fails, retrying with the same ID allows the server to recognize the
	// previous attempt. For at least 60 minutes, the server ignores duplicate
	// requests bearing the same ID.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID
	// within 60 minutes of the last request, the server checks if an original
	// operation with the same request ID was received. If so, the server ignores
	// the second request.
	//
	// The request ID must be a valid UUID. A zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateConnectClusterRequest) Reset() {
	*x = UpdateConnectClusterRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConnectClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectClusterRequest) ProtoMessage() {}

func (x *UpdateConnectClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateConnectClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConnectClusterRequest) GetConnectCluster() *ConnectCluster {
	if x != nil {
		return x.ConnectCluster
	}
	return nil
}

func (x *UpdateConnectClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for DeleteConnectCluster.
type DeleteConnectClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Kafka Connect cluster to delete.
	// Structured like
	// `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID to avoid duplication of requests. If a request times out or
	// fails, retrying with the same ID allows the server to recognize the
	// previous attempt. For at least 60 minutes, the server ignores duplicate
	// requests bearing the same ID.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID
	// within 60 minutes of the last request, the server checks if an original
	// operation with the same request ID was received. If so, the server ignores
	// the second request.
	//
	// The request ID must be a valid UUID. A zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteConnectClusterRequest) Reset() {
	*x = DeleteConnectClusterRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteConnectClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectClusterRequest) ProtoMessage() {}

func (x *DeleteConnectClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteConnectClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConnectClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for ListConnectClusters.
type ListConnectClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/location whose Connect clusters are to be
	// listed. Structured like `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of Connect clusters to return. The service may
	// return fewer than this value. If unspecified, server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListConnectClusters`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListConnectClusters`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter expression for the result.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListConnectClustersRequest) Reset() {
	*x = ListConnectClustersRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConnectClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectClustersRequest) ProtoMessage() {}

func (x *ListConnectClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectClustersRequest.ProtoReflect.Descriptor instead.
func (*ListConnectClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{4}
}

func (x *ListConnectClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConnectClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConnectClustersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for ListConnectClusters.
type ListConnectClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Connect clusters in the requested parent.
	ConnectClusters []*ConnectCluster `protobuf:"bytes,1,rep,name=connect_clusters,json=connectClusters,proto3" json:"connect_clusters,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page of
	// results. If this field is omitted, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConnectClustersResponse) Reset() {
	*x = ListConnectClustersResponse{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConnectClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectClustersResponse) ProtoMessage() {}

func (x *ListConnectClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectClustersResponse.ProtoReflect.Descriptor instead.
func (*ListConnectClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{5}
}

func (x *ListConnectClustersResponse) GetConnectClusters() []*ConnectCluster {
	if x != nil {
		return x.ConnectClusters
	}
	return nil
}

func (x *ListConnectClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for GetConnector.
type GetConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the connector whose configuration to return.
	// Structured like:
	// projects/{project}/locations/{location}/connectClusters/{connectCluster}/connectors/{connector}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectorRequest) Reset() {
	*x = GetConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectorRequest) ProtoMessage() {}

func (x *GetConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectorRequest.ProtoReflect.Descriptor instead.
func (*GetConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{6}
}

func (x *GetConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for CreateConnector.
type CreateConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Connect cluster in which to create the connector.
	// Structured like
	// `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the connector, which will become the final
	// component of the connector's name. The ID must be 1-63 characters long, and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
	// RFC 1035.
	//
	// This value is structured like: `my-connector-id`.
	ConnectorId string `protobuf:"bytes,2,opt,name=connector_id,json=connectorId,proto3" json:"connector_id,omitempty"`
	// Required. The connector to create.
	Connector *Connector `protobuf:"bytes,3,opt,name=connector,proto3" json:"connector,omitempty"`
}

func (x *CreateConnectorRequest) Reset() {
	*x = CreateConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectorRequest) ProtoMessage() {}

func (x *CreateConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectorRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{7}
}

func (x *CreateConnectorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectorRequest) GetConnectorId() string {
	if x != nil {
		return x.ConnectorId
	}
	return ""
}

func (x *CreateConnectorRequest) GetConnector() *Connector {
	if x != nil {
		return x.Connector
	}
	return nil
}

// Request for UpdateConnector.
type UpdateConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// cluster resource by the update. The fields specified in the update_mask are
	// relative to the resource, not the full request. A field will be overwritten
	// if it is in the mask. The mask is required and a value of * will update all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The connector to update. Its `name` field must be populated.
	Connector *Connector `protobuf:"bytes,2,opt,name=connector,proto3" json:"connector,omitempty"`
}

func (x *UpdateConnectorRequest) Reset() {
	*x = UpdateConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectorRequest) ProtoMessage() {}

func (x *UpdateConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectorRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateConnectorRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConnectorRequest) GetConnector() *Connector {
	if x != nil {
		return x.Connector
	}
	return nil
}

// Request for DeleteConnector.
type DeleteConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the connector to delete.
	// Structured like:
	// projects/{project}/locations/{location}/connectClusters/{connectCluster}/connectors/{connector}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConnectorRequest) Reset() {
	*x = DeleteConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectorRequest) ProtoMessage() {}

func (x *DeleteConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectorRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for ListConnectors.
type ListConnectorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Connect cluster whose connectors are to be listed.
	// Structured like
	// `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of connectors to return. The service may
	// return fewer than this value. If unspecified, server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListConnectors` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListConnectors`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConnectorsRequest) Reset() {
	*x = ListConnectorsRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConnectorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectorsRequest) ProtoMessage() {}

func (x *ListConnectorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectorsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{10}
}

func (x *ListConnectorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListConnectors.
type ListConnectorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of connectors in the requested parent.
	Connectors []*Connector `protobuf:"bytes,1,rep,name=connectors,proto3" json:"connectors,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page of
	// results. If this field is omitted, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConnectorsResponse) Reset() {
	*x = ListConnectorsResponse{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConnectorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectorsResponse) ProtoMessage() {}

func (x *ListConnectorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectorsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{11}
}

func (x *ListConnectorsResponse) GetConnectors() []*Connector {
	if x != nil {
		return x.Connectors
	}
	return nil
}

func (x *ListConnectorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for PauseConnector.
type PauseConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the connector to pause.
	// Structured like:
	// projects/{project}/locations/{location}/connectClusters/{connectCluster}/connectors/{connector}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PauseConnectorRequest) Reset() {
	*x = PauseConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseConnectorRequest) ProtoMessage() {}

func (x *PauseConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseConnectorRequest.ProtoReflect.Descriptor instead.
func (*PauseConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{12}
}

func (x *PauseConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response for PauseConnector.
type PauseConnectorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PauseConnectorResponse) Reset() {
	*x = PauseConnectorResponse{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseConnectorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseConnectorResponse) ProtoMessage() {}

func (x *PauseConnectorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseConnectorResponse.ProtoReflect.Descriptor instead.
func (*PauseConnectorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{13}
}

// Request for ResumeConnector.
type ResumeConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the connector to pause.
	// Structured like:
	// projects/{project}/locations/{location}/connectClusters/{connectCluster}/connectors/{connector}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResumeConnectorRequest) Reset() {
	*x = ResumeConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeConnectorRequest) ProtoMessage() {}

func (x *ResumeConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeConnectorRequest.ProtoReflect.Descriptor instead.
func (*ResumeConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{14}
}

func (x *ResumeConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response for ResumeConnector.
type ResumeConnectorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResumeConnectorResponse) Reset() {
	*x = ResumeConnectorResponse{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeConnectorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeConnectorResponse) ProtoMessage() {}

func (x *ResumeConnectorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeConnectorResponse.ProtoReflect.Descriptor instead.
func (*ResumeConnectorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{15}
}

// Request for RestartConnector.
type RestartConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the connector to restart.
	// Structured like:
	// projects/{project}/locations/{location}/connectClusters/{connectCluster}/connectors/{connector}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RestartConnectorRequest) Reset() {
	*x = RestartConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestartConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestartConnectorRequest) ProtoMessage() {}

func (x *RestartConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestartConnectorRequest.ProtoReflect.Descriptor instead.
func (*RestartConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{16}
}

func (x *RestartConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response for RestartConnector.
type RestartConnectorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RestartConnectorResponse) Reset() {
	*x = RestartConnectorResponse{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestartConnectorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestartConnectorResponse) ProtoMessage() {}

func (x *RestartConnectorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestartConnectorResponse.ProtoReflect.Descriptor instead.
func (*RestartConnectorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{17}
}

// Request for StopConnector.
type StopConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the connector to stop.
	// Structured like:
	// projects/{project}/locations/{location}/connectClusters/{connectCluster}/connectors/{connector}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StopConnectorRequest) Reset() {
	*x = StopConnectorRequest{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopConnectorRequest) ProtoMessage() {}

func (x *StopConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopConnectorRequest.ProtoReflect.Descriptor instead.
func (*StopConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{18}
}

func (x *StopConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response for StopConnector.
type StopConnectorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StopConnectorResponse) Reset() {
	*x = StopConnectorResponse{}
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopConnectorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopConnectorResponse) ProtoMessage() {}

func (x *StopConnectorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopConnectorResponse.ProtoReflect.Descriptor instead.
func (*StopConnectorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP(), []int{19}
}

var File_google_cloud_managedkafka_v1_managed_kafka_connect_proto protoreflect.FileDescriptor

var file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2f, 0x76, 0x31, 0x2f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61,
	0x66, 0x6b, 0x61, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x62, 0x0a, 0x18, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4,
	0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b,
	0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5a, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0,
	0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe7, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x91, 0x01, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61,
	0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xeb, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xc0, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x57, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x58, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd3,
	0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x12, 0x25, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x22, 0xa6, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x4a, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x5b, 0x0a,
	0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x89, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5a, 0x0a,
	0x15, 0x50, 0x61, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x18, 0x0a, 0x16, 0x50, 0x61, 0x75,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x5b, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x19, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c, 0x0a, 0x17, 0x52,
	0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x52, 0x65, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x17, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x83, 0x19, 0x0a, 0x13, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x12, 0xd0, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x91, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x46, 0x3a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x93, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa0, 0x01, 0xca, 0x41,
	0x23, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1,
	0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61,
	0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6f, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x51, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61,
	0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x22, 0x73, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x09, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x0f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x75, 0xda, 0x41,
	0x15, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x09, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x32, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61,
	0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x2a, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x0e, 0x50, 0x61, 0x75, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x75, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x75, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61, 0x75, 0x73, 0x65, 0x12, 0xd9,
	0x01, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b,
	0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x59, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x01,
	0x2a, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0xdd, 0x01, 0x0a, 0x10, 0x52,
	0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a,
	0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xd1, 0x01, 0x0a, 0x0d, 0x53,
	0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x01, 0x2a, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x1a, 0x4f,
	0xca, 0x41, 0x1b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xe4, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x61, 0x66,
	0x6b, 0x61, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b, 0x61, 0x66,
	0x6b, 0x61, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x70, 0x62, 0x3b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6b,
	0x61, 0x66, 0x6b, 0x61, 0x70, 0x62, 0xaa, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x61, 0x66,
	0x6b, 0x61, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x61, 0x66, 0x6b,
	0x61, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x61, 0x66,
	0x6b, 0x61, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescOnce sync.Once
	file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescData = file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDesc
)

func file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescGZIP() []byte {
	file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescOnce.Do(func() {
		file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescData)
	})
	return file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDescData
}

var file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_goTypes = []any{
	(*GetConnectClusterRequest)(nil),    // 0: google.cloud.managedkafka.v1.GetConnectClusterRequest
	(*CreateConnectClusterRequest)(nil), // 1: google.cloud.managedkafka.v1.CreateConnectClusterRequest
	(*UpdateConnectClusterRequest)(nil), // 2: google.cloud.managedkafka.v1.UpdateConnectClusterRequest
	(*DeleteConnectClusterRequest)(nil), // 3: google.cloud.managedkafka.v1.DeleteConnectClusterRequest
	(*ListConnectClustersRequest)(nil),  // 4: google.cloud.managedkafka.v1.ListConnectClustersRequest
	(*ListConnectClustersResponse)(nil), // 5: google.cloud.managedkafka.v1.ListConnectClustersResponse
	(*GetConnectorRequest)(nil),         // 6: google.cloud.managedkafka.v1.GetConnectorRequest
	(*CreateConnectorRequest)(nil),      // 7: google.cloud.managedkafka.v1.CreateConnectorRequest
	(*UpdateConnectorRequest)(nil),      // 8: google.cloud.managedkafka.v1.UpdateConnectorRequest
	(*DeleteConnectorRequest)(nil),      // 9: google.cloud.managedkafka.v1.DeleteConnectorRequest
	(*ListConnectorsRequest)(nil),       // 10: google.cloud.managedkafka.v1.ListConnectorsRequest
	(*ListConnectorsResponse)(nil),      // 11: google.cloud.managedkafka.v1.ListConnectorsResponse
	(*PauseConnectorRequest)(nil),       // 12: google.cloud.managedkafka.v1.PauseConnectorRequest
	(*PauseConnectorResponse)(nil),      // 13: google.cloud.managedkafka.v1.PauseConnectorResponse
	(*ResumeConnectorRequest)(nil),      // 14: google.cloud.managedkafka.v1.ResumeConnectorRequest
	(*ResumeConnectorResponse)(nil),     // 15: google.cloud.managedkafka.v1.ResumeConnectorResponse
	(*RestartConnectorRequest)(nil),     // 16: google.cloud.managedkafka.v1.RestartConnectorRequest
	(*RestartConnectorResponse)(nil),    // 17: google.cloud.managedkafka.v1.RestartConnectorResponse
	(*StopConnectorRequest)(nil),        // 18: google.cloud.managedkafka.v1.StopConnectorRequest
	(*StopConnectorResponse)(nil),       // 19: google.cloud.managedkafka.v1.StopConnectorResponse
	(*ConnectCluster)(nil),              // 20: google.cloud.managedkafka.v1.ConnectCluster
	(*fieldmaskpb.FieldMask)(nil),       // 21: google.protobuf.FieldMask
	(*Connector)(nil),                   // 22: google.cloud.managedkafka.v1.Connector
	(*longrunningpb.Operation)(nil),     // 23: google.longrunning.Operation
	(*emptypb.Empty)(nil),               // 24: google.protobuf.Empty
}
var file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_depIdxs = []int32{
	20, // 0: google.cloud.managedkafka.v1.CreateConnectClusterRequest.connect_cluster:type_name -> google.cloud.managedkafka.v1.ConnectCluster
	21, // 1: google.cloud.managedkafka.v1.UpdateConnectClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 2: google.cloud.managedkafka.v1.UpdateConnectClusterRequest.connect_cluster:type_name -> google.cloud.managedkafka.v1.ConnectCluster
	20, // 3: google.cloud.managedkafka.v1.ListConnectClustersResponse.connect_clusters:type_name -> google.cloud.managedkafka.v1.ConnectCluster
	22, // 4: google.cloud.managedkafka.v1.CreateConnectorRequest.connector:type_name -> google.cloud.managedkafka.v1.Connector
	21, // 5: google.cloud.managedkafka.v1.UpdateConnectorRequest.update_mask:type_name -> google.protobuf.FieldMask
	22, // 6: google.cloud.managedkafka.v1.UpdateConnectorRequest.connector:type_name -> google.cloud.managedkafka.v1.Connector
	22, // 7: google.cloud.managedkafka.v1.ListConnectorsResponse.connectors:type_name -> google.cloud.managedkafka.v1.Connector
	4,  // 8: google.cloud.managedkafka.v1.ManagedKafkaConnect.ListConnectClusters:input_type -> google.cloud.managedkafka.v1.ListConnectClustersRequest
	0,  // 9: google.cloud.managedkafka.v1.ManagedKafkaConnect.GetConnectCluster:input_type -> google.cloud.managedkafka.v1.GetConnectClusterRequest
	1,  // 10: google.cloud.managedkafka.v1.ManagedKafkaConnect.CreateConnectCluster:input_type -> google.cloud.managedkafka.v1.CreateConnectClusterRequest
	2,  // 11: google.cloud.managedkafka.v1.ManagedKafkaConnect.UpdateConnectCluster:input_type -> google.cloud.managedkafka.v1.UpdateConnectClusterRequest
	3,  // 12: google.cloud.managedkafka.v1.ManagedKafkaConnect.DeleteConnectCluster:input_type -> google.cloud.managedkafka.v1.DeleteConnectClusterRequest
	10, // 13: google.cloud.managedkafka.v1.ManagedKafkaConnect.ListConnectors:input_type -> google.cloud.managedkafka.v1.ListConnectorsRequest
	6,  // 14: google.cloud.managedkafka.v1.ManagedKafkaConnect.GetConnector:input_type -> google.cloud.managedkafka.v1.GetConnectorRequest
	7,  // 15: google.cloud.managedkafka.v1.ManagedKafkaConnect.CreateConnector:input_type -> google.cloud.managedkafka.v1.CreateConnectorRequest
	8,  // 16: google.cloud.managedkafka.v1.ManagedKafkaConnect.UpdateConnector:input_type -> google.cloud.managedkafka.v1.UpdateConnectorRequest
	9,  // 17: google.cloud.managedkafka.v1.ManagedKafkaConnect.DeleteConnector:input_type -> google.cloud.managedkafka.v1.DeleteConnectorRequest
	12, // 18: google.cloud.managedkafka.v1.ManagedKafkaConnect.PauseConnector:input_type -> google.cloud.managedkafka.v1.PauseConnectorRequest
	14, // 19: google.cloud.managedkafka.v1.ManagedKafkaConnect.ResumeConnector:input_type -> google.cloud.managedkafka.v1.ResumeConnectorRequest
	16, // 20: google.cloud.managedkafka.v1.ManagedKafkaConnect.RestartConnector:input_type -> google.cloud.managedkafka.v1.RestartConnectorRequest
	18, // 21: google.cloud.managedkafka.v1.ManagedKafkaConnect.StopConnector:input_type -> google.cloud.managedkafka.v1.StopConnectorRequest
	5,  // 22: google.cloud.managedkafka.v1.ManagedKafkaConnect.ListConnectClusters:output_type -> google.cloud.managedkafka.v1.ListConnectClustersResponse
	20, // 23: google.cloud.managedkafka.v1.ManagedKafkaConnect.GetConnectCluster:output_type -> google.cloud.managedkafka.v1.ConnectCluster
	23, // 24: google.cloud.managedkafka.v1.ManagedKafkaConnect.CreateConnectCluster:output_type -> google.longrunning.Operation
	23, // 25: google.cloud.managedkafka.v1.ManagedKafkaConnect.UpdateConnectCluster:output_type -> google.longrunning.Operation
	23, // 26: google.cloud.managedkafka.v1.ManagedKafkaConnect.DeleteConnectCluster:output_type -> google.longrunning.Operation
	11, // 27: google.cloud.managedkafka.v1.ManagedKafkaConnect.ListConnectors:output_type -> google.cloud.managedkafka.v1.ListConnectorsResponse
	22, // 28: google.cloud.managedkafka.v1.ManagedKafkaConnect.GetConnector:output_type -> google.cloud.managedkafka.v1.Connector
	22, // 29: google.cloud.managedkafka.v1.ManagedKafkaConnect.CreateConnector:output_type -> google.cloud.managedkafka.v1.Connector
	22, // 30: google.cloud.managedkafka.v1.ManagedKafkaConnect.UpdateConnector:output_type -> google.cloud.managedkafka.v1.Connector
	24, // 31: google.cloud.managedkafka.v1.ManagedKafkaConnect.DeleteConnector:output_type -> google.protobuf.Empty
	13, // 32: google.cloud.managedkafka.v1.ManagedKafkaConnect.PauseConnector:output_type -> google.cloud.managedkafka.v1.PauseConnectorResponse
	15, // 33: google.cloud.managedkafka.v1.ManagedKafkaConnect.ResumeConnector:output_type -> google.cloud.managedkafka.v1.ResumeConnectorResponse
	17, // 34: google.cloud.managedkafka.v1.ManagedKafkaConnect.RestartConnector:output_type -> google.cloud.managedkafka.v1.RestartConnectorResponse
	19, // 35: google.cloud.managedkafka.v1.ManagedKafkaConnect.StopConnector:output_type -> google.cloud.managedkafka.v1.StopConnectorResponse
	22, // [22:36] is the sub-list for method output_type
	8,  // [8:22] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_init() }
func file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_init() {
	if File_google_cloud_managedkafka_v1_managed_kafka_connect_proto != nil {
		return
	}
	file_google_cloud_managedkafka_v1_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_goTypes,
		DependencyIndexes: file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_depIdxs,
		MessageInfos:      file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_msgTypes,
	}.Build()
	File_google_cloud_managedkafka_v1_managed_kafka_connect_proto = out.File
	file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_rawDesc = nil
	file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_goTypes = nil
	file_google_cloud_managedkafka_v1_managed_kafka_connect_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ManagedKafkaConnectClient is the client API for ManagedKafkaConnect service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ManagedKafkaConnectClient interface {
	// Lists the Kafka Connect clusters in a given project and location.
	ListConnectClusters(ctx context.Context, in *ListConnectClustersRequest, opts ...grpc.CallOption) (*ListConnectClustersResponse, error)
	// Returns the properties of a single Kafka Connect cluster.
	GetConnectCluster(ctx context.Context, in *GetConnectClusterRequest, opts ...grpc.CallOption) (*ConnectCluster, error)
	// Creates a new Kafka Connect cluster in a given project and location.
	CreateConnectCluster(ctx context.Context, in *CreateConnectClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the properties of a single Kafka Connect cluster.
	UpdateConnectCluster(ctx context.Context, in *UpdateConnectClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Connect cluster.
	DeleteConnectCluster(ctx context.Context, in *DeleteConnectClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the connectors in a given Connect cluster.
	ListConnectors(ctx context.Context, in *ListConnectorsRequest, opts ...grpc.CallOption) (*ListConnectorsResponse, error)
	// Returns the properties of a single connector.
	GetConnector(ctx context.Context, in *GetConnectorRequest, opts ...grpc.CallOption) (*Connector, error)
	// Creates a new connector in a given Connect cluster.
	CreateConnector(ctx context.Context, in *CreateConnectorRequest, opts ...grpc.CallOption) (*Connector, error)
	// Updates the properties of a connector.
	UpdateConnector(ctx context.Context, in *UpdateConnectorRequest, opts ...grpc.CallOption) (*Connector, error)
	// Deletes a connector.
	DeleteConnector(ctx context.Context, in *DeleteConnectorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Pauses the connector and its tasks.
	PauseConnector(ctx context.Context, in *PauseConnectorRequest, opts ...grpc.CallOption) (*PauseConnectorResponse, error)
	// Resumes the connector and its tasks.
	ResumeConnector(ctx context.Context, in *ResumeConnectorRequest, opts ...grpc.CallOption) (*ResumeConnectorResponse, error)
	// Restarts the connector.
	RestartConnector(ctx context.Context, in *RestartConnectorRequest, opts ...grpc.CallOption) (*RestartConnectorResponse, error)
	// Stops the connector.
	StopConnector(ctx context.Context, in *StopConnectorRequest, opts ...grpc.CallOption) (*StopConnectorResponse, error)
}

type managedKafkaConnectClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedKafkaConnectClient(cc grpc.ClientConnInterface) ManagedKafkaConnectClient {
	return &managedKafkaConnectClient{cc}
}

func (c *managedKafkaConnectClient) ListConnectClusters(ctx context.Context, in *ListConnectClustersRequest, opts ...grpc.CallOption) (*ListConnectClustersResponse, error) {
	out := new(ListConnectClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/ListConnectClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) GetConnectCluster(ctx context.Context, in *GetConnectClusterRequest, opts ...grpc.CallOption) (*ConnectCluster, error) {
	out := new(ConnectCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/GetConnectCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) CreateConnectCluster(ctx context.Context, in *CreateConnectClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/CreateConnectCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) UpdateConnectCluster(ctx context.Context, in *UpdateConnectClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/UpdateConnectCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) DeleteConnectCluster(ctx context.Context, in *DeleteConnectClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/DeleteConnectCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) ListConnectors(ctx context.Context, in *ListConnectorsRequest, opts ...grpc.CallOption) (*ListConnectorsResponse, error) {
	out := new(ListConnectorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/ListConnectors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) GetConnector(ctx context.Context, in *GetConnectorRequest, opts ...grpc.CallOption) (*Connector, error) {
	out := new(Connector)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/GetConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) CreateConnector(ctx context.Context, in *CreateConnectorRequest, opts ...grpc.CallOption) (*Connector, error) {
	out := new(Connector)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/CreateConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) UpdateConnector(ctx context.Context, in *UpdateConnectorRequest, opts ...grpc.CallOption) (*Connector, error) {
	out := new(Connector)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/UpdateConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) DeleteConnector(ctx context.Context, in *DeleteConnectorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/DeleteConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) PauseConnector(ctx context.Context, in *PauseConnectorRequest, opts ...grpc.CallOption) (*PauseConnectorResponse, error) {
	out := new(PauseConnectorResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/PauseConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) ResumeConnector(ctx context.Context, in *ResumeConnectorRequest, opts ...grpc.CallOption) (*ResumeConnectorResponse, error) {
	out := new(ResumeConnectorResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/ResumeConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) RestartConnector(ctx context.Context, in *RestartConnectorRequest, opts ...grpc.CallOption) (*RestartConnectorResponse, error) {
	out := new(RestartConnectorResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/RestartConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedKafkaConnectClient) StopConnector(ctx context.Context, in *StopConnectorRequest, opts ...grpc.CallOption) (*StopConnectorResponse, error) {
	out := new(StopConnectorResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedkafka.v1.ManagedKafkaConnect/StopConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedKafkaConnectServer is the server API for ManagedKafkaConnect service.
type ManagedKafkaConnectServer interface {
	// Lists the Kafka Connect clusters in a given project and location.
	ListConnectClusters(context.Context, *ListConnectClustersRequest) (*ListConnectClustersResponse, error)
	// Returns the properties of a single Kafka Connect cluster.
	GetConnectCluster(context.Context, *GetConnectClusterRequest) (*ConnectCluster, error)
	// Creates a new Kafka Connect cluster in a given project and location.
	CreateConnectCluster(context.Context, *CreateConnectClusterRequest) (*longrunningpb.Operation, error)
	// Updates the properties of a single Kafka Connect cluster.
	UpdateConnectCluster(context.Context, *UpdateConnectClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a single Connect cluster.
	DeleteConnectCluster(context.Context, *DeleteConnectClusterRequest) (*longrunningpb.Operation, error)
	// Lists the connectors in a given Connect cluster.
	ListConnectors(context.Context, *ListConnectorsRequest) (*ListConnectorsResponse, error)
	// Returns the properties of a single connector.
	GetConnector(context.Context, *GetConnectorRequest) (*Connector, error)
	// Creates a new connector in a given Connect cluster.
	CreateConnector(context.Context, *CreateConnectorRequest) (*Connector, error)
	// Updates the properties of a connector.
	UpdateConnector(context.Context, *UpdateConnectorRequest) (*Connector, error)
	// Deletes a connector.
	DeleteConnector(context.Context, *DeleteConnectorRequest) (*emptypb.Empty, error)
	// Pauses the connector and its tasks.
	PauseConnector(context.Context, *PauseConnectorRequest) (*PauseConnectorResponse, error)
	// Resumes the connector and its tasks.
	ResumeConnector(context.Context, *ResumeConnectorRequest) (*ResumeConnectorResponse, error)
	// Restarts the connector.
	RestartConnector(context.Context, *RestartConnectorRequest) (*RestartConnectorResponse, error)
	// Stops the connector.
	StopConnector(context.Context, *StopConnectorRequest) (*StopConnectorResponse, error)
}

// UnimplementedManagedKafkaConnectServer can be embedded to have forward compatible implementations.
type UnimplementedManagedKafkaConnectServer struct {
}

func (*UnimplementedManagedKafkaConnectServer) ListConnectClusters(context.Context, *ListConnectClustersRequest) (*ListConnectClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectClusters not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) GetConnectCluster(context.Context, *GetConnectClusterRequest) (*ConnectCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectCluster not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) CreateConnectCluster(context.Context, *CreateConnectClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectCluster not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) UpdateConnectCluster(context.Context, *UpdateConnectClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectCluster not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) DeleteConnectCluster(context.Context, *DeleteConnectClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectCluster not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) ListConnectors(context.Context, *ListConnectorsRequest) (*ListConnectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectors not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) GetConnector(context.Context, *GetConnectorRequest) (*Connector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) CreateConnector(context.Context, *CreateConnectorRequest) (*Connector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) UpdateConnector(context.Context, *UpdateConnectorRequest) (*Connector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) DeleteConnector(context.Context, *DeleteConnectorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) PauseConnector(context.Context, *PauseConnectorRequest) (*PauseConnectorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) ResumeConnector(context.Context, *ResumeConnectorRequest) (*ResumeConnectorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) RestartConnector(context.Context, *RestartConnectorRequest) (*RestartConnectorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartConnector not implemented")
}
func (*UnimplementedManagedKafkaConnectServer) StopConnector(context.Context, *StopConnectorRequest) (*StopConnectorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopConnector not implemented")
}

func RegisterManagedKafkaConnectServer(s *grpc.Server, srv ManagedKafkaConnectServer) {
	s.RegisterService(&_ManagedKafkaConnect_serviceDesc, srv)
}

func _ManagedKafkaConnect_ListConnectClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).ListConnectClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/ListConnectClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).ListConnectClusters(ctx, req.(*ListConnectClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_GetConnectCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).GetConnectCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/GetConnectCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).GetConnectCluster(ctx, req.(*GetConnectClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_CreateConnectCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).CreateConnectCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/CreateConnectCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).CreateConnectCluster(ctx, req.(*CreateConnectClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_UpdateConnectCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).UpdateConnectCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/UpdateConnectCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).UpdateConnectCluster(ctx, req.(*UpdateConnectClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_DeleteConnectCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).DeleteConnectCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/DeleteConnectCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).DeleteConnectCluster(ctx, req.(*DeleteConnectClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_ListConnectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).ListConnectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/ListConnectors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).ListConnectors(ctx, req.(*ListConnectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_GetConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).GetConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/GetConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).GetConnector(ctx, req.(*GetConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_CreateConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).CreateConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/CreateConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).CreateConnector(ctx, req.(*CreateConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_UpdateConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).UpdateConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/UpdateConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).UpdateConnector(ctx, req.(*UpdateConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_DeleteConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).DeleteConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/DeleteConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).DeleteConnector(ctx, req.(*DeleteConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_PauseConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).PauseConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/PauseConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).PauseConnector(ctx, req.(*PauseConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_ResumeConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).ResumeConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/ResumeConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).ResumeConnector(ctx, req.(*ResumeConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_RestartConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).RestartConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/RestartConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).RestartConnector(ctx, req.(*RestartConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedKafkaConnect_StopConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedKafkaConnectServer).StopConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedkafka.v1.ManagedKafkaConnect/StopConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedKafkaConnectServer).StopConnector(ctx, req.(*StopConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ManagedKafkaConnect_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.managedkafka.v1.ManagedKafkaConnect",
	HandlerType: (*ManagedKafkaConnectServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConnectClusters",
			Handler:    _ManagedKafkaConnect_ListConnectClusters_Handler,
		},
		{
			MethodName: "GetConnectCluster",
			Handler:    _ManagedKafkaConnect_GetConnectCluster_Handler,
		},
		{
			MethodName: "CreateConnectCluster",
			Handler:    _ManagedKafkaConnect_CreateConnectCluster_Handler,
		},
		{
			MethodName: "UpdateConnectCluster",
			Handler:    _ManagedKafkaConnect_UpdateConnectCluster_Handler,
		},
		{
			MethodName: "DeleteConnectCluster",
			Handler:    _ManagedKafkaConnect_DeleteConnectCluster_Handler,
		},
		{
			MethodName: "ListConnectors",
			Handler:    _ManagedKafkaConnect_ListConnectors_Handler,
		},
		{
			MethodName: "GetConnector",
			Handler:    _ManagedKafkaConnect_GetConnector_Handler,
		},
		{
			MethodName: "CreateConnector",
			Handler:    _ManagedKafkaConnect_CreateConnector_Handler,
		},
		{
			MethodName: "UpdateConnector",
			Handler:    _ManagedKafkaConnect_UpdateConnector_Handler,
		},
		{
			MethodName: "DeleteConnector",
			Handler:    _ManagedKafkaConnect_DeleteConnector_Handler,
		},
		{
			MethodName: "PauseConnector",
			Handler:    _ManagedKafkaConnect_PauseConnector_Handler,
		},
		{
			MethodName: "ResumeConnector",
			Handler:    _ManagedKafkaConnect_ResumeConnector_Handler,
		},
		{
			MethodName: "RestartConnector",
			Handler:    _ManagedKafkaConnect_RestartConnector_Handler,
		},
		{
			MethodName: "StopConnector",
			Handler:    _ManagedKafkaConnect_StopConnector_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/managedkafka/v1/managed_kafka_connect.proto",
}
