// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package identitytoolkit

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	identitytoolkitpb "cloud.google.com/go/identitytoolkit/apiv2/identitytoolkitpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
)

var newAccountManagementClientHook clientHook

// AccountManagementCallOptions contains the retry settings for each method of AccountManagementClient.
type AccountManagementCallOptions struct {
	FinalizeMfaEnrollment []gax.CallOption
	StartMfaEnrollment    []gax.CallOption
	WithdrawMfa           []gax.CallOption
}

func defaultAccountManagementGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("identitytoolkit.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("identitytoolkit.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("identitytoolkit.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://identitytoolkit.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAccountManagementCallOptions() *AccountManagementCallOptions {
	return &AccountManagementCallOptions{
		FinalizeMfaEnrollment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMfaEnrollment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		WithdrawMfa: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

func defaultAccountManagementRESTCallOptions() *AccountManagementCallOptions {
	return &AccountManagementCallOptions{
		FinalizeMfaEnrollment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMfaEnrollment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		WithdrawMfa: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

// internalAccountManagementClient is an interface that defines the methods available from Identity Toolkit API.
type internalAccountManagementClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	FinalizeMfaEnrollment(context.Context, *identitytoolkitpb.FinalizeMfaEnrollmentRequest, ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaEnrollmentResponse, error)
	StartMfaEnrollment(context.Context, *identitytoolkitpb.StartMfaEnrollmentRequest, ...gax.CallOption) (*identitytoolkitpb.StartMfaEnrollmentResponse, error)
	WithdrawMfa(context.Context, *identitytoolkitpb.WithdrawMfaRequest, ...gax.CallOption) (*identitytoolkitpb.WithdrawMfaResponse, error)
}

// AccountManagementClient is a client for interacting with Identity Toolkit API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Account management for Identity Toolkit
type AccountManagementClient struct {
	// The internal transport-dependent client.
	internalClient internalAccountManagementClient

	// The call options for this service.
	CallOptions *AccountManagementCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AccountManagementClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AccountManagementClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AccountManagementClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// FinalizeMfaEnrollment finishes enrolling a second factor for the user.
func (c *AccountManagementClient) FinalizeMfaEnrollment(ctx context.Context, req *identitytoolkitpb.FinalizeMfaEnrollmentRequest, opts ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaEnrollmentResponse, error) {
	return c.internalClient.FinalizeMfaEnrollment(ctx, req, opts...)
}

// StartMfaEnrollment step one of the MFA enrollment process. In SMS case, this sends an
// SMS verification code to the user.
func (c *AccountManagementClient) StartMfaEnrollment(ctx context.Context, req *identitytoolkitpb.StartMfaEnrollmentRequest, opts ...gax.CallOption) (*identitytoolkitpb.StartMfaEnrollmentResponse, error) {
	return c.internalClient.StartMfaEnrollment(ctx, req, opts...)
}

// WithdrawMfa revokes one second factor from the enrolled second factors for an account.
func (c *AccountManagementClient) WithdrawMfa(ctx context.Context, req *identitytoolkitpb.WithdrawMfaRequest, opts ...gax.CallOption) (*identitytoolkitpb.WithdrawMfaResponse, error) {
	return c.internalClient.WithdrawMfa(ctx, req, opts...)
}

// accountManagementGRPCClient is a client for interacting with Identity Toolkit API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type accountManagementGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AccountManagementClient
	CallOptions **AccountManagementCallOptions

	// The gRPC API client.
	accountManagementClient identitytoolkitpb.AccountManagementServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewAccountManagementClient creates a new account management service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Account management for Identity Toolkit
func NewAccountManagementClient(ctx context.Context, opts ...option.ClientOption) (*AccountManagementClient, error) {
	clientOpts := defaultAccountManagementGRPCClientOptions()
	if newAccountManagementClientHook != nil {
		hookOpts, err := newAccountManagementClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AccountManagementClient{CallOptions: defaultAccountManagementCallOptions()}

	c := &accountManagementGRPCClient{
		connPool:                connPool,
		accountManagementClient: identitytoolkitpb.NewAccountManagementServiceClient(connPool),
		CallOptions:             &client.CallOptions,
		logger:                  internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *accountManagementGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *accountManagementGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *accountManagementGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type accountManagementRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing AccountManagementClient
	CallOptions **AccountManagementCallOptions

	logger *slog.Logger
}

// NewAccountManagementRESTClient creates a new account management service rest client.
//
// Account management for Identity Toolkit
func NewAccountManagementRESTClient(ctx context.Context, opts ...option.ClientOption) (*AccountManagementClient, error) {
	clientOpts := append(defaultAccountManagementRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultAccountManagementRESTCallOptions()
	c := &accountManagementRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &AccountManagementClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultAccountManagementRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://identitytoolkit.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://identitytoolkit.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://identitytoolkit.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://identitytoolkit.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *accountManagementRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *accountManagementRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *accountManagementRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *accountManagementGRPCClient) FinalizeMfaEnrollment(ctx context.Context, req *identitytoolkitpb.FinalizeMfaEnrollmentRequest, opts ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaEnrollmentResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).FinalizeMfaEnrollment[0:len((*c.CallOptions).FinalizeMfaEnrollment):len((*c.CallOptions).FinalizeMfaEnrollment)], opts...)
	var resp *identitytoolkitpb.FinalizeMfaEnrollmentResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.accountManagementClient.FinalizeMfaEnrollment, req, settings.GRPC, c.logger, "FinalizeMfaEnrollment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *accountManagementGRPCClient) StartMfaEnrollment(ctx context.Context, req *identitytoolkitpb.StartMfaEnrollmentRequest, opts ...gax.CallOption) (*identitytoolkitpb.StartMfaEnrollmentResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).StartMfaEnrollment[0:len((*c.CallOptions).StartMfaEnrollment):len((*c.CallOptions).StartMfaEnrollment)], opts...)
	var resp *identitytoolkitpb.StartMfaEnrollmentResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.accountManagementClient.StartMfaEnrollment, req, settings.GRPC, c.logger, "StartMfaEnrollment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *accountManagementGRPCClient) WithdrawMfa(ctx context.Context, req *identitytoolkitpb.WithdrawMfaRequest, opts ...gax.CallOption) (*identitytoolkitpb.WithdrawMfaResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).WithdrawMfa[0:len((*c.CallOptions).WithdrawMfa):len((*c.CallOptions).WithdrawMfa)], opts...)
	var resp *identitytoolkitpb.WithdrawMfaResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.accountManagementClient.WithdrawMfa, req, settings.GRPC, c.logger, "WithdrawMfa")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// FinalizeMfaEnrollment finishes enrolling a second factor for the user.
func (c *accountManagementRESTClient) FinalizeMfaEnrollment(ctx context.Context, req *identitytoolkitpb.FinalizeMfaEnrollmentRequest, opts ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaEnrollmentResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/accounts/mfaEnrollment:finalize")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).FinalizeMfaEnrollment[0:len((*c.CallOptions).FinalizeMfaEnrollment):len((*c.CallOptions).FinalizeMfaEnrollment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &identitytoolkitpb.FinalizeMfaEnrollmentResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "FinalizeMfaEnrollment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// StartMfaEnrollment step one of the MFA enrollment process. In SMS case, this sends an
// SMS verification code to the user.
func (c *accountManagementRESTClient) StartMfaEnrollment(ctx context.Context, req *identitytoolkitpb.StartMfaEnrollmentRequest, opts ...gax.CallOption) (*identitytoolkitpb.StartMfaEnrollmentResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/accounts/mfaEnrollment:start")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).StartMfaEnrollment[0:len((*c.CallOptions).StartMfaEnrollment):len((*c.CallOptions).StartMfaEnrollment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &identitytoolkitpb.StartMfaEnrollmentResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "StartMfaEnrollment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// WithdrawMfa revokes one second factor from the enrolled second factors for an account.
func (c *accountManagementRESTClient) WithdrawMfa(ctx context.Context, req *identitytoolkitpb.WithdrawMfaRequest, opts ...gax.CallOption) (*identitytoolkitpb.WithdrawMfaResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/accounts/mfaEnrollment:withdraw")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).WithdrawMfa[0:len((*c.CallOptions).WithdrawMfa):len((*c.CallOptions).WithdrawMfa)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &identitytoolkitpb.WithdrawMfaResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "WithdrawMfa")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
