// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/financialservices/v1/engine_version.proto

package financialservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State determines the lifecycle of a version and the models/engine configs
// trained with it.
type EngineVersion_State int32

const (
	// Default state, should never be used.
	EngineVersion_STATE_UNSPECIFIED EngineVersion_State = 0
	// Version is available for training and inference.
	EngineVersion_ACTIVE EngineVersion_State = 1
	// Models using this version can still be run, but new ones cannot be
	// trained.
	EngineVersion_LIMITED EngineVersion_State = 2
	// Version is deprecated, listed for informational purposes only.
	EngineVersion_DECOMMISSIONED EngineVersion_State = 3
)

// Enum value maps for EngineVersion_State.
var (
	EngineVersion_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "LIMITED",
		3: "DECOMMISSIONED",
	}
	EngineVersion_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"LIMITED":           2,
		"DECOMMISSIONED":    3,
	}
)

func (x EngineVersion_State) Enum() *EngineVersion_State {
	p := new(EngineVersion_State)
	*p = x
	return p
}

func (x EngineVersion_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EngineVersion_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_financialservices_v1_engine_version_proto_enumTypes[0].Descriptor()
}

func (EngineVersion_State) Type() protoreflect.EnumType {
	return &file_google_cloud_financialservices_v1_engine_version_proto_enumTypes[0]
}

func (x EngineVersion_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EngineVersion_State.Descriptor instead.
func (EngineVersion_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_version_proto_rawDescGZIP(), []int{0, 0}
}

// EngineVersion controls which version of the engine is used to tune, train,
// and run the model.
type EngineVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the EngineVersion
	// format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The state of the version.
	State EngineVersion_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.financialservices.v1.EngineVersion_State" json:"state,omitempty"`
	// Output only. Planned time to stop allowing training/tuning using this
	// version. Existing trained models can still be used for prediction/backtest.
	ExpectedLimitationStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expected_limitation_start_time,json=expectedLimitationStartTime,proto3" json:"expected_limitation_start_time,omitempty"`
	// Output only. Planned time to stop supporting the version, in addition
	// to no training or tuning, models trained on this version
	// can no longer be used for prediction/backtest.
	ExpectedDecommissionTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expected_decommission_time,json=expectedDecommissionTime,proto3" json:"expected_decommission_time,omitempty"`
	// Output only. The line of business (Retail/Commercial) this engine version
	// is used for.
	LineOfBusiness LineOfBusiness `protobuf:"varint,5,opt,name=line_of_business,json=lineOfBusiness,proto3,enum=google.cloud.financialservices.v1.LineOfBusiness" json:"line_of_business,omitempty"`
}

func (x *EngineVersion) Reset() {
	*x = EngineVersion{}
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EngineVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EngineVersion) ProtoMessage() {}

func (x *EngineVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EngineVersion.ProtoReflect.Descriptor instead.
func (*EngineVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_version_proto_rawDescGZIP(), []int{0}
}

func (x *EngineVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EngineVersion) GetState() EngineVersion_State {
	if x != nil {
		return x.State
	}
	return EngineVersion_STATE_UNSPECIFIED
}

func (x *EngineVersion) GetExpectedLimitationStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpectedLimitationStartTime
	}
	return nil
}

func (x *EngineVersion) GetExpectedDecommissionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpectedDecommissionTime
	}
	return nil
}

func (x *EngineVersion) GetLineOfBusiness() LineOfBusiness {
	if x != nil {
		return x.LineOfBusiness
	}
	return LineOfBusiness_LINE_OF_BUSINESS_UNSPECIFIED
}

// Request for retrieving a paginated list of EngineVersion resources that meet
// the specified criteria.
type ListEngineVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the EngineVersion is the Instance.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The number of resources to be included in the response. The
	// response contains a next_page_token, which can be used to retrieve the next
	// page of resources.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. In case of paginated results, this is the token that was returned
	// in the previous ListEngineVersionsResponse. It should be copied here to
	// retrieve the next page of resources. Empty will give the first page of
	// ListEngineVersionsRequest, and the last page will return an empty
	// page_token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Specify a filter to narrow search results.
	// If empty or unset will default to "state!=DEPRECATED",
	// to view deprecated versions use "state:*" or any other filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify a field to use for ordering.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEngineVersionsRequest) Reset() {
	*x = ListEngineVersionsRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEngineVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEngineVersionsRequest) ProtoMessage() {}

func (x *ListEngineVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEngineVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListEngineVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_version_proto_rawDescGZIP(), []int{1}
}

func (x *ListEngineVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEngineVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEngineVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEngineVersionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEngineVersionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response to a list call containing the list of engine versions.
type ListEngineVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of EngineVersion resources
	EngineVersions []*EngineVersion `protobuf:"bytes,1,rep,name=engine_versions,json=engineVersions,proto3" json:"engine_versions,omitempty"`
	// This token should be passed to the next EngineVersionsRequest to retrieve
	// the next page of EngineVersions (empty indicates we are done).
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListEngineVersionsResponse) Reset() {
	*x = ListEngineVersionsResponse{}
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEngineVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEngineVersionsResponse) ProtoMessage() {}

func (x *ListEngineVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEngineVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListEngineVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_version_proto_rawDescGZIP(), []int{2}
}

func (x *ListEngineVersionsResponse) GetEngineVersions() []*EngineVersion {
	if x != nil {
		return x.EngineVersions
	}
	return nil
}

func (x *ListEngineVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEngineVersionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for retrieving a specific EngineVersion resource.
type GetEngineVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EngineVersion
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEngineVersionRequest) Reset() {
	*x = GetEngineVersionRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEngineVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEngineVersionRequest) ProtoMessage() {}

func (x *GetEngineVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_version_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEngineVersionRequest.ProtoReflect.Descriptor instead.
func (*GetEngineVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_version_proto_rawDescGZIP(), []int{3}
}

func (x *GetEngineVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_financialservices_v1_engine_version_proto protoreflect.FileDescriptor

var file_google_cloud_financialservices_v1_engine_version_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x6f, 0x66, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x8b, 0x05, 0x0a, 0x0d, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x64, 0x0a, 0x1e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x65, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x1a, 0x65, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18,
	0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x6f, 0x66, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x4f, 0x66, 0x42, 0x75, 0x73,
	0x69, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x65,
	0x4f, 0x66, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x22, 0x4b, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x96, 0x01, 0xea, 0x41, 0x92, 0x01, 0x0a, 0x2e,
	0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x60,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d,
	0x22, 0xe9, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc1, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x0f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x65, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x30, 0x0a, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x92, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x42, 0x12, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_financialservices_v1_engine_version_proto_rawDescOnce sync.Once
	file_google_cloud_financialservices_v1_engine_version_proto_rawDescData = file_google_cloud_financialservices_v1_engine_version_proto_rawDesc
)

func file_google_cloud_financialservices_v1_engine_version_proto_rawDescGZIP() []byte {
	file_google_cloud_financialservices_v1_engine_version_proto_rawDescOnce.Do(func() {
		file_google_cloud_financialservices_v1_engine_version_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_financialservices_v1_engine_version_proto_rawDescData)
	})
	return file_google_cloud_financialservices_v1_engine_version_proto_rawDescData
}

var file_google_cloud_financialservices_v1_engine_version_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_financialservices_v1_engine_version_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_financialservices_v1_engine_version_proto_goTypes = []any{
	(EngineVersion_State)(0),           // 0: google.cloud.financialservices.v1.EngineVersion.State
	(*EngineVersion)(nil),              // 1: google.cloud.financialservices.v1.EngineVersion
	(*ListEngineVersionsRequest)(nil),  // 2: google.cloud.financialservices.v1.ListEngineVersionsRequest
	(*ListEngineVersionsResponse)(nil), // 3: google.cloud.financialservices.v1.ListEngineVersionsResponse
	(*GetEngineVersionRequest)(nil),    // 4: google.cloud.financialservices.v1.GetEngineVersionRequest
	(*timestamppb.Timestamp)(nil),      // 5: google.protobuf.Timestamp
	(LineOfBusiness)(0),                // 6: google.cloud.financialservices.v1.LineOfBusiness
}
var file_google_cloud_financialservices_v1_engine_version_proto_depIdxs = []int32{
	0, // 0: google.cloud.financialservices.v1.EngineVersion.state:type_name -> google.cloud.financialservices.v1.EngineVersion.State
	5, // 1: google.cloud.financialservices.v1.EngineVersion.expected_limitation_start_time:type_name -> google.protobuf.Timestamp
	5, // 2: google.cloud.financialservices.v1.EngineVersion.expected_decommission_time:type_name -> google.protobuf.Timestamp
	6, // 3: google.cloud.financialservices.v1.EngineVersion.line_of_business:type_name -> google.cloud.financialservices.v1.LineOfBusiness
	1, // 4: google.cloud.financialservices.v1.ListEngineVersionsResponse.engine_versions:type_name -> google.cloud.financialservices.v1.EngineVersion
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_financialservices_v1_engine_version_proto_init() }
func file_google_cloud_financialservices_v1_engine_version_proto_init() {
	if File_google_cloud_financialservices_v1_engine_version_proto != nil {
		return
	}
	file_google_cloud_financialservices_v1_line_of_business_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_financialservices_v1_engine_version_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_financialservices_v1_engine_version_proto_goTypes,
		DependencyIndexes: file_google_cloud_financialservices_v1_engine_version_proto_depIdxs,
		EnumInfos:         file_google_cloud_financialservices_v1_engine_version_proto_enumTypes,
		MessageInfos:      file_google_cloud_financialservices_v1_engine_version_proto_msgTypes,
	}.Build()
	File_google_cloud_financialservices_v1_engine_version_proto = out.File
	file_google_cloud_financialservices_v1_engine_version_proto_rawDesc = nil
	file_google_cloud_financialservices_v1_engine_version_proto_goTypes = nil
	file_google_cloud_financialservices_v1_engine_version_proto_depIdxs = nil
}
