// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/dataflow/v1beta3/streaming.proto

package dataflowpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Global topology of the streaming Dataflow job, including all
// computations and their sharded locations.
type TopologyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The computations associated with a streaming Dataflow job.
	Computations []*ComputationTopology `protobuf:"bytes,1,rep,name=computations,proto3" json:"computations,omitempty"`
	// The disks assigned to a streaming Dataflow job.
	DataDiskAssignments []*DataDiskAssignment `protobuf:"bytes,2,rep,name=data_disk_assignments,json=dataDiskAssignments,proto3" json:"data_disk_assignments,omitempty"`
	// Maps user stage names to stable computation names.
	UserStageToComputationNameMap map[string]string `protobuf:"bytes,3,rep,name=user_stage_to_computation_name_map,json=userStageToComputationNameMap,proto3" json:"user_stage_to_computation_name_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The size (in bits) of keys that will be assigned to source messages.
	ForwardingKeyBits int32 `protobuf:"varint,4,opt,name=forwarding_key_bits,json=forwardingKeyBits,proto3" json:"forwarding_key_bits,omitempty"`
	// Version number for persistent state.
	PersistentStateVersion int32 `protobuf:"varint,5,opt,name=persistent_state_version,json=persistentStateVersion,proto3" json:"persistent_state_version,omitempty"`
}

func (x *TopologyConfig) Reset() {
	*x = TopologyConfig{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TopologyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopologyConfig) ProtoMessage() {}

func (x *TopologyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopologyConfig.ProtoReflect.Descriptor instead.
func (*TopologyConfig) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{0}
}

func (x *TopologyConfig) GetComputations() []*ComputationTopology {
	if x != nil {
		return x.Computations
	}
	return nil
}

func (x *TopologyConfig) GetDataDiskAssignments() []*DataDiskAssignment {
	if x != nil {
		return x.DataDiskAssignments
	}
	return nil
}

func (x *TopologyConfig) GetUserStageToComputationNameMap() map[string]string {
	if x != nil {
		return x.UserStageToComputationNameMap
	}
	return nil
}

func (x *TopologyConfig) GetForwardingKeyBits() int32 {
	if x != nil {
		return x.ForwardingKeyBits
	}
	return 0
}

func (x *TopologyConfig) GetPersistentStateVersion() int32 {
	if x != nil {
		return x.PersistentStateVersion
	}
	return 0
}

// Identifies a pubsub location to use for transferring data into or
// out of a streaming Dataflow job.
type PubsubLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A pubsub topic, in the form of
	// "pubsub.googleapis.com/topics/<project-id>/<topic-name>"
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// A pubsub subscription, in the form of
	// "pubsub.googleapis.com/subscriptions/<project-id>/<subscription-name>"
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// If set, contains a pubsub label from which to extract record timestamps.
	// If left empty, record timestamps will be generated upon arrival.
	TimestampLabel string `protobuf:"bytes,3,opt,name=timestamp_label,json=timestampLabel,proto3" json:"timestamp_label,omitempty"`
	// If set, contains a pubsub label from which to extract record ids.
	// If left empty, record deduplication will be strictly best effort.
	IdLabel string `protobuf:"bytes,4,opt,name=id_label,json=idLabel,proto3" json:"id_label,omitempty"`
	// Indicates whether the pipeline allows late-arriving data.
	DropLateData bool `protobuf:"varint,5,opt,name=drop_late_data,json=dropLateData,proto3" json:"drop_late_data,omitempty"`
	// If set, specifies the pubsub subscription that will be used for tracking
	// custom time timestamps for watermark estimation.
	TrackingSubscription string `protobuf:"bytes,6,opt,name=tracking_subscription,json=trackingSubscription,proto3" json:"tracking_subscription,omitempty"`
	// If true, then the client has requested to get pubsub attributes.
	WithAttributes bool `protobuf:"varint,7,opt,name=with_attributes,json=withAttributes,proto3" json:"with_attributes,omitempty"`
}

func (x *PubsubLocation) Reset() {
	*x = PubsubLocation{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PubsubLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubLocation) ProtoMessage() {}

func (x *PubsubLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubLocation.ProtoReflect.Descriptor instead.
func (*PubsubLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{1}
}

func (x *PubsubLocation) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *PubsubLocation) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *PubsubLocation) GetTimestampLabel() string {
	if x != nil {
		return x.TimestampLabel
	}
	return ""
}

func (x *PubsubLocation) GetIdLabel() string {
	if x != nil {
		return x.IdLabel
	}
	return ""
}

func (x *PubsubLocation) GetDropLateData() bool {
	if x != nil {
		return x.DropLateData
	}
	return false
}

func (x *PubsubLocation) GetTrackingSubscription() string {
	if x != nil {
		return x.TrackingSubscription
	}
	return ""
}

func (x *PubsubLocation) GetWithAttributes() bool {
	if x != nil {
		return x.WithAttributes
	}
	return false
}

// Identifies the location of a streaming computation stage, for
// stage-to-stage communication.
type StreamingStageLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the particular stream within the streaming Dataflow
	// job.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
}

func (x *StreamingStageLocation) Reset() {
	*x = StreamingStageLocation{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingStageLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingStageLocation) ProtoMessage() {}

func (x *StreamingStageLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingStageLocation.ProtoReflect.Descriptor instead.
func (*StreamingStageLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{2}
}

func (x *StreamingStageLocation) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

// Identifies the location of a streaming side input.
type StreamingSideInputLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the particular side input within the streaming Dataflow job.
	Tag string `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// Identifies the state family where this side input is stored.
	StateFamily string `protobuf:"bytes,2,opt,name=state_family,json=stateFamily,proto3" json:"state_family,omitempty"`
}

func (x *StreamingSideInputLocation) Reset() {
	*x = StreamingSideInputLocation{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingSideInputLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingSideInputLocation) ProtoMessage() {}

func (x *StreamingSideInputLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingSideInputLocation.ProtoReflect.Descriptor instead.
func (*StreamingSideInputLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{3}
}

func (x *StreamingSideInputLocation) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

func (x *StreamingSideInputLocation) GetStateFamily() string {
	if x != nil {
		return x.StateFamily
	}
	return ""
}

// Identifies the location of a custom souce.
type CustomSourceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether this source is stateful.
	Stateful bool `protobuf:"varint,1,opt,name=stateful,proto3" json:"stateful,omitempty"`
}

func (x *CustomSourceLocation) Reset() {
	*x = CustomSourceLocation{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomSourceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomSourceLocation) ProtoMessage() {}

func (x *CustomSourceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomSourceLocation.ProtoReflect.Descriptor instead.
func (*CustomSourceLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{4}
}

func (x *CustomSourceLocation) GetStateful() bool {
	if x != nil {
		return x.Stateful
	}
	return false
}

// Describes a stream of data, either as input to be processed or as
// output of a streaming Dataflow job.
type StreamLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A specification of a stream's location.
	//
	// Types that are assignable to Location:
	//
	//	*StreamLocation_StreamingStageLocation
	//	*StreamLocation_PubsubLocation
	//	*StreamLocation_SideInputLocation
	//	*StreamLocation_CustomSourceLocation
	Location isStreamLocation_Location `protobuf_oneof:"location"`
}

func (x *StreamLocation) Reset() {
	*x = StreamLocation{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamLocation) ProtoMessage() {}

func (x *StreamLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamLocation.ProtoReflect.Descriptor instead.
func (*StreamLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{5}
}

func (m *StreamLocation) GetLocation() isStreamLocation_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *StreamLocation) GetStreamingStageLocation() *StreamingStageLocation {
	if x, ok := x.GetLocation().(*StreamLocation_StreamingStageLocation); ok {
		return x.StreamingStageLocation
	}
	return nil
}

func (x *StreamLocation) GetPubsubLocation() *PubsubLocation {
	if x, ok := x.GetLocation().(*StreamLocation_PubsubLocation); ok {
		return x.PubsubLocation
	}
	return nil
}

func (x *StreamLocation) GetSideInputLocation() *StreamingSideInputLocation {
	if x, ok := x.GetLocation().(*StreamLocation_SideInputLocation); ok {
		return x.SideInputLocation
	}
	return nil
}

func (x *StreamLocation) GetCustomSourceLocation() *CustomSourceLocation {
	if x, ok := x.GetLocation().(*StreamLocation_CustomSourceLocation); ok {
		return x.CustomSourceLocation
	}
	return nil
}

type isStreamLocation_Location interface {
	isStreamLocation_Location()
}

type StreamLocation_StreamingStageLocation struct {
	// The stream is part of another computation within the current
	// streaming Dataflow job.
	StreamingStageLocation *StreamingStageLocation `protobuf:"bytes,1,opt,name=streaming_stage_location,json=streamingStageLocation,proto3,oneof"`
}

type StreamLocation_PubsubLocation struct {
	// The stream is a pubsub stream.
	PubsubLocation *PubsubLocation `protobuf:"bytes,2,opt,name=pubsub_location,json=pubsubLocation,proto3,oneof"`
}

type StreamLocation_SideInputLocation struct {
	// The stream is a streaming side input.
	SideInputLocation *StreamingSideInputLocation `protobuf:"bytes,3,opt,name=side_input_location,json=sideInputLocation,proto3,oneof"`
}

type StreamLocation_CustomSourceLocation struct {
	// The stream is a custom source.
	CustomSourceLocation *CustomSourceLocation `protobuf:"bytes,4,opt,name=custom_source_location,json=customSourceLocation,proto3,oneof"`
}

func (*StreamLocation_StreamingStageLocation) isStreamLocation_Location() {}

func (*StreamLocation_PubsubLocation) isStreamLocation_Location() {}

func (*StreamLocation_SideInputLocation) isStreamLocation_Location() {}

func (*StreamLocation_CustomSourceLocation) isStreamLocation_Location() {}

// State family configuration.
type StateFamilyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state family value.
	StateFamily string `protobuf:"bytes,1,opt,name=state_family,json=stateFamily,proto3" json:"state_family,omitempty"`
	// If true, this family corresponds to a read operation.
	IsRead bool `protobuf:"varint,2,opt,name=is_read,json=isRead,proto3" json:"is_read,omitempty"`
}

func (x *StateFamilyConfig) Reset() {
	*x = StateFamilyConfig{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateFamilyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateFamilyConfig) ProtoMessage() {}

func (x *StateFamilyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateFamilyConfig.ProtoReflect.Descriptor instead.
func (*StateFamilyConfig) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{6}
}

func (x *StateFamilyConfig) GetStateFamily() string {
	if x != nil {
		return x.StateFamily
	}
	return ""
}

func (x *StateFamilyConfig) GetIsRead() bool {
	if x != nil {
		return x.IsRead
	}
	return false
}

// All configuration data for a particular Computation.
type ComputationTopology struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The system stage name.
	SystemStageName string `protobuf:"bytes,1,opt,name=system_stage_name,json=systemStageName,proto3" json:"system_stage_name,omitempty"`
	// The ID of the computation.
	ComputationId string `protobuf:"bytes,5,opt,name=computation_id,json=computationId,proto3" json:"computation_id,omitempty"`
	// The key ranges processed by the computation.
	KeyRanges []*KeyRangeLocation `protobuf:"bytes,2,rep,name=key_ranges,json=keyRanges,proto3" json:"key_ranges,omitempty"`
	// The inputs to the computation.
	Inputs []*StreamLocation `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// The outputs from the computation.
	Outputs []*StreamLocation `protobuf:"bytes,4,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// The state family values.
	StateFamilies []*StateFamilyConfig `protobuf:"bytes,7,rep,name=state_families,json=stateFamilies,proto3" json:"state_families,omitempty"`
}

func (x *ComputationTopology) Reset() {
	*x = ComputationTopology{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputationTopology) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputationTopology) ProtoMessage() {}

func (x *ComputationTopology) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputationTopology.ProtoReflect.Descriptor instead.
func (*ComputationTopology) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{7}
}

func (x *ComputationTopology) GetSystemStageName() string {
	if x != nil {
		return x.SystemStageName
	}
	return ""
}

func (x *ComputationTopology) GetComputationId() string {
	if x != nil {
		return x.ComputationId
	}
	return ""
}

func (x *ComputationTopology) GetKeyRanges() []*KeyRangeLocation {
	if x != nil {
		return x.KeyRanges
	}
	return nil
}

func (x *ComputationTopology) GetInputs() []*StreamLocation {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *ComputationTopology) GetOutputs() []*StreamLocation {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *ComputationTopology) GetStateFamilies() []*StateFamilyConfig {
	if x != nil {
		return x.StateFamilies
	}
	return nil
}

// Location information for a specific key-range of a sharded computation.
// Currently we only support UTF-8 character splits to simplify encoding into
// JSON.
type KeyRangeLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start (inclusive) of the key range.
	Start string `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// The end (exclusive) of the key range.
	End string `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
	// The physical location of this range assignment to be used for
	// streaming computation cross-worker message delivery.
	DeliveryEndpoint string `protobuf:"bytes,3,opt,name=delivery_endpoint,json=deliveryEndpoint,proto3" json:"delivery_endpoint,omitempty"`
	// The name of the data disk where data for this range is stored.
	// This name is local to the Google Cloud Platform project and uniquely
	// identifies the disk within that project, for example
	// "myproject-1014-104817-4c2-harness-0-disk-1".
	DataDisk string `protobuf:"bytes,5,opt,name=data_disk,json=dataDisk,proto3" json:"data_disk,omitempty"`
	// DEPRECATED. The location of the persistent state for this range, as a
	// persistent directory in the worker local filesystem.
	//
	// Deprecated: Marked as deprecated in google/dataflow/v1beta3/streaming.proto.
	DeprecatedPersistentDirectory string `protobuf:"bytes,4,opt,name=deprecated_persistent_directory,json=deprecatedPersistentDirectory,proto3" json:"deprecated_persistent_directory,omitempty"`
}

func (x *KeyRangeLocation) Reset() {
	*x = KeyRangeLocation{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyRangeLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRangeLocation) ProtoMessage() {}

func (x *KeyRangeLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRangeLocation.ProtoReflect.Descriptor instead.
func (*KeyRangeLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{8}
}

func (x *KeyRangeLocation) GetStart() string {
	if x != nil {
		return x.Start
	}
	return ""
}

func (x *KeyRangeLocation) GetEnd() string {
	if x != nil {
		return x.End
	}
	return ""
}

func (x *KeyRangeLocation) GetDeliveryEndpoint() string {
	if x != nil {
		return x.DeliveryEndpoint
	}
	return ""
}

func (x *KeyRangeLocation) GetDataDisk() string {
	if x != nil {
		return x.DataDisk
	}
	return ""
}

// Deprecated: Marked as deprecated in google/dataflow/v1beta3/streaming.proto.
func (x *KeyRangeLocation) GetDeprecatedPersistentDirectory() string {
	if x != nil {
		return x.DeprecatedPersistentDirectory
	}
	return ""
}

// Describes mounted data disk.
type MountedDataDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the data disk.
	// This name is local to the Google Cloud Platform project and uniquely
	// identifies the disk within that project, for example
	// "myproject-1014-104817-4c2-harness-0-disk-1".
	DataDisk string `protobuf:"bytes,1,opt,name=data_disk,json=dataDisk,proto3" json:"data_disk,omitempty"`
}

func (x *MountedDataDisk) Reset() {
	*x = MountedDataDisk{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MountedDataDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MountedDataDisk) ProtoMessage() {}

func (x *MountedDataDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MountedDataDisk.ProtoReflect.Descriptor instead.
func (*MountedDataDisk) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{9}
}

func (x *MountedDataDisk) GetDataDisk() string {
	if x != nil {
		return x.DataDisk
	}
	return ""
}

// Data disk assignment for a given VM instance.
type DataDiskAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// VM instance name the data disks mounted to, for example
	// "myproject-1014-104817-4c2-harness-0".
	VmInstance string `protobuf:"bytes,1,opt,name=vm_instance,json=vmInstance,proto3" json:"vm_instance,omitempty"`
	// Mounted data disks. The order is important a data disk's 0-based index in
	// this list defines which persistent directory the disk is mounted to, for
	// example the list of { "myproject-1014-104817-4c2-harness-0-disk-0" },
	// { "myproject-1014-104817-4c2-harness-0-disk-1" }.
	DataDisks []string `protobuf:"bytes,2,rep,name=data_disks,json=dataDisks,proto3" json:"data_disks,omitempty"`
}

func (x *DataDiskAssignment) Reset() {
	*x = DataDiskAssignment{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDiskAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDiskAssignment) ProtoMessage() {}

func (x *DataDiskAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDiskAssignment.ProtoReflect.Descriptor instead.
func (*DataDiskAssignment) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{10}
}

func (x *DataDiskAssignment) GetVmInstance() string {
	if x != nil {
		return x.VmInstance
	}
	return ""
}

func (x *DataDiskAssignment) GetDataDisks() []string {
	if x != nil {
		return x.DataDisks
	}
	return nil
}

// Data disk assignment information for a specific key-range of a sharded
// computation.
// Currently we only support UTF-8 character splits to simplify encoding into
// JSON.
type KeyRangeDataDiskAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start (inclusive) of the key range.
	Start string `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// The end (exclusive) of the key range.
	End string `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
	// The name of the data disk where data for this range is stored.
	// This name is local to the Google Cloud Platform project and uniquely
	// identifies the disk within that project, for example
	// "myproject-1014-104817-4c2-harness-0-disk-1".
	DataDisk string `protobuf:"bytes,3,opt,name=data_disk,json=dataDisk,proto3" json:"data_disk,omitempty"`
}

func (x *KeyRangeDataDiskAssignment) Reset() {
	*x = KeyRangeDataDiskAssignment{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyRangeDataDiskAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRangeDataDiskAssignment) ProtoMessage() {}

func (x *KeyRangeDataDiskAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRangeDataDiskAssignment.ProtoReflect.Descriptor instead.
func (*KeyRangeDataDiskAssignment) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{11}
}

func (x *KeyRangeDataDiskAssignment) GetStart() string {
	if x != nil {
		return x.Start
	}
	return ""
}

func (x *KeyRangeDataDiskAssignment) GetEnd() string {
	if x != nil {
		return x.End
	}
	return ""
}

func (x *KeyRangeDataDiskAssignment) GetDataDisk() string {
	if x != nil {
		return x.DataDisk
	}
	return ""
}

// Describes full or partial data disk assignment information of the computation
// ranges.
type StreamingComputationRanges struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the computation.
	ComputationId string `protobuf:"bytes,1,opt,name=computation_id,json=computationId,proto3" json:"computation_id,omitempty"`
	// Data disk assignments for ranges from this computation.
	RangeAssignments []*KeyRangeDataDiskAssignment `protobuf:"bytes,2,rep,name=range_assignments,json=rangeAssignments,proto3" json:"range_assignments,omitempty"`
}

func (x *StreamingComputationRanges) Reset() {
	*x = StreamingComputationRanges{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingComputationRanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingComputationRanges) ProtoMessage() {}

func (x *StreamingComputationRanges) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingComputationRanges.ProtoReflect.Descriptor instead.
func (*StreamingComputationRanges) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{12}
}

func (x *StreamingComputationRanges) GetComputationId() string {
	if x != nil {
		return x.ComputationId
	}
	return ""
}

func (x *StreamingComputationRanges) GetRangeAssignments() []*KeyRangeDataDiskAssignment {
	if x != nil {
		return x.RangeAssignments
	}
	return nil
}

// Streaming appliance snapshot configuration.
type StreamingApplianceSnapshotConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, indicates the snapshot id for the snapshot being performed.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Indicates which endpoint is used to import appliance state.
	ImportStateEndpoint string `protobuf:"bytes,2,opt,name=import_state_endpoint,json=importStateEndpoint,proto3" json:"import_state_endpoint,omitempty"`
}

func (x *StreamingApplianceSnapshotConfig) Reset() {
	*x = StreamingApplianceSnapshotConfig{}
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingApplianceSnapshotConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingApplianceSnapshotConfig) ProtoMessage() {}

func (x *StreamingApplianceSnapshotConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_streaming_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingApplianceSnapshotConfig.ProtoReflect.Descriptor instead.
func (*StreamingApplianceSnapshotConfig) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP(), []int{13}
}

func (x *StreamingApplianceSnapshotConfig) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

func (x *StreamingApplianceSnapshotConfig) GetImportStateEndpoint() string {
	if x != nil {
		return x.ImportStateEndpoint
	}
	return ""
}

var File_google_dataflow_v1beta3_streaming_proto protoreflect.FileDescriptor

var file_google_dataflow_v1beta3_streaming_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x22, 0x97, 0x04, 0x0a, 0x0e, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x15, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x13, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x95, 0x01, 0x0a, 0x22, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x55,
	0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x1d, 0x75, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70,
	0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x42, 0x69, 0x74, 0x73,
	0x12, 0x38, 0x0a, 0x18, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x16, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x50, 0x0a, 0x22, 0x55, 0x73,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x92, 0x02, 0x0a,
	0x0e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x24, 0x0a,
	0x0e, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x72, 0x6f, 0x70, 0x4c, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x33, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x69, 0x74, 0x68,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x77, 0x69, 0x74, 0x68, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x22, 0x35, 0x0a, 0x16, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x22, 0x51, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x22, 0x32, 0x0a, 0x14, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6c, 0x22,
	0xab, 0x03, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x52, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x13, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x73, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x16, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x0a,
	0x11, 0x53, 0x74, 0x61, 0x74, 0x65, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x46,
	0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x52, 0x65, 0x61, 0x64, 0x22, 0x89,
	0x03, 0x0a, 0x13, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x73, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x74, 0x61, 0x67, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x0a, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x46,
	0x61, 0x6d, 0x69, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x10, 0x4b,
	0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73,
	0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73,
	0x6b, 0x12, 0x4a, 0x0a, 0x1f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1d,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x2e, 0x0a,
	0x0f, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b,
	0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x22, 0x54, 0x0a,
	0x12, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x76, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73,
	0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69,
	0x73, 0x6b, 0x73, 0x22, 0x61, 0x0a, 0x1a, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x22, 0xa5, 0x01, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x11,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69,
	0x73, 0x6b, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x77,
	0x0a, 0x20, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0xd1, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x42, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_dataflow_v1beta3_streaming_proto_rawDescOnce sync.Once
	file_google_dataflow_v1beta3_streaming_proto_rawDescData = file_google_dataflow_v1beta3_streaming_proto_rawDesc
)

func file_google_dataflow_v1beta3_streaming_proto_rawDescGZIP() []byte {
	file_google_dataflow_v1beta3_streaming_proto_rawDescOnce.Do(func() {
		file_google_dataflow_v1beta3_streaming_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_dataflow_v1beta3_streaming_proto_rawDescData)
	})
	return file_google_dataflow_v1beta3_streaming_proto_rawDescData
}

var file_google_dataflow_v1beta3_streaming_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_dataflow_v1beta3_streaming_proto_goTypes = []any{
	(*TopologyConfig)(nil),                   // 0: google.dataflow.v1beta3.TopologyConfig
	(*PubsubLocation)(nil),                   // 1: google.dataflow.v1beta3.PubsubLocation
	(*StreamingStageLocation)(nil),           // 2: google.dataflow.v1beta3.StreamingStageLocation
	(*StreamingSideInputLocation)(nil),       // 3: google.dataflow.v1beta3.StreamingSideInputLocation
	(*CustomSourceLocation)(nil),             // 4: google.dataflow.v1beta3.CustomSourceLocation
	(*StreamLocation)(nil),                   // 5: google.dataflow.v1beta3.StreamLocation
	(*StateFamilyConfig)(nil),                // 6: google.dataflow.v1beta3.StateFamilyConfig
	(*ComputationTopology)(nil),              // 7: google.dataflow.v1beta3.ComputationTopology
	(*KeyRangeLocation)(nil),                 // 8: google.dataflow.v1beta3.KeyRangeLocation
	(*MountedDataDisk)(nil),                  // 9: google.dataflow.v1beta3.MountedDataDisk
	(*DataDiskAssignment)(nil),               // 10: google.dataflow.v1beta3.DataDiskAssignment
	(*KeyRangeDataDiskAssignment)(nil),       // 11: google.dataflow.v1beta3.KeyRangeDataDiskAssignment
	(*StreamingComputationRanges)(nil),       // 12: google.dataflow.v1beta3.StreamingComputationRanges
	(*StreamingApplianceSnapshotConfig)(nil), // 13: google.dataflow.v1beta3.StreamingApplianceSnapshotConfig
	nil,                                      // 14: google.dataflow.v1beta3.TopologyConfig.UserStageToComputationNameMapEntry
}
var file_google_dataflow_v1beta3_streaming_proto_depIdxs = []int32{
	7,  // 0: google.dataflow.v1beta3.TopologyConfig.computations:type_name -> google.dataflow.v1beta3.ComputationTopology
	10, // 1: google.dataflow.v1beta3.TopologyConfig.data_disk_assignments:type_name -> google.dataflow.v1beta3.DataDiskAssignment
	14, // 2: google.dataflow.v1beta3.TopologyConfig.user_stage_to_computation_name_map:type_name -> google.dataflow.v1beta3.TopologyConfig.UserStageToComputationNameMapEntry
	2,  // 3: google.dataflow.v1beta3.StreamLocation.streaming_stage_location:type_name -> google.dataflow.v1beta3.StreamingStageLocation
	1,  // 4: google.dataflow.v1beta3.StreamLocation.pubsub_location:type_name -> google.dataflow.v1beta3.PubsubLocation
	3,  // 5: google.dataflow.v1beta3.StreamLocation.side_input_location:type_name -> google.dataflow.v1beta3.StreamingSideInputLocation
	4,  // 6: google.dataflow.v1beta3.StreamLocation.custom_source_location:type_name -> google.dataflow.v1beta3.CustomSourceLocation
	8,  // 7: google.dataflow.v1beta3.ComputationTopology.key_ranges:type_name -> google.dataflow.v1beta3.KeyRangeLocation
	5,  // 8: google.dataflow.v1beta3.ComputationTopology.inputs:type_name -> google.dataflow.v1beta3.StreamLocation
	5,  // 9: google.dataflow.v1beta3.ComputationTopology.outputs:type_name -> google.dataflow.v1beta3.StreamLocation
	6,  // 10: google.dataflow.v1beta3.ComputationTopology.state_families:type_name -> google.dataflow.v1beta3.StateFamilyConfig
	11, // 11: google.dataflow.v1beta3.StreamingComputationRanges.range_assignments:type_name -> google.dataflow.v1beta3.KeyRangeDataDiskAssignment
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_dataflow_v1beta3_streaming_proto_init() }
func file_google_dataflow_v1beta3_streaming_proto_init() {
	if File_google_dataflow_v1beta3_streaming_proto != nil {
		return
	}
	file_google_dataflow_v1beta3_streaming_proto_msgTypes[5].OneofWrappers = []any{
		(*StreamLocation_StreamingStageLocation)(nil),
		(*StreamLocation_PubsubLocation)(nil),
		(*StreamLocation_SideInputLocation)(nil),
		(*StreamLocation_CustomSourceLocation)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_dataflow_v1beta3_streaming_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_dataflow_v1beta3_streaming_proto_goTypes,
		DependencyIndexes: file_google_dataflow_v1beta3_streaming_proto_depIdxs,
		MessageInfos:      file_google_dataflow_v1beta3_streaming_proto_msgTypes,
	}.Build()
	File_google_dataflow_v1beta3_streaming_proto = out.File
	file_google_dataflow_v1beta3_streaming_proto_rawDesc = nil
	file_google_dataflow_v1beta3_streaming_proto_goTypes = nil
	file_google_dataflow_v1beta3_streaming_proto_depIdxs = nil
}
