// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/api/cloudquotas/v1beta/cloudquotas.proto

package cloudquotaspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Message for requesting list of QuotaInfos
type ListQuotaInfosRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value of QuotaInfo resources.
	// Listing across different resource containers (such as 'projects/-') is not
	// allowed.
	//
	// Example names:
	// `projects/123/locations/global/services/compute.googleapis.com`
	// `folders/234/locations/global/services/compute.googleapis.com`
	// `organizations/345/locations/global/services/compute.googleapis.com`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListQuotaInfosRequest) Reset() {
	*x = ListQuotaInfosRequest{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQuotaInfosRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQuotaInfosRequest) ProtoMessage() {}

func (x *ListQuotaInfosRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQuotaInfosRequest.ProtoReflect.Descriptor instead.
func (*ListQuotaInfosRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{0}
}

func (x *ListQuotaInfosRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQuotaInfosRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQuotaInfosRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing QuotaInfos
type ListQuotaInfosResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of QuotaInfo
	QuotaInfos []*QuotaInfo `protobuf:"bytes,1,rep,name=quota_infos,json=quotaInfos,proto3" json:"quota_infos,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListQuotaInfosResponse) Reset() {
	*x = ListQuotaInfosResponse{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQuotaInfosResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQuotaInfosResponse) ProtoMessage() {}

func (x *ListQuotaInfosResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQuotaInfosResponse.ProtoReflect.Descriptor instead.
func (*ListQuotaInfosResponse) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{1}
}

func (x *ListQuotaInfosResponse) GetQuotaInfos() []*QuotaInfo {
	if x != nil {
		return x.QuotaInfos
	}
	return nil
}

func (x *ListQuotaInfosResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a QuotaInfo
type GetQuotaInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the quota info.
	//
	// An example name:
	// `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQuotaInfoRequest) Reset() {
	*x = GetQuotaInfoRequest{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetQuotaInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQuotaInfoRequest) ProtoMessage() {}

func (x *GetQuotaInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQuotaInfoRequest.ProtoReflect.Descriptor instead.
func (*GetQuotaInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{2}
}

func (x *GetQuotaInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting list of QuotaPreferences
type ListQuotaPreferencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value of QuotaPreference resources.
	// Listing across different resource containers (such as 'projects/-') is not
	// allowed.
	//
	// When the value starts with 'folders' or 'organizations', it lists the
	// QuotaPreferences for org quotas in the container. It does not list the
	// QuotaPreferences in the descendant projects of the container.
	//
	// Example parents:
	// `projects/123/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter result QuotaPreferences by their state, type,
	// create/update time range.
	//
	// Example filters:
	// `reconciling=true AND request_type=CLOUD_CONSOLE`,
	// `reconciling=true OR creation_time>2022-12-03T10:30:00`
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. How to order of the results. By default, the results are ordered
	// by create time.
	//
	// Example orders:
	// `quota_id`,
	// `service, create_time`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListQuotaPreferencesRequest) Reset() {
	*x = ListQuotaPreferencesRequest{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQuotaPreferencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQuotaPreferencesRequest) ProtoMessage() {}

func (x *ListQuotaPreferencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQuotaPreferencesRequest.ProtoReflect.Descriptor instead.
func (*ListQuotaPreferencesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{3}
}

func (x *ListQuotaPreferencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQuotaPreferencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQuotaPreferencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListQuotaPreferencesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListQuotaPreferencesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing QuotaPreferences
type ListQuotaPreferencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of QuotaPreference
	QuotaPreferences []*QuotaPreference `protobuf:"bytes,1,rep,name=quota_preferences,json=quotaPreferences,proto3" json:"quota_preferences,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListQuotaPreferencesResponse) Reset() {
	*x = ListQuotaPreferencesResponse{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQuotaPreferencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQuotaPreferencesResponse) ProtoMessage() {}

func (x *ListQuotaPreferencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQuotaPreferencesResponse.ProtoReflect.Descriptor instead.
func (*ListQuotaPreferencesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{4}
}

func (x *ListQuotaPreferencesResponse) GetQuotaPreferences() []*QuotaPreference {
	if x != nil {
		return x.QuotaPreferences
	}
	return nil
}

func (x *ListQuotaPreferencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListQuotaPreferencesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a QuotaPreference
type GetQuotaPreferenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	//
	// Example name:
	// `projects/123/locations/global/quota_preferences/my-config-for-us-east1`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQuotaPreferenceRequest) Reset() {
	*x = GetQuotaPreferenceRequest{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetQuotaPreferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQuotaPreferenceRequest) ProtoMessage() {}

func (x *GetQuotaPreferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQuotaPreferenceRequest.ProtoReflect.Descriptor instead.
func (*GetQuotaPreferenceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{5}
}

func (x *GetQuotaPreferenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a QuotaPreference
type CreateQuotaPreferenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	//
	// Example:
	// `projects/123/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Id of the requesting object, must be unique under its parent.
	// If client does not set this field, the service will generate one.
	QuotaPreferenceId string `protobuf:"bytes,2,opt,name=quota_preference_id,json=quotaPreferenceId,proto3" json:"quota_preference_id,omitempty"`
	// Required. The resource being created
	QuotaPreference *QuotaPreference `protobuf:"bytes,3,opt,name=quota_preference,json=quotaPreference,proto3" json:"quota_preference,omitempty"`
	// The list of quota safety checks to be ignored.
	IgnoreSafetyChecks []QuotaSafetyCheck `protobuf:"varint,4,rep,packed,name=ignore_safety_checks,json=ignoreSafetyChecks,proto3,enum=google.api.cloudquotas.v1beta.QuotaSafetyCheck" json:"ignore_safety_checks,omitempty"`
}

func (x *CreateQuotaPreferenceRequest) Reset() {
	*x = CreateQuotaPreferenceRequest{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateQuotaPreferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateQuotaPreferenceRequest) ProtoMessage() {}

func (x *CreateQuotaPreferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateQuotaPreferenceRequest.ProtoReflect.Descriptor instead.
func (*CreateQuotaPreferenceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{6}
}

func (x *CreateQuotaPreferenceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateQuotaPreferenceRequest) GetQuotaPreferenceId() string {
	if x != nil {
		return x.QuotaPreferenceId
	}
	return ""
}

func (x *CreateQuotaPreferenceRequest) GetQuotaPreference() *QuotaPreference {
	if x != nil {
		return x.QuotaPreference
	}
	return nil
}

func (x *CreateQuotaPreferenceRequest) GetIgnoreSafetyChecks() []QuotaSafetyCheck {
	if x != nil {
		return x.IgnoreSafetyChecks
	}
	return nil
}

// Message for updating a QuotaPreference
type UpdateQuotaPreferenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// QuotaPreference resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	QuotaPreference *QuotaPreference `protobuf:"bytes,2,opt,name=quota_preference,json=quotaPreference,proto3" json:"quota_preference,omitempty"`
	// Optional. If set to true, and the quota preference is not found, a new one
	// will be created. In this situation, `update_mask` is ignored.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, validate the request, but do not actually update.
	// Note that a request being valid does not mean that the request is
	// guaranteed to be fulfilled.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The list of quota safety checks to be ignored.
	IgnoreSafetyChecks []QuotaSafetyCheck `protobuf:"varint,5,rep,packed,name=ignore_safety_checks,json=ignoreSafetyChecks,proto3,enum=google.api.cloudquotas.v1beta.QuotaSafetyCheck" json:"ignore_safety_checks,omitempty"`
}

func (x *UpdateQuotaPreferenceRequest) Reset() {
	*x = UpdateQuotaPreferenceRequest{}
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateQuotaPreferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateQuotaPreferenceRequest) ProtoMessage() {}

func (x *UpdateQuotaPreferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateQuotaPreferenceRequest.ProtoReflect.Descriptor instead.
func (*UpdateQuotaPreferenceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateQuotaPreferenceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateQuotaPreferenceRequest) GetQuotaPreference() *QuotaPreference {
	if x != nil {
		return x.QuotaPreference
	}
	return nil
}

func (x *UpdateQuotaPreferenceRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateQuotaPreferenceRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateQuotaPreferenceRequest) GetIgnoreSafetyChecks() []QuotaSafetyCheck {
	if x != nil {
		return x.IgnoreSafetyChecks
	}
	return nil
}

var File_google_api_cloudquotas_v1beta_cloudquotas_proto protoreflect.FileDescriptor

var file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8b, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x57, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xec, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xc5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5b, 0x0a, 0x11, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x10, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x63, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe2, 0x02,
	0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x5e, 0x0a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x61, 0x0a, 0x14, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x12,
	0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x22, 0xf7, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5e, 0x0a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12,
	0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x61, 0x0a, 0x14, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x12, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x32, 0xb1, 0x12, 0x0a,
	0x0b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x12, 0xd5, 0x02, 0x0a,
	0x0e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd5, 0x01, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc5, 0x01, 0x5a,
	0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x73, 0x5a, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x73, 0x12, 0xc2, 0x02, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0xd3, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xc5, 0x01, 0x5a, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3e, 0x12, 0x3c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd8, 0x02, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc6, 0x01, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb6, 0x01, 0x5a, 0x39,
	0x12, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x5a, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0xc5, 0x02, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xc4, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xb6, 0x01, 0x5a, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x03, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0xbb, 0x02, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2c, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xec, 0x01, 0x3a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5a, 0x4b, 0x3a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x37, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x5a, 0x51, 0x3a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0xcc, 0x03, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xc5, 0x02, 0xda, 0x41, 0x1c, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9f,
	0x02, 0x3a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x5a, 0x5c, 0x3a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x32, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x62, 0x3a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x32, 0x4e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xf7, 0x04, 0xea, 0x41, 0xe0, 0x01, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x12, 0x38, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x7d, 0x12, 0x44, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0xea, 0x41, 0xa8, 0x01, 0x0a, 0x23, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x25, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x73, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x70,
	0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x56, 0x31, 0x42,
	0x65, 0x74, 0x61, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescOnce sync.Once
	file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescData = file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDesc
)

func file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescGZIP() []byte {
	file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescOnce.Do(func() {
		file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescData)
	})
	return file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDescData
}

var file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_api_cloudquotas_v1beta_cloudquotas_proto_goTypes = []any{
	(*ListQuotaInfosRequest)(nil),        // 0: google.api.cloudquotas.v1beta.ListQuotaInfosRequest
	(*ListQuotaInfosResponse)(nil),       // 1: google.api.cloudquotas.v1beta.ListQuotaInfosResponse
	(*GetQuotaInfoRequest)(nil),          // 2: google.api.cloudquotas.v1beta.GetQuotaInfoRequest
	(*ListQuotaPreferencesRequest)(nil),  // 3: google.api.cloudquotas.v1beta.ListQuotaPreferencesRequest
	(*ListQuotaPreferencesResponse)(nil), // 4: google.api.cloudquotas.v1beta.ListQuotaPreferencesResponse
	(*GetQuotaPreferenceRequest)(nil),    // 5: google.api.cloudquotas.v1beta.GetQuotaPreferenceRequest
	(*CreateQuotaPreferenceRequest)(nil), // 6: google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest
	(*UpdateQuotaPreferenceRequest)(nil), // 7: google.api.cloudquotas.v1beta.UpdateQuotaPreferenceRequest
	(*QuotaInfo)(nil),                    // 8: google.api.cloudquotas.v1beta.QuotaInfo
	(*QuotaPreference)(nil),              // 9: google.api.cloudquotas.v1beta.QuotaPreference
	(QuotaSafetyCheck)(0),                // 10: google.api.cloudquotas.v1beta.QuotaSafetyCheck
	(*fieldmaskpb.FieldMask)(nil),        // 11: google.protobuf.FieldMask
}
var file_google_api_cloudquotas_v1beta_cloudquotas_proto_depIdxs = []int32{
	8,  // 0: google.api.cloudquotas.v1beta.ListQuotaInfosResponse.quota_infos:type_name -> google.api.cloudquotas.v1beta.QuotaInfo
	9,  // 1: google.api.cloudquotas.v1beta.ListQuotaPreferencesResponse.quota_preferences:type_name -> google.api.cloudquotas.v1beta.QuotaPreference
	9,  // 2: google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.quota_preference:type_name -> google.api.cloudquotas.v1beta.QuotaPreference
	10, // 3: google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.ignore_safety_checks:type_name -> google.api.cloudquotas.v1beta.QuotaSafetyCheck
	11, // 4: google.api.cloudquotas.v1beta.UpdateQuotaPreferenceRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 5: google.api.cloudquotas.v1beta.UpdateQuotaPreferenceRequest.quota_preference:type_name -> google.api.cloudquotas.v1beta.QuotaPreference
	10, // 6: google.api.cloudquotas.v1beta.UpdateQuotaPreferenceRequest.ignore_safety_checks:type_name -> google.api.cloudquotas.v1beta.QuotaSafetyCheck
	0,  // 7: google.api.cloudquotas.v1beta.CloudQuotas.ListQuotaInfos:input_type -> google.api.cloudquotas.v1beta.ListQuotaInfosRequest
	2,  // 8: google.api.cloudquotas.v1beta.CloudQuotas.GetQuotaInfo:input_type -> google.api.cloudquotas.v1beta.GetQuotaInfoRequest
	3,  // 9: google.api.cloudquotas.v1beta.CloudQuotas.ListQuotaPreferences:input_type -> google.api.cloudquotas.v1beta.ListQuotaPreferencesRequest
	5,  // 10: google.api.cloudquotas.v1beta.CloudQuotas.GetQuotaPreference:input_type -> google.api.cloudquotas.v1beta.GetQuotaPreferenceRequest
	6,  // 11: google.api.cloudquotas.v1beta.CloudQuotas.CreateQuotaPreference:input_type -> google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest
	7,  // 12: google.api.cloudquotas.v1beta.CloudQuotas.UpdateQuotaPreference:input_type -> google.api.cloudquotas.v1beta.UpdateQuotaPreferenceRequest
	1,  // 13: google.api.cloudquotas.v1beta.CloudQuotas.ListQuotaInfos:output_type -> google.api.cloudquotas.v1beta.ListQuotaInfosResponse
	8,  // 14: google.api.cloudquotas.v1beta.CloudQuotas.GetQuotaInfo:output_type -> google.api.cloudquotas.v1beta.QuotaInfo
	4,  // 15: google.api.cloudquotas.v1beta.CloudQuotas.ListQuotaPreferences:output_type -> google.api.cloudquotas.v1beta.ListQuotaPreferencesResponse
	9,  // 16: google.api.cloudquotas.v1beta.CloudQuotas.GetQuotaPreference:output_type -> google.api.cloudquotas.v1beta.QuotaPreference
	9,  // 17: google.api.cloudquotas.v1beta.CloudQuotas.CreateQuotaPreference:output_type -> google.api.cloudquotas.v1beta.QuotaPreference
	9,  // 18: google.api.cloudquotas.v1beta.CloudQuotas.UpdateQuotaPreference:output_type -> google.api.cloudquotas.v1beta.QuotaPreference
	13, // [13:19] is the sub-list for method output_type
	7,  // [7:13] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_api_cloudquotas_v1beta_cloudquotas_proto_init() }
func file_google_api_cloudquotas_v1beta_cloudquotas_proto_init() {
	if File_google_api_cloudquotas_v1beta_cloudquotas_proto != nil {
		return
	}
	file_google_api_cloudquotas_v1beta_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_cloudquotas_v1beta_cloudquotas_proto_goTypes,
		DependencyIndexes: file_google_api_cloudquotas_v1beta_cloudquotas_proto_depIdxs,
		MessageInfos:      file_google_api_cloudquotas_v1beta_cloudquotas_proto_msgTypes,
	}.Build()
	File_google_api_cloudquotas_v1beta_cloudquotas_proto = out.File
	file_google_api_cloudquotas_v1beta_cloudquotas_proto_rawDesc = nil
	file_google_api_cloudquotas_v1beta_cloudquotas_proto_goTypes = nil
	file_google_api_cloudquotas_v1beta_cloudquotas_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudQuotasClient is the client API for CloudQuotas service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudQuotasClient interface {
	// Lists QuotaInfos of all quotas for a given project, folder or organization.
	ListQuotaInfos(ctx context.Context, in *ListQuotaInfosRequest, opts ...grpc.CallOption) (*ListQuotaInfosResponse, error)
	// Retrieve the QuotaInfo of a quota for a project, folder or organization.
	GetQuotaInfo(ctx context.Context, in *GetQuotaInfoRequest, opts ...grpc.CallOption) (*QuotaInfo, error)
	// Lists QuotaPreferences in a given project, folder or organization.
	ListQuotaPreferences(ctx context.Context, in *ListQuotaPreferencesRequest, opts ...grpc.CallOption) (*ListQuotaPreferencesResponse, error)
	// Gets details of a single QuotaPreference.
	GetQuotaPreference(ctx context.Context, in *GetQuotaPreferenceRequest, opts ...grpc.CallOption) (*QuotaPreference, error)
	// Creates a new QuotaPreference that declares the desired value for a quota.
	CreateQuotaPreference(ctx context.Context, in *CreateQuotaPreferenceRequest, opts ...grpc.CallOption) (*QuotaPreference, error)
	// Updates the parameters of a single QuotaPreference. It can updates the
	// config in any states, not just the ones pending approval.
	UpdateQuotaPreference(ctx context.Context, in *UpdateQuotaPreferenceRequest, opts ...grpc.CallOption) (*QuotaPreference, error)
}

type cloudQuotasClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudQuotasClient(cc grpc.ClientConnInterface) CloudQuotasClient {
	return &cloudQuotasClient{cc}
}

func (c *cloudQuotasClient) ListQuotaInfos(ctx context.Context, in *ListQuotaInfosRequest, opts ...grpc.CallOption) (*ListQuotaInfosResponse, error) {
	out := new(ListQuotaInfosResponse)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.CloudQuotas/ListQuotaInfos", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudQuotasClient) GetQuotaInfo(ctx context.Context, in *GetQuotaInfoRequest, opts ...grpc.CallOption) (*QuotaInfo, error) {
	out := new(QuotaInfo)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.CloudQuotas/GetQuotaInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudQuotasClient) ListQuotaPreferences(ctx context.Context, in *ListQuotaPreferencesRequest, opts ...grpc.CallOption) (*ListQuotaPreferencesResponse, error) {
	out := new(ListQuotaPreferencesResponse)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.CloudQuotas/ListQuotaPreferences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudQuotasClient) GetQuotaPreference(ctx context.Context, in *GetQuotaPreferenceRequest, opts ...grpc.CallOption) (*QuotaPreference, error) {
	out := new(QuotaPreference)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.CloudQuotas/GetQuotaPreference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudQuotasClient) CreateQuotaPreference(ctx context.Context, in *CreateQuotaPreferenceRequest, opts ...grpc.CallOption) (*QuotaPreference, error) {
	out := new(QuotaPreference)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.CloudQuotas/CreateQuotaPreference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudQuotasClient) UpdateQuotaPreference(ctx context.Context, in *UpdateQuotaPreferenceRequest, opts ...grpc.CallOption) (*QuotaPreference, error) {
	out := new(QuotaPreference)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.CloudQuotas/UpdateQuotaPreference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudQuotasServer is the server API for CloudQuotas service.
type CloudQuotasServer interface {
	// Lists QuotaInfos of all quotas for a given project, folder or organization.
	ListQuotaInfos(context.Context, *ListQuotaInfosRequest) (*ListQuotaInfosResponse, error)
	// Retrieve the QuotaInfo of a quota for a project, folder or organization.
	GetQuotaInfo(context.Context, *GetQuotaInfoRequest) (*QuotaInfo, error)
	// Lists QuotaPreferences in a given project, folder or organization.
	ListQuotaPreferences(context.Context, *ListQuotaPreferencesRequest) (*ListQuotaPreferencesResponse, error)
	// Gets details of a single QuotaPreference.
	GetQuotaPreference(context.Context, *GetQuotaPreferenceRequest) (*QuotaPreference, error)
	// Creates a new QuotaPreference that declares the desired value for a quota.
	CreateQuotaPreference(context.Context, *CreateQuotaPreferenceRequest) (*QuotaPreference, error)
	// Updates the parameters of a single QuotaPreference. It can updates the
	// config in any states, not just the ones pending approval.
	UpdateQuotaPreference(context.Context, *UpdateQuotaPreferenceRequest) (*QuotaPreference, error)
}

// UnimplementedCloudQuotasServer can be embedded to have forward compatible implementations.
type UnimplementedCloudQuotasServer struct {
}

func (*UnimplementedCloudQuotasServer) ListQuotaInfos(context.Context, *ListQuotaInfosRequest) (*ListQuotaInfosResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQuotaInfos not implemented")
}
func (*UnimplementedCloudQuotasServer) GetQuotaInfo(context.Context, *GetQuotaInfoRequest) (*QuotaInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQuotaInfo not implemented")
}
func (*UnimplementedCloudQuotasServer) ListQuotaPreferences(context.Context, *ListQuotaPreferencesRequest) (*ListQuotaPreferencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQuotaPreferences not implemented")
}
func (*UnimplementedCloudQuotasServer) GetQuotaPreference(context.Context, *GetQuotaPreferenceRequest) (*QuotaPreference, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQuotaPreference not implemented")
}
func (*UnimplementedCloudQuotasServer) CreateQuotaPreference(context.Context, *CreateQuotaPreferenceRequest) (*QuotaPreference, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQuotaPreference not implemented")
}
func (*UnimplementedCloudQuotasServer) UpdateQuotaPreference(context.Context, *UpdateQuotaPreferenceRequest) (*QuotaPreference, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQuotaPreference not implemented")
}

func RegisterCloudQuotasServer(s *grpc.Server, srv CloudQuotasServer) {
	s.RegisterService(&_CloudQuotas_serviceDesc, srv)
}

func _CloudQuotas_ListQuotaInfos_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotaInfosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudQuotasServer).ListQuotaInfos(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.CloudQuotas/ListQuotaInfos",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudQuotasServer).ListQuotaInfos(ctx, req.(*ListQuotaInfosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudQuotas_GetQuotaInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQuotaInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudQuotasServer).GetQuotaInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.CloudQuotas/GetQuotaInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudQuotasServer).GetQuotaInfo(ctx, req.(*GetQuotaInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudQuotas_ListQuotaPreferences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotaPreferencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudQuotasServer).ListQuotaPreferences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.CloudQuotas/ListQuotaPreferences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudQuotasServer).ListQuotaPreferences(ctx, req.(*ListQuotaPreferencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudQuotas_GetQuotaPreference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQuotaPreferenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudQuotasServer).GetQuotaPreference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.CloudQuotas/GetQuotaPreference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudQuotasServer).GetQuotaPreference(ctx, req.(*GetQuotaPreferenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudQuotas_CreateQuotaPreference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQuotaPreferenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudQuotasServer).CreateQuotaPreference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.CloudQuotas/CreateQuotaPreference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudQuotasServer).CreateQuotaPreference(ctx, req.(*CreateQuotaPreferenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudQuotas_UpdateQuotaPreference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQuotaPreferenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudQuotasServer).UpdateQuotaPreference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.CloudQuotas/UpdateQuotaPreference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudQuotasServer).UpdateQuotaPreference(ctx, req.(*UpdateQuotaPreferenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudQuotas_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.cloudquotas.v1beta.CloudQuotas",
	HandlerType: (*CloudQuotasServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListQuotaInfos",
			Handler:    _CloudQuotas_ListQuotaInfos_Handler,
		},
		{
			MethodName: "GetQuotaInfo",
			Handler:    _CloudQuotas_GetQuotaInfo_Handler,
		},
		{
			MethodName: "ListQuotaPreferences",
			Handler:    _CloudQuotas_ListQuotaPreferences_Handler,
		},
		{
			MethodName: "GetQuotaPreference",
			Handler:    _CloudQuotas_GetQuotaPreference_Handler,
		},
		{
			MethodName: "CreateQuotaPreference",
			Handler:    _CloudQuotas_CreateQuotaPreference_Handler,
		},
		{
			MethodName: "UpdateQuotaPreference",
			Handler:    _CloudQuotas_UpdateQuotaPreference_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/cloudquotas/v1beta/cloudquotas.proto",
}
