// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/event_payload.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Event payload for a new membership.
//
// Event type: `google.workspace.chat.membership.v1.created`.
type MembershipCreatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new membership.
	Membership *Membership `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *MembershipCreatedEventData) Reset() {
	*x = MembershipCreatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MembershipCreatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipCreatedEventData) ProtoMessage() {}

func (x *MembershipCreatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipCreatedEventData.ProtoReflect.Descriptor instead.
func (*MembershipCreatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{0}
}

func (x *MembershipCreatedEventData) GetMembership() *Membership {
	if x != nil {
		return x.Membership
	}
	return nil
}

// Event payload for a deleted membership.
//
// Event type: `google.workspace.chat.membership.v1.deleted`
type MembershipDeletedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deleted membership. Only the `name` and `state` fields are populated.
	Membership *Membership `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *MembershipDeletedEventData) Reset() {
	*x = MembershipDeletedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MembershipDeletedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipDeletedEventData) ProtoMessage() {}

func (x *MembershipDeletedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipDeletedEventData.ProtoReflect.Descriptor instead.
func (*MembershipDeletedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{1}
}

func (x *MembershipDeletedEventData) GetMembership() *Membership {
	if x != nil {
		return x.Membership
	}
	return nil
}

// Event payload for an updated membership.
//
// Event type: `google.workspace.chat.membership.v1.updated`
type MembershipUpdatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated membership.
	Membership *Membership `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *MembershipUpdatedEventData) Reset() {
	*x = MembershipUpdatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MembershipUpdatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipUpdatedEventData) ProtoMessage() {}

func (x *MembershipUpdatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipUpdatedEventData.ProtoReflect.Descriptor instead.
func (*MembershipUpdatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{2}
}

func (x *MembershipUpdatedEventData) GetMembership() *Membership {
	if x != nil {
		return x.Membership
	}
	return nil
}

// Event payload for multiple new memberships.
//
// Event type: `google.workspace.chat.membership.v1.batchCreated`
type MembershipBatchCreatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of new memberships.
	Memberships []*MembershipCreatedEventData `protobuf:"bytes,1,rep,name=memberships,proto3" json:"memberships,omitempty"`
}

func (x *MembershipBatchCreatedEventData) Reset() {
	*x = MembershipBatchCreatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MembershipBatchCreatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipBatchCreatedEventData) ProtoMessage() {}

func (x *MembershipBatchCreatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipBatchCreatedEventData.ProtoReflect.Descriptor instead.
func (*MembershipBatchCreatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{3}
}

func (x *MembershipBatchCreatedEventData) GetMemberships() []*MembershipCreatedEventData {
	if x != nil {
		return x.Memberships
	}
	return nil
}

// Event payload for multiple updated memberships.
//
// Event type: `google.workspace.chat.membership.v1.batchUpdated`
type MembershipBatchUpdatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of updated memberships.
	Memberships []*MembershipUpdatedEventData `protobuf:"bytes,1,rep,name=memberships,proto3" json:"memberships,omitempty"`
}

func (x *MembershipBatchUpdatedEventData) Reset() {
	*x = MembershipBatchUpdatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MembershipBatchUpdatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipBatchUpdatedEventData) ProtoMessage() {}

func (x *MembershipBatchUpdatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipBatchUpdatedEventData.ProtoReflect.Descriptor instead.
func (*MembershipBatchUpdatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{4}
}

func (x *MembershipBatchUpdatedEventData) GetMemberships() []*MembershipUpdatedEventData {
	if x != nil {
		return x.Memberships
	}
	return nil
}

// Event payload for multiple deleted memberships.
//
// Event type: `google.workspace.chat.membership.v1.batchDeleted`
type MembershipBatchDeletedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of deleted memberships.
	Memberships []*MembershipDeletedEventData `protobuf:"bytes,1,rep,name=memberships,proto3" json:"memberships,omitempty"`
}

func (x *MembershipBatchDeletedEventData) Reset() {
	*x = MembershipBatchDeletedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MembershipBatchDeletedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipBatchDeletedEventData) ProtoMessage() {}

func (x *MembershipBatchDeletedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipBatchDeletedEventData.ProtoReflect.Descriptor instead.
func (*MembershipBatchDeletedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{5}
}

func (x *MembershipBatchDeletedEventData) GetMemberships() []*MembershipDeletedEventData {
	if x != nil {
		return x.Memberships
	}
	return nil
}

// Event payload for a new message.
//
// Event type: `google.workspace.chat.message.v1.created`
type MessageCreatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new message.
	Message *Message `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *MessageCreatedEventData) Reset() {
	*x = MessageCreatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageCreatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageCreatedEventData) ProtoMessage() {}

func (x *MessageCreatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageCreatedEventData.ProtoReflect.Descriptor instead.
func (*MessageCreatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{6}
}

func (x *MessageCreatedEventData) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// Event payload for an updated message.
//
// Event type: `google.workspace.chat.message.v1.updated`
type MessageUpdatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated message.
	Message *Message `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *MessageUpdatedEventData) Reset() {
	*x = MessageUpdatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageUpdatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageUpdatedEventData) ProtoMessage() {}

func (x *MessageUpdatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageUpdatedEventData.ProtoReflect.Descriptor instead.
func (*MessageUpdatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{7}
}

func (x *MessageUpdatedEventData) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// Event payload for a deleted message.
//
// Event type: `google.workspace.chat.message.v1.deleted`
type MessageDeletedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deleted message. Only the `name`, `createTime`, `deleteTime`, and
	// `deletionMetadata` fields are populated.
	Message *Message `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *MessageDeletedEventData) Reset() {
	*x = MessageDeletedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageDeletedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageDeletedEventData) ProtoMessage() {}

func (x *MessageDeletedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageDeletedEventData.ProtoReflect.Descriptor instead.
func (*MessageDeletedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{8}
}

func (x *MessageDeletedEventData) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// Event payload for multiple new messages.
//
// Event type: `google.workspace.chat.message.v1.batchCreated`
type MessageBatchCreatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of new messages.
	Messages []*MessageCreatedEventData `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *MessageBatchCreatedEventData) Reset() {
	*x = MessageBatchCreatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageBatchCreatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageBatchCreatedEventData) ProtoMessage() {}

func (x *MessageBatchCreatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageBatchCreatedEventData.ProtoReflect.Descriptor instead.
func (*MessageBatchCreatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{9}
}

func (x *MessageBatchCreatedEventData) GetMessages() []*MessageCreatedEventData {
	if x != nil {
		return x.Messages
	}
	return nil
}

// Event payload for multiple updated messages.
//
// Event type: `google.workspace.chat.message.v1.batchUpdated`
type MessageBatchUpdatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of updated messages.
	Messages []*MessageUpdatedEventData `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *MessageBatchUpdatedEventData) Reset() {
	*x = MessageBatchUpdatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageBatchUpdatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageBatchUpdatedEventData) ProtoMessage() {}

func (x *MessageBatchUpdatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageBatchUpdatedEventData.ProtoReflect.Descriptor instead.
func (*MessageBatchUpdatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{10}
}

func (x *MessageBatchUpdatedEventData) GetMessages() []*MessageUpdatedEventData {
	if x != nil {
		return x.Messages
	}
	return nil
}

// Event payload for multiple deleted messages.
//
// Event type: `google.workspace.chat.message.v1.batchDeleted`
type MessageBatchDeletedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of deleted messages.
	Messages []*MessageDeletedEventData `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *MessageBatchDeletedEventData) Reset() {
	*x = MessageBatchDeletedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageBatchDeletedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageBatchDeletedEventData) ProtoMessage() {}

func (x *MessageBatchDeletedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageBatchDeletedEventData.ProtoReflect.Descriptor instead.
func (*MessageBatchDeletedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{11}
}

func (x *MessageBatchDeletedEventData) GetMessages() []*MessageDeletedEventData {
	if x != nil {
		return x.Messages
	}
	return nil
}

// Event payload for an updated space.
//
// Event type: `google.workspace.chat.space.v1.updated`
type SpaceUpdatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated space.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
}

func (x *SpaceUpdatedEventData) Reset() {
	*x = SpaceUpdatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpaceUpdatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpaceUpdatedEventData) ProtoMessage() {}

func (x *SpaceUpdatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpaceUpdatedEventData.ProtoReflect.Descriptor instead.
func (*SpaceUpdatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{12}
}

func (x *SpaceUpdatedEventData) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

// Event payload for multiple updates to a space.
//
// Event type: `google.workspace.chat.space.v1.batchUpdated`
type SpaceBatchUpdatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of updated spaces.
	Spaces []*SpaceUpdatedEventData `protobuf:"bytes,1,rep,name=spaces,proto3" json:"spaces,omitempty"`
}

func (x *SpaceBatchUpdatedEventData) Reset() {
	*x = SpaceBatchUpdatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpaceBatchUpdatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpaceBatchUpdatedEventData) ProtoMessage() {}

func (x *SpaceBatchUpdatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpaceBatchUpdatedEventData.ProtoReflect.Descriptor instead.
func (*SpaceBatchUpdatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{13}
}

func (x *SpaceBatchUpdatedEventData) GetSpaces() []*SpaceUpdatedEventData {
	if x != nil {
		return x.Spaces
	}
	return nil
}

// Event payload for a new reaction.
//
// Event type: `google.workspace.chat.reaction.v1.created`
type ReactionCreatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new reaction.
	Reaction *Reaction `protobuf:"bytes,1,opt,name=reaction,proto3" json:"reaction,omitempty"`
}

func (x *ReactionCreatedEventData) Reset() {
	*x = ReactionCreatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReactionCreatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReactionCreatedEventData) ProtoMessage() {}

func (x *ReactionCreatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReactionCreatedEventData.ProtoReflect.Descriptor instead.
func (*ReactionCreatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{14}
}

func (x *ReactionCreatedEventData) GetReaction() *Reaction {
	if x != nil {
		return x.Reaction
	}
	return nil
}

// Event payload for a deleted reaction.
//
// Type: `google.workspace.chat.reaction.v1.deleted`
type ReactionDeletedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deleted reaction.
	Reaction *Reaction `protobuf:"bytes,1,opt,name=reaction,proto3" json:"reaction,omitempty"`
}

func (x *ReactionDeletedEventData) Reset() {
	*x = ReactionDeletedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReactionDeletedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReactionDeletedEventData) ProtoMessage() {}

func (x *ReactionDeletedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReactionDeletedEventData.ProtoReflect.Descriptor instead.
func (*ReactionDeletedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{15}
}

func (x *ReactionDeletedEventData) GetReaction() *Reaction {
	if x != nil {
		return x.Reaction
	}
	return nil
}

// Event payload for multiple new reactions.
//
// Event type: `google.workspace.chat.reaction.v1.batchCreated`
type ReactionBatchCreatedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of new reactions.
	Reactions []*ReactionCreatedEventData `protobuf:"bytes,1,rep,name=reactions,proto3" json:"reactions,omitempty"`
}

func (x *ReactionBatchCreatedEventData) Reset() {
	*x = ReactionBatchCreatedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReactionBatchCreatedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReactionBatchCreatedEventData) ProtoMessage() {}

func (x *ReactionBatchCreatedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReactionBatchCreatedEventData.ProtoReflect.Descriptor instead.
func (*ReactionBatchCreatedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{16}
}

func (x *ReactionBatchCreatedEventData) GetReactions() []*ReactionCreatedEventData {
	if x != nil {
		return x.Reactions
	}
	return nil
}

// Event payload for multiple deleted reactions.
//
// Event type: `google.workspace.chat.reaction.v1.batchDeleted`
type ReactionBatchDeletedEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of deleted reactions.
	Reactions []*ReactionDeletedEventData `protobuf:"bytes,1,rep,name=reactions,proto3" json:"reactions,omitempty"`
}

func (x *ReactionBatchDeletedEventData) Reset() {
	*x = ReactionBatchDeletedEventData{}
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReactionBatchDeletedEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReactionBatchDeletedEventData) ProtoMessage() {}

func (x *ReactionBatchDeletedEventData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_event_payload_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReactionBatchDeletedEventData.ProtoReflect.Descriptor instead.
func (*ReactionBatchDeletedEventData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_event_payload_proto_rawDescGZIP(), []int{17}
}

func (x *ReactionBatchDeletedEventData) GetReactions() []*ReactionDeletedEventData {
	if x != nil {
		return x.Reactions
	}
	return nil
}

var File_google_chat_v1_event_payload_proto protoreflect.FileDescriptor

var file_google_chat_v1_event_payload_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68,
	0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61,
	0x74, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x58, 0x0a, 0x1a, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3a, 0x0a,
	0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x0a, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x58, 0x0a, 0x1a, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x22, 0x58, 0x0a, 0x1a, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x6f, 0x0a,
	0x1f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x4c, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x22, 0x6f,
	0x0a, 0x1f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x4c, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x22,
	0x6f, 0x0a, 0x1f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x4c, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73,
	0x22, 0x4c, 0x0a, 0x17, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x4c,
	0x0a, 0x17, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x4c, 0x0a, 0x17,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x63, 0x0a, 0x1c, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22,
	0x63, 0x0a, 0x1c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x43, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x22, 0x63, 0x0a, 0x1c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x44, 0x0a, 0x15, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x2b, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22,
	0x5b, 0x0a, 0x1a, 0x53, 0x70, 0x61, 0x63, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3d, 0x0a,
	0x06, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x06, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x22, 0x50, 0x0a, 0x18,
	0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x34, 0x0a, 0x08, 0x72, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x50,
	0x0a, 0x18, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x34, 0x0a, 0x08, 0x72, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x67, 0x0a, 0x1d, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x46, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09,
	0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x67, 0x0a, 0x1d, 0x52, 0x65, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0xaa, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63,
	0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44,
	0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x43,
	0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_event_payload_proto_rawDescOnce sync.Once
	file_google_chat_v1_event_payload_proto_rawDescData = file_google_chat_v1_event_payload_proto_rawDesc
)

func file_google_chat_v1_event_payload_proto_rawDescGZIP() []byte {
	file_google_chat_v1_event_payload_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_event_payload_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_event_payload_proto_rawDescData)
	})
	return file_google_chat_v1_event_payload_proto_rawDescData
}

var file_google_chat_v1_event_payload_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_chat_v1_event_payload_proto_goTypes = []any{
	(*MembershipCreatedEventData)(nil),      // 0: google.chat.v1.MembershipCreatedEventData
	(*MembershipDeletedEventData)(nil),      // 1: google.chat.v1.MembershipDeletedEventData
	(*MembershipUpdatedEventData)(nil),      // 2: google.chat.v1.MembershipUpdatedEventData
	(*MembershipBatchCreatedEventData)(nil), // 3: google.chat.v1.MembershipBatchCreatedEventData
	(*MembershipBatchUpdatedEventData)(nil), // 4: google.chat.v1.MembershipBatchUpdatedEventData
	(*MembershipBatchDeletedEventData)(nil), // 5: google.chat.v1.MembershipBatchDeletedEventData
	(*MessageCreatedEventData)(nil),         // 6: google.chat.v1.MessageCreatedEventData
	(*MessageUpdatedEventData)(nil),         // 7: google.chat.v1.MessageUpdatedEventData
	(*MessageDeletedEventData)(nil),         // 8: google.chat.v1.MessageDeletedEventData
	(*MessageBatchCreatedEventData)(nil),    // 9: google.chat.v1.MessageBatchCreatedEventData
	(*MessageBatchUpdatedEventData)(nil),    // 10: google.chat.v1.MessageBatchUpdatedEventData
	(*MessageBatchDeletedEventData)(nil),    // 11: google.chat.v1.MessageBatchDeletedEventData
	(*SpaceUpdatedEventData)(nil),           // 12: google.chat.v1.SpaceUpdatedEventData
	(*SpaceBatchUpdatedEventData)(nil),      // 13: google.chat.v1.SpaceBatchUpdatedEventData
	(*ReactionCreatedEventData)(nil),        // 14: google.chat.v1.ReactionCreatedEventData
	(*ReactionDeletedEventData)(nil),        // 15: google.chat.v1.ReactionDeletedEventData
	(*ReactionBatchCreatedEventData)(nil),   // 16: google.chat.v1.ReactionBatchCreatedEventData
	(*ReactionBatchDeletedEventData)(nil),   // 17: google.chat.v1.ReactionBatchDeletedEventData
	(*Membership)(nil),                      // 18: google.chat.v1.Membership
	(*Message)(nil),                         // 19: google.chat.v1.Message
	(*Space)(nil),                           // 20: google.chat.v1.Space
	(*Reaction)(nil),                        // 21: google.chat.v1.Reaction
}
var file_google_chat_v1_event_payload_proto_depIdxs = []int32{
	18, // 0: google.chat.v1.MembershipCreatedEventData.membership:type_name -> google.chat.v1.Membership
	18, // 1: google.chat.v1.MembershipDeletedEventData.membership:type_name -> google.chat.v1.Membership
	18, // 2: google.chat.v1.MembershipUpdatedEventData.membership:type_name -> google.chat.v1.Membership
	0,  // 3: google.chat.v1.MembershipBatchCreatedEventData.memberships:type_name -> google.chat.v1.MembershipCreatedEventData
	2,  // 4: google.chat.v1.MembershipBatchUpdatedEventData.memberships:type_name -> google.chat.v1.MembershipUpdatedEventData
	1,  // 5: google.chat.v1.MembershipBatchDeletedEventData.memberships:type_name -> google.chat.v1.MembershipDeletedEventData
	19, // 6: google.chat.v1.MessageCreatedEventData.message:type_name -> google.chat.v1.Message
	19, // 7: google.chat.v1.MessageUpdatedEventData.message:type_name -> google.chat.v1.Message
	19, // 8: google.chat.v1.MessageDeletedEventData.message:type_name -> google.chat.v1.Message
	6,  // 9: google.chat.v1.MessageBatchCreatedEventData.messages:type_name -> google.chat.v1.MessageCreatedEventData
	7,  // 10: google.chat.v1.MessageBatchUpdatedEventData.messages:type_name -> google.chat.v1.MessageUpdatedEventData
	8,  // 11: google.chat.v1.MessageBatchDeletedEventData.messages:type_name -> google.chat.v1.MessageDeletedEventData
	20, // 12: google.chat.v1.SpaceUpdatedEventData.space:type_name -> google.chat.v1.Space
	12, // 13: google.chat.v1.SpaceBatchUpdatedEventData.spaces:type_name -> google.chat.v1.SpaceUpdatedEventData
	21, // 14: google.chat.v1.ReactionCreatedEventData.reaction:type_name -> google.chat.v1.Reaction
	21, // 15: google.chat.v1.ReactionDeletedEventData.reaction:type_name -> google.chat.v1.Reaction
	14, // 16: google.chat.v1.ReactionBatchCreatedEventData.reactions:type_name -> google.chat.v1.ReactionCreatedEventData
	15, // 17: google.chat.v1.ReactionBatchDeletedEventData.reactions:type_name -> google.chat.v1.ReactionDeletedEventData
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_chat_v1_event_payload_proto_init() }
func file_google_chat_v1_event_payload_proto_init() {
	if File_google_chat_v1_event_payload_proto != nil {
		return
	}
	file_google_chat_v1_membership_proto_init()
	file_google_chat_v1_message_proto_init()
	file_google_chat_v1_reaction_proto_init()
	file_google_chat_v1_space_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_event_payload_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_event_payload_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_event_payload_proto_depIdxs,
		MessageInfos:      file_google_chat_v1_event_payload_proto_msgTypes,
	}.Build()
	File_google_chat_v1_event_payload_proto = out.File
	file_google_chat_v1_event_payload_proto_rawDesc = nil
	file_google_chat_v1_event_payload_proto_goTypes = nil
	file_google_chat_v1_event_payload_proto_depIdxs = nil
}
