// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/backupdr/v1/backupvault_gce.proto

package backupdrpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies whether the virtual machine instance will be shut down on key
// revocation. It is currently used in instance, instance properties and GMI
// protos
type KeyRevocationActionType int32

const (
	// Default value. This value is unused.
	KeyRevocationActionType_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED KeyRevocationActionType = 0
	// Indicates user chose no operation.
	KeyRevocationActionType_NONE KeyRevocationActionType = 1
	// Indicates user chose to opt for VM shutdown on key revocation.
	KeyRevocationActionType_STOP KeyRevocationActionType = 2
)

// Enum value maps for KeyRevocationActionType.
var (
	KeyRevocationActionType_name = map[int32]string{
		0: "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		1: "NONE",
		2: "STOP",
	}
	KeyRevocationActionType_value = map[string]int32{
		"KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 0,
		"NONE":                                   1,
		"STOP":                                   2,
	}
)

func (x KeyRevocationActionType) Enum() *KeyRevocationActionType {
	p := new(KeyRevocationActionType)
	*p = x
	return p
}

func (x KeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[0].Descriptor()
}

func (KeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[0]
}

func (x KeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyRevocationActionType.Descriptor instead.
func (KeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{0}
}

// The private IPv6 google access type for the VMs.
type ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess int32

const (
	// Default value. This value is unused.
	ComputeInstanceRestoreProperties_INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess = 0
	// Each network interface inherits PrivateIpv6GoogleAccess from its
	// subnetwork.
	ComputeInstanceRestoreProperties_INHERIT_FROM_SUBNETWORK ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess = 1
	// Outbound private IPv6 access from VMs in this subnet to Google services.
	// If specified, the subnetwork who is attached to the instance's default
	// network interface will be assigned an internal IPv6 prefix if it doesn't
	// have before.
	ComputeInstanceRestoreProperties_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess = 2
	// Bidirectional private IPv6 access to/from Google services. If
	// specified, the subnetwork who is attached to the instance's default
	// network interface will be assigned an internal IPv6 prefix if it doesn't
	// have before.
	ComputeInstanceRestoreProperties_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess = 3
)

// Enum value maps for ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess.
var (
	ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess_name = map[int32]string{
		0: "INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED",
		1: "INHERIT_FROM_SUBNETWORK",
		2: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		3: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
	}
	ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess_value = map[string]int32{
		"INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED": 0,
		"INHERIT_FROM_SUBNETWORK":                         1,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":             2,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE":           3,
	}
)

func (x ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess) Enum() *ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess {
	p := new(ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[1].Descriptor()
}

func (ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[1]
}

func (x ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess.Descriptor instead.
func (ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{1, 0}
}

// Stack type for this network interface.
type NetworkInterface_StackType int32

const (
	// Default should be STACK_TYPE_UNSPECIFIED.
	NetworkInterface_STACK_TYPE_UNSPECIFIED NetworkInterface_StackType = 0
	// The network interface will be assigned IPv4 address.
	NetworkInterface_IPV4_ONLY NetworkInterface_StackType = 1
	// The network interface can have both IPv4 and IPv6 addresses.
	NetworkInterface_IPV4_IPV6 NetworkInterface_StackType = 2
)

// Enum value maps for NetworkInterface_StackType.
var (
	NetworkInterface_StackType_name = map[int32]string{
		0: "STACK_TYPE_UNSPECIFIED",
		1: "IPV4_ONLY",
		2: "IPV4_IPV6",
	}
	NetworkInterface_StackType_value = map[string]int32{
		"STACK_TYPE_UNSPECIFIED": 0,
		"IPV4_ONLY":              1,
		"IPV4_IPV6":              2,
	}
)

func (x NetworkInterface_StackType) Enum() *NetworkInterface_StackType {
	p := new(NetworkInterface_StackType)
	*p = x
	return p
}

func (x NetworkInterface_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[2].Descriptor()
}

func (NetworkInterface_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[2]
}

func (x NetworkInterface_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_StackType.Descriptor instead.
func (NetworkInterface_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{11, 0}
}

// IPv6 access type for this network interface.
type NetworkInterface_Ipv6AccessType int32

const (
	// IPv6 access type not set. Means this network interface hasn't been
	// turned on IPv6 yet.
	NetworkInterface_UNSPECIFIED_IPV6_ACCESS_TYPE NetworkInterface_Ipv6AccessType = 0
	// This network interface can have internal IPv6.
	NetworkInterface_INTERNAL NetworkInterface_Ipv6AccessType = 1
	// This network interface can have external IPv6.
	NetworkInterface_EXTERNAL NetworkInterface_Ipv6AccessType = 2
)

// Enum value maps for NetworkInterface_Ipv6AccessType.
var (
	NetworkInterface_Ipv6AccessType_name = map[int32]string{
		0: "UNSPECIFIED_IPV6_ACCESS_TYPE",
		1: "INTERNAL",
		2: "EXTERNAL",
	}
	NetworkInterface_Ipv6AccessType_value = map[string]int32{
		"UNSPECIFIED_IPV6_ACCESS_TYPE": 0,
		"INTERNAL":                     1,
		"EXTERNAL":                     2,
	}
)

func (x NetworkInterface_Ipv6AccessType) Enum() *NetworkInterface_Ipv6AccessType {
	p := new(NetworkInterface_Ipv6AccessType)
	*p = x
	return p
}

func (x NetworkInterface_Ipv6AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_Ipv6AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[3].Descriptor()
}

func (NetworkInterface_Ipv6AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[3]
}

func (x NetworkInterface_Ipv6AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_Ipv6AccessType.Descriptor instead.
func (NetworkInterface_Ipv6AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{11, 1}
}

// Nic type for this network interface.
type NetworkInterface_NicType int32

const (
	// Default should be NIC_TYPE_UNSPECIFIED.
	NetworkInterface_NIC_TYPE_UNSPECIFIED NetworkInterface_NicType = 0
	// VIRTIO
	NetworkInterface_VIRTIO_NET NetworkInterface_NicType = 1
	// GVNIC
	NetworkInterface_GVNIC NetworkInterface_NicType = 2
)

// Enum value maps for NetworkInterface_NicType.
var (
	NetworkInterface_NicType_name = map[int32]string{
		0: "NIC_TYPE_UNSPECIFIED",
		1: "VIRTIO_NET",
		2: "GVNIC",
	}
	NetworkInterface_NicType_value = map[string]int32{
		"NIC_TYPE_UNSPECIFIED": 0,
		"VIRTIO_NET":           1,
		"GVNIC":                2,
	}
)

func (x NetworkInterface_NicType) Enum() *NetworkInterface_NicType {
	p := new(NetworkInterface_NicType)
	*p = x
	return p
}

func (x NetworkInterface_NicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_NicType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[4].Descriptor()
}

func (NetworkInterface_NicType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[4]
}

func (x NetworkInterface_NicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_NicType.Descriptor instead.
func (NetworkInterface_NicType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{11, 2}
}

// Network performance tier.
type NetworkPerformanceConfig_Tier int32

const (
	// This value is unused.
	NetworkPerformanceConfig_TIER_UNSPECIFIED NetworkPerformanceConfig_Tier = 0
	// Default network performance config.
	NetworkPerformanceConfig_DEFAULT NetworkPerformanceConfig_Tier = 1
	// Tier 1 network performance config.
	NetworkPerformanceConfig_TIER_1 NetworkPerformanceConfig_Tier = 2
)

// Enum value maps for NetworkPerformanceConfig_Tier.
var (
	NetworkPerformanceConfig_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "DEFAULT",
		2: "TIER_1",
	}
	NetworkPerformanceConfig_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"DEFAULT":          1,
		"TIER_1":           2,
	}
)

func (x NetworkPerformanceConfig_Tier) Enum() *NetworkPerformanceConfig_Tier {
	p := new(NetworkPerformanceConfig_Tier)
	*p = x
	return p
}

func (x NetworkPerformanceConfig_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPerformanceConfig_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[5].Descriptor()
}

func (NetworkPerformanceConfig_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[5]
}

func (x NetworkPerformanceConfig_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPerformanceConfig_Tier.Descriptor instead.
func (NetworkPerformanceConfig_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{12, 0}
}

// The type of configuration.
type AccessConfig_AccessType int32

const (
	// Default value. This value is unused.
	AccessConfig_ACCESS_TYPE_UNSPECIFIED AccessConfig_AccessType = 0
	// ONE_TO_ONE_NAT
	AccessConfig_ONE_TO_ONE_NAT AccessConfig_AccessType = 1
	// Direct IPv6 access.
	AccessConfig_DIRECT_IPV6 AccessConfig_AccessType = 2
)

// Enum value maps for AccessConfig_AccessType.
var (
	AccessConfig_AccessType_name = map[int32]string{
		0: "ACCESS_TYPE_UNSPECIFIED",
		1: "ONE_TO_ONE_NAT",
		2: "DIRECT_IPV6",
	}
	AccessConfig_AccessType_value = map[string]int32{
		"ACCESS_TYPE_UNSPECIFIED": 0,
		"ONE_TO_ONE_NAT":          1,
		"DIRECT_IPV6":             2,
	}
)

func (x AccessConfig_AccessType) Enum() *AccessConfig_AccessType {
	p := new(AccessConfig_AccessType)
	*p = x
	return p
}

func (x AccessConfig_AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[6].Descriptor()
}

func (AccessConfig_AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[6]
}

func (x AccessConfig_AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_AccessType.Descriptor instead.
func (AccessConfig_AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{13, 0}
}

// Network tier property used by addresses, instances and forwarding rules.
type AccessConfig_NetworkTier int32

const (
	// Default value. This value is unused.
	AccessConfig_NETWORK_TIER_UNSPECIFIED AccessConfig_NetworkTier = 0
	// High quality, Google-grade network tier, support for all networking
	// products.
	AccessConfig_PREMIUM AccessConfig_NetworkTier = 1
	// Public internet quality, only limited support for other networking
	// products.
	AccessConfig_STANDARD AccessConfig_NetworkTier = 2
)

// Enum value maps for AccessConfig_NetworkTier.
var (
	AccessConfig_NetworkTier_name = map[int32]string{
		0: "NETWORK_TIER_UNSPECIFIED",
		1: "PREMIUM",
		2: "STANDARD",
	}
	AccessConfig_NetworkTier_value = map[string]int32{
		"NETWORK_TIER_UNSPECIFIED": 0,
		"PREMIUM":                  1,
		"STANDARD":                 2,
	}
)

func (x AccessConfig_NetworkTier) Enum() *AccessConfig_NetworkTier {
	p := new(AccessConfig_NetworkTier)
	*p = x
	return p
}

func (x AccessConfig_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[7].Descriptor()
}

func (AccessConfig_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[7]
}

func (x AccessConfig_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_NetworkTier.Descriptor instead.
func (AccessConfig_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{13, 1}
}

// Indicates whether to consume from a reservation or not.
type AllocationAffinity_Type int32

const (
	// Default value. This value is unused.
	AllocationAffinity_TYPE_UNSPECIFIED AllocationAffinity_Type = 0
	// Do not consume from any allocated capacity.
	AllocationAffinity_NO_RESERVATION AllocationAffinity_Type = 1
	// Consume any allocation available.
	AllocationAffinity_ANY_RESERVATION AllocationAffinity_Type = 2
	// Must consume from a specific reservation. Must specify key value fields
	// for specifying the reservations.
	AllocationAffinity_SPECIFIC_RESERVATION AllocationAffinity_Type = 3
)

// Enum value maps for AllocationAffinity_Type.
var (
	AllocationAffinity_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NO_RESERVATION",
		2: "ANY_RESERVATION",
		3: "SPECIFIC_RESERVATION",
	}
	AllocationAffinity_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":     0,
		"NO_RESERVATION":       1,
		"ANY_RESERVATION":      2,
		"SPECIFIC_RESERVATION": 3,
	}
)

func (x AllocationAffinity_Type) Enum() *AllocationAffinity_Type {
	p := new(AllocationAffinity_Type)
	*p = x
	return p
}

func (x AllocationAffinity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationAffinity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[8].Descriptor()
}

func (AllocationAffinity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[8]
}

func (x AllocationAffinity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationAffinity_Type.Descriptor instead.
func (AllocationAffinity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{16, 0}
}

// Defines the maintenance behavior for this instance=
type Scheduling_OnHostMaintenance int32

const (
	// Default value. This value is unused.
	Scheduling_ON_HOST_MAINTENANCE_UNSPECIFIED Scheduling_OnHostMaintenance = 0
	// Tells Compute Engine to terminate and (optionally) restart the instance
	// away from the maintenance activity.
	Scheduling_TERMINATE Scheduling_OnHostMaintenance = 1
	// Default, Allows Compute Engine to automatically migrate instances
	// out of the way of maintenance events.
	Scheduling_MIGRATE Scheduling_OnHostMaintenance = 1000
)

// Enum value maps for Scheduling_OnHostMaintenance.
var (
	Scheduling_OnHostMaintenance_name = map[int32]string{
		0:    "ON_HOST_MAINTENANCE_UNSPECIFIED",
		1:    "TERMINATE",
		1000: "MIGRATE",
	}
	Scheduling_OnHostMaintenance_value = map[string]int32{
		"ON_HOST_MAINTENANCE_UNSPECIFIED": 0,
		"TERMINATE":                       1,
		"MIGRATE":                         1000,
	}
)

func (x Scheduling_OnHostMaintenance) Enum() *Scheduling_OnHostMaintenance {
	p := new(Scheduling_OnHostMaintenance)
	*p = x
	return p
}

func (x Scheduling_OnHostMaintenance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_OnHostMaintenance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[9].Descriptor()
}

func (Scheduling_OnHostMaintenance) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[9]
}

func (x Scheduling_OnHostMaintenance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_OnHostMaintenance.Descriptor instead.
func (Scheduling_OnHostMaintenance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{17, 0}
}

// Defines the provisioning model for an instance.
type Scheduling_ProvisioningModel int32

const (
	// Default value. This value is not used.
	Scheduling_PROVISIONING_MODEL_UNSPECIFIED Scheduling_ProvisioningModel = 0
	// Standard provisioning with user controlled runtime, no discounts.
	Scheduling_STANDARD Scheduling_ProvisioningModel = 1
	// Heavily discounted, no guaranteed runtime.
	Scheduling_SPOT Scheduling_ProvisioningModel = 2
)

// Enum value maps for Scheduling_ProvisioningModel.
var (
	Scheduling_ProvisioningModel_name = map[int32]string{
		0: "PROVISIONING_MODEL_UNSPECIFIED",
		1: "STANDARD",
		2: "SPOT",
	}
	Scheduling_ProvisioningModel_value = map[string]int32{
		"PROVISIONING_MODEL_UNSPECIFIED": 0,
		"STANDARD":                       1,
		"SPOT":                           2,
	}
)

func (x Scheduling_ProvisioningModel) Enum() *Scheduling_ProvisioningModel {
	p := new(Scheduling_ProvisioningModel)
	*p = x
	return p
}

func (x Scheduling_ProvisioningModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_ProvisioningModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[10].Descriptor()
}

func (Scheduling_ProvisioningModel) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[10]
}

func (x Scheduling_ProvisioningModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_ProvisioningModel.Descriptor instead.
func (Scheduling_ProvisioningModel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{17, 1}
}

// Defines the supported termination actions for an instance.
type Scheduling_InstanceTerminationAction int32

const (
	// Default value. This value is unused.
	Scheduling_INSTANCE_TERMINATION_ACTION_UNSPECIFIED Scheduling_InstanceTerminationAction = 0
	// Delete the VM.
	Scheduling_DELETE Scheduling_InstanceTerminationAction = 1
	// Stop the VM without storing in-memory content. default action.
	Scheduling_STOP Scheduling_InstanceTerminationAction = 2
)

// Enum value maps for Scheduling_InstanceTerminationAction.
var (
	Scheduling_InstanceTerminationAction_name = map[int32]string{
		0: "INSTANCE_TERMINATION_ACTION_UNSPECIFIED",
		1: "DELETE",
		2: "STOP",
	}
	Scheduling_InstanceTerminationAction_value = map[string]int32{
		"INSTANCE_TERMINATION_ACTION_UNSPECIFIED": 0,
		"DELETE": 1,
		"STOP":   2,
	}
)

func (x Scheduling_InstanceTerminationAction) Enum() *Scheduling_InstanceTerminationAction {
	p := new(Scheduling_InstanceTerminationAction)
	*p = x
	return p
}

func (x Scheduling_InstanceTerminationAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_InstanceTerminationAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[11].Descriptor()
}

func (Scheduling_InstanceTerminationAction) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[11]
}

func (x Scheduling_InstanceTerminationAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_InstanceTerminationAction.Descriptor instead.
func (Scheduling_InstanceTerminationAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{17, 2}
}

// Defines the type of node selections.
type Scheduling_NodeAffinity_Operator int32

const (
	// Default value. This value is unused.
	Scheduling_NodeAffinity_OPERATOR_UNSPECIFIED Scheduling_NodeAffinity_Operator = 0
	// Requires Compute Engine to seek for matched nodes.
	Scheduling_NodeAffinity_IN Scheduling_NodeAffinity_Operator = 1
	// Requires Compute Engine to avoid certain nodes.
	Scheduling_NodeAffinity_NOT_IN Scheduling_NodeAffinity_Operator = 2
)

// Enum value maps for Scheduling_NodeAffinity_Operator.
var (
	Scheduling_NodeAffinity_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "IN",
		2: "NOT_IN",
	}
	Scheduling_NodeAffinity_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"IN":                   1,
		"NOT_IN":               2,
	}
)

func (x Scheduling_NodeAffinity_Operator) Enum() *Scheduling_NodeAffinity_Operator {
	p := new(Scheduling_NodeAffinity_Operator)
	*p = x
	return p
}

func (x Scheduling_NodeAffinity_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_NodeAffinity_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[12].Descriptor()
}

func (Scheduling_NodeAffinity_Operator) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[12]
}

func (x Scheduling_NodeAffinity_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_NodeAffinity_Operator.Descriptor instead.
func (Scheduling_NodeAffinity_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{17, 0, 0}
}

// List of the Disk Types.
type AttachedDisk_DiskType int32

const (
	// Default value, which is unused.
	AttachedDisk_DISK_TYPE_UNSPECIFIED AttachedDisk_DiskType = 0
	// A scratch disk type.
	AttachedDisk_SCRATCH AttachedDisk_DiskType = 1
	// A persistent disk type.
	AttachedDisk_PERSISTENT AttachedDisk_DiskType = 2
)

// Enum value maps for AttachedDisk_DiskType.
var (
	AttachedDisk_DiskType_name = map[int32]string{
		0: "DISK_TYPE_UNSPECIFIED",
		1: "SCRATCH",
		2: "PERSISTENT",
	}
	AttachedDisk_DiskType_value = map[string]int32{
		"DISK_TYPE_UNSPECIFIED": 0,
		"SCRATCH":               1,
		"PERSISTENT":            2,
	}
)

func (x AttachedDisk_DiskType) Enum() *AttachedDisk_DiskType {
	p := new(AttachedDisk_DiskType)
	*p = x
	return p
}

func (x AttachedDisk_DiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_DiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[13].Descriptor()
}

func (AttachedDisk_DiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[13]
}

func (x AttachedDisk_DiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_DiskType.Descriptor instead.
func (AttachedDisk_DiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{21, 0}
}

// List of the Disk Modes.
type AttachedDisk_DiskMode int32

const (
	// Default value, which is unused.
	AttachedDisk_DISK_MODE_UNSPECIFIED AttachedDisk_DiskMode = 0
	// Attaches this disk in read-write mode. Only one
	// virtual machine at a time can be attached to a disk in read-write mode.
	AttachedDisk_READ_WRITE AttachedDisk_DiskMode = 1
	// Attaches this disk in read-only mode. Multiple virtual machines can use
	// a disk in read-only mode at a time.
	AttachedDisk_READ_ONLY AttachedDisk_DiskMode = 2
	// The disk is locked for administrative reasons. Nobody else
	// can use the disk. This mode is used (for example) when taking
	// a snapshot of a disk to prevent mounting the disk while it is
	// being snapshotted.
	AttachedDisk_LOCKED AttachedDisk_DiskMode = 3
)

// Enum value maps for AttachedDisk_DiskMode.
var (
	AttachedDisk_DiskMode_name = map[int32]string{
		0: "DISK_MODE_UNSPECIFIED",
		1: "READ_WRITE",
		2: "READ_ONLY",
		3: "LOCKED",
	}
	AttachedDisk_DiskMode_value = map[string]int32{
		"DISK_MODE_UNSPECIFIED": 0,
		"READ_WRITE":            1,
		"READ_ONLY":             2,
		"LOCKED":                3,
	}
)

func (x AttachedDisk_DiskMode) Enum() *AttachedDisk_DiskMode {
	p := new(AttachedDisk_DiskMode)
	*p = x
	return p
}

func (x AttachedDisk_DiskMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_DiskMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[14].Descriptor()
}

func (AttachedDisk_DiskMode) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[14]
}

func (x AttachedDisk_DiskMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_DiskMode.Descriptor instead.
func (AttachedDisk_DiskMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{21, 1}
}

// List of the Disk Interfaces.
type AttachedDisk_DiskInterface int32

const (
	// Default value, which is unused.
	AttachedDisk_DISK_INTERFACE_UNSPECIFIED AttachedDisk_DiskInterface = 0
	// SCSI Disk Interface.
	AttachedDisk_SCSI AttachedDisk_DiskInterface = 1
	// NVME Disk Interface.
	AttachedDisk_NVME AttachedDisk_DiskInterface = 2
	// NVDIMM Disk Interface.
	AttachedDisk_NVDIMM AttachedDisk_DiskInterface = 3
	// ISCSI Disk Interface.
	AttachedDisk_ISCSI AttachedDisk_DiskInterface = 4
)

// Enum value maps for AttachedDisk_DiskInterface.
var (
	AttachedDisk_DiskInterface_name = map[int32]string{
		0: "DISK_INTERFACE_UNSPECIFIED",
		1: "SCSI",
		2: "NVME",
		3: "NVDIMM",
		4: "ISCSI",
	}
	AttachedDisk_DiskInterface_value = map[string]int32{
		"DISK_INTERFACE_UNSPECIFIED": 0,
		"SCSI":                       1,
		"NVME":                       2,
		"NVDIMM":                     3,
		"ISCSI":                      4,
	}
)

func (x AttachedDisk_DiskInterface) Enum() *AttachedDisk_DiskInterface {
	p := new(AttachedDisk_DiskInterface)
	*p = x
	return p
}

func (x AttachedDisk_DiskInterface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_DiskInterface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[15].Descriptor()
}

func (AttachedDisk_DiskInterface) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[15]
}

func (x AttachedDisk_DiskInterface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_DiskInterface.Descriptor instead.
func (AttachedDisk_DiskInterface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{21, 2}
}

// List of the states of the Disk.
type AttachedDisk_DiskSavedState int32

const (
	// Default Disk state has not been preserved.
	AttachedDisk_DISK_SAVED_STATE_UNSPECIFIED AttachedDisk_DiskSavedState = 0
	// Disk state has been preserved.
	AttachedDisk_PRESERVED AttachedDisk_DiskSavedState = 1
)

// Enum value maps for AttachedDisk_DiskSavedState.
var (
	AttachedDisk_DiskSavedState_name = map[int32]string{
		0: "DISK_SAVED_STATE_UNSPECIFIED",
		1: "PRESERVED",
	}
	AttachedDisk_DiskSavedState_value = map[string]int32{
		"DISK_SAVED_STATE_UNSPECIFIED": 0,
		"PRESERVED":                    1,
	}
)

func (x AttachedDisk_DiskSavedState) Enum() *AttachedDisk_DiskSavedState {
	p := new(AttachedDisk_DiskSavedState)
	*p = x
	return p
}

func (x AttachedDisk_DiskSavedState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_DiskSavedState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[16].Descriptor()
}

func (AttachedDisk_DiskSavedState) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[16]
}

func (x AttachedDisk_DiskSavedState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_DiskSavedState.Descriptor instead.
func (AttachedDisk_DiskSavedState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{21, 3}
}

// List of the Feature Types.
type GuestOsFeature_FeatureType int32

const (
	// Default value, which is unused.
	GuestOsFeature_FEATURE_TYPE_UNSPECIFIED GuestOsFeature_FeatureType = 0
	// VIRTIO_SCSI_MULTIQUEUE feature type.
	GuestOsFeature_VIRTIO_SCSI_MULTIQUEUE GuestOsFeature_FeatureType = 1
	// WINDOWS feature type.
	GuestOsFeature_WINDOWS GuestOsFeature_FeatureType = 2
	// MULTI_IP_SUBNET feature type.
	GuestOsFeature_MULTI_IP_SUBNET GuestOsFeature_FeatureType = 3
	// UEFI_COMPATIBLE feature type.
	GuestOsFeature_UEFI_COMPATIBLE GuestOsFeature_FeatureType = 4
	// SECURE_BOOT feature type.
	GuestOsFeature_SECURE_BOOT GuestOsFeature_FeatureType = 5
	// GVNIC feature type.
	GuestOsFeature_GVNIC GuestOsFeature_FeatureType = 6
	// SEV_CAPABLE feature type.
	GuestOsFeature_SEV_CAPABLE GuestOsFeature_FeatureType = 7
	// BARE_METAL_LINUX_COMPATIBLE feature type.
	GuestOsFeature_BARE_METAL_LINUX_COMPATIBLE GuestOsFeature_FeatureType = 8
	// SUSPEND_RESUME_COMPATIBLE feature type.
	GuestOsFeature_SUSPEND_RESUME_COMPATIBLE GuestOsFeature_FeatureType = 9
	// SEV_LIVE_MIGRATABLE feature type.
	GuestOsFeature_SEV_LIVE_MIGRATABLE GuestOsFeature_FeatureType = 10
	// SEV_SNP_CAPABLE feature type.
	GuestOsFeature_SEV_SNP_CAPABLE GuestOsFeature_FeatureType = 11
	// TDX_CAPABLE feature type.
	GuestOsFeature_TDX_CAPABLE GuestOsFeature_FeatureType = 12
	// IDPF feature type.
	GuestOsFeature_IDPF GuestOsFeature_FeatureType = 13
	// SEV_LIVE_MIGRATABLE_V2 feature type.
	GuestOsFeature_SEV_LIVE_MIGRATABLE_V2 GuestOsFeature_FeatureType = 14
)

// Enum value maps for GuestOsFeature_FeatureType.
var (
	GuestOsFeature_FeatureType_name = map[int32]string{
		0:  "FEATURE_TYPE_UNSPECIFIED",
		1:  "VIRTIO_SCSI_MULTIQUEUE",
		2:  "WINDOWS",
		3:  "MULTI_IP_SUBNET",
		4:  "UEFI_COMPATIBLE",
		5:  "SECURE_BOOT",
		6:  "GVNIC",
		7:  "SEV_CAPABLE",
		8:  "BARE_METAL_LINUX_COMPATIBLE",
		9:  "SUSPEND_RESUME_COMPATIBLE",
		10: "SEV_LIVE_MIGRATABLE",
		11: "SEV_SNP_CAPABLE",
		12: "TDX_CAPABLE",
		13: "IDPF",
		14: "SEV_LIVE_MIGRATABLE_V2",
	}
	GuestOsFeature_FeatureType_value = map[string]int32{
		"FEATURE_TYPE_UNSPECIFIED":    0,
		"VIRTIO_SCSI_MULTIQUEUE":      1,
		"WINDOWS":                     2,
		"MULTI_IP_SUBNET":             3,
		"UEFI_COMPATIBLE":             4,
		"SECURE_BOOT":                 5,
		"GVNIC":                       6,
		"SEV_CAPABLE":                 7,
		"BARE_METAL_LINUX_COMPATIBLE": 8,
		"SUSPEND_RESUME_COMPATIBLE":   9,
		"SEV_LIVE_MIGRATABLE":         10,
		"SEV_SNP_CAPABLE":             11,
		"TDX_CAPABLE":                 12,
		"IDPF":                        13,
		"SEV_LIVE_MIGRATABLE_V2":      14,
	}
)

func (x GuestOsFeature_FeatureType) Enum() *GuestOsFeature_FeatureType {
	p := new(GuestOsFeature_FeatureType)
	*p = x
	return p
}

func (x GuestOsFeature_FeatureType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestOsFeature_FeatureType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[17].Descriptor()
}

func (GuestOsFeature_FeatureType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes[17]
}

func (x GuestOsFeature_FeatureType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestOsFeature_FeatureType.Descriptor instead.
func (GuestOsFeature_FeatureType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{22, 0}
}

// ComputeInstanceBackupProperties represents Compute Engine instance backup
// properties.
type ComputeInstanceBackupProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional text description for the instances that are created from these
	// properties.
	Description *string `protobuf:"bytes,1,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// A list of tags to apply to the instances that are created from these
	// properties. The tags identify valid sources or targets for network
	// firewalls. The setTags method can modify this list of tags. Each tag within
	// the list must comply with RFC1035 (https://www.ietf.org/rfc/rfc1035.txt).
	Tags *Tags `protobuf:"bytes,2,opt,name=tags,proto3,oneof" json:"tags,omitempty"`
	// The machine type to use for instances that are created from these
	// properties.
	MachineType *string `protobuf:"bytes,3,opt,name=machine_type,json=machineType,proto3,oneof" json:"machine_type,omitempty"`
	// Enables instances created based on these properties to send packets with
	// source IP addresses other than their own and receive packets with
	// destination IP addresses other than their own. If these instances will be
	// used as an IP gateway or it will be set as the next-hop in a Route
	// resource, specify `true`. If unsure, leave this set to `false`. See the
	// https://cloud.google.com/vpc/docs/using-routes#canipforward
	// documentation for more information.
	CanIpForward *bool `protobuf:"varint,4,opt,name=can_ip_forward,json=canIpForward,proto3,oneof" json:"can_ip_forward,omitempty"`
	// An array of network access configurations for this interface.
	NetworkInterface []*NetworkInterface `protobuf:"bytes,5,rep,name=network_interface,json=networkInterface,proto3" json:"network_interface,omitempty"`
	// An array of disks that are associated with the instances that are created
	// from these properties.
	Disk []*AttachedDisk `protobuf:"bytes,6,rep,name=disk,proto3" json:"disk,omitempty"`
	// The metadata key/value pairs to assign to instances that are created from
	// these properties. These pairs can consist of custom metadata or predefined
	// keys. See https://cloud.google.com/compute/docs/metadata/overview for more
	// information.
	Metadata *Metadata `protobuf:"bytes,7,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
	// A list of service accounts with specified scopes. Access tokens for these
	// service accounts are available to the instances that are created from
	// these properties. Use metadata queries to obtain the access tokens for
	// these instances.
	ServiceAccount []*ServiceAccount `protobuf:"bytes,8,rep,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Specifies the scheduling options for the instances that are created from
	// these properties.
	Scheduling *Scheduling `protobuf:"bytes,9,opt,name=scheduling,proto3,oneof" json:"scheduling,omitempty"`
	// A list of guest accelerator cards' type and count to use for instances
	// created from these properties.
	GuestAccelerator []*AcceleratorConfig `protobuf:"bytes,10,rep,name=guest_accelerator,json=guestAccelerator,proto3" json:"guest_accelerator,omitempty"`
	// Minimum cpu/platform to be used by instances. The instance may be
	// scheduled on the specified or newer cpu/platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// `minCpuPlatform: Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`.
	// For more information, read
	// https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
	MinCpuPlatform *string `protobuf:"bytes,11,opt,name=min_cpu_platform,json=minCpuPlatform,proto3,oneof" json:"min_cpu_platform,omitempty"`
	// KeyRevocationActionType of the instance. Supported options are "STOP" and
	// "NONE". The default value is "NONE" if it is not specified.
	KeyRevocationActionType *KeyRevocationActionType `protobuf:"varint,12,opt,name=key_revocation_action_type,json=keyRevocationActionType,proto3,enum=google.cloud.backupdr.v1.KeyRevocationActionType,oneof" json:"key_revocation_action_type,omitempty"`
	// The source instance used to create this backup. This can be a partial or
	// full URL to the resource. For example, the following are valid values:
	//
	//	-https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
	//	-projects/project/zones/zone/instances/instance
	SourceInstance *string `protobuf:"bytes,13,opt,name=source_instance,json=sourceInstance,proto3,oneof" json:"source_instance,omitempty"`
	// Labels to apply to instances that are created from these properties.
	Labels map[string]string `protobuf:"bytes,14,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ComputeInstanceBackupProperties) Reset() {
	*x = ComputeInstanceBackupProperties{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeInstanceBackupProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeInstanceBackupProperties) ProtoMessage() {}

func (x *ComputeInstanceBackupProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeInstanceBackupProperties.ProtoReflect.Descriptor instead.
func (*ComputeInstanceBackupProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeInstanceBackupProperties) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *ComputeInstanceBackupProperties) GetTags() *Tags {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetMachineType() string {
	if x != nil && x.MachineType != nil {
		return *x.MachineType
	}
	return ""
}

func (x *ComputeInstanceBackupProperties) GetCanIpForward() bool {
	if x != nil && x.CanIpForward != nil {
		return *x.CanIpForward
	}
	return false
}

func (x *ComputeInstanceBackupProperties) GetNetworkInterface() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterface
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetDisk() []*AttachedDisk {
	if x != nil {
		return x.Disk
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetServiceAccount() []*ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetScheduling() *Scheduling {
	if x != nil {
		return x.Scheduling
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetGuestAccelerator() []*AcceleratorConfig {
	if x != nil {
		return x.GuestAccelerator
	}
	return nil
}

func (x *ComputeInstanceBackupProperties) GetMinCpuPlatform() string {
	if x != nil && x.MinCpuPlatform != nil {
		return *x.MinCpuPlatform
	}
	return ""
}

func (x *ComputeInstanceBackupProperties) GetKeyRevocationActionType() KeyRevocationActionType {
	if x != nil && x.KeyRevocationActionType != nil {
		return *x.KeyRevocationActionType
	}
	return KeyRevocationActionType_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED
}

func (x *ComputeInstanceBackupProperties) GetSourceInstance() string {
	if x != nil && x.SourceInstance != nil {
		return *x.SourceInstance
	}
	return ""
}

func (x *ComputeInstanceBackupProperties) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// ComputeInstanceRestoreProperties represents Compute Engine instance
// properties to be overridden during restore.
type ComputeInstanceRestoreProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the compute instance.
	Name *string `protobuf:"bytes,1,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Optional. Controls for advanced machine-related behavior features.
	AdvancedMachineFeatures *AdvancedMachineFeatures `protobuf:"bytes,2,opt,name=advanced_machine_features,json=advancedMachineFeatures,proto3,oneof" json:"advanced_machine_features,omitempty"`
	// Optional. Allows this instance to send and receive packets with
	// non-matching destination or source IPs.
	CanIpForward *bool `protobuf:"varint,3,opt,name=can_ip_forward,json=canIpForward,proto3,oneof" json:"can_ip_forward,omitempty"`
	// Optional. Controls Confidential compute options on the instance
	ConfidentialInstanceConfig *ConfidentialInstanceConfig `protobuf:"bytes,4,opt,name=confidential_instance_config,json=confidentialInstanceConfig,proto3,oneof" json:"confidential_instance_config,omitempty"`
	// Optional. Whether the resource should be protected against deletion.
	DeletionProtection *bool `protobuf:"varint,5,opt,name=deletion_protection,json=deletionProtection,proto3,oneof" json:"deletion_protection,omitempty"`
	// Optional. An optional description of this resource. Provide this property
	// when you create the resource.
	Description *string `protobuf:"bytes,6,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Optional. Array of disks associated with this instance. Persistent disks
	// must be created before you can assign them.
	Disks []*AttachedDisk `protobuf:"bytes,7,rep,name=disks,proto3" json:"disks,omitempty"`
	// Optional. Enables display device for the instance.
	DisplayDevice *DisplayDevice `protobuf:"bytes,8,opt,name=display_device,json=displayDevice,proto3,oneof" json:"display_device,omitempty"`
	// Optional. A list of the type and count of accelerator cards attached to the
	// instance.
	GuestAccelerators []*AcceleratorConfig `protobuf:"bytes,9,rep,name=guest_accelerators,json=guestAccelerators,proto3" json:"guest_accelerators,omitempty"`
	// Optional. Specifies the hostname of the instance. The specified hostname
	// must be RFC1035 compliant. If hostname is not specified, the default
	// hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global
	// DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal
	// DNS.
	Hostname *string `protobuf:"bytes,10,opt,name=hostname,proto3,oneof" json:"hostname,omitempty"`
	// Optional. Encrypts suspended data for an instance with a
	// customer-managed encryption key.
	InstanceEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,11,opt,name=instance_encryption_key,json=instanceEncryptionKey,proto3,oneof" json:"instance_encryption_key,omitempty"`
	// Optional. KeyRevocationActionType of the instance.
	KeyRevocationActionType *KeyRevocationActionType `protobuf:"varint,12,opt,name=key_revocation_action_type,json=keyRevocationActionType,proto3,enum=google.cloud.backupdr.v1.KeyRevocationActionType,oneof" json:"key_revocation_action_type,omitempty"`
	// Optional. Labels to apply to this instance.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Full or partial URL of the machine type resource to use for this
	// instance.
	MachineType *string `protobuf:"bytes,14,opt,name=machine_type,json=machineType,proto3,oneof" json:"machine_type,omitempty"`
	// Optional. This includes custom metadata and predefined keys.
	Metadata *Metadata `protobuf:"bytes,15,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
	// Optional. Minimum CPU platform to use for this instance.
	MinCpuPlatform *string `protobuf:"bytes,16,opt,name=min_cpu_platform,json=minCpuPlatform,proto3,oneof" json:"min_cpu_platform,omitempty"`
	// Optional. An array of network configurations for this instance. These
	// specify how interfaces are configured to interact with other network
	// services, such as connecting to the internet. Multiple interfaces are
	// supported per instance.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,17,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// Optional. Configure network performance such as egress bandwidth tier.
	NetworkPerformanceConfig *NetworkPerformanceConfig `protobuf:"bytes,18,opt,name=network_performance_config,json=networkPerformanceConfig,proto3,oneof" json:"network_performance_config,omitempty"`
	// Input only. Additional params passed with the request, but not persisted
	// as part of resource payload.
	Params *InstanceParams `protobuf:"bytes,19,opt,name=params,proto3,oneof" json:"params,omitempty"`
	// Optional. The private IPv6 google access type for the VM.
	// If not specified, use INHERIT_FROM_SUBNETWORK as default.
	PrivateIpv6GoogleAccess *ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess `protobuf:"varint,20,opt,name=private_ipv6_google_access,json=privateIpv6GoogleAccess,proto3,enum=google.cloud.backupdr.v1.ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess,oneof" json:"private_ipv6_google_access,omitempty"`
	// Optional. Specifies the reservations that this instance can consume from.
	AllocationAffinity *AllocationAffinity `protobuf:"bytes,21,opt,name=allocation_affinity,json=allocationAffinity,proto3,oneof" json:"allocation_affinity,omitempty"`
	// Optional. Resource policies applied to this instance.
	ResourcePolicies []string `protobuf:"bytes,22,rep,name=resource_policies,json=resourcePolicies,proto3" json:"resource_policies,omitempty"`
	// Optional. Sets the scheduling options for this instance.
	Scheduling *Scheduling `protobuf:"bytes,23,opt,name=scheduling,proto3,oneof" json:"scheduling,omitempty"`
	// Optional. A list of service accounts, with their specified scopes,
	// authorized for this instance. Only one service account per VM instance is
	// supported.
	ServiceAccounts []*ServiceAccount `protobuf:"bytes,24,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	// Optional. Tags to apply to this instance. Tags are used to identify valid
	// sources or targets for network firewalls and are specified by the client
	// during instance creation.
	Tags *Tags `protobuf:"bytes,26,opt,name=tags,proto3,oneof" json:"tags,omitempty"`
}

func (x *ComputeInstanceRestoreProperties) Reset() {
	*x = ComputeInstanceRestoreProperties{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeInstanceRestoreProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeInstanceRestoreProperties) ProtoMessage() {}

func (x *ComputeInstanceRestoreProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeInstanceRestoreProperties.ProtoReflect.Descriptor instead.
func (*ComputeInstanceRestoreProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{1}
}

func (x *ComputeInstanceRestoreProperties) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *ComputeInstanceRestoreProperties) GetAdvancedMachineFeatures() *AdvancedMachineFeatures {
	if x != nil {
		return x.AdvancedMachineFeatures
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetCanIpForward() bool {
	if x != nil && x.CanIpForward != nil {
		return *x.CanIpForward
	}
	return false
}

func (x *ComputeInstanceRestoreProperties) GetConfidentialInstanceConfig() *ConfidentialInstanceConfig {
	if x != nil {
		return x.ConfidentialInstanceConfig
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetDeletionProtection() bool {
	if x != nil && x.DeletionProtection != nil {
		return *x.DeletionProtection
	}
	return false
}

func (x *ComputeInstanceRestoreProperties) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *ComputeInstanceRestoreProperties) GetDisks() []*AttachedDisk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetDisplayDevice() *DisplayDevice {
	if x != nil {
		return x.DisplayDevice
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetGuestAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.GuestAccelerators
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetHostname() string {
	if x != nil && x.Hostname != nil {
		return *x.Hostname
	}
	return ""
}

func (x *ComputeInstanceRestoreProperties) GetInstanceEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.InstanceEncryptionKey
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetKeyRevocationActionType() KeyRevocationActionType {
	if x != nil && x.KeyRevocationActionType != nil {
		return *x.KeyRevocationActionType
	}
	return KeyRevocationActionType_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED
}

func (x *ComputeInstanceRestoreProperties) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetMachineType() string {
	if x != nil && x.MachineType != nil {
		return *x.MachineType
	}
	return ""
}

func (x *ComputeInstanceRestoreProperties) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetMinCpuPlatform() string {
	if x != nil && x.MinCpuPlatform != nil {
		return *x.MinCpuPlatform
	}
	return ""
}

func (x *ComputeInstanceRestoreProperties) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetNetworkPerformanceConfig() *NetworkPerformanceConfig {
	if x != nil {
		return x.NetworkPerformanceConfig
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetParams() *InstanceParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetPrivateIpv6GoogleAccess() ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess {
	if x != nil && x.PrivateIpv6GoogleAccess != nil {
		return *x.PrivateIpv6GoogleAccess
	}
	return ComputeInstanceRestoreProperties_INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
}

func (x *ComputeInstanceRestoreProperties) GetAllocationAffinity() *AllocationAffinity {
	if x != nil {
		return x.AllocationAffinity
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetResourcePolicies() []string {
	if x != nil {
		return x.ResourcePolicies
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetScheduling() *Scheduling {
	if x != nil {
		return x.Scheduling
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetServiceAccounts() []*ServiceAccount {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

func (x *ComputeInstanceRestoreProperties) GetTags() *Tags {
	if x != nil {
		return x.Tags
	}
	return nil
}

// ComputeInstanceTargetEnvironment represents Compute Engine target
// environment to be used during restore.
type ComputeInstanceTargetEnvironment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Target project for the Compute Engine instance.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Required. The zone of the Compute Engine instance.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *ComputeInstanceTargetEnvironment) Reset() {
	*x = ComputeInstanceTargetEnvironment{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeInstanceTargetEnvironment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeInstanceTargetEnvironment) ProtoMessage() {}

func (x *ComputeInstanceTargetEnvironment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeInstanceTargetEnvironment.ProtoReflect.Descriptor instead.
func (*ComputeInstanceTargetEnvironment) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{2}
}

func (x *ComputeInstanceTargetEnvironment) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ComputeInstanceTargetEnvironment) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// ComputeInstanceDataSourceProperties represents the properties of a
// ComputeEngine resource that are stored in the DataSource.
type ComputeInstanceDataSourceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the compute instance backed up by the datasource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the Compute Engine instance.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The machine type of the instance.
	MachineType string `protobuf:"bytes,3,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// The total number of disks attached to the Instance.
	TotalDiskCount int64 `protobuf:"varint,4,opt,name=total_disk_count,json=totalDiskCount,proto3" json:"total_disk_count,omitempty"`
	// The sum of all the disk sizes.
	TotalDiskSizeGb int64 `protobuf:"varint,5,opt,name=total_disk_size_gb,json=totalDiskSizeGb,proto3" json:"total_disk_size_gb,omitempty"`
}

func (x *ComputeInstanceDataSourceProperties) Reset() {
	*x = ComputeInstanceDataSourceProperties{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeInstanceDataSourceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeInstanceDataSourceProperties) ProtoMessage() {}

func (x *ComputeInstanceDataSourceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeInstanceDataSourceProperties.ProtoReflect.Descriptor instead.
func (*ComputeInstanceDataSourceProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{3}
}

func (x *ComputeInstanceDataSourceProperties) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ComputeInstanceDataSourceProperties) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ComputeInstanceDataSourceProperties) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeInstanceDataSourceProperties) GetTotalDiskCount() int64 {
	if x != nil {
		return x.TotalDiskCount
	}
	return 0
}

func (x *ComputeInstanceDataSourceProperties) GetTotalDiskSizeGb() int64 {
	if x != nil {
		return x.TotalDiskSizeGb
	}
	return 0
}

// Specifies options for controlling advanced machine features.
type AdvancedMachineFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to enable nested virtualization or not (default is
	// false).
	EnableNestedVirtualization *bool `protobuf:"varint,1,opt,name=enable_nested_virtualization,json=enableNestedVirtualization,proto3,oneof" json:"enable_nested_virtualization,omitempty"`
	// Optional. The number of threads per physical core. To disable simultaneous
	// multithreading (SMT) set this to 1. If unset, the maximum number
	// of threads supported per core by the underlying processor is
	// assumed.
	ThreadsPerCore *int32 `protobuf:"varint,2,opt,name=threads_per_core,json=threadsPerCore,proto3,oneof" json:"threads_per_core,omitempty"`
	// Optional. The number of physical cores to expose to an instance. Multiply
	// by the number of threads per core to compute the total number of virtual
	// CPUs to expose to the instance. If unset, the number of cores is
	// inferred from the instance's nominal CPU count and the underlying
	// platform's SMT width.
	VisibleCoreCount *int32 `protobuf:"varint,3,opt,name=visible_core_count,json=visibleCoreCount,proto3,oneof" json:"visible_core_count,omitempty"`
	// Optional. Whether to enable UEFI networking for instance creation.
	EnableUefiNetworking *bool `protobuf:"varint,4,opt,name=enable_uefi_networking,json=enableUefiNetworking,proto3,oneof" json:"enable_uefi_networking,omitempty"`
}

func (x *AdvancedMachineFeatures) Reset() {
	*x = AdvancedMachineFeatures{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedMachineFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedMachineFeatures) ProtoMessage() {}

func (x *AdvancedMachineFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedMachineFeatures.ProtoReflect.Descriptor instead.
func (*AdvancedMachineFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{4}
}

func (x *AdvancedMachineFeatures) GetEnableNestedVirtualization() bool {
	if x != nil && x.EnableNestedVirtualization != nil {
		return *x.EnableNestedVirtualization
	}
	return false
}

func (x *AdvancedMachineFeatures) GetThreadsPerCore() int32 {
	if x != nil && x.ThreadsPerCore != nil {
		return *x.ThreadsPerCore
	}
	return 0
}

func (x *AdvancedMachineFeatures) GetVisibleCoreCount() int32 {
	if x != nil && x.VisibleCoreCount != nil {
		return *x.VisibleCoreCount
	}
	return 0
}

func (x *AdvancedMachineFeatures) GetEnableUefiNetworking() bool {
	if x != nil && x.EnableUefiNetworking != nil {
		return *x.EnableUefiNetworking
	}
	return false
}

// A set of Confidential Instance options.
type ConfidentialInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines whether the instance should have confidential compute
	// enabled.
	EnableConfidentialCompute *bool `protobuf:"varint,1,opt,name=enable_confidential_compute,json=enableConfidentialCompute,proto3,oneof" json:"enable_confidential_compute,omitempty"`
}

func (x *ConfidentialInstanceConfig) Reset() {
	*x = ConfidentialInstanceConfig{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfidentialInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfidentialInstanceConfig) ProtoMessage() {}

func (x *ConfidentialInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfidentialInstanceConfig.ProtoReflect.Descriptor instead.
func (*ConfidentialInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{5}
}

func (x *ConfidentialInstanceConfig) GetEnableConfidentialCompute() bool {
	if x != nil && x.EnableConfidentialCompute != nil {
		return *x.EnableConfidentialCompute
	}
	return false
}

// A set of Display Device options
type DisplayDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Enables display for the Compute Engine VM
	EnableDisplay *bool `protobuf:"varint,1,opt,name=enable_display,json=enableDisplay,proto3,oneof" json:"enable_display,omitempty"`
}

func (x *DisplayDevice) Reset() {
	*x = DisplayDevice{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayDevice) ProtoMessage() {}

func (x *DisplayDevice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayDevice.ProtoReflect.Descriptor instead.
func (*DisplayDevice) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{6}
}

func (x *DisplayDevice) GetEnableDisplay() bool {
	if x != nil && x.EnableDisplay != nil {
		return *x.EnableDisplay
	}
	return false
}

// A specification of the type and number of accelerator cards attached to the
// instance.
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Full or partial URL of the accelerator type resource to attach to
	// this instance.
	AcceleratorType *string `protobuf:"bytes,1,opt,name=accelerator_type,json=acceleratorType,proto3,oneof" json:"accelerator_type,omitempty"`
	// Optional. The number of the guest accelerator cards exposed to this
	// instance.
	AcceleratorCount *int32 `protobuf:"varint,2,opt,name=accelerator_count,json=acceleratorCount,proto3,oneof" json:"accelerator_count,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{7}
}

func (x *AcceleratorConfig) GetAcceleratorType() string {
	if x != nil && x.AcceleratorType != nil {
		return *x.AcceleratorType
	}
	return ""
}

func (x *AcceleratorConfig) GetAcceleratorCount() int32 {
	if x != nil && x.AcceleratorCount != nil {
		return *x.AcceleratorCount
	}
	return 0
}

// A customer-supplied encryption key.
type CustomerEncryptionKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key to use for encryption.
	//
	// Types that are assignable to Key:
	//
	//	*CustomerEncryptionKey_RawKey
	//	*CustomerEncryptionKey_RsaEncryptedKey
	//	*CustomerEncryptionKey_KmsKeyName
	Key isCustomerEncryptionKey_Key `protobuf_oneof:"key"`
	// Optional. The service account being used for the encryption request for the
	// given KMS key. If absent, the Compute Engine default service account is
	// used.
	KmsKeyServiceAccount *string `protobuf:"bytes,4,opt,name=kms_key_service_account,json=kmsKeyServiceAccount,proto3,oneof" json:"kms_key_service_account,omitempty"`
}

func (x *CustomerEncryptionKey) Reset() {
	*x = CustomerEncryptionKey{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomerEncryptionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerEncryptionKey) ProtoMessage() {}

func (x *CustomerEncryptionKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerEncryptionKey.ProtoReflect.Descriptor instead.
func (*CustomerEncryptionKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{8}
}

func (m *CustomerEncryptionKey) GetKey() isCustomerEncryptionKey_Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (x *CustomerEncryptionKey) GetRawKey() string {
	if x, ok := x.GetKey().(*CustomerEncryptionKey_RawKey); ok {
		return x.RawKey
	}
	return ""
}

func (x *CustomerEncryptionKey) GetRsaEncryptedKey() string {
	if x, ok := x.GetKey().(*CustomerEncryptionKey_RsaEncryptedKey); ok {
		return x.RsaEncryptedKey
	}
	return ""
}

func (x *CustomerEncryptionKey) GetKmsKeyName() string {
	if x, ok := x.GetKey().(*CustomerEncryptionKey_KmsKeyName); ok {
		return x.KmsKeyName
	}
	return ""
}

func (x *CustomerEncryptionKey) GetKmsKeyServiceAccount() string {
	if x != nil && x.KmsKeyServiceAccount != nil {
		return *x.KmsKeyServiceAccount
	}
	return ""
}

type isCustomerEncryptionKey_Key interface {
	isCustomerEncryptionKey_Key()
}

type CustomerEncryptionKey_RawKey struct {
	// Optional. Specifies a 256-bit customer-supplied
	// encryption key.
	RawKey string `protobuf:"bytes,1,opt,name=raw_key,json=rawKey,proto3,oneof"`
}

type CustomerEncryptionKey_RsaEncryptedKey struct {
	// Optional. RSA-wrapped 2048-bit
	// customer-supplied encryption key to either encrypt or decrypt this
	// resource.
	RsaEncryptedKey string `protobuf:"bytes,2,opt,name=rsa_encrypted_key,json=rsaEncryptedKey,proto3,oneof"`
}

type CustomerEncryptionKey_KmsKeyName struct {
	// Optional. The name of the encryption key that is stored in Google Cloud
	// KMS.
	KmsKeyName string `protobuf:"bytes,3,opt,name=kms_key_name,json=kmsKeyName,proto3,oneof"`
}

func (*CustomerEncryptionKey_RawKey) isCustomerEncryptionKey_Key() {}

func (*CustomerEncryptionKey_RsaEncryptedKey) isCustomerEncryptionKey_Key() {}

func (*CustomerEncryptionKey_KmsKeyName) isCustomerEncryptionKey_Key() {}

// A key/value pair to be used for storing metadata.
type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Key for the metadata entry.
	Key *string `protobuf:"bytes,1,opt,name=key,proto3,oneof" json:"key,omitempty"`
	// Optional. Value for the metadata entry. These are free-form strings, and
	// only have meaning as interpreted by the image running in the instance. The
	// only restriction placed on values is that their size must be less than
	// or equal to 262144 bytes (256 KiB).
	Value *string `protobuf:"bytes,2,opt,name=value,proto3,oneof" json:"value,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{9}
}

func (x *Entry) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *Entry) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

// A metadata key/value entry.
type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Array of key/value pairs. The total size of all keys and values
	// must be less than 512 KB.
	Items []*Entry `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{10}
}

func (x *Metadata) GetItems() []*Entry {
	if x != nil {
		return x.Items
	}
	return nil
}

// A network interface resource attached to an instance.
// s
type NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. URL of the VPC network resource for this instance.
	Network *string `protobuf:"bytes,1,opt,name=network,proto3,oneof" json:"network,omitempty"`
	// Optional. The URL of the Subnetwork resource for this instance.
	Subnetwork *string `protobuf:"bytes,2,opt,name=subnetwork,proto3,oneof" json:"subnetwork,omitempty"`
	// Optional. An IPv4 internal IP address to assign to the instance for this
	// network interface. If not specified by the user, an unused internal IP is
	// assigned by the system.
	IpAddress *string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3,oneof" json:"ip_address,omitempty"`
	// Optional. An IPv6 internal network address for this network interface. To
	// use a static internal IP address, it must be unused and in the same region
	// as the instance's zone. If not specified, Google Cloud will automatically
	// assign an internal IPv6 address from the instance's subnetwork.
	Ipv6Address *string `protobuf:"bytes,4,opt,name=ipv6_address,json=ipv6Address,proto3,oneof" json:"ipv6_address,omitempty"`
	// Optional. The prefix length of the primary internal IPv6 range.
	InternalIpv6PrefixLength *int32 `protobuf:"varint,5,opt,name=internal_ipv6_prefix_length,json=internalIpv6PrefixLength,proto3,oneof" json:"internal_ipv6_prefix_length,omitempty"`
	// Output only. [Output Only] The name of the network interface, which is
	// generated by the server.
	Name *string `protobuf:"bytes,6,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Optional. An array of configurations for this interface. Currently, only
	// one access config,ONE_TO_ONE_NAT is supported. If there are no
	// accessConfigs specified, then this instance will have
	// no external internet access.
	AccessConfigs []*AccessConfig `protobuf:"bytes,7,rep,name=access_configs,json=accessConfigs,proto3" json:"access_configs,omitempty"`
	// Optional. An array of IPv6 access configurations for this interface.
	// Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there
	// is no ipv6AccessConfig specified, then this instance will
	// have no external IPv6 Internet access.
	Ipv6AccessConfigs []*AccessConfig `protobuf:"bytes,8,rep,name=ipv6_access_configs,json=ipv6AccessConfigs,proto3" json:"ipv6_access_configs,omitempty"`
	// Optional. An array of alias IP ranges for this network interface.
	// You can only specify this field for network interfaces in VPC networks.
	AliasIpRanges []*AliasIpRange `protobuf:"bytes,9,rep,name=alias_ip_ranges,json=aliasIpRanges,proto3" json:"alias_ip_ranges,omitempty"`
	// The stack type for this network interface.
	StackType *NetworkInterface_StackType `protobuf:"varint,10,opt,name=stack_type,json=stackType,proto3,enum=google.cloud.backupdr.v1.NetworkInterface_StackType,oneof" json:"stack_type,omitempty"`
	// Optional. [Output Only] One of EXTERNAL, INTERNAL to indicate whether the
	// IP can be accessed from the Internet. This field is always inherited from
	// its subnetwork.
	Ipv6AccessType *NetworkInterface_Ipv6AccessType `protobuf:"varint,11,opt,name=ipv6_access_type,json=ipv6AccessType,proto3,enum=google.cloud.backupdr.v1.NetworkInterface_Ipv6AccessType,oneof" json:"ipv6_access_type,omitempty"`
	// Optional. The networking queue count that's specified by users for the
	// network interface. Both Rx and Tx queues will be set to this number. It'll
	// be empty if not specified by the users.
	QueueCount *int32 `protobuf:"varint,12,opt,name=queue_count,json=queueCount,proto3,oneof" json:"queue_count,omitempty"`
	// Optional. The type of vNIC to be used on this interface. This may be gVNIC
	// or VirtioNet.
	NicType *NetworkInterface_NicType `protobuf:"varint,13,opt,name=nic_type,json=nicType,proto3,enum=google.cloud.backupdr.v1.NetworkInterface_NicType,oneof" json:"nic_type,omitempty"`
	// Optional. The URL of the network attachment that this interface should
	// connect to in the following format:
	// projects/{project_number}/regions/{region_name}/networkAttachments/{network_attachment_name}.
	NetworkAttachment *string `protobuf:"bytes,14,opt,name=network_attachment,json=networkAttachment,proto3,oneof" json:"network_attachment,omitempty"`
}

func (x *NetworkInterface) Reset() {
	*x = NetworkInterface{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterface) ProtoMessage() {}

func (x *NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterface.ProtoReflect.Descriptor instead.
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{11}
}

func (x *NetworkInterface) GetNetwork() string {
	if x != nil && x.Network != nil {
		return *x.Network
	}
	return ""
}

func (x *NetworkInterface) GetSubnetwork() string {
	if x != nil && x.Subnetwork != nil {
		return *x.Subnetwork
	}
	return ""
}

func (x *NetworkInterface) GetIpAddress() string {
	if x != nil && x.IpAddress != nil {
		return *x.IpAddress
	}
	return ""
}

func (x *NetworkInterface) GetIpv6Address() string {
	if x != nil && x.Ipv6Address != nil {
		return *x.Ipv6Address
	}
	return ""
}

func (x *NetworkInterface) GetInternalIpv6PrefixLength() int32 {
	if x != nil && x.InternalIpv6PrefixLength != nil {
		return *x.InternalIpv6PrefixLength
	}
	return 0
}

func (x *NetworkInterface) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *NetworkInterface) GetAccessConfigs() []*AccessConfig {
	if x != nil {
		return x.AccessConfigs
	}
	return nil
}

func (x *NetworkInterface) GetIpv6AccessConfigs() []*AccessConfig {
	if x != nil {
		return x.Ipv6AccessConfigs
	}
	return nil
}

func (x *NetworkInterface) GetAliasIpRanges() []*AliasIpRange {
	if x != nil {
		return x.AliasIpRanges
	}
	return nil
}

func (x *NetworkInterface) GetStackType() NetworkInterface_StackType {
	if x != nil && x.StackType != nil {
		return *x.StackType
	}
	return NetworkInterface_STACK_TYPE_UNSPECIFIED
}

func (x *NetworkInterface) GetIpv6AccessType() NetworkInterface_Ipv6AccessType {
	if x != nil && x.Ipv6AccessType != nil {
		return *x.Ipv6AccessType
	}
	return NetworkInterface_UNSPECIFIED_IPV6_ACCESS_TYPE
}

func (x *NetworkInterface) GetQueueCount() int32 {
	if x != nil && x.QueueCount != nil {
		return *x.QueueCount
	}
	return 0
}

func (x *NetworkInterface) GetNicType() NetworkInterface_NicType {
	if x != nil && x.NicType != nil {
		return *x.NicType
	}
	return NetworkInterface_NIC_TYPE_UNSPECIFIED
}

func (x *NetworkInterface) GetNetworkAttachment() string {
	if x != nil && x.NetworkAttachment != nil {
		return *x.NetworkAttachment
	}
	return ""
}

// Network performance configuration.
type NetworkPerformanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The tier of the total egress bandwidth.
	TotalEgressBandwidthTier *NetworkPerformanceConfig_Tier `protobuf:"varint,1,opt,name=total_egress_bandwidth_tier,json=totalEgressBandwidthTier,proto3,enum=google.cloud.backupdr.v1.NetworkPerformanceConfig_Tier,oneof" json:"total_egress_bandwidth_tier,omitempty"`
}

func (x *NetworkPerformanceConfig) Reset() {
	*x = NetworkPerformanceConfig{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkPerformanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPerformanceConfig) ProtoMessage() {}

func (x *NetworkPerformanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPerformanceConfig.ProtoReflect.Descriptor instead.
func (*NetworkPerformanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{12}
}

func (x *NetworkPerformanceConfig) GetTotalEgressBandwidthTier() NetworkPerformanceConfig_Tier {
	if x != nil && x.TotalEgressBandwidthTier != nil {
		return *x.TotalEgressBandwidthTier
	}
	return NetworkPerformanceConfig_TIER_UNSPECIFIED
}

// An access configuration attached to an instance's network interface.
// Only one access config per instance is supported.
type AccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. In accessConfigs (IPv4), the
	//
	//	default and only option is ONE_TO_ONE_NAT. In
	//	ipv6AccessConfigs, the default and only option is
	//	DIRECT_IPV6.
	Type *AccessConfig_AccessType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.backupdr.v1.AccessConfig_AccessType,oneof" json:"type,omitempty"`
	// Optional. The name of this access configuration.
	Name *string `protobuf:"bytes,2,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Optional. The external IP address of this access configuration.
	ExternalIp *string `protobuf:"bytes,3,opt,name=external_ip,json=externalIp,proto3,oneof" json:"external_ip,omitempty"`
	// Optional. The external IPv6 address of this access configuration.
	ExternalIpv6 *string `protobuf:"bytes,4,opt,name=external_ipv6,json=externalIpv6,proto3,oneof" json:"external_ipv6,omitempty"`
	// Optional. The prefix length of the external IPv6 range.
	ExternalIpv6PrefixLength *int32 `protobuf:"varint,5,opt,name=external_ipv6_prefix_length,json=externalIpv6PrefixLength,proto3,oneof" json:"external_ipv6_prefix_length,omitempty"`
	// Optional. Specifies whether a public DNS 'PTR' record should be created to
	// map the external IP address of the instance to a DNS domain name.
	SetPublicPtr *bool `protobuf:"varint,6,opt,name=set_public_ptr,json=setPublicPtr,proto3,oneof" json:"set_public_ptr,omitempty"`
	// Optional. The DNS domain name for the public PTR record.
	PublicPtrDomainName *string `protobuf:"bytes,7,opt,name=public_ptr_domain_name,json=publicPtrDomainName,proto3,oneof" json:"public_ptr_domain_name,omitempty"`
	// Optional. This signifies the networking tier used for configuring this
	// access
	NetworkTier *AccessConfig_NetworkTier `protobuf:"varint,8,opt,name=network_tier,json=networkTier,proto3,enum=google.cloud.backupdr.v1.AccessConfig_NetworkTier,oneof" json:"network_tier,omitempty"`
}

func (x *AccessConfig) Reset() {
	*x = AccessConfig{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessConfig) ProtoMessage() {}

func (x *AccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessConfig.ProtoReflect.Descriptor instead.
func (*AccessConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{13}
}

func (x *AccessConfig) GetType() AccessConfig_AccessType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return AccessConfig_ACCESS_TYPE_UNSPECIFIED
}

func (x *AccessConfig) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *AccessConfig) GetExternalIp() string {
	if x != nil && x.ExternalIp != nil {
		return *x.ExternalIp
	}
	return ""
}

func (x *AccessConfig) GetExternalIpv6() string {
	if x != nil && x.ExternalIpv6 != nil {
		return *x.ExternalIpv6
	}
	return ""
}

func (x *AccessConfig) GetExternalIpv6PrefixLength() int32 {
	if x != nil && x.ExternalIpv6PrefixLength != nil {
		return *x.ExternalIpv6PrefixLength
	}
	return 0
}

func (x *AccessConfig) GetSetPublicPtr() bool {
	if x != nil && x.SetPublicPtr != nil {
		return *x.SetPublicPtr
	}
	return false
}

func (x *AccessConfig) GetPublicPtrDomainName() string {
	if x != nil && x.PublicPtrDomainName != nil {
		return *x.PublicPtrDomainName
	}
	return ""
}

func (x *AccessConfig) GetNetworkTier() AccessConfig_NetworkTier {
	if x != nil && x.NetworkTier != nil {
		return *x.NetworkTier
	}
	return AccessConfig_NETWORK_TIER_UNSPECIFIED
}

// An alias IP range attached to an instance's network interface.
type AliasIpRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The IP alias ranges to allocate for this interface.
	IpCidrRange *string `protobuf:"bytes,1,opt,name=ip_cidr_range,json=ipCidrRange,proto3,oneof" json:"ip_cidr_range,omitempty"`
	// Optional. The name of a subnetwork secondary IP range from which to
	// allocate an IP alias range. If not specified, the primary range of the
	// subnetwork is used.
	SubnetworkRangeName *string `protobuf:"bytes,2,opt,name=subnetwork_range_name,json=subnetworkRangeName,proto3,oneof" json:"subnetwork_range_name,omitempty"`
}

func (x *AliasIpRange) Reset() {
	*x = AliasIpRange{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AliasIpRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AliasIpRange) ProtoMessage() {}

func (x *AliasIpRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AliasIpRange.ProtoReflect.Descriptor instead.
func (*AliasIpRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{14}
}

func (x *AliasIpRange) GetIpCidrRange() string {
	if x != nil && x.IpCidrRange != nil {
		return *x.IpCidrRange
	}
	return ""
}

func (x *AliasIpRange) GetSubnetworkRangeName() string {
	if x != nil && x.SubnetworkRangeName != nil {
		return *x.SubnetworkRangeName
	}
	return ""
}

// Additional instance params.
type InstanceParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource manager tags to be bound to the instance.
	ResourceManagerTags map[string]string `protobuf:"bytes,1,rep,name=resource_manager_tags,json=resourceManagerTags,proto3" json:"resource_manager_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *InstanceParams) Reset() {
	*x = InstanceParams{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstanceParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceParams) ProtoMessage() {}

func (x *InstanceParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceParams.ProtoReflect.Descriptor instead.
func (*InstanceParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{15}
}

func (x *InstanceParams) GetResourceManagerTags() map[string]string {
	if x != nil {
		return x.ResourceManagerTags
	}
	return nil
}

// Specifies the reservations that this instance can consume from.
type AllocationAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the type of reservation from which this instance can
	// consume
	ConsumeAllocationType *AllocationAffinity_Type `protobuf:"varint,1,opt,name=consume_allocation_type,json=consumeAllocationType,proto3,enum=google.cloud.backupdr.v1.AllocationAffinity_Type,oneof" json:"consume_allocation_type,omitempty"`
	// Optional. Corresponds to the label key of a reservation resource.
	Key *string `protobuf:"bytes,2,opt,name=key,proto3,oneof" json:"key,omitempty"`
	// Optional. Corresponds to the label values of a reservation resource.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *AllocationAffinity) Reset() {
	*x = AllocationAffinity{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocationAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationAffinity) ProtoMessage() {}

func (x *AllocationAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationAffinity.ProtoReflect.Descriptor instead.
func (*AllocationAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{16}
}

func (x *AllocationAffinity) GetConsumeAllocationType() AllocationAffinity_Type {
	if x != nil && x.ConsumeAllocationType != nil {
		return *x.ConsumeAllocationType
	}
	return AllocationAffinity_TYPE_UNSPECIFIED
}

func (x *AllocationAffinity) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *AllocationAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Sets the scheduling options for an Instance.
type Scheduling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines the maintenance behavior for this instance.
	OnHostMaintenance *Scheduling_OnHostMaintenance `protobuf:"varint,1,opt,name=on_host_maintenance,json=onHostMaintenance,proto3,enum=google.cloud.backupdr.v1.Scheduling_OnHostMaintenance,oneof" json:"on_host_maintenance,omitempty"`
	// Optional. Specifies whether the instance should be automatically restarted
	// if it is terminated by Compute Engine (not terminated by a user).
	AutomaticRestart *bool `protobuf:"varint,2,opt,name=automatic_restart,json=automaticRestart,proto3,oneof" json:"automatic_restart,omitempty"`
	// Optional. Defines whether the instance is preemptible.
	Preemptible *bool `protobuf:"varint,3,opt,name=preemptible,proto3,oneof" json:"preemptible,omitempty"`
	// Optional. A set of node affinity and anti-affinity configurations.
	// Overrides reservationAffinity.
	NodeAffinities []*Scheduling_NodeAffinity `protobuf:"bytes,4,rep,name=node_affinities,json=nodeAffinities,proto3" json:"node_affinities,omitempty"`
	// Optional. The minimum number of virtual CPUs this instance will consume
	// when running on a sole-tenant node.
	MinNodeCpus *int32 `protobuf:"varint,5,opt,name=min_node_cpus,json=minNodeCpus,proto3,oneof" json:"min_node_cpus,omitempty"`
	// Optional. Specifies the provisioning model of the instance.
	ProvisioningModel *Scheduling_ProvisioningModel `protobuf:"varint,6,opt,name=provisioning_model,json=provisioningModel,proto3,enum=google.cloud.backupdr.v1.Scheduling_ProvisioningModel,oneof" json:"provisioning_model,omitempty"`
	// Optional. Specifies the termination action for the instance.
	InstanceTerminationAction *Scheduling_InstanceTerminationAction `protobuf:"varint,7,opt,name=instance_termination_action,json=instanceTerminationAction,proto3,enum=google.cloud.backupdr.v1.Scheduling_InstanceTerminationAction,oneof" json:"instance_termination_action,omitempty"`
	// Optional. Specifies the maximum amount of time a Local Ssd Vm should wait
	// while recovery of the Local Ssd state is attempted. Its value should be in
	// between 0 and 168 hours with hour granularity and the default value being 1
	// hour.
	LocalSsdRecoveryTimeout *SchedulingDuration `protobuf:"bytes,10,opt,name=local_ssd_recovery_timeout,json=localSsdRecoveryTimeout,proto3,oneof" json:"local_ssd_recovery_timeout,omitempty"`
}

func (x *Scheduling) Reset() {
	*x = Scheduling{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Scheduling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Scheduling) ProtoMessage() {}

func (x *Scheduling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Scheduling.ProtoReflect.Descriptor instead.
func (*Scheduling) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{17}
}

func (x *Scheduling) GetOnHostMaintenance() Scheduling_OnHostMaintenance {
	if x != nil && x.OnHostMaintenance != nil {
		return *x.OnHostMaintenance
	}
	return Scheduling_ON_HOST_MAINTENANCE_UNSPECIFIED
}

func (x *Scheduling) GetAutomaticRestart() bool {
	if x != nil && x.AutomaticRestart != nil {
		return *x.AutomaticRestart
	}
	return false
}

func (x *Scheduling) GetPreemptible() bool {
	if x != nil && x.Preemptible != nil {
		return *x.Preemptible
	}
	return false
}

func (x *Scheduling) GetNodeAffinities() []*Scheduling_NodeAffinity {
	if x != nil {
		return x.NodeAffinities
	}
	return nil
}

func (x *Scheduling) GetMinNodeCpus() int32 {
	if x != nil && x.MinNodeCpus != nil {
		return *x.MinNodeCpus
	}
	return 0
}

func (x *Scheduling) GetProvisioningModel() Scheduling_ProvisioningModel {
	if x != nil && x.ProvisioningModel != nil {
		return *x.ProvisioningModel
	}
	return Scheduling_PROVISIONING_MODEL_UNSPECIFIED
}

func (x *Scheduling) GetInstanceTerminationAction() Scheduling_InstanceTerminationAction {
	if x != nil && x.InstanceTerminationAction != nil {
		return *x.InstanceTerminationAction
	}
	return Scheduling_INSTANCE_TERMINATION_ACTION_UNSPECIFIED
}

func (x *Scheduling) GetLocalSsdRecoveryTimeout() *SchedulingDuration {
	if x != nil {
		return x.LocalSsdRecoveryTimeout
	}
	return nil
}

// A SchedulingDuration represents a fixed-length span of time represented
// as a count of seconds and fractions of seconds at nanosecond
// resolution. It is independent of any calendar and concepts like "day"
// or "month". Range is approximately 10,000 years.
type SchedulingDuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Span of time at a resolution of a second.
	Seconds *int64 `protobuf:"varint,1,opt,name=seconds,proto3,oneof" json:"seconds,omitempty"`
	// Optional. Span of time that's a fraction of a second at nanosecond
	// resolution.
	Nanos *int32 `protobuf:"varint,2,opt,name=nanos,proto3,oneof" json:"nanos,omitempty"`
}

func (x *SchedulingDuration) Reset() {
	*x = SchedulingDuration{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulingDuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulingDuration) ProtoMessage() {}

func (x *SchedulingDuration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulingDuration.ProtoReflect.Descriptor instead.
func (*SchedulingDuration) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{18}
}

func (x *SchedulingDuration) GetSeconds() int64 {
	if x != nil && x.Seconds != nil {
		return *x.Seconds
	}
	return 0
}

func (x *SchedulingDuration) GetNanos() int32 {
	if x != nil && x.Nanos != nil {
		return *x.Nanos
	}
	return 0
}

// A service account.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Email address of the service account.
	Email *string `protobuf:"bytes,1,opt,name=email,proto3,oneof" json:"email,omitempty"`
	// Optional. The list of scopes to be made available for this service account.
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{19}
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil && x.Email != nil {
		return *x.Email
	}
	return ""
}

func (x *ServiceAccount) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// A set of instance tags.
type Tags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. An array of tags. Each tag must be 1-63 characters long, and
	// comply with RFC1035.
	Items []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *Tags) Reset() {
	*x = Tags{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tags) ProtoMessage() {}

func (x *Tags) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tags.ProtoReflect.Descriptor instead.
func (*Tags) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{20}
}

func (x *Tags) GetItems() []string {
	if x != nil {
		return x.Items
	}
	return nil
}

// An instance-attached disk resource.
type AttachedDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the parameters to initialize this disk.
	InitializeParams *AttachedDisk_InitializeParams `protobuf:"bytes,1,opt,name=initialize_params,json=initializeParams,proto3,oneof" json:"initialize_params,omitempty"`
	// Optional. This is used as an identifier for the disks. This is the unique
	// name has to provided to modify disk parameters like disk_name and
	// replica_zones (in case of RePDs)
	DeviceName *string `protobuf:"bytes,4,opt,name=device_name,json=deviceName,proto3,oneof" json:"device_name,omitempty"`
	// Optional. Type of the resource.
	Kind *string `protobuf:"bytes,5,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Specifies the type of the disk.
	//
	// Deprecated: Marked as deprecated in google/cloud/backupdr/v1/backupvault_gce.proto.
	DiskTypeDeprecated *AttachedDisk_DiskType `protobuf:"varint,6,opt,name=disk_type_deprecated,json=diskTypeDeprecated,proto3,enum=google.cloud.backupdr.v1.AttachedDisk_DiskType,oneof" json:"disk_type_deprecated,omitempty"`
	// Optional. The mode in which to attach this disk.
	Mode *AttachedDisk_DiskMode `protobuf:"varint,7,opt,name=mode,proto3,enum=google.cloud.backupdr.v1.AttachedDisk_DiskMode,oneof" json:"mode,omitempty"`
	// Optional. Specifies a valid partial or full URL to an existing Persistent
	// Disk resource.
	Source *string `protobuf:"bytes,8,opt,name=source,proto3,oneof" json:"source,omitempty"`
	// Optional. A zero-based index to this disk, where 0 is reserved for the
	// boot disk.
	Index *int64 `protobuf:"varint,9,opt,name=index,proto3,oneof" json:"index,omitempty"`
	// Optional. Indicates that this is a boot disk. The virtual machine will use
	// the first partition of the disk for its root filesystem.
	Boot *bool `protobuf:"varint,10,opt,name=boot,proto3,oneof" json:"boot,omitempty"`
	// Optional. Specifies whether the disk will be auto-deleted when the instance
	// is deleted (but not when the disk is detached from the instance).
	AutoDelete *bool `protobuf:"varint,11,opt,name=auto_delete,json=autoDelete,proto3,oneof" json:"auto_delete,omitempty"`
	// Optional. Any valid publicly visible licenses.
	License []string `protobuf:"bytes,12,rep,name=license,proto3" json:"license,omitempty"`
	// Optional. Specifies the disk interface to use for attaching this disk.
	DiskInterface *AttachedDisk_DiskInterface `protobuf:"varint,13,opt,name=disk_interface,json=diskInterface,proto3,enum=google.cloud.backupdr.v1.AttachedDisk_DiskInterface,oneof" json:"disk_interface,omitempty"`
	// Optional. A list of features to enable on the guest operating system.
	// Applicable only for bootable images.
	GuestOsFeature []*GuestOsFeature `protobuf:"bytes,14,rep,name=guest_os_feature,json=guestOsFeature,proto3" json:"guest_os_feature,omitempty"`
	// Optional. Encrypts or decrypts a disk using a customer-supplied
	// encryption key.
	DiskEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,15,opt,name=disk_encryption_key,json=diskEncryptionKey,proto3,oneof" json:"disk_encryption_key,omitempty"`
	// Optional. The size of the disk in GB.
	DiskSizeGb *int64 `protobuf:"varint,16,opt,name=disk_size_gb,json=diskSizeGb,proto3,oneof" json:"disk_size_gb,omitempty"`
	// Optional. Output only. The state of the disk.
	SavedState *AttachedDisk_DiskSavedState `protobuf:"varint,17,opt,name=saved_state,json=savedState,proto3,enum=google.cloud.backupdr.v1.AttachedDisk_DiskSavedState,oneof" json:"saved_state,omitempty"`
	// Optional. Output only. The URI of the disk type resource. For example:
	// projects/project/zones/zone/diskTypes/pd-standard or pd-ssd
	DiskType *string `protobuf:"bytes,18,opt,name=disk_type,json=diskType,proto3,oneof" json:"disk_type,omitempty"`
	// Optional. Specifies the type of the disk.
	Type *AttachedDisk_DiskType `protobuf:"varint,19,opt,name=type,proto3,enum=google.cloud.backupdr.v1.AttachedDisk_DiskType,oneof" json:"type,omitempty"`
}

func (x *AttachedDisk) Reset() {
	*x = AttachedDisk{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedDisk) ProtoMessage() {}

func (x *AttachedDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedDisk.ProtoReflect.Descriptor instead.
func (*AttachedDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{21}
}

func (x *AttachedDisk) GetInitializeParams() *AttachedDisk_InitializeParams {
	if x != nil {
		return x.InitializeParams
	}
	return nil
}

func (x *AttachedDisk) GetDeviceName() string {
	if x != nil && x.DeviceName != nil {
		return *x.DeviceName
	}
	return ""
}

func (x *AttachedDisk) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/backupdr/v1/backupvault_gce.proto.
func (x *AttachedDisk) GetDiskTypeDeprecated() AttachedDisk_DiskType {
	if x != nil && x.DiskTypeDeprecated != nil {
		return *x.DiskTypeDeprecated
	}
	return AttachedDisk_DISK_TYPE_UNSPECIFIED
}

func (x *AttachedDisk) GetMode() AttachedDisk_DiskMode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return AttachedDisk_DISK_MODE_UNSPECIFIED
}

func (x *AttachedDisk) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

func (x *AttachedDisk) GetIndex() int64 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return 0
}

func (x *AttachedDisk) GetBoot() bool {
	if x != nil && x.Boot != nil {
		return *x.Boot
	}
	return false
}

func (x *AttachedDisk) GetAutoDelete() bool {
	if x != nil && x.AutoDelete != nil {
		return *x.AutoDelete
	}
	return false
}

func (x *AttachedDisk) GetLicense() []string {
	if x != nil {
		return x.License
	}
	return nil
}

func (x *AttachedDisk) GetDiskInterface() AttachedDisk_DiskInterface {
	if x != nil && x.DiskInterface != nil {
		return *x.DiskInterface
	}
	return AttachedDisk_DISK_INTERFACE_UNSPECIFIED
}

func (x *AttachedDisk) GetGuestOsFeature() []*GuestOsFeature {
	if x != nil {
		return x.GuestOsFeature
	}
	return nil
}

func (x *AttachedDisk) GetDiskEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.DiskEncryptionKey
	}
	return nil
}

func (x *AttachedDisk) GetDiskSizeGb() int64 {
	if x != nil && x.DiskSizeGb != nil {
		return *x.DiskSizeGb
	}
	return 0
}

func (x *AttachedDisk) GetSavedState() AttachedDisk_DiskSavedState {
	if x != nil && x.SavedState != nil {
		return *x.SavedState
	}
	return AttachedDisk_DISK_SAVED_STATE_UNSPECIFIED
}

func (x *AttachedDisk) GetDiskType() string {
	if x != nil && x.DiskType != nil {
		return *x.DiskType
	}
	return ""
}

func (x *AttachedDisk) GetType() AttachedDisk_DiskType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return AttachedDisk_DISK_TYPE_UNSPECIFIED
}

// Feature type of the Guest OS.
type GuestOsFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a supported feature.
	Type *GuestOsFeature_FeatureType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.backupdr.v1.GuestOsFeature_FeatureType,oneof" json:"type,omitempty"`
}

func (x *GuestOsFeature) Reset() {
	*x = GuestOsFeature{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GuestOsFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestOsFeature) ProtoMessage() {}

func (x *GuestOsFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestOsFeature.ProtoReflect.Descriptor instead.
func (*GuestOsFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{22}
}

func (x *GuestOsFeature) GetType() GuestOsFeature_FeatureType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return GuestOsFeature_FEATURE_TYPE_UNSPECIFIED
}

// Node Affinity: the configuration of desired nodes onto which this Instance
// could be scheduled.
type Scheduling_NodeAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Corresponds to the label key of Node resource.
	Key *string `protobuf:"bytes,1,opt,name=key,proto3,oneof" json:"key,omitempty"`
	// Optional. Defines the operation of node selection.
	Operator *Scheduling_NodeAffinity_Operator `protobuf:"varint,2,opt,name=operator,proto3,enum=google.cloud.backupdr.v1.Scheduling_NodeAffinity_Operator,oneof" json:"operator,omitempty"`
	// Optional. Corresponds to the label values of Node resource.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Scheduling_NodeAffinity) Reset() {
	*x = Scheduling_NodeAffinity{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Scheduling_NodeAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Scheduling_NodeAffinity) ProtoMessage() {}

func (x *Scheduling_NodeAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Scheduling_NodeAffinity.ProtoReflect.Descriptor instead.
func (*Scheduling_NodeAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{17, 0}
}

func (x *Scheduling_NodeAffinity) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *Scheduling_NodeAffinity) GetOperator() Scheduling_NodeAffinity_Operator {
	if x != nil && x.Operator != nil {
		return *x.Operator
	}
	return Scheduling_NodeAffinity_OPERATOR_UNSPECIFIED
}

func (x *Scheduling_NodeAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Specifies the parameters to initialize this disk.
type AttachedDisk_InitializeParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the disk name. If not specified, the default is to
	// use the name of the instance.
	DiskName *string `protobuf:"bytes,1,opt,name=disk_name,json=diskName,proto3,oneof" json:"disk_name,omitempty"`
	// Optional. URL of the zone where the disk should be created.
	// Required for each regional disk associated with the instance.
	ReplicaZones []string `protobuf:"bytes,2,rep,name=replica_zones,json=replicaZones,proto3" json:"replica_zones,omitempty"`
}

func (x *AttachedDisk_InitializeParams) Reset() {
	*x = AttachedDisk_InitializeParams{}
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedDisk_InitializeParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedDisk_InitializeParams) ProtoMessage() {}

func (x *AttachedDisk_InitializeParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedDisk_InitializeParams.ProtoReflect.Descriptor instead.
func (*AttachedDisk_InitializeParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP(), []int{21, 0}
}

func (x *AttachedDisk_InitializeParams) GetDiskName() string {
	if x != nil && x.DiskName != nil {
		return *x.DiskName
	}
	return ""
}

func (x *AttachedDisk_InitializeParams) GetReplicaZones() []string {
	if x != nil {
		return x.ReplicaZones
	}
	return nil
}

var File_google_cloud_backupdr_v1_backupvault_gce_proto protoreflect.FileDescriptor

var file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x67, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb3, 0x09, 0x0a, 0x1f, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x73, 0x48, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x02, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x5f, 0x69, 0x70, 0x5f, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0c,
	0x63, 0x61, 0x6e, 0x49, 0x70, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x57, 0x0a, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x04,
	0x64, 0x69, 0x73, 0x6b, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x04, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0a,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x48, 0x05, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x11, 0x67, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x10, 0x67, 0x75, 0x65, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x0e, 0x6d,
	0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x88, 0x01, 0x01,
	0x12, 0x73, 0x0a, 0x1a, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x48, 0x07, 0x52, 0x17, 0x6b, 0x65, 0x79, 0x52, 0x65,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x08,
	0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x5d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0e, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x61, 0x6e, 0x5f,
	0x69, 0x70, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x1d, 0x0a, 0x1b, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xd2,
	0x15, 0x0a, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x77, 0x0a, 0x19, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x17,
	0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x0e, 0x63, 0x61,
	0x6e, 0x5f, 0x69, 0x70, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0c, 0x63, 0x61, 0x6e, 0x49, 0x70,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x88, 0x01, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x1c, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x1a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a,
	0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x04, 0x52, 0x12, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x05, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x58, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52,
	0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x5f, 0x0a, 0x12, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x11, 0x67, 0x75, 0x65, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x73, 0x12, 0x24, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x71, 0x0a, 0x17, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x08, 0x52, 0x15, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x78, 0x0a, 0x1a, 0x6b,
	0x65, 0x79, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x09, 0x52, 0x17, 0x6b, 0x65, 0x79, 0x52, 0x65,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x0c, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0a, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x0b, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01,
	0x01, 0x12, 0x32, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x0c, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x7a, 0x0a, 0x1a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x0d, 0x52, 0x18, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01,
	0x01, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x48, 0x0e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x88, 0x01, 0x01, 0x12, 0xa1, 0x01,
	0x0a, 0x1a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x49, 0x70,
	0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x0f, 0x52, 0x17, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x49, 0x70,
	0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x67, 0x0a, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x10, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x11, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x16, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x0a,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x11, 0x52, 0x0a, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x10,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x1a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x12, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x88, 0x01, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xc7, 0x01, 0x0a, 0x1f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x49, 0x70, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x12, 0x33, 0x0a, 0x2f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x56, 0x36, 0x5f, 0x47, 0x4f, 0x4f,
	0x47, 0x4c, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x48, 0x45,
	0x52, 0x49, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x4f, 0x55, 0x54, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x56, 0x4d, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x53, 0x53, 0x5f, 0x54, 0x4f, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x29,
	0x0a, 0x25, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x42, 0x49, 0x44, 0x49, 0x52, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f,
	0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x10, 0x03, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x61, 0x6e, 0x5f, 0x69, 0x70, 0x5f, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x11, 0x0a, 0x0f,
	0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x1a, 0x0a, 0x18,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x70,
	0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74,
	0x61, 0x67, 0x73, 0x22, 0x5a, 0x0a, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x22,
	0xd5, 0x01, 0x0a, 0x23, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a,
	0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x28, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x12, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x22, 0xf9, 0x02, 0x0a, 0x17, 0x41, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x56, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x32, 0x0a, 0x10, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x0e, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x12, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x10, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x16, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x65, 0x66, 0x69, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x03, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x65, 0x66, 0x69, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x42, 0x1f, 0x0a, 0x1d, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x13, 0x0a, 0x11,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72,
	0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x75, 0x65, 0x66, 0x69, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x22, 0x86, 0x01, 0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x48, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x19,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x1e, 0x0a, 0x1c,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x22, 0x53, 0x0a, 0x0d,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2f, 0x0a,
	0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x88, 0x01, 0x01, 0x42, 0x11,
	0x0a, 0x0f, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x22, 0xaa, 0x01, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x10,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xf7,
	0x01, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x07, 0x72, 0x61, 0x77, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x06, 0x72, 0x61, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x31, 0x0a, 0x11, 0x72, 0x73, 0x61, 0x5f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x73, 0x61, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x0c, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x17, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x14, 0x6b, 0x6d,
	0x73, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x05, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x42, 0x1a, 0x0a, 0x18,
	0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x55, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x1a, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x06, 0x0a,
	0x04, 0x5f, 0x6b, 0x65, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x46, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3a, 0x0a, 0x05, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0xcc, 0x0a, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x88, 0x01, 0x01,
	0x12, 0x28, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0a, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x0a, 0x69, 0x70,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b,
	0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x02, 0x48, 0x02, 0x52, 0x09, 0x69,
	0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x0c, 0x69,
	0x70, 0x76, 0x36, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x03, 0x48, 0x03,
	0x52, 0x0b, 0x69, 0x70, 0x76, 0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x47, 0x0a, 0x1b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76,
	0x36, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x18, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76, 0x36, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x05, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x5b, 0x0a, 0x13, 0x69,
	0x70, 0x76, 0x36, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x69, 0x70, 0x76, 0x36, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x61, 0x6c, 0x69, 0x61,
	0x73, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d,
	0x61, 0x6c, 0x69, 0x61, 0x73, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x58, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x48, 0x06, 0x52, 0x09, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x6d, 0x0a, 0x10, 0x69, 0x70, 0x76, 0x36, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2e, 0x49, 0x70,
	0x76, 0x36, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x07, 0x52, 0x0e, 0x69, 0x70, 0x76, 0x36, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54,
	0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x08, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x57, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2e,
	0x4e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x09, 0x52, 0x07,
	0x6e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x12, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0a, 0x52, 0x11, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x22, 0x45, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x49, 0x50, 0x56, 0x34, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x49,
	0x50, 0x56, 0x34, 0x5f, 0x49, 0x50, 0x56, 0x36, 0x10, 0x02, 0x22, 0x4e, 0x0a, 0x0e, 0x49, 0x70,
	0x76, 0x36, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x49, 0x50, 0x56, 0x36,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x3e, 0x0a, 0x07, 0x4e, 0x69,
	0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x56, 0x49, 0x52, 0x54, 0x49, 0x4f, 0x5f, 0x4e, 0x45, 0x54, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x47, 0x56, 0x4e, 0x49, 0x43, 0x10, 0x02, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6e, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42,
	0x15, 0x0a, 0x13, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xf4, 0x01, 0x0a, 0x18, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x1b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x74,
	0x69, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x69,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x18, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x54,
	0x69, 0x65, 0x72, 0x88, 0x01, 0x01, 0x22, 0x35, 0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x31, 0x10, 0x02, 0x42, 0x1e, 0x0a,
	0x1c, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x22, 0x9b, 0x06,
	0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x1c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a,
	0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x70, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x49, 0x70, 0x76, 0x36, 0x88, 0x01, 0x01, 0x12, 0x47, 0x0a, 0x1b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x04, 0x52, 0x18, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x76,
	0x36, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x88, 0x01, 0x01,
	0x12, 0x2e, 0x0a, 0x0e, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x70,
	0x74, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52,
	0x0c, 0x73, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x50, 0x74, 0x72, 0x88, 0x01, 0x01,
	0x12, 0x3d, 0x0a, 0x16, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x70, 0x74, 0x72, 0x5f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x13, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x50,
	0x74, 0x72, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x5f, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x69, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07,
	0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x69, 0x65, 0x72, 0x88, 0x01, 0x01,
	0x22, 0x4e, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4f,
	0x4e, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x4f, 0x4e, 0x45, 0x5f, 0x4e, 0x41, 0x54, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x50, 0x56, 0x36, 0x10, 0x02,
	0x22, 0x46, 0x0a, 0x0b, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x69, 0x65, 0x72, 0x12,
	0x1c, 0x0a, 0x18, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x52, 0x45, 0x4d, 0x49, 0x55, 0x4d, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x02, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x42, 0x1e, 0x0a, 0x1c,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x42, 0x11, 0x0a, 0x0f,
	0x5f, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x70, 0x74, 0x72, 0x42,
	0x19, 0x0a, 0x17, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x70, 0x74, 0x72, 0x5f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x22, 0xa6, 0x01, 0x0a, 0x0c,
	0x41, 0x6c, 0x69, 0x61, 0x73, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x0d,
	0x69, 0x70, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x70, 0x43, 0x69,
	0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a, 0x15, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x13, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x69, 0x70, 0x5f,
	0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x7a, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x54,
	0x61, 0x67, 0x73, 0x1a, 0x46, 0x0a, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc7, 0x02, 0x0a, 0x12,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x12, 0x73, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1a, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x22, 0x5f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12,
	0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x4e, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x03, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x8a, 0x0b, 0x0a, 0x0a, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x12, 0x70, 0x0a, 0x13, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x11, 0x6f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a,
	0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d,
	0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5f, 0x0a, 0x0f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0d, 0x6d, 0x69,
	0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64,
	0x65, 0x43, 0x70, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12, 0x6f, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x04, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x88, 0x01, 0x0a, 0x1b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x73, 0x0a, 0x1a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73,
	0x64, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x17, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x88, 0x01, 0x01, 0x1a, 0xf8, 0x01, 0x0a, 0x0c, 0x4e, 0x6f,
	0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x60, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x08, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x38, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x49,
	0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x10, 0x02, 0x42,
	0x06, 0x0a, 0x04, 0x5f, 0x6b, 0x65, 0x79, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x22, 0x55, 0x0a, 0x11, 0x4f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4f, 0x4e, 0x5f,
	0x48, 0x4f, 0x53, 0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x07, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x10, 0xe8, 0x07, 0x22, 0x4f, 0x0a, 0x11, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x22, 0x0a, 0x1e, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x50, 0x4f, 0x54, 0x10, 0x02, 0x22, 0x5e, 0x0a, 0x19,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x27, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x02, 0x42, 0x16, 0x0a, 0x14,
	0x5f, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x70,
	0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6d,
	0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73,
	0x64, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x22, 0x6e, 0x0a, 0x12, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x07, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x05,
	0x6e, 0x61, 0x6e, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x01, 0x52, 0x05, 0x6e, 0x61, 0x6e, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6e, 0x61, 0x6e,
	0x6f, 0x73, 0x22, 0x57, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0x21, 0x0a, 0x04, 0x54,
	0x61, 0x67, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0xeb,
	0x0d, 0x0a, 0x0c, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x12,
	0x6e, 0x0a, 0x11, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69,
	0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x29, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x6a, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x2e, 0x44,
	0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x48, 0x03, 0x52, 0x12, 0x64,
	0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x04, 0x62, 0x6f, 0x6f, 0x74,
	0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x08, 0x52,
	0x0a, 0x61, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d,
	0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a,
	0x0e, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x2e, 0x44, 0x69,
	0x73, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x57, 0x0a, 0x10, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x73,
	0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x4f,
	0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x67,
	0x75, 0x65, 0x73, 0x74, 0x4f, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x69, 0x0a,
	0x13, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x0a, 0x52, 0x11, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x0b, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47,
	0x62, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73,
	0x6b, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x61, 0x76, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x48, 0x0c, 0x52, 0x0a, 0x73, 0x61, 0x76, 0x65,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x09, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x01, 0xe0, 0x41, 0x03, 0x48, 0x0d, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0e, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x88,
	0x01, 0x01, 0x1a, 0x71, 0x0a, 0x10, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x25, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x42, 0x0a, 0x08, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x53, 0x43, 0x52, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x52,
	0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0x50, 0x0a, 0x08, 0x44, 0x69, 0x73,
	0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x03, 0x22, 0x5a, 0x0a, 0x0d, 0x44,
	0x69, 0x73, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x1a,
	0x44, 0x49, 0x53, 0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x53, 0x43, 0x53, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x56, 0x4d, 0x45, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x56, 0x44, 0x49, 0x4d, 0x4d, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05,
	0x49, 0x53, 0x43, 0x53, 0x49, 0x10, 0x04, 0x22, 0x41, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x61, 0x76, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x49, 0x53,
	0x4b, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44, 0x10, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x16, 0x0a, 0x14,
	0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x67, 0x62, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xbb, 0x03, 0x0a,
	0x0e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x73,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x22, 0xd0,
	0x02, 0x0a, 0x0b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x56, 0x49, 0x52, 0x54, 0x49, 0x4f, 0x5f, 0x53, 0x43, 0x53, 0x49, 0x5f, 0x4d, 0x55, 0x4c, 0x54,
	0x49, 0x51, 0x55, 0x45, 0x55, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x49, 0x4e, 0x44,
	0x4f, 0x57, 0x53, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x49,
	0x50, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x45,
	0x46, 0x49, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x04, 0x12,
	0x0f, 0x0a, 0x0b, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x10, 0x05,
	0x12, 0x09, 0x0a, 0x05, 0x47, 0x56, 0x4e, 0x49, 0x43, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x53,
	0x45, 0x56, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x07, 0x12, 0x1f, 0x0a, 0x1b,
	0x42, 0x41, 0x52, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x4c, 0x5f, 0x4c, 0x49, 0x4e, 0x55, 0x58,
	0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x1d, 0x0a,
	0x19, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x45, 0x5f,
	0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x09, 0x12, 0x17, 0x0a, 0x13,
	0x53, 0x45, 0x56, 0x5f, 0x4c, 0x49, 0x56, 0x45, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x0a, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x56, 0x5f, 0x53, 0x4e, 0x50,
	0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x44,
	0x58, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x0c, 0x12, 0x08, 0x0a, 0x04, 0x49,
	0x44, 0x50, 0x46, 0x10, 0x0d, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x45, 0x56, 0x5f, 0x4c, 0x49, 0x56,
	0x45, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x56, 0x32, 0x10,
	0x0e, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2a, 0x59, 0x0a, 0x17, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x4b, 0x45, 0x59, 0x5f, 0x52, 0x45, 0x56,
	0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53,
	0x54, 0x4f, 0x50, 0x10, 0x02, 0x42, 0xc3, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x76, 0x61,
	0x75, 0x6c, 0x74, 0x47, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0x3b, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescOnce sync.Once
	file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescData = file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDesc
)

func file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescGZIP() []byte {
	file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescOnce.Do(func() {
		file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescData)
	})
	return file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDescData
}

var file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes = make([]protoimpl.EnumInfo, 18)
var file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_google_cloud_backupdr_v1_backupvault_gce_proto_goTypes = []any{
	(KeyRevocationActionType)(0),                                          // 0: google.cloud.backupdr.v1.KeyRevocationActionType
	(ComputeInstanceRestoreProperties_InstancePrivateIpv6GoogleAccess)(0), // 1: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.InstancePrivateIpv6GoogleAccess
	(NetworkInterface_StackType)(0),                                       // 2: google.cloud.backupdr.v1.NetworkInterface.StackType
	(NetworkInterface_Ipv6AccessType)(0),                                  // 3: google.cloud.backupdr.v1.NetworkInterface.Ipv6AccessType
	(NetworkInterface_NicType)(0),                                         // 4: google.cloud.backupdr.v1.NetworkInterface.NicType
	(NetworkPerformanceConfig_Tier)(0),                                    // 5: google.cloud.backupdr.v1.NetworkPerformanceConfig.Tier
	(AccessConfig_AccessType)(0),                                          // 6: google.cloud.backupdr.v1.AccessConfig.AccessType
	(AccessConfig_NetworkTier)(0),                                         // 7: google.cloud.backupdr.v1.AccessConfig.NetworkTier
	(AllocationAffinity_Type)(0),                                          // 8: google.cloud.backupdr.v1.AllocationAffinity.Type
	(Scheduling_OnHostMaintenance)(0),                                     // 9: google.cloud.backupdr.v1.Scheduling.OnHostMaintenance
	(Scheduling_ProvisioningModel)(0),                                     // 10: google.cloud.backupdr.v1.Scheduling.ProvisioningModel
	(Scheduling_InstanceTerminationAction)(0),                             // 11: google.cloud.backupdr.v1.Scheduling.InstanceTerminationAction
	(Scheduling_NodeAffinity_Operator)(0),                                 // 12: google.cloud.backupdr.v1.Scheduling.NodeAffinity.Operator
	(AttachedDisk_DiskType)(0),                                            // 13: google.cloud.backupdr.v1.AttachedDisk.DiskType
	(AttachedDisk_DiskMode)(0),                                            // 14: google.cloud.backupdr.v1.AttachedDisk.DiskMode
	(AttachedDisk_DiskInterface)(0),                                       // 15: google.cloud.backupdr.v1.AttachedDisk.DiskInterface
	(AttachedDisk_DiskSavedState)(0),                                      // 16: google.cloud.backupdr.v1.AttachedDisk.DiskSavedState
	(GuestOsFeature_FeatureType)(0),                                       // 17: google.cloud.backupdr.v1.GuestOsFeature.FeatureType
	(*ComputeInstanceBackupProperties)(nil),                               // 18: google.cloud.backupdr.v1.ComputeInstanceBackupProperties
	(*ComputeInstanceRestoreProperties)(nil),                              // 19: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties
	(*ComputeInstanceTargetEnvironment)(nil),                              // 20: google.cloud.backupdr.v1.ComputeInstanceTargetEnvironment
	(*ComputeInstanceDataSourceProperties)(nil),                           // 21: google.cloud.backupdr.v1.ComputeInstanceDataSourceProperties
	(*AdvancedMachineFeatures)(nil),                                       // 22: google.cloud.backupdr.v1.AdvancedMachineFeatures
	(*ConfidentialInstanceConfig)(nil),                                    // 23: google.cloud.backupdr.v1.ConfidentialInstanceConfig
	(*DisplayDevice)(nil),                                                 // 24: google.cloud.backupdr.v1.DisplayDevice
	(*AcceleratorConfig)(nil),                                             // 25: google.cloud.backupdr.v1.AcceleratorConfig
	(*CustomerEncryptionKey)(nil),                                         // 26: google.cloud.backupdr.v1.CustomerEncryptionKey
	(*Entry)(nil),                                                         // 27: google.cloud.backupdr.v1.Entry
	(*Metadata)(nil),                                                      // 28: google.cloud.backupdr.v1.Metadata
	(*NetworkInterface)(nil),                                              // 29: google.cloud.backupdr.v1.NetworkInterface
	(*NetworkPerformanceConfig)(nil),                                      // 30: google.cloud.backupdr.v1.NetworkPerformanceConfig
	(*AccessConfig)(nil),                                                  // 31: google.cloud.backupdr.v1.AccessConfig
	(*AliasIpRange)(nil),                                                  // 32: google.cloud.backupdr.v1.AliasIpRange
	(*InstanceParams)(nil),                                                // 33: google.cloud.backupdr.v1.InstanceParams
	(*AllocationAffinity)(nil),                                            // 34: google.cloud.backupdr.v1.AllocationAffinity
	(*Scheduling)(nil),                                                    // 35: google.cloud.backupdr.v1.Scheduling
	(*SchedulingDuration)(nil),                                            // 36: google.cloud.backupdr.v1.SchedulingDuration
	(*ServiceAccount)(nil),                                                // 37: google.cloud.backupdr.v1.ServiceAccount
	(*Tags)(nil),                                                          // 38: google.cloud.backupdr.v1.Tags
	(*AttachedDisk)(nil),                                                  // 39: google.cloud.backupdr.v1.AttachedDisk
	(*GuestOsFeature)(nil),                                                // 40: google.cloud.backupdr.v1.GuestOsFeature
	nil,                                                                   // 41: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.LabelsEntry
	nil,                                                                   // 42: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.LabelsEntry
	nil,                                                                   // 43: google.cloud.backupdr.v1.InstanceParams.ResourceManagerTagsEntry
	(*Scheduling_NodeAffinity)(nil),                                       // 44: google.cloud.backupdr.v1.Scheduling.NodeAffinity
	(*AttachedDisk_InitializeParams)(nil),                                 // 45: google.cloud.backupdr.v1.AttachedDisk.InitializeParams
}
var file_google_cloud_backupdr_v1_backupvault_gce_proto_depIdxs = []int32{
	38, // 0: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.tags:type_name -> google.cloud.backupdr.v1.Tags
	29, // 1: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.network_interface:type_name -> google.cloud.backupdr.v1.NetworkInterface
	39, // 2: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.disk:type_name -> google.cloud.backupdr.v1.AttachedDisk
	28, // 3: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.metadata:type_name -> google.cloud.backupdr.v1.Metadata
	37, // 4: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.service_account:type_name -> google.cloud.backupdr.v1.ServiceAccount
	35, // 5: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.scheduling:type_name -> google.cloud.backupdr.v1.Scheduling
	25, // 6: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.guest_accelerator:type_name -> google.cloud.backupdr.v1.AcceleratorConfig
	0,  // 7: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.key_revocation_action_type:type_name -> google.cloud.backupdr.v1.KeyRevocationActionType
	41, // 8: google.cloud.backupdr.v1.ComputeInstanceBackupProperties.labels:type_name -> google.cloud.backupdr.v1.ComputeInstanceBackupProperties.LabelsEntry
	22, // 9: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.advanced_machine_features:type_name -> google.cloud.backupdr.v1.AdvancedMachineFeatures
	23, // 10: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.confidential_instance_config:type_name -> google.cloud.backupdr.v1.ConfidentialInstanceConfig
	39, // 11: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.disks:type_name -> google.cloud.backupdr.v1.AttachedDisk
	24, // 12: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.display_device:type_name -> google.cloud.backupdr.v1.DisplayDevice
	25, // 13: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.guest_accelerators:type_name -> google.cloud.backupdr.v1.AcceleratorConfig
	26, // 14: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.instance_encryption_key:type_name -> google.cloud.backupdr.v1.CustomerEncryptionKey
	0,  // 15: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.key_revocation_action_type:type_name -> google.cloud.backupdr.v1.KeyRevocationActionType
	42, // 16: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.labels:type_name -> google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.LabelsEntry
	28, // 17: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.metadata:type_name -> google.cloud.backupdr.v1.Metadata
	29, // 18: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.network_interfaces:type_name -> google.cloud.backupdr.v1.NetworkInterface
	30, // 19: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.network_performance_config:type_name -> google.cloud.backupdr.v1.NetworkPerformanceConfig
	33, // 20: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.params:type_name -> google.cloud.backupdr.v1.InstanceParams
	1,  // 21: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.private_ipv6_google_access:type_name -> google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.InstancePrivateIpv6GoogleAccess
	34, // 22: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.allocation_affinity:type_name -> google.cloud.backupdr.v1.AllocationAffinity
	35, // 23: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.scheduling:type_name -> google.cloud.backupdr.v1.Scheduling
	37, // 24: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.service_accounts:type_name -> google.cloud.backupdr.v1.ServiceAccount
	38, // 25: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties.tags:type_name -> google.cloud.backupdr.v1.Tags
	27, // 26: google.cloud.backupdr.v1.Metadata.items:type_name -> google.cloud.backupdr.v1.Entry
	31, // 27: google.cloud.backupdr.v1.NetworkInterface.access_configs:type_name -> google.cloud.backupdr.v1.AccessConfig
	31, // 28: google.cloud.backupdr.v1.NetworkInterface.ipv6_access_configs:type_name -> google.cloud.backupdr.v1.AccessConfig
	32, // 29: google.cloud.backupdr.v1.NetworkInterface.alias_ip_ranges:type_name -> google.cloud.backupdr.v1.AliasIpRange
	2,  // 30: google.cloud.backupdr.v1.NetworkInterface.stack_type:type_name -> google.cloud.backupdr.v1.NetworkInterface.StackType
	3,  // 31: google.cloud.backupdr.v1.NetworkInterface.ipv6_access_type:type_name -> google.cloud.backupdr.v1.NetworkInterface.Ipv6AccessType
	4,  // 32: google.cloud.backupdr.v1.NetworkInterface.nic_type:type_name -> google.cloud.backupdr.v1.NetworkInterface.NicType
	5,  // 33: google.cloud.backupdr.v1.NetworkPerformanceConfig.total_egress_bandwidth_tier:type_name -> google.cloud.backupdr.v1.NetworkPerformanceConfig.Tier
	6,  // 34: google.cloud.backupdr.v1.AccessConfig.type:type_name -> google.cloud.backupdr.v1.AccessConfig.AccessType
	7,  // 35: google.cloud.backupdr.v1.AccessConfig.network_tier:type_name -> google.cloud.backupdr.v1.AccessConfig.NetworkTier
	43, // 36: google.cloud.backupdr.v1.InstanceParams.resource_manager_tags:type_name -> google.cloud.backupdr.v1.InstanceParams.ResourceManagerTagsEntry
	8,  // 37: google.cloud.backupdr.v1.AllocationAffinity.consume_allocation_type:type_name -> google.cloud.backupdr.v1.AllocationAffinity.Type
	9,  // 38: google.cloud.backupdr.v1.Scheduling.on_host_maintenance:type_name -> google.cloud.backupdr.v1.Scheduling.OnHostMaintenance
	44, // 39: google.cloud.backupdr.v1.Scheduling.node_affinities:type_name -> google.cloud.backupdr.v1.Scheduling.NodeAffinity
	10, // 40: google.cloud.backupdr.v1.Scheduling.provisioning_model:type_name -> google.cloud.backupdr.v1.Scheduling.ProvisioningModel
	11, // 41: google.cloud.backupdr.v1.Scheduling.instance_termination_action:type_name -> google.cloud.backupdr.v1.Scheduling.InstanceTerminationAction
	36, // 42: google.cloud.backupdr.v1.Scheduling.local_ssd_recovery_timeout:type_name -> google.cloud.backupdr.v1.SchedulingDuration
	45, // 43: google.cloud.backupdr.v1.AttachedDisk.initialize_params:type_name -> google.cloud.backupdr.v1.AttachedDisk.InitializeParams
	13, // 44: google.cloud.backupdr.v1.AttachedDisk.disk_type_deprecated:type_name -> google.cloud.backupdr.v1.AttachedDisk.DiskType
	14, // 45: google.cloud.backupdr.v1.AttachedDisk.mode:type_name -> google.cloud.backupdr.v1.AttachedDisk.DiskMode
	15, // 46: google.cloud.backupdr.v1.AttachedDisk.disk_interface:type_name -> google.cloud.backupdr.v1.AttachedDisk.DiskInterface
	40, // 47: google.cloud.backupdr.v1.AttachedDisk.guest_os_feature:type_name -> google.cloud.backupdr.v1.GuestOsFeature
	26, // 48: google.cloud.backupdr.v1.AttachedDisk.disk_encryption_key:type_name -> google.cloud.backupdr.v1.CustomerEncryptionKey
	16, // 49: google.cloud.backupdr.v1.AttachedDisk.saved_state:type_name -> google.cloud.backupdr.v1.AttachedDisk.DiskSavedState
	13, // 50: google.cloud.backupdr.v1.AttachedDisk.type:type_name -> google.cloud.backupdr.v1.AttachedDisk.DiskType
	17, // 51: google.cloud.backupdr.v1.GuestOsFeature.type:type_name -> google.cloud.backupdr.v1.GuestOsFeature.FeatureType
	12, // 52: google.cloud.backupdr.v1.Scheduling.NodeAffinity.operator:type_name -> google.cloud.backupdr.v1.Scheduling.NodeAffinity.Operator
	53, // [53:53] is the sub-list for method output_type
	53, // [53:53] is the sub-list for method input_type
	53, // [53:53] is the sub-list for extension type_name
	53, // [53:53] is the sub-list for extension extendee
	0,  // [0:53] is the sub-list for field type_name
}

func init() { file_google_cloud_backupdr_v1_backupvault_gce_proto_init() }
func file_google_cloud_backupdr_v1_backupvault_gce_proto_init() {
	if File_google_cloud_backupdr_v1_backupvault_gce_proto != nil {
		return
	}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[8].OneofWrappers = []any{
		(*CustomerEncryptionKey_RawKey)(nil),
		(*CustomerEncryptionKey_RsaEncryptedKey)(nil),
		(*CustomerEncryptionKey_KmsKeyName)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[11].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[12].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[13].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[14].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[16].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[17].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[18].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[19].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[21].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[22].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[26].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes[27].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDesc,
			NumEnums:      18,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_backupdr_v1_backupvault_gce_proto_goTypes,
		DependencyIndexes: file_google_cloud_backupdr_v1_backupvault_gce_proto_depIdxs,
		EnumInfos:         file_google_cloud_backupdr_v1_backupvault_gce_proto_enumTypes,
		MessageInfos:      file_google_cloud_backupdr_v1_backupvault_gce_proto_msgTypes,
	}.Build()
	File_google_cloud_backupdr_v1_backupvault_gce_proto = out.File
	file_google_cloud_backupdr_v1_backupvault_gce_proto_rawDesc = nil
	file_google_cloud_backupdr_v1_backupvault_gce_proto_goTypes = nil
	file_google_cloud_backupdr_v1_backupvault_gce_proto_depIdxs = nil
}
