// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/apps/meet/v2/resource.proto

package meetpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible access types for a meeting space.
type SpaceConfig_AccessType int32

const (
	// Default value specified by the user's organization.
	// Note: This is never returned, as the configured access type is
	// returned instead.
	SpaceConfig_ACCESS_TYPE_UNSPECIFIED SpaceConfig_AccessType = 0
	// Anyone with the join information (for example, the URL or phone access
	// information) can join without knocking.
	SpaceConfig_OPEN SpaceConfig_AccessType = 1
	// Members of the host's organization, invited external users, and dial-in
	// users can join without knocking. Everyone else must knock.
	SpaceConfig_TRUSTED SpaceConfig_AccessType = 2
	// Only invitees can join without knocking. Everyone else must knock.
	SpaceConfig_RESTRICTED SpaceConfig_AccessType = 3
)

// Enum value maps for SpaceConfig_AccessType.
var (
	SpaceConfig_AccessType_name = map[int32]string{
		0: "ACCESS_TYPE_UNSPECIFIED",
		1: "OPEN",
		2: "TRUSTED",
		3: "RESTRICTED",
	}
	SpaceConfig_AccessType_value = map[string]int32{
		"ACCESS_TYPE_UNSPECIFIED": 0,
		"OPEN":                    1,
		"TRUSTED":                 2,
		"RESTRICTED":              3,
	}
)

func (x SpaceConfig_AccessType) Enum() *SpaceConfig_AccessType {
	p := new(SpaceConfig_AccessType)
	*p = x
	return p
}

func (x SpaceConfig_AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpaceConfig_AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_meet_v2_resource_proto_enumTypes[0].Descriptor()
}

func (SpaceConfig_AccessType) Type() protoreflect.EnumType {
	return &file_google_apps_meet_v2_resource_proto_enumTypes[0]
}

func (x SpaceConfig_AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpaceConfig_AccessType.Descriptor instead.
func (SpaceConfig_AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{2, 0}
}

// Entry points that can be used to join a meeting.  Example:
// `meet.google.com`, the Meet Embed SDK Web, or a mobile application.
type SpaceConfig_EntryPointAccess int32

const (
	// Unused.
	SpaceConfig_ENTRY_POINT_ACCESS_UNSPECIFIED SpaceConfig_EntryPointAccess = 0
	// All entry points are allowed.
	SpaceConfig_ALL SpaceConfig_EntryPointAccess = 1
	// Only entry points owned by the Google Cloud project that created the
	// space can be used to join meetings in this space. Apps can use the Meet
	// Embed SDK Web or mobile Meet SDKs to create owned entry points.
	SpaceConfig_CREATOR_APP_ONLY SpaceConfig_EntryPointAccess = 2
)

// Enum value maps for SpaceConfig_EntryPointAccess.
var (
	SpaceConfig_EntryPointAccess_name = map[int32]string{
		0: "ENTRY_POINT_ACCESS_UNSPECIFIED",
		1: "ALL",
		2: "CREATOR_APP_ONLY",
	}
	SpaceConfig_EntryPointAccess_value = map[string]int32{
		"ENTRY_POINT_ACCESS_UNSPECIFIED": 0,
		"ALL":                            1,
		"CREATOR_APP_ONLY":               2,
	}
)

func (x SpaceConfig_EntryPointAccess) Enum() *SpaceConfig_EntryPointAccess {
	p := new(SpaceConfig_EntryPointAccess)
	*p = x
	return p
}

func (x SpaceConfig_EntryPointAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpaceConfig_EntryPointAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_meet_v2_resource_proto_enumTypes[1].Descriptor()
}

func (SpaceConfig_EntryPointAccess) Type() protoreflect.EnumType {
	return &file_google_apps_meet_v2_resource_proto_enumTypes[1]
}

func (x SpaceConfig_EntryPointAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpaceConfig_EntryPointAccess.Descriptor instead.
func (SpaceConfig_EntryPointAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{2, 1}
}

// Current state of the recording session.
type Recording_State int32

const (
	// Default, never used.
	Recording_STATE_UNSPECIFIED Recording_State = 0
	// An active recording session has started.
	Recording_STARTED Recording_State = 1
	// This recording session has ended, but the recording file hasn't been
	// generated yet.
	Recording_ENDED Recording_State = 2
	// Recording file is generated and ready to download.
	Recording_FILE_GENERATED Recording_State = 3
)

// Enum value maps for Recording_State.
var (
	Recording_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "ENDED",
		3: "FILE_GENERATED",
	}
	Recording_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
		"ENDED":             2,
		"FILE_GENERATED":    3,
	}
)

func (x Recording_State) Enum() *Recording_State {
	p := new(Recording_State)
	*p = x
	return p
}

func (x Recording_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Recording_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_meet_v2_resource_proto_enumTypes[2].Descriptor()
}

func (Recording_State) Type() protoreflect.EnumType {
	return &file_google_apps_meet_v2_resource_proto_enumTypes[2]
}

func (x Recording_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Recording_State.Descriptor instead.
func (Recording_State) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{9, 0}
}

// Current state of the transcript session.
type Transcript_State int32

const (
	// Default, never used.
	Transcript_STATE_UNSPECIFIED Transcript_State = 0
	// An active transcript session has started.
	Transcript_STARTED Transcript_State = 1
	// This transcript session has ended, but the transcript file hasn't been
	// generated yet.
	Transcript_ENDED Transcript_State = 2
	// Transcript file is generated and ready to download.
	Transcript_FILE_GENERATED Transcript_State = 3
)

// Enum value maps for Transcript_State.
var (
	Transcript_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "ENDED",
		3: "FILE_GENERATED",
	}
	Transcript_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
		"ENDED":             2,
		"FILE_GENERATED":    3,
	}
)

func (x Transcript_State) Enum() *Transcript_State {
	p := new(Transcript_State)
	*p = x
	return p
}

func (x Transcript_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Transcript_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_meet_v2_resource_proto_enumTypes[3].Descriptor()
}

func (Transcript_State) Type() protoreflect.EnumType {
	return &file_google_apps_meet_v2_resource_proto_enumTypes[3]
}

func (x Transcript_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Transcript_State.Descriptor instead.
func (Transcript_State) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{11, 0}
}

// Virtual place where conferences are held. Only one active conference can be
// held in one space at any given time.
type Space struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Resource name of the space.
	//
	// Format: `spaces/{space}`.
	//
	// `{space}` is the resource identifier for the space. It's a unique,
	// server-generated ID and is case sensitive. For example, `jQCFfuBOdN5z`.
	//
	// For more information, see [How Meet identifies a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#identify-meeting-space).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. URI used to join meetings consisting of
	// `https://meet.google.com/` followed by the `meeting_code`. For example,
	// `https://meet.google.com/abc-mnop-xyz`.
	MeetingUri string `protobuf:"bytes,2,opt,name=meeting_uri,json=meetingUri,proto3" json:"meeting_uri,omitempty"`
	// Output only. Type friendly unique string used to join the meeting.
	//
	// Format: `[a-z]+-[a-z]+-[a-z]+`. For example, `abc-mnop-xyz`.
	//
	// The maximum length is 128 characters.
	//
	// Can only be used as an alias of the space name to get the space.
	MeetingCode string `protobuf:"bytes,3,opt,name=meeting_code,json=meetingCode,proto3" json:"meeting_code,omitempty"`
	// Configuration pertaining to the meeting space.
	Config *SpaceConfig `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
	// Active conference, if it exists.
	ActiveConference *ActiveConference `protobuf:"bytes,6,opt,name=active_conference,json=activeConference,proto3" json:"active_conference,omitempty"`
}

func (x *Space) Reset() {
	*x = Space{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space) ProtoMessage() {}

func (x *Space) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space.ProtoReflect.Descriptor instead.
func (*Space) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{0}
}

func (x *Space) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Space) GetMeetingUri() string {
	if x != nil {
		return x.MeetingUri
	}
	return ""
}

func (x *Space) GetMeetingCode() string {
	if x != nil {
		return x.MeetingCode
	}
	return ""
}

func (x *Space) GetConfig() *SpaceConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Space) GetActiveConference() *ActiveConference {
	if x != nil {
		return x.ActiveConference
	}
	return nil
}

// Active conference.
type ActiveConference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reference to 'ConferenceRecord' resource.
	// Format: `conferenceRecords/{conference_record}` where `{conference_record}`
	// is a unique ID for each instance of a call within a space.
	ConferenceRecord string `protobuf:"bytes,1,opt,name=conference_record,json=conferenceRecord,proto3" json:"conference_record,omitempty"`
}

func (x *ActiveConference) Reset() {
	*x = ActiveConference{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActiveConference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActiveConference) ProtoMessage() {}

func (x *ActiveConference) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActiveConference.ProtoReflect.Descriptor instead.
func (*ActiveConference) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{1}
}

func (x *ActiveConference) GetConferenceRecord() string {
	if x != nil {
		return x.ConferenceRecord
	}
	return ""
}

// The configuration pertaining to a meeting space.
type SpaceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Access type of the meeting space that determines who can join without
	// knocking. Default: The user's default access settings.  Controlled by the
	// user's admin for enterprise users or RESTRICTED.
	AccessType SpaceConfig_AccessType `protobuf:"varint,1,opt,name=access_type,json=accessType,proto3,enum=google.apps.meet.v2.SpaceConfig_AccessType" json:"access_type,omitempty"`
	// Defines the entry points that can be used to join meetings hosted in this
	// meeting space.
	// Default: EntryPointAccess.ALL
	EntryPointAccess SpaceConfig_EntryPointAccess `protobuf:"varint,2,opt,name=entry_point_access,json=entryPointAccess,proto3,enum=google.apps.meet.v2.SpaceConfig_EntryPointAccess" json:"entry_point_access,omitempty"`
}

func (x *SpaceConfig) Reset() {
	*x = SpaceConfig{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpaceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpaceConfig) ProtoMessage() {}

func (x *SpaceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpaceConfig.ProtoReflect.Descriptor instead.
func (*SpaceConfig) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{2}
}

func (x *SpaceConfig) GetAccessType() SpaceConfig_AccessType {
	if x != nil {
		return x.AccessType
	}
	return SpaceConfig_ACCESS_TYPE_UNSPECIFIED
}

func (x *SpaceConfig) GetEntryPointAccess() SpaceConfig_EntryPointAccess {
	if x != nil {
		return x.EntryPointAccess
	}
	return SpaceConfig_ENTRY_POINT_ACCESS_UNSPECIFIED
}

// Single instance of a meeting held in a space.
type ConferenceRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Resource name of the conference record.
	// Format: `conferenceRecords/{conference_record}` where `{conference_record}`
	// is a unique ID for each instance of a call within a space.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when the conference started. Always set.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Timestamp when the conference ended.
	// Set for past conferences. Unset if the conference is ongoing.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server enforced expiration time for when this conference
	// record resource is deleted. The resource is deleted 30 days after the
	// conference ends.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. The space where the conference was held.
	Space string `protobuf:"bytes,5,opt,name=space,proto3" json:"space,omitempty"`
}

func (x *ConferenceRecord) Reset() {
	*x = ConferenceRecord{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConferenceRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConferenceRecord) ProtoMessage() {}

func (x *ConferenceRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConferenceRecord.ProtoReflect.Descriptor instead.
func (*ConferenceRecord) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{3}
}

func (x *ConferenceRecord) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConferenceRecord) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ConferenceRecord) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ConferenceRecord) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *ConferenceRecord) GetSpace() string {
	if x != nil {
		return x.Space
	}
	return ""
}

// User who attended or is attending a conference.
type Participant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to User:
	//
	//	*Participant_SignedinUser
	//	*Participant_AnonymousUser
	//	*Participant_PhoneUser
	User isParticipant_User `protobuf_oneof:"user"`
	// Output only. Resource name of the participant.
	// Format: `conferenceRecords/{conference_record}/participants/{participant}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the participant first joined the meeting.
	EarliestStartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=earliest_start_time,json=earliestStartTime,proto3" json:"earliest_start_time,omitempty"`
	// Output only. Time when the participant left the meeting for the last time.
	// This can be null if it's an active meeting.
	LatestEndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=latest_end_time,json=latestEndTime,proto3" json:"latest_end_time,omitempty"`
}

func (x *Participant) Reset() {
	*x = Participant{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Participant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Participant) ProtoMessage() {}

func (x *Participant) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Participant.ProtoReflect.Descriptor instead.
func (*Participant) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{4}
}

func (m *Participant) GetUser() isParticipant_User {
	if m != nil {
		return m.User
	}
	return nil
}

func (x *Participant) GetSignedinUser() *SignedinUser {
	if x, ok := x.GetUser().(*Participant_SignedinUser); ok {
		return x.SignedinUser
	}
	return nil
}

func (x *Participant) GetAnonymousUser() *AnonymousUser {
	if x, ok := x.GetUser().(*Participant_AnonymousUser); ok {
		return x.AnonymousUser
	}
	return nil
}

func (x *Participant) GetPhoneUser() *PhoneUser {
	if x, ok := x.GetUser().(*Participant_PhoneUser); ok {
		return x.PhoneUser
	}
	return nil
}

func (x *Participant) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Participant) GetEarliestStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestStartTime
	}
	return nil
}

func (x *Participant) GetLatestEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestEndTime
	}
	return nil
}

type isParticipant_User interface {
	isParticipant_User()
}

type Participant_SignedinUser struct {
	// Signed-in user.
	SignedinUser *SignedinUser `protobuf:"bytes,4,opt,name=signedin_user,json=signedinUser,proto3,oneof"`
}

type Participant_AnonymousUser struct {
	// Anonymous user.
	AnonymousUser *AnonymousUser `protobuf:"bytes,5,opt,name=anonymous_user,json=anonymousUser,proto3,oneof"`
}

type Participant_PhoneUser struct {
	// User calling from their phone.
	PhoneUser *PhoneUser `protobuf:"bytes,6,opt,name=phone_user,json=phoneUser,proto3,oneof"`
}

func (*Participant_SignedinUser) isParticipant_User() {}

func (*Participant_AnonymousUser) isParticipant_User() {}

func (*Participant_PhoneUser) isParticipant_User() {}

// Refers to each unique join or leave session when a user joins a conference
// from a device. Note that any time a user joins the conference a new unique ID
// is assigned. That means if a user joins a space multiple times from the same
// device, they're assigned different IDs, and are also be treated as different
// participant sessions.
type ParticipantSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Session id.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when the user session starts.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Timestamp when the user session ends. Unset if the user
	// session hasn’t ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ParticipantSession) Reset() {
	*x = ParticipantSession{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ParticipantSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParticipantSession) ProtoMessage() {}

func (x *ParticipantSession) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParticipantSession.ProtoReflect.Descriptor instead.
func (*ParticipantSession) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{5}
}

func (x *ParticipantSession) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ParticipantSession) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ParticipantSession) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// A signed-in user can be:
// a) An individual joining from a personal computer, mobile device, or through
// companion mode.
// b) A robot account used by conference room devices.
type SignedinUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique ID for the user. Interoperable with Admin SDK API and
	// People API. Format: `users/{user}`
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// Output only. For a personal device, it's the user's first name and last
	// name. For a robot account, it's the administrator-specified device name.
	// For example, "Altostrat Room".
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *SignedinUser) Reset() {
	*x = SignedinUser{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SignedinUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignedinUser) ProtoMessage() {}

func (x *SignedinUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignedinUser.ProtoReflect.Descriptor instead.
func (*SignedinUser) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{6}
}

func (x *SignedinUser) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *SignedinUser) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// User who joins anonymously (meaning not signed into a Google Account).
type AnonymousUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. User provided name when they join a conference anonymously.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AnonymousUser) Reset() {
	*x = AnonymousUser{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnonymousUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnonymousUser) ProtoMessage() {}

func (x *AnonymousUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnonymousUser.ProtoReflect.Descriptor instead.
func (*AnonymousUser) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{7}
}

func (x *AnonymousUser) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// User dialing in from a phone where the user's identity is unknown because
// they haven't signed in with a Google Account.
type PhoneUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Partially redacted user's phone number when calling.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *PhoneUser) Reset() {
	*x = PhoneUser{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PhoneUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhoneUser) ProtoMessage() {}

func (x *PhoneUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhoneUser.ProtoReflect.Descriptor instead.
func (*PhoneUser) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{8}
}

func (x *PhoneUser) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Metadata about a recording created during a conference.
type Recording struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Destination:
	//
	//	*Recording_DriveDestination
	Destination isRecording_Destination `protobuf_oneof:"destination"`
	// Output only. Resource name of the recording.
	// Format: `conferenceRecords/{conference_record}/recordings/{recording}`
	// where `{recording}` is a 1:1 mapping to each unique recording session
	// during the conference.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Current state.
	State Recording_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.apps.meet.v2.Recording_State" json:"state,omitempty"`
	// Output only. Timestamp when the recording started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Timestamp when the recording ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Recording) Reset() {
	*x = Recording{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Recording) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recording) ProtoMessage() {}

func (x *Recording) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recording.ProtoReflect.Descriptor instead.
func (*Recording) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{9}
}

func (m *Recording) GetDestination() isRecording_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *Recording) GetDriveDestination() *DriveDestination {
	if x, ok := x.GetDestination().(*Recording_DriveDestination); ok {
		return x.DriveDestination
	}
	return nil
}

func (x *Recording) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Recording) GetState() Recording_State {
	if x != nil {
		return x.State
	}
	return Recording_STATE_UNSPECIFIED
}

func (x *Recording) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Recording) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isRecording_Destination interface {
	isRecording_Destination()
}

type Recording_DriveDestination struct {
	// Output only. Recording is saved to Google Drive as an MP4 file. The
	// `drive_destination` includes the Drive `fileId` that can be used to
	// download the file using the `files.get` method of the Drive API.
	DriveDestination *DriveDestination `protobuf:"bytes,6,opt,name=drive_destination,json=driveDestination,proto3,oneof"`
}

func (*Recording_DriveDestination) isRecording_Destination() {}

// Export location where a recording file is saved in Google Drive.
type DriveDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The `fileId` for the underlying MP4 file. For example,
	// "1kuceFZohVoCh6FulBHxwy6I15Ogpc4hP". Use `$ GET
	// https://www.googleapis.com/drive/v3/files/{$fileId}?alt=media` to download
	// the blob. For more information, see
	// https://developers.google.com/drive/api/v3/reference/files/get.
	File string `protobuf:"bytes,1,opt,name=file,proto3" json:"file,omitempty"`
	// Output only. Link used to play back the recording file in the browser. For
	// example, `https://drive.google.com/file/d/{$fileId}/view`.
	ExportUri string `protobuf:"bytes,2,opt,name=export_uri,json=exportUri,proto3" json:"export_uri,omitempty"`
}

func (x *DriveDestination) Reset() {
	*x = DriveDestination{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DriveDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveDestination) ProtoMessage() {}

func (x *DriveDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveDestination.ProtoReflect.Descriptor instead.
func (*DriveDestination) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{10}
}

func (x *DriveDestination) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *DriveDestination) GetExportUri() string {
	if x != nil {
		return x.ExportUri
	}
	return ""
}

// Metadata for a transcript generated from a conference. It refers to the ASR
// (Automatic Speech Recognition) result of user's speech during the conference.
type Transcript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Destination:
	//
	//	*Transcript_DocsDestination
	Destination isTranscript_Destination `protobuf_oneof:"destination"`
	// Output only. Resource name of the transcript.
	// Format: `conferenceRecords/{conference_record}/transcripts/{transcript}`,
	// where `{transcript}` is a 1:1 mapping to each unique transcription session
	// of the conference.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Current state.
	State Transcript_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.apps.meet.v2.Transcript_State" json:"state,omitempty"`
	// Output only. Timestamp when the transcript started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Timestamp when the transcript stopped.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Transcript) Reset() {
	*x = Transcript{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Transcript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transcript) ProtoMessage() {}

func (x *Transcript) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transcript.ProtoReflect.Descriptor instead.
func (*Transcript) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{11}
}

func (m *Transcript) GetDestination() isTranscript_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *Transcript) GetDocsDestination() *DocsDestination {
	if x, ok := x.GetDestination().(*Transcript_DocsDestination); ok {
		return x.DocsDestination
	}
	return nil
}

func (x *Transcript) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Transcript) GetState() Transcript_State {
	if x != nil {
		return x.State
	}
	return Transcript_STATE_UNSPECIFIED
}

func (x *Transcript) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Transcript) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isTranscript_Destination interface {
	isTranscript_Destination()
}

type Transcript_DocsDestination struct {
	// Output only. Where the Google Docs transcript is saved.
	DocsDestination *DocsDestination `protobuf:"bytes,6,opt,name=docs_destination,json=docsDestination,proto3,oneof"`
}

func (*Transcript_DocsDestination) isTranscript_Destination() {}

// Google Docs location where the transcript file is saved.
type DocsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The document ID for the underlying Google Docs transcript
	// file. For example, "1kuceFZohVoCh6FulBHxwy6I15Ogpc4hP". Use the
	// `documents.get` method of the Google Docs API
	// (https://developers.google.com/docs/api/reference/rest/v1/documents/get) to
	// fetch the content.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Output only. URI for the Google Docs transcript file. Use
	// `https://docs.google.com/document/d/{$DocumentId}/view` to browse the
	// transcript in the browser.
	ExportUri string `protobuf:"bytes,2,opt,name=export_uri,json=exportUri,proto3" json:"export_uri,omitempty"`
}

func (x *DocsDestination) Reset() {
	*x = DocsDestination{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocsDestination) ProtoMessage() {}

func (x *DocsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocsDestination.ProtoReflect.Descriptor instead.
func (*DocsDestination) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{12}
}

func (x *DocsDestination) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *DocsDestination) GetExportUri() string {
	if x != nil {
		return x.ExportUri
	}
	return ""
}

// Single entry for one user’s speech during a transcript session.
type TranscriptEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the entry. Format:
	// "conferenceRecords/{conference_record}/transcripts/{transcript}/entries/{entry}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Refers to the participant who speaks.
	Participant string `protobuf:"bytes,2,opt,name=participant,proto3" json:"participant,omitempty"`
	// Output only. The transcribed text of the participant's voice, at maximum
	// 10K words. Note that the limit is subject to change.
	Text string `protobuf:"bytes,3,opt,name=text,proto3" json:"text,omitempty"`
	// Output only. Language of spoken text, such as "en-US".
	// IETF BCP 47 syntax (https://tools.ietf.org/html/bcp47)
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Output only. Timestamp when the transcript entry started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Timestamp when the transcript entry ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TranscriptEntry) Reset() {
	*x = TranscriptEntry{}
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranscriptEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranscriptEntry) ProtoMessage() {}

func (x *TranscriptEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2_resource_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranscriptEntry.ProtoReflect.Descriptor instead.
func (*TranscriptEntry) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2_resource_proto_rawDescGZIP(), []int{13}
}

func (x *TranscriptEntry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TranscriptEntry) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (x *TranscriptEntry) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *TranscriptEntry) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *TranscriptEntry) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TranscriptEntry) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

var File_google_apps_meet_v2_resource_proto protoreflect.FileDescriptor

var file_google_apps_meet_v2_resource_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x6d, 0x65,
	0x65, 0x74, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xac, 0x02, 0x0a, 0x05, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x65, 0x65,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x69, 0x12,
	0x26, 0x0a, 0x0c, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6d, 0x65, 0x65, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x38, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x52, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x3a, 0x2e, 0xea, 0x41, 0x2b, 0x0a, 0x19, 0x6d, 0x65, 0x65, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x0e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x7d, 0x22, 0x6d, 0x0a, 0x10, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x59, 0x0a, 0x11, 0x63, 0x6f, 0x6e,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x22, 0xe5, 0x02, 0x0a, 0x0b, 0x53, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65,
	0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x10, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x22, 0x50, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x4f, 0x50, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x52, 0x55, 0x53,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43,
	0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x55, 0x0a, 0x10, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x22, 0x0a, 0x1e, 0x45, 0x4e, 0x54,
	0x52, 0x59, 0x5f, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a,
	0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x52, 0x45, 0x41, 0x54, 0x4f,
	0x52, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22, 0x99, 0x03, 0x0a,
	0x10, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1b, 0x0a,
	0x19, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x24, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x25, 0x63, 0x6f,
	0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x7d, 0x2a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x32, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0xa4, 0x04, 0x0a, 0x0b, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0d, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x69, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x69, 0x6e, 0x55, 0x73,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x69, 0x6e, 0x55, 0x73,
	0x65, 0x72, 0x12, 0x4b, 0x0a, 0x0e, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x55, 0x73, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x0d, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x55, 0x73, 0x65, 0x72, 0x12,
	0x3f, 0x0a, 0x0a, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x48, 0x00, 0x52, 0x09, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x13, 0x65, 0x61, 0x72,
	0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73,
	0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x1f, 0x6d, 0x65, 0x65, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x40, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x7d, 0x2a, 0x0c, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x32, 0x0b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x22,
	0xed, 0x02, 0x0a, 0x12, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0xc1, 0x01, 0xea, 0x41,
	0xbd, 0x01, 0x0a, 0x26, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x12, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x4f, 0x0a, 0x0c, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x12,
	0x17, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x37, 0x0a, 0x0d, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x55, 0x73, 0x65,
	0x72, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x33, 0x0a, 0x09, 0x50, 0x68, 0x6f,
	0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x90,
	0x04, 0x0a, 0x09, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x59, 0x0a, 0x11,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x10, 0x64, 0x72, 0x69, 0x76, 0x65, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x4a, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x4e,
	0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x47, 0x45,
	0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x1d,
	0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3c, 0x63,
	0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73,
	0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x2a, 0x0a, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x4f, 0x0a, 0x10, 0x44, 0x72, 0x69, 0x76, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x55,
	0x72, 0x69, 0x22, 0x94, 0x04, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x12, 0x56, 0x0a, 0x10, 0x64, 0x6f, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x6f, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x6f, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x4a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x4c, 0x45,
	0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x7c, 0xea, 0x41,
	0x79, 0x0a, 0x1e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x12, 0x3e, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x7d, 0x2a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x32, 0x0a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x56, 0x0a, 0x0f, 0x44, 0x6f, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x72,
	0x69, 0x22, 0xd4, 0x03, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49,
	0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6d, 0x65, 0x65,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3e, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x9d, 0x01, 0xea, 0x41, 0x99, 0x01, 0x0a,
	0x23, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x4e, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x7d, 0x2a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x32, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0xa2, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65,
	0x74, 0x2e, 0x76, 0x32, 0x42, 0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x6d, 0x65, 0x65, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x70,
	0x62, 0x3b, 0x6d, 0x65, 0x65, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x4d, 0x65, 0x65, 0x74, 0x2e, 0x56, 0x32, 0xca, 0x02,
	0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x4d, 0x65, 0x65,
	0x74, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41,
	0x70, 0x70, 0x73, 0x3a, 0x3a, 0x4d, 0x65, 0x65, 0x74, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_meet_v2_resource_proto_rawDescOnce sync.Once
	file_google_apps_meet_v2_resource_proto_rawDescData = file_google_apps_meet_v2_resource_proto_rawDesc
)

func file_google_apps_meet_v2_resource_proto_rawDescGZIP() []byte {
	file_google_apps_meet_v2_resource_proto_rawDescOnce.Do(func() {
		file_google_apps_meet_v2_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_meet_v2_resource_proto_rawDescData)
	})
	return file_google_apps_meet_v2_resource_proto_rawDescData
}

var file_google_apps_meet_v2_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_apps_meet_v2_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_apps_meet_v2_resource_proto_goTypes = []any{
	(SpaceConfig_AccessType)(0),       // 0: google.apps.meet.v2.SpaceConfig.AccessType
	(SpaceConfig_EntryPointAccess)(0), // 1: google.apps.meet.v2.SpaceConfig.EntryPointAccess
	(Recording_State)(0),              // 2: google.apps.meet.v2.Recording.State
	(Transcript_State)(0),             // 3: google.apps.meet.v2.Transcript.State
	(*Space)(nil),                     // 4: google.apps.meet.v2.Space
	(*ActiveConference)(nil),          // 5: google.apps.meet.v2.ActiveConference
	(*SpaceConfig)(nil),               // 6: google.apps.meet.v2.SpaceConfig
	(*ConferenceRecord)(nil),          // 7: google.apps.meet.v2.ConferenceRecord
	(*Participant)(nil),               // 8: google.apps.meet.v2.Participant
	(*ParticipantSession)(nil),        // 9: google.apps.meet.v2.ParticipantSession
	(*SignedinUser)(nil),              // 10: google.apps.meet.v2.SignedinUser
	(*AnonymousUser)(nil),             // 11: google.apps.meet.v2.AnonymousUser
	(*PhoneUser)(nil),                 // 12: google.apps.meet.v2.PhoneUser
	(*Recording)(nil),                 // 13: google.apps.meet.v2.Recording
	(*DriveDestination)(nil),          // 14: google.apps.meet.v2.DriveDestination
	(*Transcript)(nil),                // 15: google.apps.meet.v2.Transcript
	(*DocsDestination)(nil),           // 16: google.apps.meet.v2.DocsDestination
	(*TranscriptEntry)(nil),           // 17: google.apps.meet.v2.TranscriptEntry
	(*timestamppb.Timestamp)(nil),     // 18: google.protobuf.Timestamp
}
var file_google_apps_meet_v2_resource_proto_depIdxs = []int32{
	6,  // 0: google.apps.meet.v2.Space.config:type_name -> google.apps.meet.v2.SpaceConfig
	5,  // 1: google.apps.meet.v2.Space.active_conference:type_name -> google.apps.meet.v2.ActiveConference
	0,  // 2: google.apps.meet.v2.SpaceConfig.access_type:type_name -> google.apps.meet.v2.SpaceConfig.AccessType
	1,  // 3: google.apps.meet.v2.SpaceConfig.entry_point_access:type_name -> google.apps.meet.v2.SpaceConfig.EntryPointAccess
	18, // 4: google.apps.meet.v2.ConferenceRecord.start_time:type_name -> google.protobuf.Timestamp
	18, // 5: google.apps.meet.v2.ConferenceRecord.end_time:type_name -> google.protobuf.Timestamp
	18, // 6: google.apps.meet.v2.ConferenceRecord.expire_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.apps.meet.v2.Participant.signedin_user:type_name -> google.apps.meet.v2.SignedinUser
	11, // 8: google.apps.meet.v2.Participant.anonymous_user:type_name -> google.apps.meet.v2.AnonymousUser
	12, // 9: google.apps.meet.v2.Participant.phone_user:type_name -> google.apps.meet.v2.PhoneUser
	18, // 10: google.apps.meet.v2.Participant.earliest_start_time:type_name -> google.protobuf.Timestamp
	18, // 11: google.apps.meet.v2.Participant.latest_end_time:type_name -> google.protobuf.Timestamp
	18, // 12: google.apps.meet.v2.ParticipantSession.start_time:type_name -> google.protobuf.Timestamp
	18, // 13: google.apps.meet.v2.ParticipantSession.end_time:type_name -> google.protobuf.Timestamp
	14, // 14: google.apps.meet.v2.Recording.drive_destination:type_name -> google.apps.meet.v2.DriveDestination
	2,  // 15: google.apps.meet.v2.Recording.state:type_name -> google.apps.meet.v2.Recording.State
	18, // 16: google.apps.meet.v2.Recording.start_time:type_name -> google.protobuf.Timestamp
	18, // 17: google.apps.meet.v2.Recording.end_time:type_name -> google.protobuf.Timestamp
	16, // 18: google.apps.meet.v2.Transcript.docs_destination:type_name -> google.apps.meet.v2.DocsDestination
	3,  // 19: google.apps.meet.v2.Transcript.state:type_name -> google.apps.meet.v2.Transcript.State
	18, // 20: google.apps.meet.v2.Transcript.start_time:type_name -> google.protobuf.Timestamp
	18, // 21: google.apps.meet.v2.Transcript.end_time:type_name -> google.protobuf.Timestamp
	18, // 22: google.apps.meet.v2.TranscriptEntry.start_time:type_name -> google.protobuf.Timestamp
	18, // 23: google.apps.meet.v2.TranscriptEntry.end_time:type_name -> google.protobuf.Timestamp
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_apps_meet_v2_resource_proto_init() }
func file_google_apps_meet_v2_resource_proto_init() {
	if File_google_apps_meet_v2_resource_proto != nil {
		return
	}
	file_google_apps_meet_v2_resource_proto_msgTypes[4].OneofWrappers = []any{
		(*Participant_SignedinUser)(nil),
		(*Participant_AnonymousUser)(nil),
		(*Participant_PhoneUser)(nil),
	}
	file_google_apps_meet_v2_resource_proto_msgTypes[9].OneofWrappers = []any{
		(*Recording_DriveDestination)(nil),
	}
	file_google_apps_meet_v2_resource_proto_msgTypes[11].OneofWrappers = []any{
		(*Transcript_DocsDestination)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_meet_v2_resource_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_meet_v2_resource_proto_goTypes,
		DependencyIndexes: file_google_apps_meet_v2_resource_proto_depIdxs,
		EnumInfos:         file_google_apps_meet_v2_resource_proto_enumTypes,
		MessageInfos:      file_google_apps_meet_v2_resource_proto_msgTypes,
	}.Build()
	File_google_apps_meet_v2_resource_proto = out.File
	file_google_apps_meet_v2_resource_proto_rawDesc = nil
	file_google_apps_meet_v2_resource_proto_goTypes = nil
	file_google_apps_meet_v2_resource_proto_depIdxs = nil
}
