// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/ai/generativelanguage/v1beta/generative_service.proto

package generativelanguagepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of task for which the embedding will be used.
type TaskType int32

const (
	// Unset value, which will default to one of the other enum values.
	TaskType_TASK_TYPE_UNSPECIFIED TaskType = 0
	// Specifies the given text is a query in a search/retrieval setting.
	TaskType_RETRIEVAL_QUERY TaskType = 1
	// Specifies the given text is a document from the corpus being searched.
	TaskType_RETRIEVAL_DOCUMENT TaskType = 2
	// Specifies the given text will be used for STS.
	TaskType_SEMANTIC_SIMILARITY TaskType = 3
	// Specifies that the given text will be classified.
	TaskType_CLASSIFICATION TaskType = 4
	// Specifies that the embeddings will be used for clustering.
	TaskType_CLUSTERING TaskType = 5
)

// Enum value maps for TaskType.
var (
	TaskType_name = map[int32]string{
		0: "TASK_TYPE_UNSPECIFIED",
		1: "RETRIEVAL_QUERY",
		2: "RETRIEVAL_DOCUMENT",
		3: "SEMANTIC_SIMILARITY",
		4: "CLASSIFICATION",
		5: "CLUSTERING",
	}
	TaskType_value = map[string]int32{
		"TASK_TYPE_UNSPECIFIED": 0,
		"RETRIEVAL_QUERY":       1,
		"RETRIEVAL_DOCUMENT":    2,
		"SEMANTIC_SIMILARITY":   3,
		"CLASSIFICATION":        4,
		"CLUSTERING":            5,
	}
)

func (x TaskType) Enum() *TaskType {
	p := new(TaskType)
	*p = x
	return p
}

func (x TaskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[0].Descriptor()
}

func (TaskType) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[0]
}

func (x TaskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskType.Descriptor instead.
func (TaskType) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{0}
}

// Specifies what was the reason why prompt was blocked.
type GenerateContentResponse_PromptFeedback_BlockReason int32

const (
	// Default value. This value is unused.
	GenerateContentResponse_PromptFeedback_BLOCK_REASON_UNSPECIFIED GenerateContentResponse_PromptFeedback_BlockReason = 0
	// Prompt was blocked due to safety reasons. You can inspect
	// `safety_ratings` to understand which safety category blocked it.
	GenerateContentResponse_PromptFeedback_SAFETY GenerateContentResponse_PromptFeedback_BlockReason = 1
	// Prompt was blocked due to unknown reaasons.
	GenerateContentResponse_PromptFeedback_OTHER GenerateContentResponse_PromptFeedback_BlockReason = 2
)

// Enum value maps for GenerateContentResponse_PromptFeedback_BlockReason.
var (
	GenerateContentResponse_PromptFeedback_BlockReason_name = map[int32]string{
		0: "BLOCK_REASON_UNSPECIFIED",
		1: "SAFETY",
		2: "OTHER",
	}
	GenerateContentResponse_PromptFeedback_BlockReason_value = map[string]int32{
		"BLOCK_REASON_UNSPECIFIED": 0,
		"SAFETY":                   1,
		"OTHER":                    2,
	}
)

func (x GenerateContentResponse_PromptFeedback_BlockReason) Enum() *GenerateContentResponse_PromptFeedback_BlockReason {
	p := new(GenerateContentResponse_PromptFeedback_BlockReason)
	*p = x
	return p
}

func (x GenerateContentResponse_PromptFeedback_BlockReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateContentResponse_PromptFeedback_BlockReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[1].Descriptor()
}

func (GenerateContentResponse_PromptFeedback_BlockReason) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[1]
}

func (x GenerateContentResponse_PromptFeedback_BlockReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateContentResponse_PromptFeedback_BlockReason.Descriptor instead.
func (GenerateContentResponse_PromptFeedback_BlockReason) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{3, 0, 0}
}

// Defines the reason why the model stopped generating tokens.
type Candidate_FinishReason int32

const (
	// Default value. This value is unused.
	Candidate_FINISH_REASON_UNSPECIFIED Candidate_FinishReason = 0
	// Natural stop point of the model or provided stop sequence.
	Candidate_STOP Candidate_FinishReason = 1
	// The maximum number of tokens as specified in the request was reached.
	Candidate_MAX_TOKENS Candidate_FinishReason = 2
	// The candidate content was flagged for safety reasons.
	Candidate_SAFETY Candidate_FinishReason = 3
	// The candidate content was flagged for recitation reasons.
	Candidate_RECITATION Candidate_FinishReason = 4
	// Unknown reason.
	Candidate_OTHER Candidate_FinishReason = 5
)

// Enum value maps for Candidate_FinishReason.
var (
	Candidate_FinishReason_name = map[int32]string{
		0: "FINISH_REASON_UNSPECIFIED",
		1: "STOP",
		2: "MAX_TOKENS",
		3: "SAFETY",
		4: "RECITATION",
		5: "OTHER",
	}
	Candidate_FinishReason_value = map[string]int32{
		"FINISH_REASON_UNSPECIFIED": 0,
		"STOP":                      1,
		"MAX_TOKENS":                2,
		"SAFETY":                    3,
		"RECITATION":                4,
		"OTHER":                     5,
	}
)

func (x Candidate_FinishReason) Enum() *Candidate_FinishReason {
	p := new(Candidate_FinishReason)
	*p = x
	return p
}

func (x Candidate_FinishReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Candidate_FinishReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[2].Descriptor()
}

func (Candidate_FinishReason) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[2]
}

func (x Candidate_FinishReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Candidate_FinishReason.Descriptor instead.
func (Candidate_FinishReason) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{4, 0}
}

// Style for grounded answers.
type GenerateAnswerRequest_AnswerStyle int32

const (
	// Unspecified answer style.
	GenerateAnswerRequest_ANSWER_STYLE_UNSPECIFIED GenerateAnswerRequest_AnswerStyle = 0
	// Succint but abstract style.
	GenerateAnswerRequest_ABSTRACTIVE GenerateAnswerRequest_AnswerStyle = 1
	// Very brief and extractive style.
	GenerateAnswerRequest_EXTRACTIVE GenerateAnswerRequest_AnswerStyle = 2
	// Verbose style including extra details. The response may be formatted as a
	// sentence, paragraph, multiple paragraphs, or bullet points, etc.
	GenerateAnswerRequest_VERBOSE GenerateAnswerRequest_AnswerStyle = 3
)

// Enum value maps for GenerateAnswerRequest_AnswerStyle.
var (
	GenerateAnswerRequest_AnswerStyle_name = map[int32]string{
		0: "ANSWER_STYLE_UNSPECIFIED",
		1: "ABSTRACTIVE",
		2: "EXTRACTIVE",
		3: "VERBOSE",
	}
	GenerateAnswerRequest_AnswerStyle_value = map[string]int32{
		"ANSWER_STYLE_UNSPECIFIED": 0,
		"ABSTRACTIVE":              1,
		"EXTRACTIVE":               2,
		"VERBOSE":                  3,
	}
)

func (x GenerateAnswerRequest_AnswerStyle) Enum() *GenerateAnswerRequest_AnswerStyle {
	p := new(GenerateAnswerRequest_AnswerStyle)
	*p = x
	return p
}

func (x GenerateAnswerRequest_AnswerStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateAnswerRequest_AnswerStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[3].Descriptor()
}

func (GenerateAnswerRequest_AnswerStyle) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[3]
}

func (x GenerateAnswerRequest_AnswerStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateAnswerRequest_AnswerStyle.Descriptor instead.
func (GenerateAnswerRequest_AnswerStyle) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{7, 0}
}

// Specifies what was the reason why input was blocked.
type GenerateAnswerResponse_InputFeedback_BlockReason int32

const (
	// Default value. This value is unused.
	GenerateAnswerResponse_InputFeedback_BLOCK_REASON_UNSPECIFIED GenerateAnswerResponse_InputFeedback_BlockReason = 0
	// Input was blocked due to safety reasons. You can inspect
	// `safety_ratings` to understand which safety category blocked it.
	GenerateAnswerResponse_InputFeedback_SAFETY GenerateAnswerResponse_InputFeedback_BlockReason = 1
	// Input was blocked due to other reasons.
	GenerateAnswerResponse_InputFeedback_OTHER GenerateAnswerResponse_InputFeedback_BlockReason = 2
)

// Enum value maps for GenerateAnswerResponse_InputFeedback_BlockReason.
var (
	GenerateAnswerResponse_InputFeedback_BlockReason_name = map[int32]string{
		0: "BLOCK_REASON_UNSPECIFIED",
		1: "SAFETY",
		2: "OTHER",
	}
	GenerateAnswerResponse_InputFeedback_BlockReason_value = map[string]int32{
		"BLOCK_REASON_UNSPECIFIED": 0,
		"SAFETY":                   1,
		"OTHER":                    2,
	}
)

func (x GenerateAnswerResponse_InputFeedback_BlockReason) Enum() *GenerateAnswerResponse_InputFeedback_BlockReason {
	p := new(GenerateAnswerResponse_InputFeedback_BlockReason)
	*p = x
	return p
}

func (x GenerateAnswerResponse_InputFeedback_BlockReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateAnswerResponse_InputFeedback_BlockReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[4].Descriptor()
}

func (GenerateAnswerResponse_InputFeedback_BlockReason) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[4]
}

func (x GenerateAnswerResponse_InputFeedback_BlockReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateAnswerResponse_InputFeedback_BlockReason.Descriptor instead.
func (GenerateAnswerResponse_InputFeedback_BlockReason) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{8, 0, 0}
}

// Request to generate a completion from the model.
type GenerateContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Model` to use for generating the completion.
	//
	// Format: `name=models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content of the current conversation with the model.
	//
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. A list of `Tools` the model may use to generate the next
	// response.
	//
	// A `Tool` is a piece of code that enables the system to interact with
	// external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model. The only supported tool is currently
	// `Function`.
	Tools []*Tool `protobuf:"bytes,5,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. A list of unique `SafetySetting` instances for blocking unsafe
	// content.
	//
	// This will be enforced on the `GenerateContentRequest.contents` and
	// `GenerateContentResponse.candidates`. There should not be more than one
	// setting for each `SafetyCategory` type. The API will block any contents and
	// responses that fail to meet the thresholds set by these settings. This list
	// overrides the default settings for each `SafetyCategory` specified in the
	// safety_settings. If there is no `SafetySetting` for a given
	// `SafetyCategory` provided in the list, the API will use the default safety
	// setting for that category. Harm categories HARM_CATEGORY_HATE_SPEECH,
	// HARM_CATEGORY_SEXUALLY_EXPLICIT, HARM_CATEGORY_DANGEROUS_CONTENT,
	// HARM_CATEGORY_HARASSMENT are supported.
	SafetySettings []*SafetySetting `protobuf:"bytes,3,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
	// Optional. Configuration options for model generation and outputs.
	GenerationConfig *GenerationConfig `protobuf:"bytes,4,opt,name=generation_config,json=generationConfig,proto3,oneof" json:"generation_config,omitempty"`
}

func (x *GenerateContentRequest) Reset() {
	*x = GenerateContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentRequest) ProtoMessage() {}

func (x *GenerateContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentRequest.ProtoReflect.Descriptor instead.
func (*GenerateContentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{0}
}

func (x *GenerateContentRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *GenerateContentRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GenerateContentRequest) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *GenerateContentRequest) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

func (x *GenerateContentRequest) GetGenerationConfig() *GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

// Configuration options for model generation and outputs. Not all parameters
// may be configurable for every model.
type GenerationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Number of generated responses to return.
	//
	// This value must be between [1, 8], inclusive. If unset, this will default
	// to 1.
	CandidateCount *int32 `protobuf:"varint,1,opt,name=candidate_count,json=candidateCount,proto3,oneof" json:"candidate_count,omitempty"`
	// Optional. The set of character sequences (up to 5) that will stop output
	// generation. If specified, the API will stop at the first appearance of a
	// stop sequence. The stop sequence will not be included as part of the
	// response.
	StopSequences []string `protobuf:"bytes,2,rep,name=stop_sequences,json=stopSequences,proto3" json:"stop_sequences,omitempty"`
	// Optional. The maximum number of tokens to include in a candidate.
	//
	// If unset, this will default to output_token_limit specified in the `Model`
	// specification.
	MaxOutputTokens *int32 `protobuf:"varint,4,opt,name=max_output_tokens,json=maxOutputTokens,proto3,oneof" json:"max_output_tokens,omitempty"`
	// Optional. Controls the randomness of the output.
	// Note: The default value varies by model, see the `Model.temperature`
	// attribute of the `Model` returned the `getModel` function.
	//
	// Values can range from [0.0,1.0],
	// inclusive. A value closer to 1.0 will produce responses that are more
	// varied and creative, while a value closer to 0.0 will typically result in
	// more straightforward responses from the model.
	Temperature *float32 `protobuf:"fixed32,5,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// Optional. The maximum cumulative probability of tokens to consider when
	// sampling.
	//
	// The model uses combined Top-k and nucleus sampling.
	//
	// Tokens are sorted based on their assigned probabilities so that only the
	// most likely tokens are considered. Top-k sampling directly limits the
	// maximum number of tokens to consider, while Nucleus sampling limits number
	// of tokens based on the cumulative probability.
	//
	// Note: The default value varies by model, see the `Model.top_p`
	// attribute of the `Model` returned the `getModel` function.
	TopP *float32 `protobuf:"fixed32,6,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
	// Optional. The maximum number of tokens to consider when sampling.
	//
	// The model uses combined Top-k and nucleus sampling.
	//
	// Top-k sampling considers the set of `top_k` most probable tokens.
	// Defaults to 40.
	//
	// Note: The default value varies by model, see the `Model.top_k`
	// attribute of the `Model` returned the `getModel` function.
	TopK *int32 `protobuf:"varint,7,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
}

func (x *GenerationConfig) Reset() {
	*x = GenerationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig) ProtoMessage() {}

func (x *GenerationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{1}
}

func (x *GenerationConfig) GetCandidateCount() int32 {
	if x != nil && x.CandidateCount != nil {
		return *x.CandidateCount
	}
	return 0
}

func (x *GenerationConfig) GetStopSequences() []string {
	if x != nil {
		return x.StopSequences
	}
	return nil
}

func (x *GenerationConfig) GetMaxOutputTokens() int32 {
	if x != nil && x.MaxOutputTokens != nil {
		return *x.MaxOutputTokens
	}
	return 0
}

func (x *GenerationConfig) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *GenerationConfig) GetTopP() float32 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

func (x *GenerationConfig) GetTopK() int32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

// Configuration for retrieving grounding content from a `Corpus` or
// `Document` created using the Semantic Retriever API.
type SemanticRetrieverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource for retrieval, e.g. corpora/123 or
	// corpora/123/documents/abc.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Required. Query to use for similarity matching `Chunk`s in the given
	// resource.
	Query *Content `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. Filters for selecting `Document`s and/or `Chunk`s from the
	// resource.
	MetadataFilters []*MetadataFilter `protobuf:"bytes,3,rep,name=metadata_filters,json=metadataFilters,proto3" json:"metadata_filters,omitempty"`
	// Optional. Maximum number of relevant `Chunk`s to retrieve.
	MaxChunksCount *int32 `protobuf:"varint,4,opt,name=max_chunks_count,json=maxChunksCount,proto3,oneof" json:"max_chunks_count,omitempty"`
	// Optional. Minimum relevance score for retrieved relevant `Chunk`s.
	MinimumRelevanceScore *float32 `protobuf:"fixed32,5,opt,name=minimum_relevance_score,json=minimumRelevanceScore,proto3,oneof" json:"minimum_relevance_score,omitempty"`
}

func (x *SemanticRetrieverConfig) Reset() {
	*x = SemanticRetrieverConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SemanticRetrieverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SemanticRetrieverConfig) ProtoMessage() {}

func (x *SemanticRetrieverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SemanticRetrieverConfig.ProtoReflect.Descriptor instead.
func (*SemanticRetrieverConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{2}
}

func (x *SemanticRetrieverConfig) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *SemanticRetrieverConfig) GetQuery() *Content {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SemanticRetrieverConfig) GetMetadataFilters() []*MetadataFilter {
	if x != nil {
		return x.MetadataFilters
	}
	return nil
}

func (x *SemanticRetrieverConfig) GetMaxChunksCount() int32 {
	if x != nil && x.MaxChunksCount != nil {
		return *x.MaxChunksCount
	}
	return 0
}

func (x *SemanticRetrieverConfig) GetMinimumRelevanceScore() float32 {
	if x != nil && x.MinimumRelevanceScore != nil {
		return *x.MinimumRelevanceScore
	}
	return 0
}

// Response from the model supporting multiple candidates.
//
// Note on safety ratings and content filtering. They are reported for both
// prompt in `GenerateContentResponse.prompt_feedback` and for each candidate
// in `finish_reason` and in `safety_ratings`. The API contract is that:
//   - either all requested candidates are returned or no candidates at all
//   - no candidates are returned only if there was something wrong with the
//     prompt (see `prompt_feedback`)
//   - feedback on each candidate is reported on `finish_reason` and
//     `safety_ratings`.
type GenerateContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Candidate responses from the model.
	Candidates []*Candidate `protobuf:"bytes,1,rep,name=candidates,proto3" json:"candidates,omitempty"`
	// Returns the prompt's feedback related to the content filters.
	PromptFeedback *GenerateContentResponse_PromptFeedback `protobuf:"bytes,2,opt,name=prompt_feedback,json=promptFeedback,proto3" json:"prompt_feedback,omitempty"`
}

func (x *GenerateContentResponse) Reset() {
	*x = GenerateContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse) ProtoMessage() {}

func (x *GenerateContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{3}
}

func (x *GenerateContentResponse) GetCandidates() []*Candidate {
	if x != nil {
		return x.Candidates
	}
	return nil
}

func (x *GenerateContentResponse) GetPromptFeedback() *GenerateContentResponse_PromptFeedback {
	if x != nil {
		return x.PromptFeedback
	}
	return nil
}

// A response candidate generated from the model.
type Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Index of the candidate in the list of candidates.
	Index *int32 `protobuf:"varint,3,opt,name=index,proto3,oneof" json:"index,omitempty"`
	// Output only. Generated content returned from the model.
	Content *Content `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. Output only. The reason why the model stopped generating tokens.
	//
	// If empty, the model has not stopped generating the tokens.
	FinishReason Candidate_FinishReason `protobuf:"varint,2,opt,name=finish_reason,json=finishReason,proto3,enum=google.ai.generativelanguage.v1beta.Candidate_FinishReason" json:"finish_reason,omitempty"`
	// List of ratings for the safety of a response candidate.
	//
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,5,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
	// Output only. Citation information for model-generated candidate.
	//
	// This field may be populated with recitation information for any text
	// included in the `content`. These are passages that are "recited" from
	// copyrighted material in the foundational LLM's training data.
	CitationMetadata *CitationMetadata `protobuf:"bytes,6,opt,name=citation_metadata,json=citationMetadata,proto3" json:"citation_metadata,omitempty"`
	// Output only. Token count for this candidate.
	TokenCount int32 `protobuf:"varint,7,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// Output only. Attribution information for sources that contributed to a
	// grounded answer.
	//
	// This field is populated for `GenerateAnswer` calls.
	GroundingAttributions []*GroundingAttribution `protobuf:"bytes,8,rep,name=grounding_attributions,json=groundingAttributions,proto3" json:"grounding_attributions,omitempty"`
}

func (x *Candidate) Reset() {
	*x = Candidate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Candidate) ProtoMessage() {}

func (x *Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Candidate.ProtoReflect.Descriptor instead.
func (*Candidate) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{4}
}

func (x *Candidate) GetIndex() int32 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return 0
}

func (x *Candidate) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Candidate) GetFinishReason() Candidate_FinishReason {
	if x != nil {
		return x.FinishReason
	}
	return Candidate_FINISH_REASON_UNSPECIFIED
}

func (x *Candidate) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

func (x *Candidate) GetCitationMetadata() *CitationMetadata {
	if x != nil {
		return x.CitationMetadata
	}
	return nil
}

func (x *Candidate) GetTokenCount() int32 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

func (x *Candidate) GetGroundingAttributions() []*GroundingAttribution {
	if x != nil {
		return x.GroundingAttributions
	}
	return nil
}

// Identifier for the source contributing to this attribution.
type AttributionSourceId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*AttributionSourceId_GroundingPassage
	//	*AttributionSourceId_SemanticRetrieverChunk_
	Source isAttributionSourceId_Source `protobuf_oneof:"source"`
}

func (x *AttributionSourceId) Reset() {
	*x = AttributionSourceId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributionSourceId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSourceId) ProtoMessage() {}

func (x *AttributionSourceId) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSourceId.ProtoReflect.Descriptor instead.
func (*AttributionSourceId) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{5}
}

func (m *AttributionSourceId) GetSource() isAttributionSourceId_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *AttributionSourceId) GetGroundingPassage() *AttributionSourceId_GroundingPassageId {
	if x, ok := x.GetSource().(*AttributionSourceId_GroundingPassage); ok {
		return x.GroundingPassage
	}
	return nil
}

func (x *AttributionSourceId) GetSemanticRetrieverChunk() *AttributionSourceId_SemanticRetrieverChunk {
	if x, ok := x.GetSource().(*AttributionSourceId_SemanticRetrieverChunk_); ok {
		return x.SemanticRetrieverChunk
	}
	return nil
}

type isAttributionSourceId_Source interface {
	isAttributionSourceId_Source()
}

type AttributionSourceId_GroundingPassage struct {
	// Identifier for an inline passage.
	GroundingPassage *AttributionSourceId_GroundingPassageId `protobuf:"bytes,1,opt,name=grounding_passage,json=groundingPassage,proto3,oneof"`
}

type AttributionSourceId_SemanticRetrieverChunk_ struct {
	// Identifier for a `Chunk` fetched via Semantic Retriever.
	SemanticRetrieverChunk *AttributionSourceId_SemanticRetrieverChunk `protobuf:"bytes,2,opt,name=semantic_retriever_chunk,json=semanticRetrieverChunk,proto3,oneof"`
}

func (*AttributionSourceId_GroundingPassage) isAttributionSourceId_Source() {}

func (*AttributionSourceId_SemanticRetrieverChunk_) isAttributionSourceId_Source() {}

// Attribution for a source that contributed to an answer.
type GroundingAttribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier for the source contributing to this attribution.
	SourceId *AttributionSourceId `protobuf:"bytes,3,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Grounding source content that makes up this attribution.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *GroundingAttribution) Reset() {
	*x = GroundingAttribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroundingAttribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingAttribution) ProtoMessage() {}

func (x *GroundingAttribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingAttribution.ProtoReflect.Descriptor instead.
func (*GroundingAttribution) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{6}
}

func (x *GroundingAttribution) GetSourceId() *AttributionSourceId {
	if x != nil {
		return x.SourceId
	}
	return nil
}

func (x *GroundingAttribution) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

// Request to generate a grounded answer from the model.
type GenerateAnswerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sources in which to ground the answer.
	//
	// Types that are assignable to GroundingSource:
	//
	//	*GenerateAnswerRequest_InlinePassages
	//	*GenerateAnswerRequest_SemanticRetriever
	GroundingSource isGenerateAnswerRequest_GroundingSource `protobuf_oneof:"grounding_source"`
	// Required. The name of the `Model` to use for generating the grounded
	// response.
	//
	// Format: `model=models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content of the current conversation with the model. For
	// single-turn queries, this is a single question to answer. For multi-turn
	// queries, this is a repeated field that contains conversation history and
	// the last `Content` in the list containing the question.
	//
	// Note: GenerateAnswer currently only supports queries in English.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Required. Style in which answers should be returned.
	AnswerStyle GenerateAnswerRequest_AnswerStyle `protobuf:"varint,5,opt,name=answer_style,json=answerStyle,proto3,enum=google.ai.generativelanguage.v1beta.GenerateAnswerRequest_AnswerStyle" json:"answer_style,omitempty"`
	// Optional. A list of unique `SafetySetting` instances for blocking unsafe
	// content.
	//
	// This will be enforced on the `GenerateAnswerRequest.contents` and
	// `GenerateAnswerResponse.candidate`. There should not be more than one
	// setting for each `SafetyCategory` type. The API will block any contents and
	// responses that fail to meet the thresholds set by these settings. This list
	// overrides the default settings for each `SafetyCategory` specified in the
	// safety_settings. If there is no `SafetySetting` for a given
	// `SafetyCategory` provided in the list, the API will use the default safety
	// setting for that category.
	SafetySettings []*SafetySetting `protobuf:"bytes,3,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
	// Optional. Controls the randomness of the output.
	//
	// Values can range from [0.0,1.0], inclusive. A value closer to 1.0 will
	// produce responses that are more varied and creative, while a value closer
	// to 0.0 will typically result in more straightforward responses from the
	// model. A low temperature (~0.2) is usually recommended for
	// Attributed-Question-Answering use cases.
	Temperature *float32 `protobuf:"fixed32,4,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
}

func (x *GenerateAnswerRequest) Reset() {
	*x = GenerateAnswerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAnswerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAnswerRequest) ProtoMessage() {}

func (x *GenerateAnswerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAnswerRequest.ProtoReflect.Descriptor instead.
func (*GenerateAnswerRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{7}
}

func (m *GenerateAnswerRequest) GetGroundingSource() isGenerateAnswerRequest_GroundingSource {
	if m != nil {
		return m.GroundingSource
	}
	return nil
}

func (x *GenerateAnswerRequest) GetInlinePassages() *GroundingPassages {
	if x, ok := x.GetGroundingSource().(*GenerateAnswerRequest_InlinePassages); ok {
		return x.InlinePassages
	}
	return nil
}

func (x *GenerateAnswerRequest) GetSemanticRetriever() *SemanticRetrieverConfig {
	if x, ok := x.GetGroundingSource().(*GenerateAnswerRequest_SemanticRetriever); ok {
		return x.SemanticRetriever
	}
	return nil
}

func (x *GenerateAnswerRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *GenerateAnswerRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GenerateAnswerRequest) GetAnswerStyle() GenerateAnswerRequest_AnswerStyle {
	if x != nil {
		return x.AnswerStyle
	}
	return GenerateAnswerRequest_ANSWER_STYLE_UNSPECIFIED
}

func (x *GenerateAnswerRequest) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

func (x *GenerateAnswerRequest) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

type isGenerateAnswerRequest_GroundingSource interface {
	isGenerateAnswerRequest_GroundingSource()
}

type GenerateAnswerRequest_InlinePassages struct {
	// Passages provided inline with the request.
	InlinePassages *GroundingPassages `protobuf:"bytes,6,opt,name=inline_passages,json=inlinePassages,proto3,oneof"`
}

type GenerateAnswerRequest_SemanticRetriever struct {
	// Content retrieved from resources created via the Semantic Retriever
	// API.
	SemanticRetriever *SemanticRetrieverConfig `protobuf:"bytes,7,opt,name=semantic_retriever,json=semanticRetriever,proto3,oneof"`
}

func (*GenerateAnswerRequest_InlinePassages) isGenerateAnswerRequest_GroundingSource() {}

func (*GenerateAnswerRequest_SemanticRetriever) isGenerateAnswerRequest_GroundingSource() {}

// Response from the model for a grounded answer.
type GenerateAnswerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Candidate answer from the model.
	//
	// Note: The model *always* attempts to provide a grounded answer, even when
	// the answer is unlikely to be answerable from the given passages.
	// In that case, a low-quality or ungrounded answer may be provided, along
	// with a low `answerable_probability`.
	Answer *Candidate `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// Output only. The model's estimate of the probability that its answer is
	// correct and grounded in the input passages.
	//
	// A low answerable_probability indicates that the answer might not be
	// grounded in the sources.
	//
	// When `answerable_probability` is low, some clients may wish to:
	//
	// * Display a message to the effect of "We couldn’t answer that question" to
	// the user.
	// * Fall back to a general-purpose LLM that answers the question from world
	// knowledge. The threshold and nature of such fallbacks will depend on
	// individual clients’ use cases. 0.5 is a good starting threshold.
	AnswerableProbability *float32 `protobuf:"fixed32,2,opt,name=answerable_probability,json=answerableProbability,proto3,oneof" json:"answerable_probability,omitempty"`
	// Output only. Feedback related to the input data used to answer the
	// question, as opposed to model-generated response to the question.
	//
	// "Input data" can be one or more of the following:
	//
	// - Question specified by the last entry in `GenerateAnswerRequest.content`
	// - Conversation history specified by the other entries in
	// `GenerateAnswerRequest.content`
	// - Grounding sources (`GenerateAnswerRequest.semantic_retriever` or
	// `GenerateAnswerRequest.inline_passages`)
	InputFeedback *GenerateAnswerResponse_InputFeedback `protobuf:"bytes,3,opt,name=input_feedback,json=inputFeedback,proto3,oneof" json:"input_feedback,omitempty"`
}

func (x *GenerateAnswerResponse) Reset() {
	*x = GenerateAnswerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAnswerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAnswerResponse) ProtoMessage() {}

func (x *GenerateAnswerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAnswerResponse.ProtoReflect.Descriptor instead.
func (*GenerateAnswerResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{8}
}

func (x *GenerateAnswerResponse) GetAnswer() *Candidate {
	if x != nil {
		return x.Answer
	}
	return nil
}

func (x *GenerateAnswerResponse) GetAnswerableProbability() float32 {
	if x != nil && x.AnswerableProbability != nil {
		return *x.AnswerableProbability
	}
	return 0
}

func (x *GenerateAnswerResponse) GetInputFeedback() *GenerateAnswerResponse_InputFeedback {
	if x != nil {
		return x.InputFeedback
	}
	return nil
}

// Request containing the `Content` for the model to embed.
type EmbedContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// This name should match a model name returned by the `ListModels` method.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content to embed. Only the `parts.text` fields will be
	// counted.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. Optional task type for which the embeddings will be used. Can
	// only be set for `models/embedding-001`.
	TaskType *TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.ai.generativelanguage.v1beta.TaskType,oneof" json:"task_type,omitempty"`
	// Optional. An optional title for the text. Only applicable when TaskType is
	// `RETRIEVAL_DOCUMENT`.
	//
	// Note: Specifying a `title` for `RETRIEVAL_DOCUMENT` provides better quality
	// embeddings for retrieval.
	Title *string `protobuf:"bytes,4,opt,name=title,proto3,oneof" json:"title,omitempty"`
}

func (x *EmbedContentRequest) Reset() {
	*x = EmbedContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EmbedContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmbedContentRequest) ProtoMessage() {}

func (x *EmbedContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmbedContentRequest.ProtoReflect.Descriptor instead.
func (*EmbedContentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{9}
}

func (x *EmbedContentRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *EmbedContentRequest) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *EmbedContentRequest) GetTaskType() TaskType {
	if x != nil && x.TaskType != nil {
		return *x.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (x *EmbedContentRequest) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

// A list of floats representing an embedding.
type ContentEmbedding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The embedding values.
	Values []float32 `protobuf:"fixed32,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *ContentEmbedding) Reset() {
	*x = ContentEmbedding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentEmbedding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentEmbedding) ProtoMessage() {}

func (x *ContentEmbedding) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentEmbedding.ProtoReflect.Descriptor instead.
func (*ContentEmbedding) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{10}
}

func (x *ContentEmbedding) GetValues() []float32 {
	if x != nil {
		return x.Values
	}
	return nil
}

// The response to an `EmbedContentRequest`.
type EmbedContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The embedding generated from the input content.
	Embedding *ContentEmbedding `protobuf:"bytes,1,opt,name=embedding,proto3" json:"embedding,omitempty"`
}

func (x *EmbedContentResponse) Reset() {
	*x = EmbedContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EmbedContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmbedContentResponse) ProtoMessage() {}

func (x *EmbedContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmbedContentResponse.ProtoReflect.Descriptor instead.
func (*EmbedContentResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{11}
}

func (x *EmbedContentResponse) GetEmbedding() *ContentEmbedding {
	if x != nil {
		return x.Embedding
	}
	return nil
}

// Batch request to get embeddings from the model for a list of prompts.
type BatchEmbedContentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// This name should match a model name returned by the `ListModels` method.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. Embed requests for the batch. The model in each of these requests
	// must match the model specified `BatchEmbedContentsRequest.model`.
	Requests []*EmbedContentRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchEmbedContentsRequest) Reset() {
	*x = BatchEmbedContentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchEmbedContentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEmbedContentsRequest) ProtoMessage() {}

func (x *BatchEmbedContentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEmbedContentsRequest.ProtoReflect.Descriptor instead.
func (*BatchEmbedContentsRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{12}
}

func (x *BatchEmbedContentsRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *BatchEmbedContentsRequest) GetRequests() []*EmbedContentRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The response to a `BatchEmbedContentsRequest`.
type BatchEmbedContentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The embeddings for each request, in the same order as provided
	// in the batch request.
	Embeddings []*ContentEmbedding `protobuf:"bytes,1,rep,name=embeddings,proto3" json:"embeddings,omitempty"`
}

func (x *BatchEmbedContentsResponse) Reset() {
	*x = BatchEmbedContentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchEmbedContentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEmbedContentsResponse) ProtoMessage() {}

func (x *BatchEmbedContentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEmbedContentsResponse.ProtoReflect.Descriptor instead.
func (*BatchEmbedContentsResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{13}
}

func (x *BatchEmbedContentsResponse) GetEmbeddings() []*ContentEmbedding {
	if x != nil {
		return x.Embeddings
	}
	return nil
}

// Counts the number of tokens in the `prompt` sent to a model.
//
// Models may tokenize text differently, so each model may return a different
// `token_count`.
type CountTokensRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// This name should match a model name returned by the `ListModels` method.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The input given to the model as a prompt.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
}

func (x *CountTokensRequest) Reset() {
	*x = CountTokensRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CountTokensRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountTokensRequest) ProtoMessage() {}

func (x *CountTokensRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountTokensRequest.ProtoReflect.Descriptor instead.
func (*CountTokensRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{14}
}

func (x *CountTokensRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *CountTokensRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

// A response from `CountTokens`.
//
// It returns the model's `token_count` for the `prompt`.
type CountTokensResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of tokens that the `model` tokenizes the `prompt` into.
	//
	// Always non-negative.
	TotalTokens int32 `protobuf:"varint,1,opt,name=total_tokens,json=totalTokens,proto3" json:"total_tokens,omitempty"`
}

func (x *CountTokensResponse) Reset() {
	*x = CountTokensResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CountTokensResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountTokensResponse) ProtoMessage() {}

func (x *CountTokensResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountTokensResponse.ProtoReflect.Descriptor instead.
func (*CountTokensResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{15}
}

func (x *CountTokensResponse) GetTotalTokens() int32 {
	if x != nil {
		return x.TotalTokens
	}
	return 0
}

// A set of the feedback metadata the prompt specified in
// `GenerateContentRequest.content`.
type GenerateContentResponse_PromptFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, the prompt was blocked and no candidates are returned.
	// Rephrase your prompt.
	BlockReason GenerateContentResponse_PromptFeedback_BlockReason `protobuf:"varint,1,opt,name=block_reason,json=blockReason,proto3,enum=google.ai.generativelanguage.v1beta.GenerateContentResponse_PromptFeedback_BlockReason" json:"block_reason,omitempty"`
	// Ratings for safety of the prompt.
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,2,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
}

func (x *GenerateContentResponse_PromptFeedback) Reset() {
	*x = GenerateContentResponse_PromptFeedback{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateContentResponse_PromptFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse_PromptFeedback) ProtoMessage() {}

func (x *GenerateContentResponse_PromptFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse_PromptFeedback.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse_PromptFeedback) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *GenerateContentResponse_PromptFeedback) GetBlockReason() GenerateContentResponse_PromptFeedback_BlockReason {
	if x != nil {
		return x.BlockReason
	}
	return GenerateContentResponse_PromptFeedback_BLOCK_REASON_UNSPECIFIED
}

func (x *GenerateContentResponse_PromptFeedback) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

// Identifier for a part within a `GroundingPassage`.
type AttributionSourceId_GroundingPassageId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. ID of the passage matching the `GenerateAnswerRequest`'s
	// `GroundingPassage.id`.
	PassageId string `protobuf:"bytes,1,opt,name=passage_id,json=passageId,proto3" json:"passage_id,omitempty"`
	// Output only. Index of the part within the `GenerateAnswerRequest`'s
	// `GroundingPassage.content`.
	PartIndex int32 `protobuf:"varint,2,opt,name=part_index,json=partIndex,proto3" json:"part_index,omitempty"`
}

func (x *AttributionSourceId_GroundingPassageId) Reset() {
	*x = AttributionSourceId_GroundingPassageId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributionSourceId_GroundingPassageId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSourceId_GroundingPassageId) ProtoMessage() {}

func (x *AttributionSourceId_GroundingPassageId) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSourceId_GroundingPassageId.ProtoReflect.Descriptor instead.
func (*AttributionSourceId_GroundingPassageId) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AttributionSourceId_GroundingPassageId) GetPassageId() string {
	if x != nil {
		return x.PassageId
	}
	return ""
}

func (x *AttributionSourceId_GroundingPassageId) GetPartIndex() int32 {
	if x != nil {
		return x.PartIndex
	}
	return 0
}

// Identifier for a `Chunk` retrieved via Semantic Retriever specified in the
// `GenerateAnswerRequest` using `SemanticRetrieverConfig`.
type AttributionSourceId_SemanticRetrieverChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the source matching the request's
	// `SemanticRetrieverConfig.source`. Example: `corpora/123` or
	// `corpora/123/documents/abc`
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Output only. Name of the `Chunk` containing the attributed text.
	// Example: `corpora/123/documents/abc/chunks/xyz`
	Chunk string `protobuf:"bytes,2,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (x *AttributionSourceId_SemanticRetrieverChunk) Reset() {
	*x = AttributionSourceId_SemanticRetrieverChunk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributionSourceId_SemanticRetrieverChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSourceId_SemanticRetrieverChunk) ProtoMessage() {}

func (x *AttributionSourceId_SemanticRetrieverChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSourceId_SemanticRetrieverChunk.ProtoReflect.Descriptor instead.
func (*AttributionSourceId_SemanticRetrieverChunk) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{5, 1}
}

func (x *AttributionSourceId_SemanticRetrieverChunk) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *AttributionSourceId_SemanticRetrieverChunk) GetChunk() string {
	if x != nil {
		return x.Chunk
	}
	return ""
}

// Feedback related to the input data used to answer the question, as opposed
// to model-generated response to the question.
type GenerateAnswerResponse_InputFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, the input was blocked and no candidates are returned.
	// Rephrase your input.
	BlockReason *GenerateAnswerResponse_InputFeedback_BlockReason `protobuf:"varint,1,opt,name=block_reason,json=blockReason,proto3,enum=google.ai.generativelanguage.v1beta.GenerateAnswerResponse_InputFeedback_BlockReason,oneof" json:"block_reason,omitempty"`
	// Ratings for safety of the input.
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,2,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
}

func (x *GenerateAnswerResponse_InputFeedback) Reset() {
	*x = GenerateAnswerResponse_InputFeedback{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAnswerResponse_InputFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAnswerResponse_InputFeedback) ProtoMessage() {}

func (x *GenerateAnswerResponse_InputFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAnswerResponse_InputFeedback.ProtoReflect.Descriptor instead.
func (*GenerateAnswerResponse_InputFeedback) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{8, 0}
}

func (x *GenerateAnswerResponse_InputFeedback) GetBlockReason() GenerateAnswerResponse_InputFeedback_BlockReason {
	if x != nil && x.BlockReason != nil {
		return *x.BlockReason
	}
	return GenerateAnswerResponse_InputFeedback_BLOCK_REASON_UNSPECIFIED
}

func (x *GenerateAnswerResponse_InputFeedback) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

var File_google_ai_generativelanguage_v1beta_generative_service_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xda, 0x03, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4d, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x73,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6c, 0x0a,
	0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xdf, 0x02, 0x0a, 0x10, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x0f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x6f,
	0x70, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x70, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x74,
	0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x70,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x04, 0x74,
	0x6f, 0x70, 0x50, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x04, 0x74, 0x6f,
	0x70, 0x4b, 0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f,
	0x70, 0x5f, 0x6b, 0x22, 0x8b, 0x03, 0x0a, 0x17, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x47, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x10, 0x6d, 0x61,
	0x78, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x78,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x40,
	0x0a, 0x17, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x15, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x52,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x22, 0x91, 0x04, 0x0a, 0x17, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a,
	0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x74, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x1a, 0xaf, 0x02, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x7f, 0x0a, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x57, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x42, 0x0a, 0x0b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x1c, 0x0a, 0x18, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54,
	0x48, 0x45, 0x52, 0x10, 0x02, 0x22, 0xbc, 0x05, 0x0a, 0x09, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x68, 0x0a, 0x0d, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x67, 0x0a, 0x11, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x69, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a,
	0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x75, 0x0a, 0x16, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x6e, 0x0a, 0x0c, 0x46, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49,
	0x4e, 0x49, 0x53, 0x48, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f,
	0x50, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e,
	0x53, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x03, 0x12,
	0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x43, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12,
	0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x05, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x22, 0xd9, 0x03, 0x0a, 0x13, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x7a, 0x0a, 0x11,
	0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x64, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x48, 0x00, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x18, 0x73, 0x65, 0x6d,
	0x61, 0x6e, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x5f,
	0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x64, 0x2e, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x16,
	0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x72, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x1a, 0x5c, 0x0a, 0x12, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x1a, 0x50, 0x0a, 0x16, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x1b,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0xba, 0x01, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x09, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xfc, 0x05,
	0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x6d, 0x0a, 0x12, 0x73, 0x65,
	0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x6d,
	0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x4d, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x6e, 0x0a, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12,
	0x60, 0x0a, 0x0f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x2a, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0b, 0x74,
	0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x22, 0x59, 0x0a,
	0x0b, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x42,
	0x53, 0x54, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x45,
	0x58, 0x54, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x56,
	0x45, 0x52, 0x42, 0x4f, 0x53, 0x45, 0x10, 0x03, 0x42, 0x12, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x91, 0x05, 0x0a,
	0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12,
	0x3f, 0x0a, 0x16, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01,
	0x12, 0x7a, 0x0a, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0d, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x88, 0x01, 0x01, 0x1a, 0xc3, 0x02, 0x0a,
	0x0d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x82,
	0x01, 0x0a, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0d,
	0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x42, 0x0a,
	0x0b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18,
	0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x41,
	0x46, 0x45, 0x54, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10,
	0x02, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x11, 0x0a,
	0x0f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x22, 0xb7, 0x02, 0x0a, 0x13, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x4b, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x09,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x1e, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x2a, 0x0a, 0x10, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x16,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x02, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x70, 0x0a, 0x14, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58,
	0x0a, 0x09, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xbd, 0x01, 0x0a, 0x19, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x59, 0x0a,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x78, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0a, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0xaa, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x4d, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22,
	0x38, 0x0a, 0x13, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x2a, 0x8f, 0x01, 0x0a, 0x08, 0x54, 0x61,
	0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45,
	0x56, 0x41, 0x4c, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x17,
	0x0a, 0x13, 0x53, 0x45, 0x4d, 0x41, 0x4e, 0x54, 0x49, 0x43, 0x5f, 0x53, 0x49, 0x4d, 0x49, 0x4c,
	0x41, 0x52, 0x49, 0x54, 0x59, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4c, 0x41, 0x53, 0x53,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x32, 0xcd, 0x0a, 0x0a, 0x11,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xd2, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x44, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x3a, 0x01, 0x2a, 0x22, 0x28, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xeb, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x60, 0xda, 0x41, 0x2b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x79,
	0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x12, 0xe0, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x0e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x33, 0x3a, 0x01, 0x2a, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x30, 0x01, 0x12, 0xc5, 0x01, 0x0a, 0x0c, 0x45, 0x6d, 0x62, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45,
	0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda,
	0x41, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x3a, 0x01, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0xde, 0x01, 0x0a, 0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0xc2, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x3a, 0x01, 0x2a, 0x22,
	0x24, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x1a, 0x24, 0xca, 0x41, 0x21, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xa2, 0x01, 0x0a, 0x27,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x5d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData = file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc
)

func file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData
}

var file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_ai_generativelanguage_v1beta_generative_service_proto_goTypes = []interface{}{
	(TaskType)(0), // 0: google.ai.generativelanguage.v1beta.TaskType
	(GenerateContentResponse_PromptFeedback_BlockReason)(0), // 1: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.BlockReason
	(Candidate_FinishReason)(0),                             // 2: google.ai.generativelanguage.v1beta.Candidate.FinishReason
	(GenerateAnswerRequest_AnswerStyle)(0),                  // 3: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.AnswerStyle
	(GenerateAnswerResponse_InputFeedback_BlockReason)(0),   // 4: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.BlockReason
	(*GenerateContentRequest)(nil),                          // 5: google.ai.generativelanguage.v1beta.GenerateContentRequest
	(*GenerationConfig)(nil),                                // 6: google.ai.generativelanguage.v1beta.GenerationConfig
	(*SemanticRetrieverConfig)(nil),                         // 7: google.ai.generativelanguage.v1beta.SemanticRetrieverConfig
	(*GenerateContentResponse)(nil),                         // 8: google.ai.generativelanguage.v1beta.GenerateContentResponse
	(*Candidate)(nil),                                       // 9: google.ai.generativelanguage.v1beta.Candidate
	(*AttributionSourceId)(nil),                             // 10: google.ai.generativelanguage.v1beta.AttributionSourceId
	(*GroundingAttribution)(nil),                            // 11: google.ai.generativelanguage.v1beta.GroundingAttribution
	(*GenerateAnswerRequest)(nil),                           // 12: google.ai.generativelanguage.v1beta.GenerateAnswerRequest
	(*GenerateAnswerResponse)(nil),                          // 13: google.ai.generativelanguage.v1beta.GenerateAnswerResponse
	(*EmbedContentRequest)(nil),                             // 14: google.ai.generativelanguage.v1beta.EmbedContentRequest
	(*ContentEmbedding)(nil),                                // 15: google.ai.generativelanguage.v1beta.ContentEmbedding
	(*EmbedContentResponse)(nil),                            // 16: google.ai.generativelanguage.v1beta.EmbedContentResponse
	(*BatchEmbedContentsRequest)(nil),                       // 17: google.ai.generativelanguage.v1beta.BatchEmbedContentsRequest
	(*BatchEmbedContentsResponse)(nil),                      // 18: google.ai.generativelanguage.v1beta.BatchEmbedContentsResponse
	(*CountTokensRequest)(nil),                              // 19: google.ai.generativelanguage.v1beta.CountTokensRequest
	(*CountTokensResponse)(nil),                             // 20: google.ai.generativelanguage.v1beta.CountTokensResponse
	(*GenerateContentResponse_PromptFeedback)(nil),          // 21: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback
	(*AttributionSourceId_GroundingPassageId)(nil),          // 22: google.ai.generativelanguage.v1beta.AttributionSourceId.GroundingPassageId
	(*AttributionSourceId_SemanticRetrieverChunk)(nil),      // 23: google.ai.generativelanguage.v1beta.AttributionSourceId.SemanticRetrieverChunk
	(*GenerateAnswerResponse_InputFeedback)(nil),            // 24: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback
	(*Content)(nil),                                         // 25: google.ai.generativelanguage.v1beta.Content
	(*Tool)(nil),                                            // 26: google.ai.generativelanguage.v1beta.Tool
	(*SafetySetting)(nil),                                   // 27: google.ai.generativelanguage.v1beta.SafetySetting
	(*MetadataFilter)(nil),                                  // 28: google.ai.generativelanguage.v1beta.MetadataFilter
	(*SafetyRating)(nil),                                    // 29: google.ai.generativelanguage.v1beta.SafetyRating
	(*CitationMetadata)(nil),                                // 30: google.ai.generativelanguage.v1beta.CitationMetadata
	(*GroundingPassages)(nil),                               // 31: google.ai.generativelanguage.v1beta.GroundingPassages
}
var file_google_ai_generativelanguage_v1beta_generative_service_proto_depIdxs = []int32{
	25, // 0: google.ai.generativelanguage.v1beta.GenerateContentRequest.contents:type_name -> google.ai.generativelanguage.v1beta.Content
	26, // 1: google.ai.generativelanguage.v1beta.GenerateContentRequest.tools:type_name -> google.ai.generativelanguage.v1beta.Tool
	27, // 2: google.ai.generativelanguage.v1beta.GenerateContentRequest.safety_settings:type_name -> google.ai.generativelanguage.v1beta.SafetySetting
	6,  // 3: google.ai.generativelanguage.v1beta.GenerateContentRequest.generation_config:type_name -> google.ai.generativelanguage.v1beta.GenerationConfig
	25, // 4: google.ai.generativelanguage.v1beta.SemanticRetrieverConfig.query:type_name -> google.ai.generativelanguage.v1beta.Content
	28, // 5: google.ai.generativelanguage.v1beta.SemanticRetrieverConfig.metadata_filters:type_name -> google.ai.generativelanguage.v1beta.MetadataFilter
	9,  // 6: google.ai.generativelanguage.v1beta.GenerateContentResponse.candidates:type_name -> google.ai.generativelanguage.v1beta.Candidate
	21, // 7: google.ai.generativelanguage.v1beta.GenerateContentResponse.prompt_feedback:type_name -> google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback
	25, // 8: google.ai.generativelanguage.v1beta.Candidate.content:type_name -> google.ai.generativelanguage.v1beta.Content
	2,  // 9: google.ai.generativelanguage.v1beta.Candidate.finish_reason:type_name -> google.ai.generativelanguage.v1beta.Candidate.FinishReason
	29, // 10: google.ai.generativelanguage.v1beta.Candidate.safety_ratings:type_name -> google.ai.generativelanguage.v1beta.SafetyRating
	30, // 11: google.ai.generativelanguage.v1beta.Candidate.citation_metadata:type_name -> google.ai.generativelanguage.v1beta.CitationMetadata
	11, // 12: google.ai.generativelanguage.v1beta.Candidate.grounding_attributions:type_name -> google.ai.generativelanguage.v1beta.GroundingAttribution
	22, // 13: google.ai.generativelanguage.v1beta.AttributionSourceId.grounding_passage:type_name -> google.ai.generativelanguage.v1beta.AttributionSourceId.GroundingPassageId
	23, // 14: google.ai.generativelanguage.v1beta.AttributionSourceId.semantic_retriever_chunk:type_name -> google.ai.generativelanguage.v1beta.AttributionSourceId.SemanticRetrieverChunk
	10, // 15: google.ai.generativelanguage.v1beta.GroundingAttribution.source_id:type_name -> google.ai.generativelanguage.v1beta.AttributionSourceId
	25, // 16: google.ai.generativelanguage.v1beta.GroundingAttribution.content:type_name -> google.ai.generativelanguage.v1beta.Content
	31, // 17: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.inline_passages:type_name -> google.ai.generativelanguage.v1beta.GroundingPassages
	7,  // 18: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.semantic_retriever:type_name -> google.ai.generativelanguage.v1beta.SemanticRetrieverConfig
	25, // 19: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.contents:type_name -> google.ai.generativelanguage.v1beta.Content
	3,  // 20: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.answer_style:type_name -> google.ai.generativelanguage.v1beta.GenerateAnswerRequest.AnswerStyle
	27, // 21: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.safety_settings:type_name -> google.ai.generativelanguage.v1beta.SafetySetting
	9,  // 22: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.answer:type_name -> google.ai.generativelanguage.v1beta.Candidate
	24, // 23: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.input_feedback:type_name -> google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback
	25, // 24: google.ai.generativelanguage.v1beta.EmbedContentRequest.content:type_name -> google.ai.generativelanguage.v1beta.Content
	0,  // 25: google.ai.generativelanguage.v1beta.EmbedContentRequest.task_type:type_name -> google.ai.generativelanguage.v1beta.TaskType
	15, // 26: google.ai.generativelanguage.v1beta.EmbedContentResponse.embedding:type_name -> google.ai.generativelanguage.v1beta.ContentEmbedding
	14, // 27: google.ai.generativelanguage.v1beta.BatchEmbedContentsRequest.requests:type_name -> google.ai.generativelanguage.v1beta.EmbedContentRequest
	15, // 28: google.ai.generativelanguage.v1beta.BatchEmbedContentsResponse.embeddings:type_name -> google.ai.generativelanguage.v1beta.ContentEmbedding
	25, // 29: google.ai.generativelanguage.v1beta.CountTokensRequest.contents:type_name -> google.ai.generativelanguage.v1beta.Content
	1,  // 30: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.block_reason:type_name -> google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.BlockReason
	29, // 31: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.safety_ratings:type_name -> google.ai.generativelanguage.v1beta.SafetyRating
	4,  // 32: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.block_reason:type_name -> google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.BlockReason
	29, // 33: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.safety_ratings:type_name -> google.ai.generativelanguage.v1beta.SafetyRating
	5,  // 34: google.ai.generativelanguage.v1beta.GenerativeService.GenerateContent:input_type -> google.ai.generativelanguage.v1beta.GenerateContentRequest
	12, // 35: google.ai.generativelanguage.v1beta.GenerativeService.GenerateAnswer:input_type -> google.ai.generativelanguage.v1beta.GenerateAnswerRequest
	5,  // 36: google.ai.generativelanguage.v1beta.GenerativeService.StreamGenerateContent:input_type -> google.ai.generativelanguage.v1beta.GenerateContentRequest
	14, // 37: google.ai.generativelanguage.v1beta.GenerativeService.EmbedContent:input_type -> google.ai.generativelanguage.v1beta.EmbedContentRequest
	17, // 38: google.ai.generativelanguage.v1beta.GenerativeService.BatchEmbedContents:input_type -> google.ai.generativelanguage.v1beta.BatchEmbedContentsRequest
	19, // 39: google.ai.generativelanguage.v1beta.GenerativeService.CountTokens:input_type -> google.ai.generativelanguage.v1beta.CountTokensRequest
	8,  // 40: google.ai.generativelanguage.v1beta.GenerativeService.GenerateContent:output_type -> google.ai.generativelanguage.v1beta.GenerateContentResponse
	13, // 41: google.ai.generativelanguage.v1beta.GenerativeService.GenerateAnswer:output_type -> google.ai.generativelanguage.v1beta.GenerateAnswerResponse
	8,  // 42: google.ai.generativelanguage.v1beta.GenerativeService.StreamGenerateContent:output_type -> google.ai.generativelanguage.v1beta.GenerateContentResponse
	16, // 43: google.ai.generativelanguage.v1beta.GenerativeService.EmbedContent:output_type -> google.ai.generativelanguage.v1beta.EmbedContentResponse
	18, // 44: google.ai.generativelanguage.v1beta.GenerativeService.BatchEmbedContents:output_type -> google.ai.generativelanguage.v1beta.BatchEmbedContentsResponse
	20, // 45: google.ai.generativelanguage.v1beta.GenerativeService.CountTokens:output_type -> google.ai.generativelanguage.v1beta.CountTokensResponse
	40, // [40:46] is the sub-list for method output_type
	34, // [34:40] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1beta_generative_service_proto_init() }
func file_google_ai_generativelanguage_v1beta_generative_service_proto_init() {
	if File_google_ai_generativelanguage_v1beta_generative_service_proto != nil {
		return
	}
	file_google_ai_generativelanguage_v1beta_citation_proto_init()
	file_google_ai_generativelanguage_v1beta_content_proto_init()
	file_google_ai_generativelanguage_v1beta_retriever_proto_init()
	file_google_ai_generativelanguage_v1beta_safety_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateContentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SemanticRetrieverConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateContentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Candidate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributionSourceId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroundingAttribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAnswerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAnswerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EmbedContentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentEmbedding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EmbedContentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchEmbedContentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchEmbedContentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CountTokensRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CountTokensResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateContentResponse_PromptFeedback); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributionSourceId_GroundingPassageId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributionSourceId_SemanticRetrieverChunk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAnswerResponse_InputFeedback); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*AttributionSourceId_GroundingPassage)(nil),
		(*AttributionSourceId_SemanticRetrieverChunk_)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*GenerateAnswerRequest_InlinePassages)(nil),
		(*GenerateAnswerRequest_SemanticRetriever)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ai_generativelanguage_v1beta_generative_service_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1beta_generative_service_proto_depIdxs,
		EnumInfos:         file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes,
		MessageInfos:      file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1beta_generative_service_proto = out.File
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1beta_generative_service_proto_goTypes = nil
	file_google_ai_generativelanguage_v1beta_generative_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GenerativeServiceClient is the client API for GenerativeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GenerativeServiceClient interface {
	// Generates a response from the model given an input
	// `GenerateContentRequest`.
	GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error)
	// Generates a grounded answer from the model given an input
	// `GenerateAnswerRequest`.
	GenerateAnswer(ctx context.Context, in *GenerateAnswerRequest, opts ...grpc.CallOption) (*GenerateAnswerResponse, error)
	// Generates a streamed response from the model given an input
	// `GenerateContentRequest`.
	StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (GenerativeService_StreamGenerateContentClient, error)
	// Generates an embedding from the model given an input `Content`.
	EmbedContent(ctx context.Context, in *EmbedContentRequest, opts ...grpc.CallOption) (*EmbedContentResponse, error)
	// Generates multiple embeddings from the model given input text in a
	// synchronous call.
	BatchEmbedContents(ctx context.Context, in *BatchEmbedContentsRequest, opts ...grpc.CallOption) (*BatchEmbedContentsResponse, error)
	// Runs a model's tokenizer on input content and returns the token count.
	CountTokens(ctx context.Context, in *CountTokensRequest, opts ...grpc.CallOption) (*CountTokensResponse, error)
}

type generativeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGenerativeServiceClient(cc grpc.ClientConnInterface) GenerativeServiceClient {
	return &generativeServiceClient{cc}
}

func (c *generativeServiceClient) GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error) {
	out := new(GenerateContentResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.GenerativeService/GenerateContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) GenerateAnswer(ctx context.Context, in *GenerateAnswerRequest, opts ...grpc.CallOption) (*GenerateAnswerResponse, error) {
	out := new(GenerateAnswerResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.GenerativeService/GenerateAnswer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (GenerativeService_StreamGenerateContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_GenerativeService_serviceDesc.Streams[0], "/google.ai.generativelanguage.v1beta.GenerativeService/StreamGenerateContent", opts...)
	if err != nil {
		return nil, err
	}
	x := &generativeServiceStreamGenerateContentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type GenerativeService_StreamGenerateContentClient interface {
	Recv() (*GenerateContentResponse, error)
	grpc.ClientStream
}

type generativeServiceStreamGenerateContentClient struct {
	grpc.ClientStream
}

func (x *generativeServiceStreamGenerateContentClient) Recv() (*GenerateContentResponse, error) {
	m := new(GenerateContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *generativeServiceClient) EmbedContent(ctx context.Context, in *EmbedContentRequest, opts ...grpc.CallOption) (*EmbedContentResponse, error) {
	out := new(EmbedContentResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.GenerativeService/EmbedContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) BatchEmbedContents(ctx context.Context, in *BatchEmbedContentsRequest, opts ...grpc.CallOption) (*BatchEmbedContentsResponse, error) {
	out := new(BatchEmbedContentsResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.GenerativeService/BatchEmbedContents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) CountTokens(ctx context.Context, in *CountTokensRequest, opts ...grpc.CallOption) (*CountTokensResponse, error) {
	out := new(CountTokensResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.GenerativeService/CountTokens", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GenerativeServiceServer is the server API for GenerativeService service.
type GenerativeServiceServer interface {
	// Generates a response from the model given an input
	// `GenerateContentRequest`.
	GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error)
	// Generates a grounded answer from the model given an input
	// `GenerateAnswerRequest`.
	GenerateAnswer(context.Context, *GenerateAnswerRequest) (*GenerateAnswerResponse, error)
	// Generates a streamed response from the model given an input
	// `GenerateContentRequest`.
	StreamGenerateContent(*GenerateContentRequest, GenerativeService_StreamGenerateContentServer) error
	// Generates an embedding from the model given an input `Content`.
	EmbedContent(context.Context, *EmbedContentRequest) (*EmbedContentResponse, error)
	// Generates multiple embeddings from the model given input text in a
	// synchronous call.
	BatchEmbedContents(context.Context, *BatchEmbedContentsRequest) (*BatchEmbedContentsResponse, error)
	// Runs a model's tokenizer on input content and returns the token count.
	CountTokens(context.Context, *CountTokensRequest) (*CountTokensResponse, error)
}

// UnimplementedGenerativeServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGenerativeServiceServer struct {
}

func (*UnimplementedGenerativeServiceServer) GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateContent not implemented")
}
func (*UnimplementedGenerativeServiceServer) GenerateAnswer(context.Context, *GenerateAnswerRequest) (*GenerateAnswerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAnswer not implemented")
}
func (*UnimplementedGenerativeServiceServer) StreamGenerateContent(*GenerateContentRequest, GenerativeService_StreamGenerateContentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamGenerateContent not implemented")
}
func (*UnimplementedGenerativeServiceServer) EmbedContent(context.Context, *EmbedContentRequest) (*EmbedContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EmbedContent not implemented")
}
func (*UnimplementedGenerativeServiceServer) BatchEmbedContents(context.Context, *BatchEmbedContentsRequest) (*BatchEmbedContentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchEmbedContents not implemented")
}
func (*UnimplementedGenerativeServiceServer) CountTokens(context.Context, *CountTokensRequest) (*CountTokensResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountTokens not implemented")
}

func RegisterGenerativeServiceServer(s *grpc.Server, srv GenerativeServiceServer) {
	s.RegisterService(&_GenerativeService_serviceDesc, srv)
}

func _GenerativeService_GenerateContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).GenerateContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.GenerativeService/GenerateContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).GenerateContent(ctx, req.(*GenerateContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_GenerateAnswer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAnswerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).GenerateAnswer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.GenerativeService/GenerateAnswer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).GenerateAnswer(ctx, req.(*GenerateAnswerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_StreamGenerateContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(GenerativeServiceServer).StreamGenerateContent(m, &generativeServiceStreamGenerateContentServer{stream})
}

type GenerativeService_StreamGenerateContentServer interface {
	Send(*GenerateContentResponse) error
	grpc.ServerStream
}

type generativeServiceStreamGenerateContentServer struct {
	grpc.ServerStream
}

func (x *generativeServiceStreamGenerateContentServer) Send(m *GenerateContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _GenerativeService_EmbedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmbedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).EmbedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.GenerativeService/EmbedContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).EmbedContent(ctx, req.(*EmbedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_BatchEmbedContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchEmbedContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).BatchEmbedContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.GenerativeService/BatchEmbedContents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).BatchEmbedContents(ctx, req.(*BatchEmbedContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_CountTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).CountTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.GenerativeService/CountTokens",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).CountTokens(ctx, req.(*CountTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GenerativeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1beta.GenerativeService",
	HandlerType: (*GenerativeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateContent",
			Handler:    _GenerativeService_GenerateContent_Handler,
		},
		{
			MethodName: "GenerateAnswer",
			Handler:    _GenerativeService_GenerateAnswer_Handler,
		},
		{
			MethodName: "EmbedContent",
			Handler:    _GenerativeService_EmbedContent_Handler,
		},
		{
			MethodName: "BatchEmbedContents",
			Handler:    _GenerativeService_BatchEmbedContents_Handler,
		},
		{
			MethodName: "CountTokens",
			Handler:    _GenerativeService_CountTokens_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamGenerateContent",
			Handler:       _GenerativeService_StreamGenerateContent_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/ai/generativelanguage/v1beta/generative_service.proto",
}
