// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/vmmigration/v1/vmmigration.proto

package vmmigrationpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	errdetails "google.golang.org/genproto/googleapis/rpc/errdetails"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Controls the level of details of a Utilization Report.
type UtilizationReportView int32

const (
	// The default / unset value.
	// The API will default to FULL on single report request and BASIC for
	// multiple reports request.
	UtilizationReportView_UTILIZATION_REPORT_VIEW_UNSPECIFIED UtilizationReportView = 0
	// Get the report metadata, without the list of VMs and their utilization
	// info.
	UtilizationReportView_BASIC UtilizationReportView = 1
	// Include everything.
	UtilizationReportView_FULL UtilizationReportView = 2
)

// Enum value maps for UtilizationReportView.
var (
	UtilizationReportView_name = map[int32]string{
		0: "UTILIZATION_REPORT_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	UtilizationReportView_value = map[string]int32{
		"UTILIZATION_REPORT_VIEW_UNSPECIFIED": 0,
		"BASIC":                               1,
		"FULL":                                2,
	}
)

func (x UtilizationReportView) Enum() *UtilizationReportView {
	p := new(UtilizationReportView)
	*p = x
	return p
}

func (x UtilizationReportView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UtilizationReportView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[0].Descriptor()
}

func (UtilizationReportView) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[0]
}

func (x UtilizationReportView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UtilizationReportView.Descriptor instead.
func (UtilizationReportView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{0}
}

// Controls the level of details of a Migrating VM.
type MigratingVmView int32

const (
	// View is unspecified. The API will fallback to the default value.
	MigratingVmView_MIGRATING_VM_VIEW_UNSPECIFIED MigratingVmView = 0
	// Get the migrating VM basic details.
	// The basic details do not include the recent clone jobs and recent cutover
	// jobs lists.
	MigratingVmView_MIGRATING_VM_VIEW_BASIC MigratingVmView = 1
	// Include everything.
	MigratingVmView_MIGRATING_VM_VIEW_FULL MigratingVmView = 2
)

// Enum value maps for MigratingVmView.
var (
	MigratingVmView_name = map[int32]string{
		0: "MIGRATING_VM_VIEW_UNSPECIFIED",
		1: "MIGRATING_VM_VIEW_BASIC",
		2: "MIGRATING_VM_VIEW_FULL",
	}
	MigratingVmView_value = map[string]int32{
		"MIGRATING_VM_VIEW_UNSPECIFIED": 0,
		"MIGRATING_VM_VIEW_BASIC":       1,
		"MIGRATING_VM_VIEW_FULL":        2,
	}
)

func (x MigratingVmView) Enum() *MigratingVmView {
	p := new(MigratingVmView)
	*p = x
	return p
}

func (x MigratingVmView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigratingVmView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[1].Descriptor()
}

func (MigratingVmView) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[1]
}

func (x MigratingVmView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigratingVmView.Descriptor instead.
func (MigratingVmView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{1}
}

// Types of disks supported for Compute Engine VM.
type ComputeEngineDiskType int32

const (
	// An unspecified disk type. Will be used as STANDARD.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED ComputeEngineDiskType = 0
	// A Standard disk type.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_STANDARD ComputeEngineDiskType = 1
	// SSD hard disk type.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_SSD ComputeEngineDiskType = 2
	// An alternative to SSD persistent disks that balance performance and
	// cost.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_BALANCED ComputeEngineDiskType = 3
)

// Enum value maps for ComputeEngineDiskType.
var (
	ComputeEngineDiskType_name = map[int32]string{
		0: "COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED",
		1: "COMPUTE_ENGINE_DISK_TYPE_STANDARD",
		2: "COMPUTE_ENGINE_DISK_TYPE_SSD",
		3: "COMPUTE_ENGINE_DISK_TYPE_BALANCED",
	}
	ComputeEngineDiskType_value = map[string]int32{
		"COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED": 0,
		"COMPUTE_ENGINE_DISK_TYPE_STANDARD":    1,
		"COMPUTE_ENGINE_DISK_TYPE_SSD":         2,
		"COMPUTE_ENGINE_DISK_TYPE_BALANCED":    3,
	}
)

func (x ComputeEngineDiskType) Enum() *ComputeEngineDiskType {
	p := new(ComputeEngineDiskType)
	*p = x
	return p
}

func (x ComputeEngineDiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineDiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[2].Descriptor()
}

func (ComputeEngineDiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[2]
}

func (x ComputeEngineDiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineDiskType.Descriptor instead.
func (ComputeEngineDiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{2}
}

// Types of licenses used in OS adaptation.
type ComputeEngineLicenseType int32

const (
	// The license type is the default for the OS.
	ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT ComputeEngineLicenseType = 0
	// The license type is Pay As You Go license type.
	ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_PAYG ComputeEngineLicenseType = 1
	// The license type is Bring Your Own License type.
	ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_BYOL ComputeEngineLicenseType = 2
)

// Enum value maps for ComputeEngineLicenseType.
var (
	ComputeEngineLicenseType_name = map[int32]string{
		0: "COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT",
		1: "COMPUTE_ENGINE_LICENSE_TYPE_PAYG",
		2: "COMPUTE_ENGINE_LICENSE_TYPE_BYOL",
	}
	ComputeEngineLicenseType_value = map[string]int32{
		"COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT": 0,
		"COMPUTE_ENGINE_LICENSE_TYPE_PAYG":    1,
		"COMPUTE_ENGINE_LICENSE_TYPE_BYOL":    2,
	}
)

func (x ComputeEngineLicenseType) Enum() *ComputeEngineLicenseType {
	p := new(ComputeEngineLicenseType)
	*p = x
	return p
}

func (x ComputeEngineLicenseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineLicenseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[3].Descriptor()
}

func (ComputeEngineLicenseType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[3]
}

func (x ComputeEngineLicenseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineLicenseType.Descriptor instead.
func (ComputeEngineLicenseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{3}
}

// Possible values for vm boot option.
type ComputeEngineBootOption int32

const (
	// The boot option is unknown.
	ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED ComputeEngineBootOption = 0
	// The boot option is EFI.
	ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_EFI ComputeEngineBootOption = 1
	// The boot option is BIOS.
	ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_BIOS ComputeEngineBootOption = 2
)

// Enum value maps for ComputeEngineBootOption.
var (
	ComputeEngineBootOption_name = map[int32]string{
		0: "COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED",
		1: "COMPUTE_ENGINE_BOOT_OPTION_EFI",
		2: "COMPUTE_ENGINE_BOOT_OPTION_BIOS",
	}
	ComputeEngineBootOption_value = map[string]int32{
		"COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED": 0,
		"COMPUTE_ENGINE_BOOT_OPTION_EFI":         1,
		"COMPUTE_ENGINE_BOOT_OPTION_BIOS":        2,
	}
)

func (x ComputeEngineBootOption) Enum() *ComputeEngineBootOption {
	p := new(ComputeEngineBootOption)
	*p = x
	return p
}

func (x ComputeEngineBootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineBootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[4].Descriptor()
}

func (ComputeEngineBootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[4]
}

func (x ComputeEngineBootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineBootOption.Descriptor instead.
func (ComputeEngineBootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{4}
}

// Possible states of a replication cycle.
type ReplicationCycle_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	ReplicationCycle_STATE_UNSPECIFIED ReplicationCycle_State = 0
	// The replication cycle is running.
	ReplicationCycle_RUNNING ReplicationCycle_State = 1
	// The replication cycle is paused.
	ReplicationCycle_PAUSED ReplicationCycle_State = 2
	// The replication cycle finished with errors.
	ReplicationCycle_FAILED ReplicationCycle_State = 3
	// The replication cycle finished successfully.
	ReplicationCycle_SUCCEEDED ReplicationCycle_State = 4
)

// Enum value maps for ReplicationCycle_State.
var (
	ReplicationCycle_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "PAUSED",
		3: "FAILED",
		4: "SUCCEEDED",
	}
	ReplicationCycle_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"PAUSED":            2,
		"FAILED":            3,
		"SUCCEEDED":         4,
	}
)

func (x ReplicationCycle_State) Enum() *ReplicationCycle_State {
	p := new(ReplicationCycle_State)
	*p = x
	return p
}

func (x ReplicationCycle_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicationCycle_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[5].Descriptor()
}

func (ReplicationCycle_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[5]
}

func (x ReplicationCycle_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplicationCycle_State.Descriptor instead.
func (ReplicationCycle_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{0, 0}
}

// The possible values of the state/health of source VM.
type MigratingVm_State int32

const (
	// The state was not sampled by the health checks yet.
	MigratingVm_STATE_UNSPECIFIED MigratingVm_State = 0
	// The VM in the source is being verified.
	MigratingVm_PENDING MigratingVm_State = 1
	// The source VM was verified, and it's ready to start replication.
	MigratingVm_READY MigratingVm_State = 2
	// Migration is going through the first sync cycle.
	MigratingVm_FIRST_SYNC MigratingVm_State = 3
	// The replication is active, and it's running or scheduled to run.
	MigratingVm_ACTIVE MigratingVm_State = 4
	// The source VM is being turned off, and a final replication is currently
	// running.
	MigratingVm_CUTTING_OVER MigratingVm_State = 7
	// The source VM was stopped and replicated. The replication is currently
	// paused.
	MigratingVm_CUTOVER MigratingVm_State = 8
	// A cutover job is active and replication cycle is running the final sync.
	MigratingVm_FINAL_SYNC MigratingVm_State = 9
	// The replication was paused by the user and no cycles are scheduled to
	// run.
	MigratingVm_PAUSED MigratingVm_State = 10
	// The migrating VM is being finalized and migration resources are being
	// removed.
	MigratingVm_FINALIZING MigratingVm_State = 11
	// The replication process is done. The migrating VM is finalized and no
	// longer consumes billable resources.
	MigratingVm_FINALIZED MigratingVm_State = 12
	// The replication process encountered an unrecoverable error and was
	// aborted.
	MigratingVm_ERROR MigratingVm_State = 13
)

// Enum value maps for MigratingVm_State.
var (
	MigratingVm_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "PENDING",
		2:  "READY",
		3:  "FIRST_SYNC",
		4:  "ACTIVE",
		7:  "CUTTING_OVER",
		8:  "CUTOVER",
		9:  "FINAL_SYNC",
		10: "PAUSED",
		11: "FINALIZING",
		12: "FINALIZED",
		13: "ERROR",
	}
	MigratingVm_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"READY":             2,
		"FIRST_SYNC":        3,
		"ACTIVE":            4,
		"CUTTING_OVER":      7,
		"CUTOVER":           8,
		"FINAL_SYNC":        9,
		"PAUSED":            10,
		"FINALIZING":        11,
		"FINALIZED":         12,
		"ERROR":             13,
	}
)

func (x MigratingVm_State) Enum() *MigratingVm_State {
	p := new(MigratingVm_State)
	*p = x
	return p
}

func (x MigratingVm_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigratingVm_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[6].Descriptor()
}

func (MigratingVm_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[6]
}

func (x MigratingVm_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigratingVm_State.Descriptor instead.
func (MigratingVm_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{6, 0}
}

// Possible states of the clone job.
type CloneJob_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	CloneJob_STATE_UNSPECIFIED CloneJob_State = 0
	// The clone job has not yet started.
	CloneJob_PENDING CloneJob_State = 1
	// The clone job is active and running.
	CloneJob_ACTIVE CloneJob_State = 2
	// The clone job finished with errors.
	CloneJob_FAILED CloneJob_State = 3
	// The clone job finished successfully.
	CloneJob_SUCCEEDED CloneJob_State = 4
	// The clone job was cancelled.
	CloneJob_CANCELLED CloneJob_State = 5
	// The clone job is being cancelled.
	CloneJob_CANCELLING CloneJob_State = 6
	// OS adaptation is running as part of the clone job to generate license.
	CloneJob_ADAPTING_OS CloneJob_State = 7
)

// Enum value maps for CloneJob_State.
var (
	CloneJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
		3: "FAILED",
		4: "SUCCEEDED",
		5: "CANCELLED",
		6: "CANCELLING",
		7: "ADAPTING_OS",
	}
	CloneJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ACTIVE":            2,
		"FAILED":            3,
		"SUCCEEDED":         4,
		"CANCELLED":         5,
		"CANCELLING":        6,
		"ADAPTING_OS":       7,
	}
)

func (x CloneJob_State) Enum() *CloneJob_State {
	p := new(CloneJob_State)
	*p = x
	return p
}

func (x CloneJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloneJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[7].Descriptor()
}

func (CloneJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[7]
}

func (x CloneJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloneJob_State.Descriptor instead.
func (CloneJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{7, 0}
}

// Possible states of the cutover job.
type CutoverJob_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	CutoverJob_STATE_UNSPECIFIED CutoverJob_State = 0
	// The cutover job has not yet started.
	CutoverJob_PENDING CutoverJob_State = 1
	// The cutover job finished with errors.
	CutoverJob_FAILED CutoverJob_State = 2
	// The cutover job finished successfully.
	CutoverJob_SUCCEEDED CutoverJob_State = 3
	// The cutover job was cancelled.
	CutoverJob_CANCELLED CutoverJob_State = 4
	// The cutover job is being cancelled.
	CutoverJob_CANCELLING CutoverJob_State = 5
	// The cutover job is active and running.
	CutoverJob_ACTIVE CutoverJob_State = 6
	// OS adaptation is running as part of the cutover job to generate license.
	CutoverJob_ADAPTING_OS CutoverJob_State = 7
)

// Enum value maps for CutoverJob_State.
var (
	CutoverJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "FAILED",
		3: "SUCCEEDED",
		4: "CANCELLED",
		5: "CANCELLING",
		6: "ACTIVE",
		7: "ADAPTING_OS",
	}
	CutoverJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"FAILED":            2,
		"SUCCEEDED":         3,
		"CANCELLED":         4,
		"CANCELLING":        5,
		"ACTIVE":            6,
		"ADAPTING_OS":       7,
	}
)

func (x CutoverJob_State) Enum() *CutoverJob_State {
	p := new(CutoverJob_State)
	*p = x
	return p
}

func (x CutoverJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CutoverJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[8].Descriptor()
}

func (CutoverJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[8]
}

func (x CutoverJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CutoverJob_State.Descriptor instead.
func (CutoverJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{12, 0}
}

// The possible values of the state.
type AwsSourceDetails_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	AwsSourceDetails_STATE_UNSPECIFIED AwsSourceDetails_State = 0
	// The state was not sampled by the health checks yet.
	AwsSourceDetails_PENDING AwsSourceDetails_State = 1
	// The source is available but might not be usable yet due to invalid
	// credentials or another reason.
	// The error message will contain further details.
	AwsSourceDetails_FAILED AwsSourceDetails_State = 2
	// The source exists and its credentials were verified.
	AwsSourceDetails_ACTIVE AwsSourceDetails_State = 3
)

// Enum value maps for AwsSourceDetails_State.
var (
	AwsSourceDetails_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "FAILED",
		3: "ACTIVE",
	}
	AwsSourceDetails_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"FAILED":            2,
		"ACTIVE":            3,
	}
)

func (x AwsSourceDetails_State) Enum() *AwsSourceDetails_State {
	p := new(AwsSourceDetails_State)
	*p = x
	return p
}

func (x AwsSourceDetails_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsSourceDetails_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[9].Descriptor()
}

func (AwsSourceDetails_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[9]
}

func (x AwsSourceDetails_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsSourceDetails_State.Descriptor instead.
func (AwsSourceDetails_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{23, 0}
}

// The possible values of the state.
type DatacenterConnector_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	DatacenterConnector_STATE_UNSPECIFIED DatacenterConnector_State = 0
	// The state was not sampled by the health checks yet.
	DatacenterConnector_PENDING DatacenterConnector_State = 1
	// The source was sampled by health checks and is not available.
	DatacenterConnector_OFFLINE DatacenterConnector_State = 2
	// The source is available but might not be usable yet due to unvalidated
	// credentials or another reason. The credentials referred to are the ones
	// to the Source. The error message will contain further details.
	DatacenterConnector_FAILED DatacenterConnector_State = 3
	// The source exists and its credentials were verified.
	DatacenterConnector_ACTIVE DatacenterConnector_State = 4
)

// Enum value maps for DatacenterConnector_State.
var (
	DatacenterConnector_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "OFFLINE",
		3: "FAILED",
		4: "ACTIVE",
	}
	DatacenterConnector_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"OFFLINE":           2,
		"FAILED":            3,
		"ACTIVE":            4,
	}
)

func (x DatacenterConnector_State) Enum() *DatacenterConnector_State {
	p := new(DatacenterConnector_State)
	*p = x
	return p
}

func (x DatacenterConnector_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatacenterConnector_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[10].Descriptor()
}

func (DatacenterConnector_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[10]
}

func (x DatacenterConnector_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatacenterConnector_State.Descriptor instead.
func (DatacenterConnector_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{24, 0}
}

// The possible values of the state.
type UpgradeStatus_State int32

const (
	// The state was not sampled by the health checks yet.
	UpgradeStatus_STATE_UNSPECIFIED UpgradeStatus_State = 0
	// The upgrade has started.
	UpgradeStatus_RUNNING UpgradeStatus_State = 1
	// The upgrade failed.
	UpgradeStatus_FAILED UpgradeStatus_State = 2
	// The upgrade finished successfully.
	UpgradeStatus_SUCCEEDED UpgradeStatus_State = 3
)

// Enum value maps for UpgradeStatus_State.
var (
	UpgradeStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "FAILED",
		3: "SUCCEEDED",
	}
	UpgradeStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"FAILED":            2,
		"SUCCEEDED":         3,
	}
)

func (x UpgradeStatus_State) Enum() *UpgradeStatus_State {
	p := new(UpgradeStatus_State)
	*p = x
	return p
}

func (x UpgradeStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[11].Descriptor()
}

func (UpgradeStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[11]
}

func (x UpgradeStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeStatus_State.Descriptor instead.
func (UpgradeStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{25, 0}
}

// Possible values for the power state of the VM.
type VmwareVmDetails_PowerState int32

const (
	// Power state is not specified.
	VmwareVmDetails_POWER_STATE_UNSPECIFIED VmwareVmDetails_PowerState = 0
	// The VM is turned ON.
	VmwareVmDetails_ON VmwareVmDetails_PowerState = 1
	// The VM is turned OFF.
	VmwareVmDetails_OFF VmwareVmDetails_PowerState = 2
	// The VM is suspended. This is similar to hibernation or sleep mode.
	VmwareVmDetails_SUSPENDED VmwareVmDetails_PowerState = 3
)

// Enum value maps for VmwareVmDetails_PowerState.
var (
	VmwareVmDetails_PowerState_name = map[int32]string{
		0: "POWER_STATE_UNSPECIFIED",
		1: "ON",
		2: "OFF",
		3: "SUSPENDED",
	}
	VmwareVmDetails_PowerState_value = map[string]int32{
		"POWER_STATE_UNSPECIFIED": 0,
		"ON":                      1,
		"OFF":                     2,
		"SUSPENDED":               3,
	}
)

func (x VmwareVmDetails_PowerState) Enum() *VmwareVmDetails_PowerState {
	p := new(VmwareVmDetails_PowerState)
	*p = x
	return p
}

func (x VmwareVmDetails_PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareVmDetails_PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[12].Descriptor()
}

func (VmwareVmDetails_PowerState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[12]
}

func (x VmwareVmDetails_PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareVmDetails_PowerState.Descriptor instead.
func (VmwareVmDetails_PowerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{35, 0}
}

// Possible values for vm boot option.
type VmwareVmDetails_BootOption int32

const (
	// The boot option is unknown.
	VmwareVmDetails_BOOT_OPTION_UNSPECIFIED VmwareVmDetails_BootOption = 0
	// The boot option is EFI.
	VmwareVmDetails_EFI VmwareVmDetails_BootOption = 1
	// The boot option is BIOS.
	VmwareVmDetails_BIOS VmwareVmDetails_BootOption = 2
)

// Enum value maps for VmwareVmDetails_BootOption.
var (
	VmwareVmDetails_BootOption_name = map[int32]string{
		0: "BOOT_OPTION_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	VmwareVmDetails_BootOption_value = map[string]int32{
		"BOOT_OPTION_UNSPECIFIED": 0,
		"EFI":                     1,
		"BIOS":                    2,
	}
)

func (x VmwareVmDetails_BootOption) Enum() *VmwareVmDetails_BootOption {
	p := new(VmwareVmDetails_BootOption)
	*p = x
	return p
}

func (x VmwareVmDetails_BootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareVmDetails_BootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[13].Descriptor()
}

func (VmwareVmDetails_BootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[13]
}

func (x VmwareVmDetails_BootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareVmDetails_BootOption.Descriptor instead.
func (VmwareVmDetails_BootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{35, 1}
}

// Possible values for the power state of the VM.
type AwsVmDetails_PowerState int32

const (
	// Power state is not specified.
	AwsVmDetails_POWER_STATE_UNSPECIFIED AwsVmDetails_PowerState = 0
	// The VM is turned on.
	AwsVmDetails_ON AwsVmDetails_PowerState = 1
	// The VM is turned off.
	AwsVmDetails_OFF AwsVmDetails_PowerState = 2
	// The VM is suspended. This is similar to hibernation or sleep
	// mode.
	AwsVmDetails_SUSPENDED AwsVmDetails_PowerState = 3
	// The VM is starting.
	AwsVmDetails_PENDING AwsVmDetails_PowerState = 4
)

// Enum value maps for AwsVmDetails_PowerState.
var (
	AwsVmDetails_PowerState_name = map[int32]string{
		0: "POWER_STATE_UNSPECIFIED",
		1: "ON",
		2: "OFF",
		3: "SUSPENDED",
		4: "PENDING",
	}
	AwsVmDetails_PowerState_value = map[string]int32{
		"POWER_STATE_UNSPECIFIED": 0,
		"ON":                      1,
		"OFF":                     2,
		"SUSPENDED":               3,
		"PENDING":                 4,
	}
)

func (x AwsVmDetails_PowerState) Enum() *AwsVmDetails_PowerState {
	p := new(AwsVmDetails_PowerState)
	*p = x
	return p
}

func (x AwsVmDetails_PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[14].Descriptor()
}

func (AwsVmDetails_PowerState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[14]
}

func (x AwsVmDetails_PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_PowerState.Descriptor instead.
func (AwsVmDetails_PowerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{36, 0}
}

// The possible values for the vm boot option.
type AwsVmDetails_BootOption int32

const (
	// The boot option is unknown.
	AwsVmDetails_BOOT_OPTION_UNSPECIFIED AwsVmDetails_BootOption = 0
	// The boot option is UEFI.
	AwsVmDetails_EFI AwsVmDetails_BootOption = 1
	// The boot option is LEGACY-BIOS.
	AwsVmDetails_BIOS AwsVmDetails_BootOption = 2
)

// Enum value maps for AwsVmDetails_BootOption.
var (
	AwsVmDetails_BootOption_name = map[int32]string{
		0: "BOOT_OPTION_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	AwsVmDetails_BootOption_value = map[string]int32{
		"BOOT_OPTION_UNSPECIFIED": 0,
		"EFI":                     1,
		"BIOS":                    2,
	}
)

func (x AwsVmDetails_BootOption) Enum() *AwsVmDetails_BootOption {
	p := new(AwsVmDetails_BootOption)
	*p = x
	return p
}

func (x AwsVmDetails_BootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_BootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[15].Descriptor()
}

func (AwsVmDetails_BootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[15]
}

func (x AwsVmDetails_BootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_BootOption.Descriptor instead.
func (AwsVmDetails_BootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{36, 1}
}

// Possible values for the virtualization types of the VM.
type AwsVmDetails_VmVirtualizationType int32

const (
	// The virtualization type is unknown.
	AwsVmDetails_VM_VIRTUALIZATION_TYPE_UNSPECIFIED AwsVmDetails_VmVirtualizationType = 0
	// The virtualziation type is HVM.
	AwsVmDetails_HVM AwsVmDetails_VmVirtualizationType = 1
	// The virtualziation type is PARAVIRTUAL.
	AwsVmDetails_PARAVIRTUAL AwsVmDetails_VmVirtualizationType = 2
)

// Enum value maps for AwsVmDetails_VmVirtualizationType.
var (
	AwsVmDetails_VmVirtualizationType_name = map[int32]string{
		0: "VM_VIRTUALIZATION_TYPE_UNSPECIFIED",
		1: "HVM",
		2: "PARAVIRTUAL",
	}
	AwsVmDetails_VmVirtualizationType_value = map[string]int32{
		"VM_VIRTUALIZATION_TYPE_UNSPECIFIED": 0,
		"HVM":                                1,
		"PARAVIRTUAL":                        2,
	}
)

func (x AwsVmDetails_VmVirtualizationType) Enum() *AwsVmDetails_VmVirtualizationType {
	p := new(AwsVmDetails_VmVirtualizationType)
	*p = x
	return p
}

func (x AwsVmDetails_VmVirtualizationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_VmVirtualizationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[16].Descriptor()
}

func (AwsVmDetails_VmVirtualizationType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[16]
}

func (x AwsVmDetails_VmVirtualizationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_VmVirtualizationType.Descriptor instead.
func (AwsVmDetails_VmVirtualizationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{36, 2}
}

// Possible values for the architectures of the VM.
type AwsVmDetails_VmArchitecture int32

const (
	// The architecture is unknown.
	AwsVmDetails_VM_ARCHITECTURE_UNSPECIFIED AwsVmDetails_VmArchitecture = 0
	// The architecture is I386.
	AwsVmDetails_I386 AwsVmDetails_VmArchitecture = 1
	// The architecture is X86_64.
	AwsVmDetails_X86_64 AwsVmDetails_VmArchitecture = 2
	// The architecture is ARM64.
	AwsVmDetails_ARM64 AwsVmDetails_VmArchitecture = 3
	// The architecture is X86_64_MAC.
	AwsVmDetails_X86_64_MAC AwsVmDetails_VmArchitecture = 4
)

// Enum value maps for AwsVmDetails_VmArchitecture.
var (
	AwsVmDetails_VmArchitecture_name = map[int32]string{
		0: "VM_ARCHITECTURE_UNSPECIFIED",
		1: "I386",
		2: "X86_64",
		3: "ARM64",
		4: "X86_64_MAC",
	}
	AwsVmDetails_VmArchitecture_value = map[string]int32{
		"VM_ARCHITECTURE_UNSPECIFIED": 0,
		"I386":                        1,
		"X86_64":                      2,
		"ARM64":                       3,
		"X86_64_MAC":                  4,
	}
)

func (x AwsVmDetails_VmArchitecture) Enum() *AwsVmDetails_VmArchitecture {
	p := new(AwsVmDetails_VmArchitecture)
	*p = x
	return p
}

func (x AwsVmDetails_VmArchitecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_VmArchitecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[17].Descriptor()
}

func (AwsVmDetails_VmArchitecture) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[17]
}

func (x AwsVmDetails_VmArchitecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_VmArchitecture.Descriptor instead.
func (AwsVmDetails_VmArchitecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{36, 3}
}

// Utilization report state.
type UtilizationReport_State int32

const (
	// The state is unknown. This value is not in use.
	UtilizationReport_STATE_UNSPECIFIED UtilizationReport_State = 0
	// The report is in the making.
	UtilizationReport_CREATING UtilizationReport_State = 1
	// Report creation completed successfully.
	UtilizationReport_SUCCEEDED UtilizationReport_State = 2
	// Report creation failed.
	UtilizationReport_FAILED UtilizationReport_State = 3
)

// Enum value maps for UtilizationReport_State.
var (
	UtilizationReport_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	UtilizationReport_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x UtilizationReport_State) Enum() *UtilizationReport_State {
	p := new(UtilizationReport_State)
	*p = x
	return p
}

func (x UtilizationReport_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UtilizationReport_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[18].Descriptor()
}

func (UtilizationReport_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[18]
}

func (x UtilizationReport_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UtilizationReport_State.Descriptor instead.
func (UtilizationReport_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 0}
}

// Report time frame options.
type UtilizationReport_TimeFrame int32

const (
	// The time frame was not specified and will default to WEEK.
	UtilizationReport_TIME_FRAME_UNSPECIFIED UtilizationReport_TimeFrame = 0
	// One week.
	UtilizationReport_WEEK UtilizationReport_TimeFrame = 1
	// One month.
	UtilizationReport_MONTH UtilizationReport_TimeFrame = 2
	// One year.
	UtilizationReport_YEAR UtilizationReport_TimeFrame = 3
)

// Enum value maps for UtilizationReport_TimeFrame.
var (
	UtilizationReport_TimeFrame_name = map[int32]string{
		0: "TIME_FRAME_UNSPECIFIED",
		1: "WEEK",
		2: "MONTH",
		3: "YEAR",
	}
	UtilizationReport_TimeFrame_value = map[string]int32{
		"TIME_FRAME_UNSPECIFIED": 0,
		"WEEK":                   1,
		"MONTH":                  2,
		"YEAR":                   3,
	}
)

func (x UtilizationReport_TimeFrame) Enum() *UtilizationReport_TimeFrame {
	p := new(UtilizationReport_TimeFrame)
	*p = x
	return p
}

func (x UtilizationReport_TimeFrame) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UtilizationReport_TimeFrame) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[19].Descriptor()
}

func (UtilizationReport_TimeFrame) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[19]
}

func (x UtilizationReport_TimeFrame) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UtilizationReport_TimeFrame.Descriptor instead.
func (UtilizationReport_TimeFrame) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 1}
}

// License types used in OS adaptation.
type AppliedLicense_Type int32

const (
	// Unspecified license for the OS.
	AppliedLicense_TYPE_UNSPECIFIED AppliedLicense_Type = 0
	// No license available for the OS.
	AppliedLicense_NONE AppliedLicense_Type = 1
	// The license type is Pay As You Go license type.
	AppliedLicense_PAYG AppliedLicense_Type = 2
	// The license type is Bring Your Own License type.
	AppliedLicense_BYOL AppliedLicense_Type = 3
)

// Enum value maps for AppliedLicense_Type.
var (
	AppliedLicense_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NONE",
		2: "PAYG",
		3: "BYOL",
	}
	AppliedLicense_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"NONE":             1,
		"PAYG":             2,
		"BYOL":             3,
	}
)

func (x AppliedLicense_Type) Enum() *AppliedLicense_Type {
	p := new(AppliedLicense_Type)
	*p = x
	return p
}

func (x AppliedLicense_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppliedLicense_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[20].Descriptor()
}

func (AppliedLicense_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[20]
}

func (x AppliedLicense_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppliedLicense_Type.Descriptor instead.
func (AppliedLicense_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{59, 0}
}

// Possible types of node selection operators. Valid operators are IN for
// affinity and NOT_IN for anti-affinity.
type SchedulingNodeAffinity_Operator int32

const (
	// An unknown, unexpected behavior.
	SchedulingNodeAffinity_OPERATOR_UNSPECIFIED SchedulingNodeAffinity_Operator = 0
	// The node resource group should be in these resources affinity.
	SchedulingNodeAffinity_IN SchedulingNodeAffinity_Operator = 1
	// The node resource group should not be in these resources affinity.
	SchedulingNodeAffinity_NOT_IN SchedulingNodeAffinity_Operator = 2
)

// Enum value maps for SchedulingNodeAffinity_Operator.
var (
	SchedulingNodeAffinity_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "IN",
		2: "NOT_IN",
	}
	SchedulingNodeAffinity_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"IN":                   1,
		"NOT_IN":               2,
	}
)

func (x SchedulingNodeAffinity_Operator) Enum() *SchedulingNodeAffinity_Operator {
	p := new(SchedulingNodeAffinity_Operator)
	*p = x
	return p
}

func (x SchedulingNodeAffinity_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchedulingNodeAffinity_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[21].Descriptor()
}

func (SchedulingNodeAffinity_Operator) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[21]
}

func (x SchedulingNodeAffinity_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchedulingNodeAffinity_Operator.Descriptor instead.
func (SchedulingNodeAffinity_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{60, 0}
}

type ComputeScheduling_OnHostMaintenance int32

const (
	// An unknown, unexpected behavior.
	ComputeScheduling_ON_HOST_MAINTENANCE_UNSPECIFIED ComputeScheduling_OnHostMaintenance = 0
	// Terminate the instance when the host machine undergoes maintenance.
	ComputeScheduling_TERMINATE ComputeScheduling_OnHostMaintenance = 1
	// Migrate the instance when the host machine undergoes maintenance.
	ComputeScheduling_MIGRATE ComputeScheduling_OnHostMaintenance = 2
)

// Enum value maps for ComputeScheduling_OnHostMaintenance.
var (
	ComputeScheduling_OnHostMaintenance_name = map[int32]string{
		0: "ON_HOST_MAINTENANCE_UNSPECIFIED",
		1: "TERMINATE",
		2: "MIGRATE",
	}
	ComputeScheduling_OnHostMaintenance_value = map[string]int32{
		"ON_HOST_MAINTENANCE_UNSPECIFIED": 0,
		"TERMINATE":                       1,
		"MIGRATE":                         2,
	}
)

func (x ComputeScheduling_OnHostMaintenance) Enum() *ComputeScheduling_OnHostMaintenance {
	p := new(ComputeScheduling_OnHostMaintenance)
	*p = x
	return p
}

func (x ComputeScheduling_OnHostMaintenance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeScheduling_OnHostMaintenance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[22].Descriptor()
}

func (ComputeScheduling_OnHostMaintenance) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[22]
}

func (x ComputeScheduling_OnHostMaintenance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeScheduling_OnHostMaintenance.Descriptor instead.
func (ComputeScheduling_OnHostMaintenance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{61, 0}
}

// Defines whether the Instance should be automatically restarted whenever
// it is terminated by Compute Engine (not terminated by user).
type ComputeScheduling_RestartType int32

const (
	// Unspecified behavior. This will use the default.
	ComputeScheduling_RESTART_TYPE_UNSPECIFIED ComputeScheduling_RestartType = 0
	// The Instance should be automatically restarted whenever it is
	// terminated by Compute Engine.
	ComputeScheduling_AUTOMATIC_RESTART ComputeScheduling_RestartType = 1
	// The Instance isn't automatically restarted whenever it is
	// terminated by Compute Engine.
	ComputeScheduling_NO_AUTOMATIC_RESTART ComputeScheduling_RestartType = 2
)

// Enum value maps for ComputeScheduling_RestartType.
var (
	ComputeScheduling_RestartType_name = map[int32]string{
		0: "RESTART_TYPE_UNSPECIFIED",
		1: "AUTOMATIC_RESTART",
		2: "NO_AUTOMATIC_RESTART",
	}
	ComputeScheduling_RestartType_value = map[string]int32{
		"RESTART_TYPE_UNSPECIFIED": 0,
		"AUTOMATIC_RESTART":        1,
		"NO_AUTOMATIC_RESTART":     2,
	}
)

func (x ComputeScheduling_RestartType) Enum() *ComputeScheduling_RestartType {
	p := new(ComputeScheduling_RestartType)
	*p = x
	return p
}

func (x ComputeScheduling_RestartType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeScheduling_RestartType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[23].Descriptor()
}

func (ComputeScheduling_RestartType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[23]
}

func (x ComputeScheduling_RestartType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeScheduling_RestartType.Descriptor instead.
func (ComputeScheduling_RestartType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{61, 1}
}

// Represents resource error codes.
type MigrationError_ErrorCode int32

const (
	// Default value. This value is not used.
	MigrationError_ERROR_CODE_UNSPECIFIED MigrationError_ErrorCode = 0
	// Migrate for Compute encountered an unknown error.
	MigrationError_UNKNOWN_ERROR MigrationError_ErrorCode = 1
	// Migrate for Compute encountered an error while validating replication
	// source health.
	MigrationError_SOURCE_VALIDATION_ERROR MigrationError_ErrorCode = 2
	// Migrate for Compute encountered an error during source data operation.
	MigrationError_SOURCE_REPLICATION_ERROR MigrationError_ErrorCode = 3
	// Migrate for Compute encountered an error during target data operation.
	MigrationError_TARGET_REPLICATION_ERROR MigrationError_ErrorCode = 4
	// Migrate for Compute encountered an error during OS adaptation.
	MigrationError_OS_ADAPTATION_ERROR MigrationError_ErrorCode = 5
	// Migrate for Compute encountered an error in clone operation.
	MigrationError_CLONE_ERROR MigrationError_ErrorCode = 6
	// Migrate for Compute encountered an error in cutover operation.
	MigrationError_CUTOVER_ERROR MigrationError_ErrorCode = 7
	// Migrate for Compute encountered an error during utilization report
	// creation.
	MigrationError_UTILIZATION_REPORT_ERROR MigrationError_ErrorCode = 8
	// Migrate for Compute encountered an error during appliance upgrade.
	MigrationError_APPLIANCE_UPGRADE_ERROR MigrationError_ErrorCode = 9
)

// Enum value maps for MigrationError_ErrorCode.
var (
	MigrationError_ErrorCode_name = map[int32]string{
		0: "ERROR_CODE_UNSPECIFIED",
		1: "UNKNOWN_ERROR",
		2: "SOURCE_VALIDATION_ERROR",
		3: "SOURCE_REPLICATION_ERROR",
		4: "TARGET_REPLICATION_ERROR",
		5: "OS_ADAPTATION_ERROR",
		6: "CLONE_ERROR",
		7: "CUTOVER_ERROR",
		8: "UTILIZATION_REPORT_ERROR",
		9: "APPLIANCE_UPGRADE_ERROR",
	}
	MigrationError_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":   0,
		"UNKNOWN_ERROR":            1,
		"SOURCE_VALIDATION_ERROR":  2,
		"SOURCE_REPLICATION_ERROR": 3,
		"TARGET_REPLICATION_ERROR": 4,
		"OS_ADAPTATION_ERROR":      5,
		"CLONE_ERROR":              6,
		"CUTOVER_ERROR":            7,
		"UTILIZATION_REPORT_ERROR": 8,
		"APPLIANCE_UPGRADE_ERROR":  9,
	}
)

func (x MigrationError_ErrorCode) Enum() *MigrationError_ErrorCode {
	p := new(MigrationError_ErrorCode)
	*p = x
	return p
}

func (x MigrationError_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationError_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[24].Descriptor()
}

func (MigrationError_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[24]
}

func (x MigrationError_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationError_ErrorCode.Descriptor instead.
func (MigrationError_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{102, 0}
}

// Possible values for AWS VM firmware.
type AwsSourceVmDetails_Firmware int32

const (
	// The firmware is unknown.
	AwsSourceVmDetails_FIRMWARE_UNSPECIFIED AwsSourceVmDetails_Firmware = 0
	// The firmware is EFI.
	AwsSourceVmDetails_EFI AwsSourceVmDetails_Firmware = 1
	// The firmware is BIOS.
	AwsSourceVmDetails_BIOS AwsSourceVmDetails_Firmware = 2
)

// Enum value maps for AwsSourceVmDetails_Firmware.
var (
	AwsSourceVmDetails_Firmware_name = map[int32]string{
		0: "FIRMWARE_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	AwsSourceVmDetails_Firmware_value = map[string]int32{
		"FIRMWARE_UNSPECIFIED": 0,
		"EFI":                  1,
		"BIOS":                 2,
	}
)

func (x AwsSourceVmDetails_Firmware) Enum() *AwsSourceVmDetails_Firmware {
	p := new(AwsSourceVmDetails_Firmware)
	*p = x
	return p
}

func (x AwsSourceVmDetails_Firmware) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsSourceVmDetails_Firmware) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[25].Descriptor()
}

func (AwsSourceVmDetails_Firmware) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[25]
}

func (x AwsSourceVmDetails_Firmware) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsSourceVmDetails_Firmware.Descriptor instead.
func (AwsSourceVmDetails_Firmware) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{103, 0}
}

// ReplicationCycle contains information about the current replication cycle
// status.
type ReplicationCycle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the ReplicationCycle.
	Name string `protobuf:"bytes,13,opt,name=name,proto3" json:"name,omitempty"`
	// The cycle's ordinal number.
	CycleNumber int32 `protobuf:"varint,10,opt,name=cycle_number,json=cycleNumber,proto3" json:"cycle_number,omitempty"`
	// The time the replication cycle has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the replication cycle has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The accumulated duration the replication cycle was paused.
	TotalPauseDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=total_pause_duration,json=totalPauseDuration,proto3" json:"total_pause_duration,omitempty"`
	// The current progress in percentage of this cycle.
	// Was replaced by 'steps' field, which breaks down the cycle progression more
	// accurately.
	//
	// Deprecated: Marked as deprecated in google/cloud/vmmigration/v1/vmmigration.proto.
	ProgressPercent int32 `protobuf:"varint,5,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// The cycle's steps list representing its progress.
	Steps []*CycleStep `protobuf:"bytes,9,rep,name=steps,proto3" json:"steps,omitempty"`
	// State of the ReplicationCycle.
	State ReplicationCycle_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.ReplicationCycle_State" json:"state,omitempty"`
	// Provides details on the state of the cycle in case of an error.
	Error *status.Status `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ReplicationCycle) Reset() {
	*x = ReplicationCycle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationCycle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationCycle) ProtoMessage() {}

func (x *ReplicationCycle) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationCycle.ProtoReflect.Descriptor instead.
func (*ReplicationCycle) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{0}
}

func (x *ReplicationCycle) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReplicationCycle) GetCycleNumber() int32 {
	if x != nil {
		return x.CycleNumber
	}
	return 0
}

func (x *ReplicationCycle) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ReplicationCycle) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ReplicationCycle) GetTotalPauseDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalPauseDuration
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/vmmigration/v1/vmmigration.proto.
func (x *ReplicationCycle) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *ReplicationCycle) GetSteps() []*CycleStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *ReplicationCycle) GetState() ReplicationCycle_State {
	if x != nil {
		return x.State
	}
	return ReplicationCycle_STATE_UNSPECIFIED
}

func (x *ReplicationCycle) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// CycleStep holds information about a step progress.
type CycleStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//	*CycleStep_InitializingReplication
	//	*CycleStep_Replicating
	//	*CycleStep_PostProcessing
	Step isCycleStep_Step `protobuf_oneof:"step"`
	// The time the cycle step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the cycle step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CycleStep) Reset() {
	*x = CycleStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CycleStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CycleStep) ProtoMessage() {}

func (x *CycleStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CycleStep.ProtoReflect.Descriptor instead.
func (*CycleStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{1}
}

func (m *CycleStep) GetStep() isCycleStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *CycleStep) GetInitializingReplication() *InitializingReplicationStep {
	if x, ok := x.GetStep().(*CycleStep_InitializingReplication); ok {
		return x.InitializingReplication
	}
	return nil
}

func (x *CycleStep) GetReplicating() *ReplicatingStep {
	if x, ok := x.GetStep().(*CycleStep_Replicating); ok {
		return x.Replicating
	}
	return nil
}

func (x *CycleStep) GetPostProcessing() *PostProcessingStep {
	if x, ok := x.GetStep().(*CycleStep_PostProcessing); ok {
		return x.PostProcessing
	}
	return nil
}

func (x *CycleStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CycleStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isCycleStep_Step interface {
	isCycleStep_Step()
}

type CycleStep_InitializingReplication struct {
	// Initializing replication step.
	InitializingReplication *InitializingReplicationStep `protobuf:"bytes,3,opt,name=initializing_replication,json=initializingReplication,proto3,oneof"`
}

type CycleStep_Replicating struct {
	// Replicating step.
	Replicating *ReplicatingStep `protobuf:"bytes,4,opt,name=replicating,proto3,oneof"`
}

type CycleStep_PostProcessing struct {
	// Post processing step.
	PostProcessing *PostProcessingStep `protobuf:"bytes,5,opt,name=post_processing,json=postProcessing,proto3,oneof"`
}

func (*CycleStep_InitializingReplication) isCycleStep_Step() {}

func (*CycleStep_Replicating) isCycleStep_Step() {}

func (*CycleStep_PostProcessing) isCycleStep_Step() {}

// InitializingReplicationStep contains specific step details.
type InitializingReplicationStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InitializingReplicationStep) Reset() {
	*x = InitializingReplicationStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitializingReplicationStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializingReplicationStep) ProtoMessage() {}

func (x *InitializingReplicationStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializingReplicationStep.ProtoReflect.Descriptor instead.
func (*InitializingReplicationStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{2}
}

// ReplicatingStep contains specific step details.
type ReplicatingStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total bytes to be handled in the step.
	TotalBytes int64 `protobuf:"varint,1,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	// Replicated bytes in the step.
	ReplicatedBytes int64 `protobuf:"varint,2,opt,name=replicated_bytes,json=replicatedBytes,proto3" json:"replicated_bytes,omitempty"`
	// The source disks replication rate for the last 2 minutes in bytes per
	// second.
	LastTwoMinutesAverageBytesPerSecond int64 `protobuf:"varint,3,opt,name=last_two_minutes_average_bytes_per_second,json=lastTwoMinutesAverageBytesPerSecond,proto3" json:"last_two_minutes_average_bytes_per_second,omitempty"`
	// The source disks replication rate for the last 30 minutes in bytes per
	// second.
	LastThirtyMinutesAverageBytesPerSecond int64 `protobuf:"varint,4,opt,name=last_thirty_minutes_average_bytes_per_second,json=lastThirtyMinutesAverageBytesPerSecond,proto3" json:"last_thirty_minutes_average_bytes_per_second,omitempty"`
}

func (x *ReplicatingStep) Reset() {
	*x = ReplicatingStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicatingStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicatingStep) ProtoMessage() {}

func (x *ReplicatingStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicatingStep.ProtoReflect.Descriptor instead.
func (*ReplicatingStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{3}
}

func (x *ReplicatingStep) GetTotalBytes() int64 {
	if x != nil {
		return x.TotalBytes
	}
	return 0
}

func (x *ReplicatingStep) GetReplicatedBytes() int64 {
	if x != nil {
		return x.ReplicatedBytes
	}
	return 0
}

func (x *ReplicatingStep) GetLastTwoMinutesAverageBytesPerSecond() int64 {
	if x != nil {
		return x.LastTwoMinutesAverageBytesPerSecond
	}
	return 0
}

func (x *ReplicatingStep) GetLastThirtyMinutesAverageBytesPerSecond() int64 {
	if x != nil {
		return x.LastThirtyMinutesAverageBytesPerSecond
	}
	return 0
}

// PostProcessingStep contains specific step details.
type PostProcessingStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostProcessingStep) Reset() {
	*x = PostProcessingStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostProcessingStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostProcessingStep) ProtoMessage() {}

func (x *PostProcessingStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostProcessingStep.ProtoReflect.Descriptor instead.
func (*PostProcessingStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{4}
}

// ReplicationSync contain information about the last replica sync to the cloud.
type ReplicationSync struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The most updated snapshot created time in the source that finished
	// replication.
	LastSyncTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=last_sync_time,json=lastSyncTime,proto3" json:"last_sync_time,omitempty"`
}

func (x *ReplicationSync) Reset() {
	*x = ReplicationSync{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationSync) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationSync) ProtoMessage() {}

func (x *ReplicationSync) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationSync.ProtoReflect.Descriptor instead.
func (*ReplicationSync) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{5}
}

func (x *ReplicationSync) GetLastSyncTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSyncTime
	}
	return nil
}

// MigratingVm describes the VM that will be migrated from a Source environment
// and its replication state.
type MigratingVm struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The default configuration of the target VM that will be created in Google
	// Cloud as a result of the migration.
	//
	// Types that are assignable to TargetVmDefaults:
	//	*MigratingVm_ComputeEngineTargetDefaults
	TargetVmDefaults isMigratingVm_TargetVmDefaults `protobuf_oneof:"target_vm_defaults"`
	// Details about the source VM.
	//
	// Types that are assignable to SourceVmDetails:
	//	*MigratingVm_AwsSourceVmDetails
	SourceVmDetails isMigratingVm_SourceVmDetails `protobuf_oneof:"source_vm_details"`
	// Output only. The identifier of the MigratingVm.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique ID of the VM in the source.
	// The VM's name in vSphere can be changed, so this is not the VM's name but
	// rather its moRef id. This id is of the form vm-<num>.
	SourceVmId string `protobuf:"bytes,2,opt,name=source_vm_id,json=sourceVmId,proto3" json:"source_vm_id,omitempty"`
	// The display name attached to the MigratingVm by the user.
	DisplayName string `protobuf:"bytes,18,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description attached to the migrating VM by the user.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The replication schedule policy.
	Policy *SchedulePolicy `protobuf:"bytes,8,opt,name=policy,proto3" json:"policy,omitempty"`
	// Output only. The time the migrating VM was created (this refers to this
	// resource and not to the time it was installed in the source).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the migrating VM resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The most updated snapshot created time in the source that
	// finished replication.
	LastSync *ReplicationSync `protobuf:"bytes,11,opt,name=last_sync,json=lastSync,proto3" json:"last_sync,omitempty"`
	// Output only. State of the MigratingVm.
	State MigratingVm_State `protobuf:"varint,23,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.MigratingVm_State" json:"state,omitempty"`
	// Output only. The last time the migrating VM state was updated.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. The percentage progress of the current running replication
	// cycle.
	CurrentSyncInfo *ReplicationCycle `protobuf:"bytes,13,opt,name=current_sync_info,json=currentSyncInfo,proto3" json:"current_sync_info,omitempty"`
	// Output only. The group this migrating vm is included in, if any. The group
	// is represented by the full path of the appropriate
	// [Group][google.cloud.vmmigration.v1.Group] resource.
	Group string `protobuf:"bytes,15,opt,name=group,proto3" json:"group,omitempty"`
	// The labels of the migrating VM.
	Labels map[string]string `protobuf:"bytes,16,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The recent [clone jobs][google.cloud.vmmigration.v1.CloneJob]
	// performed on the migrating VM. This field holds the vm's last completed
	// clone job and the vm's running clone job, if one exists.
	// Note: To have this field populated you need to explicitly request it via
	// the "view" parameter of the Get/List request.
	RecentCloneJobs []*CloneJob `protobuf:"bytes,17,rep,name=recent_clone_jobs,json=recentCloneJobs,proto3" json:"recent_clone_jobs,omitempty"`
	// Output only. Provides details on the state of the Migrating VM in case of
	// an error in replication.
	Error *status.Status `protobuf:"bytes,19,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The recent cutover jobs performed on the migrating VM.
	// This field holds the vm's last completed cutover job and the vm's
	// running cutover job, if one exists.
	// Note: To have this field populated you need to explicitly request it via
	// the "view" parameter of the Get/List request.
	RecentCutoverJobs []*CutoverJob `protobuf:"bytes,20,rep,name=recent_cutover_jobs,json=recentCutoverJobs,proto3" json:"recent_cutover_jobs,omitempty"`
}

func (x *MigratingVm) Reset() {
	*x = MigratingVm{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigratingVm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigratingVm) ProtoMessage() {}

func (x *MigratingVm) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigratingVm.ProtoReflect.Descriptor instead.
func (*MigratingVm) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{6}
}

func (m *MigratingVm) GetTargetVmDefaults() isMigratingVm_TargetVmDefaults {
	if m != nil {
		return m.TargetVmDefaults
	}
	return nil
}

func (x *MigratingVm) GetComputeEngineTargetDefaults() *ComputeEngineTargetDefaults {
	if x, ok := x.GetTargetVmDefaults().(*MigratingVm_ComputeEngineTargetDefaults); ok {
		return x.ComputeEngineTargetDefaults
	}
	return nil
}

func (m *MigratingVm) GetSourceVmDetails() isMigratingVm_SourceVmDetails {
	if m != nil {
		return m.SourceVmDetails
	}
	return nil
}

func (x *MigratingVm) GetAwsSourceVmDetails() *AwsSourceVmDetails {
	if x, ok := x.GetSourceVmDetails().(*MigratingVm_AwsSourceVmDetails); ok {
		return x.AwsSourceVmDetails
	}
	return nil
}

func (x *MigratingVm) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MigratingVm) GetSourceVmId() string {
	if x != nil {
		return x.SourceVmId
	}
	return ""
}

func (x *MigratingVm) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MigratingVm) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MigratingVm) GetPolicy() *SchedulePolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *MigratingVm) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MigratingVm) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *MigratingVm) GetLastSync() *ReplicationSync {
	if x != nil {
		return x.LastSync
	}
	return nil
}

func (x *MigratingVm) GetState() MigratingVm_State {
	if x != nil {
		return x.State
	}
	return MigratingVm_STATE_UNSPECIFIED
}

func (x *MigratingVm) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *MigratingVm) GetCurrentSyncInfo() *ReplicationCycle {
	if x != nil {
		return x.CurrentSyncInfo
	}
	return nil
}

func (x *MigratingVm) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *MigratingVm) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MigratingVm) GetRecentCloneJobs() []*CloneJob {
	if x != nil {
		return x.RecentCloneJobs
	}
	return nil
}

func (x *MigratingVm) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *MigratingVm) GetRecentCutoverJobs() []*CutoverJob {
	if x != nil {
		return x.RecentCutoverJobs
	}
	return nil
}

type isMigratingVm_TargetVmDefaults interface {
	isMigratingVm_TargetVmDefaults()
}

type MigratingVm_ComputeEngineTargetDefaults struct {
	// Details of the target VM in Compute Engine.
	ComputeEngineTargetDefaults *ComputeEngineTargetDefaults `protobuf:"bytes,26,opt,name=compute_engine_target_defaults,json=computeEngineTargetDefaults,proto3,oneof"`
}

func (*MigratingVm_ComputeEngineTargetDefaults) isMigratingVm_TargetVmDefaults() {}

type isMigratingVm_SourceVmDetails interface {
	isMigratingVm_SourceVmDetails()
}

type MigratingVm_AwsSourceVmDetails struct {
	// Output only. Details of the VM from an AWS source.
	AwsSourceVmDetails *AwsSourceVmDetails `protobuf:"bytes,29,opt,name=aws_source_vm_details,json=awsSourceVmDetails,proto3,oneof"`
}

func (*MigratingVm_AwsSourceVmDetails) isMigratingVm_SourceVmDetails() {}

// CloneJob describes the process of creating a clone of a
// [MigratingVM][google.cloud.vmmigration.v1.MigratingVm] to the
// requested target based on the latest successful uploaded snapshots.
// While the migration cycles of a MigratingVm take place, it is possible to
// verify the uploaded VM can be started in the cloud, by creating a clone. The
// clone can be created without any downtime, and it is created using the latest
// snapshots which are already in the cloud. The cloneJob is only responsible
// for its work, not its products, which means once it is finished, it will
// never touch the instance it created. It will only delete it in case of the
// CloneJob being cancelled or upon failure to clone.
type CloneJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the VM to create as the target of this clone job.
	//
	// Types that are assignable to TargetVmDetails:
	//	*CloneJob_ComputeEngineTargetDetails
	TargetVmDetails isCloneJob_TargetVmDetails `protobuf_oneof:"target_vm_details"`
	// Output only. The time the clone job was created (as an API call, not when
	// it was actually created in the target).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the clone job was ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The name of the clone.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the clone job.
	State CloneJob_State `protobuf:"varint,12,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.CloneJob_State" json:"state,omitempty"`
	// Output only. The time the state was last updated.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Provides details for the errors that led to the Clone Job's
	// state.
	Error *status.Status `protobuf:"bytes,17,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The clone steps list representing its progress.
	Steps []*CloneStep `protobuf:"bytes,23,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *CloneJob) Reset() {
	*x = CloneJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloneJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneJob) ProtoMessage() {}

func (x *CloneJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneJob.ProtoReflect.Descriptor instead.
func (*CloneJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{7}
}

func (m *CloneJob) GetTargetVmDetails() isCloneJob_TargetVmDetails {
	if m != nil {
		return m.TargetVmDetails
	}
	return nil
}

func (x *CloneJob) GetComputeEngineTargetDetails() *ComputeEngineTargetDetails {
	if x, ok := x.GetTargetVmDetails().(*CloneJob_ComputeEngineTargetDetails); ok {
		return x.ComputeEngineTargetDetails
	}
	return nil
}

func (x *CloneJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CloneJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CloneJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CloneJob) GetState() CloneJob_State {
	if x != nil {
		return x.State
	}
	return CloneJob_STATE_UNSPECIFIED
}

func (x *CloneJob) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *CloneJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *CloneJob) GetSteps() []*CloneStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isCloneJob_TargetVmDetails interface {
	isCloneJob_TargetVmDetails()
}

type CloneJob_ComputeEngineTargetDetails struct {
	// Output only. Details of the target VM in Compute Engine.
	ComputeEngineTargetDetails *ComputeEngineTargetDetails `protobuf:"bytes,20,opt,name=compute_engine_target_details,json=computeEngineTargetDetails,proto3,oneof"`
}

func (*CloneJob_ComputeEngineTargetDetails) isCloneJob_TargetVmDetails() {}

// CloneStep holds information about the clone step progress.
type CloneStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//	*CloneStep_AdaptingOs
	//	*CloneStep_PreparingVmDisks
	//	*CloneStep_InstantiatingMigratedVm
	Step isCloneStep_Step `protobuf_oneof:"step"`
	// The time the step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CloneStep) Reset() {
	*x = CloneStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloneStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneStep) ProtoMessage() {}

func (x *CloneStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneStep.ProtoReflect.Descriptor instead.
func (*CloneStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{8}
}

func (m *CloneStep) GetStep() isCloneStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *CloneStep) GetAdaptingOs() *AdaptingOSStep {
	if x, ok := x.GetStep().(*CloneStep_AdaptingOs); ok {
		return x.AdaptingOs
	}
	return nil
}

func (x *CloneStep) GetPreparingVmDisks() *PreparingVMDisksStep {
	if x, ok := x.GetStep().(*CloneStep_PreparingVmDisks); ok {
		return x.PreparingVmDisks
	}
	return nil
}

func (x *CloneStep) GetInstantiatingMigratedVm() *InstantiatingMigratedVMStep {
	if x, ok := x.GetStep().(*CloneStep_InstantiatingMigratedVm); ok {
		return x.InstantiatingMigratedVm
	}
	return nil
}

func (x *CloneStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CloneStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isCloneStep_Step interface {
	isCloneStep_Step()
}

type CloneStep_AdaptingOs struct {
	// Adapting OS step.
	AdaptingOs *AdaptingOSStep `protobuf:"bytes,3,opt,name=adapting_os,json=adaptingOs,proto3,oneof"`
}

type CloneStep_PreparingVmDisks struct {
	// Preparing VM disks step.
	PreparingVmDisks *PreparingVMDisksStep `protobuf:"bytes,4,opt,name=preparing_vm_disks,json=preparingVmDisks,proto3,oneof"`
}

type CloneStep_InstantiatingMigratedVm struct {
	// Instantiating migrated VM step.
	InstantiatingMigratedVm *InstantiatingMigratedVMStep `protobuf:"bytes,5,opt,name=instantiating_migrated_vm,json=instantiatingMigratedVm,proto3,oneof"`
}

func (*CloneStep_AdaptingOs) isCloneStep_Step() {}

func (*CloneStep_PreparingVmDisks) isCloneStep_Step() {}

func (*CloneStep_InstantiatingMigratedVm) isCloneStep_Step() {}

// AdaptingOSStep contains specific step details.
type AdaptingOSStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AdaptingOSStep) Reset() {
	*x = AdaptingOSStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptingOSStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptingOSStep) ProtoMessage() {}

func (x *AdaptingOSStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptingOSStep.ProtoReflect.Descriptor instead.
func (*AdaptingOSStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{9}
}

// PreparingVMDisksStep contains specific step details.
type PreparingVMDisksStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PreparingVMDisksStep) Reset() {
	*x = PreparingVMDisksStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreparingVMDisksStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreparingVMDisksStep) ProtoMessage() {}

func (x *PreparingVMDisksStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreparingVMDisksStep.ProtoReflect.Descriptor instead.
func (*PreparingVMDisksStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{10}
}

// InstantiatingMigratedVMStep contains specific step details.
type InstantiatingMigratedVMStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InstantiatingMigratedVMStep) Reset() {
	*x = InstantiatingMigratedVMStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstantiatingMigratedVMStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstantiatingMigratedVMStep) ProtoMessage() {}

func (x *InstantiatingMigratedVMStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstantiatingMigratedVMStep.ProtoReflect.Descriptor instead.
func (*InstantiatingMigratedVMStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{11}
}

// CutoverJob message describes a cutover of a migrating VM. The CutoverJob is
// the operation of shutting down the VM, creating a snapshot and
// clonning the VM using the replicated snapshot.
type CutoverJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the VM to create as the target of this cutover job.
	//
	// Types that are assignable to TargetVmDetails:
	//	*CutoverJob_ComputeEngineTargetDetails
	TargetVmDetails isCutoverJob_TargetVmDetails `protobuf_oneof:"target_vm_details"`
	// Output only. The time the cutover job was created (as an API call, not when
	// it was actually created in the target).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the cutover job had finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The name of the cutover job.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the cutover job.
	State CutoverJob_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.CutoverJob_State" json:"state,omitempty"`
	// Output only. The time the state was last updated.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. The current progress in percentage of the cutover job.
	ProgressPercent int32 `protobuf:"varint,13,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Provides details for the errors that led to the Cutover Job's
	// state.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. A message providing possible extra details about the current
	// state.
	StateMessage string `protobuf:"bytes,10,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. The cutover steps list representing its progress.
	Steps []*CutoverStep `protobuf:"bytes,17,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *CutoverJob) Reset() {
	*x = CutoverJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CutoverJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CutoverJob) ProtoMessage() {}

func (x *CutoverJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CutoverJob.ProtoReflect.Descriptor instead.
func (*CutoverJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{12}
}

func (m *CutoverJob) GetTargetVmDetails() isCutoverJob_TargetVmDetails {
	if m != nil {
		return m.TargetVmDetails
	}
	return nil
}

func (x *CutoverJob) GetComputeEngineTargetDetails() *ComputeEngineTargetDetails {
	if x, ok := x.GetTargetVmDetails().(*CutoverJob_ComputeEngineTargetDetails); ok {
		return x.ComputeEngineTargetDetails
	}
	return nil
}

func (x *CutoverJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CutoverJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CutoverJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CutoverJob) GetState() CutoverJob_State {
	if x != nil {
		return x.State
	}
	return CutoverJob_STATE_UNSPECIFIED
}

func (x *CutoverJob) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *CutoverJob) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *CutoverJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *CutoverJob) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *CutoverJob) GetSteps() []*CutoverStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isCutoverJob_TargetVmDetails interface {
	isCutoverJob_TargetVmDetails()
}

type CutoverJob_ComputeEngineTargetDetails struct {
	// Output only. Details of the target VM in Compute Engine.
	ComputeEngineTargetDetails *ComputeEngineTargetDetails `protobuf:"bytes,14,opt,name=compute_engine_target_details,json=computeEngineTargetDetails,proto3,oneof"`
}

func (*CutoverJob_ComputeEngineTargetDetails) isCutoverJob_TargetVmDetails() {}

// CutoverStep holds information about the cutover step progress.
type CutoverStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//	*CutoverStep_PreviousReplicationCycle
	//	*CutoverStep_ShuttingDownSourceVm
	//	*CutoverStep_FinalSync
	//	*CutoverStep_PreparingVmDisks
	//	*CutoverStep_InstantiatingMigratedVm
	Step isCutoverStep_Step `protobuf_oneof:"step"`
	// The time the step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CutoverStep) Reset() {
	*x = CutoverStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CutoverStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CutoverStep) ProtoMessage() {}

func (x *CutoverStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CutoverStep.ProtoReflect.Descriptor instead.
func (*CutoverStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{13}
}

func (m *CutoverStep) GetStep() isCutoverStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *CutoverStep) GetPreviousReplicationCycle() *ReplicationCycle {
	if x, ok := x.GetStep().(*CutoverStep_PreviousReplicationCycle); ok {
		return x.PreviousReplicationCycle
	}
	return nil
}

func (x *CutoverStep) GetShuttingDownSourceVm() *ShuttingDownSourceVMStep {
	if x, ok := x.GetStep().(*CutoverStep_ShuttingDownSourceVm); ok {
		return x.ShuttingDownSourceVm
	}
	return nil
}

func (x *CutoverStep) GetFinalSync() *ReplicationCycle {
	if x, ok := x.GetStep().(*CutoverStep_FinalSync); ok {
		return x.FinalSync
	}
	return nil
}

func (x *CutoverStep) GetPreparingVmDisks() *PreparingVMDisksStep {
	if x, ok := x.GetStep().(*CutoverStep_PreparingVmDisks); ok {
		return x.PreparingVmDisks
	}
	return nil
}

func (x *CutoverStep) GetInstantiatingMigratedVm() *InstantiatingMigratedVMStep {
	if x, ok := x.GetStep().(*CutoverStep_InstantiatingMigratedVm); ok {
		return x.InstantiatingMigratedVm
	}
	return nil
}

func (x *CutoverStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CutoverStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isCutoverStep_Step interface {
	isCutoverStep_Step()
}

type CutoverStep_PreviousReplicationCycle struct {
	// A replication cycle prior cutover step.
	PreviousReplicationCycle *ReplicationCycle `protobuf:"bytes,3,opt,name=previous_replication_cycle,json=previousReplicationCycle,proto3,oneof"`
}

type CutoverStep_ShuttingDownSourceVm struct {
	// Shutting down VM step.
	ShuttingDownSourceVm *ShuttingDownSourceVMStep `protobuf:"bytes,4,opt,name=shutting_down_source_vm,json=shuttingDownSourceVm,proto3,oneof"`
}

type CutoverStep_FinalSync struct {
	// Final sync step.
	FinalSync *ReplicationCycle `protobuf:"bytes,5,opt,name=final_sync,json=finalSync,proto3,oneof"`
}

type CutoverStep_PreparingVmDisks struct {
	// Preparing VM disks step.
	PreparingVmDisks *PreparingVMDisksStep `protobuf:"bytes,6,opt,name=preparing_vm_disks,json=preparingVmDisks,proto3,oneof"`
}

type CutoverStep_InstantiatingMigratedVm struct {
	// Instantiating migrated VM step.
	InstantiatingMigratedVm *InstantiatingMigratedVMStep `protobuf:"bytes,7,opt,name=instantiating_migrated_vm,json=instantiatingMigratedVm,proto3,oneof"`
}

func (*CutoverStep_PreviousReplicationCycle) isCutoverStep_Step() {}

func (*CutoverStep_ShuttingDownSourceVm) isCutoverStep_Step() {}

func (*CutoverStep_FinalSync) isCutoverStep_Step() {}

func (*CutoverStep_PreparingVmDisks) isCutoverStep_Step() {}

func (*CutoverStep_InstantiatingMigratedVm) isCutoverStep_Step() {}

// ShuttingDownSourceVMStep contains specific step details.
type ShuttingDownSourceVMStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ShuttingDownSourceVMStep) Reset() {
	*x = ShuttingDownSourceVMStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShuttingDownSourceVMStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShuttingDownSourceVMStep) ProtoMessage() {}

func (x *ShuttingDownSourceVMStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShuttingDownSourceVMStep.ProtoReflect.Descriptor instead.
func (*ShuttingDownSourceVMStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{14}
}

// Request message for 'CreateCloneJob' request.
type CreateCloneJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Clone's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The clone job identifier.
	CloneJobId string `protobuf:"bytes,2,opt,name=clone_job_id,json=cloneJobId,proto3" json:"clone_job_id,omitempty"`
	// Required. The clone request body.
	CloneJob *CloneJob `protobuf:"bytes,3,opt,name=clone_job,json=cloneJob,proto3" json:"clone_job,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateCloneJobRequest) Reset() {
	*x = CreateCloneJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCloneJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloneJobRequest) ProtoMessage() {}

func (x *CreateCloneJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloneJobRequest.ProtoReflect.Descriptor instead.
func (*CreateCloneJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{15}
}

func (x *CreateCloneJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCloneJobRequest) GetCloneJobId() string {
	if x != nil {
		return x.CloneJobId
	}
	return ""
}

func (x *CreateCloneJobRequest) GetCloneJob() *CloneJob {
	if x != nil {
		return x.CloneJob
	}
	return nil
}

func (x *CreateCloneJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'CancelCloneJob' request.
type CancelCloneJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The clone job id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelCloneJobRequest) Reset() {
	*x = CancelCloneJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelCloneJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCloneJobRequest) ProtoMessage() {}

func (x *CancelCloneJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCloneJobRequest.ProtoReflect.Descriptor instead.
func (*CancelCloneJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{16}
}

func (x *CancelCloneJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'CancelCloneJob' request.
type CancelCloneJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelCloneJobResponse) Reset() {
	*x = CancelCloneJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelCloneJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCloneJobResponse) ProtoMessage() {}

func (x *CancelCloneJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCloneJobResponse.ProtoReflect.Descriptor instead.
func (*CancelCloneJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{17}
}

// Request message for 'ListCloneJobsRequest' request.
type ListCloneJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of source VMs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of clone jobs to return. The service may
	// return fewer than this value. If unspecified, at most 500 clone jobs will
	// be returned. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListCloneJobs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCloneJobs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCloneJobsRequest) Reset() {
	*x = ListCloneJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloneJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloneJobsRequest) ProtoMessage() {}

func (x *ListCloneJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloneJobsRequest.ProtoReflect.Descriptor instead.
func (*ListCloneJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{18}
}

func (x *ListCloneJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCloneJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloneJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCloneJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCloneJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListCloneJobs' request.
type ListCloneJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of clone jobs response.
	CloneJobs []*CloneJob `protobuf:"bytes,1,rep,name=clone_jobs,json=cloneJobs,proto3" json:"clone_jobs,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCloneJobsResponse) Reset() {
	*x = ListCloneJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloneJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloneJobsResponse) ProtoMessage() {}

func (x *ListCloneJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloneJobsResponse.ProtoReflect.Descriptor instead.
func (*ListCloneJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{19}
}

func (x *ListCloneJobsResponse) GetCloneJobs() []*CloneJob {
	if x != nil {
		return x.CloneJobs
	}
	return nil
}

func (x *ListCloneJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCloneJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetCloneJob' request.
type GetCloneJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CloneJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCloneJobRequest) Reset() {
	*x = GetCloneJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCloneJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloneJobRequest) ProtoMessage() {}

func (x *GetCloneJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloneJobRequest.ProtoReflect.Descriptor instead.
func (*GetCloneJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{20}
}

func (x *GetCloneJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Source message describes a specific vm migration Source resource. It contains
// the source environment information.
type Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceDetails:
	//	*Source_Vmware
	//	*Source_Aws
	SourceDetails isSource_SourceDetails `protobuf_oneof:"source_details"`
	// Output only. The Source name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels of the source.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// User-provided description of the source.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Source) Reset() {
	*x = Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{21}
}

func (m *Source) GetSourceDetails() isSource_SourceDetails {
	if m != nil {
		return m.SourceDetails
	}
	return nil
}

func (x *Source) GetVmware() *VmwareSourceDetails {
	if x, ok := x.GetSourceDetails().(*Source_Vmware); ok {
		return x.Vmware
	}
	return nil
}

func (x *Source) GetAws() *AwsSourceDetails {
	if x, ok := x.GetSourceDetails().(*Source_Aws); ok {
		return x.Aws
	}
	return nil
}

func (x *Source) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Source) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Source) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Source) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Source) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

type isSource_SourceDetails interface {
	isSource_SourceDetails()
}

type Source_Vmware struct {
	// Vmware type source details.
	Vmware *VmwareSourceDetails `protobuf:"bytes,10,opt,name=vmware,proto3,oneof"`
}

type Source_Aws struct {
	// AWS type source details.
	Aws *AwsSourceDetails `protobuf:"bytes,12,opt,name=aws,proto3,oneof"`
}

func (*Source_Vmware) isSource_SourceDetails() {}

func (*Source_Aws) isSource_SourceDetails() {}

// VmwareSourceDetails message describes a specific source details for the
// vmware source type.
type VmwareSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The credentials username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Input only. The credentials password. This is write only and can not be
	// read in a GET operation.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// The ip address of the vcenter this Source represents.
	VcenterIp string `protobuf:"bytes,3,opt,name=vcenter_ip,json=vcenterIp,proto3" json:"vcenter_ip,omitempty"`
	// The thumbprint representing the certificate for the vcenter.
	Thumbprint string `protobuf:"bytes,4,opt,name=thumbprint,proto3" json:"thumbprint,omitempty"`
}

func (x *VmwareSourceDetails) Reset() {
	*x = VmwareSourceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareSourceDetails) ProtoMessage() {}

func (x *VmwareSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareSourceDetails.ProtoReflect.Descriptor instead.
func (*VmwareSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{22}
}

func (x *VmwareSourceDetails) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *VmwareSourceDetails) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *VmwareSourceDetails) GetVcenterIp() string {
	if x != nil {
		return x.VcenterIp
	}
	return ""
}

func (x *VmwareSourceDetails) GetThumbprint() string {
	if x != nil {
		return x.Thumbprint
	}
	return ""
}

// AwsSourceDetails message describes a specific source details for the
// AWS source type.
type AwsSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to CredentialsType:
	//	*AwsSourceDetails_AccessKeyCreds
	CredentialsType isAwsSourceDetails_CredentialsType `protobuf_oneof:"credentials_type"`
	// Immutable. The AWS region that the source VMs will be migrated from.
	AwsRegion string `protobuf:"bytes,3,opt,name=aws_region,json=awsRegion,proto3" json:"aws_region,omitempty"`
	// Output only. State of the source as determined by the health check.
	State AwsSourceDetails_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.AwsSourceDetails_State" json:"state,omitempty"`
	// Output only. Provides details on the state of the Source in case of an
	// error.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// AWS resource tags to limit the scope of the source inventory.
	InventoryTagList []*AwsSourceDetails_Tag `protobuf:"bytes,10,rep,name=inventory_tag_list,json=inventoryTagList,proto3" json:"inventory_tag_list,omitempty"`
	// AWS security group names to limit the scope of the source
	// inventory.
	InventorySecurityGroupNames []string `protobuf:"bytes,7,rep,name=inventory_security_group_names,json=inventorySecurityGroupNames,proto3" json:"inventory_security_group_names,omitempty"`
	// User specified tags to add to every M2VM generated resource in AWS.
	// These tags will be set in addition to the default tags that are set as part
	// of the migration process. The tags must not begin with the reserved prefix
	// `m2vm`.
	MigrationResourcesUserTags map[string]string `protobuf:"bytes,8,rep,name=migration_resources_user_tags,json=migrationResourcesUserTags,proto3" json:"migration_resources_user_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The source's public IP. All communication initiated by this
	// source will originate from this IP.
	PublicIp string `protobuf:"bytes,9,opt,name=public_ip,json=publicIp,proto3" json:"public_ip,omitempty"`
}

func (x *AwsSourceDetails) Reset() {
	*x = AwsSourceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDetails) ProtoMessage() {}

func (x *AwsSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDetails.ProtoReflect.Descriptor instead.
func (*AwsSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{23}
}

func (m *AwsSourceDetails) GetCredentialsType() isAwsSourceDetails_CredentialsType {
	if m != nil {
		return m.CredentialsType
	}
	return nil
}

func (x *AwsSourceDetails) GetAccessKeyCreds() *AwsSourceDetails_AccessKeyCredentials {
	if x, ok := x.GetCredentialsType().(*AwsSourceDetails_AccessKeyCreds); ok {
		return x.AccessKeyCreds
	}
	return nil
}

func (x *AwsSourceDetails) GetAwsRegion() string {
	if x != nil {
		return x.AwsRegion
	}
	return ""
}

func (x *AwsSourceDetails) GetState() AwsSourceDetails_State {
	if x != nil {
		return x.State
	}
	return AwsSourceDetails_STATE_UNSPECIFIED
}

func (x *AwsSourceDetails) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *AwsSourceDetails) GetInventoryTagList() []*AwsSourceDetails_Tag {
	if x != nil {
		return x.InventoryTagList
	}
	return nil
}

func (x *AwsSourceDetails) GetInventorySecurityGroupNames() []string {
	if x != nil {
		return x.InventorySecurityGroupNames
	}
	return nil
}

func (x *AwsSourceDetails) GetMigrationResourcesUserTags() map[string]string {
	if x != nil {
		return x.MigrationResourcesUserTags
	}
	return nil
}

func (x *AwsSourceDetails) GetPublicIp() string {
	if x != nil {
		return x.PublicIp
	}
	return ""
}

type isAwsSourceDetails_CredentialsType interface {
	isAwsSourceDetails_CredentialsType()
}

type AwsSourceDetails_AccessKeyCreds struct {
	// AWS Credentials using access key id and secret.
	AccessKeyCreds *AwsSourceDetails_AccessKeyCredentials `protobuf:"bytes,11,opt,name=access_key_creds,json=accessKeyCreds,proto3,oneof"`
}

func (*AwsSourceDetails_AccessKeyCreds) isAwsSourceDetails_CredentialsType() {}

// DatacenterConnector message describes a connector between the Source and
// Google Cloud, which is installed on a vmware datacenter (an OVA vm installed
// by the user) to connect the Datacenter to Google Cloud and support vm
// migration data transfer.
type DatacenterConnector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the connector was created (as an API call, not when
	// it was actually installed).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the connector was updated with an API call.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The connector's name.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. A unique key for this connector. This key is internal to the OVA
	// connector and is supplied with its creation during the registration process
	// and can not be modified.
	RegistrationId string `protobuf:"bytes,12,opt,name=registration_id,json=registrationId,proto3" json:"registration_id,omitempty"`
	// The service account to use in the connector when communicating with the
	// cloud.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The version running in the DatacenterConnector. This is supplied by the OVA
	// connector during the registration process and can not be modified.
	Version string `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The communication channel between the datacenter connector and
	// Google Cloud.
	Bucket string `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Output only. State of the DatacenterConnector, as determined by the health
	// checks.
	State DatacenterConnector_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.DatacenterConnector_State" json:"state,omitempty"`
	// Output only. The time the state was last set.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Provides details on the state of the Datacenter Connector in
	// case of an error.
	Error *status.Status `protobuf:"bytes,11,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Appliance OVA version.
	// This is the OVA which is manually installed by the user and contains the
	// infrastructure for the automatically updatable components on the appliance.
	ApplianceInfrastructureVersion string `protobuf:"bytes,13,opt,name=appliance_infrastructure_version,json=applianceInfrastructureVersion,proto3" json:"appliance_infrastructure_version,omitempty"`
	// Output only. Appliance last installed update bundle version.
	// This is the version of the automatically updatable components on the
	// appliance.
	ApplianceSoftwareVersion string `protobuf:"bytes,14,opt,name=appliance_software_version,json=applianceSoftwareVersion,proto3" json:"appliance_software_version,omitempty"`
	// Output only. The available versions for updating this appliance.
	AvailableVersions *AvailableUpdates `protobuf:"bytes,15,opt,name=available_versions,json=availableVersions,proto3" json:"available_versions,omitempty"`
	// Output only. The status of the current / last upgradeAppliance operation.
	UpgradeStatus *UpgradeStatus `protobuf:"bytes,16,opt,name=upgrade_status,json=upgradeStatus,proto3" json:"upgrade_status,omitempty"`
}

func (x *DatacenterConnector) Reset() {
	*x = DatacenterConnector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatacenterConnector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatacenterConnector) ProtoMessage() {}

func (x *DatacenterConnector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatacenterConnector.ProtoReflect.Descriptor instead.
func (*DatacenterConnector) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{24}
}

func (x *DatacenterConnector) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DatacenterConnector) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DatacenterConnector) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatacenterConnector) GetRegistrationId() string {
	if x != nil {
		return x.RegistrationId
	}
	return ""
}

func (x *DatacenterConnector) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *DatacenterConnector) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *DatacenterConnector) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DatacenterConnector) GetState() DatacenterConnector_State {
	if x != nil {
		return x.State
	}
	return DatacenterConnector_STATE_UNSPECIFIED
}

func (x *DatacenterConnector) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *DatacenterConnector) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DatacenterConnector) GetApplianceInfrastructureVersion() string {
	if x != nil {
		return x.ApplianceInfrastructureVersion
	}
	return ""
}

func (x *DatacenterConnector) GetApplianceSoftwareVersion() string {
	if x != nil {
		return x.ApplianceSoftwareVersion
	}
	return ""
}

func (x *DatacenterConnector) GetAvailableVersions() *AvailableUpdates {
	if x != nil {
		return x.AvailableVersions
	}
	return nil
}

func (x *DatacenterConnector) GetUpgradeStatus() *UpgradeStatus {
	if x != nil {
		return x.UpgradeStatus
	}
	return nil
}

// UpgradeStatus contains information about upgradeAppliance operation.
type UpgradeStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version to upgrade to.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The state of the upgradeAppliance operation.
	State UpgradeStatus_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.UpgradeStatus_State" json:"state,omitempty"`
	// Provides details on the state of the upgrade operation in case of an error.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	// The time the operation was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The version from which we upgraded.
	PreviousVersion string `protobuf:"bytes,5,opt,name=previous_version,json=previousVersion,proto3" json:"previous_version,omitempty"`
}

func (x *UpgradeStatus) Reset() {
	*x = UpgradeStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeStatus) ProtoMessage() {}

func (x *UpgradeStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeStatus.ProtoReflect.Descriptor instead.
func (*UpgradeStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{25}
}

func (x *UpgradeStatus) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *UpgradeStatus) GetState() UpgradeStatus_State {
	if x != nil {
		return x.State
	}
	return UpgradeStatus_STATE_UNSPECIFIED
}

func (x *UpgradeStatus) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *UpgradeStatus) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpgradeStatus) GetPreviousVersion() string {
	if x != nil {
		return x.PreviousVersion
	}
	return ""
}

// Holds informatiom about the available versions for upgrade.
type AvailableUpdates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The newest deployable version of the appliance.
	// The current appliance can't be updated into this version, and the owner
	// must manually deploy this OVA to a new appliance.
	NewDeployableAppliance *ApplianceVersion `protobuf:"bytes,1,opt,name=new_deployable_appliance,json=newDeployableAppliance,proto3" json:"new_deployable_appliance,omitempty"`
	// The latest version for in place update.
	// The current appliance can be updated to this version using the API or m4c
	// CLI.
	InPlaceUpdate *ApplianceVersion `protobuf:"bytes,2,opt,name=in_place_update,json=inPlaceUpdate,proto3" json:"in_place_update,omitempty"`
}

func (x *AvailableUpdates) Reset() {
	*x = AvailableUpdates{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailableUpdates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailableUpdates) ProtoMessage() {}

func (x *AvailableUpdates) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailableUpdates.ProtoReflect.Descriptor instead.
func (*AvailableUpdates) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{26}
}

func (x *AvailableUpdates) GetNewDeployableAppliance() *ApplianceVersion {
	if x != nil {
		return x.NewDeployableAppliance
	}
	return nil
}

func (x *AvailableUpdates) GetInPlaceUpdate() *ApplianceVersion {
	if x != nil {
		return x.InPlaceUpdate
	}
	return nil
}

// Describes an appliance version.
type ApplianceVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The appliance version.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// A link for downloading the version.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Determine whether it's critical to upgrade the appliance to this version.
	Critical bool `protobuf:"varint,3,opt,name=critical,proto3" json:"critical,omitempty"`
	// Link to a page that contains the version release notes.
	ReleaseNotesUri string `protobuf:"bytes,4,opt,name=release_notes_uri,json=releaseNotesUri,proto3" json:"release_notes_uri,omitempty"`
}

func (x *ApplianceVersion) Reset() {
	*x = ApplianceVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplianceVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplianceVersion) ProtoMessage() {}

func (x *ApplianceVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplianceVersion.ProtoReflect.Descriptor instead.
func (*ApplianceVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{27}
}

func (x *ApplianceVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ApplianceVersion) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ApplianceVersion) GetCritical() bool {
	if x != nil {
		return x.Critical
	}
	return false
}

func (x *ApplianceVersion) GetReleaseNotesUri() string {
	if x != nil {
		return x.ReleaseNotesUri
	}
	return ""
}

// Request message for 'ListSources' request.
type ListSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of sources.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of sources to return. The service may return
	// fewer than this value. If unspecified, at most 500 sources will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListSources` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSources` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSourcesRequest) Reset() {
	*x = ListSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesRequest) ProtoMessage() {}

func (x *ListSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{28}
}

func (x *ListSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListSources' request.
type ListSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of sources response.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSourcesResponse) Reset() {
	*x = ListSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesResponse) ProtoMessage() {}

func (x *ListSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{29}
}

func (x *ListSourcesResponse) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ListSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSourcesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetSource' request.
type GetSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Source name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSourceRequest) Reset() {
	*x = GetSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceRequest) ProtoMessage() {}

func (x *GetSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceRequest.ProtoReflect.Descriptor instead.
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{30}
}

func (x *GetSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateSource' request.
type CreateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Source's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source identifier.
	SourceId string `protobuf:"bytes,2,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Required. The create request body.
	Source *Source `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSourceRequest) Reset() {
	*x = CreateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSourceRequest) ProtoMessage() {}

func (x *CreateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{31}
}

func (x *CreateSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSourceRequest) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *CreateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *CreateSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Update message for 'UpdateSources' request.
type UpdateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// Source resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	Source *Source `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateSourceRequest) Reset() {
	*x = UpdateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSourceRequest) ProtoMessage() {}

func (x *UpdateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{32}
}

func (x *UpdateSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UpdateSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteSource' request.
type DeleteSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Source name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteSourceRequest) Reset() {
	*x = DeleteSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSourceRequest) ProtoMessage() {}

func (x *DeleteSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSourceRequest.ProtoReflect.Descriptor instead.
func (*DeleteSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [fetchInventory][google.cloud.vmmigration.v1.VmMigration.FetchInventory].
type FetchInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Source.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// If this flag is set to true, the source will be queried instead of using
	// cached results. Using this flag will make the call slower.
	ForceRefresh bool `protobuf:"varint,2,opt,name=force_refresh,json=forceRefresh,proto3" json:"force_refresh,omitempty"`
}

func (x *FetchInventoryRequest) Reset() {
	*x = FetchInventoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchInventoryRequest) ProtoMessage() {}

func (x *FetchInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchInventoryRequest.ProtoReflect.Descriptor instead.
func (*FetchInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{34}
}

func (x *FetchInventoryRequest) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *FetchInventoryRequest) GetForceRefresh() bool {
	if x != nil {
		return x.ForceRefresh
	}
	return false
}

// VmwareVmDetails describes a VM in vCenter.
type VmwareVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM's id in the source (note that this is not the MigratingVm's id).
	// This is the moref id of the VM.
	VmId string `protobuf:"bytes,1,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// The id of the vCenter's datacenter this VM is contained in.
	DatacenterId string `protobuf:"bytes,2,opt,name=datacenter_id,json=datacenterId,proto3" json:"datacenter_id,omitempty"`
	// The descriptive name of the vCenter's datacenter this VM is contained in.
	DatacenterDescription string `protobuf:"bytes,3,opt,name=datacenter_description,json=datacenterDescription,proto3" json:"datacenter_description,omitempty"`
	// The unique identifier of the VM in vCenter.
	Uuid string `protobuf:"bytes,4,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// The display name of the VM. Note that this is not necessarily unique.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The power state of the VM at the moment list was taken.
	PowerState VmwareVmDetails_PowerState `protobuf:"varint,6,opt,name=power_state,json=powerState,proto3,enum=google.cloud.vmmigration.v1.VmwareVmDetails_PowerState" json:"power_state,omitempty"`
	// The number of cpus in the VM.
	CpuCount int32 `protobuf:"varint,7,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// The size of the memory of the VM in MB.
	MemoryMb int32 `protobuf:"varint,8,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// The number of disks the VM has.
	DiskCount int32 `protobuf:"varint,9,opt,name=disk_count,json=diskCount,proto3" json:"disk_count,omitempty"`
	// The total size of the storage allocated to the VM in MB.
	CommittedStorageMb int64 `protobuf:"varint,12,opt,name=committed_storage_mb,json=committedStorageMb,proto3" json:"committed_storage_mb,omitempty"`
	// The VM's OS. See for example
	// https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html
	// for types of strings this might hold.
	GuestDescription string `protobuf:"bytes,11,opt,name=guest_description,json=guestDescription,proto3" json:"guest_description,omitempty"`
	// Output only. The VM Boot Option.
	BootOption VmwareVmDetails_BootOption `protobuf:"varint,13,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.VmwareVmDetails_BootOption" json:"boot_option,omitempty"`
}

func (x *VmwareVmDetails) Reset() {
	*x = VmwareVmDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareVmDetails) ProtoMessage() {}

func (x *VmwareVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareVmDetails.ProtoReflect.Descriptor instead.
func (*VmwareVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{35}
}

func (x *VmwareVmDetails) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *VmwareVmDetails) GetDatacenterId() string {
	if x != nil {
		return x.DatacenterId
	}
	return ""
}

func (x *VmwareVmDetails) GetDatacenterDescription() string {
	if x != nil {
		return x.DatacenterDescription
	}
	return ""
}

func (x *VmwareVmDetails) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *VmwareVmDetails) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VmwareVmDetails) GetPowerState() VmwareVmDetails_PowerState {
	if x != nil {
		return x.PowerState
	}
	return VmwareVmDetails_POWER_STATE_UNSPECIFIED
}

func (x *VmwareVmDetails) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *VmwareVmDetails) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *VmwareVmDetails) GetDiskCount() int32 {
	if x != nil {
		return x.DiskCount
	}
	return 0
}

func (x *VmwareVmDetails) GetCommittedStorageMb() int64 {
	if x != nil {
		return x.CommittedStorageMb
	}
	return 0
}

func (x *VmwareVmDetails) GetGuestDescription() string {
	if x != nil {
		return x.GuestDescription
	}
	return ""
}

func (x *VmwareVmDetails) GetBootOption() VmwareVmDetails_BootOption {
	if x != nil {
		return x.BootOption
	}
	return VmwareVmDetails_BOOT_OPTION_UNSPECIFIED
}

// AwsVmDetails describes a VM in AWS.
type AwsVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM ID in AWS.
	VmId string `protobuf:"bytes,1,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// The display name of the VM. Note that this value is not necessarily unique.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The id of the AWS's source this VM is connected to.
	SourceId string `protobuf:"bytes,3,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// The descriptive name of the AWS's source this VM is connected to.
	SourceDescription string `protobuf:"bytes,4,opt,name=source_description,json=sourceDescription,proto3" json:"source_description,omitempty"`
	// Output only. The power state of the VM at the moment list was taken.
	PowerState AwsVmDetails_PowerState `protobuf:"varint,5,opt,name=power_state,json=powerState,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_PowerState" json:"power_state,omitempty"`
	// The number of cpus the VM has.
	CpuCount int32 `protobuf:"varint,6,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// The memory size of the VM in MB.
	MemoryMb int32 `protobuf:"varint,7,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// The number of disks the VM has.
	DiskCount int32 `protobuf:"varint,8,opt,name=disk_count,json=diskCount,proto3" json:"disk_count,omitempty"`
	// The total size of the storage allocated to the VM in MB.
	CommittedStorageMb int64 `protobuf:"varint,9,opt,name=committed_storage_mb,json=committedStorageMb,proto3" json:"committed_storage_mb,omitempty"`
	// The VM's OS.
	OsDescription string `protobuf:"bytes,10,opt,name=os_description,json=osDescription,proto3" json:"os_description,omitempty"`
	// The VM Boot Option.
	BootOption AwsVmDetails_BootOption `protobuf:"varint,11,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_BootOption" json:"boot_option,omitempty"`
	// The instance type of the VM.
	InstanceType string `protobuf:"bytes,12,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// The VPC ID the VM belongs to.
	VpcId string `protobuf:"bytes,13,opt,name=vpc_id,json=vpcId,proto3" json:"vpc_id,omitempty"`
	// The security groups the VM belongs to.
	SecurityGroups []*AwsSecurityGroup `protobuf:"bytes,14,rep,name=security_groups,json=securityGroups,proto3" json:"security_groups,omitempty"`
	// The tags of the VM.
	Tags map[string]string `protobuf:"bytes,15,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The AWS zone of the VM.
	Zone string `protobuf:"bytes,16,opt,name=zone,proto3" json:"zone,omitempty"`
	// The virtualization type.
	VirtualizationType AwsVmDetails_VmVirtualizationType `protobuf:"varint,17,opt,name=virtualization_type,json=virtualizationType,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_VmVirtualizationType" json:"virtualization_type,omitempty"`
	// The CPU architecture.
	Architecture AwsVmDetails_VmArchitecture `protobuf:"varint,18,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_VmArchitecture" json:"architecture,omitempty"`
}

func (x *AwsVmDetails) Reset() {
	*x = AwsVmDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsVmDetails) ProtoMessage() {}

func (x *AwsVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsVmDetails.ProtoReflect.Descriptor instead.
func (*AwsVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{36}
}

func (x *AwsVmDetails) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *AwsVmDetails) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AwsVmDetails) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *AwsVmDetails) GetSourceDescription() string {
	if x != nil {
		return x.SourceDescription
	}
	return ""
}

func (x *AwsVmDetails) GetPowerState() AwsVmDetails_PowerState {
	if x != nil {
		return x.PowerState
	}
	return AwsVmDetails_POWER_STATE_UNSPECIFIED
}

func (x *AwsVmDetails) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *AwsVmDetails) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *AwsVmDetails) GetDiskCount() int32 {
	if x != nil {
		return x.DiskCount
	}
	return 0
}

func (x *AwsVmDetails) GetCommittedStorageMb() int64 {
	if x != nil {
		return x.CommittedStorageMb
	}
	return 0
}

func (x *AwsVmDetails) GetOsDescription() string {
	if x != nil {
		return x.OsDescription
	}
	return ""
}

func (x *AwsVmDetails) GetBootOption() AwsVmDetails_BootOption {
	if x != nil {
		return x.BootOption
	}
	return AwsVmDetails_BOOT_OPTION_UNSPECIFIED
}

func (x *AwsVmDetails) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *AwsVmDetails) GetVpcId() string {
	if x != nil {
		return x.VpcId
	}
	return ""
}

func (x *AwsVmDetails) GetSecurityGroups() []*AwsSecurityGroup {
	if x != nil {
		return x.SecurityGroups
	}
	return nil
}

func (x *AwsVmDetails) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AwsVmDetails) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *AwsVmDetails) GetVirtualizationType() AwsVmDetails_VmVirtualizationType {
	if x != nil {
		return x.VirtualizationType
	}
	return AwsVmDetails_VM_VIRTUALIZATION_TYPE_UNSPECIFIED
}

func (x *AwsVmDetails) GetArchitecture() AwsVmDetails_VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return AwsVmDetails_VM_ARCHITECTURE_UNSPECIFIED
}

// AwsSecurityGroup describes a security group of an AWS VM.
type AwsSecurityGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The AWS security group id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The AWS security group name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AwsSecurityGroup) Reset() {
	*x = AwsSecurityGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsSecurityGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSecurityGroup) ProtoMessage() {}

func (x *AwsSecurityGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSecurityGroup.ProtoReflect.Descriptor instead.
func (*AwsSecurityGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{37}
}

func (x *AwsSecurityGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AwsSecurityGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// VmwareVmsDetails describes VMs in vCenter.
type VmwareVmsDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the vmware VMs.
	Details []*VmwareVmDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *VmwareVmsDetails) Reset() {
	*x = VmwareVmsDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareVmsDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareVmsDetails) ProtoMessage() {}

func (x *VmwareVmsDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareVmsDetails.ProtoReflect.Descriptor instead.
func (*VmwareVmsDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{38}
}

func (x *VmwareVmsDetails) GetDetails() []*VmwareVmDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// AWSVmsDetails describes VMs in AWS.
type AwsVmsDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the AWS VMs.
	Details []*AwsVmDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *AwsVmsDetails) Reset() {
	*x = AwsVmsDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsVmsDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsVmsDetails) ProtoMessage() {}

func (x *AwsVmsDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsVmsDetails.ProtoReflect.Descriptor instead.
func (*AwsVmsDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{39}
}

func (x *AwsVmsDetails) GetDetails() []*AwsVmDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// Response message for
// [fetchInventory][google.cloud.vmmigration.v1.VmMigration.FetchInventory].
type FetchInventoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceVms:
	//	*FetchInventoryResponse_VmwareVms
	//	*FetchInventoryResponse_AwsVms
	SourceVms isFetchInventoryResponse_SourceVms `protobuf_oneof:"SourceVms"`
	// Output only. The timestamp when the source was last queried (if the result
	// is from the cache).
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *FetchInventoryResponse) Reset() {
	*x = FetchInventoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchInventoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchInventoryResponse) ProtoMessage() {}

func (x *FetchInventoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchInventoryResponse.ProtoReflect.Descriptor instead.
func (*FetchInventoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{40}
}

func (m *FetchInventoryResponse) GetSourceVms() isFetchInventoryResponse_SourceVms {
	if m != nil {
		return m.SourceVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetVmwareVms() *VmwareVmsDetails {
	if x, ok := x.GetSourceVms().(*FetchInventoryResponse_VmwareVms); ok {
		return x.VmwareVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetAwsVms() *AwsVmsDetails {
	if x, ok := x.GetSourceVms().(*FetchInventoryResponse_AwsVms); ok {
		return x.AwsVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isFetchInventoryResponse_SourceVms interface {
	isFetchInventoryResponse_SourceVms()
}

type FetchInventoryResponse_VmwareVms struct {
	// The description of the VMs in a Source of type Vmware.
	VmwareVms *VmwareVmsDetails `protobuf:"bytes,1,opt,name=vmware_vms,json=vmwareVms,proto3,oneof"`
}

type FetchInventoryResponse_AwsVms struct {
	// The description of the VMs in a Source of type AWS.
	AwsVms *AwsVmsDetails `protobuf:"bytes,3,opt,name=aws_vms,json=awsVms,proto3,oneof"`
}

func (*FetchInventoryResponse_VmwareVms) isFetchInventoryResponse_SourceVms() {}

func (*FetchInventoryResponse_AwsVms) isFetchInventoryResponse_SourceVms() {}

// Utilization report details the utilization (CPU, memory, etc.) of selected
// source VMs.
type UtilizationReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The report unique name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The report display name, as assigned by the user.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Current state of the report.
	State UtilizationReport_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.UtilizationReport_State" json:"state,omitempty"`
	// Output only. The time the state was last set.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Provides details on the state of the report in case of an
	// error.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The time the report was created (this refers to the time of
	// the request, not the time the report creation completed).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time frame of the report.
	TimeFrame UtilizationReport_TimeFrame `protobuf:"varint,7,opt,name=time_frame,json=timeFrame,proto3,enum=google.cloud.vmmigration.v1.UtilizationReport_TimeFrame" json:"time_frame,omitempty"`
	// Output only. The point in time when the time frame ends. Notice that the
	// time frame is counted backwards. For instance if the "frame_end_time" value
	// is 2021/01/20 and the time frame is WEEK then the report covers the week
	// between 2021/01/20 and 2021/01/14.
	FrameEndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=frame_end_time,json=frameEndTime,proto3" json:"frame_end_time,omitempty"`
	// Output only. Total number of VMs included in the report.
	VmCount int32 `protobuf:"varint,9,opt,name=vm_count,json=vmCount,proto3" json:"vm_count,omitempty"`
	// List of utilization information per VM.
	// When sent as part of the request, the "vm_id" field is used in order to
	// specify which VMs to include in the report. In that case all other fields
	// are ignored.
	Vms []*VmUtilizationInfo `protobuf:"bytes,10,rep,name=vms,proto3" json:"vms,omitempty"`
}

func (x *UtilizationReport) Reset() {
	*x = UtilizationReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UtilizationReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UtilizationReport) ProtoMessage() {}

func (x *UtilizationReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UtilizationReport.ProtoReflect.Descriptor instead.
func (*UtilizationReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41}
}

func (x *UtilizationReport) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UtilizationReport) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *UtilizationReport) GetState() UtilizationReport_State {
	if x != nil {
		return x.State
	}
	return UtilizationReport_STATE_UNSPECIFIED
}

func (x *UtilizationReport) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *UtilizationReport) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *UtilizationReport) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UtilizationReport) GetTimeFrame() UtilizationReport_TimeFrame {
	if x != nil {
		return x.TimeFrame
	}
	return UtilizationReport_TIME_FRAME_UNSPECIFIED
}

func (x *UtilizationReport) GetFrameEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FrameEndTime
	}
	return nil
}

func (x *UtilizationReport) GetVmCount() int32 {
	if x != nil {
		return x.VmCount
	}
	return 0
}

func (x *UtilizationReport) GetVms() []*VmUtilizationInfo {
	if x != nil {
		return x.Vms
	}
	return nil
}

// Utilization information of a single VM.
type VmUtilizationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to VmDetails:
	//	*VmUtilizationInfo_VmwareVmDetails
	VmDetails isVmUtilizationInfo_VmDetails `protobuf_oneof:"VmDetails"`
	// The VM's ID in the source.
	VmId string `protobuf:"bytes,3,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// Utilization metrics for this VM.
	Utilization *VmUtilizationMetrics `protobuf:"bytes,2,opt,name=utilization,proto3" json:"utilization,omitempty"`
}

func (x *VmUtilizationInfo) Reset() {
	*x = VmUtilizationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmUtilizationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmUtilizationInfo) ProtoMessage() {}

func (x *VmUtilizationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmUtilizationInfo.ProtoReflect.Descriptor instead.
func (*VmUtilizationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{42}
}

func (m *VmUtilizationInfo) GetVmDetails() isVmUtilizationInfo_VmDetails {
	if m != nil {
		return m.VmDetails
	}
	return nil
}

func (x *VmUtilizationInfo) GetVmwareVmDetails() *VmwareVmDetails {
	if x, ok := x.GetVmDetails().(*VmUtilizationInfo_VmwareVmDetails); ok {
		return x.VmwareVmDetails
	}
	return nil
}

func (x *VmUtilizationInfo) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *VmUtilizationInfo) GetUtilization() *VmUtilizationMetrics {
	if x != nil {
		return x.Utilization
	}
	return nil
}

type isVmUtilizationInfo_VmDetails interface {
	isVmUtilizationInfo_VmDetails()
}

type VmUtilizationInfo_VmwareVmDetails struct {
	// The description of the VM in a Source of type Vmware.
	VmwareVmDetails *VmwareVmDetails `protobuf:"bytes,1,opt,name=vmware_vm_details,json=vmwareVmDetails,proto3,oneof"`
}

func (*VmUtilizationInfo_VmwareVmDetails) isVmUtilizationInfo_VmDetails() {}

// Utilization metrics values for a single VM.
type VmUtilizationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max CPU usage, percent.
	CpuMaxPercent int32 `protobuf:"varint,9,opt,name=cpu_max_percent,json=cpuMaxPercent,proto3" json:"cpu_max_percent,omitempty"`
	// Average CPU usage, percent.
	CpuAveragePercent int32 `protobuf:"varint,10,opt,name=cpu_average_percent,json=cpuAveragePercent,proto3" json:"cpu_average_percent,omitempty"`
	// Max memory usage, percent.
	MemoryMaxPercent int32 `protobuf:"varint,11,opt,name=memory_max_percent,json=memoryMaxPercent,proto3" json:"memory_max_percent,omitempty"`
	// Average memory usage, percent.
	MemoryAveragePercent int32 `protobuf:"varint,12,opt,name=memory_average_percent,json=memoryAveragePercent,proto3" json:"memory_average_percent,omitempty"`
	// Max disk IO rate, in kilobytes per second.
	DiskIoRateMaxKbps int64 `protobuf:"varint,13,opt,name=disk_io_rate_max_kbps,json=diskIoRateMaxKbps,proto3" json:"disk_io_rate_max_kbps,omitempty"`
	// Average disk IO rate, in kilobytes per second.
	DiskIoRateAverageKbps int64 `protobuf:"varint,14,opt,name=disk_io_rate_average_kbps,json=diskIoRateAverageKbps,proto3" json:"disk_io_rate_average_kbps,omitempty"`
	// Max network throughput (combined transmit-rates and receive-rates), in
	// kilobytes per second.
	NetworkThroughputMaxKbps int64 `protobuf:"varint,15,opt,name=network_throughput_max_kbps,json=networkThroughputMaxKbps,proto3" json:"network_throughput_max_kbps,omitempty"`
	// Average network throughput (combined transmit-rates and receive-rates), in
	// kilobytes per second.
	NetworkThroughputAverageKbps int64 `protobuf:"varint,16,opt,name=network_throughput_average_kbps,json=networkThroughputAverageKbps,proto3" json:"network_throughput_average_kbps,omitempty"`
}

func (x *VmUtilizationMetrics) Reset() {
	*x = VmUtilizationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmUtilizationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmUtilizationMetrics) ProtoMessage() {}

func (x *VmUtilizationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmUtilizationMetrics.ProtoReflect.Descriptor instead.
func (*VmUtilizationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{43}
}

func (x *VmUtilizationMetrics) GetCpuMaxPercent() int32 {
	if x != nil {
		return x.CpuMaxPercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetCpuAveragePercent() int32 {
	if x != nil {
		return x.CpuAveragePercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetMemoryMaxPercent() int32 {
	if x != nil {
		return x.MemoryMaxPercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetMemoryAveragePercent() int32 {
	if x != nil {
		return x.MemoryAveragePercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetDiskIoRateMaxKbps() int64 {
	if x != nil {
		return x.DiskIoRateMaxKbps
	}
	return 0
}

func (x *VmUtilizationMetrics) GetDiskIoRateAverageKbps() int64 {
	if x != nil {
		return x.DiskIoRateAverageKbps
	}
	return 0
}

func (x *VmUtilizationMetrics) GetNetworkThroughputMaxKbps() int64 {
	if x != nil {
		return x.NetworkThroughputMaxKbps
	}
	return 0
}

func (x *VmUtilizationMetrics) GetNetworkThroughputAverageKbps() int64 {
	if x != nil {
		return x.NetworkThroughputAverageKbps
	}
	return 0
}

// Request message for 'ListUtilizationReports' request.
type ListUtilizationReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Reports parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The level of details of each report.
	// Defaults to BASIC.
	View UtilizationReportView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.UtilizationReportView" json:"view,omitempty"`
	// Optional. The maximum number of reports to return. The service may return
	// fewer than this value. If unspecified, at most 500 reports will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListUtilizationReports`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListUtilizationReports`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListUtilizationReportsRequest) Reset() {
	*x = ListUtilizationReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUtilizationReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUtilizationReportsRequest) ProtoMessage() {}

func (x *ListUtilizationReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUtilizationReportsRequest.ProtoReflect.Descriptor instead.
func (*ListUtilizationReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{44}
}

func (x *ListUtilizationReportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUtilizationReportsRequest) GetView() UtilizationReportView {
	if x != nil {
		return x.View
	}
	return UtilizationReportView_UTILIZATION_REPORT_VIEW_UNSPECIFIED
}

func (x *ListUtilizationReportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUtilizationReportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListUtilizationReportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListUtilizationReportsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListUtilizationReports' request.
type ListUtilizationReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of reports.
	UtilizationReports []*UtilizationReport `protobuf:"bytes,1,rep,name=utilization_reports,json=utilizationReports,proto3" json:"utilization_reports,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListUtilizationReportsResponse) Reset() {
	*x = ListUtilizationReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUtilizationReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUtilizationReportsResponse) ProtoMessage() {}

func (x *ListUtilizationReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUtilizationReportsResponse.ProtoReflect.Descriptor instead.
func (*ListUtilizationReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{45}
}

func (x *ListUtilizationReportsResponse) GetUtilizationReports() []*UtilizationReport {
	if x != nil {
		return x.UtilizationReports
	}
	return nil
}

func (x *ListUtilizationReportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListUtilizationReportsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetUtilizationReport' request.
type GetUtilizationReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Report name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of details of the report.
	// Defaults to FULL
	View UtilizationReportView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.UtilizationReportView" json:"view,omitempty"`
}

func (x *GetUtilizationReportRequest) Reset() {
	*x = GetUtilizationReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUtilizationReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUtilizationReportRequest) ProtoMessage() {}

func (x *GetUtilizationReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUtilizationReportRequest.ProtoReflect.Descriptor instead.
func (*GetUtilizationReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{46}
}

func (x *GetUtilizationReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetUtilizationReportRequest) GetView() UtilizationReportView {
	if x != nil {
		return x.View
	}
	return UtilizationReportView_UTILIZATION_REPORT_VIEW_UNSPECIFIED
}

// Request message for 'CreateUtilizationReport' request.
type CreateUtilizationReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Report's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The report to create.
	UtilizationReport *UtilizationReport `protobuf:"bytes,2,opt,name=utilization_report,json=utilizationReport,proto3" json:"utilization_report,omitempty"`
	// Required. The ID to use for the report, which will become the final
	// component of the reports's resource name.
	//
	// This value maximum length is 63 characters, and valid characters
	// are /[a-z][0-9]-/. It must start with an english letter and must not
	// end with a hyphen.
	UtilizationReportId string `protobuf:"bytes,3,opt,name=utilization_report_id,json=utilizationReportId,proto3" json:"utilization_report_id,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateUtilizationReportRequest) Reset() {
	*x = CreateUtilizationReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUtilizationReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUtilizationReportRequest) ProtoMessage() {}

func (x *CreateUtilizationReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUtilizationReportRequest.ProtoReflect.Descriptor instead.
func (*CreateUtilizationReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{47}
}

func (x *CreateUtilizationReportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateUtilizationReportRequest) GetUtilizationReport() *UtilizationReport {
	if x != nil {
		return x.UtilizationReport
	}
	return nil
}

func (x *CreateUtilizationReportRequest) GetUtilizationReportId() string {
	if x != nil {
		return x.UtilizationReportId
	}
	return ""
}

func (x *CreateUtilizationReportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteUtilizationReport' request.
type DeleteUtilizationReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Report name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteUtilizationReportRequest) Reset() {
	*x = DeleteUtilizationReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUtilizationReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUtilizationReportRequest) ProtoMessage() {}

func (x *DeleteUtilizationReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUtilizationReportRequest.ProtoReflect.Descriptor instead.
func (*DeleteUtilizationReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{48}
}

func (x *DeleteUtilizationReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteUtilizationReportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for 'ListDatacenterConnectors' request.
type ListDatacenterConnectorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of sources response.
	DatacenterConnectors []*DatacenterConnector `protobuf:"bytes,1,rep,name=datacenter_connectors,json=datacenterConnectors,proto3" json:"datacenter_connectors,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDatacenterConnectorsResponse) Reset() {
	*x = ListDatacenterConnectorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDatacenterConnectorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatacenterConnectorsResponse) ProtoMessage() {}

func (x *ListDatacenterConnectorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatacenterConnectorsResponse.ProtoReflect.Descriptor instead.
func (*ListDatacenterConnectorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{49}
}

func (x *ListDatacenterConnectorsResponse) GetDatacenterConnectors() []*DatacenterConnector {
	if x != nil {
		return x.DatacenterConnectors
	}
	return nil
}

func (x *ListDatacenterConnectorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDatacenterConnectorsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetDatacenterConnector' request.
type GetDatacenterConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DatacenterConnector.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDatacenterConnectorRequest) Reset() {
	*x = GetDatacenterConnectorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatacenterConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatacenterConnectorRequest) ProtoMessage() {}

func (x *GetDatacenterConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatacenterConnectorRequest.ProtoReflect.Descriptor instead.
func (*GetDatacenterConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{50}
}

func (x *GetDatacenterConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateDatacenterConnector' request.
type CreateDatacenterConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatacenterConnector's parent.
	// Required. The Source in where the new DatacenterConnector will be created.
	// For example:
	// `projects/my-project/locations/us-central1/sources/my-source`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The datacenterConnector identifier.
	DatacenterConnectorId string `protobuf:"bytes,2,opt,name=datacenter_connector_id,json=datacenterConnectorId,proto3" json:"datacenter_connector_id,omitempty"`
	// Required. The create request body.
	DatacenterConnector *DatacenterConnector `protobuf:"bytes,3,opt,name=datacenter_connector,json=datacenterConnector,proto3" json:"datacenter_connector,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateDatacenterConnectorRequest) Reset() {
	*x = CreateDatacenterConnectorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDatacenterConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatacenterConnectorRequest) ProtoMessage() {}

func (x *CreateDatacenterConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatacenterConnectorRequest.ProtoReflect.Descriptor instead.
func (*CreateDatacenterConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{51}
}

func (x *CreateDatacenterConnectorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDatacenterConnectorRequest) GetDatacenterConnectorId() string {
	if x != nil {
		return x.DatacenterConnectorId
	}
	return ""
}

func (x *CreateDatacenterConnectorRequest) GetDatacenterConnector() *DatacenterConnector {
	if x != nil {
		return x.DatacenterConnector
	}
	return nil
}

func (x *CreateDatacenterConnectorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteDatacenterConnector' request.
type DeleteDatacenterConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatacenterConnector name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteDatacenterConnectorRequest) Reset() {
	*x = DeleteDatacenterConnectorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDatacenterConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatacenterConnectorRequest) ProtoMessage() {}

func (x *DeleteDatacenterConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatacenterConnectorRequest.ProtoReflect.Descriptor instead.
func (*DeleteDatacenterConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{52}
}

func (x *DeleteDatacenterConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDatacenterConnectorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'UpgradeAppliance' request.
type UpgradeApplianceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatacenterConnector name.
	DatacenterConnector string `protobuf:"bytes,1,opt,name=datacenter_connector,json=datacenterConnector,proto3" json:"datacenter_connector,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpgradeApplianceRequest) Reset() {
	*x = UpgradeApplianceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeApplianceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeApplianceRequest) ProtoMessage() {}

func (x *UpgradeApplianceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeApplianceRequest.ProtoReflect.Descriptor instead.
func (*UpgradeApplianceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{53}
}

func (x *UpgradeApplianceRequest) GetDatacenterConnector() string {
	if x != nil {
		return x.DatacenterConnector
	}
	return ""
}

func (x *UpgradeApplianceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for 'UpgradeAppliance' request.
type UpgradeApplianceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpgradeApplianceResponse) Reset() {
	*x = UpgradeApplianceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeApplianceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeApplianceResponse) ProtoMessage() {}

func (x *UpgradeApplianceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeApplianceResponse.ProtoReflect.Descriptor instead.
func (*UpgradeApplianceResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{54}
}

// Request message for 'ListDatacenterConnectors' request.
type ListDatacenterConnectorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of connectors.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of connectors to return. The service may
	// return fewer than this value. If unspecified, at most 500 sources will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListDatacenterConnectors`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDatacenterConnectors` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDatacenterConnectorsRequest) Reset() {
	*x = ListDatacenterConnectorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDatacenterConnectorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatacenterConnectorsRequest) ProtoMessage() {}

func (x *ListDatacenterConnectorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatacenterConnectorsRequest.ProtoReflect.Descriptor instead.
func (*ListDatacenterConnectorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{55}
}

func (x *ListDatacenterConnectorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDatacenterConnectorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDatacenterConnectorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDatacenterConnectorsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDatacenterConnectorsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ComputeEngineTargetDefaults is a collection of details for creating a VM in a
// target Compute Engine project.
type ComputeEngineTargetDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the VM to create.
	VmName string `protobuf:"bytes,1,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// The full path of the resource of type TargetProject which represents the
	// Compute Engine project in which to create this VM.
	TargetProject string `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// The zone in which to create the VM.
	Zone string `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	// The machine type series to create the VM with.
	MachineTypeSeries string `protobuf:"bytes,4,opt,name=machine_type_series,json=machineTypeSeries,proto3" json:"machine_type_series,omitempty"`
	// The machine type to create the VM with.
	MachineType string `protobuf:"bytes,5,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// A map of network tags to associate with the VM.
	NetworkTags []string `protobuf:"bytes,6,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// List of NICs connected to this VM.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,7,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// The service account to associate the VM with.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The disk type to use in the VM.
	DiskType ComputeEngineDiskType `protobuf:"varint,9,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
	// A map of labels to associate with the VM.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The license type to use in OS adaptation.
	LicenseType ComputeEngineLicenseType `protobuf:"varint,11,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineLicenseType" json:"license_type,omitempty"`
	// Output only. The OS license returned from the adaptation module report.
	AppliedLicense *AppliedLicense `protobuf:"bytes,12,opt,name=applied_license,json=appliedLicense,proto3" json:"applied_license,omitempty"`
	// Compute instance scheduling information (if empty default is used).
	ComputeScheduling *ComputeScheduling `protobuf:"bytes,13,opt,name=compute_scheduling,json=computeScheduling,proto3" json:"compute_scheduling,omitempty"`
	// Defines whether the instance has Secure Boot enabled.
	// This can be set to true only if the vm boot option is EFI.
	SecureBoot bool `protobuf:"varint,14,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// Output only. The VM Boot Option, as set in the source vm.
	BootOption ComputeEngineBootOption `protobuf:"varint,15,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineBootOption" json:"boot_option,omitempty"`
	// The metadata key/value pairs to assign to the VM.
	Metadata map[string]string `protobuf:"bytes,16,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional licenses to assign to the VM.
	AdditionalLicenses []string `protobuf:"bytes,17,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// The hostname to assign to the VM.
	Hostname string `protobuf:"bytes,18,opt,name=hostname,proto3" json:"hostname,omitempty"`
}

func (x *ComputeEngineTargetDefaults) Reset() {
	*x = ComputeEngineTargetDefaults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeEngineTargetDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineTargetDefaults) ProtoMessage() {}

func (x *ComputeEngineTargetDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineTargetDefaults.ProtoReflect.Descriptor instead.
func (*ComputeEngineTargetDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{56}
}

func (x *ComputeEngineTargetDefaults) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetMachineTypeSeries() string {
	if x != nil {
		return x.MachineTypeSeries
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

func (x *ComputeEngineTargetDefaults) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetLicenseType() ComputeEngineLicenseType {
	if x != nil {
		return x.LicenseType
	}
	return ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT
}

func (x *ComputeEngineTargetDefaults) GetAppliedLicense() *AppliedLicense {
	if x != nil {
		return x.AppliedLicense
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetComputeScheduling() *ComputeScheduling {
	if x != nil {
		return x.ComputeScheduling
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetSecureBoot() bool {
	if x != nil {
		return x.SecureBoot
	}
	return false
}

func (x *ComputeEngineTargetDefaults) GetBootOption() ComputeEngineBootOption {
	if x != nil {
		return x.BootOption
	}
	return ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED
}

func (x *ComputeEngineTargetDefaults) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

// ComputeEngineTargetDetails is a collection of details for creating a VM in a
// target Compute Engine project.
type ComputeEngineTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the VM to create.
	VmName string `protobuf:"bytes,1,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// The Google Cloud target project ID or project name.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// The zone in which to create the VM.
	Zone string `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	// The machine type series to create the VM with.
	MachineTypeSeries string `protobuf:"bytes,4,opt,name=machine_type_series,json=machineTypeSeries,proto3" json:"machine_type_series,omitempty"`
	// The machine type to create the VM with.
	MachineType string `protobuf:"bytes,5,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// A map of network tags to associate with the VM.
	NetworkTags []string `protobuf:"bytes,6,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// List of NICs connected to this VM.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,7,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// The service account to associate the VM with.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The disk type to use in the VM.
	DiskType ComputeEngineDiskType `protobuf:"varint,9,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
	// A map of labels to associate with the VM.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The license type to use in OS adaptation.
	LicenseType ComputeEngineLicenseType `protobuf:"varint,11,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineLicenseType" json:"license_type,omitempty"`
	// The OS license returned from the adaptation module report.
	AppliedLicense *AppliedLicense `protobuf:"bytes,12,opt,name=applied_license,json=appliedLicense,proto3" json:"applied_license,omitempty"`
	// Compute instance scheduling information (if empty default is used).
	ComputeScheduling *ComputeScheduling `protobuf:"bytes,13,opt,name=compute_scheduling,json=computeScheduling,proto3" json:"compute_scheduling,omitempty"`
	// Defines whether the instance has Secure Boot enabled.
	// This can be set to true only if the vm boot option is EFI.
	SecureBoot bool `protobuf:"varint,14,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// The VM Boot Option, as set in the source vm.
	BootOption ComputeEngineBootOption `protobuf:"varint,15,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineBootOption" json:"boot_option,omitempty"`
	// The metadata key/value pairs to assign to the VM.
	Metadata map[string]string `protobuf:"bytes,16,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional licenses to assign to the VM.
	AdditionalLicenses []string `protobuf:"bytes,17,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// The hostname to assign to the VM.
	Hostname string `protobuf:"bytes,18,opt,name=hostname,proto3" json:"hostname,omitempty"`
}

func (x *ComputeEngineTargetDetails) Reset() {
	*x = ComputeEngineTargetDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeEngineTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineTargetDetails) ProtoMessage() {}

func (x *ComputeEngineTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineTargetDetails.ProtoReflect.Descriptor instead.
func (*ComputeEngineTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{57}
}

func (x *ComputeEngineTargetDetails) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetMachineTypeSeries() string {
	if x != nil {
		return x.MachineTypeSeries
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

func (x *ComputeEngineTargetDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetLicenseType() ComputeEngineLicenseType {
	if x != nil {
		return x.LicenseType
	}
	return ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT
}

func (x *ComputeEngineTargetDetails) GetAppliedLicense() *AppliedLicense {
	if x != nil {
		return x.AppliedLicense
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetComputeScheduling() *ComputeScheduling {
	if x != nil {
		return x.ComputeScheduling
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetSecureBoot() bool {
	if x != nil {
		return x.SecureBoot
	}
	return false
}

func (x *ComputeEngineTargetDetails) GetBootOption() ComputeEngineBootOption {
	if x != nil {
		return x.BootOption
	}
	return ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED
}

func (x *ComputeEngineTargetDetails) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

// NetworkInterface represents a NIC of a VM.
type NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The network to connect the NIC to.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// The subnetwork to connect the NIC to.
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// The internal IP to define in the NIC.
	// The formats accepted are: `ephemeral` \ ipv4 address \ a named address
	// resource full path.
	InternalIp string `protobuf:"bytes,3,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// The external IP to define in the NIC.
	ExternalIp string `protobuf:"bytes,4,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
}

func (x *NetworkInterface) Reset() {
	*x = NetworkInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterface) ProtoMessage() {}

func (x *NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterface.ProtoReflect.Descriptor instead.
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{58}
}

func (x *NetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkInterface) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *NetworkInterface) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *NetworkInterface) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

// AppliedLicense holds the license data returned by adaptation module report.
type AppliedLicense struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The license type that was used in OS adaptation.
	Type AppliedLicense_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vmmigration.v1.AppliedLicense_Type" json:"type,omitempty"`
	// The OS license returned from the adaptation module's report.
	OsLicense string `protobuf:"bytes,2,opt,name=os_license,json=osLicense,proto3" json:"os_license,omitempty"`
}

func (x *AppliedLicense) Reset() {
	*x = AppliedLicense{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppliedLicense) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedLicense) ProtoMessage() {}

func (x *AppliedLicense) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedLicense.ProtoReflect.Descriptor instead.
func (*AppliedLicense) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{59}
}

func (x *AppliedLicense) GetType() AppliedLicense_Type {
	if x != nil {
		return x.Type
	}
	return AppliedLicense_TYPE_UNSPECIFIED
}

func (x *AppliedLicense) GetOsLicense() string {
	if x != nil {
		return x.OsLicense
	}
	return ""
}

// Node Affinity: the configuration of desired nodes onto which this Instance
// could be scheduled. Based on
// https://cloud.google.com/compute/docs/reference/rest/v1/instances/setScheduling
type SchedulingNodeAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The label key of Node resource to reference.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The operator to use for the node resources specified in the `values`
	// parameter.
	Operator SchedulingNodeAffinity_Operator `protobuf:"varint,2,opt,name=operator,proto3,enum=google.cloud.vmmigration.v1.SchedulingNodeAffinity_Operator" json:"operator,omitempty"`
	// Corresponds to the label values of Node resource.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SchedulingNodeAffinity) Reset() {
	*x = SchedulingNodeAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchedulingNodeAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulingNodeAffinity) ProtoMessage() {}

func (x *SchedulingNodeAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulingNodeAffinity.ProtoReflect.Descriptor instead.
func (*SchedulingNodeAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{60}
}

func (x *SchedulingNodeAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SchedulingNodeAffinity) GetOperator() SchedulingNodeAffinity_Operator {
	if x != nil {
		return x.Operator
	}
	return SchedulingNodeAffinity_OPERATOR_UNSPECIFIED
}

func (x *SchedulingNodeAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Scheduling information for VM on maintenance/restart behaviour and
// node allocation in sole tenant nodes.
type ComputeScheduling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How the instance should behave when the host machine undergoes
	// maintenance that may temporarily impact instance performance.
	OnHostMaintenance ComputeScheduling_OnHostMaintenance `protobuf:"varint,1,opt,name=on_host_maintenance,json=onHostMaintenance,proto3,enum=google.cloud.vmmigration.v1.ComputeScheduling_OnHostMaintenance" json:"on_host_maintenance,omitempty"`
	// Whether the Instance should be automatically restarted whenever it is
	// terminated by Compute Engine (not terminated by user).
	// This configuration is identical to `automaticRestart` field in Compute
	// Engine create instance under scheduling.
	// It was changed to an enum (instead of a boolean) to match the default
	// value in Compute Engine which is automatic restart.
	RestartType ComputeScheduling_RestartType `protobuf:"varint,5,opt,name=restart_type,json=restartType,proto3,enum=google.cloud.vmmigration.v1.ComputeScheduling_RestartType" json:"restart_type,omitempty"`
	// A set of node affinity and anti-affinity configurations for sole tenant
	// nodes.
	NodeAffinities []*SchedulingNodeAffinity `protobuf:"bytes,3,rep,name=node_affinities,json=nodeAffinities,proto3" json:"node_affinities,omitempty"`
	// The minimum number of virtual CPUs this instance will consume when
	// running on a sole-tenant node. Ignored if no node_affinites are
	// configured.
	MinNodeCpus int32 `protobuf:"varint,4,opt,name=min_node_cpus,json=minNodeCpus,proto3" json:"min_node_cpus,omitempty"`
}

func (x *ComputeScheduling) Reset() {
	*x = ComputeScheduling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeScheduling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeScheduling) ProtoMessage() {}

func (x *ComputeScheduling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeScheduling.ProtoReflect.Descriptor instead.
func (*ComputeScheduling) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{61}
}

func (x *ComputeScheduling) GetOnHostMaintenance() ComputeScheduling_OnHostMaintenance {
	if x != nil {
		return x.OnHostMaintenance
	}
	return ComputeScheduling_ON_HOST_MAINTENANCE_UNSPECIFIED
}

func (x *ComputeScheduling) GetRestartType() ComputeScheduling_RestartType {
	if x != nil {
		return x.RestartType
	}
	return ComputeScheduling_RESTART_TYPE_UNSPECIFIED
}

func (x *ComputeScheduling) GetNodeAffinities() []*SchedulingNodeAffinity {
	if x != nil {
		return x.NodeAffinities
	}
	return nil
}

func (x *ComputeScheduling) GetMinNodeCpus() int32 {
	if x != nil {
		return x.MinNodeCpus
	}
	return 0
}

// A policy for scheduling replications.
type SchedulePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The idle duration between replication stages.
	IdleDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=idle_duration,json=idleDuration,proto3" json:"idle_duration,omitempty"`
	// A flag to indicate whether to skip OS adaptation during the replication
	// sync. OS adaptation is a process where the VM's operating system undergoes
	// changes and adaptations to fully function on Compute Engine.
	SkipOsAdaptation bool `protobuf:"varint,2,opt,name=skip_os_adaptation,json=skipOsAdaptation,proto3" json:"skip_os_adaptation,omitempty"`
}

func (x *SchedulePolicy) Reset() {
	*x = SchedulePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchedulePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulePolicy) ProtoMessage() {}

func (x *SchedulePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulePolicy.ProtoReflect.Descriptor instead.
func (*SchedulePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{62}
}

func (x *SchedulePolicy) GetIdleDuration() *durationpb.Duration {
	if x != nil {
		return x.IdleDuration
	}
	return nil
}

func (x *SchedulePolicy) GetSkipOsAdaptation() bool {
	if x != nil {
		return x.SkipOsAdaptation
	}
	return false
}

// Request message for 'CreateMigratingVm' request.
type CreateMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MigratingVm's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The migratingVm identifier.
	MigratingVmId string `protobuf:"bytes,2,opt,name=migrating_vm_id,json=migratingVmId,proto3" json:"migrating_vm_id,omitempty"`
	// Required. The create request body.
	MigratingVm *MigratingVm `protobuf:"bytes,3,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMigratingVmRequest) Reset() {
	*x = CreateMigratingVmRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMigratingVmRequest) ProtoMessage() {}

func (x *CreateMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*CreateMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{63}
}

func (x *CreateMigratingVmRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMigratingVmRequest) GetMigratingVmId() string {
	if x != nil {
		return x.MigratingVmId
	}
	return ""
}

func (x *CreateMigratingVmRequest) GetMigratingVm() *MigratingVm {
	if x != nil {
		return x.MigratingVm
	}
	return nil
}

func (x *CreateMigratingVmRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'LisMigratingVmsRequest' request.
type ListMigratingVmsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of MigratingVms.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of migrating VMs to return. The service may
	// return fewer than this value. If unspecified, at most 500 migrating VMs
	// will be returned. The maximum value is 1000; values above 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListMigratingVms` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListMigratingVms`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The level of details of each migrating VM.
	View MigratingVmView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.MigratingVmView" json:"view,omitempty"`
}

func (x *ListMigratingVmsRequest) Reset() {
	*x = ListMigratingVmsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMigratingVmsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigratingVmsRequest) ProtoMessage() {}

func (x *ListMigratingVmsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigratingVmsRequest.ProtoReflect.Descriptor instead.
func (*ListMigratingVmsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{64}
}

func (x *ListMigratingVmsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMigratingVmsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetView() MigratingVmView {
	if x != nil {
		return x.View
	}
	return MigratingVmView_MIGRATING_VM_VIEW_UNSPECIFIED
}

// Response message for 'ListMigratingVms' request.
type ListMigratingVmsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of Migrating VMs response.
	MigratingVms []*MigratingVm `protobuf:"bytes,1,rep,name=migrating_vms,json=migratingVms,proto3" json:"migrating_vms,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListMigratingVmsResponse) Reset() {
	*x = ListMigratingVmsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMigratingVmsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigratingVmsResponse) ProtoMessage() {}

func (x *ListMigratingVmsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigratingVmsResponse.ProtoReflect.Descriptor instead.
func (*ListMigratingVmsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{65}
}

func (x *ListMigratingVmsResponse) GetMigratingVms() []*MigratingVm {
	if x != nil {
		return x.MigratingVms
	}
	return nil
}

func (x *ListMigratingVmsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMigratingVmsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetMigratingVm' request.
type GetMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of details of the migrating VM.
	View MigratingVmView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.MigratingVmView" json:"view,omitempty"`
}

func (x *GetMigratingVmRequest) Reset() {
	*x = GetMigratingVmRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMigratingVmRequest) ProtoMessage() {}

func (x *GetMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*GetMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{66}
}

func (x *GetMigratingVmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetMigratingVmRequest) GetView() MigratingVmView {
	if x != nil {
		return x.View
	}
	return MigratingVmView_MIGRATING_VM_VIEW_UNSPECIFIED
}

// Request message for 'UpdateMigratingVm' request.
type UpdateMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// MigratingVm resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	MigratingVm *MigratingVm `protobuf:"bytes,2,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateMigratingVmRequest) Reset() {
	*x = UpdateMigratingVmRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMigratingVmRequest) ProtoMessage() {}

func (x *UpdateMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*UpdateMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{67}
}

func (x *UpdateMigratingVmRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMigratingVmRequest) GetMigratingVm() *MigratingVm {
	if x != nil {
		return x.MigratingVm
	}
	return nil
}

func (x *UpdateMigratingVmRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteMigratingVm' request.
type DeleteMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMigratingVmRequest) Reset() {
	*x = DeleteMigratingVmRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMigratingVmRequest) ProtoMessage() {}

func (x *DeleteMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*DeleteMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{68}
}

func (x *DeleteMigratingVmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'StartMigrationRequest' request.
type StartMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *StartMigrationRequest) Reset() {
	*x = StartMigrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMigrationRequest) ProtoMessage() {}

func (x *StartMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMigrationRequest.ProtoReflect.Descriptor instead.
func (*StartMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{69}
}

func (x *StartMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'StartMigration' request.
type StartMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StartMigrationResponse) Reset() {
	*x = StartMigrationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMigrationResponse) ProtoMessage() {}

func (x *StartMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMigrationResponse.ProtoReflect.Descriptor instead.
func (*StartMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{70}
}

// Request message for 'PauseMigration' request.
type PauseMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *PauseMigrationRequest) Reset() {
	*x = PauseMigrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseMigrationRequest) ProtoMessage() {}

func (x *PauseMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseMigrationRequest.ProtoReflect.Descriptor instead.
func (*PauseMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{71}
}

func (x *PauseMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'PauseMigration' request.
type PauseMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PauseMigrationResponse) Reset() {
	*x = PauseMigrationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseMigrationResponse) ProtoMessage() {}

func (x *PauseMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseMigrationResponse.ProtoReflect.Descriptor instead.
func (*PauseMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{72}
}

// Request message for 'ResumeMigration' request.
type ResumeMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *ResumeMigrationRequest) Reset() {
	*x = ResumeMigrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeMigrationRequest) ProtoMessage() {}

func (x *ResumeMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeMigrationRequest.ProtoReflect.Descriptor instead.
func (*ResumeMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{73}
}

func (x *ResumeMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'ResumeMigration' request.
type ResumeMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResumeMigrationResponse) Reset() {
	*x = ResumeMigrationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeMigrationResponse) ProtoMessage() {}

func (x *ResumeMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeMigrationResponse.ProtoReflect.Descriptor instead.
func (*ResumeMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{74}
}

// Request message for 'FinalizeMigration' request.
type FinalizeMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *FinalizeMigrationRequest) Reset() {
	*x = FinalizeMigrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeMigrationRequest) ProtoMessage() {}

func (x *FinalizeMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeMigrationRequest.ProtoReflect.Descriptor instead.
func (*FinalizeMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{75}
}

func (x *FinalizeMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'FinalizeMigration' request.
type FinalizeMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FinalizeMigrationResponse) Reset() {
	*x = FinalizeMigrationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeMigrationResponse) ProtoMessage() {}

func (x *FinalizeMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeMigrationResponse.ProtoReflect.Descriptor instead.
func (*FinalizeMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{76}
}

// TargetProject message represents a target Compute Engine project for a
// migration or a clone.
type TargetProject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the target project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The target project ID (number) or project name.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// The target project's description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time this target project resource was created (not related
	// to when the Compute Engine project it points to was created).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the target project resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *TargetProject) Reset() {
	*x = TargetProject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetProject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetProject) ProtoMessage() {}

func (x *TargetProject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetProject.ProtoReflect.Descriptor instead.
func (*TargetProject) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{77}
}

func (x *TargetProject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TargetProject) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *TargetProject) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TargetProject) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TargetProject) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for 'GetTargetProject' call.
type GetTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TargetProject name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTargetProjectRequest) Reset() {
	*x = GetTargetProjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTargetProjectRequest) ProtoMessage() {}

func (x *GetTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*GetTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{78}
}

func (x *GetTargetProjectRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ListTargetProjects' call.
type ListTargetProjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of targets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of targets to return. The service may return
	// fewer than this value. If unspecified, at most 500 targets will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListTargets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListTargets` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTargetProjectsRequest) Reset() {
	*x = ListTargetProjectsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetProjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetProjectsRequest) ProtoMessage() {}

func (x *ListTargetProjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetProjectsRequest.ProtoReflect.Descriptor instead.
func (*ListTargetProjectsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{79}
}

func (x *ListTargetProjectsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTargetProjectsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTargetProjectsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTargetProjectsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTargetProjectsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListTargetProjects' call.
type ListTargetProjectsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of target response.
	TargetProjects []*TargetProject `protobuf:"bytes,1,rep,name=target_projects,json=targetProjects,proto3" json:"target_projects,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTargetProjectsResponse) Reset() {
	*x = ListTargetProjectsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetProjectsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetProjectsResponse) ProtoMessage() {}

func (x *ListTargetProjectsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetProjectsResponse.ProtoReflect.Descriptor instead.
func (*ListTargetProjectsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{80}
}

func (x *ListTargetProjectsResponse) GetTargetProjects() []*TargetProject {
	if x != nil {
		return x.TargetProjects
	}
	return nil
}

func (x *ListTargetProjectsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTargetProjectsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'CreateTargetProject' request.
type CreateTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TargetProject's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The target_project identifier.
	TargetProjectId string `protobuf:"bytes,2,opt,name=target_project_id,json=targetProjectId,proto3" json:"target_project_id,omitempty"`
	// Required. The create request body.
	TargetProject *TargetProject `protobuf:"bytes,3,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateTargetProjectRequest) Reset() {
	*x = CreateTargetProjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetProjectRequest) ProtoMessage() {}

func (x *CreateTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*CreateTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{81}
}

func (x *CreateTargetProjectRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTargetProjectRequest) GetTargetProjectId() string {
	if x != nil {
		return x.TargetProjectId
	}
	return ""
}

func (x *CreateTargetProjectRequest) GetTargetProject() *TargetProject {
	if x != nil {
		return x.TargetProject
	}
	return nil
}

func (x *CreateTargetProjectRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Update message for 'UpdateTargetProject' request.
type UpdateTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// TargetProject resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	TargetProject *TargetProject `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateTargetProjectRequest) Reset() {
	*x = UpdateTargetProjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetProjectRequest) ProtoMessage() {}

func (x *UpdateTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*UpdateTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{82}
}

func (x *UpdateTargetProjectRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTargetProjectRequest) GetTargetProject() *TargetProject {
	if x != nil {
		return x.TargetProject
	}
	return nil
}

func (x *UpdateTargetProjectRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteTargetProject' request.
type DeleteTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TargetProject name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteTargetProjectRequest) Reset() {
	*x = DeleteTargetProjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTargetProjectRequest) ProtoMessage() {}

func (x *DeleteTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*DeleteTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{83}
}

func (x *DeleteTargetProjectRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTargetProjectRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Describes message for 'Group' resource. The Group is a collections of several
// MigratingVms.
type Group struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Group name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-provided description of the group.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Display name is a user defined name for this group which can be updated.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *Group) Reset() {
	*x = Group{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{84}
}

func (x *Group) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Group) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Group) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Group) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Group) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Request message for 'ListGroups' request.
type ListGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of groups.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of groups to return. The service may return
	// fewer than this value. If unspecified, at most 500 groups will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListGroups` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGroups` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGroupsRequest) Reset() {
	*x = ListGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsRequest) ProtoMessage() {}

func (x *ListGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{85}
}

func (x *ListGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGroupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGroupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListGroups' request.
type ListGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of groups response.
	Groups []*Group `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGroupsResponse) Reset() {
	*x = ListGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsResponse) ProtoMessage() {}

func (x *ListGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{86}
}

func (x *ListGroupsResponse) GetGroups() []*Group {
	if x != nil {
		return x.Groups
	}
	return nil
}

func (x *ListGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGroupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetGroup' request.
type GetGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The group name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGroupRequest) Reset() {
	*x = GetGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupRequest) ProtoMessage() {}

func (x *GetGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupRequest.ProtoReflect.Descriptor instead.
func (*GetGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{87}
}

func (x *GetGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateGroup' request.
type CreateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Group's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The group identifier.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Required. The create request body.
	Group *Group `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateGroupRequest) Reset() {
	*x = CreateGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupRequest) ProtoMessage() {}

func (x *CreateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{88}
}

func (x *CreateGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGroupRequest) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *CreateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *CreateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Update message for 'UpdateGroups' request.
type UpdateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// Group resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	Group *Group `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateGroupRequest) Reset() {
	*x = UpdateGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGroupRequest) ProtoMessage() {}

func (x *UpdateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{89}
}

func (x *UpdateGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *UpdateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteGroup' request.
type DeleteGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Group name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteGroupRequest) Reset() {
	*x = DeleteGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGroupRequest) ProtoMessage() {}

func (x *DeleteGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{90}
}

func (x *DeleteGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'AddGroupMigration' request.
type AddGroupMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full path name of the Group to add to.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// The full path name of the MigratingVm to add.
	MigratingVm string `protobuf:"bytes,2,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *AddGroupMigrationRequest) Reset() {
	*x = AddGroupMigrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddGroupMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddGroupMigrationRequest) ProtoMessage() {}

func (x *AddGroupMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddGroupMigrationRequest.ProtoReflect.Descriptor instead.
func (*AddGroupMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{91}
}

func (x *AddGroupMigrationRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *AddGroupMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'AddGroupMigration' request.
type AddGroupMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddGroupMigrationResponse) Reset() {
	*x = AddGroupMigrationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddGroupMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddGroupMigrationResponse) ProtoMessage() {}

func (x *AddGroupMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddGroupMigrationResponse.ProtoReflect.Descriptor instead.
func (*AddGroupMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{92}
}

// Request message for 'RemoveMigration' request.
type RemoveGroupMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Group.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// The MigratingVm to remove.
	MigratingVm string `protobuf:"bytes,2,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *RemoveGroupMigrationRequest) Reset() {
	*x = RemoveGroupMigrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveGroupMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveGroupMigrationRequest) ProtoMessage() {}

func (x *RemoveGroupMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveGroupMigrationRequest.ProtoReflect.Descriptor instead.
func (*RemoveGroupMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{93}
}

func (x *RemoveGroupMigrationRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *RemoveGroupMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'RemoveMigration' request.
type RemoveGroupMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveGroupMigrationResponse) Reset() {
	*x = RemoveGroupMigrationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveGroupMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveGroupMigrationResponse) ProtoMessage() {}

func (x *RemoveGroupMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveGroupMigrationResponse.ProtoReflect.Descriptor instead.
func (*RemoveGroupMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{94}
}

// Request message for 'CreateCutoverJob' request.
type CreateCutoverJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cutover's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The cutover job identifier.
	CutoverJobId string `protobuf:"bytes,2,opt,name=cutover_job_id,json=cutoverJobId,proto3" json:"cutover_job_id,omitempty"`
	// Required. The cutover request body.
	CutoverJob *CutoverJob `protobuf:"bytes,3,opt,name=cutover_job,json=cutoverJob,proto3" json:"cutover_job,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateCutoverJobRequest) Reset() {
	*x = CreateCutoverJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCutoverJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCutoverJobRequest) ProtoMessage() {}

func (x *CreateCutoverJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCutoverJobRequest.ProtoReflect.Descriptor instead.
func (*CreateCutoverJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{95}
}

func (x *CreateCutoverJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCutoverJobRequest) GetCutoverJobId() string {
	if x != nil {
		return x.CutoverJobId
	}
	return ""
}

func (x *CreateCutoverJobRequest) GetCutoverJob() *CutoverJob {
	if x != nil {
		return x.CutoverJob
	}
	return nil
}

func (x *CreateCutoverJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'CancelCutoverJob' request.
type CancelCutoverJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The cutover job id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelCutoverJobRequest) Reset() {
	*x = CancelCutoverJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelCutoverJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCutoverJobRequest) ProtoMessage() {}

func (x *CancelCutoverJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCutoverJobRequest.ProtoReflect.Descriptor instead.
func (*CancelCutoverJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{96}
}

func (x *CancelCutoverJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'CancelCutoverJob' request.
type CancelCutoverJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelCutoverJobResponse) Reset() {
	*x = CancelCutoverJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelCutoverJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCutoverJobResponse) ProtoMessage() {}

func (x *CancelCutoverJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCutoverJobResponse.ProtoReflect.Descriptor instead.
func (*CancelCutoverJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{97}
}

// Request message for 'ListCutoverJobsRequest' request.
type ListCutoverJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of migrating VMs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of cutover jobs to return. The service may
	// return fewer than this value. If unspecified, at most 500 cutover jobs will
	// be returned. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListCutoverJobs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCutoverJobs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCutoverJobsRequest) Reset() {
	*x = ListCutoverJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCutoverJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCutoverJobsRequest) ProtoMessage() {}

func (x *ListCutoverJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCutoverJobsRequest.ProtoReflect.Descriptor instead.
func (*ListCutoverJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{98}
}

func (x *ListCutoverJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCutoverJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCutoverJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCutoverJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCutoverJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListCutoverJobs' request.
type ListCutoverJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of cutover jobs response.
	CutoverJobs []*CutoverJob `protobuf:"bytes,1,rep,name=cutover_jobs,json=cutoverJobs,proto3" json:"cutover_jobs,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCutoverJobsResponse) Reset() {
	*x = ListCutoverJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCutoverJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCutoverJobsResponse) ProtoMessage() {}

func (x *ListCutoverJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCutoverJobsResponse.ProtoReflect.Descriptor instead.
func (*ListCutoverJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{99}
}

func (x *ListCutoverJobsResponse) GetCutoverJobs() []*CutoverJob {
	if x != nil {
		return x.CutoverJobs
	}
	return nil
}

func (x *ListCutoverJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCutoverJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetCutoverJob' request.
type GetCutoverJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CutoverJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCutoverJobRequest) Reset() {
	*x = GetCutoverJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCutoverJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCutoverJobRequest) ProtoMessage() {}

func (x *GetCutoverJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCutoverJobRequest.ProtoReflect.Descriptor instead.
func (*GetCutoverJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{100}
}

func (x *GetCutoverJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{101}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Represents migration resource error information that can be used with
// google.rpc.Status message. MigrationError is used to present the user with
// error information in migration operations.
type MigrationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error code.
	Code MigrationError_ErrorCode `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.vmmigration.v1.MigrationError_ErrorCode" json:"code,omitempty"`
	// Output only. The localized error message.
	ErrorMessage *errdetails.LocalizedMessage `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Output only. Suggested action for solving the error.
	ActionItem *errdetails.LocalizedMessage `protobuf:"bytes,3,opt,name=action_item,json=actionItem,proto3" json:"action_item,omitempty"`
	// Output only. URL(s) pointing to additional information on handling the
	// current error.
	HelpLinks []*errdetails.Help_Link `protobuf:"bytes,4,rep,name=help_links,json=helpLinks,proto3" json:"help_links,omitempty"`
	// Output only. The time the error occurred.
	ErrorTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=error_time,json=errorTime,proto3" json:"error_time,omitempty"`
}

func (x *MigrationError) Reset() {
	*x = MigrationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationError) ProtoMessage() {}

func (x *MigrationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationError.ProtoReflect.Descriptor instead.
func (*MigrationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{102}
}

func (x *MigrationError) GetCode() MigrationError_ErrorCode {
	if x != nil {
		return x.Code
	}
	return MigrationError_ERROR_CODE_UNSPECIFIED
}

func (x *MigrationError) GetErrorMessage() *errdetails.LocalizedMessage {
	if x != nil {
		return x.ErrorMessage
	}
	return nil
}

func (x *MigrationError) GetActionItem() *errdetails.LocalizedMessage {
	if x != nil {
		return x.ActionItem
	}
	return nil
}

func (x *MigrationError) GetHelpLinks() []*errdetails.Help_Link {
	if x != nil {
		return x.HelpLinks
	}
	return nil
}

func (x *MigrationError) GetErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ErrorTime
	}
	return nil
}

// Represent the source AWS VM details.
type AwsSourceVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The firmware type of the source VM.
	Firmware AwsSourceVmDetails_Firmware `protobuf:"varint,1,opt,name=firmware,proto3,enum=google.cloud.vmmigration.v1.AwsSourceVmDetails_Firmware" json:"firmware,omitempty"`
	// The total size of the disks being migrated in bytes.
	CommittedStorageBytes int64 `protobuf:"varint,2,opt,name=committed_storage_bytes,json=committedStorageBytes,proto3" json:"committed_storage_bytes,omitempty"`
}

func (x *AwsSourceVmDetails) Reset() {
	*x = AwsSourceVmDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsSourceVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceVmDetails) ProtoMessage() {}

func (x *AwsSourceVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceVmDetails.ProtoReflect.Descriptor instead.
func (*AwsSourceVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{103}
}

func (x *AwsSourceVmDetails) GetFirmware() AwsSourceVmDetails_Firmware {
	if x != nil {
		return x.Firmware
	}
	return AwsSourceVmDetails_FIRMWARE_UNSPECIFIED
}

func (x *AwsSourceVmDetails) GetCommittedStorageBytes() int64 {
	if x != nil {
		return x.CommittedStorageBytes
	}
	return 0
}

// Request message for 'LisReplicationCyclesRequest' request.
type ListReplicationCyclesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of ReplicationCycles.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of replication cycles to return. The service
	// may return fewer than this value. If unspecified, at most 100 migrating VMs
	// will be returned. The maximum value is 100; values above 100 will be
	// coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListReplicationCycles`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListReplicationCycles`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReplicationCyclesRequest) Reset() {
	*x = ListReplicationCyclesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReplicationCyclesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplicationCyclesRequest) ProtoMessage() {}

func (x *ListReplicationCyclesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplicationCyclesRequest.ProtoReflect.Descriptor instead.
func (*ListReplicationCyclesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{104}
}

func (x *ListReplicationCyclesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReplicationCyclesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReplicationCyclesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReplicationCyclesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReplicationCyclesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListReplicationCycles' request.
type ListReplicationCyclesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of replication cycles response.
	ReplicationCycles []*ReplicationCycle `protobuf:"bytes,1,rep,name=replication_cycles,json=replicationCycles,proto3" json:"replication_cycles,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReplicationCyclesResponse) Reset() {
	*x = ListReplicationCyclesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReplicationCyclesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplicationCyclesResponse) ProtoMessage() {}

func (x *ListReplicationCyclesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplicationCyclesResponse.ProtoReflect.Descriptor instead.
func (*ListReplicationCyclesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{105}
}

func (x *ListReplicationCyclesResponse) GetReplicationCycles() []*ReplicationCycle {
	if x != nil {
		return x.ReplicationCycles
	}
	return nil
}

func (x *ListReplicationCyclesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReplicationCyclesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetReplicationCycle' request.
type GetReplicationCycleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ReplicationCycle.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReplicationCycleRequest) Reset() {
	*x = GetReplicationCycleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReplicationCycleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReplicationCycleRequest) ProtoMessage() {}

func (x *GetReplicationCycleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReplicationCycleRequest.ProtoReflect.Descriptor instead.
func (*GetReplicationCycleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{106}
}

func (x *GetReplicationCycleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message describing AWS Credentials using access key id and secret.
type AwsSourceDetails_AccessKeyCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AWS access key ID.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// Input only. AWS secret access key.
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
}

func (x *AwsSourceDetails_AccessKeyCredentials) Reset() {
	*x = AwsSourceDetails_AccessKeyCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsSourceDetails_AccessKeyCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDetails_AccessKeyCredentials) ProtoMessage() {}

func (x *AwsSourceDetails_AccessKeyCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDetails_AccessKeyCredentials.ProtoReflect.Descriptor instead.
func (*AwsSourceDetails_AccessKeyCredentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{23, 0}
}

func (x *AwsSourceDetails_AccessKeyCredentials) GetAccessKeyId() string {
	if x != nil {
		return x.AccessKeyId
	}
	return ""
}

func (x *AwsSourceDetails_AccessKeyCredentials) GetSecretAccessKey() string {
	if x != nil {
		return x.SecretAccessKey
	}
	return ""
}

// Tag is an AWS tag representation.
type AwsSourceDetails_Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of tag.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of tag.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AwsSourceDetails_Tag) Reset() {
	*x = AwsSourceDetails_Tag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsSourceDetails_Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDetails_Tag) ProtoMessage() {}

func (x *AwsSourceDetails_Tag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDetails_Tag.ProtoReflect.Descriptor instead.
func (*AwsSourceDetails_Tag) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{23, 1}
}

func (x *AwsSourceDetails_Tag) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AwsSourceDetails_Tag) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_vmmigration_v1_vmmigration_proto protoreflect.FileDescriptor

var file_google_cloud_vmmigration_v1_vmmigration_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xee, 0x05, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0b, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b,
	0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61,
	0x75, 0x73, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x10, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x05, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x65,
	0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x52, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41,
	0x55, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x04, 0x3a, 0xad, 0x01, 0xea, 0x41, 0xa9, 0x01, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x7b, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x7d, 0x22, 0xaa, 0x03, 0x0a, 0x09, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12,
	0x75, 0x0a, 0x18, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x17, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x65, 0x70, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x22, 0x1d,
	0x0a, 0x1b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x22, 0x93, 0x02,
	0x0a, 0x0f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65,
	0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x56, 0x0a,
	0x29, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x77, 0x6f, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65,
	0x73, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x23, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x77, 0x6f, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73,
	0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12, 0x5c, 0x0a, 0x2c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x68,
	0x69, 0x72, 0x74, 0x79, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x26, 0x6c, 0x61, 0x73,
	0x74, 0x54, 0x68, 0x69, 0x72, 0x74, 0x79, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x41, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x22, 0x14, 0x0a, 0x12, 0x50, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x22, 0x53, 0x0a, 0x0f, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x40, 0x0a, 0x0e,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x94,
	0x0d, 0x0a, 0x0b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x7f,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x48, 0x00, 0x52, 0x1b, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x69, 0x0a, 0x15, 0x61, 0x77, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x12, 0x61, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x6d, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x09, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x79, 0x6e, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x53,
	0x79, 0x6e, 0x63, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3e,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5e,
	0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3e,
	0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4c,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x11,
	0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62,
	0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x5c, 0x0a, 0x13, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb7, 0x01, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x53,
	0x59, 0x4e, 0x43, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x04, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x55, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x56, 0x45,
	0x52, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x55, 0x54, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x08,
	0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x10, 0x09,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a,
	0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x0b, 0x12, 0x0d, 0x0a, 0x09,
	0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x0c, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x0d, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x26, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x6d, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d, 0x42, 0x14, 0x0a, 0x12, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x42, 0x13, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xd1, 0x06, 0x0a, 0x08, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x12, 0x81, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1a, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x17, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x41,
	0x44, 0x41, 0x50, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x53, 0x10, 0x07, 0x3a, 0x95, 0x01, 0xea,
	0x41, 0x91, 0x01, 0x0a, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f,
	0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d, 0x2f, 0x63,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f,
	0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x76,
	0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xb0, 0x03, 0x0a, 0x09, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12, 0x4e, 0x0a, 0x0b, 0x61, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x6e, 0x67, 0x4f, 0x53, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x73, 0x12, 0x61, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x70, 0x61,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x4d, 0x44, 0x69, 0x73,
	0x6b, 0x73, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x10, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x76, 0x0a, 0x19, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x56, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x22, 0x10, 0x0a, 0x0e,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x53, 0x53, 0x74, 0x65, 0x70, 0x22, 0x16,
	0x0a, 0x14, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x4d, 0x44, 0x69, 0x73,
	0x6b, 0x73, 0x53, 0x74, 0x65, 0x70, 0x22, 0x1d, 0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56,
	0x4d, 0x53, 0x74, 0x65, 0x70, 0x22, 0xb7, 0x07, 0x0a, 0x0a, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x12, 0x81, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1a, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x41,
	0x44, 0x41, 0x50, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x53, 0x10, 0x07, 0x3a, 0x9b, 0x01, 0xea,
	0x41, 0x97, 0x01, 0x0a, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x6e, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d,
	0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22,
	0x91, 0x05, 0x0a, 0x0b, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x12,
	0x6d, 0x0a, 0x1a, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x18, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x6e,
	0x0a, 0x17, 0x73, 0x68, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68,
	0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x6f, 0x77, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x14, 0x73, 0x68, 0x75, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x44, 0x6f, 0x77, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x12, 0x4e,
	0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x61,
	0x0a, 0x12, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x5f, 0x64,
	0x69, 0x73, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x4d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52,
	0x10, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x44, 0x69, 0x73, 0x6b,
	0x73, 0x12, 0x76, 0x0a, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x6d, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00,
	0x52, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x73,
	0x74, 0x65, 0x70, 0x22, 0x1a, 0x0a, 0x18, 0x53, 0x68, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x44,
	0x6f, 0x77, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x22,
	0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x12, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x25,
	0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a,
	0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x58, 0x0a,
	0x15, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x18, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xde, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x12, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xb6, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a,
	0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x55, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xce, 0x04, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a,
	0x06, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x06, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x41, 0x0a, 0x03, 0x61, 0x77, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x03, 0x61, 0x77, 0x73, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x60, 0xea, 0x41, 0x5d, 0x0a, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x7d, 0x42, 0x10, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x22, 0x91, 0x01, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x70, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x68, 0x75, 0x6d, 0x62,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x68, 0x75,
	0x6d, 0x62, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0xc4, 0x07, 0x0a, 0x10, 0x41, 0x77, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6e, 0x0a, 0x10,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0a,
	0x61, 0x77, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x61, 0x77, 0x73, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x5f, 0x0a, 0x12, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x67,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x10,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x54, 0x61, 0x67, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x1e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1b, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x1d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x55,
	0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x1a, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x55, 0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x1a, 0x6b, 0x0a, 0x14, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x1a, 0x2d, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x4d, 0x0a, 0x1f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x43, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x42, 0x12, 0x0a, 0x10, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xbe,
	0x08, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x4d, 0x0a, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x1e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x1a, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x56, 0x0a, 0x0e, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x22, 0x50, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x4f, 0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x04, 0x3a, 0x9a, 0x01, 0xea, 0x41, 0x96, 0x01, 0x0a, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x7d, 0x22,
	0xc9, 0x02, 0x0a, 0x0d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x6f, 0x75, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0xd2, 0x01, 0x0a, 0x10,
	0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x12, 0x67, 0x0a, 0x18, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x16, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x61, 0x62, 0x6c, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x69, 0x6e, 0x5f,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x69, 0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x22, 0x86, 0x01, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x2a, 0x0a,
	0x11, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x55, 0x72, 0x69, 0x22, 0xda, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xad, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42,
	0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb3, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x40, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x78, 0x0a,
	0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7f, 0x0a, 0x15, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66,
	0x72, 0x65, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x22, 0xb3, 0x05, 0x0a, 0x0f, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x13, 0x0a, 0x05,
	0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x6d, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x75, 0x69,
	0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0b, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0a, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x64, 0x69,
	0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x62, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x62, 0x12, 0x2b, 0x0a, 0x11, 0x67, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x67, 0x75, 0x65, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x62, 0x6f, 0x6f, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x22, 0x3c, 0x0a, 0x0a, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b,
	0x0a, 0x17, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45,
	0x46, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0xc4,
	0x0a, 0x0a, 0x0c, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x13, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x76, 0x6d, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0b, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x64,
	0x69, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x62,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x62, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x73,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6f, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x55, 0x0a, 0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x62, 0x6f,
	0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a,
	0x06, 0x76, 0x70, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x70, 0x63, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x47, 0x0a, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x6f, 0x0a, 0x13, 0x76, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x2e, 0x56, 0x6d, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x56, 0x6d, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x56, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0x3c, 0x0a, 0x0a, 0x42, 0x6f, 0x6f,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x4f, 0x4f, 0x54, 0x5f,
	0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0x58, 0x0a, 0x14, 0x56, 0x6d, 0x56, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x26, 0x0a, 0x22, 0x56, 0x4d, 0x5f, 0x56, 0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x48, 0x56, 0x4d, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x41, 0x52, 0x41, 0x56, 0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x10,
	0x02, 0x22, 0x62, 0x0a, 0x0e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54,
	0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x33, 0x38, 0x36, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x58, 0x38, 0x36, 0x5f, 0x36, 0x34, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52,
	0x4d, 0x36, 0x34, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x58, 0x38, 0x36, 0x5f, 0x36, 0x34, 0x5f,
	0x4d, 0x41, 0x43, 0x10, 0x04, 0x22, 0x36, 0x0a, 0x10, 0x41, 0x77, 0x73, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5a, 0x0a,
	0x10, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x46, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x54, 0x0a, 0x0d, 0x41, 0x77, 0x73,
	0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22,
	0xfe, 0x01, 0x0a, 0x16, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52,
	0x09, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x12, 0x45, 0x0a, 0x07, 0x61, 0x77,
	0x73, 0x5f, 0x76, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x73,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x06, 0x61, 0x77, 0x73, 0x56, 0x6d,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x73,
	0x22, 0xfb, 0x06, 0x0a, 0x11, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a,
	0x0e, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x45, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x6d, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x03, 0x76, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x6d, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x03, 0x76, 0x6d, 0x73, 0x22, 0x47, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x22,
	0x46, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x16,
	0x54, 0x49, 0x4d, 0x45, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x45, 0x45, 0x4b,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x59, 0x45, 0x41, 0x52, 0x10, 0x03, 0x3a, 0x94, 0x01, 0xea, 0x41, 0x90, 0x01, 0x0a, 0x2c,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x60, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x75, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x7d, 0x22, 0xe6,
	0x01, 0x0a, 0x11, 0x56, 0x6d, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5a, 0x0a, 0x11, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76,
	0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52,
	0x0f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x13, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x76, 0x6d, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0b, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0b, 0x75,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x56, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xc4, 0x03, 0x0a, 0x14, 0x56, 0x6d, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x70, 0x75, 0x4d, 0x61,
	0x78, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x70, 0x75, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x70, 0x75, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x61, 0x78, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x41, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x15,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6f, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x64, 0x69, 0x73,
	0x6b, 0x49, 0x6f, 0x52, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x78, 0x4b, 0x62, 0x70, 0x73, 0x12, 0x38,
	0x0a, 0x19, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6f, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x6f, 0x52, 0x61, 0x74, 0x65, 0x41, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x4b, 0x62, 0x70, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x5f, 0x6d,
	0x61, 0x78, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74,
	0x4d, 0x61, 0x78, 0x4b, 0x62, 0x70, 0x73, 0x12, 0x45, 0x0a, 0x1f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x1c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68,
	0x70, 0x75, 0x74, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4b, 0x62, 0x70, 0x73, 0x22, 0xbd,
	0x02, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b,
	0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xda,
	0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x64, 0x0a, 0x13, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2e, 0x0a, 0x2c, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x22, 0xaa, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x75, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x75, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x8e, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xe2, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a, 0x0a, 0x15, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6b, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8d, 0x01,
	0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xa3, 0x01,
	0x0a, 0x17, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x14, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x13, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xf4, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x86, 0x0a, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x54, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12,
	0x5c, 0x0a, 0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64,
	0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x5a, 0x0a, 0x0b, 0x62, 0x6f,
	0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x62, 0x6f, 0x6f, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xbd, 0x09, 0x0a, 0x1a, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x17,
	0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x76, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x5c, 0x0a, 0x12, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x58, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x12, 0x5d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x11, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74,
	0x12, 0x55, 0x0a, 0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x62, 0x6f, 0x6f,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x8e, 0x01, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e,
	0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1f,
	0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12,
	0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70,
	0x22, 0xb1, 0x01, 0x0a, 0x0e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x73, 0x5f,
	0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f,
	0x73, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x50, 0x41, 0x59, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x59,
	0x4f, 0x4c, 0x10, 0x03, 0x22, 0xd6, 0x01, 0x0a, 0x16, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x58, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x22, 0x38, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12,
	0x18, 0x0a, 0x14, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x10, 0x02, 0x22, 0x9a, 0x04,
	0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x70, 0x0a, 0x13, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x11, 0x6f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63,
	0x70, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x70, 0x75, 0x73, 0x22, 0x54, 0x0a, 0x11, 0x4f, 0x6e, 0x48, 0x6f, 0x73, 0x74,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4f,
	0x4e, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22, 0x5c, 0x0a, 0x0b,
	0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52,
	0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x55, 0x54,
	0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x01,
	0x12, 0x18, 0x0a, 0x14, 0x4e, 0x4f, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43,
	0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x02, 0x22, 0x7e, 0x0a, 0x0e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x0a, 0x0d,
	0x69, 0x64, 0x6c, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x69, 0x64, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12,
	0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6f, 0x73, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x4f, 0x73,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x02, 0x0a, 0x18, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12,
	0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x2b, 0x0a, 0x0f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0c,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xab, 0x02,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x12, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x45, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc2, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0x2b, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xa2, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45,
	0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc8, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x50, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x5e, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x6a, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52,
	0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x18, 0x0a, 0x16,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0x0a, 0x15, 0x50, 0x61, 0x75, 0x73, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x22, 0x18, 0x0a, 0x16, 0x50, 0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b, 0x0a, 0x16,
	0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x19, 0x0a, 0x17, 0x52, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6d, 0x0a, 0x18, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x22, 0x1b, 0x0a, 0x19, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xe0, 0x02, 0x0a, 0x0d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x76, 0xea, 0x41, 0x73,
	0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x22, 0x5f, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xca, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58,
	0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x8e, 0x02, 0x0a,
	0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x12, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd0, 0x01,
	0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x56, 0x0a, 0x0e, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x86, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc8, 0x02, 0x0a, 0x05, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x5d, 0xea, 0x41, 0x5a, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x36, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x7d, 0x22, 0xd8, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x12, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xa9, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x4f, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a,
	0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xaf, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x76, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xaa, 0x01,
	0x0a, 0x18, 0x41, 0x64, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4e, 0x0a, 0x0c, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x1b, 0x0a, 0x19, 0x41, 0x64,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xad, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4e, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x1e, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72,
	0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x5c, 0x0a, 0x17, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x1a, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe2, 0x01,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x12, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xbe, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f,
	0x0a, 0x0c, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12,
	0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x59, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5,
	0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf5, 0x04, 0x0a, 0x0e, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4e, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x46, 0x0a, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x42, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x68, 0x65, 0x6c, 0x70, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x48, 0x65, 0x6c, 0x70, 0x2e, 0x4c, 0x69, 0x6e, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x68, 0x65, 0x6c, 0x70, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x3e, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x8b, 0x02, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x1b, 0x0a,
	0x17, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x41, 0x52, 0x47,
	0x45, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x53, 0x5f, 0x41, 0x44, 0x41,
	0x50, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12,
	0x0f, 0x0a, 0x0b, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x55, 0x54, 0x4f, 0x56, 0x45, 0x52, 0x5f, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x54, 0x49, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x08, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55,
	0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x09, 0x22, 0xdb,
	0x01, 0x0a, 0x12, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x54, 0x0a, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x52, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x22, 0x37, 0x0a, 0x08, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12,
	0x18, 0x0a, 0x14, 0x46, 0x49, 0x52, 0x4d, 0x57, 0x41, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0xee, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63,
	0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd6, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x61, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x2a, 0x55, 0x0a,
	0x15, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x27, 0x0a, 0x23, 0x55, 0x54, 0x49, 0x4c, 0x49, 0x5a,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x56, 0x49, 0x45,
	0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55,
	0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x6d, 0x0a, 0x0f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x12, 0x21, 0x0a, 0x1d, 0x4d, 0x49, 0x47, 0x52, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x4d, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x49,
	0x47, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x4d, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x49, 0x47, 0x52, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x4d, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c,
	0x4c, 0x10, 0x02, 0x2a, 0xb1, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a,
	0x24, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f,
	0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d, 0x50, 0x55,
	0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x20,
	0x0a, 0x1c, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45,
	0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x02,
	0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49,
	0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x41, 0x4c,
	0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x8f, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f,
	0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x24, 0x0a,
	0x20, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f,
	0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x41, 0x59,
	0x47, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45,
	0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x42, 0x59, 0x4f, 0x4c, 0x10, 0x02, 0x2a, 0x8e, 0x01, 0x0a, 0x17, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45,
	0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47,
	0x49, 0x4e, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45,
	0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x32, 0x89, 0x53, 0x0a, 0x0b, 0x56,
	0x6d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xae, 0x01, 0x0a, 0x0b, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x09,
	0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x3a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x1b,
	0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x0c, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x0e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4d, 0xda, 0x41, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0xe4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x51, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xd1, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x02, 0x0a, 0x17, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb7, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x75, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xf3, 0x01, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x2a, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x12, 0xd9, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbd, 0x02,
	0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0xca, 0x41, 0x28, 0x0a,
	0x13, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5a, 0x3a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xf9, 0x01,
	0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x88, 0x02, 0x0a, 0x10, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0xca, 0x41, 0x2d, 0x0a, 0x18, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x3a, 0x01, 0x2a, 0x22,
	0x63, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x85, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x99, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x2c, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4a, 0x3a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d,
	0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0xcc, 0x01, 0x0a,
	0x10, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12,
	0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x49, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x87, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x0c, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca,
	0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xff, 0x01, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41,
	0x2b, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xf4, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x75,
	0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8c, 0x01, 0xca, 0x41, 0x2c, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xf0,
	0x01, 0x0a, 0x0e, 0x50, 0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x50, 0x61, 0x75, 0x73,
	0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76,
	0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x70, 0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x8b, 0x02, 0x0a, 0x11, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01,
	0xca, 0x41, 0x2e, 0x0a, 0x19, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x3a, 0x01, 0x2a, 0x22, 0x54, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0xff, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x43, 0x6c, 0x6f,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x63, 0x6c, 0x6f, 0x6e,
	0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x09,
	0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x73, 0x12, 0xf3, 0x01, 0x0a, 0x0e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xcf, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x57, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xbc, 0x01, 0x0a, 0x0b, 0x47, 0x65,
	0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48,
	0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8d, 0x02, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa3, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x63, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x57, 0x3a, 0x0b, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x48,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xfb, 0x01, 0x0a, 0x10, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41, 0x2d, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x54, 0x3a, 0x01, 0x2a, 0x22, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xd7, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0xc4, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x22, 0x57,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0x97, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcd,
	0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e,
	0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x15,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xcf,
	0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70,
	0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x11,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x30,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xc5, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x66, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xed, 0x01, 0x0a, 0x11, 0x41, 0x64, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0xca, 0x41, 0x2e, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xf9, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x31,
	0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a,
	0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0xca, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x12, 0xb7, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x89, 0x02, 0x0a, 0x13,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41,
	0x22, 0x0a, 0x0d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2c, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x3a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x8b, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x53, 0x3a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xef, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x22, 0x5d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd5, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x56, 0x6d, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x70, 0x62, 0x3b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70,
	0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x56, 0x4d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56,
	0x4d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56,
	0x4d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescOnce sync.Once
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData = file_google_cloud_vmmigration_v1_vmmigration_proto_rawDesc
)

func file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP() []byte {
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescOnce.Do(func() {
		file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData)
	})
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData
}

var file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes = make([]protoimpl.EnumInfo, 26)
var file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes = make([]protoimpl.MessageInfo, 117)
var file_google_cloud_vmmigration_v1_vmmigration_proto_goTypes = []interface{}{
	(UtilizationReportView)(0),                    // 0: google.cloud.vmmigration.v1.UtilizationReportView
	(MigratingVmView)(0),                          // 1: google.cloud.vmmigration.v1.MigratingVmView
	(ComputeEngineDiskType)(0),                    // 2: google.cloud.vmmigration.v1.ComputeEngineDiskType
	(ComputeEngineLicenseType)(0),                 // 3: google.cloud.vmmigration.v1.ComputeEngineLicenseType
	(ComputeEngineBootOption)(0),                  // 4: google.cloud.vmmigration.v1.ComputeEngineBootOption
	(ReplicationCycle_State)(0),                   // 5: google.cloud.vmmigration.v1.ReplicationCycle.State
	(MigratingVm_State)(0),                        // 6: google.cloud.vmmigration.v1.MigratingVm.State
	(CloneJob_State)(0),                           // 7: google.cloud.vmmigration.v1.CloneJob.State
	(CutoverJob_State)(0),                         // 8: google.cloud.vmmigration.v1.CutoverJob.State
	(AwsSourceDetails_State)(0),                   // 9: google.cloud.vmmigration.v1.AwsSourceDetails.State
	(DatacenterConnector_State)(0),                // 10: google.cloud.vmmigration.v1.DatacenterConnector.State
	(UpgradeStatus_State)(0),                      // 11: google.cloud.vmmigration.v1.UpgradeStatus.State
	(VmwareVmDetails_PowerState)(0),               // 12: google.cloud.vmmigration.v1.VmwareVmDetails.PowerState
	(VmwareVmDetails_BootOption)(0),               // 13: google.cloud.vmmigration.v1.VmwareVmDetails.BootOption
	(AwsVmDetails_PowerState)(0),                  // 14: google.cloud.vmmigration.v1.AwsVmDetails.PowerState
	(AwsVmDetails_BootOption)(0),                  // 15: google.cloud.vmmigration.v1.AwsVmDetails.BootOption
	(AwsVmDetails_VmVirtualizationType)(0),        // 16: google.cloud.vmmigration.v1.AwsVmDetails.VmVirtualizationType
	(AwsVmDetails_VmArchitecture)(0),              // 17: google.cloud.vmmigration.v1.AwsVmDetails.VmArchitecture
	(UtilizationReport_State)(0),                  // 18: google.cloud.vmmigration.v1.UtilizationReport.State
	(UtilizationReport_TimeFrame)(0),              // 19: google.cloud.vmmigration.v1.UtilizationReport.TimeFrame
	(AppliedLicense_Type)(0),                      // 20: google.cloud.vmmigration.v1.AppliedLicense.Type
	(SchedulingNodeAffinity_Operator)(0),          // 21: google.cloud.vmmigration.v1.SchedulingNodeAffinity.Operator
	(ComputeScheduling_OnHostMaintenance)(0),      // 22: google.cloud.vmmigration.v1.ComputeScheduling.OnHostMaintenance
	(ComputeScheduling_RestartType)(0),            // 23: google.cloud.vmmigration.v1.ComputeScheduling.RestartType
	(MigrationError_ErrorCode)(0),                 // 24: google.cloud.vmmigration.v1.MigrationError.ErrorCode
	(AwsSourceVmDetails_Firmware)(0),              // 25: google.cloud.vmmigration.v1.AwsSourceVmDetails.Firmware
	(*ReplicationCycle)(nil),                      // 26: google.cloud.vmmigration.v1.ReplicationCycle
	(*CycleStep)(nil),                             // 27: google.cloud.vmmigration.v1.CycleStep
	(*InitializingReplicationStep)(nil),           // 28: google.cloud.vmmigration.v1.InitializingReplicationStep
	(*ReplicatingStep)(nil),                       // 29: google.cloud.vmmigration.v1.ReplicatingStep
	(*PostProcessingStep)(nil),                    // 30: google.cloud.vmmigration.v1.PostProcessingStep
	(*ReplicationSync)(nil),                       // 31: google.cloud.vmmigration.v1.ReplicationSync
	(*MigratingVm)(nil),                           // 32: google.cloud.vmmigration.v1.MigratingVm
	(*CloneJob)(nil),                              // 33: google.cloud.vmmigration.v1.CloneJob
	(*CloneStep)(nil),                             // 34: google.cloud.vmmigration.v1.CloneStep
	(*AdaptingOSStep)(nil),                        // 35: google.cloud.vmmigration.v1.AdaptingOSStep
	(*PreparingVMDisksStep)(nil),                  // 36: google.cloud.vmmigration.v1.PreparingVMDisksStep
	(*InstantiatingMigratedVMStep)(nil),           // 37: google.cloud.vmmigration.v1.InstantiatingMigratedVMStep
	(*CutoverJob)(nil),                            // 38: google.cloud.vmmigration.v1.CutoverJob
	(*CutoverStep)(nil),                           // 39: google.cloud.vmmigration.v1.CutoverStep
	(*ShuttingDownSourceVMStep)(nil),              // 40: google.cloud.vmmigration.v1.ShuttingDownSourceVMStep
	(*CreateCloneJobRequest)(nil),                 // 41: google.cloud.vmmigration.v1.CreateCloneJobRequest
	(*CancelCloneJobRequest)(nil),                 // 42: google.cloud.vmmigration.v1.CancelCloneJobRequest
	(*CancelCloneJobResponse)(nil),                // 43: google.cloud.vmmigration.v1.CancelCloneJobResponse
	(*ListCloneJobsRequest)(nil),                  // 44: google.cloud.vmmigration.v1.ListCloneJobsRequest
	(*ListCloneJobsResponse)(nil),                 // 45: google.cloud.vmmigration.v1.ListCloneJobsResponse
	(*GetCloneJobRequest)(nil),                    // 46: google.cloud.vmmigration.v1.GetCloneJobRequest
	(*Source)(nil),                                // 47: google.cloud.vmmigration.v1.Source
	(*VmwareSourceDetails)(nil),                   // 48: google.cloud.vmmigration.v1.VmwareSourceDetails
	(*AwsSourceDetails)(nil),                      // 49: google.cloud.vmmigration.v1.AwsSourceDetails
	(*DatacenterConnector)(nil),                   // 50: google.cloud.vmmigration.v1.DatacenterConnector
	(*UpgradeStatus)(nil),                         // 51: google.cloud.vmmigration.v1.UpgradeStatus
	(*AvailableUpdates)(nil),                      // 52: google.cloud.vmmigration.v1.AvailableUpdates
	(*ApplianceVersion)(nil),                      // 53: google.cloud.vmmigration.v1.ApplianceVersion
	(*ListSourcesRequest)(nil),                    // 54: google.cloud.vmmigration.v1.ListSourcesRequest
	(*ListSourcesResponse)(nil),                   // 55: google.cloud.vmmigration.v1.ListSourcesResponse
	(*GetSourceRequest)(nil),                      // 56: google.cloud.vmmigration.v1.GetSourceRequest
	(*CreateSourceRequest)(nil),                   // 57: google.cloud.vmmigration.v1.CreateSourceRequest
	(*UpdateSourceRequest)(nil),                   // 58: google.cloud.vmmigration.v1.UpdateSourceRequest
	(*DeleteSourceRequest)(nil),                   // 59: google.cloud.vmmigration.v1.DeleteSourceRequest
	(*FetchInventoryRequest)(nil),                 // 60: google.cloud.vmmigration.v1.FetchInventoryRequest
	(*VmwareVmDetails)(nil),                       // 61: google.cloud.vmmigration.v1.VmwareVmDetails
	(*AwsVmDetails)(nil),                          // 62: google.cloud.vmmigration.v1.AwsVmDetails
	(*AwsSecurityGroup)(nil),                      // 63: google.cloud.vmmigration.v1.AwsSecurityGroup
	(*VmwareVmsDetails)(nil),                      // 64: google.cloud.vmmigration.v1.VmwareVmsDetails
	(*AwsVmsDetails)(nil),                         // 65: google.cloud.vmmigration.v1.AwsVmsDetails
	(*FetchInventoryResponse)(nil),                // 66: google.cloud.vmmigration.v1.FetchInventoryResponse
	(*UtilizationReport)(nil),                     // 67: google.cloud.vmmigration.v1.UtilizationReport
	(*VmUtilizationInfo)(nil),                     // 68: google.cloud.vmmigration.v1.VmUtilizationInfo
	(*VmUtilizationMetrics)(nil),                  // 69: google.cloud.vmmigration.v1.VmUtilizationMetrics
	(*ListUtilizationReportsRequest)(nil),         // 70: google.cloud.vmmigration.v1.ListUtilizationReportsRequest
	(*ListUtilizationReportsResponse)(nil),        // 71: google.cloud.vmmigration.v1.ListUtilizationReportsResponse
	(*GetUtilizationReportRequest)(nil),           // 72: google.cloud.vmmigration.v1.GetUtilizationReportRequest
	(*CreateUtilizationReportRequest)(nil),        // 73: google.cloud.vmmigration.v1.CreateUtilizationReportRequest
	(*DeleteUtilizationReportRequest)(nil),        // 74: google.cloud.vmmigration.v1.DeleteUtilizationReportRequest
	(*ListDatacenterConnectorsResponse)(nil),      // 75: google.cloud.vmmigration.v1.ListDatacenterConnectorsResponse
	(*GetDatacenterConnectorRequest)(nil),         // 76: google.cloud.vmmigration.v1.GetDatacenterConnectorRequest
	(*CreateDatacenterConnectorRequest)(nil),      // 77: google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest
	(*DeleteDatacenterConnectorRequest)(nil),      // 78: google.cloud.vmmigration.v1.DeleteDatacenterConnectorRequest
	(*UpgradeApplianceRequest)(nil),               // 79: google.cloud.vmmigration.v1.UpgradeApplianceRequest
	(*UpgradeApplianceResponse)(nil),              // 80: google.cloud.vmmigration.v1.UpgradeApplianceResponse
	(*ListDatacenterConnectorsRequest)(nil),       // 81: google.cloud.vmmigration.v1.ListDatacenterConnectorsRequest
	(*ComputeEngineTargetDefaults)(nil),           // 82: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults
	(*ComputeEngineTargetDetails)(nil),            // 83: google.cloud.vmmigration.v1.ComputeEngineTargetDetails
	(*NetworkInterface)(nil),                      // 84: google.cloud.vmmigration.v1.NetworkInterface
	(*AppliedLicense)(nil),                        // 85: google.cloud.vmmigration.v1.AppliedLicense
	(*SchedulingNodeAffinity)(nil),                // 86: google.cloud.vmmigration.v1.SchedulingNodeAffinity
	(*ComputeScheduling)(nil),                     // 87: google.cloud.vmmigration.v1.ComputeScheduling
	(*SchedulePolicy)(nil),                        // 88: google.cloud.vmmigration.v1.SchedulePolicy
	(*CreateMigratingVmRequest)(nil),              // 89: google.cloud.vmmigration.v1.CreateMigratingVmRequest
	(*ListMigratingVmsRequest)(nil),               // 90: google.cloud.vmmigration.v1.ListMigratingVmsRequest
	(*ListMigratingVmsResponse)(nil),              // 91: google.cloud.vmmigration.v1.ListMigratingVmsResponse
	(*GetMigratingVmRequest)(nil),                 // 92: google.cloud.vmmigration.v1.GetMigratingVmRequest
	(*UpdateMigratingVmRequest)(nil),              // 93: google.cloud.vmmigration.v1.UpdateMigratingVmRequest
	(*DeleteMigratingVmRequest)(nil),              // 94: google.cloud.vmmigration.v1.DeleteMigratingVmRequest
	(*StartMigrationRequest)(nil),                 // 95: google.cloud.vmmigration.v1.StartMigrationRequest
	(*StartMigrationResponse)(nil),                // 96: google.cloud.vmmigration.v1.StartMigrationResponse
	(*PauseMigrationRequest)(nil),                 // 97: google.cloud.vmmigration.v1.PauseMigrationRequest
	(*PauseMigrationResponse)(nil),                // 98: google.cloud.vmmigration.v1.PauseMigrationResponse
	(*ResumeMigrationRequest)(nil),                // 99: google.cloud.vmmigration.v1.ResumeMigrationRequest
	(*ResumeMigrationResponse)(nil),               // 100: google.cloud.vmmigration.v1.ResumeMigrationResponse
	(*FinalizeMigrationRequest)(nil),              // 101: google.cloud.vmmigration.v1.FinalizeMigrationRequest
	(*FinalizeMigrationResponse)(nil),             // 102: google.cloud.vmmigration.v1.FinalizeMigrationResponse
	(*TargetProject)(nil),                         // 103: google.cloud.vmmigration.v1.TargetProject
	(*GetTargetProjectRequest)(nil),               // 104: google.cloud.vmmigration.v1.GetTargetProjectRequest
	(*ListTargetProjectsRequest)(nil),             // 105: google.cloud.vmmigration.v1.ListTargetProjectsRequest
	(*ListTargetProjectsResponse)(nil),            // 106: google.cloud.vmmigration.v1.ListTargetProjectsResponse
	(*CreateTargetProjectRequest)(nil),            // 107: google.cloud.vmmigration.v1.CreateTargetProjectRequest
	(*UpdateTargetProjectRequest)(nil),            // 108: google.cloud.vmmigration.v1.UpdateTargetProjectRequest
	(*DeleteTargetProjectRequest)(nil),            // 109: google.cloud.vmmigration.v1.DeleteTargetProjectRequest
	(*Group)(nil),                                 // 110: google.cloud.vmmigration.v1.Group
	(*ListGroupsRequest)(nil),                     // 111: google.cloud.vmmigration.v1.ListGroupsRequest
	(*ListGroupsResponse)(nil),                    // 112: google.cloud.vmmigration.v1.ListGroupsResponse
	(*GetGroupRequest)(nil),                       // 113: google.cloud.vmmigration.v1.GetGroupRequest
	(*CreateGroupRequest)(nil),                    // 114: google.cloud.vmmigration.v1.CreateGroupRequest
	(*UpdateGroupRequest)(nil),                    // 115: google.cloud.vmmigration.v1.UpdateGroupRequest
	(*DeleteGroupRequest)(nil),                    // 116: google.cloud.vmmigration.v1.DeleteGroupRequest
	(*AddGroupMigrationRequest)(nil),              // 117: google.cloud.vmmigration.v1.AddGroupMigrationRequest
	(*AddGroupMigrationResponse)(nil),             // 118: google.cloud.vmmigration.v1.AddGroupMigrationResponse
	(*RemoveGroupMigrationRequest)(nil),           // 119: google.cloud.vmmigration.v1.RemoveGroupMigrationRequest
	(*RemoveGroupMigrationResponse)(nil),          // 120: google.cloud.vmmigration.v1.RemoveGroupMigrationResponse
	(*CreateCutoverJobRequest)(nil),               // 121: google.cloud.vmmigration.v1.CreateCutoverJobRequest
	(*CancelCutoverJobRequest)(nil),               // 122: google.cloud.vmmigration.v1.CancelCutoverJobRequest
	(*CancelCutoverJobResponse)(nil),              // 123: google.cloud.vmmigration.v1.CancelCutoverJobResponse
	(*ListCutoverJobsRequest)(nil),                // 124: google.cloud.vmmigration.v1.ListCutoverJobsRequest
	(*ListCutoverJobsResponse)(nil),               // 125: google.cloud.vmmigration.v1.ListCutoverJobsResponse
	(*GetCutoverJobRequest)(nil),                  // 126: google.cloud.vmmigration.v1.GetCutoverJobRequest
	(*OperationMetadata)(nil),                     // 127: google.cloud.vmmigration.v1.OperationMetadata
	(*MigrationError)(nil),                        // 128: google.cloud.vmmigration.v1.MigrationError
	(*AwsSourceVmDetails)(nil),                    // 129: google.cloud.vmmigration.v1.AwsSourceVmDetails
	(*ListReplicationCyclesRequest)(nil),          // 130: google.cloud.vmmigration.v1.ListReplicationCyclesRequest
	(*ListReplicationCyclesResponse)(nil),         // 131: google.cloud.vmmigration.v1.ListReplicationCyclesResponse
	(*GetReplicationCycleRequest)(nil),            // 132: google.cloud.vmmigration.v1.GetReplicationCycleRequest
	nil,                                           // 133: google.cloud.vmmigration.v1.MigratingVm.LabelsEntry
	nil,                                           // 134: google.cloud.vmmigration.v1.Source.LabelsEntry
	(*AwsSourceDetails_AccessKeyCredentials)(nil), // 135: google.cloud.vmmigration.v1.AwsSourceDetails.AccessKeyCredentials
	(*AwsSourceDetails_Tag)(nil),                  // 136: google.cloud.vmmigration.v1.AwsSourceDetails.Tag
	nil,                                           // 137: google.cloud.vmmigration.v1.AwsSourceDetails.MigrationResourcesUserTagsEntry
	nil,                                           // 138: google.cloud.vmmigration.v1.AwsVmDetails.TagsEntry
	nil,                                           // 139: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.LabelsEntry
	nil,                                           // 140: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.MetadataEntry
	nil,                                           // 141: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.LabelsEntry
	nil,                                           // 142: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.MetadataEntry
	(*timestamppb.Timestamp)(nil),                 // 143: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                   // 144: google.protobuf.Duration
	(*status.Status)(nil),                         // 145: google.rpc.Status
	(*fieldmaskpb.FieldMask)(nil),                 // 146: google.protobuf.FieldMask
	(*errdetails.LocalizedMessage)(nil),           // 147: google.rpc.LocalizedMessage
	(*errdetails.Help_Link)(nil),                  // 148: google.rpc.Help.Link
	(*longrunningpb.Operation)(nil),               // 149: google.longrunning.Operation
}
var file_google_cloud_vmmigration_v1_vmmigration_proto_depIdxs = []int32{
	143, // 0: google.cloud.vmmigration.v1.ReplicationCycle.start_time:type_name -> google.protobuf.Timestamp
	143, // 1: google.cloud.vmmigration.v1.ReplicationCycle.end_time:type_name -> google.protobuf.Timestamp
	144, // 2: google.cloud.vmmigration.v1.ReplicationCycle.total_pause_duration:type_name -> google.protobuf.Duration
	27,  // 3: google.cloud.vmmigration.v1.ReplicationCycle.steps:type_name -> google.cloud.vmmigration.v1.CycleStep
	5,   // 4: google.cloud.vmmigration.v1.ReplicationCycle.state:type_name -> google.cloud.vmmigration.v1.ReplicationCycle.State
	145, // 5: google.cloud.vmmigration.v1.ReplicationCycle.error:type_name -> google.rpc.Status
	28,  // 6: google.cloud.vmmigration.v1.CycleStep.initializing_replication:type_name -> google.cloud.vmmigration.v1.InitializingReplicationStep
	29,  // 7: google.cloud.vmmigration.v1.CycleStep.replicating:type_name -> google.cloud.vmmigration.v1.ReplicatingStep
	30,  // 8: google.cloud.vmmigration.v1.CycleStep.post_processing:type_name -> google.cloud.vmmigration.v1.PostProcessingStep
	143, // 9: google.cloud.vmmigration.v1.CycleStep.start_time:type_name -> google.protobuf.Timestamp
	143, // 10: google.cloud.vmmigration.v1.CycleStep.end_time:type_name -> google.protobuf.Timestamp
	143, // 11: google.cloud.vmmigration.v1.ReplicationSync.last_sync_time:type_name -> google.protobuf.Timestamp
	82,  // 12: google.cloud.vmmigration.v1.MigratingVm.compute_engine_target_defaults:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDefaults
	129, // 13: google.cloud.vmmigration.v1.MigratingVm.aws_source_vm_details:type_name -> google.cloud.vmmigration.v1.AwsSourceVmDetails
	88,  // 14: google.cloud.vmmigration.v1.MigratingVm.policy:type_name -> google.cloud.vmmigration.v1.SchedulePolicy
	143, // 15: google.cloud.vmmigration.v1.MigratingVm.create_time:type_name -> google.protobuf.Timestamp
	143, // 16: google.cloud.vmmigration.v1.MigratingVm.update_time:type_name -> google.protobuf.Timestamp
	31,  // 17: google.cloud.vmmigration.v1.MigratingVm.last_sync:type_name -> google.cloud.vmmigration.v1.ReplicationSync
	6,   // 18: google.cloud.vmmigration.v1.MigratingVm.state:type_name -> google.cloud.vmmigration.v1.MigratingVm.State
	143, // 19: google.cloud.vmmigration.v1.MigratingVm.state_time:type_name -> google.protobuf.Timestamp
	26,  // 20: google.cloud.vmmigration.v1.MigratingVm.current_sync_info:type_name -> google.cloud.vmmigration.v1.ReplicationCycle
	133, // 21: google.cloud.vmmigration.v1.MigratingVm.labels:type_name -> google.cloud.vmmigration.v1.MigratingVm.LabelsEntry
	33,  // 22: google.cloud.vmmigration.v1.MigratingVm.recent_clone_jobs:type_name -> google.cloud.vmmigration.v1.CloneJob
	145, // 23: google.cloud.vmmigration.v1.MigratingVm.error:type_name -> google.rpc.Status
	38,  // 24: google.cloud.vmmigration.v1.MigratingVm.recent_cutover_jobs:type_name -> google.cloud.vmmigration.v1.CutoverJob
	83,  // 25: google.cloud.vmmigration.v1.CloneJob.compute_engine_target_details:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDetails
	143, // 26: google.cloud.vmmigration.v1.CloneJob.create_time:type_name -> google.protobuf.Timestamp
	143, // 27: google.cloud.vmmigration.v1.CloneJob.end_time:type_name -> google.protobuf.Timestamp
	7,   // 28: google.cloud.vmmigration.v1.CloneJob.state:type_name -> google.cloud.vmmigration.v1.CloneJob.State
	143, // 29: google.cloud.vmmigration.v1.CloneJob.state_time:type_name -> google.protobuf.Timestamp
	145, // 30: google.cloud.vmmigration.v1.CloneJob.error:type_name -> google.rpc.Status
	34,  // 31: google.cloud.vmmigration.v1.CloneJob.steps:type_name -> google.cloud.vmmigration.v1.CloneStep
	35,  // 32: google.cloud.vmmigration.v1.CloneStep.adapting_os:type_name -> google.cloud.vmmigration.v1.AdaptingOSStep
	36,  // 33: google.cloud.vmmigration.v1.CloneStep.preparing_vm_disks:type_name -> google.cloud.vmmigration.v1.PreparingVMDisksStep
	37,  // 34: google.cloud.vmmigration.v1.CloneStep.instantiating_migrated_vm:type_name -> google.cloud.vmmigration.v1.InstantiatingMigratedVMStep
	143, // 35: google.cloud.vmmigration.v1.CloneStep.start_time:type_name -> google.protobuf.Timestamp
	143, // 36: google.cloud.vmmigration.v1.CloneStep.end_time:type_name -> google.protobuf.Timestamp
	83,  // 37: google.cloud.vmmigration.v1.CutoverJob.compute_engine_target_details:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDetails
	143, // 38: google.cloud.vmmigration.v1.CutoverJob.create_time:type_name -> google.protobuf.Timestamp
	143, // 39: google.cloud.vmmigration.v1.CutoverJob.end_time:type_name -> google.protobuf.Timestamp
	8,   // 40: google.cloud.vmmigration.v1.CutoverJob.state:type_name -> google.cloud.vmmigration.v1.CutoverJob.State
	143, // 41: google.cloud.vmmigration.v1.CutoverJob.state_time:type_name -> google.protobuf.Timestamp
	145, // 42: google.cloud.vmmigration.v1.CutoverJob.error:type_name -> google.rpc.Status
	39,  // 43: google.cloud.vmmigration.v1.CutoverJob.steps:type_name -> google.cloud.vmmigration.v1.CutoverStep
	26,  // 44: google.cloud.vmmigration.v1.CutoverStep.previous_replication_cycle:type_name -> google.cloud.vmmigration.v1.ReplicationCycle
	40,  // 45: google.cloud.vmmigration.v1.CutoverStep.shutting_down_source_vm:type_name -> google.cloud.vmmigration.v1.ShuttingDownSourceVMStep
	26,  // 46: google.cloud.vmmigration.v1.CutoverStep.final_sync:type_name -> google.cloud.vmmigration.v1.ReplicationCycle
	36,  // 47: google.cloud.vmmigration.v1.CutoverStep.preparing_vm_disks:type_name -> google.cloud.vmmigration.v1.PreparingVMDisksStep
	37,  // 48: google.cloud.vmmigration.v1.CutoverStep.instantiating_migrated_vm:type_name -> google.cloud.vmmigration.v1.InstantiatingMigratedVMStep
	143, // 49: google.cloud.vmmigration.v1.CutoverStep.start_time:type_name -> google.protobuf.Timestamp
	143, // 50: google.cloud.vmmigration.v1.CutoverStep.end_time:type_name -> google.protobuf.Timestamp
	33,  // 51: google.cloud.vmmigration.v1.CreateCloneJobRequest.clone_job:type_name -> google.cloud.vmmigration.v1.CloneJob
	33,  // 52: google.cloud.vmmigration.v1.ListCloneJobsResponse.clone_jobs:type_name -> google.cloud.vmmigration.v1.CloneJob
	48,  // 53: google.cloud.vmmigration.v1.Source.vmware:type_name -> google.cloud.vmmigration.v1.VmwareSourceDetails
	49,  // 54: google.cloud.vmmigration.v1.Source.aws:type_name -> google.cloud.vmmigration.v1.AwsSourceDetails
	143, // 55: google.cloud.vmmigration.v1.Source.create_time:type_name -> google.protobuf.Timestamp
	143, // 56: google.cloud.vmmigration.v1.Source.update_time:type_name -> google.protobuf.Timestamp
	134, // 57: google.cloud.vmmigration.v1.Source.labels:type_name -> google.cloud.vmmigration.v1.Source.LabelsEntry
	135, // 58: google.cloud.vmmigration.v1.AwsSourceDetails.access_key_creds:type_name -> google.cloud.vmmigration.v1.AwsSourceDetails.AccessKeyCredentials
	9,   // 59: google.cloud.vmmigration.v1.AwsSourceDetails.state:type_name -> google.cloud.vmmigration.v1.AwsSourceDetails.State
	145, // 60: google.cloud.vmmigration.v1.AwsSourceDetails.error:type_name -> google.rpc.Status
	136, // 61: google.cloud.vmmigration.v1.AwsSourceDetails.inventory_tag_list:type_name -> google.cloud.vmmigration.v1.AwsSourceDetails.Tag
	137, // 62: google.cloud.vmmigration.v1.AwsSourceDetails.migration_resources_user_tags:type_name -> google.cloud.vmmigration.v1.AwsSourceDetails.MigrationResourcesUserTagsEntry
	143, // 63: google.cloud.vmmigration.v1.DatacenterConnector.create_time:type_name -> google.protobuf.Timestamp
	143, // 64: google.cloud.vmmigration.v1.DatacenterConnector.update_time:type_name -> google.protobuf.Timestamp
	10,  // 65: google.cloud.vmmigration.v1.DatacenterConnector.state:type_name -> google.cloud.vmmigration.v1.DatacenterConnector.State
	143, // 66: google.cloud.vmmigration.v1.DatacenterConnector.state_time:type_name -> google.protobuf.Timestamp
	145, // 67: google.cloud.vmmigration.v1.DatacenterConnector.error:type_name -> google.rpc.Status
	52,  // 68: google.cloud.vmmigration.v1.DatacenterConnector.available_versions:type_name -> google.cloud.vmmigration.v1.AvailableUpdates
	51,  // 69: google.cloud.vmmigration.v1.DatacenterConnector.upgrade_status:type_name -> google.cloud.vmmigration.v1.UpgradeStatus
	11,  // 70: google.cloud.vmmigration.v1.UpgradeStatus.state:type_name -> google.cloud.vmmigration.v1.UpgradeStatus.State
	145, // 71: google.cloud.vmmigration.v1.UpgradeStatus.error:type_name -> google.rpc.Status
	143, // 72: google.cloud.vmmigration.v1.UpgradeStatus.start_time:type_name -> google.protobuf.Timestamp
	53,  // 73: google.cloud.vmmigration.v1.AvailableUpdates.new_deployable_appliance:type_name -> google.cloud.vmmigration.v1.ApplianceVersion
	53,  // 74: google.cloud.vmmigration.v1.AvailableUpdates.in_place_update:type_name -> google.cloud.vmmigration.v1.ApplianceVersion
	47,  // 75: google.cloud.vmmigration.v1.ListSourcesResponse.sources:type_name -> google.cloud.vmmigration.v1.Source
	47,  // 76: google.cloud.vmmigration.v1.CreateSourceRequest.source:type_name -> google.cloud.vmmigration.v1.Source
	146, // 77: google.cloud.vmmigration.v1.UpdateSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	47,  // 78: google.cloud.vmmigration.v1.UpdateSourceRequest.source:type_name -> google.cloud.vmmigration.v1.Source
	12,  // 79: google.cloud.vmmigration.v1.VmwareVmDetails.power_state:type_name -> google.cloud.vmmigration.v1.VmwareVmDetails.PowerState
	13,  // 80: google.cloud.vmmigration.v1.VmwareVmDetails.boot_option:type_name -> google.cloud.vmmigration.v1.VmwareVmDetails.BootOption
	14,  // 81: google.cloud.vmmigration.v1.AwsVmDetails.power_state:type_name -> google.cloud.vmmigration.v1.AwsVmDetails.PowerState
	15,  // 82: google.cloud.vmmigration.v1.AwsVmDetails.boot_option:type_name -> google.cloud.vmmigration.v1.AwsVmDetails.BootOption
	63,  // 83: google.cloud.vmmigration.v1.AwsVmDetails.security_groups:type_name -> google.cloud.vmmigration.v1.AwsSecurityGroup
	138, // 84: google.cloud.vmmigration.v1.AwsVmDetails.tags:type_name -> google.cloud.vmmigration.v1.AwsVmDetails.TagsEntry
	16,  // 85: google.cloud.vmmigration.v1.AwsVmDetails.virtualization_type:type_name -> google.cloud.vmmigration.v1.AwsVmDetails.VmVirtualizationType
	17,  // 86: google.cloud.vmmigration.v1.AwsVmDetails.architecture:type_name -> google.cloud.vmmigration.v1.AwsVmDetails.VmArchitecture
	61,  // 87: google.cloud.vmmigration.v1.VmwareVmsDetails.details:type_name -> google.cloud.vmmigration.v1.VmwareVmDetails
	62,  // 88: google.cloud.vmmigration.v1.AwsVmsDetails.details:type_name -> google.cloud.vmmigration.v1.AwsVmDetails
	64,  // 89: google.cloud.vmmigration.v1.FetchInventoryResponse.vmware_vms:type_name -> google.cloud.vmmigration.v1.VmwareVmsDetails
	65,  // 90: google.cloud.vmmigration.v1.FetchInventoryResponse.aws_vms:type_name -> google.cloud.vmmigration.v1.AwsVmsDetails
	143, // 91: google.cloud.vmmigration.v1.FetchInventoryResponse.update_time:type_name -> google.protobuf.Timestamp
	18,  // 92: google.cloud.vmmigration.v1.UtilizationReport.state:type_name -> google.cloud.vmmigration.v1.UtilizationReport.State
	143, // 93: google.cloud.vmmigration.v1.UtilizationReport.state_time:type_name -> google.protobuf.Timestamp
	145, // 94: google.cloud.vmmigration.v1.UtilizationReport.error:type_name -> google.rpc.Status
	143, // 95: google.cloud.vmmigration.v1.UtilizationReport.create_time:type_name -> google.protobuf.Timestamp
	19,  // 96: google.cloud.vmmigration.v1.UtilizationReport.time_frame:type_name -> google.cloud.vmmigration.v1.UtilizationReport.TimeFrame
	143, // 97: google.cloud.vmmigration.v1.UtilizationReport.frame_end_time:type_name -> google.protobuf.Timestamp
	68,  // 98: google.cloud.vmmigration.v1.UtilizationReport.vms:type_name -> google.cloud.vmmigration.v1.VmUtilizationInfo
	61,  // 99: google.cloud.vmmigration.v1.VmUtilizationInfo.vmware_vm_details:type_name -> google.cloud.vmmigration.v1.VmwareVmDetails
	69,  // 100: google.cloud.vmmigration.v1.VmUtilizationInfo.utilization:type_name -> google.cloud.vmmigration.v1.VmUtilizationMetrics
	0,   // 101: google.cloud.vmmigration.v1.ListUtilizationReportsRequest.view:type_name -> google.cloud.vmmigration.v1.UtilizationReportView
	67,  // 102: google.cloud.vmmigration.v1.ListUtilizationReportsResponse.utilization_reports:type_name -> google.cloud.vmmigration.v1.UtilizationReport
	0,   // 103: google.cloud.vmmigration.v1.GetUtilizationReportRequest.view:type_name -> google.cloud.vmmigration.v1.UtilizationReportView
	67,  // 104: google.cloud.vmmigration.v1.CreateUtilizationReportRequest.utilization_report:type_name -> google.cloud.vmmigration.v1.UtilizationReport
	50,  // 105: google.cloud.vmmigration.v1.ListDatacenterConnectorsResponse.datacenter_connectors:type_name -> google.cloud.vmmigration.v1.DatacenterConnector
	50,  // 106: google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest.datacenter_connector:type_name -> google.cloud.vmmigration.v1.DatacenterConnector
	84,  // 107: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.network_interfaces:type_name -> google.cloud.vmmigration.v1.NetworkInterface
	2,   // 108: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.disk_type:type_name -> google.cloud.vmmigration.v1.ComputeEngineDiskType
	139, // 109: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.labels:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.LabelsEntry
	3,   // 110: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.license_type:type_name -> google.cloud.vmmigration.v1.ComputeEngineLicenseType
	85,  // 111: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.applied_license:type_name -> google.cloud.vmmigration.v1.AppliedLicense
	87,  // 112: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.compute_scheduling:type_name -> google.cloud.vmmigration.v1.ComputeScheduling
	4,   // 113: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.boot_option:type_name -> google.cloud.vmmigration.v1.ComputeEngineBootOption
	140, // 114: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.metadata:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.MetadataEntry
	84,  // 115: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.network_interfaces:type_name -> google.cloud.vmmigration.v1.NetworkInterface
	2,   // 116: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.disk_type:type_name -> google.cloud.vmmigration.v1.ComputeEngineDiskType
	141, // 117: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.labels:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDetails.LabelsEntry
	3,   // 118: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.license_type:type_name -> google.cloud.vmmigration.v1.ComputeEngineLicenseType
	85,  // 119: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.applied_license:type_name -> google.cloud.vmmigration.v1.AppliedLicense
	87,  // 120: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.compute_scheduling:type_name -> google.cloud.vmmigration.v1.ComputeScheduling
	4,   // 121: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.boot_option:type_name -> google.cloud.vmmigration.v1.ComputeEngineBootOption
	142, // 122: google.cloud.vmmigration.v1.ComputeEngineTargetDetails.metadata:type_name -> google.cloud.vmmigration.v1.ComputeEngineTargetDetails.MetadataEntry
	20,  // 123: google.cloud.vmmigration.v1.AppliedLicense.type:type_name -> google.cloud.vmmigration.v1.AppliedLicense.Type
	21,  // 124: google.cloud.vmmigration.v1.SchedulingNodeAffinity.operator:type_name -> google.cloud.vmmigration.v1.SchedulingNodeAffinity.Operator
	22,  // 125: google.cloud.vmmigration.v1.ComputeScheduling.on_host_maintenance:type_name -> google.cloud.vmmigration.v1.ComputeScheduling.OnHostMaintenance
	23,  // 126: google.cloud.vmmigration.v1.ComputeScheduling.restart_type:type_name -> google.cloud.vmmigration.v1.ComputeScheduling.RestartType
	86,  // 127: google.cloud.vmmigration.v1.ComputeScheduling.node_affinities:type_name -> google.cloud.vmmigration.v1.SchedulingNodeAffinity
	144, // 128: google.cloud.vmmigration.v1.SchedulePolicy.idle_duration:type_name -> google.protobuf.Duration
	32,  // 129: google.cloud.vmmigration.v1.CreateMigratingVmRequest.migrating_vm:type_name -> google.cloud.vmmigration.v1.MigratingVm
	1,   // 130: google.cloud.vmmigration.v1.ListMigratingVmsRequest.view:type_name -> google.cloud.vmmigration.v1.MigratingVmView
	32,  // 131: google.cloud.vmmigration.v1.ListMigratingVmsResponse.migrating_vms:type_name -> google.cloud.vmmigration.v1.MigratingVm
	1,   // 132: google.cloud.vmmigration.v1.GetMigratingVmRequest.view:type_name -> google.cloud.vmmigration.v1.MigratingVmView
	146, // 133: google.cloud.vmmigration.v1.UpdateMigratingVmRequest.update_mask:type_name -> google.protobuf.FieldMask
	32,  // 134: google.cloud.vmmigration.v1.UpdateMigratingVmRequest.migrating_vm:type_name -> google.cloud.vmmigration.v1.MigratingVm
	143, // 135: google.cloud.vmmigration.v1.TargetProject.create_time:type_name -> google.protobuf.Timestamp
	143, // 136: google.cloud.vmmigration.v1.TargetProject.update_time:type_name -> google.protobuf.Timestamp
	103, // 137: google.cloud.vmmigration.v1.ListTargetProjectsResponse.target_projects:type_name -> google.cloud.vmmigration.v1.TargetProject
	103, // 138: google.cloud.vmmigration.v1.CreateTargetProjectRequest.target_project:type_name -> google.cloud.vmmigration.v1.TargetProject
	146, // 139: google.cloud.vmmigration.v1.UpdateTargetProjectRequest.update_mask:type_name -> google.protobuf.FieldMask
	103, // 140: google.cloud.vmmigration.v1.UpdateTargetProjectRequest.target_project:type_name -> google.cloud.vmmigration.v1.TargetProject
	143, // 141: google.cloud.vmmigration.v1.Group.create_time:type_name -> google.protobuf.Timestamp
	143, // 142: google.cloud.vmmigration.v1.Group.update_time:type_name -> google.protobuf.Timestamp
	110, // 143: google.cloud.vmmigration.v1.ListGroupsResponse.groups:type_name -> google.cloud.vmmigration.v1.Group
	110, // 144: google.cloud.vmmigration.v1.CreateGroupRequest.group:type_name -> google.cloud.vmmigration.v1.Group
	146, // 145: google.cloud.vmmigration.v1.UpdateGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	110, // 146: google.cloud.vmmigration.v1.UpdateGroupRequest.group:type_name -> google.cloud.vmmigration.v1.Group
	38,  // 147: google.cloud.vmmigration.v1.CreateCutoverJobRequest.cutover_job:type_name -> google.cloud.vmmigration.v1.CutoverJob
	38,  // 148: google.cloud.vmmigration.v1.ListCutoverJobsResponse.cutover_jobs:type_name -> google.cloud.vmmigration.v1.CutoverJob
	143, // 149: google.cloud.vmmigration.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	143, // 150: google.cloud.vmmigration.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	24,  // 151: google.cloud.vmmigration.v1.MigrationError.code:type_name -> google.cloud.vmmigration.v1.MigrationError.ErrorCode
	147, // 152: google.cloud.vmmigration.v1.MigrationError.error_message:type_name -> google.rpc.LocalizedMessage
	147, // 153: google.cloud.vmmigration.v1.MigrationError.action_item:type_name -> google.rpc.LocalizedMessage
	148, // 154: google.cloud.vmmigration.v1.MigrationError.help_links:type_name -> google.rpc.Help.Link
	143, // 155: google.cloud.vmmigration.v1.MigrationError.error_time:type_name -> google.protobuf.Timestamp
	25,  // 156: google.cloud.vmmigration.v1.AwsSourceVmDetails.firmware:type_name -> google.cloud.vmmigration.v1.AwsSourceVmDetails.Firmware
	26,  // 157: google.cloud.vmmigration.v1.ListReplicationCyclesResponse.replication_cycles:type_name -> google.cloud.vmmigration.v1.ReplicationCycle
	54,  // 158: google.cloud.vmmigration.v1.VmMigration.ListSources:input_type -> google.cloud.vmmigration.v1.ListSourcesRequest
	56,  // 159: google.cloud.vmmigration.v1.VmMigration.GetSource:input_type -> google.cloud.vmmigration.v1.GetSourceRequest
	57,  // 160: google.cloud.vmmigration.v1.VmMigration.CreateSource:input_type -> google.cloud.vmmigration.v1.CreateSourceRequest
	58,  // 161: google.cloud.vmmigration.v1.VmMigration.UpdateSource:input_type -> google.cloud.vmmigration.v1.UpdateSourceRequest
	59,  // 162: google.cloud.vmmigration.v1.VmMigration.DeleteSource:input_type -> google.cloud.vmmigration.v1.DeleteSourceRequest
	60,  // 163: google.cloud.vmmigration.v1.VmMigration.FetchInventory:input_type -> google.cloud.vmmigration.v1.FetchInventoryRequest
	70,  // 164: google.cloud.vmmigration.v1.VmMigration.ListUtilizationReports:input_type -> google.cloud.vmmigration.v1.ListUtilizationReportsRequest
	72,  // 165: google.cloud.vmmigration.v1.VmMigration.GetUtilizationReport:input_type -> google.cloud.vmmigration.v1.GetUtilizationReportRequest
	73,  // 166: google.cloud.vmmigration.v1.VmMigration.CreateUtilizationReport:input_type -> google.cloud.vmmigration.v1.CreateUtilizationReportRequest
	74,  // 167: google.cloud.vmmigration.v1.VmMigration.DeleteUtilizationReport:input_type -> google.cloud.vmmigration.v1.DeleteUtilizationReportRequest
	81,  // 168: google.cloud.vmmigration.v1.VmMigration.ListDatacenterConnectors:input_type -> google.cloud.vmmigration.v1.ListDatacenterConnectorsRequest
	76,  // 169: google.cloud.vmmigration.v1.VmMigration.GetDatacenterConnector:input_type -> google.cloud.vmmigration.v1.GetDatacenterConnectorRequest
	77,  // 170: google.cloud.vmmigration.v1.VmMigration.CreateDatacenterConnector:input_type -> google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest
	78,  // 171: google.cloud.vmmigration.v1.VmMigration.DeleteDatacenterConnector:input_type -> google.cloud.vmmigration.v1.DeleteDatacenterConnectorRequest
	79,  // 172: google.cloud.vmmigration.v1.VmMigration.UpgradeAppliance:input_type -> google.cloud.vmmigration.v1.UpgradeApplianceRequest
	89,  // 173: google.cloud.vmmigration.v1.VmMigration.CreateMigratingVm:input_type -> google.cloud.vmmigration.v1.CreateMigratingVmRequest
	90,  // 174: google.cloud.vmmigration.v1.VmMigration.ListMigratingVms:input_type -> google.cloud.vmmigration.v1.ListMigratingVmsRequest
	92,  // 175: google.cloud.vmmigration.v1.VmMigration.GetMigratingVm:input_type -> google.cloud.vmmigration.v1.GetMigratingVmRequest
	93,  // 176: google.cloud.vmmigration.v1.VmMigration.UpdateMigratingVm:input_type -> google.cloud.vmmigration.v1.UpdateMigratingVmRequest
	94,  // 177: google.cloud.vmmigration.v1.VmMigration.DeleteMigratingVm:input_type -> google.cloud.vmmigration.v1.DeleteMigratingVmRequest
	95,  // 178: google.cloud.vmmigration.v1.VmMigration.StartMigration:input_type -> google.cloud.vmmigration.v1.StartMigrationRequest
	99,  // 179: google.cloud.vmmigration.v1.VmMigration.ResumeMigration:input_type -> google.cloud.vmmigration.v1.ResumeMigrationRequest
	97,  // 180: google.cloud.vmmigration.v1.VmMigration.PauseMigration:input_type -> google.cloud.vmmigration.v1.PauseMigrationRequest
	101, // 181: google.cloud.vmmigration.v1.VmMigration.FinalizeMigration:input_type -> google.cloud.vmmigration.v1.FinalizeMigrationRequest
	41,  // 182: google.cloud.vmmigration.v1.VmMigration.CreateCloneJob:input_type -> google.cloud.vmmigration.v1.CreateCloneJobRequest
	42,  // 183: google.cloud.vmmigration.v1.VmMigration.CancelCloneJob:input_type -> google.cloud.vmmigration.v1.CancelCloneJobRequest
	44,  // 184: google.cloud.vmmigration.v1.VmMigration.ListCloneJobs:input_type -> google.cloud.vmmigration.v1.ListCloneJobsRequest
	46,  // 185: google.cloud.vmmigration.v1.VmMigration.GetCloneJob:input_type -> google.cloud.vmmigration.v1.GetCloneJobRequest
	121, // 186: google.cloud.vmmigration.v1.VmMigration.CreateCutoverJob:input_type -> google.cloud.vmmigration.v1.CreateCutoverJobRequest
	122, // 187: google.cloud.vmmigration.v1.VmMigration.CancelCutoverJob:input_type -> google.cloud.vmmigration.v1.CancelCutoverJobRequest
	124, // 188: google.cloud.vmmigration.v1.VmMigration.ListCutoverJobs:input_type -> google.cloud.vmmigration.v1.ListCutoverJobsRequest
	126, // 189: google.cloud.vmmigration.v1.VmMigration.GetCutoverJob:input_type -> google.cloud.vmmigration.v1.GetCutoverJobRequest
	111, // 190: google.cloud.vmmigration.v1.VmMigration.ListGroups:input_type -> google.cloud.vmmigration.v1.ListGroupsRequest
	113, // 191: google.cloud.vmmigration.v1.VmMigration.GetGroup:input_type -> google.cloud.vmmigration.v1.GetGroupRequest
	114, // 192: google.cloud.vmmigration.v1.VmMigration.CreateGroup:input_type -> google.cloud.vmmigration.v1.CreateGroupRequest
	115, // 193: google.cloud.vmmigration.v1.VmMigration.UpdateGroup:input_type -> google.cloud.vmmigration.v1.UpdateGroupRequest
	116, // 194: google.cloud.vmmigration.v1.VmMigration.DeleteGroup:input_type -> google.cloud.vmmigration.v1.DeleteGroupRequest
	117, // 195: google.cloud.vmmigration.v1.VmMigration.AddGroupMigration:input_type -> google.cloud.vmmigration.v1.AddGroupMigrationRequest
	119, // 196: google.cloud.vmmigration.v1.VmMigration.RemoveGroupMigration:input_type -> google.cloud.vmmigration.v1.RemoveGroupMigrationRequest
	105, // 197: google.cloud.vmmigration.v1.VmMigration.ListTargetProjects:input_type -> google.cloud.vmmigration.v1.ListTargetProjectsRequest
	104, // 198: google.cloud.vmmigration.v1.VmMigration.GetTargetProject:input_type -> google.cloud.vmmigration.v1.GetTargetProjectRequest
	107, // 199: google.cloud.vmmigration.v1.VmMigration.CreateTargetProject:input_type -> google.cloud.vmmigration.v1.CreateTargetProjectRequest
	108, // 200: google.cloud.vmmigration.v1.VmMigration.UpdateTargetProject:input_type -> google.cloud.vmmigration.v1.UpdateTargetProjectRequest
	109, // 201: google.cloud.vmmigration.v1.VmMigration.DeleteTargetProject:input_type -> google.cloud.vmmigration.v1.DeleteTargetProjectRequest
	130, // 202: google.cloud.vmmigration.v1.VmMigration.ListReplicationCycles:input_type -> google.cloud.vmmigration.v1.ListReplicationCyclesRequest
	132, // 203: google.cloud.vmmigration.v1.VmMigration.GetReplicationCycle:input_type -> google.cloud.vmmigration.v1.GetReplicationCycleRequest
	55,  // 204: google.cloud.vmmigration.v1.VmMigration.ListSources:output_type -> google.cloud.vmmigration.v1.ListSourcesResponse
	47,  // 205: google.cloud.vmmigration.v1.VmMigration.GetSource:output_type -> google.cloud.vmmigration.v1.Source
	149, // 206: google.cloud.vmmigration.v1.VmMigration.CreateSource:output_type -> google.longrunning.Operation
	149, // 207: google.cloud.vmmigration.v1.VmMigration.UpdateSource:output_type -> google.longrunning.Operation
	149, // 208: google.cloud.vmmigration.v1.VmMigration.DeleteSource:output_type -> google.longrunning.Operation
	66,  // 209: google.cloud.vmmigration.v1.VmMigration.FetchInventory:output_type -> google.cloud.vmmigration.v1.FetchInventoryResponse
	71,  // 210: google.cloud.vmmigration.v1.VmMigration.ListUtilizationReports:output_type -> google.cloud.vmmigration.v1.ListUtilizationReportsResponse
	67,  // 211: google.cloud.vmmigration.v1.VmMigration.GetUtilizationReport:output_type -> google.cloud.vmmigration.v1.UtilizationReport
	149, // 212: google.cloud.vmmigration.v1.VmMigration.CreateUtilizationReport:output_type -> google.longrunning.Operation
	149, // 213: google.cloud.vmmigration.v1.VmMigration.DeleteUtilizationReport:output_type -> google.longrunning.Operation
	75,  // 214: google.cloud.vmmigration.v1.VmMigration.ListDatacenterConnectors:output_type -> google.cloud.vmmigration.v1.ListDatacenterConnectorsResponse
	50,  // 215: google.cloud.vmmigration.v1.VmMigration.GetDatacenterConnector:output_type -> google.cloud.vmmigration.v1.DatacenterConnector
	149, // 216: google.cloud.vmmigration.v1.VmMigration.CreateDatacenterConnector:output_type -> google.longrunning.Operation
	149, // 217: google.cloud.vmmigration.v1.VmMigration.DeleteDatacenterConnector:output_type -> google.longrunning.Operation
	149, // 218: google.cloud.vmmigration.v1.VmMigration.UpgradeAppliance:output_type -> google.longrunning.Operation
	149, // 219: google.cloud.vmmigration.v1.VmMigration.CreateMigratingVm:output_type -> google.longrunning.Operation
	91,  // 220: google.cloud.vmmigration.v1.VmMigration.ListMigratingVms:output_type -> google.cloud.vmmigration.v1.ListMigratingVmsResponse
	32,  // 221: google.cloud.vmmigration.v1.VmMigration.GetMigratingVm:output_type -> google.cloud.vmmigration.v1.MigratingVm
	149, // 222: google.cloud.vmmigration.v1.VmMigration.UpdateMigratingVm:output_type -> google.longrunning.Operation
	149, // 223: google.cloud.vmmigration.v1.VmMigration.DeleteMigratingVm:output_type -> google.longrunning.Operation
	149, // 224: google.cloud.vmmigration.v1.VmMigration.StartMigration:output_type -> google.longrunning.Operation
	149, // 225: google.cloud.vmmigration.v1.VmMigration.ResumeMigration:output_type -> google.longrunning.Operation
	149, // 226: google.cloud.vmmigration.v1.VmMigration.PauseMigration:output_type -> google.longrunning.Operation
	149, // 227: google.cloud.vmmigration.v1.VmMigration.FinalizeMigration:output_type -> google.longrunning.Operation
	149, // 228: google.cloud.vmmigration.v1.VmMigration.CreateCloneJob:output_type -> google.longrunning.Operation
	149, // 229: google.cloud.vmmigration.v1.VmMigration.CancelCloneJob:output_type -> google.longrunning.Operation
	45,  // 230: google.cloud.vmmigration.v1.VmMigration.ListCloneJobs:output_type -> google.cloud.vmmigration.v1.ListCloneJobsResponse
	33,  // 231: google.cloud.vmmigration.v1.VmMigration.GetCloneJob:output_type -> google.cloud.vmmigration.v1.CloneJob
	149, // 232: google.cloud.vmmigration.v1.VmMigration.CreateCutoverJob:output_type -> google.longrunning.Operation
	149, // 233: google.cloud.vmmigration.v1.VmMigration.CancelCutoverJob:output_type -> google.longrunning.Operation
	125, // 234: google.cloud.vmmigration.v1.VmMigration.ListCutoverJobs:output_type -> google.cloud.vmmigration.v1.ListCutoverJobsResponse
	38,  // 235: google.cloud.vmmigration.v1.VmMigration.GetCutoverJob:output_type -> google.cloud.vmmigration.v1.CutoverJob
	112, // 236: google.cloud.vmmigration.v1.VmMigration.ListGroups:output_type -> google.cloud.vmmigration.v1.ListGroupsResponse
	110, // 237: google.cloud.vmmigration.v1.VmMigration.GetGroup:output_type -> google.cloud.vmmigration.v1.Group
	149, // 238: google.cloud.vmmigration.v1.VmMigration.CreateGroup:output_type -> google.longrunning.Operation
	149, // 239: google.cloud.vmmigration.v1.VmMigration.UpdateGroup:output_type -> google.longrunning.Operation
	149, // 240: google.cloud.vmmigration.v1.VmMigration.DeleteGroup:output_type -> google.longrunning.Operation
	149, // 241: google.cloud.vmmigration.v1.VmMigration.AddGroupMigration:output_type -> google.longrunning.Operation
	149, // 242: google.cloud.vmmigration.v1.VmMigration.RemoveGroupMigration:output_type -> google.longrunning.Operation
	106, // 243: google.cloud.vmmigration.v1.VmMigration.ListTargetProjects:output_type -> google.cloud.vmmigration.v1.ListTargetProjectsResponse
	103, // 244: google.cloud.vmmigration.v1.VmMigration.GetTargetProject:output_type -> google.cloud.vmmigration.v1.TargetProject
	149, // 245: google.cloud.vmmigration.v1.VmMigration.CreateTargetProject:output_type -> google.longrunning.Operation
	149, // 246: google.cloud.vmmigration.v1.VmMigration.UpdateTargetProject:output_type -> google.longrunning.Operation
	149, // 247: google.cloud.vmmigration.v1.VmMigration.DeleteTargetProject:output_type -> google.longrunning.Operation
	131, // 248: google.cloud.vmmigration.v1.VmMigration.ListReplicationCycles:output_type -> google.cloud.vmmigration.v1.ListReplicationCyclesResponse
	26,  // 249: google.cloud.vmmigration.v1.VmMigration.GetReplicationCycle:output_type -> google.cloud.vmmigration.v1.ReplicationCycle
	204, // [204:250] is the sub-list for method output_type
	158, // [158:204] is the sub-list for method input_type
	158, // [158:158] is the sub-list for extension type_name
	158, // [158:158] is the sub-list for extension extendee
	0,   // [0:158] is the sub-list for field type_name
}

func init() { file_google_cloud_vmmigration_v1_vmmigration_proto_init() }
func file_google_cloud_vmmigration_v1_vmmigration_proto_init() {
	if File_google_cloud_vmmigration_v1_vmmigration_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationCycle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CycleStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitializingReplicationStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicatingStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostProcessingStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationSync); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigratingVm); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloneJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloneStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptingOSStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreparingVMDisksStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstantiatingMigratedVMStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CutoverJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CutoverStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShuttingDownSourceVMStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCloneJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelCloneJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelCloneJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloneJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloneJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCloneJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareSourceDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsSourceDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatacenterConnector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailableUpdates); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplianceVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchInventoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareVmDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsVmDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsSecurityGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareVmsDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsVmsDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchInventoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UtilizationReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmUtilizationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmUtilizationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUtilizationReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUtilizationReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetUtilizationReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateUtilizationReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteUtilizationReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDatacenterConnectorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatacenterConnectorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDatacenterConnectorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDatacenterConnectorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeApplianceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeApplianceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDatacenterConnectorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeEngineTargetDefaults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeEngineTargetDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkInterface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppliedLicense); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchedulingNodeAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeScheduling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchedulePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMigratingVmRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMigratingVmsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMigratingVmsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMigratingVmRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMigratingVmRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMigratingVmRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartMigrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartMigrationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseMigrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseMigrationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeMigrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeMigrationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeMigrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeMigrationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetProject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTargetProjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetProjectsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetProjectsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTargetProjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTargetProjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTargetProjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Group); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddGroupMigrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddGroupMigrationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveGroupMigrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveGroupMigrationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCutoverJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelCutoverJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelCutoverJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCutoverJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCutoverJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCutoverJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsSourceVmDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReplicationCyclesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReplicationCyclesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReplicationCycleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsSourceDetails_AccessKeyCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsSourceDetails_Tag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*CycleStep_InitializingReplication)(nil),
		(*CycleStep_Replicating)(nil),
		(*CycleStep_PostProcessing)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*MigratingVm_ComputeEngineTargetDefaults)(nil),
		(*MigratingVm_AwsSourceVmDetails)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*CloneJob_ComputeEngineTargetDetails)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*CloneStep_AdaptingOs)(nil),
		(*CloneStep_PreparingVmDisks)(nil),
		(*CloneStep_InstantiatingMigratedVm)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*CutoverJob_ComputeEngineTargetDetails)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*CutoverStep_PreviousReplicationCycle)(nil),
		(*CutoverStep_ShuttingDownSourceVm)(nil),
		(*CutoverStep_FinalSync)(nil),
		(*CutoverStep_PreparingVmDisks)(nil),
		(*CutoverStep_InstantiatingMigratedVm)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[21].OneofWrappers = []interface{}{
		(*Source_Vmware)(nil),
		(*Source_Aws)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*AwsSourceDetails_AccessKeyCreds)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[40].OneofWrappers = []interface{}{
		(*FetchInventoryResponse_VmwareVms)(nil),
		(*FetchInventoryResponse_AwsVms)(nil),
	}
	file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[42].OneofWrappers = []interface{}{
		(*VmUtilizationInfo_VmwareVmDetails)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vmmigration_v1_vmmigration_proto_rawDesc,
			NumEnums:      26,
			NumMessages:   117,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_vmmigration_v1_vmmigration_proto_goTypes,
		DependencyIndexes: file_google_cloud_vmmigration_v1_vmmigration_proto_depIdxs,
		EnumInfos:         file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes,
		MessageInfos:      file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes,
	}.Build()
	File_google_cloud_vmmigration_v1_vmmigration_proto = out.File
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDesc = nil
	file_google_cloud_vmmigration_v1_vmmigration_proto_goTypes = nil
	file_google_cloud_vmmigration_v1_vmmigration_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VmMigrationClient is the client API for VmMigration service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VmMigrationClient interface {
	// Lists Sources in a given project and location.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Gets details of a single Source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a new Source in a given project and location.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Source.
	DeleteSource(ctx context.Context, in *DeleteSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List remote source's inventory of VMs.
	// The remote source is the onprem vCenter (remote in the sense it's not in
	// Compute Engine). The inventory describes the list of existing VMs in that
	// source. Note that this operation lists the VMs on the remote source, as
	// opposed to listing the MigratingVms resources in the vmmigration service.
	FetchInventory(ctx context.Context, in *FetchInventoryRequest, opts ...grpc.CallOption) (*FetchInventoryResponse, error)
	// Lists Utilization Reports of the given Source.
	ListUtilizationReports(ctx context.Context, in *ListUtilizationReportsRequest, opts ...grpc.CallOption) (*ListUtilizationReportsResponse, error)
	// Gets a single Utilization Report.
	GetUtilizationReport(ctx context.Context, in *GetUtilizationReportRequest, opts ...grpc.CallOption) (*UtilizationReport, error)
	// Creates a new UtilizationReport.
	CreateUtilizationReport(ctx context.Context, in *CreateUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Utilization Report.
	DeleteUtilizationReport(ctx context.Context, in *DeleteUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DatacenterConnectors in a given Source.
	ListDatacenterConnectors(ctx context.Context, in *ListDatacenterConnectorsRequest, opts ...grpc.CallOption) (*ListDatacenterConnectorsResponse, error)
	// Gets details of a single DatacenterConnector.
	GetDatacenterConnector(ctx context.Context, in *GetDatacenterConnectorRequest, opts ...grpc.CallOption) (*DatacenterConnector, error)
	// Creates a new DatacenterConnector in a given Source.
	CreateDatacenterConnector(ctx context.Context, in *CreateDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DatacenterConnector.
	DeleteDatacenterConnector(ctx context.Context, in *DeleteDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upgrades the appliance relate to this DatacenterConnector to the in-place
	// updateable version.
	UpgradeAppliance(ctx context.Context, in *UpgradeApplianceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new MigratingVm in a given Source.
	CreateMigratingVm(ctx context.Context, in *CreateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists MigratingVms in a given Source.
	ListMigratingVms(ctx context.Context, in *ListMigratingVmsRequest, opts ...grpc.CallOption) (*ListMigratingVmsResponse, error)
	// Gets details of a single MigratingVm.
	GetMigratingVm(ctx context.Context, in *GetMigratingVmRequest, opts ...grpc.CallOption) (*MigratingVm, error)
	// Updates the parameters of a single MigratingVm.
	UpdateMigratingVm(ctx context.Context, in *UpdateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single MigratingVm.
	DeleteMigratingVm(ctx context.Context, in *DeleteMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts migration for a VM. Starts the process of uploading
	// data and creating snapshots, in replication cycles scheduled by the policy.
	StartMigration(ctx context.Context, in *StartMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resumes a migration for a VM. When called on a paused migration, will start
	// the process of uploading data and creating snapshots; when called on a
	// completed cut-over migration, will update the migration to active state and
	// start the process of uploading data and creating snapshots.
	ResumeMigration(ctx context.Context, in *ResumeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Pauses a migration for a VM. If cycle tasks are running they will be
	// cancelled, preserving source task data. Further replication cycles will not
	// be triggered while the VM is paused.
	PauseMigration(ctx context.Context, in *PauseMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Marks a migration as completed, deleting migration resources that are no
	// longer being used. Only applicable after cutover is done.
	FinalizeMigration(ctx context.Context, in *FinalizeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Initiates a Clone of a specific migrating VM.
	CreateCloneJob(ctx context.Context, in *CreateCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running clone job.
	CancelCloneJob(ctx context.Context, in *CancelCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CloneJobs of a given migrating VM.
	ListCloneJobs(ctx context.Context, in *ListCloneJobsRequest, opts ...grpc.CallOption) (*ListCloneJobsResponse, error)
	// Gets details of a single CloneJob.
	GetCloneJob(ctx context.Context, in *GetCloneJobRequest, opts ...grpc.CallOption) (*CloneJob, error)
	// Initiates a Cutover of a specific migrating VM.
	// The returned LRO is completed when the cutover job resource is created
	// and the job is initiated.
	CreateCutoverJob(ctx context.Context, in *CreateCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running cutover job.
	CancelCutoverJob(ctx context.Context, in *CancelCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CutoverJobs of a given migrating VM.
	ListCutoverJobs(ctx context.Context, in *ListCutoverJobsRequest, opts ...grpc.CallOption) (*ListCutoverJobsResponse, error)
	// Gets details of a single CutoverJob.
	GetCutoverJob(ctx context.Context, in *GetCutoverJobRequest, opts ...grpc.CallOption) (*CutoverJob, error)
	// Lists Groups in a given project and location.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// Gets details of a single Group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error)
	// Creates a new Group in a given project and location.
	CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Group.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Group.
	DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds a MigratingVm to a Group.
	AddGroupMigration(ctx context.Context, in *AddGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes a MigratingVm from a Group.
	RemoveGroupMigration(ctx context.Context, in *RemoveGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists TargetProjects in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	ListTargetProjects(ctx context.Context, in *ListTargetProjectsRequest, opts ...grpc.CallOption) (*ListTargetProjectsResponse, error)
	// Gets details of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	GetTargetProject(ctx context.Context, in *GetTargetProjectRequest, opts ...grpc.CallOption) (*TargetProject, error)
	// Creates a new TargetProject in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	CreateTargetProject(ctx context.Context, in *CreateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	UpdateTargetProject(ctx context.Context, in *UpdateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	DeleteTargetProject(ctx context.Context, in *DeleteTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ReplicationCycles in a given MigratingVM.
	ListReplicationCycles(ctx context.Context, in *ListReplicationCyclesRequest, opts ...grpc.CallOption) (*ListReplicationCyclesResponse, error)
	// Gets details of a single ReplicationCycle.
	GetReplicationCycle(ctx context.Context, in *GetReplicationCycleRequest, opts ...grpc.CallOption) (*ReplicationCycle, error)
}

type vmMigrationClient struct {
	cc grpc.ClientConnInterface
}

func NewVmMigrationClient(cc grpc.ClientConnInterface) VmMigrationClient {
	return &vmMigrationClient{cc}
}

func (c *vmMigrationClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteSource(ctx context.Context, in *DeleteSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/DeleteSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) FetchInventory(ctx context.Context, in *FetchInventoryRequest, opts ...grpc.CallOption) (*FetchInventoryResponse, error) {
	out := new(FetchInventoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/FetchInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListUtilizationReports(ctx context.Context, in *ListUtilizationReportsRequest, opts ...grpc.CallOption) (*ListUtilizationReportsResponse, error) {
	out := new(ListUtilizationReportsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListUtilizationReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetUtilizationReport(ctx context.Context, in *GetUtilizationReportRequest, opts ...grpc.CallOption) (*UtilizationReport, error) {
	out := new(UtilizationReport)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetUtilizationReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateUtilizationReport(ctx context.Context, in *CreateUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateUtilizationReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteUtilizationReport(ctx context.Context, in *DeleteUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/DeleteUtilizationReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListDatacenterConnectors(ctx context.Context, in *ListDatacenterConnectorsRequest, opts ...grpc.CallOption) (*ListDatacenterConnectorsResponse, error) {
	out := new(ListDatacenterConnectorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListDatacenterConnectors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetDatacenterConnector(ctx context.Context, in *GetDatacenterConnectorRequest, opts ...grpc.CallOption) (*DatacenterConnector, error) {
	out := new(DatacenterConnector)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetDatacenterConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateDatacenterConnector(ctx context.Context, in *CreateDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateDatacenterConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteDatacenterConnector(ctx context.Context, in *DeleteDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/DeleteDatacenterConnector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpgradeAppliance(ctx context.Context, in *UpgradeApplianceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/UpgradeAppliance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateMigratingVm(ctx context.Context, in *CreateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateMigratingVm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListMigratingVms(ctx context.Context, in *ListMigratingVmsRequest, opts ...grpc.CallOption) (*ListMigratingVmsResponse, error) {
	out := new(ListMigratingVmsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListMigratingVms", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetMigratingVm(ctx context.Context, in *GetMigratingVmRequest, opts ...grpc.CallOption) (*MigratingVm, error) {
	out := new(MigratingVm)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetMigratingVm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateMigratingVm(ctx context.Context, in *UpdateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/UpdateMigratingVm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteMigratingVm(ctx context.Context, in *DeleteMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/DeleteMigratingVm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) StartMigration(ctx context.Context, in *StartMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/StartMigration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ResumeMigration(ctx context.Context, in *ResumeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ResumeMigration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) PauseMigration(ctx context.Context, in *PauseMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/PauseMigration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) FinalizeMigration(ctx context.Context, in *FinalizeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/FinalizeMigration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateCloneJob(ctx context.Context, in *CreateCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateCloneJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CancelCloneJob(ctx context.Context, in *CancelCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CancelCloneJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListCloneJobs(ctx context.Context, in *ListCloneJobsRequest, opts ...grpc.CallOption) (*ListCloneJobsResponse, error) {
	out := new(ListCloneJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListCloneJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetCloneJob(ctx context.Context, in *GetCloneJobRequest, opts ...grpc.CallOption) (*CloneJob, error) {
	out := new(CloneJob)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetCloneJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateCutoverJob(ctx context.Context, in *CreateCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateCutoverJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CancelCutoverJob(ctx context.Context, in *CancelCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CancelCutoverJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListCutoverJobs(ctx context.Context, in *ListCutoverJobsRequest, opts ...grpc.CallOption) (*ListCutoverJobsResponse, error) {
	out := new(ListCutoverJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListCutoverJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetCutoverJob(ctx context.Context, in *GetCutoverJobRequest, opts ...grpc.CallOption) (*CutoverJob, error) {
	out := new(CutoverJob)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetCutoverJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/DeleteGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) AddGroupMigration(ctx context.Context, in *AddGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/AddGroupMigration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) RemoveGroupMigration(ctx context.Context, in *RemoveGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/RemoveGroupMigration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListTargetProjects(ctx context.Context, in *ListTargetProjectsRequest, opts ...grpc.CallOption) (*ListTargetProjectsResponse, error) {
	out := new(ListTargetProjectsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListTargetProjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetTargetProject(ctx context.Context, in *GetTargetProjectRequest, opts ...grpc.CallOption) (*TargetProject, error) {
	out := new(TargetProject)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetTargetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateTargetProject(ctx context.Context, in *CreateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/CreateTargetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateTargetProject(ctx context.Context, in *UpdateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/UpdateTargetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteTargetProject(ctx context.Context, in *DeleteTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/DeleteTargetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListReplicationCycles(ctx context.Context, in *ListReplicationCyclesRequest, opts ...grpc.CallOption) (*ListReplicationCyclesResponse, error) {
	out := new(ListReplicationCyclesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/ListReplicationCycles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetReplicationCycle(ctx context.Context, in *GetReplicationCycleRequest, opts ...grpc.CallOption) (*ReplicationCycle, error) {
	out := new(ReplicationCycle)
	err := c.cc.Invoke(ctx, "/google.cloud.vmmigration.v1.VmMigration/GetReplicationCycle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VmMigrationServer is the server API for VmMigration service.
type VmMigrationServer interface {
	// Lists Sources in a given project and location.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Gets details of a single Source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Creates a new Source in a given project and location.
	CreateSource(context.Context, *CreateSourceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*longrunningpb.Operation, error)
	// Deletes a single Source.
	DeleteSource(context.Context, *DeleteSourceRequest) (*longrunningpb.Operation, error)
	// List remote source's inventory of VMs.
	// The remote source is the onprem vCenter (remote in the sense it's not in
	// Compute Engine). The inventory describes the list of existing VMs in that
	// source. Note that this operation lists the VMs on the remote source, as
	// opposed to listing the MigratingVms resources in the vmmigration service.
	FetchInventory(context.Context, *FetchInventoryRequest) (*FetchInventoryResponse, error)
	// Lists Utilization Reports of the given Source.
	ListUtilizationReports(context.Context, *ListUtilizationReportsRequest) (*ListUtilizationReportsResponse, error)
	// Gets a single Utilization Report.
	GetUtilizationReport(context.Context, *GetUtilizationReportRequest) (*UtilizationReport, error)
	// Creates a new UtilizationReport.
	CreateUtilizationReport(context.Context, *CreateUtilizationReportRequest) (*longrunningpb.Operation, error)
	// Deletes a single Utilization Report.
	DeleteUtilizationReport(context.Context, *DeleteUtilizationReportRequest) (*longrunningpb.Operation, error)
	// Lists DatacenterConnectors in a given Source.
	ListDatacenterConnectors(context.Context, *ListDatacenterConnectorsRequest) (*ListDatacenterConnectorsResponse, error)
	// Gets details of a single DatacenterConnector.
	GetDatacenterConnector(context.Context, *GetDatacenterConnectorRequest) (*DatacenterConnector, error)
	// Creates a new DatacenterConnector in a given Source.
	CreateDatacenterConnector(context.Context, *CreateDatacenterConnectorRequest) (*longrunningpb.Operation, error)
	// Deletes a single DatacenterConnector.
	DeleteDatacenterConnector(context.Context, *DeleteDatacenterConnectorRequest) (*longrunningpb.Operation, error)
	// Upgrades the appliance relate to this DatacenterConnector to the in-place
	// updateable version.
	UpgradeAppliance(context.Context, *UpgradeApplianceRequest) (*longrunningpb.Operation, error)
	// Creates a new MigratingVm in a given Source.
	CreateMigratingVm(context.Context, *CreateMigratingVmRequest) (*longrunningpb.Operation, error)
	// Lists MigratingVms in a given Source.
	ListMigratingVms(context.Context, *ListMigratingVmsRequest) (*ListMigratingVmsResponse, error)
	// Gets details of a single MigratingVm.
	GetMigratingVm(context.Context, *GetMigratingVmRequest) (*MigratingVm, error)
	// Updates the parameters of a single MigratingVm.
	UpdateMigratingVm(context.Context, *UpdateMigratingVmRequest) (*longrunningpb.Operation, error)
	// Deletes a single MigratingVm.
	DeleteMigratingVm(context.Context, *DeleteMigratingVmRequest) (*longrunningpb.Operation, error)
	// Starts migration for a VM. Starts the process of uploading
	// data and creating snapshots, in replication cycles scheduled by the policy.
	StartMigration(context.Context, *StartMigrationRequest) (*longrunningpb.Operation, error)
	// Resumes a migration for a VM. When called on a paused migration, will start
	// the process of uploading data and creating snapshots; when called on a
	// completed cut-over migration, will update the migration to active state and
	// start the process of uploading data and creating snapshots.
	ResumeMigration(context.Context, *ResumeMigrationRequest) (*longrunningpb.Operation, error)
	// Pauses a migration for a VM. If cycle tasks are running they will be
	// cancelled, preserving source task data. Further replication cycles will not
	// be triggered while the VM is paused.
	PauseMigration(context.Context, *PauseMigrationRequest) (*longrunningpb.Operation, error)
	// Marks a migration as completed, deleting migration resources that are no
	// longer being used. Only applicable after cutover is done.
	FinalizeMigration(context.Context, *FinalizeMigrationRequest) (*longrunningpb.Operation, error)
	// Initiates a Clone of a specific migrating VM.
	CreateCloneJob(context.Context, *CreateCloneJobRequest) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running clone job.
	CancelCloneJob(context.Context, *CancelCloneJobRequest) (*longrunningpb.Operation, error)
	// Lists CloneJobs of a given migrating VM.
	ListCloneJobs(context.Context, *ListCloneJobsRequest) (*ListCloneJobsResponse, error)
	// Gets details of a single CloneJob.
	GetCloneJob(context.Context, *GetCloneJobRequest) (*CloneJob, error)
	// Initiates a Cutover of a specific migrating VM.
	// The returned LRO is completed when the cutover job resource is created
	// and the job is initiated.
	CreateCutoverJob(context.Context, *CreateCutoverJobRequest) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running cutover job.
	CancelCutoverJob(context.Context, *CancelCutoverJobRequest) (*longrunningpb.Operation, error)
	// Lists CutoverJobs of a given migrating VM.
	ListCutoverJobs(context.Context, *ListCutoverJobsRequest) (*ListCutoverJobsResponse, error)
	// Gets details of a single CutoverJob.
	GetCutoverJob(context.Context, *GetCutoverJobRequest) (*CutoverJob, error)
	// Lists Groups in a given project and location.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// Gets details of a single Group.
	GetGroup(context.Context, *GetGroupRequest) (*Group, error)
	// Creates a new Group in a given project and location.
	CreateGroup(context.Context, *CreateGroupRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Group.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error)
	// Deletes a single Group.
	DeleteGroup(context.Context, *DeleteGroupRequest) (*longrunningpb.Operation, error)
	// Adds a MigratingVm to a Group.
	AddGroupMigration(context.Context, *AddGroupMigrationRequest) (*longrunningpb.Operation, error)
	// Removes a MigratingVm from a Group.
	RemoveGroupMigration(context.Context, *RemoveGroupMigrationRequest) (*longrunningpb.Operation, error)
	// Lists TargetProjects in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	ListTargetProjects(context.Context, *ListTargetProjectsRequest) (*ListTargetProjectsResponse, error)
	// Gets details of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	GetTargetProject(context.Context, *GetTargetProjectRequest) (*TargetProject, error)
	// Creates a new TargetProject in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	CreateTargetProject(context.Context, *CreateTargetProjectRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	UpdateTargetProject(context.Context, *UpdateTargetProjectRequest) (*longrunningpb.Operation, error)
	// Deletes a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	DeleteTargetProject(context.Context, *DeleteTargetProjectRequest) (*longrunningpb.Operation, error)
	// Lists ReplicationCycles in a given MigratingVM.
	ListReplicationCycles(context.Context, *ListReplicationCyclesRequest) (*ListReplicationCyclesResponse, error)
	// Gets details of a single ReplicationCycle.
	GetReplicationCycle(context.Context, *GetReplicationCycleRequest) (*ReplicationCycle, error)
}

// UnimplementedVmMigrationServer can be embedded to have forward compatible implementations.
type UnimplementedVmMigrationServer struct {
}

func (*UnimplementedVmMigrationServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (*UnimplementedVmMigrationServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (*UnimplementedVmMigrationServer) CreateSource(context.Context, *CreateSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (*UnimplementedVmMigrationServer) UpdateSource(context.Context, *UpdateSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (*UnimplementedVmMigrationServer) DeleteSource(context.Context, *DeleteSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSource not implemented")
}
func (*UnimplementedVmMigrationServer) FetchInventory(context.Context, *FetchInventoryRequest) (*FetchInventoryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchInventory not implemented")
}
func (*UnimplementedVmMigrationServer) ListUtilizationReports(context.Context, *ListUtilizationReportsRequest) (*ListUtilizationReportsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListUtilizationReports not implemented")
}
func (*UnimplementedVmMigrationServer) GetUtilizationReport(context.Context, *GetUtilizationReportRequest) (*UtilizationReport, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetUtilizationReport not implemented")
}
func (*UnimplementedVmMigrationServer) CreateUtilizationReport(context.Context, *CreateUtilizationReportRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateUtilizationReport not implemented")
}
func (*UnimplementedVmMigrationServer) DeleteUtilizationReport(context.Context, *DeleteUtilizationReportRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteUtilizationReport not implemented")
}
func (*UnimplementedVmMigrationServer) ListDatacenterConnectors(context.Context, *ListDatacenterConnectorsRequest) (*ListDatacenterConnectorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDatacenterConnectors not implemented")
}
func (*UnimplementedVmMigrationServer) GetDatacenterConnector(context.Context, *GetDatacenterConnectorRequest) (*DatacenterConnector, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDatacenterConnector not implemented")
}
func (*UnimplementedVmMigrationServer) CreateDatacenterConnector(context.Context, *CreateDatacenterConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDatacenterConnector not implemented")
}
func (*UnimplementedVmMigrationServer) DeleteDatacenterConnector(context.Context, *DeleteDatacenterConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDatacenterConnector not implemented")
}
func (*UnimplementedVmMigrationServer) UpgradeAppliance(context.Context, *UpgradeApplianceRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpgradeAppliance not implemented")
}
func (*UnimplementedVmMigrationServer) CreateMigratingVm(context.Context, *CreateMigratingVmRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateMigratingVm not implemented")
}
func (*UnimplementedVmMigrationServer) ListMigratingVms(context.Context, *ListMigratingVmsRequest) (*ListMigratingVmsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListMigratingVms not implemented")
}
func (*UnimplementedVmMigrationServer) GetMigratingVm(context.Context, *GetMigratingVmRequest) (*MigratingVm, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetMigratingVm not implemented")
}
func (*UnimplementedVmMigrationServer) UpdateMigratingVm(context.Context, *UpdateMigratingVmRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateMigratingVm not implemented")
}
func (*UnimplementedVmMigrationServer) DeleteMigratingVm(context.Context, *DeleteMigratingVmRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteMigratingVm not implemented")
}
func (*UnimplementedVmMigrationServer) StartMigration(context.Context, *StartMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method StartMigration not implemented")
}
func (*UnimplementedVmMigrationServer) ResumeMigration(context.Context, *ResumeMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ResumeMigration not implemented")
}
func (*UnimplementedVmMigrationServer) PauseMigration(context.Context, *PauseMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PauseMigration not implemented")
}
func (*UnimplementedVmMigrationServer) FinalizeMigration(context.Context, *FinalizeMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FinalizeMigration not implemented")
}
func (*UnimplementedVmMigrationServer) CreateCloneJob(context.Context, *CreateCloneJobRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCloneJob not implemented")
}
func (*UnimplementedVmMigrationServer) CancelCloneJob(context.Context, *CancelCloneJobRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelCloneJob not implemented")
}
func (*UnimplementedVmMigrationServer) ListCloneJobs(context.Context, *ListCloneJobsRequest) (*ListCloneJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCloneJobs not implemented")
}
func (*UnimplementedVmMigrationServer) GetCloneJob(context.Context, *GetCloneJobRequest) (*CloneJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCloneJob not implemented")
}
func (*UnimplementedVmMigrationServer) CreateCutoverJob(context.Context, *CreateCutoverJobRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCutoverJob not implemented")
}
func (*UnimplementedVmMigrationServer) CancelCutoverJob(context.Context, *CancelCutoverJobRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelCutoverJob not implemented")
}
func (*UnimplementedVmMigrationServer) ListCutoverJobs(context.Context, *ListCutoverJobsRequest) (*ListCutoverJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCutoverJobs not implemented")
}
func (*UnimplementedVmMigrationServer) GetCutoverJob(context.Context, *GetCutoverJobRequest) (*CutoverJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCutoverJob not implemented")
}
func (*UnimplementedVmMigrationServer) ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (*UnimplementedVmMigrationServer) GetGroup(context.Context, *GetGroupRequest) (*Group, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (*UnimplementedVmMigrationServer) CreateGroup(context.Context, *CreateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (*UnimplementedVmMigrationServer) UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}
func (*UnimplementedVmMigrationServer) DeleteGroup(context.Context, *DeleteGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteGroup not implemented")
}
func (*UnimplementedVmMigrationServer) AddGroupMigration(context.Context, *AddGroupMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddGroupMigration not implemented")
}
func (*UnimplementedVmMigrationServer) RemoveGroupMigration(context.Context, *RemoveGroupMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveGroupMigration not implemented")
}
func (*UnimplementedVmMigrationServer) ListTargetProjects(context.Context, *ListTargetProjectsRequest) (*ListTargetProjectsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListTargetProjects not implemented")
}
func (*UnimplementedVmMigrationServer) GetTargetProject(context.Context, *GetTargetProjectRequest) (*TargetProject, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetTargetProject not implemented")
}
func (*UnimplementedVmMigrationServer) CreateTargetProject(context.Context, *CreateTargetProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateTargetProject not implemented")
}
func (*UnimplementedVmMigrationServer) UpdateTargetProject(context.Context, *UpdateTargetProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateTargetProject not implemented")
}
func (*UnimplementedVmMigrationServer) DeleteTargetProject(context.Context, *DeleteTargetProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteTargetProject not implemented")
}
func (*UnimplementedVmMigrationServer) ListReplicationCycles(context.Context, *ListReplicationCyclesRequest) (*ListReplicationCyclesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReplicationCycles not implemented")
}
func (*UnimplementedVmMigrationServer) GetReplicationCycle(context.Context, *GetReplicationCycleRequest) (*ReplicationCycle, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReplicationCycle not implemented")
}

func RegisterVmMigrationServer(s *grpc.Server, srv VmMigrationServer) {
	s.RegisterService(&_VmMigration_serviceDesc, srv)
}

func _VmMigration_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/UpdateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/DeleteSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteSource(ctx, req.(*DeleteSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_FetchInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).FetchInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/FetchInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).FetchInventory(ctx, req.(*FetchInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListUtilizationReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUtilizationReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListUtilizationReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListUtilizationReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListUtilizationReports(ctx, req.(*ListUtilizationReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetUtilizationReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUtilizationReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetUtilizationReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetUtilizationReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetUtilizationReport(ctx, req.(*GetUtilizationReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateUtilizationReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUtilizationReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateUtilizationReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateUtilizationReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateUtilizationReport(ctx, req.(*CreateUtilizationReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteUtilizationReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUtilizationReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteUtilizationReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/DeleteUtilizationReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteUtilizationReport(ctx, req.(*DeleteUtilizationReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListDatacenterConnectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatacenterConnectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListDatacenterConnectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListDatacenterConnectors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListDatacenterConnectors(ctx, req.(*ListDatacenterConnectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetDatacenterConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatacenterConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetDatacenterConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetDatacenterConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetDatacenterConnector(ctx, req.(*GetDatacenterConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateDatacenterConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatacenterConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateDatacenterConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateDatacenterConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateDatacenterConnector(ctx, req.(*CreateDatacenterConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteDatacenterConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatacenterConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteDatacenterConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/DeleteDatacenterConnector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteDatacenterConnector(ctx, req.(*DeleteDatacenterConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpgradeAppliance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeApplianceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpgradeAppliance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/UpgradeAppliance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpgradeAppliance(ctx, req.(*UpgradeApplianceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateMigratingVm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateMigratingVm(ctx, req.(*CreateMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListMigratingVms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigratingVmsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListMigratingVms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListMigratingVms",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListMigratingVms(ctx, req.(*ListMigratingVmsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetMigratingVm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetMigratingVm(ctx, req.(*GetMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/UpdateMigratingVm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateMigratingVm(ctx, req.(*UpdateMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/DeleteMigratingVm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteMigratingVm(ctx, req.(*DeleteMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_StartMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).StartMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/StartMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).StartMigration(ctx, req.(*StartMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ResumeMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ResumeMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ResumeMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ResumeMigration(ctx, req.(*ResumeMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_PauseMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).PauseMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/PauseMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).PauseMigration(ctx, req.(*PauseMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_FinalizeMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).FinalizeMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/FinalizeMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).FinalizeMigration(ctx, req.(*FinalizeMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateCloneJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCloneJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateCloneJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateCloneJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateCloneJob(ctx, req.(*CreateCloneJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CancelCloneJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelCloneJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CancelCloneJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CancelCloneJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CancelCloneJob(ctx, req.(*CancelCloneJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListCloneJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCloneJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListCloneJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListCloneJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListCloneJobs(ctx, req.(*ListCloneJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetCloneJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCloneJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetCloneJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetCloneJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetCloneJob(ctx, req.(*GetCloneJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateCutoverJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCutoverJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateCutoverJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateCutoverJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateCutoverJob(ctx, req.(*CreateCutoverJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CancelCutoverJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelCutoverJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CancelCutoverJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CancelCutoverJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CancelCutoverJob(ctx, req.(*CancelCutoverJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListCutoverJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCutoverJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListCutoverJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListCutoverJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListCutoverJobs(ctx, req.(*ListCutoverJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetCutoverJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCutoverJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetCutoverJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetCutoverJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetCutoverJob(ctx, req.(*GetCutoverJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateGroup(ctx, req.(*CreateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/DeleteGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteGroup(ctx, req.(*DeleteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_AddGroupMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddGroupMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).AddGroupMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/AddGroupMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).AddGroupMigration(ctx, req.(*AddGroupMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_RemoveGroupMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveGroupMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).RemoveGroupMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/RemoveGroupMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).RemoveGroupMigration(ctx, req.(*RemoveGroupMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListTargetProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListTargetProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListTargetProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListTargetProjects(ctx, req.(*ListTargetProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetTargetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetTargetProject(ctx, req.(*GetTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/CreateTargetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateTargetProject(ctx, req.(*CreateTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/UpdateTargetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateTargetProject(ctx, req.(*UpdateTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/DeleteTargetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteTargetProject(ctx, req.(*DeleteTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListReplicationCycles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReplicationCyclesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListReplicationCycles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/ListReplicationCycles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListReplicationCycles(ctx, req.(*ListReplicationCyclesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetReplicationCycle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationCycleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetReplicationCycle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmmigration.v1.VmMigration/GetReplicationCycle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetReplicationCycle(ctx, req.(*GetReplicationCycleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VmMigration_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vmmigration.v1.VmMigration",
	HandlerType: (*VmMigrationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSources",
			Handler:    _VmMigration_ListSources_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _VmMigration_GetSource_Handler,
		},
		{
			MethodName: "CreateSource",
			Handler:    _VmMigration_CreateSource_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _VmMigration_UpdateSource_Handler,
		},
		{
			MethodName: "DeleteSource",
			Handler:    _VmMigration_DeleteSource_Handler,
		},
		{
			MethodName: "FetchInventory",
			Handler:    _VmMigration_FetchInventory_Handler,
		},
		{
			MethodName: "ListUtilizationReports",
			Handler:    _VmMigration_ListUtilizationReports_Handler,
		},
		{
			MethodName: "GetUtilizationReport",
			Handler:    _VmMigration_GetUtilizationReport_Handler,
		},
		{
			MethodName: "CreateUtilizationReport",
			Handler:    _VmMigration_CreateUtilizationReport_Handler,
		},
		{
			MethodName: "DeleteUtilizationReport",
			Handler:    _VmMigration_DeleteUtilizationReport_Handler,
		},
		{
			MethodName: "ListDatacenterConnectors",
			Handler:    _VmMigration_ListDatacenterConnectors_Handler,
		},
		{
			MethodName: "GetDatacenterConnector",
			Handler:    _VmMigration_GetDatacenterConnector_Handler,
		},
		{
			MethodName: "CreateDatacenterConnector",
			Handler:    _VmMigration_CreateDatacenterConnector_Handler,
		},
		{
			MethodName: "DeleteDatacenterConnector",
			Handler:    _VmMigration_DeleteDatacenterConnector_Handler,
		},
		{
			MethodName: "UpgradeAppliance",
			Handler:    _VmMigration_UpgradeAppliance_Handler,
		},
		{
			MethodName: "CreateMigratingVm",
			Handler:    _VmMigration_CreateMigratingVm_Handler,
		},
		{
			MethodName: "ListMigratingVms",
			Handler:    _VmMigration_ListMigratingVms_Handler,
		},
		{
			MethodName: "GetMigratingVm",
			Handler:    _VmMigration_GetMigratingVm_Handler,
		},
		{
			MethodName: "UpdateMigratingVm",
			Handler:    _VmMigration_UpdateMigratingVm_Handler,
		},
		{
			MethodName: "DeleteMigratingVm",
			Handler:    _VmMigration_DeleteMigratingVm_Handler,
		},
		{
			MethodName: "StartMigration",
			Handler:    _VmMigration_StartMigration_Handler,
		},
		{
			MethodName: "ResumeMigration",
			Handler:    _VmMigration_ResumeMigration_Handler,
		},
		{
			MethodName: "PauseMigration",
			Handler:    _VmMigration_PauseMigration_Handler,
		},
		{
			MethodName: "FinalizeMigration",
			Handler:    _VmMigration_FinalizeMigration_Handler,
		},
		{
			MethodName: "CreateCloneJob",
			Handler:    _VmMigration_CreateCloneJob_Handler,
		},
		{
			MethodName: "CancelCloneJob",
			Handler:    _VmMigration_CancelCloneJob_Handler,
		},
		{
			MethodName: "ListCloneJobs",
			Handler:    _VmMigration_ListCloneJobs_Handler,
		},
		{
			MethodName: "GetCloneJob",
			Handler:    _VmMigration_GetCloneJob_Handler,
		},
		{
			MethodName: "CreateCutoverJob",
			Handler:    _VmMigration_CreateCutoverJob_Handler,
		},
		{
			MethodName: "CancelCutoverJob",
			Handler:    _VmMigration_CancelCutoverJob_Handler,
		},
		{
			MethodName: "ListCutoverJobs",
			Handler:    _VmMigration_ListCutoverJobs_Handler,
		},
		{
			MethodName: "GetCutoverJob",
			Handler:    _VmMigration_GetCutoverJob_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _VmMigration_ListGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _VmMigration_GetGroup_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _VmMigration_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _VmMigration_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _VmMigration_DeleteGroup_Handler,
		},
		{
			MethodName: "AddGroupMigration",
			Handler:    _VmMigration_AddGroupMigration_Handler,
		},
		{
			MethodName: "RemoveGroupMigration",
			Handler:    _VmMigration_RemoveGroupMigration_Handler,
		},
		{
			MethodName: "ListTargetProjects",
			Handler:    _VmMigration_ListTargetProjects_Handler,
		},
		{
			MethodName: "GetTargetProject",
			Handler:    _VmMigration_GetTargetProject_Handler,
		},
		{
			MethodName: "CreateTargetProject",
			Handler:    _VmMigration_CreateTargetProject_Handler,
		},
		{
			MethodName: "UpdateTargetProject",
			Handler:    _VmMigration_UpdateTargetProject_Handler,
		},
		{
			MethodName: "DeleteTargetProject",
			Handler:    _VmMigration_DeleteTargetProject_Handler,
		},
		{
			MethodName: "ListReplicationCycles",
			Handler:    _VmMigration_ListReplicationCycles_Handler,
		},
		{
			MethodName: "GetReplicationCycle",
			Handler:    _VmMigration_GetReplicationCycle_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vmmigration/v1/vmmigration.proto",
}
