// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/vision/v1p1beta1/image_annotator.proto

package visionpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A bucketized representation of likelihood, which is intended to give clients
// highly stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// It is very unlikely that the image belongs to the specified vertical.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// It is unlikely that the image belongs to the specified vertical.
	Likelihood_UNLIKELY Likelihood = 2
	// It is possible that the image belongs to the specified vertical.
	Likelihood_POSSIBLE Likelihood = 3
	// It is likely that the image belongs to the specified vertical.
	Likelihood_LIKELY Likelihood = 4
	// It is very likely that the image belongs to the specified vertical.
	Likelihood_VERY_LIKELY Likelihood = 5
)

// Enum value maps for Likelihood.
var (
	Likelihood_name = map[int32]string{
		0: "UNKNOWN",
		1: "VERY_UNLIKELY",
		2: "UNLIKELY",
		3: "POSSIBLE",
		4: "LIKELY",
		5: "VERY_LIKELY",
	}
	Likelihood_value = map[string]int32{
		"UNKNOWN":       0,
		"VERY_UNLIKELY": 1,
		"UNLIKELY":      2,
		"POSSIBLE":      3,
		"LIKELY":        4,
		"VERY_LIKELY":   5,
	}
)

func (x Likelihood) Enum() *Likelihood {
	p := new(Likelihood)
	*p = x
	return p
}

func (x Likelihood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Likelihood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes[0].Descriptor()
}

func (Likelihood) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes[0]
}

func (x Likelihood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Likelihood.Descriptor instead.
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{0}
}

// Type of image feature.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run OCR.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run dense text document OCR. Takes precedence when both
	// DOCUMENT_TEXT_DETECTION and TEXT_DETECTION are present.
	Feature_DOCUMENT_TEXT_DETECTION Feature_Type = 11
	// Run computer vision models to compute image safe-search properties.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of image properties, such as the image's dominant colors.
	Feature_IMAGE_PROPERTIES Feature_Type = 7
	// Run crop hints.
	Feature_CROP_HINTS Feature_Type = 9
	// Run web detection.
	Feature_WEB_DETECTION Feature_Type = 10
)

// Enum value maps for Feature_Type.
var (
	Feature_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "FACE_DETECTION",
		2:  "LANDMARK_DETECTION",
		3:  "LOGO_DETECTION",
		4:  "LABEL_DETECTION",
		5:  "TEXT_DETECTION",
		11: "DOCUMENT_TEXT_DETECTION",
		6:  "SAFE_SEARCH_DETECTION",
		7:  "IMAGE_PROPERTIES",
		9:  "CROP_HINTS",
		10: "WEB_DETECTION",
	}
	Feature_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":        0,
		"FACE_DETECTION":          1,
		"LANDMARK_DETECTION":      2,
		"LOGO_DETECTION":          3,
		"LABEL_DETECTION":         4,
		"TEXT_DETECTION":          5,
		"DOCUMENT_TEXT_DETECTION": 11,
		"SAFE_SEARCH_DETECTION":   6,
		"IMAGE_PROPERTIES":        7,
		"CROP_HINTS":              9,
		"WEB_DETECTION":           10,
	}
)

func (x Feature_Type) Enum() *Feature_Type {
	p := new(Feature_Type)
	*p = x
	return p
}

func (x Feature_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Feature_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes[1].Descriptor()
}

func (Feature_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes[1]
}

func (x Feature_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Feature_Type.Descriptor instead.
func (Feature_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{0, 0}
}

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image
// without considering mirror projections typical of photos. So, `LEFT_EYE`,
// typically, is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
)

// Enum value maps for FaceAnnotation_Landmark_Type.
var (
	FaceAnnotation_Landmark_Type_name = map[int32]string{
		0:  "UNKNOWN_LANDMARK",
		1:  "LEFT_EYE",
		2:  "RIGHT_EYE",
		3:  "LEFT_OF_LEFT_EYEBROW",
		4:  "RIGHT_OF_LEFT_EYEBROW",
		5:  "LEFT_OF_RIGHT_EYEBROW",
		6:  "RIGHT_OF_RIGHT_EYEBROW",
		7:  "MIDPOINT_BETWEEN_EYES",
		8:  "NOSE_TIP",
		9:  "UPPER_LIP",
		10: "LOWER_LIP",
		11: "MOUTH_LEFT",
		12: "MOUTH_RIGHT",
		13: "MOUTH_CENTER",
		14: "NOSE_BOTTOM_RIGHT",
		15: "NOSE_BOTTOM_LEFT",
		16: "NOSE_BOTTOM_CENTER",
		17: "LEFT_EYE_TOP_BOUNDARY",
		18: "LEFT_EYE_RIGHT_CORNER",
		19: "LEFT_EYE_BOTTOM_BOUNDARY",
		20: "LEFT_EYE_LEFT_CORNER",
		21: "RIGHT_EYE_TOP_BOUNDARY",
		22: "RIGHT_EYE_RIGHT_CORNER",
		23: "RIGHT_EYE_BOTTOM_BOUNDARY",
		24: "RIGHT_EYE_LEFT_CORNER",
		25: "LEFT_EYEBROW_UPPER_MIDPOINT",
		26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
		27: "LEFT_EAR_TRAGION",
		28: "RIGHT_EAR_TRAGION",
		29: "LEFT_EYE_PUPIL",
		30: "RIGHT_EYE_PUPIL",
		31: "FOREHEAD_GLABELLA",
		32: "CHIN_GNATHION",
		33: "CHIN_LEFT_GONION",
		34: "CHIN_RIGHT_GONION",
	}
	FaceAnnotation_Landmark_Type_value = map[string]int32{
		"UNKNOWN_LANDMARK":             0,
		"LEFT_EYE":                     1,
		"RIGHT_EYE":                    2,
		"LEFT_OF_LEFT_EYEBROW":         3,
		"RIGHT_OF_LEFT_EYEBROW":        4,
		"LEFT_OF_RIGHT_EYEBROW":        5,
		"RIGHT_OF_RIGHT_EYEBROW":       6,
		"MIDPOINT_BETWEEN_EYES":        7,
		"NOSE_TIP":                     8,
		"UPPER_LIP":                    9,
		"LOWER_LIP":                    10,
		"MOUTH_LEFT":                   11,
		"MOUTH_RIGHT":                  12,
		"MOUTH_CENTER":                 13,
		"NOSE_BOTTOM_RIGHT":            14,
		"NOSE_BOTTOM_LEFT":             15,
		"NOSE_BOTTOM_CENTER":           16,
		"LEFT_EYE_TOP_BOUNDARY":        17,
		"LEFT_EYE_RIGHT_CORNER":        18,
		"LEFT_EYE_BOTTOM_BOUNDARY":     19,
		"LEFT_EYE_LEFT_CORNER":         20,
		"RIGHT_EYE_TOP_BOUNDARY":       21,
		"RIGHT_EYE_RIGHT_CORNER":       22,
		"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
		"RIGHT_EYE_LEFT_CORNER":        24,
		"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
		"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
		"LEFT_EAR_TRAGION":             27,
		"RIGHT_EAR_TRAGION":            28,
		"LEFT_EYE_PUPIL":               29,
		"RIGHT_EYE_PUPIL":              30,
		"FOREHEAD_GLABELLA":            31,
		"CHIN_GNATHION":                32,
		"CHIN_LEFT_GONION":             33,
		"CHIN_RIGHT_GONION":            34,
	}
)

func (x FaceAnnotation_Landmark_Type) Enum() *FaceAnnotation_Landmark_Type {
	p := new(FaceAnnotation_Landmark_Type)
	*p = x
	return p
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FaceAnnotation_Landmark_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes[2].Descriptor()
}

func (FaceAnnotation_Landmark_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes[2]
}

func (x FaceAnnotation_Landmark_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FaceAnnotation_Landmark_Type.Descriptor instead.
func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{3, 0, 0}
}

// Users describe the type of Google Cloud Vision API tasks to perform over
// images by using *Feature*s. Each Feature indicates a type of image
// detection task to perform. Features encode the Cloud Vision API
// vertical to operate on and the number of top-scoring results to return.
type Feature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vision.v1p1beta1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Model to use for the feature.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest". `DOCUMENT_TEXT_DETECTION` and `TEXT_DETECTION` also
	// support "builtin/weekly" for the bleeding edge release updated weekly.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *Feature) Reset() {
	*x = Feature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Feature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feature) ProtoMessage() {}

func (x *Feature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feature.ProtoReflect.Descriptor instead.
func (*Feature) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{0}
}

func (x *Feature) GetType() Feature_Type {
	if x != nil {
		return x.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

func (x *Feature) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *Feature) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// External image source (Google Cloud Storage image location).
type ImageSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// NOTE: For new code `image_uri` below is preferred.
	// Google Cloud Storage image URI, which must be in the following form:
	// `gs://bucket_name/object_name` (for details, see
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris)).
	// NOTE: Cloud Storage object versioning is not supported.
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri,proto3" json:"gcs_image_uri,omitempty"`
	// Image URI which supports:
	// 1) Google Cloud Storage image URI, which must be in the following form:
	// `gs://bucket_name/object_name` (for details, see
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris)).
	// NOTE: Cloud Storage object versioning is not supported.
	// 2) Publicly accessible image HTTP/HTTPS URL.
	// This is preferred over the legacy `gcs_image_uri` above. When both
	// `gcs_image_uri` and `image_uri` are specified, `image_uri` takes
	// precedence.
	ImageUri string `protobuf:"bytes,2,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
}

func (x *ImageSource) Reset() {
	*x = ImageSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSource) ProtoMessage() {}

func (x *ImageSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSource.ProtoReflect.Descriptor instead.
func (*ImageSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{1}
}

func (x *ImageSource) GetGcsImageUri() string {
	if x != nil {
		return x.GcsImageUri
	}
	return ""
}

func (x *ImageSource) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Image content, represented as a stream of bytes.
	// Note: as with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location. If both `content` and `source`
	// are provided for an image, `content` takes precedence and is
	// used to perform the image annotation request.
	Source *ImageSource `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *Image) Reset() {
	*x = Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{2}
}

func (x *Image) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Image) GetSource() *ImageSource {
	if x != nil {
		return x.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale, as returned in `ImageParams`.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// `BoundingPoly` (the polygon will be unbounded) if only a partial face
	// appears in the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The `fd_bounding_poly` bounding polygon is tighter than the
	// `boundingPoly`, and encloses only the skin part of the face. Typically, it
	// is used to eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly,proto3" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	// Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
	// of the face relative to the image vertical about the axis perpendicular to
	// the face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle,proto3" json:"roll_angle,omitempty"`
	// Yaw angle, which indicates the leftward/rightward angle that the face is
	// pointing relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle,proto3" json:"pan_angle,omitempty"`
	// Pitch angle, which indicates the upwards/downwards angle that the face is
	// pointing relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle,proto3" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence,proto3" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence,proto3" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"headwear_likelihood,omitempty"`
}

func (x *FaceAnnotation) Reset() {
	*x = FaceAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceAnnotation) ProtoMessage() {}

func (x *FaceAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceAnnotation.ProtoReflect.Descriptor instead.
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{3}
}

func (x *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.FdBoundingPoly
	}
	return nil
}

func (x *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if x != nil {
		return x.Landmarks
	}
	return nil
}

func (x *FaceAnnotation) GetRollAngle() float32 {
	if x != nil {
		return x.RollAngle
	}
	return 0
}

func (x *FaceAnnotation) GetPanAngle() float32 {
	if x != nil {
		return x.PanAngle
	}
	return 0
}

func (x *FaceAnnotation) GetTiltAngle() float32 {
	if x != nil {
		return x.TiltAngle
	}
	return 0
}

func (x *FaceAnnotation) GetDetectionConfidence() float32 {
	if x != nil {
		return x.DetectionConfidence
	}
	return 0
}

func (x *FaceAnnotation) GetLandmarkingConfidence() float32 {
	if x != nil {
		return x.LandmarkingConfidence
	}
	return 0
}

func (x *FaceAnnotation) GetJoyLikelihood() Likelihood {
	if x != nil {
		return x.JoyLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetSorrowLikelihood() Likelihood {
	if x != nil {
		return x.SorrowLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetAngerLikelihood() Likelihood {
	if x != nil {
		return x.AngerLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetSurpriseLikelihood() Likelihood {
	if x != nil {
		return x.SurpriseLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetUnderExposedLikelihood() Likelihood {
	if x != nil {
		return x.UnderExposedLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetBlurredLikelihood() Likelihood {
	if x != nil {
		return x.BlurredLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetHeadwearLikelihood() Likelihood {
	if x != nil {
		return x.HeadwearLikelihood
	}
	return Likelihood_UNKNOWN
}

// Detected entity location information.
type LocationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// lat/long location coordinates.
	LatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
}

func (x *LocationInfo) Reset() {
	*x = LocationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationInfo) ProtoMessage() {}

func (x *LocationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationInfo.ProtoReflect.Descriptor instead.
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{4}
}

func (x *LocationInfo) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

// A `Property` consists of a user-supplied name/value pair.
type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Value of numeric properties.
	Uint64Value uint64 `protobuf:"varint,3,opt,name=uint64_value,json=uint64Value,proto3" json:"uint64_value,omitempty"`
}

func (x *Property) Reset() {
	*x = Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{5}
}

func (x *Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Property) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Property) GetUint64Value() uint64 {
	if x != nil {
		return x.Uint64Value
	}
	return 0
}

// Set of detected entity features.
type EntityAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	Mid string `protobuf:"bytes,1,opt,name=mid,proto3" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// `description` is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale,proto3" json:"locale,omitempty"`
	// Entity textual description, expressed in its `locale` language.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// The accuracy of the entity detection in an image.
	// For example, for an image in which the "Eiffel Tower" entity is detected,
	// this field represents the confidence that there is a tower in the query
	// image. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of "tower" is likely higher to an image
	// containing the detected "Eiffel Tower" than to an image containing a
	// detected distant towering building, even though the confidence that
	// there is a tower in each image may be the same. Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality,proto3" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Not produced
	// for `LABEL_DETECTION` features.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// `LocationInfo` elements can be present because one location may
	// indicate the location of the scene in the image, and another location
	// may indicate the location of the place where the image was taken.
	// Location information is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations,proto3" json:"locations,omitempty"`
	// Some entities may have optional user-supplied `Property` (name/value)
	// fields, such a score or string that qualifies the entity.
	Properties []*Property `protobuf:"bytes,9,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *EntityAnnotation) Reset() {
	*x = EntityAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityAnnotation) ProtoMessage() {}

func (x *EntityAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityAnnotation.ProtoReflect.Descriptor instead.
func (*EntityAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{6}
}

func (x *EntityAnnotation) GetMid() string {
	if x != nil {
		return x.Mid
	}
	return ""
}

func (x *EntityAnnotation) GetLocale() string {
	if x != nil {
		return x.Locale
	}
	return ""
}

func (x *EntityAnnotation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntityAnnotation) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *EntityAnnotation) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *EntityAnnotation) GetTopicality() float32 {
	if x != nil {
		return x.Topicality
	}
	return 0
}

func (x *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *EntityAnnotation) GetLocations() []*LocationInfo {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *EntityAnnotation) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Set of features pertaining to the image, computed by computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the adult content likelihood for the image. Adult content may
	// contain elements such as nudity, pornographic images or cartoons, or
	// sexual activities.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood that this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood that this image contains violent content.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"violence,omitempty"`
	// Likelihood that the request image contains racy content. Racy content may
	// include (but is not limited to) skimpy or sheer clothing, strategically
	// covered nudity, lewd or provocative poses, or close-ups of sensitive
	// body areas.
	Racy Likelihood `protobuf:"varint,9,opt,name=racy,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"racy,omitempty"`
}

func (x *SafeSearchAnnotation) Reset() {
	*x = SafeSearchAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SafeSearchAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafeSearchAnnotation) ProtoMessage() {}

func (x *SafeSearchAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafeSearchAnnotation.ProtoReflect.Descriptor instead.
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{7}
}

func (x *SafeSearchAnnotation) GetAdult() Likelihood {
	if x != nil {
		return x.Adult
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetSpoof() Likelihood {
	if x != nil {
		return x.Spoof
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetMedical() Likelihood {
	if x != nil {
		return x.Medical
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetViolence() Likelihood {
	if x != nil {
		return x.Violence
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetRacy() Likelihood {
	if x != nil {
		return x.Racy
	}
	return Likelihood_UNKNOWN
}

// Rectangle determined by min and max `LatLng` pairs.
type LatLongRect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Min lat/long pair.
	MinLatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng,proto3" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng *latlng.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng,proto3" json:"max_lat_lng,omitempty"`
}

func (x *LatLongRect) Reset() {
	*x = LatLongRect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LatLongRect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LatLongRect) ProtoMessage() {}

func (x *LatLongRect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LatLongRect.ProtoReflect.Descriptor instead.
func (*LatLongRect) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{8}
}

func (x *LatLongRect) GetMinLatLng() *latlng.LatLng {
	if x != nil {
		return x.MinLatLng
	}
	return nil
}

func (x *LatLongRect) GetMaxLatLng() *latlng.LatLng {
	if x != nil {
		return x.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score, and the fraction of
// the image that the color occupies in the image.
type ColorInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RGB components of the color.
	Color *color.Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
	// The fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction float32 `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction,proto3" json:"pixel_fraction,omitempty"`
}

func (x *ColorInfo) Reset() {
	*x = ColorInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColorInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColorInfo) ProtoMessage() {}

func (x *ColorInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColorInfo.ProtoReflect.Descriptor instead.
func (*ColorInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{9}
}

func (x *ColorInfo) GetColor() *color.Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *ColorInfo) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *ColorInfo) GetPixelFraction() float32 {
	if x != nil {
		return x.PixelFraction
	}
	return 0
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RGB color values with their score and pixel fraction.
	Colors []*ColorInfo `protobuf:"bytes,1,rep,name=colors,proto3" json:"colors,omitempty"`
}

func (x *DominantColorsAnnotation) Reset() {
	*x = DominantColorsAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DominantColorsAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DominantColorsAnnotation) ProtoMessage() {}

func (x *DominantColorsAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DominantColorsAnnotation.ProtoReflect.Descriptor instead.
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{10}
}

func (x *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if x != nil {
		return x.Colors
	}
	return nil
}

// Stores image properties, such as dominant colors.
type ImageProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If present, dominant colors completed successfully.
	DominantColors *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors,proto3" json:"dominant_colors,omitempty"`
}

func (x *ImageProperties) Reset() {
	*x = ImageProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageProperties) ProtoMessage() {}

func (x *ImageProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageProperties.ProtoReflect.Descriptor instead.
func (*ImageProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{11}
}

func (x *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if x != nil {
		return x.DominantColors
	}
	return nil
}

// Single crop hint that is used to generate a new crop when serving an image.
type CropHint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon for the crop region. The coordinates of the bounding
	// box are in the original image's scale, as returned in `ImageParams`.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Confidence of this being a salient region.  Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Fraction of importance of this salient region with respect to the original
	// image.
	ImportanceFraction float32 `protobuf:"fixed32,3,opt,name=importance_fraction,json=importanceFraction,proto3" json:"importance_fraction,omitempty"`
}

func (x *CropHint) Reset() {
	*x = CropHint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CropHint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CropHint) ProtoMessage() {}

func (x *CropHint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CropHint.ProtoReflect.Descriptor instead.
func (*CropHint) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{12}
}

func (x *CropHint) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *CropHint) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *CropHint) GetImportanceFraction() float32 {
	if x != nil {
		return x.ImportanceFraction
	}
	return 0
}

// Set of crop hints that are used to generate new crops when serving images.
type CropHintsAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Crop hint results.
	CropHints []*CropHint `protobuf:"bytes,1,rep,name=crop_hints,json=cropHints,proto3" json:"crop_hints,omitempty"`
}

func (x *CropHintsAnnotation) Reset() {
	*x = CropHintsAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CropHintsAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CropHintsAnnotation) ProtoMessage() {}

func (x *CropHintsAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CropHintsAnnotation.ProtoReflect.Descriptor instead.
func (*CropHintsAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{13}
}

func (x *CropHintsAnnotation) GetCropHints() []*CropHint {
	if x != nil {
		return x.CropHints
	}
	return nil
}

// Parameters for crop hints annotation request.
type CropHintsParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aspect ratios in floats, representing the ratio of the width to the height
	// of the image. For example, if the desired aspect ratio is 4/3, the
	// corresponding float value should be 1.33333.  If not specified, the
	// best possible crop is returned. The number of provided aspect ratios is
	// limited to a maximum of 16; any aspect ratios provided after the 16th are
	// ignored.
	AspectRatios []float32 `protobuf:"fixed32,1,rep,packed,name=aspect_ratios,json=aspectRatios,proto3" json:"aspect_ratios,omitempty"`
}

func (x *CropHintsParams) Reset() {
	*x = CropHintsParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CropHintsParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CropHintsParams) ProtoMessage() {}

func (x *CropHintsParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CropHintsParams.ProtoReflect.Descriptor instead.
func (*CropHintsParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{14}
}

func (x *CropHintsParams) GetAspectRatios() []float32 {
	if x != nil {
		return x.AspectRatios
	}
	return nil
}

// Parameters for web detection request.
type WebDetectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to include results derived from the geo information in the image.
	IncludeGeoResults bool `protobuf:"varint,2,opt,name=include_geo_results,json=includeGeoResults,proto3" json:"include_geo_results,omitempty"`
}

func (x *WebDetectionParams) Reset() {
	*x = WebDetectionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebDetectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebDetectionParams) ProtoMessage() {}

func (x *WebDetectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebDetectionParams.ProtoReflect.Descriptor instead.
func (*WebDetectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{15}
}

func (x *WebDetectionParams) GetIncludeGeoResults() bool {
	if x != nil {
		return x.IncludeGeoResults
	}
	return false
}

// Parameters for text detections. This is used to control TEXT_DETECTION and
// DOCUMENT_TEXT_DETECTION features.
type TextDetectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// By default, Cloud Vision API only includes confidence score for
	// DOCUMENT_TEXT_DETECTION result. Set the flag to true to include confidence
	// score for TEXT_DETECTION as well.
	EnableTextDetectionConfidenceScore bool `protobuf:"varint,9,opt,name=enable_text_detection_confidence_score,json=enableTextDetectionConfidenceScore,proto3" json:"enable_text_detection_confidence_score,omitempty"`
	// A list of advanced OCR options to fine-tune OCR behavior.
	AdvancedOcrOptions []string `protobuf:"bytes,11,rep,name=advanced_ocr_options,json=advancedOcrOptions,proto3" json:"advanced_ocr_options,omitempty"`
}

func (x *TextDetectionParams) Reset() {
	*x = TextDetectionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextDetectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextDetectionParams) ProtoMessage() {}

func (x *TextDetectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextDetectionParams.ProtoReflect.Descriptor instead.
func (*TextDetectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{16}
}

func (x *TextDetectionParams) GetEnableTextDetectionConfidenceScore() bool {
	if x != nil {
		return x.EnableTextDetectionConfidenceScore
	}
	return false
}

func (x *TextDetectionParams) GetAdvancedOcrOptions() []string {
	if x != nil {
		return x.AdvancedOcrOptions
	}
	return nil
}

// Image context and/or feature-specific parameters.
type ImageContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// lat/long rectangle that specifies the location of the image.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect,proto3" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported languages](https://cloud.google.com/vision/docs/languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Parameters for crop hints annotation request.
	CropHintsParams *CropHintsParams `protobuf:"bytes,4,opt,name=crop_hints_params,json=cropHintsParams,proto3" json:"crop_hints_params,omitempty"`
	// Parameters for web detection.
	WebDetectionParams *WebDetectionParams `protobuf:"bytes,6,opt,name=web_detection_params,json=webDetectionParams,proto3" json:"web_detection_params,omitempty"`
	// Parameters for text detection and document text detection.
	TextDetectionParams *TextDetectionParams `protobuf:"bytes,12,opt,name=text_detection_params,json=textDetectionParams,proto3" json:"text_detection_params,omitempty"`
}

func (x *ImageContext) Reset() {
	*x = ImageContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageContext) ProtoMessage() {}

func (x *ImageContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageContext.ProtoReflect.Descriptor instead.
func (*ImageContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{17}
}

func (x *ImageContext) GetLatLongRect() *LatLongRect {
	if x != nil {
		return x.LatLongRect
	}
	return nil
}

func (x *ImageContext) GetLanguageHints() []string {
	if x != nil {
		return x.LanguageHints
	}
	return nil
}

func (x *ImageContext) GetCropHintsParams() *CropHintsParams {
	if x != nil {
		return x.CropHintsParams
	}
	return nil
}

func (x *ImageContext) GetWebDetectionParams() *WebDetectionParams {
	if x != nil {
		return x.WebDetectionParams
	}
	return nil
}

func (x *ImageContext) GetTextDetectionParams() *TextDetectionParams {
	if x != nil {
		return x.TextDetectionParams
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features.
type AnnotateImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
}

func (x *AnnotateImageRequest) Reset() {
	*x = AnnotateImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateImageRequest) ProtoMessage() {}

func (x *AnnotateImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateImageRequest.ProtoReflect.Descriptor instead.
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{18}
}

func (x *AnnotateImageRequest) GetImage() *Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *AnnotateImageRequest) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateImageRequest) GetImageContext() *ImageContext {
	if x != nil {
		return x.ImageContext
	}
	return nil
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If present, face detection has completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// If present, landmark detection has completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations,proto3" json:"landmark_annotations,omitempty"`
	// If present, logo detection has completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations,proto3" json:"logo_annotations,omitempty"`
	// If present, label detection has completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// If present, text (OCR) detection has completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	// This annotation provides the structural hierarchy for the OCR detected
	// text.
	FullTextAnnotation *TextAnnotation `protobuf:"bytes,12,opt,name=full_text_annotation,json=fullTextAnnotation,proto3" json:"full_text_annotation,omitempty"`
	// If present, safe-search annotation has completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation,proto3" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation,proto3" json:"image_properties_annotation,omitempty"`
	// If present, crop hints have completed successfully.
	CropHintsAnnotation *CropHintsAnnotation `protobuf:"bytes,11,opt,name=crop_hints_annotation,json=cropHintsAnnotation,proto3" json:"crop_hints_annotation,omitempty"`
	// If present, web detection has completed successfully.
	WebDetection *WebDetection `protobuf:"bytes,13,opt,name=web_detection,json=webDetection,proto3" json:"web_detection,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in image annotations are guaranteed to be
	// correct, even when `error` is set.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *AnnotateImageResponse) Reset() {
	*x = AnnotateImageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateImageResponse) ProtoMessage() {}

func (x *AnnotateImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateImageResponse.ProtoReflect.Descriptor instead.
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{19}
}

func (x *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if x != nil {
		return x.FaceAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.LandmarkAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.LogoAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.LabelAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.TextAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetFullTextAnnotation() *TextAnnotation {
	if x != nil {
		return x.FullTextAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if x != nil {
		return x.SafeSearchAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if x != nil {
		return x.ImagePropertiesAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetCropHintsAnnotation() *CropHintsAnnotation {
	if x != nil {
		return x.CropHintsAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetWebDetection() *WebDetection {
	if x != nil {
		return x.WebDetection
	}
	return nil
}

func (x *AnnotateImageResponse) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchAnnotateImagesRequest) Reset() {
	*x = BatchAnnotateImagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchAnnotateImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchAnnotateImagesRequest) ProtoMessage() {}

func (x *BatchAnnotateImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchAnnotateImagesRequest.ProtoReflect.Descriptor instead.
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{20}
}

func (x *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual responses to image annotation requests within the batch.
	Responses []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *BatchAnnotateImagesResponse) Reset() {
	*x = BatchAnnotateImagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchAnnotateImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchAnnotateImagesResponse) ProtoMessage() {}

func (x *BatchAnnotateImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchAnnotateImagesResponse.ProtoReflect.Descriptor instead.
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{21}
}

func (x *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// A face-specific landmark (for example, a face feature).
type FaceAnnotation_Landmark struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.vision.v1p1beta1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position *Position `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
}

func (x *FaceAnnotation_Landmark) Reset() {
	*x = FaceAnnotation_Landmark{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceAnnotation_Landmark) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceAnnotation_Landmark) ProtoMessage() {}

func (x *FaceAnnotation_Landmark) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceAnnotation_Landmark.ProtoReflect.Descriptor instead.
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP(), []int{3, 0}
}

func (x *FaceAnnotation_Landmark) GetType() FaceAnnotation_Landmark_Type {
	if x != nil {
		return x.Type
	}
	return FaceAnnotation_Landmark_UNKNOWN_LANDMARK
}

func (x *FaceAnnotation_Landmark) GetPosition() *Position {
	if x != nil {
		return x.Position
	}
	return nil
}

var File_google_cloud_vision_v1p1beta1_image_annotator_proto protoreflect.FileDescriptor

var file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x6d,
	0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x77,
	0x65, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfa,
	0x02, 0x0a, 0x07, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x3f, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x22, 0xf6, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x41, 0x4e, 0x44, 0x4d, 0x41, 0x52,
	0x4b, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x12, 0x0a,
	0x0e, 0x4c, 0x4f, 0x47, 0x4f, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x44,
	0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x4f,
	0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x41, 0x46, 0x45, 0x5f,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x50,
	0x45, 0x52, 0x54, 0x49, 0x45, 0x53, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x52, 0x4f, 0x50,
	0x5f, 0x48, 0x49, 0x4e, 0x54, 0x53, 0x10, 0x09, 0x12, 0x11, 0x0a, 0x0d, 0x57, 0x45, 0x42, 0x5f,
	0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x22, 0x4e, 0x0a, 0x0b, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x67, 0x63,
	0x73, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x67, 0x63, 0x73, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1b,
	0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x22, 0x65, 0x0a, 0x05, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x42,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xa5, 0x10, 0x0a, 0x0e, 0x46, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x55, 0x0a, 0x10, 0x66, 0x64, 0x5f, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x0e,
	0x66, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x54,
	0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x52, 0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d,
	0x61, 0x72, 0x6b, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x5f, 0x61, 0x6e, 0x67,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x41, 0x6e,
	0x67, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x67, 0x6c, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x70, 0x61, 0x6e, 0x41, 0x6e, 0x67, 0x6c, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x69, 0x6c, 0x74, 0x5f, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x74, 0x69, 0x6c, 0x74, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x12,
	0x31, 0x0a, 0x14, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x35, 0x0a, 0x16, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x15, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0e, 0x6a, 0x6f, 0x79,
	0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x0d, 0x6a, 0x6f,
	0x79, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x56, 0x0a, 0x11, 0x73,
	0x6f, 0x72, 0x72, 0x6f, 0x77, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x52, 0x10, 0x73, 0x6f, 0x72, 0x72, 0x6f, 0x77, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x12, 0x54, 0x0a, 0x10, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x0f, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x4c,
	0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x5a, 0x0a, 0x13, 0x73, 0x75, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x52, 0x12, 0x73, 0x75, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x63, 0x0a, 0x18, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x65,
	0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f,
	0x6f, 0x64, 0x52, 0x16, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64,
	0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x58, 0x0a, 0x12, 0x62, 0x6c,
	0x75, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x52, 0x11, 0x62, 0x6c, 0x75, 0x72, 0x72, 0x65, 0x64, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69,
	0x68, 0x6f, 0x6f, 0x64, 0x12, 0x5a, 0x0a, 0x13, 0x68, 0x65, 0x61, 0x64, 0x77, 0x65, 0x61, 0x72,
	0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x12, 0x68, 0x65,
	0x61, 0x64, 0x77, 0x65, 0x61, 0x72, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x1a, 0xd7, 0x07, 0x0a, 0x08, 0x4c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x4f, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x6e, 0x64, 0x6d,
	0x61, 0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x43,
	0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x06, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x44, 0x4d, 0x41, 0x52, 0x4b,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x10, 0x02, 0x12,
	0x18, 0x0a, 0x14, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f,
	0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52,
	0x4f, 0x57, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x4f, 0x46, 0x5f,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x10, 0x05, 0x12,
	0x1a, 0x0a, 0x16, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x4d,
	0x49, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x42, 0x45, 0x54, 0x57, 0x45, 0x45, 0x4e, 0x5f,
	0x45, 0x59, 0x45, 0x53, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x54,
	0x49, 0x50, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x4c, 0x49,
	0x50, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x4c, 0x49, 0x50,
	0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x4f, 0x55, 0x54, 0x48, 0x5f, 0x4c, 0x45, 0x46, 0x54,
	0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x4f, 0x55, 0x54, 0x48, 0x5f, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x4f, 0x55, 0x54, 0x48, 0x5f, 0x43, 0x45, 0x4e,
	0x54, 0x45, 0x52, 0x10, 0x0d, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x42, 0x4f,
	0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10,
	0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x4c, 0x45, 0x46, 0x54,
	0x10, 0x0f, 0x12, 0x16, 0x0a, 0x12, 0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f,
	0x4d, 0x5f, 0x43, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x10, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x45,
	0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44,
	0x41, 0x52, 0x59, 0x10, 0x11, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59,
	0x45, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x12,
	0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x42, 0x4f, 0x54,
	0x54, 0x4f, 0x4d, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x13, 0x12, 0x18,
	0x0a, 0x14, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f,
	0x43, 0x4f, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x14, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41,
	0x52, 0x59, 0x10, 0x15, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59,
	0x45, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x16,
	0x12, 0x1d, 0x0a, 0x19, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x42, 0x4f,
	0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x17, 0x12,
	0x19, 0x0a, 0x15, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x4c, 0x45, 0x46,
	0x54, 0x5f, 0x43, 0x4f, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x18, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x45,
	0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52,
	0x5f, 0x4d, 0x49, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10, 0x19, 0x12, 0x20, 0x0a, 0x1c, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x5f, 0x55, 0x50, 0x50,
	0x45, 0x52, 0x5f, 0x4d, 0x49, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10, 0x1a, 0x12, 0x14, 0x0a,
	0x10, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x41, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x47, 0x49, 0x4f,
	0x4e, 0x10, 0x1b, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x41, 0x52,
	0x5f, 0x54, 0x52, 0x41, 0x47, 0x49, 0x4f, 0x4e, 0x10, 0x1c, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x45,
	0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x50, 0x55, 0x50, 0x49, 0x4c, 0x10, 0x1d, 0x12, 0x13,
	0x0a, 0x0f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x50, 0x55, 0x50, 0x49,
	0x4c, 0x10, 0x1e, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x4f, 0x52, 0x45, 0x48, 0x45, 0x41, 0x44, 0x5f,
	0x47, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x4c, 0x41, 0x10, 0x1f, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x48,
	0x49, 0x4e, 0x5f, 0x47, 0x4e, 0x41, 0x54, 0x48, 0x49, 0x4f, 0x4e, 0x10, 0x20, 0x12, 0x14, 0x0a,
	0x10, 0x43, 0x48, 0x49, 0x4e, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x47, 0x4f, 0x4e, 0x49, 0x4f,
	0x4e, 0x10, 0x21, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x48, 0x49, 0x4e, 0x5f, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x47, 0x4f, 0x4e, 0x49, 0x4f, 0x4e, 0x10, 0x22, 0x22, 0x3c, 0x0a, 0x0c, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x07, 0x6c, 0x61,
	0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67,
	0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x22, 0x57, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x9a, 0x03, 0x0a, 0x10, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x50, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x0c, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x49, 0x0a, 0x09, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xe3,
	0x02, 0x0a, 0x14, 0x53, 0x61, 0x66, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x05, 0x61, 0x64, 0x75, 0x6c, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x52, 0x05, 0x61, 0x64, 0x75, 0x6c, 0x74, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6f,
	0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f,
	0x6f, 0x64, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6f, 0x66, 0x12, 0x43, 0x0a, 0x07, 0x6d, 0x65, 0x64,
	0x69, 0x63, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x07, 0x6d, 0x65, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x45,
	0x0a, 0x08, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x08, 0x76, 0x69, 0x6f,
	0x6c, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x72, 0x61, 0x63, 0x79, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x04,
	0x72, 0x61, 0x63, 0x79, 0x22, 0x77, 0x0a, 0x0b, 0x4c, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52,
	0x65, 0x63, 0x74, 0x12, 0x33, 0x0a, 0x0b, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x74, 0x5f, 0x6c,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x12, 0x33, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f,
	0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c,
	0x6e, 0x67, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x22, 0x72, 0x0a,
	0x09, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x05, 0x63, 0x6f,
	0x6c, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x05, 0x63,
	0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0d, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5c, 0x0a, 0x18, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6c,
	0x6f, 0x72, 0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x06, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x22,
	0x73, 0x0a, 0x0f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x69,
	0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x73, 0x22, 0xad, 0x01, 0x0a, 0x08, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e,
	0x74, 0x12, 0x50, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f,
	0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x12, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5d, 0x0a, 0x13, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74,
	0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0a, 0x63,
	0x72, 0x6f, 0x70, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x63, 0x72, 0x6f, 0x70, 0x48, 0x69,
	0x6e, 0x74, 0x73, 0x22, 0x36, 0x0a, 0x0f, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x02, 0x52, 0x0c, 0x61,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x73, 0x22, 0x44, 0x0a, 0x12, 0x57,
	0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x67, 0x65, 0x6f,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x47, 0x65, 0x6f, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x22, 0x9b, 0x01, 0x0a, 0x13, 0x54, 0x65, 0x78, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x26, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x22, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x54, 0x65, 0x78, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x30, 0x0a,
	0x14, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6f, 0x63, 0x72, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x4f, 0x63, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xae, 0x03, 0x0a, 0x0c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x4e, 0x0a, 0x0d, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x63,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52,
	0x65, 0x63, 0x74, 0x52, 0x0b, 0x6c, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x68, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x63, 0x72, 0x6f, 0x70, 0x5f,
	0x68, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x52, 0x0f, 0x63, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x63, 0x0a, 0x14, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x52, 0x12, 0x77, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x66, 0x0a, 0x15, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x74, 0x65, 0x78,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x22, 0xe8, 0x01, 0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x42, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52,
	0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0c, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x8b, 0x08, 0x0a, 0x15,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x66, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x62, 0x0a, 0x14, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13,
	0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x6c, 0x6f, 0x67, 0x6f, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x6c, 0x6f, 0x67, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5c, 0x0a, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a,
	0x10, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x14, 0x66, 0x75, 0x6c,
	0x6c, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x16, 0x73, 0x61,
	0x66, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x14, 0x73, 0x61, 0x66, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x1b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x19, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x15, 0x63, 0x72, 0x6f, 0x70, 0x5f, 0x68, 0x69,
	0x6e, 0x74, 0x73, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x72, 0x6f, 0x70, 0x48, 0x69,
	0x6e, 0x74, 0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a,
	0x0d, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x77, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x72, 0x0a, 0x1a, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x71, 0x0a,
	0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73,
	0x2a, 0x65, 0x0a, 0x0a, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x0b,
	0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x56,
	0x45, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x50, 0x4f, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49,
	0x4b, 0x45, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c,
	0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x05, 0x32, 0xc9, 0x02, 0x0a, 0x0e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x12, 0xbe, 0x01, 0x0a, 0x13, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0xda, 0x41, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x3a, 0x01, 0x2a, 0x22,
	0x1a, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x76, 0xca, 0x41, 0x15,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5b, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x7b, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xf8, 0x01, 0x01,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescOnce sync.Once
	file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescData = file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDesc
)

func file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescGZIP() []byte {
	file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescOnce.Do(func() {
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescData)
	})
	return file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDescData
}

var file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_vision_v1p1beta1_image_annotator_proto_goTypes = []interface{}{
	(Likelihood)(0),                     // 0: google.cloud.vision.v1p1beta1.Likelihood
	(Feature_Type)(0),                   // 1: google.cloud.vision.v1p1beta1.Feature.Type
	(FaceAnnotation_Landmark_Type)(0),   // 2: google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.Type
	(*Feature)(nil),                     // 3: google.cloud.vision.v1p1beta1.Feature
	(*ImageSource)(nil),                 // 4: google.cloud.vision.v1p1beta1.ImageSource
	(*Image)(nil),                       // 5: google.cloud.vision.v1p1beta1.Image
	(*FaceAnnotation)(nil),              // 6: google.cloud.vision.v1p1beta1.FaceAnnotation
	(*LocationInfo)(nil),                // 7: google.cloud.vision.v1p1beta1.LocationInfo
	(*Property)(nil),                    // 8: google.cloud.vision.v1p1beta1.Property
	(*EntityAnnotation)(nil),            // 9: google.cloud.vision.v1p1beta1.EntityAnnotation
	(*SafeSearchAnnotation)(nil),        // 10: google.cloud.vision.v1p1beta1.SafeSearchAnnotation
	(*LatLongRect)(nil),                 // 11: google.cloud.vision.v1p1beta1.LatLongRect
	(*ColorInfo)(nil),                   // 12: google.cloud.vision.v1p1beta1.ColorInfo
	(*DominantColorsAnnotation)(nil),    // 13: google.cloud.vision.v1p1beta1.DominantColorsAnnotation
	(*ImageProperties)(nil),             // 14: google.cloud.vision.v1p1beta1.ImageProperties
	(*CropHint)(nil),                    // 15: google.cloud.vision.v1p1beta1.CropHint
	(*CropHintsAnnotation)(nil),         // 16: google.cloud.vision.v1p1beta1.CropHintsAnnotation
	(*CropHintsParams)(nil),             // 17: google.cloud.vision.v1p1beta1.CropHintsParams
	(*WebDetectionParams)(nil),          // 18: google.cloud.vision.v1p1beta1.WebDetectionParams
	(*TextDetectionParams)(nil),         // 19: google.cloud.vision.v1p1beta1.TextDetectionParams
	(*ImageContext)(nil),                // 20: google.cloud.vision.v1p1beta1.ImageContext
	(*AnnotateImageRequest)(nil),        // 21: google.cloud.vision.v1p1beta1.AnnotateImageRequest
	(*AnnotateImageResponse)(nil),       // 22: google.cloud.vision.v1p1beta1.AnnotateImageResponse
	(*BatchAnnotateImagesRequest)(nil),  // 23: google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest
	(*BatchAnnotateImagesResponse)(nil), // 24: google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse
	(*FaceAnnotation_Landmark)(nil),     // 25: google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark
	(*BoundingPoly)(nil),                // 26: google.cloud.vision.v1p1beta1.BoundingPoly
	(*latlng.LatLng)(nil),               // 27: google.type.LatLng
	(*color.Color)(nil),                 // 28: google.type.Color
	(*TextAnnotation)(nil),              // 29: google.cloud.vision.v1p1beta1.TextAnnotation
	(*WebDetection)(nil),                // 30: google.cloud.vision.v1p1beta1.WebDetection
	(*status.Status)(nil),               // 31: google.rpc.Status
	(*Position)(nil),                    // 32: google.cloud.vision.v1p1beta1.Position
}
var file_google_cloud_vision_v1p1beta1_image_annotator_proto_depIdxs = []int32{
	1,  // 0: google.cloud.vision.v1p1beta1.Feature.type:type_name -> google.cloud.vision.v1p1beta1.Feature.Type
	4,  // 1: google.cloud.vision.v1p1beta1.Image.source:type_name -> google.cloud.vision.v1p1beta1.ImageSource
	26, // 2: google.cloud.vision.v1p1beta1.FaceAnnotation.bounding_poly:type_name -> google.cloud.vision.v1p1beta1.BoundingPoly
	26, // 3: google.cloud.vision.v1p1beta1.FaceAnnotation.fd_bounding_poly:type_name -> google.cloud.vision.v1p1beta1.BoundingPoly
	25, // 4: google.cloud.vision.v1p1beta1.FaceAnnotation.landmarks:type_name -> google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark
	0,  // 5: google.cloud.vision.v1p1beta1.FaceAnnotation.joy_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 6: google.cloud.vision.v1p1beta1.FaceAnnotation.sorrow_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 7: google.cloud.vision.v1p1beta1.FaceAnnotation.anger_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 8: google.cloud.vision.v1p1beta1.FaceAnnotation.surprise_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 9: google.cloud.vision.v1p1beta1.FaceAnnotation.under_exposed_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 10: google.cloud.vision.v1p1beta1.FaceAnnotation.blurred_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 11: google.cloud.vision.v1p1beta1.FaceAnnotation.headwear_likelihood:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	27, // 12: google.cloud.vision.v1p1beta1.LocationInfo.lat_lng:type_name -> google.type.LatLng
	26, // 13: google.cloud.vision.v1p1beta1.EntityAnnotation.bounding_poly:type_name -> google.cloud.vision.v1p1beta1.BoundingPoly
	7,  // 14: google.cloud.vision.v1p1beta1.EntityAnnotation.locations:type_name -> google.cloud.vision.v1p1beta1.LocationInfo
	8,  // 15: google.cloud.vision.v1p1beta1.EntityAnnotation.properties:type_name -> google.cloud.vision.v1p1beta1.Property
	0,  // 16: google.cloud.vision.v1p1beta1.SafeSearchAnnotation.adult:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 17: google.cloud.vision.v1p1beta1.SafeSearchAnnotation.spoof:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 18: google.cloud.vision.v1p1beta1.SafeSearchAnnotation.medical:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 19: google.cloud.vision.v1p1beta1.SafeSearchAnnotation.violence:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	0,  // 20: google.cloud.vision.v1p1beta1.SafeSearchAnnotation.racy:type_name -> google.cloud.vision.v1p1beta1.Likelihood
	27, // 21: google.cloud.vision.v1p1beta1.LatLongRect.min_lat_lng:type_name -> google.type.LatLng
	27, // 22: google.cloud.vision.v1p1beta1.LatLongRect.max_lat_lng:type_name -> google.type.LatLng
	28, // 23: google.cloud.vision.v1p1beta1.ColorInfo.color:type_name -> google.type.Color
	12, // 24: google.cloud.vision.v1p1beta1.DominantColorsAnnotation.colors:type_name -> google.cloud.vision.v1p1beta1.ColorInfo
	13, // 25: google.cloud.vision.v1p1beta1.ImageProperties.dominant_colors:type_name -> google.cloud.vision.v1p1beta1.DominantColorsAnnotation
	26, // 26: google.cloud.vision.v1p1beta1.CropHint.bounding_poly:type_name -> google.cloud.vision.v1p1beta1.BoundingPoly
	15, // 27: google.cloud.vision.v1p1beta1.CropHintsAnnotation.crop_hints:type_name -> google.cloud.vision.v1p1beta1.CropHint
	11, // 28: google.cloud.vision.v1p1beta1.ImageContext.lat_long_rect:type_name -> google.cloud.vision.v1p1beta1.LatLongRect
	17, // 29: google.cloud.vision.v1p1beta1.ImageContext.crop_hints_params:type_name -> google.cloud.vision.v1p1beta1.CropHintsParams
	18, // 30: google.cloud.vision.v1p1beta1.ImageContext.web_detection_params:type_name -> google.cloud.vision.v1p1beta1.WebDetectionParams
	19, // 31: google.cloud.vision.v1p1beta1.ImageContext.text_detection_params:type_name -> google.cloud.vision.v1p1beta1.TextDetectionParams
	5,  // 32: google.cloud.vision.v1p1beta1.AnnotateImageRequest.image:type_name -> google.cloud.vision.v1p1beta1.Image
	3,  // 33: google.cloud.vision.v1p1beta1.AnnotateImageRequest.features:type_name -> google.cloud.vision.v1p1beta1.Feature
	20, // 34: google.cloud.vision.v1p1beta1.AnnotateImageRequest.image_context:type_name -> google.cloud.vision.v1p1beta1.ImageContext
	6,  // 35: google.cloud.vision.v1p1beta1.AnnotateImageResponse.face_annotations:type_name -> google.cloud.vision.v1p1beta1.FaceAnnotation
	9,  // 36: google.cloud.vision.v1p1beta1.AnnotateImageResponse.landmark_annotations:type_name -> google.cloud.vision.v1p1beta1.EntityAnnotation
	9,  // 37: google.cloud.vision.v1p1beta1.AnnotateImageResponse.logo_annotations:type_name -> google.cloud.vision.v1p1beta1.EntityAnnotation
	9,  // 38: google.cloud.vision.v1p1beta1.AnnotateImageResponse.label_annotations:type_name -> google.cloud.vision.v1p1beta1.EntityAnnotation
	9,  // 39: google.cloud.vision.v1p1beta1.AnnotateImageResponse.text_annotations:type_name -> google.cloud.vision.v1p1beta1.EntityAnnotation
	29, // 40: google.cloud.vision.v1p1beta1.AnnotateImageResponse.full_text_annotation:type_name -> google.cloud.vision.v1p1beta1.TextAnnotation
	10, // 41: google.cloud.vision.v1p1beta1.AnnotateImageResponse.safe_search_annotation:type_name -> google.cloud.vision.v1p1beta1.SafeSearchAnnotation
	14, // 42: google.cloud.vision.v1p1beta1.AnnotateImageResponse.image_properties_annotation:type_name -> google.cloud.vision.v1p1beta1.ImageProperties
	16, // 43: google.cloud.vision.v1p1beta1.AnnotateImageResponse.crop_hints_annotation:type_name -> google.cloud.vision.v1p1beta1.CropHintsAnnotation
	30, // 44: google.cloud.vision.v1p1beta1.AnnotateImageResponse.web_detection:type_name -> google.cloud.vision.v1p1beta1.WebDetection
	31, // 45: google.cloud.vision.v1p1beta1.AnnotateImageResponse.error:type_name -> google.rpc.Status
	21, // 46: google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest.requests:type_name -> google.cloud.vision.v1p1beta1.AnnotateImageRequest
	22, // 47: google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse.responses:type_name -> google.cloud.vision.v1p1beta1.AnnotateImageResponse
	2,  // 48: google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.type:type_name -> google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.Type
	32, // 49: google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark.position:type_name -> google.cloud.vision.v1p1beta1.Position
	23, // 50: google.cloud.vision.v1p1beta1.ImageAnnotator.BatchAnnotateImages:input_type -> google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest
	24, // 51: google.cloud.vision.v1p1beta1.ImageAnnotator.BatchAnnotateImages:output_type -> google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse
	51, // [51:52] is the sub-list for method output_type
	50, // [50:51] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_cloud_vision_v1p1beta1_image_annotator_proto_init() }
func file_google_cloud_vision_v1p1beta1_image_annotator_proto_init() {
	if File_google_cloud_vision_v1p1beta1_image_annotator_proto != nil {
		return
	}
	file_google_cloud_vision_v1p1beta1_geometry_proto_init()
	file_google_cloud_vision_v1p1beta1_text_annotation_proto_init()
	file_google_cloud_vision_v1p1beta1_web_detection_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Feature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SafeSearchAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LatLongRect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColorInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DominantColorsAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CropHint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CropHintsAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CropHintsParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebDetectionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextDetectionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateImageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchAnnotateImagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchAnnotateImagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceAnnotation_Landmark); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_vision_v1p1beta1_image_annotator_proto_goTypes,
		DependencyIndexes: file_google_cloud_vision_v1p1beta1_image_annotator_proto_depIdxs,
		EnumInfos:         file_google_cloud_vision_v1p1beta1_image_annotator_proto_enumTypes,
		MessageInfos:      file_google_cloud_vision_v1p1beta1_image_annotator_proto_msgTypes,
	}.Build()
	File_google_cloud_vision_v1p1beta1_image_annotator_proto = out.File
	file_google_cloud_vision_v1p1beta1_image_annotator_proto_rawDesc = nil
	file_google_cloud_vision_v1p1beta1_image_annotator_proto_goTypes = nil
	file_google_cloud_vision_v1p1beta1_image_annotator_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ImageAnnotatorClient is the client API for ImageAnnotator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
}

type imageAnnotatorClient struct {
	cc grpc.ClientConnInterface
}

func NewImageAnnotatorClient(cc grpc.ClientConnInterface) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1p1beta1.ImageAnnotator/BatchAnnotateImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageAnnotatorServer is the server API for ImageAnnotator service.
type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
}

// UnimplementedImageAnnotatorServer can be embedded to have forward compatible implementations.
type UnimplementedImageAnnotatorServer struct {
}

func (*UnimplementedImageAnnotatorServer) BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchAnnotateImages not implemented")
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p1beta1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1p1beta1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1p1beta1/image_annotator.proto",
}
