// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/retail/v2beta/purge_config.proto

package retailpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Metadata related to the progress of the Purge operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type PurgeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PurgeMetadata) Reset() {
	*x = PurgeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurgeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeMetadata) ProtoMessage() {}

func (x *PurgeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeMetadata.ProtoReflect.Descriptor instead.
func (*PurgeMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_purge_config_proto_rawDescGZIP(), []int{0}
}

// Request message for PurgeUserEvents method.
type PurgeUserEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the catalog under which the events are
	// created. The format is
	// `projects/${projectId}/locations/global/catalogs/${catalogId}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The filter string to specify the events to be deleted with a
	// length limit of 5,000 characters. Empty string filter is not allowed. The
	// eligible fields for filtering are:
	//
	// * `eventType`: Double quoted
	// [UserEvent.event_type][google.cloud.retail.v2beta.UserEvent.event_type]
	// string.
	// * `eventTime`: in ISO 8601 "zulu" format.
	// * `visitorId`: Double quoted string. Specifying this will delete all
	//   events associated with a visitor.
	// * `userId`: Double quoted string. Specifying this will delete all events
	//   associated with a user.
	//
	// Examples:
	//
	// * Deleting all events in a time range:
	//   `eventTime > "2012-04-23T18:25:43.511Z"
	//   eventTime < "2012-04-23T18:30:43.511Z"`
	// * Deleting specific eventType in time range:
	//   `eventTime > "2012-04-23T18:25:43.511Z" eventType = "detail-page-view"`
	// * Deleting all events for a specific visitor:
	//   `visitorId = "visitor1024"`
	//
	// The filtering fields are assumed to have an implicit AND.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Actually perform the purge.
	// If `force` is set to false, the method will return the expected purge count
	// without deleting any user events.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *PurgeUserEventsRequest) Reset() {
	*x = PurgeUserEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurgeUserEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeUserEventsRequest) ProtoMessage() {}

func (x *PurgeUserEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeUserEventsRequest.ProtoReflect.Descriptor instead.
func (*PurgeUserEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_purge_config_proto_rawDescGZIP(), []int{1}
}

func (x *PurgeUserEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PurgeUserEventsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *PurgeUserEventsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Response of the PurgeUserEventsRequest. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type PurgeUserEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total count of events purged as a result of the operation.
	PurgedEventsCount int64 `protobuf:"varint,1,opt,name=purged_events_count,json=purgedEventsCount,proto3" json:"purged_events_count,omitempty"`
}

func (x *PurgeUserEventsResponse) Reset() {
	*x = PurgeUserEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurgeUserEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeUserEventsResponse) ProtoMessage() {}

func (x *PurgeUserEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeUserEventsResponse.ProtoReflect.Descriptor instead.
func (*PurgeUserEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_purge_config_proto_rawDescGZIP(), []int{2}
}

func (x *PurgeUserEventsResponse) GetPurgedEventsCount() int64 {
	if x != nil {
		return x.PurgedEventsCount
	}
	return 0
}

var File_google_cloud_retail_v2beta_purge_config_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_purge_config_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x75, 0x72,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x0f, 0x0a, 0x0d, 0x50, 0x75, 0x72, 0x67, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x49, 0x0a, 0x17, 0x50, 0x75, 0x72, 0x67, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2e, 0x0a, 0x13, 0x70, 0x75, 0x72, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x70,
	0x75, 0x72, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0xcf, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x10, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2,
	0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56,
	0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x62, 0x65,
	0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2beta_purge_config_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_purge_config_proto_rawDescData = file_google_cloud_retail_v2beta_purge_config_proto_rawDesc
)

func file_google_cloud_retail_v2beta_purge_config_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_purge_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_purge_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_purge_config_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_purge_config_proto_rawDescData
}

var file_google_cloud_retail_v2beta_purge_config_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_retail_v2beta_purge_config_proto_goTypes = []interface{}{
	(*PurgeMetadata)(nil),           // 0: google.cloud.retail.v2beta.PurgeMetadata
	(*PurgeUserEventsRequest)(nil),  // 1: google.cloud.retail.v2beta.PurgeUserEventsRequest
	(*PurgeUserEventsResponse)(nil), // 2: google.cloud.retail.v2beta.PurgeUserEventsResponse
}
var file_google_cloud_retail_v2beta_purge_config_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_purge_config_proto_init() }
func file_google_cloud_retail_v2beta_purge_config_proto_init() {
	if File_google_cloud_retail_v2beta_purge_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurgeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurgeUserEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_purge_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurgeUserEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_purge_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2beta_purge_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_purge_config_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2beta_purge_config_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_purge_config_proto = out.File
	file_google_cloud_retail_v2beta_purge_config_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_purge_config_proto_goTypes = nil
	file_google_cloud_retail_v2beta_purge_config_proto_depIdxs = nil
}
