// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/retail/v2beta/product_service.proto

package retailpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
// method.
type CreateProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent catalog resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [Product][google.cloud.retail.v2beta.Product] to create.
	Product *Product `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	// Required. The ID to use for the
	// [Product][google.cloud.retail.v2beta.Product], which will become the final
	// component of the [Product.name][google.cloud.retail.v2beta.Product.name].
	//
	// If the caller does not have permission to create the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	//
	// This field must be unique among all
	// [Product][google.cloud.retail.v2beta.Product]s with the same
	// [parent][google.cloud.retail.v2beta.CreateProductRequest.parent].
	// Otherwise, an ALREADY_EXISTS error is returned.
	//
	// This field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	ProductId string `protobuf:"bytes,3,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
}

func (x *CreateProductRequest) Reset() {
	*x = CreateProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProductRequest) ProtoMessage() {}

func (x *CreateProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProductRequest.ProtoReflect.Descriptor instead.
func (*CreateProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateProductRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProductRequest) GetProduct() *Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *CreateProductRequest) GetProductId() string {
	if x != nil {
		return x.ProductId
	}
	return ""
}

// Request message for
// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
// method.
type GetProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Product][google.cloud.retail.v2beta.Product], such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
	//
	// If the caller does not have permission to access the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	//
	// If the requested [Product][google.cloud.retail.v2beta.Product] does not
	// exist, a NOT_FOUND error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProductRequest) Reset() {
	*x = GetProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProductRequest) ProtoMessage() {}

func (x *GetProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProductRequest.ProtoReflect.Descriptor instead.
func (*GetProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetProductRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
// method.
type UpdateProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The product to update/create.
	//
	// If the caller does not have permission to update the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	//
	// If the [Product][google.cloud.retail.v2beta.Product] to update does not
	// exist and
	// [allow_missing][google.cloud.retail.v2beta.UpdateProductRequest.allow_missing]
	// is not set, a NOT_FOUND error is returned.
	Product *Product `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Indicates which fields in the provided
	// [Product][google.cloud.retail.v2beta.Product] to update. The immutable and
	// output only fields are NOT supported. If not set, all supported fields (the
	// fields that are neither immutable nor output only) are updated.
	//
	// If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
	// is returned.
	//
	// The attribute key can be updated by setting the mask path as
	// "attributes.${key_name}". If a key name is present in the mask but not in
	// the patching product from the request, this key will be deleted after the
	// update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true, and the [Product][google.cloud.retail.v2beta.Product] is
	// not found, a new [Product][google.cloud.retail.v2beta.Product] will be
	// created. In this situation, `update_mask` is ignored.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateProductRequest) Reset() {
	*x = UpdateProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProductRequest) ProtoMessage() {}

func (x *UpdateProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProductRequest.ProtoReflect.Descriptor instead.
func (*UpdateProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateProductRequest) GetProduct() *Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *UpdateProductRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateProductRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [ProductService.DeleteProduct][google.cloud.retail.v2beta.ProductService.DeleteProduct]
// method.
type DeleteProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Product][google.cloud.retail.v2beta.Product], such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
	//
	// If the caller does not have permission to delete the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	//
	// If the [Product][google.cloud.retail.v2beta.Product] to delete does not
	// exist, a NOT_FOUND error is returned.
	//
	// The [Product][google.cloud.retail.v2beta.Product] to delete can neither be
	// a
	// [Product.Type.COLLECTION][google.cloud.retail.v2beta.Product.Type.COLLECTION]
	// [Product][google.cloud.retail.v2beta.Product] member nor a
	// [Product.Type.PRIMARY][google.cloud.retail.v2beta.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2beta.Product] with more than one
	// [variants][google.cloud.retail.v2beta.Product.Type.VARIANT]. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// All inventory information for the named
	// [Product][google.cloud.retail.v2beta.Product] will be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProductRequest) Reset() {
	*x = DeleteProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProductRequest) ProtoMessage() {}

func (x *DeleteProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProductRequest.ProtoReflect.Descriptor instead.
func (*DeleteProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteProductRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
// method.
type ListProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent branch resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/0`. Use
	// `default_branch` as the branch ID, to list products under the default
	// branch.
	//
	// If the caller does not have permission to list
	// [Product][google.cloud.retail.v2beta.Product]s under this branch,
	// regardless of whether or not this branch exists, a PERMISSION_DENIED error
	// is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of [Product][google.cloud.retail.v2beta.Product]s to return.
	// If unspecified, defaults to 100. The maximum allowed value is 1000. Values
	// above 1000 will be coerced to 1000.
	//
	// If this field is negative, an INVALID_ARGUMENT error is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token
	// [ListProductsResponse.next_page_token][google.cloud.retail.v2beta.ListProductsResponse.next_page_token],
	// received from a previous
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
	// must match the call that provided the page token. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to apply on the list results. Supported features:
	//
	// * List all the products under the parent branch if
	// [filter][google.cloud.retail.v2beta.ListProductsRequest.filter] is unset.
	// * List
	// [Product.Type.VARIANT][google.cloud.retail.v2beta.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2beta.Product]s sharing the same
	//   [Product.Type.PRIMARY][google.cloud.retail.v2beta.Product.Type.PRIMARY]
	//   [Product][google.cloud.retail.v2beta.Product]. For example:
	//     `primary_product_id = "some_product_id"`
	// * List [Product][google.cloud.retail.v2beta.Product]s bundled in a
	// [Product.Type.COLLECTION][google.cloud.retail.v2beta.Product.Type.COLLECTION]
	// [Product][google.cloud.retail.v2beta.Product].
	//   For example:
	//     `collection_product_id = "some_product_id"`
	// * List [Product][google.cloud.retail.v2beta.Product]s with a partibular
	// type. For example:
	//     `type = "PRIMARY"`
	//     `type = "VARIANT"`
	//     `type = "COLLECTION"`
	//
	// If the field is unrecognizable, an INVALID_ARGUMENT error is returned.
	//
	// If the specified
	// [Product.Type.PRIMARY][google.cloud.retail.v2beta.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2beta.Product] or
	// [Product.Type.COLLECTION][google.cloud.retail.v2beta.Product.Type.COLLECTION]
	// [Product][google.cloud.retail.v2beta.Product] does not exist, a NOT_FOUND
	// error is returned.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The fields of [Product][google.cloud.retail.v2beta.Product] to return in
	// the responses. If not set or empty, the following fields are returned:
	//
	// * [Product.name][google.cloud.retail.v2beta.Product.name]
	// * [Product.id][google.cloud.retail.v2beta.Product.id]
	// * [Product.title][google.cloud.retail.v2beta.Product.title]
	// * [Product.uri][google.cloud.retail.v2beta.Product.uri]
	// * [Product.images][google.cloud.retail.v2beta.Product.images]
	// * [Product.price_info][google.cloud.retail.v2beta.Product.price_info]
	// * [Product.brands][google.cloud.retail.v2beta.Product.brands]
	//
	// If "*" is provided, all fields are returned.
	// [Product.name][google.cloud.retail.v2beta.Product.name] is always returned
	// no matter what mask is set.
	//
	// If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
	// is returned.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListProductsRequest) Reset() {
	*x = ListProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsRequest) ProtoMessage() {}

func (x *ListProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsRequest.ProtoReflect.Descriptor instead.
func (*ListProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListProductsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProductsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListProductsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListProductsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
// method.
type ListProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [Product][google.cloud.retail.v2beta.Product]s.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// A token that can be sent as
	// [ListProductsRequest.page_token][google.cloud.retail.v2beta.ListProductsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductsResponse) Reset() {
	*x = ListProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsResponse) ProtoMessage() {}

func (x *ListProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsResponse.ProtoReflect.Descriptor instead.
func (*ListProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListProductsResponse) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *ListProductsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory]
// method.
type SetInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The inventory information to update. The allowable fields to
	// update are:
	//
	// * [Product.price_info][google.cloud.retail.v2beta.Product.price_info]
	// * [Product.availability][google.cloud.retail.v2beta.Product.availability]
	// * [Product.available_quantity][google.cloud.retail.v2beta.Product.available_quantity]
	// * [Product.fulfillment_info][google.cloud.retail.v2beta.Product.fulfillment_info]
	// The updated inventory fields must be specified in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask].
	//
	// If
	// [SetInventoryRequest.inventory.name][google.cloud.retail.v2beta.Product.name]
	// is empty or invalid, an INVALID_ARGUMENT error is returned.
	//
	// If the caller does not have permission to update the
	// [Product][google.cloud.retail.v2beta.Product] named in
	// [Product.name][google.cloud.retail.v2beta.Product.name], regardless of
	// whether or not it exists, a PERMISSION_DENIED error is returned.
	//
	// If the [Product][google.cloud.retail.v2beta.Product] to update does not
	// have existing inventory information, the provided inventory information
	// will be inserted.
	//
	// If the [Product][google.cloud.retail.v2beta.Product] to update has existing
	// inventory information, the provided inventory information will be merged
	// while respecting the last update time for each inventory field, using the
	// provided or default value for
	// [SetInventoryRequest.set_time][google.cloud.retail.v2beta.SetInventoryRequest.set_time].
	//
	// The caller can replace place IDs for a subset of fulfillment types in the
	// following ways:
	//
	// * Adds "fulfillment_info" in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask]
	// * Specifies only the desired fulfillment types and corresponding place IDs
	// to update in
	// [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2beta.Product.fulfillment_info]
	//
	// The caller can clear all place IDs from a subset of fulfillment types in
	// the following ways:
	//
	// * Adds "fulfillment_info" in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask]
	// * Specifies only the desired fulfillment types to clear in
	// [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2beta.Product.fulfillment_info]
	// * Checks that only the desired fulfillment info types have empty
	// [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids]
	//
	// The last update time is recorded for the following inventory fields:
	// * [Product.price_info][google.cloud.retail.v2beta.Product.price_info]
	// * [Product.availability][google.cloud.retail.v2beta.Product.availability]
	// * [Product.available_quantity][google.cloud.retail.v2beta.Product.available_quantity]
	// * [Product.fulfillment_info][google.cloud.retail.v2beta.Product.fulfillment_info]
	//
	// If a full overwrite of inventory information while ignoring timestamps is
	// needed,
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// should be invoked instead.
	Inventory *Product `protobuf:"bytes,1,opt,name=inventory,proto3" json:"inventory,omitempty"`
	// Indicates which inventory fields in the provided
	// [Product][google.cloud.retail.v2beta.Product] to update.
	//
	// At least one field must be provided.
	//
	// If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
	// is returned and the entire update will be ignored.
	SetMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=set_mask,json=setMask,proto3" json:"set_mask,omitempty"`
	// The time when the request is issued, used to prevent
	// out-of-order updates on inventory fields with the last update time
	// recorded. If not provided, the internal system time will be used.
	SetTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=set_time,json=setTime,proto3" json:"set_time,omitempty"`
	// If set to true, and the [Product][google.cloud.retail.v2beta.Product] with
	// name [Product.name][google.cloud.retail.v2beta.Product.name] is not found,
	// the inventory update will still be processed and retained for at most 1 day
	// until the [Product][google.cloud.retail.v2beta.Product] is created. If set
	// to false, a NOT_FOUND error is returned if the
	// [Product][google.cloud.retail.v2beta.Product] is not found.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *SetInventoryRequest) Reset() {
	*x = SetInventoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetInventoryRequest) ProtoMessage() {}

func (x *SetInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetInventoryRequest.ProtoReflect.Descriptor instead.
func (*SetInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{6}
}

func (x *SetInventoryRequest) GetInventory() *Product {
	if x != nil {
		return x.Inventory
	}
	return nil
}

func (x *SetInventoryRequest) GetSetMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.SetMask
	}
	return nil
}

func (x *SetInventoryRequest) GetSetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SetTime
	}
	return nil
}

func (x *SetInventoryRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Metadata related to the progress of the SetInventory operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory]
// method.
type SetInventoryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetInventoryMetadata) Reset() {
	*x = SetInventoryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetInventoryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetInventoryMetadata) ProtoMessage() {}

func (x *SetInventoryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetInventoryMetadata.ProtoReflect.Descriptor instead.
func (*SetInventoryMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{7}
}

// Response of the SetInventoryRequest.  Currently empty because
// there is no meaningful response populated from the
// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory]
// method.
type SetInventoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetInventoryResponse) Reset() {
	*x = SetInventoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetInventoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetInventoryResponse) ProtoMessage() {}

func (x *SetInventoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetInventoryResponse.ProtoReflect.Descriptor instead.
func (*SetInventoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{8}
}

// Request message for
// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
// method.
type AddFulfillmentPlacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Product][google.cloud.retail.v2beta.Product], such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
	//
	// If the caller does not have permission to access the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Required. The fulfillment type, including commonly used types (such as
	// pickup in store and same day delivery), and custom types.
	//
	// Supported values:
	//
	// * "pickup-in-store"
	// * "ship-to-store"
	// * "same-day-delivery"
	// * "next-day-delivery"
	// * "custom-type-1"
	// * "custom-type-2"
	// * "custom-type-3"
	// * "custom-type-4"
	// * "custom-type-5"
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	//
	// This field directly corresponds to
	// [Product.fulfillment_info.type][google.cloud.retail.v2beta.FulfillmentInfo.type].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Required. The IDs for this
	// [type][google.cloud.retail.v2beta.AddFulfillmentPlacesRequest.type], such
	// as the store IDs for "pickup-in-store" or the region IDs for
	// "same-day-delivery" to be added for this
	// [type][google.cloud.retail.v2beta.AddFulfillmentPlacesRequest.type].
	// Duplicate IDs will be automatically ignored.
	//
	// At least 1 value is required, and a maximum of 2000 values are allowed.
	// Each value must be a string with a length limit of 10 characters, matching
	// the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// If the total number of place IDs exceeds 2000 for this
	// [type][google.cloud.retail.v2beta.AddFulfillmentPlacesRequest.type] after
	// adding, then the update will be rejected.
	PlaceIds []string `protobuf:"bytes,3,rep,name=place_ids,json=placeIds,proto3" json:"place_ids,omitempty"`
	// The time when the fulfillment updates are issued, used to prevent
	// out-of-order updates on fulfillment information. If not provided, the
	// internal system time will be used.
	AddTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=add_time,json=addTime,proto3" json:"add_time,omitempty"`
	// If set to true, and the [Product][google.cloud.retail.v2beta.Product] is
	// not found, the fulfillment information will still be processed and retained
	// for at most 1 day and processed once the
	// [Product][google.cloud.retail.v2beta.Product] is created. If set to false,
	// a NOT_FOUND error is returned if the
	// [Product][google.cloud.retail.v2beta.Product] is not found.
	AllowMissing bool `protobuf:"varint,5,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *AddFulfillmentPlacesRequest) Reset() {
	*x = AddFulfillmentPlacesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddFulfillmentPlacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddFulfillmentPlacesRequest) ProtoMessage() {}

func (x *AddFulfillmentPlacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddFulfillmentPlacesRequest.ProtoReflect.Descriptor instead.
func (*AddFulfillmentPlacesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{9}
}

func (x *AddFulfillmentPlacesRequest) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *AddFulfillmentPlacesRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AddFulfillmentPlacesRequest) GetPlaceIds() []string {
	if x != nil {
		return x.PlaceIds
	}
	return nil
}

func (x *AddFulfillmentPlacesRequest) GetAddTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AddTime
	}
	return nil
}

func (x *AddFulfillmentPlacesRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Metadata related to the progress of the AddFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
// method.
type AddFulfillmentPlacesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddFulfillmentPlacesMetadata) Reset() {
	*x = AddFulfillmentPlacesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddFulfillmentPlacesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddFulfillmentPlacesMetadata) ProtoMessage() {}

func (x *AddFulfillmentPlacesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddFulfillmentPlacesMetadata.ProtoReflect.Descriptor instead.
func (*AddFulfillmentPlacesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{10}
}

// Response of the AddFulfillmentPlacesRequest.  Currently empty because
// there is no meaningful response populated from the
// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
// method.
type AddFulfillmentPlacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddFulfillmentPlacesResponse) Reset() {
	*x = AddFulfillmentPlacesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddFulfillmentPlacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddFulfillmentPlacesResponse) ProtoMessage() {}

func (x *AddFulfillmentPlacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddFulfillmentPlacesResponse.ProtoReflect.Descriptor instead.
func (*AddFulfillmentPlacesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{11}
}

// Request message for
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// method.
type AddLocalInventoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Product][google.cloud.retail.v2beta.Product], such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
	//
	// If the caller does not have permission to access the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Required. A list of inventory information at difference places. Each place
	// is identified by its place ID. At most 3000 inventories are allowed per
	// request.
	LocalInventories []*LocalInventory `protobuf:"bytes,2,rep,name=local_inventories,json=localInventories,proto3" json:"local_inventories,omitempty"`
	// Indicates which inventory fields in the provided list of
	// [LocalInventory][google.cloud.retail.v2beta.LocalInventory] to update. The
	// field is updated to the provided value.
	//
	// If a field is set while the place does not have a previous local inventory,
	// the local inventory at that store is created.
	//
	// If a field is set while the value of that field is not provided, the
	// original field value, if it exists, is deleted.
	//
	// If the mask is not set or set with empty paths, all inventory fields will
	// be updated.
	//
	// If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
	// is returned and the entire update will be ignored.
	AddMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=add_mask,json=addMask,proto3" json:"add_mask,omitempty"`
	// The time when the inventory updates are issued. Used to prevent
	// out-of-order updates on local inventory fields. If not provided, the
	// internal system time will be used.
	AddTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=add_time,json=addTime,proto3" json:"add_time,omitempty"`
	// If set to true, and the [Product][google.cloud.retail.v2beta.Product] is
	// not found, the local inventory will still be processed and retained for at
	// most 1 day and processed once the
	// [Product][google.cloud.retail.v2beta.Product] is created. If set to false,
	// a NOT_FOUND error is returned if the
	// [Product][google.cloud.retail.v2beta.Product] is not found.
	AllowMissing bool `protobuf:"varint,6,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *AddLocalInventoriesRequest) Reset() {
	*x = AddLocalInventoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddLocalInventoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddLocalInventoriesRequest) ProtoMessage() {}

func (x *AddLocalInventoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddLocalInventoriesRequest.ProtoReflect.Descriptor instead.
func (*AddLocalInventoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{12}
}

func (x *AddLocalInventoriesRequest) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *AddLocalInventoriesRequest) GetLocalInventories() []*LocalInventory {
	if x != nil {
		return x.LocalInventories
	}
	return nil
}

func (x *AddLocalInventoriesRequest) GetAddMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.AddMask
	}
	return nil
}

func (x *AddLocalInventoriesRequest) GetAddTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AddTime
	}
	return nil
}

func (x *AddLocalInventoriesRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Metadata related to the progress of the AddLocalInventories operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// method.
type AddLocalInventoriesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddLocalInventoriesMetadata) Reset() {
	*x = AddLocalInventoriesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddLocalInventoriesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddLocalInventoriesMetadata) ProtoMessage() {}

func (x *AddLocalInventoriesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddLocalInventoriesMetadata.ProtoReflect.Descriptor instead.
func (*AddLocalInventoriesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{13}
}

// Response of the
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// API.  Currently empty because there is no meaningful response populated from
// the
// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
// method.
type AddLocalInventoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddLocalInventoriesResponse) Reset() {
	*x = AddLocalInventoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddLocalInventoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddLocalInventoriesResponse) ProtoMessage() {}

func (x *AddLocalInventoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddLocalInventoriesResponse.ProtoReflect.Descriptor instead.
func (*AddLocalInventoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{14}
}

// Request message for
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// method.
type RemoveLocalInventoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Product][google.cloud.retail.v2beta.Product], such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
	//
	// If the caller does not have permission to access the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Required. A list of place IDs to have their inventory deleted.
	// At most 3000 place IDs are allowed per request.
	PlaceIds []string `protobuf:"bytes,2,rep,name=place_ids,json=placeIds,proto3" json:"place_ids,omitempty"`
	// The time when the inventory deletions are issued. Used to prevent
	// out-of-order updates and deletions on local inventory fields. If not
	// provided, the internal system time will be used.
	RemoveTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=remove_time,json=removeTime,proto3" json:"remove_time,omitempty"`
	// If set to true, and the [Product][google.cloud.retail.v2beta.Product] is
	// not found, the local inventory removal request will still be processed and
	// retained for at most 1 day and processed once the
	// [Product][google.cloud.retail.v2beta.Product] is created. If set to false,
	// a NOT_FOUND error is returned if the
	// [Product][google.cloud.retail.v2beta.Product] is not found.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *RemoveLocalInventoriesRequest) Reset() {
	*x = RemoveLocalInventoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveLocalInventoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveLocalInventoriesRequest) ProtoMessage() {}

func (x *RemoveLocalInventoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveLocalInventoriesRequest.ProtoReflect.Descriptor instead.
func (*RemoveLocalInventoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{15}
}

func (x *RemoveLocalInventoriesRequest) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *RemoveLocalInventoriesRequest) GetPlaceIds() []string {
	if x != nil {
		return x.PlaceIds
	}
	return nil
}

func (x *RemoveLocalInventoriesRequest) GetRemoveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RemoveTime
	}
	return nil
}

func (x *RemoveLocalInventoriesRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Metadata related to the progress of the RemoveLocalInventories operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// method.
type RemoveLocalInventoriesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveLocalInventoriesMetadata) Reset() {
	*x = RemoveLocalInventoriesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveLocalInventoriesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveLocalInventoriesMetadata) ProtoMessage() {}

func (x *RemoveLocalInventoriesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveLocalInventoriesMetadata.ProtoReflect.Descriptor instead.
func (*RemoveLocalInventoriesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{16}
}

// Response of the
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// API.  Currently empty because there is no meaningful response populated from
// the
// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
// method.
type RemoveLocalInventoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveLocalInventoriesResponse) Reset() {
	*x = RemoveLocalInventoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveLocalInventoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveLocalInventoriesResponse) ProtoMessage() {}

func (x *RemoveLocalInventoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveLocalInventoriesResponse.ProtoReflect.Descriptor instead.
func (*RemoveLocalInventoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{17}
}

// Request message for
// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
// method.
type RemoveFulfillmentPlacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Product][google.cloud.retail.v2beta.Product], such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
	//
	// If the caller does not have permission to access the
	// [Product][google.cloud.retail.v2beta.Product], regardless of whether or not
	// it exists, a PERMISSION_DENIED error is returned.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Required. The fulfillment type, including commonly used types (such as
	// pickup in store and same day delivery), and custom types.
	//
	// Supported values:
	//
	// * "pickup-in-store"
	// * "ship-to-store"
	// * "same-day-delivery"
	// * "next-day-delivery"
	// * "custom-type-1"
	// * "custom-type-2"
	// * "custom-type-3"
	// * "custom-type-4"
	// * "custom-type-5"
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	//
	// This field directly corresponds to
	// [Product.fulfillment_info.type][google.cloud.retail.v2beta.FulfillmentInfo.type].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Required. The IDs for this
	// [type][google.cloud.retail.v2beta.RemoveFulfillmentPlacesRequest.type],
	// such as the store IDs for "pickup-in-store" or the region IDs for
	// "same-day-delivery", to be removed for this
	// [type][google.cloud.retail.v2beta.RemoveFulfillmentPlacesRequest.type].
	//
	// At least 1 value is required, and a maximum of 2000 values are allowed.
	// Each value must be a string with a length limit of 10 characters, matching
	// the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
	// INVALID_ARGUMENT error is returned.
	PlaceIds []string `protobuf:"bytes,3,rep,name=place_ids,json=placeIds,proto3" json:"place_ids,omitempty"`
	// The time when the fulfillment updates are issued, used to prevent
	// out-of-order updates on fulfillment information. If not provided, the
	// internal system time will be used.
	RemoveTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=remove_time,json=removeTime,proto3" json:"remove_time,omitempty"`
	// If set to true, and the [Product][google.cloud.retail.v2beta.Product] is
	// not found, the fulfillment information will still be processed and retained
	// for at most 1 day and processed once the
	// [Product][google.cloud.retail.v2beta.Product] is created. If set to false,
	// a NOT_FOUND error is returned if the
	// [Product][google.cloud.retail.v2beta.Product] is not found.
	AllowMissing bool `protobuf:"varint,5,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *RemoveFulfillmentPlacesRequest) Reset() {
	*x = RemoveFulfillmentPlacesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFulfillmentPlacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFulfillmentPlacesRequest) ProtoMessage() {}

func (x *RemoveFulfillmentPlacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFulfillmentPlacesRequest.ProtoReflect.Descriptor instead.
func (*RemoveFulfillmentPlacesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{18}
}

func (x *RemoveFulfillmentPlacesRequest) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *RemoveFulfillmentPlacesRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *RemoveFulfillmentPlacesRequest) GetPlaceIds() []string {
	if x != nil {
		return x.PlaceIds
	}
	return nil
}

func (x *RemoveFulfillmentPlacesRequest) GetRemoveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RemoveTime
	}
	return nil
}

func (x *RemoveFulfillmentPlacesRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Metadata related to the progress of the RemoveFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated from the
// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
// method.
type RemoveFulfillmentPlacesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveFulfillmentPlacesMetadata) Reset() {
	*x = RemoveFulfillmentPlacesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFulfillmentPlacesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFulfillmentPlacesMetadata) ProtoMessage() {}

func (x *RemoveFulfillmentPlacesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFulfillmentPlacesMetadata.ProtoReflect.Descriptor instead.
func (*RemoveFulfillmentPlacesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{19}
}

// Response of the RemoveFulfillmentPlacesRequest. Currently empty because there
// is no meaningful response populated from the
// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
// method.
type RemoveFulfillmentPlacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveFulfillmentPlacesResponse) Reset() {
	*x = RemoveFulfillmentPlacesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFulfillmentPlacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFulfillmentPlacesResponse) ProtoMessage() {}

func (x *RemoveFulfillmentPlacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_product_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFulfillmentPlacesResponse.ProtoReflect.Descriptor instead.
func (*RemoveFulfillmentPlacesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP(), []int{20}
}

var File_google_cloud_retail_v2beta_product_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_product_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbc, 0x01, 0x0a, 0x14, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x42, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x64, 0x22, 0x4e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x51, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe0, 0x01, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x7f, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf0,
	0x01, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x35,
	0x0a, 0x08, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x07, 0x73, 0x65,
	0x74, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x35, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x73, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x22, 0x16, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x16, 0x0a, 0x14, 0x53, 0x65, 0x74,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xf5, 0x01, 0x0a, 0x1b, 0x41, 0x64, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x35, 0x0a,
	0x08, 0x61, 0x64, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x61, 0x64, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x1e, 0x0a, 0x1c, 0x41, 0x64, 0x64,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x1e, 0x0a, 0x1c, 0x41, 0x64, 0x64,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xce, 0x02, 0x0a, 0x1a, 0x41, 0x64,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x5c, 0x0a, 0x11, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x61, 0x64, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x07, 0x61, 0x64, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x35,
	0x0a, 0x08, 0x61, 0x64, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x61, 0x64,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x1d, 0x0a, 0x1b, 0x41, 0x64,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x1d, 0x0a, 0x1b, 0x41, 0x64, 0x64,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe4, 0x01, 0x0a, 0x1d, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x3b, 0x0a,
	0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22,
	0x20, 0x0a, 0x1e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x20, 0x0a, 0x1e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xfe, 0x01, 0x0a, 0x1e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49,
	0x64, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x22, 0x21, 0x0a, 0x1f, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x21, 0x0a, 0x1f, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xc6, 0x18, 0x0a, 0x0e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdb, 0x01,
	0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x73, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x07, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x22, 0x46, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0xb8, 0x01, 0x0a, 0x0a,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x56,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xca, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x12, 0xde, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x76, 0xda, 0x41,
	0x13, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x07, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x32, 0x4f, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xb1, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x2a,
	0x47, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0x9e, 0x02, 0x0a, 0x0e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9, 0x01,
	0xca, 0x41, 0x5e, 0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xc4, 0x02, 0x0a, 0x0c, 0x53, 0x65,
	0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe3, 0x01, 0xca, 0x41, 0x62,
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x74,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65,
	0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x12, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2c, 0x73,
	0x65, 0x74, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x3a, 0x01, 0x2a,
	0x22, 0x5e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0xda, 0x02, 0x0a, 0x14, 0x41, 0x64, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xe9, 0x01, 0xca, 0x41, 0x72, 0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x64,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x07, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x3a, 0x01, 0x2a, 0x22, 0x5f, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x46, 0x75, 0x6c, 0x66,
	0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0xe9, 0x02,
	0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75, 0x6c,
	0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf2, 0x01, 0xca, 0x41, 0x78, 0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75, 0x6c,
	0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x67, 0x3a, 0x01, 0x2a, 0x22, 0x62, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0xd5, 0x02, 0x0a, 0x13, 0x41, 0x64,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41,
	0x64, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe6, 0x01, 0xca, 0x41, 0x70, 0x0a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x64, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x41, 0x64, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x3a, 0x01,
	0x2a, 0x22, 0x5e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x61, 0x64,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0xe4, 0x02, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xef, 0x01, 0xca, 0x41, 0x76, 0x0a, 0x39, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x66, 0x3a, 0x01, 0x2a, 0x22, 0x61, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0xd2, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x13, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02,
	0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1a, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2beta_product_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_product_service_proto_rawDescData = file_google_cloud_retail_v2beta_product_service_proto_rawDesc
)

func file_google_cloud_retail_v2beta_product_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_product_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_product_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_product_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_product_service_proto_rawDescData
}

var file_google_cloud_retail_v2beta_product_service_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_retail_v2beta_product_service_proto_goTypes = []interface{}{
	(*CreateProductRequest)(nil),            // 0: google.cloud.retail.v2beta.CreateProductRequest
	(*GetProductRequest)(nil),               // 1: google.cloud.retail.v2beta.GetProductRequest
	(*UpdateProductRequest)(nil),            // 2: google.cloud.retail.v2beta.UpdateProductRequest
	(*DeleteProductRequest)(nil),            // 3: google.cloud.retail.v2beta.DeleteProductRequest
	(*ListProductsRequest)(nil),             // 4: google.cloud.retail.v2beta.ListProductsRequest
	(*ListProductsResponse)(nil),            // 5: google.cloud.retail.v2beta.ListProductsResponse
	(*SetInventoryRequest)(nil),             // 6: google.cloud.retail.v2beta.SetInventoryRequest
	(*SetInventoryMetadata)(nil),            // 7: google.cloud.retail.v2beta.SetInventoryMetadata
	(*SetInventoryResponse)(nil),            // 8: google.cloud.retail.v2beta.SetInventoryResponse
	(*AddFulfillmentPlacesRequest)(nil),     // 9: google.cloud.retail.v2beta.AddFulfillmentPlacesRequest
	(*AddFulfillmentPlacesMetadata)(nil),    // 10: google.cloud.retail.v2beta.AddFulfillmentPlacesMetadata
	(*AddFulfillmentPlacesResponse)(nil),    // 11: google.cloud.retail.v2beta.AddFulfillmentPlacesResponse
	(*AddLocalInventoriesRequest)(nil),      // 12: google.cloud.retail.v2beta.AddLocalInventoriesRequest
	(*AddLocalInventoriesMetadata)(nil),     // 13: google.cloud.retail.v2beta.AddLocalInventoriesMetadata
	(*AddLocalInventoriesResponse)(nil),     // 14: google.cloud.retail.v2beta.AddLocalInventoriesResponse
	(*RemoveLocalInventoriesRequest)(nil),   // 15: google.cloud.retail.v2beta.RemoveLocalInventoriesRequest
	(*RemoveLocalInventoriesMetadata)(nil),  // 16: google.cloud.retail.v2beta.RemoveLocalInventoriesMetadata
	(*RemoveLocalInventoriesResponse)(nil),  // 17: google.cloud.retail.v2beta.RemoveLocalInventoriesResponse
	(*RemoveFulfillmentPlacesRequest)(nil),  // 18: google.cloud.retail.v2beta.RemoveFulfillmentPlacesRequest
	(*RemoveFulfillmentPlacesMetadata)(nil), // 19: google.cloud.retail.v2beta.RemoveFulfillmentPlacesMetadata
	(*RemoveFulfillmentPlacesResponse)(nil), // 20: google.cloud.retail.v2beta.RemoveFulfillmentPlacesResponse
	(*Product)(nil),                         // 21: google.cloud.retail.v2beta.Product
	(*fieldmaskpb.FieldMask)(nil),           // 22: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),           // 23: google.protobuf.Timestamp
	(*LocalInventory)(nil),                  // 24: google.cloud.retail.v2beta.LocalInventory
	(*ImportProductsRequest)(nil),           // 25: google.cloud.retail.v2beta.ImportProductsRequest
	(*emptypb.Empty)(nil),                   // 26: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),         // 27: google.longrunning.Operation
}
var file_google_cloud_retail_v2beta_product_service_proto_depIdxs = []int32{
	21, // 0: google.cloud.retail.v2beta.CreateProductRequest.product:type_name -> google.cloud.retail.v2beta.Product
	21, // 1: google.cloud.retail.v2beta.UpdateProductRequest.product:type_name -> google.cloud.retail.v2beta.Product
	22, // 2: google.cloud.retail.v2beta.UpdateProductRequest.update_mask:type_name -> google.protobuf.FieldMask
	22, // 3: google.cloud.retail.v2beta.ListProductsRequest.read_mask:type_name -> google.protobuf.FieldMask
	21, // 4: google.cloud.retail.v2beta.ListProductsResponse.products:type_name -> google.cloud.retail.v2beta.Product
	21, // 5: google.cloud.retail.v2beta.SetInventoryRequest.inventory:type_name -> google.cloud.retail.v2beta.Product
	22, // 6: google.cloud.retail.v2beta.SetInventoryRequest.set_mask:type_name -> google.protobuf.FieldMask
	23, // 7: google.cloud.retail.v2beta.SetInventoryRequest.set_time:type_name -> google.protobuf.Timestamp
	23, // 8: google.cloud.retail.v2beta.AddFulfillmentPlacesRequest.add_time:type_name -> google.protobuf.Timestamp
	24, // 9: google.cloud.retail.v2beta.AddLocalInventoriesRequest.local_inventories:type_name -> google.cloud.retail.v2beta.LocalInventory
	22, // 10: google.cloud.retail.v2beta.AddLocalInventoriesRequest.add_mask:type_name -> google.protobuf.FieldMask
	23, // 11: google.cloud.retail.v2beta.AddLocalInventoriesRequest.add_time:type_name -> google.protobuf.Timestamp
	23, // 12: google.cloud.retail.v2beta.RemoveLocalInventoriesRequest.remove_time:type_name -> google.protobuf.Timestamp
	23, // 13: google.cloud.retail.v2beta.RemoveFulfillmentPlacesRequest.remove_time:type_name -> google.protobuf.Timestamp
	0,  // 14: google.cloud.retail.v2beta.ProductService.CreateProduct:input_type -> google.cloud.retail.v2beta.CreateProductRequest
	1,  // 15: google.cloud.retail.v2beta.ProductService.GetProduct:input_type -> google.cloud.retail.v2beta.GetProductRequest
	4,  // 16: google.cloud.retail.v2beta.ProductService.ListProducts:input_type -> google.cloud.retail.v2beta.ListProductsRequest
	2,  // 17: google.cloud.retail.v2beta.ProductService.UpdateProduct:input_type -> google.cloud.retail.v2beta.UpdateProductRequest
	3,  // 18: google.cloud.retail.v2beta.ProductService.DeleteProduct:input_type -> google.cloud.retail.v2beta.DeleteProductRequest
	25, // 19: google.cloud.retail.v2beta.ProductService.ImportProducts:input_type -> google.cloud.retail.v2beta.ImportProductsRequest
	6,  // 20: google.cloud.retail.v2beta.ProductService.SetInventory:input_type -> google.cloud.retail.v2beta.SetInventoryRequest
	9,  // 21: google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces:input_type -> google.cloud.retail.v2beta.AddFulfillmentPlacesRequest
	18, // 22: google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces:input_type -> google.cloud.retail.v2beta.RemoveFulfillmentPlacesRequest
	12, // 23: google.cloud.retail.v2beta.ProductService.AddLocalInventories:input_type -> google.cloud.retail.v2beta.AddLocalInventoriesRequest
	15, // 24: google.cloud.retail.v2beta.ProductService.RemoveLocalInventories:input_type -> google.cloud.retail.v2beta.RemoveLocalInventoriesRequest
	21, // 25: google.cloud.retail.v2beta.ProductService.CreateProduct:output_type -> google.cloud.retail.v2beta.Product
	21, // 26: google.cloud.retail.v2beta.ProductService.GetProduct:output_type -> google.cloud.retail.v2beta.Product
	5,  // 27: google.cloud.retail.v2beta.ProductService.ListProducts:output_type -> google.cloud.retail.v2beta.ListProductsResponse
	21, // 28: google.cloud.retail.v2beta.ProductService.UpdateProduct:output_type -> google.cloud.retail.v2beta.Product
	26, // 29: google.cloud.retail.v2beta.ProductService.DeleteProduct:output_type -> google.protobuf.Empty
	27, // 30: google.cloud.retail.v2beta.ProductService.ImportProducts:output_type -> google.longrunning.Operation
	27, // 31: google.cloud.retail.v2beta.ProductService.SetInventory:output_type -> google.longrunning.Operation
	27, // 32: google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces:output_type -> google.longrunning.Operation
	27, // 33: google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces:output_type -> google.longrunning.Operation
	27, // 34: google.cloud.retail.v2beta.ProductService.AddLocalInventories:output_type -> google.longrunning.Operation
	27, // 35: google.cloud.retail.v2beta.ProductService.RemoveLocalInventories:output_type -> google.longrunning.Operation
	25, // [25:36] is the sub-list for method output_type
	14, // [14:25] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_product_service_proto_init() }
func file_google_cloud_retail_v2beta_product_service_proto_init() {
	if File_google_cloud_retail_v2beta_product_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2beta_common_proto_init()
	file_google_cloud_retail_v2beta_import_config_proto_init()
	file_google_cloud_retail_v2beta_product_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetInventoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetInventoryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetInventoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddFulfillmentPlacesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddFulfillmentPlacesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddFulfillmentPlacesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddLocalInventoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddLocalInventoriesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddLocalInventoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveLocalInventoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveLocalInventoriesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveLocalInventoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFulfillmentPlacesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFulfillmentPlacesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_product_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFulfillmentPlacesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_product_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2beta_product_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_product_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2beta_product_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_product_service_proto = out.File
	file_google_cloud_retail_v2beta_product_service_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_product_service_proto_goTypes = nil
	file_google_cloud_retail_v2beta_product_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProductServiceClient is the client API for ProductService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProductServiceClient interface {
	// Creates a [Product][google.cloud.retail.v2beta.Product].
	CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Gets a [Product][google.cloud.retail.v2beta.Product].
	GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Gets a list of [Product][google.cloud.retail.v2beta.Product]s.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Updates a [Product][google.cloud.retail.v2beta.Product].
	UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Deletes a [Product][google.cloud.retail.v2beta.Product].
	DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Bulk import of multiple [Product][google.cloud.retail.v2beta.Product]s.
	//
	// Request processing may be synchronous.
	// Non-existing items are created.
	//
	// Note that it is possible for a subset of the
	// [Product][google.cloud.retail.v2beta.Product]s to be successfully updated.
	ImportProducts(ctx context.Context, in *ImportProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] while respecting the last
	// update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update is enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// When inventory is updated with
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct],
	// the specified inventory field value(s) overwrite any existing value(s)
	// while ignoring the last update time for this field. Furthermore, the last
	// update times for the specified inventory fields are overwritten by the
	// times of the
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// or
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// request.
	//
	// If no inventory fields are set in
	// [CreateProductRequest.product][google.cloud.retail.v2beta.CreateProductRequest.product],
	// then any pre-existing inventory information for this product is used.
	//
	// If no inventory fields are set in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask],
	// then any existing inventory information is preserved.
	//
	// Pre-existing inventory information can only be updated with
	// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory],
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces],
	// and
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces].
	//
	// The returned [Operation][google.longrunning.Operation]s is obsolete after
	// one day, and the [GetOperation][google.longrunning.Operations.GetOperation]
	// API returns `NOT_FOUND` afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates are not marked as [done][google.longrunning.Operation.done] until
	// they are obsolete.
	SetInventory(ctx context.Context, in *SetInventoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// It is recommended to use the
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// method instead of
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces].
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally adds place IDs to
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the added place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddFulfillmentPlaces(ctx context.Context, in *AddFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// It is recommended to use the
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// method instead of
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces].
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally removes place IDs from a
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the removed place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveFulfillmentPlaces(ctx context.Context, in *RemoveFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places, while
	// respecting the last update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// inventory information. If the request is valid, the update will be enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be modified using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddLocalInventories(ctx context.Context, in *AddLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Remove local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places at a
	// removal timestamp.
	//
	// This process is asynchronous. If the request is valid, the removal will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, removals are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be removed using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveLocalInventories(ctx context.Context, in *RemoveLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type productServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProductServiceClient(cc grpc.ClientConnInterface) ProductServiceClient {
	return &productServiceClient{cc}
}

func (c *productServiceClient) CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/CreateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/GetProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/ListProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/UpdateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/DeleteProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) ImportProducts(ctx context.Context, in *ImportProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/ImportProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) SetInventory(ctx context.Context, in *SetInventoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/SetInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) AddFulfillmentPlaces(ctx context.Context, in *AddFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/AddFulfillmentPlaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) RemoveFulfillmentPlaces(ctx context.Context, in *RemoveFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/RemoveFulfillmentPlaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) AddLocalInventories(ctx context.Context, in *AddLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/AddLocalInventories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) RemoveLocalInventories(ctx context.Context, in *RemoveLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2beta.ProductService/RemoveLocalInventories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductServiceServer is the server API for ProductService service.
type ProductServiceServer interface {
	// Creates a [Product][google.cloud.retail.v2beta.Product].
	CreateProduct(context.Context, *CreateProductRequest) (*Product, error)
	// Gets a [Product][google.cloud.retail.v2beta.Product].
	GetProduct(context.Context, *GetProductRequest) (*Product, error)
	// Gets a list of [Product][google.cloud.retail.v2beta.Product]s.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Updates a [Product][google.cloud.retail.v2beta.Product].
	UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error)
	// Deletes a [Product][google.cloud.retail.v2beta.Product].
	DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error)
	// Bulk import of multiple [Product][google.cloud.retail.v2beta.Product]s.
	//
	// Request processing may be synchronous.
	// Non-existing items are created.
	//
	// Note that it is possible for a subset of the
	// [Product][google.cloud.retail.v2beta.Product]s to be successfully updated.
	ImportProducts(context.Context, *ImportProductsRequest) (*longrunningpb.Operation, error)
	// Updates inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] while respecting the last
	// update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update is enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// When inventory is updated with
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct],
	// the specified inventory field value(s) overwrite any existing value(s)
	// while ignoring the last update time for this field. Furthermore, the last
	// update times for the specified inventory fields are overwritten by the
	// times of the
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// or
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// request.
	//
	// If no inventory fields are set in
	// [CreateProductRequest.product][google.cloud.retail.v2beta.CreateProductRequest.product],
	// then any pre-existing inventory information for this product is used.
	//
	// If no inventory fields are set in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask],
	// then any existing inventory information is preserved.
	//
	// Pre-existing inventory information can only be updated with
	// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory],
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces],
	// and
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces].
	//
	// The returned [Operation][google.longrunning.Operation]s is obsolete after
	// one day, and the [GetOperation][google.longrunning.Operations.GetOperation]
	// API returns `NOT_FOUND` afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates are not marked as [done][google.longrunning.Operation.done] until
	// they are obsolete.
	SetInventory(context.Context, *SetInventoryRequest) (*longrunningpb.Operation, error)
	// It is recommended to use the
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// method instead of
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces].
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally adds place IDs to
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the added place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddFulfillmentPlaces(context.Context, *AddFulfillmentPlacesRequest) (*longrunningpb.Operation, error)
	// It is recommended to use the
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// method instead of
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces].
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally removes place IDs from a
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the removed place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveFulfillmentPlaces(context.Context, *RemoveFulfillmentPlacesRequest) (*longrunningpb.Operation, error)
	// Updates local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places, while
	// respecting the last update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// inventory information. If the request is valid, the update will be enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be modified using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddLocalInventories(context.Context, *AddLocalInventoriesRequest) (*longrunningpb.Operation, error)
	// Remove local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places at a
	// removal timestamp.
	//
	// This process is asynchronous. If the request is valid, the removal will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, removals are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be removed using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveLocalInventories(context.Context, *RemoveLocalInventoriesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedProductServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProductServiceServer struct {
}

func (*UnimplementedProductServiceServer) CreateProduct(context.Context, *CreateProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProduct not implemented")
}
func (*UnimplementedProductServiceServer) GetProduct(context.Context, *GetProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProduct not implemented")
}
func (*UnimplementedProductServiceServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (*UnimplementedProductServiceServer) UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProduct not implemented")
}
func (*UnimplementedProductServiceServer) DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProduct not implemented")
}
func (*UnimplementedProductServiceServer) ImportProducts(context.Context, *ImportProductsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportProducts not implemented")
}
func (*UnimplementedProductServiceServer) SetInventory(context.Context, *SetInventoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetInventory not implemented")
}
func (*UnimplementedProductServiceServer) AddFulfillmentPlaces(context.Context, *AddFulfillmentPlacesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddFulfillmentPlaces not implemented")
}
func (*UnimplementedProductServiceServer) RemoveFulfillmentPlaces(context.Context, *RemoveFulfillmentPlacesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveFulfillmentPlaces not implemented")
}
func (*UnimplementedProductServiceServer) AddLocalInventories(context.Context, *AddLocalInventoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddLocalInventories not implemented")
}
func (*UnimplementedProductServiceServer) RemoveLocalInventories(context.Context, *RemoveLocalInventoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveLocalInventories not implemented")
}

func RegisterProductServiceServer(s *grpc.Server, srv ProductServiceServer) {
	s.RegisterService(&_ProductService_serviceDesc, srv)
}

func _ProductService_CreateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).CreateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/CreateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).CreateProduct(ctx, req.(*CreateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_GetProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).GetProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/GetProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).GetProduct(ctx, req.(*GetProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/ListProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_UpdateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).UpdateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/UpdateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).UpdateProduct(ctx, req.(*UpdateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_DeleteProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).DeleteProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/DeleteProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).DeleteProduct(ctx, req.(*DeleteProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_ImportProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).ImportProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/ImportProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).ImportProducts(ctx, req.(*ImportProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_SetInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).SetInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/SetInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).SetInventory(ctx, req.(*SetInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_AddFulfillmentPlaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddFulfillmentPlacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).AddFulfillmentPlaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/AddFulfillmentPlaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).AddFulfillmentPlaces(ctx, req.(*AddFulfillmentPlacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_RemoveFulfillmentPlaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveFulfillmentPlacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).RemoveFulfillmentPlaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/RemoveFulfillmentPlaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).RemoveFulfillmentPlaces(ctx, req.(*RemoveFulfillmentPlacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_AddLocalInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddLocalInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).AddLocalInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/AddLocalInventories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).AddLocalInventories(ctx, req.(*AddLocalInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_RemoveLocalInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveLocalInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).RemoveLocalInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2beta.ProductService/RemoveLocalInventories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).RemoveLocalInventories(ctx, req.(*RemoveLocalInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProductService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2beta.ProductService",
	HandlerType: (*ProductServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProduct",
			Handler:    _ProductService_CreateProduct_Handler,
		},
		{
			MethodName: "GetProduct",
			Handler:    _ProductService_GetProduct_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _ProductService_ListProducts_Handler,
		},
		{
			MethodName: "UpdateProduct",
			Handler:    _ProductService_UpdateProduct_Handler,
		},
		{
			MethodName: "DeleteProduct",
			Handler:    _ProductService_DeleteProduct_Handler,
		},
		{
			MethodName: "ImportProducts",
			Handler:    _ProductService_ImportProducts_Handler,
		},
		{
			MethodName: "SetInventory",
			Handler:    _ProductService_SetInventory_Handler,
		},
		{
			MethodName: "AddFulfillmentPlaces",
			Handler:    _ProductService_AddFulfillmentPlaces_Handler,
		},
		{
			MethodName: "RemoveFulfillmentPlaces",
			Handler:    _ProductService_RemoveFulfillmentPlaces_Handler,
		},
		{
			MethodName: "AddLocalInventories",
			Handler:    _ProductService_AddLocalInventories_Handler,
		},
		{
			MethodName: "RemoveLocalInventories",
			Handler:    _ProductService_RemoveLocalInventories_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2beta/product_service.proto",
}
