// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package netapp

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	netapppb "cloud.google.com/go/netapp/apiv1/netapppb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListStoragePools            []gax.CallOption
	CreateStoragePool           []gax.CallOption
	GetStoragePool              []gax.CallOption
	UpdateStoragePool           []gax.CallOption
	DeleteStoragePool           []gax.CallOption
	ListVolumes                 []gax.CallOption
	GetVolume                   []gax.CallOption
	CreateVolume                []gax.CallOption
	UpdateVolume                []gax.CallOption
	DeleteVolume                []gax.CallOption
	RevertVolume                []gax.CallOption
	ListSnapshots               []gax.CallOption
	GetSnapshot                 []gax.CallOption
	CreateSnapshot              []gax.CallOption
	DeleteSnapshot              []gax.CallOption
	UpdateSnapshot              []gax.CallOption
	ListActiveDirectories       []gax.CallOption
	GetActiveDirectory          []gax.CallOption
	CreateActiveDirectory       []gax.CallOption
	UpdateActiveDirectory       []gax.CallOption
	DeleteActiveDirectory       []gax.CallOption
	ListKmsConfigs              []gax.CallOption
	CreateKmsConfig             []gax.CallOption
	GetKmsConfig                []gax.CallOption
	UpdateKmsConfig             []gax.CallOption
	EncryptVolumes              []gax.CallOption
	VerifyKmsConfig             []gax.CallOption
	DeleteKmsConfig             []gax.CallOption
	ListReplications            []gax.CallOption
	GetReplication              []gax.CallOption
	CreateReplication           []gax.CallOption
	DeleteReplication           []gax.CallOption
	UpdateReplication           []gax.CallOption
	StopReplication             []gax.CallOption
	ResumeReplication           []gax.CallOption
	ReverseReplicationDirection []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("netapp.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("netapp.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://netapp.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListStoragePools: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RevertVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSnapshots: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListActiveDirectories: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListKmsConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EncryptVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		VerifyKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReplications: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReverseReplicationDirection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListStoragePools: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteStoragePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RevertVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSnapshots: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListActiveDirectories: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteActiveDirectory: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListKmsConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EncryptVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		VerifyKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteKmsConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReplications: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeReplication: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReverseReplicationDirection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

// internalClient is an interface that defines the methods available from NetApp API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListStoragePools(context.Context, *netapppb.ListStoragePoolsRequest, ...gax.CallOption) *StoragePoolIterator
	CreateStoragePool(context.Context, *netapppb.CreateStoragePoolRequest, ...gax.CallOption) (*CreateStoragePoolOperation, error)
	CreateStoragePoolOperation(name string) *CreateStoragePoolOperation
	GetStoragePool(context.Context, *netapppb.GetStoragePoolRequest, ...gax.CallOption) (*netapppb.StoragePool, error)
	UpdateStoragePool(context.Context, *netapppb.UpdateStoragePoolRequest, ...gax.CallOption) (*UpdateStoragePoolOperation, error)
	UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation
	DeleteStoragePool(context.Context, *netapppb.DeleteStoragePoolRequest, ...gax.CallOption) (*DeleteStoragePoolOperation, error)
	DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation
	ListVolumes(context.Context, *netapppb.ListVolumesRequest, ...gax.CallOption) *VolumeIterator
	GetVolume(context.Context, *netapppb.GetVolumeRequest, ...gax.CallOption) (*netapppb.Volume, error)
	CreateVolume(context.Context, *netapppb.CreateVolumeRequest, ...gax.CallOption) (*CreateVolumeOperation, error)
	CreateVolumeOperation(name string) *CreateVolumeOperation
	UpdateVolume(context.Context, *netapppb.UpdateVolumeRequest, ...gax.CallOption) (*UpdateVolumeOperation, error)
	UpdateVolumeOperation(name string) *UpdateVolumeOperation
	DeleteVolume(context.Context, *netapppb.DeleteVolumeRequest, ...gax.CallOption) (*DeleteVolumeOperation, error)
	DeleteVolumeOperation(name string) *DeleteVolumeOperation
	RevertVolume(context.Context, *netapppb.RevertVolumeRequest, ...gax.CallOption) (*RevertVolumeOperation, error)
	RevertVolumeOperation(name string) *RevertVolumeOperation
	ListSnapshots(context.Context, *netapppb.ListSnapshotsRequest, ...gax.CallOption) *SnapshotIterator
	GetSnapshot(context.Context, *netapppb.GetSnapshotRequest, ...gax.CallOption) (*netapppb.Snapshot, error)
	CreateSnapshot(context.Context, *netapppb.CreateSnapshotRequest, ...gax.CallOption) (*CreateSnapshotOperation, error)
	CreateSnapshotOperation(name string) *CreateSnapshotOperation
	DeleteSnapshot(context.Context, *netapppb.DeleteSnapshotRequest, ...gax.CallOption) (*DeleteSnapshotOperation, error)
	DeleteSnapshotOperation(name string) *DeleteSnapshotOperation
	UpdateSnapshot(context.Context, *netapppb.UpdateSnapshotRequest, ...gax.CallOption) (*UpdateSnapshotOperation, error)
	UpdateSnapshotOperation(name string) *UpdateSnapshotOperation
	ListActiveDirectories(context.Context, *netapppb.ListActiveDirectoriesRequest, ...gax.CallOption) *ActiveDirectoryIterator
	GetActiveDirectory(context.Context, *netapppb.GetActiveDirectoryRequest, ...gax.CallOption) (*netapppb.ActiveDirectory, error)
	CreateActiveDirectory(context.Context, *netapppb.CreateActiveDirectoryRequest, ...gax.CallOption) (*CreateActiveDirectoryOperation, error)
	CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation
	UpdateActiveDirectory(context.Context, *netapppb.UpdateActiveDirectoryRequest, ...gax.CallOption) (*UpdateActiveDirectoryOperation, error)
	UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation
	DeleteActiveDirectory(context.Context, *netapppb.DeleteActiveDirectoryRequest, ...gax.CallOption) (*DeleteActiveDirectoryOperation, error)
	DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation
	ListKmsConfigs(context.Context, *netapppb.ListKmsConfigsRequest, ...gax.CallOption) *KmsConfigIterator
	CreateKmsConfig(context.Context, *netapppb.CreateKmsConfigRequest, ...gax.CallOption) (*CreateKmsConfigOperation, error)
	CreateKmsConfigOperation(name string) *CreateKmsConfigOperation
	GetKmsConfig(context.Context, *netapppb.GetKmsConfigRequest, ...gax.CallOption) (*netapppb.KmsConfig, error)
	UpdateKmsConfig(context.Context, *netapppb.UpdateKmsConfigRequest, ...gax.CallOption) (*UpdateKmsConfigOperation, error)
	UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation
	EncryptVolumes(context.Context, *netapppb.EncryptVolumesRequest, ...gax.CallOption) (*EncryptVolumesOperation, error)
	EncryptVolumesOperation(name string) *EncryptVolumesOperation
	VerifyKmsConfig(context.Context, *netapppb.VerifyKmsConfigRequest, ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error)
	DeleteKmsConfig(context.Context, *netapppb.DeleteKmsConfigRequest, ...gax.CallOption) (*DeleteKmsConfigOperation, error)
	DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation
	ListReplications(context.Context, *netapppb.ListReplicationsRequest, ...gax.CallOption) *ReplicationIterator
	GetReplication(context.Context, *netapppb.GetReplicationRequest, ...gax.CallOption) (*netapppb.Replication, error)
	CreateReplication(context.Context, *netapppb.CreateReplicationRequest, ...gax.CallOption) (*CreateReplicationOperation, error)
	CreateReplicationOperation(name string) *CreateReplicationOperation
	DeleteReplication(context.Context, *netapppb.DeleteReplicationRequest, ...gax.CallOption) (*DeleteReplicationOperation, error)
	DeleteReplicationOperation(name string) *DeleteReplicationOperation
	UpdateReplication(context.Context, *netapppb.UpdateReplicationRequest, ...gax.CallOption) (*UpdateReplicationOperation, error)
	UpdateReplicationOperation(name string) *UpdateReplicationOperation
	StopReplication(context.Context, *netapppb.StopReplicationRequest, ...gax.CallOption) (*StopReplicationOperation, error)
	StopReplicationOperation(name string) *StopReplicationOperation
	ResumeReplication(context.Context, *netapppb.ResumeReplicationRequest, ...gax.CallOption) (*ResumeReplicationOperation, error)
	ResumeReplicationOperation(name string) *ResumeReplicationOperation
	ReverseReplicationDirection(context.Context, *netapppb.ReverseReplicationDirectionRequest, ...gax.CallOption) (*ReverseReplicationDirectionOperation, error)
	ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation
}

// Client is a client for interacting with NetApp API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// NetApp Files Google Cloud Service
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListStoragePools returns descriptions of all storage pools owned by the caller.
func (c *Client) ListStoragePools(ctx context.Context, req *netapppb.ListStoragePoolsRequest, opts ...gax.CallOption) *StoragePoolIterator {
	return c.internalClient.ListStoragePools(ctx, req, opts...)
}

// CreateStoragePool creates a new storage pool.
func (c *Client) CreateStoragePool(ctx context.Context, req *netapppb.CreateStoragePoolRequest, opts ...gax.CallOption) (*CreateStoragePoolOperation, error) {
	return c.internalClient.CreateStoragePool(ctx, req, opts...)
}

// CreateStoragePoolOperation returns a new CreateStoragePoolOperation from a given name.
// The name must be that of a previously created CreateStoragePoolOperation, possibly from a different process.
func (c *Client) CreateStoragePoolOperation(name string) *CreateStoragePoolOperation {
	return c.internalClient.CreateStoragePoolOperation(name)
}

// GetStoragePool returns the description of the specified storage pool by poolId.
func (c *Client) GetStoragePool(ctx context.Context, req *netapppb.GetStoragePoolRequest, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	return c.internalClient.GetStoragePool(ctx, req, opts...)
}

// UpdateStoragePool updates the storage pool properties with the full spec
func (c *Client) UpdateStoragePool(ctx context.Context, req *netapppb.UpdateStoragePoolRequest, opts ...gax.CallOption) (*UpdateStoragePoolOperation, error) {
	return c.internalClient.UpdateStoragePool(ctx, req, opts...)
}

// UpdateStoragePoolOperation returns a new UpdateStoragePoolOperation from a given name.
// The name must be that of a previously created UpdateStoragePoolOperation, possibly from a different process.
func (c *Client) UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation {
	return c.internalClient.UpdateStoragePoolOperation(name)
}

// DeleteStoragePool warning! This operation will permanently delete the storage pool.
func (c *Client) DeleteStoragePool(ctx context.Context, req *netapppb.DeleteStoragePoolRequest, opts ...gax.CallOption) (*DeleteStoragePoolOperation, error) {
	return c.internalClient.DeleteStoragePool(ctx, req, opts...)
}

// DeleteStoragePoolOperation returns a new DeleteStoragePoolOperation from a given name.
// The name must be that of a previously created DeleteStoragePoolOperation, possibly from a different process.
func (c *Client) DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation {
	return c.internalClient.DeleteStoragePoolOperation(name)
}

// ListVolumes lists Volumes in a given project.
func (c *Client) ListVolumes(ctx context.Context, req *netapppb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	return c.internalClient.ListVolumes(ctx, req, opts...)
}

// GetVolume gets details of a single Volume.
func (c *Client) GetVolume(ctx context.Context, req *netapppb.GetVolumeRequest, opts ...gax.CallOption) (*netapppb.Volume, error) {
	return c.internalClient.GetVolume(ctx, req, opts...)
}

// CreateVolume creates a new Volume in a given project and location.
func (c *Client) CreateVolume(ctx context.Context, req *netapppb.CreateVolumeRequest, opts ...gax.CallOption) (*CreateVolumeOperation, error) {
	return c.internalClient.CreateVolume(ctx, req, opts...)
}

// CreateVolumeOperation returns a new CreateVolumeOperation from a given name.
// The name must be that of a previously created CreateVolumeOperation, possibly from a different process.
func (c *Client) CreateVolumeOperation(name string) *CreateVolumeOperation {
	return c.internalClient.CreateVolumeOperation(name)
}

// UpdateVolume updates the parameters of a single Volume.
func (c *Client) UpdateVolume(ctx context.Context, req *netapppb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	return c.internalClient.UpdateVolume(ctx, req, opts...)
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *Client) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return c.internalClient.UpdateVolumeOperation(name)
}

// DeleteVolume deletes a single Volume.
func (c *Client) DeleteVolume(ctx context.Context, req *netapppb.DeleteVolumeRequest, opts ...gax.CallOption) (*DeleteVolumeOperation, error) {
	return c.internalClient.DeleteVolume(ctx, req, opts...)
}

// DeleteVolumeOperation returns a new DeleteVolumeOperation from a given name.
// The name must be that of a previously created DeleteVolumeOperation, possibly from a different process.
func (c *Client) DeleteVolumeOperation(name string) *DeleteVolumeOperation {
	return c.internalClient.DeleteVolumeOperation(name)
}

// RevertVolume revert an existing volume to a specified snapshot.
// Warning! This operation will permanently revert all changes made after the
// snapshot was created.
func (c *Client) RevertVolume(ctx context.Context, req *netapppb.RevertVolumeRequest, opts ...gax.CallOption) (*RevertVolumeOperation, error) {
	return c.internalClient.RevertVolume(ctx, req, opts...)
}

// RevertVolumeOperation returns a new RevertVolumeOperation from a given name.
// The name must be that of a previously created RevertVolumeOperation, possibly from a different process.
func (c *Client) RevertVolumeOperation(name string) *RevertVolumeOperation {
	return c.internalClient.RevertVolumeOperation(name)
}

// ListSnapshots returns descriptions of all snapshots for a volume.
func (c *Client) ListSnapshots(ctx context.Context, req *netapppb.ListSnapshotsRequest, opts ...gax.CallOption) *SnapshotIterator {
	return c.internalClient.ListSnapshots(ctx, req, opts...)
}

// GetSnapshot describe a snapshot for a volume.
func (c *Client) GetSnapshot(ctx context.Context, req *netapppb.GetSnapshotRequest, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	return c.internalClient.GetSnapshot(ctx, req, opts...)
}

// CreateSnapshot create a new snapshot for a volume.
func (c *Client) CreateSnapshot(ctx context.Context, req *netapppb.CreateSnapshotRequest, opts ...gax.CallOption) (*CreateSnapshotOperation, error) {
	return c.internalClient.CreateSnapshot(ctx, req, opts...)
}

// CreateSnapshotOperation returns a new CreateSnapshotOperation from a given name.
// The name must be that of a previously created CreateSnapshotOperation, possibly from a different process.
func (c *Client) CreateSnapshotOperation(name string) *CreateSnapshotOperation {
	return c.internalClient.CreateSnapshotOperation(name)
}

// DeleteSnapshot deletes a snapshot.
func (c *Client) DeleteSnapshot(ctx context.Context, req *netapppb.DeleteSnapshotRequest, opts ...gax.CallOption) (*DeleteSnapshotOperation, error) {
	return c.internalClient.DeleteSnapshot(ctx, req, opts...)
}

// DeleteSnapshotOperation returns a new DeleteSnapshotOperation from a given name.
// The name must be that of a previously created DeleteSnapshotOperation, possibly from a different process.
func (c *Client) DeleteSnapshotOperation(name string) *DeleteSnapshotOperation {
	return c.internalClient.DeleteSnapshotOperation(name)
}

// UpdateSnapshot updates the settings of a specific snapshot.
func (c *Client) UpdateSnapshot(ctx context.Context, req *netapppb.UpdateSnapshotRequest, opts ...gax.CallOption) (*UpdateSnapshotOperation, error) {
	return c.internalClient.UpdateSnapshot(ctx, req, opts...)
}

// UpdateSnapshotOperation returns a new UpdateSnapshotOperation from a given name.
// The name must be that of a previously created UpdateSnapshotOperation, possibly from a different process.
func (c *Client) UpdateSnapshotOperation(name string) *UpdateSnapshotOperation {
	return c.internalClient.UpdateSnapshotOperation(name)
}

// ListActiveDirectories lists active directories.
func (c *Client) ListActiveDirectories(ctx context.Context, req *netapppb.ListActiveDirectoriesRequest, opts ...gax.CallOption) *ActiveDirectoryIterator {
	return c.internalClient.ListActiveDirectories(ctx, req, opts...)
}

// GetActiveDirectory describes a specified active directory.
func (c *Client) GetActiveDirectory(ctx context.Context, req *netapppb.GetActiveDirectoryRequest, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	return c.internalClient.GetActiveDirectory(ctx, req, opts...)
}

// CreateActiveDirectory createActiveDirectory
// Creates the active directory specified in the request.
func (c *Client) CreateActiveDirectory(ctx context.Context, req *netapppb.CreateActiveDirectoryRequest, opts ...gax.CallOption) (*CreateActiveDirectoryOperation, error) {
	return c.internalClient.CreateActiveDirectory(ctx, req, opts...)
}

// CreateActiveDirectoryOperation returns a new CreateActiveDirectoryOperation from a given name.
// The name must be that of a previously created CreateActiveDirectoryOperation, possibly from a different process.
func (c *Client) CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation {
	return c.internalClient.CreateActiveDirectoryOperation(name)
}

// UpdateActiveDirectory update the parameters of an active directories.
func (c *Client) UpdateActiveDirectory(ctx context.Context, req *netapppb.UpdateActiveDirectoryRequest, opts ...gax.CallOption) (*UpdateActiveDirectoryOperation, error) {
	return c.internalClient.UpdateActiveDirectory(ctx, req, opts...)
}

// UpdateActiveDirectoryOperation returns a new UpdateActiveDirectoryOperation from a given name.
// The name must be that of a previously created UpdateActiveDirectoryOperation, possibly from a different process.
func (c *Client) UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation {
	return c.internalClient.UpdateActiveDirectoryOperation(name)
}

// DeleteActiveDirectory delete the active directory specified in the request.
func (c *Client) DeleteActiveDirectory(ctx context.Context, req *netapppb.DeleteActiveDirectoryRequest, opts ...gax.CallOption) (*DeleteActiveDirectoryOperation, error) {
	return c.internalClient.DeleteActiveDirectory(ctx, req, opts...)
}

// DeleteActiveDirectoryOperation returns a new DeleteActiveDirectoryOperation from a given name.
// The name must be that of a previously created DeleteActiveDirectoryOperation, possibly from a different process.
func (c *Client) DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation {
	return c.internalClient.DeleteActiveDirectoryOperation(name)
}

// ListKmsConfigs returns descriptions of all KMS configs owned by the caller.
func (c *Client) ListKmsConfigs(ctx context.Context, req *netapppb.ListKmsConfigsRequest, opts ...gax.CallOption) *KmsConfigIterator {
	return c.internalClient.ListKmsConfigs(ctx, req, opts...)
}

// CreateKmsConfig creates a new KMS config.
func (c *Client) CreateKmsConfig(ctx context.Context, req *netapppb.CreateKmsConfigRequest, opts ...gax.CallOption) (*CreateKmsConfigOperation, error) {
	return c.internalClient.CreateKmsConfig(ctx, req, opts...)
}

// CreateKmsConfigOperation returns a new CreateKmsConfigOperation from a given name.
// The name must be that of a previously created CreateKmsConfigOperation, possibly from a different process.
func (c *Client) CreateKmsConfigOperation(name string) *CreateKmsConfigOperation {
	return c.internalClient.CreateKmsConfigOperation(name)
}

// GetKmsConfig returns the description of the specified KMS config by kms_config_id.
func (c *Client) GetKmsConfig(ctx context.Context, req *netapppb.GetKmsConfigRequest, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	return c.internalClient.GetKmsConfig(ctx, req, opts...)
}

// UpdateKmsConfig updates the Kms config properties with the full spec
func (c *Client) UpdateKmsConfig(ctx context.Context, req *netapppb.UpdateKmsConfigRequest, opts ...gax.CallOption) (*UpdateKmsConfigOperation, error) {
	return c.internalClient.UpdateKmsConfig(ctx, req, opts...)
}

// UpdateKmsConfigOperation returns a new UpdateKmsConfigOperation from a given name.
// The name must be that of a previously created UpdateKmsConfigOperation, possibly from a different process.
func (c *Client) UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation {
	return c.internalClient.UpdateKmsConfigOperation(name)
}

// EncryptVolumes encrypt the existing volumes without CMEK encryption with the desired the
// KMS config for the whole region.
func (c *Client) EncryptVolumes(ctx context.Context, req *netapppb.EncryptVolumesRequest, opts ...gax.CallOption) (*EncryptVolumesOperation, error) {
	return c.internalClient.EncryptVolumes(ctx, req, opts...)
}

// EncryptVolumesOperation returns a new EncryptVolumesOperation from a given name.
// The name must be that of a previously created EncryptVolumesOperation, possibly from a different process.
func (c *Client) EncryptVolumesOperation(name string) *EncryptVolumesOperation {
	return c.internalClient.EncryptVolumesOperation(name)
}

// VerifyKmsConfig verifies KMS config reachability.
func (c *Client) VerifyKmsConfig(ctx context.Context, req *netapppb.VerifyKmsConfigRequest, opts ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error) {
	return c.internalClient.VerifyKmsConfig(ctx, req, opts...)
}

// DeleteKmsConfig warning! This operation will permanently delete the Kms config.
func (c *Client) DeleteKmsConfig(ctx context.Context, req *netapppb.DeleteKmsConfigRequest, opts ...gax.CallOption) (*DeleteKmsConfigOperation, error) {
	return c.internalClient.DeleteKmsConfig(ctx, req, opts...)
}

// DeleteKmsConfigOperation returns a new DeleteKmsConfigOperation from a given name.
// The name must be that of a previously created DeleteKmsConfigOperation, possibly from a different process.
func (c *Client) DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation {
	return c.internalClient.DeleteKmsConfigOperation(name)
}

// ListReplications returns descriptions of all replications for a volume.
func (c *Client) ListReplications(ctx context.Context, req *netapppb.ListReplicationsRequest, opts ...gax.CallOption) *ReplicationIterator {
	return c.internalClient.ListReplications(ctx, req, opts...)
}

// GetReplication describe a replication for a volume.
func (c *Client) GetReplication(ctx context.Context, req *netapppb.GetReplicationRequest, opts ...gax.CallOption) (*netapppb.Replication, error) {
	return c.internalClient.GetReplication(ctx, req, opts...)
}

// CreateReplication create a new replication for a volume.
func (c *Client) CreateReplication(ctx context.Context, req *netapppb.CreateReplicationRequest, opts ...gax.CallOption) (*CreateReplicationOperation, error) {
	return c.internalClient.CreateReplication(ctx, req, opts...)
}

// CreateReplicationOperation returns a new CreateReplicationOperation from a given name.
// The name must be that of a previously created CreateReplicationOperation, possibly from a different process.
func (c *Client) CreateReplicationOperation(name string) *CreateReplicationOperation {
	return c.internalClient.CreateReplicationOperation(name)
}

// DeleteReplication deletes a replication.
func (c *Client) DeleteReplication(ctx context.Context, req *netapppb.DeleteReplicationRequest, opts ...gax.CallOption) (*DeleteReplicationOperation, error) {
	return c.internalClient.DeleteReplication(ctx, req, opts...)
}

// DeleteReplicationOperation returns a new DeleteReplicationOperation from a given name.
// The name must be that of a previously created DeleteReplicationOperation, possibly from a different process.
func (c *Client) DeleteReplicationOperation(name string) *DeleteReplicationOperation {
	return c.internalClient.DeleteReplicationOperation(name)
}

// UpdateReplication updates the settings of a specific replication.
func (c *Client) UpdateReplication(ctx context.Context, req *netapppb.UpdateReplicationRequest, opts ...gax.CallOption) (*UpdateReplicationOperation, error) {
	return c.internalClient.UpdateReplication(ctx, req, opts...)
}

// UpdateReplicationOperation returns a new UpdateReplicationOperation from a given name.
// The name must be that of a previously created UpdateReplicationOperation, possibly from a different process.
func (c *Client) UpdateReplicationOperation(name string) *UpdateReplicationOperation {
	return c.internalClient.UpdateReplicationOperation(name)
}

// StopReplication stop Cross Region Replication.
func (c *Client) StopReplication(ctx context.Context, req *netapppb.StopReplicationRequest, opts ...gax.CallOption) (*StopReplicationOperation, error) {
	return c.internalClient.StopReplication(ctx, req, opts...)
}

// StopReplicationOperation returns a new StopReplicationOperation from a given name.
// The name must be that of a previously created StopReplicationOperation, possibly from a different process.
func (c *Client) StopReplicationOperation(name string) *StopReplicationOperation {
	return c.internalClient.StopReplicationOperation(name)
}

// ResumeReplication resume Cross Region Replication.
func (c *Client) ResumeReplication(ctx context.Context, req *netapppb.ResumeReplicationRequest, opts ...gax.CallOption) (*ResumeReplicationOperation, error) {
	return c.internalClient.ResumeReplication(ctx, req, opts...)
}

// ResumeReplicationOperation returns a new ResumeReplicationOperation from a given name.
// The name must be that of a previously created ResumeReplicationOperation, possibly from a different process.
func (c *Client) ResumeReplicationOperation(name string) *ResumeReplicationOperation {
	return c.internalClient.ResumeReplicationOperation(name)
}

// ReverseReplicationDirection reverses direction of replication. Source becomes destination and
// destination becomes source.
func (c *Client) ReverseReplicationDirection(ctx context.Context, req *netapppb.ReverseReplicationDirectionRequest, opts ...gax.CallOption) (*ReverseReplicationDirectionOperation, error) {
	return c.internalClient.ReverseReplicationDirection(ctx, req, opts...)
}

// ReverseReplicationDirectionOperation returns a new ReverseReplicationDirectionOperation from a given name.
// The name must be that of a previously created ReverseReplicationDirectionOperation, possibly from a different process.
func (c *Client) ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation {
	return c.internalClient.ReverseReplicationDirectionOperation(name)
}

// gRPCClient is a client for interacting with NetApp API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client netapppb.NetAppClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewClient creates a new net app client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// NetApp Files Google Cloud Service
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:    connPool,
		client:      netapppb.NewNetAppClient(connPool),
		CallOptions: &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions
}

// NewRESTClient creates a new net app rest client.
//
// NetApp Files Google Cloud Service
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://netapp.googleapis.com"),
		internaloption.WithDefaultMTLSEndpoint("https://netapp.mtls.googleapis.com"),
		internaloption.WithDefaultAudience("https://netapp.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListStoragePools(ctx context.Context, req *netapppb.ListStoragePoolsRequest, opts ...gax.CallOption) *StoragePoolIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListStoragePools[0:len((*c.CallOptions).ListStoragePools):len((*c.CallOptions).ListStoragePools)], opts...)
	it := &StoragePoolIterator{}
	req = proto.Clone(req).(*netapppb.ListStoragePoolsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.StoragePool, string, error) {
		resp := &netapppb.ListStoragePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListStoragePools(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetStoragePools(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CreateStoragePool(ctx context.Context, req *netapppb.CreateStoragePoolRequest, opts ...gax.CallOption) (*CreateStoragePoolOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateStoragePool[0:len((*c.CallOptions).CreateStoragePool):len((*c.CallOptions).CreateStoragePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateStoragePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetStoragePool(ctx context.Context, req *netapppb.GetStoragePoolRequest, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetStoragePool[0:len((*c.CallOptions).GetStoragePool):len((*c.CallOptions).GetStoragePool)], opts...)
	var resp *netapppb.StoragePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetStoragePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateStoragePool(ctx context.Context, req *netapppb.UpdateStoragePoolRequest, opts ...gax.CallOption) (*UpdateStoragePoolOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "storage_pool.name", url.QueryEscape(req.GetStoragePool().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateStoragePool[0:len((*c.CallOptions).UpdateStoragePool):len((*c.CallOptions).UpdateStoragePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateStoragePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteStoragePool(ctx context.Context, req *netapppb.DeleteStoragePoolRequest, opts ...gax.CallOption) (*DeleteStoragePoolOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteStoragePool[0:len((*c.CallOptions).DeleteStoragePool):len((*c.CallOptions).DeleteStoragePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteStoragePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListVolumes(ctx context.Context, req *netapppb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListVolumes[0:len((*c.CallOptions).ListVolumes):len((*c.CallOptions).ListVolumes)], opts...)
	it := &VolumeIterator{}
	req = proto.Clone(req).(*netapppb.ListVolumesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Volume, string, error) {
		resp := &netapppb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListVolumes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetVolume(ctx context.Context, req *netapppb.GetVolumeRequest, opts ...gax.CallOption) (*netapppb.Volume, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	var resp *netapppb.Volume
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateVolume(ctx context.Context, req *netapppb.CreateVolumeRequest, opts ...gax.CallOption) (*CreateVolumeOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateVolume[0:len((*c.CallOptions).CreateVolume):len((*c.CallOptions).CreateVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateVolume(ctx context.Context, req *netapppb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateVolume[0:len((*c.CallOptions).UpdateVolume):len((*c.CallOptions).UpdateVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteVolume(ctx context.Context, req *netapppb.DeleteVolumeRequest, opts ...gax.CallOption) (*DeleteVolumeOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteVolume[0:len((*c.CallOptions).DeleteVolume):len((*c.CallOptions).DeleteVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RevertVolume(ctx context.Context, req *netapppb.RevertVolumeRequest, opts ...gax.CallOption) (*RevertVolumeOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).RevertVolume[0:len((*c.CallOptions).RevertVolume):len((*c.CallOptions).RevertVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RevertVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RevertVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListSnapshots(ctx context.Context, req *netapppb.ListSnapshotsRequest, opts ...gax.CallOption) *SnapshotIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListSnapshots[0:len((*c.CallOptions).ListSnapshots):len((*c.CallOptions).ListSnapshots)], opts...)
	it := &SnapshotIterator{}
	req = proto.Clone(req).(*netapppb.ListSnapshotsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Snapshot, string, error) {
		resp := &netapppb.ListSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListSnapshots(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSnapshots(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSnapshot(ctx context.Context, req *netapppb.GetSnapshotRequest, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetSnapshot[0:len((*c.CallOptions).GetSnapshot):len((*c.CallOptions).GetSnapshot)], opts...)
	var resp *netapppb.Snapshot
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSnapshot(ctx context.Context, req *netapppb.CreateSnapshotRequest, opts ...gax.CallOption) (*CreateSnapshotOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateSnapshot[0:len((*c.CallOptions).CreateSnapshot):len((*c.CallOptions).CreateSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteSnapshot(ctx context.Context, req *netapppb.DeleteSnapshotRequest, opts ...gax.CallOption) (*DeleteSnapshotOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteSnapshot[0:len((*c.CallOptions).DeleteSnapshot):len((*c.CallOptions).DeleteSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateSnapshot(ctx context.Context, req *netapppb.UpdateSnapshotRequest, opts ...gax.CallOption) (*UpdateSnapshotOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "snapshot.name", url.QueryEscape(req.GetSnapshot().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateSnapshot[0:len((*c.CallOptions).UpdateSnapshot):len((*c.CallOptions).UpdateSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListActiveDirectories(ctx context.Context, req *netapppb.ListActiveDirectoriesRequest, opts ...gax.CallOption) *ActiveDirectoryIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListActiveDirectories[0:len((*c.CallOptions).ListActiveDirectories):len((*c.CallOptions).ListActiveDirectories)], opts...)
	it := &ActiveDirectoryIterator{}
	req = proto.Clone(req).(*netapppb.ListActiveDirectoriesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.ActiveDirectory, string, error) {
		resp := &netapppb.ListActiveDirectoriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListActiveDirectories(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetActiveDirectories(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetActiveDirectory(ctx context.Context, req *netapppb.GetActiveDirectoryRequest, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetActiveDirectory[0:len((*c.CallOptions).GetActiveDirectory):len((*c.CallOptions).GetActiveDirectory)], opts...)
	var resp *netapppb.ActiveDirectory
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetActiveDirectory(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateActiveDirectory(ctx context.Context, req *netapppb.CreateActiveDirectoryRequest, opts ...gax.CallOption) (*CreateActiveDirectoryOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateActiveDirectory[0:len((*c.CallOptions).CreateActiveDirectory):len((*c.CallOptions).CreateActiveDirectory)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateActiveDirectory(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateActiveDirectory(ctx context.Context, req *netapppb.UpdateActiveDirectoryRequest, opts ...gax.CallOption) (*UpdateActiveDirectoryOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "active_directory.name", url.QueryEscape(req.GetActiveDirectory().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateActiveDirectory[0:len((*c.CallOptions).UpdateActiveDirectory):len((*c.CallOptions).UpdateActiveDirectory)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateActiveDirectory(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteActiveDirectory(ctx context.Context, req *netapppb.DeleteActiveDirectoryRequest, opts ...gax.CallOption) (*DeleteActiveDirectoryOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteActiveDirectory[0:len((*c.CallOptions).DeleteActiveDirectory):len((*c.CallOptions).DeleteActiveDirectory)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteActiveDirectory(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListKmsConfigs(ctx context.Context, req *netapppb.ListKmsConfigsRequest, opts ...gax.CallOption) *KmsConfigIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListKmsConfigs[0:len((*c.CallOptions).ListKmsConfigs):len((*c.CallOptions).ListKmsConfigs)], opts...)
	it := &KmsConfigIterator{}
	req = proto.Clone(req).(*netapppb.ListKmsConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.KmsConfig, string, error) {
		resp := &netapppb.ListKmsConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListKmsConfigs(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetKmsConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CreateKmsConfig(ctx context.Context, req *netapppb.CreateKmsConfigRequest, opts ...gax.CallOption) (*CreateKmsConfigOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateKmsConfig[0:len((*c.CallOptions).CreateKmsConfig):len((*c.CallOptions).CreateKmsConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateKmsConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetKmsConfig(ctx context.Context, req *netapppb.GetKmsConfigRequest, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetKmsConfig[0:len((*c.CallOptions).GetKmsConfig):len((*c.CallOptions).GetKmsConfig)], opts...)
	var resp *netapppb.KmsConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetKmsConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateKmsConfig(ctx context.Context, req *netapppb.UpdateKmsConfigRequest, opts ...gax.CallOption) (*UpdateKmsConfigOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "kms_config.name", url.QueryEscape(req.GetKmsConfig().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateKmsConfig[0:len((*c.CallOptions).UpdateKmsConfig):len((*c.CallOptions).UpdateKmsConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateKmsConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) EncryptVolumes(ctx context.Context, req *netapppb.EncryptVolumesRequest, opts ...gax.CallOption) (*EncryptVolumesOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).EncryptVolumes[0:len((*c.CallOptions).EncryptVolumes):len((*c.CallOptions).EncryptVolumes)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.EncryptVolumes(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EncryptVolumesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) VerifyKmsConfig(ctx context.Context, req *netapppb.VerifyKmsConfigRequest, opts ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).VerifyKmsConfig[0:len((*c.CallOptions).VerifyKmsConfig):len((*c.CallOptions).VerifyKmsConfig)], opts...)
	var resp *netapppb.VerifyKmsConfigResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.VerifyKmsConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteKmsConfig(ctx context.Context, req *netapppb.DeleteKmsConfigRequest, opts ...gax.CallOption) (*DeleteKmsConfigOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteKmsConfig[0:len((*c.CallOptions).DeleteKmsConfig):len((*c.CallOptions).DeleteKmsConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteKmsConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListReplications(ctx context.Context, req *netapppb.ListReplicationsRequest, opts ...gax.CallOption) *ReplicationIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListReplications[0:len((*c.CallOptions).ListReplications):len((*c.CallOptions).ListReplications)], opts...)
	it := &ReplicationIterator{}
	req = proto.Clone(req).(*netapppb.ListReplicationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Replication, string, error) {
		resp := &netapppb.ListReplicationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListReplications(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReplications(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetReplication(ctx context.Context, req *netapppb.GetReplicationRequest, opts ...gax.CallOption) (*netapppb.Replication, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetReplication[0:len((*c.CallOptions).GetReplication):len((*c.CallOptions).GetReplication)], opts...)
	var resp *netapppb.Replication
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetReplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateReplication(ctx context.Context, req *netapppb.CreateReplicationRequest, opts ...gax.CallOption) (*CreateReplicationOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateReplication[0:len((*c.CallOptions).CreateReplication):len((*c.CallOptions).CreateReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateReplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteReplication(ctx context.Context, req *netapppb.DeleteReplicationRequest, opts ...gax.CallOption) (*DeleteReplicationOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteReplication[0:len((*c.CallOptions).DeleteReplication):len((*c.CallOptions).DeleteReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteReplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateReplication(ctx context.Context, req *netapppb.UpdateReplicationRequest, opts ...gax.CallOption) (*UpdateReplicationOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "replication.name", url.QueryEscape(req.GetReplication().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateReplication[0:len((*c.CallOptions).UpdateReplication):len((*c.CallOptions).UpdateReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateReplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) StopReplication(ctx context.Context, req *netapppb.StopReplicationRequest, opts ...gax.CallOption) (*StopReplicationOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).StopReplication[0:len((*c.CallOptions).StopReplication):len((*c.CallOptions).StopReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.StopReplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ResumeReplication(ctx context.Context, req *netapppb.ResumeReplicationRequest, opts ...gax.CallOption) (*ResumeReplicationOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ResumeReplication[0:len((*c.CallOptions).ResumeReplication):len((*c.CallOptions).ResumeReplication)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ResumeReplication(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResumeReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReverseReplicationDirection(ctx context.Context, req *netapppb.ReverseReplicationDirectionRequest, opts ...gax.CallOption) (*ReverseReplicationDirectionOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ReverseReplicationDirection[0:len((*c.CallOptions).ReverseReplicationDirection):len((*c.CallOptions).ReverseReplicationDirection)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ReverseReplicationDirection(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReverseReplicationDirectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

// ListStoragePools returns descriptions of all storage pools owned by the caller.
func (c *restClient) ListStoragePools(ctx context.Context, req *netapppb.ListStoragePoolsRequest, opts ...gax.CallOption) *StoragePoolIterator {
	it := &StoragePoolIterator{}
	req = proto.Clone(req).(*netapppb.ListStoragePoolsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.StoragePool, string, error) {
		resp := &netapppb.ListStoragePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/storagePools", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetStoragePools(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateStoragePool creates a new storage pool.
func (c *restClient) CreateStoragePool(ctx context.Context, req *netapppb.CreateStoragePoolRequest, opts ...gax.CallOption) (*CreateStoragePoolOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetStoragePool()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/storagePools", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("storagePoolId", fmt.Sprintf("%v", req.GetStoragePoolId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetStoragePool returns the description of the specified storage pool by poolId.
func (c *restClient) GetStoragePool(ctx context.Context, req *netapppb.GetStoragePoolRequest, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetStoragePool[0:len((*c.CallOptions).GetStoragePool):len((*c.CallOptions).GetStoragePool)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.StoragePool{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateStoragePool updates the storage pool properties with the full spec
func (c *restClient) UpdateStoragePool(ctx context.Context, req *netapppb.UpdateStoragePoolRequest, opts ...gax.CallOption) (*UpdateStoragePoolOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetStoragePool()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetStoragePool().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "storage_pool.name", url.QueryEscape(req.GetStoragePool().GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteStoragePool warning! This operation will permanently delete the storage pool.
func (c *restClient) DeleteStoragePool(ctx context.Context, req *netapppb.DeleteStoragePoolRequest, opts ...gax.CallOption) (*DeleteStoragePoolOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListVolumes lists Volumes in a given project.
func (c *restClient) ListVolumes(ctx context.Context, req *netapppb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	it := &VolumeIterator{}
	req = proto.Clone(req).(*netapppb.ListVolumesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Volume, string, error) {
		resp := &netapppb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/volumes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetVolume gets details of a single Volume.
func (c *restClient) GetVolume(ctx context.Context, req *netapppb.GetVolumeRequest, opts ...gax.CallOption) (*netapppb.Volume, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Volume{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateVolume creates a new Volume in a given project and location.
func (c *restClient) CreateVolume(ctx context.Context, req *netapppb.CreateVolumeRequest, opts ...gax.CallOption) (*CreateVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetVolume()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/volumes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("volumeId", fmt.Sprintf("%v", req.GetVolumeId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateVolume updates the parameters of a single Volume.
func (c *restClient) UpdateVolume(ctx context.Context, req *netapppb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetVolume()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetVolume().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteVolume deletes a single Volume.
func (c *restClient) DeleteVolume(ctx context.Context, req *netapppb.DeleteVolumeRequest, opts ...gax.CallOption) (*DeleteVolumeOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RevertVolume revert an existing volume to a specified snapshot.
// Warning! This operation will permanently revert all changes made after the
// snapshot was created.
func (c *restClient) RevertVolume(ctx context.Context, req *netapppb.RevertVolumeRequest, opts ...gax.CallOption) (*RevertVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:revert", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RevertVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListSnapshots returns descriptions of all snapshots for a volume.
func (c *restClient) ListSnapshots(ctx context.Context, req *netapppb.ListSnapshotsRequest, opts ...gax.CallOption) *SnapshotIterator {
	it := &SnapshotIterator{}
	req = proto.Clone(req).(*netapppb.ListSnapshotsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Snapshot, string, error) {
		resp := &netapppb.ListSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/snapshots", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSnapshots(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSnapshot describe a snapshot for a volume.
func (c *restClient) GetSnapshot(ctx context.Context, req *netapppb.GetSnapshotRequest, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetSnapshot[0:len((*c.CallOptions).GetSnapshot):len((*c.CallOptions).GetSnapshot)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Snapshot{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateSnapshot create a new snapshot for a volume.
func (c *restClient) CreateSnapshot(ctx context.Context, req *netapppb.CreateSnapshotRequest, opts ...gax.CallOption) (*CreateSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSnapshot()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/snapshots", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("snapshotId", fmt.Sprintf("%v", req.GetSnapshotId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteSnapshot deletes a snapshot.
func (c *restClient) DeleteSnapshot(ctx context.Context, req *netapppb.DeleteSnapshotRequest, opts ...gax.CallOption) (*DeleteSnapshotOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateSnapshot updates the settings of a specific snapshot.
func (c *restClient) UpdateSnapshot(ctx context.Context, req *netapppb.UpdateSnapshotRequest, opts ...gax.CallOption) (*UpdateSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSnapshot()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSnapshot().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "snapshot.name", url.QueryEscape(req.GetSnapshot().GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListActiveDirectories lists active directories.
func (c *restClient) ListActiveDirectories(ctx context.Context, req *netapppb.ListActiveDirectoriesRequest, opts ...gax.CallOption) *ActiveDirectoryIterator {
	it := &ActiveDirectoryIterator{}
	req = proto.Clone(req).(*netapppb.ListActiveDirectoriesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.ActiveDirectory, string, error) {
		resp := &netapppb.ListActiveDirectoriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/activeDirectories", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetActiveDirectories(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetActiveDirectory describes a specified active directory.
func (c *restClient) GetActiveDirectory(ctx context.Context, req *netapppb.GetActiveDirectoryRequest, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetActiveDirectory[0:len((*c.CallOptions).GetActiveDirectory):len((*c.CallOptions).GetActiveDirectory)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.ActiveDirectory{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateActiveDirectory createActiveDirectory
// Creates the active directory specified in the request.
func (c *restClient) CreateActiveDirectory(ctx context.Context, req *netapppb.CreateActiveDirectoryRequest, opts ...gax.CallOption) (*CreateActiveDirectoryOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetActiveDirectory()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/activeDirectories", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("activeDirectoryId", fmt.Sprintf("%v", req.GetActiveDirectoryId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateActiveDirectory update the parameters of an active directories.
func (c *restClient) UpdateActiveDirectory(ctx context.Context, req *netapppb.UpdateActiveDirectoryRequest, opts ...gax.CallOption) (*UpdateActiveDirectoryOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetActiveDirectory()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetActiveDirectory().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "active_directory.name", url.QueryEscape(req.GetActiveDirectory().GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteActiveDirectory delete the active directory specified in the request.
func (c *restClient) DeleteActiveDirectory(ctx context.Context, req *netapppb.DeleteActiveDirectoryRequest, opts ...gax.CallOption) (*DeleteActiveDirectoryOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListKmsConfigs returns descriptions of all KMS configs owned by the caller.
func (c *restClient) ListKmsConfigs(ctx context.Context, req *netapppb.ListKmsConfigsRequest, opts ...gax.CallOption) *KmsConfigIterator {
	it := &KmsConfigIterator{}
	req = proto.Clone(req).(*netapppb.ListKmsConfigsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.KmsConfig, string, error) {
		resp := &netapppb.ListKmsConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/kmsConfigs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetKmsConfigs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateKmsConfig creates a new KMS config.
func (c *restClient) CreateKmsConfig(ctx context.Context, req *netapppb.CreateKmsConfigRequest, opts ...gax.CallOption) (*CreateKmsConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetKmsConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/kmsConfigs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("kmsConfigId", fmt.Sprintf("%v", req.GetKmsConfigId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetKmsConfig returns the description of the specified KMS config by kms_config_id.
func (c *restClient) GetKmsConfig(ctx context.Context, req *netapppb.GetKmsConfigRequest, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetKmsConfig[0:len((*c.CallOptions).GetKmsConfig):len((*c.CallOptions).GetKmsConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.KmsConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateKmsConfig updates the Kms config properties with the full spec
func (c *restClient) UpdateKmsConfig(ctx context.Context, req *netapppb.UpdateKmsConfigRequest, opts ...gax.CallOption) (*UpdateKmsConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetKmsConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetKmsConfig().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "kms_config.name", url.QueryEscape(req.GetKmsConfig().GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// EncryptVolumes encrypt the existing volumes without CMEK encryption with the desired the
// KMS config for the whole region.
func (c *restClient) EncryptVolumes(ctx context.Context, req *netapppb.EncryptVolumesRequest, opts ...gax.CallOption) (*EncryptVolumesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:encrypt", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &EncryptVolumesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// VerifyKmsConfig verifies KMS config reachability.
func (c *restClient) VerifyKmsConfig(ctx context.Context, req *netapppb.VerifyKmsConfigRequest, opts ...gax.CallOption) (*netapppb.VerifyKmsConfigResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:verify", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).VerifyKmsConfig[0:len((*c.CallOptions).VerifyKmsConfig):len((*c.CallOptions).VerifyKmsConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.VerifyKmsConfigResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteKmsConfig warning! This operation will permanently delete the Kms config.
func (c *restClient) DeleteKmsConfig(ctx context.Context, req *netapppb.DeleteKmsConfigRequest, opts ...gax.CallOption) (*DeleteKmsConfigOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListReplications returns descriptions of all replications for a volume.
func (c *restClient) ListReplications(ctx context.Context, req *netapppb.ListReplicationsRequest, opts ...gax.CallOption) *ReplicationIterator {
	it := &ReplicationIterator{}
	req = proto.Clone(req).(*netapppb.ListReplicationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*netapppb.Replication, string, error) {
		resp := &netapppb.ListReplicationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/replications", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		headers := buildHeaders(ctx, c.xGoogMetadata, metadata.Pairs("Content-Type", "application/json"))
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetReplications(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetReplication describe a replication for a volume.
func (c *restClient) GetReplication(ctx context.Context, req *netapppb.GetReplicationRequest, opts ...gax.CallOption) (*netapppb.Replication, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetReplication[0:len((*c.CallOptions).GetReplication):len((*c.CallOptions).GetReplication)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &netapppb.Replication{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateReplication create a new replication for a volume.
func (c *restClient) CreateReplication(ctx context.Context, req *netapppb.CreateReplicationRequest, opts ...gax.CallOption) (*CreateReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReplication()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/replications", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("replicationId", fmt.Sprintf("%v", req.GetReplicationId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteReplication deletes a replication.
func (c *restClient) DeleteReplication(ctx context.Context, req *netapppb.DeleteReplicationRequest, opts ...gax.CallOption) (*DeleteReplicationOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateReplication updates the settings of a specific replication.
func (c *restClient) UpdateReplication(ctx context.Context, req *netapppb.UpdateReplicationRequest, opts ...gax.CallOption) (*UpdateReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReplication()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetReplication().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "replication.name", url.QueryEscape(req.GetReplication().GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StopReplication stop Cross Region Replication.
func (c *restClient) StopReplication(ctx context.Context, req *netapppb.StopReplicationRequest, opts ...gax.CallOption) (*StopReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:stop", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &StopReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ResumeReplication resume Cross Region Replication.
func (c *restClient) ResumeReplication(ctx context.Context, req *netapppb.ResumeReplicationRequest, opts ...gax.CallOption) (*ResumeReplicationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:resume", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ResumeReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ReverseReplicationDirection reverses direction of replication. Source becomes destination and
// destination becomes source.
func (c *restClient) ReverseReplicationDirection(ctx context.Context, req *netapppb.ReverseReplicationDirectionRequest, opts ...gax.CallOption) (*ReverseReplicationDirectionOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:reverseDirection", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ReverseReplicationDirectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateActiveDirectoryOperation manages a long-running operation from CreateActiveDirectory.
type CreateActiveDirectoryOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateActiveDirectoryOperation returns a new CreateActiveDirectoryOperation from a given name.
// The name must be that of a previously created CreateActiveDirectoryOperation, possibly from a different process.
func (c *gRPCClient) CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation {
	return &CreateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateActiveDirectoryOperation returns a new CreateActiveDirectoryOperation from a given name.
// The name must be that of a previously created CreateActiveDirectoryOperation, possibly from a different process.
func (c *restClient) CreateActiveDirectoryOperation(name string) *CreateActiveDirectoryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateActiveDirectoryOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.ActiveDirectory
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateActiveDirectoryOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.ActiveDirectory
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateActiveDirectoryOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateActiveDirectoryOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateActiveDirectoryOperation) Name() string {
	return op.lro.Name()
}

// CreateKmsConfigOperation manages a long-running operation from CreateKmsConfig.
type CreateKmsConfigOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateKmsConfigOperation returns a new CreateKmsConfigOperation from a given name.
// The name must be that of a previously created CreateKmsConfigOperation, possibly from a different process.
func (c *gRPCClient) CreateKmsConfigOperation(name string) *CreateKmsConfigOperation {
	return &CreateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateKmsConfigOperation returns a new CreateKmsConfigOperation from a given name.
// The name must be that of a previously created CreateKmsConfigOperation, possibly from a different process.
func (c *restClient) CreateKmsConfigOperation(name string) *CreateKmsConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateKmsConfigOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.KmsConfig
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateKmsConfigOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.KmsConfig
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateKmsConfigOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateKmsConfigOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateKmsConfigOperation) Name() string {
	return op.lro.Name()
}

// CreateReplicationOperation manages a long-running operation from CreateReplication.
type CreateReplicationOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateReplicationOperation returns a new CreateReplicationOperation from a given name.
// The name must be that of a previously created CreateReplicationOperation, possibly from a different process.
func (c *gRPCClient) CreateReplicationOperation(name string) *CreateReplicationOperation {
	return &CreateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateReplicationOperation returns a new CreateReplicationOperation from a given name.
// The name must be that of a previously created CreateReplicationOperation, possibly from a different process.
func (c *restClient) CreateReplicationOperation(name string) *CreateReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateReplicationOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateReplicationOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateReplicationOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateReplicationOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateReplicationOperation) Name() string {
	return op.lro.Name()
}

// CreateSnapshotOperation manages a long-running operation from CreateSnapshot.
type CreateSnapshotOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateSnapshotOperation returns a new CreateSnapshotOperation from a given name.
// The name must be that of a previously created CreateSnapshotOperation, possibly from a different process.
func (c *gRPCClient) CreateSnapshotOperation(name string) *CreateSnapshotOperation {
	return &CreateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateSnapshotOperation returns a new CreateSnapshotOperation from a given name.
// The name must be that of a previously created CreateSnapshotOperation, possibly from a different process.
func (c *restClient) CreateSnapshotOperation(name string) *CreateSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateSnapshotOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Snapshot
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateSnapshotOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Snapshot
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateSnapshotOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateSnapshotOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateSnapshotOperation) Name() string {
	return op.lro.Name()
}

// CreateStoragePoolOperation manages a long-running operation from CreateStoragePool.
type CreateStoragePoolOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateStoragePoolOperation returns a new CreateStoragePoolOperation from a given name.
// The name must be that of a previously created CreateStoragePoolOperation, possibly from a different process.
func (c *gRPCClient) CreateStoragePoolOperation(name string) *CreateStoragePoolOperation {
	return &CreateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateStoragePoolOperation returns a new CreateStoragePoolOperation from a given name.
// The name must be that of a previously created CreateStoragePoolOperation, possibly from a different process.
func (c *restClient) CreateStoragePoolOperation(name string) *CreateStoragePoolOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateStoragePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.StoragePool
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateStoragePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.StoragePool
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateStoragePoolOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateStoragePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateStoragePoolOperation) Name() string {
	return op.lro.Name()
}

// CreateVolumeOperation manages a long-running operation from CreateVolume.
type CreateVolumeOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateVolumeOperation returns a new CreateVolumeOperation from a given name.
// The name must be that of a previously created CreateVolumeOperation, possibly from a different process.
func (c *gRPCClient) CreateVolumeOperation(name string) *CreateVolumeOperation {
	return &CreateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateVolumeOperation returns a new CreateVolumeOperation from a given name.
// The name must be that of a previously created CreateVolumeOperation, possibly from a different process.
func (c *restClient) CreateVolumeOperation(name string) *CreateVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateVolumeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Volume, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Volume
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateVolumeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Volume, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Volume
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateVolumeOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateVolumeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateVolumeOperation) Name() string {
	return op.lro.Name()
}

// DeleteActiveDirectoryOperation manages a long-running operation from DeleteActiveDirectory.
type DeleteActiveDirectoryOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// DeleteActiveDirectoryOperation returns a new DeleteActiveDirectoryOperation from a given name.
// The name must be that of a previously created DeleteActiveDirectoryOperation, possibly from a different process.
func (c *gRPCClient) DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation {
	return &DeleteActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteActiveDirectoryOperation returns a new DeleteActiveDirectoryOperation from a given name.
// The name must be that of a previously created DeleteActiveDirectoryOperation, possibly from a different process.
func (c *restClient) DeleteActiveDirectoryOperation(name string) *DeleteActiveDirectoryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteActiveDirectoryOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteActiveDirectoryOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteActiveDirectoryOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteActiveDirectoryOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteActiveDirectoryOperation) Name() string {
	return op.lro.Name()
}

// DeleteKmsConfigOperation manages a long-running operation from DeleteKmsConfig.
type DeleteKmsConfigOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// DeleteKmsConfigOperation returns a new DeleteKmsConfigOperation from a given name.
// The name must be that of a previously created DeleteKmsConfigOperation, possibly from a different process.
func (c *gRPCClient) DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation {
	return &DeleteKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteKmsConfigOperation returns a new DeleteKmsConfigOperation from a given name.
// The name must be that of a previously created DeleteKmsConfigOperation, possibly from a different process.
func (c *restClient) DeleteKmsConfigOperation(name string) *DeleteKmsConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteKmsConfigOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteKmsConfigOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteKmsConfigOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteKmsConfigOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteKmsConfigOperation) Name() string {
	return op.lro.Name()
}

// DeleteReplicationOperation manages a long-running operation from DeleteReplication.
type DeleteReplicationOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// DeleteReplicationOperation returns a new DeleteReplicationOperation from a given name.
// The name must be that of a previously created DeleteReplicationOperation, possibly from a different process.
func (c *gRPCClient) DeleteReplicationOperation(name string) *DeleteReplicationOperation {
	return &DeleteReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteReplicationOperation returns a new DeleteReplicationOperation from a given name.
// The name must be that of a previously created DeleteReplicationOperation, possibly from a different process.
func (c *restClient) DeleteReplicationOperation(name string) *DeleteReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteReplicationOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteReplicationOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteReplicationOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteReplicationOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteReplicationOperation) Name() string {
	return op.lro.Name()
}

// DeleteSnapshotOperation manages a long-running operation from DeleteSnapshot.
type DeleteSnapshotOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// DeleteSnapshotOperation returns a new DeleteSnapshotOperation from a given name.
// The name must be that of a previously created DeleteSnapshotOperation, possibly from a different process.
func (c *gRPCClient) DeleteSnapshotOperation(name string) *DeleteSnapshotOperation {
	return &DeleteSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteSnapshotOperation returns a new DeleteSnapshotOperation from a given name.
// The name must be that of a previously created DeleteSnapshotOperation, possibly from a different process.
func (c *restClient) DeleteSnapshotOperation(name string) *DeleteSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteSnapshotOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteSnapshotOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteSnapshotOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteSnapshotOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteSnapshotOperation) Name() string {
	return op.lro.Name()
}

// DeleteStoragePoolOperation manages a long-running operation from DeleteStoragePool.
type DeleteStoragePoolOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// DeleteStoragePoolOperation returns a new DeleteStoragePoolOperation from a given name.
// The name must be that of a previously created DeleteStoragePoolOperation, possibly from a different process.
func (c *gRPCClient) DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation {
	return &DeleteStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteStoragePoolOperation returns a new DeleteStoragePoolOperation from a given name.
// The name must be that of a previously created DeleteStoragePoolOperation, possibly from a different process.
func (c *restClient) DeleteStoragePoolOperation(name string) *DeleteStoragePoolOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteStoragePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteStoragePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteStoragePoolOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteStoragePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteStoragePoolOperation) Name() string {
	return op.lro.Name()
}

// DeleteVolumeOperation manages a long-running operation from DeleteVolume.
type DeleteVolumeOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// DeleteVolumeOperation returns a new DeleteVolumeOperation from a given name.
// The name must be that of a previously created DeleteVolumeOperation, possibly from a different process.
func (c *gRPCClient) DeleteVolumeOperation(name string) *DeleteVolumeOperation {
	return &DeleteVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteVolumeOperation returns a new DeleteVolumeOperation from a given name.
// The name must be that of a previously created DeleteVolumeOperation, possibly from a different process.
func (c *restClient) DeleteVolumeOperation(name string) *DeleteVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteVolumeOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteVolumeOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteVolumeOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteVolumeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteVolumeOperation) Name() string {
	return op.lro.Name()
}

// EncryptVolumesOperation manages a long-running operation from EncryptVolumes.
type EncryptVolumesOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// EncryptVolumesOperation returns a new EncryptVolumesOperation from a given name.
// The name must be that of a previously created EncryptVolumesOperation, possibly from a different process.
func (c *gRPCClient) EncryptVolumesOperation(name string) *EncryptVolumesOperation {
	return &EncryptVolumesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EncryptVolumesOperation returns a new EncryptVolumesOperation from a given name.
// The name must be that of a previously created EncryptVolumesOperation, possibly from a different process.
func (c *restClient) EncryptVolumesOperation(name string) *EncryptVolumesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &EncryptVolumesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *EncryptVolumesOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.KmsConfig
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *EncryptVolumesOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.KmsConfig
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *EncryptVolumesOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *EncryptVolumesOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *EncryptVolumesOperation) Name() string {
	return op.lro.Name()
}

// ResumeReplicationOperation manages a long-running operation from ResumeReplication.
type ResumeReplicationOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// ResumeReplicationOperation returns a new ResumeReplicationOperation from a given name.
// The name must be that of a previously created ResumeReplicationOperation, possibly from a different process.
func (c *gRPCClient) ResumeReplicationOperation(name string) *ResumeReplicationOperation {
	return &ResumeReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResumeReplicationOperation returns a new ResumeReplicationOperation from a given name.
// The name must be that of a previously created ResumeReplicationOperation, possibly from a different process.
func (c *restClient) ResumeReplicationOperation(name string) *ResumeReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ResumeReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ResumeReplicationOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ResumeReplicationOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ResumeReplicationOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ResumeReplicationOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ResumeReplicationOperation) Name() string {
	return op.lro.Name()
}

// ReverseReplicationDirectionOperation manages a long-running operation from ReverseReplicationDirection.
type ReverseReplicationDirectionOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// ReverseReplicationDirectionOperation returns a new ReverseReplicationDirectionOperation from a given name.
// The name must be that of a previously created ReverseReplicationDirectionOperation, possibly from a different process.
func (c *gRPCClient) ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation {
	return &ReverseReplicationDirectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReverseReplicationDirectionOperation returns a new ReverseReplicationDirectionOperation from a given name.
// The name must be that of a previously created ReverseReplicationDirectionOperation, possibly from a different process.
func (c *restClient) ReverseReplicationDirectionOperation(name string) *ReverseReplicationDirectionOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ReverseReplicationDirectionOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ReverseReplicationDirectionOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ReverseReplicationDirectionOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ReverseReplicationDirectionOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ReverseReplicationDirectionOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ReverseReplicationDirectionOperation) Name() string {
	return op.lro.Name()
}

// RevertVolumeOperation manages a long-running operation from RevertVolume.
type RevertVolumeOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// RevertVolumeOperation returns a new RevertVolumeOperation from a given name.
// The name must be that of a previously created RevertVolumeOperation, possibly from a different process.
func (c *gRPCClient) RevertVolumeOperation(name string) *RevertVolumeOperation {
	return &RevertVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RevertVolumeOperation returns a new RevertVolumeOperation from a given name.
// The name must be that of a previously created RevertVolumeOperation, possibly from a different process.
func (c *restClient) RevertVolumeOperation(name string) *RevertVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RevertVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *RevertVolumeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Volume, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Volume
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *RevertVolumeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Volume, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Volume
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *RevertVolumeOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *RevertVolumeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *RevertVolumeOperation) Name() string {
	return op.lro.Name()
}

// StopReplicationOperation manages a long-running operation from StopReplication.
type StopReplicationOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// StopReplicationOperation returns a new StopReplicationOperation from a given name.
// The name must be that of a previously created StopReplicationOperation, possibly from a different process.
func (c *gRPCClient) StopReplicationOperation(name string) *StopReplicationOperation {
	return &StopReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopReplicationOperation returns a new StopReplicationOperation from a given name.
// The name must be that of a previously created StopReplicationOperation, possibly from a different process.
func (c *restClient) StopReplicationOperation(name string) *StopReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &StopReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *StopReplicationOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *StopReplicationOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *StopReplicationOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *StopReplicationOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *StopReplicationOperation) Name() string {
	return op.lro.Name()
}

// UpdateActiveDirectoryOperation manages a long-running operation from UpdateActiveDirectory.
type UpdateActiveDirectoryOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// UpdateActiveDirectoryOperation returns a new UpdateActiveDirectoryOperation from a given name.
// The name must be that of a previously created UpdateActiveDirectoryOperation, possibly from a different process.
func (c *gRPCClient) UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation {
	return &UpdateActiveDirectoryOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateActiveDirectoryOperation returns a new UpdateActiveDirectoryOperation from a given name.
// The name must be that of a previously created UpdateActiveDirectoryOperation, possibly from a different process.
func (c *restClient) UpdateActiveDirectoryOperation(name string) *UpdateActiveDirectoryOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateActiveDirectoryOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateActiveDirectoryOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.ActiveDirectory
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateActiveDirectoryOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.ActiveDirectory, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.ActiveDirectory
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateActiveDirectoryOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateActiveDirectoryOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateActiveDirectoryOperation) Name() string {
	return op.lro.Name()
}

// UpdateKmsConfigOperation manages a long-running operation from UpdateKmsConfig.
type UpdateKmsConfigOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// UpdateKmsConfigOperation returns a new UpdateKmsConfigOperation from a given name.
// The name must be that of a previously created UpdateKmsConfigOperation, possibly from a different process.
func (c *gRPCClient) UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation {
	return &UpdateKmsConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateKmsConfigOperation returns a new UpdateKmsConfigOperation from a given name.
// The name must be that of a previously created UpdateKmsConfigOperation, possibly from a different process.
func (c *restClient) UpdateKmsConfigOperation(name string) *UpdateKmsConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateKmsConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateKmsConfigOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.KmsConfig
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateKmsConfigOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.KmsConfig, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.KmsConfig
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateKmsConfigOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateKmsConfigOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateKmsConfigOperation) Name() string {
	return op.lro.Name()
}

// UpdateReplicationOperation manages a long-running operation from UpdateReplication.
type UpdateReplicationOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// UpdateReplicationOperation returns a new UpdateReplicationOperation from a given name.
// The name must be that of a previously created UpdateReplicationOperation, possibly from a different process.
func (c *gRPCClient) UpdateReplicationOperation(name string) *UpdateReplicationOperation {
	return &UpdateReplicationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateReplicationOperation returns a new UpdateReplicationOperation from a given name.
// The name must be that of a previously created UpdateReplicationOperation, possibly from a different process.
func (c *restClient) UpdateReplicationOperation(name string) *UpdateReplicationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateReplicationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateReplicationOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateReplicationOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Replication, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Replication
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateReplicationOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateReplicationOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateReplicationOperation) Name() string {
	return op.lro.Name()
}

// UpdateSnapshotOperation manages a long-running operation from UpdateSnapshot.
type UpdateSnapshotOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// UpdateSnapshotOperation returns a new UpdateSnapshotOperation from a given name.
// The name must be that of a previously created UpdateSnapshotOperation, possibly from a different process.
func (c *gRPCClient) UpdateSnapshotOperation(name string) *UpdateSnapshotOperation {
	return &UpdateSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateSnapshotOperation returns a new UpdateSnapshotOperation from a given name.
// The name must be that of a previously created UpdateSnapshotOperation, possibly from a different process.
func (c *restClient) UpdateSnapshotOperation(name string) *UpdateSnapshotOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateSnapshotOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Snapshot
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateSnapshotOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Snapshot, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Snapshot
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateSnapshotOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateSnapshotOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateSnapshotOperation) Name() string {
	return op.lro.Name()
}

// UpdateStoragePoolOperation manages a long-running operation from UpdateStoragePool.
type UpdateStoragePoolOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// UpdateStoragePoolOperation returns a new UpdateStoragePoolOperation from a given name.
// The name must be that of a previously created UpdateStoragePoolOperation, possibly from a different process.
func (c *gRPCClient) UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation {
	return &UpdateStoragePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateStoragePoolOperation returns a new UpdateStoragePoolOperation from a given name.
// The name must be that of a previously created UpdateStoragePoolOperation, possibly from a different process.
func (c *restClient) UpdateStoragePoolOperation(name string) *UpdateStoragePoolOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateStoragePoolOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateStoragePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.StoragePool
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateStoragePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.StoragePool, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.StoragePool
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateStoragePoolOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateStoragePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateStoragePoolOperation) Name() string {
	return op.lro.Name()
}

// UpdateVolumeOperation manages a long-running operation from UpdateVolume.
type UpdateVolumeOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *gRPCClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *restClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateVolumeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*netapppb.Volume, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Volume
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateVolumeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*netapppb.Volume, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp netapppb.Volume
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateVolumeOperation) Metadata() (*netapppb.OperationMetadata, error) {
	var meta netapppb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateVolumeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateVolumeOperation) Name() string {
	return op.lro.Name()
}

// ActiveDirectoryIterator manages a stream of *netapppb.ActiveDirectory.
type ActiveDirectoryIterator struct {
	items    []*netapppb.ActiveDirectory
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*netapppb.ActiveDirectory, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ActiveDirectoryIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ActiveDirectoryIterator) Next() (*netapppb.ActiveDirectory, error) {
	var item *netapppb.ActiveDirectory
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ActiveDirectoryIterator) bufLen() int {
	return len(it.items)
}

func (it *ActiveDirectoryIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// KmsConfigIterator manages a stream of *netapppb.KmsConfig.
type KmsConfigIterator struct {
	items    []*netapppb.KmsConfig
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*netapppb.KmsConfig, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *KmsConfigIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *KmsConfigIterator) Next() (*netapppb.KmsConfig, error) {
	var item *netapppb.KmsConfig
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *KmsConfigIterator) bufLen() int {
	return len(it.items)
}

func (it *KmsConfigIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ReplicationIterator manages a stream of *netapppb.Replication.
type ReplicationIterator struct {
	items    []*netapppb.Replication
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*netapppb.Replication, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ReplicationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ReplicationIterator) Next() (*netapppb.Replication, error) {
	var item *netapppb.Replication
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ReplicationIterator) bufLen() int {
	return len(it.items)
}

func (it *ReplicationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SnapshotIterator manages a stream of *netapppb.Snapshot.
type SnapshotIterator struct {
	items    []*netapppb.Snapshot
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*netapppb.Snapshot, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SnapshotIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SnapshotIterator) Next() (*netapppb.Snapshot, error) {
	var item *netapppb.Snapshot
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SnapshotIterator) bufLen() int {
	return len(it.items)
}

func (it *SnapshotIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StoragePoolIterator manages a stream of *netapppb.StoragePool.
type StoragePoolIterator struct {
	items    []*netapppb.StoragePool
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*netapppb.StoragePool, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *StoragePoolIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StoragePoolIterator) Next() (*netapppb.StoragePool, error) {
	var item *netapppb.StoragePool
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StoragePoolIterator) bufLen() int {
	return len(it.items)
}

func (it *StoragePoolIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VolumeIterator manages a stream of *netapppb.Volume.
type VolumeIterator struct {
	items    []*netapppb.Volume
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*netapppb.Volume, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *VolumeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VolumeIterator) Next() (*netapppb.Volume, error) {
	var item *netapppb.Volume
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VolumeIterator) bufLen() int {
	return len(it.items)
}

func (it *VolumeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
