// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package gkemulticloud

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	gkemulticloudpb "cloud.google.com/go/gkemulticloud/apiv1/gkemulticloudpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newAwsClustersClientHook clientHook

// AwsClustersCallOptions contains the retry settings for each method of AwsClustersClient.
type AwsClustersCallOptions struct {
	CreateAwsCluster       []gax.CallOption
	UpdateAwsCluster       []gax.CallOption
	GetAwsCluster          []gax.CallOption
	ListAwsClusters        []gax.CallOption
	DeleteAwsCluster       []gax.CallOption
	GenerateAwsAccessToken []gax.CallOption
	CreateAwsNodePool      []gax.CallOption
	UpdateAwsNodePool      []gax.CallOption
	GetAwsNodePool         []gax.CallOption
	ListAwsNodePools       []gax.CallOption
	DeleteAwsNodePool      []gax.CallOption
	GetAwsServerConfig     []gax.CallOption
	CancelOperation        []gax.CallOption
	DeleteOperation        []gax.CallOption
	GetOperation           []gax.CallOption
	ListOperations         []gax.CallOption
}

func defaultAwsClustersGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("gkemulticloud.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("gkemulticloud.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://gkemulticloud.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAwsClustersCallOptions() *AwsClustersCallOptions {
	return &AwsClustersCallOptions{
		CreateAwsCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAwsCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAwsCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAwsClusters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAwsCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GenerateAwsAccessToken: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateAwsNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAwsNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAwsNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAwsNodePools: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAwsNodePool: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAwsServerConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalAwsClustersClient is an interface that defines the methods available from Anthos Multi-Cloud API.
type internalAwsClustersClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateAwsCluster(context.Context, *gkemulticloudpb.CreateAwsClusterRequest, ...gax.CallOption) (*CreateAwsClusterOperation, error)
	CreateAwsClusterOperation(name string) *CreateAwsClusterOperation
	UpdateAwsCluster(context.Context, *gkemulticloudpb.UpdateAwsClusterRequest, ...gax.CallOption) (*UpdateAwsClusterOperation, error)
	UpdateAwsClusterOperation(name string) *UpdateAwsClusterOperation
	GetAwsCluster(context.Context, *gkemulticloudpb.GetAwsClusterRequest, ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error)
	ListAwsClusters(context.Context, *gkemulticloudpb.ListAwsClustersRequest, ...gax.CallOption) *AwsClusterIterator
	DeleteAwsCluster(context.Context, *gkemulticloudpb.DeleteAwsClusterRequest, ...gax.CallOption) (*DeleteAwsClusterOperation, error)
	DeleteAwsClusterOperation(name string) *DeleteAwsClusterOperation
	GenerateAwsAccessToken(context.Context, *gkemulticloudpb.GenerateAwsAccessTokenRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAwsAccessTokenResponse, error)
	CreateAwsNodePool(context.Context, *gkemulticloudpb.CreateAwsNodePoolRequest, ...gax.CallOption) (*CreateAwsNodePoolOperation, error)
	CreateAwsNodePoolOperation(name string) *CreateAwsNodePoolOperation
	UpdateAwsNodePool(context.Context, *gkemulticloudpb.UpdateAwsNodePoolRequest, ...gax.CallOption) (*UpdateAwsNodePoolOperation, error)
	UpdateAwsNodePoolOperation(name string) *UpdateAwsNodePoolOperation
	GetAwsNodePool(context.Context, *gkemulticloudpb.GetAwsNodePoolRequest, ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error)
	ListAwsNodePools(context.Context, *gkemulticloudpb.ListAwsNodePoolsRequest, ...gax.CallOption) *AwsNodePoolIterator
	DeleteAwsNodePool(context.Context, *gkemulticloudpb.DeleteAwsNodePoolRequest, ...gax.CallOption) (*DeleteAwsNodePoolOperation, error)
	DeleteAwsNodePoolOperation(name string) *DeleteAwsNodePoolOperation
	GetAwsServerConfig(context.Context, *gkemulticloudpb.GetAwsServerConfigRequest, ...gax.CallOption) (*gkemulticloudpb.AwsServerConfig, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// AwsClustersClient is a client for interacting with Anthos Multi-Cloud API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The AwsClusters API provides a single centrally managed service
// to create and manage Anthos clusters that run on AWS infrastructure.
type AwsClustersClient struct {
	// The internal transport-dependent client.
	internalClient internalAwsClustersClient

	// The call options for this service.
	CallOptions *AwsClustersCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AwsClustersClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AwsClustersClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AwsClustersClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateAwsCluster creates a new AwsCluster
// resource on a given Google Cloud Platform project and region.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AwsClustersClient) CreateAwsCluster(ctx context.Context, req *gkemulticloudpb.CreateAwsClusterRequest, opts ...gax.CallOption) (*CreateAwsClusterOperation, error) {
	return c.internalClient.CreateAwsCluster(ctx, req, opts...)
}

// CreateAwsClusterOperation returns a new CreateAwsClusterOperation from a given name.
// The name must be that of a previously created CreateAwsClusterOperation, possibly from a different process.
func (c *AwsClustersClient) CreateAwsClusterOperation(name string) *CreateAwsClusterOperation {
	return c.internalClient.CreateAwsClusterOperation(name)
}

// UpdateAwsCluster updates an AwsCluster.
func (c *AwsClustersClient) UpdateAwsCluster(ctx context.Context, req *gkemulticloudpb.UpdateAwsClusterRequest, opts ...gax.CallOption) (*UpdateAwsClusterOperation, error) {
	return c.internalClient.UpdateAwsCluster(ctx, req, opts...)
}

// UpdateAwsClusterOperation returns a new UpdateAwsClusterOperation from a given name.
// The name must be that of a previously created UpdateAwsClusterOperation, possibly from a different process.
func (c *AwsClustersClient) UpdateAwsClusterOperation(name string) *UpdateAwsClusterOperation {
	return c.internalClient.UpdateAwsClusterOperation(name)
}

// GetAwsCluster describes a specific AwsCluster
// resource.
func (c *AwsClustersClient) GetAwsCluster(ctx context.Context, req *gkemulticloudpb.GetAwsClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error) {
	return c.internalClient.GetAwsCluster(ctx, req, opts...)
}

// ListAwsClusters lists all AwsCluster resources
// on a given Google Cloud project and region.
func (c *AwsClustersClient) ListAwsClusters(ctx context.Context, req *gkemulticloudpb.ListAwsClustersRequest, opts ...gax.CallOption) *AwsClusterIterator {
	return c.internalClient.ListAwsClusters(ctx, req, opts...)
}

// DeleteAwsCluster deletes a specific AwsCluster
// resource.
//
// Fails if the cluster has one or more associated
// AwsNodePool resources.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AwsClustersClient) DeleteAwsCluster(ctx context.Context, req *gkemulticloudpb.DeleteAwsClusterRequest, opts ...gax.CallOption) (*DeleteAwsClusterOperation, error) {
	return c.internalClient.DeleteAwsCluster(ctx, req, opts...)
}

// DeleteAwsClusterOperation returns a new DeleteAwsClusterOperation from a given name.
// The name must be that of a previously created DeleteAwsClusterOperation, possibly from a different process.
func (c *AwsClustersClient) DeleteAwsClusterOperation(name string) *DeleteAwsClusterOperation {
	return c.internalClient.DeleteAwsClusterOperation(name)
}

// GenerateAwsAccessToken generates a short-lived access token to authenticate to a given
// AwsCluster resource.
func (c *AwsClustersClient) GenerateAwsAccessToken(ctx context.Context, req *gkemulticloudpb.GenerateAwsAccessTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAwsAccessTokenResponse, error) {
	return c.internalClient.GenerateAwsAccessToken(ctx, req, opts...)
}

// CreateAwsNodePool creates a new AwsNodePool,
// attached to a given AwsCluster.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AwsClustersClient) CreateAwsNodePool(ctx context.Context, req *gkemulticloudpb.CreateAwsNodePoolRequest, opts ...gax.CallOption) (*CreateAwsNodePoolOperation, error) {
	return c.internalClient.CreateAwsNodePool(ctx, req, opts...)
}

// CreateAwsNodePoolOperation returns a new CreateAwsNodePoolOperation from a given name.
// The name must be that of a previously created CreateAwsNodePoolOperation, possibly from a different process.
func (c *AwsClustersClient) CreateAwsNodePoolOperation(name string) *CreateAwsNodePoolOperation {
	return c.internalClient.CreateAwsNodePoolOperation(name)
}

// UpdateAwsNodePool updates an AwsNodePool.
func (c *AwsClustersClient) UpdateAwsNodePool(ctx context.Context, req *gkemulticloudpb.UpdateAwsNodePoolRequest, opts ...gax.CallOption) (*UpdateAwsNodePoolOperation, error) {
	return c.internalClient.UpdateAwsNodePool(ctx, req, opts...)
}

// UpdateAwsNodePoolOperation returns a new UpdateAwsNodePoolOperation from a given name.
// The name must be that of a previously created UpdateAwsNodePoolOperation, possibly from a different process.
func (c *AwsClustersClient) UpdateAwsNodePoolOperation(name string) *UpdateAwsNodePoolOperation {
	return c.internalClient.UpdateAwsNodePoolOperation(name)
}

// GetAwsNodePool describes a specific
// AwsNodePool resource.
func (c *AwsClustersClient) GetAwsNodePool(ctx context.Context, req *gkemulticloudpb.GetAwsNodePoolRequest, opts ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error) {
	return c.internalClient.GetAwsNodePool(ctx, req, opts...)
}

// ListAwsNodePools lists all AwsNodePool
// resources on a given
// AwsCluster.
func (c *AwsClustersClient) ListAwsNodePools(ctx context.Context, req *gkemulticloudpb.ListAwsNodePoolsRequest, opts ...gax.CallOption) *AwsNodePoolIterator {
	return c.internalClient.ListAwsNodePools(ctx, req, opts...)
}

// DeleteAwsNodePool deletes a specific AwsNodePool
// resource.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AwsClustersClient) DeleteAwsNodePool(ctx context.Context, req *gkemulticloudpb.DeleteAwsNodePoolRequest, opts ...gax.CallOption) (*DeleteAwsNodePoolOperation, error) {
	return c.internalClient.DeleteAwsNodePool(ctx, req, opts...)
}

// DeleteAwsNodePoolOperation returns a new DeleteAwsNodePoolOperation from a given name.
// The name must be that of a previously created DeleteAwsNodePoolOperation, possibly from a different process.
func (c *AwsClustersClient) DeleteAwsNodePoolOperation(name string) *DeleteAwsNodePoolOperation {
	return c.internalClient.DeleteAwsNodePoolOperation(name)
}

// GetAwsServerConfig returns information, such as supported AWS regions and Kubernetes
// versions, on a given Google Cloud location.
func (c *AwsClustersClient) GetAwsServerConfig(ctx context.Context, req *gkemulticloudpb.GetAwsServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AwsServerConfig, error) {
	return c.internalClient.GetAwsServerConfig(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *AwsClustersClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *AwsClustersClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *AwsClustersClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *AwsClustersClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// awsClustersGRPCClient is a client for interacting with Anthos Multi-Cloud API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type awsClustersGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AwsClustersClient
	CallOptions **AwsClustersCallOptions

	// The gRPC API client.
	awsClustersClient gkemulticloudpb.AwsClustersClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewAwsClustersClient creates a new aws clusters client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The AwsClusters API provides a single centrally managed service
// to create and manage Anthos clusters that run on AWS infrastructure.
func NewAwsClustersClient(ctx context.Context, opts ...option.ClientOption) (*AwsClustersClient, error) {
	clientOpts := defaultAwsClustersGRPCClientOptions()
	if newAwsClustersClientHook != nil {
		hookOpts, err := newAwsClustersClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AwsClustersClient{CallOptions: defaultAwsClustersCallOptions()}

	c := &awsClustersGRPCClient{
		connPool:          connPool,
		awsClustersClient: gkemulticloudpb.NewAwsClustersClient(connPool),
		CallOptions:       &client.CallOptions,
		operationsClient:  longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *awsClustersGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *awsClustersGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *awsClustersGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *awsClustersGRPCClient) CreateAwsCluster(ctx context.Context, req *gkemulticloudpb.CreateAwsClusterRequest, opts ...gax.CallOption) (*CreateAwsClusterOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAwsCluster[0:len((*c.CallOptions).CreateAwsCluster):len((*c.CallOptions).CreateAwsCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.CreateAwsCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAwsClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *awsClustersGRPCClient) UpdateAwsCluster(ctx context.Context, req *gkemulticloudpb.UpdateAwsClusterRequest, opts ...gax.CallOption) (*UpdateAwsClusterOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "aws_cluster.name", url.QueryEscape(req.GetAwsCluster().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAwsCluster[0:len((*c.CallOptions).UpdateAwsCluster):len((*c.CallOptions).UpdateAwsCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.UpdateAwsCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAwsClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *awsClustersGRPCClient) GetAwsCluster(ctx context.Context, req *gkemulticloudpb.GetAwsClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAwsCluster[0:len((*c.CallOptions).GetAwsCluster):len((*c.CallOptions).GetAwsCluster)], opts...)
	var resp *gkemulticloudpb.AwsCluster
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.GetAwsCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *awsClustersGRPCClient) ListAwsClusters(ctx context.Context, req *gkemulticloudpb.ListAwsClustersRequest, opts ...gax.CallOption) *AwsClusterIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAwsClusters[0:len((*c.CallOptions).ListAwsClusters):len((*c.CallOptions).ListAwsClusters)], opts...)
	it := &AwsClusterIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAwsClustersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AwsCluster, string, error) {
		resp := &gkemulticloudpb.ListAwsClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.awsClustersClient.ListAwsClusters(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAwsClusters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *awsClustersGRPCClient) DeleteAwsCluster(ctx context.Context, req *gkemulticloudpb.DeleteAwsClusterRequest, opts ...gax.CallOption) (*DeleteAwsClusterOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAwsCluster[0:len((*c.CallOptions).DeleteAwsCluster):len((*c.CallOptions).DeleteAwsCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.DeleteAwsCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAwsClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *awsClustersGRPCClient) GenerateAwsAccessToken(ctx context.Context, req *gkemulticloudpb.GenerateAwsAccessTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAwsAccessTokenResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "aws_cluster", url.QueryEscape(req.GetAwsCluster())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GenerateAwsAccessToken[0:len((*c.CallOptions).GenerateAwsAccessToken):len((*c.CallOptions).GenerateAwsAccessToken)], opts...)
	var resp *gkemulticloudpb.GenerateAwsAccessTokenResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.GenerateAwsAccessToken(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *awsClustersGRPCClient) CreateAwsNodePool(ctx context.Context, req *gkemulticloudpb.CreateAwsNodePoolRequest, opts ...gax.CallOption) (*CreateAwsNodePoolOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAwsNodePool[0:len((*c.CallOptions).CreateAwsNodePool):len((*c.CallOptions).CreateAwsNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.CreateAwsNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAwsNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *awsClustersGRPCClient) UpdateAwsNodePool(ctx context.Context, req *gkemulticloudpb.UpdateAwsNodePoolRequest, opts ...gax.CallOption) (*UpdateAwsNodePoolOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "aws_node_pool.name", url.QueryEscape(req.GetAwsNodePool().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAwsNodePool[0:len((*c.CallOptions).UpdateAwsNodePool):len((*c.CallOptions).UpdateAwsNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.UpdateAwsNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAwsNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *awsClustersGRPCClient) GetAwsNodePool(ctx context.Context, req *gkemulticloudpb.GetAwsNodePoolRequest, opts ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAwsNodePool[0:len((*c.CallOptions).GetAwsNodePool):len((*c.CallOptions).GetAwsNodePool)], opts...)
	var resp *gkemulticloudpb.AwsNodePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.GetAwsNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *awsClustersGRPCClient) ListAwsNodePools(ctx context.Context, req *gkemulticloudpb.ListAwsNodePoolsRequest, opts ...gax.CallOption) *AwsNodePoolIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAwsNodePools[0:len((*c.CallOptions).ListAwsNodePools):len((*c.CallOptions).ListAwsNodePools)], opts...)
	it := &AwsNodePoolIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAwsNodePoolsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AwsNodePool, string, error) {
		resp := &gkemulticloudpb.ListAwsNodePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.awsClustersClient.ListAwsNodePools(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAwsNodePools(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *awsClustersGRPCClient) DeleteAwsNodePool(ctx context.Context, req *gkemulticloudpb.DeleteAwsNodePoolRequest, opts ...gax.CallOption) (*DeleteAwsNodePoolOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAwsNodePool[0:len((*c.CallOptions).DeleteAwsNodePool):len((*c.CallOptions).DeleteAwsNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.DeleteAwsNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAwsNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *awsClustersGRPCClient) GetAwsServerConfig(ctx context.Context, req *gkemulticloudpb.GetAwsServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AwsServerConfig, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAwsServerConfig[0:len((*c.CallOptions).GetAwsServerConfig):len((*c.CallOptions).GetAwsServerConfig)], opts...)
	var resp *gkemulticloudpb.AwsServerConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.awsClustersClient.GetAwsServerConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *awsClustersGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *awsClustersGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *awsClustersGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *awsClustersGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAwsClusterOperation manages a long-running operation from CreateAwsCluster.
type CreateAwsClusterOperation struct {
	lro *longrunning.Operation
}

// CreateAwsClusterOperation returns a new CreateAwsClusterOperation from a given name.
// The name must be that of a previously created CreateAwsClusterOperation, possibly from a different process.
func (c *awsClustersGRPCClient) CreateAwsClusterOperation(name string) *CreateAwsClusterOperation {
	return &CreateAwsClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAwsClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error) {
	var resp gkemulticloudpb.AwsCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAwsClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error) {
	var resp gkemulticloudpb.AwsCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAwsClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAwsClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAwsClusterOperation) Name() string {
	return op.lro.Name()
}

// CreateAwsNodePoolOperation manages a long-running operation from CreateAwsNodePool.
type CreateAwsNodePoolOperation struct {
	lro *longrunning.Operation
}

// CreateAwsNodePoolOperation returns a new CreateAwsNodePoolOperation from a given name.
// The name must be that of a previously created CreateAwsNodePoolOperation, possibly from a different process.
func (c *awsClustersGRPCClient) CreateAwsNodePoolOperation(name string) *CreateAwsNodePoolOperation {
	return &CreateAwsNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAwsNodePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error) {
	var resp gkemulticloudpb.AwsNodePool
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAwsNodePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error) {
	var resp gkemulticloudpb.AwsNodePool
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAwsNodePoolOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAwsNodePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAwsNodePoolOperation) Name() string {
	return op.lro.Name()
}

// DeleteAwsClusterOperation manages a long-running operation from DeleteAwsCluster.
type DeleteAwsClusterOperation struct {
	lro *longrunning.Operation
}

// DeleteAwsClusterOperation returns a new DeleteAwsClusterOperation from a given name.
// The name must be that of a previously created DeleteAwsClusterOperation, possibly from a different process.
func (c *awsClustersGRPCClient) DeleteAwsClusterOperation(name string) *DeleteAwsClusterOperation {
	return &DeleteAwsClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAwsClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAwsClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAwsClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAwsClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAwsClusterOperation) Name() string {
	return op.lro.Name()
}

// DeleteAwsNodePoolOperation manages a long-running operation from DeleteAwsNodePool.
type DeleteAwsNodePoolOperation struct {
	lro *longrunning.Operation
}

// DeleteAwsNodePoolOperation returns a new DeleteAwsNodePoolOperation from a given name.
// The name must be that of a previously created DeleteAwsNodePoolOperation, possibly from a different process.
func (c *awsClustersGRPCClient) DeleteAwsNodePoolOperation(name string) *DeleteAwsNodePoolOperation {
	return &DeleteAwsNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAwsNodePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAwsNodePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAwsNodePoolOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAwsNodePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAwsNodePoolOperation) Name() string {
	return op.lro.Name()
}

// UpdateAwsClusterOperation manages a long-running operation from UpdateAwsCluster.
type UpdateAwsClusterOperation struct {
	lro *longrunning.Operation
}

// UpdateAwsClusterOperation returns a new UpdateAwsClusterOperation from a given name.
// The name must be that of a previously created UpdateAwsClusterOperation, possibly from a different process.
func (c *awsClustersGRPCClient) UpdateAwsClusterOperation(name string) *UpdateAwsClusterOperation {
	return &UpdateAwsClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAwsClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error) {
	var resp gkemulticloudpb.AwsCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAwsClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsCluster, error) {
	var resp gkemulticloudpb.AwsCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAwsClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAwsClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAwsClusterOperation) Name() string {
	return op.lro.Name()
}

// UpdateAwsNodePoolOperation manages a long-running operation from UpdateAwsNodePool.
type UpdateAwsNodePoolOperation struct {
	lro *longrunning.Operation
}

// UpdateAwsNodePoolOperation returns a new UpdateAwsNodePoolOperation from a given name.
// The name must be that of a previously created UpdateAwsNodePoolOperation, possibly from a different process.
func (c *awsClustersGRPCClient) UpdateAwsNodePoolOperation(name string) *UpdateAwsNodePoolOperation {
	return &UpdateAwsNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAwsNodePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error) {
	var resp gkemulticloudpb.AwsNodePool
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAwsNodePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AwsNodePool, error) {
	var resp gkemulticloudpb.AwsNodePool
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAwsNodePoolOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAwsNodePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAwsNodePoolOperation) Name() string {
	return op.lro.Name()
}

// AwsClusterIterator manages a stream of *gkemulticloudpb.AwsCluster.
type AwsClusterIterator struct {
	items    []*gkemulticloudpb.AwsCluster
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*gkemulticloudpb.AwsCluster, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AwsClusterIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AwsClusterIterator) Next() (*gkemulticloudpb.AwsCluster, error) {
	var item *gkemulticloudpb.AwsCluster
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AwsClusterIterator) bufLen() int {
	return len(it.items)
}

func (it *AwsClusterIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AwsNodePoolIterator manages a stream of *gkemulticloudpb.AwsNodePool.
type AwsNodePoolIterator struct {
	items    []*gkemulticloudpb.AwsNodePool
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*gkemulticloudpb.AwsNodePool, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AwsNodePoolIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AwsNodePoolIterator) Next() (*gkemulticloudpb.AwsNodePool, error) {
	var item *gkemulticloudpb.AwsNodePool
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AwsNodePoolIterator) bufLen() int {
	return len(it.items)
}

func (it *AwsNodePoolIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
