// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/discoveryengine/v1/search_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum describing under which condition query expansion should occur.
type SearchRequest_QueryExpansionSpec_Condition int32

const (
	// Unspecified query expansion condition. In this case, server behavior
	// defaults to
	// [Condition.DISABLED][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED SearchRequest_QueryExpansionSpec_Condition = 0
	// Disabled query expansion. Only the exact search query is used, even if
	// [SearchResponse.total_size][google.cloud.discoveryengine.v1.SearchResponse.total_size]
	// is zero.
	SearchRequest_QueryExpansionSpec_DISABLED SearchRequest_QueryExpansionSpec_Condition = 1
	// Automatic query expansion built by the Search API.
	SearchRequest_QueryExpansionSpec_AUTO SearchRequest_QueryExpansionSpec_Condition = 2
)

// Enum value maps for SearchRequest_QueryExpansionSpec_Condition.
var (
	SearchRequest_QueryExpansionSpec_Condition_name = map[int32]string{
		0: "CONDITION_UNSPECIFIED",
		1: "DISABLED",
		2: "AUTO",
	}
	SearchRequest_QueryExpansionSpec_Condition_value = map[string]int32{
		"CONDITION_UNSPECIFIED": 0,
		"DISABLED":              1,
		"AUTO":                  2,
	}
)

func (x SearchRequest_QueryExpansionSpec_Condition) Enum() *SearchRequest_QueryExpansionSpec_Condition {
	p := new(SearchRequest_QueryExpansionSpec_Condition)
	*p = x
	return p
}

func (x SearchRequest_QueryExpansionSpec_Condition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_QueryExpansionSpec_Condition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_search_service_proto_enumTypes[0].Descriptor()
}

func (SearchRequest_QueryExpansionSpec_Condition) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_search_service_proto_enumTypes[0]
}

func (x SearchRequest_QueryExpansionSpec_Condition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec_Condition.Descriptor instead.
func (SearchRequest_QueryExpansionSpec_Condition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Enum describing under which mode spell correction should occur.
type SearchRequest_SpellCorrectionSpec_Mode int32

const (
	// Unspecified spell correction mode. In this case, server behavior
	// defaults to
	// [Mode.AUTO][google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
	SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED SearchRequest_SpellCorrectionSpec_Mode = 0
	// Search API will try to find a spell suggestion if there
	// is any and put in the
	// [SearchResponse.corrected_query][google.cloud.discoveryengine.v1.SearchResponse.corrected_query].
	// The spell suggestion will not be used as the search query.
	SearchRequest_SpellCorrectionSpec_SUGGESTION_ONLY SearchRequest_SpellCorrectionSpec_Mode = 1
	// Automatic spell correction built by the Search API. Search will
	// be based on the corrected query if found.
	SearchRequest_SpellCorrectionSpec_AUTO SearchRequest_SpellCorrectionSpec_Mode = 2
)

// Enum value maps for SearchRequest_SpellCorrectionSpec_Mode.
var (
	SearchRequest_SpellCorrectionSpec_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "SUGGESTION_ONLY",
		2: "AUTO",
	}
	SearchRequest_SpellCorrectionSpec_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"SUGGESTION_ONLY":  1,
		"AUTO":             2,
	}
)

func (x SearchRequest_SpellCorrectionSpec_Mode) Enum() *SearchRequest_SpellCorrectionSpec_Mode {
	p := new(SearchRequest_SpellCorrectionSpec_Mode)
	*p = x
	return p
}

func (x SearchRequest_SpellCorrectionSpec_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_SpellCorrectionSpec_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_search_service_proto_enumTypes[1].Descriptor()
}

func (SearchRequest_SpellCorrectionSpec_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_search_service_proto_enumTypes[1]
}

func (x SearchRequest_SpellCorrectionSpec_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_SpellCorrectionSpec_Mode.Descriptor instead.
func (SearchRequest_SpellCorrectionSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Request message for
// [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
// method.
type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Search serving config, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
	// This field is used to identify the serving configuration name, set
	// of models used to make the search.
	ServingConfig string `protobuf:"bytes,1,opt,name=serving_config,json=servingConfig,proto3" json:"serving_config,omitempty"`
	// The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
	//
	// Use `default_branch` as the branch ID or leave this field empty, to search
	// documents under the default branch.
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`
	// Raw search query.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Maximum number of [Document][google.cloud.discoveryengine.v1.Document]s to
	// return. If unspecified, defaults to a reasonable value. The maximum allowed
	// value is 100. Values above 100 will be coerced to 100.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token received from a previous
	// [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
	// must match the call that provided the page token. Otherwise, an
	//  `INVALID_ARGUMENT`  error is returned.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A 0-indexed integer that specifies the current offset (that is, starting
	// result location, amongst the
	// [Document][google.cloud.discoveryengine.v1.Document]s deemed by the API as
	// relevant) in search results. This field is only considered if
	// [page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token] is
	// unset.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	Offset int32 `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
	// Information about the end user.
	// Highly recommended for analytics. The user_agent string in UserInfo will
	// be used to deduce device_type for analytics.
	UserInfo *UserInfo `protobuf:"bytes,21,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Additional search parameters.
	//
	// For public website search only, supported values are:
	//
	// * `user_country_code`: string. Default empty. If set to non-empty, results
	//    are restricted or boosted based on the location provided.
	// * `search_type`: double. Default empty. Enables non-webpage searching
	//   depending on the value. The only valid non-default value is 1,
	//   which enables image searching.
	Params map[string]*structpb.Value `protobuf:"bytes,11,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The query expansion specification that specifies the conditions under which
	// query expansion will occur.
	QueryExpansionSpec *SearchRequest_QueryExpansionSpec `protobuf:"bytes,13,opt,name=query_expansion_spec,json=queryExpansionSpec,proto3" json:"query_expansion_spec,omitempty"`
	// The spell correction specification that specifies the mode under
	// which spell correction will take effect.
	SpellCorrectionSpec *SearchRequest_SpellCorrectionSpec `protobuf:"bytes,14,opt,name=spell_correction_spec,json=spellCorrectionSpec,proto3" json:"spell_correction_spec,omitempty"`
	// A unique identifier for tracking visitors. For example, this could be
	// implemented with an HTTP cookie, which should be able to uniquely identify
	// a visitor on a single device. This unique identifier should not change if
	// the visitor logs in or out of the website.
	//
	// This field should NOT have a fixed value such as `unknown_visitor`.
	//
	// This should be the same identifier as
	// [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
	// and
	// [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1.CompleteQueryRequest.user_pseudo_id]
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
	UserPseudoId string `protobuf:"bytes,15,opt,name=user_pseudo_id,json=userPseudoId,proto3" json:"user_pseudo_id,omitempty"`
	// The content search spec that configs the desired behavior of content
	// search.
	ContentSearchSpec *SearchRequest_ContentSearchSpec `protobuf:"bytes,24,opt,name=content_search_spec,json=contentSearchSpec,proto3" json:"content_search_spec,omitempty"`
	// Whether to turn on safe search. This is only supported for
	// [ContentConfig.PUBLIC_WEBSITE][].
	SafeSearch bool `protobuf:"varint,20,opt,name=safe_search,json=safeSearch,proto3" json:"safe_search,omitempty"`
	// The user labels applied to a resource must meet the following requirements:
	//
	// * Each resource can have multiple labels, up to a maximum of 64.
	// * Each label must be a key-value pair.
	// * Keys have a minimum length of 1 character and a maximum length of 63
	//   characters and cannot be empty. Values can be empty and have a maximum
	//   length of 63 characters.
	// * Keys and values can contain only lowercase letters, numeric characters,
	//   underscores, and dashes. All characters must use UTF-8 encoding, and
	//   international characters are allowed.
	// * The key portion of a label must be unique. However, you can use the same
	//   key with multiple resources.
	// * Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `protobuf:"bytes,22,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchRequest) GetServingConfig() string {
	if x != nil {
		return x.ServingConfig
	}
	return ""
}

func (x *SearchRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SearchRequest) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *SearchRequest) GetParams() map[string]*structpb.Value {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *SearchRequest) GetQueryExpansionSpec() *SearchRequest_QueryExpansionSpec {
	if x != nil {
		return x.QueryExpansionSpec
	}
	return nil
}

func (x *SearchRequest) GetSpellCorrectionSpec() *SearchRequest_SpellCorrectionSpec {
	if x != nil {
		return x.SpellCorrectionSpec
	}
	return nil
}

func (x *SearchRequest) GetUserPseudoId() string {
	if x != nil {
		return x.UserPseudoId
	}
	return ""
}

func (x *SearchRequest) GetContentSearchSpec() *SearchRequest_ContentSearchSpec {
	if x != nil {
		return x.ContentSearchSpec
	}
	return nil
}

func (x *SearchRequest) GetSafeSearch() bool {
	if x != nil {
		return x.SafeSearch
	}
	return false
}

func (x *SearchRequest) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

// Response message for
// [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
// method.
type SearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of matched documents. The order represents the ranking.
	Results []*SearchResponse_SearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The estimated total count of matched items irrespective of pagination. The
	// count of [results][google.cloud.discoveryengine.v1.SearchResponse.results]
	// returned by pagination may be less than the
	// [total_size][google.cloud.discoveryengine.v1.SearchResponse.total_size]
	// that matches.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// A unique search token. This should be included in the
	// [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
	// this search, which enables accurate attribution of search model
	// performance.
	AttributionToken string `protobuf:"bytes,4,opt,name=attribution_token,json=attributionToken,proto3" json:"attribution_token,omitempty"`
	// A token that can be sent as
	// [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,5,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Contains the spell corrected query, if found. If the spell correction type
	// is AUTOMATIC, then the search results are based on corrected_query.
	// Otherwise the original query is used for search.
	CorrectedQuery string `protobuf:"bytes,7,opt,name=corrected_query,json=correctedQuery,proto3" json:"corrected_query,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchResponse) GetResults() []*SearchResponse_SearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchResponse) GetAttributionToken() string {
	if x != nil {
		return x.AttributionToken
	}
	return ""
}

func (x *SearchResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchResponse) GetCorrectedQuery() string {
	if x != nil {
		return x.CorrectedQuery
	}
	return ""
}

// Specification to determine under which conditions query expansion should
// occur.
type SearchRequest_QueryExpansionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The condition under which query expansion should occur. Default to
	// [Condition.DISABLED][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	Condition SearchRequest_QueryExpansionSpec_Condition `protobuf:"varint,1,opt,name=condition,proto3,enum=google.cloud.discoveryengine.v1.SearchRequest_QueryExpansionSpec_Condition" json:"condition,omitempty"`
}

func (x *SearchRequest_QueryExpansionSpec) Reset() {
	*x = SearchRequest_QueryExpansionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_QueryExpansionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_QueryExpansionSpec) ProtoMessage() {}

func (x *SearchRequest_QueryExpansionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_QueryExpansionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SearchRequest_QueryExpansionSpec) GetCondition() SearchRequest_QueryExpansionSpec_Condition {
	if x != nil {
		return x.Condition
	}
	return SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED
}

// The specification for query spell correction.
type SearchRequest_SpellCorrectionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mode under which spell correction should take effect to
	// replace the original search query. Default to
	// [Mode.AUTO][google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
	Mode SearchRequest_SpellCorrectionSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.discoveryengine.v1.SearchRequest_SpellCorrectionSpec_Mode" json:"mode,omitempty"`
}

func (x *SearchRequest_SpellCorrectionSpec) Reset() {
	*x = SearchRequest_SpellCorrectionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_SpellCorrectionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_SpellCorrectionSpec) ProtoMessage() {}

func (x *SearchRequest_SpellCorrectionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_SpellCorrectionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_SpellCorrectionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SearchRequest_SpellCorrectionSpec) GetMode() SearchRequest_SpellCorrectionSpec_Mode {
	if x != nil {
		return x.Mode
	}
	return SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED
}

// The specification that configs the desired behavior of the UCS content
// search.
type SearchRequest_ContentSearchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If there is no snippet spec provided, there will be no snippet in the
	// search result.
	SnippetSpec *SearchRequest_ContentSearchSpec_SnippetSpec `protobuf:"bytes,1,opt,name=snippet_spec,json=snippetSpec,proto3" json:"snippet_spec,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SearchRequest_ContentSearchSpec) GetSnippetSpec() *SearchRequest_ContentSearchSpec_SnippetSpec {
	if x != nil {
		return x.SnippetSpec
	}
	return nil
}

// The specification that configs the snippet in the search results.
type SearchRequest_ContentSearchSpec_SnippetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max number of snippets returned in each search result.
	// If the matching snippets is less than the max_snippet_count, return all
	// of the snippets; otherwise, return the max_snippet_count.
	//
	// At most 5 snippets will be returned for each SearchResult.
	MaxSnippetCount int32 `protobuf:"varint,1,opt,name=max_snippet_count,json=maxSnippetCount,proto3" json:"max_snippet_count,omitempty"`
	// if true, only snippet reference is returned.
	ReferenceOnly bool `protobuf:"varint,2,opt,name=reference_only,json=referenceOnly,proto3" json:"reference_only,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SnippetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SnippetSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SnippetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SnippetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetMaxSnippetCount() int32 {
	if x != nil {
		return x.MaxSnippetCount
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetReferenceOnly() bool {
	if x != nil {
		return x.ReferenceOnly
	}
	return false
}

// Represents the search results.
type SearchResponse_SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
	// searched [Document][google.cloud.discoveryengine.v1.Document].
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The document data snippet in the search response. Only fields that are
	// marked as retrievable are populated.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
}

func (x *SearchResponse_SearchResult) Reset() {
	*x = SearchResponse_SearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_SearchResult) ProtoMessage() {}

func (x *SearchResponse_SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResponse_SearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *SearchResponse_SearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SearchResponse_SearchResult) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

var File_google_cloud_discoveryengine_v1_search_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1_search_service_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xac, 0x0d, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x52, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x73, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x12, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x76, 0x0a, 0x15, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f, 0x63, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x13, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x24, 0x0a, 0x0e,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x50, 0x73, 0x65, 0x75, 0x64, 0x6f,
	0x49, 0x64, 0x12, 0x70, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x61, 0x66, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x5f, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xbf, 0x01, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x69, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x02, 0x1a, 0xaf, 0x01, 0x0a, 0x13, 0x53, 0x70, 0x65,
	0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x5b, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53,
	0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x3b, 0x0a,
	0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53,
	0x55, 0x47, 0x47, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x02, 0x1a, 0xe6, 0x01, 0x0a, 0x11, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x6f, 0x0a, 0x0c, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x0b, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x1a, 0x60, 0x0a, 0x0b, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d, 0x61, 0x78,
	0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x1a, 0x51, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xec, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63,
	0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x1a, 0x65, 0x0a,
	0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x45, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x32, 0x93, 0x03, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xad, 0x02, 0x0a, 0x06, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xc1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xba, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x63, 0x3a, 0x01, 0x2a, 0x22, 0x5e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x85, 0x02, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x42, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56,
	0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1_search_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1_search_service_proto_rawDescData = file_google_cloud_discoveryengine_v1_search_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1_search_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1_search_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1_search_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1_search_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1_search_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1_search_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_discoveryengine_v1_search_service_proto_goTypes = []interface{}{
	(SearchRequest_QueryExpansionSpec_Condition)(0), // 0: google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.Condition
	(SearchRequest_SpellCorrectionSpec_Mode)(0),     // 1: google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec.Mode
	(*SearchRequest)(nil),                           // 2: google.cloud.discoveryengine.v1.SearchRequest
	(*SearchResponse)(nil),                          // 3: google.cloud.discoveryengine.v1.SearchResponse
	(*SearchRequest_QueryExpansionSpec)(nil),        // 4: google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec
	(*SearchRequest_SpellCorrectionSpec)(nil),       // 5: google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec
	(*SearchRequest_ContentSearchSpec)(nil),         // 6: google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec
	nil,                                             // 7: google.cloud.discoveryengine.v1.SearchRequest.ParamsEntry
	nil,                                             // 8: google.cloud.discoveryengine.v1.SearchRequest.UserLabelsEntry
	(*SearchRequest_ContentSearchSpec_SnippetSpec)(nil), // 9: google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.SnippetSpec
	(*SearchResponse_SearchResult)(nil),                 // 10: google.cloud.discoveryengine.v1.SearchResponse.SearchResult
	(*UserInfo)(nil),                                    // 11: google.cloud.discoveryengine.v1.UserInfo
	(*structpb.Value)(nil),                              // 12: google.protobuf.Value
	(*Document)(nil),                                    // 13: google.cloud.discoveryengine.v1.Document
}
var file_google_cloud_discoveryengine_v1_search_service_proto_depIdxs = []int32{
	11, // 0: google.cloud.discoveryengine.v1.SearchRequest.user_info:type_name -> google.cloud.discoveryengine.v1.UserInfo
	7,  // 1: google.cloud.discoveryengine.v1.SearchRequest.params:type_name -> google.cloud.discoveryengine.v1.SearchRequest.ParamsEntry
	4,  // 2: google.cloud.discoveryengine.v1.SearchRequest.query_expansion_spec:type_name -> google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec
	5,  // 3: google.cloud.discoveryengine.v1.SearchRequest.spell_correction_spec:type_name -> google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec
	6,  // 4: google.cloud.discoveryengine.v1.SearchRequest.content_search_spec:type_name -> google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec
	8,  // 5: google.cloud.discoveryengine.v1.SearchRequest.user_labels:type_name -> google.cloud.discoveryengine.v1.SearchRequest.UserLabelsEntry
	10, // 6: google.cloud.discoveryengine.v1.SearchResponse.results:type_name -> google.cloud.discoveryengine.v1.SearchResponse.SearchResult
	0,  // 7: google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.condition:type_name -> google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.Condition
	1,  // 8: google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec.mode:type_name -> google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec.Mode
	9,  // 9: google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.snippet_spec:type_name -> google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.SnippetSpec
	12, // 10: google.cloud.discoveryengine.v1.SearchRequest.ParamsEntry.value:type_name -> google.protobuf.Value
	13, // 11: google.cloud.discoveryengine.v1.SearchResponse.SearchResult.document:type_name -> google.cloud.discoveryengine.v1.Document
	2,  // 12: google.cloud.discoveryengine.v1.SearchService.Search:input_type -> google.cloud.discoveryengine.v1.SearchRequest
	3,  // 13: google.cloud.discoveryengine.v1.SearchService.Search:output_type -> google.cloud.discoveryengine.v1.SearchResponse
	13, // [13:14] is the sub-list for method output_type
	12, // [12:13] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1_search_service_proto_init() }
func file_google_cloud_discoveryengine_v1_search_service_proto_init() {
	if File_google_cloud_discoveryengine_v1_search_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1_common_proto_init()
	file_google_cloud_discoveryengine_v1_document_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_QueryExpansionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_SpellCorrectionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SnippetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_SearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1_search_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1_search_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1_search_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1_search_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1_search_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1_search_service_proto = out.File
	file_google_cloud_discoveryengine_v1_search_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1_search_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1_search_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SearchServiceClient is the client API for SearchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SearchServiceClient interface {
	// Performs a search.
	Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error)
}

type searchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchServiceClient(cc grpc.ClientConnInterface) SearchServiceClient {
	return &searchServiceClient{cc}
}

func (c *searchServiceClient) Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error) {
	out := new(SearchResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.SearchService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchServiceServer is the server API for SearchService service.
type SearchServiceServer interface {
	// Performs a search.
	Search(context.Context, *SearchRequest) (*SearchResponse, error)
}

// UnimplementedSearchServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSearchServiceServer struct {
}

func (*UnimplementedSearchServiceServer) Search(context.Context, *SearchRequest) (*SearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Search not implemented")
}

func RegisterSearchServiceServer(s *grpc.Server, srv SearchServiceServer) {
	s.RegisterService(&_SearchService_serviceDesc, srv)
}

func _SearchService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.SearchService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Search(ctx, req.(*SearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SearchService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1.SearchService",
	HandlerType: (*SearchServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _SearchService_Search_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1/search_service.proto",
}
