// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/dataproc/v1/shared.proto

package dataprocpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Cluster components that can be activated.
type Component int32

const (
	// Unspecified component. Specifying this will cause Cluster creation to fail.
	Component_COMPONENT_UNSPECIFIED Component = 0
	// The Anaconda python distribution. The Anaconda component is not supported
	// in the Dataproc
	// <a
	// href="/dataproc/docs/concepts/versioning/dataproc-release-2.0">2.0
	// image</a>. The 2.0 image is pre-installed with Miniconda.
	Component_ANACONDA Component = 5
	// Docker
	Component_DOCKER Component = 13
	// The Druid query engine. (alpha)
	Component_DRUID Component = 9
	// Flink
	Component_FLINK Component = 14
	// HBase. (beta)
	Component_HBASE Component = 11
	// The Hive Web HCatalog (the REST service for accessing HCatalog).
	Component_HIVE_WEBHCAT Component = 3
	// Hudi.
	Component_HUDI Component = 18
	// The Jupyter Notebook.
	Component_JUPYTER Component = 1
	// The Presto query engine.
	Component_PRESTO Component = 6
	// The Trino query engine.
	Component_TRINO Component = 17
	// The Ranger service.
	Component_RANGER Component = 12
	// The Solr service.
	Component_SOLR Component = 10
	// The Zeppelin notebook.
	Component_ZEPPELIN Component = 4
	// The Zookeeper service.
	Component_ZOOKEEPER Component = 8
)

// Enum value maps for Component.
var (
	Component_name = map[int32]string{
		0:  "COMPONENT_UNSPECIFIED",
		5:  "ANACONDA",
		13: "DOCKER",
		9:  "DRUID",
		14: "FLINK",
		11: "HBASE",
		3:  "HIVE_WEBHCAT",
		18: "HUDI",
		1:  "JUPYTER",
		6:  "PRESTO",
		17: "TRINO",
		12: "RANGER",
		10: "SOLR",
		4:  "ZEPPELIN",
		8:  "ZOOKEEPER",
	}
	Component_value = map[string]int32{
		"COMPONENT_UNSPECIFIED": 0,
		"ANACONDA":              5,
		"DOCKER":                13,
		"DRUID":                 9,
		"FLINK":                 14,
		"HBASE":                 11,
		"HIVE_WEBHCAT":          3,
		"HUDI":                  18,
		"JUPYTER":               1,
		"PRESTO":                6,
		"TRINO":                 17,
		"RANGER":                12,
		"SOLR":                  10,
		"ZEPPELIN":              4,
		"ZOOKEEPER":             8,
	}
)

func (x Component) Enum() *Component {
	p := new(Component)
	*p = x
	return p
}

func (x Component) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Component) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_shared_proto_enumTypes[0].Descriptor()
}

func (Component) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_shared_proto_enumTypes[0]
}

func (x Component) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Component.Descriptor instead.
func (Component) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{0}
}

// Actions in response to failure of a resource associated with a cluster.
type FailureAction int32

const (
	// When FailureAction is unspecified, failure action defaults to NO_ACTION.
	FailureAction_FAILURE_ACTION_UNSPECIFIED FailureAction = 0
	// Take no action on failure to create a cluster resource. NO_ACTION is the
	// default.
	FailureAction_NO_ACTION FailureAction = 1
	// Delete the failed cluster resource.
	FailureAction_DELETE FailureAction = 2
)

// Enum value maps for FailureAction.
var (
	FailureAction_name = map[int32]string{
		0: "FAILURE_ACTION_UNSPECIFIED",
		1: "NO_ACTION",
		2: "DELETE",
	}
	FailureAction_value = map[string]int32{
		"FAILURE_ACTION_UNSPECIFIED": 0,
		"NO_ACTION":                  1,
		"DELETE":                     2,
	}
)

func (x FailureAction) Enum() *FailureAction {
	p := new(FailureAction)
	*p = x
	return p
}

func (x FailureAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FailureAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_shared_proto_enumTypes[1].Descriptor()
}

func (FailureAction) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_shared_proto_enumTypes[1]
}

func (x FailureAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FailureAction.Descriptor instead.
func (FailureAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{1}
}

// `Role` specifies the tasks that will run on the node pool. Roles can be
// specific to workloads. Exactly one
// [GkeNodePoolTarget][google.cloud.dataproc.v1.GkeNodePoolTarget] within the
// virtual cluster must have the `DEFAULT` role, which is used to run all
// workloads that are not associated with a node pool.
type GkeNodePoolTarget_Role int32

const (
	// Role is unspecified.
	GkeNodePoolTarget_ROLE_UNSPECIFIED GkeNodePoolTarget_Role = 0
	// At least one node pool must have the `DEFAULT` role.
	// Work assigned to a role that is not associated with a node pool
	// is assigned to the node pool with the `DEFAULT` role. For example,
	// work assigned to the `CONTROLLER` role will be assigned to the node pool
	// with the `DEFAULT` role if no node pool has the `CONTROLLER` role.
	GkeNodePoolTarget_DEFAULT GkeNodePoolTarget_Role = 1
	// Run work associated with the Dataproc control plane (for example,
	// controllers and webhooks). Very low resource requirements.
	GkeNodePoolTarget_CONTROLLER GkeNodePoolTarget_Role = 2
	// Run work associated with a Spark driver of a job.
	GkeNodePoolTarget_SPARK_DRIVER GkeNodePoolTarget_Role = 3
	// Run work associated with a Spark executor of a job.
	GkeNodePoolTarget_SPARK_EXECUTOR GkeNodePoolTarget_Role = 4
)

// Enum value maps for GkeNodePoolTarget_Role.
var (
	GkeNodePoolTarget_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "DEFAULT",
		2: "CONTROLLER",
		3: "SPARK_DRIVER",
		4: "SPARK_EXECUTOR",
	}
	GkeNodePoolTarget_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"DEFAULT":          1,
		"CONTROLLER":       2,
		"SPARK_DRIVER":     3,
		"SPARK_EXECUTOR":   4,
	}
)

func (x GkeNodePoolTarget_Role) Enum() *GkeNodePoolTarget_Role {
	p := new(GkeNodePoolTarget_Role)
	*p = x
	return p
}

func (x GkeNodePoolTarget_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GkeNodePoolTarget_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_shared_proto_enumTypes[2].Descriptor()
}

func (GkeNodePoolTarget_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_shared_proto_enumTypes[2]
}

func (x GkeNodePoolTarget_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GkeNodePoolTarget_Role.Descriptor instead.
func (GkeNodePoolTarget_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{11, 0}
}

// Runtime configuration for a workload.
type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Version of the batch runtime.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. Optional custom container image for the job runtime environment.
	// If not specified, a default container image will be used.
	ContainerImage string `protobuf:"bytes,2,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
	// Optional. A mapping of property names to values, which are used to
	// configure workload execution.
	Properties map[string]string `protobuf:"bytes,3,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{0}
}

func (x *RuntimeConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RuntimeConfig) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

func (x *RuntimeConfig) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Environment configuration for a workload.
type EnvironmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Execution configuration for a workload.
	ExecutionConfig *ExecutionConfig `protobuf:"bytes,1,opt,name=execution_config,json=executionConfig,proto3" json:"execution_config,omitempty"`
	// Optional. Peripherals configuration that workload has access to.
	PeripheralsConfig *PeripheralsConfig `protobuf:"bytes,2,opt,name=peripherals_config,json=peripheralsConfig,proto3" json:"peripherals_config,omitempty"`
}

func (x *EnvironmentConfig) Reset() {
	*x = EnvironmentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvironmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentConfig) ProtoMessage() {}

func (x *EnvironmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentConfig.ProtoReflect.Descriptor instead.
func (*EnvironmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{1}
}

func (x *EnvironmentConfig) GetExecutionConfig() *ExecutionConfig {
	if x != nil {
		return x.ExecutionConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetPeripheralsConfig() *PeripheralsConfig {
	if x != nil {
		return x.PeripheralsConfig
	}
	return nil
}

// Execution configuration for a workload.
type ExecutionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Service account that used to execute workload.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Network configuration for workload execution.
	//
	// Types that are assignable to Network:
	//	*ExecutionConfig_NetworkUri
	//	*ExecutionConfig_SubnetworkUri
	Network isExecutionConfig_Network `protobuf_oneof:"network"`
	// Optional. Tags used for network traffic control.
	NetworkTags []string `protobuf:"bytes,6,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Optional. The Cloud KMS key to use for encryption.
	KmsKey string `protobuf:"bytes,7,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Optional. The duration after which the workload will be terminated.
	// When the workload passes this ttl, it will be unconditionally killed
	// without waiting for ongoing work to finish.
	// Minimum value is 10 minutes; maximum value is 14 days (see JSON
	// representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	// If both ttl and idle_ttl are specified, the conditions are treated as
	// and OR: the workload will be terminated when it has been idle for idle_ttl
	// or when the ttl has passed, whichever comes first.
	// If ttl is not specified for a session, it defaults to 24h.
	Ttl *durationpb.Duration `protobuf:"bytes,9,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Optional. A Cloud Storage bucket used to stage workload dependencies,
	// config files, and store workload output and other ephemeral data, such as
	// Spark history files. If you do not specify a staging bucket, Cloud Dataproc
	// will determine a Cloud Storage location according to the region where your
	// workload is running, and then create and manage project-level, per-location
	// staging and temporary buckets.
	// **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
	// a Cloud Storage bucket.**
	StagingBucket string `protobuf:"bytes,10,opt,name=staging_bucket,json=stagingBucket,proto3" json:"staging_bucket,omitempty"`
}

func (x *ExecutionConfig) Reset() {
	*x = ExecutionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionConfig) ProtoMessage() {}

func (x *ExecutionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionConfig.ProtoReflect.Descriptor instead.
func (*ExecutionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{2}
}

func (x *ExecutionConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (m *ExecutionConfig) GetNetwork() isExecutionConfig_Network {
	if m != nil {
		return m.Network
	}
	return nil
}

func (x *ExecutionConfig) GetNetworkUri() string {
	if x, ok := x.GetNetwork().(*ExecutionConfig_NetworkUri); ok {
		return x.NetworkUri
	}
	return ""
}

func (x *ExecutionConfig) GetSubnetworkUri() string {
	if x, ok := x.GetNetwork().(*ExecutionConfig_SubnetworkUri); ok {
		return x.SubnetworkUri
	}
	return ""
}

func (x *ExecutionConfig) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ExecutionConfig) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *ExecutionConfig) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *ExecutionConfig) GetStagingBucket() string {
	if x != nil {
		return x.StagingBucket
	}
	return ""
}

type isExecutionConfig_Network interface {
	isExecutionConfig_Network()
}

type ExecutionConfig_NetworkUri struct {
	// Optional. Network URI to connect workload to.
	NetworkUri string `protobuf:"bytes,4,opt,name=network_uri,json=networkUri,proto3,oneof"`
}

type ExecutionConfig_SubnetworkUri struct {
	// Optional. Subnetwork URI to connect workload to.
	SubnetworkUri string `protobuf:"bytes,5,opt,name=subnetwork_uri,json=subnetworkUri,proto3,oneof"`
}

func (*ExecutionConfig_NetworkUri) isExecutionConfig_Network() {}

func (*ExecutionConfig_SubnetworkUri) isExecutionConfig_Network() {}

// Spark History Server configuration for the workload.
type SparkHistoryServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of an existing Dataproc Cluster to act as a Spark
	// History Server for the workload.
	//
	// Example:
	//
	// * `projects/[project_id]/regions/[region]/clusters/[cluster_name]`
	DataprocCluster string `protobuf:"bytes,1,opt,name=dataproc_cluster,json=dataprocCluster,proto3" json:"dataproc_cluster,omitempty"`
}

func (x *SparkHistoryServerConfig) Reset() {
	*x = SparkHistoryServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkHistoryServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkHistoryServerConfig) ProtoMessage() {}

func (x *SparkHistoryServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkHistoryServerConfig.ProtoReflect.Descriptor instead.
func (*SparkHistoryServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{3}
}

func (x *SparkHistoryServerConfig) GetDataprocCluster() string {
	if x != nil {
		return x.DataprocCluster
	}
	return ""
}

// Auxiliary services configuration for a workload.
type PeripheralsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of an existing Dataproc Metastore service.
	//
	// Example:
	//
	// * `projects/[project_id]/locations/[region]/services/[service_id]`
	MetastoreService string `protobuf:"bytes,1,opt,name=metastore_service,json=metastoreService,proto3" json:"metastore_service,omitempty"`
	// Optional. The Spark History Server configuration for the workload.
	SparkHistoryServerConfig *SparkHistoryServerConfig `protobuf:"bytes,2,opt,name=spark_history_server_config,json=sparkHistoryServerConfig,proto3" json:"spark_history_server_config,omitempty"`
}

func (x *PeripheralsConfig) Reset() {
	*x = PeripheralsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeripheralsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeripheralsConfig) ProtoMessage() {}

func (x *PeripheralsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeripheralsConfig.ProtoReflect.Descriptor instead.
func (*PeripheralsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{4}
}

func (x *PeripheralsConfig) GetMetastoreService() string {
	if x != nil {
		return x.MetastoreService
	}
	return ""
}

func (x *PeripheralsConfig) GetSparkHistoryServerConfig() *SparkHistoryServerConfig {
	if x != nil {
		return x.SparkHistoryServerConfig
	}
	return nil
}

// Runtime information about workload execution.
type RuntimeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Map of remote access endpoints (such as web interfaces and
	// APIs) to their URIs.
	Endpoints map[string]string `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A URI pointing to the location of the stdout and stderr of the
	// workload.
	OutputUri string `protobuf:"bytes,2,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Output only. A URI pointing to the location of the diagnostics tarball.
	DiagnosticOutputUri string `protobuf:"bytes,3,opt,name=diagnostic_output_uri,json=diagnosticOutputUri,proto3" json:"diagnostic_output_uri,omitempty"`
	// Output only. Approximate workload resource usage calculated after workload
	// finishes (see [Dataproc Serverless pricing]
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	ApproximateUsage *UsageMetrics `protobuf:"bytes,6,opt,name=approximate_usage,json=approximateUsage,proto3" json:"approximate_usage,omitempty"`
	// Output only. Snapshot of current workload resource usage.
	CurrentUsage *UsageSnapshot `protobuf:"bytes,7,opt,name=current_usage,json=currentUsage,proto3" json:"current_usage,omitempty"`
}

func (x *RuntimeInfo) Reset() {
	*x = RuntimeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeInfo) ProtoMessage() {}

func (x *RuntimeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeInfo.ProtoReflect.Descriptor instead.
func (*RuntimeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{5}
}

func (x *RuntimeInfo) GetEndpoints() map[string]string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *RuntimeInfo) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (x *RuntimeInfo) GetDiagnosticOutputUri() string {
	if x != nil {
		return x.DiagnosticOutputUri
	}
	return ""
}

func (x *RuntimeInfo) GetApproximateUsage() *UsageMetrics {
	if x != nil {
		return x.ApproximateUsage
	}
	return nil
}

func (x *RuntimeInfo) GetCurrentUsage() *UsageSnapshot {
	if x != nil {
		return x.CurrentUsage
	}
	return nil
}

// Usage metrics represent approximate total resources consumed by a workload.
type UsageMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. DCU (Dataproc Compute Units) usage in (`milliDCU` x `seconds`)
	// (see [Dataproc Serverless pricing]
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	MilliDcuSeconds int64 `protobuf:"varint,1,opt,name=milli_dcu_seconds,json=milliDcuSeconds,proto3" json:"milli_dcu_seconds,omitempty"`
	// Optional. Shuffle storage usage in (`GB` x `seconds`) (see
	// [Dataproc Serverless pricing]
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	ShuffleStorageGbSeconds int64 `protobuf:"varint,2,opt,name=shuffle_storage_gb_seconds,json=shuffleStorageGbSeconds,proto3" json:"shuffle_storage_gb_seconds,omitempty"`
}

func (x *UsageMetrics) Reset() {
	*x = UsageMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsageMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsageMetrics) ProtoMessage() {}

func (x *UsageMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsageMetrics.ProtoReflect.Descriptor instead.
func (*UsageMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{6}
}

func (x *UsageMetrics) GetMilliDcuSeconds() int64 {
	if x != nil {
		return x.MilliDcuSeconds
	}
	return 0
}

func (x *UsageMetrics) GetShuffleStorageGbSeconds() int64 {
	if x != nil {
		return x.ShuffleStorageGbSeconds
	}
	return 0
}

// The usage snaphot represents the resources consumed by a workload at a
// specified time.
type UsageSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) (see
	// [Dataproc Serverless pricing]
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	MilliDcu int64 `protobuf:"varint,1,opt,name=milli_dcu,json=milliDcu,proto3" json:"milli_dcu,omitempty"`
	// Optional. Shuffle Storage in gigabytes (GB). (see [Dataproc Serverless
	// pricing] (https://cloud.google.com/dataproc-serverless/pricing))
	ShuffleStorageGb int64 `protobuf:"varint,2,opt,name=shuffle_storage_gb,json=shuffleStorageGb,proto3" json:"shuffle_storage_gb,omitempty"`
	// Optional. The timestamp of the usage snapshot.
	SnapshotTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
}

func (x *UsageSnapshot) Reset() {
	*x = UsageSnapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsageSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsageSnapshot) ProtoMessage() {}

func (x *UsageSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsageSnapshot.ProtoReflect.Descriptor instead.
func (*UsageSnapshot) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{7}
}

func (x *UsageSnapshot) GetMilliDcu() int64 {
	if x != nil {
		return x.MilliDcu
	}
	return 0
}

func (x *UsageSnapshot) GetShuffleStorageGb() int64 {
	if x != nil {
		return x.ShuffleStorageGb
	}
	return 0
}

func (x *UsageSnapshot) GetSnapshotTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SnapshotTime
	}
	return nil
}

// The cluster's GKE config.
type GkeClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A target GKE cluster to deploy to. It must be in the same project
	// and region as the Dataproc cluster (the GKE cluster can be zonal or
	// regional). Format:
	// 'projects/{project}/locations/{location}/clusters/{cluster_id}'
	GkeClusterTarget string `protobuf:"bytes,2,opt,name=gke_cluster_target,json=gkeClusterTarget,proto3" json:"gke_cluster_target,omitempty"`
	// Optional. GKE node pools where workloads will be scheduled. At least one
	// node pool must be assigned the `DEFAULT`
	// [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
	// If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
	// `GkeNodePoolTarget`. Each role can be given to only one
	// `GkeNodePoolTarget`. All node pools must have the same location settings.
	NodePoolTarget []*GkeNodePoolTarget `protobuf:"bytes,3,rep,name=node_pool_target,json=nodePoolTarget,proto3" json:"node_pool_target,omitempty"`
}

func (x *GkeClusterConfig) Reset() {
	*x = GkeClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeClusterConfig) ProtoMessage() {}

func (x *GkeClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeClusterConfig.ProtoReflect.Descriptor instead.
func (*GkeClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{8}
}

func (x *GkeClusterConfig) GetGkeClusterTarget() string {
	if x != nil {
		return x.GkeClusterTarget
	}
	return ""
}

func (x *GkeClusterConfig) GetNodePoolTarget() []*GkeNodePoolTarget {
	if x != nil {
		return x.NodePoolTarget
	}
	return nil
}

// The configuration for running the Dataproc cluster on Kubernetes.
type KubernetesClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A namespace within the Kubernetes cluster to deploy into. If this
	// namespace does not exist, it is created. If it exists, Dataproc verifies
	// that another Dataproc VirtualCluster is not installed into it. If not
	// specified, the name of the Dataproc Cluster is used.
	KubernetesNamespace string `protobuf:"bytes,1,opt,name=kubernetes_namespace,json=kubernetesNamespace,proto3" json:"kubernetes_namespace,omitempty"`
	// Types that are assignable to Config:
	//	*KubernetesClusterConfig_GkeClusterConfig
	Config isKubernetesClusterConfig_Config `protobuf_oneof:"config"`
	// Optional. The software configuration for this Dataproc cluster running on
	// Kubernetes.
	KubernetesSoftwareConfig *KubernetesSoftwareConfig `protobuf:"bytes,3,opt,name=kubernetes_software_config,json=kubernetesSoftwareConfig,proto3" json:"kubernetes_software_config,omitempty"`
}

func (x *KubernetesClusterConfig) Reset() {
	*x = KubernetesClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesClusterConfig) ProtoMessage() {}

func (x *KubernetesClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesClusterConfig.ProtoReflect.Descriptor instead.
func (*KubernetesClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{9}
}

func (x *KubernetesClusterConfig) GetKubernetesNamespace() string {
	if x != nil {
		return x.KubernetesNamespace
	}
	return ""
}

func (m *KubernetesClusterConfig) GetConfig() isKubernetesClusterConfig_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *KubernetesClusterConfig) GetGkeClusterConfig() *GkeClusterConfig {
	if x, ok := x.GetConfig().(*KubernetesClusterConfig_GkeClusterConfig); ok {
		return x.GkeClusterConfig
	}
	return nil
}

func (x *KubernetesClusterConfig) GetKubernetesSoftwareConfig() *KubernetesSoftwareConfig {
	if x != nil {
		return x.KubernetesSoftwareConfig
	}
	return nil
}

type isKubernetesClusterConfig_Config interface {
	isKubernetesClusterConfig_Config()
}

type KubernetesClusterConfig_GkeClusterConfig struct {
	// Required. The configuration for running the Dataproc cluster on GKE.
	GkeClusterConfig *GkeClusterConfig `protobuf:"bytes,2,opt,name=gke_cluster_config,json=gkeClusterConfig,proto3,oneof"`
}

func (*KubernetesClusterConfig_GkeClusterConfig) isKubernetesClusterConfig_Config() {}

// The software configuration for this Dataproc cluster running on Kubernetes.
type KubernetesSoftwareConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The components that should be installed in this Dataproc cluster. The key
	// must be a string from the KubernetesComponent enumeration. The value is
	// the version of the software to be installed.
	// At least one entry must be specified.
	ComponentVersion map[string]string `protobuf:"bytes,1,rep,name=component_version,json=componentVersion,proto3" json:"component_version,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, for example
	// `spark:spark.kubernetes.container.image`. The following are supported
	// prefixes and their mappings:
	//
	// * spark:  `spark-defaults.conf`
	//
	// For more information, see [Cluster
	// properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *KubernetesSoftwareConfig) Reset() {
	*x = KubernetesSoftwareConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesSoftwareConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesSoftwareConfig) ProtoMessage() {}

func (x *KubernetesSoftwareConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesSoftwareConfig.ProtoReflect.Descriptor instead.
func (*KubernetesSoftwareConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{10}
}

func (x *KubernetesSoftwareConfig) GetComponentVersion() map[string]string {
	if x != nil {
		return x.ComponentVersion
	}
	return nil
}

func (x *KubernetesSoftwareConfig) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

// GKE node pools that Dataproc workloads run on.
type GkeNodePoolTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The target GKE node pool.
	// Format:
	// 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
	NodePool string `protobuf:"bytes,1,opt,name=node_pool,json=nodePool,proto3" json:"node_pool,omitempty"`
	// Required. The roles associated with the GKE node pool.
	Roles []GkeNodePoolTarget_Role `protobuf:"varint,2,rep,packed,name=roles,proto3,enum=google.cloud.dataproc.v1.GkeNodePoolTarget_Role" json:"roles,omitempty"`
	// Input only. The configuration for the GKE node pool.
	//
	// If specified, Dataproc attempts to create a node pool with the
	// specified shape. If one with the same name already exists, it is
	// verified against all specified fields. If a field differs, the
	// virtual cluster creation will fail.
	//
	// If omitted, any node pool with the specified name is used. If a
	// node pool with the specified name does not exist, Dataproc create a
	// node pool with default values.
	//
	// This is an input only field. It will not be returned by the API.
	NodePoolConfig *GkeNodePoolConfig `protobuf:"bytes,3,opt,name=node_pool_config,json=nodePoolConfig,proto3" json:"node_pool_config,omitempty"`
}

func (x *GkeNodePoolTarget) Reset() {
	*x = GkeNodePoolTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeNodePoolTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeNodePoolTarget) ProtoMessage() {}

func (x *GkeNodePoolTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeNodePoolTarget.ProtoReflect.Descriptor instead.
func (*GkeNodePoolTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{11}
}

func (x *GkeNodePoolTarget) GetNodePool() string {
	if x != nil {
		return x.NodePool
	}
	return ""
}

func (x *GkeNodePoolTarget) GetRoles() []GkeNodePoolTarget_Role {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *GkeNodePoolTarget) GetNodePoolConfig() *GkeNodePoolConfig {
	if x != nil {
		return x.NodePoolConfig
	}
	return nil
}

// The configuration of a GKE node pool used by a [Dataproc-on-GKE
// cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
type GkeNodePoolConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The node pool configuration.
	Config *GkeNodePoolConfig_GkeNodeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. The list of Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) where
	// node pool nodes associated with a Dataproc on GKE virtual cluster
	// will be located.
	//
	// **Note:** All node pools associated with a virtual cluster
	// must be located in the same region as the virtual cluster, and they must
	// be located in the same zone within that region.
	//
	// If a location is not specified during node pool creation, Dataproc on GKE
	// will choose the zone.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// Optional. The autoscaler configuration for this node pool. The autoscaler
	// is enabled only when a valid configuration is present.
	Autoscaling *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig `protobuf:"bytes,4,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
}

func (x *GkeNodePoolConfig) Reset() {
	*x = GkeNodePoolConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeNodePoolConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeNodePoolConfig) ProtoMessage() {}

func (x *GkeNodePoolConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeNodePoolConfig.ProtoReflect.Descriptor instead.
func (*GkeNodePoolConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{12}
}

func (x *GkeNodePoolConfig) GetConfig() *GkeNodePoolConfig_GkeNodeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *GkeNodePoolConfig) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *GkeNodePoolConfig) GetAutoscaling() *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

// Parameters that describe cluster nodes.
type GkeNodePoolConfig_GkeNodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of a Compute Engine [machine
	// type](https://cloud.google.com/compute/docs/machine-types).
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Optional. The number of local SSD disks to attach to the node, which is
	// limited by the maximum number of disks allowable per zone (see [Adding
	// Local SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
	// Optional. Whether the nodes are created as legacy [preemptible VM
	// instances] (https://cloud.google.com/compute/docs/instances/preemptible).
	// Also see
	// [Spot][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.spot]
	// VMs, preemptible VM instances without a maximum lifetime. Legacy and Spot
	// preemptible nodes cannot be used in a node pool with the `CONTROLLER`
	// [role]
	// (/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
	// or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
	// DEFAULT node pool will assume the CONTROLLER role).
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// Optional. A list of [hardware
	// accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
	// each node.
	Accelerators []*GkeNodePoolConfig_GkeNodePoolAcceleratorConfig `protobuf:"bytes,11,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Optional. [Minimum CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	// to be used by this instance. The instance may be scheduled on the
	// specified or a newer CPU platform. Specify the friendly names of CPU
	// platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
	MinCpuPlatform string `protobuf:"bytes,13,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// Optional. The [Customer Managed Encryption Key (CMEK)]
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
	// used to encrypt the boot disk attached to each node in the node pool.
	// Specify the key using the following format:
	// <code>projects/<var>KEY_PROJECT_ID</var>/locations/<var>LOCATION</var>/keyRings/<var>RING_NAME</var>/cryptoKeys/<var>KEY_NAME</var></code>.
	BootDiskKmsKey string `protobuf:"bytes,23,opt,name=boot_disk_kms_key,json=bootDiskKmsKey,proto3" json:"boot_disk_kms_key,omitempty"`
	// Optional. Whether the nodes are created as [Spot VM instances]
	// (https://cloud.google.com/compute/docs/instances/spot).
	// Spot VMs are the latest update to legacy
	// [preemptible
	// VMs][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.preemptible].
	// Spot VMs do not have a maximum lifetime. Legacy and Spot preemptible
	// nodes cannot be used in a node pool with the `CONTROLLER`
	// [role](/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
	// or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
	// DEFAULT node pool will assume the CONTROLLER role).
	Spot bool `protobuf:"varint,32,opt,name=spot,proto3" json:"spot,omitempty"`
}

func (x *GkeNodePoolConfig_GkeNodeConfig) Reset() {
	*x = GkeNodePoolConfig_GkeNodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeNodePoolConfig_GkeNodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeNodePoolConfig_GkeNodeConfig) ProtoMessage() {}

func (x *GkeNodePoolConfig_GkeNodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeNodePoolConfig_GkeNodeConfig.ProtoReflect.Descriptor instead.
func (*GkeNodePoolConfig_GkeNodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{12, 0}
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetLocalSsdCount() int32 {
	if x != nil {
		return x.LocalSsdCount
	}
	return 0
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetAccelerators() []*GkeNodePoolConfig_GkeNodePoolAcceleratorConfig {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetBootDiskKmsKey() string {
	if x != nil {
		return x.BootDiskKmsKey
	}
	return ""
}

func (x *GkeNodePoolConfig_GkeNodeConfig) GetSpot() bool {
	if x != nil {
		return x.Spot
	}
	return false
}

// A GkeNodeConfigAcceleratorConfig represents a Hardware Accelerator request
// for a node pool.
type GkeNodePoolConfig_GkeNodePoolAcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of accelerator cards exposed to an instance.
	AcceleratorCount int64 `protobuf:"varint,1,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
	// The accelerator type resource namename (see GPUs on Compute Engine).
	AcceleratorType string `protobuf:"bytes,2,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
	// Size of partitions to create on the GPU. Valid values are described in
	// the NVIDIA [mig user
	// guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
	GpuPartitionSize string `protobuf:"bytes,3,opt,name=gpu_partition_size,json=gpuPartitionSize,proto3" json:"gpu_partition_size,omitempty"`
}

func (x *GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) Reset() {
	*x = GkeNodePoolConfig_GkeNodePoolAcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) ProtoMessage() {}

func (x *GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeNodePoolConfig_GkeNodePoolAcceleratorConfig.ProtoReflect.Descriptor instead.
func (*GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{12, 1}
}

func (x *GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) GetAcceleratorCount() int64 {
	if x != nil {
		return x.AcceleratorCount
	}
	return 0
}

func (x *GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) GetAcceleratorType() string {
	if x != nil {
		return x.AcceleratorType
	}
	return ""
}

func (x *GkeNodePoolConfig_GkeNodePoolAcceleratorConfig) GetGpuPartitionSize() string {
	if x != nil {
		return x.GpuPartitionSize
	}
	return ""
}

// GkeNodePoolAutoscaling contains information the cluster autoscaler needs to
// adjust the size of the node pool to the current cluster usage.
type GkeNodePoolConfig_GkeNodePoolAutoscalingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum number of nodes in the node pool. Must be >= 0 and <=
	// max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// The maximum number of nodes in the node pool. Must be >= min_node_count,
	// and must be > 0.
	// **Note:** Quota must be sufficient to scale up the cluster.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
}

func (x *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) Reset() {
	*x = GkeNodePoolConfig_GkeNodePoolAutoscalingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) ProtoMessage() {}

func (x *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeNodePoolConfig_GkeNodePoolAutoscalingConfig.ProtoReflect.Descriptor instead.
func (*GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{12, 2}
}

func (x *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) GetMinNodeCount() int32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *GkeNodePoolConfig_GkeNodePoolAutoscalingConfig) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

var File_google_cloud_dataproc_v1_shared_proto protoreflect.FileDescriptor

var file_google_cloud_dataproc_v1_shared_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9,
	0x01, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x5c, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcf, 0x01, 0x0a, 0x11, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x59, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12, 0x70,
	0x65, 0x72, 0x69, 0x70, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x70, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70, 0x65, 0x72, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc4, 0x02, 0x0a,
	0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x26,
	0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x1c, 0x0a, 0x07,
	0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x03, 0x74, 0x74,
	0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x67, 0x69,
	0x6e, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x22, 0x4a, 0x0a, 0x18, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x2e, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22,
	0xe2, 0x01, 0x0a, 0x11, 0x50, 0x65, 0x72, 0x69, 0x70, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x11, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x76, 0x0a, 0x1b,
	0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x70, 0x61, 0x72,
	0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xae, 0x03, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x57, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x22, 0x0a,
	0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72,
	0x69, 0x12, 0x37, 0x0a, 0x15, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x58, 0x0a, 0x11, 0x61, 0x70,
	0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x10, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x51, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x3c, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x81, 0x01, 0x0a, 0x0c, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f,
	0x64, 0x63, 0x75, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x44, 0x63, 0x75,
	0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x40, 0x0a, 0x1a, 0x73, 0x68, 0x75, 0x66, 0x66,
	0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x67, 0x62, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x17, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x47, 0x62, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0xaa, 0x01, 0x0a, 0x0d, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d,
	0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x64, 0x63, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x44, 0x63, 0x75, 0x12, 0x31, 0x0a,
	0x12, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x47, 0x62,
	0x12, 0x44, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x10, 0x47, 0x6b, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x12, 0x67,
	0x6b, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x10, 0x67, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x5a, 0x0a, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22,
	0xb3, 0x02, 0x0a, 0x17, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x14, 0x6b,
	0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x67, 0x6b, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x00, 0x52, 0x10, 0x67, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x1a, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x6f,
	0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x18, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x6f, 0x66,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xf9, 0x02, 0x0a, 0x18, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x75, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x65, 0x73, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x65, 0x73, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x43, 0x0a,
	0x15, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xbf, 0x02, 0x0a, 0x11, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x4b, 0x0a, 0x05, 0x72, 0x6f, 0x6c,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x04, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x5f, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f,
	0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0e, 0x0a,
	0x0a, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x52, 0x10, 0x02, 0x12, 0x10, 0x0a,
	0x0c, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x52, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x4f,
	0x52, 0x10, 0x04, 0x22, 0x8b, 0x07, 0x0a, 0x11, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x21, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf6, 0x02, 0x0a, 0x0d, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2b, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0b,
	0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69,
	0x62, 0x6c, 0x65, 0x12, 0x71, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x70,
	0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x2e, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x70, 0x6f, 0x74, 0x18, 0x20, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x73, 0x70, 0x6f, 0x74, 0x1a, 0xa4,
	0x01, 0x0a, 0x1c, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x2b, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x67, 0x70, 0x75, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x67, 0x70, 0x75, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x6a, 0x0a, 0x1c, 0x47, 0x6b, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d,
	0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x6d,
	0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x2a, 0xd4, 0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12,
	0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x4e,
	0x41, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x43, 0x4b,
	0x45, 0x52, 0x10, 0x0d, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x55, 0x49, 0x44, 0x10, 0x09, 0x12,
	0x09, 0x0a, 0x05, 0x46, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x42,
	0x41, 0x53, 0x45, 0x10, 0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x57, 0x45,
	0x42, 0x48, 0x43, 0x41, 0x54, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x55, 0x44, 0x49, 0x10,
	0x12, 0x12, 0x0b, 0x0a, 0x07, 0x4a, 0x55, 0x50, 0x59, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x50, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52,
	0x49, 0x4e, 0x4f, 0x10, 0x11, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x52, 0x10,
	0x0c, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x4f, 0x4c, 0x52, 0x10, 0x0a, 0x12, 0x0c, 0x0a, 0x08, 0x5a,
	0x45, 0x50, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x5a, 0x4f, 0x4f,
	0x4b, 0x45, 0x45, 0x50, 0x45, 0x52, 0x10, 0x08, 0x2a, 0x4a, 0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x41, 0x49,
	0x4c, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x10, 0x02, 0x42, 0xac, 0x02, 0xea, 0x41, 0x5e, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0xea, 0x41, 0x5e, 0x0a, 0x20, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataproc_v1_shared_proto_rawDescOnce sync.Once
	file_google_cloud_dataproc_v1_shared_proto_rawDescData = file_google_cloud_dataproc_v1_shared_proto_rawDesc
)

func file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP() []byte {
	file_google_cloud_dataproc_v1_shared_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataproc_v1_shared_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataproc_v1_shared_proto_rawDescData)
	})
	return file_google_cloud_dataproc_v1_shared_proto_rawDescData
}

var file_google_cloud_dataproc_v1_shared_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dataproc_v1_shared_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_dataproc_v1_shared_proto_goTypes = []interface{}{
	(Component)(0),                          // 0: google.cloud.dataproc.v1.Component
	(FailureAction)(0),                      // 1: google.cloud.dataproc.v1.FailureAction
	(GkeNodePoolTarget_Role)(0),             // 2: google.cloud.dataproc.v1.GkeNodePoolTarget.Role
	(*RuntimeConfig)(nil),                   // 3: google.cloud.dataproc.v1.RuntimeConfig
	(*EnvironmentConfig)(nil),               // 4: google.cloud.dataproc.v1.EnvironmentConfig
	(*ExecutionConfig)(nil),                 // 5: google.cloud.dataproc.v1.ExecutionConfig
	(*SparkHistoryServerConfig)(nil),        // 6: google.cloud.dataproc.v1.SparkHistoryServerConfig
	(*PeripheralsConfig)(nil),               // 7: google.cloud.dataproc.v1.PeripheralsConfig
	(*RuntimeInfo)(nil),                     // 8: google.cloud.dataproc.v1.RuntimeInfo
	(*UsageMetrics)(nil),                    // 9: google.cloud.dataproc.v1.UsageMetrics
	(*UsageSnapshot)(nil),                   // 10: google.cloud.dataproc.v1.UsageSnapshot
	(*GkeClusterConfig)(nil),                // 11: google.cloud.dataproc.v1.GkeClusterConfig
	(*KubernetesClusterConfig)(nil),         // 12: google.cloud.dataproc.v1.KubernetesClusterConfig
	(*KubernetesSoftwareConfig)(nil),        // 13: google.cloud.dataproc.v1.KubernetesSoftwareConfig
	(*GkeNodePoolTarget)(nil),               // 14: google.cloud.dataproc.v1.GkeNodePoolTarget
	(*GkeNodePoolConfig)(nil),               // 15: google.cloud.dataproc.v1.GkeNodePoolConfig
	nil,                                     // 16: google.cloud.dataproc.v1.RuntimeConfig.PropertiesEntry
	nil,                                     // 17: google.cloud.dataproc.v1.RuntimeInfo.EndpointsEntry
	nil,                                     // 18: google.cloud.dataproc.v1.KubernetesSoftwareConfig.ComponentVersionEntry
	nil,                                     // 19: google.cloud.dataproc.v1.KubernetesSoftwareConfig.PropertiesEntry
	(*GkeNodePoolConfig_GkeNodeConfig)(nil), // 20: google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
	(*GkeNodePoolConfig_GkeNodePoolAcceleratorConfig)(nil), // 21: google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
	(*GkeNodePoolConfig_GkeNodePoolAutoscalingConfig)(nil), // 22: google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
	(*durationpb.Duration)(nil),                            // 23: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                          // 24: google.protobuf.Timestamp
}
var file_google_cloud_dataproc_v1_shared_proto_depIdxs = []int32{
	16, // 0: google.cloud.dataproc.v1.RuntimeConfig.properties:type_name -> google.cloud.dataproc.v1.RuntimeConfig.PropertiesEntry
	5,  // 1: google.cloud.dataproc.v1.EnvironmentConfig.execution_config:type_name -> google.cloud.dataproc.v1.ExecutionConfig
	7,  // 2: google.cloud.dataproc.v1.EnvironmentConfig.peripherals_config:type_name -> google.cloud.dataproc.v1.PeripheralsConfig
	23, // 3: google.cloud.dataproc.v1.ExecutionConfig.ttl:type_name -> google.protobuf.Duration
	6,  // 4: google.cloud.dataproc.v1.PeripheralsConfig.spark_history_server_config:type_name -> google.cloud.dataproc.v1.SparkHistoryServerConfig
	17, // 5: google.cloud.dataproc.v1.RuntimeInfo.endpoints:type_name -> google.cloud.dataproc.v1.RuntimeInfo.EndpointsEntry
	9,  // 6: google.cloud.dataproc.v1.RuntimeInfo.approximate_usage:type_name -> google.cloud.dataproc.v1.UsageMetrics
	10, // 7: google.cloud.dataproc.v1.RuntimeInfo.current_usage:type_name -> google.cloud.dataproc.v1.UsageSnapshot
	24, // 8: google.cloud.dataproc.v1.UsageSnapshot.snapshot_time:type_name -> google.protobuf.Timestamp
	14, // 9: google.cloud.dataproc.v1.GkeClusterConfig.node_pool_target:type_name -> google.cloud.dataproc.v1.GkeNodePoolTarget
	11, // 10: google.cloud.dataproc.v1.KubernetesClusterConfig.gke_cluster_config:type_name -> google.cloud.dataproc.v1.GkeClusterConfig
	13, // 11: google.cloud.dataproc.v1.KubernetesClusterConfig.kubernetes_software_config:type_name -> google.cloud.dataproc.v1.KubernetesSoftwareConfig
	18, // 12: google.cloud.dataproc.v1.KubernetesSoftwareConfig.component_version:type_name -> google.cloud.dataproc.v1.KubernetesSoftwareConfig.ComponentVersionEntry
	19, // 13: google.cloud.dataproc.v1.KubernetesSoftwareConfig.properties:type_name -> google.cloud.dataproc.v1.KubernetesSoftwareConfig.PropertiesEntry
	2,  // 14: google.cloud.dataproc.v1.GkeNodePoolTarget.roles:type_name -> google.cloud.dataproc.v1.GkeNodePoolTarget.Role
	15, // 15: google.cloud.dataproc.v1.GkeNodePoolTarget.node_pool_config:type_name -> google.cloud.dataproc.v1.GkeNodePoolConfig
	20, // 16: google.cloud.dataproc.v1.GkeNodePoolConfig.config:type_name -> google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
	22, // 17: google.cloud.dataproc.v1.GkeNodePoolConfig.autoscaling:type_name -> google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
	21, // 18: google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.accelerators:type_name -> google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_dataproc_v1_shared_proto_init() }
func file_google_cloud_dataproc_v1_shared_proto_init() {
	if File_google_cloud_dataproc_v1_shared_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvironmentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkHistoryServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeripheralsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UsageMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UsageSnapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesSoftwareConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeNodePoolTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeNodePoolConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeNodePoolConfig_GkeNodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeNodePoolConfig_GkeNodePoolAcceleratorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeNodePoolConfig_GkeNodePoolAutoscalingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataproc_v1_shared_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ExecutionConfig_NetworkUri)(nil),
		(*ExecutionConfig_SubnetworkUri)(nil),
	}
	file_google_cloud_dataproc_v1_shared_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*KubernetesClusterConfig_GkeClusterConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataproc_v1_shared_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataproc_v1_shared_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataproc_v1_shared_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataproc_v1_shared_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataproc_v1_shared_proto_msgTypes,
	}.Build()
	File_google_cloud_dataproc_v1_shared_proto = out.File
	file_google_cloud_dataproc_v1_shared_proto_rawDesc = nil
	file_google_cloud_dataproc_v1_shared_proto_goTypes = nil
	file_google_cloud_dataproc_v1_shared_proto_depIdxs = nil
}
