// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

package clouddmspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of database entities supported,
type DatabaseEntityType int32

const (
	// Unspecified database entity type.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED DatabaseEntityType = 0
	// Schema.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_SCHEMA DatabaseEntityType = 1
	// Table.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_TABLE DatabaseEntityType = 2
	// Column.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_COLUMN DatabaseEntityType = 3
	// Constraint.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_CONSTRAINT DatabaseEntityType = 4
	// Index.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_INDEX DatabaseEntityType = 5
	// Trigger.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_TRIGGER DatabaseEntityType = 6
	// View.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_VIEW DatabaseEntityType = 7
	// Sequence.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_SEQUENCE DatabaseEntityType = 8
	// Stored Procedure.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_STORED_PROCEDURE DatabaseEntityType = 9
	// Function.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_FUNCTION DatabaseEntityType = 10
	// Synonym.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_SYNONYM DatabaseEntityType = 11
	// Package.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_DATABASE_PACKAGE DatabaseEntityType = 12
	// UDT.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_UDT DatabaseEntityType = 13
	// Materialized View.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW DatabaseEntityType = 14
	// Database.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_DATABASE DatabaseEntityType = 15
)

// Enum value maps for DatabaseEntityType.
var (
	DatabaseEntityType_name = map[int32]string{
		0:  "DATABASE_ENTITY_TYPE_UNSPECIFIED",
		1:  "DATABASE_ENTITY_TYPE_SCHEMA",
		2:  "DATABASE_ENTITY_TYPE_TABLE",
		3:  "DATABASE_ENTITY_TYPE_COLUMN",
		4:  "DATABASE_ENTITY_TYPE_CONSTRAINT",
		5:  "DATABASE_ENTITY_TYPE_INDEX",
		6:  "DATABASE_ENTITY_TYPE_TRIGGER",
		7:  "DATABASE_ENTITY_TYPE_VIEW",
		8:  "DATABASE_ENTITY_TYPE_SEQUENCE",
		9:  "DATABASE_ENTITY_TYPE_STORED_PROCEDURE",
		10: "DATABASE_ENTITY_TYPE_FUNCTION",
		11: "DATABASE_ENTITY_TYPE_SYNONYM",
		12: "DATABASE_ENTITY_TYPE_DATABASE_PACKAGE",
		13: "DATABASE_ENTITY_TYPE_UDT",
		14: "DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW",
		15: "DATABASE_ENTITY_TYPE_DATABASE",
	}
	DatabaseEntityType_value = map[string]int32{
		"DATABASE_ENTITY_TYPE_UNSPECIFIED":       0,
		"DATABASE_ENTITY_TYPE_SCHEMA":            1,
		"DATABASE_ENTITY_TYPE_TABLE":             2,
		"DATABASE_ENTITY_TYPE_COLUMN":            3,
		"DATABASE_ENTITY_TYPE_CONSTRAINT":        4,
		"DATABASE_ENTITY_TYPE_INDEX":             5,
		"DATABASE_ENTITY_TYPE_TRIGGER":           6,
		"DATABASE_ENTITY_TYPE_VIEW":              7,
		"DATABASE_ENTITY_TYPE_SEQUENCE":          8,
		"DATABASE_ENTITY_TYPE_STORED_PROCEDURE":  9,
		"DATABASE_ENTITY_TYPE_FUNCTION":          10,
		"DATABASE_ENTITY_TYPE_SYNONYM":           11,
		"DATABASE_ENTITY_TYPE_DATABASE_PACKAGE":  12,
		"DATABASE_ENTITY_TYPE_UDT":               13,
		"DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW": 14,
		"DATABASE_ENTITY_TYPE_DATABASE":          15,
	}
)

func (x DatabaseEntityType) Enum() *DatabaseEntityType {
	p := new(DatabaseEntityType)
	*p = x
	return p
}

func (x DatabaseEntityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEntityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[0].Descriptor()
}

func (DatabaseEntityType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[0]
}

func (x DatabaseEntityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEntityType.Descriptor instead.
func (DatabaseEntityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{0}
}

// The types of jobs that can be executed in the background.
type BackgroundJobType int32

const (
	// Unspecified background job type.
	BackgroundJobType_BACKGROUND_JOB_TYPE_UNSPECIFIED BackgroundJobType = 0
	// Job to seed from the source database.
	BackgroundJobType_BACKGROUND_JOB_TYPE_SOURCE_SEED BackgroundJobType = 1
	// Job to convert the source database into a draft of the destination
	// database.
	BackgroundJobType_BACKGROUND_JOB_TYPE_CONVERT BackgroundJobType = 2
	// Job to apply the draft tree onto the destination.
	BackgroundJobType_BACKGROUND_JOB_TYPE_APPLY_DESTINATION BackgroundJobType = 3
	// Job to import and convert mapping rules from an external source such as an
	// ora2pg config file.
	BackgroundJobType_BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE BackgroundJobType = 5
)

// Enum value maps for BackgroundJobType.
var (
	BackgroundJobType_name = map[int32]string{
		0: "BACKGROUND_JOB_TYPE_UNSPECIFIED",
		1: "BACKGROUND_JOB_TYPE_SOURCE_SEED",
		2: "BACKGROUND_JOB_TYPE_CONVERT",
		3: "BACKGROUND_JOB_TYPE_APPLY_DESTINATION",
		5: "BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE",
	}
	BackgroundJobType_value = map[string]int32{
		"BACKGROUND_JOB_TYPE_UNSPECIFIED":       0,
		"BACKGROUND_JOB_TYPE_SOURCE_SEED":       1,
		"BACKGROUND_JOB_TYPE_CONVERT":           2,
		"BACKGROUND_JOB_TYPE_APPLY_DESTINATION": 3,
		"BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE": 5,
	}
)

func (x BackgroundJobType) Enum() *BackgroundJobType {
	p := new(BackgroundJobType)
	*p = x
	return p
}

func (x BackgroundJobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackgroundJobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[1].Descriptor()
}

func (BackgroundJobType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[1]
}

func (x BackgroundJobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackgroundJobType.Descriptor instead.
func (BackgroundJobType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{1}
}

// The format for the import rules file.
type ImportRulesFileFormat int32

const (
	// Unspecified rules format.
	ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_UNSPECIFIED ImportRulesFileFormat = 0
	// HarbourBridge session file.
	ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE ImportRulesFileFormat = 1
	// Ora2Pg configuration file.
	ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE ImportRulesFileFormat = 2
)

// Enum value maps for ImportRulesFileFormat.
var (
	ImportRulesFileFormat_name = map[int32]string{
		0: "IMPORT_RULES_FILE_FORMAT_UNSPECIFIED",
		1: "IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE",
		2: "IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE",
	}
	ImportRulesFileFormat_value = map[string]int32{
		"IMPORT_RULES_FILE_FORMAT_UNSPECIFIED":                 0,
		"IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE": 1,
		"IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE":         2,
	}
)

func (x ImportRulesFileFormat) Enum() *ImportRulesFileFormat {
	p := new(ImportRulesFileFormat)
	*p = x
	return p
}

func (x ImportRulesFileFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportRulesFileFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[2].Descriptor()
}

func (ImportRulesFileFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[2]
}

func (x ImportRulesFileFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportRulesFileFormat.Descriptor instead.
func (ImportRulesFileFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2}
}

// Final state after a job completes.
type BackgroundJobLogEntry_JobCompletionState int32

const (
	// The status is not specified. This state is used when job is not yet
	// finished.
	BackgroundJobLogEntry_JOB_COMPLETION_STATE_UNSPECIFIED BackgroundJobLogEntry_JobCompletionState = 0
	// Success.
	BackgroundJobLogEntry_SUCCEEDED BackgroundJobLogEntry_JobCompletionState = 1
	// Error.
	BackgroundJobLogEntry_FAILED BackgroundJobLogEntry_JobCompletionState = 2
)

// Enum value maps for BackgroundJobLogEntry_JobCompletionState.
var (
	BackgroundJobLogEntry_JobCompletionState_name = map[int32]string{
		0: "JOB_COMPLETION_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
	}
	BackgroundJobLogEntry_JobCompletionState_value = map[string]int32{
		"JOB_COMPLETION_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                        1,
		"FAILED":                           2,
	}
)

func (x BackgroundJobLogEntry_JobCompletionState) Enum() *BackgroundJobLogEntry_JobCompletionState {
	p := new(BackgroundJobLogEntry_JobCompletionState)
	*p = x
	return p
}

func (x BackgroundJobLogEntry_JobCompletionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackgroundJobLogEntry_JobCompletionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[3].Descriptor()
}

func (BackgroundJobLogEntry_JobCompletionState) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[3]
}

func (x BackgroundJobLogEntry_JobCompletionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackgroundJobLogEntry_JobCompletionState.Descriptor instead.
func (BackgroundJobLogEntry_JobCompletionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 0}
}

// The type of database entities tree.
type DatabaseEntity_TreeType int32

const (
	// Tree type unspecified.
	DatabaseEntity_TREE_TYPE_UNSPECIFIED DatabaseEntity_TreeType = 0
	// Tree of entities loaded from a source database.
	DatabaseEntity_SOURCE DatabaseEntity_TreeType = 1
	// Tree of entities converted from the source tree using the mapping rules.
	DatabaseEntity_DRAFT DatabaseEntity_TreeType = 2
	// Tree of entities observed on the destination database.
	DatabaseEntity_DESTINATION DatabaseEntity_TreeType = 3
)

// Enum value maps for DatabaseEntity_TreeType.
var (
	DatabaseEntity_TreeType_name = map[int32]string{
		0: "TREE_TYPE_UNSPECIFIED",
		1: "SOURCE",
		2: "DRAFT",
		3: "DESTINATION",
	}
	DatabaseEntity_TreeType_value = map[string]int32{
		"TREE_TYPE_UNSPECIFIED": 0,
		"SOURCE":                1,
		"DRAFT":                 2,
		"DESTINATION":           3,
	}
)

func (x DatabaseEntity_TreeType) Enum() *DatabaseEntity_TreeType {
	p := new(DatabaseEntity_TreeType)
	*p = x
	return p
}

func (x DatabaseEntity_TreeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEntity_TreeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[4].Descriptor()
}

func (DatabaseEntity_TreeType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[4]
}

func (x DatabaseEntity_TreeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEntity_TreeType.Descriptor instead.
func (DatabaseEntity_TreeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{3, 0}
}

// The type and version of a source or destination database.
type DatabaseEngineInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Engine type.
	Engine DatabaseEngine `protobuf:"varint,1,opt,name=engine,proto3,enum=google.cloud.clouddms.v1.DatabaseEngine" json:"engine,omitempty"`
	// Required. Engine named version, for example 12.c.1.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *DatabaseEngineInfo) Reset() {
	*x = DatabaseEngineInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseEngineInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEngineInfo) ProtoMessage() {}

func (x *DatabaseEngineInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEngineInfo.ProtoReflect.Descriptor instead.
func (*DatabaseEngineInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{0}
}

func (x *DatabaseEngineInfo) GetEngine() DatabaseEngine {
	if x != nil {
		return x.Engine
	}
	return DatabaseEngine_DATABASE_ENGINE_UNSPECIFIED
}

func (x *DatabaseEngineInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// The main conversion workspace resource entity.
type ConversionWorkspace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of the workspace resource, in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The source engine details.
	Source *DatabaseEngineInfo `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The destination engine details.
	Destination *DatabaseEngineInfo `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	// A generic list of settings for the workspace.
	// The settings are database pair dependant and can indicate default behavior
	// for the mapping rules engine or turn on or off specific features.
	// Such examples can be: convert_foreign_key_to_interleave=true,
	// skip_triggers=false, ignore_non_table_synonyms=true
	GlobalSettings map[string]string `protobuf:"bytes,4,rep,name=global_settings,json=globalSettings,proto3" json:"global_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Whether the workspace has uncommitted changes (changes which
	// were made after the workspace was committed).
	HasUncommittedChanges bool `protobuf:"varint,5,opt,name=has_uncommitted_changes,json=hasUncommittedChanges,proto3" json:"has_uncommitted_changes,omitempty"`
	// Output only. The latest commit ID.
	LatestCommitId string `protobuf:"bytes,6,opt,name=latest_commit_id,json=latestCommitId,proto3" json:"latest_commit_id,omitempty"`
	// Output only. The timestamp when the workspace was committed.
	LatestCommitTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=latest_commit_time,json=latestCommitTime,proto3" json:"latest_commit_time,omitempty"`
	// Output only. The timestamp when the workspace resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the workspace resource was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The display name for the workspace.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ConversionWorkspace) Reset() {
	*x = ConversionWorkspace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversionWorkspace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversionWorkspace) ProtoMessage() {}

func (x *ConversionWorkspace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversionWorkspace.ProtoReflect.Descriptor instead.
func (*ConversionWorkspace) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{1}
}

func (x *ConversionWorkspace) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversionWorkspace) GetSource() *DatabaseEngineInfo {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ConversionWorkspace) GetDestination() *DatabaseEngineInfo {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ConversionWorkspace) GetGlobalSettings() map[string]string {
	if x != nil {
		return x.GlobalSettings
	}
	return nil
}

func (x *ConversionWorkspace) GetHasUncommittedChanges() bool {
	if x != nil {
		return x.HasUncommittedChanges
	}
	return false
}

func (x *ConversionWorkspace) GetLatestCommitId() string {
	if x != nil {
		return x.LatestCommitId
	}
	return ""
}

func (x *ConversionWorkspace) GetLatestCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestCommitTime
	}
	return nil
}

func (x *ConversionWorkspace) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConversionWorkspace) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConversionWorkspace) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Execution log of a background job.
type BackgroundJobLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The background job log entry ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of job that was executed.
	JobType BackgroundJobType `protobuf:"varint,2,opt,name=job_type,json=jobType,proto3,enum=google.cloud.clouddms.v1.BackgroundJobType" json:"job_type,omitempty"`
	// The timestamp when the background job was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The timestamp when the background job was finished.
	FinishTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	// Job completion state, i.e. the final state after the job completed.
	CompletionState BackgroundJobLogEntry_JobCompletionState `protobuf:"varint,5,opt,name=completion_state,json=completionState,proto3,enum=google.cloud.clouddms.v1.BackgroundJobLogEntry_JobCompletionState" json:"completion_state,omitempty"`
	// Job completion comment, such as how many entities were seeded,
	// how many warnings were found during conversion, and similar information.
	CompletionComment string `protobuf:"bytes,6,opt,name=completion_comment,json=completionComment,proto3" json:"completion_comment,omitempty"`
	// Whether the client requested the conversion workspace to be committed after
	// a successful completion of the job.
	RequestAutocommit bool `protobuf:"varint,7,opt,name=request_autocommit,json=requestAutocommit,proto3" json:"request_autocommit,omitempty"`
	// Types that are assignable to JobDetails:
	//	*BackgroundJobLogEntry_SeedJobDetails_
	//	*BackgroundJobLogEntry_ImportRulesJobDetails_
	//	*BackgroundJobLogEntry_ConvertJobDetails_
	//	*BackgroundJobLogEntry_ApplyJobDetails_
	JobDetails isBackgroundJobLogEntry_JobDetails `protobuf_oneof:"job_details"`
}

func (x *BackgroundJobLogEntry) Reset() {
	*x = BackgroundJobLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackgroundJobLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry) ProtoMessage() {}

func (x *BackgroundJobLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2}
}

func (x *BackgroundJobLogEntry) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BackgroundJobLogEntry) GetJobType() BackgroundJobType {
	if x != nil {
		return x.JobType
	}
	return BackgroundJobType_BACKGROUND_JOB_TYPE_UNSPECIFIED
}

func (x *BackgroundJobLogEntry) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetFinishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishTime
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetCompletionState() BackgroundJobLogEntry_JobCompletionState {
	if x != nil {
		return x.CompletionState
	}
	return BackgroundJobLogEntry_JOB_COMPLETION_STATE_UNSPECIFIED
}

func (x *BackgroundJobLogEntry) GetCompletionComment() string {
	if x != nil {
		return x.CompletionComment
	}
	return ""
}

func (x *BackgroundJobLogEntry) GetRequestAutocommit() bool {
	if x != nil {
		return x.RequestAutocommit
	}
	return false
}

func (m *BackgroundJobLogEntry) GetJobDetails() isBackgroundJobLogEntry_JobDetails {
	if m != nil {
		return m.JobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetSeedJobDetails() *BackgroundJobLogEntry_SeedJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_SeedJobDetails_); ok {
		return x.SeedJobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetImportRulesJobDetails() *BackgroundJobLogEntry_ImportRulesJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_ImportRulesJobDetails_); ok {
		return x.ImportRulesJobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetConvertJobDetails() *BackgroundJobLogEntry_ConvertJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_ConvertJobDetails_); ok {
		return x.ConvertJobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetApplyJobDetails() *BackgroundJobLogEntry_ApplyJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_ApplyJobDetails_); ok {
		return x.ApplyJobDetails
	}
	return nil
}

type isBackgroundJobLogEntry_JobDetails interface {
	isBackgroundJobLogEntry_JobDetails()
}

type BackgroundJobLogEntry_SeedJobDetails_ struct {
	// Seed job details.
	SeedJobDetails *BackgroundJobLogEntry_SeedJobDetails `protobuf:"bytes,100,opt,name=seed_job_details,json=seedJobDetails,proto3,oneof"`
}

type BackgroundJobLogEntry_ImportRulesJobDetails_ struct {
	// Import rules job details.
	ImportRulesJobDetails *BackgroundJobLogEntry_ImportRulesJobDetails `protobuf:"bytes,101,opt,name=import_rules_job_details,json=importRulesJobDetails,proto3,oneof"`
}

type BackgroundJobLogEntry_ConvertJobDetails_ struct {
	// Convert job details.
	ConvertJobDetails *BackgroundJobLogEntry_ConvertJobDetails `protobuf:"bytes,102,opt,name=convert_job_details,json=convertJobDetails,proto3,oneof"`
}

type BackgroundJobLogEntry_ApplyJobDetails_ struct {
	// Apply job details.
	ApplyJobDetails *BackgroundJobLogEntry_ApplyJobDetails `protobuf:"bytes,103,opt,name=apply_job_details,json=applyJobDetails,proto3,oneof"`
}

func (*BackgroundJobLogEntry_SeedJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

func (*BackgroundJobLogEntry_ImportRulesJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

func (*BackgroundJobLogEntry_ConvertJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

func (*BackgroundJobLogEntry_ApplyJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

// The base entity type for all the database related entities.
// The message contains the entity name, the name of its parent, the entity
// type, and the specific details per entity type.
type DatabaseEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short name (e.g. table name) of the entity.
	ShortName string `protobuf:"bytes,1,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The full name of the parent entity (e.g. schema name).
	ParentEntity string `protobuf:"bytes,2,opt,name=parent_entity,json=parentEntity,proto3" json:"parent_entity,omitempty"`
	// The type of tree the entity belongs to.
	Tree DatabaseEntity_TreeType `protobuf:"varint,3,opt,name=tree,proto3,enum=google.cloud.clouddms.v1.DatabaseEntity_TreeType" json:"tree,omitempty"`
	// The type of the database entity (table, view, index, ...).
	EntityType DatabaseEntityType `protobuf:"varint,4,opt,name=entity_type,json=entityType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"entity_type,omitempty"`
	// Details about entity mappings.
	// For source tree entities, this holds the draft entities which were
	// generated by the mapping rules.
	// For draft tree entities, this holds the source entities which were
	// converted to form the draft entity.
	// Destination entities will have no mapping details.
	Mappings []*EntityMapping `protobuf:"bytes,5,rep,name=mappings,proto3" json:"mappings,omitempty"`
	// The specific body for each entity type.
	//
	// Types that are assignable to EntityBody:
	//	*DatabaseEntity_Schema
	//	*DatabaseEntity_Table
	//	*DatabaseEntity_View
	//	*DatabaseEntity_Sequence
	//	*DatabaseEntity_StoredProcedure
	//	*DatabaseEntity_DatabaseFunction
	//	*DatabaseEntity_Synonym
	//	*DatabaseEntity_DatabasePackage
	EntityBody isDatabaseEntity_EntityBody `protobuf_oneof:"entity_body"`
}

func (x *DatabaseEntity) Reset() {
	*x = DatabaseEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEntity) ProtoMessage() {}

func (x *DatabaseEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEntity.ProtoReflect.Descriptor instead.
func (*DatabaseEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{3}
}

func (x *DatabaseEntity) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *DatabaseEntity) GetParentEntity() string {
	if x != nil {
		return x.ParentEntity
	}
	return ""
}

func (x *DatabaseEntity) GetTree() DatabaseEntity_TreeType {
	if x != nil {
		return x.Tree
	}
	return DatabaseEntity_TREE_TYPE_UNSPECIFIED
}

func (x *DatabaseEntity) GetEntityType() DatabaseEntityType {
	if x != nil {
		return x.EntityType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *DatabaseEntity) GetMappings() []*EntityMapping {
	if x != nil {
		return x.Mappings
	}
	return nil
}

func (m *DatabaseEntity) GetEntityBody() isDatabaseEntity_EntityBody {
	if m != nil {
		return m.EntityBody
	}
	return nil
}

func (x *DatabaseEntity) GetSchema() *SchemaEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Schema); ok {
		return x.Schema
	}
	return nil
}

func (x *DatabaseEntity) GetTable() *TableEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Table); ok {
		return x.Table
	}
	return nil
}

func (x *DatabaseEntity) GetView() *ViewEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_View); ok {
		return x.View
	}
	return nil
}

func (x *DatabaseEntity) GetSequence() *SequenceEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Sequence); ok {
		return x.Sequence
	}
	return nil
}

func (x *DatabaseEntity) GetStoredProcedure() *StoredProcedureEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_StoredProcedure); ok {
		return x.StoredProcedure
	}
	return nil
}

func (x *DatabaseEntity) GetDatabaseFunction() *FunctionEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_DatabaseFunction); ok {
		return x.DatabaseFunction
	}
	return nil
}

func (x *DatabaseEntity) GetSynonym() *SynonymEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Synonym); ok {
		return x.Synonym
	}
	return nil
}

func (x *DatabaseEntity) GetDatabasePackage() *PackageEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_DatabasePackage); ok {
		return x.DatabasePackage
	}
	return nil
}

type isDatabaseEntity_EntityBody interface {
	isDatabaseEntity_EntityBody()
}

type DatabaseEntity_Schema struct {
	// Schema.
	Schema *SchemaEntity `protobuf:"bytes,102,opt,name=schema,proto3,oneof"`
}

type DatabaseEntity_Table struct {
	// Table.
	Table *TableEntity `protobuf:"bytes,103,opt,name=table,proto3,oneof"`
}

type DatabaseEntity_View struct {
	// View.
	View *ViewEntity `protobuf:"bytes,104,opt,name=view,proto3,oneof"`
}

type DatabaseEntity_Sequence struct {
	// Sequence.
	Sequence *SequenceEntity `protobuf:"bytes,105,opt,name=sequence,proto3,oneof"`
}

type DatabaseEntity_StoredProcedure struct {
	// Stored procedure.
	StoredProcedure *StoredProcedureEntity `protobuf:"bytes,106,opt,name=stored_procedure,json=storedProcedure,proto3,oneof"`
}

type DatabaseEntity_DatabaseFunction struct {
	// Function.
	DatabaseFunction *FunctionEntity `protobuf:"bytes,107,opt,name=database_function,json=databaseFunction,proto3,oneof"`
}

type DatabaseEntity_Synonym struct {
	// Synonym.
	Synonym *SynonymEntity `protobuf:"bytes,108,opt,name=synonym,proto3,oneof"`
}

type DatabaseEntity_DatabasePackage struct {
	// Package.
	DatabasePackage *PackageEntity `protobuf:"bytes,109,opt,name=database_package,json=databasePackage,proto3,oneof"`
}

func (*DatabaseEntity_Schema) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Table) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_View) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Sequence) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_StoredProcedure) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_DatabaseFunction) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Synonym) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_DatabasePackage) isDatabaseEntity_EntityBody() {}

// Schema typically has no parent entity, but can have a parent entity
// DatabaseInstance (for database engines which support it).  For some database
// engines, the terms  schema and user can be used interchangeably when they
// refer to a namespace or a collection of other database entities. Can store
// additional information which is schema specific.
type SchemaEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,1,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *SchemaEntity) Reset() {
	*x = SchemaEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaEntity) ProtoMessage() {}

func (x *SchemaEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaEntity.ProtoReflect.Descriptor instead.
func (*SchemaEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{4}
}

func (x *SchemaEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Table's parent is a schema.
type TableEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table columns.
	Columns []*ColumnEntity `protobuf:"bytes,1,rep,name=columns,proto3" json:"columns,omitempty"`
	// Table constraints.
	Constraints []*ConstraintEntity `protobuf:"bytes,2,rep,name=constraints,proto3" json:"constraints,omitempty"`
	// Table indices.
	Indices []*IndexEntity `protobuf:"bytes,3,rep,name=indices,proto3" json:"indices,omitempty"`
	// Table triggers.
	Triggers []*TriggerEntity `protobuf:"bytes,4,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,5,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Comment associated with the table.
	Comment string `protobuf:"bytes,6,opt,name=comment,proto3" json:"comment,omitempty"`
}

func (x *TableEntity) Reset() {
	*x = TableEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableEntity) ProtoMessage() {}

func (x *TableEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableEntity.ProtoReflect.Descriptor instead.
func (*TableEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{5}
}

func (x *TableEntity) GetColumns() []*ColumnEntity {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *TableEntity) GetConstraints() []*ConstraintEntity {
	if x != nil {
		return x.Constraints
	}
	return nil
}

func (x *TableEntity) GetIndices() []*IndexEntity {
	if x != nil {
		return x.Indices
	}
	return nil
}

func (x *TableEntity) GetTriggers() []*TriggerEntity {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *TableEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *TableEntity) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

// Column is not used as an independent entity, it is retrieved as part of a
// Table entity.
type ColumnEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Column data type.
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Charset override - instead of table level charset.
	Charset string `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
	// Collation override - instead of table level collation.
	Collation string `protobuf:"bytes,4,opt,name=collation,proto3" json:"collation,omitempty"`
	// Column length - e.g. varchar (50).
	Length int64 `protobuf:"varint,5,opt,name=length,proto3" json:"length,omitempty"`
	// Column precision - when relevant.
	Precision int32 `protobuf:"varint,6,opt,name=precision,proto3" json:"precision,omitempty"`
	// Column scale - when relevant.
	Scale int32 `protobuf:"varint,7,opt,name=scale,proto3" json:"scale,omitempty"`
	// Column fractional second precision - used for timestamp based datatypes.
	FractionalSecondsPrecision int32 `protobuf:"varint,8,opt,name=fractional_seconds_precision,json=fractionalSecondsPrecision,proto3" json:"fractional_seconds_precision,omitempty"`
	// Is the column of array type.
	Array bool `protobuf:"varint,9,opt,name=array,proto3" json:"array,omitempty"`
	// If the column is array, of which length.
	ArrayLength int32 `protobuf:"varint,10,opt,name=array_length,json=arrayLength,proto3" json:"array_length,omitempty"`
	// Is the column nullable.
	Nullable bool `protobuf:"varint,11,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// Is the column auto-generated/identity.
	AutoGenerated bool `protobuf:"varint,12,opt,name=auto_generated,json=autoGenerated,proto3" json:"auto_generated,omitempty"`
	// Is the column a UDT.
	Udt bool `protobuf:"varint,13,opt,name=udt,proto3" json:"udt,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,14,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Specifies the list of values allowed in the column.
	// Only used for set data type.
	SetValues []string `protobuf:"bytes,15,rep,name=set_values,json=setValues,proto3" json:"set_values,omitempty"`
	// Comment associated with the column.
	Comment string `protobuf:"bytes,16,opt,name=comment,proto3" json:"comment,omitempty"`
	// Column order in the table.
	OrdinalPosition int32 `protobuf:"varint,17,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
	// Default value of the column.
	DefaultValue string `protobuf:"bytes,18,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *ColumnEntity) Reset() {
	*x = ColumnEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnEntity) ProtoMessage() {}

func (x *ColumnEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnEntity.ProtoReflect.Descriptor instead.
func (*ColumnEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ColumnEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ColumnEntity) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *ColumnEntity) GetCharset() string {
	if x != nil {
		return x.Charset
	}
	return ""
}

func (x *ColumnEntity) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *ColumnEntity) GetLength() int64 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *ColumnEntity) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *ColumnEntity) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *ColumnEntity) GetFractionalSecondsPrecision() int32 {
	if x != nil {
		return x.FractionalSecondsPrecision
	}
	return 0
}

func (x *ColumnEntity) GetArray() bool {
	if x != nil {
		return x.Array
	}
	return false
}

func (x *ColumnEntity) GetArrayLength() int32 {
	if x != nil {
		return x.ArrayLength
	}
	return 0
}

func (x *ColumnEntity) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *ColumnEntity) GetAutoGenerated() bool {
	if x != nil {
		return x.AutoGenerated
	}
	return false
}

func (x *ColumnEntity) GetUdt() bool {
	if x != nil {
		return x.Udt
	}
	return false
}

func (x *ColumnEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *ColumnEntity) GetSetValues() []string {
	if x != nil {
		return x.SetValues
	}
	return nil
}

func (x *ColumnEntity) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (x *ColumnEntity) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

func (x *ColumnEntity) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

// Constraint is not used as an independent entity, it is retrieved
// as part of another entity such as Table or View.
type ConstraintEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the table constraint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of constraint, for example unique, primary key, foreign key (currently
	// only primary key is supported).
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Table columns used as part of the Constraint, for example primary key
	// constraint should list the columns which constitutes the key.
	TableColumns []string `protobuf:"bytes,3,rep,name=table_columns,json=tableColumns,proto3" json:"table_columns,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,4,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Reference columns which may be associated with the constraint. For example,
	// if the constraint is a FOREIGN_KEY, this represents the list of full names
	// of referenced columns by the foreign key.
	ReferenceColumns []string `protobuf:"bytes,5,rep,name=reference_columns,json=referenceColumns,proto3" json:"reference_columns,omitempty"`
	// Reference table which may be associated with the constraint. For example,
	// if the constraint is a FOREIGN_KEY, this represents the list of full name
	// of the referenced table by the foreign key.
	ReferenceTable string `protobuf:"bytes,6,opt,name=reference_table,json=referenceTable,proto3" json:"reference_table,omitempty"`
	// Table which is associated with the constraint. In case the constraint
	// is defined on a table, this field is left empty as this information is
	// stored in parent_name. However, if constraint is defined on a view, this
	// field stores the table name on which the view is defined.
	TableName string `protobuf:"bytes,7,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
}

func (x *ConstraintEntity) Reset() {
	*x = ConstraintEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConstraintEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConstraintEntity) ProtoMessage() {}

func (x *ConstraintEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConstraintEntity.ProtoReflect.Descriptor instead.
func (*ConstraintEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ConstraintEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConstraintEntity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ConstraintEntity) GetTableColumns() []string {
	if x != nil {
		return x.TableColumns
	}
	return nil
}

func (x *ConstraintEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *ConstraintEntity) GetReferenceColumns() []string {
	if x != nil {
		return x.ReferenceColumns
	}
	return nil
}

func (x *ConstraintEntity) GetReferenceTable() string {
	if x != nil {
		return x.ReferenceTable
	}
	return ""
}

func (x *ConstraintEntity) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

// Index is not used as an independent entity, it is retrieved as part of a
// Table entity.
type IndexEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the index.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of index, for example B-TREE.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Table columns used as part of the Index, for example B-TREE index should
	// list the columns which constitutes the index.
	TableColumns []string `protobuf:"bytes,3,rep,name=table_columns,json=tableColumns,proto3" json:"table_columns,omitempty"`
	// Boolean value indicating whether the index is unique.
	Unique bool `protobuf:"varint,4,opt,name=unique,proto3" json:"unique,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,5,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *IndexEntity) Reset() {
	*x = IndexEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexEntity) ProtoMessage() {}

func (x *IndexEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexEntity.ProtoReflect.Descriptor instead.
func (*IndexEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{8}
}

func (x *IndexEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IndexEntity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *IndexEntity) GetTableColumns() []string {
	if x != nil {
		return x.TableColumns
	}
	return nil
}

func (x *IndexEntity) GetUnique() bool {
	if x != nil {
		return x.Unique
	}
	return false
}

func (x *IndexEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Trigger is not used as an independent entity, it is retrieved as part of a
// Table entity.
type TriggerEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the trigger.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The DML, DDL, or database events that fire the trigger, for example
	// INSERT, UPDATE.
	TriggeringEvents []string `protobuf:"bytes,2,rep,name=triggering_events,json=triggeringEvents,proto3" json:"triggering_events,omitempty"`
	// Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
	// ROW.
	TriggerType string `protobuf:"bytes,3,opt,name=trigger_type,json=triggerType,proto3" json:"trigger_type,omitempty"`
	// The SQL code which creates the trigger.
	SqlCode string `protobuf:"bytes,4,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,5,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *TriggerEntity) Reset() {
	*x = TriggerEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TriggerEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggerEntity) ProtoMessage() {}

func (x *TriggerEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggerEntity.ProtoReflect.Descriptor instead.
func (*TriggerEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{9}
}

func (x *TriggerEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TriggerEntity) GetTriggeringEvents() []string {
	if x != nil {
		return x.TriggeringEvents
	}
	return nil
}

func (x *TriggerEntity) GetTriggerType() string {
	if x != nil {
		return x.TriggerType
	}
	return ""
}

func (x *TriggerEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *TriggerEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// View's parent is a schema.
type ViewEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the view.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// View constraints.
	Constraints []*ConstraintEntity `protobuf:"bytes,3,rep,name=constraints,proto3" json:"constraints,omitempty"`
}

func (x *ViewEntity) Reset() {
	*x = ViewEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ViewEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViewEntity) ProtoMessage() {}

func (x *ViewEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViewEntity.ProtoReflect.Descriptor instead.
func (*ViewEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{10}
}

func (x *ViewEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *ViewEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *ViewEntity) GetConstraints() []*ConstraintEntity {
	if x != nil {
		return x.Constraints
	}
	return nil
}

// Sequence's parent is a schema.
type SequenceEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Increment value for the sequence.
	Increment int64 `protobuf:"varint,1,opt,name=increment,proto3" json:"increment,omitempty"`
	// Start number for the sequence represented as bytes to accommodate large.
	// numbers
	StartValue []byte `protobuf:"bytes,2,opt,name=start_value,json=startValue,proto3" json:"start_value,omitempty"`
	// Maximum number for the sequence represented as bytes to accommodate large.
	// numbers
	MaxValue []byte `protobuf:"bytes,3,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Minimum number for the sequence represented as bytes to accommodate large.
	// numbers
	MinValue []byte `protobuf:"bytes,4,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Indicates whether the sequence value should cycle through.
	Cycle bool `protobuf:"varint,5,opt,name=cycle,proto3" json:"cycle,omitempty"`
	// Indicates number of entries to cache / precreate.
	Cache int64 `protobuf:"varint,6,opt,name=cache,proto3" json:"cache,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,7,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *SequenceEntity) Reset() {
	*x = SequenceEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SequenceEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequenceEntity) ProtoMessage() {}

func (x *SequenceEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequenceEntity.ProtoReflect.Descriptor instead.
func (*SequenceEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{11}
}

func (x *SequenceEntity) GetIncrement() int64 {
	if x != nil {
		return x.Increment
	}
	return 0
}

func (x *SequenceEntity) GetStartValue() []byte {
	if x != nil {
		return x.StartValue
	}
	return nil
}

func (x *SequenceEntity) GetMaxValue() []byte {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *SequenceEntity) GetMinValue() []byte {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *SequenceEntity) GetCycle() bool {
	if x != nil {
		return x.Cycle
	}
	return false
}

func (x *SequenceEntity) GetCache() int64 {
	if x != nil {
		return x.Cache
	}
	return 0
}

func (x *SequenceEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Stored procedure's parent is a schema.
type StoredProcedureEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the stored procedure.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *StoredProcedureEntity) Reset() {
	*x = StoredProcedureEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredProcedureEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredProcedureEntity) ProtoMessage() {}

func (x *StoredProcedureEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredProcedureEntity.ProtoReflect.Descriptor instead.
func (*StoredProcedureEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{12}
}

func (x *StoredProcedureEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *StoredProcedureEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Function's parent is a schema.
type FunctionEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the function.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *FunctionEntity) Reset() {
	*x = FunctionEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionEntity) ProtoMessage() {}

func (x *FunctionEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionEntity.ProtoReflect.Descriptor instead.
func (*FunctionEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{13}
}

func (x *FunctionEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *FunctionEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Synonym's parent is a schema.
type SynonymEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the entity for which the synonym is being created (the source).
	SourceEntity string `protobuf:"bytes,1,opt,name=source_entity,json=sourceEntity,proto3" json:"source_entity,omitempty"`
	// The type of the entity for which the synonym is being created
	// (usually a table or a sequence).
	SourceType DatabaseEntityType `protobuf:"varint,2,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"source_type,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,3,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *SynonymEntity) Reset() {
	*x = SynonymEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynonymEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynonymEntity) ProtoMessage() {}

func (x *SynonymEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynonymEntity.ProtoReflect.Descriptor instead.
func (*SynonymEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{14}
}

func (x *SynonymEntity) GetSourceEntity() string {
	if x != nil {
		return x.SourceEntity
	}
	return ""
}

func (x *SynonymEntity) GetSourceType() DatabaseEntityType {
	if x != nil {
		return x.SourceType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *SynonymEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Package's parent is a schema.
type PackageEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the package.
	PackageSqlCode string `protobuf:"bytes,1,opt,name=package_sql_code,json=packageSqlCode,proto3" json:"package_sql_code,omitempty"`
	// The SQL code which creates the package body. If the package specification
	// has cursors or subprograms, then the package body is mandatory.
	PackageBody string `protobuf:"bytes,2,opt,name=package_body,json=packageBody,proto3" json:"package_body,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,3,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *PackageEntity) Reset() {
	*x = PackageEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageEntity) ProtoMessage() {}

func (x *PackageEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageEntity.ProtoReflect.Descriptor instead.
func (*PackageEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{15}
}

func (x *PackageEntity) GetPackageSqlCode() string {
	if x != nil {
		return x.PackageSqlCode
	}
	return ""
}

func (x *PackageEntity) GetPackageBody() string {
	if x != nil {
		return x.PackageBody
	}
	return ""
}

func (x *PackageEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Details of the mappings of a database entity.
type EntityMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source entity full name.
	// The source entity can also be a column, index or constraint using the
	// same naming notation schema.table.column.
	SourceEntity string `protobuf:"bytes,1,opt,name=source_entity,json=sourceEntity,proto3" json:"source_entity,omitempty"`
	// Target entity full name.
	// The draft entity can also include a column, index or constraint using the
	// same naming notation schema.table.column.
	DraftEntity string `protobuf:"bytes,2,opt,name=draft_entity,json=draftEntity,proto3" json:"draft_entity,omitempty"`
	// Type of source entity.
	SourceType DatabaseEntityType `protobuf:"varint,4,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"source_type,omitempty"`
	// Type of draft entity.
	DraftType DatabaseEntityType `protobuf:"varint,5,opt,name=draft_type,json=draftType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"draft_type,omitempty"`
	// Entity mapping log entries.
	// Multiple rules can be effective and contribute changes to a converted
	// entity, such as a rule can handle the entity name, another rule can handle
	// an entity type. In addition, rules which did not change the entity are also
	// logged along with the reason preventing them to do so.
	MappingLog []*EntityMappingLogEntry `protobuf:"bytes,3,rep,name=mapping_log,json=mappingLog,proto3" json:"mapping_log,omitempty"`
}

func (x *EntityMapping) Reset() {
	*x = EntityMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMapping) ProtoMessage() {}

func (x *EntityMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMapping.ProtoReflect.Descriptor instead.
func (*EntityMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{16}
}

func (x *EntityMapping) GetSourceEntity() string {
	if x != nil {
		return x.SourceEntity
	}
	return ""
}

func (x *EntityMapping) GetDraftEntity() string {
	if x != nil {
		return x.DraftEntity
	}
	return ""
}

func (x *EntityMapping) GetSourceType() DatabaseEntityType {
	if x != nil {
		return x.SourceType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *EntityMapping) GetDraftType() DatabaseEntityType {
	if x != nil {
		return x.DraftType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *EntityMapping) GetMappingLog() []*EntityMappingLogEntry {
	if x != nil {
		return x.MappingLog
	}
	return nil
}

// A single record of a rule which was used for a mapping.
type EntityMappingLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which rule caused this log entry.
	RuleId string `protobuf:"bytes,1,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Rule revision ID.
	RuleRevisionId string `protobuf:"bytes,2,opt,name=rule_revision_id,json=ruleRevisionId,proto3" json:"rule_revision_id,omitempty"`
	// Comment.
	MappingComment string `protobuf:"bytes,3,opt,name=mapping_comment,json=mappingComment,proto3" json:"mapping_comment,omitempty"`
}

func (x *EntityMappingLogEntry) Reset() {
	*x = EntityMappingLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityMappingLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMappingLogEntry) ProtoMessage() {}

func (x *EntityMappingLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMappingLogEntry.ProtoReflect.Descriptor instead.
func (*EntityMappingLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{17}
}

func (x *EntityMappingLogEntry) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *EntityMappingLogEntry) GetRuleRevisionId() string {
	if x != nil {
		return x.RuleRevisionId
	}
	return ""
}

func (x *EntityMappingLogEntry) GetMappingComment() string {
	if x != nil {
		return x.MappingComment
	}
	return ""
}

// Details regarding a Seed background job.
type BackgroundJobLogEntry_SeedJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The connection profile which was used for the seed job.
	ConnectionProfile string `protobuf:"bytes,1,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
}

func (x *BackgroundJobLogEntry_SeedJobDetails) Reset() {
	*x = BackgroundJobLogEntry_SeedJobDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackgroundJobLogEntry_SeedJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_SeedJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_SeedJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_SeedJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_SeedJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *BackgroundJobLogEntry_SeedJobDetails) GetConnectionProfile() string {
	if x != nil {
		return x.ConnectionProfile
	}
	return ""
}

// Details regarding an Import Rules background job.
type BackgroundJobLogEntry_ImportRulesJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File names used for the import rules job.
	Files []string `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// The requested file format.
	FileFormat ImportRulesFileFormat `protobuf:"varint,2,opt,name=file_format,json=fileFormat,proto3,enum=google.cloud.clouddms.v1.ImportRulesFileFormat" json:"file_format,omitempty"`
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) Reset() {
	*x = BackgroundJobLogEntry_ImportRulesJobDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_ImportRulesJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_ImportRulesJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_ImportRulesJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 1}
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) GetFiles() []string {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) GetFileFormat() ImportRulesFileFormat {
	if x != nil {
		return x.FileFormat
	}
	return ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
}

// Details regarding a Convert background job.
type BackgroundJobLogEntry_ConvertJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AIP-160 based filter used to specify the entities to convert
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *BackgroundJobLogEntry_ConvertJobDetails) Reset() {
	*x = BackgroundJobLogEntry_ConvertJobDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackgroundJobLogEntry_ConvertJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_ConvertJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_ConvertJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_ConvertJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_ConvertJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 2}
}

func (x *BackgroundJobLogEntry_ConvertJobDetails) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Details regarding an Apply background job.
type BackgroundJobLogEntry_ApplyJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The connection profile which was used for the apply job.
	ConnectionProfile string `protobuf:"bytes,1,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// AIP-160 based filter used to specify the entities to apply
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) Reset() {
	*x = BackgroundJobLogEntry_ApplyJobDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_ApplyJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_ApplyJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_ApplyJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_ApplyJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 3}
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) GetConnectionProfile() string {
	if x != nil {
		return x.ConnectionProfile
	}
	return ""
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

var File_google_cloud_clouddms_v1_conversionworkspace_resources_proto protoreflect.FileDescriptor

var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x7a, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a, 0x06,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xe8, 0x06, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a,
	0x0a, 0x0f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x68, 0x61,
	0x73, 0x5f, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x68, 0x61, 0x73, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x41, 0x0a, 0x13,
	0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x8b, 0x01, 0xea, 0x41, 0x87, 0x01, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x22, 0xb6, 0x0a,
	0x0a, 0x15, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x46, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a,
	0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x66, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x66, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6d, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x12, 0x6a, 0x0a, 0x10, 0x73, 0x65, 0x65, 0x64, 0x5f, 0x6a, 0x6f, 0x62,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x53, 0x65, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x0e, 0x73, 0x65, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x80, 0x01, 0x0a, 0x18, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x65, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x15, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x73, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6d, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x67, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x4a, 0x6f, 0x62,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x3f, 0x0a, 0x0e, 0x53, 0x65, 0x65, 0x64, 0x4a,
	0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0x7f, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0a, 0x66,
	0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0x2b, 0x0a, 0x11, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x1a, 0x58, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x4a,
	0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x22, 0x55, 0x0a, 0x12, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x4a, 0x4f, 0x42, 0x5f, 0x43, 0x4f,
	0x4d, 0x50, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xe4, 0x07, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f,
	0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73,
	0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x45, 0x0a,
	0x04, 0x74, 0x72, 0x65, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x72, 0x65, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x08,
	0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x48, 0x00, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3d, 0x0a, 0x05, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x48, 0x00, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x46, 0x0a, 0x08, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x69, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x48, 0x00, 0x52, 0x08, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a,
	0x10, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72,
	0x65, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75,
	0x72, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x6b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x48, 0x00, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x18,
	0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x07, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x12, 0x54, 0x0a, 0x10, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x6d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x22,
	0x4d, 0x0a, 0x08, 0x54, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54,
	0x52, 0x45, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x42, 0x0d,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x50, 0x0a,
	0x0c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x40, 0x0a,
	0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22,
	0xff, 0x02, 0x0a, 0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x40, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0x3f, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x43, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0xde, 0x04, 0x0a, 0x0c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a,
	0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x1c, 0x66, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f, 0x70, 0x72,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1a, 0x66,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x72, 0x72,
	0x61, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x61, 0x72, 0x72, 0x61, 0x79, 0x12,
	0x21, 0x0a, 0x0c, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x64, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x03, 0x75, 0x64, 0x74, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73,
	0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a,
	0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x96, 0x02, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x0b,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x0d, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xb7, 0x01, 0x0a, 0x0a, 0x56, 0x69, 0x65, 0x77, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x22,
	0xf7, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x63, 0x79, 0x63, 0x6c,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x63, 0x61, 0x63, 0x68, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0x74, 0x0a, 0x15, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a,
	0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22,
	0x6d, 0x0a, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xc5,
	0x01, 0x0a, 0x0d, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x4d, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x71, 0x6c, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x42, 0x6f, 0x64, 0x79, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xc5, 0x02, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x72, 0x61, 0x66, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x4d, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x4b, 0x0a, 0x0a, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x09, 0x64, 0x72, 0x61, 0x66, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a,
	0x0b, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0a, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x22,
	0x83, 0x01, 0x0a, 0x15, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x75, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x75, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f,
	0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x2a, 0xcd, 0x04, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45,
	0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d,
	0x41, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x55,
	0x4d, 0x4e, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45,
	0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x41, 0x54,
	0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0x05, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x41, 0x54,
	0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x10, 0x06, 0x12, 0x1d, 0x0a, 0x19, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x07, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41,
	0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x08, 0x12, 0x29, 0x0a,
	0x25, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f,
	0x43, 0x45, 0x44, 0x55, 0x52, 0x45, 0x10, 0x09, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41,
	0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x20, 0x0a, 0x1c, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x59, 0x4e, 0x4f, 0x4e, 0x59, 0x4d, 0x10, 0x0b, 0x12, 0x29, 0x0a,
	0x25, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x50,
	0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x10, 0x0c, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x41, 0x54, 0x41,
	0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x44, 0x54, 0x10, 0x0d, 0x12, 0x2a, 0x0a, 0x26, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41,
	0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d,
	0x41, 0x54, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x10, 0x0e, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45,
	0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42,
	0x41, 0x53, 0x45, 0x10, 0x0f, 0x2a, 0xd4, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x42,
	0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x23, 0x0a, 0x1f, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x4a,
	0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x53,
	0x45, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f,
	0x55, 0x4e, 0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x56, 0x45, 0x52, 0x54, 0x10, 0x02, 0x12, 0x29, 0x0a, 0x25, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52,
	0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x50,
	0x50, 0x4c, 0x59, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x03, 0x12, 0x29, 0x0a, 0x25, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f,
	0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f,
	0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x05, 0x2a, 0xad, 0x01, 0x0a,
	0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x28, 0x0a, 0x24, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54,
	0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d,
	0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x38, 0x0a, 0x34, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x48, 0x41, 0x52,
	0x42, 0x4f, 0x55, 0x52, 0x5f, 0x42, 0x52, 0x49, 0x44, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x30, 0x0a, 0x2c, 0x49, 0x4d,
	0x50, 0x4f, 0x52, 0x54, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x50, 0x47, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x42, 0xd1, 0x01, 0x0a,
	0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x21, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x70,
	0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x44, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6d, 0x73, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x4d, 0x53, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescOnce sync.Once
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData = file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc
)

func file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData)
	})
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData
}

var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_goTypes = []interface{}{
	(DatabaseEntityType)(0),                             // 0: google.cloud.clouddms.v1.DatabaseEntityType
	(BackgroundJobType)(0),                              // 1: google.cloud.clouddms.v1.BackgroundJobType
	(ImportRulesFileFormat)(0),                          // 2: google.cloud.clouddms.v1.ImportRulesFileFormat
	(BackgroundJobLogEntry_JobCompletionState)(0),       // 3: google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
	(DatabaseEntity_TreeType)(0),                        // 4: google.cloud.clouddms.v1.DatabaseEntity.TreeType
	(*DatabaseEngineInfo)(nil),                          // 5: google.cloud.clouddms.v1.DatabaseEngineInfo
	(*ConversionWorkspace)(nil),                         // 6: google.cloud.clouddms.v1.ConversionWorkspace
	(*BackgroundJobLogEntry)(nil),                       // 7: google.cloud.clouddms.v1.BackgroundJobLogEntry
	(*DatabaseEntity)(nil),                              // 8: google.cloud.clouddms.v1.DatabaseEntity
	(*SchemaEntity)(nil),                                // 9: google.cloud.clouddms.v1.SchemaEntity
	(*TableEntity)(nil),                                 // 10: google.cloud.clouddms.v1.TableEntity
	(*ColumnEntity)(nil),                                // 11: google.cloud.clouddms.v1.ColumnEntity
	(*ConstraintEntity)(nil),                            // 12: google.cloud.clouddms.v1.ConstraintEntity
	(*IndexEntity)(nil),                                 // 13: google.cloud.clouddms.v1.IndexEntity
	(*TriggerEntity)(nil),                               // 14: google.cloud.clouddms.v1.TriggerEntity
	(*ViewEntity)(nil),                                  // 15: google.cloud.clouddms.v1.ViewEntity
	(*SequenceEntity)(nil),                              // 16: google.cloud.clouddms.v1.SequenceEntity
	(*StoredProcedureEntity)(nil),                       // 17: google.cloud.clouddms.v1.StoredProcedureEntity
	(*FunctionEntity)(nil),                              // 18: google.cloud.clouddms.v1.FunctionEntity
	(*SynonymEntity)(nil),                               // 19: google.cloud.clouddms.v1.SynonymEntity
	(*PackageEntity)(nil),                               // 20: google.cloud.clouddms.v1.PackageEntity
	(*EntityMapping)(nil),                               // 21: google.cloud.clouddms.v1.EntityMapping
	(*EntityMappingLogEntry)(nil),                       // 22: google.cloud.clouddms.v1.EntityMappingLogEntry
	nil,                                                 // 23: google.cloud.clouddms.v1.ConversionWorkspace.GlobalSettingsEntry
	(*BackgroundJobLogEntry_SeedJobDetails)(nil),        // 24: google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
	(*BackgroundJobLogEntry_ImportRulesJobDetails)(nil), // 25: google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
	(*BackgroundJobLogEntry_ConvertJobDetails)(nil),     // 26: google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
	(*BackgroundJobLogEntry_ApplyJobDetails)(nil),       // 27: google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
	(DatabaseEngine)(0),                                 // 28: google.cloud.clouddms.v1.DatabaseEngine
	(*timestamppb.Timestamp)(nil),                       // 29: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                             // 30: google.protobuf.Struct
}
var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_depIdxs = []int32{
	28, // 0: google.cloud.clouddms.v1.DatabaseEngineInfo.engine:type_name -> google.cloud.clouddms.v1.DatabaseEngine
	5,  // 1: google.cloud.clouddms.v1.ConversionWorkspace.source:type_name -> google.cloud.clouddms.v1.DatabaseEngineInfo
	5,  // 2: google.cloud.clouddms.v1.ConversionWorkspace.destination:type_name -> google.cloud.clouddms.v1.DatabaseEngineInfo
	23, // 3: google.cloud.clouddms.v1.ConversionWorkspace.global_settings:type_name -> google.cloud.clouddms.v1.ConversionWorkspace.GlobalSettingsEntry
	29, // 4: google.cloud.clouddms.v1.ConversionWorkspace.latest_commit_time:type_name -> google.protobuf.Timestamp
	29, // 5: google.cloud.clouddms.v1.ConversionWorkspace.create_time:type_name -> google.protobuf.Timestamp
	29, // 6: google.cloud.clouddms.v1.ConversionWorkspace.update_time:type_name -> google.protobuf.Timestamp
	1,  // 7: google.cloud.clouddms.v1.BackgroundJobLogEntry.job_type:type_name -> google.cloud.clouddms.v1.BackgroundJobType
	29, // 8: google.cloud.clouddms.v1.BackgroundJobLogEntry.start_time:type_name -> google.protobuf.Timestamp
	29, // 9: google.cloud.clouddms.v1.BackgroundJobLogEntry.finish_time:type_name -> google.protobuf.Timestamp
	3,  // 10: google.cloud.clouddms.v1.BackgroundJobLogEntry.completion_state:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
	24, // 11: google.cloud.clouddms.v1.BackgroundJobLogEntry.seed_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
	25, // 12: google.cloud.clouddms.v1.BackgroundJobLogEntry.import_rules_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
	26, // 13: google.cloud.clouddms.v1.BackgroundJobLogEntry.convert_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
	27, // 14: google.cloud.clouddms.v1.BackgroundJobLogEntry.apply_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
	4,  // 15: google.cloud.clouddms.v1.DatabaseEntity.tree:type_name -> google.cloud.clouddms.v1.DatabaseEntity.TreeType
	0,  // 16: google.cloud.clouddms.v1.DatabaseEntity.entity_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	21, // 17: google.cloud.clouddms.v1.DatabaseEntity.mappings:type_name -> google.cloud.clouddms.v1.EntityMapping
	9,  // 18: google.cloud.clouddms.v1.DatabaseEntity.schema:type_name -> google.cloud.clouddms.v1.SchemaEntity
	10, // 19: google.cloud.clouddms.v1.DatabaseEntity.table:type_name -> google.cloud.clouddms.v1.TableEntity
	15, // 20: google.cloud.clouddms.v1.DatabaseEntity.view:type_name -> google.cloud.clouddms.v1.ViewEntity
	16, // 21: google.cloud.clouddms.v1.DatabaseEntity.sequence:type_name -> google.cloud.clouddms.v1.SequenceEntity
	17, // 22: google.cloud.clouddms.v1.DatabaseEntity.stored_procedure:type_name -> google.cloud.clouddms.v1.StoredProcedureEntity
	18, // 23: google.cloud.clouddms.v1.DatabaseEntity.database_function:type_name -> google.cloud.clouddms.v1.FunctionEntity
	19, // 24: google.cloud.clouddms.v1.DatabaseEntity.synonym:type_name -> google.cloud.clouddms.v1.SynonymEntity
	20, // 25: google.cloud.clouddms.v1.DatabaseEntity.database_package:type_name -> google.cloud.clouddms.v1.PackageEntity
	30, // 26: google.cloud.clouddms.v1.SchemaEntity.custom_features:type_name -> google.protobuf.Struct
	11, // 27: google.cloud.clouddms.v1.TableEntity.columns:type_name -> google.cloud.clouddms.v1.ColumnEntity
	12, // 28: google.cloud.clouddms.v1.TableEntity.constraints:type_name -> google.cloud.clouddms.v1.ConstraintEntity
	13, // 29: google.cloud.clouddms.v1.TableEntity.indices:type_name -> google.cloud.clouddms.v1.IndexEntity
	14, // 30: google.cloud.clouddms.v1.TableEntity.triggers:type_name -> google.cloud.clouddms.v1.TriggerEntity
	30, // 31: google.cloud.clouddms.v1.TableEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 32: google.cloud.clouddms.v1.ColumnEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 33: google.cloud.clouddms.v1.ConstraintEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 34: google.cloud.clouddms.v1.IndexEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 35: google.cloud.clouddms.v1.TriggerEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 36: google.cloud.clouddms.v1.ViewEntity.custom_features:type_name -> google.protobuf.Struct
	12, // 37: google.cloud.clouddms.v1.ViewEntity.constraints:type_name -> google.cloud.clouddms.v1.ConstraintEntity
	30, // 38: google.cloud.clouddms.v1.SequenceEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 39: google.cloud.clouddms.v1.StoredProcedureEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 40: google.cloud.clouddms.v1.FunctionEntity.custom_features:type_name -> google.protobuf.Struct
	0,  // 41: google.cloud.clouddms.v1.SynonymEntity.source_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	30, // 42: google.cloud.clouddms.v1.SynonymEntity.custom_features:type_name -> google.protobuf.Struct
	30, // 43: google.cloud.clouddms.v1.PackageEntity.custom_features:type_name -> google.protobuf.Struct
	0,  // 44: google.cloud.clouddms.v1.EntityMapping.source_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	0,  // 45: google.cloud.clouddms.v1.EntityMapping.draft_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	22, // 46: google.cloud.clouddms.v1.EntityMapping.mapping_log:type_name -> google.cloud.clouddms.v1.EntityMappingLogEntry
	2,  // 47: google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.file_format:type_name -> google.cloud.clouddms.v1.ImportRulesFileFormat
	48, // [48:48] is the sub-list for method output_type
	48, // [48:48] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_init() }
func file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_init() {
	if File_google_cloud_clouddms_v1_conversionworkspace_resources_proto != nil {
		return
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseEngineInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversionWorkspace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackgroundJobLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConstraintEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TriggerEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ViewEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SequenceEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoredProcedureEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynonymEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityMappingLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackgroundJobLogEntry_SeedJobDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackgroundJobLogEntry_ImportRulesJobDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackgroundJobLogEntry_ConvertJobDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackgroundJobLogEntry_ApplyJobDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*BackgroundJobLogEntry_SeedJobDetails_)(nil),
		(*BackgroundJobLogEntry_ImportRulesJobDetails_)(nil),
		(*BackgroundJobLogEntry_ConvertJobDetails_)(nil),
		(*BackgroundJobLogEntry_ApplyJobDetails_)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*DatabaseEntity_Schema)(nil),
		(*DatabaseEntity_Table)(nil),
		(*DatabaseEntity_View)(nil),
		(*DatabaseEntity_Sequence)(nil),
		(*DatabaseEntity_StoredProcedure)(nil),
		(*DatabaseEntity_DatabaseFunction)(nil),
		(*DatabaseEntity_Synonym)(nil),
		(*DatabaseEntity_DatabasePackage)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_clouddms_v1_conversionworkspace_resources_proto = out.File
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc = nil
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_goTypes = nil
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_depIdxs = nil
}
