// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

package vmwareenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum State defines possible states of private clouds.
type PrivateCloud_State int32

const (
	// The default value. This value should never be used.
	PrivateCloud_STATE_UNSPECIFIED PrivateCloud_State = 0
	// The private cloud is ready.
	PrivateCloud_ACTIVE PrivateCloud_State = 1
	// The private cloud is being created.
	PrivateCloud_CREATING PrivateCloud_State = 2
	// The private cloud is being updated.
	PrivateCloud_UPDATING PrivateCloud_State = 3
	// The private cloud is in failed state.
	PrivateCloud_FAILED PrivateCloud_State = 5
	// The private cloud is scheduled for deletion. The deletion process can be
	// cancelled by using the corresponding undelete method.
	PrivateCloud_DELETED PrivateCloud_State = 6
	// The private cloud is irreversibly deleted and is being removed from the
	// system.
	PrivateCloud_PURGING PrivateCloud_State = 7
)

// Enum value maps for PrivateCloud_State.
var (
	PrivateCloud_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		5: "FAILED",
		6: "DELETED",
		7: "PURGING",
	}
	PrivateCloud_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"FAILED":            5,
		"DELETED":           6,
		"PURGING":           7,
	}
)

func (x PrivateCloud_State) Enum() *PrivateCloud_State {
	p := new(PrivateCloud_State)
	*p = x
	return p
}

func (x PrivateCloud_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateCloud_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[0].Descriptor()
}

func (PrivateCloud_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[0]
}

func (x PrivateCloud_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateCloud_State.Descriptor instead.
func (PrivateCloud_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{2, 0}
}

// Enum Type defines private cloud type.
type PrivateCloud_Type int32

const (
	// Standard private is a zonal resource, with 3+ nodes. Default type.
	PrivateCloud_STANDARD PrivateCloud_Type = 0
	// Time limited private cloud is a zonal resource, can have only 1 node and
	// has limited life span. Will be deleted after defined period of time,
	// can be converted into standard private cloud by expanding it up to 3
	// or more nodes.
	PrivateCloud_TIME_LIMITED PrivateCloud_Type = 1
)

// Enum value maps for PrivateCloud_Type.
var (
	PrivateCloud_Type_name = map[int32]string{
		0: "STANDARD",
		1: "TIME_LIMITED",
	}
	PrivateCloud_Type_value = map[string]int32{
		"STANDARD":     0,
		"TIME_LIMITED": 1,
	}
)

func (x PrivateCloud_Type) Enum() *PrivateCloud_Type {
	p := new(PrivateCloud_Type)
	*p = x
	return p
}

func (x PrivateCloud_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateCloud_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[1].Descriptor()
}

func (PrivateCloud_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[1]
}

func (x PrivateCloud_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateCloud_Type.Descriptor instead.
func (PrivateCloud_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{2, 1}
}

// Enum State defines possible states of private cloud clusters.
type Cluster_State int32

const (
	// The default value. This value should never be used.
	Cluster_STATE_UNSPECIFIED Cluster_State = 0
	// The Cluster is operational and can be used by the user.
	Cluster_ACTIVE Cluster_State = 1
	// The Cluster is being deployed.
	Cluster_CREATING Cluster_State = 2
	// Adding or removing of a node to the cluster, any other cluster specific
	// updates.
	Cluster_UPDATING Cluster_State = 3
	// The Cluster is being deleted.
	Cluster_DELETING Cluster_State = 4
	// The Cluster is undergoing maintenance, for example: a failed node is
	// getting replaced.
	Cluster_REPAIRING Cluster_State = 5
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
		5: "REPAIRING",
	}
	Cluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
		"REPAIRING":         5,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[2].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[2]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{3, 0}
}

// Defines possible states of subnets.
type Subnet_State int32

const (
	// The default value. This value should never be used.
	Subnet_STATE_UNSPECIFIED Subnet_State = 0
	// The subnet is ready.
	Subnet_ACTIVE Subnet_State = 1
	// The subnet is being created.
	Subnet_CREATING Subnet_State = 2
	// The subnet is being updated.
	Subnet_UPDATING Subnet_State = 3
	// The subnet is being deleted.
	Subnet_DELETING Subnet_State = 4
	// Changes requested in the last operation are being propagated.
	Subnet_RECONCILING Subnet_State = 5
	// Last operation on the subnet did not succeed. Subnet's payload is
	// reverted back to its most recent working state.
	Subnet_FAILED Subnet_State = 6
)

// Enum value maps for Subnet_State.
var (
	Subnet_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
		5: "RECONCILING",
		6: "FAILED",
	}
	Subnet_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
		"RECONCILING":       5,
		"FAILED":            6,
	}
)

func (x Subnet_State) Enum() *Subnet_State {
	p := new(Subnet_State)
	*p = x
	return p
}

func (x Subnet_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnet_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[3].Descriptor()
}

func (Subnet_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[3]
}

func (x Subnet_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnet_State.Descriptor instead.
func (Subnet_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{4, 0}
}

// State of HCX activation key
type HcxActivationKey_State int32

const (
	// Unspecified state.
	HcxActivationKey_STATE_UNSPECIFIED HcxActivationKey_State = 0
	// State of a newly generated activation key.
	HcxActivationKey_AVAILABLE HcxActivationKey_State = 1
	// State of key when it has been used to activate HCX appliance.
	HcxActivationKey_CONSUMED HcxActivationKey_State = 2
	// State of key when it is being created.
	HcxActivationKey_CREATING HcxActivationKey_State = 3
)

// Enum value maps for HcxActivationKey_State.
var (
	HcxActivationKey_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "AVAILABLE",
		2: "CONSUMED",
		3: "CREATING",
	}
	HcxActivationKey_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"AVAILABLE":         1,
		"CONSUMED":          2,
		"CREATING":          3,
	}
)

func (x HcxActivationKey_State) Enum() *HcxActivationKey_State {
	p := new(HcxActivationKey_State)
	*p = x
	return p
}

func (x HcxActivationKey_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HcxActivationKey_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[4].Descriptor()
}

func (HcxActivationKey_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[4]
}

func (x HcxActivationKey_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HcxActivationKey_State.Descriptor instead.
func (HcxActivationKey_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{7, 0}
}

// State of the appliance
type Hcx_State int32

const (
	// Unspecified appliance state. This is the default value.
	Hcx_STATE_UNSPECIFIED Hcx_State = 0
	// The appliance is operational and can be used.
	Hcx_ACTIVE Hcx_State = 1
	// The appliance is being deployed.
	Hcx_CREATING Hcx_State = 2
)

// Enum value maps for Hcx_State.
var (
	Hcx_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Hcx_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Hcx_State) Enum() *Hcx_State {
	p := new(Hcx_State)
	*p = x
	return p
}

func (x Hcx_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Hcx_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[5].Descriptor()
}

func (Hcx_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[5]
}

func (x Hcx_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Hcx_State.Descriptor instead.
func (Hcx_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{8, 0}
}

// State of the appliance
type Nsx_State int32

const (
	// Unspecified appliance state. This is the default value.
	Nsx_STATE_UNSPECIFIED Nsx_State = 0
	// The appliance is operational and can be used.
	Nsx_ACTIVE Nsx_State = 1
	// The appliance is being deployed.
	Nsx_CREATING Nsx_State = 2
)

// Enum value maps for Nsx_State.
var (
	Nsx_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Nsx_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Nsx_State) Enum() *Nsx_State {
	p := new(Nsx_State)
	*p = x
	return p
}

func (x Nsx_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Nsx_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[6].Descriptor()
}

func (Nsx_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[6]
}

func (x Nsx_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Nsx_State.Descriptor instead.
func (Nsx_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{9, 0}
}

// State of the appliance
type Vcenter_State int32

const (
	// Unspecified appliance state. This is the default value.
	Vcenter_STATE_UNSPECIFIED Vcenter_State = 0
	// The appliance is operational and can be used.
	Vcenter_ACTIVE Vcenter_State = 1
	// The appliance is being deployed.
	Vcenter_CREATING Vcenter_State = 2
)

// Enum value maps for Vcenter_State.
var (
	Vcenter_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Vcenter_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Vcenter_State) Enum() *Vcenter_State {
	p := new(Vcenter_State)
	*p = x
	return p
}

func (x Vcenter_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Vcenter_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[7].Descriptor()
}

func (Vcenter_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[7]
}

func (x Vcenter_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Vcenter_State.Descriptor instead.
func (Vcenter_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{10, 0}
}

// The type of the peering route.
type PeeringRoute_Type int32

const (
	// Unspecified peering route type. This is the default value.
	PeeringRoute_TYPE_UNSPECIFIED PeeringRoute_Type = 0
	// Dynamic routes in the peer network.
	PeeringRoute_DYNAMIC_PEERING_ROUTE PeeringRoute_Type = 1
	// Static routes in the peer network.
	PeeringRoute_STATIC_PEERING_ROUTE PeeringRoute_Type = 2
	// Created, updated, and removed automatically by Google Cloud when subnets
	// are created, modified, or deleted in the peer network.
	PeeringRoute_SUBNET_PEERING_ROUTE PeeringRoute_Type = 3
)

// Enum value maps for PeeringRoute_Type.
var (
	PeeringRoute_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DYNAMIC_PEERING_ROUTE",
		2: "STATIC_PEERING_ROUTE",
		3: "SUBNET_PEERING_ROUTE",
	}
	PeeringRoute_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":      0,
		"DYNAMIC_PEERING_ROUTE": 1,
		"STATIC_PEERING_ROUTE":  2,
		"SUBNET_PEERING_ROUTE":  3,
	}
)

func (x PeeringRoute_Type) Enum() *PeeringRoute_Type {
	p := new(PeeringRoute_Type)
	*p = x
	return p
}

func (x PeeringRoute_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeeringRoute_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[8].Descriptor()
}

func (PeeringRoute_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[8]
}

func (x PeeringRoute_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeeringRoute_Type.Descriptor instead.
func (PeeringRoute_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{11, 0}
}

// The direction of the exchanged routes.
type PeeringRoute_Direction int32

const (
	// Unspecified exchanged routes direction. This is default.
	PeeringRoute_DIRECTION_UNSPECIFIED PeeringRoute_Direction = 0
	// Routes imported from the peer network.
	PeeringRoute_INCOMING PeeringRoute_Direction = 1
	// Routes exported to the peer network.
	PeeringRoute_OUTGOING PeeringRoute_Direction = 2
)

// Enum value maps for PeeringRoute_Direction.
var (
	PeeringRoute_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "INCOMING",
		2: "OUTGOING",
	}
	PeeringRoute_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"INCOMING":              1,
		"OUTGOING":              2,
	}
)

func (x PeeringRoute_Direction) Enum() *PeeringRoute_Direction {
	p := new(PeeringRoute_Direction)
	*p = x
	return p
}

func (x PeeringRoute_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeeringRoute_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[9].Descriptor()
}

func (PeeringRoute_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[9]
}

func (x PeeringRoute_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeeringRoute_Direction.Descriptor instead.
func (PeeringRoute_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{11, 1}
}

// Enum State defines possible states of a network policy controlled
// service.
type NetworkPolicy_NetworkService_State int32

const (
	// Unspecified service state. This is the default value.
	NetworkPolicy_NetworkService_STATE_UNSPECIFIED NetworkPolicy_NetworkService_State = 0
	// Service is not provisioned.
	NetworkPolicy_NetworkService_UNPROVISIONED NetworkPolicy_NetworkService_State = 1
	// Service is in the process of being provisioned/deprovisioned.
	NetworkPolicy_NetworkService_RECONCILING NetworkPolicy_NetworkService_State = 2
	// Service is active.
	NetworkPolicy_NetworkService_ACTIVE NetworkPolicy_NetworkService_State = 3
)

// Enum value maps for NetworkPolicy_NetworkService_State.
var (
	NetworkPolicy_NetworkService_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNPROVISIONED",
		2: "RECONCILING",
		3: "ACTIVE",
	}
	NetworkPolicy_NetworkService_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNPROVISIONED":     1,
		"RECONCILING":       2,
		"ACTIVE":            3,
	}
)

func (x NetworkPolicy_NetworkService_State) Enum() *NetworkPolicy_NetworkService_State {
	p := new(NetworkPolicy_NetworkService_State)
	*p = x
	return p
}

func (x NetworkPolicy_NetworkService_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicy_NetworkService_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[10].Descriptor()
}

func (NetworkPolicy_NetworkService_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[10]
}

func (x NetworkPolicy_NetworkService_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicy_NetworkService_State.Descriptor instead.
func (NetworkPolicy_NetworkService_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{12, 0, 0}
}

// Enum State defines possible states of VMware Engine network.
type VmwareEngineNetwork_State int32

const (
	// The default value. This value is used if the state is omitted.
	VmwareEngineNetwork_STATE_UNSPECIFIED VmwareEngineNetwork_State = 0
	// The VMware Engine network is being created.
	VmwareEngineNetwork_CREATING VmwareEngineNetwork_State = 1
	// The VMware Engine network is ready.
	VmwareEngineNetwork_ACTIVE VmwareEngineNetwork_State = 2
	// The VMware Engine network is being updated.
	VmwareEngineNetwork_UPDATING VmwareEngineNetwork_State = 3
	// The VMware Engine network is being deleted.
	VmwareEngineNetwork_DELETING VmwareEngineNetwork_State = 4
)

// Enum value maps for VmwareEngineNetwork_State.
var (
	VmwareEngineNetwork_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	VmwareEngineNetwork_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x VmwareEngineNetwork_State) Enum() *VmwareEngineNetwork_State {
	p := new(VmwareEngineNetwork_State)
	*p = x
	return p
}

func (x VmwareEngineNetwork_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[11].Descriptor()
}

func (VmwareEngineNetwork_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[11]
}

func (x VmwareEngineNetwork_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_State.Descriptor instead.
func (VmwareEngineNetwork_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13, 0}
}

// Enum Type defines possible types of VMware Engine network.
type VmwareEngineNetwork_Type int32

const (
	// The default value. This value should never be used.
	VmwareEngineNetwork_TYPE_UNSPECIFIED VmwareEngineNetwork_Type = 0
	// Network type used by private clouds created in projects without a network
	// of type `STANDARD`. This network type is no longer used for new VMware
	// Engine private cloud deployments.
	VmwareEngineNetwork_LEGACY VmwareEngineNetwork_Type = 1
)

// Enum value maps for VmwareEngineNetwork_Type.
var (
	VmwareEngineNetwork_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "LEGACY",
	}
	VmwareEngineNetwork_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"LEGACY":           1,
	}
)

func (x VmwareEngineNetwork_Type) Enum() *VmwareEngineNetwork_Type {
	p := new(VmwareEngineNetwork_Type)
	*p = x
	return p
}

func (x VmwareEngineNetwork_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[12].Descriptor()
}

func (VmwareEngineNetwork_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[12]
}

func (x VmwareEngineNetwork_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_Type.Descriptor instead.
func (VmwareEngineNetwork_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13, 1}
}

// Enum Type defines possible types of a VMware Engine network controlled
// service.
type VmwareEngineNetwork_VpcNetwork_Type int32

const (
	// The default value. This value should never be used.
	VmwareEngineNetwork_VpcNetwork_TYPE_UNSPECIFIED VmwareEngineNetwork_VpcNetwork_Type = 0
	// VPC network that will be peered with a consumer VPC network or the
	// intranet VPC of another VMware Engine network. Access a private cloud
	// through Compute Engine VMs on a peered VPC network or an on-premises
	// resource connected to a peered consumer VPC network.
	VmwareEngineNetwork_VpcNetwork_INTRANET VmwareEngineNetwork_VpcNetwork_Type = 1
	// VPC network used for internet access to and from a private cloud.
	VmwareEngineNetwork_VpcNetwork_INTERNET VmwareEngineNetwork_VpcNetwork_Type = 2
	// VPC network used for access to Google Cloud services like
	// Cloud Storage.
	VmwareEngineNetwork_VpcNetwork_GOOGLE_CLOUD VmwareEngineNetwork_VpcNetwork_Type = 3
)

// Enum value maps for VmwareEngineNetwork_VpcNetwork_Type.
var (
	VmwareEngineNetwork_VpcNetwork_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INTRANET",
		2: "INTERNET",
		3: "GOOGLE_CLOUD",
	}
	VmwareEngineNetwork_VpcNetwork_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"INTRANET":         1,
		"INTERNET":         2,
		"GOOGLE_CLOUD":     3,
	}
)

func (x VmwareEngineNetwork_VpcNetwork_Type) Enum() *VmwareEngineNetwork_VpcNetwork_Type {
	p := new(VmwareEngineNetwork_VpcNetwork_Type)
	*p = x
	return p
}

func (x VmwareEngineNetwork_VpcNetwork_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_VpcNetwork_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[13].Descriptor()
}

func (VmwareEngineNetwork_VpcNetwork_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[13]
}

func (x VmwareEngineNetwork_VpcNetwork_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_VpcNetwork_Type.Descriptor instead.
func (VmwareEngineNetwork_VpcNetwork_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13, 0, 0}
}

// Enum State defines possible states of private connection.
type PrivateConnection_State int32

const (
	// The default value. This value is used if the state is omitted.
	PrivateConnection_STATE_UNSPECIFIED PrivateConnection_State = 0
	// The private connection is being created.
	PrivateConnection_CREATING PrivateConnection_State = 1
	// The private connection is ready.
	PrivateConnection_ACTIVE PrivateConnection_State = 2
	// The private connection is being updated.
	PrivateConnection_UPDATING PrivateConnection_State = 3
	// The private connection is being deleted.
	PrivateConnection_DELETING PrivateConnection_State = 4
	// The private connection is not provisioned, since no private cloud is
	// present for which this private connection is needed.
	PrivateConnection_UNPROVISIONED PrivateConnection_State = 5
	// The private connection is in failed state.
	PrivateConnection_FAILED PrivateConnection_State = 6
)

// Enum value maps for PrivateConnection_State.
var (
	PrivateConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
		5: "UNPROVISIONED",
		6: "FAILED",
	}
	PrivateConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
		"UNPROVISIONED":     5,
		"FAILED":            6,
	}
)

func (x PrivateConnection_State) Enum() *PrivateConnection_State {
	p := new(PrivateConnection_State)
	*p = x
	return p
}

func (x PrivateConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[14].Descriptor()
}

func (PrivateConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[14]
}

func (x PrivateConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_State.Descriptor instead.
func (PrivateConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14, 0}
}

// Enum Type defines possible types of private connection.
type PrivateConnection_Type int32

const (
	// The default value. This value should never be used.
	PrivateConnection_TYPE_UNSPECIFIED PrivateConnection_Type = 0
	// Connection used for establishing [private services
	// access](https://cloud.google.com/vpc/docs/private-services-access).
	PrivateConnection_PRIVATE_SERVICE_ACCESS PrivateConnection_Type = 1
	// Connection used for connecting to NetApp Cloud Volumes.
	PrivateConnection_NETAPP_CLOUD_VOLUMES PrivateConnection_Type = 2
	// Connection used for connecting to Dell PowerScale.
	PrivateConnection_DELL_POWERSCALE PrivateConnection_Type = 3
	// Connection used for connecting to third-party services.
	PrivateConnection_THIRD_PARTY_SERVICE PrivateConnection_Type = 4
)

// Enum value maps for PrivateConnection_Type.
var (
	PrivateConnection_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PRIVATE_SERVICE_ACCESS",
		2: "NETAPP_CLOUD_VOLUMES",
		3: "DELL_POWERSCALE",
		4: "THIRD_PARTY_SERVICE",
	}
	PrivateConnection_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":       0,
		"PRIVATE_SERVICE_ACCESS": 1,
		"NETAPP_CLOUD_VOLUMES":   2,
		"DELL_POWERSCALE":        3,
		"THIRD_PARTY_SERVICE":    4,
	}
)

func (x PrivateConnection_Type) Enum() *PrivateConnection_Type {
	p := new(PrivateConnection_Type)
	*p = x
	return p
}

func (x PrivateConnection_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[15].Descriptor()
}

func (PrivateConnection_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[15]
}

func (x PrivateConnection_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_Type.Descriptor instead.
func (PrivateConnection_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14, 1}
}

// Possible types for RoutingMode
type PrivateConnection_RoutingMode int32

const (
	// The default value. This value should never be used.
	PrivateConnection_ROUTING_MODE_UNSPECIFIED PrivateConnection_RoutingMode = 0
	// Global Routing Mode
	PrivateConnection_GLOBAL PrivateConnection_RoutingMode = 1
	// Regional Routing Mode
	PrivateConnection_REGIONAL PrivateConnection_RoutingMode = 2
)

// Enum value maps for PrivateConnection_RoutingMode.
var (
	PrivateConnection_RoutingMode_name = map[int32]string{
		0: "ROUTING_MODE_UNSPECIFIED",
		1: "GLOBAL",
		2: "REGIONAL",
	}
	PrivateConnection_RoutingMode_value = map[string]int32{
		"ROUTING_MODE_UNSPECIFIED": 0,
		"GLOBAL":                   1,
		"REGIONAL":                 2,
	}
)

func (x PrivateConnection_RoutingMode) Enum() *PrivateConnection_RoutingMode {
	p := new(PrivateConnection_RoutingMode)
	*p = x
	return p
}

func (x PrivateConnection_RoutingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_RoutingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[16].Descriptor()
}

func (PrivateConnection_RoutingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[16]
}

func (x PrivateConnection_RoutingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_RoutingMode.Descriptor instead.
func (PrivateConnection_RoutingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14, 2}
}

// Enum PeeringState defines the possible states of peering between service
// network and the vpc network peered to service network
type PrivateConnection_PeeringState int32

const (
	// The default value. This value is used if the peering state is omitted or
	// unknown.
	PrivateConnection_PEERING_STATE_UNSPECIFIED PrivateConnection_PeeringState = 0
	// The peering is in active state.
	PrivateConnection_PEERING_ACTIVE PrivateConnection_PeeringState = 1
	// The peering is in inactive state.
	PrivateConnection_PEERING_INACTIVE PrivateConnection_PeeringState = 2
)

// Enum value maps for PrivateConnection_PeeringState.
var (
	PrivateConnection_PeeringState_name = map[int32]string{
		0: "PEERING_STATE_UNSPECIFIED",
		1: "PEERING_ACTIVE",
		2: "PEERING_INACTIVE",
	}
	PrivateConnection_PeeringState_value = map[string]int32{
		"PEERING_STATE_UNSPECIFIED": 0,
		"PEERING_ACTIVE":            1,
		"PEERING_INACTIVE":          2,
	}
)

func (x PrivateConnection_PeeringState) Enum() *PrivateConnection_PeeringState {
	p := new(PrivateConnection_PeeringState)
	*p = x
	return p
}

func (x PrivateConnection_PeeringState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_PeeringState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[17].Descriptor()
}

func (PrivateConnection_PeeringState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes[17]
}

func (x PrivateConnection_PeeringState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_PeeringState.Descriptor instead.
func (PrivateConnection_PeeringState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14, 3}
}

// Network configuration in the consumer project
// with which the peering has to be done.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Management CIDR used by VMware management appliances.
	ManagementCidr string `protobuf:"bytes,4,opt,name=management_cidr,json=managementCidr,proto3" json:"management_cidr,omitempty"`
	// Optional. The relative resource name of the VMware Engine network attached
	// to the private cloud. Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,5,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,6,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
	// Output only. The IP address layout version of the management IP address
	// range. Possible versions include:
	// * `managementIpAddressLayoutVersion=1`: Indicates the legacy IP address
	// layout used by some existing private clouds. This is no longer supported
	// for new private clouds as it does not support all features.
	// * `managementIpAddressLayoutVersion=2`: Indicates the latest IP address
	// layout used by all newly created private clouds. This version supports all
	// current features.
	ManagementIpAddressLayoutVersion int32 `protobuf:"varint,8,opt,name=management_ip_address_layout_version,json=managementIpAddressLayoutVersion,proto3" json:"management_ip_address_layout_version,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkConfig) GetManagementCidr() string {
	if x != nil {
		return x.ManagementCidr
	}
	return ""
}

func (x *NetworkConfig) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkConfig) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

func (x *NetworkConfig) GetManagementIpAddressLayoutVersion() int32 {
	if x != nil {
		return x.ManagementIpAddressLayoutVersion
	}
	return 0
}

// Information about the type and number of nodes associated with the cluster.
type NodeTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The number of nodes of this type in the cluster
	NodeCount int32 `protobuf:"varint,1,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Optional. Customized number of cores available to each node of the type.
	// This number must always be one of `nodeType.availableCustomCoreCounts`.
	// If zero is provided max value from `nodeType.availableCustomCoreCounts`
	// will be used.
	CustomCoreCount int32 `protobuf:"varint,2,opt,name=custom_core_count,json=customCoreCount,proto3" json:"custom_core_count,omitempty"`
}

func (x *NodeTypeConfig) Reset() {
	*x = NodeTypeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTypeConfig) ProtoMessage() {}

func (x *NodeTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTypeConfig.ProtoReflect.Descriptor instead.
func (*NodeTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{1}
}

func (x *NodeTypeConfig) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *NodeTypeConfig) GetCustomCoreCount() int32 {
	if x != nil {
		return x.CustomCoreCount
	}
	return 0
}

// Represents a private cloud resource. Private clouds are zonal resources.
type PrivateCloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this private cloud.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time when the resource was scheduled for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. Time when the resource will be irreversibly deleted.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. State of the resource. New values may be added to this enum
	// when appropriate.
	State PrivateCloud_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.PrivateCloud_State" json:"state,omitempty"`
	// Required. Network configuration of the private cloud.
	NetworkConfig *NetworkConfig `protobuf:"bytes,9,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Required. Input only. The management cluster for this private cloud.
	// This field is required during creation of the private cloud to provide
	// details for the default cluster.
	//
	// The following fields can't be changed after private cloud creation:
	// `ManagementCluster.clusterId`, `ManagementCluster.nodeTypeId`.
	ManagementCluster *PrivateCloud_ManagementCluster `protobuf:"bytes,10,opt,name=management_cluster,json=managementCluster,proto3" json:"management_cluster,omitempty"`
	// User-provided description for this private cloud.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. HCX appliance.
	Hcx *Hcx `protobuf:"bytes,17,opt,name=hcx,proto3" json:"hcx,omitempty"`
	// Output only. NSX appliance.
	Nsx *Nsx `protobuf:"bytes,18,opt,name=nsx,proto3" json:"nsx,omitempty"`
	// Output only. Vcenter appliance.
	Vcenter *Vcenter `protobuf:"bytes,19,opt,name=vcenter,proto3" json:"vcenter,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,20,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Type of the private cloud. Defaults to STANDARD.
	Type PrivateCloud_Type `protobuf:"varint,22,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.PrivateCloud_Type" json:"type,omitempty"`
}

func (x *PrivateCloud) Reset() {
	*x = PrivateCloud{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateCloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateCloud) ProtoMessage() {}

func (x *PrivateCloud) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateCloud.ProtoReflect.Descriptor instead.
func (*PrivateCloud) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{2}
}

func (x *PrivateCloud) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateCloud) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateCloud) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateCloud) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *PrivateCloud) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *PrivateCloud) GetState() PrivateCloud_State {
	if x != nil {
		return x.State
	}
	return PrivateCloud_STATE_UNSPECIFIED
}

func (x *PrivateCloud) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (x *PrivateCloud) GetManagementCluster() *PrivateCloud_ManagementCluster {
	if x != nil {
		return x.ManagementCluster
	}
	return nil
}

func (x *PrivateCloud) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PrivateCloud) GetHcx() *Hcx {
	if x != nil {
		return x.Hcx
	}
	return nil
}

func (x *PrivateCloud) GetNsx() *Nsx {
	if x != nil {
		return x.Nsx
	}
	return nil
}

func (x *PrivateCloud) GetVcenter() *Vcenter {
	if x != nil {
		return x.Vcenter
	}
	return nil
}

func (x *PrivateCloud) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PrivateCloud) GetType() PrivateCloud_Type {
	if x != nil {
		return x.Type
	}
	return PrivateCloud_STANDARD
}

// A cluster in a private cloud.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this cluster.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the resource.
	State Cluster_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Cluster_State" json:"state,omitempty"`
	// Output only. True if the cluster is a management cluster; false otherwise.
	// There can only be one management cluster in a private cloud
	// and it has to be the first one.
	Management bool `protobuf:"varint,7,opt,name=management,proto3" json:"management,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,14,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The map of cluster node types in this cluster, where the key is
	// canonical identifier of the node type (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]*NodeTypeConfig `protobuf:"bytes,16,rep,name=node_type_configs,json=nodeTypeConfigs,proto3" json:"node_type_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_UNSPECIFIED
}

func (x *Cluster) GetManagement() bool {
	if x != nil {
		return x.Management
	}
	return false
}

func (x *Cluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Cluster) GetNodeTypeConfigs() map[string]*NodeTypeConfig {
	if x != nil {
		return x.NodeTypeConfigs
	}
	return nil
}

// Subnet in a private cloud. Either `management` subnets (such as vMotion) that
// are read-only, or `userDefined`, which can also be updated.
type Subnet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this subnet.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The IP address range of the subnet in CIDR format '10.0.0.0/24'.
	IpCidrRange string `protobuf:"bytes,7,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// The IP address of the gateway of this subnet.
	// Must fall within the IP prefix defined above.
	GatewayIp string `protobuf:"bytes,8,opt,name=gateway_ip,json=gatewayIp,proto3" json:"gateway_ip,omitempty"`
	// Output only. The type of the subnet. For example "management" or
	// "userDefined".
	Type string `protobuf:"bytes,11,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The state of the resource.
	State Subnet_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Subnet_State" json:"state,omitempty"`
}

func (x *Subnet) Reset() {
	*x = Subnet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subnet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subnet) ProtoMessage() {}

func (x *Subnet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subnet.ProtoReflect.Descriptor instead.
func (*Subnet) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Subnet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subnet) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *Subnet) GetGatewayIp() string {
	if x != nil {
		return x.GatewayIp
	}
	return ""
}

func (x *Subnet) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Subnet) GetState() Subnet_State {
	if x != nil {
		return x.State
	}
	return Subnet_STATE_UNSPECIFIED
}

// Describes node type.
type NodeType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this node type.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The canonical identifier of the node type
	// (corresponds to the `NodeType`). For example: standard-72.
	NodeTypeId string `protobuf:"bytes,2,opt,name=node_type_id,json=nodeTypeId,proto3" json:"node_type_id,omitempty"`
	// Output only. The friendly name for this node type.
	// For example: ve1-standard-72
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The total number of virtual CPUs in a single node.
	VirtualCpuCount int32 `protobuf:"varint,4,opt,name=virtual_cpu_count,json=virtualCpuCount,proto3" json:"virtual_cpu_count,omitempty"`
	// Output only. The total number of CPU cores in a single node.
	TotalCoreCount int32 `protobuf:"varint,5,opt,name=total_core_count,json=totalCoreCount,proto3" json:"total_core_count,omitempty"`
	// Output only. The amount of physical memory available, defined in GB.
	MemoryGb int32 `protobuf:"varint,7,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// Output only. The amount of storage available, defined in GB.
	DiskSizeGb int32 `protobuf:"varint,8,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Output only. List of possible values of custom core count.
	AvailableCustomCoreCounts []int32 `protobuf:"varint,11,rep,packed,name=available_custom_core_counts,json=availableCustomCoreCounts,proto3" json:"available_custom_core_counts,omitempty"`
}

func (x *NodeType) Reset() {
	*x = NodeType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeType) ProtoMessage() {}

func (x *NodeType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeType.ProtoReflect.Descriptor instead.
func (*NodeType) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{5}
}

func (x *NodeType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodeType) GetNodeTypeId() string {
	if x != nil {
		return x.NodeTypeId
	}
	return ""
}

func (x *NodeType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NodeType) GetVirtualCpuCount() int32 {
	if x != nil {
		return x.VirtualCpuCount
	}
	return 0
}

func (x *NodeType) GetTotalCoreCount() int32 {
	if x != nil {
		return x.TotalCoreCount
	}
	return 0
}

func (x *NodeType) GetMemoryGb() int32 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *NodeType) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *NodeType) GetAvailableCustomCoreCounts() []int32 {
	if x != nil {
		return x.AvailableCustomCoreCounts
	}
	return nil
}

// Credentials for a private cloud.
type Credentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Initial username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Initial password.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *Credentials) Reset() {
	*x = Credentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Credentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Credentials) ProtoMessage() {}

func (x *Credentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Credentials.ProtoReflect.Descriptor instead.
func (*Credentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{6}
}

func (x *Credentials) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Credentials) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// HCX activation key. A default key is created during
// private cloud provisioning, but this behavior is subject to change
// and you should always verify active keys.
// Use
// [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys]
// to retrieve existing keys and
// [VmwareEngine.CreateHcxActivationKey][google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey]
// to create new ones.
type HcxActivationKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this HcxActivationKey.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of HCX activation key.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. State of HCX activation key.
	State HcxActivationKey_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.HcxActivationKey_State" json:"state,omitempty"`
	// Output only. HCX activation key.
	ActivationKey string `protobuf:"bytes,4,opt,name=activation_key,json=activationKey,proto3" json:"activation_key,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *HcxActivationKey) Reset() {
	*x = HcxActivationKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HcxActivationKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HcxActivationKey) ProtoMessage() {}

func (x *HcxActivationKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HcxActivationKey.ProtoReflect.Descriptor instead.
func (*HcxActivationKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{7}
}

func (x *HcxActivationKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HcxActivationKey) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *HcxActivationKey) GetState() HcxActivationKey_State {
	if x != nil {
		return x.State
	}
	return HcxActivationKey_STATE_UNSPECIFIED
}

func (x *HcxActivationKey) GetActivationKey() string {
	if x != nil {
		return x.ActivationKey
	}
	return ""
}

func (x *HcxActivationKey) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Details about a HCX Cloud Manager appliance.
type Hcx struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Hcx_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Hcx_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Hcx) Reset() {
	*x = Hcx{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hcx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hcx) ProtoMessage() {}

func (x *Hcx) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hcx.ProtoReflect.Descriptor instead.
func (*Hcx) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{8}
}

func (x *Hcx) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Hcx) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Hcx) GetState() Hcx_State {
	if x != nil {
		return x.State
	}
	return Hcx_STATE_UNSPECIFIED
}

func (x *Hcx) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Details about a NSX Manager appliance.
type Nsx struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Nsx_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Nsx_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Nsx) Reset() {
	*x = Nsx{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Nsx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Nsx) ProtoMessage() {}

func (x *Nsx) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Nsx.ProtoReflect.Descriptor instead.
func (*Nsx) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{9}
}

func (x *Nsx) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Nsx) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Nsx) GetState() Nsx_State {
	if x != nil {
		return x.State
	}
	return Nsx_STATE_UNSPECIFIED
}

func (x *Nsx) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Details about a vCenter Server management appliance.
type Vcenter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Vcenter_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Vcenter_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Vcenter) Reset() {
	*x = Vcenter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vcenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vcenter) ProtoMessage() {}

func (x *Vcenter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vcenter.ProtoReflect.Descriptor instead.
func (*Vcenter) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{10}
}

func (x *Vcenter) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Vcenter) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Vcenter) GetState() Vcenter_State {
	if x != nil {
		return x.State
	}
	return Vcenter_STATE_UNSPECIFIED
}

func (x *Vcenter) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Exchanged network peering route.
type PeeringRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Destination range of the peering route in CIDR notation.
	DestRange string `protobuf:"bytes,1,opt,name=dest_range,json=destRange,proto3" json:"dest_range,omitempty"`
	// Output only. Type of the route in the peer VPC network.
	Type PeeringRoute_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.PeeringRoute_Type" json:"type,omitempty"`
	// Output only. Region containing the next hop of the peering route. This
	// field only applies to dynamic routes in the peer VPC network.
	NextHopRegion string `protobuf:"bytes,3,opt,name=next_hop_region,json=nextHopRegion,proto3" json:"next_hop_region,omitempty"`
	// Output only. The priority of the peering route.
	Priority int64 `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`
	// Output only. True if the peering route has been imported from a peered
	// VPC network; false otherwise. The import happens if the field
	// `NetworkPeering.importCustomRoutes` is true for this network,
	// `NetworkPeering.exportCustomRoutes` is true for the peer VPC network, and
	// the import does not result in a route conflict.
	Imported bool `protobuf:"varint,5,opt,name=imported,proto3" json:"imported,omitempty"`
	// Output only. Direction of the routes exchanged with the peer network, from
	// the VMware Engine network perspective:
	//
	// * Routes of direction `INCOMING` are imported from the peer network.
	// * Routes of direction `OUTGOING` are exported from the intranet VPC network
	// of the VMware Engine network.
	Direction PeeringRoute_Direction `protobuf:"varint,6,opt,name=direction,proto3,enum=google.cloud.vmwareengine.v1.PeeringRoute_Direction" json:"direction,omitempty"`
}

func (x *PeeringRoute) Reset() {
	*x = PeeringRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringRoute) ProtoMessage() {}

func (x *PeeringRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringRoute.ProtoReflect.Descriptor instead.
func (*PeeringRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{11}
}

func (x *PeeringRoute) GetDestRange() string {
	if x != nil {
		return x.DestRange
	}
	return ""
}

func (x *PeeringRoute) GetType() PeeringRoute_Type {
	if x != nil {
		return x.Type
	}
	return PeeringRoute_TYPE_UNSPECIFIED
}

func (x *PeeringRoute) GetNextHopRegion() string {
	if x != nil {
		return x.NextHopRegion
	}
	return ""
}

func (x *PeeringRoute) GetPriority() int64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *PeeringRoute) GetImported() bool {
	if x != nil {
		return x.Imported
	}
	return false
}

func (x *PeeringRoute) GetDirection() PeeringRoute_Direction {
	if x != nil {
		return x.Direction
	}
	return PeeringRoute_DIRECTION_UNSPECIFIED
}

// Represents a network policy resource. Network policies are regional
// resources. You can use a network policy to enable or disable internet access
// and external IP access. Network policies are associated with a VMware Engine
// network, which might span across regions. For a given region, a network
// policy applies to all private clouds in the VMware Engine network associated
// with the policy.
type NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this network policy.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Network service that allows VMware workloads to access the internet.
	InternetAccess *NetworkPolicy_NetworkService `protobuf:"bytes,6,opt,name=internet_access,json=internetAccess,proto3" json:"internet_access,omitempty"`
	// Network service that allows External IP addresses to be assigned to VMware
	// workloads. This service can only be enabled when `internet_access` is also
	// enabled.
	ExternalIp *NetworkPolicy_NetworkService `protobuf:"bytes,7,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Required. IP address range in CIDR notation used to create internet access
	// and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
	// required. The range cannot overlap with any prefixes either in the consumer
	// VPC network or in use by the private clouds attached to that VPC network.
	EdgeServicesCidr string `protobuf:"bytes,9,opt,name=edge_services_cidr,json=edgeServicesCidr,proto3" json:"edge_services_cidr,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,10,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The relative resource name of the VMware Engine network.
	// Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,12,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Optional. User-provided description for this network policy.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,14,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
}

func (x *NetworkPolicy) Reset() {
	*x = NetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy) ProtoMessage() {}

func (x *NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy.ProtoReflect.Descriptor instead.
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{12}
}

func (x *NetworkPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NetworkPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NetworkPolicy) GetInternetAccess() *NetworkPolicy_NetworkService {
	if x != nil {
		return x.InternetAccess
	}
	return nil
}

func (x *NetworkPolicy) GetExternalIp() *NetworkPolicy_NetworkService {
	if x != nil {
		return x.ExternalIp
	}
	return nil
}

func (x *NetworkPolicy) GetEdgeServicesCidr() string {
	if x != nil {
		return x.EdgeServicesCidr
	}
	return ""
}

func (x *NetworkPolicy) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *NetworkPolicy) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkPolicy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *NetworkPolicy) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

// VMware Engine network resource that provides connectivity for VMware Engine
// private clouds.
type VmwareEngineNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the VMware Engine network.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-provided description for this VMware Engine network.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. VMware Engine service VPC networks that provide connectivity
	// from a private cloud to customer projects, the internet, and other Google
	// Cloud services.
	VpcNetworks []*VmwareEngineNetwork_VpcNetwork `protobuf:"bytes,6,rep,name=vpc_networks,json=vpcNetworks,proto3" json:"vpc_networks,omitempty"`
	// Output only. State of the VMware Engine network.
	State VmwareEngineNetwork_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_State" json:"state,omitempty"`
	// Required. VMware Engine network type.
	Type VmwareEngineNetwork_Type `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_Type" json:"type,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// Checksum that may be sent on update and delete requests to ensure that the
	// user-provided value is up to date before the server processes a request.
	// The server computes checksums based on the value of other fields in the
	// request.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *VmwareEngineNetwork) Reset() {
	*x = VmwareEngineNetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareEngineNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEngineNetwork) ProtoMessage() {}

func (x *VmwareEngineNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEngineNetwork.ProtoReflect.Descriptor instead.
func (*VmwareEngineNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13}
}

func (x *VmwareEngineNetwork) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VmwareEngineNetwork) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VmwareEngineNetwork) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VmwareEngineNetwork) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VmwareEngineNetwork) GetVpcNetworks() []*VmwareEngineNetwork_VpcNetwork {
	if x != nil {
		return x.VpcNetworks
	}
	return nil
}

func (x *VmwareEngineNetwork) GetState() VmwareEngineNetwork_State {
	if x != nil {
		return x.State
	}
	return VmwareEngineNetwork_STATE_UNSPECIFIED
}

func (x *VmwareEngineNetwork) GetType() VmwareEngineNetwork_Type {
	if x != nil {
		return x.Type
	}
	return VmwareEngineNetwork_TYPE_UNSPECIFIED
}

func (x *VmwareEngineNetwork) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *VmwareEngineNetwork) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Private connection resource that provides connectivity for VMware Engine
// private clouds.
type PrivateConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the private connection.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateConnections/my-connection`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User-provided description for this private connection.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. State of the private connection.
	State PrivateConnection_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_State" json:"state,omitempty"`
	// Required. The relative resource name of Legacy VMware Engine network.
	// Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}`, `{location}` will be same as specified in private
	// connection resource name and `{vmware_engine_network_id}` will be in the
	// form of `{location}`-default e.g.
	// projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
	VmwareEngineNetwork string `protobuf:"bytes,8,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,9,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
	// Required. Private connection type.
	Type PrivateConnection_Type `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_Type" json:"type,omitempty"`
	// Output only. VPC network peering id between given network VPC and
	// VMwareEngineNetwork.
	PeeringId string `protobuf:"bytes,12,opt,name=peering_id,json=peeringId,proto3" json:"peering_id,omitempty"`
	// Optional. Routing Mode.
	// Default value is set to GLOBAL.
	// For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
	// REGIONAL, for other types only GLOBAL is supported.
	RoutingMode PrivateConnection_RoutingMode `protobuf:"varint,13,opt,name=routing_mode,json=routingMode,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_RoutingMode" json:"routing_mode,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,14,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. Service network to create private connection.
	// Specify the name in the following form:
	// `projects/{project}/global/networks/{network_id}`
	// For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
	// VPC, e.g. projects/project-tp/global/networks/servicenetworking.
	// For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
	// e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
	// For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
	// projects/project-tp/global/networks/dell-tenant-vpc.
	// For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
	// any other producer VPC to which the VMware Engine Network needs to be
	// connected, e.g. projects/project/global/networks/vpc.
	ServiceNetwork string `protobuf:"bytes,16,opt,name=service_network,json=serviceNetwork,proto3" json:"service_network,omitempty"`
	// Output only. Peering state between service network and VMware Engine
	// network.
	PeeringState PrivateConnection_PeeringState `protobuf:"varint,17,opt,name=peering_state,json=peeringState,proto3,enum=google.cloud.vmwareengine.v1.PrivateConnection_PeeringState" json:"peering_state,omitempty"`
}

func (x *PrivateConnection) Reset() {
	*x = PrivateConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateConnection) ProtoMessage() {}

func (x *PrivateConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateConnection.ProtoReflect.Descriptor instead.
func (*PrivateConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{14}
}

func (x *PrivateConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateConnection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateConnection) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PrivateConnection) GetState() PrivateConnection_State {
	if x != nil {
		return x.State
	}
	return PrivateConnection_STATE_UNSPECIFIED
}

func (x *PrivateConnection) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *PrivateConnection) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

func (x *PrivateConnection) GetType() PrivateConnection_Type {
	if x != nil {
		return x.Type
	}
	return PrivateConnection_TYPE_UNSPECIFIED
}

func (x *PrivateConnection) GetPeeringId() string {
	if x != nil {
		return x.PeeringId
	}
	return ""
}

func (x *PrivateConnection) GetRoutingMode() PrivateConnection_RoutingMode {
	if x != nil {
		return x.RoutingMode
	}
	return PrivateConnection_ROUTING_MODE_UNSPECIFIED
}

func (x *PrivateConnection) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PrivateConnection) GetServiceNetwork() string {
	if x != nil {
		return x.ServiceNetwork
	}
	return ""
}

func (x *PrivateConnection) GetPeeringState() PrivateConnection_PeeringState {
	if x != nil {
		return x.PeeringState
	}
	return PrivateConnection_PEERING_STATE_UNSPECIFIED
}

// Management cluster configuration.
type PrivateCloud_ManagementCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user-provided identifier of the new `Cluster`.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC
	// 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The map of cluster node types in this cluster, where the key is
	// canonical identifier of the node type (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]*NodeTypeConfig `protobuf:"bytes,7,rep,name=node_type_configs,json=nodeTypeConfigs,proto3" json:"node_type_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PrivateCloud_ManagementCluster) Reset() {
	*x = PrivateCloud_ManagementCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateCloud_ManagementCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateCloud_ManagementCluster) ProtoMessage() {}

func (x *PrivateCloud_ManagementCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateCloud_ManagementCluster.ProtoReflect.Descriptor instead.
func (*PrivateCloud_ManagementCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *PrivateCloud_ManagementCluster) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *PrivateCloud_ManagementCluster) GetNodeTypeConfigs() map[string]*NodeTypeConfig {
	if x != nil {
		return x.NodeTypeConfigs
	}
	return nil
}

// Represents a network service that is managed by a `NetworkPolicy` resource.
// A network service provides a way to control an aspect of external access to
// VMware workloads. For example, whether the VMware workloads in the
// private clouds governed by a network policy can access or be accessed from
// the internet.
type NetworkPolicy_NetworkService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the service is enabled; false otherwise.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Output only. State of the service. New values may be added to this enum
	// when appropriate.
	State NetworkPolicy_NetworkService_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.NetworkPolicy_NetworkService_State" json:"state,omitempty"`
}

func (x *NetworkPolicy_NetworkService) Reset() {
	*x = NetworkPolicy_NetworkService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicy_NetworkService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy_NetworkService) ProtoMessage() {}

func (x *NetworkPolicy_NetworkService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy_NetworkService.ProtoReflect.Descriptor instead.
func (*NetworkPolicy_NetworkService) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{12, 0}
}

func (x *NetworkPolicy_NetworkService) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NetworkPolicy_NetworkService) GetState() NetworkPolicy_NetworkService_State {
	if x != nil {
		return x.State
	}
	return NetworkPolicy_NetworkService_STATE_UNSPECIFIED
}

// Represents a VMware Engine VPC network that is managed by a
// VMware Engine network resource.
type VmwareEngineNetwork_VpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Type of VPC network (INTRANET, INTERNET, or
	// GOOGLE_CLOUD)
	Type VmwareEngineNetwork_VpcNetwork_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_VpcNetwork_Type" json:"type,omitempty"`
	// Output only. The relative resource name of the service VPC network this
	// VMware Engine network is attached to. For example:
	// `projects/123123/global/networks/my-network`
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *VmwareEngineNetwork_VpcNetwork) Reset() {
	*x = VmwareEngineNetwork_VpcNetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareEngineNetwork_VpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEngineNetwork_VpcNetwork) ProtoMessage() {}

func (x *VmwareEngineNetwork_VpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEngineNetwork_VpcNetwork.ProtoReflect.Descriptor instead.
func (*VmwareEngineNetwork_VpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *VmwareEngineNetwork_VpcNetwork) GetType() VmwareEngineNetwork_VpcNetwork_Type {
	if x != nil {
		return x.Type
	}
	return VmwareEngineNetwork_VpcNetwork_TYPE_UNSPECIFIED
}

func (x *VmwareEngineNetwork_VpcNetwork) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

var File_google_cloud_vmwareengine_v1_vmwareengine_resources_proto protoreflect.FileDescriptor

var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x02, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x69, 0x64, 0x72, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x13,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x7e, 0x0a, 0x1f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x1c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x12, 0x53, 0x0a, 0x24, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x0e, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f,
	0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0xc4, 0x0b, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x57,
	0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x12, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38,
	0x0a, 0x03, 0x68, 0x63, 0x78, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x03, 0x68, 0x63, 0x78, 0x12, 0x38, 0x0a, 0x03, 0x6e, 0x73, 0x78, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x73, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6e,
	0x73, 0x78, 0x12, 0x44, 0x0a, 0x07, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xae, 0x02, 0x0a, 0x11, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x70, 0x0a, 0x14, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6c, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b,
	0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x55, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x22, 0x26, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45, 0x44, 0x10, 0x01,
	0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12,
	0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x22, 0xf3, 0x05, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x6b, 0x0a, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x1a, 0x70, 0x0a, 0x14, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x63, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x50, 0x41,
	0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x23, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x22, 0xb8, 0x03, 0x0a,
	0x06, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x22, 0x0a, 0x0d, 0x69, 0x70, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x70, 0x43, 0x69, 0x64, 0x72, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f,
	0x69, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x49, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x71, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43,
	0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x22, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12,
	0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x7d, 0x22, 0xcb, 0x03, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x11,
	0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a,
	0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x67, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x25,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53,
	0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x44, 0x0a, 0x1c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x19, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a, 0x68, 0xea, 0x41, 0x65,
	0x0a, 0x24, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f,
	0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x7d, 0x22, 0x45, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0xef, 0x03, 0x0a,
	0x10, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a,
	0x0e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x22, 0x49, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x3a, 0xa0, 0x01, 0xea, 0x41,
	0x9c, 0x01, 0x0a, 0x2c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x6c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x68, 0x63, 0x78, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x22, 0xd2,
	0x01, 0x0a, 0x03, 0x48, 0x63, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x63, 0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x38, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x22, 0xd2, 0x01, 0x0a, 0x03, 0x4e, 0x73, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x73, 0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71,
	0x64, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x38,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xda, 0x01, 0x0a, 0x07, 0x56, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x38, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xf5, 0x03, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x64, 0x65, 0x73, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x59,
	0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x5f,
	0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x02, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x03, 0x22, 0x42, 0x0a, 0x09, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x4f, 0x55, 0x54, 0x47, 0x4f, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xa0, 0x08,
	0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x5b, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x31,
	0x0a, 0x12, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f,
	0x63, 0x69, 0x64, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x65, 0x64, 0x67, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x69, 0x64,
	0x72, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x31, 0x0a,
	0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x1f,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x1c,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x1a, 0xd7, 0x01, 0x0a,
	0x0e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x4e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43,
	0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x29, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x48, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d,
	0x22, 0x91, 0x08, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x0c, 0x76, 0x70, 0x63, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2e, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x52, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x4f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x1a, 0xf6, 0x01,
	0x0a, 0x0a, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5a, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x56, 0x70,
	0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x4a, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x52,
	0x41, 0x4e, 0x45, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e,
	0x45, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x10, 0x03, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0x28, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x45,
	0x47, 0x41, 0x43, 0x59, 0x10, 0x01, 0x3a, 0x8b, 0x01, 0xea, 0x41, 0x87, 0x01, 0x0a, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x54,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x7d, 0x22, 0xdd, 0x0b, 0x0a, 0x11, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x7e, 0x0a,
	0x1f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x1c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x4d, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x64,
	0x12, 0x63, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x4f, 0x0a, 0x0f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x66, 0x0a,
	0x0d, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x73, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x55,
	0x4e, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x22, 0x80, 0x01, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x52, 0x49,
	0x56, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x45, 0x54, 0x41, 0x50, 0x50, 0x5f,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x53, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x4c, 0x5f, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x53, 0x43, 0x41,
	0x4c, 0x45, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41,
	0x52, 0x54, 0x59, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x04, 0x22, 0x45, 0x0a,
	0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x4c,
	0x4f, 0x42, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e,
	0x41, 0x4c, 0x10, 0x02, 0x22, 0x57, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x45, 0x52, 0x49,
	0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x3a, 0x84, 0x01,
	0xea, 0x41, 0x80, 0x01, 0x0a, 0x2d, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x42, 0xe6, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x1c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescOnce sync.Once
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData = file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc
)

func file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData)
	})
	return file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDescData
}

var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 18)
var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_goTypes = []interface{}{
	(PrivateCloud_State)(0),                  // 0: google.cloud.vmwareengine.v1.PrivateCloud.State
	(PrivateCloud_Type)(0),                   // 1: google.cloud.vmwareengine.v1.PrivateCloud.Type
	(Cluster_State)(0),                       // 2: google.cloud.vmwareengine.v1.Cluster.State
	(Subnet_State)(0),                        // 3: google.cloud.vmwareengine.v1.Subnet.State
	(HcxActivationKey_State)(0),              // 4: google.cloud.vmwareengine.v1.HcxActivationKey.State
	(Hcx_State)(0),                           // 5: google.cloud.vmwareengine.v1.Hcx.State
	(Nsx_State)(0),                           // 6: google.cloud.vmwareengine.v1.Nsx.State
	(Vcenter_State)(0),                       // 7: google.cloud.vmwareengine.v1.Vcenter.State
	(PeeringRoute_Type)(0),                   // 8: google.cloud.vmwareengine.v1.PeeringRoute.Type
	(PeeringRoute_Direction)(0),              // 9: google.cloud.vmwareengine.v1.PeeringRoute.Direction
	(NetworkPolicy_NetworkService_State)(0),  // 10: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.State
	(VmwareEngineNetwork_State)(0),           // 11: google.cloud.vmwareengine.v1.VmwareEngineNetwork.State
	(VmwareEngineNetwork_Type)(0),            // 12: google.cloud.vmwareengine.v1.VmwareEngineNetwork.Type
	(VmwareEngineNetwork_VpcNetwork_Type)(0), // 13: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.Type
	(PrivateConnection_State)(0),             // 14: google.cloud.vmwareengine.v1.PrivateConnection.State
	(PrivateConnection_Type)(0),              // 15: google.cloud.vmwareengine.v1.PrivateConnection.Type
	(PrivateConnection_RoutingMode)(0),       // 16: google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode
	(PrivateConnection_PeeringState)(0),      // 17: google.cloud.vmwareengine.v1.PrivateConnection.PeeringState
	(*NetworkConfig)(nil),                    // 18: google.cloud.vmwareengine.v1.NetworkConfig
	(*NodeTypeConfig)(nil),                   // 19: google.cloud.vmwareengine.v1.NodeTypeConfig
	(*PrivateCloud)(nil),                     // 20: google.cloud.vmwareengine.v1.PrivateCloud
	(*Cluster)(nil),                          // 21: google.cloud.vmwareengine.v1.Cluster
	(*Subnet)(nil),                           // 22: google.cloud.vmwareengine.v1.Subnet
	(*NodeType)(nil),                         // 23: google.cloud.vmwareengine.v1.NodeType
	(*Credentials)(nil),                      // 24: google.cloud.vmwareengine.v1.Credentials
	(*HcxActivationKey)(nil),                 // 25: google.cloud.vmwareengine.v1.HcxActivationKey
	(*Hcx)(nil),                              // 26: google.cloud.vmwareengine.v1.Hcx
	(*Nsx)(nil),                              // 27: google.cloud.vmwareengine.v1.Nsx
	(*Vcenter)(nil),                          // 28: google.cloud.vmwareengine.v1.Vcenter
	(*PeeringRoute)(nil),                     // 29: google.cloud.vmwareengine.v1.PeeringRoute
	(*NetworkPolicy)(nil),                    // 30: google.cloud.vmwareengine.v1.NetworkPolicy
	(*VmwareEngineNetwork)(nil),              // 31: google.cloud.vmwareengine.v1.VmwareEngineNetwork
	(*PrivateConnection)(nil),                // 32: google.cloud.vmwareengine.v1.PrivateConnection
	(*PrivateCloud_ManagementCluster)(nil),   // 33: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster
	nil,                                      // 34: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry
	nil,                                      // 35: google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry
	(*NetworkPolicy_NetworkService)(nil),     // 36: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	(*VmwareEngineNetwork_VpcNetwork)(nil),   // 37: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork
	(*timestamppb.Timestamp)(nil),            // 38: google.protobuf.Timestamp
}
var file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_depIdxs = []int32{
	38, // 0: google.cloud.vmwareengine.v1.PrivateCloud.create_time:type_name -> google.protobuf.Timestamp
	38, // 1: google.cloud.vmwareengine.v1.PrivateCloud.update_time:type_name -> google.protobuf.Timestamp
	38, // 2: google.cloud.vmwareengine.v1.PrivateCloud.delete_time:type_name -> google.protobuf.Timestamp
	38, // 3: google.cloud.vmwareengine.v1.PrivateCloud.expire_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.cloud.vmwareengine.v1.PrivateCloud.state:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.State
	18, // 5: google.cloud.vmwareengine.v1.PrivateCloud.network_config:type_name -> google.cloud.vmwareengine.v1.NetworkConfig
	33, // 6: google.cloud.vmwareengine.v1.PrivateCloud.management_cluster:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster
	26, // 7: google.cloud.vmwareengine.v1.PrivateCloud.hcx:type_name -> google.cloud.vmwareengine.v1.Hcx
	27, // 8: google.cloud.vmwareengine.v1.PrivateCloud.nsx:type_name -> google.cloud.vmwareengine.v1.Nsx
	28, // 9: google.cloud.vmwareengine.v1.PrivateCloud.vcenter:type_name -> google.cloud.vmwareengine.v1.Vcenter
	1,  // 10: google.cloud.vmwareengine.v1.PrivateCloud.type:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.Type
	38, // 11: google.cloud.vmwareengine.v1.Cluster.create_time:type_name -> google.protobuf.Timestamp
	38, // 12: google.cloud.vmwareengine.v1.Cluster.update_time:type_name -> google.protobuf.Timestamp
	2,  // 13: google.cloud.vmwareengine.v1.Cluster.state:type_name -> google.cloud.vmwareengine.v1.Cluster.State
	35, // 14: google.cloud.vmwareengine.v1.Cluster.node_type_configs:type_name -> google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry
	3,  // 15: google.cloud.vmwareengine.v1.Subnet.state:type_name -> google.cloud.vmwareengine.v1.Subnet.State
	38, // 16: google.cloud.vmwareengine.v1.HcxActivationKey.create_time:type_name -> google.protobuf.Timestamp
	4,  // 17: google.cloud.vmwareengine.v1.HcxActivationKey.state:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey.State
	5,  // 18: google.cloud.vmwareengine.v1.Hcx.state:type_name -> google.cloud.vmwareengine.v1.Hcx.State
	6,  // 19: google.cloud.vmwareengine.v1.Nsx.state:type_name -> google.cloud.vmwareengine.v1.Nsx.State
	7,  // 20: google.cloud.vmwareengine.v1.Vcenter.state:type_name -> google.cloud.vmwareengine.v1.Vcenter.State
	8,  // 21: google.cloud.vmwareengine.v1.PeeringRoute.type:type_name -> google.cloud.vmwareengine.v1.PeeringRoute.Type
	9,  // 22: google.cloud.vmwareengine.v1.PeeringRoute.direction:type_name -> google.cloud.vmwareengine.v1.PeeringRoute.Direction
	38, // 23: google.cloud.vmwareengine.v1.NetworkPolicy.create_time:type_name -> google.protobuf.Timestamp
	38, // 24: google.cloud.vmwareengine.v1.NetworkPolicy.update_time:type_name -> google.protobuf.Timestamp
	36, // 25: google.cloud.vmwareengine.v1.NetworkPolicy.internet_access:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	36, // 26: google.cloud.vmwareengine.v1.NetworkPolicy.external_ip:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	38, // 27: google.cloud.vmwareengine.v1.VmwareEngineNetwork.create_time:type_name -> google.protobuf.Timestamp
	38, // 28: google.cloud.vmwareengine.v1.VmwareEngineNetwork.update_time:type_name -> google.protobuf.Timestamp
	37, // 29: google.cloud.vmwareengine.v1.VmwareEngineNetwork.vpc_networks:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork
	11, // 30: google.cloud.vmwareengine.v1.VmwareEngineNetwork.state:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.State
	12, // 31: google.cloud.vmwareengine.v1.VmwareEngineNetwork.type:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.Type
	38, // 32: google.cloud.vmwareengine.v1.PrivateConnection.create_time:type_name -> google.protobuf.Timestamp
	38, // 33: google.cloud.vmwareengine.v1.PrivateConnection.update_time:type_name -> google.protobuf.Timestamp
	14, // 34: google.cloud.vmwareengine.v1.PrivateConnection.state:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.State
	15, // 35: google.cloud.vmwareengine.v1.PrivateConnection.type:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.Type
	16, // 36: google.cloud.vmwareengine.v1.PrivateConnection.routing_mode:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.RoutingMode
	17, // 37: google.cloud.vmwareengine.v1.PrivateConnection.peering_state:type_name -> google.cloud.vmwareengine.v1.PrivateConnection.PeeringState
	34, // 38: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.node_type_configs:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry
	19, // 39: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry.value:type_name -> google.cloud.vmwareengine.v1.NodeTypeConfig
	19, // 40: google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry.value:type_name -> google.cloud.vmwareengine.v1.NodeTypeConfig
	10, // 41: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.state:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.State
	13, // 42: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.type:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.Type
	43, // [43:43] is the sub-list for method output_type
	43, // [43:43] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_init() }
func file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_init() {
	if File_google_cloud_vmwareengine_v1_vmwareengine_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeTypeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateCloud); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subnet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Credentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HcxActivationKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hcx); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Nsx); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vcenter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareEngineNetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateCloud_ManagementCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicy_NetworkService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareEngineNetwork_VpcNetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc,
			NumEnums:      18,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_vmwareengine_v1_vmwareengine_resources_proto = out.File
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_rawDesc = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_goTypes = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_depIdxs = nil
}
