// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/bigquery/connection/v1/connection.proto

package connectionpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported Cloud SQL database types.
type CloudSqlProperties_DatabaseType int32

const (
	// Unspecified database type.
	CloudSqlProperties_DATABASE_TYPE_UNSPECIFIED CloudSqlProperties_DatabaseType = 0
	// Cloud SQL for PostgreSQL.
	CloudSqlProperties_POSTGRES CloudSqlProperties_DatabaseType = 1
	// Cloud SQL for MySQL.
	CloudSqlProperties_MYSQL CloudSqlProperties_DatabaseType = 2
)

// Enum value maps for CloudSqlProperties_DatabaseType.
var (
	CloudSqlProperties_DatabaseType_name = map[int32]string{
		0: "DATABASE_TYPE_UNSPECIFIED",
		1: "POSTGRES",
		2: "MYSQL",
	}
	CloudSqlProperties_DatabaseType_value = map[string]int32{
		"DATABASE_TYPE_UNSPECIFIED": 0,
		"POSTGRES":                  1,
		"MYSQL":                     2,
	}
)

func (x CloudSqlProperties_DatabaseType) Enum() *CloudSqlProperties_DatabaseType {
	p := new(CloudSqlProperties_DatabaseType)
	*p = x
	return p
}

func (x CloudSqlProperties_DatabaseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudSqlProperties_DatabaseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_connection_v1_connection_proto_enumTypes[0].Descriptor()
}

func (CloudSqlProperties_DatabaseType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_connection_v1_connection_proto_enumTypes[0]
}

func (x CloudSqlProperties_DatabaseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudSqlProperties_DatabaseType.Descriptor instead.
func (CloudSqlProperties_DatabaseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{7, 0}
}

// The request for
// [ConnectionService.CreateConnection][google.cloud.bigquery.connection.v1.ConnectionService.CreateConnection].
type CreateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// Must be in the format `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Connection id that should be assigned to the created connection.
	ConnectionId string `protobuf:"bytes,2,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Required. Connection to create.
	Connection *Connection `protobuf:"bytes,3,opt,name=connection,proto3" json:"connection,omitempty"`
}

func (x *CreateConnectionRequest) Reset() {
	*x = CreateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectionRequest) ProtoMessage() {}

func (x *CreateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{0}
}

func (x *CreateConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

// The request for
// [ConnectionService.GetConnection][google.cloud.bigquery.connection.v1.ConnectionService.GetConnection].
type GetConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectionRequest) Reset() {
	*x = GetConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionRequest) ProtoMessage() {}

func (x *GetConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{1}
}

func (x *GetConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1.ConnectionService.ListConnections].
type ListConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// Must be in the form: `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConnectionsRequest) Reset() {
	*x = ListConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsRequest) ProtoMessage() {}

func (x *ListConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{2}
}

func (x *ListConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1.ConnectionService.ListConnections].
type ListConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Next page token.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of connections.
	Connections []*Connection `protobuf:"bytes,2,rep,name=connections,proto3" json:"connections,omitempty"`
}

func (x *ListConnectionsResponse) Reset() {
	*x = ListConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsResponse) ProtoMessage() {}

func (x *ListConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{3}
}

func (x *ListConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectionsResponse) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

// The request for
// [ConnectionService.UpdateConnection][google.cloud.bigquery.connection.v1.ConnectionService.UpdateConnection].
type UpdateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the connection to update, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Connection containing the updated fields.
	Connection *Connection `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	// Required. Update mask for the connection fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConnectionRequest) Reset() {
	*x = UpdateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectionRequest) ProtoMessage() {}

func (x *UpdateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *UpdateConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for [ConnectionService.DeleteConnectionRequest][].
type DeleteConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the deleted connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConnectionRequest) Reset() {
	*x = DeleteConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectionRequest) ProtoMessage() {}

func (x *DeleteConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Configuration parameters to establish connection with an external data
// source, except the credential attributes.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the connection in the form of:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided display name for the connection.
	FriendlyName string `protobuf:"bytes,2,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// User provided description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Properties specific to the underlying data source.
	//
	// Types that are assignable to Properties:
	//	*Connection_CloudSql
	//	*Connection_Aws
	//	*Connection_Azure
	//	*Connection_CloudSpanner
	//	*Connection_CloudResource
	//	*Connection_Spark
	Properties isConnection_Properties `protobuf_oneof:"properties"`
	// Output only. The creation timestamp of the connection.
	CreationTime int64 `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The last update timestamp of the connection.
	LastModifiedTime int64 `protobuf:"varint,6,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// Output only. True, if credential is configured for this connection.
	HasCredential bool `protobuf:"varint,7,opt,name=has_credential,json=hasCredential,proto3" json:"has_credential,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{6}
}

func (x *Connection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Connection) GetFriendlyName() string {
	if x != nil {
		return x.FriendlyName
	}
	return ""
}

func (x *Connection) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Connection) GetProperties() isConnection_Properties {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (x *Connection) GetCloudSql() *CloudSqlProperties {
	if x, ok := x.GetProperties().(*Connection_CloudSql); ok {
		return x.CloudSql
	}
	return nil
}

func (x *Connection) GetAws() *AwsProperties {
	if x, ok := x.GetProperties().(*Connection_Aws); ok {
		return x.Aws
	}
	return nil
}

func (x *Connection) GetAzure() *AzureProperties {
	if x, ok := x.GetProperties().(*Connection_Azure); ok {
		return x.Azure
	}
	return nil
}

func (x *Connection) GetCloudSpanner() *CloudSpannerProperties {
	if x, ok := x.GetProperties().(*Connection_CloudSpanner); ok {
		return x.CloudSpanner
	}
	return nil
}

func (x *Connection) GetCloudResource() *CloudResourceProperties {
	if x, ok := x.GetProperties().(*Connection_CloudResource); ok {
		return x.CloudResource
	}
	return nil
}

func (x *Connection) GetSpark() *SparkProperties {
	if x, ok := x.GetProperties().(*Connection_Spark); ok {
		return x.Spark
	}
	return nil
}

func (x *Connection) GetCreationTime() int64 {
	if x != nil {
		return x.CreationTime
	}
	return 0
}

func (x *Connection) GetLastModifiedTime() int64 {
	if x != nil {
		return x.LastModifiedTime
	}
	return 0
}

func (x *Connection) GetHasCredential() bool {
	if x != nil {
		return x.HasCredential
	}
	return false
}

type isConnection_Properties interface {
	isConnection_Properties()
}

type Connection_CloudSql struct {
	// Cloud SQL properties.
	CloudSql *CloudSqlProperties `protobuf:"bytes,4,opt,name=cloud_sql,json=cloudSql,proto3,oneof"`
}

type Connection_Aws struct {
	// Amazon Web Services (AWS) properties.
	Aws *AwsProperties `protobuf:"bytes,8,opt,name=aws,proto3,oneof"`
}

type Connection_Azure struct {
	// Azure properties.
	Azure *AzureProperties `protobuf:"bytes,11,opt,name=azure,proto3,oneof"`
}

type Connection_CloudSpanner struct {
	// Cloud Spanner properties.
	CloudSpanner *CloudSpannerProperties `protobuf:"bytes,21,opt,name=cloud_spanner,json=cloudSpanner,proto3,oneof"`
}

type Connection_CloudResource struct {
	// Cloud Resource properties.
	CloudResource *CloudResourceProperties `protobuf:"bytes,22,opt,name=cloud_resource,json=cloudResource,proto3,oneof"`
}

type Connection_Spark struct {
	// Spark properties.
	Spark *SparkProperties `protobuf:"bytes,23,opt,name=spark,proto3,oneof"`
}

func (*Connection_CloudSql) isConnection_Properties() {}

func (*Connection_Aws) isConnection_Properties() {}

func (*Connection_Azure) isConnection_Properties() {}

func (*Connection_CloudSpanner) isConnection_Properties() {}

func (*Connection_CloudResource) isConnection_Properties() {}

func (*Connection_Spark) isConnection_Properties() {}

// Connection properties specific to the Cloud SQL.
type CloudSqlProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID in the form `project:location:instance`.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Database name.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// Type of the Cloud SQL database.
	Type CloudSqlProperties_DatabaseType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.bigquery.connection.v1.CloudSqlProperties_DatabaseType" json:"type,omitempty"`
	// Input only. Cloud SQL credential.
	Credential *CloudSqlCredential `protobuf:"bytes,4,opt,name=credential,proto3" json:"credential,omitempty"`
	// Output only. The account ID of the service used for the purpose of this
	// connection.
	//
	// When the connection is used in the context of an operation in
	// BigQuery, this service account will serve as the identity being used for
	// connecting to the CloudSQL instance specified in this connection.
	ServiceAccountId string `protobuf:"bytes,5,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
}

func (x *CloudSqlProperties) Reset() {
	*x = CloudSqlProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSqlProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlProperties) ProtoMessage() {}

func (x *CloudSqlProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlProperties.ProtoReflect.Descriptor instead.
func (*CloudSqlProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{7}
}

func (x *CloudSqlProperties) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CloudSqlProperties) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *CloudSqlProperties) GetType() CloudSqlProperties_DatabaseType {
	if x != nil {
		return x.Type
	}
	return CloudSqlProperties_DATABASE_TYPE_UNSPECIFIED
}

func (x *CloudSqlProperties) GetCredential() *CloudSqlCredential {
	if x != nil {
		return x.Credential
	}
	return nil
}

func (x *CloudSqlProperties) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

// Credential info for the Cloud SQL.
type CloudSqlCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The username for the credential.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the credential.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *CloudSqlCredential) Reset() {
	*x = CloudSqlCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSqlCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlCredential) ProtoMessage() {}

func (x *CloudSqlCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlCredential.ProtoReflect.Descriptor instead.
func (*CloudSqlCredential) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{8}
}

func (x *CloudSqlCredential) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *CloudSqlCredential) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// Connection properties specific to Cloud Spanner.
type CloudSpannerProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Spanner database in the form `project/instance/database'
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// If parallelism should be used when reading from Cloud Spanner
	UseParallelism bool `protobuf:"varint,2,opt,name=use_parallelism,json=useParallelism,proto3" json:"use_parallelism,omitempty"`
	// If the serverless analytics service should be used to read data from Cloud
	// Spanner.
	// Note: `use_parallelism` must be set when using serverless analytics.
	UseServerlessAnalytics bool `protobuf:"varint,3,opt,name=use_serverless_analytics,json=useServerlessAnalytics,proto3" json:"use_serverless_analytics,omitempty"`
	// Optional. Cloud Spanner database role for fine-grained access control.
	// A database role is a collection of fine-grained access privileges. Example:
	// Admin predefines roles that provides user a set of permissions (SELECT,
	// INSERT, ..). The user can then specify a predefined role on a connection to
	// execute their Cloud Spanner query. The role is passthrough here. If the
	// user is not authorized to use the specified role, they get an error. This
	// validation happens on Cloud Spanner.
	//
	// See https://cloud.google.com/spanner/docs/fgac-about for more details.
	//
	// REQUIRES: database role name must start with uppercase/lowercase letter
	// and only contain uppercase/lowercase letters, numbers, and underscores.
	DatabaseRole string `protobuf:"bytes,4,opt,name=database_role,json=databaseRole,proto3" json:"database_role,omitempty"`
}

func (x *CloudSpannerProperties) Reset() {
	*x = CloudSpannerProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSpannerProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSpannerProperties) ProtoMessage() {}

func (x *CloudSpannerProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSpannerProperties.ProtoReflect.Descriptor instead.
func (*CloudSpannerProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{9}
}

func (x *CloudSpannerProperties) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *CloudSpannerProperties) GetUseParallelism() bool {
	if x != nil {
		return x.UseParallelism
	}
	return false
}

func (x *CloudSpannerProperties) GetUseServerlessAnalytics() bool {
	if x != nil {
		return x.UseServerlessAnalytics
	}
	return false
}

func (x *CloudSpannerProperties) GetDatabaseRole() string {
	if x != nil {
		return x.DatabaseRole
	}
	return ""
}

// Connection properties specific to Amazon Web Services (AWS).
type AwsProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Authentication method chosen at connection creation.
	//
	// Types that are assignable to AuthenticationMethod:
	//	*AwsProperties_CrossAccountRole
	//	*AwsProperties_AccessRole
	AuthenticationMethod isAwsProperties_AuthenticationMethod `protobuf_oneof:"authentication_method"`
}

func (x *AwsProperties) Reset() {
	*x = AwsProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsProperties) ProtoMessage() {}

func (x *AwsProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsProperties.ProtoReflect.Descriptor instead.
func (*AwsProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{10}
}

func (m *AwsProperties) GetAuthenticationMethod() isAwsProperties_AuthenticationMethod {
	if m != nil {
		return m.AuthenticationMethod
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/connection/v1/connection.proto.
func (x *AwsProperties) GetCrossAccountRole() *AwsCrossAccountRole {
	if x, ok := x.GetAuthenticationMethod().(*AwsProperties_CrossAccountRole); ok {
		return x.CrossAccountRole
	}
	return nil
}

func (x *AwsProperties) GetAccessRole() *AwsAccessRole {
	if x, ok := x.GetAuthenticationMethod().(*AwsProperties_AccessRole); ok {
		return x.AccessRole
	}
	return nil
}

type isAwsProperties_AuthenticationMethod interface {
	isAwsProperties_AuthenticationMethod()
}

type AwsProperties_CrossAccountRole struct {
	// Authentication using Google owned AWS IAM user's access key to assume
	// into customer's AWS IAM Role.
	// Deprecated, do not use.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/connection/v1/connection.proto.
	CrossAccountRole *AwsCrossAccountRole `protobuf:"bytes,2,opt,name=cross_account_role,json=crossAccountRole,proto3,oneof"`
}

type AwsProperties_AccessRole struct {
	// Authentication using Google owned service account to assume into
	// customer's AWS IAM Role.
	AccessRole *AwsAccessRole `protobuf:"bytes,3,opt,name=access_role,json=accessRole,proto3,oneof"`
}

func (*AwsProperties_CrossAccountRole) isAwsProperties_AuthenticationMethod() {}

func (*AwsProperties_AccessRole) isAwsProperties_AuthenticationMethod() {}

// Authentication method for Amazon Web Services (AWS) that uses Google owned
// AWS IAM user's access key to assume into customer's AWS IAM Role.
type AwsCrossAccountRole struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user’s AWS IAM Role that trusts the Google-owned AWS IAM user
	// Connection.
	IamRoleId string `protobuf:"bytes,1,opt,name=iam_role_id,json=iamRoleId,proto3" json:"iam_role_id,omitempty"`
	// Output only. Google-owned AWS IAM User for a Connection.
	IamUserId string `protobuf:"bytes,2,opt,name=iam_user_id,json=iamUserId,proto3" json:"iam_user_id,omitempty"`
	// Output only. A Google-generated id for representing Connection’s identity
	// in AWS. External Id is also used for preventing the Confused Deputy
	// Problem. See
	// https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
	ExternalId string `protobuf:"bytes,3,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
}

func (x *AwsCrossAccountRole) Reset() {
	*x = AwsCrossAccountRole{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsCrossAccountRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsCrossAccountRole) ProtoMessage() {}

func (x *AwsCrossAccountRole) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsCrossAccountRole.ProtoReflect.Descriptor instead.
func (*AwsCrossAccountRole) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{11}
}

func (x *AwsCrossAccountRole) GetIamRoleId() string {
	if x != nil {
		return x.IamRoleId
	}
	return ""
}

func (x *AwsCrossAccountRole) GetIamUserId() string {
	if x != nil {
		return x.IamUserId
	}
	return ""
}

func (x *AwsCrossAccountRole) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

// Authentication method for Amazon Web Services (AWS) that uses Google owned
// Google service account to assume into customer's AWS IAM Role.
type AwsAccessRole struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user’s AWS IAM Role that trusts the Google-owned AWS IAM user
	// Connection.
	IamRoleId string `protobuf:"bytes,1,opt,name=iam_role_id,json=iamRoleId,proto3" json:"iam_role_id,omitempty"`
	// A unique Google-owned and Google-generated identity for the Connection.
	// This identity will be used to access the user's AWS IAM Role.
	Identity string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *AwsAccessRole) Reset() {
	*x = AwsAccessRole{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsAccessRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsAccessRole) ProtoMessage() {}

func (x *AwsAccessRole) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsAccessRole.ProtoReflect.Descriptor instead.
func (*AwsAccessRole) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{12}
}

func (x *AwsAccessRole) GetIamRoleId() string {
	if x != nil {
		return x.IamRoleId
	}
	return ""
}

func (x *AwsAccessRole) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// Container for connection properties specific to Azure.
type AzureProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Azure Active Directory Application.
	Application string `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	// Output only. The client id of the Azure Active Directory Application.
	ClientId string `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Output only. The object id of the Azure Active Directory Application.
	ObjectId string `protobuf:"bytes,3,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// The id of customer's directory that host the data.
	CustomerTenantId string `protobuf:"bytes,4,opt,name=customer_tenant_id,json=customerTenantId,proto3" json:"customer_tenant_id,omitempty"`
	// The URL user will be redirected to after granting consent during connection
	// setup.
	RedirectUri string `protobuf:"bytes,5,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
	// The client ID of the user's Azure Active Directory Application used for a
	// federated connection.
	FederatedApplicationClientId string `protobuf:"bytes,6,opt,name=federated_application_client_id,json=federatedApplicationClientId,proto3" json:"federated_application_client_id,omitempty"`
	// Output only. A unique Google-owned and Google-generated identity for the
	// Connection. This identity will be used to access the user's Azure Active
	// Directory Application.
	Identity string `protobuf:"bytes,7,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *AzureProperties) Reset() {
	*x = AzureProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureProperties) ProtoMessage() {}

func (x *AzureProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureProperties.ProtoReflect.Descriptor instead.
func (*AzureProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{13}
}

func (x *AzureProperties) GetApplication() string {
	if x != nil {
		return x.Application
	}
	return ""
}

func (x *AzureProperties) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *AzureProperties) GetObjectId() string {
	if x != nil {
		return x.ObjectId
	}
	return ""
}

func (x *AzureProperties) GetCustomerTenantId() string {
	if x != nil {
		return x.CustomerTenantId
	}
	return ""
}

func (x *AzureProperties) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

func (x *AzureProperties) GetFederatedApplicationClientId() string {
	if x != nil {
		return x.FederatedApplicationClientId
	}
	return ""
}

func (x *AzureProperties) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// Container for connection properties for delegation of access to GCP
// resources.
type CloudResourceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The account ID of the service created for the purpose of this
	// connection.
	//
	// The service account does not have any permissions associated with it
	// when it is created. After creation, customers delegate permissions
	// to the service account. When the connection is used in the context of an
	// operation in BigQuery, the service account will be used to connect to the
	// desired resources in GCP.
	//
	// The account ID is in the form of:
	//   <service-1234>@gcp-sa-bigquery-cloudresource.iam.gserviceaccount.com
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
}

func (x *CloudResourceProperties) Reset() {
	*x = CloudResourceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudResourceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudResourceProperties) ProtoMessage() {}

func (x *CloudResourceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudResourceProperties.ProtoReflect.Descriptor instead.
func (*CloudResourceProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{14}
}

func (x *CloudResourceProperties) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

// Configuration of the Dataproc Metastore Service.
type MetastoreServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of an existing Dataproc Metastore service.
	//
	// Example:
	//
	// * `projects/[project_id]/locations/[region]/services/[service_id]`
	MetastoreService string `protobuf:"bytes,1,opt,name=metastore_service,json=metastoreService,proto3" json:"metastore_service,omitempty"`
}

func (x *MetastoreServiceConfig) Reset() {
	*x = MetastoreServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetastoreServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetastoreServiceConfig) ProtoMessage() {}

func (x *MetastoreServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetastoreServiceConfig.ProtoReflect.Descriptor instead.
func (*MetastoreServiceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{15}
}

func (x *MetastoreServiceConfig) GetMetastoreService() string {
	if x != nil {
		return x.MetastoreService
	}
	return ""
}

// Configuration of the Spark History Server.
type SparkHistoryServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of an existing Dataproc Cluster to act as a Spark
	// History Server for the connection.
	//
	// Example:
	//
	// * `projects/[project_id]/regions/[region]/clusters/[cluster_name]`
	DataprocCluster string `protobuf:"bytes,1,opt,name=dataproc_cluster,json=dataprocCluster,proto3" json:"dataproc_cluster,omitempty"`
}

func (x *SparkHistoryServerConfig) Reset() {
	*x = SparkHistoryServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkHistoryServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkHistoryServerConfig) ProtoMessage() {}

func (x *SparkHistoryServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkHistoryServerConfig.ProtoReflect.Descriptor instead.
func (*SparkHistoryServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{16}
}

func (x *SparkHistoryServerConfig) GetDataprocCluster() string {
	if x != nil {
		return x.DataprocCluster
	}
	return ""
}

// Container for connection properties to execute stored procedures for Apache
// Spark.
type SparkProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The account ID of the service created for the purpose of this
	// connection.
	//
	// The service account does not have any permissions associated with it when
	// it is created. After creation, customers delegate permissions to the
	// service account. When the connection is used in the context of a stored
	// procedure for Apache Spark in BigQuery, the service account will be used to
	// connect to the desired resources in Google Cloud.
	//
	// The account ID is in the form of:
	// bqcx-<projectnumber>-<uniqueid>@gcp-sa-bigquery-consp.iam.gserviceaccount.com
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Optional. Dataproc Metastore Service configuration for the connection.
	MetastoreServiceConfig *MetastoreServiceConfig `protobuf:"bytes,3,opt,name=metastore_service_config,json=metastoreServiceConfig,proto3" json:"metastore_service_config,omitempty"`
	// Optional. Spark History Server configuration for the connection.
	SparkHistoryServerConfig *SparkHistoryServerConfig `protobuf:"bytes,4,opt,name=spark_history_server_config,json=sparkHistoryServerConfig,proto3" json:"spark_history_server_config,omitempty"`
}

func (x *SparkProperties) Reset() {
	*x = SparkProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkProperties) ProtoMessage() {}

func (x *SparkProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkProperties.ProtoReflect.Descriptor instead.
func (*SparkProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP(), []int{17}
}

func (x *SparkProperties) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *SparkProperties) GetMetastoreServiceConfig() *MetastoreServiceConfig {
	if x != nil {
		return x.MetastoreServiceConfig
	}
	return nil
}

func (x *SparkProperties) GetSparkHistoryServerConfig() *SparkHistoryServerConfig {
	if x != nil {
		return x.SparkHistoryServerConfig
	}
	return nil
}

var File_google_cloud_bigquery_connection_v1_connection_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_connection_v1_connection_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61,
	0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x01, 0x0a, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x54, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x60, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x51, 0x0a,
	0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xfb, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2e, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x63,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a,
	0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xfa, 0x06, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64,
	0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a,
	0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x08, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x71, 0x6c, 0x12, 0x46, 0x0a, 0x03, 0x61, 0x77, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x03, 0x61, 0x77, 0x73, 0x12, 0x4c, 0x0a,
	0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x48, 0x00, 0x52, 0x05, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x12, 0x62, 0x0a, 0x0d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x12,
	0x65, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x72,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x05, 0x73,
	0x70, 0x61, 0x72, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x31,
	0x0a, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x68, 0x61, 0x73, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x68, 0x61, 0x73, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x3a, 0x73, 0xea,
	0x41, 0x70, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x22, 0x84, 0x03, 0x0a, 0x12, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71,
	0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5c,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71,
	0x6c, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x31, 0x0a, 0x12,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x22,
	0x46, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x4d, 0x59, 0x53, 0x51, 0x4c, 0x10, 0x02, 0x22, 0x4c, 0x0a, 0x12, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x53, 0x71, 0x6c, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x1a, 0x0a,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0xc1, 0x01, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x75, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c,
	0x65, 0x6c, 0x69, 0x73, 0x6d, 0x12, 0x38, 0x0a, 0x18, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x75, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x12,
	0x28, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0xed, 0x01, 0x0a, 0x0d, 0x41, 0x77,
	0x73, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x6c, 0x0a, 0x12, 0x63,
	0x72, 0x6f, 0x73, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x10, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x6f,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x6f, 0x6c, 0x65,
	0x42, 0x17, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x80, 0x01, 0x0a, 0x13, 0x41, 0x77,
	0x73, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x1e, 0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x61, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x61, 0x6d,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x22, 0x4b, 0x0a, 0x0d,
	0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x1e, 0x0a,
	0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x69, 0x61, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0xb5, 0x02, 0x0a, 0x0f, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x25, 0x0a,
	0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x45, 0x0a, 0x1f, 0x66, 0x65, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1c, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x1f, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x22, 0x4c, 0x0a, 0x17, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x12,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x22,
	0x6f, 0x0a, 0x16, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x11, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x10,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x22, 0x6e, 0x0a, 0x18, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x10,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x0f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x22, 0xc4, 0x02, 0x0a, 0x0f, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x7a, 0x0a, 0x18, 0x6d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x81, 0x01, 0x0a, 0x1b, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73,
	0x70, 0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0xcc, 0x0d, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe8, 0x01,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x65, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0a, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe4, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x61, 0xda, 0x41, 0x1b,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3d, 0x3a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8,
	0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9, 0x01, 0x0a, 0x0c, 0x47, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x5e, 0xda, 0x41, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45,
	0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xa8, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x5d, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xd3, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x68, 0xda, 0x41,
	0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x7e, 0xca, 0x41, 0x21, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xfd, 0x02, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x7d, 0xea, 0x41, 0x5e, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x50,
	0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_connection_v1_connection_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_connection_v1_connection_proto_rawDescData = file_google_cloud_bigquery_connection_v1_connection_proto_rawDesc
)

func file_google_cloud_bigquery_connection_v1_connection_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_connection_v1_connection_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_connection_v1_connection_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_connection_v1_connection_proto_rawDescData)
	})
	return file_google_cloud_bigquery_connection_v1_connection_proto_rawDescData
}

var file_google_cloud_bigquery_connection_v1_connection_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_bigquery_connection_v1_connection_proto_goTypes = []interface{}{
	(CloudSqlProperties_DatabaseType)(0),     // 0: google.cloud.bigquery.connection.v1.CloudSqlProperties.DatabaseType
	(*CreateConnectionRequest)(nil),          // 1: google.cloud.bigquery.connection.v1.CreateConnectionRequest
	(*GetConnectionRequest)(nil),             // 2: google.cloud.bigquery.connection.v1.GetConnectionRequest
	(*ListConnectionsRequest)(nil),           // 3: google.cloud.bigquery.connection.v1.ListConnectionsRequest
	(*ListConnectionsResponse)(nil),          // 4: google.cloud.bigquery.connection.v1.ListConnectionsResponse
	(*UpdateConnectionRequest)(nil),          // 5: google.cloud.bigquery.connection.v1.UpdateConnectionRequest
	(*DeleteConnectionRequest)(nil),          // 6: google.cloud.bigquery.connection.v1.DeleteConnectionRequest
	(*Connection)(nil),                       // 7: google.cloud.bigquery.connection.v1.Connection
	(*CloudSqlProperties)(nil),               // 8: google.cloud.bigquery.connection.v1.CloudSqlProperties
	(*CloudSqlCredential)(nil),               // 9: google.cloud.bigquery.connection.v1.CloudSqlCredential
	(*CloudSpannerProperties)(nil),           // 10: google.cloud.bigquery.connection.v1.CloudSpannerProperties
	(*AwsProperties)(nil),                    // 11: google.cloud.bigquery.connection.v1.AwsProperties
	(*AwsCrossAccountRole)(nil),              // 12: google.cloud.bigquery.connection.v1.AwsCrossAccountRole
	(*AwsAccessRole)(nil),                    // 13: google.cloud.bigquery.connection.v1.AwsAccessRole
	(*AzureProperties)(nil),                  // 14: google.cloud.bigquery.connection.v1.AzureProperties
	(*CloudResourceProperties)(nil),          // 15: google.cloud.bigquery.connection.v1.CloudResourceProperties
	(*MetastoreServiceConfig)(nil),           // 16: google.cloud.bigquery.connection.v1.MetastoreServiceConfig
	(*SparkHistoryServerConfig)(nil),         // 17: google.cloud.bigquery.connection.v1.SparkHistoryServerConfig
	(*SparkProperties)(nil),                  // 18: google.cloud.bigquery.connection.v1.SparkProperties
	(*fieldmaskpb.FieldMask)(nil),            // 19: google.protobuf.FieldMask
	(*iampb.GetIamPolicyRequest)(nil),        // 20: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),        // 21: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 22: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                    // 23: google.protobuf.Empty
	(*iampb.Policy)(nil),                     // 24: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 25: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_bigquery_connection_v1_connection_proto_depIdxs = []int32{
	7,  // 0: google.cloud.bigquery.connection.v1.CreateConnectionRequest.connection:type_name -> google.cloud.bigquery.connection.v1.Connection
	7,  // 1: google.cloud.bigquery.connection.v1.ListConnectionsResponse.connections:type_name -> google.cloud.bigquery.connection.v1.Connection
	7,  // 2: google.cloud.bigquery.connection.v1.UpdateConnectionRequest.connection:type_name -> google.cloud.bigquery.connection.v1.Connection
	19, // 3: google.cloud.bigquery.connection.v1.UpdateConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 4: google.cloud.bigquery.connection.v1.Connection.cloud_sql:type_name -> google.cloud.bigquery.connection.v1.CloudSqlProperties
	11, // 5: google.cloud.bigquery.connection.v1.Connection.aws:type_name -> google.cloud.bigquery.connection.v1.AwsProperties
	14, // 6: google.cloud.bigquery.connection.v1.Connection.azure:type_name -> google.cloud.bigquery.connection.v1.AzureProperties
	10, // 7: google.cloud.bigquery.connection.v1.Connection.cloud_spanner:type_name -> google.cloud.bigquery.connection.v1.CloudSpannerProperties
	15, // 8: google.cloud.bigquery.connection.v1.Connection.cloud_resource:type_name -> google.cloud.bigquery.connection.v1.CloudResourceProperties
	18, // 9: google.cloud.bigquery.connection.v1.Connection.spark:type_name -> google.cloud.bigquery.connection.v1.SparkProperties
	0,  // 10: google.cloud.bigquery.connection.v1.CloudSqlProperties.type:type_name -> google.cloud.bigquery.connection.v1.CloudSqlProperties.DatabaseType
	9,  // 11: google.cloud.bigquery.connection.v1.CloudSqlProperties.credential:type_name -> google.cloud.bigquery.connection.v1.CloudSqlCredential
	12, // 12: google.cloud.bigquery.connection.v1.AwsProperties.cross_account_role:type_name -> google.cloud.bigquery.connection.v1.AwsCrossAccountRole
	13, // 13: google.cloud.bigquery.connection.v1.AwsProperties.access_role:type_name -> google.cloud.bigquery.connection.v1.AwsAccessRole
	16, // 14: google.cloud.bigquery.connection.v1.SparkProperties.metastore_service_config:type_name -> google.cloud.bigquery.connection.v1.MetastoreServiceConfig
	17, // 15: google.cloud.bigquery.connection.v1.SparkProperties.spark_history_server_config:type_name -> google.cloud.bigquery.connection.v1.SparkHistoryServerConfig
	1,  // 16: google.cloud.bigquery.connection.v1.ConnectionService.CreateConnection:input_type -> google.cloud.bigquery.connection.v1.CreateConnectionRequest
	2,  // 17: google.cloud.bigquery.connection.v1.ConnectionService.GetConnection:input_type -> google.cloud.bigquery.connection.v1.GetConnectionRequest
	3,  // 18: google.cloud.bigquery.connection.v1.ConnectionService.ListConnections:input_type -> google.cloud.bigquery.connection.v1.ListConnectionsRequest
	5,  // 19: google.cloud.bigquery.connection.v1.ConnectionService.UpdateConnection:input_type -> google.cloud.bigquery.connection.v1.UpdateConnectionRequest
	6,  // 20: google.cloud.bigquery.connection.v1.ConnectionService.DeleteConnection:input_type -> google.cloud.bigquery.connection.v1.DeleteConnectionRequest
	20, // 21: google.cloud.bigquery.connection.v1.ConnectionService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	21, // 22: google.cloud.bigquery.connection.v1.ConnectionService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	22, // 23: google.cloud.bigquery.connection.v1.ConnectionService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	7,  // 24: google.cloud.bigquery.connection.v1.ConnectionService.CreateConnection:output_type -> google.cloud.bigquery.connection.v1.Connection
	7,  // 25: google.cloud.bigquery.connection.v1.ConnectionService.GetConnection:output_type -> google.cloud.bigquery.connection.v1.Connection
	4,  // 26: google.cloud.bigquery.connection.v1.ConnectionService.ListConnections:output_type -> google.cloud.bigquery.connection.v1.ListConnectionsResponse
	7,  // 27: google.cloud.bigquery.connection.v1.ConnectionService.UpdateConnection:output_type -> google.cloud.bigquery.connection.v1.Connection
	23, // 28: google.cloud.bigquery.connection.v1.ConnectionService.DeleteConnection:output_type -> google.protobuf.Empty
	24, // 29: google.cloud.bigquery.connection.v1.ConnectionService.GetIamPolicy:output_type -> google.iam.v1.Policy
	24, // 30: google.cloud.bigquery.connection.v1.ConnectionService.SetIamPolicy:output_type -> google.iam.v1.Policy
	25, // 31: google.cloud.bigquery.connection.v1.ConnectionService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	24, // [24:32] is the sub-list for method output_type
	16, // [16:24] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_connection_v1_connection_proto_init() }
func file_google_cloud_bigquery_connection_v1_connection_proto_init() {
	if File_google_cloud_bigquery_connection_v1_connection_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSqlProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSqlCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSpannerProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsCrossAccountRole); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsAccessRole); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudResourceProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetastoreServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkHistoryServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Connection_CloudSql)(nil),
		(*Connection_Aws)(nil),
		(*Connection_Azure)(nil),
		(*Connection_CloudSpanner)(nil),
		(*Connection_CloudResource)(nil),
		(*Connection_Spark)(nil),
	}
	file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*AwsProperties_CrossAccountRole)(nil),
		(*AwsProperties_AccessRole)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_connection_v1_connection_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_connection_v1_connection_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_connection_v1_connection_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_connection_v1_connection_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_connection_v1_connection_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_connection_v1_connection_proto = out.File
	file_google_cloud_bigquery_connection_v1_connection_proto_rawDesc = nil
	file_google_cloud_bigquery_connection_v1_connection_proto_goTypes = nil
	file_google_cloud_bigquery_connection_v1_connection_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConnectionServiceClient is the client API for ConnectionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConnectionServiceClient interface {
	// Creates a new connection.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns specified connection.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns a list of connections in the given project.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Updates the specified connection. For security reasons, also resets
	// credential if connection properties are in the update field mask.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Deletes connection and associated credential.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	//
	// Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a `NOT_FOUND` error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type connectionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConnectionServiceClient(cc grpc.ClientConnInterface) ConnectionServiceClient {
	return &connectionServiceClient{cc}
}

func (c *connectionServiceClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/CreateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/GetConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/ListConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/UpdateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/DeleteConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConnectionServiceServer is the server API for ConnectionService service.
type ConnectionServiceServer interface {
	// Creates a new connection.
	CreateConnection(context.Context, *CreateConnectionRequest) (*Connection, error)
	// Returns specified connection.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Returns a list of connections in the given project.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Updates the specified connection. For security reasons, also resets
	// credential if connection properties are in the update field mask.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*Connection, error)
	// Deletes connection and associated credential.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*emptypb.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	//
	// Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a `NOT_FOUND` error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedConnectionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConnectionServiceServer struct {
}

func (*UnimplementedConnectionServiceServer) CreateConnection(context.Context, *CreateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) GetConnection(context.Context, *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (*UnimplementedConnectionServiceServer) UpdateConnection(context.Context, *UpdateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) DeleteConnection(context.Context, *DeleteConnectionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedConnectionServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedConnectionServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterConnectionServiceServer(s *grpc.Server, srv ConnectionServiceServer) {
	s.RegisterService(&_ConnectionService_serviceDesc, srv)
}

func _ConnectionService_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/CreateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/GetConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/ListConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/UpdateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/DeleteConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConnectionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.connection.v1.ConnectionService",
	HandlerType: (*ConnectionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConnection",
			Handler:    _ConnectionService_CreateConnection_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _ConnectionService_GetConnection_Handler,
		},
		{
			MethodName: "ListConnections",
			Handler:    _ConnectionService_ListConnections_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _ConnectionService_UpdateConnection_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _ConnectionService_DeleteConnection_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ConnectionService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ConnectionService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ConnectionService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/connection/v1/connection.proto",
}
