// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto

package appgatewayspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum containing list of all possible network connectivity options
// supported by BeyondCorp AppGateway.
type AppGateway_Type int32

const (
	// Default value. This value is unused.
	AppGateway_TYPE_UNSPECIFIED AppGateway_Type = 0
	// TCP Proxy based BeyondCorp Connection. API will default to this if unset.
	AppGateway_TCP_PROXY AppGateway_Type = 1
)

// Enum value maps for AppGateway_Type.
var (
	AppGateway_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TCP_PROXY",
	}
	AppGateway_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TCP_PROXY":        1,
	}
)

func (x AppGateway_Type) Enum() *AppGateway_Type {
	p := new(AppGateway_Type)
	*p = x
	return p
}

func (x AppGateway_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppGateway_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes[0].Descriptor()
}

func (AppGateway_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes[0]
}

func (x AppGateway_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppGateway_Type.Descriptor instead.
func (AppGateway_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{5, 0}
}

// Represents the different states of an AppGateway.
type AppGateway_State int32

const (
	// Default value. This value is unused.
	AppGateway_STATE_UNSPECIFIED AppGateway_State = 0
	// AppGateway is being created.
	AppGateway_CREATING AppGateway_State = 1
	// AppGateway has been created.
	AppGateway_CREATED AppGateway_State = 2
	// AppGateway's configuration is being updated.
	AppGateway_UPDATING AppGateway_State = 3
	// AppGateway is being deleted.
	AppGateway_DELETING AppGateway_State = 4
	// AppGateway is down and may be restored in the future.
	// This happens when CCFE sends ProjectState = OFF.
	AppGateway_DOWN AppGateway_State = 5
)

// Enum value maps for AppGateway_State.
var (
	AppGateway_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "UPDATING",
		4: "DELETING",
		5: "DOWN",
	}
	AppGateway_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"UPDATING":          3,
		"DELETING":          4,
		"DOWN":              5,
	}
)

func (x AppGateway_State) Enum() *AppGateway_State {
	p := new(AppGateway_State)
	*p = x
	return p
}

func (x AppGateway_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppGateway_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes[1].Descriptor()
}

func (AppGateway_State) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes[1]
}

func (x AppGateway_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppGateway_State.Descriptor instead.
func (AppGateway_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{5, 1}
}

// Enum containing list of all possible host types supported by BeyondCorp
// Connection.
type AppGateway_HostType int32

const (
	// Default value. This value is unused.
	AppGateway_HOST_TYPE_UNSPECIFIED AppGateway_HostType = 0
	// AppGateway hosted in a GCP regional managed instance group.
	AppGateway_GCP_REGIONAL_MIG AppGateway_HostType = 1
)

// Enum value maps for AppGateway_HostType.
var (
	AppGateway_HostType_name = map[int32]string{
		0: "HOST_TYPE_UNSPECIFIED",
		1: "GCP_REGIONAL_MIG",
	}
	AppGateway_HostType_value = map[string]int32{
		"HOST_TYPE_UNSPECIFIED": 0,
		"GCP_REGIONAL_MIG":      1,
	}
)

func (x AppGateway_HostType) Enum() *AppGateway_HostType {
	p := new(AppGateway_HostType)
	*p = x
	return p
}

func (x AppGateway_HostType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppGateway_HostType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes[2].Descriptor()
}

func (AppGateway_HostType) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes[2]
}

func (x AppGateway_HostType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppGateway_HostType.Descriptor instead.
func (AppGateway_HostType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{5, 2}
}

// Request message for BeyondCorp.ListAppGateways.
type ListAppGatewaysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AppGateway location using the form:
	// `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][BeyondCorp.ListAppGatewaysResponse.next_page_token] to
	// determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous
	// ListAppGatewaysRequest, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter specifying constraints of a list operation.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results. See
	// [Sorting
	// order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
	// for more information.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAppGatewaysRequest) Reset() {
	*x = ListAppGatewaysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAppGatewaysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAppGatewaysRequest) ProtoMessage() {}

func (x *ListAppGatewaysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAppGatewaysRequest.ProtoReflect.Descriptor instead.
func (*ListAppGatewaysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListAppGatewaysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAppGatewaysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAppGatewaysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAppGatewaysRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAppGatewaysRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for BeyondCorp.ListAppGateways.
type ListAppGatewaysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of BeyondCorp AppGateways in the project.
	AppGateways []*AppGateway `protobuf:"bytes,1,rep,name=app_gateways,json=appGateways,proto3" json:"app_gateways,omitempty"`
	// A token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// A list of locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAppGatewaysResponse) Reset() {
	*x = ListAppGatewaysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAppGatewaysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAppGatewaysResponse) ProtoMessage() {}

func (x *ListAppGatewaysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAppGatewaysResponse.ProtoReflect.Descriptor instead.
func (*ListAppGatewaysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListAppGatewaysResponse) GetAppGateways() []*AppGateway {
	if x != nil {
		return x.AppGateways
	}
	return nil
}

func (x *ListAppGatewaysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAppGatewaysResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for BeyondCorp.GetAppGateway.
type GetAppGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BeyondCorp AppGateway name using the form:
	// `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAppGatewayRequest) Reset() {
	*x = GetAppGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAppGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAppGatewayRequest) ProtoMessage() {}

func (x *GetAppGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAppGatewayRequest.ProtoReflect.Descriptor instead.
func (*GetAppGatewayRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetAppGatewayRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BeyondCorp.CreateAppGateway.
type CreateAppGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource project name of the AppGateway location using the
	// form: `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. User-settable AppGateway resource ID.
	//  * Must start with a letter.
	//  * Must contain between 4-63 characters from `/[a-z][0-9]-/`.
	//  * Must end with a number or a letter.
	AppGatewayId string `protobuf:"bytes,2,opt,name=app_gateway_id,json=appGatewayId,proto3" json:"app_gateway_id,omitempty"`
	// Required. A BeyondCorp AppGateway resource.
	AppGateway *AppGateway `protobuf:"bytes,3,opt,name=app_gateway,json=appGateway,proto3" json:"app_gateway,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAppGatewayRequest) Reset() {
	*x = CreateAppGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAppGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAppGatewayRequest) ProtoMessage() {}

func (x *CreateAppGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAppGatewayRequest.ProtoReflect.Descriptor instead.
func (*CreateAppGatewayRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateAppGatewayRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAppGatewayRequest) GetAppGatewayId() string {
	if x != nil {
		return x.AppGatewayId
	}
	return ""
}

func (x *CreateAppGatewayRequest) GetAppGateway() *AppGateway {
	if x != nil {
		return x.AppGateway
	}
	return nil
}

func (x *CreateAppGatewayRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateAppGatewayRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for BeyondCorp.DeleteAppGateway.
type DeleteAppGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BeyondCorp AppGateway name using the form:
	// `projects/{project_id}/locations/{location_id}/appGateways/{app_gateway_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteAppGatewayRequest) Reset() {
	*x = DeleteAppGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAppGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAppGatewayRequest) ProtoMessage() {}

func (x *DeleteAppGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAppGatewayRequest.ProtoReflect.Descriptor instead.
func (*DeleteAppGatewayRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteAppGatewayRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAppGatewayRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteAppGatewayRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// A BeyondCorp AppGateway resource represents a BeyondCorp protected AppGateway
// to a remote application. It creates all the necessary GCP components needed
// for creating a BeyondCorp protected AppGateway. Multiple connectors can be
// authorised for a single AppGateway.
type AppGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique resource name of the AppGateway.
	// The name is ignored when creating an AppGateway.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when the resource was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Resource labels to represent user provided metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. An arbitrary user-provided name for the AppGateway. Cannot exceed
	// 64 characters.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. A unique identifier for the instance generated by the
	// system.
	Uid string `protobuf:"bytes,6,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The type of network connectivity used by the AppGateway.
	Type AppGateway_Type `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.beyondcorp.appgateways.v1.AppGateway_Type" json:"type,omitempty"`
	// Output only. The current state of the AppGateway.
	State AppGateway_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.beyondcorp.appgateways.v1.AppGateway_State" json:"state,omitempty"`
	// Output only. Server-defined URI for this resource.
	Uri string `protobuf:"bytes,9,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. A list of connections allocated for the Gateway
	AllocatedConnections []*AppGateway_AllocatedConnection `protobuf:"bytes,10,rep,name=allocated_connections,json=allocatedConnections,proto3" json:"allocated_connections,omitempty"`
	// Required. The type of hosting used by the AppGateway.
	HostType AppGateway_HostType `protobuf:"varint,11,opt,name=host_type,json=hostType,proto3,enum=google.cloud.beyondcorp.appgateways.v1.AppGateway_HostType" json:"host_type,omitempty"`
}

func (x *AppGateway) Reset() {
	*x = AppGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppGateway) ProtoMessage() {}

func (x *AppGateway) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppGateway.ProtoReflect.Descriptor instead.
func (*AppGateway) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{5}
}

func (x *AppGateway) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AppGateway) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AppGateway) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AppGateway) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AppGateway) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AppGateway) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AppGateway) GetType() AppGateway_Type {
	if x != nil {
		return x.Type
	}
	return AppGateway_TYPE_UNSPECIFIED
}

func (x *AppGateway) GetState() AppGateway_State {
	if x != nil {
		return x.State
	}
	return AppGateway_STATE_UNSPECIFIED
}

func (x *AppGateway) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *AppGateway) GetAllocatedConnections() []*AppGateway_AllocatedConnection {
	if x != nil {
		return x.AllocatedConnections
	}
	return nil
}

func (x *AppGateway) GetHostType() AppGateway_HostType {
	if x != nil {
		return x.HostType
	}
	return AppGateway_HOST_TYPE_UNSPECIFIED
}

// Represents the metadata of the long-running operation.
type AppGatewayOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *AppGatewayOperationMetadata) Reset() {
	*x = AppGatewayOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppGatewayOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppGatewayOperationMetadata) ProtoMessage() {}

func (x *AppGatewayOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppGatewayOperationMetadata.ProtoReflect.Descriptor instead.
func (*AppGatewayOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{6}
}

func (x *AppGatewayOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AppGatewayOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *AppGatewayOperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *AppGatewayOperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *AppGatewayOperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *AppGatewayOperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *AppGatewayOperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Allocated connection of the AppGateway.
type AppGateway_AllocatedConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The PSC uri of an allocated connection
	PscUri string `protobuf:"bytes,1,opt,name=psc_uri,json=pscUri,proto3" json:"psc_uri,omitempty"`
	// Required. The ingress port of an allocated connection
	IngressPort int32 `protobuf:"varint,2,opt,name=ingress_port,json=ingressPort,proto3" json:"ingress_port,omitempty"`
}

func (x *AppGateway_AllocatedConnection) Reset() {
	*x = AppGateway_AllocatedConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppGateway_AllocatedConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppGateway_AllocatedConnection) ProtoMessage() {}

func (x *AppGateway_AllocatedConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppGateway_AllocatedConnection.ProtoReflect.Descriptor instead.
func (*AppGateway_AllocatedConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AppGateway_AllocatedConnection) GetPscUri() string {
	if x != nil {
		return x.PscUri
	}
	return ""
}

func (x *AppGateway_AllocatedConnection) GetIngressPort() int32 {
	if x != nil {
		return x.IngressPort
	}
	return 0
}

var File_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto protoreflect.FileDescriptor

var file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDesc = []byte{
	0x0a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe1, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xba, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x5f, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x0b,
	0x61, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x58, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb2, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x12, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x61, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x58, 0x0a, 0x0b,
	0x61, 0x70, 0x70, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xa9, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0xb6, 0x09, 0x0a, 0x0a, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x80, 0x01, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x09, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x48, 0x6f, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x5b, 0x0a, 0x13, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1c, 0x0a, 0x07, 0x70, 0x73, 0x63, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x73, 0x63, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a,
	0x0c, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x50, 0x6f, 0x72, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x2b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x54, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x01, 0x22, 0x5f, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x05, 0x22, 0x3b,
	0x0a, 0x08, 0x48, 0x6f, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x48, 0x4f,
	0x53, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x43, 0x50, 0x5f, 0x52, 0x45, 0x47,
	0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x4d, 0x49, 0x47, 0x10, 0x01, 0x3a, 0x6c, 0xea, 0x41, 0x69,
	0x0a, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x61, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70,
	0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x7d, 0x22, 0xdf, 0x02, 0x0a, 0x1b, 0x41, 0x70,
	0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xf6, 0x07, 0x0a, 0x12,
	0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xd4, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70,
	0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e,
	0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x22, 0x3e, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x89, 0x02,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x94, 0x01, 0xca, 0x41, 0x29, 0x0a, 0x0a, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x12, 0x1b, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x61, 0x70, 0x70,
	0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70,
	0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0xe9, 0x01, 0x0a, 0x10, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70,
	0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75,
	0xca, 0x41, 0x34, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x1b, 0x41, 0x70, 0x70, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0x94, 0x02, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73,
	0x2e, 0x76, 0x31, 0x42, 0x17, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x61,
	0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x61, 0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x70, 0x62, 0x3b, 0x61,
	0x70, 0x70, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x43, 0x6f, 0x72, 0x70, 0x2e, 0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x43, 0x6f, 0x72, 0x70, 0x5c,
	0x41, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x42, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x43, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescOnce sync.Once
	file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescData = file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDesc
)

func file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescGZIP() []byte {
	file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescData)
	})
	return file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDescData
}

var file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_goTypes = []interface{}{
	(AppGateway_Type)(0),                   // 0: google.cloud.beyondcorp.appgateways.v1.AppGateway.Type
	(AppGateway_State)(0),                  // 1: google.cloud.beyondcorp.appgateways.v1.AppGateway.State
	(AppGateway_HostType)(0),               // 2: google.cloud.beyondcorp.appgateways.v1.AppGateway.HostType
	(*ListAppGatewaysRequest)(nil),         // 3: google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest
	(*ListAppGatewaysResponse)(nil),        // 4: google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysResponse
	(*GetAppGatewayRequest)(nil),           // 5: google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest
	(*CreateAppGatewayRequest)(nil),        // 6: google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest
	(*DeleteAppGatewayRequest)(nil),        // 7: google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest
	(*AppGateway)(nil),                     // 8: google.cloud.beyondcorp.appgateways.v1.AppGateway
	(*AppGatewayOperationMetadata)(nil),    // 9: google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata
	(*AppGateway_AllocatedConnection)(nil), // 10: google.cloud.beyondcorp.appgateways.v1.AppGateway.AllocatedConnection
	nil,                                    // 11: google.cloud.beyondcorp.appgateways.v1.AppGateway.LabelsEntry
	(*timestamppb.Timestamp)(nil),          // 12: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),        // 13: google.longrunning.Operation
}
var file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_depIdxs = []int32{
	8,  // 0: google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysResponse.app_gateways:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway
	8,  // 1: google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest.app_gateway:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway
	12, // 2: google.cloud.beyondcorp.appgateways.v1.AppGateway.create_time:type_name -> google.protobuf.Timestamp
	12, // 3: google.cloud.beyondcorp.appgateways.v1.AppGateway.update_time:type_name -> google.protobuf.Timestamp
	11, // 4: google.cloud.beyondcorp.appgateways.v1.AppGateway.labels:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway.LabelsEntry
	0,  // 5: google.cloud.beyondcorp.appgateways.v1.AppGateway.type:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway.Type
	1,  // 6: google.cloud.beyondcorp.appgateways.v1.AppGateway.state:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway.State
	10, // 7: google.cloud.beyondcorp.appgateways.v1.AppGateway.allocated_connections:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway.AllocatedConnection
	2,  // 8: google.cloud.beyondcorp.appgateways.v1.AppGateway.host_type:type_name -> google.cloud.beyondcorp.appgateways.v1.AppGateway.HostType
	12, // 9: google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	12, // 10: google.cloud.beyondcorp.appgateways.v1.AppGatewayOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	3,  // 11: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.ListAppGateways:input_type -> google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysRequest
	5,  // 12: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.GetAppGateway:input_type -> google.cloud.beyondcorp.appgateways.v1.GetAppGatewayRequest
	6,  // 13: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.CreateAppGateway:input_type -> google.cloud.beyondcorp.appgateways.v1.CreateAppGatewayRequest
	7,  // 14: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.DeleteAppGateway:input_type -> google.cloud.beyondcorp.appgateways.v1.DeleteAppGatewayRequest
	4,  // 15: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.ListAppGateways:output_type -> google.cloud.beyondcorp.appgateways.v1.ListAppGatewaysResponse
	8,  // 16: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.GetAppGateway:output_type -> google.cloud.beyondcorp.appgateways.v1.AppGateway
	13, // 17: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.CreateAppGateway:output_type -> google.longrunning.Operation
	13, // 18: google.cloud.beyondcorp.appgateways.v1.AppGatewaysService.DeleteAppGateway:output_type -> google.longrunning.Operation
	15, // [15:19] is the sub-list for method output_type
	11, // [11:15] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_init() }
func file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_init() {
	if File_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAppGatewaysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAppGatewaysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAppGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAppGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAppGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppGateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppGatewayOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppGateway_AllocatedConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_msgTypes,
	}.Build()
	File_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto = out.File
	file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_rawDesc = nil
	file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_goTypes = nil
	file_google_cloud_beyondcorp_appgateways_v1_app_gateways_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AppGatewaysServiceClient is the client API for AppGatewaysService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AppGatewaysServiceClient interface {
	// Lists AppGateways in a given project and location.
	ListAppGateways(ctx context.Context, in *ListAppGatewaysRequest, opts ...grpc.CallOption) (*ListAppGatewaysResponse, error)
	// Gets details of a single AppGateway.
	GetAppGateway(ctx context.Context, in *GetAppGatewayRequest, opts ...grpc.CallOption) (*AppGateway, error)
	// Creates a new AppGateway in a given project and location.
	CreateAppGateway(ctx context.Context, in *CreateAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single AppGateway.
	DeleteAppGateway(ctx context.Context, in *DeleteAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type appGatewaysServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAppGatewaysServiceClient(cc grpc.ClientConnInterface) AppGatewaysServiceClient {
	return &appGatewaysServiceClient{cc}
}

func (c *appGatewaysServiceClient) ListAppGateways(ctx context.Context, in *ListAppGatewaysRequest, opts ...grpc.CallOption) (*ListAppGatewaysResponse, error) {
	out := new(ListAppGatewaysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/ListAppGateways", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appGatewaysServiceClient) GetAppGateway(ctx context.Context, in *GetAppGatewayRequest, opts ...grpc.CallOption) (*AppGateway, error) {
	out := new(AppGateway)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/GetAppGateway", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appGatewaysServiceClient) CreateAppGateway(ctx context.Context, in *CreateAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/CreateAppGateway", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appGatewaysServiceClient) DeleteAppGateway(ctx context.Context, in *DeleteAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/DeleteAppGateway", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppGatewaysServiceServer is the server API for AppGatewaysService service.
type AppGatewaysServiceServer interface {
	// Lists AppGateways in a given project and location.
	ListAppGateways(context.Context, *ListAppGatewaysRequest) (*ListAppGatewaysResponse, error)
	// Gets details of a single AppGateway.
	GetAppGateway(context.Context, *GetAppGatewayRequest) (*AppGateway, error)
	// Creates a new AppGateway in a given project and location.
	CreateAppGateway(context.Context, *CreateAppGatewayRequest) (*longrunningpb.Operation, error)
	// Deletes a single AppGateway.
	DeleteAppGateway(context.Context, *DeleteAppGatewayRequest) (*longrunningpb.Operation, error)
}

// UnimplementedAppGatewaysServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAppGatewaysServiceServer struct {
}

func (*UnimplementedAppGatewaysServiceServer) ListAppGateways(context.Context, *ListAppGatewaysRequest) (*ListAppGatewaysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppGateways not implemented")
}
func (*UnimplementedAppGatewaysServiceServer) GetAppGateway(context.Context, *GetAppGatewayRequest) (*AppGateway, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppGateway not implemented")
}
func (*UnimplementedAppGatewaysServiceServer) CreateAppGateway(context.Context, *CreateAppGatewayRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppGateway not implemented")
}
func (*UnimplementedAppGatewaysServiceServer) DeleteAppGateway(context.Context, *DeleteAppGatewayRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppGateway not implemented")
}

func RegisterAppGatewaysServiceServer(s *grpc.Server, srv AppGatewaysServiceServer) {
	s.RegisterService(&_AppGatewaysService_serviceDesc, srv)
}

func _AppGatewaysService_ListAppGateways_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppGatewaysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).ListAppGateways(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/ListAppGateways",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).ListAppGateways(ctx, req.(*ListAppGatewaysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppGatewaysService_GetAppGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).GetAppGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/GetAppGateway",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).GetAppGateway(ctx, req.(*GetAppGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppGatewaysService_CreateAppGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).CreateAppGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/CreateAppGateway",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).CreateAppGateway(ctx, req.(*CreateAppGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppGatewaysService_DeleteAppGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).DeleteAppGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/DeleteAppGateway",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).DeleteAppGateway(ctx, req.(*DeleteAppGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AppGatewaysService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
	HandlerType: (*AppGatewaysServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAppGateways",
			Handler:    _AppGatewaysService_ListAppGateways_Handler,
		},
		{
			MethodName: "GetAppGateway",
			Handler:    _AppGatewaysService_GetAppGateway_Handler,
		},
		{
			MethodName: "CreateAppGateway",
			Handler:    _AppGatewaysService_CreateAppGateway_Handler,
		},
		{
			MethodName: "DeleteAppGateway",
			Handler:    _AppGatewaysService_DeleteAppGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto",
}
