// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/baremetalsolution/v2/nfs_share.proto

package baremetalsolutionpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible states for this NFS share.
type NfsShare_State int32

const (
	// The share is in an unknown state.
	NfsShare_STATE_UNSPECIFIED NfsShare_State = 0
	// The share has been provisioned.
	NfsShare_PROVISIONED NfsShare_State = 1
)

// Enum value maps for NfsShare_State.
var (
	NfsShare_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONED",
	}
	NfsShare_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONED":       1,
	}
)

func (x NfsShare_State) Enum() *NfsShare_State {
	p := new(NfsShare_State)
	*p = x
	return p
}

func (x NfsShare_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NfsShare_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_enumTypes[0].Descriptor()
}

func (NfsShare_State) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_nfs_share_proto_enumTypes[0]
}

func (x NfsShare_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NfsShare_State.Descriptor instead.
func (NfsShare_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{0, 0}
}

// The possible mount permissions.
type NfsShare_MountPermissions int32

const (
	// Permissions were not specified.
	NfsShare_MOUNT_PERMISSIONS_UNSPECIFIED NfsShare_MountPermissions = 0
	// NFS share can be mount with read-only permissions.
	NfsShare_READ NfsShare_MountPermissions = 1
	// NFS share can be mount with read-write permissions.
	NfsShare_READ_WRITE NfsShare_MountPermissions = 2
)

// Enum value maps for NfsShare_MountPermissions.
var (
	NfsShare_MountPermissions_name = map[int32]string{
		0: "MOUNT_PERMISSIONS_UNSPECIFIED",
		1: "READ",
		2: "READ_WRITE",
	}
	NfsShare_MountPermissions_value = map[string]int32{
		"MOUNT_PERMISSIONS_UNSPECIFIED": 0,
		"READ":                          1,
		"READ_WRITE":                    2,
	}
)

func (x NfsShare_MountPermissions) Enum() *NfsShare_MountPermissions {
	p := new(NfsShare_MountPermissions)
	*p = x
	return p
}

func (x NfsShare_MountPermissions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NfsShare_MountPermissions) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_enumTypes[1].Descriptor()
}

func (NfsShare_MountPermissions) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_nfs_share_proto_enumTypes[1]
}

func (x NfsShare_MountPermissions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NfsShare_MountPermissions.Descriptor instead.
func (NfsShare_MountPermissions) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{0, 1}
}

// An NFS share.
type NfsShare struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the NFS share.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. An identifier for the NFS share, generated by the backend.
	NfsShareId string `protobuf:"bytes,2,opt,name=nfs_share_id,json=nfsShareId,proto3" json:"nfs_share_id,omitempty"`
	// The state of the NFS share.
	State NfsShare_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.baremetalsolution.v2.NfsShare_State" json:"state,omitempty"`
	// The volume containing the share.
	Volume string `protobuf:"bytes,4,opt,name=volume,proto3" json:"volume,omitempty"`
	// List of allowed access points.
	AllowedClients []*NfsShare_AllowedClient `protobuf:"bytes,5,rep,name=allowed_clients,json=allowedClients,proto3" json:"allowed_clients,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *NfsShare) Reset() {
	*x = NfsShare{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NfsShare) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NfsShare) ProtoMessage() {}

func (x *NfsShare) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NfsShare.ProtoReflect.Descriptor instead.
func (*NfsShare) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{0}
}

func (x *NfsShare) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NfsShare) GetNfsShareId() string {
	if x != nil {
		return x.NfsShareId
	}
	return ""
}

func (x *NfsShare) GetState() NfsShare_State {
	if x != nil {
		return x.State
	}
	return NfsShare_STATE_UNSPECIFIED
}

func (x *NfsShare) GetVolume() string {
	if x != nil {
		return x.Volume
	}
	return ""
}

func (x *NfsShare) GetAllowedClients() []*NfsShare_AllowedClient {
	if x != nil {
		return x.AllowedClients
	}
	return nil
}

func (x *NfsShare) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Message for requesting NFS share information.
type GetNfsShareRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNfsShareRequest) Reset() {
	*x = GetNfsShareRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNfsShareRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNfsShareRequest) ProtoMessage() {}

func (x *GetNfsShareRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNfsShareRequest.ProtoReflect.Descriptor instead.
func (*GetNfsShareRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{1}
}

func (x *GetNfsShareRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting a list of NFS shares.
type ListNfsSharesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListNfsSharesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server might return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results from the server.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListNfsSharesRequest) Reset() {
	*x = ListNfsSharesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNfsSharesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNfsSharesRequest) ProtoMessage() {}

func (x *ListNfsSharesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNfsSharesRequest.ProtoReflect.Descriptor instead.
func (*ListNfsSharesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{2}
}

func (x *ListNfsSharesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNfsSharesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNfsSharesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNfsSharesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message containing the list of NFS shares.
type ListNfsSharesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of NFS shares.
	NfsShares []*NfsShare `protobuf:"bytes,1,rep,name=nfs_shares,json=nfsShares,proto3" json:"nfs_shares,omitempty"`
	// A token identifying a page of results from the server.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNfsSharesResponse) Reset() {
	*x = ListNfsSharesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNfsSharesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNfsSharesResponse) ProtoMessage() {}

func (x *ListNfsSharesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNfsSharesResponse.ProtoReflect.Descriptor instead.
func (*ListNfsSharesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{3}
}

func (x *ListNfsSharesResponse) GetNfsShares() []*NfsShare {
	if x != nil {
		return x.NfsShares
	}
	return nil
}

func (x *ListNfsSharesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNfsSharesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message requesting to updating a NFS share.
type UpdateNfsShareRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The NFS share to update.
	//
	// The `name` field is used to identify the NFS share to update.
	// Format: projects/{project}/locations/{location}/nfsShares/{nfs_share}
	NfsShare *NfsShare `protobuf:"bytes,1,opt,name=nfs_share,json=nfsShare,proto3" json:"nfs_share,omitempty"`
	// The list of fields to update.
	// The only currently supported fields are:
	//   `labels`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNfsShareRequest) Reset() {
	*x = UpdateNfsShareRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNfsShareRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNfsShareRequest) ProtoMessage() {}

func (x *UpdateNfsShareRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNfsShareRequest.ProtoReflect.Descriptor instead.
func (*UpdateNfsShareRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateNfsShareRequest) GetNfsShare() *NfsShare {
	if x != nil {
		return x.NfsShare
	}
	return nil
}

func (x *UpdateNfsShareRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Represents an 'access point' for the share.
type NfsShare_AllowedClient struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The network the access point sits on.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// The IP address of the share on this network.
	ShareIp string `protobuf:"bytes,2,opt,name=share_ip,json=shareIp,proto3" json:"share_ip,omitempty"`
	// The subnet of IP addresses permitted to access the share.
	AllowedClientsCidr string `protobuf:"bytes,3,opt,name=allowed_clients_cidr,json=allowedClientsCidr,proto3" json:"allowed_clients_cidr,omitempty"`
	// Mount permissions.
	MountPermissions NfsShare_MountPermissions `protobuf:"varint,4,opt,name=mount_permissions,json=mountPermissions,proto3,enum=google.cloud.baremetalsolution.v2.NfsShare_MountPermissions" json:"mount_permissions,omitempty"`
	// Allow dev flag.  Which controls whether to allow creation of devices.
	AllowDev bool `protobuf:"varint,5,opt,name=allow_dev,json=allowDev,proto3" json:"allow_dev,omitempty"`
	// Allow the setuid flag.
	AllowSuid bool `protobuf:"varint,6,opt,name=allow_suid,json=allowSuid,proto3" json:"allow_suid,omitempty"`
	// Disable root squashing, which is a feature of NFS.
	// Root squash is a special mapping of the remote superuser (root) identity
	// when using identity authentication.
	NoRootSquash bool `protobuf:"varint,7,opt,name=no_root_squash,json=noRootSquash,proto3" json:"no_root_squash,omitempty"`
}

func (x *NfsShare_AllowedClient) Reset() {
	*x = NfsShare_AllowedClient{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NfsShare_AllowedClient) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NfsShare_AllowedClient) ProtoMessage() {}

func (x *NfsShare_AllowedClient) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NfsShare_AllowedClient.ProtoReflect.Descriptor instead.
func (*NfsShare_AllowedClient) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP(), []int{0, 0}
}

func (x *NfsShare_AllowedClient) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NfsShare_AllowedClient) GetShareIp() string {
	if x != nil {
		return x.ShareIp
	}
	return ""
}

func (x *NfsShare_AllowedClient) GetAllowedClientsCidr() string {
	if x != nil {
		return x.AllowedClientsCidr
	}
	return ""
}

func (x *NfsShare_AllowedClient) GetMountPermissions() NfsShare_MountPermissions {
	if x != nil {
		return x.MountPermissions
	}
	return NfsShare_MOUNT_PERMISSIONS_UNSPECIFIED
}

func (x *NfsShare_AllowedClient) GetAllowDev() bool {
	if x != nil {
		return x.AllowDev
	}
	return false
}

func (x *NfsShare_AllowedClient) GetAllowSuid() bool {
	if x != nil {
		return x.AllowSuid
	}
	return false
}

func (x *NfsShare_AllowedClient) GetNoRootSquash() bool {
	if x != nil {
		return x.NoRootSquash
	}
	return false
}

var File_google_cloud_baremetalsolution_v2_nfs_share_proto protoreflect.FileDescriptor

var file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x08, 0x0a, 0x08, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x6e, 0x66,
	0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x49,
	0x64, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x44, 0x0a, 0x06, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x12, 0x62, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x66,
	0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xf2, 0x02, 0x0a, 0x0d, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x19, 0x0a, 0x08, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x73, 0x68, 0x61, 0x72, 0x65, 0x49, 0x70, 0x12, 0x30, 0x0a, 0x14, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63,
	0x69, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x69, 0x64, 0x72, 0x12, 0x69, 0x0a,
	0x11, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x66, 0x73,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x64, 0x65, 0x76, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x44, 0x65, 0x76, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73,
	0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x53, 0x75, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x6f, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x73, 0x71, 0x75, 0x61, 0x73, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6e, 0x6f,
	0x52, 0x6f, 0x6f, 0x74, 0x53, 0x71, 0x75, 0x61, 0x73, 0x68, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x2f, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49,
	0x4f, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x22, 0x4f, 0x0a, 0x10, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x1d, 0x4d, 0x4f,
	0x55, 0x4e, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f,
	0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x29, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x46, 0x53, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x66, 0x73, 0x5f,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x7d, 0x22, 0x5b, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4e, 0x66, 0x73,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x46, 0x53, 0x53, 0x68, 0x61, 0x72, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xad, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x66, 0x73, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0xad, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x66, 0x73, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a,
	0x0a, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x52, 0x09,
	0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x66,
	0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a,
	0x09, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0xfc, 0x01, 0x0a, 0x25, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x42, 0x0d, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x32, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x72,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56,
	0x32, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescOnce sync.Once
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescData = file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDesc
)

func file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescGZIP() []byte {
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescOnce.Do(func() {
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescData)
	})
	return file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDescData
}

var file_google_cloud_baremetalsolution_v2_nfs_share_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_baremetalsolution_v2_nfs_share_proto_goTypes = []interface{}{
	(NfsShare_State)(0),            // 0: google.cloud.baremetalsolution.v2.NfsShare.State
	(NfsShare_MountPermissions)(0), // 1: google.cloud.baremetalsolution.v2.NfsShare.MountPermissions
	(*NfsShare)(nil),               // 2: google.cloud.baremetalsolution.v2.NfsShare
	(*GetNfsShareRequest)(nil),     // 3: google.cloud.baremetalsolution.v2.GetNfsShareRequest
	(*ListNfsSharesRequest)(nil),   // 4: google.cloud.baremetalsolution.v2.ListNfsSharesRequest
	(*ListNfsSharesResponse)(nil),  // 5: google.cloud.baremetalsolution.v2.ListNfsSharesResponse
	(*UpdateNfsShareRequest)(nil),  // 6: google.cloud.baremetalsolution.v2.UpdateNfsShareRequest
	(*NfsShare_AllowedClient)(nil), // 7: google.cloud.baremetalsolution.v2.NfsShare.AllowedClient
	nil,                            // 8: google.cloud.baremetalsolution.v2.NfsShare.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),  // 9: google.protobuf.FieldMask
}
var file_google_cloud_baremetalsolution_v2_nfs_share_proto_depIdxs = []int32{
	0, // 0: google.cloud.baremetalsolution.v2.NfsShare.state:type_name -> google.cloud.baremetalsolution.v2.NfsShare.State
	7, // 1: google.cloud.baremetalsolution.v2.NfsShare.allowed_clients:type_name -> google.cloud.baremetalsolution.v2.NfsShare.AllowedClient
	8, // 2: google.cloud.baremetalsolution.v2.NfsShare.labels:type_name -> google.cloud.baremetalsolution.v2.NfsShare.LabelsEntry
	2, // 3: google.cloud.baremetalsolution.v2.ListNfsSharesResponse.nfs_shares:type_name -> google.cloud.baremetalsolution.v2.NfsShare
	2, // 4: google.cloud.baremetalsolution.v2.UpdateNfsShareRequest.nfs_share:type_name -> google.cloud.baremetalsolution.v2.NfsShare
	9, // 5: google.cloud.baremetalsolution.v2.UpdateNfsShareRequest.update_mask:type_name -> google.protobuf.FieldMask
	1, // 6: google.cloud.baremetalsolution.v2.NfsShare.AllowedClient.mount_permissions:type_name -> google.cloud.baremetalsolution.v2.NfsShare.MountPermissions
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_baremetalsolution_v2_nfs_share_proto_init() }
func file_google_cloud_baremetalsolution_v2_nfs_share_proto_init() {
	if File_google_cloud_baremetalsolution_v2_nfs_share_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NfsShare); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNfsShareRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNfsSharesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNfsSharesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNfsShareRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NfsShare_AllowedClient); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_baremetalsolution_v2_nfs_share_proto_goTypes,
		DependencyIndexes: file_google_cloud_baremetalsolution_v2_nfs_share_proto_depIdxs,
		EnumInfos:         file_google_cloud_baremetalsolution_v2_nfs_share_proto_enumTypes,
		MessageInfos:      file_google_cloud_baremetalsolution_v2_nfs_share_proto_msgTypes,
	}.Build()
	File_google_cloud_baremetalsolution_v2_nfs_share_proto = out.File
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_rawDesc = nil
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_goTypes = nil
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_depIdxs = nil
}
