// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/analytics/admin/v1alpha/resources.proto

package adminpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The category selected for this property, used for industry benchmarking.
type IndustryCategory int32

const (
	// Industry category unspecified
	IndustryCategory_INDUSTRY_CATEGORY_UNSPECIFIED IndustryCategory = 0
	// Automotive
	IndustryCategory_AUTOMOTIVE IndustryCategory = 1
	// Business and industrial markets
	IndustryCategory_BUSINESS_AND_INDUSTRIAL_MARKETS IndustryCategory = 2
	// Finance
	IndustryCategory_FINANCE IndustryCategory = 3
	// Healthcare
	IndustryCategory_HEALTHCARE IndustryCategory = 4
	// Technology
	IndustryCategory_TECHNOLOGY IndustryCategory = 5
	// Travel
	IndustryCategory_TRAVEL IndustryCategory = 6
	// Other
	IndustryCategory_OTHER IndustryCategory = 7
	// Arts and entertainment
	IndustryCategory_ARTS_AND_ENTERTAINMENT IndustryCategory = 8
	// Beauty and fitness
	IndustryCategory_BEAUTY_AND_FITNESS IndustryCategory = 9
	// Books and literature
	IndustryCategory_BOOKS_AND_LITERATURE IndustryCategory = 10
	// Food and drink
	IndustryCategory_FOOD_AND_DRINK IndustryCategory = 11
	// Games
	IndustryCategory_GAMES IndustryCategory = 12
	// Hobbies and leisure
	IndustryCategory_HOBBIES_AND_LEISURE IndustryCategory = 13
	// Home and garden
	IndustryCategory_HOME_AND_GARDEN IndustryCategory = 14
	// Internet and telecom
	IndustryCategory_INTERNET_AND_TELECOM IndustryCategory = 15
	// Law and government
	IndustryCategory_LAW_AND_GOVERNMENT IndustryCategory = 16
	// News
	IndustryCategory_NEWS IndustryCategory = 17
	// Online communities
	IndustryCategory_ONLINE_COMMUNITIES IndustryCategory = 18
	// People and society
	IndustryCategory_PEOPLE_AND_SOCIETY IndustryCategory = 19
	// Pets and animals
	IndustryCategory_PETS_AND_ANIMALS IndustryCategory = 20
	// Real estate
	IndustryCategory_REAL_ESTATE IndustryCategory = 21
	// Reference
	IndustryCategory_REFERENCE IndustryCategory = 22
	// Science
	IndustryCategory_SCIENCE IndustryCategory = 23
	// Sports
	IndustryCategory_SPORTS IndustryCategory = 24
	// Jobs and education
	IndustryCategory_JOBS_AND_EDUCATION IndustryCategory = 25
	// Shopping
	IndustryCategory_SHOPPING IndustryCategory = 26
)

// Enum value maps for IndustryCategory.
var (
	IndustryCategory_name = map[int32]string{
		0:  "INDUSTRY_CATEGORY_UNSPECIFIED",
		1:  "AUTOMOTIVE",
		2:  "BUSINESS_AND_INDUSTRIAL_MARKETS",
		3:  "FINANCE",
		4:  "HEALTHCARE",
		5:  "TECHNOLOGY",
		6:  "TRAVEL",
		7:  "OTHER",
		8:  "ARTS_AND_ENTERTAINMENT",
		9:  "BEAUTY_AND_FITNESS",
		10: "BOOKS_AND_LITERATURE",
		11: "FOOD_AND_DRINK",
		12: "GAMES",
		13: "HOBBIES_AND_LEISURE",
		14: "HOME_AND_GARDEN",
		15: "INTERNET_AND_TELECOM",
		16: "LAW_AND_GOVERNMENT",
		17: "NEWS",
		18: "ONLINE_COMMUNITIES",
		19: "PEOPLE_AND_SOCIETY",
		20: "PETS_AND_ANIMALS",
		21: "REAL_ESTATE",
		22: "REFERENCE",
		23: "SCIENCE",
		24: "SPORTS",
		25: "JOBS_AND_EDUCATION",
		26: "SHOPPING",
	}
	IndustryCategory_value = map[string]int32{
		"INDUSTRY_CATEGORY_UNSPECIFIED":   0,
		"AUTOMOTIVE":                      1,
		"BUSINESS_AND_INDUSTRIAL_MARKETS": 2,
		"FINANCE":                         3,
		"HEALTHCARE":                      4,
		"TECHNOLOGY":                      5,
		"TRAVEL":                          6,
		"OTHER":                           7,
		"ARTS_AND_ENTERTAINMENT":          8,
		"BEAUTY_AND_FITNESS":              9,
		"BOOKS_AND_LITERATURE":            10,
		"FOOD_AND_DRINK":                  11,
		"GAMES":                           12,
		"HOBBIES_AND_LEISURE":             13,
		"HOME_AND_GARDEN":                 14,
		"INTERNET_AND_TELECOM":            15,
		"LAW_AND_GOVERNMENT":              16,
		"NEWS":                            17,
		"ONLINE_COMMUNITIES":              18,
		"PEOPLE_AND_SOCIETY":              19,
		"PETS_AND_ANIMALS":                20,
		"REAL_ESTATE":                     21,
		"REFERENCE":                       22,
		"SCIENCE":                         23,
		"SPORTS":                          24,
		"JOBS_AND_EDUCATION":              25,
		"SHOPPING":                        26,
	}
)

func (x IndustryCategory) Enum() *IndustryCategory {
	p := new(IndustryCategory)
	*p = x
	return p
}

func (x IndustryCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndustryCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[0].Descriptor()
}

func (IndustryCategory) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[0]
}

func (x IndustryCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndustryCategory.Descriptor instead.
func (IndustryCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{0}
}

// Various levels of service for Google Analytics.
type ServiceLevel int32

const (
	// Service level not specified or invalid.
	ServiceLevel_SERVICE_LEVEL_UNSPECIFIED ServiceLevel = 0
	// The standard version of Google Analytics.
	ServiceLevel_GOOGLE_ANALYTICS_STANDARD ServiceLevel = 1
	// The paid, premium version of Google Analytics.
	ServiceLevel_GOOGLE_ANALYTICS_360 ServiceLevel = 2
)

// Enum value maps for ServiceLevel.
var (
	ServiceLevel_name = map[int32]string{
		0: "SERVICE_LEVEL_UNSPECIFIED",
		1: "GOOGLE_ANALYTICS_STANDARD",
		2: "GOOGLE_ANALYTICS_360",
	}
	ServiceLevel_value = map[string]int32{
		"SERVICE_LEVEL_UNSPECIFIED": 0,
		"GOOGLE_ANALYTICS_STANDARD": 1,
		"GOOGLE_ANALYTICS_360":      2,
	}
)

func (x ServiceLevel) Enum() *ServiceLevel {
	p := new(ServiceLevel)
	*p = x
	return p
}

func (x ServiceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[1].Descriptor()
}

func (ServiceLevel) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[1]
}

func (x ServiceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceLevel.Descriptor instead.
func (ServiceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{1}
}

// Different kinds of actors that can make changes to Google Analytics
// resources.
type ActorType int32

const (
	// Unknown or unspecified actor type.
	ActorType_ACTOR_TYPE_UNSPECIFIED ActorType = 0
	// Changes made by the user specified in actor_email.
	ActorType_USER ActorType = 1
	// Changes made by the Google Analytics system.
	ActorType_SYSTEM ActorType = 2
	// Changes made by Google Analytics support team staff.
	ActorType_SUPPORT ActorType = 3
)

// Enum value maps for ActorType.
var (
	ActorType_name = map[int32]string{
		0: "ACTOR_TYPE_UNSPECIFIED",
		1: "USER",
		2: "SYSTEM",
		3: "SUPPORT",
	}
	ActorType_value = map[string]int32{
		"ACTOR_TYPE_UNSPECIFIED": 0,
		"USER":                   1,
		"SYSTEM":                 2,
		"SUPPORT":                3,
	}
)

func (x ActorType) Enum() *ActorType {
	p := new(ActorType)
	*p = x
	return p
}

func (x ActorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[2].Descriptor()
}

func (ActorType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[2]
}

func (x ActorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActorType.Descriptor instead.
func (ActorType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2}
}

// Types of actions that may change a resource.
type ActionType int32

const (
	// Action type unknown or not specified.
	ActionType_ACTION_TYPE_UNSPECIFIED ActionType = 0
	// Resource was created in this change.
	ActionType_CREATED ActionType = 1
	// Resource was updated in this change.
	ActionType_UPDATED ActionType = 2
	// Resource was deleted in this change.
	ActionType_DELETED ActionType = 3
)

// Enum value maps for ActionType.
var (
	ActionType_name = map[int32]string{
		0: "ACTION_TYPE_UNSPECIFIED",
		1: "CREATED",
		2: "UPDATED",
		3: "DELETED",
	}
	ActionType_value = map[string]int32{
		"ACTION_TYPE_UNSPECIFIED": 0,
		"CREATED":                 1,
		"UPDATED":                 2,
		"DELETED":                 3,
	}
)

func (x ActionType) Enum() *ActionType {
	p := new(ActionType)
	*p = x
	return p
}

func (x ActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[3].Descriptor()
}

func (ActionType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[3]
}

func (x ActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionType.Descriptor instead.
func (ActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{3}
}

// Types of resources whose changes may be returned from change history.
type ChangeHistoryResourceType int32

const (
	// Resource type unknown or not specified.
	ChangeHistoryResourceType_CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED ChangeHistoryResourceType = 0
	// Account resource
	ChangeHistoryResourceType_ACCOUNT ChangeHistoryResourceType = 1
	// Property resource
	ChangeHistoryResourceType_PROPERTY ChangeHistoryResourceType = 2
	// FirebaseLink resource
	ChangeHistoryResourceType_FIREBASE_LINK ChangeHistoryResourceType = 6
	// GoogleAdsLink resource
	ChangeHistoryResourceType_GOOGLE_ADS_LINK ChangeHistoryResourceType = 7
	// GoogleSignalsSettings resource
	ChangeHistoryResourceType_GOOGLE_SIGNALS_SETTINGS ChangeHistoryResourceType = 8
	// ConversionEvent resource
	ChangeHistoryResourceType_CONVERSION_EVENT ChangeHistoryResourceType = 9
	// MeasurementProtocolSecret resource
	ChangeHistoryResourceType_MEASUREMENT_PROTOCOL_SECRET ChangeHistoryResourceType = 10
	// CustomDimension resource
	ChangeHistoryResourceType_CUSTOM_DIMENSION ChangeHistoryResourceType = 11
	// CustomMetric resource
	ChangeHistoryResourceType_CUSTOM_METRIC ChangeHistoryResourceType = 12
	// DataRetentionSettings resource
	ChangeHistoryResourceType_DATA_RETENTION_SETTINGS ChangeHistoryResourceType = 13
	// DisplayVideo360AdvertiserLink resource
	ChangeHistoryResourceType_DISPLAY_VIDEO_360_ADVERTISER_LINK ChangeHistoryResourceType = 14
	// DisplayVideo360AdvertiserLinkProposal resource
	ChangeHistoryResourceType_DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL ChangeHistoryResourceType = 15
	// SearchAds360Link resource
	ChangeHistoryResourceType_SEARCH_ADS_360_LINK ChangeHistoryResourceType = 16
	// DataStream resource
	ChangeHistoryResourceType_DATA_STREAM ChangeHistoryResourceType = 18
	// AttributionSettings resource
	ChangeHistoryResourceType_ATTRIBUTION_SETTINGS ChangeHistoryResourceType = 20
	// ExpandedDataSet resource
	ChangeHistoryResourceType_EXPANDED_DATA_SET ChangeHistoryResourceType = 21
	// ChannelGroup resource
	ChangeHistoryResourceType_CHANNEL_GROUP ChangeHistoryResourceType = 22
	// EnhancedMeasurementSettings resource
	ChangeHistoryResourceType_ENHANCED_MEASUREMENT_SETTINGS ChangeHistoryResourceType = 24
	// AdSenseLink resource
	ChangeHistoryResourceType_ADSENSE_LINK ChangeHistoryResourceType = 27
	// Audience resource
	ChangeHistoryResourceType_AUDIENCE ChangeHistoryResourceType = 28
	// EventCreateRule resource
	ChangeHistoryResourceType_EVENT_CREATE_RULE ChangeHistoryResourceType = 29
)

// Enum value maps for ChangeHistoryResourceType.
var (
	ChangeHistoryResourceType_name = map[int32]string{
		0:  "CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED",
		1:  "ACCOUNT",
		2:  "PROPERTY",
		6:  "FIREBASE_LINK",
		7:  "GOOGLE_ADS_LINK",
		8:  "GOOGLE_SIGNALS_SETTINGS",
		9:  "CONVERSION_EVENT",
		10: "MEASUREMENT_PROTOCOL_SECRET",
		11: "CUSTOM_DIMENSION",
		12: "CUSTOM_METRIC",
		13: "DATA_RETENTION_SETTINGS",
		14: "DISPLAY_VIDEO_360_ADVERTISER_LINK",
		15: "DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL",
		16: "SEARCH_ADS_360_LINK",
		18: "DATA_STREAM",
		20: "ATTRIBUTION_SETTINGS",
		21: "EXPANDED_DATA_SET",
		22: "CHANNEL_GROUP",
		24: "ENHANCED_MEASUREMENT_SETTINGS",
		27: "ADSENSE_LINK",
		28: "AUDIENCE",
		29: "EVENT_CREATE_RULE",
	}
	ChangeHistoryResourceType_value = map[string]int32{
		"CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED": 0,
		"ACCOUNT":                                    1,
		"PROPERTY":                                   2,
		"FIREBASE_LINK":                              6,
		"GOOGLE_ADS_LINK":                            7,
		"GOOGLE_SIGNALS_SETTINGS":                    8,
		"CONVERSION_EVENT":                           9,
		"MEASUREMENT_PROTOCOL_SECRET":                10,
		"CUSTOM_DIMENSION":                           11,
		"CUSTOM_METRIC":                              12,
		"DATA_RETENTION_SETTINGS":                    13,
		"DISPLAY_VIDEO_360_ADVERTISER_LINK":          14,
		"DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL": 15,
		"SEARCH_ADS_360_LINK":                        16,
		"DATA_STREAM":                                18,
		"ATTRIBUTION_SETTINGS":                       20,
		"EXPANDED_DATA_SET":                          21,
		"CHANNEL_GROUP":                              22,
		"ENHANCED_MEASUREMENT_SETTINGS":              24,
		"ADSENSE_LINK":                               27,
		"AUDIENCE":                                   28,
		"EVENT_CREATE_RULE":                          29,
	}
)

func (x ChangeHistoryResourceType) Enum() *ChangeHistoryResourceType {
	p := new(ChangeHistoryResourceType)
	*p = x
	return p
}

func (x ChangeHistoryResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeHistoryResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[4].Descriptor()
}

func (ChangeHistoryResourceType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[4]
}

func (x ChangeHistoryResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeHistoryResourceType.Descriptor instead.
func (ChangeHistoryResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{4}
}

// Status of the Google Signals settings.
type GoogleSignalsState int32

const (
	// Google Signals status defaults to GOOGLE_SIGNALS_STATE_UNSPECIFIED to
	// represent that the user has not made an explicit choice.
	GoogleSignalsState_GOOGLE_SIGNALS_STATE_UNSPECIFIED GoogleSignalsState = 0
	// Google Signals is enabled.
	GoogleSignalsState_GOOGLE_SIGNALS_ENABLED GoogleSignalsState = 1
	// Google Signals is disabled.
	GoogleSignalsState_GOOGLE_SIGNALS_DISABLED GoogleSignalsState = 2
)

// Enum value maps for GoogleSignalsState.
var (
	GoogleSignalsState_name = map[int32]string{
		0: "GOOGLE_SIGNALS_STATE_UNSPECIFIED",
		1: "GOOGLE_SIGNALS_ENABLED",
		2: "GOOGLE_SIGNALS_DISABLED",
	}
	GoogleSignalsState_value = map[string]int32{
		"GOOGLE_SIGNALS_STATE_UNSPECIFIED": 0,
		"GOOGLE_SIGNALS_ENABLED":           1,
		"GOOGLE_SIGNALS_DISABLED":          2,
	}
)

func (x GoogleSignalsState) Enum() *GoogleSignalsState {
	p := new(GoogleSignalsState)
	*p = x
	return p
}

func (x GoogleSignalsState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GoogleSignalsState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[5].Descriptor()
}

func (GoogleSignalsState) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[5]
}

func (x GoogleSignalsState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GoogleSignalsState.Descriptor instead.
func (GoogleSignalsState) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{5}
}

// Consent field of the Google Signals settings.
type GoogleSignalsConsent int32

const (
	// Google Signals consent value defaults to
	// GOOGLE_SIGNALS_CONSENT_UNSPECIFIED.  This will be treated as
	// GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED.
	GoogleSignalsConsent_GOOGLE_SIGNALS_CONSENT_UNSPECIFIED GoogleSignalsConsent = 0
	// Terms of service have been accepted
	GoogleSignalsConsent_GOOGLE_SIGNALS_CONSENT_CONSENTED GoogleSignalsConsent = 2
	// Terms of service have not been accepted
	GoogleSignalsConsent_GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED GoogleSignalsConsent = 1
)

// Enum value maps for GoogleSignalsConsent.
var (
	GoogleSignalsConsent_name = map[int32]string{
		0: "GOOGLE_SIGNALS_CONSENT_UNSPECIFIED",
		2: "GOOGLE_SIGNALS_CONSENT_CONSENTED",
		1: "GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED",
	}
	GoogleSignalsConsent_value = map[string]int32{
		"GOOGLE_SIGNALS_CONSENT_UNSPECIFIED":   0,
		"GOOGLE_SIGNALS_CONSENT_CONSENTED":     2,
		"GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED": 1,
	}
)

func (x GoogleSignalsConsent) Enum() *GoogleSignalsConsent {
	p := new(GoogleSignalsConsent)
	*p = x
	return p
}

func (x GoogleSignalsConsent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GoogleSignalsConsent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[6].Descriptor()
}

func (GoogleSignalsConsent) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[6]
}

func (x GoogleSignalsConsent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GoogleSignalsConsent.Descriptor instead.
func (GoogleSignalsConsent) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{6}
}

// An indication of which product the user initiated a link proposal from.
type LinkProposalInitiatingProduct int32

const (
	// Unspecified product.
	LinkProposalInitiatingProduct_LINK_PROPOSAL_INITIATING_PRODUCT_UNSPECIFIED LinkProposalInitiatingProduct = 0
	// This proposal was created by a user from Google Analytics.
	LinkProposalInitiatingProduct_GOOGLE_ANALYTICS LinkProposalInitiatingProduct = 1
	// This proposal was created by a user from a linked product (not Google
	// Analytics).
	LinkProposalInitiatingProduct_LINKED_PRODUCT LinkProposalInitiatingProduct = 2
)

// Enum value maps for LinkProposalInitiatingProduct.
var (
	LinkProposalInitiatingProduct_name = map[int32]string{
		0: "LINK_PROPOSAL_INITIATING_PRODUCT_UNSPECIFIED",
		1: "GOOGLE_ANALYTICS",
		2: "LINKED_PRODUCT",
	}
	LinkProposalInitiatingProduct_value = map[string]int32{
		"LINK_PROPOSAL_INITIATING_PRODUCT_UNSPECIFIED": 0,
		"GOOGLE_ANALYTICS": 1,
		"LINKED_PRODUCT":   2,
	}
)

func (x LinkProposalInitiatingProduct) Enum() *LinkProposalInitiatingProduct {
	p := new(LinkProposalInitiatingProduct)
	*p = x
	return p
}

func (x LinkProposalInitiatingProduct) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LinkProposalInitiatingProduct) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[7].Descriptor()
}

func (LinkProposalInitiatingProduct) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[7]
}

func (x LinkProposalInitiatingProduct) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LinkProposalInitiatingProduct.Descriptor instead.
func (LinkProposalInitiatingProduct) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{7}
}

// The state of a link proposal resource.
type LinkProposalState int32

const (
	// Unspecified state
	LinkProposalState_LINK_PROPOSAL_STATE_UNSPECIFIED LinkProposalState = 0
	// This proposal is awaiting review from a Google Analytics user. This
	// proposal will automatically expire after some time.
	LinkProposalState_AWAITING_REVIEW_FROM_GOOGLE_ANALYTICS LinkProposalState = 1
	// This proposal is awaiting review from a user of a linked product. This
	// proposal will automatically expire after some time.
	LinkProposalState_AWAITING_REVIEW_FROM_LINKED_PRODUCT LinkProposalState = 2
	// This proposal has been withdrawn by an admin on the initiating product.
	// This proposal will be automatically deleted after some time.
	LinkProposalState_WITHDRAWN LinkProposalState = 3
	// This proposal has been declined by an admin on the receiving product. This
	// proposal will be automatically deleted after some time.
	LinkProposalState_DECLINED LinkProposalState = 4
	// This proposal expired due to lack of response from an admin on the
	// receiving product. This proposal will be automatically deleted after some
	// time.
	LinkProposalState_EXPIRED LinkProposalState = 5
	// This proposal has become obsolete because a link was directly created to
	// the same external product resource that this proposal specifies. This
	// proposal will be automatically deleted after some time.
	LinkProposalState_OBSOLETE LinkProposalState = 6
)

// Enum value maps for LinkProposalState.
var (
	LinkProposalState_name = map[int32]string{
		0: "LINK_PROPOSAL_STATE_UNSPECIFIED",
		1: "AWAITING_REVIEW_FROM_GOOGLE_ANALYTICS",
		2: "AWAITING_REVIEW_FROM_LINKED_PRODUCT",
		3: "WITHDRAWN",
		4: "DECLINED",
		5: "EXPIRED",
		6: "OBSOLETE",
	}
	LinkProposalState_value = map[string]int32{
		"LINK_PROPOSAL_STATE_UNSPECIFIED":       0,
		"AWAITING_REVIEW_FROM_GOOGLE_ANALYTICS": 1,
		"AWAITING_REVIEW_FROM_LINKED_PRODUCT":   2,
		"WITHDRAWN":                             3,
		"DECLINED":                              4,
		"EXPIRED":                               5,
		"OBSOLETE":                              6,
	}
)

func (x LinkProposalState) Enum() *LinkProposalState {
	p := new(LinkProposalState)
	*p = x
	return p
}

func (x LinkProposalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LinkProposalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[8].Descriptor()
}

func (LinkProposalState) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[8]
}

func (x LinkProposalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LinkProposalState.Descriptor instead.
func (LinkProposalState) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{8}
}

// Types of Property resources.
type PropertyType int32

const (
	// Unknown or unspecified property type
	PropertyType_PROPERTY_TYPE_UNSPECIFIED PropertyType = 0
	// Ordinary GA4 property
	PropertyType_PROPERTY_TYPE_ORDINARY PropertyType = 1
	// GA4 subproperty
	PropertyType_PROPERTY_TYPE_SUBPROPERTY PropertyType = 2
	// GA4 rollup property
	PropertyType_PROPERTY_TYPE_ROLLUP PropertyType = 3
)

// Enum value maps for PropertyType.
var (
	PropertyType_name = map[int32]string{
		0: "PROPERTY_TYPE_UNSPECIFIED",
		1: "PROPERTY_TYPE_ORDINARY",
		2: "PROPERTY_TYPE_SUBPROPERTY",
		3: "PROPERTY_TYPE_ROLLUP",
	}
	PropertyType_value = map[string]int32{
		"PROPERTY_TYPE_UNSPECIFIED": 0,
		"PROPERTY_TYPE_ORDINARY":    1,
		"PROPERTY_TYPE_SUBPROPERTY": 2,
		"PROPERTY_TYPE_ROLLUP":      3,
	}
)

func (x PropertyType) Enum() *PropertyType {
	p := new(PropertyType)
	*p = x
	return p
}

func (x PropertyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PropertyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[9].Descriptor()
}

func (PropertyType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[9]
}

func (x PropertyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PropertyType.Descriptor instead.
func (PropertyType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{9}
}

// The type of the data stream.
type DataStream_DataStreamType int32

const (
	// Type unknown or not specified.
	DataStream_DATA_STREAM_TYPE_UNSPECIFIED DataStream_DataStreamType = 0
	// Web data stream.
	DataStream_WEB_DATA_STREAM DataStream_DataStreamType = 1
	// Android app data stream.
	DataStream_ANDROID_APP_DATA_STREAM DataStream_DataStreamType = 2
	// iOS app data stream.
	DataStream_IOS_APP_DATA_STREAM DataStream_DataStreamType = 3
)

// Enum value maps for DataStream_DataStreamType.
var (
	DataStream_DataStreamType_name = map[int32]string{
		0: "DATA_STREAM_TYPE_UNSPECIFIED",
		1: "WEB_DATA_STREAM",
		2: "ANDROID_APP_DATA_STREAM",
		3: "IOS_APP_DATA_STREAM",
	}
	DataStream_DataStreamType_value = map[string]int32{
		"DATA_STREAM_TYPE_UNSPECIFIED": 0,
		"WEB_DATA_STREAM":              1,
		"ANDROID_APP_DATA_STREAM":      2,
		"IOS_APP_DATA_STREAM":          3,
	}
)

func (x DataStream_DataStreamType) Enum() *DataStream_DataStreamType {
	p := new(DataStream_DataStreamType)
	*p = x
	return p
}

func (x DataStream_DataStreamType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStream_DataStreamType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[10].Descriptor()
}

func (DataStream_DataStreamType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[10]
}

func (x DataStream_DataStreamType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStream_DataStreamType.Descriptor instead.
func (DataStream_DataStreamType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2, 0}
}

// Valid values for the scope of this dimension.
type CustomDimension_DimensionScope int32

const (
	// Scope unknown or not specified.
	CustomDimension_DIMENSION_SCOPE_UNSPECIFIED CustomDimension_DimensionScope = 0
	// Dimension scoped to an event.
	CustomDimension_EVENT CustomDimension_DimensionScope = 1
	// Dimension scoped to a user.
	CustomDimension_USER CustomDimension_DimensionScope = 2
	// Dimension scoped to eCommerce items
	CustomDimension_ITEM CustomDimension_DimensionScope = 3
)

// Enum value maps for CustomDimension_DimensionScope.
var (
	CustomDimension_DimensionScope_name = map[int32]string{
		0: "DIMENSION_SCOPE_UNSPECIFIED",
		1: "EVENT",
		2: "USER",
		3: "ITEM",
	}
	CustomDimension_DimensionScope_value = map[string]int32{
		"DIMENSION_SCOPE_UNSPECIFIED": 0,
		"EVENT":                       1,
		"USER":                        2,
		"ITEM":                        3,
	}
)

func (x CustomDimension_DimensionScope) Enum() *CustomDimension_DimensionScope {
	p := new(CustomDimension_DimensionScope)
	*p = x
	return p
}

func (x CustomDimension_DimensionScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomDimension_DimensionScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[11].Descriptor()
}

func (CustomDimension_DimensionScope) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[11]
}

func (x CustomDimension_DimensionScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomDimension_DimensionScope.Descriptor instead.
func (CustomDimension_DimensionScope) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{20, 0}
}

// Possible types of representing the custom metric's value.
//
// Currency representation may change in the future, requiring a breaking API
// change.
type CustomMetric_MeasurementUnit int32

const (
	// MeasurementUnit unspecified or missing.
	CustomMetric_MEASUREMENT_UNIT_UNSPECIFIED CustomMetric_MeasurementUnit = 0
	// This metric uses default units.
	CustomMetric_STANDARD CustomMetric_MeasurementUnit = 1
	// This metric measures a currency.
	CustomMetric_CURRENCY CustomMetric_MeasurementUnit = 2
	// This metric measures feet.
	CustomMetric_FEET CustomMetric_MeasurementUnit = 3
	// This metric measures meters.
	CustomMetric_METERS CustomMetric_MeasurementUnit = 4
	// This metric measures kilometers.
	CustomMetric_KILOMETERS CustomMetric_MeasurementUnit = 5
	// This metric measures miles.
	CustomMetric_MILES CustomMetric_MeasurementUnit = 6
	// This metric measures milliseconds.
	CustomMetric_MILLISECONDS CustomMetric_MeasurementUnit = 7
	// This metric measures seconds.
	CustomMetric_SECONDS CustomMetric_MeasurementUnit = 8
	// This metric measures minutes.
	CustomMetric_MINUTES CustomMetric_MeasurementUnit = 9
	// This metric measures hours.
	CustomMetric_HOURS CustomMetric_MeasurementUnit = 10
)

// Enum value maps for CustomMetric_MeasurementUnit.
var (
	CustomMetric_MeasurementUnit_name = map[int32]string{
		0:  "MEASUREMENT_UNIT_UNSPECIFIED",
		1:  "STANDARD",
		2:  "CURRENCY",
		3:  "FEET",
		4:  "METERS",
		5:  "KILOMETERS",
		6:  "MILES",
		7:  "MILLISECONDS",
		8:  "SECONDS",
		9:  "MINUTES",
		10: "HOURS",
	}
	CustomMetric_MeasurementUnit_value = map[string]int32{
		"MEASUREMENT_UNIT_UNSPECIFIED": 0,
		"STANDARD":                     1,
		"CURRENCY":                     2,
		"FEET":                         3,
		"METERS":                       4,
		"KILOMETERS":                   5,
		"MILES":                        6,
		"MILLISECONDS":                 7,
		"SECONDS":                      8,
		"MINUTES":                      9,
		"HOURS":                        10,
	}
)

func (x CustomMetric_MeasurementUnit) Enum() *CustomMetric_MeasurementUnit {
	p := new(CustomMetric_MeasurementUnit)
	*p = x
	return p
}

func (x CustomMetric_MeasurementUnit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomMetric_MeasurementUnit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[12].Descriptor()
}

func (CustomMetric_MeasurementUnit) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[12]
}

func (x CustomMetric_MeasurementUnit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomMetric_MeasurementUnit.Descriptor instead.
func (CustomMetric_MeasurementUnit) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{21, 0}
}

// The scope of this metric.
type CustomMetric_MetricScope int32

const (
	// Scope unknown or not specified.
	CustomMetric_METRIC_SCOPE_UNSPECIFIED CustomMetric_MetricScope = 0
	// Metric scoped to an event.
	CustomMetric_EVENT CustomMetric_MetricScope = 1
)

// Enum value maps for CustomMetric_MetricScope.
var (
	CustomMetric_MetricScope_name = map[int32]string{
		0: "METRIC_SCOPE_UNSPECIFIED",
		1: "EVENT",
	}
	CustomMetric_MetricScope_value = map[string]int32{
		"METRIC_SCOPE_UNSPECIFIED": 0,
		"EVENT":                    1,
	}
)

func (x CustomMetric_MetricScope) Enum() *CustomMetric_MetricScope {
	p := new(CustomMetric_MetricScope)
	*p = x
	return p
}

func (x CustomMetric_MetricScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomMetric_MetricScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[13].Descriptor()
}

func (CustomMetric_MetricScope) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[13]
}

func (x CustomMetric_MetricScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomMetric_MetricScope.Descriptor instead.
func (CustomMetric_MetricScope) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{21, 1}
}

// Labels that mark the data in this custom metric as data that should be
// restricted to specific users.
type CustomMetric_RestrictedMetricType int32

const (
	// Type unknown or unspecified.
	CustomMetric_RESTRICTED_METRIC_TYPE_UNSPECIFIED CustomMetric_RestrictedMetricType = 0
	// Metric reports cost data.
	CustomMetric_COST_DATA CustomMetric_RestrictedMetricType = 1
	// Metric reports revenue data.
	CustomMetric_REVENUE_DATA CustomMetric_RestrictedMetricType = 2
)

// Enum value maps for CustomMetric_RestrictedMetricType.
var (
	CustomMetric_RestrictedMetricType_name = map[int32]string{
		0: "RESTRICTED_METRIC_TYPE_UNSPECIFIED",
		1: "COST_DATA",
		2: "REVENUE_DATA",
	}
	CustomMetric_RestrictedMetricType_value = map[string]int32{
		"RESTRICTED_METRIC_TYPE_UNSPECIFIED": 0,
		"COST_DATA":                          1,
		"REVENUE_DATA":                       2,
	}
)

func (x CustomMetric_RestrictedMetricType) Enum() *CustomMetric_RestrictedMetricType {
	p := new(CustomMetric_RestrictedMetricType)
	*p = x
	return p
}

func (x CustomMetric_RestrictedMetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomMetric_RestrictedMetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[14].Descriptor()
}

func (CustomMetric_RestrictedMetricType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[14]
}

func (x CustomMetric_RestrictedMetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomMetric_RestrictedMetricType.Descriptor instead.
func (CustomMetric_RestrictedMetricType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{21, 2}
}

// Valid values for the data retention duration.
type DataRetentionSettings_RetentionDuration int32

const (
	// Data retention time duration is not specified.
	DataRetentionSettings_RETENTION_DURATION_UNSPECIFIED DataRetentionSettings_RetentionDuration = 0
	// The data retention time duration is 2 months.
	DataRetentionSettings_TWO_MONTHS DataRetentionSettings_RetentionDuration = 1
	// The data retention time duration is 14 months.
	DataRetentionSettings_FOURTEEN_MONTHS DataRetentionSettings_RetentionDuration = 3
	// The data retention time duration is 26 months.
	// Available to 360 properties only.
	DataRetentionSettings_TWENTY_SIX_MONTHS DataRetentionSettings_RetentionDuration = 4
	// The data retention time duration is 38 months.
	// Available to 360 properties only.
	DataRetentionSettings_THIRTY_EIGHT_MONTHS DataRetentionSettings_RetentionDuration = 5
	// The data retention time duration is 50 months.
	// Available to 360 properties only.
	DataRetentionSettings_FIFTY_MONTHS DataRetentionSettings_RetentionDuration = 6
)

// Enum value maps for DataRetentionSettings_RetentionDuration.
var (
	DataRetentionSettings_RetentionDuration_name = map[int32]string{
		0: "RETENTION_DURATION_UNSPECIFIED",
		1: "TWO_MONTHS",
		3: "FOURTEEN_MONTHS",
		4: "TWENTY_SIX_MONTHS",
		5: "THIRTY_EIGHT_MONTHS",
		6: "FIFTY_MONTHS",
	}
	DataRetentionSettings_RetentionDuration_value = map[string]int32{
		"RETENTION_DURATION_UNSPECIFIED": 0,
		"TWO_MONTHS":                     1,
		"FOURTEEN_MONTHS":                3,
		"TWENTY_SIX_MONTHS":              4,
		"THIRTY_EIGHT_MONTHS":            5,
		"FIFTY_MONTHS":                   6,
	}
)

func (x DataRetentionSettings_RetentionDuration) Enum() *DataRetentionSettings_RetentionDuration {
	p := new(DataRetentionSettings_RetentionDuration)
	*p = x
	return p
}

func (x DataRetentionSettings_RetentionDuration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataRetentionSettings_RetentionDuration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[15].Descriptor()
}

func (DataRetentionSettings_RetentionDuration) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[15]
}

func (x DataRetentionSettings_RetentionDuration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataRetentionSettings_RetentionDuration.Descriptor instead.
func (DataRetentionSettings_RetentionDuration) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{22, 0}
}

// How far back in time events should be considered for inclusion in a
// converting path which leads to the first install of an app or the first
// visit to a site.
type AttributionSettings_AcquisitionConversionEventLookbackWindow int32

const (
	// Lookback window size unspecified.
	AttributionSettings_ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED AttributionSettings_AcquisitionConversionEventLookbackWindow = 0
	// 7-day lookback window.
	AttributionSettings_ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_7_DAYS AttributionSettings_AcquisitionConversionEventLookbackWindow = 1
	// 30-day lookback window.
	AttributionSettings_ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS AttributionSettings_AcquisitionConversionEventLookbackWindow = 2
)

// Enum value maps for AttributionSettings_AcquisitionConversionEventLookbackWindow.
var (
	AttributionSettings_AcquisitionConversionEventLookbackWindow_name = map[int32]string{
		0: "ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED",
		1: "ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_7_DAYS",
		2: "ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS",
	}
	AttributionSettings_AcquisitionConversionEventLookbackWindow_value = map[string]int32{
		"ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED": 0,
		"ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_7_DAYS":      1,
		"ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS":     2,
	}
)

func (x AttributionSettings_AcquisitionConversionEventLookbackWindow) Enum() *AttributionSettings_AcquisitionConversionEventLookbackWindow {
	p := new(AttributionSettings_AcquisitionConversionEventLookbackWindow)
	*p = x
	return p
}

func (x AttributionSettings_AcquisitionConversionEventLookbackWindow) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttributionSettings_AcquisitionConversionEventLookbackWindow) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[16].Descriptor()
}

func (AttributionSettings_AcquisitionConversionEventLookbackWindow) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[16]
}

func (x AttributionSettings_AcquisitionConversionEventLookbackWindow) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttributionSettings_AcquisitionConversionEventLookbackWindow.Descriptor instead.
func (AttributionSettings_AcquisitionConversionEventLookbackWindow) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{23, 0}
}

// How far back in time events should be considered for inclusion in a
// converting path for all conversions other than first app install/first site
// visit.
type AttributionSettings_OtherConversionEventLookbackWindow int32

const (
	// Lookback window size unspecified.
	AttributionSettings_OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED AttributionSettings_OtherConversionEventLookbackWindow = 0
	// 30-day lookback window.
	AttributionSettings_OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS AttributionSettings_OtherConversionEventLookbackWindow = 1
	// 60-day lookback window.
	AttributionSettings_OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_60_DAYS AttributionSettings_OtherConversionEventLookbackWindow = 2
	// 90-day lookback window.
	AttributionSettings_OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_90_DAYS AttributionSettings_OtherConversionEventLookbackWindow = 3
)

// Enum value maps for AttributionSettings_OtherConversionEventLookbackWindow.
var (
	AttributionSettings_OtherConversionEventLookbackWindow_name = map[int32]string{
		0: "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED",
		1: "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS",
		2: "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_60_DAYS",
		3: "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_90_DAYS",
	}
	AttributionSettings_OtherConversionEventLookbackWindow_value = map[string]int32{
		"OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED": 0,
		"OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS":     1,
		"OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_60_DAYS":     2,
		"OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_90_DAYS":     3,
	}
)

func (x AttributionSettings_OtherConversionEventLookbackWindow) Enum() *AttributionSettings_OtherConversionEventLookbackWindow {
	p := new(AttributionSettings_OtherConversionEventLookbackWindow)
	*p = x
	return p
}

func (x AttributionSettings_OtherConversionEventLookbackWindow) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttributionSettings_OtherConversionEventLookbackWindow) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[17].Descriptor()
}

func (AttributionSettings_OtherConversionEventLookbackWindow) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[17]
}

func (x AttributionSettings_OtherConversionEventLookbackWindow) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttributionSettings_OtherConversionEventLookbackWindow.Descriptor instead.
func (AttributionSettings_OtherConversionEventLookbackWindow) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{23, 1}
}

// The reporting attribution model used to calculate conversion credit in this
// property's reports.
type AttributionSettings_ReportingAttributionModel int32

const (
	// Reporting attribution model unspecified.
	AttributionSettings_REPORTING_ATTRIBUTION_MODEL_UNSPECIFIED AttributionSettings_ReportingAttributionModel = 0
	// Data-driven attribution distributes credit for the conversion based on
	// data for each conversion event. Each Data-driven model is specific to
	// each advertiser and each conversion event.
	AttributionSettings_CROSS_CHANNEL_DATA_DRIVEN AttributionSettings_ReportingAttributionModel = 1
	// Ignores direct traffic and attributes 100% of the conversion value to the
	// last channel that the customer clicked through (or engaged view through
	// for YouTube) before converting.
	AttributionSettings_CROSS_CHANNEL_LAST_CLICK AttributionSettings_ReportingAttributionModel = 2
	// Starting in June 2023, new properties can no longer use this model.
	// See
	// [Analytics
	// Help](https://support.google.com/analytics/answer/9164320?hl=en#040623)
	// for more details.
	// Starting in September 2023, we will sunset this model for all properties.
	//
	// Gives all credit for the conversion to the first channel that a customer
	// clicked (or engaged view through for YouTube) before converting.
	AttributionSettings_CROSS_CHANNEL_FIRST_CLICK AttributionSettings_ReportingAttributionModel = 3
	// Starting in June 2023, new properties can no longer use this model.
	// See
	// [Analytics
	// Help](https://support.google.com/analytics/answer/9164320?hl=en#040623)
	// for more details.
	// Starting in September 2023, we will sunset this model for all properties.
	//
	// Distributes the credit for the conversion equally across all the channels
	// a customer clicked (or engaged view through for YouTube) before
	// converting.
	AttributionSettings_CROSS_CHANNEL_LINEAR AttributionSettings_ReportingAttributionModel = 4
	// Starting in June 2023, new properties can no longer use this model.
	// See
	// [Analytics
	// Help](https://support.google.com/analytics/answer/9164320?hl=en#040623)
	// for more details.
	// Starting in September 2023, we will sunset this model for all properties.
	//
	// Attributes 40% credit to the first and last interaction, and the
	// remaining 20% credit is distributed evenly to the middle interactions.
	AttributionSettings_CROSS_CHANNEL_POSITION_BASED AttributionSettings_ReportingAttributionModel = 5
	// Starting in June 2023, new properties can no longer use this model.
	// See
	// [Analytics
	// Help](https://support.google.com/analytics/answer/9164320?hl=en#040623)
	// for more details.
	// Starting in September 2023, we will sunset this model for all properties.
	//
	// Gives more credit to the touchpoints that happened closer in time to
	// the conversion.
	AttributionSettings_CROSS_CHANNEL_TIME_DECAY AttributionSettings_ReportingAttributionModel = 6
	// Attributes 100% of the conversion value to the last Google Ads channel
	// that the customer clicked through before converting.
	AttributionSettings_ADS_PREFERRED_LAST_CLICK AttributionSettings_ReportingAttributionModel = 7
)

// Enum value maps for AttributionSettings_ReportingAttributionModel.
var (
	AttributionSettings_ReportingAttributionModel_name = map[int32]string{
		0: "REPORTING_ATTRIBUTION_MODEL_UNSPECIFIED",
		1: "CROSS_CHANNEL_DATA_DRIVEN",
		2: "CROSS_CHANNEL_LAST_CLICK",
		3: "CROSS_CHANNEL_FIRST_CLICK",
		4: "CROSS_CHANNEL_LINEAR",
		5: "CROSS_CHANNEL_POSITION_BASED",
		6: "CROSS_CHANNEL_TIME_DECAY",
		7: "ADS_PREFERRED_LAST_CLICK",
	}
	AttributionSettings_ReportingAttributionModel_value = map[string]int32{
		"REPORTING_ATTRIBUTION_MODEL_UNSPECIFIED": 0,
		"CROSS_CHANNEL_DATA_DRIVEN":               1,
		"CROSS_CHANNEL_LAST_CLICK":                2,
		"CROSS_CHANNEL_FIRST_CLICK":               3,
		"CROSS_CHANNEL_LINEAR":                    4,
		"CROSS_CHANNEL_POSITION_BASED":            5,
		"CROSS_CHANNEL_TIME_DECAY":                6,
		"ADS_PREFERRED_LAST_CLICK":                7,
	}
)

func (x AttributionSettings_ReportingAttributionModel) Enum() *AttributionSettings_ReportingAttributionModel {
	p := new(AttributionSettings_ReportingAttributionModel)
	*p = x
	return p
}

func (x AttributionSettings_ReportingAttributionModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttributionSettings_ReportingAttributionModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[18].Descriptor()
}

func (AttributionSettings_ReportingAttributionModel) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[18]
}

func (x AttributionSettings_ReportingAttributionModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttributionSettings_ReportingAttributionModel.Descriptor instead.
func (AttributionSettings_ReportingAttributionModel) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{23, 2}
}

// The Conversion Export Scope for data exported to linked Ads Accounts.
type AttributionSettings_AdsWebConversionDataExportScope int32

const (
	// Default value. This value is unused.
	AttributionSettings_ADS_WEB_CONVERSION_DATA_EXPORT_SCOPE_UNSPECIFIED AttributionSettings_AdsWebConversionDataExportScope = 0
	// No data export scope selected yet.
	// Export scope can never be changed back to this value.
	AttributionSettings_NOT_SELECTED_YET AttributionSettings_AdsWebConversionDataExportScope = 1
	// The Ads Web Conversion Data export scope is Cross Channel.
	AttributionSettings_CROSS_CHANNEL AttributionSettings_AdsWebConversionDataExportScope = 2
	// The Ads Web Conversion Data export scope is Ads Preferred.
	AttributionSettings_ADS_PREFERRED AttributionSettings_AdsWebConversionDataExportScope = 3
)

// Enum value maps for AttributionSettings_AdsWebConversionDataExportScope.
var (
	AttributionSettings_AdsWebConversionDataExportScope_name = map[int32]string{
		0: "ADS_WEB_CONVERSION_DATA_EXPORT_SCOPE_UNSPECIFIED",
		1: "NOT_SELECTED_YET",
		2: "CROSS_CHANNEL",
		3: "ADS_PREFERRED",
	}
	AttributionSettings_AdsWebConversionDataExportScope_value = map[string]int32{
		"ADS_WEB_CONVERSION_DATA_EXPORT_SCOPE_UNSPECIFIED": 0,
		"NOT_SELECTED_YET": 1,
		"CROSS_CHANNEL":    2,
		"ADS_PREFERRED":    3,
	}
)

func (x AttributionSettings_AdsWebConversionDataExportScope) Enum() *AttributionSettings_AdsWebConversionDataExportScope {
	p := new(AttributionSettings_AdsWebConversionDataExportScope)
	*p = x
	return p
}

func (x AttributionSettings_AdsWebConversionDataExportScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttributionSettings_AdsWebConversionDataExportScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[19].Descriptor()
}

func (AttributionSettings_AdsWebConversionDataExportScope) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[19]
}

func (x AttributionSettings_AdsWebConversionDataExportScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttributionSettings_AdsWebConversionDataExportScope.Descriptor instead.
func (AttributionSettings_AdsWebConversionDataExportScope) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{23, 3}
}

// A resource message representing a Google Analytics account.
type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this account.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when this account was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when account payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Human-readable display name for this account.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Country of business. Must be a Unicode CLDR region code.
	RegionCode string `protobuf:"bytes,5,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Output only. Indicates whether this Account is soft-deleted or not. Deleted
	// accounts are excluded from List results unless specifically requested.
	Deleted bool `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
}

func (x *Account) Reset() {
	*x = Account{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Account) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Account) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Account) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Account) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Account) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *Account) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

// A resource message representing a Google Analytics GA4 property.
type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this property.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The property type for this Property resource. When creating a
	// property, if the type is "PROPERTY_TYPE_UNSPECIFIED", then
	// "ORDINARY_PROPERTY" will be implied. "SUBPROPERTY" and "ROLLUP_PROPERTY"
	// types cannot yet be created with the Google Analytics Admin API.
	PropertyType PropertyType `protobuf:"varint,14,opt,name=property_type,json=propertyType,proto3,enum=google.analytics.admin.v1alpha.PropertyType" json:"property_type,omitempty"`
	// Output only. Time when the entity was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when entity payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. Resource name of this property's logical parent.
	//
	// Note: The Property-Moving UI can be used to change the parent.
	// Format: accounts/{account}, properties/{property}
	// Example: "accounts/100", "properties/101"
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Human-readable display name for this property.
	//
	// The max allowed display name length is 100 UTF-16 code units.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Industry associated with this property
	// Example: AUTOMOTIVE, FOOD_AND_DRINK
	IndustryCategory IndustryCategory `protobuf:"varint,6,opt,name=industry_category,json=industryCategory,proto3,enum=google.analytics.admin.v1alpha.IndustryCategory" json:"industry_category,omitempty"`
	// Required. Reporting Time Zone, used as the day boundary for reports,
	// regardless of where the data originates. If the time zone honors DST,
	// Analytics will automatically adjust for the changes.
	//
	// NOTE: Changing the time zone only affects data going forward, and is not
	// applied retroactively.
	//
	// Format: https://www.iana.org/time-zones
	// Example: "America/Los_Angeles"
	TimeZone string `protobuf:"bytes,7,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The currency type used in reports involving monetary values.
	//
	//
	// Format: https://en.wikipedia.org/wiki/ISO_4217
	// Examples: "USD", "EUR", "JPY"
	CurrencyCode string `protobuf:"bytes,8,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Output only. The Google Analytics service level that applies to this
	// property.
	ServiceLevel ServiceLevel `protobuf:"varint,10,opt,name=service_level,json=serviceLevel,proto3,enum=google.analytics.admin.v1alpha.ServiceLevel" json:"service_level,omitempty"`
	// Output only. If set, the time at which this property was trashed. If not
	// set, then this property is not currently in the trash can.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. If set, the time at which this trashed property will be
	// permanently deleted. If not set, then this property is not currently in the
	// trash can and is not slated to be deleted.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Immutable. The resource name of the parent account
	// Format: accounts/{account_id}
	// Example: "accounts/123"
	Account string `protobuf:"bytes,13,opt,name=account,proto3" json:"account,omitempty"`
}

func (x *Property) Reset() {
	*x = Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Property) GetPropertyType() PropertyType {
	if x != nil {
		return x.PropertyType
	}
	return PropertyType_PROPERTY_TYPE_UNSPECIFIED
}

func (x *Property) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Property) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Property) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Property) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Property) GetIndustryCategory() IndustryCategory {
	if x != nil {
		return x.IndustryCategory
	}
	return IndustryCategory_INDUSTRY_CATEGORY_UNSPECIFIED
}

func (x *Property) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *Property) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *Property) GetServiceLevel() ServiceLevel {
	if x != nil {
		return x.ServiceLevel
	}
	return ServiceLevel_SERVICE_LEVEL_UNSPECIFIED
}

func (x *Property) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Property) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Property) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

// A resource message representing a data stream.
type DataStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data for specific data stream types. The message that will be
	// set corresponds to the type of this stream.
	//
	// Types that are assignable to StreamData:
	//	*DataStream_WebStreamData_
	//	*DataStream_AndroidAppStreamData_
	//	*DataStream_IosAppStreamData_
	StreamData isDataStream_StreamData `protobuf_oneof:"stream_data"`
	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/dataStreams/{stream_id}
	// Example: "properties/1000/dataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The type of this DataStream resource.
	Type DataStream_DataStreamType `protobuf:"varint,2,opt,name=type,proto3,enum=google.analytics.admin.v1alpha.DataStream_DataStreamType" json:"type,omitempty"`
	// Human-readable display name for the Data Stream.
	//
	// Required for web data streams.
	//
	// The max allowed display name length is 255 UTF-16 code units.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *DataStream) Reset() {
	*x = DataStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStream) ProtoMessage() {}

func (x *DataStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStream.ProtoReflect.Descriptor instead.
func (*DataStream) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2}
}

func (m *DataStream) GetStreamData() isDataStream_StreamData {
	if m != nil {
		return m.StreamData
	}
	return nil
}

func (x *DataStream) GetWebStreamData() *DataStream_WebStreamData {
	if x, ok := x.GetStreamData().(*DataStream_WebStreamData_); ok {
		return x.WebStreamData
	}
	return nil
}

func (x *DataStream) GetAndroidAppStreamData() *DataStream_AndroidAppStreamData {
	if x, ok := x.GetStreamData().(*DataStream_AndroidAppStreamData_); ok {
		return x.AndroidAppStreamData
	}
	return nil
}

func (x *DataStream) GetIosAppStreamData() *DataStream_IosAppStreamData {
	if x, ok := x.GetStreamData().(*DataStream_IosAppStreamData_); ok {
		return x.IosAppStreamData
	}
	return nil
}

func (x *DataStream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataStream) GetType() DataStream_DataStreamType {
	if x != nil {
		return x.Type
	}
	return DataStream_DATA_STREAM_TYPE_UNSPECIFIED
}

func (x *DataStream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataStream) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataStream) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isDataStream_StreamData interface {
	isDataStream_StreamData()
}

type DataStream_WebStreamData_ struct {
	// Data specific to web streams. Must be populated if type is
	// WEB_DATA_STREAM.
	WebStreamData *DataStream_WebStreamData `protobuf:"bytes,6,opt,name=web_stream_data,json=webStreamData,proto3,oneof"`
}

type DataStream_AndroidAppStreamData_ struct {
	// Data specific to Android app streams. Must be populated if type is
	// ANDROID_APP_DATA_STREAM.
	AndroidAppStreamData *DataStream_AndroidAppStreamData `protobuf:"bytes,7,opt,name=android_app_stream_data,json=androidAppStreamData,proto3,oneof"`
}

type DataStream_IosAppStreamData_ struct {
	// Data specific to iOS app streams. Must be populated if type is
	// IOS_APP_DATA_STREAM.
	IosAppStreamData *DataStream_IosAppStreamData `protobuf:"bytes,8,opt,name=ios_app_stream_data,json=iosAppStreamData,proto3,oneof"`
}

func (*DataStream_WebStreamData_) isDataStream_StreamData() {}

func (*DataStream_AndroidAppStreamData_) isDataStream_StreamData() {}

func (*DataStream_IosAppStreamData_) isDataStream_StreamData() {}

// A resource message representing a user's permissions on an Account or
// Property resource.
type UserLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Example format: properties/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Email address of the user to link
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Roles directly assigned to this user for this account or property.
	//
	// Valid values:
	// predefinedRoles/viewer
	// predefinedRoles/analyst
	// predefinedRoles/editor
	// predefinedRoles/admin
	// predefinedRoles/no-cost-data
	// predefinedRoles/no-revenue-data
	//
	// Excludes roles that are inherited from a higher-level entity, group,
	// or organization admin role.
	//
	// A UserLink that is updated to have an empty list of direct_roles will be
	// deleted.
	DirectRoles []string `protobuf:"bytes,3,rep,name=direct_roles,json=directRoles,proto3" json:"direct_roles,omitempty"`
}

func (x *UserLink) Reset() {
	*x = UserLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserLink) ProtoMessage() {}

func (x *UserLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserLink.ProtoReflect.Descriptor instead.
func (*UserLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{3}
}

func (x *UserLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UserLink) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

func (x *UserLink) GetDirectRoles() []string {
	if x != nil {
		return x.DirectRoles
	}
	return nil
}

// Read-only resource used to summarize a principal's effective roles.
type AuditUserLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Example format: properties/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Email address of the linked user
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Roles directly assigned to this user for this entity.
	//
	// Format: predefinedRoles/viewer
	//
	// Excludes roles that are inherited from an account (if this is for a
	// property), group, or organization admin role.
	DirectRoles []string `protobuf:"bytes,3,rep,name=direct_roles,json=directRoles,proto3" json:"direct_roles,omitempty"`
	// Union of all permissions a user has at this account or property (includes
	// direct permissions, group-inherited permissions, etc.).
	//
	// Format: predefinedRoles/viewer
	EffectiveRoles []string `protobuf:"bytes,4,rep,name=effective_roles,json=effectiveRoles,proto3" json:"effective_roles,omitempty"`
}

func (x *AuditUserLink) Reset() {
	*x = AuditUserLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLink) ProtoMessage() {}

func (x *AuditUserLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLink.ProtoReflect.Descriptor instead.
func (*AuditUserLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{4}
}

func (x *AuditUserLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuditUserLink) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

func (x *AuditUserLink) GetDirectRoles() []string {
	if x != nil {
		return x.DirectRoles
	}
	return nil
}

func (x *AuditUserLink) GetEffectiveRoles() []string {
	if x != nil {
		return x.EffectiveRoles
	}
	return nil
}

// A link between a GA4 property and a Firebase project.
type FirebaseLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Example format: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Firebase project resource name. When creating a FirebaseLink,
	// you may provide this resource name using either a project number or project
	// ID. Once this resource has been created, returned FirebaseLinks will always
	// have a project_name that contains a project number.
	//
	// Format: 'projects/{project number}'
	// Example: 'projects/1234'
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. Time when this FirebaseLink was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *FirebaseLink) Reset() {
	*x = FirebaseLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirebaseLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirebaseLink) ProtoMessage() {}

func (x *FirebaseLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirebaseLink.ProtoReflect.Descriptor instead.
func (*FirebaseLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{5}
}

func (x *FirebaseLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FirebaseLink) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *FirebaseLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Read-only resource with the tag for sending data from a website to a
// DataStream. Only present for web DataStream resources.
type GlobalSiteTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name for this GlobalSiteTag resource.
	// Format: properties/{property_id}/dataStreams/{stream_id}/globalSiteTag
	// Example: "properties/123/dataStreams/456/globalSiteTag"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. JavaScript code snippet to be pasted as the first item into the
	// head tag of every webpage to measure.
	Snippet string `protobuf:"bytes,2,opt,name=snippet,proto3" json:"snippet,omitempty"`
}

func (x *GlobalSiteTag) Reset() {
	*x = GlobalSiteTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalSiteTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalSiteTag) ProtoMessage() {}

func (x *GlobalSiteTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalSiteTag.ProtoReflect.Descriptor instead.
func (*GlobalSiteTag) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{6}
}

func (x *GlobalSiteTag) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GlobalSiteTag) GetSnippet() string {
	if x != nil {
		return x.Snippet
	}
	return ""
}

// A link between a GA4 property and a Google Ads account.
type GoogleAdsLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Format:
	// properties/{propertyId}/googleAdsLinks/{googleAdsLinkId}
	//
	// Note: googleAdsLinkId is not the Google Ads customer ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Google Ads customer ID.
	CustomerId string `protobuf:"bytes,3,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Output only. If true, this link is for a Google Ads manager account.
	CanManageClients bool `protobuf:"varint,4,opt,name=can_manage_clients,json=canManageClients,proto3" json:"can_manage_clients,omitempty"`
	// Enable personalized advertising features with this integration.
	// Automatically publish my Google Analytics audience lists and Google
	// Analytics remarketing events/parameters to the linked Google Ads account.
	// If this field is not set on create/update, it will be defaulted to true.
	AdsPersonalizationEnabled *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	// Output only. Time when this link was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when this link was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Email address of the user that created the link.
	// An empty string will be returned if the email address can't be retrieved.
	CreatorEmailAddress string `protobuf:"bytes,9,opt,name=creator_email_address,json=creatorEmailAddress,proto3" json:"creator_email_address,omitempty"`
}

func (x *GoogleAdsLink) Reset() {
	*x = GoogleAdsLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleAdsLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleAdsLink) ProtoMessage() {}

func (x *GoogleAdsLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleAdsLink.ProtoReflect.Descriptor instead.
func (*GoogleAdsLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{7}
}

func (x *GoogleAdsLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GoogleAdsLink) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *GoogleAdsLink) GetCanManageClients() bool {
	if x != nil {
		return x.CanManageClients
	}
	return false
}

func (x *GoogleAdsLink) GetAdsPersonalizationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AdsPersonalizationEnabled
	}
	return nil
}

func (x *GoogleAdsLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GoogleAdsLink) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GoogleAdsLink) GetCreatorEmailAddress() string {
	if x != nil {
		return x.CreatorEmailAddress
	}
	return ""
}

// A resource message representing data sharing settings of a Google Analytics
// account.
type DataSharingSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name.
	// Format: accounts/{account}/dataSharingSettings
	// Example: "accounts/1000/dataSharingSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Allows Google support to access the data in order to help troubleshoot
	// issues.
	SharingWithGoogleSupportEnabled bool `protobuf:"varint,2,opt,name=sharing_with_google_support_enabled,json=sharingWithGoogleSupportEnabled,proto3" json:"sharing_with_google_support_enabled,omitempty"`
	// Allows Google sales teams that are assigned to the customer to access the
	// data in order to suggest configuration changes to improve results.
	// Sales team restrictions still apply when enabled.
	SharingWithGoogleAssignedSalesEnabled bool `protobuf:"varint,3,opt,name=sharing_with_google_assigned_sales_enabled,json=sharingWithGoogleAssignedSalesEnabled,proto3" json:"sharing_with_google_assigned_sales_enabled,omitempty"`
	// Allows any of Google sales to access the data in order to suggest
	// configuration changes to improve results.
	SharingWithGoogleAnySalesEnabled bool `protobuf:"varint,4,opt,name=sharing_with_google_any_sales_enabled,json=sharingWithGoogleAnySalesEnabled,proto3" json:"sharing_with_google_any_sales_enabled,omitempty"`
	// Allows Google to use the data to improve other Google products or services.
	SharingWithGoogleProductsEnabled bool `protobuf:"varint,5,opt,name=sharing_with_google_products_enabled,json=sharingWithGoogleProductsEnabled,proto3" json:"sharing_with_google_products_enabled,omitempty"`
	// Allows Google to share the data anonymously in aggregate form with others.
	SharingWithOthersEnabled bool `protobuf:"varint,6,opt,name=sharing_with_others_enabled,json=sharingWithOthersEnabled,proto3" json:"sharing_with_others_enabled,omitempty"`
}

func (x *DataSharingSettings) Reset() {
	*x = DataSharingSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSharingSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSharingSettings) ProtoMessage() {}

func (x *DataSharingSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSharingSettings.ProtoReflect.Descriptor instead.
func (*DataSharingSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{8}
}

func (x *DataSharingSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSharingSettings) GetSharingWithGoogleSupportEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleSupportEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithGoogleAssignedSalesEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleAssignedSalesEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithGoogleAnySalesEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleAnySalesEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithGoogleProductsEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleProductsEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithOthersEnabled() bool {
	if x != nil {
		return x.SharingWithOthersEnabled
	}
	return false
}

// A virtual resource representing an overview of an account and
// all its child GA4 properties.
type AccountSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name for this account summary.
	// Format: accountSummaries/{account_id}
	// Example: "accountSummaries/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Resource name of account referred to by this account summary
	// Format: accounts/{account_id}
	// Example: "accounts/1000"
	Account string `protobuf:"bytes,2,opt,name=account,proto3" json:"account,omitempty"`
	// Display name for the account referred to in this account summary.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// List of summaries for child accounts of this account.
	PropertySummaries []*PropertySummary `protobuf:"bytes,4,rep,name=property_summaries,json=propertySummaries,proto3" json:"property_summaries,omitempty"`
}

func (x *AccountSummary) Reset() {
	*x = AccountSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountSummary) ProtoMessage() {}

func (x *AccountSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountSummary.ProtoReflect.Descriptor instead.
func (*AccountSummary) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{9}
}

func (x *AccountSummary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccountSummary) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *AccountSummary) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AccountSummary) GetPropertySummaries() []*PropertySummary {
	if x != nil {
		return x.PropertySummaries
	}
	return nil
}

// A virtual resource representing metadata for a GA4 property.
type PropertySummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of property referred to by this property summary
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Display name for the property referred to in this property summary.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The property's property type.
	PropertyType PropertyType `protobuf:"varint,3,opt,name=property_type,json=propertyType,proto3,enum=google.analytics.admin.v1alpha.PropertyType" json:"property_type,omitempty"`
	// Resource name of this property's logical parent.
	//
	// Note: The Property-Moving UI can be used to change the parent.
	// Format: accounts/{account}, properties/{property}
	// Example: "accounts/100", "properties/200"
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *PropertySummary) Reset() {
	*x = PropertySummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertySummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertySummary) ProtoMessage() {}

func (x *PropertySummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertySummary.ProtoReflect.Descriptor instead.
func (*PropertySummary) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{10}
}

func (x *PropertySummary) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *PropertySummary) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PropertySummary) GetPropertyType() PropertyType {
	if x != nil {
		return x.PropertyType
	}
	return PropertyType_PROPERTY_TYPE_UNSPECIFIED
}

func (x *PropertySummary) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// A secret value used for sending hits to Measurement Protocol.
type MeasurementProtocolSecret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this secret. This secret may be a child of
	// any type of stream. Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human-readable display name for this secret.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The measurement protocol secret value. Pass this value to the
	// api_secret field of the Measurement Protocol API when sending hits to this
	// secret's parent property.
	SecretValue string `protobuf:"bytes,3,opt,name=secret_value,json=secretValue,proto3" json:"secret_value,omitempty"`
}

func (x *MeasurementProtocolSecret) Reset() {
	*x = MeasurementProtocolSecret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeasurementProtocolSecret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeasurementProtocolSecret) ProtoMessage() {}

func (x *MeasurementProtocolSecret) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeasurementProtocolSecret.ProtoReflect.Descriptor instead.
func (*MeasurementProtocolSecret) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{11}
}

func (x *MeasurementProtocolSecret) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MeasurementProtocolSecret) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MeasurementProtocolSecret) GetSecretValue() string {
	if x != nil {
		return x.SecretValue
	}
	return ""
}

// A set of changes within a Google Analytics account or its child properties
// that resulted from the same cause. Common causes would be updates made in the
// Google Analytics UI, changes from customer support, or automatic Google
// Analytics system changes.
type ChangeHistoryEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of this change history event. This ID is unique across Google Analytics.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Time when change was made.
	ChangeTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=change_time,json=changeTime,proto3" json:"change_time,omitempty"`
	// The type of actor that made this change.
	ActorType ActorType `protobuf:"varint,3,opt,name=actor_type,json=actorType,proto3,enum=google.analytics.admin.v1alpha.ActorType" json:"actor_type,omitempty"`
	// Email address of the Google account that made the change. This will be a
	// valid email address if the actor field is set to USER, and empty otherwise.
	// Google accounts that have been deleted will cause an error.
	UserActorEmail string `protobuf:"bytes,4,opt,name=user_actor_email,json=userActorEmail,proto3" json:"user_actor_email,omitempty"`
	// If true, then the list of changes returned was filtered, and does not
	// represent all changes that occurred in this event.
	ChangesFiltered bool `protobuf:"varint,5,opt,name=changes_filtered,json=changesFiltered,proto3" json:"changes_filtered,omitempty"`
	// A list of changes made in this change history event that fit the filters
	// specified in SearchChangeHistoryEventsRequest.
	Changes []*ChangeHistoryChange `protobuf:"bytes,6,rep,name=changes,proto3" json:"changes,omitempty"`
}

func (x *ChangeHistoryEvent) Reset() {
	*x = ChangeHistoryEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeHistoryEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeHistoryEvent) ProtoMessage() {}

func (x *ChangeHistoryEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeHistoryEvent.ProtoReflect.Descriptor instead.
func (*ChangeHistoryEvent) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{12}
}

func (x *ChangeHistoryEvent) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ChangeHistoryEvent) GetChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ChangeTime
	}
	return nil
}

func (x *ChangeHistoryEvent) GetActorType() ActorType {
	if x != nil {
		return x.ActorType
	}
	return ActorType_ACTOR_TYPE_UNSPECIFIED
}

func (x *ChangeHistoryEvent) GetUserActorEmail() string {
	if x != nil {
		return x.UserActorEmail
	}
	return ""
}

func (x *ChangeHistoryEvent) GetChangesFiltered() bool {
	if x != nil {
		return x.ChangesFiltered
	}
	return false
}

func (x *ChangeHistoryEvent) GetChanges() []*ChangeHistoryChange {
	if x != nil {
		return x.Changes
	}
	return nil
}

// A description of a change to a single Google Analytics resource.
type ChangeHistoryChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the resource whose changes are described by this entry.
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The type of action that changed this resource.
	Action ActionType `protobuf:"varint,2,opt,name=action,proto3,enum=google.analytics.admin.v1alpha.ActionType" json:"action,omitempty"`
	// Resource contents from before the change was made. If this resource was
	// created in this change, this field will be missing.
	ResourceBeforeChange *ChangeHistoryChange_ChangeHistoryResource `protobuf:"bytes,3,opt,name=resource_before_change,json=resourceBeforeChange,proto3" json:"resource_before_change,omitempty"`
	// Resource contents from after the change was made. If this resource was
	// deleted in this change, this field will be missing.
	ResourceAfterChange *ChangeHistoryChange_ChangeHistoryResource `protobuf:"bytes,4,opt,name=resource_after_change,json=resourceAfterChange,proto3" json:"resource_after_change,omitempty"`
}

func (x *ChangeHistoryChange) Reset() {
	*x = ChangeHistoryChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeHistoryChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeHistoryChange) ProtoMessage() {}

func (x *ChangeHistoryChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeHistoryChange.ProtoReflect.Descriptor instead.
func (*ChangeHistoryChange) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{13}
}

func (x *ChangeHistoryChange) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *ChangeHistoryChange) GetAction() ActionType {
	if x != nil {
		return x.Action
	}
	return ActionType_ACTION_TYPE_UNSPECIFIED
}

func (x *ChangeHistoryChange) GetResourceBeforeChange() *ChangeHistoryChange_ChangeHistoryResource {
	if x != nil {
		return x.ResourceBeforeChange
	}
	return nil
}

func (x *ChangeHistoryChange) GetResourceAfterChange() *ChangeHistoryChange_ChangeHistoryResource {
	if x != nil {
		return x.ResourceAfterChange
	}
	return nil
}

// A link between a GA4 property and a Display & Video 360 advertiser.
type DisplayVideo360AdvertiserLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this DisplayVideo360AdvertiserLink
	// resource. Format:
	// properties/{propertyId}/displayVideo360AdvertiserLinks/{linkId}
	//
	// Note: linkId is not the Display & Video 360 Advertiser ID
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The Display & Video 360 Advertiser's advertiser ID.
	AdvertiserId string `protobuf:"bytes,2,opt,name=advertiser_id,json=advertiserId,proto3" json:"advertiser_id,omitempty"`
	// Output only. The display name of the Display & Video 360 Advertiser.
	AdvertiserDisplayName string `protobuf:"bytes,3,opt,name=advertiser_display_name,json=advertiserDisplayName,proto3" json:"advertiser_display_name,omitempty"`
	// Enables personalized advertising features with this integration.
	// If this field is not set on create/update, it will be defaulted to true.
	AdsPersonalizationEnabled *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	// Immutable. Enables the import of campaign data from Display & Video 360
	// into the GA4 property. After link creation, this can only be updated from
	// the Display & Video 360 product. If this field is not set on create, it
	// will be defaulted to true.
	CampaignDataSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=campaign_data_sharing_enabled,json=campaignDataSharingEnabled,proto3" json:"campaign_data_sharing_enabled,omitempty"`
	// Immutable. Enables the import of cost data from Display & Video 360 into
	// the GA4 property. This can only be enabled if campaign_data_sharing_enabled
	// is enabled. After link creation, this can only be updated from the Display
	// & Video 360 product. If this field is not set on create, it will be
	// defaulted to true.
	CostDataSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=cost_data_sharing_enabled,json=costDataSharingEnabled,proto3" json:"cost_data_sharing_enabled,omitempty"`
}

func (x *DisplayVideo360AdvertiserLink) Reset() {
	*x = DisplayVideo360AdvertiserLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisplayVideo360AdvertiserLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayVideo360AdvertiserLink) ProtoMessage() {}

func (x *DisplayVideo360AdvertiserLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayVideo360AdvertiserLink.ProtoReflect.Descriptor instead.
func (*DisplayVideo360AdvertiserLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{14}
}

func (x *DisplayVideo360AdvertiserLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLink) GetAdvertiserId() string {
	if x != nil {
		return x.AdvertiserId
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLink) GetAdvertiserDisplayName() string {
	if x != nil {
		return x.AdvertiserDisplayName
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLink) GetAdsPersonalizationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AdsPersonalizationEnabled
	}
	return nil
}

func (x *DisplayVideo360AdvertiserLink) GetCampaignDataSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CampaignDataSharingEnabled
	}
	return nil
}

func (x *DisplayVideo360AdvertiserLink) GetCostDataSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CostDataSharingEnabled
	}
	return nil
}

// A proposal for a link between a GA4 property and a Display & Video 360
// advertiser.
//
// A proposal is converted to a DisplayVideo360AdvertiserLink once approved.
// Google Analytics admins approve inbound proposals while Display & Video 360
// admins approve outbound proposals.
type DisplayVideo360AdvertiserLinkProposal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// DisplayVideo360AdvertiserLinkProposal resource. Format:
	// properties/{propertyId}/displayVideo360AdvertiserLinkProposals/{proposalId}
	//
	// Note: proposalId is not the Display & Video 360 Advertiser ID
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The Display & Video 360 Advertiser's advertiser ID.
	AdvertiserId string `protobuf:"bytes,2,opt,name=advertiser_id,json=advertiserId,proto3" json:"advertiser_id,omitempty"`
	// Output only. The status information for this link proposal.
	LinkProposalStatusDetails *LinkProposalStatusDetails `protobuf:"bytes,3,opt,name=link_proposal_status_details,json=linkProposalStatusDetails,proto3" json:"link_proposal_status_details,omitempty"`
	// Output only. The display name of the Display & Video Advertiser.
	// Only populated for proposals that originated from Display & Video 360.
	AdvertiserDisplayName string `protobuf:"bytes,4,opt,name=advertiser_display_name,json=advertiserDisplayName,proto3" json:"advertiser_display_name,omitempty"`
	// Input only. On a proposal being sent to Display & Video 360, this field
	// must be set to the email address of an admin on the target advertiser. This
	// is used to verify that the Google Analytics admin is aware of at least one
	// admin on the Display & Video 360 Advertiser. This does not restrict
	// approval of the proposal to a single user. Any admin on the Display & Video
	// 360 Advertiser may approve the proposal.
	ValidationEmail string `protobuf:"bytes,5,opt,name=validation_email,json=validationEmail,proto3" json:"validation_email,omitempty"`
	// Immutable. Enables personalized advertising features with this integration.
	// If this field is not set on create, it will be defaulted to true.
	AdsPersonalizationEnabled *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	// Immutable. Enables the import of campaign data from Display & Video 360.
	// If this field is not set on create, it will be defaulted to true.
	CampaignDataSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=campaign_data_sharing_enabled,json=campaignDataSharingEnabled,proto3" json:"campaign_data_sharing_enabled,omitempty"`
	// Immutable. Enables the import of cost data from Display & Video 360.
	// This can only be enabled if campaign_data_sharing_enabled is enabled.
	// If this field is not set on create, it will be defaulted to true.
	CostDataSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=cost_data_sharing_enabled,json=costDataSharingEnabled,proto3" json:"cost_data_sharing_enabled,omitempty"`
}

func (x *DisplayVideo360AdvertiserLinkProposal) Reset() {
	*x = DisplayVideo360AdvertiserLinkProposal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisplayVideo360AdvertiserLinkProposal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayVideo360AdvertiserLinkProposal) ProtoMessage() {}

func (x *DisplayVideo360AdvertiserLinkProposal) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayVideo360AdvertiserLinkProposal.ProtoReflect.Descriptor instead.
func (*DisplayVideo360AdvertiserLinkProposal) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{15}
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetAdvertiserId() string {
	if x != nil {
		return x.AdvertiserId
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetLinkProposalStatusDetails() *LinkProposalStatusDetails {
	if x != nil {
		return x.LinkProposalStatusDetails
	}
	return nil
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetAdvertiserDisplayName() string {
	if x != nil {
		return x.AdvertiserDisplayName
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetValidationEmail() string {
	if x != nil {
		return x.ValidationEmail
	}
	return ""
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetAdsPersonalizationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AdsPersonalizationEnabled
	}
	return nil
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetCampaignDataSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CampaignDataSharingEnabled
	}
	return nil
}

func (x *DisplayVideo360AdvertiserLinkProposal) GetCostDataSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CostDataSharingEnabled
	}
	return nil
}

// A link between a GA4 property and a Search Ads 360 entity.
type SearchAds360Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this SearchAds360Link resource.
	// Format: properties/{propertyId}/searchAds360Links/{linkId}
	//
	// Note: linkId is not the Search Ads 360 advertiser ID
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. This field represents the Advertiser ID of the Search Ads 360
	// Advertiser. that has been linked.
	AdvertiserId string `protobuf:"bytes,2,opt,name=advertiser_id,json=advertiserId,proto3" json:"advertiser_id,omitempty"`
	// Immutable. Enables the import of campaign data from Search Ads 360 into the
	// GA4 property. After link creation, this can only be updated from the Search
	// Ads 360 product.
	// If this field is not set on create, it will be defaulted to true.
	CampaignDataSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=campaign_data_sharing_enabled,json=campaignDataSharingEnabled,proto3" json:"campaign_data_sharing_enabled,omitempty"`
	// Immutable. Enables the import of cost data from Search Ads 360 to the GA4
	// property. This can only be enabled if campaign_data_sharing_enabled is
	// enabled. After link creation, this can only be updated from
	// the Search Ads 360 product.
	// If this field is not set on create, it will be defaulted to true.
	CostDataSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=cost_data_sharing_enabled,json=costDataSharingEnabled,proto3" json:"cost_data_sharing_enabled,omitempty"`
	// Output only. The display name of the Search Ads 360 Advertiser.
	// Allows users to easily identify the linked resource.
	AdvertiserDisplayName string `protobuf:"bytes,5,opt,name=advertiser_display_name,json=advertiserDisplayName,proto3" json:"advertiser_display_name,omitempty"`
	// Enables personalized advertising features with this integration.
	// If this field is not set on create, it will be defaulted to true.
	AdsPersonalizationEnabled *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	// Enables export of site stats with this integration.
	// If this field is not set on create, it will be defaulted to true.
	SiteStatsSharingEnabled *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=site_stats_sharing_enabled,json=siteStatsSharingEnabled,proto3" json:"site_stats_sharing_enabled,omitempty"`
}

func (x *SearchAds360Link) Reset() {
	*x = SearchAds360Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAds360Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAds360Link) ProtoMessage() {}

func (x *SearchAds360Link) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAds360Link.ProtoReflect.Descriptor instead.
func (*SearchAds360Link) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{16}
}

func (x *SearchAds360Link) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchAds360Link) GetAdvertiserId() string {
	if x != nil {
		return x.AdvertiserId
	}
	return ""
}

func (x *SearchAds360Link) GetCampaignDataSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CampaignDataSharingEnabled
	}
	return nil
}

func (x *SearchAds360Link) GetCostDataSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CostDataSharingEnabled
	}
	return nil
}

func (x *SearchAds360Link) GetAdvertiserDisplayName() string {
	if x != nil {
		return x.AdvertiserDisplayName
	}
	return ""
}

func (x *SearchAds360Link) GetAdsPersonalizationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AdsPersonalizationEnabled
	}
	return nil
}

func (x *SearchAds360Link) GetSiteStatsSharingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.SiteStatsSharingEnabled
	}
	return nil
}

// Status information for a link proposal.
type LinkProposalStatusDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The source of this proposal.
	LinkProposalInitiatingProduct LinkProposalInitiatingProduct `protobuf:"varint,1,opt,name=link_proposal_initiating_product,json=linkProposalInitiatingProduct,proto3,enum=google.analytics.admin.v1alpha.LinkProposalInitiatingProduct" json:"link_proposal_initiating_product,omitempty"`
	// Output only. The email address of the user that proposed this linkage.
	RequestorEmail string `protobuf:"bytes,2,opt,name=requestor_email,json=requestorEmail,proto3" json:"requestor_email,omitempty"`
	// Output only. The state of this proposal.
	LinkProposalState LinkProposalState `protobuf:"varint,3,opt,name=link_proposal_state,json=linkProposalState,proto3,enum=google.analytics.admin.v1alpha.LinkProposalState" json:"link_proposal_state,omitempty"`
}

func (x *LinkProposalStatusDetails) Reset() {
	*x = LinkProposalStatusDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinkProposalStatusDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkProposalStatusDetails) ProtoMessage() {}

func (x *LinkProposalStatusDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkProposalStatusDetails.ProtoReflect.Descriptor instead.
func (*LinkProposalStatusDetails) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{17}
}

func (x *LinkProposalStatusDetails) GetLinkProposalInitiatingProduct() LinkProposalInitiatingProduct {
	if x != nil {
		return x.LinkProposalInitiatingProduct
	}
	return LinkProposalInitiatingProduct_LINK_PROPOSAL_INITIATING_PRODUCT_UNSPECIFIED
}

func (x *LinkProposalStatusDetails) GetRequestorEmail() string {
	if x != nil {
		return x.RequestorEmail
	}
	return ""
}

func (x *LinkProposalStatusDetails) GetLinkProposalState() LinkProposalState {
	if x != nil {
		return x.LinkProposalState
	}
	return LinkProposalState_LINK_PROPOSAL_STATE_UNSPECIFIED
}

// A conversion event in a Google Analytics property.
type ConversionEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this conversion event.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The event name for this conversion event.
	// Examples: 'click', 'purchase'
	EventName string `protobuf:"bytes,2,opt,name=event_name,json=eventName,proto3" json:"event_name,omitempty"`
	// Output only. Time when this conversion event was created in the property.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. If set, this event can currently be deleted with
	// DeleteConversionEvent.
	Deletable bool `protobuf:"varint,4,opt,name=deletable,proto3" json:"deletable,omitempty"`
	// Output only. If set to true, this conversion event refers to a custom
	// event.  If set to false, this conversion event refers to a default event in
	// GA. Default events typically have special meaning in GA. Default events are
	// usually created for you by the GA system, but in some cases can be created
	// by property admins. Custom events count towards the maximum number of
	// custom conversion events that may be created per property.
	Custom bool `protobuf:"varint,5,opt,name=custom,proto3" json:"custom,omitempty"`
}

func (x *ConversionEvent) Reset() {
	*x = ConversionEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversionEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversionEvent) ProtoMessage() {}

func (x *ConversionEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversionEvent.ProtoReflect.Descriptor instead.
func (*ConversionEvent) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{18}
}

func (x *ConversionEvent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversionEvent) GetEventName() string {
	if x != nil {
		return x.EventName
	}
	return ""
}

func (x *ConversionEvent) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConversionEvent) GetDeletable() bool {
	if x != nil {
		return x.Deletable
	}
	return false
}

func (x *ConversionEvent) GetCustom() bool {
	if x != nil {
		return x.Custom
	}
	return false
}

// Settings values for Google Signals.  This is a singleton resource.
type GoogleSignalsSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this setting.
	// Format: properties/{property_id}/googleSignalsSettings
	// Example: "properties/1000/googleSignalsSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Status of this setting.
	State GoogleSignalsState `protobuf:"varint,3,opt,name=state,proto3,enum=google.analytics.admin.v1alpha.GoogleSignalsState" json:"state,omitempty"`
	// Output only. Terms of Service acceptance.
	Consent GoogleSignalsConsent `protobuf:"varint,4,opt,name=consent,proto3,enum=google.analytics.admin.v1alpha.GoogleSignalsConsent" json:"consent,omitempty"`
}

func (x *GoogleSignalsSettings) Reset() {
	*x = GoogleSignalsSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleSignalsSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleSignalsSettings) ProtoMessage() {}

func (x *GoogleSignalsSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleSignalsSettings.ProtoReflect.Descriptor instead.
func (*GoogleSignalsSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{19}
}

func (x *GoogleSignalsSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GoogleSignalsSettings) GetState() GoogleSignalsState {
	if x != nil {
		return x.State
	}
	return GoogleSignalsState_GOOGLE_SIGNALS_STATE_UNSPECIFIED
}

func (x *GoogleSignalsSettings) GetConsent() GoogleSignalsConsent {
	if x != nil {
		return x.Consent
	}
	return GoogleSignalsConsent_GOOGLE_SIGNALS_CONSENT_UNSPECIFIED
}

// A definition for a CustomDimension.
type CustomDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name for this CustomDimension resource.
	// Format: properties/{property}/customDimensions/{customDimension}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Tagging parameter name for this custom dimension.
	//
	// If this is a user-scoped dimension, then this is the user property name.
	// If this is an event-scoped dimension, then this is the event parameter
	// name.
	//
	// If this is an item-scoped dimension, then this is the parameter
	// name found in the eCommerce items array.
	//
	// May only contain alphanumeric and underscore characters, starting with a
	// letter. Max length of 24 characters for user-scoped dimensions, 40
	// characters for event-scoped dimensions.
	ParameterName string `protobuf:"bytes,2,opt,name=parameter_name,json=parameterName,proto3" json:"parameter_name,omitempty"`
	// Required. Display name for this custom dimension as shown in the Analytics
	// UI. Max length of 82 characters, alphanumeric plus space and underscore
	// starting with a letter. Legacy system-generated display names may contain
	// square brackets, but updates to this field will never permit square
	// brackets.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description for this custom dimension. Max length of 150
	// characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. The scope of this dimension.
	Scope CustomDimension_DimensionScope `protobuf:"varint,5,opt,name=scope,proto3,enum=google.analytics.admin.v1alpha.CustomDimension_DimensionScope" json:"scope,omitempty"`
	// Optional. If set to true, sets this dimension as NPA and excludes it from
	// ads personalization.
	//
	// This is currently only supported by user-scoped custom dimensions.
	DisallowAdsPersonalization bool `protobuf:"varint,6,opt,name=disallow_ads_personalization,json=disallowAdsPersonalization,proto3" json:"disallow_ads_personalization,omitempty"`
}

func (x *CustomDimension) Reset() {
	*x = CustomDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomDimension) ProtoMessage() {}

func (x *CustomDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomDimension.ProtoReflect.Descriptor instead.
func (*CustomDimension) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{20}
}

func (x *CustomDimension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomDimension) GetParameterName() string {
	if x != nil {
		return x.ParameterName
	}
	return ""
}

func (x *CustomDimension) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CustomDimension) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CustomDimension) GetScope() CustomDimension_DimensionScope {
	if x != nil {
		return x.Scope
	}
	return CustomDimension_DIMENSION_SCOPE_UNSPECIFIED
}

func (x *CustomDimension) GetDisallowAdsPersonalization() bool {
	if x != nil {
		return x.DisallowAdsPersonalization
	}
	return false
}

// A definition for a custom metric.
type CustomMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name for this CustomMetric resource.
	// Format: properties/{property}/customMetrics/{customMetric}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Tagging name for this custom metric.
	//
	// If this is an event-scoped metric, then this is the event parameter
	// name.
	//
	// May only contain alphanumeric and underscore charactes, starting with a
	// letter. Max length of 40 characters for event-scoped metrics.
	ParameterName string `protobuf:"bytes,2,opt,name=parameter_name,json=parameterName,proto3" json:"parameter_name,omitempty"`
	// Required. Display name for this custom metric as shown in the Analytics UI.
	// Max length of 82 characters, alphanumeric plus space and underscore
	// starting with a letter. Legacy system-generated display names may contain
	// square brackets, but updates to this field will never permit square
	// brackets.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description for this custom dimension.
	// Max length of 150 characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The type for the custom metric's value.
	MeasurementUnit CustomMetric_MeasurementUnit `protobuf:"varint,5,opt,name=measurement_unit,json=measurementUnit,proto3,enum=google.analytics.admin.v1alpha.CustomMetric_MeasurementUnit" json:"measurement_unit,omitempty"`
	// Required. Immutable. The scope of this custom metric.
	Scope CustomMetric_MetricScope `protobuf:"varint,6,opt,name=scope,proto3,enum=google.analytics.admin.v1alpha.CustomMetric_MetricScope" json:"scope,omitempty"`
	// Optional. Types of restricted data that this metric may contain. Required
	// for metrics with CURRENCY measurement unit. Must be empty for metrics with
	// a non-CURRENCY measurement unit.
	RestrictedMetricType []CustomMetric_RestrictedMetricType `protobuf:"varint,8,rep,packed,name=restricted_metric_type,json=restrictedMetricType,proto3,enum=google.analytics.admin.v1alpha.CustomMetric_RestrictedMetricType" json:"restricted_metric_type,omitempty"`
}

func (x *CustomMetric) Reset() {
	*x = CustomMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomMetric) ProtoMessage() {}

func (x *CustomMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomMetric.ProtoReflect.Descriptor instead.
func (*CustomMetric) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{21}
}

func (x *CustomMetric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomMetric) GetParameterName() string {
	if x != nil {
		return x.ParameterName
	}
	return ""
}

func (x *CustomMetric) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CustomMetric) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CustomMetric) GetMeasurementUnit() CustomMetric_MeasurementUnit {
	if x != nil {
		return x.MeasurementUnit
	}
	return CustomMetric_MEASUREMENT_UNIT_UNSPECIFIED
}

func (x *CustomMetric) GetScope() CustomMetric_MetricScope {
	if x != nil {
		return x.Scope
	}
	return CustomMetric_METRIC_SCOPE_UNSPECIFIED
}

func (x *CustomMetric) GetRestrictedMetricType() []CustomMetric_RestrictedMetricType {
	if x != nil {
		return x.RestrictedMetricType
	}
	return nil
}

// Settings values for data retention. This is a singleton resource.
type DataRetentionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name for this DataRetentionSetting resource.
	// Format: properties/{property}/dataRetentionSettings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The length of time that event-level data is retained.
	EventDataRetention DataRetentionSettings_RetentionDuration `protobuf:"varint,2,opt,name=event_data_retention,json=eventDataRetention,proto3,enum=google.analytics.admin.v1alpha.DataRetentionSettings_RetentionDuration" json:"event_data_retention,omitempty"`
	// If true, reset the retention period for the user identifier with every
	// event from that user.
	ResetUserDataOnNewActivity bool `protobuf:"varint,3,opt,name=reset_user_data_on_new_activity,json=resetUserDataOnNewActivity,proto3" json:"reset_user_data_on_new_activity,omitempty"`
}

func (x *DataRetentionSettings) Reset() {
	*x = DataRetentionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRetentionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRetentionSettings) ProtoMessage() {}

func (x *DataRetentionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRetentionSettings.ProtoReflect.Descriptor instead.
func (*DataRetentionSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{22}
}

func (x *DataRetentionSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataRetentionSettings) GetEventDataRetention() DataRetentionSettings_RetentionDuration {
	if x != nil {
		return x.EventDataRetention
	}
	return DataRetentionSettings_RETENTION_DURATION_UNSPECIFIED
}

func (x *DataRetentionSettings) GetResetUserDataOnNewActivity() bool {
	if x != nil {
		return x.ResetUserDataOnNewActivity
	}
	return false
}

// The attribution settings used for a given property. This is a singleton
// resource.
type AttributionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this attribution settings resource.
	// Format: properties/{property_id}/attributionSettings
	// Example: "properties/1000/attributionSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The lookback window configuration for acquisition conversion
	// events. The default window size is 30 days.
	AcquisitionConversionEventLookbackWindow AttributionSettings_AcquisitionConversionEventLookbackWindow `protobuf:"varint,2,opt,name=acquisition_conversion_event_lookback_window,json=acquisitionConversionEventLookbackWindow,proto3,enum=google.analytics.admin.v1alpha.AttributionSettings_AcquisitionConversionEventLookbackWindow" json:"acquisition_conversion_event_lookback_window,omitempty"`
	// Required. The lookback window for all other, non-acquisition conversion
	// events. The default window size is 90 days.
	OtherConversionEventLookbackWindow AttributionSettings_OtherConversionEventLookbackWindow `protobuf:"varint,3,opt,name=other_conversion_event_lookback_window,json=otherConversionEventLookbackWindow,proto3,enum=google.analytics.admin.v1alpha.AttributionSettings_OtherConversionEventLookbackWindow" json:"other_conversion_event_lookback_window,omitempty"`
	// Required. The reporting attribution model used to calculate conversion
	// credit in this property's reports.
	//
	// Changing the attribution model will apply to both historical and future
	// data. These changes will be reflected in reports with conversion and
	// revenue data. User and session data will be unaffected.
	ReportingAttributionModel AttributionSettings_ReportingAttributionModel `protobuf:"varint,4,opt,name=reporting_attribution_model,json=reportingAttributionModel,proto3,enum=google.analytics.admin.v1alpha.AttributionSettings_ReportingAttributionModel" json:"reporting_attribution_model,omitempty"`
	// Required. The Conversion Export Scope for data exported to linked Ads
	// Accounts.
	AdsWebConversionDataExportScope AttributionSettings_AdsWebConversionDataExportScope `protobuf:"varint,5,opt,name=ads_web_conversion_data_export_scope,json=adsWebConversionDataExportScope,proto3,enum=google.analytics.admin.v1alpha.AttributionSettings_AdsWebConversionDataExportScope" json:"ads_web_conversion_data_export_scope,omitempty"`
}

func (x *AttributionSettings) Reset() {
	*x = AttributionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSettings) ProtoMessage() {}

func (x *AttributionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSettings.ProtoReflect.Descriptor instead.
func (*AttributionSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{23}
}

func (x *AttributionSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttributionSettings) GetAcquisitionConversionEventLookbackWindow() AttributionSettings_AcquisitionConversionEventLookbackWindow {
	if x != nil {
		return x.AcquisitionConversionEventLookbackWindow
	}
	return AttributionSettings_ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED
}

func (x *AttributionSettings) GetOtherConversionEventLookbackWindow() AttributionSettings_OtherConversionEventLookbackWindow {
	if x != nil {
		return x.OtherConversionEventLookbackWindow
	}
	return AttributionSettings_OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED
}

func (x *AttributionSettings) GetReportingAttributionModel() AttributionSettings_ReportingAttributionModel {
	if x != nil {
		return x.ReportingAttributionModel
	}
	return AttributionSettings_REPORTING_ATTRIBUTION_MODEL_UNSPECIFIED
}

func (x *AttributionSettings) GetAdsWebConversionDataExportScope() AttributionSettings_AdsWebConversionDataExportScope {
	if x != nil {
		return x.AdsWebConversionDataExportScope
	}
	return AttributionSettings_ADS_WEB_CONVERSION_DATA_EXPORT_SCOPE_UNSPECIFIED
}

// A binding of a user to a set of roles.
type AccessBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target for which to set roles for.
	//
	// Types that are assignable to AccessTarget:
	//	*AccessBinding_User
	AccessTarget isAccessBinding_AccessTarget `protobuf_oneof:"access_target"`
	// Output only. Resource name of this binding.
	//
	// Format: accounts/{account}/accessBindings/{access_binding} or
	// properties/{property}/accessBindings/{access_binding}
	//
	// Example:
	// "accounts/100/accessBindings/200"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of roles for to grant to the parent resource.
	//
	// Valid values:
	// predefinedRoles/viewer
	// predefinedRoles/analyst
	// predefinedRoles/editor
	// predefinedRoles/admin
	// predefinedRoles/no-cost-data
	// predefinedRoles/no-revenue-data
	//
	// For users, if an empty list of roles is set, this AccessBinding will be
	// deleted.
	Roles []string `protobuf:"bytes,3,rep,name=roles,proto3" json:"roles,omitempty"`
}

func (x *AccessBinding) Reset() {
	*x = AccessBinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessBinding) ProtoMessage() {}

func (x *AccessBinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessBinding.ProtoReflect.Descriptor instead.
func (*AccessBinding) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{24}
}

func (m *AccessBinding) GetAccessTarget() isAccessBinding_AccessTarget {
	if m != nil {
		return m.AccessTarget
	}
	return nil
}

func (x *AccessBinding) GetUser() string {
	if x, ok := x.GetAccessTarget().(*AccessBinding_User); ok {
		return x.User
	}
	return ""
}

func (x *AccessBinding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccessBinding) GetRoles() []string {
	if x != nil {
		return x.Roles
	}
	return nil
}

type isAccessBinding_AccessTarget interface {
	isAccessBinding_AccessTarget()
}

type AccessBinding_User struct {
	// If set, the email address of the user to set roles for.
	// Format: "someuser@gmail.com"
	User string `protobuf:"bytes,2,opt,name=user,proto3,oneof"`
}

func (*AccessBinding_User) isAccessBinding_AccessTarget() {}

// A link between a GA4 Property and BigQuery project.
type BigQueryLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this BigQuery link.
	// Format: 'properties/{property_id}/bigQueryLinks/{bigquery_link_id}'
	// Format: 'properties/1234/bigQueryLinks/abc567'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The linked Google Cloud project. When creating a BigQueryLink,
	// you may provide this resource name using either a project number or project
	// ID. Once this resource has been created, the returned project will always
	// have a project that contains a project number.
	// Format: 'projects/{project number}'
	// Example: 'projects/1234'
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. Time when the link was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// If set true, enables daily data export to the linked Google Cloud project.
	DailyExportEnabled bool `protobuf:"varint,4,opt,name=daily_export_enabled,json=dailyExportEnabled,proto3" json:"daily_export_enabled,omitempty"`
	// If set true, enables streaming export to the linked Google Cloud project.
	StreamingExportEnabled bool `protobuf:"varint,5,opt,name=streaming_export_enabled,json=streamingExportEnabled,proto3" json:"streaming_export_enabled,omitempty"`
	// If set true, enables intraday export to the linked Google Cloud project.
	IntradayExportEnabled bool `protobuf:"varint,9,opt,name=intraday_export_enabled,json=intradayExportEnabled,proto3" json:"intraday_export_enabled,omitempty"`
	// If set true, exported data will include advertising identifiers for mobile
	// app streams.
	IncludeAdvertisingId bool `protobuf:"varint,6,opt,name=include_advertising_id,json=includeAdvertisingId,proto3" json:"include_advertising_id,omitempty"`
	// The list of streams under the parent property for which data will be
	// exported.
	// Format: properties/{property_id}/dataStreams/{stream_id}
	// Example: ['properties/1000/dataStreams/2000']
	ExportStreams []string `protobuf:"bytes,7,rep,name=export_streams,json=exportStreams,proto3" json:"export_streams,omitempty"`
	// The list of event names that will be excluded from exports.
	ExcludedEvents []string `protobuf:"bytes,8,rep,name=excluded_events,json=excludedEvents,proto3" json:"excluded_events,omitempty"`
}

func (x *BigQueryLink) Reset() {
	*x = BigQueryLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryLink) ProtoMessage() {}

func (x *BigQueryLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryLink.ProtoReflect.Descriptor instead.
func (*BigQueryLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{25}
}

func (x *BigQueryLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BigQueryLink) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *BigQueryLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BigQueryLink) GetDailyExportEnabled() bool {
	if x != nil {
		return x.DailyExportEnabled
	}
	return false
}

func (x *BigQueryLink) GetStreamingExportEnabled() bool {
	if x != nil {
		return x.StreamingExportEnabled
	}
	return false
}

func (x *BigQueryLink) GetIntradayExportEnabled() bool {
	if x != nil {
		return x.IntradayExportEnabled
	}
	return false
}

func (x *BigQueryLink) GetIncludeAdvertisingId() bool {
	if x != nil {
		return x.IncludeAdvertisingId
	}
	return false
}

func (x *BigQueryLink) GetExportStreams() []string {
	if x != nil {
		return x.ExportStreams
	}
	return nil
}

func (x *BigQueryLink) GetExcludedEvents() []string {
	if x != nil {
		return x.ExcludedEvents
	}
	return nil
}

// Singleton resource under a web DataStream, configuring measurement of
// additional site interactions and content.
type EnhancedMeasurementSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the Enhanced Measurement Settings.
	// Format:
	// properties/{property_id}/dataStreams/{data_stream}/enhancedMeasurementSettings
	// Example: "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates whether Enhanced Measurement Settings will be used to
	// automatically measure interactions and content on this web stream.
	//
	// Changing this value does not affect the settings themselves, but determines
	// whether they are respected.
	StreamEnabled bool `protobuf:"varint,2,opt,name=stream_enabled,json=streamEnabled,proto3" json:"stream_enabled,omitempty"`
	// If enabled, capture scroll events each time a visitor gets to the bottom of
	// a page.
	ScrollsEnabled bool `protobuf:"varint,3,opt,name=scrolls_enabled,json=scrollsEnabled,proto3" json:"scrolls_enabled,omitempty"`
	// If enabled, capture an outbound click event each time a visitor clicks a
	// link that leads them away from your domain.
	OutboundClicksEnabled bool `protobuf:"varint,4,opt,name=outbound_clicks_enabled,json=outboundClicksEnabled,proto3" json:"outbound_clicks_enabled,omitempty"`
	// If enabled, capture a view search results event each time a visitor
	// performs a search on your site (based on a query parameter).
	SiteSearchEnabled bool `protobuf:"varint,5,opt,name=site_search_enabled,json=siteSearchEnabled,proto3" json:"site_search_enabled,omitempty"`
	// If enabled, capture video play, progress, and complete events as visitors
	// view embedded videos on your site.
	VideoEngagementEnabled bool `protobuf:"varint,6,opt,name=video_engagement_enabled,json=videoEngagementEnabled,proto3" json:"video_engagement_enabled,omitempty"`
	// If enabled, capture a file download event each time a link is clicked with
	// a common document, compressed file, application, video, or audio extension.
	FileDownloadsEnabled bool `protobuf:"varint,7,opt,name=file_downloads_enabled,json=fileDownloadsEnabled,proto3" json:"file_downloads_enabled,omitempty"`
	// If enabled, capture a page view event each time the website changes the
	// browser history state.
	PageChangesEnabled bool `protobuf:"varint,8,opt,name=page_changes_enabled,json=pageChangesEnabled,proto3" json:"page_changes_enabled,omitempty"`
	// If enabled, capture a form interaction event each time a visitor interacts
	// with a form on your website.
	// False by default.
	FormInteractionsEnabled bool `protobuf:"varint,9,opt,name=form_interactions_enabled,json=formInteractionsEnabled,proto3" json:"form_interactions_enabled,omitempty"`
	// Required. URL query parameters to interpret as site search parameters.
	// Max length is 1024 characters. Must not be empty.
	SearchQueryParameter string `protobuf:"bytes,10,opt,name=search_query_parameter,json=searchQueryParameter,proto3" json:"search_query_parameter,omitempty"`
	// Additional URL query parameters.
	// Max length is 1024 characters.
	UriQueryParameter string `protobuf:"bytes,11,opt,name=uri_query_parameter,json=uriQueryParameter,proto3" json:"uri_query_parameter,omitempty"`
}

func (x *EnhancedMeasurementSettings) Reset() {
	*x = EnhancedMeasurementSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnhancedMeasurementSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnhancedMeasurementSettings) ProtoMessage() {}

func (x *EnhancedMeasurementSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnhancedMeasurementSettings.ProtoReflect.Descriptor instead.
func (*EnhancedMeasurementSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{26}
}

func (x *EnhancedMeasurementSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnhancedMeasurementSettings) GetStreamEnabled() bool {
	if x != nil {
		return x.StreamEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetScrollsEnabled() bool {
	if x != nil {
		return x.ScrollsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetOutboundClicksEnabled() bool {
	if x != nil {
		return x.OutboundClicksEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetSiteSearchEnabled() bool {
	if x != nil {
		return x.SiteSearchEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetVideoEngagementEnabled() bool {
	if x != nil {
		return x.VideoEngagementEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetFileDownloadsEnabled() bool {
	if x != nil {
		return x.FileDownloadsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetPageChangesEnabled() bool {
	if x != nil {
		return x.PageChangesEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetFormInteractionsEnabled() bool {
	if x != nil {
		return x.FormInteractionsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetSearchQueryParameter() string {
	if x != nil {
		return x.SearchQueryParameter
	}
	return ""
}

func (x *EnhancedMeasurementSettings) GetUriQueryParameter() string {
	if x != nil {
		return x.UriQueryParameter
	}
	return ""
}

// Configuration for a specific Connected Site Tag.
type ConnectedSiteTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User-provided display name for the connected site tag. Must be
	// less than 256 characters.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. "Tag ID to forward events to. Also known as the Measurement ID,
	// or the "G-ID"  (For example: G-12345).
	TagId string `protobuf:"bytes,2,opt,name=tag_id,json=tagId,proto3" json:"tag_id,omitempty"`
}

func (x *ConnectedSiteTag) Reset() {
	*x = ConnectedSiteTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectedSiteTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectedSiteTag) ProtoMessage() {}

func (x *ConnectedSiteTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectedSiteTag.ProtoReflect.Descriptor instead.
func (*ConnectedSiteTag) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{27}
}

func (x *ConnectedSiteTag) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConnectedSiteTag) GetTagId() string {
	if x != nil {
		return x.TagId
	}
	return ""
}

// A link between a GA4 Property and an AdSense for Content ad client.
type AdSenseLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this AdSense Link resource.
	// Format: properties/{propertyId}/adSenseLinks/{linkId}
	// Example: properties/1234/adSenseLinks/6789
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The AdSense ad client code that the GA4 property is linked to.
	// Example format: "ca-pub-1234567890"
	AdClientCode string `protobuf:"bytes,2,opt,name=ad_client_code,json=adClientCode,proto3" json:"ad_client_code,omitempty"`
}

func (x *AdSenseLink) Reset() {
	*x = AdSenseLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdSenseLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdSenseLink) ProtoMessage() {}

func (x *AdSenseLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdSenseLink.ProtoReflect.Descriptor instead.
func (*AdSenseLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{28}
}

func (x *AdSenseLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdSenseLink) GetAdClientCode() string {
	if x != nil {
		return x.AdClientCode
	}
	return ""
}

// Data specific to web streams.
type DataStream_WebStreamData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Analytics Measurement ID.
	//
	// Example: "G-1A2BCD345E"
	MeasurementId string `protobuf:"bytes,1,opt,name=measurement_id,json=measurementId,proto3" json:"measurement_id,omitempty"`
	// Output only. ID of the corresponding web app in Firebase, if any.
	// This ID can change if the web app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,2,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Domain name of the web app being measured, or empty.
	// Example: "http://www.google.com", "https://www.google.com"
	DefaultUri string `protobuf:"bytes,3,opt,name=default_uri,json=defaultUri,proto3" json:"default_uri,omitempty"`
}

func (x *DataStream_WebStreamData) Reset() {
	*x = DataStream_WebStreamData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataStream_WebStreamData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStream_WebStreamData) ProtoMessage() {}

func (x *DataStream_WebStreamData) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStream_WebStreamData.ProtoReflect.Descriptor instead.
func (*DataStream_WebStreamData) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *DataStream_WebStreamData) GetMeasurementId() string {
	if x != nil {
		return x.MeasurementId
	}
	return ""
}

func (x *DataStream_WebStreamData) GetFirebaseAppId() string {
	if x != nil {
		return x.FirebaseAppId
	}
	return ""
}

func (x *DataStream_WebStreamData) GetDefaultUri() string {
	if x != nil {
		return x.DefaultUri
	}
	return ""
}

// Data specific to Android app streams.
type DataStream_AndroidAppStreamData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. ID of the corresponding Android app in Firebase, if any.
	// This ID can change if the Android app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,1,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Immutable. The package name for the app being measured.
	// Example: "com.example.myandroidapp"
	PackageName string `protobuf:"bytes,2,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
}

func (x *DataStream_AndroidAppStreamData) Reset() {
	*x = DataStream_AndroidAppStreamData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataStream_AndroidAppStreamData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStream_AndroidAppStreamData) ProtoMessage() {}

func (x *DataStream_AndroidAppStreamData) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStream_AndroidAppStreamData.ProtoReflect.Descriptor instead.
func (*DataStream_AndroidAppStreamData) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2, 1}
}

func (x *DataStream_AndroidAppStreamData) GetFirebaseAppId() string {
	if x != nil {
		return x.FirebaseAppId
	}
	return ""
}

func (x *DataStream_AndroidAppStreamData) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

// Data specific to iOS app streams.
type DataStream_IosAppStreamData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. ID of the corresponding iOS app in Firebase, if any.
	// This ID can change if the iOS app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,1,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Required. Immutable. The Apple App Store Bundle ID for the app
	// Example: "com.example.myiosapp"
	BundleId string `protobuf:"bytes,2,opt,name=bundle_id,json=bundleId,proto3" json:"bundle_id,omitempty"`
}

func (x *DataStream_IosAppStreamData) Reset() {
	*x = DataStream_IosAppStreamData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataStream_IosAppStreamData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStream_IosAppStreamData) ProtoMessage() {}

func (x *DataStream_IosAppStreamData) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStream_IosAppStreamData.ProtoReflect.Descriptor instead.
func (*DataStream_IosAppStreamData) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2, 2}
}

func (x *DataStream_IosAppStreamData) GetFirebaseAppId() string {
	if x != nil {
		return x.FirebaseAppId
	}
	return ""
}

func (x *DataStream_IosAppStreamData) GetBundleId() string {
	if x != nil {
		return x.BundleId
	}
	return ""
}

// A snapshot of a resource as before or after the result of a change in
// change history.
type ChangeHistoryChange_ChangeHistoryResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Resource:
	//	*ChangeHistoryChange_ChangeHistoryResource_Account
	//	*ChangeHistoryChange_ChangeHistoryResource_Property
	//	*ChangeHistoryChange_ChangeHistoryResource_FirebaseLink
	//	*ChangeHistoryChange_ChangeHistoryResource_GoogleAdsLink
	//	*ChangeHistoryChange_ChangeHistoryResource_GoogleSignalsSettings
	//	*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLink
	//	*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLinkProposal
	//	*ChangeHistoryChange_ChangeHistoryResource_ConversionEvent
	//	*ChangeHistoryChange_ChangeHistoryResource_MeasurementProtocolSecret
	//	*ChangeHistoryChange_ChangeHistoryResource_CustomDimension
	//	*ChangeHistoryChange_ChangeHistoryResource_CustomMetric
	//	*ChangeHistoryChange_ChangeHistoryResource_DataRetentionSettings
	//	*ChangeHistoryChange_ChangeHistoryResource_SearchAds_360Link
	//	*ChangeHistoryChange_ChangeHistoryResource_DataStream
	//	*ChangeHistoryChange_ChangeHistoryResource_AttributionSettings
	//	*ChangeHistoryChange_ChangeHistoryResource_ExpandedDataSet
	//	*ChangeHistoryChange_ChangeHistoryResource_ChannelGroup
	//	*ChangeHistoryChange_ChangeHistoryResource_BigqueryLink
	//	*ChangeHistoryChange_ChangeHistoryResource_EnhancedMeasurementSettings
	//	*ChangeHistoryChange_ChangeHistoryResource_AdsenseLink
	//	*ChangeHistoryChange_ChangeHistoryResource_Audience
	//	*ChangeHistoryChange_ChangeHistoryResource_EventCreateRule
	Resource isChangeHistoryChange_ChangeHistoryResource_Resource `protobuf_oneof:"resource"`
}

func (x *ChangeHistoryChange_ChangeHistoryResource) Reset() {
	*x = ChangeHistoryChange_ChangeHistoryResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeHistoryChange_ChangeHistoryResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeHistoryChange_ChangeHistoryResource) ProtoMessage() {}

func (x *ChangeHistoryChange_ChangeHistoryResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeHistoryChange_ChangeHistoryResource.ProtoReflect.Descriptor instead.
func (*ChangeHistoryChange_ChangeHistoryResource) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (m *ChangeHistoryChange_ChangeHistoryResource) GetResource() isChangeHistoryChange_ChangeHistoryResource_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetAccount() *Account {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_Account); ok {
		return x.Account
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetProperty() *Property {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_Property); ok {
		return x.Property
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetFirebaseLink() *FirebaseLink {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_FirebaseLink); ok {
		return x.FirebaseLink
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetGoogleAdsLink() *GoogleAdsLink {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_GoogleAdsLink); ok {
		return x.GoogleAdsLink
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetGoogleSignalsSettings() *GoogleSignalsSettings {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_GoogleSignalsSettings); ok {
		return x.GoogleSignalsSettings
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLink); ok {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetDisplayVideo_360AdvertiserLinkProposal() *DisplayVideo360AdvertiserLinkProposal {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLinkProposal); ok {
		return x.DisplayVideo_360AdvertiserLinkProposal
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetConversionEvent() *ConversionEvent {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_ConversionEvent); ok {
		return x.ConversionEvent
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_MeasurementProtocolSecret); ok {
		return x.MeasurementProtocolSecret
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetCustomDimension() *CustomDimension {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_CustomDimension); ok {
		return x.CustomDimension
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetCustomMetric() *CustomMetric {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_CustomMetric); ok {
		return x.CustomMetric
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetDataRetentionSettings() *DataRetentionSettings {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_DataRetentionSettings); ok {
		return x.DataRetentionSettings
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetSearchAds_360Link() *SearchAds360Link {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_SearchAds_360Link); ok {
		return x.SearchAds_360Link
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetDataStream() *DataStream {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_DataStream); ok {
		return x.DataStream
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetAttributionSettings() *AttributionSettings {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_AttributionSettings); ok {
		return x.AttributionSettings
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetExpandedDataSet() *ExpandedDataSet {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_ExpandedDataSet); ok {
		return x.ExpandedDataSet
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetChannelGroup() *ChannelGroup {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_ChannelGroup); ok {
		return x.ChannelGroup
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetBigqueryLink() *BigQueryLink {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_BigqueryLink); ok {
		return x.BigqueryLink
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetEnhancedMeasurementSettings() *EnhancedMeasurementSettings {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_EnhancedMeasurementSettings); ok {
		return x.EnhancedMeasurementSettings
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetAdsenseLink() *AdSenseLink {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_AdsenseLink); ok {
		return x.AdsenseLink
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetAudience() *Audience {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_Audience); ok {
		return x.Audience
	}
	return nil
}

func (x *ChangeHistoryChange_ChangeHistoryResource) GetEventCreateRule() *EventCreateRule {
	if x, ok := x.GetResource().(*ChangeHistoryChange_ChangeHistoryResource_EventCreateRule); ok {
		return x.EventCreateRule
	}
	return nil
}

type isChangeHistoryChange_ChangeHistoryResource_Resource interface {
	isChangeHistoryChange_ChangeHistoryResource_Resource()
}

type ChangeHistoryChange_ChangeHistoryResource_Account struct {
	// A snapshot of an Account resource in change history.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_Property struct {
	// A snapshot of a Property resource in change history.
	Property *Property `protobuf:"bytes,2,opt,name=property,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_FirebaseLink struct {
	// A snapshot of a FirebaseLink resource in change history.
	FirebaseLink *FirebaseLink `protobuf:"bytes,6,opt,name=firebase_link,json=firebaseLink,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_GoogleAdsLink struct {
	// A snapshot of a GoogleAdsLink resource in change history.
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,7,opt,name=google_ads_link,json=googleAdsLink,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_GoogleSignalsSettings struct {
	// A snapshot of a GoogleSignalsSettings resource in change history.
	GoogleSignalsSettings *GoogleSignalsSettings `protobuf:"bytes,8,opt,name=google_signals_settings,json=googleSignalsSettings,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLink struct {
	// A snapshot of a DisplayVideo360AdvertiserLink resource in change
	// history.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,9,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLinkProposal struct {
	// A snapshot of a DisplayVideo360AdvertiserLinkProposal resource in
	// change history.
	DisplayVideo_360AdvertiserLinkProposal *DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,10,opt,name=display_video_360_advertiser_link_proposal,json=displayVideo360AdvertiserLinkProposal,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_ConversionEvent struct {
	// A snapshot of a ConversionEvent resource in change history.
	ConversionEvent *ConversionEvent `protobuf:"bytes,11,opt,name=conversion_event,json=conversionEvent,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_MeasurementProtocolSecret struct {
	// A snapshot of a MeasurementProtocolSecret resource in change history.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,12,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_CustomDimension struct {
	// A snapshot of a CustomDimension resource in change history.
	CustomDimension *CustomDimension `protobuf:"bytes,13,opt,name=custom_dimension,json=customDimension,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_CustomMetric struct {
	// A snapshot of a CustomMetric resource in change history.
	CustomMetric *CustomMetric `protobuf:"bytes,14,opt,name=custom_metric,json=customMetric,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_DataRetentionSettings struct {
	// A snapshot of a data retention settings resource in change history.
	DataRetentionSettings *DataRetentionSettings `protobuf:"bytes,15,opt,name=data_retention_settings,json=dataRetentionSettings,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_SearchAds_360Link struct {
	// A snapshot of a SearchAds360Link resource in change history.
	SearchAds_360Link *SearchAds360Link `protobuf:"bytes,16,opt,name=search_ads_360_link,json=searchAds360Link,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_DataStream struct {
	// A snapshot of a DataStream resource in change history.
	DataStream *DataStream `protobuf:"bytes,18,opt,name=data_stream,json=dataStream,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_AttributionSettings struct {
	// A snapshot of AttributionSettings resource in change history.
	AttributionSettings *AttributionSettings `protobuf:"bytes,20,opt,name=attribution_settings,json=attributionSettings,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_ExpandedDataSet struct {
	// A snapshot of an ExpandedDataSet resource in change history.
	ExpandedDataSet *ExpandedDataSet `protobuf:"bytes,21,opt,name=expanded_data_set,json=expandedDataSet,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_ChannelGroup struct {
	// A snapshot of a ChannelGroup resource in change history.
	ChannelGroup *ChannelGroup `protobuf:"bytes,22,opt,name=channel_group,json=channelGroup,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_BigqueryLink struct {
	// A snapshot of a BigQuery link resource in change history.
	BigqueryLink *BigQueryLink `protobuf:"bytes,23,opt,name=bigquery_link,json=bigqueryLink,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_EnhancedMeasurementSettings struct {
	// A snapshot of EnhancedMeasurementSettings resource in change history.
	EnhancedMeasurementSettings *EnhancedMeasurementSettings `protobuf:"bytes,24,opt,name=enhanced_measurement_settings,json=enhancedMeasurementSettings,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_AdsenseLink struct {
	// A snapshot of an AdSenseLink resource in change history.
	AdsenseLink *AdSenseLink `protobuf:"bytes,27,opt,name=adsense_link,json=adsenseLink,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_Audience struct {
	// A snapshot of an Audience resource in change history.
	Audience *Audience `protobuf:"bytes,28,opt,name=audience,proto3,oneof"`
}

type ChangeHistoryChange_ChangeHistoryResource_EventCreateRule struct {
	// A snapshot of an EventCreateRule resource in change history.
	EventCreateRule *EventCreateRule `protobuf:"bytes,29,opt,name=event_create_rule,json=eventCreateRule,proto3,oneof"`
}

func (*ChangeHistoryChange_ChangeHistoryResource_Account) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_Property) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_FirebaseLink) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_GoogleAdsLink) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_GoogleSignalsSettings) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLink) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLinkProposal) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_ConversionEvent) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_MeasurementProtocolSecret) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_CustomDimension) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_CustomMetric) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_DataRetentionSettings) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_SearchAds_360Link) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_DataStream) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_AttributionSettings) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_ExpandedDataSet) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_ChannelGroup) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_BigqueryLink) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_EnhancedMeasurementSettings) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_AdsenseLink) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_Audience) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

func (*ChangeHistoryChange_ChangeHistoryResource_EventCreateRule) isChangeHistoryChange_ChangeHistoryResource_Resource() {
}

var File_google_analytics_admin_v1alpha_resources_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_resources_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xce, 0x02, 0x0a, 0x07, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x3a, 0x3e, 0xea, 0x41, 0x3b, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x22, 0xd3, 0x06, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x0d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x11,
	0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72,
	0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x10, 0x69, 0x6e, 0x64, 0x75, 0x73,
	0x74, 0x72, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x56, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x42, 0xea, 0x41, 0x3f, 0x0a, 0x26, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x15, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x22, 0xbc, 0x09, 0x0a, 0x0a,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x62, 0x0a, 0x0f, 0x77, 0x65,
	0x62, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x57, 0x65, 0x62, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x0d, 0x77, 0x65, 0x62, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x12, 0x78,
	0x0a, 0x17, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x41, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x14, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x12, 0x6c, 0x0a, 0x13, 0x69, 0x6f, 0x73, 0x5f,
	0x61, 0x70, 0x70, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61,
	0x74, 0x61, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x55, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x89, 0x01,
	0x0a, 0x0d, 0x57, 0x65, 0x62, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x2a, 0x0a, 0x0e, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x0f, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x41, 0x70, 0x70, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x55, 0x72, 0x69, 0x1a, 0x6b, 0x0a, 0x14, 0x41, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x2b, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x70,
	0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x41, 0x70, 0x70, 0x49, 0x64, 0x12, 0x26,
	0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x64, 0x0a, 0x10, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x0f, 0x66, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x41, 0x70, 0x70, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x09, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x7d, 0x0a, 0x0e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20,
	0x0a, 0x1c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x13, 0x0a, 0x0f, 0x57, 0x45, 0x42, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x4e, 0x44, 0x52, 0x4f, 0x49, 0x44,
	0x5f, 0x41, 0x50, 0x50, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d,
	0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4f, 0x53, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x03, 0x3a, 0x5e, 0xea, 0x41, 0x5b,
	0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x42, 0x0d, 0x0a, 0x0b, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x22, 0xf5, 0x01, 0x0a, 0x08, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x3a, 0x82, 0x01,
	0xea, 0x41, 0x7f, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x28, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x75, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x7d, 0x22, 0x94, 0x01, 0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0xee, 0x01, 0x0a, 0x0c, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x33, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x22, 0xb8, 0x01, 0x0a, 0x0d, 0x47,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53,
	0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x22, 0x84, 0x04, 0x0a, 0x0d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x61, 0x6e, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x5a, 0x0a, 0x1b, 0x61, 0x64, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x61, 0x64, 0x73, 0x50,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x22, 0x97, 0x04, 0x0a,
	0x13, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a,
	0x23, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1f, 0x73, 0x68, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x59, 0x0a, 0x2a, 0x73,
	0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x61, 0x6c, 0x65,
	0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x25, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x25, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x6e,
	0x79, 0x5f, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x20, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69,
	0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x6e, 0x79, 0x53, 0x61, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4e, 0x0a, 0x24, 0x73, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x20, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69,
	0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x1b, 0x73, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x73, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x3a, 0x5e, 0xea, 0x41, 0x5b, 0x0a, 0x31, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xc4, 0x02, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x44, 0x0a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x55, 0xea, 0x41, 0x52, 0x0a, 0x2c, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x22, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x7d, 0x22, 0xe8, 0x01,
	0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x47, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a,
	0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xae, 0x02, 0x0a, 0x19, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0xa7, 0x01, 0xea, 0x41, 0xa3, 0x01, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12,
	0x68, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d,
	0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x22, 0xcf, 0x02, 0x0a, 0x12, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a,
	0x0a, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x61, 0x63,
	0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x12, 0x4d, 0x0a, 0x07,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x99, 0x14, 0x0a, 0x13,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x42, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x14,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x7d, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x13,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x66, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x1a, 0xa1, 0x11, 0x0a, 0x15, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x43, 0x0a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x53, 0x0a, 0x0d, 0x66, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x48,
	0x00, 0x52, 0x0c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x57, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x6f, 0x0a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x48, 0x00, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x89, 0x01, 0x0a, 0x21, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f,
	0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0xa2, 0x01, 0x0a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x48, 0x00, 0x52, 0x25, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x5c, 0x0a, 0x10, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x7b, 0x0a, 0x1b, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x48, 0x00, 0x52, 0x19, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x5c, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x6f, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x48, 0x00, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x61, 0x0a, 0x13, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64,
	0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4d, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x68, 0x0a, 0x14, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00,
	0x52, 0x13, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5d, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x53, 0x0a, 0x0d, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x48, 0x00,
	0x52, 0x0c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x81,
	0x01, 0x0a, 0x1d, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x1b, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x50, 0x0a, 0x0c, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x46, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x11,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xd9, 0x04, 0x0a, 0x1d, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c,
	0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x17,
	0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x1b, 0x61, 0x64, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x61, 0x64, 0x73, 0x50,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x62, 0x0a, 0x1d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x1a, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5a, 0x0a, 0x19, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x63,
	0x6f, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x3a, 0x9b, 0x01, 0xea, 0x41, 0x97, 0x01, 0x0a, 0x3b, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d,
	0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f,
	0x7b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33,
	0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x7d, 0x22, 0xb0, 0x06, 0x0a, 0x25, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x0c, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x7f, 0x0a, 0x1c, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x3b, 0x0a, 0x17, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e,
	0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x5f,
	0x0a, 0x1b, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x19, 0x61, 0x64, 0x73, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x62, 0x0a, 0x1d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x1a, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x5a, 0x0a, 0x19, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x63, 0x6f, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x3a,
	0xb4, 0x01, 0xea, 0x41, 0xb0, 0x01, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x69, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x7b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x7d, 0x22, 0xfb, 0x04, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0c, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x62,
	0x0a, 0x1d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x1a, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x5a, 0x0a, 0x19, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x63, 0x6f, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3b,
	0x0a, 0x17, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x1b, 0x61,
	0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x61, 0x64,
	0x73, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x73, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x3a, 0x72, 0xea, 0x41, 0x6f, 0x0a, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36,
	0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x7d, 0x22, 0xbf, 0x02, 0x0a, 0x19, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x20, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1d, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x12, 0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x66,
	0x0a, 0x13, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x11, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xbf, 0x02, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x2d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xb6, 0x02, 0x0a, 0x15, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x53, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x3a, 0x65, 0xea, 0x41, 0x62, 0x0a,
	0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x8e, 0x04, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d,
	0x0a, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0d,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x1c, 0x64, 0x69,
	0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41,
	0x64, 0x73, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x50, 0x0a, 0x0e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x55, 0x53, 0x45, 0x52, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x54, 0x45,
	0x4d, 0x10, 0x03, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x22, 0xa2, 0x07, 0x0a, 0x0c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x0e,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x10, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x6e,
	0x69, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x56, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x12, 0x7c, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb7,
	0x01, 0x0a, 0x0f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x6e,
	0x69, 0x74, 0x12, 0x20, 0x0a, 0x1c, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52, 0x45, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x59, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x46, 0x45, 0x45, 0x54, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45,
	0x54, 0x45, 0x52, 0x53, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x4b, 0x49, 0x4c, 0x4f, 0x4d, 0x45,
	0x54, 0x45, 0x52, 0x53, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x49, 0x4c, 0x45, 0x53, 0x10,
	0x06, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x53, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x08,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x53, 0x10, 0x09, 0x12, 0x09, 0x0a,
	0x05, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x0a, 0x22, 0x36, 0x0a, 0x0b, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x45, 0x54, 0x52, 0x49,
	0x43, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x01,
	0x22, 0x5f, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x52, 0x45, 0x53, 0x54,
	0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x53, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x52, 0x45, 0x56, 0x45, 0x4e, 0x55, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10,
	0x02, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x33, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x7d, 0x22, 0xf8, 0x03, 0x0a, 0x15, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x79, 0x0a, 0x14, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x12, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x1f, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x6e, 0x5f, 0x6e, 0x65, 0x77, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a,
	0x72, 0x65, 0x73, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x6e, 0x4e,
	0x65, 0x77, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x22, 0x9e, 0x01, 0x0a, 0x11, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x55,
	0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x57, 0x4f, 0x5f, 0x4d, 0x4f, 0x4e, 0x54,
	0x48, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x46, 0x4f, 0x55, 0x52, 0x54, 0x45, 0x45, 0x4e,
	0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x53, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x57, 0x45,
	0x4e, 0x54, 0x59, 0x5f, 0x53, 0x49, 0x58, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x53, 0x10, 0x04,
	0x12, 0x17, 0x0a, 0x13, 0x54, 0x48, 0x49, 0x52, 0x54, 0x59, 0x5f, 0x45, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x53, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x49, 0x46,
	0x54, 0x59, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x53, 0x10, 0x06, 0x3a, 0x65, 0xea, 0x41, 0x62,
	0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0xd4, 0x0d, 0x0a, 0x13, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x2c, 0x61, 0x63, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x41, 0x63, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x6f, 0x6b, 0x62, 0x61,
	0x63, 0x6b, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x28, 0x61,
	0x63, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63,
	0x6b, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0xaf, 0x01, 0x0a, 0x26, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4f, 0x74,
	0x68, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x4c, 0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63, 0x6b, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x22, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x6f, 0x6b, 0x62,
	0x61, 0x63, 0x6b, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x92, 0x01, 0x0a, 0x1b, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x19, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0xa7,
	0x01, 0x0a, 0x24, 0x61, 0x64, 0x73, 0x5f, 0x77, 0x65, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x41, 0x64, 0x73, 0x57, 0x65, 0x62, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1f, 0x61, 0x64, 0x73, 0x57, 0x65, 0x62, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x28, 0x41, 0x63, 0x71,
	0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63, 0x6b, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x3c, 0x0a, 0x38, 0x41, 0x43, 0x51, 0x55, 0x49, 0x53, 0x49,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x4f, 0x4f, 0x4b, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x57,
	0x49, 0x4e, 0x44, 0x4f, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x37, 0x0a, 0x33, 0x41, 0x43, 0x51, 0x55, 0x49, 0x53, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x4f, 0x4f, 0x4b, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x57, 0x49, 0x4e,
	0x44, 0x4f, 0x57, 0x5f, 0x37, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x38, 0x0a, 0x34,
	0x41, 0x43, 0x51, 0x55, 0x49, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x4f, 0x4f,
	0x4b, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x5f, 0x33, 0x30, 0x5f,
	0x44, 0x41, 0x59, 0x53, 0x10, 0x02, 0x22, 0xf8, 0x01, 0x0a, 0x22, 0x4f, 0x74, 0x68, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c,
	0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63, 0x6b, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x36, 0x0a,
	0x32, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x4f, 0x4f, 0x4b, 0x42, 0x41, 0x43, 0x4b,
	0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x32, 0x0a, 0x2e, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x43,
	0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x4c, 0x4f, 0x4f, 0x4b, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x5f,
	0x33, 0x30, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x32, 0x0a, 0x2e, 0x4f, 0x54, 0x48,
	0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x4f, 0x4f, 0x4b, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x57, 0x49, 0x4e,
	0x44, 0x4f, 0x57, 0x5f, 0x36, 0x30, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x02, 0x12, 0x32, 0x0a,
	0x2e, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x4f, 0x4f, 0x4b, 0x42, 0x41, 0x43, 0x4b,
	0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x5f, 0x39, 0x30, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10,
	0x03, 0x22, 0x9c, 0x02, 0x0a, 0x19, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x2b, 0x0a, 0x27, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x54, 0x54,
	0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19,
	0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x43,
	0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4c, 0x41, 0x53,
	0x54, 0x5f, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x52, 0x4f,
	0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54,
	0x5f, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x52, 0x4f, 0x53,
	0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52,
	0x10, 0x04, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e,
	0x4e, 0x45, 0x4c, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x41, 0x53,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x43, 0x41, 0x59,
	0x10, 0x06, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x44, 0x53, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52,
	0x52, 0x45, 0x44, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x10, 0x07,
	0x22, 0x93, 0x01, 0x0a, 0x1f, 0x41, 0x64, 0x73, 0x57, 0x65, 0x62, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x30, 0x41, 0x44, 0x53, 0x5f, 0x57, 0x45, 0x42, 0x5f,
	0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x4f,
	0x54, 0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x59, 0x45, 0x54, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45,
	0x4c, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x44, 0x53, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45,
	0x52, 0x52, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x31, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x29,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x84, 0x02, 0x0a, 0x0d, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a, 0x04, 0x75,
	0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73,
	0x3a, 0x9c, 0x01, 0xea, 0x41, 0x98, 0x01, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x32, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x35, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x42,
	0x0f, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x22, 0x98, 0x04, 0x0a, 0x0c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x64,
	0x61, 0x69, 0x6c, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x61, 0x69, 0x6c, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x38, 0x0a,
	0x18, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x16, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x72, 0x61,
	0x64, 0x61, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x64,
	0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x34, 0x0a, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x33, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x62, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x22, 0xc6, 0x05, 0x0a, 0x1b,
	0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x73, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x13,
	0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x69, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x18,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x45, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x14,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x70, 0x61, 0x67, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3a,
	0x0a, 0x19, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x17, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x16, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x14, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x75, 0x72, 0x69, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x75, 0x72, 0x69, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x3a, 0x8c, 0x01, 0xea, 0x41, 0x88, 0x01, 0x0a, 0x39, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x68, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x2f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0x56, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x06, 0x74, 0x61, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x67, 0x49, 0x64, 0x22, 0xb4, 0x01, 0x0a,
	0x0b, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x0c, 0x61, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64, 0x65,
	0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x29, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x31, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x61, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x7d, 0x2a, 0xaa, 0x04, 0x0a, 0x10, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x44, 0x55,
	0x53, 0x54, 0x52, 0x59, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x41,
	0x55, 0x54, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x42,
	0x55, 0x53, 0x49, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x49, 0x4e, 0x44, 0x55,
	0x53, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x54, 0x53, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a,
	0x0a, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x41, 0x52, 0x45, 0x10, 0x04, 0x12, 0x0e, 0x0a,
	0x0a, 0x54, 0x45, 0x43, 0x48, 0x4e, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x10, 0x05, 0x12, 0x0a, 0x0a,
	0x06, 0x54, 0x52, 0x41, 0x56, 0x45, 0x4c, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48,
	0x45, 0x52, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x52, 0x54, 0x53, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x54, 0x41, 0x49, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x08,
	0x12, 0x16, 0x0a, 0x12, 0x42, 0x45, 0x41, 0x55, 0x54, 0x59, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x46,
	0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x4f, 0x4f, 0x4b,
	0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4c, 0x49, 0x54, 0x45, 0x52, 0x41, 0x54, 0x55, 0x52, 0x45,
	0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x4f, 0x4f, 0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44,
	0x52, 0x49, 0x4e, 0x4b, 0x10, 0x0b, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x41, 0x4d, 0x45, 0x53, 0x10,
	0x0c, 0x12, 0x17, 0x0a, 0x13, 0x48, 0x4f, 0x42, 0x42, 0x49, 0x45, 0x53, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x4c, 0x45, 0x49, 0x53, 0x55, 0x52, 0x45, 0x10, 0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x48, 0x4f,
	0x4d, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x41, 0x52, 0x44, 0x45, 0x4e, 0x10, 0x0e, 0x12,
	0x18, 0x0a, 0x14, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f,
	0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x10, 0x0f, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x41, 0x57,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x10, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x45, 0x57, 0x53, 0x10, 0x11, 0x12, 0x16, 0x0a, 0x12, 0x4f,
	0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x4e, 0x49, 0x54, 0x49, 0x45,
	0x53, 0x10, 0x12, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x4f, 0x50, 0x4c, 0x45, 0x5f, 0x41, 0x4e,
	0x44, 0x5f, 0x53, 0x4f, 0x43, 0x49, 0x45, 0x54, 0x59, 0x10, 0x13, 0x12, 0x14, 0x0a, 0x10, 0x50,
	0x45, 0x54, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x53, 0x10,
	0x14, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x41, 0x4c, 0x5f, 0x45, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x10, 0x15, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10,
	0x16, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x43, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x17, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x10, 0x18, 0x12, 0x16, 0x0a, 0x12, 0x4a, 0x4f,
	0x42, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x45, 0x44, 0x55, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x19, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x48, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x1a,
	0x2a, 0x66, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45,
	0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1d, 0x0a, 0x19, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x54,
	0x49, 0x43, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x54, 0x49,
	0x43, 0x53, 0x5f, 0x33, 0x36, 0x30, 0x10, 0x02, 0x2a, 0x4a, 0x0a, 0x09, 0x41, 0x63, 0x74, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x50, 0x50, 0x4f,
	0x52, 0x54, 0x10, 0x03, 0x2a, 0x50, 0x0a, 0x0a, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x2a, 0xc5, 0x04, 0x0a, 0x19, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x28, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x48,
	0x49, 0x53, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x59, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x46, 0x49, 0x52, 0x45, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x06,
	0x12, 0x13, 0x0a, 0x0f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x44, 0x53, 0x5f, 0x4c,
	0x49, 0x4e, 0x4b, 0x10, 0x07, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f,
	0x53, 0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53,
	0x10, 0x08, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x09, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x45, 0x41, 0x53,
	0x55, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c,
	0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x10, 0x0a, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x5f, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x12,
	0x11, 0x0a, 0x0d, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43,
	0x10, 0x0c, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45, 0x54, 0x45, 0x4e,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x10, 0x0d, 0x12,
	0x25, 0x0a, 0x21, 0x44, 0x49, 0x53, 0x50, 0x4c, 0x41, 0x59, 0x5f, 0x56, 0x49, 0x44, 0x45, 0x4f,
	0x5f, 0x33, 0x36, 0x30, 0x5f, 0x41, 0x44, 0x56, 0x45, 0x52, 0x54, 0x49, 0x53, 0x45, 0x52, 0x5f,
	0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x0e, 0x12, 0x2e, 0x0a, 0x2a, 0x44, 0x49, 0x53, 0x50, 0x4c, 0x41,
	0x59, 0x5f, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x41, 0x44, 0x56, 0x45,
	0x52, 0x54, 0x49, 0x53, 0x45, 0x52, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x50, 0x52, 0x4f, 0x50,
	0x4f, 0x53, 0x41, 0x4c, 0x10, 0x0f, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48,
	0x5f, 0x41, 0x44, 0x53, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x10, 0x12,
	0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x12,
	0x12, 0x18, 0x0a, 0x14, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x10, 0x14, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x58,
	0x50, 0x41, 0x4e, 0x44, 0x45, 0x44, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x45, 0x54, 0x10,
	0x15, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x10, 0x16, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x4e, 0x48, 0x41, 0x4e, 0x43, 0x45, 0x44,
	0x5f, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x54,
	0x54, 0x49, 0x4e, 0x47, 0x53, 0x10, 0x18, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x44, 0x53, 0x45, 0x4e,
	0x53, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x1b, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x55, 0x44,
	0x49, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x1c, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x1d, 0x2a, 0x73,
	0x0a, 0x12, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53,
	0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x2a, 0x8e, 0x01, 0x0a, 0x14, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x22,
	0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x43,
	0x4f, 0x4e, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53,
	0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x43,
	0x4f, 0x4e, 0x53, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x28, 0x0a, 0x24, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x4c, 0x53, 0x5f, 0x43, 0x4f, 0x4e,
	0x53, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x45, 0x4e, 0x54,
	0x45, 0x44, 0x10, 0x01, 0x2a, 0x7b, 0x0a, 0x1d, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x30, 0x0a, 0x2c, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x50, 0x52,
	0x4f, 0x50, 0x4f, 0x53, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x54, 0x49, 0x43, 0x53, 0x10, 0x01, 0x12, 0x12, 0x0a,
	0x0e, 0x4c, 0x49, 0x4e, 0x4b, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x10,
	0x02, 0x2a, 0xc4, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4c, 0x49, 0x4e, 0x4b, 0x5f,
	0x50, 0x52, 0x4f, 0x50, 0x4f, 0x53, 0x41, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x29, 0x0a, 0x25,
	0x41, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x4e, 0x41, 0x4c,
	0x59, 0x54, 0x49, 0x43, 0x53, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x41, 0x57, 0x41, 0x49, 0x54,
	0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f,
	0x4c, 0x49, 0x4e, 0x4b, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x57, 0x49, 0x54, 0x48, 0x44, 0x52, 0x41, 0x57, 0x4e, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a,
	0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x42,
	0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x06, 0x2a, 0x82, 0x01, 0x0a, 0x0c, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x52, 0x4f,
	0x50, 0x45, 0x52, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x52, 0x4f, 0x50,
	0x45, 0x52, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x44, 0x49, 0x4e, 0x41,
	0x52, 0x59, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x59,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x55, 0x42, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54,
	0x59, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x59, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x55, 0x50, 0x10, 0x03, 0x42, 0x76, 0x0a,
	0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_resources_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_resources_proto_rawDescData = file_google_analytics_admin_v1alpha_resources_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_resources_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_resources_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 20)
var file_google_analytics_admin_v1alpha_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 33)
var file_google_analytics_admin_v1alpha_resources_proto_goTypes = []interface{}{
	(IndustryCategory)(0),                        // 0: google.analytics.admin.v1alpha.IndustryCategory
	(ServiceLevel)(0),                            // 1: google.analytics.admin.v1alpha.ServiceLevel
	(ActorType)(0),                               // 2: google.analytics.admin.v1alpha.ActorType
	(ActionType)(0),                              // 3: google.analytics.admin.v1alpha.ActionType
	(ChangeHistoryResourceType)(0),               // 4: google.analytics.admin.v1alpha.ChangeHistoryResourceType
	(GoogleSignalsState)(0),                      // 5: google.analytics.admin.v1alpha.GoogleSignalsState
	(GoogleSignalsConsent)(0),                    // 6: google.analytics.admin.v1alpha.GoogleSignalsConsent
	(LinkProposalInitiatingProduct)(0),           // 7: google.analytics.admin.v1alpha.LinkProposalInitiatingProduct
	(LinkProposalState)(0),                       // 8: google.analytics.admin.v1alpha.LinkProposalState
	(PropertyType)(0),                            // 9: google.analytics.admin.v1alpha.PropertyType
	(DataStream_DataStreamType)(0),               // 10: google.analytics.admin.v1alpha.DataStream.DataStreamType
	(CustomDimension_DimensionScope)(0),          // 11: google.analytics.admin.v1alpha.CustomDimension.DimensionScope
	(CustomMetric_MeasurementUnit)(0),            // 12: google.analytics.admin.v1alpha.CustomMetric.MeasurementUnit
	(CustomMetric_MetricScope)(0),                // 13: google.analytics.admin.v1alpha.CustomMetric.MetricScope
	(CustomMetric_RestrictedMetricType)(0),       // 14: google.analytics.admin.v1alpha.CustomMetric.RestrictedMetricType
	(DataRetentionSettings_RetentionDuration)(0), // 15: google.analytics.admin.v1alpha.DataRetentionSettings.RetentionDuration
	(AttributionSettings_AcquisitionConversionEventLookbackWindow)(0), // 16: google.analytics.admin.v1alpha.AttributionSettings.AcquisitionConversionEventLookbackWindow
	(AttributionSettings_OtherConversionEventLookbackWindow)(0),       // 17: google.analytics.admin.v1alpha.AttributionSettings.OtherConversionEventLookbackWindow
	(AttributionSettings_ReportingAttributionModel)(0),                // 18: google.analytics.admin.v1alpha.AttributionSettings.ReportingAttributionModel
	(AttributionSettings_AdsWebConversionDataExportScope)(0),          // 19: google.analytics.admin.v1alpha.AttributionSettings.AdsWebConversionDataExportScope
	(*Account)(nil),                                   // 20: google.analytics.admin.v1alpha.Account
	(*Property)(nil),                                  // 21: google.analytics.admin.v1alpha.Property
	(*DataStream)(nil),                                // 22: google.analytics.admin.v1alpha.DataStream
	(*UserLink)(nil),                                  // 23: google.analytics.admin.v1alpha.UserLink
	(*AuditUserLink)(nil),                             // 24: google.analytics.admin.v1alpha.AuditUserLink
	(*FirebaseLink)(nil),                              // 25: google.analytics.admin.v1alpha.FirebaseLink
	(*GlobalSiteTag)(nil),                             // 26: google.analytics.admin.v1alpha.GlobalSiteTag
	(*GoogleAdsLink)(nil),                             // 27: google.analytics.admin.v1alpha.GoogleAdsLink
	(*DataSharingSettings)(nil),                       // 28: google.analytics.admin.v1alpha.DataSharingSettings
	(*AccountSummary)(nil),                            // 29: google.analytics.admin.v1alpha.AccountSummary
	(*PropertySummary)(nil),                           // 30: google.analytics.admin.v1alpha.PropertySummary
	(*MeasurementProtocolSecret)(nil),                 // 31: google.analytics.admin.v1alpha.MeasurementProtocolSecret
	(*ChangeHistoryEvent)(nil),                        // 32: google.analytics.admin.v1alpha.ChangeHistoryEvent
	(*ChangeHistoryChange)(nil),                       // 33: google.analytics.admin.v1alpha.ChangeHistoryChange
	(*DisplayVideo360AdvertiserLink)(nil),             // 34: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	(*DisplayVideo360AdvertiserLinkProposal)(nil),     // 35: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	(*SearchAds360Link)(nil),                          // 36: google.analytics.admin.v1alpha.SearchAds360Link
	(*LinkProposalStatusDetails)(nil),                 // 37: google.analytics.admin.v1alpha.LinkProposalStatusDetails
	(*ConversionEvent)(nil),                           // 38: google.analytics.admin.v1alpha.ConversionEvent
	(*GoogleSignalsSettings)(nil),                     // 39: google.analytics.admin.v1alpha.GoogleSignalsSettings
	(*CustomDimension)(nil),                           // 40: google.analytics.admin.v1alpha.CustomDimension
	(*CustomMetric)(nil),                              // 41: google.analytics.admin.v1alpha.CustomMetric
	(*DataRetentionSettings)(nil),                     // 42: google.analytics.admin.v1alpha.DataRetentionSettings
	(*AttributionSettings)(nil),                       // 43: google.analytics.admin.v1alpha.AttributionSettings
	(*AccessBinding)(nil),                             // 44: google.analytics.admin.v1alpha.AccessBinding
	(*BigQueryLink)(nil),                              // 45: google.analytics.admin.v1alpha.BigQueryLink
	(*EnhancedMeasurementSettings)(nil),               // 46: google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	(*ConnectedSiteTag)(nil),                          // 47: google.analytics.admin.v1alpha.ConnectedSiteTag
	(*AdSenseLink)(nil),                               // 48: google.analytics.admin.v1alpha.AdSenseLink
	(*DataStream_WebStreamData)(nil),                  // 49: google.analytics.admin.v1alpha.DataStream.WebStreamData
	(*DataStream_AndroidAppStreamData)(nil),           // 50: google.analytics.admin.v1alpha.DataStream.AndroidAppStreamData
	(*DataStream_IosAppStreamData)(nil),               // 51: google.analytics.admin.v1alpha.DataStream.IosAppStreamData
	(*ChangeHistoryChange_ChangeHistoryResource)(nil), // 52: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource
	(*timestamppb.Timestamp)(nil),                     // 53: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),                      // 54: google.protobuf.BoolValue
	(*ExpandedDataSet)(nil),                           // 55: google.analytics.admin.v1alpha.ExpandedDataSet
	(*ChannelGroup)(nil),                              // 56: google.analytics.admin.v1alpha.ChannelGroup
	(*Audience)(nil),                                  // 57: google.analytics.admin.v1alpha.Audience
	(*EventCreateRule)(nil),                           // 58: google.analytics.admin.v1alpha.EventCreateRule
}
var file_google_analytics_admin_v1alpha_resources_proto_depIdxs = []int32{
	53, // 0: google.analytics.admin.v1alpha.Account.create_time:type_name -> google.protobuf.Timestamp
	53, // 1: google.analytics.admin.v1alpha.Account.update_time:type_name -> google.protobuf.Timestamp
	9,  // 2: google.analytics.admin.v1alpha.Property.property_type:type_name -> google.analytics.admin.v1alpha.PropertyType
	53, // 3: google.analytics.admin.v1alpha.Property.create_time:type_name -> google.protobuf.Timestamp
	53, // 4: google.analytics.admin.v1alpha.Property.update_time:type_name -> google.protobuf.Timestamp
	0,  // 5: google.analytics.admin.v1alpha.Property.industry_category:type_name -> google.analytics.admin.v1alpha.IndustryCategory
	1,  // 6: google.analytics.admin.v1alpha.Property.service_level:type_name -> google.analytics.admin.v1alpha.ServiceLevel
	53, // 7: google.analytics.admin.v1alpha.Property.delete_time:type_name -> google.protobuf.Timestamp
	53, // 8: google.analytics.admin.v1alpha.Property.expire_time:type_name -> google.protobuf.Timestamp
	49, // 9: google.analytics.admin.v1alpha.DataStream.web_stream_data:type_name -> google.analytics.admin.v1alpha.DataStream.WebStreamData
	50, // 10: google.analytics.admin.v1alpha.DataStream.android_app_stream_data:type_name -> google.analytics.admin.v1alpha.DataStream.AndroidAppStreamData
	51, // 11: google.analytics.admin.v1alpha.DataStream.ios_app_stream_data:type_name -> google.analytics.admin.v1alpha.DataStream.IosAppStreamData
	10, // 12: google.analytics.admin.v1alpha.DataStream.type:type_name -> google.analytics.admin.v1alpha.DataStream.DataStreamType
	53, // 13: google.analytics.admin.v1alpha.DataStream.create_time:type_name -> google.protobuf.Timestamp
	53, // 14: google.analytics.admin.v1alpha.DataStream.update_time:type_name -> google.protobuf.Timestamp
	53, // 15: google.analytics.admin.v1alpha.FirebaseLink.create_time:type_name -> google.protobuf.Timestamp
	54, // 16: google.analytics.admin.v1alpha.GoogleAdsLink.ads_personalization_enabled:type_name -> google.protobuf.BoolValue
	53, // 17: google.analytics.admin.v1alpha.GoogleAdsLink.create_time:type_name -> google.protobuf.Timestamp
	53, // 18: google.analytics.admin.v1alpha.GoogleAdsLink.update_time:type_name -> google.protobuf.Timestamp
	30, // 19: google.analytics.admin.v1alpha.AccountSummary.property_summaries:type_name -> google.analytics.admin.v1alpha.PropertySummary
	9,  // 20: google.analytics.admin.v1alpha.PropertySummary.property_type:type_name -> google.analytics.admin.v1alpha.PropertyType
	53, // 21: google.analytics.admin.v1alpha.ChangeHistoryEvent.change_time:type_name -> google.protobuf.Timestamp
	2,  // 22: google.analytics.admin.v1alpha.ChangeHistoryEvent.actor_type:type_name -> google.analytics.admin.v1alpha.ActorType
	33, // 23: google.analytics.admin.v1alpha.ChangeHistoryEvent.changes:type_name -> google.analytics.admin.v1alpha.ChangeHistoryChange
	3,  // 24: google.analytics.admin.v1alpha.ChangeHistoryChange.action:type_name -> google.analytics.admin.v1alpha.ActionType
	52, // 25: google.analytics.admin.v1alpha.ChangeHistoryChange.resource_before_change:type_name -> google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource
	52, // 26: google.analytics.admin.v1alpha.ChangeHistoryChange.resource_after_change:type_name -> google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource
	54, // 27: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink.ads_personalization_enabled:type_name -> google.protobuf.BoolValue
	54, // 28: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink.campaign_data_sharing_enabled:type_name -> google.protobuf.BoolValue
	54, // 29: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink.cost_data_sharing_enabled:type_name -> google.protobuf.BoolValue
	37, // 30: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal.link_proposal_status_details:type_name -> google.analytics.admin.v1alpha.LinkProposalStatusDetails
	54, // 31: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal.ads_personalization_enabled:type_name -> google.protobuf.BoolValue
	54, // 32: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal.campaign_data_sharing_enabled:type_name -> google.protobuf.BoolValue
	54, // 33: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal.cost_data_sharing_enabled:type_name -> google.protobuf.BoolValue
	54, // 34: google.analytics.admin.v1alpha.SearchAds360Link.campaign_data_sharing_enabled:type_name -> google.protobuf.BoolValue
	54, // 35: google.analytics.admin.v1alpha.SearchAds360Link.cost_data_sharing_enabled:type_name -> google.protobuf.BoolValue
	54, // 36: google.analytics.admin.v1alpha.SearchAds360Link.ads_personalization_enabled:type_name -> google.protobuf.BoolValue
	54, // 37: google.analytics.admin.v1alpha.SearchAds360Link.site_stats_sharing_enabled:type_name -> google.protobuf.BoolValue
	7,  // 38: google.analytics.admin.v1alpha.LinkProposalStatusDetails.link_proposal_initiating_product:type_name -> google.analytics.admin.v1alpha.LinkProposalInitiatingProduct
	8,  // 39: google.analytics.admin.v1alpha.LinkProposalStatusDetails.link_proposal_state:type_name -> google.analytics.admin.v1alpha.LinkProposalState
	53, // 40: google.analytics.admin.v1alpha.ConversionEvent.create_time:type_name -> google.protobuf.Timestamp
	5,  // 41: google.analytics.admin.v1alpha.GoogleSignalsSettings.state:type_name -> google.analytics.admin.v1alpha.GoogleSignalsState
	6,  // 42: google.analytics.admin.v1alpha.GoogleSignalsSettings.consent:type_name -> google.analytics.admin.v1alpha.GoogleSignalsConsent
	11, // 43: google.analytics.admin.v1alpha.CustomDimension.scope:type_name -> google.analytics.admin.v1alpha.CustomDimension.DimensionScope
	12, // 44: google.analytics.admin.v1alpha.CustomMetric.measurement_unit:type_name -> google.analytics.admin.v1alpha.CustomMetric.MeasurementUnit
	13, // 45: google.analytics.admin.v1alpha.CustomMetric.scope:type_name -> google.analytics.admin.v1alpha.CustomMetric.MetricScope
	14, // 46: google.analytics.admin.v1alpha.CustomMetric.restricted_metric_type:type_name -> google.analytics.admin.v1alpha.CustomMetric.RestrictedMetricType
	15, // 47: google.analytics.admin.v1alpha.DataRetentionSettings.event_data_retention:type_name -> google.analytics.admin.v1alpha.DataRetentionSettings.RetentionDuration
	16, // 48: google.analytics.admin.v1alpha.AttributionSettings.acquisition_conversion_event_lookback_window:type_name -> google.analytics.admin.v1alpha.AttributionSettings.AcquisitionConversionEventLookbackWindow
	17, // 49: google.analytics.admin.v1alpha.AttributionSettings.other_conversion_event_lookback_window:type_name -> google.analytics.admin.v1alpha.AttributionSettings.OtherConversionEventLookbackWindow
	18, // 50: google.analytics.admin.v1alpha.AttributionSettings.reporting_attribution_model:type_name -> google.analytics.admin.v1alpha.AttributionSettings.ReportingAttributionModel
	19, // 51: google.analytics.admin.v1alpha.AttributionSettings.ads_web_conversion_data_export_scope:type_name -> google.analytics.admin.v1alpha.AttributionSettings.AdsWebConversionDataExportScope
	53, // 52: google.analytics.admin.v1alpha.BigQueryLink.create_time:type_name -> google.protobuf.Timestamp
	20, // 53: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.account:type_name -> google.analytics.admin.v1alpha.Account
	21, // 54: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.property:type_name -> google.analytics.admin.v1alpha.Property
	25, // 55: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.firebase_link:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	27, // 56: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	39, // 57: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.google_signals_settings:type_name -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	34, // 58: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	35, // 59: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.display_video_360_advertiser_link_proposal:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	38, // 60: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.conversion_event:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	31, // 61: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	40, // 62: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	41, // 63: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	42, // 64: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.data_retention_settings:type_name -> google.analytics.admin.v1alpha.DataRetentionSettings
	36, // 65: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.search_ads_360_link:type_name -> google.analytics.admin.v1alpha.SearchAds360Link
	22, // 66: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.data_stream:type_name -> google.analytics.admin.v1alpha.DataStream
	43, // 67: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.attribution_settings:type_name -> google.analytics.admin.v1alpha.AttributionSettings
	55, // 68: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.expanded_data_set:type_name -> google.analytics.admin.v1alpha.ExpandedDataSet
	56, // 69: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.channel_group:type_name -> google.analytics.admin.v1alpha.ChannelGroup
	45, // 70: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.bigquery_link:type_name -> google.analytics.admin.v1alpha.BigQueryLink
	46, // 71: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.enhanced_measurement_settings:type_name -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	48, // 72: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.adsense_link:type_name -> google.analytics.admin.v1alpha.AdSenseLink
	57, // 73: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.audience:type_name -> google.analytics.admin.v1alpha.Audience
	58, // 74: google.analytics.admin.v1alpha.ChangeHistoryChange.ChangeHistoryResource.event_create_rule:type_name -> google.analytics.admin.v1alpha.EventCreateRule
	75, // [75:75] is the sub-list for method output_type
	75, // [75:75] is the sub-list for method input_type
	75, // [75:75] is the sub-list for extension type_name
	75, // [75:75] is the sub-list for extension extendee
	0,  // [0:75] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_resources_proto_init() }
func file_google_analytics_admin_v1alpha_resources_proto_init() {
	if File_google_analytics_admin_v1alpha_resources_proto != nil {
		return
	}
	file_google_analytics_admin_v1alpha_audience_proto_init()
	file_google_analytics_admin_v1alpha_channel_group_proto_init()
	file_google_analytics_admin_v1alpha_event_create_and_edit_proto_init()
	file_google_analytics_admin_v1alpha_expanded_data_set_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Account); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FirebaseLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlobalSiteTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleAdsLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSharingSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertySummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeasurementProtocolSecret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeHistoryEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeHistoryChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisplayVideo360AdvertiserLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisplayVideo360AdvertiserLinkProposal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAds360Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinkProposalStatusDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversionEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleSignalsSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRetentionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessBinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnhancedMeasurementSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectedSiteTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdSenseLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataStream_WebStreamData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataStream_AndroidAppStreamData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataStream_IosAppStreamData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeHistoryChange_ChangeHistoryResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*DataStream_WebStreamData_)(nil),
		(*DataStream_AndroidAppStreamData_)(nil),
		(*DataStream_IosAppStreamData_)(nil),
	}
	file_google_analytics_admin_v1alpha_resources_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*AccessBinding_User)(nil),
	}
	file_google_analytics_admin_v1alpha_resources_proto_msgTypes[32].OneofWrappers = []interface{}{
		(*ChangeHistoryChange_ChangeHistoryResource_Account)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_Property)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_FirebaseLink)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_GoogleAdsLink)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_GoogleSignalsSettings)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLink)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_DisplayVideo_360AdvertiserLinkProposal)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_ConversionEvent)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_MeasurementProtocolSecret)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_CustomDimension)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_CustomMetric)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_DataRetentionSettings)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_SearchAds_360Link)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_DataStream)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_AttributionSettings)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_ExpandedDataSet)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_ChannelGroup)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_BigqueryLink)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_EnhancedMeasurementSettings)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_AdsenseLink)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_Audience)(nil),
		(*ChangeHistoryChange_ChangeHistoryResource_EventCreateRule)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_resources_proto_rawDesc,
			NumEnums:      20,
			NumMessages:   33,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_resources_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_resources_proto_depIdxs,
		EnumInfos:         file_google_analytics_admin_v1alpha_resources_proto_enumTypes,
		MessageInfos:      file_google_analytics_admin_v1alpha_resources_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_resources_proto = out.File
	file_google_analytics_admin_v1alpha_resources_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_resources_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_resources_proto_depIdxs = nil
}
