// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package gkemulticloud

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	gkemulticloudpb "google.golang.org/genproto/googleapis/cloud/gkemulticloud/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newAzureClustersClientHook clientHook

// AzureClustersCallOptions contains the retry settings for each method of AzureClustersClient.
type AzureClustersCallOptions struct {
	CreateAzureClient        []gax.CallOption
	GetAzureClient           []gax.CallOption
	ListAzureClients         []gax.CallOption
	DeleteAzureClient        []gax.CallOption
	CreateAzureCluster       []gax.CallOption
	UpdateAzureCluster       []gax.CallOption
	GetAzureCluster          []gax.CallOption
	ListAzureClusters        []gax.CallOption
	DeleteAzureCluster       []gax.CallOption
	GenerateAzureAccessToken []gax.CallOption
	CreateAzureNodePool      []gax.CallOption
	UpdateAzureNodePool      []gax.CallOption
	GetAzureNodePool         []gax.CallOption
	ListAzureNodePools       []gax.CallOption
	DeleteAzureNodePool      []gax.CallOption
	GetAzureServerConfig     []gax.CallOption
}

func defaultAzureClustersGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("gkemulticloud.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("gkemulticloud.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://gkemulticloud.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAzureClustersCallOptions() *AzureClustersCallOptions {
	return &AzureClustersCallOptions{
		CreateAzureClient: []gax.CallOption{},
		GetAzureClient: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAzureClients: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAzureClient:  []gax.CallOption{},
		CreateAzureCluster: []gax.CallOption{},
		UpdateAzureCluster: []gax.CallOption{},
		GetAzureCluster: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAzureClusters: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAzureCluster: []gax.CallOption{},
		GenerateAzureAccessToken: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateAzureNodePool: []gax.CallOption{},
		UpdateAzureNodePool: []gax.CallOption{},
		GetAzureNodePool: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAzureNodePools: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAzureNodePool: []gax.CallOption{},
		GetAzureServerConfig: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// internalAzureClustersClient is an interface that defines the methods available from Anthos Multi-Cloud API.
type internalAzureClustersClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateAzureClient(context.Context, *gkemulticloudpb.CreateAzureClientRequest, ...gax.CallOption) (*CreateAzureClientOperation, error)
	CreateAzureClientOperation(name string) *CreateAzureClientOperation
	GetAzureClient(context.Context, *gkemulticloudpb.GetAzureClientRequest, ...gax.CallOption) (*gkemulticloudpb.AzureClient, error)
	ListAzureClients(context.Context, *gkemulticloudpb.ListAzureClientsRequest, ...gax.CallOption) *AzureClientIterator
	DeleteAzureClient(context.Context, *gkemulticloudpb.DeleteAzureClientRequest, ...gax.CallOption) (*DeleteAzureClientOperation, error)
	DeleteAzureClientOperation(name string) *DeleteAzureClientOperation
	CreateAzureCluster(context.Context, *gkemulticloudpb.CreateAzureClusterRequest, ...gax.CallOption) (*CreateAzureClusterOperation, error)
	CreateAzureClusterOperation(name string) *CreateAzureClusterOperation
	UpdateAzureCluster(context.Context, *gkemulticloudpb.UpdateAzureClusterRequest, ...gax.CallOption) (*UpdateAzureClusterOperation, error)
	UpdateAzureClusterOperation(name string) *UpdateAzureClusterOperation
	GetAzureCluster(context.Context, *gkemulticloudpb.GetAzureClusterRequest, ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error)
	ListAzureClusters(context.Context, *gkemulticloudpb.ListAzureClustersRequest, ...gax.CallOption) *AzureClusterIterator
	DeleteAzureCluster(context.Context, *gkemulticloudpb.DeleteAzureClusterRequest, ...gax.CallOption) (*DeleteAzureClusterOperation, error)
	DeleteAzureClusterOperation(name string) *DeleteAzureClusterOperation
	GenerateAzureAccessToken(context.Context, *gkemulticloudpb.GenerateAzureAccessTokenRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAzureAccessTokenResponse, error)
	CreateAzureNodePool(context.Context, *gkemulticloudpb.CreateAzureNodePoolRequest, ...gax.CallOption) (*CreateAzureNodePoolOperation, error)
	CreateAzureNodePoolOperation(name string) *CreateAzureNodePoolOperation
	UpdateAzureNodePool(context.Context, *gkemulticloudpb.UpdateAzureNodePoolRequest, ...gax.CallOption) (*UpdateAzureNodePoolOperation, error)
	UpdateAzureNodePoolOperation(name string) *UpdateAzureNodePoolOperation
	GetAzureNodePool(context.Context, *gkemulticloudpb.GetAzureNodePoolRequest, ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error)
	ListAzureNodePools(context.Context, *gkemulticloudpb.ListAzureNodePoolsRequest, ...gax.CallOption) *AzureNodePoolIterator
	DeleteAzureNodePool(context.Context, *gkemulticloudpb.DeleteAzureNodePoolRequest, ...gax.CallOption) (*DeleteAzureNodePoolOperation, error)
	DeleteAzureNodePoolOperation(name string) *DeleteAzureNodePoolOperation
	GetAzureServerConfig(context.Context, *gkemulticloudpb.GetAzureServerConfigRequest, ...gax.CallOption) (*gkemulticloudpb.AzureServerConfig, error)
}

// AzureClustersClient is a client for interacting with Anthos Multi-Cloud API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The AzureClusters API provides a single centrally managed service
// to create and manage Anthos clusters that run on Azure infrastructure.
type AzureClustersClient struct {
	// The internal transport-dependent client.
	internalClient internalAzureClustersClient

	// The call options for this service.
	CallOptions *AzureClustersCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AzureClustersClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AzureClustersClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *AzureClustersClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateAzureClient creates a new AzureClient resource on a given Google Cloud project
// and region.
//
// AzureClient resources hold client authentication
// information needed by the Anthos Multicloud API to manage Azure resources
// on your Azure subscription on your behalf.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) CreateAzureClient(ctx context.Context, req *gkemulticloudpb.CreateAzureClientRequest, opts ...gax.CallOption) (*CreateAzureClientOperation, error) {
	return c.internalClient.CreateAzureClient(ctx, req, opts...)
}

// CreateAzureClientOperation returns a new CreateAzureClientOperation from a given name.
// The name must be that of a previously created CreateAzureClientOperation, possibly from a different process.
func (c *AzureClustersClient) CreateAzureClientOperation(name string) *CreateAzureClientOperation {
	return c.internalClient.CreateAzureClientOperation(name)
}

// GetAzureClient describes a specific AzureClient resource.
func (c *AzureClustersClient) GetAzureClient(ctx context.Context, req *gkemulticloudpb.GetAzureClientRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureClient, error) {
	return c.internalClient.GetAzureClient(ctx, req, opts...)
}

// ListAzureClients lists all AzureClient resources on a given Google Cloud project and
// region.
func (c *AzureClustersClient) ListAzureClients(ctx context.Context, req *gkemulticloudpb.ListAzureClientsRequest, opts ...gax.CallOption) *AzureClientIterator {
	return c.internalClient.ListAzureClients(ctx, req, opts...)
}

// DeleteAzureClient deletes a specific AzureClient resource.
//
// If the client is used by one or more clusters, deletion will
// fail and a FAILED_PRECONDITION error will be returned.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) DeleteAzureClient(ctx context.Context, req *gkemulticloudpb.DeleteAzureClientRequest, opts ...gax.CallOption) (*DeleteAzureClientOperation, error) {
	return c.internalClient.DeleteAzureClient(ctx, req, opts...)
}

// DeleteAzureClientOperation returns a new DeleteAzureClientOperation from a given name.
// The name must be that of a previously created DeleteAzureClientOperation, possibly from a different process.
func (c *AzureClustersClient) DeleteAzureClientOperation(name string) *DeleteAzureClientOperation {
	return c.internalClient.DeleteAzureClientOperation(name)
}

// CreateAzureCluster creates a new AzureCluster resource on a given GCP project and region.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) CreateAzureCluster(ctx context.Context, req *gkemulticloudpb.CreateAzureClusterRequest, opts ...gax.CallOption) (*CreateAzureClusterOperation, error) {
	return c.internalClient.CreateAzureCluster(ctx, req, opts...)
}

// CreateAzureClusterOperation returns a new CreateAzureClusterOperation from a given name.
// The name must be that of a previously created CreateAzureClusterOperation, possibly from a different process.
func (c *AzureClustersClient) CreateAzureClusterOperation(name string) *CreateAzureClusterOperation {
	return c.internalClient.CreateAzureClusterOperation(name)
}

// UpdateAzureCluster updates an AzureCluster.
func (c *AzureClustersClient) UpdateAzureCluster(ctx context.Context, req *gkemulticloudpb.UpdateAzureClusterRequest, opts ...gax.CallOption) (*UpdateAzureClusterOperation, error) {
	return c.internalClient.UpdateAzureCluster(ctx, req, opts...)
}

// UpdateAzureClusterOperation returns a new UpdateAzureClusterOperation from a given name.
// The name must be that of a previously created UpdateAzureClusterOperation, possibly from a different process.
func (c *AzureClustersClient) UpdateAzureClusterOperation(name string) *UpdateAzureClusterOperation {
	return c.internalClient.UpdateAzureClusterOperation(name)
}

// GetAzureCluster describes a specific AzureCluster resource.
func (c *AzureClustersClient) GetAzureCluster(ctx context.Context, req *gkemulticloudpb.GetAzureClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	return c.internalClient.GetAzureCluster(ctx, req, opts...)
}

// ListAzureClusters lists all AzureCluster resources on a given Google Cloud project and
// region.
func (c *AzureClustersClient) ListAzureClusters(ctx context.Context, req *gkemulticloudpb.ListAzureClustersRequest, opts ...gax.CallOption) *AzureClusterIterator {
	return c.internalClient.ListAzureClusters(ctx, req, opts...)
}

// DeleteAzureCluster deletes a specific AzureCluster resource.
//
// Fails if the cluster has one or more associated AzureNodePool
// resources.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) DeleteAzureCluster(ctx context.Context, req *gkemulticloudpb.DeleteAzureClusterRequest, opts ...gax.CallOption) (*DeleteAzureClusterOperation, error) {
	return c.internalClient.DeleteAzureCluster(ctx, req, opts...)
}

// DeleteAzureClusterOperation returns a new DeleteAzureClusterOperation from a given name.
// The name must be that of a previously created DeleteAzureClusterOperation, possibly from a different process.
func (c *AzureClustersClient) DeleteAzureClusterOperation(name string) *DeleteAzureClusterOperation {
	return c.internalClient.DeleteAzureClusterOperation(name)
}

// GenerateAzureAccessToken generates a short-lived access token to authenticate to a given
// AzureCluster resource.
func (c *AzureClustersClient) GenerateAzureAccessToken(ctx context.Context, req *gkemulticloudpb.GenerateAzureAccessTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAzureAccessTokenResponse, error) {
	return c.internalClient.GenerateAzureAccessToken(ctx, req, opts...)
}

// CreateAzureNodePool creates a new AzureNodePool, attached to a given AzureCluster.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) CreateAzureNodePool(ctx context.Context, req *gkemulticloudpb.CreateAzureNodePoolRequest, opts ...gax.CallOption) (*CreateAzureNodePoolOperation, error) {
	return c.internalClient.CreateAzureNodePool(ctx, req, opts...)
}

// CreateAzureNodePoolOperation returns a new CreateAzureNodePoolOperation from a given name.
// The name must be that of a previously created CreateAzureNodePoolOperation, possibly from a different process.
func (c *AzureClustersClient) CreateAzureNodePoolOperation(name string) *CreateAzureNodePoolOperation {
	return c.internalClient.CreateAzureNodePoolOperation(name)
}

// UpdateAzureNodePool updates an AzureNodePool.
func (c *AzureClustersClient) UpdateAzureNodePool(ctx context.Context, req *gkemulticloudpb.UpdateAzureNodePoolRequest, opts ...gax.CallOption) (*UpdateAzureNodePoolOperation, error) {
	return c.internalClient.UpdateAzureNodePool(ctx, req, opts...)
}

// UpdateAzureNodePoolOperation returns a new UpdateAzureNodePoolOperation from a given name.
// The name must be that of a previously created UpdateAzureNodePoolOperation, possibly from a different process.
func (c *AzureClustersClient) UpdateAzureNodePoolOperation(name string) *UpdateAzureNodePoolOperation {
	return c.internalClient.UpdateAzureNodePoolOperation(name)
}

// GetAzureNodePool describes a specific AzureNodePool resource.
func (c *AzureClustersClient) GetAzureNodePool(ctx context.Context, req *gkemulticloudpb.GetAzureNodePoolRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	return c.internalClient.GetAzureNodePool(ctx, req, opts...)
}

// ListAzureNodePools lists all AzureNodePool resources on a given AzureCluster.
func (c *AzureClustersClient) ListAzureNodePools(ctx context.Context, req *gkemulticloudpb.ListAzureNodePoolsRequest, opts ...gax.CallOption) *AzureNodePoolIterator {
	return c.internalClient.ListAzureNodePools(ctx, req, opts...)
}

// DeleteAzureNodePool deletes a specific AzureNodePool resource.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AzureClustersClient) DeleteAzureNodePool(ctx context.Context, req *gkemulticloudpb.DeleteAzureNodePoolRequest, opts ...gax.CallOption) (*DeleteAzureNodePoolOperation, error) {
	return c.internalClient.DeleteAzureNodePool(ctx, req, opts...)
}

// DeleteAzureNodePoolOperation returns a new DeleteAzureNodePoolOperation from a given name.
// The name must be that of a previously created DeleteAzureNodePoolOperation, possibly from a different process.
func (c *AzureClustersClient) DeleteAzureNodePoolOperation(name string) *DeleteAzureNodePoolOperation {
	return c.internalClient.DeleteAzureNodePoolOperation(name)
}

// GetAzureServerConfig returns information, such as supported Azure regions and Kubernetes
// versions, on a given Google Cloud location.
func (c *AzureClustersClient) GetAzureServerConfig(ctx context.Context, req *gkemulticloudpb.GetAzureServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureServerConfig, error) {
	return c.internalClient.GetAzureServerConfig(ctx, req, opts...)
}

// azureClustersGRPCClient is a client for interacting with Anthos Multi-Cloud API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type azureClustersGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing AzureClustersClient
	CallOptions **AzureClustersCallOptions

	// The gRPC API client.
	azureClustersClient gkemulticloudpb.AzureClustersClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewAzureClustersClient creates a new azure clusters client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The AzureClusters API provides a single centrally managed service
// to create and manage Anthos clusters that run on Azure infrastructure.
func NewAzureClustersClient(ctx context.Context, opts ...option.ClientOption) (*AzureClustersClient, error) {
	clientOpts := defaultAzureClustersGRPCClientOptions()
	if newAzureClustersClientHook != nil {
		hookOpts, err := newAzureClustersClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AzureClustersClient{CallOptions: defaultAzureClustersCallOptions()}

	c := &azureClustersGRPCClient{
		connPool:            connPool,
		disableDeadlines:    disableDeadlines,
		azureClustersClient: gkemulticloudpb.NewAzureClustersClient(connPool),
		CallOptions:         &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *azureClustersGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *azureClustersGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *azureClustersGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *azureClustersGRPCClient) CreateAzureClient(ctx context.Context, req *gkemulticloudpb.CreateAzureClientRequest, opts ...gax.CallOption) (*CreateAzureClientOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAzureClient[0:len((*c.CallOptions).CreateAzureClient):len((*c.CallOptions).CreateAzureClient)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.CreateAzureClient(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureClient(ctx context.Context, req *gkemulticloudpb.GetAzureClientRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureClient, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAzureClient[0:len((*c.CallOptions).GetAzureClient):len((*c.CallOptions).GetAzureClient)], opts...)
	var resp *gkemulticloudpb.AzureClient
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.GetAzureClient(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListAzureClients(ctx context.Context, req *gkemulticloudpb.ListAzureClientsRequest, opts ...gax.CallOption) *AzureClientIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAzureClients[0:len((*c.CallOptions).ListAzureClients):len((*c.CallOptions).ListAzureClients)], opts...)
	it := &AzureClientIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAzureClientsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AzureClient, string, error) {
		resp := &gkemulticloudpb.ListAzureClientsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.azureClustersClient.ListAzureClients(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAzureClients(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *azureClustersGRPCClient) DeleteAzureClient(ctx context.Context, req *gkemulticloudpb.DeleteAzureClientRequest, opts ...gax.CallOption) (*DeleteAzureClientOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAzureClient[0:len((*c.CallOptions).DeleteAzureClient):len((*c.CallOptions).DeleteAzureClient)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.DeleteAzureClient(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) CreateAzureCluster(ctx context.Context, req *gkemulticloudpb.CreateAzureClusterRequest, opts ...gax.CallOption) (*CreateAzureClusterOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAzureCluster[0:len((*c.CallOptions).CreateAzureCluster):len((*c.CallOptions).CreateAzureCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.CreateAzureCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) UpdateAzureCluster(ctx context.Context, req *gkemulticloudpb.UpdateAzureClusterRequest, opts ...gax.CallOption) (*UpdateAzureClusterOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster.name", url.QueryEscape(req.GetAzureCluster().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAzureCluster[0:len((*c.CallOptions).UpdateAzureCluster):len((*c.CallOptions).UpdateAzureCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.UpdateAzureCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureCluster(ctx context.Context, req *gkemulticloudpb.GetAzureClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAzureCluster[0:len((*c.CallOptions).GetAzureCluster):len((*c.CallOptions).GetAzureCluster)], opts...)
	var resp *gkemulticloudpb.AzureCluster
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.GetAzureCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListAzureClusters(ctx context.Context, req *gkemulticloudpb.ListAzureClustersRequest, opts ...gax.CallOption) *AzureClusterIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAzureClusters[0:len((*c.CallOptions).ListAzureClusters):len((*c.CallOptions).ListAzureClusters)], opts...)
	it := &AzureClusterIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAzureClustersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AzureCluster, string, error) {
		resp := &gkemulticloudpb.ListAzureClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.azureClustersClient.ListAzureClusters(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAzureClusters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *azureClustersGRPCClient) DeleteAzureCluster(ctx context.Context, req *gkemulticloudpb.DeleteAzureClusterRequest, opts ...gax.CallOption) (*DeleteAzureClusterOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAzureCluster[0:len((*c.CallOptions).DeleteAzureCluster):len((*c.CallOptions).DeleteAzureCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.DeleteAzureCluster(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GenerateAzureAccessToken(ctx context.Context, req *gkemulticloudpb.GenerateAzureAccessTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAzureAccessTokenResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "azure_cluster", url.QueryEscape(req.GetAzureCluster())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GenerateAzureAccessToken[0:len((*c.CallOptions).GenerateAzureAccessToken):len((*c.CallOptions).GenerateAzureAccessToken)], opts...)
	var resp *gkemulticloudpb.GenerateAzureAccessTokenResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.GenerateAzureAccessToken(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) CreateAzureNodePool(ctx context.Context, req *gkemulticloudpb.CreateAzureNodePoolRequest, opts ...gax.CallOption) (*CreateAzureNodePoolOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAzureNodePool[0:len((*c.CallOptions).CreateAzureNodePool):len((*c.CallOptions).CreateAzureNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.CreateAzureNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) UpdateAzureNodePool(ctx context.Context, req *gkemulticloudpb.UpdateAzureNodePoolRequest, opts ...gax.CallOption) (*UpdateAzureNodePoolOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "azure_node_pool.name", url.QueryEscape(req.GetAzureNodePool().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAzureNodePool[0:len((*c.CallOptions).UpdateAzureNodePool):len((*c.CallOptions).UpdateAzureNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.UpdateAzureNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureNodePool(ctx context.Context, req *gkemulticloudpb.GetAzureNodePoolRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAzureNodePool[0:len((*c.CallOptions).GetAzureNodePool):len((*c.CallOptions).GetAzureNodePool)], opts...)
	var resp *gkemulticloudpb.AzureNodePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.GetAzureNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *azureClustersGRPCClient) ListAzureNodePools(ctx context.Context, req *gkemulticloudpb.ListAzureNodePoolsRequest, opts ...gax.CallOption) *AzureNodePoolIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAzureNodePools[0:len((*c.CallOptions).ListAzureNodePools):len((*c.CallOptions).ListAzureNodePools)], opts...)
	it := &AzureNodePoolIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAzureNodePoolsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AzureNodePool, string, error) {
		resp := &gkemulticloudpb.ListAzureNodePoolsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.azureClustersClient.ListAzureNodePools(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAzureNodePools(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *azureClustersGRPCClient) DeleteAzureNodePool(ctx context.Context, req *gkemulticloudpb.DeleteAzureNodePoolRequest, opts ...gax.CallOption) (*DeleteAzureNodePoolOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAzureNodePool[0:len((*c.CallOptions).DeleteAzureNodePool):len((*c.CallOptions).DeleteAzureNodePool)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.DeleteAzureNodePool(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *azureClustersGRPCClient) GetAzureServerConfig(ctx context.Context, req *gkemulticloudpb.GetAzureServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AzureServerConfig, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAzureServerConfig[0:len((*c.CallOptions).GetAzureServerConfig):len((*c.CallOptions).GetAzureServerConfig)], opts...)
	var resp *gkemulticloudpb.AzureServerConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.azureClustersClient.GetAzureServerConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateAzureClientOperation manages a long-running operation from CreateAzureClient.
type CreateAzureClientOperation struct {
	lro *longrunning.Operation
}

// CreateAzureClientOperation returns a new CreateAzureClientOperation from a given name.
// The name must be that of a previously created CreateAzureClientOperation, possibly from a different process.
func (c *azureClustersGRPCClient) CreateAzureClientOperation(name string) *CreateAzureClientOperation {
	return &CreateAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAzureClientOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureClient, error) {
	var resp gkemulticloudpb.AzureClient
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAzureClientOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureClient, error) {
	var resp gkemulticloudpb.AzureClient
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAzureClientOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAzureClientOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAzureClientOperation) Name() string {
	return op.lro.Name()
}

// CreateAzureClusterOperation manages a long-running operation from CreateAzureCluster.
type CreateAzureClusterOperation struct {
	lro *longrunning.Operation
}

// CreateAzureClusterOperation returns a new CreateAzureClusterOperation from a given name.
// The name must be that of a previously created CreateAzureClusterOperation, possibly from a different process.
func (c *azureClustersGRPCClient) CreateAzureClusterOperation(name string) *CreateAzureClusterOperation {
	return &CreateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAzureClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	var resp gkemulticloudpb.AzureCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAzureClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	var resp gkemulticloudpb.AzureCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAzureClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAzureClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAzureClusterOperation) Name() string {
	return op.lro.Name()
}

// CreateAzureNodePoolOperation manages a long-running operation from CreateAzureNodePool.
type CreateAzureNodePoolOperation struct {
	lro *longrunning.Operation
}

// CreateAzureNodePoolOperation returns a new CreateAzureNodePoolOperation from a given name.
// The name must be that of a previously created CreateAzureNodePoolOperation, possibly from a different process.
func (c *azureClustersGRPCClient) CreateAzureNodePoolOperation(name string) *CreateAzureNodePoolOperation {
	return &CreateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAzureNodePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	var resp gkemulticloudpb.AzureNodePool
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAzureNodePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	var resp gkemulticloudpb.AzureNodePool
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAzureNodePoolOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAzureNodePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAzureNodePoolOperation) Name() string {
	return op.lro.Name()
}

// DeleteAzureClientOperation manages a long-running operation from DeleteAzureClient.
type DeleteAzureClientOperation struct {
	lro *longrunning.Operation
}

// DeleteAzureClientOperation returns a new DeleteAzureClientOperation from a given name.
// The name must be that of a previously created DeleteAzureClientOperation, possibly from a different process.
func (c *azureClustersGRPCClient) DeleteAzureClientOperation(name string) *DeleteAzureClientOperation {
	return &DeleteAzureClientOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAzureClientOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAzureClientOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAzureClientOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAzureClientOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAzureClientOperation) Name() string {
	return op.lro.Name()
}

// DeleteAzureClusterOperation manages a long-running operation from DeleteAzureCluster.
type DeleteAzureClusterOperation struct {
	lro *longrunning.Operation
}

// DeleteAzureClusterOperation returns a new DeleteAzureClusterOperation from a given name.
// The name must be that of a previously created DeleteAzureClusterOperation, possibly from a different process.
func (c *azureClustersGRPCClient) DeleteAzureClusterOperation(name string) *DeleteAzureClusterOperation {
	return &DeleteAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAzureClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAzureClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAzureClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAzureClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAzureClusterOperation) Name() string {
	return op.lro.Name()
}

// DeleteAzureNodePoolOperation manages a long-running operation from DeleteAzureNodePool.
type DeleteAzureNodePoolOperation struct {
	lro *longrunning.Operation
}

// DeleteAzureNodePoolOperation returns a new DeleteAzureNodePoolOperation from a given name.
// The name must be that of a previously created DeleteAzureNodePoolOperation, possibly from a different process.
func (c *azureClustersGRPCClient) DeleteAzureNodePoolOperation(name string) *DeleteAzureNodePoolOperation {
	return &DeleteAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAzureNodePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAzureNodePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAzureNodePoolOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAzureNodePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAzureNodePoolOperation) Name() string {
	return op.lro.Name()
}

// UpdateAzureClusterOperation manages a long-running operation from UpdateAzureCluster.
type UpdateAzureClusterOperation struct {
	lro *longrunning.Operation
}

// UpdateAzureClusterOperation returns a new UpdateAzureClusterOperation from a given name.
// The name must be that of a previously created UpdateAzureClusterOperation, possibly from a different process.
func (c *azureClustersGRPCClient) UpdateAzureClusterOperation(name string) *UpdateAzureClusterOperation {
	return &UpdateAzureClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAzureClusterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	var resp gkemulticloudpb.AzureCluster
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAzureClusterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureCluster, error) {
	var resp gkemulticloudpb.AzureCluster
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAzureClusterOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAzureClusterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAzureClusterOperation) Name() string {
	return op.lro.Name()
}

// UpdateAzureNodePoolOperation manages a long-running operation from UpdateAzureNodePool.
type UpdateAzureNodePoolOperation struct {
	lro *longrunning.Operation
}

// UpdateAzureNodePoolOperation returns a new UpdateAzureNodePoolOperation from a given name.
// The name must be that of a previously created UpdateAzureNodePoolOperation, possibly from a different process.
func (c *azureClustersGRPCClient) UpdateAzureNodePoolOperation(name string) *UpdateAzureNodePoolOperation {
	return &UpdateAzureNodePoolOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAzureNodePoolOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	var resp gkemulticloudpb.AzureNodePool
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAzureNodePoolOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*gkemulticloudpb.AzureNodePool, error) {
	var resp gkemulticloudpb.AzureNodePool
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAzureNodePoolOperation) Metadata() (*gkemulticloudpb.OperationMetadata, error) {
	var meta gkemulticloudpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAzureNodePoolOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAzureNodePoolOperation) Name() string {
	return op.lro.Name()
}

// AzureClientIterator manages a stream of *gkemulticloudpb.AzureClient.
type AzureClientIterator struct {
	items    []*gkemulticloudpb.AzureClient
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*gkemulticloudpb.AzureClient, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AzureClientIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AzureClientIterator) Next() (*gkemulticloudpb.AzureClient, error) {
	var item *gkemulticloudpb.AzureClient
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AzureClientIterator) bufLen() int {
	return len(it.items)
}

func (it *AzureClientIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AzureClusterIterator manages a stream of *gkemulticloudpb.AzureCluster.
type AzureClusterIterator struct {
	items    []*gkemulticloudpb.AzureCluster
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*gkemulticloudpb.AzureCluster, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AzureClusterIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AzureClusterIterator) Next() (*gkemulticloudpb.AzureCluster, error) {
	var item *gkemulticloudpb.AzureCluster
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AzureClusterIterator) bufLen() int {
	return len(it.items)
}

func (it *AzureClusterIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AzureNodePoolIterator manages a stream of *gkemulticloudpb.AzureNodePool.
type AzureNodePoolIterator struct {
	items    []*gkemulticloudpb.AzureNodePool
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*gkemulticloudpb.AzureNodePool, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AzureNodePoolIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AzureNodePoolIterator) Next() (*gkemulticloudpb.AzureNodePool, error) {
	var item *gkemulticloudpb.AzureNodePool
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AzureNodePoolIterator) bufLen() int {
	return len(it.items)
}

func (it *AzureNodePoolIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
