// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package deploy

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	deploypb "google.golang.org/genproto/googleapis/cloud/deploy/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newCloudDeployClientHook clientHook

// CloudDeployCallOptions contains the retry settings for each method of CloudDeployClient.
type CloudDeployCallOptions struct {
	ListDeliveryPipelines  []gax.CallOption
	GetDeliveryPipeline    []gax.CallOption
	CreateDeliveryPipeline []gax.CallOption
	UpdateDeliveryPipeline []gax.CallOption
	DeleteDeliveryPipeline []gax.CallOption
	ListTargets            []gax.CallOption
	GetTarget              []gax.CallOption
	CreateTarget           []gax.CallOption
	UpdateTarget           []gax.CallOption
	DeleteTarget           []gax.CallOption
	ListReleases           []gax.CallOption
	GetRelease             []gax.CallOption
	CreateRelease          []gax.CallOption
	ApproveRollout         []gax.CallOption
	ListRollouts           []gax.CallOption
	GetRollout             []gax.CallOption
	CreateRollout          []gax.CallOption
	GetConfig              []gax.CallOption
}

func defaultCloudDeployGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("clouddeploy.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("clouddeploy.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://clouddeploy.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCloudDeployCallOptions() *CloudDeployCallOptions {
	return &CloudDeployCallOptions{
		ListDeliveryPipelines: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetDeliveryPipeline: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateDeliveryPipeline: []gax.CallOption{},
		UpdateDeliveryPipeline: []gax.CallOption{},
		DeleteDeliveryPipeline: []gax.CallOption{},
		ListTargets: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetTarget: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateTarget: []gax.CallOption{},
		UpdateTarget: []gax.CallOption{},
		DeleteTarget: []gax.CallOption{},
		ListReleases: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetRelease: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateRelease:  []gax.CallOption{},
		ApproveRollout: []gax.CallOption{},
		ListRollouts: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetRollout: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateRollout: []gax.CallOption{},
		GetConfig: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// internalCloudDeployClient is an interface that defines the methods availaible from Google Cloud Deploy API.
type internalCloudDeployClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListDeliveryPipelines(context.Context, *deploypb.ListDeliveryPipelinesRequest, ...gax.CallOption) *DeliveryPipelineIterator
	GetDeliveryPipeline(context.Context, *deploypb.GetDeliveryPipelineRequest, ...gax.CallOption) (*deploypb.DeliveryPipeline, error)
	CreateDeliveryPipeline(context.Context, *deploypb.CreateDeliveryPipelineRequest, ...gax.CallOption) (*CreateDeliveryPipelineOperation, error)
	CreateDeliveryPipelineOperation(name string) *CreateDeliveryPipelineOperation
	UpdateDeliveryPipeline(context.Context, *deploypb.UpdateDeliveryPipelineRequest, ...gax.CallOption) (*UpdateDeliveryPipelineOperation, error)
	UpdateDeliveryPipelineOperation(name string) *UpdateDeliveryPipelineOperation
	DeleteDeliveryPipeline(context.Context, *deploypb.DeleteDeliveryPipelineRequest, ...gax.CallOption) (*DeleteDeliveryPipelineOperation, error)
	DeleteDeliveryPipelineOperation(name string) *DeleteDeliveryPipelineOperation
	ListTargets(context.Context, *deploypb.ListTargetsRequest, ...gax.CallOption) *TargetIterator
	GetTarget(context.Context, *deploypb.GetTargetRequest, ...gax.CallOption) (*deploypb.Target, error)
	CreateTarget(context.Context, *deploypb.CreateTargetRequest, ...gax.CallOption) (*CreateTargetOperation, error)
	CreateTargetOperation(name string) *CreateTargetOperation
	UpdateTarget(context.Context, *deploypb.UpdateTargetRequest, ...gax.CallOption) (*UpdateTargetOperation, error)
	UpdateTargetOperation(name string) *UpdateTargetOperation
	DeleteTarget(context.Context, *deploypb.DeleteTargetRequest, ...gax.CallOption) (*DeleteTargetOperation, error)
	DeleteTargetOperation(name string) *DeleteTargetOperation
	ListReleases(context.Context, *deploypb.ListReleasesRequest, ...gax.CallOption) *ReleaseIterator
	GetRelease(context.Context, *deploypb.GetReleaseRequest, ...gax.CallOption) (*deploypb.Release, error)
	CreateRelease(context.Context, *deploypb.CreateReleaseRequest, ...gax.CallOption) (*CreateReleaseOperation, error)
	CreateReleaseOperation(name string) *CreateReleaseOperation
	ApproveRollout(context.Context, *deploypb.ApproveRolloutRequest, ...gax.CallOption) (*deploypb.ApproveRolloutResponse, error)
	ListRollouts(context.Context, *deploypb.ListRolloutsRequest, ...gax.CallOption) *RolloutIterator
	GetRollout(context.Context, *deploypb.GetRolloutRequest, ...gax.CallOption) (*deploypb.Rollout, error)
	CreateRollout(context.Context, *deploypb.CreateRolloutRequest, ...gax.CallOption) (*CreateRolloutOperation, error)
	CreateRolloutOperation(name string) *CreateRolloutOperation
	GetConfig(context.Context, *deploypb.GetConfigRequest, ...gax.CallOption) (*deploypb.Config, error)
}

// CloudDeployClient is a client for interacting with Google Cloud Deploy API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// CloudDeploy service creates and manages Continuous Delivery operations
// on Google Cloud Platform via Skaffold (https://skaffold.dev (at https://skaffold.dev)).
type CloudDeployClient struct {
	// The internal transport-dependent client.
	internalClient internalCloudDeployClient

	// The call options for this service.
	CallOptions *CloudDeployCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *CloudDeployClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *CloudDeployClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *CloudDeployClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListDeliveryPipelines lists DeliveryPipelines in a given project and location.
func (c *CloudDeployClient) ListDeliveryPipelines(ctx context.Context, req *deploypb.ListDeliveryPipelinesRequest, opts ...gax.CallOption) *DeliveryPipelineIterator {
	return c.internalClient.ListDeliveryPipelines(ctx, req, opts...)
}

// GetDeliveryPipeline gets details of a single DeliveryPipeline.
func (c *CloudDeployClient) GetDeliveryPipeline(ctx context.Context, req *deploypb.GetDeliveryPipelineRequest, opts ...gax.CallOption) (*deploypb.DeliveryPipeline, error) {
	return c.internalClient.GetDeliveryPipeline(ctx, req, opts...)
}

// CreateDeliveryPipeline creates a new DeliveryPipeline in a given project and location.
func (c *CloudDeployClient) CreateDeliveryPipeline(ctx context.Context, req *deploypb.CreateDeliveryPipelineRequest, opts ...gax.CallOption) (*CreateDeliveryPipelineOperation, error) {
	return c.internalClient.CreateDeliveryPipeline(ctx, req, opts...)
}

// CreateDeliveryPipelineOperation returns a new CreateDeliveryPipelineOperation from a given name.
// The name must be that of a previously created CreateDeliveryPipelineOperation, possibly from a different process.
func (c *CloudDeployClient) CreateDeliveryPipelineOperation(name string) *CreateDeliveryPipelineOperation {
	return c.internalClient.CreateDeliveryPipelineOperation(name)
}

// UpdateDeliveryPipeline updates the parameters of a single DeliveryPipeline.
func (c *CloudDeployClient) UpdateDeliveryPipeline(ctx context.Context, req *deploypb.UpdateDeliveryPipelineRequest, opts ...gax.CallOption) (*UpdateDeliveryPipelineOperation, error) {
	return c.internalClient.UpdateDeliveryPipeline(ctx, req, opts...)
}

// UpdateDeliveryPipelineOperation returns a new UpdateDeliveryPipelineOperation from a given name.
// The name must be that of a previously created UpdateDeliveryPipelineOperation, possibly from a different process.
func (c *CloudDeployClient) UpdateDeliveryPipelineOperation(name string) *UpdateDeliveryPipelineOperation {
	return c.internalClient.UpdateDeliveryPipelineOperation(name)
}

// DeleteDeliveryPipeline deletes a single DeliveryPipeline.
func (c *CloudDeployClient) DeleteDeliveryPipeline(ctx context.Context, req *deploypb.DeleteDeliveryPipelineRequest, opts ...gax.CallOption) (*DeleteDeliveryPipelineOperation, error) {
	return c.internalClient.DeleteDeliveryPipeline(ctx, req, opts...)
}

// DeleteDeliveryPipelineOperation returns a new DeleteDeliveryPipelineOperation from a given name.
// The name must be that of a previously created DeleteDeliveryPipelineOperation, possibly from a different process.
func (c *CloudDeployClient) DeleteDeliveryPipelineOperation(name string) *DeleteDeliveryPipelineOperation {
	return c.internalClient.DeleteDeliveryPipelineOperation(name)
}

// ListTargets lists Targets in a given project and location.
func (c *CloudDeployClient) ListTargets(ctx context.Context, req *deploypb.ListTargetsRequest, opts ...gax.CallOption) *TargetIterator {
	return c.internalClient.ListTargets(ctx, req, opts...)
}

// GetTarget gets details of a single Target.
func (c *CloudDeployClient) GetTarget(ctx context.Context, req *deploypb.GetTargetRequest, opts ...gax.CallOption) (*deploypb.Target, error) {
	return c.internalClient.GetTarget(ctx, req, opts...)
}

// CreateTarget creates a new Target in a given project and location.
func (c *CloudDeployClient) CreateTarget(ctx context.Context, req *deploypb.CreateTargetRequest, opts ...gax.CallOption) (*CreateTargetOperation, error) {
	return c.internalClient.CreateTarget(ctx, req, opts...)
}

// CreateTargetOperation returns a new CreateTargetOperation from a given name.
// The name must be that of a previously created CreateTargetOperation, possibly from a different process.
func (c *CloudDeployClient) CreateTargetOperation(name string) *CreateTargetOperation {
	return c.internalClient.CreateTargetOperation(name)
}

// UpdateTarget updates the parameters of a single Target.
func (c *CloudDeployClient) UpdateTarget(ctx context.Context, req *deploypb.UpdateTargetRequest, opts ...gax.CallOption) (*UpdateTargetOperation, error) {
	return c.internalClient.UpdateTarget(ctx, req, opts...)
}

// UpdateTargetOperation returns a new UpdateTargetOperation from a given name.
// The name must be that of a previously created UpdateTargetOperation, possibly from a different process.
func (c *CloudDeployClient) UpdateTargetOperation(name string) *UpdateTargetOperation {
	return c.internalClient.UpdateTargetOperation(name)
}

// DeleteTarget deletes a single Target.
func (c *CloudDeployClient) DeleteTarget(ctx context.Context, req *deploypb.DeleteTargetRequest, opts ...gax.CallOption) (*DeleteTargetOperation, error) {
	return c.internalClient.DeleteTarget(ctx, req, opts...)
}

// DeleteTargetOperation returns a new DeleteTargetOperation from a given name.
// The name must be that of a previously created DeleteTargetOperation, possibly from a different process.
func (c *CloudDeployClient) DeleteTargetOperation(name string) *DeleteTargetOperation {
	return c.internalClient.DeleteTargetOperation(name)
}

// ListReleases lists Releases in a given project and location.
func (c *CloudDeployClient) ListReleases(ctx context.Context, req *deploypb.ListReleasesRequest, opts ...gax.CallOption) *ReleaseIterator {
	return c.internalClient.ListReleases(ctx, req, opts...)
}

// GetRelease gets details of a single Release.
func (c *CloudDeployClient) GetRelease(ctx context.Context, req *deploypb.GetReleaseRequest, opts ...gax.CallOption) (*deploypb.Release, error) {
	return c.internalClient.GetRelease(ctx, req, opts...)
}

// CreateRelease creates a new Release in a given project and location.
func (c *CloudDeployClient) CreateRelease(ctx context.Context, req *deploypb.CreateReleaseRequest, opts ...gax.CallOption) (*CreateReleaseOperation, error) {
	return c.internalClient.CreateRelease(ctx, req, opts...)
}

// CreateReleaseOperation returns a new CreateReleaseOperation from a given name.
// The name must be that of a previously created CreateReleaseOperation, possibly from a different process.
func (c *CloudDeployClient) CreateReleaseOperation(name string) *CreateReleaseOperation {
	return c.internalClient.CreateReleaseOperation(name)
}

// ApproveRollout approves a Rollout.
func (c *CloudDeployClient) ApproveRollout(ctx context.Context, req *deploypb.ApproveRolloutRequest, opts ...gax.CallOption) (*deploypb.ApproveRolloutResponse, error) {
	return c.internalClient.ApproveRollout(ctx, req, opts...)
}

// ListRollouts lists Rollouts in a given project and location.
func (c *CloudDeployClient) ListRollouts(ctx context.Context, req *deploypb.ListRolloutsRequest, opts ...gax.CallOption) *RolloutIterator {
	return c.internalClient.ListRollouts(ctx, req, opts...)
}

// GetRollout gets details of a single Rollout.
func (c *CloudDeployClient) GetRollout(ctx context.Context, req *deploypb.GetRolloutRequest, opts ...gax.CallOption) (*deploypb.Rollout, error) {
	return c.internalClient.GetRollout(ctx, req, opts...)
}

// CreateRollout creates a new Rollout in a given project and location.
func (c *CloudDeployClient) CreateRollout(ctx context.Context, req *deploypb.CreateRolloutRequest, opts ...gax.CallOption) (*CreateRolloutOperation, error) {
	return c.internalClient.CreateRollout(ctx, req, opts...)
}

// CreateRolloutOperation returns a new CreateRolloutOperation from a given name.
// The name must be that of a previously created CreateRolloutOperation, possibly from a different process.
func (c *CloudDeployClient) CreateRolloutOperation(name string) *CreateRolloutOperation {
	return c.internalClient.CreateRolloutOperation(name)
}

// GetConfig gets the configuration for a location.
func (c *CloudDeployClient) GetConfig(ctx context.Context, req *deploypb.GetConfigRequest, opts ...gax.CallOption) (*deploypb.Config, error) {
	return c.internalClient.GetConfig(ctx, req, opts...)
}

// cloudDeployGRPCClient is a client for interacting with Google Cloud Deploy API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type cloudDeployGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing CloudDeployClient
	CallOptions **CloudDeployCallOptions

	// The gRPC API client.
	cloudDeployClient deploypb.CloudDeployClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewCloudDeployClient creates a new cloud deploy client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// CloudDeploy service creates and manages Continuous Delivery operations
// on Google Cloud Platform via Skaffold (https://skaffold.dev (at https://skaffold.dev)).
func NewCloudDeployClient(ctx context.Context, opts ...option.ClientOption) (*CloudDeployClient, error) {
	clientOpts := defaultCloudDeployGRPCClientOptions()
	if newCloudDeployClientHook != nil {
		hookOpts, err := newCloudDeployClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := CloudDeployClient{CallOptions: defaultCloudDeployCallOptions()}

	c := &cloudDeployGRPCClient{
		connPool:          connPool,
		disableDeadlines:  disableDeadlines,
		cloudDeployClient: deploypb.NewCloudDeployClient(connPool),
		CallOptions:       &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *cloudDeployGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *cloudDeployGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", versionClient, "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *cloudDeployGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *cloudDeployGRPCClient) ListDeliveryPipelines(ctx context.Context, req *deploypb.ListDeliveryPipelinesRequest, opts ...gax.CallOption) *DeliveryPipelineIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListDeliveryPipelines[0:len((*c.CallOptions).ListDeliveryPipelines):len((*c.CallOptions).ListDeliveryPipelines)], opts...)
	it := &DeliveryPipelineIterator{}
	req = proto.Clone(req).(*deploypb.ListDeliveryPipelinesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deploypb.DeliveryPipeline, string, error) {
		resp := &deploypb.ListDeliveryPipelinesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudDeployClient.ListDeliveryPipelines(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDeliveryPipelines(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudDeployGRPCClient) GetDeliveryPipeline(ctx context.Context, req *deploypb.GetDeliveryPipelineRequest, opts ...gax.CallOption) (*deploypb.DeliveryPipeline, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetDeliveryPipeline[0:len((*c.CallOptions).GetDeliveryPipeline):len((*c.CallOptions).GetDeliveryPipeline)], opts...)
	var resp *deploypb.DeliveryPipeline
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.GetDeliveryPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudDeployGRPCClient) CreateDeliveryPipeline(ctx context.Context, req *deploypb.CreateDeliveryPipelineRequest, opts ...gax.CallOption) (*CreateDeliveryPipelineOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateDeliveryPipeline[0:len((*c.CallOptions).CreateDeliveryPipeline):len((*c.CallOptions).CreateDeliveryPipeline)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.CreateDeliveryPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDeliveryPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) UpdateDeliveryPipeline(ctx context.Context, req *deploypb.UpdateDeliveryPipelineRequest, opts ...gax.CallOption) (*UpdateDeliveryPipelineOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "delivery_pipeline.name", url.QueryEscape(req.GetDeliveryPipeline().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateDeliveryPipeline[0:len((*c.CallOptions).UpdateDeliveryPipeline):len((*c.CallOptions).UpdateDeliveryPipeline)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.UpdateDeliveryPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateDeliveryPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) DeleteDeliveryPipeline(ctx context.Context, req *deploypb.DeleteDeliveryPipelineRequest, opts ...gax.CallOption) (*DeleteDeliveryPipelineOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteDeliveryPipeline[0:len((*c.CallOptions).DeleteDeliveryPipeline):len((*c.CallOptions).DeleteDeliveryPipeline)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.DeleteDeliveryPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDeliveryPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) ListTargets(ctx context.Context, req *deploypb.ListTargetsRequest, opts ...gax.CallOption) *TargetIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListTargets[0:len((*c.CallOptions).ListTargets):len((*c.CallOptions).ListTargets)], opts...)
	it := &TargetIterator{}
	req = proto.Clone(req).(*deploypb.ListTargetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deploypb.Target, string, error) {
		resp := &deploypb.ListTargetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudDeployClient.ListTargets(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTargets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudDeployGRPCClient) GetTarget(ctx context.Context, req *deploypb.GetTargetRequest, opts ...gax.CallOption) (*deploypb.Target, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetTarget[0:len((*c.CallOptions).GetTarget):len((*c.CallOptions).GetTarget)], opts...)
	var resp *deploypb.Target
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.GetTarget(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudDeployGRPCClient) CreateTarget(ctx context.Context, req *deploypb.CreateTargetRequest, opts ...gax.CallOption) (*CreateTargetOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateTarget[0:len((*c.CallOptions).CreateTarget):len((*c.CallOptions).CreateTarget)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.CreateTarget(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateTargetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) UpdateTarget(ctx context.Context, req *deploypb.UpdateTargetRequest, opts ...gax.CallOption) (*UpdateTargetOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "target.name", url.QueryEscape(req.GetTarget().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateTarget[0:len((*c.CallOptions).UpdateTarget):len((*c.CallOptions).UpdateTarget)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.UpdateTarget(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateTargetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) DeleteTarget(ctx context.Context, req *deploypb.DeleteTargetRequest, opts ...gax.CallOption) (*DeleteTargetOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteTarget[0:len((*c.CallOptions).DeleteTarget):len((*c.CallOptions).DeleteTarget)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.DeleteTarget(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTargetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) ListReleases(ctx context.Context, req *deploypb.ListReleasesRequest, opts ...gax.CallOption) *ReleaseIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListReleases[0:len((*c.CallOptions).ListReleases):len((*c.CallOptions).ListReleases)], opts...)
	it := &ReleaseIterator{}
	req = proto.Clone(req).(*deploypb.ListReleasesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deploypb.Release, string, error) {
		resp := &deploypb.ListReleasesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudDeployClient.ListReleases(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReleases(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudDeployGRPCClient) GetRelease(ctx context.Context, req *deploypb.GetReleaseRequest, opts ...gax.CallOption) (*deploypb.Release, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetRelease[0:len((*c.CallOptions).GetRelease):len((*c.CallOptions).GetRelease)], opts...)
	var resp *deploypb.Release
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.GetRelease(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudDeployGRPCClient) CreateRelease(ctx context.Context, req *deploypb.CreateReleaseRequest, opts ...gax.CallOption) (*CreateReleaseOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateRelease[0:len((*c.CallOptions).CreateRelease):len((*c.CallOptions).CreateRelease)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.CreateRelease(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateReleaseOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) ApproveRollout(ctx context.Context, req *deploypb.ApproveRolloutRequest, opts ...gax.CallOption) (*deploypb.ApproveRolloutResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ApproveRollout[0:len((*c.CallOptions).ApproveRollout):len((*c.CallOptions).ApproveRollout)], opts...)
	var resp *deploypb.ApproveRolloutResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.ApproveRollout(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudDeployGRPCClient) ListRollouts(ctx context.Context, req *deploypb.ListRolloutsRequest, opts ...gax.CallOption) *RolloutIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListRollouts[0:len((*c.CallOptions).ListRollouts):len((*c.CallOptions).ListRollouts)], opts...)
	it := &RolloutIterator{}
	req = proto.Clone(req).(*deploypb.ListRolloutsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deploypb.Rollout, string, error) {
		resp := &deploypb.ListRolloutsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudDeployClient.ListRollouts(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetRollouts(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudDeployGRPCClient) GetRollout(ctx context.Context, req *deploypb.GetRolloutRequest, opts ...gax.CallOption) (*deploypb.Rollout, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetRollout[0:len((*c.CallOptions).GetRollout):len((*c.CallOptions).GetRollout)], opts...)
	var resp *deploypb.Rollout
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.GetRollout(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudDeployGRPCClient) CreateRollout(ctx context.Context, req *deploypb.CreateRolloutRequest, opts ...gax.CallOption) (*CreateRolloutOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateRollout[0:len((*c.CallOptions).CreateRollout):len((*c.CallOptions).CreateRollout)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.CreateRollout(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateRolloutOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *cloudDeployGRPCClient) GetConfig(ctx context.Context, req *deploypb.GetConfigRequest, opts ...gax.CallOption) (*deploypb.Config, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetConfig[0:len((*c.CallOptions).GetConfig):len((*c.CallOptions).GetConfig)], opts...)
	var resp *deploypb.Config
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudDeployClient.GetConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateDeliveryPipelineOperation manages a long-running operation from CreateDeliveryPipeline.
type CreateDeliveryPipelineOperation struct {
	lro *longrunning.Operation
}

// CreateDeliveryPipelineOperation returns a new CreateDeliveryPipelineOperation from a given name.
// The name must be that of a previously created CreateDeliveryPipelineOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) CreateDeliveryPipelineOperation(name string) *CreateDeliveryPipelineOperation {
	return &CreateDeliveryPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateDeliveryPipelineOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*deploypb.DeliveryPipeline, error) {
	var resp deploypb.DeliveryPipeline
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateDeliveryPipelineOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*deploypb.DeliveryPipeline, error) {
	var resp deploypb.DeliveryPipeline
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateDeliveryPipelineOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateDeliveryPipelineOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateDeliveryPipelineOperation) Name() string {
	return op.lro.Name()
}

// CreateReleaseOperation manages a long-running operation from CreateRelease.
type CreateReleaseOperation struct {
	lro *longrunning.Operation
}

// CreateReleaseOperation returns a new CreateReleaseOperation from a given name.
// The name must be that of a previously created CreateReleaseOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) CreateReleaseOperation(name string) *CreateReleaseOperation {
	return &CreateReleaseOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateReleaseOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*deploypb.Release, error) {
	var resp deploypb.Release
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateReleaseOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*deploypb.Release, error) {
	var resp deploypb.Release
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateReleaseOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateReleaseOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateReleaseOperation) Name() string {
	return op.lro.Name()
}

// CreateRolloutOperation manages a long-running operation from CreateRollout.
type CreateRolloutOperation struct {
	lro *longrunning.Operation
}

// CreateRolloutOperation returns a new CreateRolloutOperation from a given name.
// The name must be that of a previously created CreateRolloutOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) CreateRolloutOperation(name string) *CreateRolloutOperation {
	return &CreateRolloutOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateRolloutOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*deploypb.Rollout, error) {
	var resp deploypb.Rollout
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateRolloutOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*deploypb.Rollout, error) {
	var resp deploypb.Rollout
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateRolloutOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateRolloutOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateRolloutOperation) Name() string {
	return op.lro.Name()
}

// CreateTargetOperation manages a long-running operation from CreateTarget.
type CreateTargetOperation struct {
	lro *longrunning.Operation
}

// CreateTargetOperation returns a new CreateTargetOperation from a given name.
// The name must be that of a previously created CreateTargetOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) CreateTargetOperation(name string) *CreateTargetOperation {
	return &CreateTargetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateTargetOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*deploypb.Target, error) {
	var resp deploypb.Target
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateTargetOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*deploypb.Target, error) {
	var resp deploypb.Target
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateTargetOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateTargetOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateTargetOperation) Name() string {
	return op.lro.Name()
}

// DeleteDeliveryPipelineOperation manages a long-running operation from DeleteDeliveryPipeline.
type DeleteDeliveryPipelineOperation struct {
	lro *longrunning.Operation
}

// DeleteDeliveryPipelineOperation returns a new DeleteDeliveryPipelineOperation from a given name.
// The name must be that of a previously created DeleteDeliveryPipelineOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) DeleteDeliveryPipelineOperation(name string) *DeleteDeliveryPipelineOperation {
	return &DeleteDeliveryPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteDeliveryPipelineOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteDeliveryPipelineOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteDeliveryPipelineOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteDeliveryPipelineOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteDeliveryPipelineOperation) Name() string {
	return op.lro.Name()
}

// DeleteTargetOperation manages a long-running operation from DeleteTarget.
type DeleteTargetOperation struct {
	lro *longrunning.Operation
}

// DeleteTargetOperation returns a new DeleteTargetOperation from a given name.
// The name must be that of a previously created DeleteTargetOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) DeleteTargetOperation(name string) *DeleteTargetOperation {
	return &DeleteTargetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteTargetOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteTargetOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteTargetOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteTargetOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteTargetOperation) Name() string {
	return op.lro.Name()
}

// UpdateDeliveryPipelineOperation manages a long-running operation from UpdateDeliveryPipeline.
type UpdateDeliveryPipelineOperation struct {
	lro *longrunning.Operation
}

// UpdateDeliveryPipelineOperation returns a new UpdateDeliveryPipelineOperation from a given name.
// The name must be that of a previously created UpdateDeliveryPipelineOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) UpdateDeliveryPipelineOperation(name string) *UpdateDeliveryPipelineOperation {
	return &UpdateDeliveryPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateDeliveryPipelineOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*deploypb.DeliveryPipeline, error) {
	var resp deploypb.DeliveryPipeline
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateDeliveryPipelineOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*deploypb.DeliveryPipeline, error) {
	var resp deploypb.DeliveryPipeline
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateDeliveryPipelineOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateDeliveryPipelineOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateDeliveryPipelineOperation) Name() string {
	return op.lro.Name()
}

// UpdateTargetOperation manages a long-running operation from UpdateTarget.
type UpdateTargetOperation struct {
	lro *longrunning.Operation
}

// UpdateTargetOperation returns a new UpdateTargetOperation from a given name.
// The name must be that of a previously created UpdateTargetOperation, possibly from a different process.
func (c *cloudDeployGRPCClient) UpdateTargetOperation(name string) *UpdateTargetOperation {
	return &UpdateTargetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateTargetOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*deploypb.Target, error) {
	var resp deploypb.Target
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateTargetOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*deploypb.Target, error) {
	var resp deploypb.Target
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateTargetOperation) Metadata() (*deploypb.OperationMetadata, error) {
	var meta deploypb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateTargetOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateTargetOperation) Name() string {
	return op.lro.Name()
}

// DeliveryPipelineIterator manages a stream of *deploypb.DeliveryPipeline.
type DeliveryPipelineIterator struct {
	items    []*deploypb.DeliveryPipeline
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*deploypb.DeliveryPipeline, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *DeliveryPipelineIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *DeliveryPipelineIterator) Next() (*deploypb.DeliveryPipeline, error) {
	var item *deploypb.DeliveryPipeline
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *DeliveryPipelineIterator) bufLen() int {
	return len(it.items)
}

func (it *DeliveryPipelineIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ReleaseIterator manages a stream of *deploypb.Release.
type ReleaseIterator struct {
	items    []*deploypb.Release
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*deploypb.Release, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ReleaseIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ReleaseIterator) Next() (*deploypb.Release, error) {
	var item *deploypb.Release
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ReleaseIterator) bufLen() int {
	return len(it.items)
}

func (it *ReleaseIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// RolloutIterator manages a stream of *deploypb.Rollout.
type RolloutIterator struct {
	items    []*deploypb.Rollout
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*deploypb.Rollout, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *RolloutIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *RolloutIterator) Next() (*deploypb.Rollout, error) {
	var item *deploypb.Rollout
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *RolloutIterator) bufLen() int {
	return len(it.items)
}

func (it *RolloutIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TargetIterator manages a stream of *deploypb.Target.
type TargetIterator struct {
	items    []*deploypb.Target
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*deploypb.Target, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TargetIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TargetIterator) Next() (*deploypb.Target, error) {
	var item *deploypb.Target
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TargetIterator) bufLen() int {
	return len(it.items)
}

func (it *TargetIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
