// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package dataflow_test

import (
	"context"

	dataflow "cloud.google.com/go/dataflow/apiv1beta3"
	"google.golang.org/api/iterator"
	dataflowpb "google.golang.org/genproto/googleapis/dataflow/v1beta3"
)

func ExampleNewJobsV1Beta3Client() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleJobsV1Beta3Client_CreateJob() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.CreateJobRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#CreateJobRequest.
	}
	resp, err := c.CreateJob(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleJobsV1Beta3Client_GetJob() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.GetJobRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#GetJobRequest.
	}
	resp, err := c.GetJob(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleJobsV1Beta3Client_UpdateJob() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.UpdateJobRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#UpdateJobRequest.
	}
	resp, err := c.UpdateJob(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleJobsV1Beta3Client_ListJobs() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.ListJobsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#ListJobsRequest.
	}
	it := c.ListJobs(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleJobsV1Beta3Client_AggregatedListJobs() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.ListJobsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#ListJobsRequest.
	}
	it := c.AggregatedListJobs(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleJobsV1Beta3Client_CheckActiveJobs() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.CheckActiveJobsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#CheckActiveJobsRequest.
	}
	resp, err := c.CheckActiveJobs(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleJobsV1Beta3Client_SnapshotJob() {
	ctx := context.Background()
	c, err := dataflow.NewJobsV1Beta3Client(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &dataflowpb.SnapshotJobRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/dataflow/v1beta3#SnapshotJobRequest.
	}
	resp, err := c.SnapshotJob(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}
