// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package aiplatform

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	aiplatformpb "google.golang.org/genproto/googleapis/cloud/aiplatform/v1beta1"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	iampb "google.golang.org/genproto/googleapis/iam/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newTensorboardClientHook clientHook

// TensorboardCallOptions contains the retry settings for each method of TensorboardClient.
type TensorboardCallOptions struct {
	CreateTensorboard                  []gax.CallOption
	GetTensorboard                     []gax.CallOption
	UpdateTensorboard                  []gax.CallOption
	ListTensorboards                   []gax.CallOption
	DeleteTensorboard                  []gax.CallOption
	CreateTensorboardExperiment        []gax.CallOption
	GetTensorboardExperiment           []gax.CallOption
	UpdateTensorboardExperiment        []gax.CallOption
	ListTensorboardExperiments         []gax.CallOption
	DeleteTensorboardExperiment        []gax.CallOption
	CreateTensorboardRun               []gax.CallOption
	BatchCreateTensorboardRuns         []gax.CallOption
	GetTensorboardRun                  []gax.CallOption
	UpdateTensorboardRun               []gax.CallOption
	ListTensorboardRuns                []gax.CallOption
	DeleteTensorboardRun               []gax.CallOption
	BatchCreateTensorboardTimeSeries   []gax.CallOption
	CreateTensorboardTimeSeries        []gax.CallOption
	GetTensorboardTimeSeries           []gax.CallOption
	UpdateTensorboardTimeSeries        []gax.CallOption
	ListTensorboardTimeSeries          []gax.CallOption
	DeleteTensorboardTimeSeries        []gax.CallOption
	BatchReadTensorboardTimeSeriesData []gax.CallOption
	ReadTensorboardTimeSeriesData      []gax.CallOption
	ReadTensorboardBlobData            []gax.CallOption
	WriteTensorboardExperimentData     []gax.CallOption
	WriteTensorboardRunData            []gax.CallOption
	ExportTensorboardTimeSeriesData    []gax.CallOption
	GetLocation                        []gax.CallOption
	ListLocations                      []gax.CallOption
	GetIamPolicy                       []gax.CallOption
	SetIamPolicy                       []gax.CallOption
	TestIamPermissions                 []gax.CallOption
	CancelOperation                    []gax.CallOption
	DeleteOperation                    []gax.CallOption
	GetOperation                       []gax.CallOption
	ListOperations                     []gax.CallOption
	WaitOperation                      []gax.CallOption
}

func defaultTensorboardGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("aiplatform.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("aiplatform.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://aiplatform.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultTensorboardCallOptions() *TensorboardCallOptions {
	return &TensorboardCallOptions{
		CreateTensorboard:                  []gax.CallOption{},
		GetTensorboard:                     []gax.CallOption{},
		UpdateTensorboard:                  []gax.CallOption{},
		ListTensorboards:                   []gax.CallOption{},
		DeleteTensorboard:                  []gax.CallOption{},
		CreateTensorboardExperiment:        []gax.CallOption{},
		GetTensorboardExperiment:           []gax.CallOption{},
		UpdateTensorboardExperiment:        []gax.CallOption{},
		ListTensorboardExperiments:         []gax.CallOption{},
		DeleteTensorboardExperiment:        []gax.CallOption{},
		CreateTensorboardRun:               []gax.CallOption{},
		BatchCreateTensorboardRuns:         []gax.CallOption{},
		GetTensorboardRun:                  []gax.CallOption{},
		UpdateTensorboardRun:               []gax.CallOption{},
		ListTensorboardRuns:                []gax.CallOption{},
		DeleteTensorboardRun:               []gax.CallOption{},
		BatchCreateTensorboardTimeSeries:   []gax.CallOption{},
		CreateTensorboardTimeSeries:        []gax.CallOption{},
		GetTensorboardTimeSeries:           []gax.CallOption{},
		UpdateTensorboardTimeSeries:        []gax.CallOption{},
		ListTensorboardTimeSeries:          []gax.CallOption{},
		DeleteTensorboardTimeSeries:        []gax.CallOption{},
		BatchReadTensorboardTimeSeriesData: []gax.CallOption{},
		ReadTensorboardTimeSeriesData:      []gax.CallOption{},
		ReadTensorboardBlobData:            []gax.CallOption{},
		WriteTensorboardExperimentData:     []gax.CallOption{},
		WriteTensorboardRunData:            []gax.CallOption{},
		ExportTensorboardTimeSeriesData:    []gax.CallOption{},
		GetLocation:                        []gax.CallOption{},
		ListLocations:                      []gax.CallOption{},
		GetIamPolicy:                       []gax.CallOption{},
		SetIamPolicy:                       []gax.CallOption{},
		TestIamPermissions:                 []gax.CallOption{},
		CancelOperation:                    []gax.CallOption{},
		DeleteOperation:                    []gax.CallOption{},
		GetOperation:                       []gax.CallOption{},
		ListOperations:                     []gax.CallOption{},
		WaitOperation:                      []gax.CallOption{},
	}
}

// internalTensorboardClient is an interface that defines the methods available from Vertex AI API.
type internalTensorboardClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateTensorboard(context.Context, *aiplatformpb.CreateTensorboardRequest, ...gax.CallOption) (*CreateTensorboardOperation, error)
	CreateTensorboardOperation(name string) *CreateTensorboardOperation
	GetTensorboard(context.Context, *aiplatformpb.GetTensorboardRequest, ...gax.CallOption) (*aiplatformpb.Tensorboard, error)
	UpdateTensorboard(context.Context, *aiplatformpb.UpdateTensorboardRequest, ...gax.CallOption) (*UpdateTensorboardOperation, error)
	UpdateTensorboardOperation(name string) *UpdateTensorboardOperation
	ListTensorboards(context.Context, *aiplatformpb.ListTensorboardsRequest, ...gax.CallOption) *TensorboardIterator
	DeleteTensorboard(context.Context, *aiplatformpb.DeleteTensorboardRequest, ...gax.CallOption) (*DeleteTensorboardOperation, error)
	DeleteTensorboardOperation(name string) *DeleteTensorboardOperation
	CreateTensorboardExperiment(context.Context, *aiplatformpb.CreateTensorboardExperimentRequest, ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error)
	GetTensorboardExperiment(context.Context, *aiplatformpb.GetTensorboardExperimentRequest, ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error)
	UpdateTensorboardExperiment(context.Context, *aiplatformpb.UpdateTensorboardExperimentRequest, ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error)
	ListTensorboardExperiments(context.Context, *aiplatformpb.ListTensorboardExperimentsRequest, ...gax.CallOption) *TensorboardExperimentIterator
	DeleteTensorboardExperiment(context.Context, *aiplatformpb.DeleteTensorboardExperimentRequest, ...gax.CallOption) (*DeleteTensorboardExperimentOperation, error)
	DeleteTensorboardExperimentOperation(name string) *DeleteTensorboardExperimentOperation
	CreateTensorboardRun(context.Context, *aiplatformpb.CreateTensorboardRunRequest, ...gax.CallOption) (*aiplatformpb.TensorboardRun, error)
	BatchCreateTensorboardRuns(context.Context, *aiplatformpb.BatchCreateTensorboardRunsRequest, ...gax.CallOption) (*aiplatformpb.BatchCreateTensorboardRunsResponse, error)
	GetTensorboardRun(context.Context, *aiplatformpb.GetTensorboardRunRequest, ...gax.CallOption) (*aiplatformpb.TensorboardRun, error)
	UpdateTensorboardRun(context.Context, *aiplatformpb.UpdateTensorboardRunRequest, ...gax.CallOption) (*aiplatformpb.TensorboardRun, error)
	ListTensorboardRuns(context.Context, *aiplatformpb.ListTensorboardRunsRequest, ...gax.CallOption) *TensorboardRunIterator
	DeleteTensorboardRun(context.Context, *aiplatformpb.DeleteTensorboardRunRequest, ...gax.CallOption) (*DeleteTensorboardRunOperation, error)
	DeleteTensorboardRunOperation(name string) *DeleteTensorboardRunOperation
	BatchCreateTensorboardTimeSeries(context.Context, *aiplatformpb.BatchCreateTensorboardTimeSeriesRequest, ...gax.CallOption) (*aiplatformpb.BatchCreateTensorboardTimeSeriesResponse, error)
	CreateTensorboardTimeSeries(context.Context, *aiplatformpb.CreateTensorboardTimeSeriesRequest, ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error)
	GetTensorboardTimeSeries(context.Context, *aiplatformpb.GetTensorboardTimeSeriesRequest, ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error)
	UpdateTensorboardTimeSeries(context.Context, *aiplatformpb.UpdateTensorboardTimeSeriesRequest, ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error)
	ListTensorboardTimeSeries(context.Context, *aiplatformpb.ListTensorboardTimeSeriesRequest, ...gax.CallOption) *TensorboardTimeSeriesIterator
	DeleteTensorboardTimeSeries(context.Context, *aiplatformpb.DeleteTensorboardTimeSeriesRequest, ...gax.CallOption) (*DeleteTensorboardTimeSeriesOperation, error)
	DeleteTensorboardTimeSeriesOperation(name string) *DeleteTensorboardTimeSeriesOperation
	BatchReadTensorboardTimeSeriesData(context.Context, *aiplatformpb.BatchReadTensorboardTimeSeriesDataRequest, ...gax.CallOption) (*aiplatformpb.BatchReadTensorboardTimeSeriesDataResponse, error)
	ReadTensorboardTimeSeriesData(context.Context, *aiplatformpb.ReadTensorboardTimeSeriesDataRequest, ...gax.CallOption) (*aiplatformpb.ReadTensorboardTimeSeriesDataResponse, error)
	ReadTensorboardBlobData(context.Context, *aiplatformpb.ReadTensorboardBlobDataRequest, ...gax.CallOption) (aiplatformpb.TensorboardService_ReadTensorboardBlobDataClient, error)
	WriteTensorboardExperimentData(context.Context, *aiplatformpb.WriteTensorboardExperimentDataRequest, ...gax.CallOption) (*aiplatformpb.WriteTensorboardExperimentDataResponse, error)
	WriteTensorboardRunData(context.Context, *aiplatformpb.WriteTensorboardRunDataRequest, ...gax.CallOption) (*aiplatformpb.WriteTensorboardRunDataResponse, error)
	ExportTensorboardTimeSeriesData(context.Context, *aiplatformpb.ExportTensorboardTimeSeriesDataRequest, ...gax.CallOption) *TimeSeriesDataPointIterator
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
	WaitOperation(context.Context, *longrunningpb.WaitOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// TensorboardClient is a client for interacting with Vertex AI API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// TensorboardService
type TensorboardClient struct {
	// The internal transport-dependent client.
	internalClient internalTensorboardClient

	// The call options for this service.
	CallOptions *TensorboardCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *TensorboardClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *TensorboardClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *TensorboardClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateTensorboard creates a Tensorboard.
func (c *TensorboardClient) CreateTensorboard(ctx context.Context, req *aiplatformpb.CreateTensorboardRequest, opts ...gax.CallOption) (*CreateTensorboardOperation, error) {
	return c.internalClient.CreateTensorboard(ctx, req, opts...)
}

// CreateTensorboardOperation returns a new CreateTensorboardOperation from a given name.
// The name must be that of a previously created CreateTensorboardOperation, possibly from a different process.
func (c *TensorboardClient) CreateTensorboardOperation(name string) *CreateTensorboardOperation {
	return c.internalClient.CreateTensorboardOperation(name)
}

// GetTensorboard gets a Tensorboard.
func (c *TensorboardClient) GetTensorboard(ctx context.Context, req *aiplatformpb.GetTensorboardRequest, opts ...gax.CallOption) (*aiplatformpb.Tensorboard, error) {
	return c.internalClient.GetTensorboard(ctx, req, opts...)
}

// UpdateTensorboard updates a Tensorboard.
func (c *TensorboardClient) UpdateTensorboard(ctx context.Context, req *aiplatformpb.UpdateTensorboardRequest, opts ...gax.CallOption) (*UpdateTensorboardOperation, error) {
	return c.internalClient.UpdateTensorboard(ctx, req, opts...)
}

// UpdateTensorboardOperation returns a new UpdateTensorboardOperation from a given name.
// The name must be that of a previously created UpdateTensorboardOperation, possibly from a different process.
func (c *TensorboardClient) UpdateTensorboardOperation(name string) *UpdateTensorboardOperation {
	return c.internalClient.UpdateTensorboardOperation(name)
}

// ListTensorboards lists Tensorboards in a Location.
func (c *TensorboardClient) ListTensorboards(ctx context.Context, req *aiplatformpb.ListTensorboardsRequest, opts ...gax.CallOption) *TensorboardIterator {
	return c.internalClient.ListTensorboards(ctx, req, opts...)
}

// DeleteTensorboard deletes a Tensorboard.
func (c *TensorboardClient) DeleteTensorboard(ctx context.Context, req *aiplatformpb.DeleteTensorboardRequest, opts ...gax.CallOption) (*DeleteTensorboardOperation, error) {
	return c.internalClient.DeleteTensorboard(ctx, req, opts...)
}

// DeleteTensorboardOperation returns a new DeleteTensorboardOperation from a given name.
// The name must be that of a previously created DeleteTensorboardOperation, possibly from a different process.
func (c *TensorboardClient) DeleteTensorboardOperation(name string) *DeleteTensorboardOperation {
	return c.internalClient.DeleteTensorboardOperation(name)
}

// CreateTensorboardExperiment creates a TensorboardExperiment.
func (c *TensorboardClient) CreateTensorboardExperiment(ctx context.Context, req *aiplatformpb.CreateTensorboardExperimentRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error) {
	return c.internalClient.CreateTensorboardExperiment(ctx, req, opts...)
}

// GetTensorboardExperiment gets a TensorboardExperiment.
func (c *TensorboardClient) GetTensorboardExperiment(ctx context.Context, req *aiplatformpb.GetTensorboardExperimentRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error) {
	return c.internalClient.GetTensorboardExperiment(ctx, req, opts...)
}

// UpdateTensorboardExperiment updates a TensorboardExperiment.
func (c *TensorboardClient) UpdateTensorboardExperiment(ctx context.Context, req *aiplatformpb.UpdateTensorboardExperimentRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error) {
	return c.internalClient.UpdateTensorboardExperiment(ctx, req, opts...)
}

// ListTensorboardExperiments lists TensorboardExperiments in a Location.
func (c *TensorboardClient) ListTensorboardExperiments(ctx context.Context, req *aiplatformpb.ListTensorboardExperimentsRequest, opts ...gax.CallOption) *TensorboardExperimentIterator {
	return c.internalClient.ListTensorboardExperiments(ctx, req, opts...)
}

// DeleteTensorboardExperiment deletes a TensorboardExperiment.
func (c *TensorboardClient) DeleteTensorboardExperiment(ctx context.Context, req *aiplatformpb.DeleteTensorboardExperimentRequest, opts ...gax.CallOption) (*DeleteTensorboardExperimentOperation, error) {
	return c.internalClient.DeleteTensorboardExperiment(ctx, req, opts...)
}

// DeleteTensorboardExperimentOperation returns a new DeleteTensorboardExperimentOperation from a given name.
// The name must be that of a previously created DeleteTensorboardExperimentOperation, possibly from a different process.
func (c *TensorboardClient) DeleteTensorboardExperimentOperation(name string) *DeleteTensorboardExperimentOperation {
	return c.internalClient.DeleteTensorboardExperimentOperation(name)
}

// CreateTensorboardRun creates a TensorboardRun.
func (c *TensorboardClient) CreateTensorboardRun(ctx context.Context, req *aiplatformpb.CreateTensorboardRunRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardRun, error) {
	return c.internalClient.CreateTensorboardRun(ctx, req, opts...)
}

// BatchCreateTensorboardRuns batch create TensorboardRuns.
func (c *TensorboardClient) BatchCreateTensorboardRuns(ctx context.Context, req *aiplatformpb.BatchCreateTensorboardRunsRequest, opts ...gax.CallOption) (*aiplatformpb.BatchCreateTensorboardRunsResponse, error) {
	return c.internalClient.BatchCreateTensorboardRuns(ctx, req, opts...)
}

// GetTensorboardRun gets a TensorboardRun.
func (c *TensorboardClient) GetTensorboardRun(ctx context.Context, req *aiplatformpb.GetTensorboardRunRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardRun, error) {
	return c.internalClient.GetTensorboardRun(ctx, req, opts...)
}

// UpdateTensorboardRun updates a TensorboardRun.
func (c *TensorboardClient) UpdateTensorboardRun(ctx context.Context, req *aiplatformpb.UpdateTensorboardRunRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardRun, error) {
	return c.internalClient.UpdateTensorboardRun(ctx, req, opts...)
}

// ListTensorboardRuns lists TensorboardRuns in a Location.
func (c *TensorboardClient) ListTensorboardRuns(ctx context.Context, req *aiplatformpb.ListTensorboardRunsRequest, opts ...gax.CallOption) *TensorboardRunIterator {
	return c.internalClient.ListTensorboardRuns(ctx, req, opts...)
}

// DeleteTensorboardRun deletes a TensorboardRun.
func (c *TensorboardClient) DeleteTensorboardRun(ctx context.Context, req *aiplatformpb.DeleteTensorboardRunRequest, opts ...gax.CallOption) (*DeleteTensorboardRunOperation, error) {
	return c.internalClient.DeleteTensorboardRun(ctx, req, opts...)
}

// DeleteTensorboardRunOperation returns a new DeleteTensorboardRunOperation from a given name.
// The name must be that of a previously created DeleteTensorboardRunOperation, possibly from a different process.
func (c *TensorboardClient) DeleteTensorboardRunOperation(name string) *DeleteTensorboardRunOperation {
	return c.internalClient.DeleteTensorboardRunOperation(name)
}

// BatchCreateTensorboardTimeSeries batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
func (c *TensorboardClient) BatchCreateTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.BatchCreateTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.BatchCreateTensorboardTimeSeriesResponse, error) {
	return c.internalClient.BatchCreateTensorboardTimeSeries(ctx, req, opts...)
}

// CreateTensorboardTimeSeries creates a TensorboardTimeSeries.
func (c *TensorboardClient) CreateTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.CreateTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error) {
	return c.internalClient.CreateTensorboardTimeSeries(ctx, req, opts...)
}

// GetTensorboardTimeSeries gets a TensorboardTimeSeries.
func (c *TensorboardClient) GetTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.GetTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error) {
	return c.internalClient.GetTensorboardTimeSeries(ctx, req, opts...)
}

// UpdateTensorboardTimeSeries updates a TensorboardTimeSeries.
func (c *TensorboardClient) UpdateTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.UpdateTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error) {
	return c.internalClient.UpdateTensorboardTimeSeries(ctx, req, opts...)
}

// ListTensorboardTimeSeries lists TensorboardTimeSeries in a Location.
func (c *TensorboardClient) ListTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.ListTensorboardTimeSeriesRequest, opts ...gax.CallOption) *TensorboardTimeSeriesIterator {
	return c.internalClient.ListTensorboardTimeSeries(ctx, req, opts...)
}

// DeleteTensorboardTimeSeries deletes a TensorboardTimeSeries.
func (c *TensorboardClient) DeleteTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.DeleteTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*DeleteTensorboardTimeSeriesOperation, error) {
	return c.internalClient.DeleteTensorboardTimeSeries(ctx, req, opts...)
}

// DeleteTensorboardTimeSeriesOperation returns a new DeleteTensorboardTimeSeriesOperation from a given name.
// The name must be that of a previously created DeleteTensorboardTimeSeriesOperation, possibly from a different process.
func (c *TensorboardClient) DeleteTensorboardTimeSeriesOperation(name string) *DeleteTensorboardTimeSeriesOperation {
	return c.internalClient.DeleteTensorboardTimeSeriesOperation(name)
}

// BatchReadTensorboardTimeSeriesData reads multiple TensorboardTimeSeries’ data. The data point number limit is
// 1000 for scalars, 100 for tensors and blob references. If the number of
// data points stored is less than the limit, all data will be returned.
// Otherwise, that limit number of data points will be randomly selected from
// this time series and returned.
func (c *TensorboardClient) BatchReadTensorboardTimeSeriesData(ctx context.Context, req *aiplatformpb.BatchReadTensorboardTimeSeriesDataRequest, opts ...gax.CallOption) (*aiplatformpb.BatchReadTensorboardTimeSeriesDataResponse, error) {
	return c.internalClient.BatchReadTensorboardTimeSeriesData(ctx, req, opts...)
}

// ReadTensorboardTimeSeriesData reads a TensorboardTimeSeries’ data. By default, if the number of data
// points stored is less than 1000, all data will be returned. Otherwise, 1000
// data points will be randomly selected from this time series and returned.
// This value can be changed by changing max_data_points, which can’t be
// greater than 10k.
func (c *TensorboardClient) ReadTensorboardTimeSeriesData(ctx context.Context, req *aiplatformpb.ReadTensorboardTimeSeriesDataRequest, opts ...gax.CallOption) (*aiplatformpb.ReadTensorboardTimeSeriesDataResponse, error) {
	return c.internalClient.ReadTensorboardTimeSeriesData(ctx, req, opts...)
}

// ReadTensorboardBlobData gets bytes of TensorboardBlobs.
// This is to allow reading blob data stored in consumer project’s Cloud
// Storage bucket without users having to obtain Cloud Storage access
// permission.
func (c *TensorboardClient) ReadTensorboardBlobData(ctx context.Context, req *aiplatformpb.ReadTensorboardBlobDataRequest, opts ...gax.CallOption) (aiplatformpb.TensorboardService_ReadTensorboardBlobDataClient, error) {
	return c.internalClient.ReadTensorboardBlobData(ctx, req, opts...)
}

// WriteTensorboardExperimentData write time series data points of multiple TensorboardTimeSeries in multiple
// TensorboardRun’s. If any data fail to be ingested, an error will be
// returned.
func (c *TensorboardClient) WriteTensorboardExperimentData(ctx context.Context, req *aiplatformpb.WriteTensorboardExperimentDataRequest, opts ...gax.CallOption) (*aiplatformpb.WriteTensorboardExperimentDataResponse, error) {
	return c.internalClient.WriteTensorboardExperimentData(ctx, req, opts...)
}

// WriteTensorboardRunData write time series data points into multiple TensorboardTimeSeries under
// a TensorboardRun. If any data fail to be ingested, an error will be
// returned.
func (c *TensorboardClient) WriteTensorboardRunData(ctx context.Context, req *aiplatformpb.WriteTensorboardRunDataRequest, opts ...gax.CallOption) (*aiplatformpb.WriteTensorboardRunDataResponse, error) {
	return c.internalClient.WriteTensorboardRunData(ctx, req, opts...)
}

// ExportTensorboardTimeSeriesData exports a TensorboardTimeSeries’ data. Data is returned in paginated
// responses.
func (c *TensorboardClient) ExportTensorboardTimeSeriesData(ctx context.Context, req *aiplatformpb.ExportTensorboardTimeSeriesDataRequest, opts ...gax.CallOption) *TimeSeriesDataPointIterator {
	return c.internalClient.ExportTensorboardTimeSeriesData(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *TensorboardClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *TensorboardClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *TensorboardClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *TensorboardClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *TensorboardClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *TensorboardClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *TensorboardClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *TensorboardClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *TensorboardClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// WaitOperation is a utility method from google.longrunning.Operations.
func (c *TensorboardClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.WaitOperation(ctx, req, opts...)
}

// tensorboardGRPCClient is a client for interacting with Vertex AI API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type tensorboardGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing TensorboardClient
	CallOptions **TensorboardCallOptions

	// The gRPC API client.
	tensorboardClient aiplatformpb.TensorboardServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewTensorboardClient creates a new tensorboard service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// TensorboardService
func NewTensorboardClient(ctx context.Context, opts ...option.ClientOption) (*TensorboardClient, error) {
	clientOpts := defaultTensorboardGRPCClientOptions()
	if newTensorboardClientHook != nil {
		hookOpts, err := newTensorboardClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := TensorboardClient{CallOptions: defaultTensorboardCallOptions()}

	c := &tensorboardGRPCClient{
		connPool:          connPool,
		disableDeadlines:  disableDeadlines,
		tensorboardClient: aiplatformpb.NewTensorboardServiceClient(connPool),
		CallOptions:       &client.CallOptions,
		operationsClient:  longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:   iampb.NewIAMPolicyClient(connPool),
		locationsClient:   locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *tensorboardGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *tensorboardGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *tensorboardGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *tensorboardGRPCClient) CreateTensorboard(ctx context.Context, req *aiplatformpb.CreateTensorboardRequest, opts ...gax.CallOption) (*CreateTensorboardOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateTensorboard[0:len((*c.CallOptions).CreateTensorboard):len((*c.CallOptions).CreateTensorboard)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.CreateTensorboard(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateTensorboardOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *tensorboardGRPCClient) GetTensorboard(ctx context.Context, req *aiplatformpb.GetTensorboardRequest, opts ...gax.CallOption) (*aiplatformpb.Tensorboard, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetTensorboard[0:len((*c.CallOptions).GetTensorboard):len((*c.CallOptions).GetTensorboard)], opts...)
	var resp *aiplatformpb.Tensorboard
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.GetTensorboard(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) UpdateTensorboard(ctx context.Context, req *aiplatformpb.UpdateTensorboardRequest, opts ...gax.CallOption) (*UpdateTensorboardOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard.name", url.QueryEscape(req.GetTensorboard().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateTensorboard[0:len((*c.CallOptions).UpdateTensorboard):len((*c.CallOptions).UpdateTensorboard)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.UpdateTensorboard(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateTensorboardOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *tensorboardGRPCClient) ListTensorboards(ctx context.Context, req *aiplatformpb.ListTensorboardsRequest, opts ...gax.CallOption) *TensorboardIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListTensorboards[0:len((*c.CallOptions).ListTensorboards):len((*c.CallOptions).ListTensorboards)], opts...)
	it := &TensorboardIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListTensorboardsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.Tensorboard, string, error) {
		resp := &aiplatformpb.ListTensorboardsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.tensorboardClient.ListTensorboards(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTensorboards(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) DeleteTensorboard(ctx context.Context, req *aiplatformpb.DeleteTensorboardRequest, opts ...gax.CallOption) (*DeleteTensorboardOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteTensorboard[0:len((*c.CallOptions).DeleteTensorboard):len((*c.CallOptions).DeleteTensorboard)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.DeleteTensorboard(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTensorboardOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *tensorboardGRPCClient) CreateTensorboardExperiment(ctx context.Context, req *aiplatformpb.CreateTensorboardExperimentRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateTensorboardExperiment[0:len((*c.CallOptions).CreateTensorboardExperiment):len((*c.CallOptions).CreateTensorboardExperiment)], opts...)
	var resp *aiplatformpb.TensorboardExperiment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.CreateTensorboardExperiment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) GetTensorboardExperiment(ctx context.Context, req *aiplatformpb.GetTensorboardExperimentRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetTensorboardExperiment[0:len((*c.CallOptions).GetTensorboardExperiment):len((*c.CallOptions).GetTensorboardExperiment)], opts...)
	var resp *aiplatformpb.TensorboardExperiment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.GetTensorboardExperiment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) UpdateTensorboardExperiment(ctx context.Context, req *aiplatformpb.UpdateTensorboardExperimentRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardExperiment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_experiment.name", url.QueryEscape(req.GetTensorboardExperiment().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateTensorboardExperiment[0:len((*c.CallOptions).UpdateTensorboardExperiment):len((*c.CallOptions).UpdateTensorboardExperiment)], opts...)
	var resp *aiplatformpb.TensorboardExperiment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.UpdateTensorboardExperiment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ListTensorboardExperiments(ctx context.Context, req *aiplatformpb.ListTensorboardExperimentsRequest, opts ...gax.CallOption) *TensorboardExperimentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListTensorboardExperiments[0:len((*c.CallOptions).ListTensorboardExperiments):len((*c.CallOptions).ListTensorboardExperiments)], opts...)
	it := &TensorboardExperimentIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListTensorboardExperimentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.TensorboardExperiment, string, error) {
		resp := &aiplatformpb.ListTensorboardExperimentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.tensorboardClient.ListTensorboardExperiments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTensorboardExperiments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) DeleteTensorboardExperiment(ctx context.Context, req *aiplatformpb.DeleteTensorboardExperimentRequest, opts ...gax.CallOption) (*DeleteTensorboardExperimentOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteTensorboardExperiment[0:len((*c.CallOptions).DeleteTensorboardExperiment):len((*c.CallOptions).DeleteTensorboardExperiment)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.DeleteTensorboardExperiment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTensorboardExperimentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *tensorboardGRPCClient) CreateTensorboardRun(ctx context.Context, req *aiplatformpb.CreateTensorboardRunRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardRun, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateTensorboardRun[0:len((*c.CallOptions).CreateTensorboardRun):len((*c.CallOptions).CreateTensorboardRun)], opts...)
	var resp *aiplatformpb.TensorboardRun
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.CreateTensorboardRun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) BatchCreateTensorboardRuns(ctx context.Context, req *aiplatformpb.BatchCreateTensorboardRunsRequest, opts ...gax.CallOption) (*aiplatformpb.BatchCreateTensorboardRunsResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).BatchCreateTensorboardRuns[0:len((*c.CallOptions).BatchCreateTensorboardRuns):len((*c.CallOptions).BatchCreateTensorboardRuns)], opts...)
	var resp *aiplatformpb.BatchCreateTensorboardRunsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.BatchCreateTensorboardRuns(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) GetTensorboardRun(ctx context.Context, req *aiplatformpb.GetTensorboardRunRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardRun, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetTensorboardRun[0:len((*c.CallOptions).GetTensorboardRun):len((*c.CallOptions).GetTensorboardRun)], opts...)
	var resp *aiplatformpb.TensorboardRun
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.GetTensorboardRun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) UpdateTensorboardRun(ctx context.Context, req *aiplatformpb.UpdateTensorboardRunRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardRun, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_run.name", url.QueryEscape(req.GetTensorboardRun().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateTensorboardRun[0:len((*c.CallOptions).UpdateTensorboardRun):len((*c.CallOptions).UpdateTensorboardRun)], opts...)
	var resp *aiplatformpb.TensorboardRun
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.UpdateTensorboardRun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ListTensorboardRuns(ctx context.Context, req *aiplatformpb.ListTensorboardRunsRequest, opts ...gax.CallOption) *TensorboardRunIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListTensorboardRuns[0:len((*c.CallOptions).ListTensorboardRuns):len((*c.CallOptions).ListTensorboardRuns)], opts...)
	it := &TensorboardRunIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListTensorboardRunsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.TensorboardRun, string, error) {
		resp := &aiplatformpb.ListTensorboardRunsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.tensorboardClient.ListTensorboardRuns(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTensorboardRuns(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) DeleteTensorboardRun(ctx context.Context, req *aiplatformpb.DeleteTensorboardRunRequest, opts ...gax.CallOption) (*DeleteTensorboardRunOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteTensorboardRun[0:len((*c.CallOptions).DeleteTensorboardRun):len((*c.CallOptions).DeleteTensorboardRun)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.DeleteTensorboardRun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTensorboardRunOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *tensorboardGRPCClient) BatchCreateTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.BatchCreateTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.BatchCreateTensorboardTimeSeriesResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).BatchCreateTensorboardTimeSeries[0:len((*c.CallOptions).BatchCreateTensorboardTimeSeries):len((*c.CallOptions).BatchCreateTensorboardTimeSeries)], opts...)
	var resp *aiplatformpb.BatchCreateTensorboardTimeSeriesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.BatchCreateTensorboardTimeSeries(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) CreateTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.CreateTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateTensorboardTimeSeries[0:len((*c.CallOptions).CreateTensorboardTimeSeries):len((*c.CallOptions).CreateTensorboardTimeSeries)], opts...)
	var resp *aiplatformpb.TensorboardTimeSeries
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.CreateTensorboardTimeSeries(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) GetTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.GetTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetTensorboardTimeSeries[0:len((*c.CallOptions).GetTensorboardTimeSeries):len((*c.CallOptions).GetTensorboardTimeSeries)], opts...)
	var resp *aiplatformpb.TensorboardTimeSeries
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.GetTensorboardTimeSeries(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) UpdateTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.UpdateTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*aiplatformpb.TensorboardTimeSeries, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_time_series.name", url.QueryEscape(req.GetTensorboardTimeSeries().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateTensorboardTimeSeries[0:len((*c.CallOptions).UpdateTensorboardTimeSeries):len((*c.CallOptions).UpdateTensorboardTimeSeries)], opts...)
	var resp *aiplatformpb.TensorboardTimeSeries
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.UpdateTensorboardTimeSeries(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ListTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.ListTensorboardTimeSeriesRequest, opts ...gax.CallOption) *TensorboardTimeSeriesIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListTensorboardTimeSeries[0:len((*c.CallOptions).ListTensorboardTimeSeries):len((*c.CallOptions).ListTensorboardTimeSeries)], opts...)
	it := &TensorboardTimeSeriesIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListTensorboardTimeSeriesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.TensorboardTimeSeries, string, error) {
		resp := &aiplatformpb.ListTensorboardTimeSeriesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.tensorboardClient.ListTensorboardTimeSeries(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTensorboardTimeSeries(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) DeleteTensorboardTimeSeries(ctx context.Context, req *aiplatformpb.DeleteTensorboardTimeSeriesRequest, opts ...gax.CallOption) (*DeleteTensorboardTimeSeriesOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteTensorboardTimeSeries[0:len((*c.CallOptions).DeleteTensorboardTimeSeries):len((*c.CallOptions).DeleteTensorboardTimeSeries)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.DeleteTensorboardTimeSeries(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTensorboardTimeSeriesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *tensorboardGRPCClient) BatchReadTensorboardTimeSeriesData(ctx context.Context, req *aiplatformpb.BatchReadTensorboardTimeSeriesDataRequest, opts ...gax.CallOption) (*aiplatformpb.BatchReadTensorboardTimeSeriesDataResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard", url.QueryEscape(req.GetTensorboard())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).BatchReadTensorboardTimeSeriesData[0:len((*c.CallOptions).BatchReadTensorboardTimeSeriesData):len((*c.CallOptions).BatchReadTensorboardTimeSeriesData)], opts...)
	var resp *aiplatformpb.BatchReadTensorboardTimeSeriesDataResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.BatchReadTensorboardTimeSeriesData(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ReadTensorboardTimeSeriesData(ctx context.Context, req *aiplatformpb.ReadTensorboardTimeSeriesDataRequest, opts ...gax.CallOption) (*aiplatformpb.ReadTensorboardTimeSeriesDataResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_time_series", url.QueryEscape(req.GetTensorboardTimeSeries())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ReadTensorboardTimeSeriesData[0:len((*c.CallOptions).ReadTensorboardTimeSeriesData):len((*c.CallOptions).ReadTensorboardTimeSeriesData)], opts...)
	var resp *aiplatformpb.ReadTensorboardTimeSeriesDataResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.ReadTensorboardTimeSeriesData(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ReadTensorboardBlobData(ctx context.Context, req *aiplatformpb.ReadTensorboardBlobDataRequest, opts ...gax.CallOption) (aiplatformpb.TensorboardService_ReadTensorboardBlobDataClient, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "time_series", url.QueryEscape(req.GetTimeSeries())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	var resp aiplatformpb.TensorboardService_ReadTensorboardBlobDataClient
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.ReadTensorboardBlobData(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) WriteTensorboardExperimentData(ctx context.Context, req *aiplatformpb.WriteTensorboardExperimentDataRequest, opts ...gax.CallOption) (*aiplatformpb.WriteTensorboardExperimentDataResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_experiment", url.QueryEscape(req.GetTensorboardExperiment())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).WriteTensorboardExperimentData[0:len((*c.CallOptions).WriteTensorboardExperimentData):len((*c.CallOptions).WriteTensorboardExperimentData)], opts...)
	var resp *aiplatformpb.WriteTensorboardExperimentDataResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.WriteTensorboardExperimentData(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) WriteTensorboardRunData(ctx context.Context, req *aiplatformpb.WriteTensorboardRunDataRequest, opts ...gax.CallOption) (*aiplatformpb.WriteTensorboardRunDataResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_run", url.QueryEscape(req.GetTensorboardRun())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).WriteTensorboardRunData[0:len((*c.CallOptions).WriteTensorboardRunData):len((*c.CallOptions).WriteTensorboardRunData)], opts...)
	var resp *aiplatformpb.WriteTensorboardRunDataResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tensorboardClient.WriteTensorboardRunData(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ExportTensorboardTimeSeriesData(ctx context.Context, req *aiplatformpb.ExportTensorboardTimeSeriesDataRequest, opts ...gax.CallOption) *TimeSeriesDataPointIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "tensorboard_time_series", url.QueryEscape(req.GetTensorboardTimeSeries())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ExportTensorboardTimeSeriesData[0:len((*c.CallOptions).ExportTensorboardTimeSeriesData):len((*c.CallOptions).ExportTensorboardTimeSeriesData)], opts...)
	it := &TimeSeriesDataPointIterator{}
	req = proto.Clone(req).(*aiplatformpb.ExportTensorboardTimeSeriesDataRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.TimeSeriesDataPoint, string, error) {
		resp := &aiplatformpb.ExportTensorboardTimeSeriesDataResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.tensorboardClient.ExportTensorboardTimeSeriesData(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTimeSeriesDataPoints(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.locationsClient.GetLocation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.locationsClient.ListLocations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.GetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.SetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.TestIamPermissions(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *tensorboardGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *tensorboardGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tensorboardGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tensorboardGRPCClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).WaitOperation[0:len((*c.CallOptions).WaitOperation):len((*c.CallOptions).WaitOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.WaitOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateTensorboardOperation manages a long-running operation from CreateTensorboard.
type CreateTensorboardOperation struct {
	lro *longrunning.Operation
}

// CreateTensorboardOperation returns a new CreateTensorboardOperation from a given name.
// The name must be that of a previously created CreateTensorboardOperation, possibly from a different process.
func (c *tensorboardGRPCClient) CreateTensorboardOperation(name string) *CreateTensorboardOperation {
	return &CreateTensorboardOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateTensorboardOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*aiplatformpb.Tensorboard, error) {
	var resp aiplatformpb.Tensorboard
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateTensorboardOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*aiplatformpb.Tensorboard, error) {
	var resp aiplatformpb.Tensorboard
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateTensorboardOperation) Metadata() (*aiplatformpb.CreateTensorboardOperationMetadata, error) {
	var meta aiplatformpb.CreateTensorboardOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateTensorboardOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateTensorboardOperation) Name() string {
	return op.lro.Name()
}

// DeleteTensorboardOperation manages a long-running operation from DeleteTensorboard.
type DeleteTensorboardOperation struct {
	lro *longrunning.Operation
}

// DeleteTensorboardOperation returns a new DeleteTensorboardOperation from a given name.
// The name must be that of a previously created DeleteTensorboardOperation, possibly from a different process.
func (c *tensorboardGRPCClient) DeleteTensorboardOperation(name string) *DeleteTensorboardOperation {
	return &DeleteTensorboardOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteTensorboardOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteTensorboardOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteTensorboardOperation) Metadata() (*aiplatformpb.DeleteOperationMetadata, error) {
	var meta aiplatformpb.DeleteOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteTensorboardOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteTensorboardOperation) Name() string {
	return op.lro.Name()
}

// DeleteTensorboardExperimentOperation manages a long-running operation from DeleteTensorboardExperiment.
type DeleteTensorboardExperimentOperation struct {
	lro *longrunning.Operation
}

// DeleteTensorboardExperimentOperation returns a new DeleteTensorboardExperimentOperation from a given name.
// The name must be that of a previously created DeleteTensorboardExperimentOperation, possibly from a different process.
func (c *tensorboardGRPCClient) DeleteTensorboardExperimentOperation(name string) *DeleteTensorboardExperimentOperation {
	return &DeleteTensorboardExperimentOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteTensorboardExperimentOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteTensorboardExperimentOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteTensorboardExperimentOperation) Metadata() (*aiplatformpb.DeleteOperationMetadata, error) {
	var meta aiplatformpb.DeleteOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteTensorboardExperimentOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteTensorboardExperimentOperation) Name() string {
	return op.lro.Name()
}

// DeleteTensorboardRunOperation manages a long-running operation from DeleteTensorboardRun.
type DeleteTensorboardRunOperation struct {
	lro *longrunning.Operation
}

// DeleteTensorboardRunOperation returns a new DeleteTensorboardRunOperation from a given name.
// The name must be that of a previously created DeleteTensorboardRunOperation, possibly from a different process.
func (c *tensorboardGRPCClient) DeleteTensorboardRunOperation(name string) *DeleteTensorboardRunOperation {
	return &DeleteTensorboardRunOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteTensorboardRunOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteTensorboardRunOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteTensorboardRunOperation) Metadata() (*aiplatformpb.DeleteOperationMetadata, error) {
	var meta aiplatformpb.DeleteOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteTensorboardRunOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteTensorboardRunOperation) Name() string {
	return op.lro.Name()
}

// DeleteTensorboardTimeSeriesOperation manages a long-running operation from DeleteTensorboardTimeSeries.
type DeleteTensorboardTimeSeriesOperation struct {
	lro *longrunning.Operation
}

// DeleteTensorboardTimeSeriesOperation returns a new DeleteTensorboardTimeSeriesOperation from a given name.
// The name must be that of a previously created DeleteTensorboardTimeSeriesOperation, possibly from a different process.
func (c *tensorboardGRPCClient) DeleteTensorboardTimeSeriesOperation(name string) *DeleteTensorboardTimeSeriesOperation {
	return &DeleteTensorboardTimeSeriesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteTensorboardTimeSeriesOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteTensorboardTimeSeriesOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteTensorboardTimeSeriesOperation) Metadata() (*aiplatformpb.DeleteOperationMetadata, error) {
	var meta aiplatformpb.DeleteOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteTensorboardTimeSeriesOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteTensorboardTimeSeriesOperation) Name() string {
	return op.lro.Name()
}

// UpdateTensorboardOperation manages a long-running operation from UpdateTensorboard.
type UpdateTensorboardOperation struct {
	lro *longrunning.Operation
}

// UpdateTensorboardOperation returns a new UpdateTensorboardOperation from a given name.
// The name must be that of a previously created UpdateTensorboardOperation, possibly from a different process.
func (c *tensorboardGRPCClient) UpdateTensorboardOperation(name string) *UpdateTensorboardOperation {
	return &UpdateTensorboardOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateTensorboardOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*aiplatformpb.Tensorboard, error) {
	var resp aiplatformpb.Tensorboard
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateTensorboardOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*aiplatformpb.Tensorboard, error) {
	var resp aiplatformpb.Tensorboard
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateTensorboardOperation) Metadata() (*aiplatformpb.UpdateTensorboardOperationMetadata, error) {
	var meta aiplatformpb.UpdateTensorboardOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateTensorboardOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateTensorboardOperation) Name() string {
	return op.lro.Name()
}

// TensorboardExperimentIterator manages a stream of *aiplatformpb.TensorboardExperiment.
type TensorboardExperimentIterator struct {
	items    []*aiplatformpb.TensorboardExperiment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*aiplatformpb.TensorboardExperiment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TensorboardExperimentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TensorboardExperimentIterator) Next() (*aiplatformpb.TensorboardExperiment, error) {
	var item *aiplatformpb.TensorboardExperiment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TensorboardExperimentIterator) bufLen() int {
	return len(it.items)
}

func (it *TensorboardExperimentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TensorboardIterator manages a stream of *aiplatformpb.Tensorboard.
type TensorboardIterator struct {
	items    []*aiplatformpb.Tensorboard
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*aiplatformpb.Tensorboard, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TensorboardIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TensorboardIterator) Next() (*aiplatformpb.Tensorboard, error) {
	var item *aiplatformpb.Tensorboard
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TensorboardIterator) bufLen() int {
	return len(it.items)
}

func (it *TensorboardIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TensorboardRunIterator manages a stream of *aiplatformpb.TensorboardRun.
type TensorboardRunIterator struct {
	items    []*aiplatformpb.TensorboardRun
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*aiplatformpb.TensorboardRun, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TensorboardRunIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TensorboardRunIterator) Next() (*aiplatformpb.TensorboardRun, error) {
	var item *aiplatformpb.TensorboardRun
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TensorboardRunIterator) bufLen() int {
	return len(it.items)
}

func (it *TensorboardRunIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TensorboardTimeSeriesIterator manages a stream of *aiplatformpb.TensorboardTimeSeries.
type TensorboardTimeSeriesIterator struct {
	items    []*aiplatformpb.TensorboardTimeSeries
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*aiplatformpb.TensorboardTimeSeries, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TensorboardTimeSeriesIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TensorboardTimeSeriesIterator) Next() (*aiplatformpb.TensorboardTimeSeries, error) {
	var item *aiplatformpb.TensorboardTimeSeries
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TensorboardTimeSeriesIterator) bufLen() int {
	return len(it.items)
}

func (it *TensorboardTimeSeriesIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TimeSeriesDataPointIterator manages a stream of *aiplatformpb.TimeSeriesDataPoint.
type TimeSeriesDataPointIterator struct {
	items    []*aiplatformpb.TimeSeriesDataPoint
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*aiplatformpb.TimeSeriesDataPoint, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TimeSeriesDataPointIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TimeSeriesDataPointIterator) Next() (*aiplatformpb.TimeSeriesDataPoint, error) {
	var item *aiplatformpb.TimeSeriesDataPoint
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TimeSeriesDataPointIterator) bufLen() int {
	return len(it.items)
}

func (it *TimeSeriesDataPointIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
